/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform.android;

import android.net.http.X509TrustManagerExtensions;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.tls.CertificateChainCleaner;

public final class AndroidCertificateChainCleaner
extends CertificateChainCleaner {
    public static final Companion Companion = new Companion(null);
    private final X509TrustManager trustManager;
    private final X509TrustManagerExtensions x509TrustManagerExtensions;

    public AndroidCertificateChainCleaner(X509TrustManager trustManager, X509TrustManagerExtensions x509TrustManagerExtensions) {
        Intrinsics.checkNotNullParameter(trustManager, "trustManager");
        Intrinsics.checkNotNullParameter(x509TrustManagerExtensions, "x509TrustManagerExtensions");
        this.trustManager = trustManager;
        this.x509TrustManagerExtensions = x509TrustManagerExtensions;
    }

    @Override
    public List<Certificate> clean(List<? extends Certificate> chain, String hostname) throws SSLPeerUnverifiedException {
        Intrinsics.checkNotNullParameter(chain, "chain");
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        Collection $this$toTypedArray$iv = chain;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        X509Certificate[] x509CertificateArray = thisCollection$iv.toArray(new X509Certificate[0]);
        if (x509CertificateArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        X509Certificate[] certificates = x509CertificateArray;
        try {
            $this$toTypedArray$iv = this.x509TrustManagerExtensions.checkServerTrusted(certificates, "RSA", hostname);
            Intrinsics.checkNotNullExpressionValue($this$toTypedArray$iv, "x509TrustManagerExtensio\u2026ficates, \"RSA\", hostname)");
            return $this$toTypedArray$iv;
        }
        catch (CertificateException ce) {
            SSLPeerUnverifiedException sSLPeerUnverifiedException;
            SSLPeerUnverifiedException $this$clean_u24lambda_u2d0 = sSLPeerUnverifiedException = new SSLPeerUnverifiedException(ce.getMessage());
            boolean bl = false;
            $this$clean_u24lambda_u2d0.initCause(ce);
            throw (Throwable)sSLPeerUnverifiedException;
        }
    }

    public boolean equals(Object other) {
        return other instanceof AndroidCertificateChainCleaner && ((AndroidCertificateChainCleaner)other).trustManager == this.trustManager;
    }

    public int hashCode() {
        return System.identityHashCode(this.trustManager);
    }

    public static final class Companion {
        private Companion() {
        }

        public final AndroidCertificateChainCleaner buildIfSupported(X509TrustManager trustManager) {
            X509TrustManagerExtensions x509TrustManagerExtensions;
            Intrinsics.checkNotNullParameter(trustManager, "trustManager");
            try {
                x509TrustManagerExtensions = new X509TrustManagerExtensions(trustManager);
            }
            catch (IllegalArgumentException iae) {
                x509TrustManagerExtensions = null;
            }
            X509TrustManagerExtensions extensions = x509TrustManagerExtensions;
            return extensions != null ? new AndroidCertificateChainCleaner(trustManager, extensions) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

