/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal.Util;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader;
import okhttp3.internal.ws.WebSocketWriter;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    public static final Companion Companion = new Companion(null);
    private final Request originalRequest;
    private final WebSocketListener listener;
    private final Random random;
    private final long pingIntervalMillis;
    private WebSocketExtensions extensions;
    private long minimumDeflateSize;
    private final String key;
    private Call call;
    private Task writerTask;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private TaskQueue taskQueue;
    private String name;
    private Streams streams;
    private final ArrayDeque<ByteString> pongQueue;
    private final ArrayDeque<Object> messageAndCloseQueue;
    private long queueSize;
    private boolean enqueuedClose;
    private int receivedCloseCode;
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;
    private static final List<Protocol> ONLY_HTTP1 = CollectionsKt.listOf(Protocol.HTTP_1_1);

    /*
     * WARNING - void declaration
     */
    public RealWebSocket(TaskRunner taskRunner, Request originalRequest, WebSocketListener listener2, Random random, long pingIntervalMillis, WebSocketExtensions extensions, long minimumDeflateSize) {
        void $this$_init__u24lambda_u2d1;
        byte[] byArray;
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(originalRequest, "originalRequest");
        Intrinsics.checkNotNullParameter(listener2, "listener");
        Intrinsics.checkNotNullParameter(random, "random");
        this.originalRequest = originalRequest;
        this.listener = listener2;
        this.random = random;
        this.pingIntervalMillis = pingIntervalMillis;
        this.extensions = extensions;
        this.minimumDeflateSize = minimumDeflateSize;
        this.taskQueue = taskRunner.newQueue();
        this.pongQueue = new ArrayDeque();
        this.messageAndCloseQueue = new ArrayDeque();
        this.receivedCloseCode = -1;
        if (!Intrinsics.areEqual("GET", this.originalRequest.method())) {
            boolean $i$a$-require-RealWebSocket$22 = false;
            String $i$a$-require-RealWebSocket$22 = Intrinsics.stringPlus("Request must be GET: ", this.originalRequest.method());
            throw new IllegalArgumentException($i$a$-require-RealWebSocket$22.toString());
        }
        byte[] $i$a$-require-RealWebSocket$22 = byArray = new byte[16];
        ByteString.Companion companion = ByteString.Companion;
        RealWebSocket realWebSocket = this;
        boolean bl = false;
        this.random.nextBytes((byte[])$this$_init__u24lambda_u2d1);
        Unit unit = Unit.INSTANCE;
        realWebSocket.key = ByteString.Companion.of$default(companion, byArray, 0, 0, 3, null).base64();
    }

    public final WebSocketListener getListener$okhttp() {
        return this.listener;
    }

    public void cancel() {
        Call call = this.call;
        Intrinsics.checkNotNull(call);
        call.cancel();
    }

    public final void connect(OkHttpClient client) {
        Intrinsics.checkNotNullParameter(client, "client");
        if (this.originalRequest.header("Sec-WebSocket-Extensions") != null) {
            this.failWebSocket(new ProtocolException("Request header not permitted: 'Sec-WebSocket-Extensions'"), null);
            return;
        }
        OkHttpClient webSocketClient = client.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").header("Sec-WebSocket-Extensions", "permessage-deflate").build();
        Call call = this.call = (Call)new RealCall(webSocketClient, request, true);
        Intrinsics.checkNotNull(call);
        call.enqueue(new Callback(this, request){
            final /* synthetic */ RealWebSocket this$0;
            final /* synthetic */ Request $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(response, "response");
                Exchange exchange = response.exchange();
                Streams streams = null;
                try {
                    this.this$0.checkUpgradeSuccess$okhttp(response, exchange);
                    Exchange exchange2 = exchange;
                    Intrinsics.checkNotNull(exchange2);
                    streams = exchange2.newWebSocketStreams();
                }
                catch (IOException e) {
                    Exchange exchange3 = exchange;
                    if (exchange3 != null) {
                        exchange3.webSocketUpgradeFailed();
                    }
                    this.this$0.failWebSocket(e, response);
                    Util.closeQuietly(response);
                    return;
                }
                WebSocketExtensions extensions = WebSocketExtensions.Companion.parse(response.headers());
                RealWebSocket.access$setExtensions$p(this.this$0, extensions);
                if (!RealWebSocket.access$isValid(this.this$0, extensions)) {
                    RealWebSocket realWebSocket = this.this$0;
                    RealWebSocket realWebSocket2 = this.this$0;
                    RealWebSocket realWebSocket3 = realWebSocket;
                    synchronized (realWebSocket3) {
                        boolean bl = false;
                        RealWebSocket.access$getMessageAndCloseQueue$p(realWebSocket2).clear();
                        boolean bl2 = realWebSocket2.close(1010, "unexpected Sec-WebSocket-Extensions in response header");
                    }
                }
                try {
                    String name = Util.okHttpName + " WebSocket " + this.$request.url().redact();
                    this.this$0.initReaderAndWriter(name, streams);
                    this.this$0.getListener$okhttp().onOpen(this.this$0, response);
                    this.this$0.loopReader();
                }
                catch (Exception e) {
                    this.this$0.failWebSocket(e, null);
                }
            }

            public void onFailure(Call call, IOException e) {
                Intrinsics.checkNotNullParameter(call, "call");
                Intrinsics.checkNotNullParameter(e, "e");
                this.this$0.failWebSocket(e, null);
            }
        });
    }

    private final boolean isValid(WebSocketExtensions $this$isValid) {
        if ($this$isValid.unknownValues) {
            return false;
        }
        if ($this$isValid.clientMaxWindowBits != null) {
            return false;
        }
        return $this$isValid.serverMaxWindowBits == null || new IntRange(8, 15).contains($this$isValid.serverMaxWindowBits);
    }

    public final void checkUpgradeSuccess$okhttp(Response response, Exchange exchange) throws IOException {
        Intrinsics.checkNotNullParameter(response, "response");
        if (response.code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + response.code() + ' ' + response.message() + '\'');
        }
        String headerConnection = Response.header$default(response, "Connection", null, 2, null);
        if (!StringsKt.equals("Upgrade", headerConnection, true)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + headerConnection + '\'');
        }
        String headerUpgrade = Response.header$default(response, "Upgrade", null, 2, null);
        if (!StringsKt.equals("websocket", headerUpgrade, true)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + headerUpgrade + '\'');
        }
        String headerAccept = Response.header$default(response, "Sec-WebSocket-Accept", null, 2, null);
        String acceptExpected = ByteString.Companion.encodeUtf8(Intrinsics.stringPlus(this.key, "258EAFA5-E914-47DA-95CA-C5AB0DC85B11")).sha1().base64();
        if (!Intrinsics.areEqual(acceptExpected, headerAccept)) {
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + acceptExpected + "' but was '" + headerAccept + '\'');
        }
        if (exchange == null) {
            throw new ProtocolException("Web Socket exchange missing: bad interceptor?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void initReaderAndWriter(String name, Streams streams) throws IOException {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(streams, "streams");
        WebSocketExtensions webSocketExtensions = this.extensions;
        Intrinsics.checkNotNull(webSocketExtensions);
        WebSocketExtensions extensions = webSocketExtensions;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean bl = false;
            this.name = name;
            this.streams = streams;
            this.writer = new WebSocketWriter(streams.getClient(), streams.getSink(), this.random, extensions.perMessageDeflate, extensions.noContextTakeover(streams.getClient()), this.minimumDeflateSize);
            this.writerTask = new WriterTask();
            if (this.pingIntervalMillis != 0L) {
                void this_$iv;
                long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pingIntervalMillis);
                TaskQueue taskQueue = this.taskQueue;
                String name$iv = Intrinsics.stringPlus(name, " ping");
                boolean $i$f$schedule = false;
                this_$iv.schedule(new Task(name$iv, this, pingIntervalNanos){
                    final /* synthetic */ String $name;
                    final /* synthetic */ RealWebSocket this$0;
                    final /* synthetic */ long $pingIntervalNanos$inlined;
                    {
                        this.$name = $name;
                        this.this$0 = realWebSocket;
                        this.$pingIntervalNanos$inlined = l;
                        super($name, false, 2, null);
                    }

                    public long runOnce() {
                        boolean bl = false;
                        this.this$0.writePingFrame$okhttp();
                        return this.$pingIntervalNanos$inlined;
                    }
                }, pingIntervalNanos);
            }
            if (!((Collection)this.messageAndCloseQueue).isEmpty()) {
                this.runWriter();
            }
            Unit unit = Unit.INSTANCE;
        }
        this.reader = new WebSocketReader(streams.getClient(), streams.getSource(), this, extensions.perMessageDeflate, extensions.noContextTakeover(!streams.getClient()));
    }

    public final void loopReader() throws IOException {
        while (this.receivedCloseCode == -1) {
            WebSocketReader webSocketReader = this.reader;
            Intrinsics.checkNotNull(webSocketReader);
            webSocketReader.processNextFrame();
        }
    }

    @Override
    public void onReadMessage(String text) throws IOException {
        Intrinsics.checkNotNullParameter(text, "text");
        this.listener.onMessage((WebSocket)this, text);
    }

    @Override
    public void onReadMessage(ByteString bytes) throws IOException {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        this.listener.onMessage((WebSocket)this, bytes);
    }

    @Override
    public synchronized void onReadPing(ByteString payload) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add(payload);
        this.runWriter();
        int n = this.receivedPingCount;
        this.receivedPingCount = n + 1;
    }

    @Override
    public synchronized void onReadPong(ByteString payload) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        int n = this.receivedPongCount;
        this.receivedPongCount = n + 1;
        this.awaitingPong = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onReadClose(int code, String reason) {
        Intrinsics.checkNotNullParameter(reason, "reason");
        if (!(code != -1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Streams toClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean bl = false;
            if (!(this.receivedCloseCode == -1)) {
                boolean bl2 = false;
                String string = "already closed";
                throw new IllegalStateException(string.toString());
            }
            this.receivedCloseCode = code;
            this.receivedCloseReason = reason;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                toClose = this.streams;
                this.streams = null;
                readerToClose = this.reader;
                this.reader = null;
                writerToClose = this.writer;
                this.writer = null;
                this.taskQueue.shutdown();
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            this.listener.onClosing(this, code, reason);
            if (toClose != null) {
                this.listener.onClosed(this, code, reason);
            }
        }
        finally {
            Streams streams = toClose;
            if (streams != null) {
                Util.closeQuietly(streams);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
        }
    }

    @Override
    public boolean send(String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        return this.send(ByteString.Companion.encodeUtf8(text), 1);
    }

    @Override
    public boolean send(ByteString bytes) {
        Intrinsics.checkNotNullParameter(bytes, "bytes");
        return this.send(bytes, 2);
    }

    private final synchronized boolean send(ByteString data, int formatOpcode) {
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)data.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)data.size();
        this.messageAndCloseQueue.add(new Message(formatOpcode, data));
        this.runWriter();
        return true;
    }

    @Override
    public boolean close(int code, String reason) {
        return this.close(code, reason, 60000L);
    }

    public final synchronized boolean close(int code, String reason, long cancelAfterCloseMillis) {
        WebSocketProtocol.INSTANCE.validateCloseCode(code);
        ByteString reasonBytes = null;
        if (reason != null && !((long)(reasonBytes = ByteString.Companion.encodeUtf8(reason)).size() <= 123L)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus("reason.size() > 123: ", reason);
            throw new IllegalArgumentException(string.toString());
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new Close(code, reasonBytes, cancelAfterCloseMillis));
        this.runWriter();
        return true;
    }

    private final void runWriter() {
        RealWebSocket $this$assertThreadHoldsLock$iv = this;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        Task writerTask = this.writerTask;
        if (writerTask != null) {
            TaskQueue.schedule$default(this.taskQueue, writerTask, 0L, 2, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean writeOneFrame$okhttp() throws IOException {
        Object object;
        WebSocketWriter writer = null;
        ByteString pong = null;
        Object messageOrClose = null;
        int receivedCloseCode = 0;
        receivedCloseCode = -1;
        String receivedCloseReason = null;
        Streams streamsToClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            block25: {
                block24: {
                    boolean bl = false;
                    if (!this.failed) break block24;
                    boolean bl2 = false;
                    return bl2;
                }
                writer = this.writer;
                pong = this.pongQueue.poll();
                if (pong != null) break block25;
                messageOrClose = this.messageAndCloseQueue.poll();
                if (messageOrClose instanceof Close) {
                    receivedCloseCode = this.receivedCloseCode;
                    receivedCloseReason = this.receivedCloseReason;
                    if (receivedCloseCode != -1) {
                        streamsToClose = this.streams;
                        this.streams = null;
                        readerToClose = this.reader;
                        this.reader = null;
                        writerToClose = this.writer;
                        this.writer = null;
                        this.taskQueue.shutdown();
                    } else {
                        void name$iv;
                        void this_$iv;
                        Object object2 = messageOrClose;
                        long cancelAfterCloseMillis = ((Close)object2).getCancelAfterCloseMillis();
                        object2 = this.taskQueue;
                        String string = Intrinsics.stringPlus(this.name, " cancel");
                        long delayNanos$iv = TimeUnit.MILLISECONDS.toNanos(cancelAfterCloseMillis);
                        boolean cancelable$iv = true;
                        boolean $i$f$execute = false;
                        this_$iv.schedule(new Task((String)name$iv, cancelable$iv, this){
                            final /* synthetic */ String $name;
                            final /* synthetic */ boolean $cancelable;
                            final /* synthetic */ RealWebSocket this$0;
                            {
                                this.$name = $name;
                                this.$cancelable = $cancelable;
                                this.this$0 = realWebSocket;
                                super($name, $cancelable);
                            }

                            public long runOnce() {
                                boolean bl = false;
                                this.this$0.cancel();
                                return -1L;
                            }
                        }, delayNanos$iv);
                    }
                    break block25;
                }
                if (messageOrClose != null) break block25;
                boolean bl = false;
                return bl;
            }
            object = Unit.INSTANCE;
        }
        try {
            if (pong != null) {
                WebSocketWriter webSocketWriter = writer;
                Intrinsics.checkNotNull(webSocketWriter);
                webSocketWriter.writePong(pong);
            } else if (messageOrClose instanceof Message) {
                object = messageOrClose;
                Message message = (Message)object;
                WebSocketWriter webSocketWriter = writer;
                Intrinsics.checkNotNull(webSocketWriter);
                webSocketWriter.writeMessageFrame(message.getFormatOpcode(), message.getData());
                object = this;
                synchronized (object) {
                    boolean bl = false;
                    this.queueSize -= (long)message.getData().size();
                    Unit unit = Unit.INSTANCE;
                }
            } else if (messageOrClose instanceof Close) {
                object = messageOrClose;
                Close close = (Close)object;
                WebSocketWriter webSocketWriter = writer;
                Intrinsics.checkNotNull(webSocketWriter);
                webSocketWriter.writeClose(close.getCode(), close.getReason());
                if (streamsToClose != null) {
                    WebSocket webSocket2 = this;
                    String string = receivedCloseReason;
                    Intrinsics.checkNotNull(string);
                    this.listener.onClosed(webSocket2, receivedCloseCode, string);
                }
            } else {
                throw new AssertionError();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Streams streams = streamsToClose;
            if (streams != null) {
                Util.closeQuietly(streams);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePingFrame$okhttp() {
        WebSocketWriter writer = null;
        int failedPing = 0;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean bl = false;
            if (this.failed) {
                return;
            }
            WebSocketWriter webSocketWriter = this.writer;
            if (webSocketWriter == null) {
                return;
            }
            writer = webSocketWriter;
            failedPing = this.awaitingPong ? this.sentPingCount : -1;
            int n = this.sentPingCount;
            this.sentPingCount = n + 1;
            this.awaitingPong = true;
            Unit unit = Unit.INSTANCE;
        }
        if (failedPing != -1) {
            this.failWebSocket(new SocketTimeoutException("sent ping but didn't receive pong within " + this.pingIntervalMillis + "ms (after " + (failedPing - 1) + " successful ping/pongs)"), null);
            return;
        }
        try {
            writer.writePing(ByteString.EMPTY);
        }
        catch (IOException e) {
            this.failWebSocket(e, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void failWebSocket(Exception e, Response response) {
        Intrinsics.checkNotNullParameter(e, "e");
        Streams streamsToClose = null;
        WebSocketReader readerToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean bl = false;
            if (this.failed) {
                return;
            }
            this.failed = true;
            streamsToClose = this.streams;
            this.streams = null;
            readerToClose = this.reader;
            this.reader = null;
            writerToClose = this.writer;
            this.writer = null;
            this.taskQueue.shutdown();
            Unit unit = Unit.INSTANCE;
        }
        try {
            this.listener.onFailure(this, e, response);
        }
        finally {
            Streams streams = streamsToClose;
            if (streams != null) {
                Util.closeQuietly(streams);
            }
            WebSocketReader webSocketReader = readerToClose;
            if (webSocketReader != null) {
                Util.closeQuietly(webSocketReader);
            }
            WebSocketWriter webSocketWriter = writerToClose;
            if (webSocketWriter != null) {
                Util.closeQuietly(webSocketWriter);
            }
        }
    }

    public static final /* synthetic */ void access$setExtensions$p(RealWebSocket $this, WebSocketExtensions webSocketExtensions) {
        $this.extensions = webSocketExtensions;
    }

    public static final /* synthetic */ boolean access$isValid(RealWebSocket $this, WebSocketExtensions $receiver) {
        return $this.isValid($receiver);
    }

    public static final /* synthetic */ ArrayDeque access$getMessageAndCloseQueue$p(RealWebSocket $this) {
        return $this.messageAndCloseQueue;
    }

    public static final class Message {
        private final int formatOpcode;
        private final ByteString data;

        public Message(int formatOpcode, ByteString data) {
            Intrinsics.checkNotNullParameter(data, "data");
            this.formatOpcode = formatOpcode;
            this.data = data;
        }

        public final int getFormatOpcode() {
            return this.formatOpcode;
        }

        public final ByteString getData() {
            return this.data;
        }
    }

    public static final class Close {
        private final int code;
        private final ByteString reason;
        private final long cancelAfterCloseMillis;

        public Close(int code, ByteString reason, long cancelAfterCloseMillis) {
            this.code = code;
            this.reason = reason;
            this.cancelAfterCloseMillis = cancelAfterCloseMillis;
        }

        public final int getCode() {
            return this.code;
        }

        public final ByteString getReason() {
            return this.reason;
        }

        public final long getCancelAfterCloseMillis() {
            return this.cancelAfterCloseMillis;
        }
    }

    public static abstract class Streams
    implements Closeable {
        private final boolean client;
        private final BufferedSource source;
        private final BufferedSink sink;

        public Streams(boolean client, BufferedSource source2, BufferedSink sink2) {
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(sink2, "sink");
            this.client = client;
            this.source = source2;
            this.sink = sink2;
        }

        public final boolean getClient() {
            return this.client;
        }

        public final BufferedSource getSource() {
            return this.source;
        }

        public final BufferedSink getSink() {
            return this.sink;
        }
    }

    private final class WriterTask
    extends Task {
        public WriterTask() {
            Intrinsics.checkNotNullParameter(RealWebSocket.this, "this$0");
            super(Intrinsics.stringPlus(RealWebSocket.this.name, " writer"), false, 2, null);
        }

        @Override
        public long runOnce() {
            try {
                if (RealWebSocket.this.writeOneFrame$okhttp()) {
                    return 0L;
                }
            }
            catch (IOException e) {
                RealWebSocket.this.failWebSocket(e, null);
            }
            return -1L;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

