/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.IOException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.internal.Util;

public final class WebSocketExtensions {
    public static final Companion Companion = new Companion(null);
    public final boolean perMessageDeflate;
    public final Integer clientMaxWindowBits;
    public final boolean clientNoContextTakeover;
    public final Integer serverMaxWindowBits;
    public final boolean serverNoContextTakeover;
    public final boolean unknownValues;

    public WebSocketExtensions(boolean perMessageDeflate, Integer clientMaxWindowBits, boolean clientNoContextTakeover, Integer serverMaxWindowBits, boolean serverNoContextTakeover, boolean unknownValues) {
        this.perMessageDeflate = perMessageDeflate;
        this.clientMaxWindowBits = clientMaxWindowBits;
        this.clientNoContextTakeover = clientNoContextTakeover;
        this.serverMaxWindowBits = serverMaxWindowBits;
        this.serverNoContextTakeover = serverNoContextTakeover;
        this.unknownValues = unknownValues;
    }

    public /* synthetic */ WebSocketExtensions(boolean bl, Integer n, boolean bl2, Integer n2, boolean bl3, boolean bl4, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            bl = false;
        }
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            bl2 = false;
        }
        if ((n3 & 8) != 0) {
            n2 = null;
        }
        if ((n3 & 0x10) != 0) {
            bl3 = false;
        }
        if ((n3 & 0x20) != 0) {
            bl4 = false;
        }
        this(bl, n, bl2, n2, bl3, bl4);
    }

    public final boolean noContextTakeover(boolean clientOriginated) {
        return clientOriginated ? this.clientNoContextTakeover : this.serverNoContextTakeover;
    }

    public String toString() {
        return "WebSocketExtensions(perMessageDeflate=" + this.perMessageDeflate + ", clientMaxWindowBits=" + this.clientMaxWindowBits + ", clientNoContextTakeover=" + this.clientNoContextTakeover + ", serverMaxWindowBits=" + this.serverMaxWindowBits + ", serverNoContextTakeover=" + this.serverNoContextTakeover + ", unknownValues=" + this.unknownValues + ')';
    }

    public int hashCode() {
        int n = this.perMessageDeflate ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int result2 = n;
        result2 = result2 * 31 + (this.clientMaxWindowBits == null ? 0 : ((Object)this.clientMaxWindowBits).hashCode());
        int n2 = this.clientNoContextTakeover ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        result2 = result2 * 31 + (this.serverMaxWindowBits == null ? 0 : ((Object)this.serverMaxWindowBits).hashCode());
        int n3 = this.serverNoContextTakeover ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result2 = result2 * 31 + n3;
        int n4 = this.unknownValues ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        result2 = result2 * 31 + n4;
        return result2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WebSocketExtensions)) {
            return false;
        }
        WebSocketExtensions webSocketExtensions = (WebSocketExtensions)other;
        if (this.perMessageDeflate != webSocketExtensions.perMessageDeflate) {
            return false;
        }
        if (!Intrinsics.areEqual(this.clientMaxWindowBits, webSocketExtensions.clientMaxWindowBits)) {
            return false;
        }
        if (this.clientNoContextTakeover != webSocketExtensions.clientNoContextTakeover) {
            return false;
        }
        if (!Intrinsics.areEqual(this.serverMaxWindowBits, webSocketExtensions.serverMaxWindowBits)) {
            return false;
        }
        if (this.serverNoContextTakeover != webSocketExtensions.serverNoContextTakeover) {
            return false;
        }
        return this.unknownValues == webSocketExtensions.unknownValues;
    }

    public WebSocketExtensions() {
        this(false, null, false, null, false, false, 63, null);
    }

    public static final class Companion {
        private Companion() {
        }

        public final WebSocketExtensions parse(Headers responseHeaders) throws IOException {
            Intrinsics.checkNotNullParameter(responseHeaders, "responseHeaders");
            boolean compressionEnabled = false;
            Integer clientMaxWindowBits = null;
            boolean clientNoContextTakeover = false;
            Integer serverMaxWindowBits = null;
            boolean serverNoContextTakeover = false;
            boolean unexpectedValues = false;
            int n = 0;
            int n2 = responseHeaders.size();
            while (n < n2) {
                int i;
                if (!StringsKt.equals(responseHeaders.name(i = n++), "Sec-WebSocket-Extensions", true)) continue;
                String header = responseHeaders.value(i);
                int pos = 0;
                while (pos < header.length()) {
                    int extensionEnd = Util.delimiterOffset$default(header, ',', pos, 0, 4, null);
                    int extensionTokenEnd = Util.delimiterOffset(header, ';', pos, extensionEnd);
                    String extensionToken = Util.trimSubstring(header, pos, extensionTokenEnd);
                    pos = extensionTokenEnd + 1;
                    if (StringsKt.equals(extensionToken, "permessage-deflate", true)) {
                        if (compressionEnabled) {
                            unexpectedValues = true;
                        }
                        compressionEnabled = true;
                        while (pos < extensionEnd) {
                            int parameterEnd = Util.delimiterOffset(header, ';', pos, extensionEnd);
                            int equals = Util.delimiterOffset(header, '=', pos, parameterEnd);
                            String name = Util.trimSubstring(header, pos, equals);
                            String value = equals < parameterEnd ? StringsKt.removeSurrounding(Util.trimSubstring(header, equals + 1, parameterEnd), "\"") : (String)null;
                            pos = parameterEnd + 1;
                            if (StringsKt.equals(name, "client_max_window_bits", true)) {
                                if (clientMaxWindowBits != null) {
                                    unexpectedValues = true;
                                }
                                String string = value;
                                clientMaxWindowBits = string == null ? null : StringsKt.toIntOrNull(string);
                                if (clientMaxWindowBits != null) continue;
                                unexpectedValues = true;
                                continue;
                            }
                            if (StringsKt.equals(name, "client_no_context_takeover", true)) {
                                if (clientNoContextTakeover) {
                                    unexpectedValues = true;
                                }
                                if (value != null) {
                                    unexpectedValues = true;
                                }
                                clientNoContextTakeover = true;
                                continue;
                            }
                            if (StringsKt.equals(name, "server_max_window_bits", true)) {
                                if (serverMaxWindowBits != null) {
                                    unexpectedValues = true;
                                }
                                String string = value;
                                serverMaxWindowBits = string == null ? null : StringsKt.toIntOrNull(string);
                                if (serverMaxWindowBits != null) continue;
                                unexpectedValues = true;
                                continue;
                            }
                            if (StringsKt.equals(name, "server_no_context_takeover", true)) {
                                if (serverNoContextTakeover) {
                                    unexpectedValues = true;
                                }
                                if (value != null) {
                                    unexpectedValues = true;
                                }
                                serverNoContextTakeover = true;
                                continue;
                            }
                            unexpectedValues = true;
                        }
                        continue;
                    }
                    unexpectedValues = true;
                }
            }
            return new WebSocketExtensions(compressionEnabled, clientMaxWindowBits, clientNoContextTakeover, serverMaxWindowBits, serverNoContextTakeover, unexpectedValues);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

