/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;

public final class WebSocketProtocol {
    public static final WebSocketProtocol INSTANCE = new WebSocketProtocol();

    private WebSocketProtocol() {
    }

    public final void toggleMask(Buffer.UnsafeCursor cursor, byte[] key) {
        Intrinsics.checkNotNullParameter(cursor, "cursor");
        Intrinsics.checkNotNullParameter(key, "key");
        int keyIndex = 0;
        int keyLength = key.length;
        do {
            byte[] buffer = cursor.data;
            int i = cursor.start;
            int end = cursor.end;
            if (buffer == null) continue;
            while (i < end) {
                byte bufferInt = buffer[i];
                byte keyInt = key[keyIndex %= keyLength];
                buffer[i] = (byte)(bufferInt ^ keyInt);
                int n = i;
                i = n + 1;
                n = keyIndex;
                keyIndex = n + 1;
            }
        } while (cursor.next() != -1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final String closeCodeExceptionMessage(int code) {
        String string;
        if (code < 1000 || code >= 5000) {
            string = Intrinsics.stringPlus("Code must be in range [1000,5000): ", code);
            return string;
        }
        if (!(1004 <= code ? code < 1007 : false)) {
            if (!(1015 <= code ? code < 3000 : false)) {
                string = null;
                return string;
            }
        }
        string = "Code " + code + " is reserved and may not be used.";
        return string;
    }

    public final void validateCloseCode(int code) {
        String message = this.closeCodeExceptionMessage(code);
        if (!(message == null)) {
            boolean bl = false;
            String string = message;
            Intrinsics.checkNotNull(string);
            String string2 = string;
            throw new IllegalArgumentException(string2.toString());
        }
    }
}

