/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class InvalidCharset
extends Charset {
    public static final InvalidCharset INSTANCE = new InvalidCharset();

    private InvalidCharset() {
        super("Invalid", new String[0]);
    }

    @Override
    public boolean contains(Charset cs) {
        return false;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoder(this, 1.0f, 1.0f){

            @Override
            protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                if (in.remaining() > 0) {
                    return CoderResult.unmappableForLength(1);
                }
                return CoderResult.UNDERFLOW;
            }
        };
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new CharsetEncoder(this, 4.0f, 4.0f){

            @Override
            protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
                if (in.remaining() > 0) {
                    return CoderResult.unmappableForLength(1);
                }
                return CoderResult.UNDERFLOW;
            }
        };
    }
}

