/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.Graphene;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk3.GTK3;
import org.eclipse.swt.internal.gtk4.GTK4;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class Tree
extends Composite {
    long modelHandle;
    long checkRenderer;
    int columnCount;
    int sortDirection;
    int selectionCountOnPress;
    int selectionCountOnRelease;
    long ignoreCell;
    TreeItem[] items;
    int nextId;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    TreeItem currentItem;
    ImageList imageList;
    ImageList headerImageList;
    boolean firstCustomDraw;
    boolean firstCompute = true;
    boolean modelChanged;
    boolean expandAll;
    int drawState;
    int drawFlags;
    GdkRGBA background;
    GdkRGBA foreground;
    GdkRGBA drawForegroundRGBA;
    boolean isOwnerDrawn;
    boolean ignoreSize;
    boolean pixbufSizeSet;
    boolean hasChildren;
    int pixbufHeight;
    int pixbufWidth;
    int headerHeight;
    boolean headerVisible;
    TreeItem topItem;
    double cachedAdjustment;
    double currentAdjustment;
    Color headerBackground;
    Color headerForeground;
    boolean boundsChangedSinceLastDraw;
    boolean wasScrolled;
    boolean rowActivated;
    private long headerCSSProvider;
    static final int ID_COLUMN = 0;
    static final int CHECKED_COLUMN = 1;
    static final int GRAYED_COLUMN = 2;
    static final int FOREGROUND_COLUMN = 3;
    static final int BACKGROUND_COLUMN = 4;
    static final int FONT_COLUMN = 5;
    static final int FIRST_COLUMN = 6;
    static final int CELL_PIXBUF = 0;
    static final int CELL_TEXT = 1;
    static final int CELL_FOREGROUND = 2;
    static final int CELL_BACKGROUND = 3;
    static final int CELL_FONT = 4;
    static final int CELL_SURFACE = 5;
    static final int CELL_TYPES = 6;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    @Override
    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        if (!this.isOwnerDrawn) {
            switch (eventType) {
                case 40: 
                case 41: 
                case 42: {
                    this.isOwnerDrawn = true;
                    this.recreateRenderers();
                }
            }
        }
    }

    TreeItem _getItem(long iter) {
        int id = this.getId(iter, true);
        if (this.items[id] != null) {
            return this.items[id];
        }
        long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        int depth = GTK.gtk_tree_path_get_depth(path);
        int[] indices = new int[depth];
        C.memmove(indices, GTK.gtk_tree_path_get_indices(path), (long)(4 * depth));
        long parentIter = 0L;
        if (depth > 1) {
            GTK.gtk_tree_path_up(path);
            parentIter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_get_iter(this.modelHandle, parentIter, path);
        }
        this.items[id] = new TreeItem(this, parentIter, 0, indices[indices.length - 1], iter);
        GTK.gtk_tree_path_free(path);
        if (parentIter != 0L) {
            OS.g_free(parentIter);
        }
        return this.items[id];
    }

    TreeItem _getItem(long parentIter, long iter, int index) {
        int id = this.getId(iter, true);
        if (this.items[id] != null) {
            return this.items[id];
        }
        this.items[id] = new TreeItem(this, parentIter, 0, index, iter);
        return this.items[id];
    }

    void reallocateIds(int newSize) {
        TreeItem[] newItems = new TreeItem[newSize];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        this.items = newItems;
    }

    int findAvailableId() {
        int id;
        if (this.nextId >= this.items.length) {
            this.nextId = 0;
        }
        for (id = this.nextId; id < this.items.length; ++id) {
            if (this.items[id] != null) continue;
            return id;
        }
        for (id = 0; id < this.nextId; ++id) {
            if (this.items[id] != null) continue;
            return id;
        }
        int newId = this.items.length;
        if (this.drawCount <= 0) {
            this.reallocateIds(this.items.length + 4);
        } else {
            this.reallocateIds((this.items.length + 1) * 3 / 2);
        }
        return newId;
    }

    int getId(long iter, boolean queryModel) {
        if (queryModel) {
            int[] value = new int[1];
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
            if (value[0] != -1) {
                return value[0];
            }
        }
        int id = this.findAvailableId();
        this.nextId = id + 1;
        GTK.gtk_tree_store_set(this.modelHandle, iter, 0, id, -1);
        return id;
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Tree.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    long cellDataProc(long tree_column, long cell, long tree_model, long iter, long data) {
        if (cell == this.ignoreCell) {
            return 0L;
        }
        TreeItem item = this._getItem(iter);
        if (item != null) {
            OS.g_object_set_qdata(cell, Display.SWT_OBJECT_INDEX2, item.handle);
        }
        boolean isPixbuf = GTK.GTK_IS_CELL_RENDERER_PIXBUF(cell);
        boolean isText = GTK.GTK_IS_CELL_RENDERER_TEXT(cell);
        if (isText) {
            GTK.gtk_cell_renderer_set_fixed_size(cell, -1, -1);
        }
        if (!isPixbuf && !isText) {
            return 0L;
        }
        int modelIndex = -1;
        boolean customDraw = false;
        if (this.columnCount == 0) {
            modelIndex = 6;
            customDraw = this.firstCustomDraw;
        } else {
            TreeColumn column = (TreeColumn)this.display.getWidget(tree_column);
            if (column != null) {
                modelIndex = column.modelIndex;
                customDraw = column.customDraw;
            }
        }
        if (modelIndex == -1) {
            return 0L;
        }
        boolean setData = false;
        boolean updated = false;
        if ((this.style & 0x10000000) != 0) {
            if (!item.cached) {
                setData = this.checkData(item);
            }
            if (item.updated) {
                updated = true;
                item.updated = false;
            }
        }
        long[] ptr = new long[1];
        if (setData) {
            if (isPixbuf) {
                ptr[0] = 0L;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 0, ptr, -1);
                OS.g_object_set(cell, OS.gicon, ptr[0], 0L);
                if (ptr[0] != 0L) {
                    OS.g_object_unref(ptr[0]);
                }
            } else {
                ptr[0] = 0L;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 1, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.text, ptr[0], 0L);
                    OS.g_free(ptr[0]);
                }
            }
        }
        if (customDraw) {
            if (!this.isOwnerDrawn) {
                ptr[0] = 0L;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 3, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.cell_background_rgba, ptr[0], 0L);
                    GDK.gdk_rgba_free(ptr[0]);
                }
            }
            if (!isPixbuf) {
                ptr[0] = 0L;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 2, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.foreground_rgba, ptr[0], 0L);
                    GDK.gdk_rgba_free(ptr[0]);
                }
                ptr[0] = 0L;
                GTK.gtk_tree_model_get(tree_model, iter, modelIndex + 4, ptr, -1);
                if (ptr[0] != 0L) {
                    OS.g_object_set(cell, OS.font_desc, ptr[0], 0L);
                    OS.pango_font_description_free(ptr[0]);
                }
            }
        }
        if (setData || updated) {
            this.ignoreCell = cell;
            this.setScrollWidth(tree_column, item);
            this.ignoreCell = 0L;
        }
        return 0L;
    }

    boolean checkData(TreeItem item) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            TreeItem parentItem = item.getParentItem();
            Event event = new Event();
            event.item = item;
            event.index = parentItem == null ? this.indexOf(item) : parentItem.indexOf(item);
            int mask = 17;
            int signal_id = OS.g_signal_lookup(OS.row_changed, GTK.gtk_tree_model_get_type());
            OS.g_signal_handlers_block_matched(this.modelHandle, mask, signal_id, 0, 0L, 0L, this.handle);
            this.currentItem = item;
            item.settingData = true;
            this.sendEvent(36, event);
            item.settingData = false;
            this.currentItem = null;
            if (this.isDisposed()) {
                return false;
            }
            OS.g_signal_handlers_unblock_matched(this.modelHandle, mask, signal_id, 0, 0L, 0L, this.handle);
            if (item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    public void addTreeListener(TreeListener listener) {
        this.addTypedListener(listener, 17, 18);
    }

    int calculateWidth(long column, long iter, boolean recurse) {
        long list;
        GTK.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
        int width = 0;
        int[] w = new int[1];
        long path = 0L;
        long expander_column = GTK.gtk_tree_view_get_expander_column(this.handle);
        if (expander_column == 0L && !GTK.gtk_tree_view_column_get_visible(column)) {
            GTK.gtk_tree_view_column_set_visible(column, true);
            expander_column = GTK.gtk_tree_view_get_expander_column(this.handle);
            GTK.gtk_tree_view_column_set_visible(column, false);
        }
        if (expander_column == column) {
            GdkRectangle rect = new GdkRectangle();
            GTK.gtk_widget_realize(this.handle);
            path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            GTK.gtk_tree_view_get_cell_area(this.handle, path, column, rect);
            width += rect.x;
            if (!GTK.gtk_tree_view_column_get_visible(column)) {
                if (GTK.GTK4) {
                    long image = GTK4.gtk_image_new_from_icon_name(GTK.GTK_NAMED_ICON_PAN_DOWN);
                    GtkRequisition requisition = new GtkRequisition();
                    GTK.gtk_widget_get_preferred_size(image, requisition, null);
                    width += requisition.width + 4;
                } else {
                    GTK3.gtk_widget_style_get(this.handle, OS.expander_size, w, 0L);
                    width += w[0] + 4;
                }
            }
        }
        if (!GTK.GTK4) {
            GTK3.gtk_widget_style_get(this.handle, OS.focus_line_width, w, 0L);
            width += 2 * w[0];
        }
        if ((list = GTK.gtk_cell_layout_get_cells(column)) == 0L) {
            return 0;
        }
        long temp = list;
        while (temp != 0L) {
            long renderer = OS.g_list_data(temp);
            if (renderer != 0L) {
                this.gtk_cell_renderer_get_preferred_size(renderer, this.handle, w, null);
                width += w[0];
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        if (recurse) {
            boolean expanded;
            if (path == 0L) {
                path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
            }
            if (expanded = GTK.gtk_tree_view_row_expanded(this.handle, path)) {
                long childIter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                boolean valid = GTK.gtk_tree_model_iter_children(this.modelHandle, childIter, iter);
                while (valid) {
                    width = Math.max(width, this.calculateWidth(column, childIter, true));
                    valid = GTK.gtk_tree_model_iter_next(this.modelHandle, childIter);
                }
                OS.g_free(childIter);
            }
        }
        if (path != 0L) {
            GTK.gtk_tree_path_free(path);
        }
        if (GTK.gtk_tree_view_get_grid_lines(this.handle) > 0 && !GTK.GTK4) {
            GTK3.gtk_widget_style_get(this.handle, OS.grid_line_width, w, 0L);
            width += 2 * w[0];
        }
        return width;
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.clear(0L, index, all);
    }

    void clear(long parentIter, int index, boolean all) {
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parentIter, index);
        int[] value = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
        if (value[0] != -1) {
            TreeItem item = this.items[value[0]];
            item.clear();
        }
        if (all) {
            this.clearAll(all, iter);
        }
        OS.g_free(iter);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.clearAll(all, 0L);
    }

    void clearAll(boolean all, long parentIter) {
        int length = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (length == 0) {
            return;
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        boolean valid = GTK.gtk_tree_model_iter_children(this.modelHandle, iter, parentIter);
        int[] value = new int[1];
        while (valid) {
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
            if (value[0] != -1) {
                TreeItem item = this.items[value[0]];
                item.clear();
            }
            if (all) {
                this.clearAll(all, iter);
            }
            valid = GTK.gtk_tree_model_iter_next(this.modelHandle, iter);
        }
        OS.g_free(iter);
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if (!GTK.GTK4 && this.firstCompute) {
            for (TreeColumn column : this.columns) {
                if (column == null) continue;
                GTK.gtk_widget_set_visible(column.buttonHandle, true);
            }
            this.firstCompute = false;
        }
        GTK.gtk_widget_realize(this.handle);
        Point size = this.computeNativeSize(this.handle, wHint, hHint, changed);
        if (hHint == -1 && size.y == this.getHeaderHeight()) {
            int itemHeight = this.getItemHeightInPixels();
            size.y = this.getItemCount() * itemHeight + this.getHeaderHeight();
            for (TreeItem item : this.items) {
                if (item == null || !item.isExpanded) continue;
                size.y += GTK.gtk_tree_model_iter_n_children(this.modelHandle, item.handle) * itemHeight;
            }
        }
        Rectangle trim = this.computeTrimInPixels(0, 0, size.x, size.y);
        size.x = trim.width;
        if (size.y == this.headerHeight && this.headerVisible && (this.style & 0x10) != 0) {
            ++trim.height;
        }
        size.y = trim.height;
        return size;
    }

    void copyModel(long oldModel, int oldStart, long newModel, int newStart, long oldParent, long newParent, int modelLength) {
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        long value = OS.g_malloc(OS.GValue_sizeof());
        C.memset(value, 0, OS.GValue_sizeof());
        if (GTK.gtk_tree_model_iter_children(oldModel, iter, oldParent)) {
            long[] oldItems = new long[GTK.gtk_tree_model_iter_n_children(oldModel, oldParent)];
            int oldIndex = 0;
            int[] intBuffer = new int[1];
            do {
                long newIterator;
                if ((newIterator = OS.g_malloc(GTK.GtkTreeIter_sizeof())) == 0L) {
                    this.error(2);
                }
                GTK.gtk_tree_store_append(newModel, newIterator, newParent);
                GTK.gtk_tree_model_get(oldModel, iter, 0, intBuffer, -1);
                int index = intBuffer[0];
                TreeItem item = null;
                if (index != -1) {
                    item = this.items[index];
                    if (item != null) {
                        long oldIterator = item.handle;
                        oldItems[oldIndex++] = oldIterator;
                        for (int iColumn = 0; iColumn < 6; ++iColumn) {
                            GTK.gtk_tree_model_get_value(oldModel, oldIterator, iColumn, value);
                            GTK.gtk_tree_store_set_value(newModel, newIterator, iColumn, value);
                            OS.g_value_unset(value);
                        }
                        for (int iOffset = 0; iOffset < modelLength - 6; ++iOffset) {
                            GTK.gtk_tree_model_get_value(oldModel, oldIterator, oldStart + iOffset, value);
                            GTK.gtk_tree_store_set_value(newModel, newIterator, newStart + iOffset, value);
                            OS.g_value_unset(value);
                        }
                    }
                } else {
                    GTK.gtk_tree_store_set(newModel, newIterator, 0, -1, -1);
                }
                this.copyModel(oldModel, oldStart, newModel, newStart, iter, newIterator, modelLength);
                if (item != null) {
                    item.handle = newIterator;
                    continue;
                }
                OS.g_free(newIterator);
            } while (GTK.gtk_tree_model_iter_next(oldModel, iter));
            for (int i = 0; i < oldItems.length; ++i) {
                long oldItem = oldItems[i];
                if (oldItem == 0L) continue;
                GTK.gtk_tree_store_remove(oldModel, oldItem);
                OS.g_free(oldItem);
            }
        }
        OS.g_free(value);
        OS.g_free(iter);
    }

    void createColumn(TreeColumn column, int index) {
        long columnHandle;
        int modelIndex = 6;
        if (this.columnCount != 0) {
            int modelLength = GTK.gtk_tree_model_get_n_columns(this.modelHandle);
            boolean[] usedColumns = new boolean[modelLength];
            for (int i = 0; i < this.columnCount; ++i) {
                int columnIndex = this.columns[i].modelIndex;
                for (int j = 0; j < 6; ++j) {
                    usedColumns[columnIndex + j] = true;
                }
            }
            while (modelIndex < modelLength && usedColumns[modelIndex]) {
                ++modelIndex;
            }
            if (modelIndex == modelLength) {
                long oldModel = this.modelHandle;
                long[] types = this.getColumnTypes(this.columnCount + 4);
                long newModel = GTK.gtk_tree_store_newv(types.length, types);
                if (newModel == 0L) {
                    this.error(2);
                }
                this.copyModel(oldModel, 6, newModel, 6, 0L, 0L, modelLength);
                GTK.gtk_tree_view_set_model(this.handle, newModel);
                this.setModel(newModel);
            }
        }
        if ((columnHandle = GTK.gtk_tree_view_column_new()) == 0L) {
            this.error(2);
        }
        if (index == 0 && this.columnCount > 0) {
            TreeColumn checkColumn = this.columns[0];
            this.createRenderers(checkColumn.handle, checkColumn.modelIndex, false, checkColumn.style);
        }
        this.createRenderers(columnHandle, modelIndex, index == 0, column == null ? 0 : column.style);
        if ((this.style & 0x10000000) == 0 && this.columnCount == 0) {
            GTK.gtk_tree_view_column_set_sizing(columnHandle, 0);
        } else {
            GTK.gtk_tree_view_column_set_sizing(columnHandle, 2);
        }
        GTK.gtk_tree_view_column_set_resizable(columnHandle, true);
        GTK.gtk_tree_view_column_set_clickable(columnHandle, true);
        GTK.gtk_tree_view_column_set_min_width(columnHandle, 0);
        GTK.gtk_tree_view_insert_column(this.handle, columnHandle, index);
        if (this.columnCount != 0) {
            GTK.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (column != null) {
            column.handle = columnHandle;
            column.modelIndex = modelIndex;
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            this.scrolledHandle = GTK4.gtk_scrolled_window_new();
        } else {
            GTK3.gtk_widget_set_has_window(this.fixedHandle, true);
            this.scrolledHandle = GTK3.gtk_scrolled_window_new(0L, 0L);
        }
        if (this.scrolledHandle == 0L) {
            this.error(2);
        }
        long[] types = this.getColumnTypes(1);
        this.modelHandle = GTK.gtk_tree_store_newv(types.length, types);
        if (this.modelHandle == 0L) {
            this.error(2);
        }
        this.handle = GTK.gtk_tree_view_new_with_model(this.modelHandle);
        if (this.handle == 0L) {
            this.error(2);
        }
        if ((this.style & 0x20) != 0) {
            this.checkRenderer = GTK.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
        }
        this.createColumn(null, 0);
        if (GTK.GTK4) {
            OS.swt_fixed_add(this.fixedHandle, this.scrolledHandle);
            GTK4.gtk_scrolled_window_set_child(this.scrolledHandle, this.handle);
        } else {
            GTK3.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            GTK3.gtk_container_add(this.scrolledHandle, this.handle);
        }
        int mode = (this.style & 2) != 0 ? 3 : 2;
        long selectionHandle = GTK.gtk_tree_view_get_selection(this.handle);
        GTK.gtk_tree_selection_set_mode(selectionHandle, mode);
        GTK.gtk_tree_view_set_headers_visible(this.handle, false);
        int hsp = (this.style & 0x100) != 0 ? 1 : 2;
        int vsp = (this.style & 0x200) != 0 ? 1 : 2;
        GTK.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
        if ((this.style & 0x800) != 0) {
            if (GTK.GTK4) {
                GTK4.gtk_scrolled_window_set_has_frame(this.scrolledHandle, true);
            } else {
                GTK3.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.style & 0x10000000) != 0) {
            OS.g_object_set(this.handle, OS.fixed_height_mode, true, 0L);
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        }
        if (GTK.GTK4) {
            this.bindArrowKeyBindings();
        }
    }

    void bindArrowKeyBindings() {
        if (!GTK.GTK4) {
            return;
        }
        int[] keyval = new int[1];
        GTK.gtk_accelerator_parse(Converter.javaStringToCString("Left"), keyval, null);
        GTK4.gtk_widget_class_add_binding_signal(GTK.GTK_WIDGET_GET_CLASS(this.handle), keyval[0], 0, Converter.javaStringToCString("expand-collapse-cursor-row"), Converter.javaStringToCString("(bbb)"), false, false, false);
        GTK.gtk_accelerator_parse(Converter.javaStringToCString("Right"), keyval, null);
        GTK4.gtk_widget_class_add_binding_signal(GTK.GTK_WIDGET_GET_CLASS(this.handle), keyval[0], 0, Converter.javaStringToCString("expand-collapse-cursor-row"), Converter.javaStringToCString("(bbb)"), false, true, false);
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    void createItem(TreeColumn column, int index) {
        long imageHandle;
        long labelHandle;
        if (0 > index || index > this.columnCount) {
            this.error(6);
        }
        if (index == 0) {
            column.style &= 0xFEFDBFFF;
            column.style |= 0x4000;
        }
        if (this.columnCount == 0) {
            column.handle = GTK.gtk_tree_view_get_column(this.handle, 0);
            GTK.gtk_tree_view_column_set_sizing(column.handle, 2);
            GTK.gtk_tree_view_column_set_visible(column.handle, false);
            column.modelIndex = 6;
            this.createRenderers(column.handle, column.modelIndex, true, column.style);
            column.customDraw = this.firstCustomDraw;
            this.firstCustomDraw = false;
        } else {
            this.createColumn(column, index);
        }
        long boxHandle = this.gtk_box_new(0, false, 3);
        if (boxHandle == 0L) {
            this.error(2);
        }
        if ((labelHandle = GTK.gtk_label_new_with_mnemonic(null)) == 0L) {
            this.error(2);
        }
        if ((imageHandle = GTK.gtk_image_new()) == 0L) {
            this.error(2);
        }
        if (GTK.GTK4) {
            GTK4.gtk_box_append(boxHandle, imageHandle);
            GTK4.gtk_box_append(boxHandle, labelHandle);
            GTK.gtk_widget_hide(imageHandle);
        } else {
            GTK3.gtk_container_add(boxHandle, imageHandle);
            GTK3.gtk_container_add(boxHandle, labelHandle);
            GTK.gtk_widget_show(boxHandle);
            GTK.gtk_widget_show(labelHandle);
        }
        column.labelHandle = labelHandle;
        column.imageHandle = imageHandle;
        GTK.gtk_tree_view_column_set_widget(column.handle, boxHandle);
        column.buttonHandle = GTK.gtk_tree_view_column_get_button(column.handle);
        GTK.gtk_widget_set_focus_on_click(column.buttonHandle, false);
        if (this.columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columns.length + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if ((this.state & 0x4000) != 0) {
            long fontDesc = this.getFontDescription();
            column.setFontDescription(fontDesc);
            OS.pango_font_description_free(fontDesc);
        }
        if (this.columnCount >= 1) {
            for (int i = 0; i < this.items.length; ++i) {
                String[] strings;
                TreeItem item = this.items[i];
                if (item == null) continue;
                Font[] cellFont = item.cellFont;
                if (cellFont != null) {
                    Font[] temp = new Font[this.columnCount];
                    System.arraycopy(cellFont, 0, temp, 0, index);
                    System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                    item.cellFont = temp;
                }
                if ((strings = item.strings) == null) continue;
                String[] temp = new String[this.columnCount];
                System.arraycopy(strings, 0, temp, 0, index);
                System.arraycopy(strings, index, temp, index + 1, this.columnCount - index - 1);
                temp[index] = "";
                item.strings = temp;
            }
        }
        this.updateHeaderCSS();
    }

    void createItem(TreeItem item, long parentIter, int index) {
        int roots;
        if (index == 0) {
            item.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (item.handle == 0L) {
                this.error(2);
            }
            GTK.gtk_tree_store_prepend(this.modelHandle, item.handle, parentIter);
        } else if (index == -1) {
            item.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (item.handle == 0L) {
                this.error(2);
            }
            GTK.gtk_tree_store_append(this.modelHandle, item.handle, parentIter);
        } else {
            int count = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
            if (0 > index || index > count) {
                this.error(6);
            }
            item.handle = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (item.handle == 0L) {
                this.error(2);
            }
            if (index == count) {
                GTK.gtk_tree_store_append(this.modelHandle, item.handle, parentIter);
            } else {
                GTK.gtk_tree_store_insert(this.modelHandle, item.handle, parentIter, index);
            }
        }
        int id = this.getId(item.handle, false);
        this.items[id] = item;
        this.modelChanged = true;
        if (parentIter == 0L && (roots = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L)) == 1) {
            Event event = new Event();
            event.detail = 0;
            this.sendEvent(56, event);
        }
    }

    void createRenderers(long columnHandle, int modelIndex, boolean check, int columnStyle) {
        long textRenderer;
        long pixbufRenderer;
        GTK.gtk_tree_view_column_clear(columnHandle);
        if ((this.style & 0x20) != 0 && check) {
            GTK.gtk_tree_view_column_pack_start(columnHandle, this.checkRenderer, false);
            GTK.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.active, 1);
            GTK.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.inconsistent, 2);
            if (!this.isOwnerDrawn) {
                GTK.gtk_tree_view_column_add_attribute(columnHandle, this.checkRenderer, OS.cell_background_rgba, 4);
            }
            if (this.isOwnerDrawn) {
                GTK.gtk_tree_view_column_set_cell_data_func(columnHandle, this.checkRenderer, this.display.cellDataProc, this.handle, 0L);
                OS.g_object_set_qdata(this.checkRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            }
        }
        if (GTK.GTK4) {
            pixbufRenderer = GTK.gtk_cell_renderer_pixbuf_new();
        } else {
            long l = pixbufRenderer = this.isOwnerDrawn ? OS.g_object_new(this.display.gtk_cell_renderer_pixbuf_get_type(), 0L) : GTK.gtk_cell_renderer_pixbuf_new();
        }
        if (pixbufRenderer == 0L) {
            this.error(2);
        } else if (!this.isOwnerDrawn) {
            if ((this.style & 0x10000000) != 0 && this.pixbufSizeSet) {
                GTK.gtk_cell_renderer_set_fixed_size(pixbufRenderer, this.pixbufHeight, this.pixbufWidth);
            } else {
                GTK.gtk_cell_renderer_set_fixed_size(pixbufRenderer, 0, 0);
            }
        }
        long l = textRenderer = this.isOwnerDrawn ? OS.g_object_new(this.display.gtk_cell_renderer_text_get_type(), 0L) : GTK.gtk_cell_renderer_text_new();
        if (textRenderer == 0L) {
            this.error(2);
        }
        if (this.isOwnerDrawn) {
            OS.g_object_set_qdata(pixbufRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
            OS.g_object_set_qdata(textRenderer, Display.SWT_OBJECT_INDEX1, columnHandle);
        }
        if ((this.style & 0x20) != 0 && check) {
            OS.g_object_set(pixbufRenderer, OS.mode, 1, 0L);
        }
        if ((columnStyle & 0x20000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 1.0f, 0L);
            GTK.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            GTK.gtk_tree_view_column_pack_end(columnHandle, pixbufRenderer, false);
            GTK.gtk_tree_view_column_set_alignment(columnHandle, 1.0f);
        } else if ((columnStyle & 0x1000000) != 0) {
            OS.g_object_set(textRenderer, OS.xalign, 0.5f, 0L);
            GTK.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            GTK.gtk_tree_view_column_pack_end(columnHandle, textRenderer, true);
            GTK.gtk_tree_view_column_set_alignment(columnHandle, 0.5f);
        } else {
            GTK.gtk_tree_view_column_pack_start(columnHandle, pixbufRenderer, false);
            GTK.gtk_tree_view_column_pack_start(columnHandle, textRenderer, true);
            GTK.gtk_tree_view_column_set_alignment(columnHandle, 0.0f);
        }
        GTK.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.pixbuf, modelIndex + 0);
        if (!this.isOwnerDrawn) {
            GTK.gtk_tree_view_column_add_attribute(columnHandle, pixbufRenderer, OS.cell_background_rgba, 4);
            GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.cell_background_rgba, 4);
        }
        GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.text, modelIndex + 1);
        GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.foreground_rgba, 3);
        GTK.gtk_tree_view_column_add_attribute(columnHandle, textRenderer, OS.font_desc, 5);
        boolean customDraw = this.firstCustomDraw;
        if (this.columnCount != 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].handle != columnHandle) continue;
                customDraw = this.columns[i].customDraw;
                break;
            }
        }
        if ((this.style & 0x10000000) != 0 || customDraw || this.isOwnerDrawn) {
            GTK.gtk_tree_view_column_set_cell_data_func(columnHandle, textRenderer, this.display.cellDataProc, this.handle, 0L);
            GTK.gtk_tree_view_column_set_cell_data_func(columnHandle, pixbufRenderer, this.display.cellDataProc, this.handle, 0L);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
        this.columnCount = 0;
        this.setFontDescription(this.defaultFont().handle);
    }

    @Override
    GdkRGBA defaultBackground() {
        return this.display.getSystemColor((int)25).handle;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(GTK.gtk_tree_view_get_selection(this.handle));
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
        }
        this.display.removeWidget(this.modelHandle);
    }

    public void deselect(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_unselect_iter(selection, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        boolean fixColumn = this.showFirstColumn();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_unselect_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    void destroyItem(TreeColumn column) {
        int index;
        for (index = 0; index < this.columnCount && this.columns[index] != column; ++index) {
        }
        if (index == this.columnCount) {
            return;
        }
        long columnHandle = column.handle;
        if (this.columnCount == 1) {
            this.firstCustomDraw = column.customDraw;
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        GTK.gtk_tree_view_remove_column(this.handle, columnHandle);
        if (this.columnCount == 0) {
            long oldModel = this.modelHandle;
            long[] types = this.getColumnTypes(1);
            long newModel = GTK.gtk_tree_store_newv(types.length, types);
            if (newModel == 0L) {
                this.error(2);
            }
            this.copyModel(oldModel, column.modelIndex, newModel, 6, 0L, 0L, 12);
            GTK.gtk_tree_view_set_model(this.handle, newModel);
            this.setModel(newModel);
            this.createColumn(null, 0);
        } else {
            for (int i = 0; i < this.items.length; ++i) {
                TreeItem item = this.items[i];
                if (item == null) continue;
                long iter = item.handle;
                int modelIndex = column.modelIndex;
                GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 0, 0L, -1);
                GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 1, 0L, -1);
                GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 2, 0L, -1);
                GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 3, 0L, -1);
                GTK.gtk_tree_store_set(this.modelHandle, iter, modelIndex + 4, 0L, -1);
                Font[] cellFont = item.cellFont;
                if (cellFont == null) continue;
                if (this.columnCount == 0) {
                    item.cellFont = null;
                    continue;
                }
                Font[] temp = new Font[this.columnCount];
                System.arraycopy(cellFont, 0, temp, 0, index);
                System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - index);
                item.cellFont = temp;
            }
            if (index == 0) {
                TreeColumn firstColumn = this.columns[0];
                firstColumn.style &= 0xFEFDBFFF;
                firstColumn.style |= 0x4000;
                this.createRenderers(firstColumn.handle, firstColumn.modelIndex, true, firstColumn.style);
            }
        }
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    void destroyItem(TreeItem item) {
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_store_remove(this.modelHandle, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        this.modelChanged = true;
        int roots = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (roots == 0) {
            Event event = new Event();
            event.detail = 1;
            this.sendEvent(56, event);
        }
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean dragOnTimeout, boolean[] consume) {
        boolean selected = false;
        if (OS.isX11()) {
            boolean dragDetect;
            if (filter) {
                long[] path = new long[1];
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, null, null, null)) {
                    if (path[0] != 0L) {
                        long selection = GTK.gtk_tree_view_get_selection(this.handle);
                        if (GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                            selected = true;
                        }
                        GTK.gtk_tree_path_free(path[0]);
                    }
                } else {
                    return false;
                }
            }
            if ((dragDetect = super.dragDetect(x, y, filter, false, consume)) && selected && consume != null) {
                consume[0] = true;
            }
            return dragDetect;
        }
        double[] startX = new double[1];
        double[] startY = new double[1];
        long[] path = new long[1];
        if (GTK.gtk_gesture_drag_get_start_point(this.dragGesture, startX, startY)) {
            if (this.getHeaderVisible()) {
                startY[0] = startY[0] - (double)this.getHeaderHeightInPixels();
            }
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)startX[0], (int)startY[0], path, null, null, null)) {
                if (path[0] != 0L) {
                    boolean dragDetect = super.dragDetect(x, y, filter, false, consume);
                    if (dragDetect && selected && consume != null) {
                        consume[0] = true;
                    }
                    return dragDetect;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    @Override
    long eventWindow() {
        return this.paintWindow();
    }

    @Override
    Rectangle getClientAreaInPixels() {
        Rectangle rect;
        int height;
        this.checkWidget();
        if (RESIZE_ON_GETCLIENTAREA) {
            this.forceResize();
        }
        long clientHandle = this.clientHandle();
        GtkAllocation allocation = new GtkAllocation();
        GTK.gtk_widget_get_allocation(clientHandle, allocation);
        int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
        int n = height = (this.state & 0x400) != 0 ? 0 : allocation.height;
        if (GTK.GTK4) {
            int[] headerHeight = new int[1];
            int[] headerWidth = new int[1];
            GTK.gtk_tree_view_convert_bin_window_to_widget_coords(this.handle, 0, 0, headerWidth, headerHeight);
            rect = new Rectangle(headerWidth[0], headerHeight[0], width, height);
        } else {
            GTK.gtk_widget_realize(this.handle);
            long fixedWindow = this.gtk_widget_get_window(this.fixedHandle);
            long binWindow = GTK3.gtk_tree_view_get_bin_window(this.handle);
            int[] binX = new int[1];
            int[] binY = new int[1];
            GDK.gdk_window_get_origin(binWindow, binX, binY);
            int[] fixedX = new int[1];
            int[] fixedY = new int[1];
            GDK.gdk_window_get_origin(fixedWindow, fixedX, fixedY);
            rect = new Rectangle(fixedX[0] - binX[0], fixedY[0] - binY[0], width, height);
        }
        return rect;
    }

    @Override
    int getClientWidth() {
        int[] w = new int[1];
        int[] h = new int[1];
        if (GTK.GTK4) {
            long surface = this.gtk_widget_get_surface(this.handle);
            this.gdk_surface_get_size(surface, w, h);
        } else {
            GTK.gtk_widget_realize(this.handle);
            this.gdk_window_get_size(GTK3.gtk_tree_view_get_bin_window(this.handle), w, h);
        }
        return w[0];
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (0 > index || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        if (this.columnCount == 0) {
            return new int[0];
        }
        long list = GTK.gtk_tree_view_get_columns(this.handle);
        if (list == 0L) {
            return new int[0];
        }
        int i = 0;
        int count = OS.g_list_length(list);
        int[] order = new int[count];
        long temp = list;
        while (temp != 0L) {
            long column = OS.g_list_data(temp);
            if (column != 0L) {
                for (int j = 0; j < this.columnCount; ++j) {
                    if (this.columns[j].handle != column) continue;
                    order[i++] = j;
                    break;
                }
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        return order;
    }

    long[] getColumnTypes(int columnCount) {
        long[] types = new long[6 + columnCount * 6];
        types[0] = OS.G_TYPE_INT();
        types[1] = OS.G_TYPE_BOOLEAN();
        types[2] = OS.G_TYPE_BOOLEAN();
        types[3] = GDK.GDK_TYPE_RGBA();
        types[4] = GDK.GDK_TYPE_RGBA();
        types[5] = OS.PANGO_TYPE_FONT_DESCRIPTION();
        for (int i = 6; i < types.length; i += 6) {
            types[i + 0] = GDK.GDK_TYPE_PIXBUF();
            types[i + 1] = OS.G_TYPE_STRING();
            types[i + 2] = GDK.GDK_TYPE_RGBA();
            types[i + 3] = GDK.GDK_TYPE_RGBA();
            types[i + 4] = OS.PANGO_TYPE_FONT_DESCRIPTION();
            types[i + 5] = OS.G_TYPE_LONG();
        }
        return types;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    @Override
    GdkRGBA getContextBackgroundGdkRGBA() {
        if (this.background != null) {
            return this.background;
        }
        return this.defaultBackground();
    }

    @Override
    GdkRGBA getContextColorGdkRGBA() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.display.COLOR_LIST_FOREGROUND_RGBA;
    }

    TreeItem getFocusItem() {
        long[] path = new long[1];
        GTK.gtk_tree_view_get_cursor(this.handle, path, null);
        if (path[0] == 0L) {
            return null;
        }
        TreeItem item = null;
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            int[] index = new int[1];
            GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
            if (index[0] != -1) {
                item = this.items[index[0]];
            }
        }
        OS.g_free(iter);
        GTK.gtk_tree_path_free(path[0]);
        return item;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getGridLineWidthInPixels());
    }

    int getGridLineWidthInPixels() {
        this.checkWidget();
        return 0;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return this.headerBackground != null ? this.headerBackground : this.display.getSystemColor(25);
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return this.headerForeground != null ? this.headerForeground : this.display.getSystemColor(24);
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getHeaderHeightInPixels());
    }

    int getHeaderHeightInPixels() {
        this.checkWidget();
        if (!GTK.gtk_tree_view_get_headers_visible(this.handle)) {
            return 0;
        }
        int height = 0;
        if (this.columnCount > 0) {
            GtkRequisition requisition = new GtkRequisition();
            for (int i = 0; i < this.columnCount; ++i) {
                long buttonHandle = this.columns[i].buttonHandle;
                if (buttonHandle == 0L) continue;
                this.gtk_widget_get_preferred_size(buttonHandle, requisition);
                height = Math.max(height, requisition.height);
            }
        } else if (GTK.GTK4) {
            int[] headerHeight = new int[1];
            GTK.gtk_tree_view_convert_bin_window_to_widget_coords(this.handle, 0, 0, null, headerHeight);
            height = headerHeight[0];
        } else {
            GTK.gtk_widget_realize(this.handle);
            long fixedWindow = this.gtk_widget_get_window(this.fixedHandle);
            long binWindow = GTK3.gtk_tree_view_get_bin_window(this.handle);
            int[] binY = new int[1];
            GDK.gdk_window_get_origin(binWindow, null, binY);
            int[] fixedY = new int[1];
            GDK.gdk_window_get_origin(fixedWindow, null, fixedY);
            height = binY[0] - fixedY[0];
        }
        return height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return GTK.gtk_tree_view_get_headers_visible(this.handle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0) {
            this.error(6);
        }
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        try {
            if (!GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, 0L, index)) {
                this.error(6);
            }
            TreeItem treeItem = this._getItem(0L, iter, index);
            return treeItem;
        }
        finally {
            OS.g_free(iter);
        }
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        return this.getItemInPixels(DPIUtil.autoScaleUp(point));
    }

    TreeItem getItemInPixels(Point point) {
        long[] columnHandle;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        long[] path = new long[1];
        GTK.gtk_widget_realize(this.handle);
        int x = point.x;
        int y = point.y;
        if (this.getHeaderVisible() && GTK.GTK4) {
            y -= this.getHeaderHeight();
        }
        if ((this.style & 0x8000000) != 0) {
            x = this.getClientWidth() - x;
        }
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, x, y, path, columnHandle = new long[1], null, null)) {
            return null;
        }
        if (path[0] == 0L) {
            return null;
        }
        TreeItem item = null;
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            boolean overExpander = false;
            if (GTK.gtk_tree_view_get_expander_column(this.handle) == columnHandle[0]) {
                GdkRectangle rect = new GdkRectangle();
                GTK.gtk_tree_view_get_cell_area(this.handle, path[0], columnHandle[0], rect);
                if ((this.style & 0x8000000) != 0) {
                    overExpander = x > rect.x + rect.width;
                } else {
                    boolean bl = overExpander = x < rect.x;
                }
            }
            if (!overExpander) {
                item = this._getItem(iter);
            }
        }
        OS.g_free(iter);
        GTK.gtk_tree_path_free(path[0]);
        return item;
    }

    public int getItemCount() {
        this.checkWidget();
        return GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
    }

    public int getItemHeight() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getItemHeightInPixels());
    }

    int getItemHeightInPixels() {
        this.checkWidget();
        int height = 0;
        int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
        if (itemCount == 0) {
            long column = GTK.gtk_tree_view_get_column(this.handle, 0);
            int[] h = new int[1];
            this.ignoreSize = true;
            if (GTK.GTK4) {
                GTK4.gtk_tree_view_column_cell_get_size(column, null, null, null, h);
            } else {
                GTK3.gtk_tree_view_column_cell_get_size(column, null, null, null, null, h);
            }
            height = h[0];
            long textRenderer = this.getTextRenderer(column);
            if (textRenderer != 0L) {
                GTK.gtk_cell_renderer_get_preferred_height_for_width(textRenderer, this.handle, 0, h, null);
            }
            height += h[0];
            this.ignoreSize = false;
        } else {
            long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            GTK.gtk_tree_model_get_iter_first(this.modelHandle, iter);
            int columnCount = Math.max(1, this.columnCount);
            for (int i = 0; i < columnCount; ++i) {
                long column = GTK.gtk_tree_view_get_column(this.handle, i);
                GTK.gtk_tree_view_column_cell_set_cell_data(column, this.modelHandle, iter, false, false);
                int[] h = new int[1];
                if (GTK.GTK4) {
                    GTK4.gtk_tree_view_column_cell_get_size(column, null, null, null, h);
                } else {
                    GTK3.gtk_tree_view_column_cell_get_size(column, null, null, null, null, h);
                }
                long textRenderer = this.getTextRenderer(column);
                int[] ypad = new int[1];
                if (textRenderer != 0L) {
                    GTK.gtk_cell_renderer_get_padding(textRenderer, null, ypad);
                }
                height = Math.max(height, h[0] + ypad[0]);
            }
            OS.g_free(iter);
        }
        return height;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        return this.getItems(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TreeItem[] getItems(long parent) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        try {
            boolean valid = GTK.gtk_tree_model_iter_children(this.modelHandle, iter, parent);
            while (valid) {
                result.add(this._getItem(parent, iter, result.size()));
                valid = GTK.gtk_tree_model_iter_next(this.modelHandle, iter);
            }
        }
        finally {
            OS.g_free(iter);
        }
        return result.toArray(new TreeItem[result.size()]);
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return GTK.gtk_tree_view_get_grid_lines(this.handle) > 0;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    long getPixbufRenderer(long column) {
        long list = GTK.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0L;
        }
        long originalList = list;
        long pixbufRenderer = 0L;
        while (list != 0L) {
            long renderer = OS.g_list_data(list);
            if (GTK.GTK_IS_CELL_RENDERER_PIXBUF(renderer)) {
                pixbufRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return pixbufRenderer;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        long list = GTK.gtk_tree_selection_get_selected_rows(selection, null);
        if (list != 0L) {
            long originalList = list;
            int count = OS.g_list_length(list);
            TreeItem[] treeSelection = new TreeItem[count];
            int length = 0;
            for (int i = 0; i < count; ++i) {
                long data = OS.g_list_data(list);
                long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, data)) {
                    treeSelection[length] = this._getItem(iter);
                    ++length;
                }
                list = OS.g_list_next(list);
                OS.g_free(iter);
                GTK.gtk_tree_path_free(data);
            }
            OS.g_list_free(originalList);
            if (length < count) {
                TreeItem[] temp = new TreeItem[length];
                System.arraycopy(treeSelection, 0, temp, 0, length);
                treeSelection = temp;
            }
            return treeSelection;
        }
        return new TreeItem[0];
    }

    public int getSelectionCount() {
        this.checkWidget();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        return GTK.gtk_tree_selection_count_selected_rows(selection);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    long getTextRenderer(long column) {
        long list = GTK.gtk_cell_layout_get_cells(column);
        if (list == 0L) {
            return 0L;
        }
        long originalList = list;
        long textRenderer = 0L;
        while (list != 0L) {
            long renderer = OS.g_list_data(list);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(renderer)) {
                textRenderer = renderer;
                break;
            }
            list = OS.g_list_next(list);
        }
        OS.g_list_free(originalList);
        return textRenderer;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        long vAdjustment = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.currentAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
        TreeItem item = null;
        if (this.cachedAdjustment == this.currentAdjustment) {
            item = this._getCachedTopItem();
        }
        if (item != null && !item.isDisposed()) {
            return item;
        }
        long[] path = new long[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, 1, 1, path, null, null, null)) {
            return null;
        }
        if (path[0] == 0L) {
            return null;
        }
        item = null;
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, path[0])) {
            item = this._getItem(iter);
        }
        OS.g_free(iter);
        GTK.gtk_tree_path_free(path[0]);
        this.topItem = item;
        return item;
    }

    TreeItem _getCachedTopItem() {
        long treeSelect = GTK.gtk_tree_view_get_selection(this.handle);
        long list = GTK.gtk_tree_selection_get_selected_rows(treeSelect, null);
        TreeItem treeSelection = null;
        if (list != 0L) {
            long data;
            long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, data = OS.g_list_data(list))) {
                treeSelection = this._getItem(iter);
            }
            OS.g_free(iter);
            GTK.gtk_tree_path_free(data);
            if (this.topItem == treeSelection) {
                return this.topItem;
            }
            return treeSelection;
        }
        if (this.topItem == null) {
            TreeItem item = null;
            long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
            if (GTK.gtk_tree_model_get_iter_first(this.modelHandle, iter)) {
                item = this._getItem(iter);
            }
            OS.g_free(iter);
            return item;
        }
        return this.topItem;
    }

    @Override
    long gtk_button_press_event(long widget, long event) {
        long[] path;
        int button;
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        GDK.gdk_event_get_coords(event, eventX, eventY);
        int eventType = GDK.gdk_event_get_event_type(event);
        int[] eventButton = new int[1];
        int[] eventState = new int[1];
        GDK.gdk_event_get_button(event, eventButton);
        GDK.gdk_event_get_state(event, eventState);
        double[] eventRX = new double[1];
        double[] eventRY = new double[1];
        GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
        long eventGdkResource = this.gdk_event_get_surface_or_window(event);
        if (eventGdkResource != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && OS.isWayland() && eventType == 4) {
            long nextEvent = GDK.gdk_event_peek();
            if (nextEvent == 0L) {
                long[] path2 = new long[1];
                long selection = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)eventX[0], (int)eventY[0], path2, null, null, null) && path2[0] != 0L) {
                    this.selectionCountOnPress = this.getSelectionCount();
                    if (GTK.gtk_tree_selection_path_is_selected(selection, path2[0]) && ((eventState[0] & 5) == 0 || (eventState[0] & 4) != 0)) {
                        long gtk_false_funcPtr = GTK.GET_FUNCTION_POINTER_gtk_false();
                        GTK.gtk_tree_selection_set_select_function(selection, gtk_false_funcPtr, 0L, 0L);
                    }
                }
            } else {
                this.gdk_event_free(nextEvent);
            }
        }
        if ((button = eventButton[0]) == 3 && eventType == 4 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)eventX[0], (int)eventY[0], path = new long[1], null, null, null) && path[0] != 0L) {
            long selection = GTK.gtk_tree_view_get_selection(this.handle);
            if (GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                result = 1L;
            }
            GTK.gtk_tree_path_free(path[0]);
        }
        if ((this.style & 4) != 0 && this.getSelectionCount() == 0 && GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)eventX[0], (int)eventY[0], path = new long[1], null, null, null) && path[0] != 0L) {
            long selection = GTK.gtk_tree_view_get_selection(this.handle);
            OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_view_set_cursor(this.handle, path[0], 0L, false);
            OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            GTK.gtk_tree_path_free(path[0]);
        }
        if (eventType == 5 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
        return result;
    }

    @Override
    void gtk_gesture_press_event(long gesture, int n_press, double x, double y, long event) {
        super.gtk_gesture_press_event(gesture, n_press, x, y, event);
        if (n_press == 2 && this.rowActivated) {
            this.sendTreeDefaultSelection();
            this.rowActivated = false;
        }
    }

    @Override
    long gtk_row_activated(long tree, long path, long column) {
        this.rowActivated = true;
        return 0L;
    }

    @Override
    long gtk_key_press_event(long widget, long event) {
        int[] key = new int[1];
        if (GTK.GTK4) {
            key[0] = GDK.gdk_key_event_get_keyval(event);
        } else {
            GDK.gdk_event_get_keyval(event, key);
        }
        switch (key[0]) {
            case 65293: {
                int keymask = this.gdk_event_get_state(event);
                if ((keymask & 0x1C000008) != 0) break;
                this.sendTreeDefaultSelection();
            }
        }
        return super.gtk_key_press_event(widget, event);
    }

    void sendTreeDefaultSelection() {
        TreeItem treeItem = this.getFocusItem();
        if (treeItem == null) {
            return;
        }
        Event event = new Event();
        event.item = treeItem;
        this.sendSelectionEvent(14, event, false);
    }

    @Override
    long gtk_button_release_event(long widget, long event) {
        double[] eventX = new double[1];
        double[] eventY = new double[1];
        if (GTK.GTK4) {
            GDK.gdk_event_get_position(event, eventX, eventY);
        } else {
            GDK.gdk_event_get_coords(event, eventX, eventY);
        }
        int[] eventButton = new int[1];
        int[] eventState = new int[1];
        if (GTK.GTK4) {
            eventButton[0] = GDK.gdk_button_event_get_button(event);
            eventState[0] = GDK.gdk_event_get_modifier_state(event);
        } else {
            GDK.gdk_event_get_button(event, eventButton);
            GDK.gdk_event_get_state(event, eventState);
        }
        double[] eventRX = new double[1];
        double[] eventRY = new double[1];
        GDK.gdk_event_get_root_coords(event, eventRX, eventRY);
        long eventGdkResource = this.gdk_event_get_surface_or_window(event);
        if (GTK.GTK4 ? eventGdkResource != this.gtk_widget_get_surface(this.handle) : eventGdkResource != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        this.lastInput.x = (int)eventX[0];
        this.lastInput.y = (int)eventY[0];
        if (this.containedInRegion(this.lastInput.x, this.lastInput.y)) {
            return 0L;
        }
        if ((this.state & 0x800000) != 0 && this.hooks(29) && OS.isWayland()) {
            long[] path = new long[1];
            long selection = GTK.gtk_tree_view_get_selection(this.handle);
            GTK.gtk_tree_selection_set_select_function(selection, 0L, 0L, 0L);
            if (GTK.gtk_tree_view_get_path_at_pos(this.handle, (int)eventX[0], (int)eventY[0], path, null, null, null) && path[0] != 0L && GTK.gtk_tree_selection_path_is_selected(selection, path[0])) {
                this.selectionCountOnRelease = this.getSelectionCount();
                if ((eventState[0] & 5) == 0) {
                    GTK.gtk_tree_view_set_cursor(this.handle, path[0], 0L, false);
                }
                if ((eventState[0] & 4) != 0 && this.selectionCountOnRelease == this.selectionCountOnPress) {
                    GTK.gtk_tree_selection_unselect_path(selection, path[0]);
                }
            }
        }
        return super.gtk_button_release_event(widget, event);
    }

    @Override
    long gtk_changed(long widget) {
        TreeItem item = this.getFocusItem();
        if (item != null) {
            Event event = new Event();
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    @Override
    long gtk_expand_collapse_cursor_row(long widget, long logical, long expand, long open_all) {
        if (expand != 0L && open_all != 0L) {
            this.expandAll = true;
        }
        return 0L;
    }

    void drawInheritedBackground(long cairo) {
        Control control;
        if (((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
            long gdkResource;
            int[] width = new int[1];
            int[] height = new int[1];
            if (GTK.GTK4) {
                gdkResource = this.gtk_widget_get_surface(this.handle);
                this.gdk_surface_get_size(gdkResource, width, height);
            } else {
                gdkResource = GTK3.gtk_tree_view_get_bin_window(this.handle);
                this.gdk_window_get_size(gdkResource, width, height);
            }
            long parent = 0L;
            int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parent);
            GdkRectangle rect = new GdkRectangle();
            boolean expanded = true;
            while (itemCount != 0 && expanded && height[0] > rect.y + rect.height) {
                long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parent, itemCount - 1);
                itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, iter);
                long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
                GTK.gtk_tree_view_get_cell_area(this.handle, path, 0L, rect);
                expanded = GTK.gtk_tree_view_row_expanded(this.handle, path);
                GTK.gtk_tree_path_free(path);
                if (parent != 0L) {
                    OS.g_free(parent);
                }
                parent = iter;
            }
            if (parent != 0L) {
                OS.g_free(parent);
            }
            if (height[0] > rect.y + rect.height) {
                this.drawBackground(control, gdkResource, cairo, 0, rect.y + rect.height, width[0], height[0] - (rect.y + rect.height));
            }
        }
    }

    @Override
    long gtk_draw(long widget, long cairo) {
        boolean haveBoundsChanged = this.boundsChangedSinceLastDraw;
        this.boundsChangedSinceLastDraw = false;
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if (this.isOwnerDrawn && haveBoundsChanged) {
            GTK.gtk_widget_queue_draw(this.handle);
            return 0L;
        }
        this.drawInheritedBackground(cairo);
        return super.gtk_draw(widget, cairo);
    }

    @Override
    long gtk_motion_notify_event(long widget, long event) {
        long window;
        long surface;
        if (GTK.GTK4 ? (surface = GDK.gdk_event_get_surface(event)) != this.gtk_widget_get_surface(this.handle) : (window = GDK.GDK_EVENT_WINDOW(event)) != GTK3.gtk_tree_view_get_bin_window(this.handle)) {
            return 0L;
        }
        return super.gtk_motion_notify_event(widget, event);
    }

    @Override
    long gtk_row_has_child_toggled(long model, long path, long iter) {
        int[] index = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        if (index[0] >= this.items.length) {
            return 0L;
        }
        TreeItem item = this.items[index[0]];
        if (item == null) {
            return 0L;
        }
        int childCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, item.handle);
        if (childCount != 0 && item.isExpanded) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            GTK.gtk_tree_view_expand_row(this.handle, path, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
        }
        return 0L;
    }

    @Override
    long gtk_scroll_event(long widget, long eventPtr) {
        long result = super.gtk_scroll_event(widget, eventPtr);
        if (!this.wasScrolled) {
            this.wasScrolled = true;
        }
        return result;
    }

    @Override
    long gtk_start_interactive_search(long widget) {
        if (!this.searchEnabled()) {
            OS.g_signal_stop_emission_by_name(widget, OS.start_interactive_search);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_test_collapse_row(long tree, long iter, long path) {
        int[] index = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        TreeItem item = this.items[index[0]];
        Event event = new Event();
        event.item = item;
        boolean oldModelChanged = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(18, event);
        boolean changed = this.modelChanged || !GTK.gtk_tree_view_row_expanded(this.handle, path);
        this.modelChanged = oldModelChanged;
        if (this.isDisposed() || item.isDisposed()) {
            return 1L;
        }
        item.isExpanded = false;
        if (changed) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 50L);
            GTK.gtk_tree_view_collapse_row(this.handle, path);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 50L);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_test_expand_row(long tree, long iter, long path) {
        int[] index = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
        TreeItem item = this.items[index[0]];
        Event event = new Event();
        event.item = item;
        boolean oldModelChanged = this.modelChanged;
        this.modelChanged = false;
        this.sendEvent(17, event);
        boolean changed = this.modelChanged || GTK.gtk_tree_view_row_expanded(this.handle, path);
        this.modelChanged = oldModelChanged;
        if (this.isDisposed() || item.isDisposed()) {
            return 1L;
        }
        item.isExpanded = true;
        if (changed || this.expandAll) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            GTK.gtk_tree_view_expand_row(this.handle, path, false);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 51L);
            return 1L;
        }
        return 0L;
    }

    @Override
    long gtk_toggled(long renderer, long pathStr) {
        long path = GTK.gtk_tree_path_new_from_string(pathStr);
        if (path == 0L) {
            return 0L;
        }
        TreeItem item = null;
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (GTK.gtk_tree_model_get_iter(this.modelHandle, iter, path)) {
            item = this._getItem(iter);
        }
        OS.g_free(iter);
        GTK.gtk_tree_path_free(path);
        if (item != null) {
            item.setChecked(!item.getChecked());
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            this.sendSelectionEvent(13, event, false);
        }
        return 0L;
    }

    @Override
    void gtk_widget_get_preferred_size(long widget, GtkRequisition requisition) {
        boolean fixVisible;
        long columns;
        if (this.columnCount == 0) {
            super.gtk_widget_get_preferred_size(widget, requisition);
            return;
        }
        long list = columns = GTK.gtk_tree_view_get_columns(this.handle);
        boolean bl = fixVisible = columns != 0L;
        while (list != 0L) {
            long column = OS.g_list_data(list);
            if (GTK.gtk_tree_view_column_get_visible(column)) {
                fixVisible = false;
                break;
            }
            list = OS.g_list_next(list);
        }
        long columnHandle = 0L;
        if (fixVisible) {
            columnHandle = OS.g_list_data(columns);
            GTK.gtk_tree_view_column_set_visible(columnHandle, true);
        }
        super.gtk_widget_get_preferred_size(widget, requisition);
        if (fixVisible) {
            GTK.gtk_tree_view_column_set_visible(columnHandle, false);
        }
        if (columns != 0L) {
            OS.g_list_free(columns);
        }
    }

    void hideFirstColumn() {
        long firstColumn = GTK.gtk_tree_view_get_column(this.handle, 0);
        GTK.gtk_tree_view_column_set_visible(firstColumn, false);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_connect_closure(selection, OS.changed, this.display.getClosure(6), false);
        OS.g_signal_connect_closure(this.handle, OS.row_activated, this.display.getClosure(41), false);
        OS.g_signal_connect_closure(this.handle, OS.test_expand_row, this.display.getClosure(51), false);
        OS.g_signal_connect_closure(this.handle, OS.test_collapse_row, this.display.getClosure(50), false);
        OS.g_signal_connect_closure(this.handle, OS.expand_collapse_cursor_row, this.display.getClosure(17), false);
        OS.g_signal_connect_closure(this.modelHandle, OS.row_has_child_toggled, this.display.getClosure(84), false);
        if (this.checkRenderer != 0L) {
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        OS.g_signal_connect_closure(this.handle, OS.start_interactive_search, this.display.getClosure(69), false);
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != column) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        long indices;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int index = -1;
        long path = GTK.gtk_tree_model_get_path(this.modelHandle, item.handle);
        int depth = GTK.gtk_tree_path_get_depth(path);
        if (depth == 1 && (indices = GTK.gtk_tree_path_get_indices(path)) != 0L) {
            int[] temp = new int[1];
            C.memmove(temp, indices, 4L);
            index = temp[0];
        }
        GTK.gtk_tree_path_free(path);
        return index;
    }

    @Override
    boolean mnemonicHit(char key) {
        for (int i = 0; i < this.columnCount; ++i) {
            long labelHandle = this.columns[i].labelHandle;
            if (labelHandle == 0L || !this.mnemonicHit(labelHandle, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        for (int i = 0; i < this.columnCount; ++i) {
            long labelHandle = this.columns[i].labelHandle;
            if (labelHandle == 0L || !this.mnemonicMatch(labelHandle, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    long paintWindow() {
        GTK.gtk_widget_realize(this.handle);
        return GTK3.gtk_tree_view_get_bin_window(this.handle);
    }

    @Override
    void propagateDraw(long container, long cairo) {
        super.propagateDraw(container, cairo);
        if (this.headerVisible && this.noChildDrawing && this.wasScrolled) {
            for (TreeColumn column : this.columns) {
                if (column == null) continue;
                GTK.gtk_widget_queue_draw(column.buttonHandle);
            }
            this.wasScrolled = false;
        }
    }

    void recreateRenderers() {
        if (this.checkRenderer != 0L) {
            this.display.removeWidget(this.checkRenderer);
            OS.g_object_unref(this.checkRenderer);
            long l = this.checkRenderer = this.isOwnerDrawn ? OS.g_object_new(this.display.gtk_cell_renderer_toggle_get_type(), 0L) : GTK.gtk_cell_renderer_toggle_new();
            if (this.checkRenderer == 0L) {
                this.error(2);
            }
            OS.g_object_ref(this.checkRenderer);
            this.display.addWidget(this.checkRenderer, this);
            OS.g_signal_connect_closure(this.checkRenderer, OS.toggled, this.display.getClosure(53), false);
        }
        if (this.columnCount == 0) {
            this.createRenderers(GTK.gtk_tree_view_get_column(this.handle, 0), 6, true, 0);
        } else {
            for (int i = 0; i < this.columnCount; ++i) {
                TreeColumn column = this.columns[i];
                this.createRenderers(column.handle, column.modelIndex, i == 0, column.style);
            }
        }
    }

    @Override
    void redrawBackgroundImage() {
        Control control = this.findBackgroundControl();
        if (control != null && control.backgroundImage != null) {
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(GTK.gtk_tree_view_get_selection(this.handle), this);
        if (this.checkRenderer != 0L) {
            this.display.addWidget(this.checkRenderer, this);
        }
        this.display.addWidget(this.modelHandle, this);
    }

    void releaseItem(TreeItem item, boolean release) {
        int[] index = new int[1];
        GTK.gtk_tree_model_get(this.modelHandle, item.handle, 0, index, -1);
        if (index[0] == -1) {
            return;
        }
        if (release) {
            item.release(false);
        }
        this.items[index[0]] = null;
    }

    void releaseItems(long parentIter) {
        int[] index = new int[1];
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        boolean valid = GTK.gtk_tree_model_iter_children(this.modelHandle, iter, parentIter);
        while (valid) {
            this.releaseItems(iter);
            if (!this.isDisposed()) {
                TreeItem item;
                GTK.gtk_tree_model_get(this.modelHandle, iter, 0, index, -1);
                if (index[0] != -1 && (item = this.items[index[0]]) != null) {
                    this.releaseItem(item, true);
                }
            }
            valid = GTK.gtk_tree_model_iter_next(this.modelHandle, iter);
        }
        OS.g_free(iter);
    }

    @Override
    void releaseChildren(boolean destroy) {
        int i;
        if (this.items != null) {
            for (i = 0; i < this.items.length; ++i) {
                TreeItem item = this.items[i];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.items = null;
        }
        if (this.columns != null) {
            for (i = 0; i < this.columnCount; ++i) {
                TreeColumn column = this.columns[i];
                if (column == null || column.isDisposed()) continue;
                column.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.modelHandle != 0L) {
            OS.g_object_unref(this.modelHandle);
        }
        this.modelHandle = 0L;
        if (this.checkRenderer != 0L) {
            OS.g_object_unref(this.checkRenderer);
        }
        this.checkRenderer = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        if (this.headerImageList != null) {
            this.headerImageList.dispose();
        }
        this.headerImageList = null;
        this.imageList = null;
        this.currentItem = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(long parentIter, int start, int end) {
        if (start > end) {
            return;
        }
        int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (0 > start || start > end || end >= itemCount) {
            this.error(6);
        }
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        long iter = OS.g_malloc(GTK.GtkTreeIter_sizeof());
        if (iter == 0L) {
            this.error(2);
        }
        try {
            for (int i = start; i <= end; ++i) {
                TreeItem item;
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iter, parentIter, start);
                int[] value = new int[1];
                GTK.gtk_tree_model_get(this.modelHandle, iter, 0, value, -1);
                TreeItem treeItem = item = value[0] != -1 ? this.items[value[0]] : null;
                if (item != null && !item.isDisposed()) {
                    if (item.settingData) {
                        this.throwCannotRemoveItem(i);
                    }
                    item.dispose();
                    continue;
                }
                OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
                GTK.gtk_tree_store_remove(this.modelHandle, iter);
                OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
            }
        }
        finally {
            OS.g_free(iter);
        }
    }

    public void removeAll() {
        this.checkWidget();
        this.checkSetDataInProcessBeforeRemoval();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_store_clear(this.modelHandle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        for (int i = 0; i < this.items.length; ++i) {
            TreeItem item = this.items[i];
            if (item == null || item.isDisposed()) continue;
            item.release(false);
        }
        this.items = new TreeItem[4];
        if (!this.searchEnabled()) {
            GTK.gtk_tree_view_set_search_column(this.handle, -1);
        } else {
            int firstColumn = this.columnCount == 0 ? 6 : this.columns[0].modelIndex;
            GTK.gtk_tree_view_set_search_column(this.handle, firstColumn + 1);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    void sendMeasureEvent(long cell, long width, long height) {
        if (!this.ignoreSize && GTK.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(41)) {
            long iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
            TreeItem item = null;
            if (iter != 0L) {
                item = this._getItem(iter);
            }
            if (item != null && !item.isDisposed()) {
                int columnIndex = 0;
                if (this.columnCount > 0) {
                    long columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
                    for (int i = 0; i < this.columnCount; ++i) {
                        if (this.columns[i].handle != columnHandle) continue;
                        columnIndex = i;
                        break;
                    }
                }
                int[] contentWidth = new int[1];
                int[] contentHeight = new int[1];
                if (width != 0L) {
                    C.memmove(contentWidth, width, 4L);
                }
                if (height != 0L) {
                    C.memmove(contentHeight, height, 4L);
                }
                GTK.gtk_cell_renderer_get_preferred_height_for_width(cell, this.handle, contentWidth[0], contentHeight, null);
                Image image = item.getImage(columnIndex);
                int imageWidth = 0;
                if (image != null && !image.isDisposed()) {
                    Rectangle bounds = DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
                    bounds = image.getBounds();
                    imageWidth = bounds.width;
                }
                contentWidth[0] = contentWidth[0] + imageWidth;
                GC gc = new GC(this);
                gc.setFont(item.getFont(columnIndex));
                Event event = new Event();
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                Rectangle eventRect = new Rectangle(0, 0, contentWidth[0], contentHeight[0]);
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
                long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
                long selection = GTK.gtk_tree_view_get_selection(this.handle);
                if (GTK.gtk_tree_selection_path_is_selected(selection, path)) {
                    event.detail = 2;
                }
                GTK.gtk_tree_path_free(path);
                this.sendEvent(41, event);
                gc.dispose();
                Rectangle rect = DPIUtil.autoScaleUp(event.getBounds());
                contentWidth[0] = rect.width - imageWidth;
                if (contentHeight[0] < rect.height) {
                    contentHeight[0] = rect.height;
                }
                if (width != 0L) {
                    C.memmove(width, contentWidth, 4L);
                }
                if (height != 0L) {
                    C.memmove(height, contentHeight, 4L);
                }
                GTK.gtk_cell_renderer_set_fixed_size(cell, -1, contentHeight[0]);
            }
        }
    }

    @Override
    long rendererGetPreferredWidthProc(long cell, long handle, long minimun_size, long natural_size) {
        long g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        OS.call(klass.get_preferred_width, cell, handle, minimun_size, natural_size);
        this.sendMeasureEvent(cell, minimun_size, 0L);
        return 0L;
    }

    @Override
    long rendererSnapshotProc(long cell, long snapshot, long widget, long background_area, long cell_area, long flags) {
        long rect = Graphene.graphene_rect_alloc();
        GdkRectangle gdkRectangle = new GdkRectangle();
        OS.memmove(gdkRectangle, background_area, (long)GdkRectangle.sizeof);
        Graphene.graphene_rect_init(rect, gdkRectangle.x, gdkRectangle.y, gdkRectangle.width, gdkRectangle.height);
        long cairo = GTK4.gtk_snapshot_append_cairo(snapshot, rect);
        this.rendererRender(cell, cairo, snapshot, widget, background_area, cell_area, 0L, flags);
        return 0L;
    }

    @Override
    long rendererRenderProc(long cell, long cr, long widget, long background_area, long cell_area, long flags) {
        this.rendererRender(cell, cr, 0L, widget, background_area, cell_area, 0L, flags);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rendererRender(long cell, long cr, long snapshot, long widget, long background_area, long cell_area, long expose_area, long flags) {
        TreeItem item = null;
        boolean wasSelected = false;
        long iter = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX2);
        if (iter != 0L) {
            item = this._getItem(iter);
        }
        long columnHandle = OS.g_object_get_qdata(cell, Display.SWT_OBJECT_INDEX1);
        int columnIndex = 0;
        if (this.columnCount > 0) {
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].handle != columnHandle) continue;
                columnIndex = i;
                break;
            }
        }
        GdkRectangle rendererRect = new GdkRectangle();
        GdkRectangle columnRect = new GdkRectangle();
        OS.memmove(rendererRect, background_area, (long)GdkRectangle.sizeof);
        long path = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
        GTK.gtk_tree_view_get_background_area(this.handle, path, columnHandle, columnRect);
        GTK.gtk_tree_path_free(path);
        int y_offset = columnRect.y - rendererRect.y;
        columnRect.y -= y_offset;
        if (item != null && (GTK.GTK_IS_CELL_RENDERER_TOGGLE(cell) || columnIndex != 0 || (this.style & 0x20) == 0)) {
            long textRenderer;
            Control control;
            this.drawFlags = (int)flags;
            this.drawState = 16;
            long[] ptr = new long[1];
            GTK.gtk_tree_model_get(this.modelHandle, item.handle, 4, ptr, -1);
            if (ptr[0] == 0L) {
                int modelIndex = this.columnCount == 0 ? 6 : this.columns[columnIndex].modelIndex;
                GTK.gtk_tree_model_get(this.modelHandle, item.handle, modelIndex + 3, ptr, -1);
            }
            if (ptr[0] != 0L) {
                this.drawState |= 8;
                GDK.gdk_rgba_free(ptr[0]);
            }
            if ((flags & 1L) != 0L) {
                this.drawState |= 2;
            }
            if ((flags & 1L) == 0L && (flags & 0x10L) != 0L) {
                this.drawState |= 4;
            }
            Rectangle rect = columnRect.toRectangle();
            if (cr != 0L) {
                GdkRectangle r2 = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(cr, r2);
                rect.x = r2.x;
                rect.width = r2.width;
            }
            if ((this.drawState & 2) == 0 && ((this.state & 0x8000) != 0 || this.backgroundImage != null) && (control = this.findBackgroundControl()) != null) {
                if (cr != 0L) {
                    Cairo.cairo_save(cr);
                }
                this.drawBackground(control, 0L, cr, rect.x, rect.y, rect.width, rect.height);
                if (cr != 0L) {
                    Cairo.cairo_restore(cr);
                }
            }
            if ((textRenderer = this.getTextRenderer(columnHandle)) != 0L) {
                this.gtk_cell_renderer_get_preferred_size(textRenderer, this.handle, null, null);
            }
            if (this.hooks(40)) {
                Control control2;
                Cairo.cairo_save(cr);
                boolean bl = wasSelected = (this.drawState & 2) != 0;
                if (wasSelected && (control2 = this.findBackgroundControl()) == null) {
                    control2 = this;
                }
                GC gc = this.getGC(cr);
                if ((this.drawState & 2) != 0) {
                    gc.setBackground(this.display.getSystemColor(26));
                    gc.setForeground(this.display.getSystemColor(27));
                } else {
                    gc.setBackground(item.getBackground(columnIndex));
                    gc.setForeground(item.getForeground(columnIndex));
                }
                gc.setFont(item.getFont(columnIndex));
                if ((this.style & 0x8000000) != 0) {
                    rect.x = this.getClientWidth() - rect.width - rect.x;
                }
                if (cr != 0L) {
                    rect2 = DPIUtil.autoScaleDown(rect);
                    gc.setClipping(rect2.x, rect2.y, rect2.width, rect2.height);
                } else {
                    rect2 = DPIUtil.autoScaleDown(rect);
                    gc.setClipping(rect2.x, rect2.y, rect2.width, rect2.height);
                }
                Event event = new Event();
                try {
                    Rectangle eventRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
                    eventRect.y += y_offset;
                    Cairo.cairo_translate(cr, 0.0, -y_offset);
                    event.item = item;
                    event.index = columnIndex;
                    event.gc = gc;
                    event.detail = this.drawState;
                    event.setBounds(DPIUtil.autoScaleDown(eventRect));
                    this.sendEvent(40, event);
                }
                finally {
                    Cairo.cairo_translate(cr, 0.0, y_offset);
                }
                this.drawForegroundRGBA = null;
                this.drawState = event.doit ? event.detail : 0;
                this.drawFlags &= 0xFFFFFFEE;
                if ((this.drawState & 2) != 0) {
                    this.drawFlags |= 1;
                }
                if ((this.drawState & 4) != 0) {
                    this.drawFlags |= 0x10;
                }
                if ((this.drawState & 2) == 0 && wasSelected) {
                    this.drawForegroundRGBA = gc.getForeground().handle;
                }
                gc.dispose();
                Cairo.cairo_restore(cr);
            }
        }
        if ((this.drawState & 8) != 0 && (this.drawState & 2) == 0) {
            GC gc = this.getGC(cr);
            gc.setBackground(item.getBackground(columnIndex));
            gc.fillRectangle(DPIUtil.autoScaleDown(rendererRect.toRectangle()));
            gc.dispose();
        }
        if ((this.drawState & 0x10) != 0 || GTK.GTK_IS_CELL_RENDERER_TOGGLE(cell)) {
            long g_class = OS.g_type_class_peek_parent(OS.G_OBJECT_GET_CLASS(cell));
            GtkCellRendererClass klass = new GtkCellRendererClass();
            OS.memmove(klass, g_class);
            if (GTK.GTK_IS_CELL_RENDERER_TEXT(cell)) {
                GdkRGBA rgba = this.foreground != null ? this.foreground : this.display.getSystemColor((int)24).handle;
                OS.g_object_set(cell, OS.foreground_rgba, rgba, 0L);
            }
            if (GTK.GTK4) {
                OS.call(klass.snapshot, cell, snapshot, widget, background_area, cell_area, this.drawFlags);
            } else {
                OS.call(klass.render, cell, cr, widget, background_area, cell_area, this.drawFlags);
            }
        }
        if (item != null && GTK.GTK_IS_CELL_RENDERER_TEXT(cell) && this.hooks(42)) {
            if (wasSelected) {
                this.drawState |= 2;
            }
            Rectangle rect = columnRect.toRectangle();
            this.ignoreSize = true;
            int[] contentX = new int[1];
            int[] contentWidth = new int[1];
            this.gtk_cell_renderer_get_preferred_size(cell, this.handle, contentWidth, null);
            this.gtk_tree_view_column_cell_get_position(columnHandle, cell, contentX, null);
            this.ignoreSize = false;
            Image image = item.getImage(columnIndex);
            int imageWidth = 0;
            if (image != null) {
                Rectangle bounds = DPIUtil.useCairoAutoScale() ? image.getBounds() : image.getBoundsInPixels();
                imageWidth = bounds.width;
            }
            if (cr != 0L) {
                rect.x -= imageWidth;
                rect.width += imageWidth;
            }
            contentX[0] = contentX[0] - imageWidth;
            contentWidth[0] = contentWidth[0] + imageWidth;
            if (GTK.gtk_tree_view_get_expander_column(this.handle) == columnHandle) {
                GdkRectangle rect3 = new GdkRectangle();
                GTK.gtk_widget_realize(this.handle);
                long path2 = GTK.gtk_tree_model_get_path(this.modelHandle, iter);
                GTK.gtk_tree_view_get_cell_area(this.handle, path2, columnHandle, rect3);
                GTK.gtk_tree_path_free(path2);
                contentX[0] = contentX[0] + rect3.x;
            }
            GC gc = this.getGC(cr);
            if ((this.drawState & 2) != 0) {
                Color background = this.display.getSystemColor(26);
                Color foreground = this.display.getSystemColor(27);
                gc.setBackground(background);
                gc.setForeground(foreground);
            } else {
                gc.setBackground(item.getBackground(columnIndex));
                Color foreground = this.drawForegroundRGBA != null ? Color.gtk_new(this.display, this.drawForegroundRGBA) : item.getForeground(columnIndex);
                gc.setForeground(foreground);
            }
            gc.setFont(item.getFont(columnIndex));
            if ((this.style & 0x8000000) != 0) {
                rect.x = this.getClientWidth() - rect.width - rect.x;
            }
            Rectangle rect2 = DPIUtil.autoScaleDown(rect);
            gc.setClipping(rect2.x, rect2.y, rect2.width, rect2.height);
            Event event = new Event();
            try {
                Rectangle eventRect = new Rectangle(rect.x + contentX[0], rect.y, contentWidth[0], rect.height);
                eventRect.y += y_offset;
                Cairo.cairo_translate(cr, 0.0, -y_offset);
                event.item = item;
                event.index = columnIndex;
                event.gc = gc;
                event.detail = this.drawState;
                event.setBounds(DPIUtil.autoScaleDown(eventRect));
                this.sendEvent(42, event);
            }
            finally {
                Cairo.cairo_translate(cr, 0.0, y_offset);
            }
            gc.dispose();
        }
    }

    private GC getGC(long cr) {
        GCData gcData = new GCData();
        gcData.cairo = cr;
        GC gc = GC.gtk_new(this, gcData);
        return gc;
    }

    void resetCustomDraw() {
        if ((this.style & 0x10000000) != 0 || this.isOwnerDrawn) {
            return;
        }
        int end = Math.max(1, this.columnCount);
        for (int i = 0; i < end; ++i) {
            boolean customDraw;
            boolean bl = customDraw = this.columnCount != 0 ? this.columns[i].customDraw : this.firstCustomDraw;
            if (!customDraw) continue;
            long column = GTK.gtk_tree_view_get_column(this.handle, i);
            long textRenderer = this.getTextRenderer(column);
            GTK.gtk_tree_view_column_set_cell_data_func(column, textRenderer, 0L, 0L, 0L);
            if (this.columnCount == 0) continue;
            this.columns[i].customDraw = false;
        }
        this.firstCustomDraw = false;
    }

    @Override
    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            for (i = 0; i < this.items.length; ++i) {
                TreeItem item = this.items[i];
                if (item == null) continue;
                item.reskinChildren(flags);
            }
        }
        if (this.columns != null) {
            for (i = 0; i < this.columns.length; ++i) {
                TreeColumn column = this.columns[i];
                if (column == null) continue;
                column.reskinChildren(flags);
            }
        }
        super.reskinChildren(flags);
    }

    boolean searchEnabled() {
        return (this.style & 0x10000000) == 0;
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item == null) {
            GTK.gtk_tree_view_set_drag_dest_row(this.handle, 0L, 0);
            return;
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        Rectangle rect = item.getBoundsInPixels();
        long[] path = new long[1];
        GTK.gtk_widget_realize(this.handle);
        if (!GTK.gtk_tree_view_get_path_at_pos(this.handle, rect.x, rect.y, path, null, null, null)) {
            return;
        }
        if (path[0] == 0L) {
            return;
        }
        int position = before ? 0 : 1;
        GTK.gtk_tree_view_set_drag_dest_row(this.handle, path[0], position);
        GTK.gtk_tree_path_free(path[0]);
    }

    void setItemCount(long parentIter, int count) {
        boolean isVirtual;
        int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, parentIter);
        if (count == itemCount) {
            return;
        }
        boolean bl = isVirtual = (this.style & 0x10000000) != 0;
        if (!isVirtual) {
            this.setRedraw(false);
        }
        if (parentIter == 0L && count == 0) {
            this.removeAll();
        } else {
            this.remove(parentIter, count, itemCount - 1);
        }
        if (isVirtual) {
            long iterInsertAfter;
            long iters = OS.g_malloc(2 * GTK.GtkTreeIter_sizeof());
            if (iters == 0L) {
                this.error(2);
            }
            long iterResult = iters;
            if (itemCount != 0) {
                iterInsertAfter = iters + (long)GTK.GtkTreeIter_sizeof();
                GTK.gtk_tree_model_iter_nth_child(this.modelHandle, iterInsertAfter, parentIter, itemCount - 1);
            } else {
                iterInsertAfter = 0L;
            }
            for (int i = itemCount; i < count; ++i) {
                GTK.gtk_tree_store_insert_after(this.modelHandle, iterResult, parentIter, iterInsertAfter);
                GTK.gtk_tree_store_set(this.modelHandle, iterResult, 0, -1, -1);
            }
            OS.g_free(iters);
        } else {
            for (int i = itemCount; i < count; ++i) {
                new TreeItem(this, parentIter, 0, itemCount, 0L);
            }
        }
        if (!isVirtual) {
            this.setRedraw(true);
        }
        this.modelChanged = true;
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        this.setItemCount(0L, count);
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_select_iter(selection, item.handle);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        GTK.gtk_tree_selection_select_all(selection);
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    @Override
    void setBackgroundGdkRGBA(long context, long handle, GdkRGBA rgba) {
        this.background = rgba == null ? this.defaultBackground() : rgba;
        GdkRGBA selectedBackground = this.display.getSystemColor((int)26).handle;
        String css = "treeview {background-color: " + this.display.gtk_rgba_to_css_string(this.background) + ";}\ntreeview:selected {background-color: " + this.display.gtk_rgba_to_css_string(selectedBackground) + ";}";
        this.cssBackground = css;
        String finalCss = this.display.gtk_css_create_css_color_string(this.cssBackground, this.cssForeground, 8);
        this.gtk_css_provider_load_from_css(context, finalCss);
    }

    @Override
    void setBackgroundSurface(Image image) {
        this.isOwnerDrawn = true;
        this.recreateRenderers();
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        if (result != 0) {
            this.boundsChangedSinceLastDraw = true;
        }
        GTK.gtk_widget_realize(this.handle);
        return result;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length > 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        boolean[] seen = new boolean[this.columnCount];
        for (int i = 0; i < order.length; ++i) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(6);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
        }
        long baseColumn = 0L;
        for (int i = 0; i < order.length; ++i) {
            long column = this.columns[order[i]].handle;
            GTK.gtk_tree_view_move_column_after(this.handle, column, baseColumn);
            baseColumn = column;
        }
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        TreeColumn[] columns = this.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i] == null) continue;
            columns[i].setFontDescription(font);
        }
    }

    @Override
    void setForegroundGdkRGBA(GdkRGBA rgba) {
        this.foreground = rgba;
        GdkRGBA toSet = rgba == null ? this.display.COLOR_LIST_FOREGROUND_RGBA : rgba;
        this.setForegroundGdkRGBA(this.handle, toSet);
    }

    public void setHeaderBackground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerBackground)) {
                return;
            }
        }
        this.headerBackground = color;
        this.updateHeaderCSS();
    }

    void updateHeaderCSS() {
        StringBuilder css = new StringBuilder("button {");
        if (this.headerBackground != null) {
            css.append("background: " + this.display.gtk_rgba_to_css_string(this.headerBackground.handle) + "; ");
        }
        if (this.headerForeground != null) {
            css.append("color: " + this.display.gtk_rgba_to_css_string(this.headerForeground.handle) + "; ");
        }
        css.append("}\n");
        if (this.columnCount == 0) {
            long buttonHandle = GTK.gtk_tree_view_column_get_button(GTK.gtk_tree_view_get_column(this.handle, 0));
            if (this.headerCSSProvider == 0L) {
                this.headerCSSProvider = GTK.gtk_css_provider_new();
                GTK.gtk_style_context_add_provider(GTK.gtk_widget_get_style_context(buttonHandle), this.headerCSSProvider, 600);
            }
            if (GTK.GTK4) {
                GTK4.gtk_css_provider_load_from_data(this.headerCSSProvider, Converter.javaStringToCString(css.toString()), -1L);
            } else {
                GTK3.gtk_css_provider_load_from_data(this.headerCSSProvider, Converter.javaStringToCString(css.toString()), -1L, null);
            }
        } else {
            for (TreeColumn column : this.columns) {
                if (column == null) continue;
                column.setHeaderCSS(css.toString());
            }
        }
    }

    public void setHeaderForeground(Color color) {
        this.checkWidget();
        if (color != null) {
            if (color.isDisposed()) {
                this.error(5);
            }
            if (color.equals(this.headerForeground)) {
                return;
            }
        }
        this.headerForeground = color;
        this.updateHeaderCSS();
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        GTK.gtk_tree_view_set_headers_visible(this.handle, show);
        this.headerHeight = this.getHeaderHeight();
        this.headerVisible = show;
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        GTK.gtk_tree_view_set_grid_lines(this.handle, show ? 2 : 0);
    }

    void setModel(long newModel) {
        this.display.removeWidget(this.modelHandle);
        OS.g_object_unref(this.modelHandle);
        this.modelHandle = newModel;
        this.display.addWidget(this.modelHandle, this);
    }

    @Override
    void setOrientation(boolean create) {
        int i;
        super.setOrientation(create);
        if (this.items != null) {
            for (i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                this.items[i].setOrientation(create);
            }
        }
        if (this.columns != null) {
            for (i = 0; i < this.columns.length; ++i) {
                if (this.columns[i] == null) continue;
                this.columns[i].setOrientation(create);
            }
        }
    }

    @Override
    void setParentBackground() {
        this.isOwnerDrawn = true;
        this.recreateRenderers();
    }

    @Override
    void setParentGdkResource(Control child) {
        if (!GTK.GTK4) {
            long parentGdkWindow = this.eventWindow();
            GTK3.gtk_widget_set_parent_window(child.topHandle(), parentGdkWindow);
            this.hasChildren = true;
            this.connectFixedHandleDraw();
        }
    }

    void setScrollWidth(long column, TreeItem item) {
        int itemWidth;
        if (this.columnCount != 0 || this.currentItem == item) {
            return;
        }
        int width = GTK.gtk_tree_view_column_get_fixed_width(column);
        if (width < (itemWidth = this.calculateWidth(column, item.handle, true))) {
            GTK.gtk_tree_view_column_set_fixed_width(column, itemWidth);
        }
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        boolean fixColumn = this.showFirstColumn();
        long selection = GTK.gtk_tree_view_get_selection(this.handle);
        OS.g_signal_handlers_block_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        boolean first = true;
        for (int i = 0; i < length; ++i) {
            TreeItem item = items[i];
            if (item == null) continue;
            if (item.isDisposed()) break;
            if (item.parent != this) continue;
            long path = GTK.gtk_tree_model_get_path(this.modelHandle, item.handle);
            this.showItem(path, false);
            if (first) {
                GTK.gtk_tree_view_set_cursor(this.handle, path, 0L, false);
            }
            GTK.gtk_tree_selection_select_iter(selection, item.handle);
            GTK.gtk_tree_path_free(path);
            first = false;
        }
        OS.g_signal_handlers_unblock_matched(selection, 16, 0, 0, 0L, 0L, 6L);
        if (fixColumn) {
            this.hideFirstColumn();
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        }
        this.sortColumn = column;
        if (this.sortColumn != null && this.sortDirection != 0) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            GTK.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        if (this.sortDirection == 0) {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, false);
        } else {
            GTK.gtk_tree_view_column_set_sort_indicator(this.sortColumn.handle, true);
            GTK.gtk_tree_view_column_set_sort_order(this.sortColumn.handle, this.sortDirection == 1024 ? 0 : 1);
        }
    }

    public void setTopItem(TreeItem item) {
        long vAdjustment = GTK.gtk_scrollable_get_vadjustment(this.handle);
        this.cachedAdjustment = GTK.gtk_adjustment_get_value(vAdjustment);
        this.topItem = item;
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        long path = GTK.gtk_tree_model_get_path(this.modelHandle, item.handle);
        this.showItem(path, false);
        GTK.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, true, 0.0f, 0.0f);
        GTK.gtk_tree_path_free(path);
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        GTK.gtk_tree_view_scroll_to_cell(this.handle, 0L, column.handle, false, 0.0f, 0.0f);
    }

    boolean showFirstColumn() {
        int columnCount = Math.max(1, this.columnCount);
        for (int i = 0; i < columnCount; ++i) {
            long column = GTK.gtk_tree_view_get_column(this.handle, i);
            if (!GTK.gtk_tree_view_column_get_visible(column)) continue;
            return false;
        }
        long firstColumn = GTK.gtk_tree_view_get_column(this.handle, 0);
        GTK.gtk_tree_view_column_set_visible(firstColumn, true);
        return true;
    }

    public void showSelection() {
        this.checkWidget();
        TreeItem[] items = this.getSelection();
        if (items.length != 0 && items[0] != null) {
            this.showItem(items[0]);
        }
    }

    void showItem(long path, boolean scroll) {
        int depth = GTK.gtk_tree_path_get_depth(path);
        if (depth > 1) {
            int[] indices = new int[depth - 1];
            long indicesPtr = GTK.gtk_tree_path_get_indices(path);
            C.memmove(indices, indicesPtr, (long)(indices.length * 4));
            long tempPath = GTK.gtk_tree_path_new();
            for (int i = 0; i < indices.length; ++i) {
                GTK.gtk_tree_path_append_index(tempPath, indices[i]);
                GTK.gtk_tree_view_expand_row(this.handle, tempPath, false);
            }
            GTK.gtk_tree_path_free(tempPath);
        }
        if (scroll) {
            GTK.gtk_tree_view_scroll_to_cell(this.handle, path, 0L, false, 0.5f, 0.0f);
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        long path = GTK.gtk_tree_model_get_path(this.modelHandle, item.handle);
        this.showItem(path, true);
        GTK.gtk_tree_path_free(path);
    }

    @Override
    void updateScrollBarValue(ScrollBar bar) {
        super.updateScrollBarValue(bar);
        if (!GTK.GTK4) {
            long parentHandle = this.parentingHandle();
            long list = GTK3.gtk_container_get_children(parentHandle);
            if (list == 0L) {
                return;
            }
            long temp = list;
            while (temp != 0L) {
                long widget = OS.g_list_data(temp);
                if (widget != 0L) {
                    GTK.gtk_widget_queue_resize(widget);
                }
                temp = OS.g_list_next(temp);
            }
            OS.g_list_free(list);
        }
    }

    @Override
    long windowProc(long handle, long arg0, long user_data) {
        switch ((int)user_data) {
            case 18: {
                if (!this.hasChildren) break;
                if (this.headerVisible) {
                    this.noChildDrawing = true;
                }
                this.propagateDraw(handle, arg0);
                break;
            }
            case 19: {
                long window;
                Control control;
                int itemCount = GTK.gtk_tree_model_iter_n_children(this.modelHandle, 0L);
                if (itemCount != 0 || (this.state & 0x40) != 0 || (this.state & 0x8000) == 0 && this.backgroundImage == null || (control = this.findBackgroundControl()) == null || (window = GTK3.gtk_tree_view_get_bin_window(handle)) != GTK3.gtk_widget_get_window(handle)) break;
                GdkRectangle rect = new GdkRectangle();
                GDK.gdk_cairo_get_clip_rectangle(arg0, rect);
                this.drawBackground(control, window, arg0, rect.x, rect.y, rect.width, rect.height);
                break;
            }
        }
        return super.windowProc(handle, arg0, user_data);
    }

    @Override
    Point resizeCalculationsGTK3(long widget, int width, int height) {
        int hScrollBarHeight;
        Point sizes = super.resizeCalculationsGTK3(widget, width, height);
        if (widget == this.scrolledHandle && this.getHeaderVisible() && (hScrollBarHeight = this.hScrollBarWidth()) > 0) {
            sizes.y = Math.max(sizes.y, this.getHeaderHeight() + hScrollBarHeight + this.getBorderWidth() * 2);
        }
        return sizes;
    }

    void checkSetDataInProcessBeforeRemoval() {
        for (int i = 0; i < this.items.length; ++i) {
            TreeItem item = this.items[i];
            if (item == null || !item.settingData) continue;
            this.throwCannotRemoveItem(i);
        }
    }

    private void throwCannotRemoveItem(int i) {
        String message = "Cannot remove item with index " + i + ".";
        throw new SWTException(message);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.headerCSSProvider != 0L) {
            OS.g_object_unref(this.headerCSSProvider);
            this.headerCSSProvider = 0L;
        }
    }
}

