#include <shared/system.h>
#include <shared/debug.h>
#include "SettingsUI.h"
#include "commands.h"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

SettingsUI::SettingsUI()
    : cst(nullptr)
    , command_table(nullptr) {
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

SettingsUI::SettingsUI(const CommandTable2 *command_table_)
    : cst(new CommandStateTable)
    , command_table(command_table_) {
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

SettingsUI::~SettingsUI() {
    delete this->cst;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

const std::string &SettingsUI::GetName() const {
    return m_name;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

void SettingsUI::SetName(std::string name) {
    m_name = std::move(name);
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

uint32_t SettingsUI::GetExtraImGuiWindowFlags() const {
    return 0;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

ImVec2 SettingsUI::GetDefaultSize() const {
    return m_default_size;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

void SettingsUI::SetDefaultSize(ImVec2 default_size) {
    ASSERT(m_default_size.x == 0 && m_default_size.y == 0);
    m_default_size = default_size;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
