#include <shared/system.h>
#include <shared/log.h>
#include "VBlankMonitor.h"
#include "VBlankMonitorWindows.h"
#include "VBlankMonitorOSX.h"
#include "VBlankMonitorDefault.h"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

// Also used to initialise any vblank monitor per-thread logs.
LOG_TAGGED_DEFINE(VBLANK, "VBLANK", "", &log_printer_stdout_and_debugger, false);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

VBlankMonitor::Handler::Handler() {
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

VBlankMonitor::Handler::~Handler() {
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

VBlankMonitor::VBlankMonitor() {
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

VBlankMonitor::~VBlankMonitor() {
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

bool VBlankMonitor::RefreshDisplayList(Messages *messages) {
    (void)messages;

    return true;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

bool VBlankMonitor::NeedsRefreshDisplayList() const {
    return false;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

std::unique_ptr<VBlankMonitor> CreateVBlankMonitor(VBlankMonitor::Handler *handler,
                                                   bool force_default,
                                                   Messages *messages) {
    std::unique_ptr<VBlankMonitor> v;

    if (force_default) {
        v = CreateVBlankMonitorDefault(std::chrono::microseconds(20000));
    }

    if (!v) {
#if SYSTEM_WINDOWS
        v = CreateVBlankMonitorWindows();
#elif SYSTEM_OSX
        v = CreateVBlankMonitorOSX();
#else
        v = CreateVBlankMonitorDefault(std::chrono::microseconds(20000));
#endif
    }

    if (!v) {
        return nullptr;
    }

    if (!v->Init(handler, messages)) {
        return nullptr;
    }

    if (!v->RefreshDisplayList(messages)) {
        return nullptr;
    }

    return v;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
