/*
 Copyright (c) 2010 Greg James, Brian Silverman, Barry Silverman

 The following is provided under terms of the Creative Commons
 Attribution-NonCommercial-ShareAlike 3.0 Unported license:
 http://creativecommons.org/licenses/by-nc-sa/3.0/

 Specify the original author as Greg James and the following URL
 for original source material:  www.visual6502.org
 */

#include "types.h"

enum {
//	D1x1 = 827,
	a0 = 737,
	a1 = 1234,
	a2 = 978,
	a3 = 162,
	a4 = 727,
	a5 = 858,
	a6 = 1136,
	a7 = 1653,
	ab0 = 268,
	ab1 = 451,
	ab2 = 1340,
	ab3 = 211,
	ab4 = 435,
	ab5 = 736,
	ab6 = 887,
	ab7 = 1493,
	ab8 = 230,
	ab9 = 148,
	ab10 = 1443,
	ab11 = 399,
	ab12 = 1237,
	ab13 = 349,
	ab14 = 672,
	ab15 = 195,
//	adh0 = 407,
//	adh1 = 52,
//	adh2 = 1651,
//	adh3 = 315,
//	adh4 = 1160,
//	adh5 = 483,
//	adh6 = 13,
//	adh7 = 1539,
//	adl0 = 413,
//	adl1 = 1282,
//	adl2 = 1242,
//	adl3 = 684,
//	adl4 = 1437,
//	adl5 = 1630,
//	adl6 = 121,
//	adl7 = 1299,
//	alu0 = 394,
//	alu1 = 697,
//	alu2 = 276,
//	alu3 = 495,
//	alu4 = 1490,
//	alu5 = 893,
//	alu6 = 68,
//	alu7 = 1123,
//	cclk = 943,   // aka cp2
//	clearIR = 1077,
	clk0 = 1171,
//	clk1out = 1163,
//	clk2out = 421,
//	clock1 = 156,
//	clock2 = 1536,
//	cp1 = 710,
	db0 = 1005,
	db1 = 82,
	db2 = 945,
	db3 = 650,
	db4 = 1393,
	db5 = 175,
	db6 = 1591,
	db7 = 1349,
//	dor0 = 222,
//	dor1 = 527,
//	dor2 = 1288,
//	dor3 = 823,
//	dor4 = 873,
//	dor5 = 1266,
//	dor6 = 1418,
//	dor7 = 158,
//	fetch = 879,
//	h1x1 = 1042 // drive status byte onto databus
//	idb0 = 1108,
//	idb1 = 991,
//	idb2 = 1473,
//	idb3 = 1302,
//	idb4 = 892,
//	idb5 = 1503,
//	idb6 = 833,
//	idb7 = 493,
//	idl0 = 116,
//	idl1 = 576,
//	idl2 = 1485,
//	idl3 = 1284,
//	idl4 = 1516,
//	idl5 = 498,
//	idl6 = 1537,
//	idl7 = 529,
	irq = 103,
	nmi = 1297,
//	notRdy0 = 248,
	notir0 = 194,
	notir1 = 702,
	notir2 = 1182,
	notir3 = 1125,
	notir4 = 26,
	notir5 = 1394,  // OK
	notir6 = 895,   // OK
	notir7 = 1320,
//	nots0 = 418,
//	nots1 = 1064,
//	nots2 = 752,
//	nots3 = 828,
//	nots4 = 1603,
//	nots5 = 601,
//	nots6 = 1029,
//	nots7 = 181,
	p0 = 687,
	p1 = 1444,
	p2 = 1421,
	p3 = 439,
	p4 = 1119,
	p5 = 0,
	p6 = 77,
	p7 = 1370,
	pch0 = 1670,
	pch1 = 292,
	pch2 = 502,
	pch3 = 584,
	pch4 = 948,
	pch5 = 49,
	pch6 = 1551,
	pch7 = 205,
	pcl0 = 1139,
	pcl1 = 1022,
	pcl2 = 655,
	pcl3 = 1359,
	pcl4 = 900,
	pcl5 = 622,
	pcl6 = 377,
	pcl7 = 1611,
//	pd0 = 758,
//	pd1 = 361,
//	pd2 = 955,
//	pd3 = 894,
//	pd4 = 369,
//	pd5 = 829,
//	pd6 = 1669,
//	pd7 = 1690,
	rdy = 89,
	res = 159,
	rw = 1156,
	s0 = 1403,
	s1 = 183,
	s2 = 81,
	s3 = 1532,
	s4 = 1702,
	s5 = 1098,
	s6 = 1212,
	s7 = 1435,
//	sb0 = 54,
//	sb1 = 1150,
//	sb2 = 1287,
//	sb3 = 1188,
//	sb4 = 1405,
//	sb5 = 166,
//	sb6 = 1336,
//	sb7 = 1001,
	so = 1672,
//	sync_ = 539,
//	t2 = 971,
//	t3 = 1567,
//	t4 = 690,
//	t5 = 909,
	vcc = 657,
	vss = 558,
	x0 = 1216,
	x1 = 98,
	x2 = 1,
	x3 = 1648,
	x4 = 85,
	x5 = 589,
	x6 = 448,
	x7 = 777,
	y0 = 64,
	y1 = 1148,
	y2 = 573,
	y3 = 305,
	y4 = 989,
	y5 = 615,
	y6 = 115,
	y7 = 843,
};

BOOL
netlist_6502_node_is_pullup[] = {
	1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1,
	1, 0, 1, 1, 1, 0, 1, 2, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0,
	1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0,
	0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1,
	0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0,
	0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0,
	0, 1, 0, 1, 1, 1, 2, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1,
	1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 2, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0,
	1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1,
	1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1,
	0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1,
	0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 2, 1, 0, 1, 0, 1, 0, 1, 0,
	1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1,
	0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1,
	1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0,
	1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1,
	1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 2, 1, 0,
	0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1,
	0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0,
	0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0,
	0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 2, 0, 1, 1, 1, 0, 1, 1, 1,
	1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1,
	0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 2, 1, 1, 0, 1, 0, 1, 0, 1, 1,
	1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0,
	1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0,
	0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1,
	0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0,
	0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0,
	1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1,
	1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1,
	0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 2, 1, 0, 0, 1, 1, 1, 0, 1, 0,
	0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1,
	1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1,
	0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1,
	0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1,
	1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0,
	0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1,
	0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 2, 1, 1, 0, 0, 1, 0, 2, 1, 1, 1, 1,
	1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0,
	0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1,
	1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1,
	0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0,
	0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1,
	1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1,
	0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0,
	0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0,
	2, 0, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0,
	0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0,
	1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1,
	1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 2, 2, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1,
	1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1,
	0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 2, 1, 0, 0,
	1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0,
	0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0,
	1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0,
	1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 1,
	1, 1, 0, 0, 2, 0, 2, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1,
	1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1,
	0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1,
	0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1,
	1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1,
	0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1,
	1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 1,
	1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0,
	0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1,
	1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0,
	1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1,
	0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1,
	0, 1, 1, 0, 1, 0, 1, 2, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0,
	0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 2,
	0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1
};

netlist_transdefs
netlist_6502_transdefs[] = {
	{357, 558, 217},
	{1608, 657, 349},
	{412, 558, 1146},
	{558, 558, 943},
	{826, 230, 657},
	{82, 558, 1319},
	{821, 289, 1514},
	{558, 558, 1171},
	{945, 558, 1199},
	{710, 524, 1548},
	{190, 558, 220},
	{38, 1247, 657},
	{1248, 189, 558},
	{1248, 558, 155},
	{943, 558, 346},
	{1140, 148, 657},
	{1540, 508, 558},
	{710, 32, 1082},
	{710, 1451, 212},
	{1247, 558, 534},
	{943, 1162, 272},
	{943, 983, 418},
	{248, 1615, 468},
	{248, 472, 395},
	{710, 1495, 348},
	{1096, 1100, 558},
	{1096, 558, 1660},
	{1096, 855, 657},
	{1503, 558, 744},
	{44, 1616, 558},
	{78, 651, 375},
	{78, 558, 65},
	{710, 928, 1378},
	{710, 1309, 74},
	{943, 518, 115},
	{32, 558, 31},
	{943, 1405, 657},
	{943, 973, 1603},
	{347, 510, 558},
	{710, 1667, 883},
	{706, 1456, 558},
	{1174, 307, 558},
	{1622, 558, 409},
	{192, 25, 558},
	{1490, 558, 606},
	{943, 1148, 767},
	{549, 1150, 1248},
	{549, 1287, 1332},
	{549, 1680, 1188},
	{549, 1142, 1405},
	{353, 794, 558},
	{353, 794, 558},
	{593, 558, 1700},
	{549, 1167, 54},
	{600, 613, 1362},
	{549, 530, 166},
	{549, 1627, 1336},
	{948, 558, 1400},
	{264, 1092, 480},
	{1582, 632, 558},
	{584, 558, 923},
	{1003, 274, 136},
	{1003, 860, 558},
	{943, 1347, 1527},
	{68, 558, 331},
	{558, 945, 558},
	{1457, 1644, 1495},
	{1485, 1066, 558},
	{1485, 558, 1066},
	{1485, 1066, 558},
	{1077, 558, 1622},
	{1077, 667, 558},
	{325, 115, 1336},
	{710, 920, 785},
	{1318, 748, 558},
	{362, 304, 657},
	{127, 421, 657},
	{325, 989, 1405},
	{53, 558, 790},
	{763, 558, 1068},
	{1088, 558, 147},
	{1088, 558, 1463},
	{1042, 1370, 493},
	{1042, 1473, 1421},
	{943, 513, 443},
	{943, 1673, 1646},
	{943, 490, 1516},
	{311, 856, 558},
	{311, 835, 558},
	{783, 558, 1158},
	{783, 558, 1704},
	{783, 558, 1253},
	{381, 230, 558},
	{381, 230, 558},
	{381, 230, 558},
	{381, 558, 230},
	{381, 230, 558},
	{381, 558, 230},
	{381, 230, 558},
	{152, 558, 1343},
	{555, 371, 558},
	{810, 558, 207},
	{819, 501, 558},
	{1148, 1138, 558},
	{963, 657, 672},
	{967, 202, 558},
	{1691, 972, 558},
	{1342, 1563, 558},
	{786, 844, 558},
	{422, 657, 1296},
	{422, 1346, 558},
	{422, 359, 558},
	{984, 1680, 558},
	{1410, 558, 365},
	{403, 558, 1145},
	{527, 746, 558},
	{1610, 972, 1372},
	{710, 653, 1497},
	{429, 489, 558},
	{467, 558, 10},
	{460, 692, 558},
	{536, 558, 1647},
	{917, 1358, 558},
	{821, 429, 514},
	{744, 558, 1268},
	{710, 430, 1570},
	{943, 1179, 393},
	{1700, 998, 1188},
	{1700, 1389, 1287},
	{1369, 558, 1462},
	{1369, 657, 438},
	{925, 558, 816},
	{1700, 721, 1001},
	{1700, 618, 1336},
	{818, 1043, 558},
	{818, 657, 414},
	{1700, 3, 1405},
	{270, 1426, 558},
	{1678, 477, 1559},
	{1678, 558, 1632},
	{710, 1590, 1083},
	{589, 558, 1017},
	{710, 1424, 1066},
	{1420, 1455, 558},
	{1420, 397, 558},
	{493, 789, 558},
	{640, 884, 558},
	{1108, 558, 624},
	{154, 558, 75},
	{154, 657, 129},
	{787, 558, 605},
	{1247, 558, 325},
	{1582, 604, 558},
	{1670, 1010, 558},
	{798, 82, 657},
	{798, 82, 657},
	{453, 1264, 558},
	{28, 567, 558},
	{121, 558, 1548},
	{285, 1225, 558},
	{1134, 558, 70},
	{706, 1366, 558},
	{272, 952, 558},
	{715, 426, 558},
	{715, 914, 558},
	{761, 711, 739},
	{1296, 657, 399},
	{1453, 657, 373},
	{1312, 558, 264},
	{646, 558, 812},
	{943, 1513, 210},
	{379, 1500, 1706},
	{379, 558, 1345},
	{813, 1101, 1508},
	{4, 558, 11},
	{819, 1380, 558},
	{714, 214, 657},
	{43, 818, 558},
	{1520, 558, 1107},
	{1002, 558, 1130},
	{943, 779, 805},
	{710, 1141, 101},
	{943, 408, 1308},
	{1581, 1480, 379},
	{347, 558, 191},
	{1537, 1116, 558},
	{1537, 558, 1116},
	{1537, 1116, 558},
	{1624, 169, 558},
	{408, 938, 558},
	{1576, 1125, 558},
	{943, 1609, 1394},
	{205, 453, 558},
	{309, 558, 368},
	{1544, 405, 1172},
	{1720, 558, 373},
	{1720, 657, 612},
	{1088, 1076, 657},
	{646, 558, 773},
	{982, 558, 1141},
	{1135, 558, 1203},
	{1135, 558, 1629},
	{1258, 558, 813},
	{248, 558, 720},
	{1045, 558, 1371},
	{999, 558, 1237},
	{999, 1237, 558},
	{999, 558, 1237},
	{999, 558, 1237},
	{999, 1237, 558},
	{999, 558, 1237},
	{999, 1237, 558},
	{943, 561, 29},
	{867, 558, 876},
	{1173, 558, 1717},
	{1146, 206, 558},
	{76, 558, 1106},
	{241, 558, 1033},
	{241, 657, 1015},
	{995, 975, 886},
	{201, 558, 1371},
	{273, 558, 272},
	{846, 307, 558},
	{879, 1183, 541},
	{827, 558, 380},
	{1061, 558, 124},
	{654, 332, 1403},
	{943, 1108, 657},
	{621, 558, 355},
	{1035, 558, 251},
	{1606, 188, 558},
	{41, 407, 719},
	{41, 52, 87},
	{41, 1651, 1424},
	{41, 315, 1661},
	{41, 1160, 1095},
	{41, 483, 1387},
	{41, 13, 1014},
	{41, 1539, 1147},
	{370, 558, 689},
	{805, 558, 1534},
	{943, 326, 1136},
	{943, 1117, 170},
	{710, 797, 873},
	{1382, 558, 1087},
	{960, 1178, 558},
	{977, 1628, 316},
	{977, 558, 143},
	{874, 1098, 166},
	{874, 1212, 1336},
	{874, 1532, 1188},
	{874, 1405, 1702},
	{874, 183, 1150},
	{874, 81, 1287},
	{781, 802, 558},
	{1525, 558, 406},
	{1525, 558, 555},
	{647, 427, 558},
	{1372, 1425, 558},
	{943, 242, 1648},
	{710, 931, 1674},
	{710, 1526, 1450},
	{1273, 638, 558},
	{512, 558, 154},
	{1247, 874, 558},
	{1427, 558, 1448},
	{223, 558, 1357},
	{1219, 558, 1002},
	{1042, 1108, 687},
	{943, 604, 1477},
	{206, 367, 1082},
	{265, 818, 558},
	{1575, 558, 971},
	{105, 371, 406},
	{105, 558, 555},
	{631, 558, 1323},
	{631, 657, 283},
	{544, 267, 558},
	{1482, 616, 558},
	{943, 657, 1437},
	{101, 558, 1364},
	{985, 558, 844},
	{1262, 558, 1151},
	{654, 618, 1212},
	{654, 280, 1098},
	{654, 3, 1702},
	{654, 998, 1532},
	{654, 1389, 81},
	{654, 694, 183},
	{315, 558, 883},
	{1307, 558, 178},
	{281, 558, 347},
	{781, 553, 558},
	{1413, 558, 1235},
	{764, 558, 1649},
	{1212, 558, 1187},
	{710, 719, 1597},
	{1410, 558, 1605},
	{279, 455, 558},
	{943, 407, 657},
	{730, 1724, 558},
	{612, 558, 175},
	{612, 558, 175},
	{612, 558, 175},
	{612, 558, 175},
	{612, 175, 558},
	{612, 175, 558},
	{612, 558, 175},
	{445, 558, 317},
	{445, 558, 417},
	{445, 558, 417},
	{710, 127, 558},
	{445, 539, 558},
	{445, 558, 539},
	{445, 539, 558},
	{445, 558, 539},
	{445, 558, 539},
	{768, 287, 558},
	{1382, 1215, 558},
	{1220, 558, 547},
	{1220, 817, 558},
	{1015, 1637, 1242},
	{1015, 1282, 872},
	{1015, 413, 401},
	{784, 558, 1464},
	{67, 558, 501},
	{1699, 558, 913},
	{447, 261, 558},
	{425, 388, 558},
	{801, 564, 54},
	{347, 335, 558},
	{1602, 558, 1596},
	{182, 442, 558},
	{746, 657, 798},
	{943, 261, 729},
	{710, 959, 323},
	{710, 1183, 1605},
	{1595, 1181, 793},
	{1227, 488, 558},
	{0, 182, 558},
	{1452, 861, 558},
	{575, 558, 1000},
	{1708, 558, 1055},
	{1305, 558, 921},
	{525, 800, 558},
	{525, 1331, 657},
	{1130, 80, 558},
	{1381, 558, 980},
	{328, 1133, 558},
	{328, 558, 194},
	{66, 451, 558},
	{66, 451, 558},
	{66, 451, 558},
	{66, 451, 558},
	{943, 558, 48},
	{943, 558, 741},
	{1341, 600, 558},
	{712, 558, 300},
	{1108, 558, 1224},
	{335, 1303, 1397},
	{253, 279, 558},
	{253, 1692, 558},
	{1129, 657, 943},
	{1333, 906, 558},
	{558, 82, 558},
	{1081, 558, 605},
	{1530, 558, 1198},
	{424, 657, 248},
	{614, 558, 1178},
	{198, 248, 558},
	{198, 424, 558},
	{335, 1717, 1604},
	{437, 413, 977},
	{926, 558, 1054},
	{1700, 694, 1150},
	{869, 558, 349},
	{869, 558, 349},
	{869, 349, 558},
	{869, 558, 349},
	{869, 349, 558},
	{869, 349, 558},
	{869, 349, 558},
	{1076, 657, 1393},
	{1076, 657, 1393},
	{1611, 558, 641},
	{1700, 280, 166},
	{244, 558, 544},
	{1144, 757, 939},
	{248, 1456, 428},
	{248, 12, 1091},
	{248, 558, 16},
	{82, 213, 558},
	{170, 558, 686},
	{601, 558, 280},
	{943, 1654, 162},
	{821, 705, 1062},
	{521, 6, 558},
	{317, 657, 417},
	{203, 558, 52},
	{353, 558, 1076},
	{353, 558, 1076},
	{353, 558, 1463},
	{710, 1553, 845},
	{1109, 1358, 558},
	{650, 558, 1281},
	{427, 558, 500},
	{427, 112, 1314},
	{943, 878, 462},
	{330, 807, 558},
	{1258, 558, 1716},
	{48, 584, 315},
	{48, 502, 1651},
	{48, 49, 483},
	{48, 948, 1160},
	{48, 205, 1539},
	{48, 1551, 13},
	{943, 1336, 657},
	{943, 1187, 1029},
	{1503, 558, 1383},
	{821, 1667, 92},
	{943, 1090, 1683},
	{762, 558, 1018},
	{135, 421, 558},
	{135, 421, 558},
	{135, 558, 421},
	{135, 421, 558},
	{943, 1160, 657},
	{943, 1630, 657},
	{440, 366, 1012},
	{668, 1143, 558},
	{1162, 21, 558},
	{943, 474, 15},
	{1263, 1169, 54},
	{962, 558, 1035},
	{1523, 963, 558},
	{1523, 635, 657},
	{1260, 1413, 558},
	{1260, 657, 1235},
	{220, 558, 130},
	{220, 639, 657},
	{400, 558, 102},
	{400, 657, 1696},
	{834, 558, 1696},
	{834, 558, 400},
	{777, 1561, 558},
	{604, 656, 558},
	{1545, 1443, 657},
	{1246, 558, 1012},
	{1334, 558, 949},
	{1334, 558, 1406},
	{859, 977, 1108},
	{710, 402, 187},
	{358, 558, 1129},
	{358, 558, 1129},
	{943, 1717, 1113},
	{1263, 871, 1001},
	{943, 657, 52},
	{943, 568, 498},
	{1250, 138, 558},
	{1250, 990, 558},
	{1250, 1041, 657},
	{1011, 558, 1214},
	{1655, 558, 182},
	{1136, 1356, 558},
	{378, 909, 558},
	{35, 71, 558},
	{35, 654, 657},
	{554, 1180, 558},
	{554, 558, 964},
	{787, 1304, 558},
	{967, 1347, 558},
	{967, 558, 104},
	{710, 571, 343},
	{943, 207, 1061},
	{980, 473, 1004},
	{89, 558, 958},
	{963, 657, 672},
	{1240, 863, 558},
	{943, 164, 333},
	{174, 558, 1197},
	{781, 558, 1170},
	{670, 1417, 657},
	{994, 558, 1443},
	{994, 1443, 558},
	{994, 558, 1443},
	{994, 558, 1443},
	{994, 1443, 558},
	{994, 558, 1443},
	{994, 1443, 558},
	{1439, 558, 518},
	{654, 1435, 721},
	{13, 558, 880},
	{670, 747, 558},
	{1472, 1480, 558},
	{1587, 1294, 558},
	{1587, 558, 1083},
	{1628, 1285, 942},
	{506, 558, 877},
	{824, 1278, 1642},
	{59, 722, 1084},
	{1396, 1347, 558},
	{1676, 558, 634},
	{1676, 86, 657},
	{943, 194, 310},
	{118, 1092, 558},
	{1176, 558, 572},
	{1336, 61, 558},
	{1100, 268, 558},
	{1100, 268, 558},
	{1100, 268, 558},
	{712, 558, 383},
	{1337, 1560, 558},
	{1603, 558, 3},
	{443, 1422, 754},
	{443, 558, 755},
	{943, 496, 601},
	{1223, 225, 558},
	{1223, 657, 859},
	{337, 895, 558},
	{1225, 558, 1222},
	{710, 87, 870},
	{1015, 684, 1414},
	{1015, 1437, 606},
	{943, 844, 459},
	{175, 568, 558},
	{1517, 916, 558},
	{1015, 765, 1299},
	{1015, 1630, 314},
	{1015, 121, 331},
	{293, 1402, 57},
	{293, 207, 356},
	{293, 810, 558},
	{335, 734, 1106},
	{807, 330, 558},
	{990, 1041, 558},
	{990, 138, 657},
	{1357, 558, 1575},
	{1097, 558, 1475},
	{59, 740, 1691},
	{787, 51, 29},
	{1635, 558, 203},
	{710, 1641, 237},
	{710, 724, 409},
	{1662, 1426, 845},
	{267, 558, 80},
	{206, 387, 916},
	{59, 649, 1071},
	{505, 22, 1572},
	{505, 558, 193},
	{943, 1071, 495},
	{1109, 1130, 558},
	{1417, 1163, 558},
	{1417, 558, 1163},
	{1417, 1163, 558},
	{1417, 558, 1163},
	{1417, 1163, 558},
	{943, 718, 116},
	{1236, 165, 558},
	{8, 1584, 345},
	{1634, 558, 37},
	{1634, 558, 224},
	{10, 176, 558},
	{55, 628, 558},
	{1614, 299, 1616},
	{925, 558, 335},
	{664, 558, 1697},
	{1465, 558, 1134},
	{1459, 122, 558},
	{1459, 1030, 558},
	{772, 558, 1305},
	{772, 657, 921},
	{1098, 558, 496},
	{1079, 481, 558},
	{943, 534, 558},
	{459, 625, 558},
	{43, 830, 558},
	{558, 103, 558},
	{755, 566, 580},
	{1634, 520, 657},
	{732, 558, 17},
	{732, 558, 1536},
	{710, 248, 1679},
	{710, 223, 1215},
	{748, 1327, 558},
	{1078, 558, 511},
	{863, 1108, 719},
	{863, 991, 87},
	{863, 1473, 1424},
	{863, 1302, 1661},
	{863, 892, 1095},
	{863, 1503, 1387},
	{863, 833, 1014},
	{863, 493, 1147},
	{1374, 1368, 558},
	{322, 657, 1493},
	{322, 1493, 657},
	{322, 1493, 657},
	{322, 1493, 657},
	{1536, 558, 1233},
	{1536, 558, 286},
	{1536, 558, 382},
	{1536, 558, 1173},
	{1536, 558, 1543},
	{1536, 558, 76},
	{1536, 1658, 558},
	{1536, 245, 558},
	{1536, 985, 558},
	{1536, 558, 682},
	{1536, 558, 665},
	{1536, 558, 271},
	{1536, 558, 552},
	{1536, 1623, 558},
	{1536, 403, 558},
	{1536, 1273, 558},
	{1536, 558, 1337},
	{1536, 558, 1355},
	{1536, 558, 787},
	{1536, 558, 575},
	{1536, 558, 257},
	{1536, 179, 558},
	{1536, 131, 558},
	{1536, 1420, 558},
	{1536, 558, 1342},
	{1536, 558, 4},
	{1536, 558, 1396},
	{1536, 558, 167},
	{1536, 558, 303},
	{1536, 1504, 558},
	{1536, 1721, 558},
	{1536, 1074, 558},
	{1536, 558, 1478},
	{1536, 558, 594},
	{1536, 558, 1292},
	{1536, 558, 1114},
	{1536, 558, 1476},
	{1536, 1226, 558},
	{1536, 1419, 558},
	{943, 573, 1491},
	{236, 558, 272},
	{587, 558, 299},
	{337, 1466, 558},
	{337, 1601, 558},
	{337, 558, 1173},
	{337, 558, 1562},
	{337, 558, 1543},
	{337, 558, 1540},
	{337, 558, 245},
	{337, 985, 558},
	{337, 682, 558},
	{337, 665, 558},
	{337, 558, 286},
	{337, 558, 271},
	{337, 558, 370},
	{337, 558, 403},
	{337, 558, 804},
	{337, 712, 558},
	{337, 546, 558},
	{337, 776, 558},
	{337, 558, 257},
	{337, 558, 179},
	{337, 558, 1420},
	{337, 558, 4},
	{337, 167, 558},
	{337, 303, 558},
	{337, 1504, 558},
	{337, 487, 558},
	{337, 558, 579},
	{337, 558, 145},
	{337, 558, 259},
	{337, 558, 517},
	{337, 352, 558},
	{337, 750, 558},
	{337, 528, 558},
	{337, 691, 558},
	{337, 558, 1646},
	{337, 558, 1114},
	{337, 558, 1476},
	{337, 558, 1226},
	{337, 1665, 558},
	{337, 840, 558},
	{337, 1164, 558},
	{943, 473, 848},
	{943, 614, 389},
	{1359, 558, 249},
	{943, 960, 1081},
	{248, 1154, 558},
	{248, 180, 558},
	{1202, 558, 1367},
	{1202, 558, 57},
	{307, 558, 620},
	{784, 558, 256},
	{1551, 558, 278},
	{567, 171, 558},
	{567, 1026, 558},
	{567, 657, 322},
	{551, 558, 8},
	{943, 1620, 1125},
	{558, 1297, 558},
	{832, 1275, 558},
	{491, 437, 558},
	{1502, 642, 558},
	{1502, 951, 558},
	{1502, 1152, 657},
	{892, 744, 558},
	{79, 911, 696},
	{943, 277, 893},
	{412, 1257, 558},
	{1714, 1189, 262},
	{1241, 177, 558},
	{833, 558, 351},
	{43, 558, 1541},
	{1529, 558, 91},
	{167, 558, 11},
	{710, 854, 1395},
	{1126, 1290, 558},
	{699, 1556, 986},
	{699, 867, 558},
	{1057, 1649, 558},
	{1070, 558, 1538},
	{1070, 1334, 558},
	{1070, 558, 200},
	{1112, 382, 558},
	{1112, 1233, 558},
	{1112, 84, 558},
	{1112, 1543, 558},
	{1112, 76, 558},
	{1112, 1658, 558},
	{1112, 786, 558},
	{1112, 1664, 558},
	{1112, 1482, 558},
	{1112, 286, 558},
	{1112, 271, 558},
	{1112, 370, 558},
	{1112, 552, 558},
	{1112, 1612, 558},
	{1112, 1487, 558},
	{1112, 784, 558},
	{1112, 764, 558},
	{1112, 1057, 558},
	{1112, 1582, 558},
	{1112, 1031, 558},
	{1112, 804, 558},
	{1112, 1311, 558},
	{1112, 1428, 558},
	{1112, 1520, 558},
	{1112, 1259, 558},
	{1112, 857, 558},
	{1112, 712, 558},
	{1112, 1337, 558},
	{1112, 1381, 558},
	{1112, 776, 558},
	{1112, 157, 558},
	{1112, 1324, 558},
	{1112, 179, 558},
	{1112, 131, 558},
	{1112, 4, 558},
	{1112, 1396, 558},
	{1112, 167, 558},
	{1112, 303, 558},
	{1112, 1086, 558},
	{1112, 1074, 558},
	{1112, 487, 558},
	{1112, 579, 558},
	{1112, 0, 558},
	{1112, 1478, 558},
	{1112, 594, 558},
	{1112, 1210, 558},
	{1112, 1557, 558},
	{1112, 259, 558},
	{1112, 1052, 558},
	{1112, 791, 558},
	{1112, 352, 558},
	{1112, 750, 558},
	{1112, 932, 558},
	{1112, 1589, 558},
	{1112, 446, 558},
	{1112, 528, 558},
	{1112, 309, 558},
	{1112, 1430, 558},
	{1112, 1646, 558},
	{1112, 1476, 558},
	{1112, 1226, 558},
	{1112, 1569, 558},
	{1112, 950, 558},
	{1112, 1665, 558},
	{1112, 1710, 558},
	{1112, 1050, 558},
	{1112, 607, 558},
	{1112, 219, 558},
	{1300, 1384, 558},
	{710, 416, 1016},
	{276, 558, 1637},
	{1544, 586, 1330},
	{1544, 586, 1330},
	{943, 1607, 318},
	{1328, 558, 1466},
	{1328, 271, 558},
	{1328, 370, 558},
	{1328, 558, 552},
	{1328, 558, 1612},
	{1328, 558, 1487},
	{1328, 558, 784},
	{1328, 558, 244},
	{1328, 558, 1623},
	{1328, 764, 558},
	{1328, 403, 558},
	{1328, 558, 1582},
	{1328, 558, 1031},
	{1328, 558, 804},
	{1328, 558, 1311},
	{1328, 558, 1520},
	{1328, 558, 857},
	{1328, 712, 558},
	{1328, 558, 1381},
	{1328, 558, 546},
	{1328, 558, 776},
	{1328, 558, 157},
	{1328, 558, 1243},
	{1328, 558, 1324},
	{1328, 131, 558},
	{1328, 1396, 558},
	{1328, 558, 303},
	{1328, 558, 1504},
	{1328, 558, 1086},
	{1328, 558, 1074},
	{1328, 558, 1246},
	{1328, 558, 487},
	{1328, 579, 558},
	{1328, 0, 558},
	{1328, 558, 1478},
	{1328, 558, 594},
	{1328, 558, 1557},
	{1328, 558, 259},
	{1328, 558, 1052},
	{1328, 558, 791},
	{1328, 352, 558},
	{1328, 750, 558},
	{1328, 558, 932},
	{1328, 558, 1589},
	{1328, 558, 446},
	{1328, 558, 528},
	{1328, 558, 309},
	{1328, 558, 1430},
	{1328, 691, 558},
	{1328, 1292, 558},
	{1328, 558, 1646},
	{1328, 558, 1114},
	{1328, 558, 1476},
	{1328, 558, 1226},
	{1328, 558, 1569},
	{1328, 558, 1665},
	{1328, 1050, 558},
	{1328, 558, 1174},
	{1063, 558, 1310},
	{963, 672, 657},
	{840, 558, 846},
	{1131, 558, 187},
	{243, 566, 802},
	{216, 516, 558},
	{216, 1610, 558},
	{1299, 558, 1046},
	{1107, 389, 558},
	{639, 416, 107},
	{1007, 558, 1334},
	{1673, 558, 754},
	{639, 1636, 707},
	{573, 1484, 558},
	{1241, 558, 1013},
	{1241, 558, 1217},
	{291, 558, 1157},
	{291, 657, 1564},
	{1524, 1225, 558},
	{1721, 558, 10},
	{278, 558, 1488},
	{462, 558, 1278},
	{599, 725, 558},
	{692, 441, 558},
	{692, 325, 657},
	{1259, 558, 300},
	{760, 1350, 558},
	{1473, 558, 458},
	{820, 27, 558},
	{383, 917, 558},
	{622, 558, 386},
	{248, 1649, 558},
	{16, 472, 1366},
	{899, 558, 850},
	{353, 558, 147},
	{353, 558, 147},
	{1385, 558, 347},
	{710, 1132, 1087},
	{248, 1180, 558},
	{943, 1373, 188},
	{817, 486, 558},
	{997, 657, 963},
	{997, 1523, 558},
	{997, 635, 558},
	{225, 859, 558},
	{640, 136, 558},
	{640, 860, 558},
	{155, 1021, 558},
	{155, 425, 558},
	{440, 558, 1555},
	{432, 1686, 558},
	{432, 1097, 558},
	{635, 558, 672},
	{635, 672, 558},
	{635, 558, 672},
	{635, 672, 558},
	{635, 558, 672},
	{635, 672, 558},
	{635, 672, 558},
	{43, 558, 1534},
	{967, 1330, 558},
	{181, 721, 558},
	{943, 1225, 683},
	{726, 558, 630},
	{1195, 558, 1191},
	{1195, 1254, 657},
	{771, 1055, 558},
	{221, 251, 558},
	{221, 558, 251},
	{248, 558, 372},
	{248, 1365, 1085},
	{943, 359, 92},
	{710, 626, 756},
	{710, 457, 823},
	{255, 558, 741},
	{1140, 148, 657},
	{1288, 1634, 558},
	{383, 558, 1040},
	{383, 1040, 558},
	{1637, 558, 699},
	{270, 1445, 1495},
	{1593, 558, 1552},
	{1593, 362, 657},
	{1666, 1525, 957},
	{1666, 250, 953},
	{1666, 701, 740},
	{1666, 884, 1071},
	{1666, 308, 296},
	{1666, 1469, 277},
	{1666, 1459, 722},
	{1666, 304, 177},
	{341, 558, 256},
	{16, 1558, 428},
	{691, 252, 591},
	{558, 558, 1672},
	{439, 1053, 558},
	{156, 558, 786},
	{156, 558, 1664},
	{156, 558, 1482},
	{156, 558, 1243},
	{156, 558, 822},
	{156, 1324, 558},
	{156, 558, 1646},
	{156, 1155, 558},
	{156, 558, 301},
	{156, 558, 950},
	{156, 558, 1665},
	{156, 558, 1710},
	{943, 1302, 657},
	{943, 1694, 1},
	{874, 54, 1403},
	{1120, 558, 137},
	{558, 1171, 558},
	{833, 744, 558},
	{368, 218, 558},
	{623, 319, 1707},
	{623, 388, 558},
	{1578, 1368, 558},
	{1027, 558, 476},
	{1589, 368, 558},
	{1589, 104, 558},
	{153, 558, 1096},
	{440, 1352, 558},
	{440, 104, 558},
	{440, 812, 558},
	{1585, 558, 962},
	{1398, 1489, 558},
	{258, 1103, 1106},
	{979, 1347, 558},
	{370, 558, 1464},
	{955, 558, 1671},
	{1343, 911, 558},
	{790, 558, 434},
	{1054, 558, 70},
	{1543, 558, 1106},
	{1150, 320, 558},
	{283, 1108, 488},
	{775, 657, 1608},
	{775, 1423, 558},
	{775, 869, 558},
	{283, 1473, 481},
	{1164, 340, 558},
	{248, 558, 1382},
	{575, 673, 1053},
	{879, 703, 927},
	{415, 931, 558},
	{88, 1375, 558},
	{1110, 771, 558},
	{1506, 965, 1388},
	{1506, 295, 558},
	{353, 558, 7},
	{353, 558, 7},
	{353, 558, 466},
	{73, 920, 558},
	{65, 651, 558},
	{710, 248, 902},
	{1384, 1182, 558},
	{943, 1675, 895},
	{25, 674, 558},
	{943, 1588, 829},
	{943, 894, 1281},
	{943, 369, 1075},
	{943, 929, 1234},
	{688, 558, 1223},
	{943, 1638, 1537},
	{110, 701, 716},
	{510, 1716, 558},
	{1113, 161, 558},
	{861, 1382, 558},
	{1247, 558, 1068},
	{471, 1591, 1591},
	{471, 558, 1591},
	{471, 558, 1591},
	{471, 558, 1591},
	{471, 558, 1591},
	{471, 558, 1591},
	{471, 558, 1591},
	{471, 558, 1591},
	{471, 1591, 558},
	{353, 558, 1325},
	{353, 558, 1325},
	{353, 558, 769},
	{358, 1467, 657},
	{710, 463, 1094},
	{879, 1590, 1620},
	{645, 558, 1368},
	{248, 558, 1275},
	{52, 558, 1267},
	{710, 494, 514},
	{954, 279, 558},
	{954, 367, 558},
	{236, 558, 1427},
	{271, 558, 1464},
	{114, 558, 1496},
	{943, 1251, 843},
	{1437, 558, 1519},
	{710, 262, 1447},
	{522, 558, 1196},
	{639, 246, 153},
	{691, 558, 790},
	{1182, 1601, 558},
	{1182, 258, 558},
	{1182, 665, 558},
	{1182, 764, 558},
	{1182, 1057, 558},
	{1182, 1381, 558},
	{1182, 303, 558},
	{1182, 285, 558},
	{1182, 594, 558},
	{1182, 1052, 558},
	{1182, 1589, 558},
	{1182, 309, 558},
	{1182, 1646, 558},
	{1182, 904, 558},
	{1182, 1476, 558},
	{1182, 950, 558},
	{1182, 558, 607},
	{1182, 219, 558},
	{943, 558, 984},
	{943, 558, 549},
	{943, 558, 437},
	{943, 558, 859},
	{943, 558, 1068},
	{943, 558, 654},
	{943, 874, 558},
	{984, 558, 1167},
	{710, 851, 792},
	{984, 558, 1248},
	{984, 558, 1142},
	{984, 558, 1627},
	{984, 558, 530},
	{1052, 558, 510},
	{1052, 558, 134},
	{1165, 105, 558},
	{1165, 558, 942},
	{37, 945, 945},
	{37, 945, 558},
	{37, 945, 558},
	{37, 945, 558},
	{37, 945, 558},
	{37, 558, 945},
	{37, 945, 558},
	{37, 945, 558},
	{37, 558, 945},
	{8, 36, 558},
	{8, 150, 558},
	{570, 1030, 333},
	{1258, 591, 558},
	{943, 684, 657},
	{1259, 558, 1649},
	{943, 1724, 448},
	{685, 558, 1598},
	{1238, 558, 1060},
	{921, 371, 957},
	{921, 965, 250},
	{921, 22, 740},
	{921, 274, 1071},
	{921, 651, 296},
	{921, 486, 277},
	{921, 722, 1197},
	{921, 304, 532},
	{710, 1376, 1288},
	{1569, 558, 327},
	{988, 640, 558},
	{943, 34, 828},
	{943, 657, 1188},
	{151, 558, 2},
	{1326, 72, 558},
	{710, 1339, 597},
	{402, 558, 834},
	{485, 436, 558},
	{361, 809, 558},
	{943, 442, 509},
	{1025, 558, 564},
	{1320, 558, 1601},
	{1320, 558, 382},
	{1320, 558, 1173},
	{1320, 558, 1233},
	{1320, 1562, 558},
	{1320, 558, 1543},
	{1320, 558, 76},
	{1320, 558, 1658},
	{1320, 558, 1540},
	{1320, 558, 245},
	{1320, 558, 985},
	{1320, 558, 786},
	{1320, 1664, 558},
	{1320, 558, 682},
	{1320, 558, 1482},
	{1320, 558, 665},
	{1320, 558, 286},
	{1320, 558, 324},
	{1320, 558, 1337},
	{1320, 558, 1355},
	{1320, 558, 787},
	{1320, 558, 257},
	{1320, 558, 179},
	{1320, 558, 1420},
	{1320, 558, 4},
	{1320, 558, 167},
	{1320, 558, 145},
	{1320, 558, 517},
	{1320, 558, 301},
	{1320, 558, 950},
	{1320, 1710, 558},
	{1320, 1419, 558},
	{1320, 558, 1164},
	{1068, 977, 624},
	{236, 558, 79},
	{1023, 1003, 558},
	{1023, 1425, 924},
	{1068, 1645, 478},
	{1068, 704, 458},
	{811, 753, 558},
	{811, 753, 558},
	{519, 558, 127},
	{519, 135, 657},
	{1360, 1575, 558},
	{1155, 558, 252},
	{1628, 1348, 558},
	{16, 1703, 468},
	{1074, 366, 558},
	{1063, 308, 1583},
	{1513, 558, 234},
	{946, 558, 384},
	{1653, 558, 128},
	{773, 275, 558},
	{376, 66, 558},
	{376, 558, 842},
	{376, 1479, 657},
	{943, 98, 1709},
	{686, 558, 1282},
	{710, 562, 645},
	{467, 1705, 558},
	{1392, 297, 346},
	{1392, 558, 284},
	{526, 558, 1227},
	{552, 558, 1464},
	{1425, 558, 78},
	{1425, 1310, 142},
	{117, 558, 1617},
	{92, 422, 558},
	{991, 558, 744},
	{1294, 851, 558},
	{943, 197, 944},
	{1658, 558, 1106},
	{710, 1684, 1418},
	{516, 388, 558},
	{1221, 1566, 558},
	{812, 558, 1044},
	{943, 1352, 1131},
	{1355, 558, 1560},
	{710, 1375, 95},
	{710, 1089, 1529},
	{844, 454, 946},
	{129, 331, 1336},
	{129, 314, 166},
	{129, 1405, 606},
	{129, 1414, 1188},
	{352, 1391, 558},
	{352, 1352, 558},
	{943, 820, 1657},
	{553, 511, 845},
	{1272, 558, 608},
	{413, 558, 123},
	{1142, 558, 185},
	{1142, 558, 404},
	{43, 21, 558},
	{1449, 558, 944},
	{1675, 337, 558},
	{16, 363, 1091},
	{1233, 558, 1717},
	{384, 885, 558},
	{384, 550, 558},
	{943, 176, 598},
	{943, 1592, 1653},
	{943, 558, 891},
	{702, 558, 1562},
	{702, 1543, 558},
	{702, 76, 558},
	{702, 1540, 558},
	{702, 245, 558},
	{702, 985, 558},
	{702, 786, 558},
	{702, 682, 558},
	{702, 244, 558},
	{702, 324, 558},
	{702, 558, 1466},
	{702, 546, 558},
	{702, 1324, 558},
	{702, 179, 558},
	{702, 1396, 558},
	{702, 167, 558},
	{702, 1074, 558},
	{702, 1246, 558},
	{702, 53, 558},
	{702, 691, 558},
	{702, 1665, 558},
	{248, 558, 191},
	{778, 558, 1275},
	{31, 687, 558},
	{444, 657, 42},
	{1228, 1196, 558},
	{1140, 148, 657},
	{943, 67, 1036},
	{1632, 1236, 558},
	{1632, 1220, 558},
	{163, 1498, 558},
	{163, 903, 558},
	{1620, 1576, 558},
	{943, 1011, 862},
	{710, 1687, 222},
	{710, 299, 1625},
	{943, 1008, 169},
	{1321, 1714, 558},
	{1244, 1103, 558},
	{1433, 620, 558},
	{710, 254, 1353},
	{943, 340, 1283},
	{681, 433, 1023},
	{1446, 430, 206},
	{1010, 311, 558},
	{1010, 1334, 558},
	{1047, 558, 534},
	{796, 35, 558},
	{1262, 1407, 933},
	{943, 296, 1490},
	{667, 558, 928},
	{284, 891, 1032},
	{292, 1070, 558},
	{26, 60, 558},
	{26, 1512, 558},
	{26, 1173, 558},
	{26, 258, 558},
	{26, 245, 558},
	{26, 682, 558},
	{26, 492, 558},
	{26, 1204, 558},
	{26, 558, 58},
	{26, 342, 558},
	{26, 257, 558},
	{26, 354, 558},
	{26, 1168, 558},
	{26, 1721, 558},
	{26, 1239, 558},
	{26, 558, 461},
	{26, 447, 558},
	{26, 660, 558},
	{26, 1292, 558},
	{26, 1114, 558},
	{26, 904, 558},
	{26, 558, 1419},
	{26, 281, 558},
	{26, 1164, 558},
	{1651, 558, 168},
	{437, 1242, 704},
	{943, 889, 1104},
	{991, 1474, 558},
	{1247, 48, 558},
	{1247, 1331, 558},
	{456, 1039, 558},
	{647, 939, 558},
	{943, 825, 138},
	{1036, 717, 558},
	{1672, 558, 1650},
	{509, 1270, 558},
	{653, 558, 390},
	{179, 558, 1455},
	{862, 1365, 558},
	{866, 657, 9},
	{1055, 1560, 558},
	{1038, 269, 558},
	{1622, 558, 1019},
	{1622, 1294, 558},
	{1484, 558, 1491},
	{882, 558, 1374},
	{725, 306, 558},
	{1448, 1619, 558},
	{943, 831, 858},
	{1511, 1598, 262},
	{1042, 1444, 991},
	{172, 1633, 558},
	{172, 210, 657},
	{1357, 678, 558},
	{1302, 558, 1600},
	{1186, 98, 1150},
	{1533, 558, 964},
	{331, 149, 558},
	{984, 558, 1522},
	{1715, 558, 1399},
	{1715, 558, 1399},
	{1715, 1105, 657},
	{677, 726, 558},
	{989, 565, 558},
	{1022, 558, 329},
	{689, 558, 1465},
	{943, 396, 796},
	{943, 153, 1100},
	{1442, 793, 558},
	{1380, 558, 109},
	{967, 558, 405},
	{1693, 1312, 558},
	{1601, 1604, 558},
	{1601, 558, 1397},
	{1247, 558, 1698},
	{558, 558, 175},
	{269, 1030, 333},
	{603, 1721, 558},
	{235, 1483, 336},
	{235, 558, 1084},
	{149, 970, 558},
	{149, 558, 762},
	{892, 558, 478},
	{295, 965, 558},
	{791, 273, 558},
	{791, 677, 558},
	{116, 1597, 558},
	{116, 558, 1597},
	{116, 1597, 558},
	{1683, 558, 966},
	{441, 325, 558},
	{1109, 558, 1649},
	{627, 558, 318},
	{538, 330, 881},
	{43, 558, 1223},
	{282, 874, 558},
	{33, 558, 1301},
	{853, 1517, 558},
	{425, 1388, 558},
	{425, 295, 558},
	{876, 1584, 558},
	{283, 1458, 833},
	{1356, 326, 558},
	{1318, 637, 558},
	{1691, 516, 558},
	{394, 558, 401},
	{1415, 558, 471},
	{1415, 558, 466},
	{710, 1290, 698},
	{943, 111, 955},
	{943, 62, 1690},
	{943, 374, 1669},
	{675, 888, 558},
	{675, 888, 558},
	{697, 558, 872},
	{1239, 636, 558},
	{792, 732, 106},
	{1005, 558, 93},
	{978, 419, 558},
	{1328, 558, 1320},
	{1304, 558, 1688},
	{828, 558, 998},
	{248, 1145, 558},
	{248, 604, 558},
	{710, 533, 599},
	{1064, 558, 694},
	{321, 558, 849},
	{321, 657, 247},
	{1228, 384, 558},
	{1228, 384, 558},
	{1377, 385, 558},
	{1177, 558, 1614},
	{857, 558, 300},
	{353, 558, 520},
	{353, 558, 520},
	{353, 558, 224},
	{194, 60, 558},
	{194, 1512, 558},
	{194, 84, 558},
	{194, 558, 1623},
	{194, 558, 403},
	{194, 558, 1428},
	{194, 558, 492},
	{194, 558, 1204},
	{194, 1259, 558},
	{194, 558, 342},
	{194, 558, 1355},
	{194, 558, 787},
	{194, 558, 575},
	{194, 1243, 558},
	{194, 822, 558},
	{194, 1420, 558},
	{194, 558, 1342},
	{194, 558, 1504},
	{194, 1168, 558},
	{194, 145, 558},
	{194, 1524, 558},
	{194, 1210, 558},
	{194, 461, 558},
	{194, 558, 1155},
	{194, 558, 301},
	{194, 558, 1385},
	{558, 558, 650},
	{759, 558, 944},
	{879, 1300, 343},
	{1006, 558, 664},
	{710, 675, 330},
	{353, 612, 558},
	{353, 612, 558},
	{943, 14, 294},
	{943, 586, 832},
	{1567, 558, 60},
	{1567, 558, 1487},
	{1567, 558, 1031},
	{1567, 1428, 558},
	{1567, 558, 58},
	{1567, 558, 342},
	{1567, 1381, 558},
	{1567, 558, 579},
	{1567, 558, 120},
	{1567, 558, 677},
	{1567, 558, 447},
	{1567, 558, 660},
	{1567, 558, 1430},
	{1567, 904, 558},
	{1567, 558, 607},
	{1682, 613, 150},
	{91, 558, 1256},
	{91, 657, 574},
	{339, 558, 543},
	{595, 239, 558},
	{595, 992, 558},
	{1247, 558, 859},
	{943, 676, 907},
	{17, 657, 1536},
	{17, 558, 646},
	{1114, 558, 889},
	{1226, 327, 558},
	{1564, 684, 1661},
	{1564, 1437, 1095},
	{1564, 1282, 87},
	{1564, 1242, 1424},
	{1564, 413, 719},
	{320, 1322, 558},
	{320, 735, 558},
	{353, 558, 471},
	{353, 558, 471},
	{354, 558, 595},
	{444, 643, 558},
	{444, 1613, 558},
	{943, 1431, 1134},
	{1478, 558, 256},
	{1313, 924, 558},
	{1105, 558, 710},
	{1105, 558, 710},
	{1105, 710, 558},
	{1105, 558, 710},
	{1105, 710, 558},
	{1488, 558, 545},
	{1488, 558, 1547},
	{45, 558, 815},
	{647, 558, 570},
	{801, 1491, 1287},
	{470, 467, 558},
	{943, 146, 737},
	{801, 1188, 1531},
	{885, 513, 558},
	{353, 558, 37},
	{353, 558, 37},
	{96, 350, 313},
	{96, 649, 558},
	{288, 558, 798},
	{288, 657, 794},
	{1429, 826, 657},
	{43, 625, 558},
	{1532, 558, 34},
	{751, 558, 652},
	{1677, 558, 475},
	{1677, 657, 999},
	{943, 865, 958},
	{1186, 1405, 85},
	{1186, 1648, 1188},
	{1186, 1, 1287},
	{582, 558, 1067},
	{582, 821, 657},
	{1186, 1336, 448},
	{1186, 589, 166},
	{1629, 558, 263},
	{707, 558, 1502},
	{71, 558, 654},
	{1186, 777, 1001},
	{858, 1719, 558},
	{60, 1717, 558},
	{520, 657, 945},
	{520, 657, 945},
	{1104, 253, 558},
	{1552, 362, 558},
	{892, 797, 558},
	{644, 678, 558},
	{975, 854, 558},
	{1084, 558, 803},
	{1084, 1314, 558},
	{1205, 1454, 1494},
	{1205, 260, 558},
	{943, 1689, 982},
	{943, 1001, 657},
	{943, 522, 88},
	{1386, 484, 914},
	{31, 307, 558},
	{1287, 1580, 558},
	{1287, 1580, 558},
	{86, 435, 558},
	{86, 558, 435},
	{86, 558, 435},
	{86, 558, 435},
	{710, 1624, 248},
	{286, 616, 558},
	{803, 482, 558},
	{210, 558, 736},
	{210, 558, 736},
	{210, 558, 736},
	{210, 558, 736},
	{294, 959, 558},
	{128, 558, 1592},
	{353, 558, 42},
	{353, 558, 42},
	{353, 558, 1613},
	{910, 558, 1165},
	{943, 658, 989},
	{673, 1304, 558},
	{15, 39, 558},
	{710, 1514, 880},
	{708, 549, 558},
	{943, 305, 1531},
	{480, 202, 629},
	{710, 472, 1606},
	{943, 44, 90},
	{683, 558, 229},
	{1154, 1380, 558},
	{904, 558, 347},
	{943, 559, 608},
	{353, 558, 373},
	{353, 558, 373},
	{353, 558, 1720},
	{943, 54, 657},
	{943, 722, 68},
	{409, 558, 302},
	{362, 841, 957},
	{362, 250, 681},
	{362, 350, 740},
	{362, 1071, 1063},
	{362, 296, 477},
	{362, 277, 336},
	{362, 722, 1318},
	{943, 469, 875},
	{1664, 844, 558},
	{325, 573, 1287},
	{613, 1656, 450},
	{613, 558, 1159},
	{943, 657, 493},
	{943, 1481, 1452},
	{943, 560, 808},
	{572, 1517, 558},
	{693, 1348, 1525},
	{139, 169, 558},
	{334, 558, 1421},
	{353, 643, 558},
	{353, 643, 558},
	{248, 46, 558},
	{1137, 558, 1185},
	{560, 558, 412},
	{860, 274, 558},
	{943, 436, 85},
	{943, 896, 1284},
	{1716, 558, 180},
	{1349, 588, 558},
	{1045, 558, 1370},
	{943, 1321, 132},
	{943, 1254, 1307},
	{550, 1347, 558},
	{790, 1137, 816},
	{943, 250, 697},
	{639, 825, 864},
	{175, 558, 1588},
	{747, 558, 1417},
	{1460, 558, 1309},
	{1174, 201, 558},
	{353, 558, 798},
	{353, 558, 798},
	{353, 558, 288},
	{943, 558, 525},
	{943, 558, 628},
	{1111, 1470, 558},
	{1111, 558, 1614},
	{1680, 313, 558},
	{1680, 649, 558},
	{956, 984, 558},
	{1521, 558, 242},
	{325, 1148, 1150},
	{440, 137, 504},
	{1382, 1649, 558},
	{1382, 300, 558},
	{90, 1433, 558},
	{120, 558, 256},
	{1645, 1063, 185},
	{1645, 404, 558},
	{1258, 558, 1352},
	{987, 558, 1169},
	{95, 558, 531},
	{943, 31, 1051},
	{710, 1368, 1149},
	{1453, 612, 558},
	{1453, 1720, 558},
	{126, 558, 113},
	{750, 1391, 558},
	{640, 558, 1610},
	{1217, 558, 532},
	{43, 476, 558},
	{453, 558, 1213},
	{1371, 620, 558},
	{439, 51, 558},
	{1553, 558, 334},
	{1002, 558, 605},
	{1002, 558, 605},
	{1477, 1541, 558},
	{1428, 558, 1107},
	{1428, 558, 604},
	{558, 558, 89},
	{646, 558, 272},
	{1174, 558, 1293},
	{131, 558, 1455},
	{800, 1331, 558},
	{1247, 558, 741},
	{1564, 121, 1014},
	{1564, 1630, 1387},
	{943, 1037, 266},
	{42, 657, 650},
	{42, 657, 650},
	{1702, 558, 973},
	{1471, 558, 1119},
	{943, 1586, 621},
	{710, 577, 1046},
	{476, 558, 956},
	{476, 984, 657},
	{1562, 1244, 558},
	{1562, 1351, 558},
	{1503, 961, 558},
	{710, 1093, 226},
	{245, 1358, 558},
	{671, 14, 558},
	{1124, 558, 1662},
	{1269, 558, 1401},
	{1269, 558, 1249},
	{821, 668, 1451},
	{226, 1593, 558},
	{543, 196, 558},
	{543, 657, 1468},
	{1708, 558, 236},
	{475, 1237, 657},
	{1350, 827, 558},
	{710, 827, 1472},
	{710, 1275, 1581},
	{1626, 558, 1133},
	{1626, 558, 702},
	{821, 1128, 1353},
	{1086, 558, 1037},
	{1399, 558, 1105},
	{319, 558, 972},
	{936, 558, 425},
	{1325, 657, 1005},
	{1325, 1005, 657},
	{43, 558, 611},
	{245, 558, 1106},
	{710, 50, 1350},
	{600, 36, 558},
	{1721, 558, 1048},
	{710, 1636, 935},
	{1394, 503, 558},
	{1468, 1630, 280},
	{1468, 1437, 3},
	{1468, 684, 998},
	{1468, 1242, 1389},
	{1408, 1004, 558},
	{1662, 553, 558},
	{1468, 721, 1299},
	{862, 1347, 558},
	{107, 558, 376},
	{236, 182, 1151},
	{124, 558, 141},
	{710, 1528, 1215},
	{710, 1161, 109},
	{1401, 626, 1198},
	{529, 558, 391},
	{529, 558, 391},
	{529, 558, 391},
	{770, 558, 19},
	{943, 1150, 657},
	{943, 182, 265},
	{943, 897, 1211},
	{446, 368, 558},
	{1165, 558, 1354},
	{1214, 558, 879},
	{966, 1635, 558},
	{966, 657, 203},
	{559, 770, 558},
	{1596, 1271, 558},
	{1596, 657, 140},
	{943, 657, 1242},
	{943, 1402, 114},
	{710, 1014, 1116},
	{1600, 1546, 1495},
	{31, 1044, 558},
	{905, 558, 979},
	{1533, 156, 558},
	{373, 657, 175},
	{373, 657, 175},
	{1175, 558, 267},
	{943, 1473, 657},
	{597, 882, 558},
	{761, 1056, 558},
	{78, 695, 619},
	{78, 558, 1179},
	{943, 674, 745},
	{943, 1130, 512},
	{943, 1102, 1099},
	{1241, 269, 558},
	{353, 558, 298},
	{353, 558, 298},
	{353, 558, 23},
	{600, 1279, 558},
	{161, 558, 969},
	{161, 657, 801},
	{641, 715, 558},
	{641, 1704, 558},
	{1247, 558, 654},
	{804, 558, 604},
	{325, 615, 166},
	{1577, 558, 1042},
	{1043, 558, 414},
	{325, 843, 1001},
	{1218, 1257, 558},
	{894, 1587, 558},
	{1393, 558, 490},
	{344, 1073, 557},
	{826, 657, 230},
	{344, 20, 585},
	{344, 558, 1316},
	{943, 73, 934},
	{248, 1465, 558},
	{1501, 1349, 558},
	{1501, 1349, 558},
	{1501, 558, 1349},
	{1501, 1349, 558},
	{943, 1049, 160},
	{477, 647, 558},
	{1149, 558, 264},
	{1565, 558, 1218},
	{1565, 558, 1218},
	{710, 248, 1276},
	{943, 1713, 501},
	{971, 1512, 558},
	{971, 258, 558},
	{971, 84, 558},
	{971, 788, 558},
	{971, 1057, 558},
	{971, 204, 558},
	{971, 1582, 558},
	{971, 1204, 558},
	{971, 712, 558},
	{971, 157, 558},
	{971, 1086, 558},
	{971, 487, 558},
	{971, 1239, 558},
	{971, 285, 558},
	{971, 1524, 558},
	{971, 273, 558},
	{971, 750, 558},
	{971, 932, 558},
	{971, 309, 558},
	{971, 219, 558},
	{710, 1360, 1091},
	{84, 558, 1106},
	{1679, 558, 1262},
	{943, 1438, 504},
	{943, 1228, 1574},
	{843, 558, 1640},
	{943, 119, 702},
	{328, 1006, 558},
	{879, 237, 119},
	{879, 724, 310},
	{710, 248, 1272},
	{503, 558, 270},
	{833, 1684, 558},
	{0, 558, 256},
	{335, 508, 1303},
	{1669, 1460, 558},
	{704, 681, 452},
	{704, 1691, 558},
	{534, 54, 737},
	{534, 1009, 1234},
	{534, 978, 450},
	{534, 1475, 162},
	{534, 1405, 727},
	{534, 263, 858},
	{534, 679, 1136},
	{534, 1494, 1653},
	{251, 558, 1028},
	{251, 353, 558},
	{251, 353, 558},
	{251, 558, 353},
	{251, 558, 353},
	{1708, 19, 558},
	{1060, 54, 1108},
	{1060, 1150, 991},
	{1060, 1473, 1287},
	{1060, 1188, 1302},
	{1060, 892, 1405},
	{1060, 1503, 166},
	{1060, 833, 1336},
	{1060, 1001, 493},
	{943, 1065, 1124},
	{1571, 1144, 558},
	{1194, 558, 439},
	{848, 558, 1178},
	{943, 824, 398},
	{1465, 728, 558},
	{388, 972, 1372},
	{825, 558, 1250},
	{943, 558, 742},
	{616, 558, 454},
	{1419, 558, 774},
	{390, 1258, 558},
	{1418, 1415, 558},
	{1564, 1147, 1299},
	{620, 558, 922},
	{620, 1115, 558},
	{1295, 558, 1238},
	{1295, 657, 1060},
	{943, 1209, 663},
	{710, 1181, 69},
	{943, 28, 171},
	{1247, 437, 558},
	{1710, 252, 558},
	{799, 1339, 558},
	{643, 558, 650},
	{643, 558, 650},
	{643, 558, 650},
	{643, 650, 558},
	{643, 650, 558},
	{643, 558, 650},
	{643, 558, 650},
	{102, 657, 1156},
	{102, 657, 1156},
	{102, 657, 1156},
	{102, 657, 1156},
	{102, 657, 1156},
	{102, 657, 1156},
	{102, 657, 1156},
	{1314, 558, 592},
	{1314, 1327, 1617},
	{1083, 302, 558},
	{1083, 1019, 558},
	{1200, 558, 648},
	{1435, 548, 558},
	{1020, 1277, 558},
	{1436, 1723, 558},
	{1436, 558, 1614},
	{1184, 1631, 903},
	{943, 1651, 657},
	{372, 1085, 1172},
	{248, 912, 1290},
	{273, 558, 773},
	{964, 558, 17},
	{964, 558, 1536},
	{663, 558, 535},
	{470, 1286, 558},
	{127, 135, 558},
	{872, 558, 901},
	{1245, 299, 1723},
	{1152, 1340, 657},
	{1152, 1340, 657},
	{1152, 657, 1340},
	{1152, 657, 1340},
	{1152, 1340, 657},
	{1560, 1081, 558},
	{1609, 1329, 558},
	{1450, 1499, 558},
	{926, 558, 1712},
	{1170, 661, 566},
	{943, 1326, 1073},
	{466, 558, 7},
	{466, 657, 471},
	{1258, 384, 558},
	{193, 22, 558},
	{289, 997, 558},
	{943, 1358, 521},
	{318, 558, 1444},
	{1545, 1443, 657},
	{710, 644, 428},
	{1171, 558, 519},
	{1574, 1089, 558},
	{776, 558, 1219},
	{305, 184, 558},
	{1411, 1079, 558},
	{849, 558, 247},
	{862, 1211, 558},
	{94, 558, 1024},
	{933, 558, 877},
	{523, 1657, 1406},
	{523, 875, 1659},
	{523, 558, 743},
	{1646, 558, 513},
	{1230, 708, 558},
	{1230, 657, 549},
	{59, 304, 1398},
	{59, 143, 957},
	{947, 558, 1654},
	{377, 558, 232},
	{1468, 413, 332},
	{758, 1622, 558},
	{81, 558, 1190},
	{943, 1300, 1182},
	{270, 922, 1544},
	{270, 1115, 558},
	{1691, 558, 110},
	{1691, 558, 1023},
	{868, 723, 558},
	{746, 794, 558},
	{746, 288, 558},
	{546, 1681, 558},
	{43, 1270, 558},
	{1247, 898, 558},
	{119, 558, 1626},
	{500, 1390, 1197},
	{500, 558, 174},
	{188, 690, 558},
	{1303, 782, 1040},
	{1160, 212, 558},
	{449, 558, 819},
	{1302, 457, 558},
	{1033, 558, 1015},
	{414, 1611, 1299},
	{325, 305, 1188},
	{943, 11, 55},
	{1274, 558, 1069},
	{710, 913, 1274},
	{1311, 558, 604},
	{23, 558, 298},
	{23, 657, 1501},
	{968, 1093, 558},
	{943, 1705, 1020},
	{199, 558, 781},
	{199, 558, 1422},
	{334, 558, 118},
	{700, 619, 558},
	{157, 558, 1090},
	{1129, 558, 1467},
	{1633, 657, 736},
	{1633, 657, 736},
	{1633, 657, 736},
	{1633, 657, 736},
	{1633, 657, 736},
	{901, 1556, 558},
	{901, 867, 558},
	{647, 1220, 558},
	{1067, 821, 558},
	{943, 541, 1320},
	{710, 1409, 916},
	{666, 558, 862},
	{1323, 283, 558},
	{535, 558, 1206},
	{1185, 1215, 558},
	{201, 1433, 558},
	{493, 1200, 558},
	{493, 558, 744},
	{636, 558, 967},
	{855, 268, 657},
	{855, 268, 657},
	{855, 268, 657},
	{855, 268, 657},
	{855, 268, 657},
	{248, 558, 1343},
	{646, 202, 558},
	{943, 558, 881},
	{1056, 1080, 739},
	{943, 1539, 657},
	{878, 631, 558},
	{916, 558, 1185},
	{967, 558, 272},
	{943, 80, 1333},
	{1671, 571, 558},
	{1671, 558, 302},
	{1671, 1019, 558},
	{1671, 558, 1294},
	{1516, 1306, 558},
	{1516, 558, 1306},
	{1516, 1306, 558},
	{196, 558, 1468},
	{271, 558, 1058},
	{710, 1039, 24},
	{857, 558, 1649},
	{857, 558, 1377},
	{943, 1101, 190},
	{164, 412, 558},
	{943, 993, 20},
	{0, 726, 558},
	{1455, 1412, 558},
	{1346, 558, 1296},
	{1346, 359, 657},
	{1324, 558, 1455},
	{214, 765, 1001},
	{847, 558, 104},
	{1243, 558, 1455},
	{676, 558, 148},
	{676, 148, 558},
	{676, 558, 148},
	{676, 148, 558},
	{676, 558, 148},
	{676, 558, 148},
	{676, 558, 148},
	{748, 558, 1241},
	{1296, 399, 657},
	{785, 558, 267},
	{1028, 353, 657},
	{1159, 558, 450},
	{1431, 1578, 558},
	{238, 1215, 558},
	{969, 801, 558},
	{232, 558, 585},
	{232, 1704, 558},
	{232, 558, 1316},
	{943, 1177, 1069},
	{1429, 1315, 558},
	{1429, 381, 558},
	{943, 1442, 1045},
	{1481, 558, 1134},
	{943, 728, 357},
	{781, 558, 160},
	{1481, 558, 912},
	{943, 1652, 385},
	{558, 1005, 558},
	{646, 470, 558},
	{943, 1194, 99},
	{727, 556, 558},
	{932, 368, 558},
	{932, 558, 1352},
	{1121, 291, 558},
	{981, 558, 733},
	{943, 107, 66},
	{1143, 475, 657},
	{1143, 558, 1677},
	{1143, 558, 999},
	{943, 957, 394},
	{1285, 1506, 558},
	{1285, 1510, 1122},
	{1447, 558, 1175},
	{1327, 808, 558},
	{959, 1154, 558},
	{171, 558, 1493},
	{171, 558, 1493},
	{171, 558, 1493},
	{171, 558, 1493},
	{345, 1475, 1686},
	{345, 558, 1097},
	{1138, 558, 767},
	{710, 1387, 240},
	{815, 558, 1193},
	{1292, 558, 1065},
	{829, 667, 558},
	{98, 1434, 558},
	{1505, 830, 558},
	{757, 1030, 558},
	{710, 1718, 671},
	{192, 1130, 558},
	{1024, 558, 1069},
	{943, 1231, 1176},
	{1062, 1429, 558},
	{1171, 558, 358},
	{1222, 558, 1090},
	{382, 558, 1717},
	{1186, 1216, 54},
	{336, 1459, 482},
	{558, 159, 558},
	{1579, 558, 221},
	{1042, 1119, 892},
	{1591, 374, 558},
	{1042, 439, 1302},
	{1042, 77, 833},
	{507, 279, 558},
	{507, 186, 1082},
	{710, 961, 1266},
	{200, 558, 1486},
	{200, 293, 1367},
	{200, 558, 57},
	{353, 1501, 558},
	{353, 1501, 558},
	{943, 952, 1509},
	{222, 97, 558},
	{938, 1245, 558},
	{99, 558, 1644},
	{108, 1666, 558},
	{850, 1446, 558},
	{850, 430, 558},
	{943, 1169, 1216},
	{943, 588, 529},
	{943, 483, 657},
	{943, 121, 657},
	{67, 558, 14},
	{1032, 558, 297},
	{1534, 558, 763},
	{1534, 1068, 657},
	{69, 1045, 558},
	{36, 1009, 1322},
	{36, 558, 735},
	{417, 657, 539},
	{417, 539, 657},
	{417, 539, 657},
	{417, 657, 539},
	{417, 657, 539},
	{417, 657, 539},
	{417, 539, 657},
	{967, 1211, 558},
	{967, 1211, 558},
	{1286, 1211, 558},
	{690, 558, 1612},
	{690, 558, 804},
	{690, 1311, 558},
	{690, 492, 558},
	{690, 1259, 558},
	{690, 558, 354},
	{690, 558, 341},
	{690, 558, 461},
	{690, 558, 352},
	{690, 558, 1589},
	{690, 1569, 558},
	{690, 281, 558},
	{1399, 657, 710},
	{398, 321, 558},
	{43, 692, 558},
	{1293, 620, 558},
	{936, 1122, 558},
	{348, 1194, 558},
	{350, 988, 558},
	{743, 558, 875},
	{743, 545, 609},
	{743, 558, 1547},
	{890, 558, 1694},
	{140, 1539, 1001},
	{140, 1336, 13},
	{325, 64, 54},
	{140, 407, 54},
	{710, 38, 558},
	{710, 558, 1247},
	{1252, 882, 558},
	{140, 1160, 1405},
	{140, 315, 1188},
	{140, 1651, 1287},
	{761, 233, 970},
	{761, 558, 762},
	{1201, 558, 1372},
	{840, 558, 1293},
	{115, 1439, 558},
	{97, 558, 1072},
	{97, 558, 769},
	{755, 558, 1170},
	{834, 657, 102},
	{75, 129, 558},
	{142, 1571, 558},
	{142, 427, 165},
	{574, 1628, 957},
	{574, 841, 250},
	{574, 681, 740},
	{574, 350, 1071},
	{574, 1063, 296},
	{574, 277, 477},
	{574, 336, 722},
	{574, 304, 1318},
	{233, 1205, 569},
	{943, 1282, 657},
	{1191, 657, 887},
	{1191, 657, 887},
	{1191, 657, 887},
	{1191, 657, 887},
	{1499, 558, 709},
	{1499, 657, 1201},
	{1549, 929, 558},
	{943, 414, 558},
	{943, 898, 558},
	{31, 558, 132},
	{918, 1583, 558},
	{336, 558, 112},
	{756, 1110, 558},
	{1331, 146, 1108},
	{1331, 929, 991},
	{1331, 1618, 1473},
	{1331, 1654, 1302},
	{1331, 892, 1344},
	{1331, 831, 1503},
	{1331, 326, 833},
	{1331, 1592, 493},
	{369, 540, 558},
	{1345, 1542, 1685},
	{1345, 1568, 558},
	{1649, 795, 558},
	{710, 1180, 1533},
	{1403, 558, 983},
	{1268, 558, 580},
	{287, 657, 1545},
	{287, 558, 1034},
	{287, 558, 994},
	{219, 558, 347},
	{140, 1150, 52},
	{984, 558, 1332},
	{610, 558, 582},
	{801, 1251, 1001},
	{1139, 937, 558},
	{943, 1500, 526},
	{801, 658, 1405},
	{47, 603, 558},
	{801, 518, 1336},
	{801, 733, 166},
	{49, 499, 558},
	{579, 558, 824},
	{862, 558, 445},
	{729, 558, 1185},
	{710, 738, 1519},
	{1540, 558, 734},
	{943, 1503, 657},
	{50, 558, 629},
	{943, 440, 151},
	{660, 1716, 558},
	{660, 1708, 558},
	{594, 558, 256},
	{39, 558, 208},
	{558, 558, 1349},
	{943, 927, 26},
	{628, 1335, 558},
	{628, 657, 1698},
	{943, 616, 460},
	{895, 558, 1233},
	{895, 558, 76},
	{895, 1658, 558},
	{895, 558, 786},
	{895, 558, 1664},
	{895, 558, 1612},
	{895, 558, 784},
	{895, 244, 558},
	{895, 1623, 558},
	{895, 558, 764},
	{895, 1311, 558},
	{895, 324, 558},
	{895, 857, 558},
	{895, 558, 1337},
	{895, 1355, 558},
	{895, 787, 558},
	{895, 558, 575},
	{895, 558, 1381},
	{895, 822, 558},
	{895, 131, 558},
	{895, 558, 1086},
	{895, 558, 1074},
	{895, 558, 1246},
	{895, 0, 558},
	{895, 558, 594},
	{895, 558, 1052},
	{895, 558, 1589},
	{895, 558, 446},
	{895, 309, 558},
	{895, 53, 558},
	{895, 1292, 558},
	{895, 558, 1155},
	{895, 558, 1569},
	{895, 558, 301},
	{895, 558, 950},
	{895, 558, 1710},
	{895, 1419, 558},
	{681, 558, 716},
	{283, 72, 1503},
	{143, 693, 558},
	{143, 1285, 558},
	{1031, 558, 604},
	{943, 1455, 1505},
	{1566, 1240, 558},
	{1566, 657, 863},
	{710, 1507, 864},
	{1133, 996, 558},
	{1704, 856, 919},
	{1704, 835, 558},
	{581, 838, 558},
	{397, 11, 1563},
	{1557, 134, 558},
	{283, 892, 208},
	{862, 1130, 558},
	{943, 657, 315},
	{943, 133, 558},
	{943, 161, 558},
	{418, 558, 332},
	{943, 740, 276},
	{1466, 558, 1000},
	{1257, 753, 558},
	{1257, 711, 558},
	{1257, 558, 569},
	{24, 440, 558},
	{64, 1025, 558},
	{58, 558, 1107},
	{943, 795, 360},
	{739, 679, 1554},
	{739, 558, 479},
	{943, 868, 1631},
	{0, 558, 272},
	{298, 657, 1349},
	{298, 657, 1349},
	{298, 657, 1349},
	{298, 657, 1349},
	{659, 558, 195},
	{659, 195, 558},
	{659, 195, 558},
	{659, 195, 558},
	{659, 558, 195},
	{659, 195, 558},
	{1698, 54, 146},
	{1698, 1150, 929},
	{1698, 1618, 1287},
	{1698, 1188, 1654},
	{1698, 1405, 1344},
	{1698, 166, 831},
	{1698, 326, 1336},
	{1698, 1592, 1001},
	{1468, 1282, 694},
	{943, 707, 642},
	{780, 1722, 558},
	{379, 558, 1704},
	{1125, 1512, 558},
	{1125, 558, 382},
	{1125, 1173, 558},
	{1125, 1543, 558},
	{1125, 76, 558},
	{1125, 245, 558},
	{1125, 786, 558},
	{1125, 1664, 558},
	{1125, 682, 558},
	{1125, 1482, 558},
	{1125, 552, 558},
	{1125, 1487, 558},
	{1125, 764, 558},
	{1125, 1057, 558},
	{1125, 58, 558},
	{1125, 1520, 558},
	{1125, 1381, 558},
	{1125, 257, 558},
	{1125, 1324, 558},
	{1125, 179, 558},
	{1125, 558, 131},
	{1125, 4, 558},
	{1125, 1396, 558},
	{1125, 167, 558},
	{1125, 354, 558},
	{1125, 1086, 558},
	{1125, 1074, 558},
	{1125, 558, 273},
	{1125, 594, 558},
	{1125, 677, 558},
	{1125, 447, 558},
	{1125, 1052, 558},
	{1125, 558, 791},
	{1125, 750, 558},
	{1125, 932, 558},
	{1125, 1589, 558},
	{1125, 309, 558},
	{1125, 1430, 558},
	{1125, 1292, 558},
	{1125, 1114, 558},
	{1125, 1226, 558},
	{1125, 1006, 558},
	{1125, 1164, 558},
	{1125, 950, 558},
	{1125, 281, 558},
	{1125, 1665, 558},
	{1125, 607, 558},
	{1125, 1419, 558},
	{1125, 1050, 558},
	{1255, 59, 558},
	{781, 1546, 558},
	{781, 558, 1457},
	{897, 558, 1369},
	{46, 1508, 558},
	{530, 558, 1559},
	{530, 558, 1632},
	{434, 558, 510},
	{1247, 414, 558},
	{630, 152, 558},
	{701, 558, 1572},
	{701, 558, 193},
	{335, 1352, 558},
	{1696, 558, 1156},
	{1696, 1156, 558},
	{1696, 1156, 558},
	{1696, 558, 1156},
	{1696, 1156, 558},
	{229, 407, 558},
	{192, 506, 558},
	{517, 925, 558},
	{934, 139, 558},
	{943, 1064, 1711},
	{1545, 657, 1443},
	{754, 648, 1181},
	{754, 1595, 558},
	{48, 292, 52},
	{710, 590, 1178},
	{1128, 558, 775},
	{48, 1670, 407},
	{713, 617, 558},
	{713, 676, 558},
	{943, 751, 1192},
	{489, 657, 1639},
	{489, 558, 1153},
	{489, 659, 558},
	{1018, 558, 100},
	{1220, 1469, 558},
	{231, 558, 778},
	{1430, 558, 368},
	{877, 911, 558},
	{877, 911, 558},
	{300, 558, 847},
	{133, 558, 602},
	{133, 657, 1263},
	{709, 1201, 558},
	{1216, 987, 558},
	{318, 558, 1293},
	{1393, 558, 1075},
	{1704, 558, 1007},
	{236, 176, 558},
	{741, 1551, 652},
	{741, 205, 1206},
	{741, 948, 27},
	{741, 49, 1301},
	{741, 502, 1496},
	{741, 584, 141},
	{741, 1670, 1722},
	{741, 292, 209},
	{943, 515, 1411},
	{665, 616, 558},
	{203, 558, 315},
	{203, 558, 1651},
	{203, 558, 483},
	{203, 558, 1160},
	{1228, 550, 558},
	{203, 558, 1539},
	{203, 558, 13},
	{360, 1230, 558},
	{204, 1118, 558},
	{1289, 632, 1058},
	{197, 558, 198},
	{197, 558, 198},
	{888, 558, 1092},
	{879, 1675, 74},
	{879, 1609, 1378},
	{270, 1692, 1082},
	{407, 1668, 558},
	{487, 558, 824},
	{1068, 1432, 583},
	{1068, 96, 1621},
	{182, 1619, 558},
	{943, 126, 1486},
	{788, 152, 558},
	{974, 558, 1492},
	{1357, 378, 558},
	{1161, 732, 558},
	{1302, 558, 1621},
	{646, 558, 182},
	{607, 558, 347},
	{710, 1267, 1298},
	{1613, 558, 42},
	{1613, 657, 643},
	{901, 558, 1682},
	{901, 558, 1362},
	{943, 940, 378},
	{248, 558, 187},
	{248, 558, 1718},
	{1623, 558, 837},
	{747, 1163, 657},
	{358, 558, 1715},
	{438, 1437, 208},
	{438, 72, 1630},
	{438, 121, 1458},
	{438, 1647, 1299},
	{438, 413, 488},
	{438, 976, 1282},
	{438, 1242, 481},
	{438, 723, 684},
	{854, 975, 558},
	{1345, 558, 1500},
	{943, 635, 289},
	{1404, 558, 133},
	{1193, 558, 1242},
	{833, 558, 1416},
	{1276, 930, 558},
	{1276, 930, 558},
	{1400, 558, 83},
	{1509, 611, 558},
	{684, 558, 1507},
	{839, 43, 657},
	{943, 484, 536},
	{43, 6, 558},
	{1235, 1539, 1206},
	{1235, 13, 652},
	{1235, 483, 1301},
	{1235, 1160, 27},
	{1235, 315, 141},
	{1235, 1651, 1496},
	{1235, 52, 209},
	{1235, 407, 1722},
	{1440, 605, 779},
	{1201, 558, 700},
	{943, 1062, 381},
	{710, 1129, 558},
	{1642, 558, 1352},
	{1041, 211, 657},
	{1041, 657, 211},
	{1041, 657, 211},
	{1041, 657, 211},
	{1041, 211, 657},
	{178, 1254, 558},
	{178, 1195, 558},
	{178, 657, 1191},
	{389, 300, 558},
	{1541, 558, 491},
	{1541, 437, 657},
	{943, 558, 431},
	{1639, 657, 195},
	{475, 1237, 657},
	{353, 558, 1072},
	{353, 558, 1072},
	{1008, 1189, 558},
	{1008, 558, 1511},
	{410, 344, 814},
	{410, 557, 558},
	{308, 558, 375},
	{308, 558, 65},
	{943, 706, 678},
	{561, 558, 533},
	{410, 558, 474},
	{1423, 558, 1608},
	{1423, 869, 657},
	{710, 168, 836},
	{1297, 1392, 558},
	{943, 1699, 1024},
	{364, 558, 1232},
	{710, 468, 18},
	{59, 404, 296},
	{389, 1649, 558},
	{1487, 558, 1464},
	{59, 1632, 277},
	{18, 558, 378},
	{1570, 1480, 379},
	{943, 833, 657},
	{440, 1681, 905},
	{943, 213, 576},
	{943, 862, 537},
	{710, 789, 158},
	{1166, 1685, 558},
	{1166, 1568, 558},
	{1660, 558, 855},
	{1660, 1100, 657},
	{1134, 558, 1712},
	{1050, 1006, 558},
	{779, 656, 1594},
	{297, 558, 1032},
	{556, 558, 1344},
	{1689, 558, 1196},
	{1315, 558, 826},
	{1265, 1202, 558},
	{1265, 1334, 558},
	{943, 733, 615},
	{1639, 657, 195},
	{158, 63, 558},
	{1373, 558, 1703},
	{1373, 558, 395},
	{1153, 558, 1639},
	{1153, 659, 657},
	{314, 761, 558},
	{781, 558, 1550},
	{943, 967, 1269},
	{1459, 558, 1390},
	{1459, 558, 174},
	{1396, 558, 11},
	{943, 199, 327},
	{943, 252, 338},
	{710, 187, 1579},
	{710, 627, 566},
	{1247, 1186, 558},
	{943, 306, 581},
	{1157, 1564, 558},
	{562, 558, 1374},
	{1266, 1453, 558},
	{1639, 195, 657},
	{1473, 744, 558},
	{893, 558, 314},
	{1473, 558, 1573},
	{625, 662, 558},
	{625, 657, 1186},
	{646, 558, 1172},
	{1284, 558, 464},
	{1284, 558, 464},
	{1284, 558, 464},
	{1122, 558, 505},
	{1122, 558, 433},
	{609, 558, 1213},
	{97, 1325, 657},
	{604, 558, 385},
	{1145, 522, 558},
	{737, 558, 5},
	{1512, 558, 1717},
	{943, 554, 17},
	{940, 558, 1615},
	{359, 399, 558},
	{359, 399, 558},
	{359, 558, 399},
	{359, 399, 558},
	{359, 558, 399},
	{359, 399, 558},
	{359, 399, 558},
	{790, 191, 558},
	{1204, 1107, 558},
	{1591, 558, 1638},
	{821, 768, 836},
	{206, 558, 465},
	{528, 558, 368},
	{1167, 316, 558},
	{1167, 558, 143},
	{217, 696, 558},
	{234, 210, 558},
	{234, 172, 558},
	{234, 1633, 657},
	{419, 1618, 558},
	{710, 43, 558},
	{710, 558, 1247},
	{710, 1247, 558},
	{162, 558, 947},
	{991, 558, 243},
	{859, 1535, 493},
	{859, 235, 833},
	{1576, 60, 558},
	{1576, 84, 558},
	{1576, 271, 558},
	{1576, 370, 558},
	{1576, 1612, 558},
	{1576, 784, 558},
	{1576, 204, 558},
	{1576, 804, 558},
	{1576, 1311, 558},
	{1576, 1428, 558},
	{1576, 492, 558},
	{1576, 1204, 558},
	{1576, 1259, 558},
	{1576, 342, 558},
	{1576, 857, 558},
	{1576, 712, 558},
	{1576, 776, 558},
	{1576, 1168, 558},
	{1576, 1721, 558},
	{1576, 487, 558},
	{1576, 579, 558},
	{1576, 1239, 558},
	{1576, 285, 558},
	{1576, 1524, 558},
	{1576, 0, 558},
	{1576, 1478, 558},
	{1576, 1210, 558},
	{1576, 461, 558},
	{1576, 660, 558},
	{1576, 1557, 558},
	{1576, 259, 558},
	{1576, 352, 558},
	{1576, 446, 558},
	{1576, 528, 558},
	{1576, 904, 558},
	{1576, 1569, 558},
	{1576, 1710, 558},
	{1576, 219, 558},
	{1576, 1385, 558},
	{710, 1147, 391},
	{859, 1432, 991},
	{859, 96, 1302},
	{859, 1473, 704},
	{859, 1678, 1503},
	{859, 1645, 892},
	{558, 806, 558},
	{943, 589, 578},
	{682, 1586, 558},
	{943, 768, 994},
	{1316, 1386, 426},
	{1316, 914, 558},
	{943, 657, 413},
	{943, 1229, 780},
	{1441, 41, 558},
	{1535, 1318, 1695},
	{1535, 558, 1398},
	{1316, 558, 20},
	{853, 558, 387},
	{519, 670, 558},
	{519, 558, 670},
	{283, 723, 1302},
	{283, 976, 991},
	{283, 493, 1647},
	{698, 558, 1481},
	{846, 1371, 558},
	{1201, 333, 558},
	{21, 228, 558},
	{21, 657, 48},
	{943, 1530, 1110},
	{1123, 765, 558},
	{1607, 661, 558},
	{1652, 1178, 558},
	{943, 1121, 1225},
	{1247, 549, 558},
	{655, 783, 558},
	{540, 227, 558},
	{602, 1263, 558},
	{710, 1661, 464},
	{611, 255, 558},
	{611, 741, 657},
	{248, 917, 558},
	{954, 558, 513},
	{1026, 558, 322},
	{1026, 171, 657},
	{1051, 455, 1082},
	{1200, 626, 1249},
	{943, 456, 191},
	{822, 558, 1455},
	{404, 918, 558},
	{404, 142, 558},
	{943, 558, 1331},
	{943, 558, 1698},
	{842, 558, 1479},
	{842, 657, 66},
	{713, 657, 1140},
	{1409, 1231, 558},
	{1228, 11, 558},
	{166, 1135, 558},
	{1522, 1695, 558},
	{1522, 558, 1398},
	{943, 364, 86},
	{70, 1117, 558},
	{1211, 10, 558},
	{637, 558, 1308},
	{1608, 349, 657},
	{1599, 807, 431},
	{1335, 558, 1698},
	{1665, 252, 558},
	{1247, 558, 1263},
	{1314, 1308, 1489},
	{1314, 637, 558},
	{596, 558, 819},
	{565, 558, 658},
	{1068, 1678, 1383},
	{1068, 235, 351},
	{1068, 1535, 423},
	{1605, 1294, 558},
	{927, 1112, 558},
	{958, 1449, 558},
	{943, 871, 777},
	{919, 1229, 835},
	{919, 1486, 1538},
	{919, 558, 200},
	{1211, 1655, 558},
	{1077, 558, 809},
	{1077, 558, 1410},
	{710, 705, 1668},
	{273, 1211, 558},
	{1492, 558, 1445},
	{1492, 558, 1457},
	{266, 558, 525},
	{1357, 558, 188},
	{710, 246, 123},
	{1415, 7, 657},
	{217, 558, 413},
	{440, 558, 813},
	{335, 558, 1280},
	{1234, 1549, 558},
	{302, 851, 558},
	{710, 1650, 94},
	{943, 1602, 506},
	{770, 558, 853},
	{249, 163, 558},
	{249, 1704, 558},
	{1, 890, 558},
	{1329, 558, 1601},
	{1329, 558, 382},
	{1329, 558, 1173},
	{1329, 558, 1233},
	{1329, 558, 1543},
	{1329, 558, 76},
	{1329, 558, 1540},
	{1329, 245, 558},
	{1329, 558, 786},
	{1329, 558, 1482},
	{1329, 558, 370},
	{1329, 558, 552},
	{1329, 558, 784},
	{1329, 558, 1623},
	{1329, 558, 403},
	{1329, 1311, 558},
	{1329, 558, 1355},
	{1329, 558, 257},
	{1329, 558, 179},
	{1329, 558, 1086},
	{1329, 558, 487},
	{1329, 558, 145},
	{1329, 558, 1478},
	{1329, 1557, 558},
	{1329, 558, 517},
	{1329, 558, 352},
	{1329, 558, 750},
	{1329, 558, 932},
	{1329, 558, 309},
	{1329, 558, 1569},
	{1329, 558, 301},
	{199, 558, 941},
	{256, 25, 558},
	{943, 633, 1059},
	{943, 1575, 40},
	{61, 1554, 558},
	{61, 558, 479},
	{85, 485, 558},
	{479, 679, 558},
	{873, 1088, 558},
	{259, 558, 134},
	{823, 444, 558},
	{840, 1433, 558},
	{1315, 657, 381},
	{83, 949, 523},
	{83, 558, 1406},
	{1220, 570, 558},
	{943, 799, 264},
	{943, 1693, 264},
	{992, 46, 558},
	{301, 558, 252},
	{745, 558, 241},
	{771, 558, 1446},
	{771, 430, 465},
	{1184, 474, 766},
	{1184, 558, 410},
	{1077, 1671, 558},
	{1077, 558, 1460},
	{838, 811, 558},
	{1112, 558, 26},
	{113, 558, 209},
	{710, 187, 759},
	{1108, 1687, 558},
	{943, 558, 1035},
	{541, 558, 1328},
	{129, 872, 1150},
	{1283, 587, 558},
	{129, 401, 54},
	{902, 558, 1109},
	{902, 558, 1109},
	{902, 558, 1289},
	{830, 1047, 558},
	{830, 534, 657},
	{1643, 558, 766},
	{1643, 1704, 558},
	{1643, 558, 410},
	{1077, 558, 1587},
	{1077, 558, 540},
	{1044, 1408, 1000},
	{943, 1379, 215},
	{986, 1279, 345},
	{247, 1722, 1108},
	{247, 991, 209},
	{247, 1473, 1496},
	{247, 141, 1302},
	{247, 27, 892},
	{247, 1301, 1503},
	{247, 833, 652},
	{247, 493, 1206},
	{943, 1128, 869},
	{1674, 772, 558},
	{909, 446, 558},
	{909, 528, 558},
	{909, 0, 558},
	{909, 1210, 558},
	{909, 1385, 558},
	{909, 370, 558},
	{909, 784, 558},
	{909, 776, 558},
	{909, 1168, 558},
	{943, 104, 1221},
	{943, 558, 1186},
	{943, 1263, 558},
	{943, 558, 325},
	{943, 558, 801},
	{710, 47, 420},
	{937, 558, 1706},
	{937, 558, 1704},
	{937, 558, 1345},
	{1132, 717, 558},
	{710, 666, 1380},
	{1382, 334, 558},
	{617, 676, 657},
	{710, 1474, 527},
	{630, 1705, 558},
	{1518, 898, 558},
	{996, 1710, 558},
	{996, 558, 1601},
	{996, 558, 382},
	{996, 558, 1173},
	{996, 1233, 558},
	{996, 1658, 558},
	{996, 1664, 558},
	{996, 1482, 558},
	{996, 665, 558},
	{996, 558, 286},
	{996, 558, 271},
	{996, 558, 370},
	{996, 552, 558},
	{996, 1612, 558},
	{996, 1487, 558},
	{996, 784, 558},
	{996, 764, 558},
	{996, 558, 1582},
	{996, 558, 1031},
	{996, 558, 804},
	{996, 1311, 558},
	{996, 1520, 558},
	{996, 857, 558},
	{996, 712, 558},
	{996, 1337, 558},
	{996, 558, 1381},
	{996, 558, 776},
	{996, 558, 157},
	{996, 257, 558},
	{996, 131, 558},
	{996, 4, 558},
	{996, 303, 558},
	{996, 1721, 558},
	{996, 558, 1086},
	{996, 558, 487},
	{996, 558, 579},
	{996, 1239, 558},
	{996, 0, 558},
	{996, 1478, 558},
	{996, 594, 558},
	{996, 660, 558},
	{996, 558, 1557},
	{996, 558, 259},
	{996, 558, 1052},
	{996, 791, 558},
	{996, 352, 558},
	{996, 750, 558},
	{996, 932, 558},
	{996, 1589, 558},
	{996, 558, 446},
	{996, 558, 528},
	{996, 558, 309},
	{996, 1430, 558},
	{996, 1292, 558},
	{996, 1646, 558},
	{996, 1114, 558},
	{996, 1476, 558},
	{996, 558, 1226},
	{996, 558, 1569},
	{996, 558, 950},
	{996, 1050, 558},
	{996, 1419, 558},
	{996, 1164, 558},
	{312, 995, 558},
	{312, 854, 742},
	{988, 1425, 558},
	{710, 1291, 1382},
	{717, 558, 926},
	{717, 558, 1087},
	{1034, 558, 1545},
	{1034, 994, 657},
	{1690, 558, 1410},
	{1302, 558, 744},
	{40, 1558, 558},
	{40, 558, 12},
	{1282, 558, 1016},
	{393, 551, 558},
	{943, 596, 1085},
	{943, 1175, 685},
	{1291, 1312, 558},
	{592, 1013, 532},
	{592, 558, 1217},
	{1021, 1510, 558},
	{809, 365, 558},
	{90, 558, 77},
	{852, 1454, 558},
	{852, 260, 558},
	{324, 1107, 1555},
	{769, 558, 1325},
	{769, 657, 1072},
	{900, 558, 1643},
	{147, 1393, 1393},
	{147, 1393, 558},
	{147, 1393, 558},
	{147, 558, 1393},
	{147, 558, 1393},
	{147, 558, 1393},
	{147, 558, 1393},
	{147, 558, 1393},
	{147, 558, 1393},
	{1473, 1376, 558},
	{365, 558, 125},
	{537, 363, 558},
	{993, 731, 558},
	{753, 263, 1203},
	{753, 558, 1629},
	{926, 827, 558},
	{943, 632, 339},
	{1364, 558, 108},
	{1364, 657, 1666},
	{425, 558, 953},
	{1467, 943, 558},
	{1467, 943, 558},
	{1467, 943, 558},
	{1467, 558, 943},
	{56, 558, 720},
	{260, 558, 1494},
	{735, 1009, 558},
	{1242, 935, 558},
	{5, 558, 146},
	{1462, 438, 558},
	{1115, 1544, 558},
	{1394, 558, 1658},
	{1394, 558, 985},
	{1394, 558, 1664},
	{1394, 558, 682},
	{1394, 558, 665},
	{1394, 558, 286},
	{1394, 558, 271},
	{1394, 558, 1612},
	{1394, 558, 1487},
	{1394, 558, 244},
	{1394, 558, 1520},
	{1394, 558, 324},
	{1394, 558, 712},
	{1394, 558, 787},
	{1394, 558, 575},
	{1394, 558, 1466},
	{1394, 558, 776},
	{1394, 558, 822},
	{1394, 558, 131},
	{1394, 558, 1420},
	{1394, 558, 4},
	{1394, 558, 167},
	{1394, 558, 303},
	{1394, 558, 1504},
	{1394, 558, 579},
	{1394, 558, 0},
	{1394, 558, 259},
	{1394, 558, 528},
	{1394, 558, 1430},
	{1394, 558, 1646},
	{1394, 558, 1155},
	{1394, 558, 1476},
	{1394, 558, 1226},
	{1394, 558, 1164},
	{1438, 1497, 558},
	{1254, 887, 558},
	{1254, 558, 887},
	{1254, 558, 887},
	{1254, 558, 887},
	{540, 302, 558},
	{540, 558, 365},
	{540, 1294, 558},
	{236, 558, 506},
	{1580, 1656, 558},
	{1580, 1159, 558},
	{1573, 845, 1550},
	{430, 959, 558},
	{1263, 578, 166},
	{1263, 1724, 1336},
	{1256, 558, 574},
	{1263, 1694, 1287},
	{1263, 242, 1188},
	{1263, 436, 1405},
	{224, 558, 520},
	{224, 657, 37},
	{1719, 558, 831},
	{1144, 558, 570},
	{1329, 1394, 558},
	{248, 558, 879},
	{1599, 558, 538},
	{1296, 657, 399},
	{103, 558, 1599},
	{943, 1391, 1577},
	{531, 558, 1255},
	{531, 657, 59},
	{63, 657, 298},
	{943, 668, 999},
	{821, 1298, 907},
	{943, 1106, 1404},
	{498, 558, 240},
	{498, 558, 240},
	{498, 558, 240},
	{1612, 558, 1464},
	{712, 558, 1649},
	{801, 767, 1150},
	{1432, 841, 189},
	{1432, 558, 155},
	{662, 1186, 558},
	{469, 558, 33},
	{1232, 86, 558},
	{1232, 558, 1676},
	{1232, 634, 657},
	{1434, 558, 1709},
	{752, 558, 1389},
	{681, 558, 216},
	{130, 639, 558},
	{275, 104, 558},
	{1019, 1515, 851},
	{1019, 231, 558},
	{731, 1458, 558},
	{248, 558, 1120},
	{248, 1039, 2},
	{342, 558, 300},
	{1398, 117, 558},
	{1398, 558, 1241},
	{617, 558, 1140},
	{1527, 1295, 558},
	{125, 1515, 558},
	{1625, 558, 90},
	{1476, 1379, 558},
	{1697, 275, 558},
	{1168, 558, 595},
	{143, 623, 558},
	{782, 1347, 558},
	{366, 934, 558},
	{898, 622, 72},
	{898, 900, 208},
	{898, 1611, 1647},
	{898, 377, 1458},
	{898, 1022, 976},
	{898, 1139, 488},
	{898, 1359, 723},
	{898, 655, 481},
	{140, 483, 166},
	{1468, 618, 121},
	{483, 558, 254},
	{336, 558, 1038},
	{1542, 515, 1158},
	{1542, 558, 1253},
	{1247, 984, 558},
	{576, 558, 870},
	{576, 558, 870},
	{576, 558, 870},
	{1253, 558, 515},
	{934, 558, 160},
	{837, 1689, 558},
	{590, 558, 910},
	{1700, 332, 54},
	{493, 558, 423},
	{943, 974, 774},
	{943, 934, 968},
	{943, 1196, 415},
	{943, 680, 1688},
	{1528, 106, 558},
	{303, 558, 669},
	{437, 121, 235},
	{437, 1299, 1535},
	{1608, 349, 657},
	{437, 1282, 1432},
	{437, 1437, 1645},
	{437, 1678, 1630},
	{943, 1126, 1465},
	{437, 684, 96},
	{943, 19, 899},
	{725, 558, 1179},
	{930, 1286, 558},
	{1005, 558, 718},
	{558, 1591, 558},
	{943, 1618, 978},
	{945, 558, 111},
	{943, 304, 1123},
	{650, 896, 558},
	{1002, 1211, 558},
	{1416, 1470, 299},
	{952, 152, 558},
	{862, 558, 272},
	{258, 1717, 1351},
	{1263, 1709, 1150},
	{669, 1228, 558},
	{558, 1393, 558},
	{943, 1374, 1252},
	{1627, 1483, 558},
	{1627, 558, 1084},
	{936, 1707, 558},
	{936, 388, 558},
	{943, 727, 1344},
	{502, 558, 1265},
	{1640, 558, 1251},
	{865, 558, 420},
	{1032, 645, 558},
	{1384, 60, 558},
	{1384, 1512, 558},
	{1384, 382, 558},
	{1384, 1173, 558},
	{1384, 84, 558},
	{1384, 1543, 558},
	{1384, 76, 558},
	{1384, 245, 558},
	{1384, 786, 558},
	{1384, 1664, 558},
	{1384, 682, 558},
	{1384, 1482, 558},
	{1384, 271, 558},
	{1384, 370, 558},
	{1384, 552, 558},
	{1384, 1612, 558},
	{1384, 1487, 558},
	{1384, 784, 558},
	{1384, 1582, 558},
	{1384, 804, 558},
	{1384, 1311, 558},
	{1384, 1428, 558},
	{1384, 492, 558},
	{1384, 1204, 558},
	{1384, 1520, 558},
	{1384, 1259, 558},
	{1384, 342, 558},
	{1384, 857, 558},
	{1384, 712, 558},
	{1384, 776, 558},
	{1384, 157, 558},
	{1384, 257, 558},
	{1384, 1324, 558},
	{1384, 179, 558},
	{1384, 131, 558},
	{1384, 4, 558},
	{1384, 1396, 558},
	{1384, 167, 558},
	{1384, 1168, 558},
	{1384, 1721, 558},
	{1384, 1086, 558},
	{1384, 1074, 558},
	{1384, 487, 558},
	{1384, 579, 558},
	{1384, 1239, 558},
	{1384, 1524, 558},
	{1384, 0, 558},
	{1384, 1478, 558},
	{1384, 1210, 558},
	{1384, 461, 558},
	{1384, 660, 558},
	{1384, 1557, 558},
	{1384, 259, 558},
	{1384, 791, 558},
	{1384, 352, 558},
	{1384, 750, 558},
	{1384, 932, 558},
	{1384, 446, 558},
	{1384, 528, 558},
	{1384, 1430, 558},
	{1384, 1292, 558},
	{1384, 1114, 558},
	{1384, 1226, 558},
	{1384, 1569, 558},
	{1384, 1665, 558},
	{1384, 1050, 558},
	{1384, 1419, 558},
	{1384, 1385, 558},
	{1384, 1164, 558},
	{1384, 1006, 558},
	{943, 1712, 45},
	{1561, 558, 871},
	{1210, 726, 558},
	{1210, 558, 256},
	{1463, 558, 1076},
	{1463, 657, 147},
	{183, 558, 1711},
	{257, 558, 1455},
	{943, 64, 564},
	{943, 659, 429},
	{1213, 1209, 558},
	{228, 558, 48},
	{1224, 558, 186},
	{495, 558, 1414},
	{1277, 558, 1441},
	{1277, 657, 41},
	{248, 558, 781},
	{248, 558, 781},
	{134, 930, 558},
	{134, 467, 558},
	{943, 449, 67},
	{811, 1080, 558},
	{811, 1205, 100},
	{943, 991, 657},
	{809, 558, 1641},
	{609, 1192, 1547},
	{609, 1209, 1264},
	{1412, 558, 384},
	{1349, 62, 558},
	{710, 1338, 720},
	{1464, 558, 1109},
	{710, 227, 703},
	{943, 166, 657},
	{943, 548, 181},
	{710, 1095, 1306},
	{710, 558, 43},
	{710, 558, 839},
	{1049, 558, 507},
	{338, 558, 954},
	{549, 1001, 1522},
	{615, 981, 558},
	{598, 1260, 558},
	{310, 558, 328},
	{1539, 494, 558},
	{943, 13, 657},
	{943, 657, 1299},
	{180, 501, 558},
	{1102, 976, 558},
	{1048, 239, 192},
	{184, 558, 1531},
	{943, 1199, 1485},
	{943, 824, 56},
	{943, 886, 558},
	{639, 524, 1307},
	{639, 577, 28},
	{639, 738, 364},
	{639, 463, 1513},
	{1630, 1094, 558},
	{264, 558, 1712},
	{461, 261, 558},
	{461, 726, 558},
	{879, 380, 1077},
	{1713, 238, 558},
	{1628, 623, 1354},
	{907, 558, 713},
	{414, 1022, 1282},
	{414, 413, 1139},
	{414, 1359, 684},
	{414, 1242, 655},
	{414, 622, 1630},
	{414, 1437, 900},
	{414, 121, 377},
	{248, 558, 1185},
	{1108, 558, 744},
	{1271, 140, 558},
	{159, 558, 312},
	{129, 1637, 1287},
	{499, 558, 1659},
	{499, 558, 743},
	{950, 252, 558},
	{1029, 558, 618},
	{943, 1341, 695},
	{475, 1237, 657},
	{874, 1435, 1001},
	{642, 1340, 558},
	{642, 1340, 558},
	{642, 1340, 558},
	{642, 1340, 558},
	{1002, 152, 558},
	{572, 558, 1407},
	{943, 1078, 334},
	{1479, 451, 657},
	{1479, 451, 657},
	{1479, 451, 657},
	{1479, 657, 451},
	{1479, 451, 657},
	{1648, 558, 1521},
	{323, 14, 558},
	{355, 558, 593},
	{355, 657, 1700},
	{392, 814, 558},
	{392, 557, 558},
	{794, 82, 558},
	{794, 82, 558},
	{794, 558, 82},
	{794, 558, 82},
	{794, 82, 558},
	{794, 82, 558},
	{794, 82, 558},
	{943, 1155, 1436},
	{943, 696, 610},
	{1146, 811, 558},
	{248, 1440, 558},
	{841, 558, 936},
	{63, 1501, 558},
	{63, 23, 558},
	{1247, 801, 558},
	{43, 1230, 558},
	{122, 570, 558},
	{649, 1313, 558},
	{649, 640, 558},
	{1332, 452, 558},
	{1332, 1691, 558},
	{934, 1196, 558},
	{943, 558, 1585},
	{1270, 558, 1518},
	{1270, 898, 657},
	{1188, 432, 558},
	{1188, 432, 558},
	{906, 558, 714},
	{906, 558, 214},
	{1017, 558, 578},
	{1338, 462, 558},
	{1382, 1350, 558},
	{7, 657, 1591},
	{7, 657, 1591},
	{7, 657, 1591},
	{680, 558, 1526},
	{943, 629, 760},
	{967, 558, 1427},
	{1001, 852, 558},
	{1001, 852, 558},
	{138, 211, 558},
	{138, 211, 558},
	{138, 211, 558},
	{138, 211, 558},
	{943, 1649, 1027},
	{926, 558, 187},
	{638, 1118, 604},
	{1358, 396, 558},
	{634, 657, 435},
	{634, 657, 435},
	{634, 657, 435},
	{634, 657, 435},
	{634, 435, 657},
	{1542, 1099, 1568},
	{1253, 1184, 1498},
	{1253, 903, 558},
	{827, 558, 1471},
	{386, 392, 558},
	{386, 1704, 558},
	{943, 700, 1565},
	{329, 1166, 558},
	{329, 1704, 558},
	{492, 1107, 558},
	{1072, 1005, 558},
	{1072, 558, 1005},
	{1072, 1005, 558},
	{1072, 558, 1005},
	{1072, 1005, 558},
	{1072, 558, 1005},
	{1072, 1005, 558},
	{1072, 558, 1005},
	{1571, 486, 547},
	{1571, 817, 558},
	{826, 230, 657},
	{218, 558, 1716},
	{943, 1594, 688},
	{1395, 558, 67},
	{1395, 67, 558},
	{215, 941, 1111},
	{59, 155, 250},
	{1504, 558, 669},
	{6, 558, 282},
	{6, 874, 657},
	{145, 1280, 1037},
	{43, 35, 558},
	{991, 558, 583},
	{448, 730, 558},
	{678, 558, 1567},
	{943, 361, 1319},
	{943, 758, 93},
	{951, 1152, 558},
	{951, 642, 657},
	{943, 1287, 657},
	{943, 1190, 752},
	{943, 892, 657},
	{1258, 1130, 558},
	{1619, 558, 586},
	{923, 356, 558},
	{923, 1334, 558},
	{923, 810, 558}
};
