/*
 Copyright (c) 2011 Ijor, Segher Boessenkool, Ed Spittles

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
*/

var nodenames ={
gnd: 663,      // pads: ground
vcc: 31,       // pads: power
phi1: 1507,    // pads: phase 1 clock input
phi2: 1511,    // pads: phase 2 clock input
reset: 1461,   // pads: reset

db0: 686,       // pads: data bus (should really be called d)
db1: 683,
db2: 677,
db3: 676,
db4: 669,
db5: 670,
db6: 664,
db7: 691,

ab0: 1854,       // pads: address bus (should really be called a)
ab1: 1857,
ab2: 1855,
ab3: 1858,
ab4: 1856,
ab5: 1859,
ab6: 1860,
ab7: 1865,
ab8: 1861,
ab9: 1863,
ab10: 1862,
ab11: 1864,
ab12: 1948,
ab13: 1946,
ab14: 1949,
ab15: 1947,

irq: 1496,     // input pads: interrupt request (active low)
nmi: 1501,     // pads: non maskable interrupt (active low)
dbe: 1456,     // pads: data bus enable
halt: 1492,    // pads: halt (active low)
tsc: 1459,     // pads: tristate control
rw: 1965,      // output pads: read / not write
vma: 1971,     // pads: valid memory address
ba: 1964,      // pads: bus available
//

// major internal busses

idb0: 610,  // internal databus (should be called db)
idb1: 1593,
idb2: 387,
idb3: 386,
idb4: 311,
idb5: 310,
idb6: 393,
idb7: 1651,

abh0: 267, // internal bus: address bus high
abh1: 258,
abh2: 266,
abh3: 257,
abh4: 265,
abh5: 256,
abh6: 259,
abh7: 255,

abl0: 1670,  // internal bus: address bus low
abl1: 1671,
abl2: 1653,
abl3: 1667,
abl4: 1655,
abl5: 1657,
abl6: 1656,
abl7: 1658,

ablx0: 1683,  // internal bus: extension of abl bus
ablx1: 1682,
ablx2: 1689,
ablx3: 1687,
ablx4: 1694,
ablx5: 1693,
ablx6: 1698,
ablx7: 1697,

i0: 1271,  // pla word lines
i1: 1269,
i2: 1268,
i3: 1267,
i4: 1265,
i5: 1264,
i6: 1263,
i7: 1261,

// programmer-visible state

flagc: 1160, // status word flags
flagh: 785,
flagi: 1007,
flagn: 1005,
flagv: 1124,
flagz: 1026,

acca0: 1934,  // a register: accumulator a
acca1: 1688,
acca2: 1700,
acca3: 1699,
acca4: 1701,
acca5: 1702,
acca6: 1703,
acca7: 1784,

accb0: 1919,  // b register: accumulator b
accb1: 1927,
accb2: 1921,
accb3: 1929,
accb4: 1923,
accb5: 1931,
accb6: 1925,
accb7: 1933,

ixh0: 1910, // index register high
ixh1: 1914,
ixh2: 1911,
ixh3: 1915,
ixh4: 1912,
ixh5: 1916,
ixh6: 1913,
ixh7: 1917,
ixl0: 1918, // index register low
ixl1: 1926,
ixl2: 1920,
ixl3: 1928,
ixl4: 1922,
ixl5: 1930,
ixl6: 1924,
ixl7: 1932,

pch0: 1878, // program counter high register
pch1: 1882,
pch2: 1879,
pch3: 1883,
pch4: 1880,
pch5: 1884,
pch6: 1881,
pch7: 1885,
pcl0: 1877, // program counter low register
pcl1: 1873,
pcl2: 1876,
pcl3: 1872,
pcl4: 1875,
pcl5: 1871,
pcl6: 1874,
pcl7: 1870,

sph0: 1909,  // stack pointer high register
sph1: 1908,
sph2: 1907,
sph3: 1906,
sph4: 1905,
sph5: 1904,
sph6: 1903,
sph7: 1902,
spl0: 1894,  // stack pointer low register
spl1: 1898,
spl2: 1895,
spl3: 1899,
spl4: 1896,
spl5: 1900,
spl6: 1897,
spl7: 1901,

// datapath state not visible to the programmer

tmp0: 1893, // non-visible temporary register
tmp1: 1892,
tmp2: 1891,
tmp3: 1890,
tmp4: 1889,
tmp5: 1888,
tmp6: 1887,
tmp7: 1886,

sum0: 644,  // alu output (phi2-latched)
sum1: 643,
sum2: 642,
sum3: 641,
sum4: 640,
sum5: 639,
sum6: 638,
sum7: 412,

dbi0: 608,  // data bus input register
dbi1: 599,
dbi2: 598,
dbi3: 400,
dbi4: 405,
dbi5: 395,
dbi6: 389,
dbi7: 650,

dbo0: 609,  // data bus output latch
dbo1: 602,
dbo2: 601,
dbo3: 402,
dbo4: 406,
dbo5: 397,
dbo6: 390,
dbo7: 649,

inch0: 198, // incrementer high output port
inch1: 199,
inch2: 200,
inch3: 201,
inch4: 202,
inch5: 203,
inch6: 204,
inch7: 205,
incl0: 154, // incrementer low output port
incl1: 143,
incl2: 144,
incl3: 147,
incl4: 148,
incl5: 151,
incl6: 152,
incl7: 156,

obl0: 27,  // output buffer low (address bus low output latch)
obl1: 30,
obl2: 28,
obl3: 32,
obl4: 29,
obl5: 33,
obl6: 1073,
obl7: 35,

"#obh0": 1071,  // output buffer high (address bus high output latch))
"#obh1": 819,
"#obh2": 811,
"#obh3": 813,
"#obh4": 817,
"#obh5": 809,
"#obh6": 815,
"#obh7": 574,

// other internal state
ir0: 1301, // Instruction Register
ir1: 1285,
ir2: 1286,
ir3: 1287,
ir4: 1288,
ir5: 1289,
ir6: 1274,
ir7: 1277,

// timing state signals
Ts: 1309,
Tf: 849,      // aka fetch
Ta0: 879,
Td0_0: 981,
"#Te0": 868,
"Te0.2": 866,
Tg0: 12,
Tx0: 850,
Ta1: 838,
Te1_0: 735,
Tg1: 772,
Tx1: 851,
Ta2: 844,
Tg2: 832,
Tx2: 860,
Tg3: 835,
Tr3: 823,
Tg4: 696,
Tr4: 825,
Tg5: 914,
Tr5: 828,
Tg6: 911,
Tr6: 894,
Tr7: 694,
Tg7: 1081,
Tg8: 891,
Tr8: 697,

// other internal busses registers and signals

// internal control signals
sync: 1528,   // aka #decode_0

// ALU signals
adda0: 1680,
adda1: 1681,
adda2: 1685,
adda3: 1686,
adda4: 1691,
adda5: 1692,
adda6: 1695,
adda7: 1696,
adda0in: 1938,
adda1in: 1940,
adda2in: 1939,
adda3in: 1942,
adda4in: 1941,
adda5in: 1944,
adda6in: 1943,
adda7in: 1945,
addb0: 569,
addb1: 568,
addb2: 561,
addb3: 560,
addb4: 553,
addb5: 552,
addb6: 545,
addb7: 544,
addg0: 593,
addg1: 594,
addg2: 589,
addg3: 590,
addg4: 585,
addg5: 586,
addg6: 581,
addg7: 582,
addp0: 564,
addp1: 566,
addp2: 556,
addp3: 558,
addp4: 548,
addp5: 550,
addp6: 541,
addp7: 543,

decode: 1225,
enrwa: 1318,
fetch: 849, // aka Tf

ob: 1308, // output buffer (read-not-write output latch)

resg: 1512,

xi0: 1303,  // half-latch prior to IR
xi1: 1291,
xi2: 1294,
xi3: 1292,
xi4: 1295,
xi5: 1293,
xi6: 1275,
xi7: 1276,

// signals which are not purely alphabetical
// note that underscore digit represents a logical duplication
acca0_1: 342,
acca1_1: 350,
acca2_1: 344,
acca3_1: 352,
acca4_1: 346,
acca5_1: 354,
acca6_1: 348,
acca7_1: 356,
accb0_1: 343,
accb1_1: 351,
accb2_1: 345,
accb3_1: 353,
accb4_1: 347,
accb5_1: 355,
accb6_1: 349,
accb7_1: 357,
ahd0_0: 237,
ahd1_0: 240,
ahd2_0: 236,
ahd3_0: 239,
ahd4_0: 235,
ahd5_0: 238,
ahd6_0: 234,
ahd7_0: 252,
ald0_0: 74,
ald1_0: 71,
ald2_0: 68,
ald3_0: 65,
ald4_0: 62,
ald5_0: 34,
ald6_0: 56,
ald7_0: 53,
ba_0: 1228,
idb0_2: 521,
idb1_2: 520,
idb2_2: 517,
idb3_2: 516,
idb4_2: 513,
idb5_2: 512,
idb6_2: 509,
idb7_2: 508,
decode_1: 1304,
halt_0: 1491,
inchi0_0: 206,
inchi1_0: 208,
inchi2_0: 207,
inchi4_0: 245,
inchi5_0: 243,
inchi6_0: 242,
incli0_0: 89,
incli1_0: 90,
incli2_0: 88,
incli4_0: 93,
incli5_0: 91,
incli6_0: 92,
ir0_1: 1300,
ir1_1: 1280,
ir2_1: 1281,
ir3_1: 1282,
ir4_1: 1283,
ir5_1: 1284,
ir6_1: 1272,
ir7_1: 1273,
ixh0_1: 365,
ixh1_1: 364,
ixh2_1: 363,
ixh3_1: 362,
ixh4_1: 361,
ixh5_1: 360,
ixh6_1: 359,
ixh7_1: 358,
ixl0_1: 373,
ixl1_1: 372,
ixl2_1: 371,
ixl3_1: 370,
ixl4_1: 369,
ixl5_1: 368,
ixl6_1: 367,
ixl7_1: 366,
pch0_1: 197,
pch1_1: 193,
pch2_1: 196,
pch3_1: 192,
pch4_1: 195,
pch5_1: 191,
pch6_1: 194,
pch7_1: 190,
pcl0_1: 153,
pcl1_1: 141,
pcl2_1: 142,
pcl3_1: 145,
pcl4_1: 146,
pcl5_1: 149,
pcl6_1: 150,
pcl7_1: 155,
reset_0: 1462,
sph0_1: 303,
sph1_1: 302,
sph2_1: 301,
sph3_1: 300,
sph4_1: 299,
sph5_1: 298,
sph6_1: 297,
sph7_1: 296,
spl0_1: 295,
spl1_1: 294,
spl2_1: 293,
spl3_1: 292,
spl4_1: 291,
spl5_1: 290,
spl6_1: 289,
spl7_1: 288,
tmp0_1: 284,
tmp1_1: 283,
tmp2_1: 282,
tmp3_1: 281,
tmp4_1: 280,
tmp5_1: 279,
tmp6_1: 278,
tmp7_1: 254,
vma_0: 1498,
phi2_1: 478,
"#abh0_0": 1070,
"#abh0_1": 277,
"#abh1_0": 818,
"#abh1_1": 271,
"#abh2_0": 810,
"#abh2_1": 276,
"#abh3_0": 812,
"#abh3_1": 270,
"#abh4_0": 816,
"#abh4_1": 275,
"#abh5_0": 808,
"#abh5_1": 269,
"#abh6_0": 814,
"#abh6_1": 272,
"#abh7_0": 572,
"#abh7_1": 268,
"#abl0_0": 76,
"#abl10_0": 500,
"#abl11_0": 501,
"#abl12_0": 498,
"#abl13_0": 499,
"#abl14_0": 496,
"#abl15_0": 497,
"#abl16_0": 494,
"#abl17_0": 495,
"#abl1_0": 73,
"#abl2_0": 70,
"#abl3_0": 67,
"#abl4_0": 64,
"#abl5_0": 61,
"#abl6_0": 58,
"#abl7_0": 55,
"#acca0_0": 1710,
"#acca1_0": 1718,
"#acca2_0": 1711,
"#acca3_0": 1719,
"#acca4_0": 1723,
"#acca5_0": 1727,
"#acca6_0": 1731,
"#acca7_0": 1783,
"#accb0_0": 1704,
"#accb1_0": 1712,
"#accb2_0": 1705,
"#accb3_0": 1713,
"#accb4_0": 1720,
"#accb5_0": 1724,
"#accb6_0": 1728,
"#accb7_0": 1732,
"#addb0_0": 492,
"#addb1_0": 493,
"#addb2_0": 502,
"#addb3_0": 503,
"#addb4_0": 504,
"#addb5_0": 505,
"#addb6_0": 522,
"#addb7_0": 523,
"#addc01": 591,
"#addc12": 588,
"#addc23": 587,
"#addc45": 583,
"#addc56": 580,
"#addc67": 579,
"#ahd0": 264,
"#ahd1": 274,
"#ahd2": 263,
"#ahd3": 273,
"#ahd4": 262,
"#ahd5": 261,
"#ahd6": 260,
"#ahd7": 1780,
"#ald0": 1672,
"#ald1": 1673,
"#ald2": 1654,
"#ald3": 1668,
"#ald4": 1659,
"#ald5": 1661,
"#ald6": 1660,
"#ald7": 1662,
"#ccr/db": 287,
"#d0_0": 607,
"#d1_0": 597,
"#d2_0": 596,
"#d3_0": 399,
"#d4_0": 404,
"#d5_0": 394,
"#d6_0": 388,
"#d7_0": 661,
"#db0_0": 75,
"#db0_1": 519,
"#db1_0": 72,
"#db1_1": 518,
"#db2_0": 69,
"#db2_1": 515,
"#db3_0": 66,
"#db3_1": 514,
"#db4_0": 63,
"#db4_1": 511,
"#db5_0": 60,
"#db5_1": 510,
"#db6_0": 57,
"#db6_1": 507,
"#db7_0": 54,
"#db7_1": 506,
"#dbi0_0": 611,
"#dbi1_0": 605,
"#dbi2_0": 603,
"#dbi3_0": 403,
"#dbi4_0": 407,
"#dbi5_0": 398,
"#dbi6_0": 391,
"#dbi7_0": 654,
// "#decode_0": 1528,  aka  sync
"#decode_2": 1259,
"#i0": 1270,
"#i1": 1197,
"#i2": 1198,
"#i3": 1266,
"#i4": 1199,
"#i5": 1200,
"#i6": 1262,
"#i7": 1260,
"#inch0_0": 218,
"#inch1_0": 214,
"#inch2_0": 217,
"#inch3_0": 213,
"#inch4_0": 216,
"#inch5_0": 212,
"#inch6_0": 215,
"#inch7_0": 211,
"#inchc01": 1758,
"#inchc12": 1759,
"#inchc23": 1763,
"#inchc34": 1764,
"#inchc45": 1767,
"#inchc56": 1768,
"#inchc67": 1779,
"#inchcin": 186,
"#inchi0": 247,
"#inchi1": 250,
"#inchi2": 246,
"#inchi3": 249,
"#inchi4": 244,
"#inchi5": 248,
"#inchi6": 241,
"#incho0": 225,
"#incho1": 221,
"#incho2": 224,
"#incho3": 220,
"#incho4": 223,
"#incho5": 219,
"#incho6": 222,
"#incho7": 210,
"#incl0_0": 119,
"#incl1_0": 115,
"#incl2_0": 118,
"#incl3_0": 114,
"#incl4_0": 117,
"#incl5_0": 113,
"#incl6_0": 116,
"#incl7_0": 96,
"#inclc01": 1675,
"#inclc12": 1652,
"#inclc23": 1676,
"#inclc34": 1663,
"#inclc45": 1665,
"#inclc56": 1664,
"#inclc67": 1666,
"#inclcin": 1674,
"#incli0": 50,
"#incli1": 46,
"#incli2": 49,
"#incli3": 45,
"#incli4": 48,
"#incli5": 44,
"#incli6": 47,
"#incli7": 43,
"#inclo0": 104,
"#inclo1": 100,
"#inclo2": 103,
"#inclo3": 99,
"#inclo4": 102,
"#inclo5": 98,
"#inclo6": 101,
"#inclo7": 97,
"#ir0_0": 1302,
"#ir1_0": 1290,
"#ir2_0": 1296,
"#ir3_0": 1297,
"#ir4_0": 1298,
"#ir5_0": 1299,
"#ir6_0": 1278,
"#ir7_0": 1279,
"#ixh0_0": 1706,
"#ixh1_0": 1714,
"#ixh2_0": 1707,
"#ixh3_0": 1715,
"#ixh4_0": 1721,
"#ixh5_0": 1725,
"#ixh6_0": 1729,
"#ixh7_0": 1781,
"#ixl0_0": 1708,
"#ixl1_0": 1716,
"#ixl2_0": 1709,
"#ixl3_0": 1717,
"#ixl4_0": 1722,
"#ixl5_0": 1726,
"#ixl6_0": 1730,
"#ixl7_0": 1782,
"#pch0_0": 1760,
"#pch1_0": 1757,
"#pch2_0": 1761,
"#pch3_0": 1762,
"#pch4_0": 1765,
"#pch5_0": 1766,
"#pch6_0": 1769,
"#pch7_0": 1778,
"#pcl0_0": 1770,
"#pcl1_0": 1775,
"#pcl2_0": 1771,
"#pcl3_0": 1776,
"#pcl4_0": 1772,
"#pcl5_0": 1777,
"#pcl6_0": 1773,
"#pcl7_0": 1774,
"#reset_1": 1463,
"#sph0_0": 1735,
"#sph1_0": 1738,
"#sph2_0": 1741,
"#sph3_0": 1744,
"#sph4_0": 1747,
"#sph5_0": 1750,
"#sph6_0": 1753,
"#sph7_0": 1756,
"#spl0_0": 1734,
"#spl1_0": 1737,
"#spl2_0": 1740,
"#spl3_0": 1743,
"#spl4_0": 1746,
"#spl5_0": 1749,
"#spl6_0": 1752,
"#spl7_0": 1755,
"#sum0_0": 616,
"#sum1_0": 632,
"#sum2_0": 615,
"#sum3_0": 627,
"#sum4_0": 614,
"#sum5_0": 622,
"#sum6_0": 613,
"#sum7_0": 617,
"#sumo0": 634,
"#sumo1": 633,
"#sumo2": 629,
"#sumo3": 628,
"#sumo4": 624,
"#sumo5": 623,
"#sumo6": 619,
"#sumo7": 618,
"#tmp0_0": 1733,
"#tmp1_0": 1736,
"#tmp2_0": 1739,
"#tmp3_0": 1742,
"#tmp4_0": 1745,
"#tmp5_0": 1748,
"#tmp6_0": 1751,
"#tmp7_0": 1754,
"#ena": 1646,
"#enrw": 1168,
"#flagc_0": 1129,
"#flagcx": 1128,
"#flagh_0": 787,
"#flaghx": 781,
"#flagi_0": 1576,
"#flagix": 1006,
"#flagn_0": 997,
"#flagnx": 996,
"#flagv_0": 1103,
"#flagvx": 1566,
"#flagz_0": 1579,
"#flagzx": 1024,
"#n0n-0": 1250,
"#n0n-1": 1251,
"#n0n-2": 1252,
"#n0n-3": 1253,
"#n0n-4": 1254,
"#n0n-5": 1247,
"#n0n-6": 1243,
"#n0n-7": 1244,
"#n0n.2-0": 1249,
"#n0n.2-1": 1255,
"#n0n.2-2": 1256,
"#n0n.2-3": 1257,
"#n0n.2-4": 1258,
"#n0n.2-5": 1248,
"#n0n.2-6": 1241,
"#n0n.2-7": 1242,
"#phi2_0": 477,
"#phi2_2": 576,
"#x0/abh": 979,
"#x0/abl1": 438,
"#x0/db0": 127,
"#x0/db1": 129,
"#x0/db2": 132,
"#xab/ix": 456,
"#xab/sp": 167,
"#xabl/abl1": 426,
"#xabl/ald": 82,
"#xacca/abl1": 428,
"#xacca/db": 466,
"#xaccb/abl1": 460,
"#xaccb/db": 760,
"#xaddg0": 571,
"#xaddg1": 570,
"#xaddg2": 563,
"#xaddg3": 562,
"#xaddg4": 555,
"#xaddg5": 554,
"#xaddg6": 547,
"#xaddg7": 546,
"#xda/adda": 434,
"#xdb/acca": 464,
"#xdb/accb": 430,
"#xdb/adda": 436,
"#xdb/ald": 84,
"#xdb/ixh": 454,
"#xdb/ixl": 458,
"#xdb/sph": 739,
"#xdb/spl": 445,
"#xdb/tmp": 448,
"#xinc/ab": 121,
"#xinc/pc": 701,
"#xixh/abh": 421,
"#xixh/abl1": 757,
"#xixh/db": 424,
"#xixl/abl1": 462,
"#xixl/db": 432,
"#xpc/ab": 123,
"#xpch/db": 157,
"#xpcl/db": 125,
"#xsp/ab": 745,
"#xsph/db": 452,
"#xspl/db": 738,
"#xsr/adda": 468,
"#xtmp/abh": 443,
"#xtmp/db": 450,
"#xndb/adda": 471,
"0/abh": 181,
"0/abl1": 316,
"0/db0": 136,
"0/db1": 135,
"0/db2": 134,
"a0-high": 13,
"a0-low": 21,
"a1-high": 16,
"a1-low": 24,
"a10-high": 803,
"a10-low": 39,
"a11-high": 804,
"a11-low": 41,
"a12-high": 806,
"a12-low": 689,
"a13-high": 802,
"a13-low": 687,
"a14-high": 805,
"a14-low": 690,
"a15-high": 801,
"a15-low": 688,
"a2-high": 14,
"a2-low": 22,
"a3-high": 17,
"a3-low": 25,
"a4-high": 15,
"a4-low": 23,
"a5-high": 18,
"a5-low": 26,
"a6-high": 19,
"a6-low": 20,
"a7-high": 37,
"a7-low": 36,
"a8-high": 1072,
"a8-low": 38,
"a9-high": 807,
"a9-low": 40,
"ab/ix": 329,
"ab/ob": 1647,
"ab/sp": 171,
"abh/ahd": 176,
"abl/abl1": 326,
"abl/ald": 6,
"acca/abl1": 325,
"acca/db": 314,
"accb/abl1": 318,
"accb/db": 324,
"ba-high": 1237,
"ba-low": 1227,
"d0-high": 681,
"d0-low": 684,
"d1-high": 682,
"d1-low": 685,
"d2-high": 674,
"d2-low": 679,
"d3-high": 675,
"d3-low": 680,
"d4-high": 666,
"d4-low": 671,
"d5-high": 667,
"d5-low": 672,
"d6-high": 662,
"d6-low": 665,
"d7-high": 653,
"d7-low": 652,
"da/adda": 418,
"db/acca": 315,
"db/accb": 323,
"db/adda": 417,
"db/ald": 7,
"db/ixh": 285,
"db/ixl": 320,
"db/sph": 180,
"db/spl": 177,
"db/tmp": 174,
"dbi0-fb": 612,
"dbi1-fb": 600,
"dbi2-fb": 606,
"dbi3-fb": 401,
"dbi4-fb": 408,
"dbi5-fb": 396,
"dbi6-fb": 392,
"dbi7-fb": 651,
"inc/ab": 140,
"inc/pc": 138,
"ixh/abh": 327,
"ixh/abl1": 319,
"ixh/db": 328,
"ixl/abl1": 317,
"ixl/db": 322,
"pch/abh": 161,
"pch/db": 162,
"pcl/abl": 139,
"pcl/db": 137,
"rw-high": 1306,
"rw-low": 1307,
"sph/abh": 286,
"sph/db": 172,
"spl/abl": 178,
"spl/db": 175,
"sr/adda": 416,
"sum/db": 532,
"tmp/abh": 179,
"tmp/db": 173,
"vma-high": 1500,
"vma-low": 1499,
"flag0/db1": 321,
"flag0/db2": 375,
"flag0/db3": 376,
"flag0/db4": 309,
"flag0/db5": 308,
"ndb/adda": 415,

// from this point: signals imported from Segher 2011-04-16 and not yet ordered or commented
carry: 646,
dbe_1: 1453,
dec: 163,
halted: 2,
int: 1083,
irq_0: 3,
irqg: 1183,
nmi_0: 1477,
nmig: 1192,
restart: 1186,

ta0: 879,  // timing state signals also seen earlier with mixed-case names
ta1: 838,
ta2: 844,
td0_0: 981,
td0_1: 700,
te1_0: 735,
te1_1: 967,
te1_2: 705,
te1_3: 715,
te1_4: 865,
te1_5: 973,
te1_6: 706,
tg0: 12,
tg1: 772,
tg2: 832,
tg3: 835,
tg4: 696,
tg5: 914,
tg6: 911,
tg7: 1081,
tg8: 891,
tr3: 823,
tr4: 825,
tr5: 828,
tr6: 894,
tr7: 694,
tr8: 697,
ts: 1309,
tsc_0: 1508,
tx0: 850,
tx1: 851,
tx2: 860,

wait: 1234,
wr: 788,
writing: 1449,

// the remainder of the imports need quoting
"#alu-cin": 592,
"#alu-cout": 595,
"#alu-hin": 584,
"#alu-hout": 1690,
"#alu-or": 472,
"#alu-or-xor": 475,
"#carry16": 733,
"#dbe_0": 1452,
"#dbe_2": 1454,
"#end": 1574,
"#flagc_1": 942,
"#i-ts": 1313,
"#inc": 712,
"#inch-cin": 78,
"#next-cyc-fetch": 4,
"#nmi_1": 1478,
"#nmip": 1178,
"#op-00xxxxxx_0": 945,
"#op-ta0-a-alu": 1019,
"#ta0-stx": 796,
"#ta0.2_0": 873,
"#ta1-0000100x": 798,
"#ta1-0000100x.2": 799,
"#ta1_0": 872,
"#ta1_1": 1095,
"#ta1_2": 960,
"#taken": 1039,
"#te0": 868,
"#te0.2_0": 867,
"#tx0_0": 971,
"#tx0_1": 926,
"#tx1_0": 727,
"#xalu-cin": 943,
"#xalu-or-xor": 479,
"#xdbi/db": 536,
"#xsum/db": 535,
"alu-and": 473,
"alu-sl": 578,
"alu-sr/c": 1110,
"alu-sub/c": 1144,
"alu-sub/c_0": 1163,
"alu-vout": 1058,
"alu-zout": 645,
"alu/c": 1147,
"alu/c_0": 1164,
"alu/h": 782,
"alu/nz": 1027,
"alu/v": 1112,
"alu2/z": 1049,
"da-c": 379,
"da-h": 381,
"db/ccr": 1107,
"dbi/db": 531,
"dec-low-adjust": 385,
"do-alu-cin": 575,
"force-wait": 1245,
"inc16/z": 989,
"incl-cout": 42,
"insn/c": 1162,
"insn/c_0": 1131,
"insn/i": 1000,
"insn/v": 1570,
"irq-dis": 990,
"irq-new": 1215,
"ix/ab": 833,
"nmi-done": 1172,
"nmi-new": 1174,
"no-address": 1489,
"shift-vout": 1057,
"shift/v": 1568,
"sr-cin": 765,
"t-before-fetch-simple": 1149,
"ta0-two-cycle-insn": 965,
"ta0.2": 878,
"ta2-0000100x": 1028,
"ta2-0000100x_0": 748,
"ta2-0000100x_1": 759,
"ta2-1xxx11xx": 1045,
"ta3-0000100x": 1031,
"te0.2": 866,
"tsc-high": 1460,
"tsc-low": 1476,
"xalu-and": 483,

// pla outputs (not in physical order)
"op-0000011x": 1361,
"op-0000100x": 1332,
"op-0000100x_0": 1379,
"op-0000100x_1": 1427,
"op-0000101x": 1141,
"op-0000110x": 1130,
"op-0000xxxx": 1369,
"op-0000xxxx_0": 1362,
"op-00010110": 1355,
"op-0001100x": 1394,
"op-0001101x": 1346,
"op-0001xxxx": 1360,
"op-000x0110": 1391,
"op-0010xxxx": 1380,
"op-0010xxxx_0": 1363,
"op-0010xxxx_1": 1399,
"op-0010xxxx_2": 1426,
"op-0011100x": 1381,
"op-00111011": 1383,
"op-00xxxxxx": 1342,
"op-0100xxxx": 1432,
"op-0101xxxx": 1425,
"op-011x1101": 1387,
"op-011x1110": 1398,
"op-011xxxxx": 1337,
"op-011xxxxx_0": 1322,
"op-011xxxxx_1": 1320,
"op-01xx01xx": 1443,
"op-01xx01xx_0": 1396,
"op-01xx0xxx": 1390,
"op-01xx100x": 1345,
"op-01xx100x_0": 1094,
"op-01xx100x_1": 1334,
"op-01xx1110": 1328,
"op-01xx1110_0": 1341,
"op-01xx11x1": 1428,
"op-01xxx1xx": 1338,
"op-0x01xxxx": 1343,
"op-0x0xxxxx_0": 1364,
"op-0xxxxxxx": 1439,
"op-0xxxxxxx_0": 1401,
"op-0xxxxxxx_1": 1437,
"op-10xx0111": 1339,
"op-10xx111x": 948,
"op-10xxxxxx": 1384,
"op-11xx0111": 1436,
"op-11xx1110": 1366,
"op-11xx1111": 1393,
"op-11xxxxxx": 1327,
"op-1x001101": 1349,
"op-1x00xxxx": 1372,
"op-1x10xxxx": 1350,
"op-1x11xxxx": 1321,
"op-1xx01101": 1352,
"op-1xx0xxxx": 1371,
"op-1xxx0010": 1354,
"op-1xxx0111": 1323,
"op-1xxx10x0": 1438,
"op-1xxx10x1": 1444,
"op-1xxx1100": 1378,
"op-1xxx1100_0": 1442,
"op-1xxx1101": 1356,
"op-1xxx1101_0": 1388,
"op-1xxx1101_1": 1434,
"op-1xxx1111": 1389,
"op-1xxx11x0": 1374,
"op-1xxx11xx": 1431,
"op-1xxx11xx_0": 1353,
"op-1xxx11xx_1": 1430,
"op-1xxx11xx_2": 1392,
"op-1xxx11xx_3": 1340,
"op-1xxx11xx_4": 1373,
"op-1xxxx111": 1435,
"op-1xxxx111_0": 1348,
"op-1xxxxxxx": 846,
"op-1xxxxxxx_0": 1150,
"op-s-00000110": 1420,
"op-s-00000111": 1407,
"op-s-00001001": 1410,
"op-s-0000100x": 1417,
"op-s-0000100x_0": 1423,
"op-s-0000111x": 1001,
"op-s-00110101": 1411,
"op-s-00110110": 1413,
"op-s-00110111": 1414,
"op-s-0011011x": 1415,
"op-s-0011x1xx": 1421,
"op-s-0011xxxx": 1409,
"op-s-0x0xxxxx": 1419,
"op-s-0x0xxxxx": 1422,
"op-s-1x001101": 1412,
"op-s-1x00xxxx": 1405,
"op-s-1x01xxxx": 1418,
"op-s-1x01xxxx_0": 1402,
"op-s-1x01xxxx_1": 1416,
"op-s-xx10xxxx": 1408,
"op-s-xx10xxxx_0": 1403,
"op-s-xx11xxxx": 1404,
"op-xx11xxxx": 1357,
"op-xxx011x": 1375,
"op-xxx1xxxx": 1336,
"op-xxxx0000": 1424,
"op-xxxx000x": 1377,
"op-xxxx0010": 1344,
"op-xxxx0011": 1333,
"op-xxxx001x": 1335,
"op-xxxx00xx": 1433,
"op-xxxx00xx_0": 1367,
"op-xxxx0111": 1330,
"op-xxxx01xx": 1395,
"op-xxxx0x01": 1385,
"op-xxxx0x0x": 1324,
"op-xxxx0xxx": 1040,
"op-xxxx0xxx_0": 1351,
"op-xxxx1001": 1326,
"op-xxxx100x": 1358,
"op-xxxx10x1": 1365,
"op-xxxx10x1_0": 1429,
"op-xxxx10xx": 1325,
"op-xxxx1100": 1440,
"op-xxxx111x": 1359,
"op-xxxx111x_0": 1400,
"op-xxxx111x_1": 1368,
"op-xxxx11xx": 1329,
"op-xxxx11xx_0": 1382,
"op-xxxx1xx1": 1386,
"op-xxxx1xxx": 1397,
"op-xxxxx11x": 1376,
"op-xxxxx11x_0": 1441,
"op-xxxxx1xx": 1370,
"op-xxxxxx0x": 1041,
"op-xxxxxx1x": 1446,
"op-xxxxxxx0": 1138,
"op-xxxxxxx0_0": 1003,
"op-xxxxxxx1": 1331,
"op-xxxxxxx1_0": 11,
"op-xxxxxxx1_1": 1347,
"op-xxxxxxx1_2": 1086,
}
