/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.time.CalendarUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class CalendarUtilsTest
extends AbstractLangTest {
    @Test
    public void testGetDayOfMonth() {
        Assertions.assertEquals((int)Calendar.getInstance().get(5), (int)CalendarUtils.getInstance().getDayOfMonth());
    }

    @Test
    public void testGetDayOfYear() {
        Assertions.assertEquals((int)Calendar.getInstance().get(6), (int)CalendarUtils.getInstance().getDayOfYear());
    }

    @Test
    public void testGetMonth() {
        Assertions.assertEquals((int)Calendar.getInstance().get(2), (int)CalendarUtils.getInstance().getMonth());
    }

    @Test
    public void testGetStandaloneLongMonthNames() {
        String[] monthNames = CalendarUtils.getInstance((Locale)Locale.GERMAN).getStandaloneLongMonthNames();
        Assertions.assertEquals((int)12, (int)monthNames.length);
        Assertions.assertEquals((Object)"Januar", (Object)monthNames[0]);
        Assertions.assertEquals((Object)"Februar", (Object)monthNames[1]);
        Assertions.assertEquals((Object)"M\u00e4rz", (Object)monthNames[2]);
        Assertions.assertEquals((Object)"April", (Object)monthNames[3]);
        Assertions.assertEquals((Object)"Mai", (Object)monthNames[4]);
        Assertions.assertEquals((Object)"Juni", (Object)monthNames[5]);
        Assertions.assertEquals((Object)"Juli", (Object)monthNames[6]);
        Assertions.assertEquals((Object)"August", (Object)monthNames[7]);
        Assertions.assertEquals((Object)"September", (Object)monthNames[8]);
        Assertions.assertEquals((Object)"Oktober", (Object)monthNames[9]);
        Assertions.assertEquals((Object)"November", (Object)monthNames[10]);
        Assertions.assertEquals((Object)"Dezember", (Object)monthNames[11]);
    }

    @Test
    public void testGetStandaloneShortMonthNames() {
        String[] monthNames = CalendarUtils.getInstance((Locale)Locale.GERMAN).getStandaloneShortMonthNames();
        Assertions.assertEquals((int)12, (int)monthNames.length);
        Assertions.assertEquals((Object)"Jan", (Object)monthNames[0]);
        Assertions.assertEquals((Object)"Feb", (Object)monthNames[1]);
        Assertions.assertEquals((Object)"M\u00e4r", (Object)monthNames[2]);
        Assertions.assertEquals((Object)"Apr", (Object)monthNames[3]);
        Assertions.assertEquals((Object)"Mai", (Object)monthNames[4]);
        Assertions.assertEquals((Object)"Jun", (Object)monthNames[5]);
        Assertions.assertEquals((Object)"Jul", (Object)monthNames[6]);
        Assertions.assertEquals((Object)"Aug", (Object)monthNames[7]);
        Assertions.assertEquals((Object)"Sep", (Object)monthNames[8]);
        Assertions.assertEquals((Object)"Okt", (Object)monthNames[9]);
        Assertions.assertEquals((Object)"Nov", (Object)monthNames[10]);
        Assertions.assertEquals((Object)"Dez", (Object)monthNames[11]);
    }

    @Test
    public void testGetYear() {
        Assertions.assertEquals((int)Calendar.getInstance().get(1), (int)CalendarUtils.INSTANCE.getYear());
    }

    @ParameterizedTest
    @MethodSource(value={"java.util.TimeZone#getAvailableIDs()"})
    public void testToLocalDateTime(String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        ZoneId zoneId = timeZone.toZoneId();
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTimeInMillis(0L);
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(calendar.toInstant(), ((Calendar)calendar).getTimeZone().toZoneId()), (Object)new CalendarUtils((Calendar)calendar).toLocalDateTime());
        ZonedDateTime zdt1 = ZonedDateTime.of(1, 2, 3, 4, 5, 6, 0, zoneId);
        calendar.setTimeInMillis(zdt1.toInstant().toEpochMilli());
        Assertions.assertEquals((Object)LocalDateTime.ofInstant(zdt1.toInstant(), ((Calendar)calendar).getTimeZone().toZoneId()), (Object)new CalendarUtils((Calendar)calendar).toLocalDateTime());
    }

    @ParameterizedTest
    @MethodSource(value={"java.util.TimeZone#getAvailableIDs()"})
    public void testToOffsetDateTime(String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        ZoneId zoneId = timeZone.toZoneId();
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTimeInMillis(0L);
        Assertions.assertEquals((Object)OffsetDateTime.ofInstant(calendar.toInstant(), ((Calendar)calendar).getTimeZone().toZoneId()), (Object)new CalendarUtils((Calendar)calendar).toOffsetDateTime());
        ZonedDateTime zdt1 = ZonedDateTime.of(1, 2, 3, 4, 5, 6, 0, zoneId);
        calendar.setTimeInMillis(zdt1.toInstant().toEpochMilli());
        Assertions.assertEquals((Object)OffsetDateTime.ofInstant(zdt1.toInstant(), ((Calendar)calendar).getTimeZone().toZoneId()), (Object)new CalendarUtils((Calendar)calendar).toOffsetDateTime());
    }

    @ParameterizedTest
    @MethodSource(value={"java.util.TimeZone#getAvailableIDs()"})
    public void testToZonedDateTime(String timeZoneId) {
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
        ZoneId zoneId = timeZone.toZoneId();
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTimeInMillis(0L);
        Assertions.assertEquals((Object)ZonedDateTime.ofInstant(calendar.toInstant(), ((Calendar)calendar).getTimeZone().toZoneId()), (Object)new CalendarUtils((Calendar)calendar).toZonedDateTime());
        ZonedDateTime zdt1 = ZonedDateTime.of(1, 2, 3, 4, 5, 6, 0, zoneId);
        calendar.setTimeInMillis(zdt1.toInstant().toEpochMilli());
        Assertions.assertEquals((Object)ZonedDateTime.ofInstant(zdt1.toInstant(), ((Calendar)calendar).getTimeZone().toZoneId()), (Object)new CalendarUtils((Calendar)calendar).toZonedDateTime());
    }
}

