/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.AddWorkItemDialog;
import com.pomodorotechnique.client.ui.MessagesWindow;
import com.pomodorotechnique.client.ui.PomodoroClientAboutBox;
import com.pomodorotechnique.client.ui.PomodoroClientApp;
import com.pomodorotechnique.client.ui.PomodoroListener;
import com.pomodorotechnique.client.ui.SettingsWindow;
import com.pomodorotechnique.client.ui.SoundsTimerListener;
import com.pomodorotechnique.client.ui.StatisticsWindow;
import com.pomodorotechnique.client.ui.TimerWindow;
import com.pomodorotechnique.client.ui.TraySupport;
import com.pomodorotechnique.client.ui.UpdateDialog;
import com.pomodorotechnique.client.ui.UsersWindow;
import com.pomodorotechnique.client.ui.Util;
import com.pomodorotechnique.client.ui.timer.Timer;
import com.pomodorotechnique.client.ui.timer.TimerState;
import com.pomodorotechnique.client.ui.workitem.PomodoroRenderer;
import com.pomodorotechnique.client.ui.workitem.WorkItemStatusRenderer;
import com.pomodorotechnique.client.ui.workitem.WorkItemTitleRenderer;
import com.pomodorotechnique.server.InterruptionType;
import com.pomodorotechnique.server.Messages;
import com.pomodorotechnique.server.PlanType;
import com.pomodorotechnique.server.PomodoroType;
import com.pomodorotechnique.server.StatusType;
import com.pomodorotechnique.server.WorkitemType;
import com.pomodorotechnique.server.api.AlreadyExistsException;
import com.pomodorotechnique.server.api.InvalidStateException;
import com.pomodorotechnique.server.api.NoPomodorosLeftException;
import com.pomodorotechnique.server.api.NotFoundException;
import com.pomodorotechnique.server.api.OfflineServerImpl;
import com.pomodorotechnique.server.api.Server;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class PomodoroClientView
extends FrameView {
    private final Server server;
    private final TimerWindow timerWindow;
    private TraySupport tray = null;
    private final Preferences prefs = Preferences.userRoot().node("pomodoroServer");
    private SoundsTimerListener soundListener = null;
    private final MouseListener showPomodoroMouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            PomodoroClientView.this.timerWindow.setVisible(true);
        }
    };
    private final PomodoroListener pomodoroListener = new PomodoroListener(){

        public void refreshUiOnFinish(WorkitemType workItem) {
            try {
                PomodoroClientView.this.setToolbarButtonsEnabledAuto();
                try {
                    PomodoroClientView.this.refreshWorkItem(PomodoroClientView.this.findWorkItem(workItem));
                }
                catch (NotFoundException ex) {
                    Logger.getLogger(PomodoroClientView.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.checkForMessages(workItem);
            }
            catch (InvalidStateException ex) {
                Logger.getLogger(PomodoroClientView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void pomodoroVoid(WorkitemType workItem) {
            try {
                PomodoroClientView.this.statusMessageLabel.setText("Pomodoro cancelled");
                PomodoroClientView.this.server.voidPomodoro(workItem);
                PomodoroClientView.this.timer.voidCurrentPomodoro();
                this.refreshUiOnFinish(workItem);
            }
            catch (InvalidStateException ex) {
                Logger.getLogger(PomodoroClientView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void interruption(WorkitemType workItem, InterruptionType interruption) {
            try {
                PomodoroClientView.this.server.registerInterruption(workItem, interruption);
                PomodoroClientView.this.refreshWorkItem(PomodoroClientView.this.findWorkItem(workItem));
            }
            catch (Exception ex) {
                Logger.getLogger(PomodoroClientView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public void workCompleted(WorkitemType workItem, PomodoroType pomodoro, boolean successfully) {
            if (successfully) {
                PomodoroClientView.this.statusMessageLabel.setText("Work ended successfully. Having rest now.");
                try {
                    PomodoroClientView.this.server.completePomodoro(workItem);
                }
                catch (InvalidStateException ex) {
                    Logger.getLogger(PomodoroClientView.class.getName()).log(Level.SEVERE, null, ex);
                }
                this.refreshUiOnFinish(workItem);
            }
        }

        public void ready(WorkitemType workItem) {
            PomodoroClientView.this.statusMessageLabel.setText("");
            this.refreshUiOnFinish(workItem);
            switch (PomodoroClientView.this.getTimerWindowMode()) {
                case NO_TRAY: {
                    break;
                }
                case HIDE_MAIN_WINDOW_ONLY: {
                    PomodoroClientView.this.getFrame().setVisible(true);
                    PomodoroClientView.this.getFrame().toFront();
                    break;
                }
                case HIDE_EVERYTHING: {
                    PomodoroClientView.this.getFrame().setVisible(true);
                    PomodoroClientView.this.getFrame().toFront();
                }
            }
        }

        private void checkForMessages(WorkitemType workItem) throws InvalidStateException {
            Messages msg;
            if (!(PomodoroClientView.this.server instanceof OfflineServerImpl) && (msg = PomodoroClientView.this.server.getMessages(workItem)) != null && !msg.getMessage().isEmpty()) {
                MessagesWindow w = new MessagesWindow(null, true, msg);
                w.setVisible(true);
            }
        }
    };
    private final Timer timer;
    private JButton addPomodoroButton;
    private JButton addWorkItemButton;
    private JButton completeWorkItemButton;
    private JButton createNewPlanButton;
    private JMenuItem deletePlanMenuItem;
    private JButton deleteWorkItemButton;
    private JLabel headerLogoLabel;
    private JPanel headerPanel;
    private JLabel headerTextLabel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JButton settingsButton;
    private JButton startPomodoroButton;
    private JButton statisticsButton;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JToolBar toolBar;
    private JButton usersButton;
    private JTable workItemTable;
    private final javax.swing.Timer messageTimer;
    private final javax.swing.Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForUpdates() {
        if (this.prefs.get("updatesCheck", "Y").equals("Y")) {
            try {
                URL u = new URL("http://flowkeeper.org/updates");
                InputStream is = null;
                String html = null;
                try {
                    is = u.openStream();
                    byte[] buf = new byte[8192];
                    is.read(buf, 0, buf.length);
                    html = new String(buf);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
                if (html != null) {
                    String version;
                    int start = html.indexOf("<!--latest-version#");
                    int end = html.indexOf("#latest-version-->");
                    if (start > 0 && end > 0 && !(version = html.substring(start + 19, end)).equals("12 / 2010")) {
                        new UpdateDialog((Frame)this.getFrame(), true, version).setVisible(true);
                    }
                }
            }
            catch (Throwable t) {
                Logger.getLogger(PomodoroClientView.class.getName()).log(Level.INFO, "Unable to connect to updates server");
            }
        }
    }

    private int findWorkItem(WorkitemType wi) throws NotFoundException {
        return this.server.getPlan().getWorkitem().indexOf(wi);
    }

    public PomodoroClientView(SingleFrameApplication app, Server server) {
        super(app);
        this.server = server;
        this.initComponents();
        this.getFrame().setDefaultCloseOperation(1);
        if (server instanceof OfflineServerImpl) {
            this.usersButton.setVisible(false);
        }
        this.deleteWorkItemButton.setVisible(false);
        this.workItemTable.getSelectionModel().addListSelectionListener(new SelectionListener());
        this.createNewPlanButton.setVisible(false);
        this.deletePlanMenuItem.setEnabled(true);
        this.timer = new Timer(server.getUser());
        try {
            this.tray = new TraySupport(this.timer, this);
            this.timer.addListener(this.tray);
        }
        catch (Throwable t) {
            this.tray = null;
        }
        try {
            this.soundListener = new SoundsTimerListener(this.timer);
            if (this.isSoundEnabled()) {
                this.timer.addListener(this.soundListener);
                this.soundListener.enable();
            }
        }
        catch (Throwable t) {
            if (this.soundListener != null) {
                this.timer.removeListener(this.soundListener);
            }
            this.soundListener = null;
        }
        this.timerWindow = new TimerWindow(this, false, this.timer);
        this.timerWindow.addPomodoroListener(this.pomodoroListener);
        this.initTitle();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new javax.swing.Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PomodoroClientView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new javax.swing.Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PomodoroClientView.this.busyIconIndex = (PomodoroClientView.this.busyIconIndex + 1) % PomodoroClientView.this.busyIcons.length;
                PomodoroClientView.this.statusAnimationLabel.setIcon(PomodoroClientView.this.busyIcons[PomodoroClientView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!PomodoroClientView.this.busyIconTimer.isRunning()) {
                        PomodoroClientView.this.statusAnimationLabel.setIcon(PomodoroClientView.this.busyIcons[0]);
                        PomodoroClientView.this.busyIconIndex = 0;
                        PomodoroClientView.this.busyIconTimer.start();
                    }
                    PomodoroClientView.this.progressBar.setVisible(true);
                    PomodoroClientView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    PomodoroClientView.this.busyIconTimer.stop();
                    PomodoroClientView.this.statusAnimationLabel.setIcon(PomodoroClientView.this.idleIcon);
                    PomodoroClientView.this.progressBar.setVisible(false);
                    PomodoroClientView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    PomodoroClientView.this.statusMessageLabel.setText(text == null ? "" : text);
                    PomodoroClientView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    PomodoroClientView.this.progressBar.setVisible(true);
                    PomodoroClientView.this.progressBar.setIndeterminate(false);
                    PomodoroClientView.this.progressBar.setValue(value);
                }
            }
        });
        Util.decorate(this.getFrame());
        this.checkForUpdates();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = PomodoroClientApp.getApplication().getMainFrame();
            this.aboutBox = new PomodoroClientAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        PomodoroClientApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.headerPanel = new JPanel();
        this.headerTextLabel = new JLabel();
        this.createNewPlanButton = new JButton();
        this.headerLogoLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.workItemTable = new JTable();
        this.toolBar = new JToolBar();
        this.addWorkItemButton = new JButton();
        this.completeWorkItemButton = new JButton();
        this.deleteWorkItemButton = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.startPomodoroButton = new JButton();
        this.addPomodoroButton = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.statisticsButton = new JButton();
        this.usersButton = new JButton();
        this.settingsButton = new JButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        this.deletePlanMenuItem = new JMenuItem();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        ResourceMap resourceMap = Application.getInstance(PomodoroClientApp.class).getContext().getResourceMap(PomodoroClientView.class);
        this.jPanel1.setBackground(resourceMap.getColor("jPanel1.background"));
        this.jPanel1.setName("jPanel1");
        this.jPanel1.setOpaque(false);
        this.headerPanel.setBackground(resourceMap.getColor("headerPanel.background"));
        this.headerPanel.setBorder(BorderFactory.createLineBorder(resourceMap.getColor("headerPanel.border.lineColor")));
        this.headerPanel.setName("headerPanel");
        this.headerTextLabel.setFont(this.headerTextLabel.getFont().deriveFont((float)this.headerTextLabel.getFont().getSize() + 7.0f));
        this.headerTextLabel.setText(resourceMap.getString("headerTextLabel.text", new Object[0]));
        this.headerTextLabel.setName("headerTextLabel");
        ApplicationActionMap actionMap = Application.getInstance(PomodoroClientApp.class).getContext().getActionMap(PomodoroClientView.class, this);
        this.createNewPlanButton.setAction(actionMap.get("createPlan"));
        this.createNewPlanButton.setText(resourceMap.getString("createNewPlanButton.text", new Object[0]));
        this.createNewPlanButton.setName("createNewPlanButton");
        this.headerLogoLabel.setIcon(resourceMap.getIcon("headerLogoLabel.icon"));
        this.headerLogoLabel.setText(resourceMap.getString("headerLogoLabel.text", new Object[0]));
        this.headerLogoLabel.setName("headerLogoLabel");
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.headerTextLabel, -1, 228, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.createNewPlanButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.headerLogoLabel)));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerLogoLabel).addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.headerTextLabel, -2, 68, -2).addComponent(this.createNewPlanButton)));
        this.jScrollPane1.setBackground(resourceMap.getColor("jScrollPane1.background"));
        this.jScrollPane1.setName("jScrollPane1");
        this.jScrollPane1.setOpaque(false);
        this.workItemTable.setFont(this.workItemTable.getFont().deriveFont((float)this.workItemTable.getFont().getSize() + 3.0f));
        this.workItemTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"", "Work Item Title", "Pomodoros"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.workItemTable.setGridColor(resourceMap.getColor("workItemTable.gridColor"));
        this.workItemTable.setName("workItemTable");
        this.workItemTable.setOpaque(false);
        this.workItemTable.setRowHeight(25);
        this.workItemTable.setRowMargin(0);
        this.workItemTable.setSelectionBackground(resourceMap.getColor("workItemTable.selectionBackground"));
        this.workItemTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.workItemTable);
        this.workItemTable.getColumnModel().getColumn(0).setPreferredWidth(10);
        this.workItemTable.getColumnModel().getColumn(0).setHeaderValue(resourceMap.getString("workItemTable.columnModel.title0", new Object[0]));
        this.workItemTable.getColumnModel().getColumn(0).setCellRenderer(new WorkItemStatusRenderer());
        this.workItemTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.workItemTable.getColumnModel().getColumn(1).setHeaderValue(resourceMap.getString("workItemTable.columnModel.title1", new Object[0]));
        this.workItemTable.getColumnModel().getColumn(1).setCellRenderer(new WorkItemTitleRenderer());
        this.workItemTable.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.workItemTable.getColumnModel().getColumn(2).setHeaderValue(resourceMap.getString("workItemTable.columnModel.title2", new Object[0]));
        this.workItemTable.getColumnModel().getColumn(2).setCellRenderer(new PomodoroRenderer());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 550, Short.MAX_VALUE).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.headerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 203, Short.MAX_VALUE)));
        this.toolBar.setRollover(true);
        this.toolBar.setName("toolBar");
        this.addWorkItemButton.setAction(actionMap.get("addWorkItem"));
        this.addWorkItemButton.setIcon(resourceMap.getIcon("addWorkItemButton.icon"));
        this.addWorkItemButton.setText(resourceMap.getString("addWorkItemButton.text", new Object[0]));
        this.addWorkItemButton.setFocusable(false);
        this.addWorkItemButton.setHorizontalTextPosition(0);
        this.addWorkItemButton.setName("addWorkItemButton");
        this.addWorkItemButton.setVerticalTextPosition(3);
        this.toolBar.add(this.addWorkItemButton);
        this.completeWorkItemButton.setAction(actionMap.get("completeWorkItem"));
        this.completeWorkItemButton.setIcon(resourceMap.getIcon("completeWorkItemButton.icon"));
        this.completeWorkItemButton.setText(resourceMap.getString("completeWorkItemButton.text", new Object[0]));
        this.completeWorkItemButton.setFocusable(false);
        this.completeWorkItemButton.setHorizontalTextPosition(0);
        this.completeWorkItemButton.setName("completeWorkItemButton");
        this.completeWorkItemButton.setVerticalTextPosition(3);
        this.toolBar.add(this.completeWorkItemButton);
        this.deleteWorkItemButton.setAction(actionMap.get("deleteWorkItem"));
        this.deleteWorkItemButton.setIcon(resourceMap.getIcon("deleteWorkItemButton.icon"));
        this.deleteWorkItemButton.setText(resourceMap.getString("deleteWorkItemButton.text", new Object[0]));
        this.deleteWorkItemButton.setFocusable(false);
        this.deleteWorkItemButton.setHorizontalTextPosition(0);
        this.deleteWorkItemButton.setName("deleteWorkItemButton");
        this.deleteWorkItemButton.setVerticalTextPosition(3);
        this.toolBar.add(this.deleteWorkItemButton);
        this.jSeparator2.setName("jSeparator2");
        this.toolBar.add(this.jSeparator2);
        this.startPomodoroButton.setAction(actionMap.get("startPomodoro"));
        this.startPomodoroButton.setFont(resourceMap.getFont("startPomodoroButton.font"));
        this.startPomodoroButton.setIcon(resourceMap.getIcon("startPomodoroButton.icon"));
        this.startPomodoroButton.setText(resourceMap.getString("startPomodoroButton.text", new Object[0]));
        this.startPomodoroButton.setFocusable(false);
        this.startPomodoroButton.setHorizontalTextPosition(0);
        this.startPomodoroButton.setName("startPomodoroButton");
        this.startPomodoroButton.setVerticalTextPosition(3);
        this.toolBar.add(this.startPomodoroButton);
        this.addPomodoroButton.setAction(actionMap.get("addPomodoro"));
        this.addPomodoroButton.setIcon(resourceMap.getIcon("addPomodoroButton.icon"));
        this.addPomodoroButton.setText(resourceMap.getString("addPomodoroButton.text", new Object[0]));
        this.addPomodoroButton.setFocusable(false);
        this.addPomodoroButton.setHorizontalTextPosition(0);
        this.addPomodoroButton.setName("addPomodoroButton");
        this.addPomodoroButton.setVerticalTextPosition(3);
        this.toolBar.add(this.addPomodoroButton);
        this.jSeparator1.setName("jSeparator1");
        this.toolBar.add(this.jSeparator1);
        this.statisticsButton.setAction(actionMap.get("displayStatistics"));
        this.statisticsButton.setIcon(resourceMap.getIcon("statisticsButton.icon"));
        this.statisticsButton.setText(resourceMap.getString("statisticsButton.text", new Object[0]));
        this.statisticsButton.setFocusable(false);
        this.statisticsButton.setHorizontalTextPosition(0);
        this.statisticsButton.setName("statisticsButton");
        this.statisticsButton.setVerticalTextPosition(3);
        this.toolBar.add(this.statisticsButton);
        this.usersButton.setAction(actionMap.get("displayUsers"));
        this.usersButton.setIcon(resourceMap.getIcon("usersButton.icon"));
        this.usersButton.setText(resourceMap.getString("usersButton.text", new Object[0]));
        this.usersButton.setFocusable(false);
        this.usersButton.setHorizontalTextPosition(0);
        this.usersButton.setName("usersButton");
        this.usersButton.setVerticalTextPosition(3);
        this.toolBar.add(this.usersButton);
        this.settingsButton.setAction(actionMap.get("displaySettings"));
        this.settingsButton.setIcon(resourceMap.getIcon("settingsButton.icon"));
        this.settingsButton.setText(resourceMap.getString("settingsButton.text", new Object[0]));
        this.settingsButton.setFocusable(false);
        this.settingsButton.setHorizontalTextPosition(0);
        this.settingsButton.setName("settingsButton");
        this.settingsButton.setVerticalTextPosition(3);
        this.toolBar.add(this.settingsButton);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()).addComponent(this.toolBar, -1, 570, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.toolBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        this.deletePlanMenuItem.setAction(actionMap.get("deletePlan"));
        this.deletePlanMenuItem.setText(resourceMap.getString("deletePlanMenuItem.text", new Object[0]));
        this.deletePlanMenuItem.setName("deletePlanMenuItem");
        fileMenu.add(this.deletePlanMenuItem);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 570, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 400, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    @Action
    public void addWorkItem() throws NotFoundException {
        AddWorkItemDialog dlg = new AddWorkItemDialog((Frame)this.getFrame(), true);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            DefaultTableModel m = (DefaultTableModel)this.workItemTable.getModel();
            WorkitemType wi = this.server.addWorkItem(dlg.getWorkItemTitle(), dlg.getPomodoros());
            m.addRow(new Object[]{wi, wi, wi});
        }
    }

    @Action
    public void deleteWorkItem() {
        if (JOptionPane.showConfirmDialog(this.getFrame(), "Are you sure you want to delete this work item?", "Confirm", 0) == 0) {
            int offset = 0;
            for (int r : this.workItemTable.getSelectedRows()) {
                DefaultTableModel m = (DefaultTableModel)this.workItemTable.getModel();
                m.removeRow(r - offset++);
            }
        }
    }

    @Action
    public void startPomodoro() throws NotFoundException, NoPomodorosLeftException {
        int i = this.workItemTable.getSelectedRow();
        WorkitemType wi = this.server.getPlan().getWorkitem().get(i);
        PomodoroType pomodoro = this.server.startNextPomodoro(wi);
        this.timerWindow.setWorkItem(wi);
        this.timerWindow.setVisible(true);
        this.statusMessageLabel.setText("In a Pomodoro now. Click here to see the timer.");
        this.statusMessageLabel.addMouseListener(this.showPomodoroMouseListener);
        this.timer.startPomodoro(pomodoro);
        this.setToolbarButtonsEnabledAuto();
        this.refreshWorkItem(i);
        this.updateTitle();
        switch (this.getTimerWindowMode()) {
            case NO_TRAY: {
                break;
            }
            case HIDE_MAIN_WINDOW_ONLY: {
                this.getFrame().setVisible(false);
                this.timerWindow.setVisible(true);
                break;
            }
            case HIDE_EVERYTHING: {
                this.getFrame().setVisible(false);
                this.timerWindow.setVisible(false);
            }
        }
    }

    private boolean isSoundEnabled() {
        return this.prefs.get("timerSounds", "Y").equals("Y");
    }

    private TimerWindowMode getTimerWindowMode() {
        String mode = this.prefs.get("timerWindowMode", "M");
        if (mode.equals("N") || this.tray == null) {
            return TimerWindowMode.NO_TRAY;
        }
        if (mode.equals("M")) {
            return TimerWindowMode.HIDE_MAIN_WINDOW_ONLY;
        }
        return TimerWindowMode.HIDE_EVERYTHING;
    }

    private void updateTitle() throws NotFoundException {
        PlanType plan = this.server.getPlan();
        String state = "new";
        if (plan.getStatus().equals((Object)StatusType.FAILED)) {
            state = "failed";
        } else if (plan.getStatus().equals((Object)StatusType.COMPLETED)) {
            state = "completed";
        } else if (plan.getStatus().equals((Object)StatusType.STARTED)) {
            state = "started";
        }
        this.headerTextLabel.setText("Plan for " + plan.getDate().toString() + " (" + state + ")");
    }

    private void initTitle() {
        try {
            this.updateTitle();
            this.populateTable();
            this.createNewPlanButton.setVisible(false);
            this.deletePlanMenuItem.setEnabled(true);
            this.setWorkItemActionsEnabled(true);
            this.setToolbarButtonsEnabledAuto();
        }
        catch (NotFoundException ex) {
            this.headerTextLabel.setText("There is no plan for today");
            this.createNewPlanButton.setVisible(true);
            this.deletePlanMenuItem.setEnabled(false);
            this.setWorkItemActionsEnabled(false);
            this.setToolbarButtonsEnabledAuto();
            DefaultTableModel m = (DefaultTableModel)this.workItemTable.getModel();
            m.setRowCount(0);
        }
    }

    private void populateTable() throws NotFoundException {
        DefaultTableModel m = (DefaultTableModel)this.workItemTable.getModel();
        PlanType plan = this.server.getPlan();
        for (WorkitemType wi : plan.getWorkitem()) {
            m.addRow(new Object[]{wi, wi, wi});
        }
    }

    @Action
    public void createPlan() throws AlreadyExistsException, NotFoundException {
        this.server.createPlan();
        this.initTitle();
    }

    private void setWorkItemActionsEnabled(boolean enabled) {
        this.addWorkItemButton.setEnabled(enabled);
        this.deleteWorkItemButton.setEnabled(enabled);
        this.completeWorkItemButton.setEnabled(enabled);
        this.addPomodoroButton.setEnabled(enabled);
        this.statisticsButton.setEnabled(enabled);
    }

    private void setToolbarButtonsEnabledAuto() {
        try {
            int row = this.workItemTable.getSelectedRow();
            if (row == -1) {
                this.startPomodoroButton.setEnabled(false);
                if (this.tray != null) {
                    this.tray.pomodoroItemSetEnabled(false);
                }
                this.timerWindow.enableNextButton(false);
                this.addPomodoroButton.setEnabled(false);
                this.deleteWorkItemButton.setEnabled(false);
            } else {
                boolean planFinished;
                PlanType plan = this.server.getPlan();
                WorkitemType wi = plan.getWorkitem().get(row);
                boolean wiFinished = wi.getStatus().equals((Object)StatusType.COMPLETED) || wi.getStatus().equals((Object)StatusType.FAILED);
                boolean bl = planFinished = plan.getStatus().equals((Object)StatusType.COMPLETED) || plan.getStatus().equals((Object)StatusType.FAILED);
                if (planFinished) {
                    this.deleteWorkItemButton.setEnabled(false);
                    this.completeWorkItemButton.setEnabled(false);
                    this.addPomodoroButton.setEnabled(false);
                    this.addWorkItemButton.setEnabled(false);
                    this.startPomodoroButton.setEnabled(false);
                    if (this.tray != null) {
                        this.tray.pomodoroItemSetEnabled(false);
                    }
                    this.timerWindow.enableNextButton(false);
                } else {
                    this.completeWorkItemButton.setEnabled(!wiFinished);
                    this.addPomodoroButton.setEnabled(!wiFinished);
                    boolean pomodoroLeft = false;
                    for (PomodoroType p : wi.getPomodoro()) {
                        if (!p.getStatus().equals((Object)StatusType.NEW)) continue;
                        pomodoroLeft = true;
                        break;
                    }
                    boolean notInPomodoro = this.timer.getState().equals((Object)TimerState.READY);
                    boolean enablePomodoroButton = !wiFinished && pomodoroLeft && notInPomodoro;
                    this.startPomodoroButton.setEnabled(enablePomodoroButton);
                    if (this.tray != null) {
                        this.tray.pomodoroItemSetEnabled(enablePomodoroButton);
                    }
                    this.timerWindow.enableNextButton(enablePomodoroButton);
                }
            }
        }
        catch (NotFoundException ex) {
            this.startPomodoroButton.setEnabled(false);
            if (this.tray != null) {
                this.tray.pomodoroItemSetEnabled(false);
            }
            this.timerWindow.enableNextButton(false);
        }
    }

    @Action
    public void addPomodoro() throws NotFoundException {
        int i = this.workItemTable.getSelectedRow();
        WorkitemType wi = this.server.getPlan().getWorkitem().get(i);
        if (wi.getPomodoro().size() >= 4) {
            JOptionPane.showMessageDialog(this.getFrame(), "It is not advisable to assign more than\nfour pomodoros per each work item", "Pomodoro Technique Advice", 2);
        }
        this.server.addPomodoro(wi);
        this.refreshWorkItem(i);
    }

    private void refreshWorkItem(int index) throws NotFoundException {
        WorkitemType wi = this.server.getPlan().getWorkitem().get(index);
        this.workItemTable.getModel().setValueAt(wi, index, 0);
        this.workItemTable.getModel().setValueAt(wi, index, 1);
        this.workItemTable.getModel().setValueAt(wi, index, 2);
        this.setToolbarButtonsEnabledAuto();
    }

    private void refreshSelectedWorkItem() throws NotFoundException {
        this.refreshWorkItem(this.workItemTable.getSelectedRow());
    }

    @Action
    public void completeWorkItem() throws NotFoundException {
        int i = this.workItemTable.getSelectedRow();
        WorkitemType wi = this.server.getPlan().getWorkitem().get(i);
        this.server.completeWorkItem(wi);
        this.refreshWorkItem(i);
    }

    @Action
    public void displayStatistics() throws NotFoundException {
        new StatisticsWindow(null, true, this.server.getPlan()).setVisible(true);
    }

    @Action
    public void displayUsers() {
        new UsersWindow(null, true, this.server).setVisible(true);
    }

    @Action
    public void deletePlan() {
        if (JOptionPane.showConfirmDialog(this.getFrame(), "Are you sure you want to delete this plan? You will lose all data for today.", "Confirm", 0) == 0) {
            try {
                this.timer.voidCurrentPomodoro();
            }
            catch (IllegalStateException ex) {
                Logger.getLogger(PomodoroClientView.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                this.server.deletePlan(this.server.getPlan());
                this.initTitle();
            }
            catch (Exception ex) {
                Logger.getLogger(PomodoroClientView.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Action
    public void displaySettings() {
        SettingsWindow w = new SettingsWindow((Frame)this.getFrame(), true, this.server.getUser());
        w.setVisible(true);
        if (this.soundListener != null) {
            this.timer.removeListener(this.soundListener);
            this.soundListener.disable();
            if (this.isSoundEnabled()) {
                this.timer.addListener(this.soundListener);
                this.soundListener.enable();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimerWindowMode {
        NO_TRAY,
        HIDE_MAIN_WINDOW_ONLY,
        HIDE_EVERYTHING;

    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            PomodoroClientView.this.setToolbarButtonsEnabledAuto();
        }
    }
}

