/*
 * Decompiled with CFR 0.152.
 */
package com.pomodorotechnique.client.ui;

import com.pomodorotechnique.client.ui.timer.Timer;
import com.pomodorotechnique.client.ui.timer.TimerListener;
import com.pomodorotechnique.client.ui.timer.TimerState;
import com.pomodorotechnique.server.PomodoroType;
import java.io.BufferedInputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;

public class SoundsTimerListener
implements TimerListener {
    private final Clip clipTick;
    private final Clip clipEnd;
    private boolean active = true;
    private final Timer timer;
    private boolean firstTime = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SoundsTimerListener(Timer timer) {
        this.timer = timer;
        try {
            AudioInputStream ais = null;
            try {
                ais = AudioSystem.getAudioInputStream(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream("sounds/tick.wav")));
                this.clipTick = AudioSystem.getClip();
                this.clipTick.open(ais);
                this.clipTick.setLoopPoints(0, -1);
            }
            finally {
                if (ais != null) {
                    ais.close();
                }
            }
            try {
                ais = AudioSystem.getAudioInputStream(new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream("sounds/end.wav")));
                this.clipEnd = AudioSystem.getClip();
                this.clipEnd.open(ais);
                this.clipEnd.setLoopPoints(0, -1);
            }
            finally {
                if (ais != null) {
                    ais.close();
                }
            }
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException(t);
        }
    }

    public void onPomodoroStarted(PomodoroType pomodoro) {
        this.active = true;
        this.start();
    }

    private void playDing() {
        if (this.firstTime) {
            this.clipEnd.loop(0);
            this.firstTime = false;
        } else {
            this.clipEnd.loop(1);
        }
    }

    public void onWorkCompleted(PomodoroType pomodoro, boolean successfully) {
        this.active = false;
        this.stop();
        if (successfully) {
            this.playDing();
        }
    }

    public void onReady() {
        this.active = false;
        this.stop();
        this.playDing();
    }

    public void onTick() {
        if (!this.clipTick.isRunning() && this.active && this.timer.getState().equals((Object)TimerState.BUSY)) {
            this.start();
        }
    }

    public void enable() {
        this.active = true;
    }

    public void disable() {
        this.active = false;
        this.stop();
    }

    private void stop() {
        this.clipTick.stop();
    }

    private void start() {
        this.clipTick.loop(-1);
    }
}

