# Localization Guidelines

Help to translate Vidtuber to other languages
-----------------

## Updates an existing translation

#### Requirements:
- [poEdit](https://poedit.net/), to do the actual translation you can use [poEdit](https://poedit.net/). It allows you to create, update and start translating a translation catalog from a `PO` file, and finally generate a `MO` file needed to apply the translation of a program.

### PO, POT and MO files - what are they?
`PO` format stands for **Portable Object** and is the standard file format for localization for doing the actual translation, while `POT` format stands for **Portable Object Template** and is a format generated by GNU gettext to streamline software localization and internationalization. `POT` file is just a template that should never be edited directly, [PO file: Learn more here](https://www.gnu.org/software/gettext/manual/html_node/PO-Files.html).
The `MO` (Machine Object) file format is the file extension given by the compiler when building the language binary file to ensure that the program can be effectively translated (from a human-readable text `PO` file to the machine language `MO` file), [MO file: Learn more here](https://www.gnu.org/software/gettext/manual/html_node/MO-Files.html).

### Let's get started
- Download [latest](https://github.com/jeanslack/Vidtuber/releases/latest) release of Vidtuber source archive (zipball or tarball).

- Extract the archive and open the obtained Vidtuber source directory.

- Browse into `vidtuber/data/locale` and choose the language code directory you are interested in translating.

- Then browse into language code directory, e.g `<LANG_CODE>/LC_MESSAGES`, and locate the `vidtuber.po` file, like this:

``` text
    Vidtuber (source directory)
    |__ vidtuber
        |__ data
            |__ locale
                |__ <LANG_CODE> (language code, e.g de_DE)
                    |__ LC_MESSAGES
                        |__ vidtuber.po
```
- Open the `vidtuber.po` file with [poEdit](https://poedit.net/) 

- Click on [poEdit](https://poedit.net/) menu bar *-> Catalog -> Update from POT file...*, then 
import the `vidtuber.pot` file template sited on `locale` folder. This is **important** as it 
ensures that the `vidtuber.po` file is fully updated with the latest translation strings.

- Also, check the catalog property data on menu bar *> Catalog > Property...*
and make sure it contains at least some updated indications you could provide.

- Now, you are ready to start your translation. When you're done save your work; 
you can always resume your work from where you left off.

- Before running Vidtuber to test your updated translation, please install the required [dependencies](https://github.com/jeanslack/Vidtuber/blob/main/INSTALL).

- Try your new tranlation by open a terminal window, `cd` on the `Vidtuber` 
sources directory and type: `python3 launcher`. 

When you have completed your translation with 'PoEdit', please [Create a pull 
request](https://github.com/jeanslack/Vidtuber/pulls) or send me your 
`vidtuber.po` file at: <jeanlucperni@gmail.com>   

I will be grateful!!

At your disposal for clarification.

-----------------

## Start with a new translation

If you cannot find support for the language you wish to translate on Vidtuber, 
please make a request for new language support by contacting the application developer 
at <jeanlucperni@gmail.com> or opening a new issue using the [Feature request](https://github.com/jeanslack/Vidtuber/issues/new/choose) form.

#### Notes
When you request support for a new language, the language code should be in the format `en_US` and NOT just `en` using the standard language codes **<ISO 639-1>_<ISO 3166-1 alpha-2>** (e.g. `en_US`). See more at [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) and [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) wikipedia pages.

Thanks!

-----------------

## General rules

- Variables such as `{0}`, `{1}`, `{dir}`, `{0:.1f}`, etc should be copied exactly as they appear in the translation box.
- Leave keyboard accelerator shortcuts such as `\tCtrl+O`, `\tCtrl+Shift+H`, `\tDEL`, `\tShift+DEL`, etc as they appear in the translation box.
- If possible, try to respect the length of sentences where the newline character such as `\n` is present.
- When you request to publish your translation, make sure you include useful information for any contacts: name or nickname and email or website (see [PO file headers](https://www.gnu.org/software/gettext/manual/html_node/Header-Entry.html)).
- Binary translation files (MO) are not accepted and you should not push them upstream or on any Pull Requests.

-----------------

## Useful Resources
- [ISO 639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes)
- [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2)
- [PO file format](https://www.gnu.org/software/gettext/manual/html_node/PO-Files.html)
- [PO file headers](https://www.gnu.org/software/gettext/manual/html_node/Header-Entry.html)
- [GNU gettext manual](https://www.gnu.org/software/gettext/manual/html_node/index.html#SEC_Contents)




