#if defined(ALF_LSB_FIRST) && defined(ALF_MSB_FIRST)
#  error Cannot define both ALF_LSB_FIRST and ALF_MSB_FIRST
#endif

/* user defined one or the other in COPT, use it. */
#if defined(ALF_LSB_FIRST) || defined(ALF_MSB_FIRST)
#  define ALF_ENDIAN_OK
#endif

/* try to get the byte order on this platform.
   if we succeed, either ALF_LSB_FIRST or ALF_MSB_FIRST will
   be defined, and so will ALF_ENDIAN_OK. */

#ifndef ALF_ENDIAN_OK
#  if defined(__BYTE_ORDER__)
#    if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#      define ALF_LSB_FIRST
#      define ALF_ENDIAN_OK
#    else
#      if __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__
#        define ALF_MSB_FIRST
#        define ALF_ENDIAN_OK
#      endif
#    endif
#  endif
#endif

/* if the __BYTE_ORDER__ macro wasn't defined... */
#ifndef ALF_ENDIAN_OK
#  if defined(__LITTLE_ENDIAN__ || defined __LITTLE_ENDIAN || defined LITTLE_ENDIAN)
#    define ALF_LSB_FIRST
#    define ALF_ENDIAN_OK
#  else
#    if defined(__BIG_ENDIAN__ || defined __BIG_ENDIAN || defined BIG_ENDIAN)
#      define ALF_MSB_FIRST
#      define ALF_ENDIAN_OK
#    endif
#  endif
#endif

#ifdef ALF_ENDIAN_OK
#  ifdef ALF_LSB_FIRST
#    define HIBYTE 2
#    define MIDBYTE 1
#    define LOBYTE 0
#  else
#    define HIBYTE 1
#    define MIDBYTE 2
#    define LOBYTE 3
#  endif
#else
#  warning Cannot determine endianness, falling back to safe but slow append_bit().
#  warning Recompile with -DALF_LSB_FIRST or -DALF_MSB_FIRST.
#endif
