#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

/* only check this many filenames */
#define MAX_FNAMES 1024

/* FILENAME.EXT\0 = 13 */
#define FNAME_LEN 13

// #define DUPNAME_DEBUG

static char filenames[MAX_FNAMES][FNAME_LEN];
static int fncount;

/* linear search, slow, but only happens once at startup */
int is_dup_filename(const char *newname) {
	int i;

	for(i = 0; i < fncount; i++)
		if(strncmp(newname, filenames[i], FNAME_LEN - 1) == 0)
			return 1;

	strncpy(filenames[fncount++], newname, FNAME_LEN - 1);

	return 0;
}

#ifdef DUPNAME_DEBUG
int main(int argc, char **argv) {
	int i;

	while(++argv, --argc)
		printf("%s: %d\n", *argv, is_dup_filename(*argv));

	printf("filenames[]\n");

	for(i = 0; i < fncount; i++)
		printf("   %s\n", filenames[i]);

	return 0;
}
#endif
