#[allow(non_camel_case_types)]
#[derive(Debug, Clone, Copy, PartialEq, Eq, PartialOrd, Ord, Hash)]
pub enum Opcode {
  PHI,
  INLINEASM,
  INLINEASM_BR,
  CFI_INSTRUCTION,
  EH_LABEL,
  GC_LABEL,
  ANNOTATION_LABEL,
  KILL,
  EXTRACT_SUBREG,
  INSERT_SUBREG,
  IMPLICIT_DEF,
  SUBREG_TO_REG,
  COPY_TO_REGCLASS,
  DBG_VALUE,
  DBG_VALUE_LIST,
  DBG_INSTR_REF,
  DBG_PHI,
  DBG_LABEL,
  REG_SEQUENCE,
  COPY,
  BUNDLE,
  LIFETIME_START,
  LIFETIME_END,
  PSEUDO_PROBE,
  ARITH_FENCE,
  STACKMAP,
  FENTRY_CALL,
  PATCHPOINT,
  LOAD_STACK_GUARD,
  PREALLOCATED_SETUP,
  PREALLOCATED_ARG,
  STATEPOINT,
  LOCAL_ESCAPE,
  FAULTING_OP,
  PATCHABLE_OP,
  PATCHABLE_FUNCTION_ENTER,
  PATCHABLE_RET,
  PATCHABLE_FUNCTION_EXIT,
  PATCHABLE_TAIL_CALL,
  PATCHABLE_EVENT_CALL,
  PATCHABLE_TYPED_EVENT_CALL,
  ICALL_BRANCH_FUNNEL,
  MEMBARRIER,
  JUMP_TABLE_DEBUG_INFO,
  CONVERGENCECTRL_ENTRY,
  CONVERGENCECTRL_ANCHOR,
  CONVERGENCECTRL_LOOP,
  CONVERGENCECTRL_GLUE,
  G_ASSERT_SEXT,
  G_ASSERT_ZEXT,
  G_ASSERT_ALIGN,
  G_ADD,
  G_SUB,
  G_MUL,
  G_SDIV,
  G_UDIV,
  G_SREM,
  G_UREM,
  G_SDIVREM,
  G_UDIVREM,
  G_AND,
  G_OR,
  G_XOR,
  G_IMPLICIT_DEF,
  G_PHI,
  G_FRAME_INDEX,
  G_GLOBAL_VALUE,
  G_PTRAUTH_GLOBAL_VALUE,
  G_CONSTANT_POOL,
  G_EXTRACT,
  G_UNMERGE_VALUES,
  G_INSERT,
  G_MERGE_VALUES,
  G_BUILD_VECTOR,
  G_BUILD_VECTOR_TRUNC,
  G_CONCAT_VECTORS,
  G_PTRTOINT,
  G_INTTOPTR,
  G_BITCAST,
  G_FREEZE,
  G_CONSTANT_FOLD_BARRIER,
  G_INTRINSIC_FPTRUNC_ROUND,
  G_INTRINSIC_TRUNC,
  G_INTRINSIC_ROUND,
  G_INTRINSIC_LRINT,
  G_INTRINSIC_LLRINT,
  G_INTRINSIC_ROUNDEVEN,
  G_READCYCLECOUNTER,
  G_READSTEADYCOUNTER,
  G_LOAD,
  G_SEXTLOAD,
  G_ZEXTLOAD,
  G_INDEXED_LOAD,
  G_INDEXED_SEXTLOAD,
  G_INDEXED_ZEXTLOAD,
  G_STORE,
  G_INDEXED_STORE,
  G_ATOMIC_CMPXCHG_WITH_SUCCESS,
  G_ATOMIC_CMPXCHG,
  G_ATOMICRMW_XCHG,
  G_ATOMICRMW_ADD,
  G_ATOMICRMW_SUB,
  G_ATOMICRMW_AND,
  G_ATOMICRMW_NAND,
  G_ATOMICRMW_OR,
  G_ATOMICRMW_XOR,
  G_ATOMICRMW_MAX,
  G_ATOMICRMW_MIN,
  G_ATOMICRMW_UMAX,
  G_ATOMICRMW_UMIN,
  G_ATOMICRMW_FADD,
  G_ATOMICRMW_FSUB,
  G_ATOMICRMW_FMAX,
  G_ATOMICRMW_FMIN,
  G_ATOMICRMW_UINC_WRAP,
  G_ATOMICRMW_UDEC_WRAP,
  G_FENCE,
  G_PREFETCH,
  G_BRCOND,
  G_BRINDIRECT,
  G_INVOKE_REGION_START,
  G_INTRINSIC,
  G_INTRINSIC_W_SIDE_EFFECTS,
  G_INTRINSIC_CONVERGENT,
  G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
  G_ANYEXT,
  G_TRUNC,
  G_CONSTANT,
  G_FCONSTANT,
  G_VASTART,
  G_VAARG,
  G_SEXT,
  G_SEXT_INREG,
  G_ZEXT,
  G_SHL,
  G_LSHR,
  G_ASHR,
  G_FSHL,
  G_FSHR,
  G_ROTR,
  G_ROTL,
  G_ICMP,
  G_FCMP,
  G_SCMP,
  G_UCMP,
  G_SELECT,
  G_UADDO,
  G_UADDE,
  G_USUBO,
  G_USUBE,
  G_SADDO,
  G_SADDE,
  G_SSUBO,
  G_SSUBE,
  G_UMULO,
  G_SMULO,
  G_UMULH,
  G_SMULH,
  G_UADDSAT,
  G_SADDSAT,
  G_USUBSAT,
  G_SSUBSAT,
  G_USHLSAT,
  G_SSHLSAT,
  G_SMULFIX,
  G_UMULFIX,
  G_SMULFIXSAT,
  G_UMULFIXSAT,
  G_SDIVFIX,
  G_UDIVFIX,
  G_SDIVFIXSAT,
  G_UDIVFIXSAT,
  G_FADD,
  G_FSUB,
  G_FMUL,
  G_FMA,
  G_FMAD,
  G_FDIV,
  G_FREM,
  G_FPOW,
  G_FPOWI,
  G_FEXP,
  G_FEXP2,
  G_FEXP10,
  G_FLOG,
  G_FLOG2,
  G_FLOG10,
  G_FLDEXP,
  G_FFREXP,
  G_FNEG,
  G_FPEXT,
  G_FPTRUNC,
  G_FPTOSI,
  G_FPTOUI,
  G_SITOFP,
  G_UITOFP,
  G_FABS,
  G_FCOPYSIGN,
  G_IS_FPCLASS,
  G_FCANONICALIZE,
  G_FMINNUM,
  G_FMAXNUM,
  G_FMINNUM_IEEE,
  G_FMAXNUM_IEEE,
  G_FMINIMUM,
  G_FMAXIMUM,
  G_GET_FPENV,
  G_SET_FPENV,
  G_RESET_FPENV,
  G_GET_FPMODE,
  G_SET_FPMODE,
  G_RESET_FPMODE,
  G_PTR_ADD,
  G_PTRMASK,
  G_SMIN,
  G_SMAX,
  G_UMIN,
  G_UMAX,
  G_ABS,
  G_LROUND,
  G_LLROUND,
  G_BR,
  G_BRJT,
  G_VSCALE,
  G_INSERT_SUBVECTOR,
  G_EXTRACT_SUBVECTOR,
  G_INSERT_VECTOR_ELT,
  G_EXTRACT_VECTOR_ELT,
  G_SHUFFLE_VECTOR,
  G_SPLAT_VECTOR,
  G_VECTOR_COMPRESS,
  G_CTTZ,
  G_CTTZ_ZERO_UNDEF,
  G_CTLZ,
  G_CTLZ_ZERO_UNDEF,
  G_CTPOP,
  G_BSWAP,
  G_BITREVERSE,
  G_FCEIL,
  G_FCOS,
  G_FSIN,
  G_FTAN,
  G_FACOS,
  G_FASIN,
  G_FATAN,
  G_FCOSH,
  G_FSINH,
  G_FTANH,
  G_FSQRT,
  G_FFLOOR,
  G_FRINT,
  G_FNEARBYINT,
  G_ADDRSPACE_CAST,
  G_BLOCK_ADDR,
  G_JUMP_TABLE,
  G_DYN_STACKALLOC,
  G_STACKSAVE,
  G_STACKRESTORE,
  G_STRICT_FADD,
  G_STRICT_FSUB,
  G_STRICT_FMUL,
  G_STRICT_FDIV,
  G_STRICT_FREM,
  G_STRICT_FMA,
  G_STRICT_FSQRT,
  G_STRICT_FLDEXP,
  G_READ_REGISTER,
  G_WRITE_REGISTER,
  G_MEMCPY,
  G_MEMCPY_INLINE,
  G_MEMMOVE,
  G_MEMSET,
  G_BZERO,
  G_TRAP,
  G_DEBUGTRAP,
  G_UBSANTRAP,
  G_VECREDUCE_SEQ_FADD,
  G_VECREDUCE_SEQ_FMUL,
  G_VECREDUCE_FADD,
  G_VECREDUCE_FMUL,
  G_VECREDUCE_FMAX,
  G_VECREDUCE_FMIN,
  G_VECREDUCE_FMAXIMUM,
  G_VECREDUCE_FMINIMUM,
  G_VECREDUCE_ADD,
  G_VECREDUCE_MUL,
  G_VECREDUCE_AND,
  G_VECREDUCE_OR,
  G_VECREDUCE_XOR,
  G_VECREDUCE_SMAX,
  G_VECREDUCE_SMIN,
  G_VECREDUCE_UMAX,
  G_VECREDUCE_UMIN,
  G_SBFX,
  G_UBFX,
  ADD16ri_DB,
  ADD16rr_DB,
  ADD32ri_DB,
  ADD32rr_DB,
  ADD64ri32_DB,
  ADD64rr_DB,
  ADD8ri_DB,
  ADD8rr_DB,
  AVX1_SETALLONES,
  AVX2_SETALLONES,
  AVX512_128_SET0,
  AVX512_256_SET0,
  AVX512_512_SET0,
  AVX512_512_SETALLONES,
  AVX512_512_SEXT_MASK_32,
  AVX512_512_SEXT_MASK_64,
  AVX512_FsFLD0F128,
  AVX512_FsFLD0SD,
  AVX512_FsFLD0SH,
  AVX512_FsFLD0SS,
  AVX_SET0,
  CALL64m_RVMARKER,
  CALL64pcrel32_RVMARKER,
  CALL64r_RVMARKER,
  FsFLD0F128,
  FsFLD0SD,
  FsFLD0SH,
  FsFLD0SS,
  INDIRECT_THUNK_CALL32,
  INDIRECT_THUNK_CALL64,
  INDIRECT_THUNK_TCRETURN32,
  INDIRECT_THUNK_TCRETURN64,
  KSET0D,
  KSET0Q,
  KSET0W,
  KSET1D,
  KSET1Q,
  KSET1W,
  LCMPXCHG16B_NO_RBX,
  LCMPXCHG16B_SAVE_RBX,
  MMX_SET0,
  MORESTACK_RET,
  MORESTACK_RET_RESTORE_R10,
  MOV32ImmSExti8,
  MOV32r0,
  MOV32r1,
  MOV32r_1,
  MOV32ri64,
  MOV64ImmSExti8,
  MWAITX,
  MWAITX_SAVE_RBX,
  PLDTILECFGV,
  PLEA32r,
  PLEA64r,
  PTDPBF16PSV,
  PTDPBSSDV,
  PTDPBSUDV,
  PTDPBUSDV,
  PTDPBUUDV,
  PTDPFP16PSV,
  PTILELOADDT1V,
  PTILELOADDV,
  PTILESTOREDV,
  PTILEZEROV,
  RDFLAGS32,
  RDFLAGS64,
  SEH_EndPrologue,
  SEH_Epilogue,
  SEH_PushFrame,
  SEH_PushReg,
  SEH_SaveReg,
  SEH_SaveXMM,
  SEH_SetFrame,
  SEH_StackAlign,
  SEH_StackAlloc,
  SETB_C32r,
  SETB_C64r,
  SHLDROT32ri,
  SHLDROT64ri,
  SHRDROT32ri,
  SHRDROT64ri,
  VMOVAPSZ128mr_NOVLX,
  VMOVAPSZ128rm_NOVLX,
  VMOVAPSZ256mr_NOVLX,
  VMOVAPSZ256rm_NOVLX,
  VMOVUPSZ128mr_NOVLX,
  VMOVUPSZ128rm_NOVLX,
  VMOVUPSZ256mr_NOVLX,
  VMOVUPSZ256rm_NOVLX,
  V_SET0,
  V_SETALLONES,
  WRFLAGS32,
  WRFLAGS64,
  XABORT_DEF,
  XOR32_FP,
  XOR64_FP,
  AAA,
  AAD8i8,
  AADD32mr,
  AADD32mr_EVEX,
  AADD64mr,
  AADD64mr_EVEX,
  AAM8i8,
  AAND32mr,
  AAND32mr_EVEX,
  AAND64mr,
  AAND64mr_EVEX,
  AAS,
  ABS_F,
  ABS_Fp32,
  ABS_Fp64,
  ABS_Fp80,
  ADC16i16,
  ADC16mi,
  ADC16mi8,
  ADC16mi8_EVEX,
  ADC16mi8_ND,
  ADC16mi_EVEX,
  ADC16mi_ND,
  ADC16mr,
  ADC16mr_EVEX,
  ADC16mr_ND,
  ADC16ri,
  ADC16ri8,
  ADC16ri8_EVEX,
  ADC16ri8_ND,
  ADC16ri_EVEX,
  ADC16ri_ND,
  ADC16rm,
  ADC16rm_EVEX,
  ADC16rm_ND,
  ADC16rr,
  ADC16rr_EVEX,
  ADC16rr_EVEX_REV,
  ADC16rr_ND,
  ADC16rr_ND_REV,
  ADC16rr_REV,
  ADC32i32,
  ADC32mi,
  ADC32mi8,
  ADC32mi8_EVEX,
  ADC32mi8_ND,
  ADC32mi_EVEX,
  ADC32mi_ND,
  ADC32mr,
  ADC32mr_EVEX,
  ADC32mr_ND,
  ADC32ri,
  ADC32ri8,
  ADC32ri8_EVEX,
  ADC32ri8_ND,
  ADC32ri_EVEX,
  ADC32ri_ND,
  ADC32rm,
  ADC32rm_EVEX,
  ADC32rm_ND,
  ADC32rr,
  ADC32rr_EVEX,
  ADC32rr_EVEX_REV,
  ADC32rr_ND,
  ADC32rr_ND_REV,
  ADC32rr_REV,
  ADC64i32,
  ADC64mi32,
  ADC64mi32_EVEX,
  ADC64mi32_ND,
  ADC64mi8,
  ADC64mi8_EVEX,
  ADC64mi8_ND,
  ADC64mr,
  ADC64mr_EVEX,
  ADC64mr_ND,
  ADC64ri32,
  ADC64ri32_EVEX,
  ADC64ri32_ND,
  ADC64ri8,
  ADC64ri8_EVEX,
  ADC64ri8_ND,
  ADC64rm,
  ADC64rm_EVEX,
  ADC64rm_ND,
  ADC64rr,
  ADC64rr_EVEX,
  ADC64rr_EVEX_REV,
  ADC64rr_ND,
  ADC64rr_ND_REV,
  ADC64rr_REV,
  ADC8i8,
  ADC8mi,
  ADC8mi8,
  ADC8mi_EVEX,
  ADC8mi_ND,
  ADC8mr,
  ADC8mr_EVEX,
  ADC8mr_ND,
  ADC8ri,
  ADC8ri8,
  ADC8ri_EVEX,
  ADC8ri_ND,
  ADC8rm,
  ADC8rm_EVEX,
  ADC8rm_ND,
  ADC8rr,
  ADC8rr_EVEX,
  ADC8rr_EVEX_REV,
  ADC8rr_ND,
  ADC8rr_ND_REV,
  ADC8rr_REV,
  ADCX32rm,
  ADCX32rm_EVEX,
  ADCX32rm_ND,
  ADCX32rr,
  ADCX32rr_EVEX,
  ADCX32rr_ND,
  ADCX64rm,
  ADCX64rm_EVEX,
  ADCX64rm_ND,
  ADCX64rr,
  ADCX64rr_EVEX,
  ADCX64rr_ND,
  ADD16i16,
  ADD16mi,
  ADD16mi8,
  ADD16mi8_EVEX,
  ADD16mi8_ND,
  ADD16mi8_NF,
  ADD16mi8_NF_ND,
  ADD16mi_EVEX,
  ADD16mi_ND,
  ADD16mi_NF,
  ADD16mi_NF_ND,
  ADD16mr,
  ADD16mr_EVEX,
  ADD16mr_ND,
  ADD16mr_NF,
  ADD16mr_NF_ND,
  ADD16ri,
  ADD16ri8,
  ADD16ri8_EVEX,
  ADD16ri8_ND,
  ADD16ri8_NF,
  ADD16ri8_NF_ND,
  ADD16ri_EVEX,
  ADD16ri_ND,
  ADD16ri_NF,
  ADD16ri_NF_ND,
  ADD16rm,
  ADD16rm_EVEX,
  ADD16rm_ND,
  ADD16rm_NF,
  ADD16rm_NF_ND,
  ADD16rr,
  ADD16rr_EVEX,
  ADD16rr_EVEX_REV,
  ADD16rr_ND,
  ADD16rr_ND_REV,
  ADD16rr_NF,
  ADD16rr_NF_ND,
  ADD16rr_NF_ND_REV,
  ADD16rr_NF_REV,
  ADD16rr_REV,
  ADD32i32,
  ADD32mi,
  ADD32mi8,
  ADD32mi8_EVEX,
  ADD32mi8_ND,
  ADD32mi8_NF,
  ADD32mi8_NF_ND,
  ADD32mi_EVEX,
  ADD32mi_ND,
  ADD32mi_NF,
  ADD32mi_NF_ND,
  ADD32mr,
  ADD32mr_EVEX,
  ADD32mr_ND,
  ADD32mr_NF,
  ADD32mr_NF_ND,
  ADD32ri,
  ADD32ri8,
  ADD32ri8_EVEX,
  ADD32ri8_ND,
  ADD32ri8_NF,
  ADD32ri8_NF_ND,
  ADD32ri_EVEX,
  ADD32ri_ND,
  ADD32ri_NF,
  ADD32ri_NF_ND,
  ADD32rm,
  ADD32rm_EVEX,
  ADD32rm_ND,
  ADD32rm_NF,
  ADD32rm_NF_ND,
  ADD32rr,
  ADD32rr_EVEX,
  ADD32rr_EVEX_REV,
  ADD32rr_ND,
  ADD32rr_ND_REV,
  ADD32rr_NF,
  ADD32rr_NF_ND,
  ADD32rr_NF_ND_REV,
  ADD32rr_NF_REV,
  ADD32rr_REV,
  ADD64i32,
  ADD64mi32,
  ADD64mi32_EVEX,
  ADD64mi32_ND,
  ADD64mi32_NF,
  ADD64mi32_NF_ND,
  ADD64mi8,
  ADD64mi8_EVEX,
  ADD64mi8_ND,
  ADD64mi8_NF,
  ADD64mi8_NF_ND,
  ADD64mr,
  ADD64mr_EVEX,
  ADD64mr_ND,
  ADD64mr_NF,
  ADD64mr_NF_ND,
  ADD64ri32,
  ADD64ri32_EVEX,
  ADD64ri32_ND,
  ADD64ri32_NF,
  ADD64ri32_NF_ND,
  ADD64ri8,
  ADD64ri8_EVEX,
  ADD64ri8_ND,
  ADD64ri8_NF,
  ADD64ri8_NF_ND,
  ADD64rm,
  ADD64rm_EVEX,
  ADD64rm_ND,
  ADD64rm_NF,
  ADD64rm_NF_ND,
  ADD64rr,
  ADD64rr_EVEX,
  ADD64rr_EVEX_REV,
  ADD64rr_ND,
  ADD64rr_ND_REV,
  ADD64rr_NF,
  ADD64rr_NF_ND,
  ADD64rr_NF_ND_REV,
  ADD64rr_NF_REV,
  ADD64rr_REV,
  ADD8i8,
  ADD8mi,
  ADD8mi8,
  ADD8mi_EVEX,
  ADD8mi_ND,
  ADD8mi_NF,
  ADD8mi_NF_ND,
  ADD8mr,
  ADD8mr_EVEX,
  ADD8mr_ND,
  ADD8mr_NF,
  ADD8mr_NF_ND,
  ADD8ri,
  ADD8ri8,
  ADD8ri_EVEX,
  ADD8ri_ND,
  ADD8ri_NF,
  ADD8ri_NF_ND,
  ADD8rm,
  ADD8rm_EVEX,
  ADD8rm_ND,
  ADD8rm_NF,
  ADD8rm_NF_ND,
  ADD8rr,
  ADD8rr_EVEX,
  ADD8rr_EVEX_REV,
  ADD8rr_ND,
  ADD8rr_ND_REV,
  ADD8rr_NF,
  ADD8rr_NF_ND,
  ADD8rr_NF_ND_REV,
  ADD8rr_NF_REV,
  ADD8rr_REV,
  ADDPDrm,
  ADDPDrr,
  ADDPSrm,
  ADDPSrr,
  ADDR16_PREFIX,
  ADDR32_PREFIX,
  ADDSDrm,
  ADDSDrm_Int,
  ADDSDrr,
  ADDSDrr_Int,
  ADDSSrm,
  ADDSSrm_Int,
  ADDSSrr,
  ADDSSrr_Int,
  ADDSUBPDrm,
  ADDSUBPDrr,
  ADDSUBPSrm,
  ADDSUBPSrr,
  ADD_F32m,
  ADD_F64m,
  ADD_FI16m,
  ADD_FI32m,
  ADD_FPrST0,
  ADD_FST0r,
  ADD_Fp32,
  ADD_Fp32m,
  ADD_Fp64,
  ADD_Fp64m,
  ADD_Fp64m32,
  ADD_Fp80,
  ADD_Fp80m32,
  ADD_Fp80m64,
  ADD_FpI16m32,
  ADD_FpI16m64,
  ADD_FpI16m80,
  ADD_FpI32m32,
  ADD_FpI32m64,
  ADD_FpI32m80,
  ADD_FrST0,
  ADJCALLSTACKDOWN32,
  ADJCALLSTACKDOWN64,
  ADJCALLSTACKUP32,
  ADJCALLSTACKUP64,
  ADOX32rm,
  ADOX32rm_EVEX,
  ADOX32rm_ND,
  ADOX32rr,
  ADOX32rr_EVEX,
  ADOX32rr_ND,
  ADOX64rm,
  ADOX64rm_EVEX,
  ADOX64rm_ND,
  ADOX64rr,
  ADOX64rr_EVEX,
  ADOX64rr_ND,
  AESDEC128KL,
  AESDEC256KL,
  AESDECLASTrm,
  AESDECLASTrr,
  AESDECWIDE128KL,
  AESDECWIDE256KL,
  AESDECrm,
  AESDECrr,
  AESENC128KL,
  AESENC256KL,
  AESENCLASTrm,
  AESENCLASTrr,
  AESENCWIDE128KL,
  AESENCWIDE256KL,
  AESENCrm,
  AESENCrr,
  AESIMCrm,
  AESIMCrr,
  AESKEYGENASSIST128rm,
  AESKEYGENASSIST128rr,
  AND16i16,
  AND16mi,
  AND16mi8,
  AND16mi8_EVEX,
  AND16mi8_ND,
  AND16mi8_NF,
  AND16mi8_NF_ND,
  AND16mi_EVEX,
  AND16mi_ND,
  AND16mi_NF,
  AND16mi_NF_ND,
  AND16mr,
  AND16mr_EVEX,
  AND16mr_ND,
  AND16mr_NF,
  AND16mr_NF_ND,
  AND16ri,
  AND16ri8,
  AND16ri8_EVEX,
  AND16ri8_ND,
  AND16ri8_NF,
  AND16ri8_NF_ND,
  AND16ri_EVEX,
  AND16ri_ND,
  AND16ri_NF,
  AND16ri_NF_ND,
  AND16rm,
  AND16rm_EVEX,
  AND16rm_ND,
  AND16rm_NF,
  AND16rm_NF_ND,
  AND16rr,
  AND16rr_EVEX,
  AND16rr_EVEX_REV,
  AND16rr_ND,
  AND16rr_ND_REV,
  AND16rr_NF,
  AND16rr_NF_ND,
  AND16rr_NF_ND_REV,
  AND16rr_NF_REV,
  AND16rr_REV,
  AND32i32,
  AND32mi,
  AND32mi8,
  AND32mi8_EVEX,
  AND32mi8_ND,
  AND32mi8_NF,
  AND32mi8_NF_ND,
  AND32mi_EVEX,
  AND32mi_ND,
  AND32mi_NF,
  AND32mi_NF_ND,
  AND32mr,
  AND32mr_EVEX,
  AND32mr_ND,
  AND32mr_NF,
  AND32mr_NF_ND,
  AND32ri,
  AND32ri8,
  AND32ri8_EVEX,
  AND32ri8_ND,
  AND32ri8_NF,
  AND32ri8_NF_ND,
  AND32ri_EVEX,
  AND32ri_ND,
  AND32ri_NF,
  AND32ri_NF_ND,
  AND32rm,
  AND32rm_EVEX,
  AND32rm_ND,
  AND32rm_NF,
  AND32rm_NF_ND,
  AND32rr,
  AND32rr_EVEX,
  AND32rr_EVEX_REV,
  AND32rr_ND,
  AND32rr_ND_REV,
  AND32rr_NF,
  AND32rr_NF_ND,
  AND32rr_NF_ND_REV,
  AND32rr_NF_REV,
  AND32rr_REV,
  AND64i32,
  AND64mi32,
  AND64mi32_EVEX,
  AND64mi32_ND,
  AND64mi32_NF,
  AND64mi32_NF_ND,
  AND64mi8,
  AND64mi8_EVEX,
  AND64mi8_ND,
  AND64mi8_NF,
  AND64mi8_NF_ND,
  AND64mr,
  AND64mr_EVEX,
  AND64mr_ND,
  AND64mr_NF,
  AND64mr_NF_ND,
  AND64ri32,
  AND64ri32_EVEX,
  AND64ri32_ND,
  AND64ri32_NF,
  AND64ri32_NF_ND,
  AND64ri8,
  AND64ri8_EVEX,
  AND64ri8_ND,
  AND64ri8_NF,
  AND64ri8_NF_ND,
  AND64rm,
  AND64rm_EVEX,
  AND64rm_ND,
  AND64rm_NF,
  AND64rm_NF_ND,
  AND64rr,
  AND64rr_EVEX,
  AND64rr_EVEX_REV,
  AND64rr_ND,
  AND64rr_ND_REV,
  AND64rr_NF,
  AND64rr_NF_ND,
  AND64rr_NF_ND_REV,
  AND64rr_NF_REV,
  AND64rr_REV,
  AND8i8,
  AND8mi,
  AND8mi8,
  AND8mi_EVEX,
  AND8mi_ND,
  AND8mi_NF,
  AND8mi_NF_ND,
  AND8mr,
  AND8mr_EVEX,
  AND8mr_ND,
  AND8mr_NF,
  AND8mr_NF_ND,
  AND8ri,
  AND8ri8,
  AND8ri_EVEX,
  AND8ri_ND,
  AND8ri_NF,
  AND8ri_NF_ND,
  AND8rm,
  AND8rm_EVEX,
  AND8rm_ND,
  AND8rm_NF,
  AND8rm_NF_ND,
  AND8rr,
  AND8rr_EVEX,
  AND8rr_EVEX_REV,
  AND8rr_ND,
  AND8rr_ND_REV,
  AND8rr_NF,
  AND8rr_NF_ND,
  AND8rr_NF_ND_REV,
  AND8rr_NF_REV,
  AND8rr_REV,
  ANDN32rm,
  ANDN32rm_EVEX,
  ANDN32rm_NF,
  ANDN32rr,
  ANDN32rr_EVEX,
  ANDN32rr_NF,
  ANDN64rm,
  ANDN64rm_EVEX,
  ANDN64rm_NF,
  ANDN64rr,
  ANDN64rr_EVEX,
  ANDN64rr_NF,
  ANDNPDrm,
  ANDNPDrr,
  ANDNPSrm,
  ANDNPSrr,
  ANDPDrm,
  ANDPDrr,
  ANDPSrm,
  ANDPSrr,
  AOR32mr,
  AOR32mr_EVEX,
  AOR64mr,
  AOR64mr_EVEX,
  ARPL16mr,
  ARPL16rr,
  ASAN_CHECK_MEMACCESS,
  AXOR32mr,
  AXOR32mr_EVEX,
  AXOR64mr,
  AXOR64mr_EVEX,
  BEXTR32rm,
  BEXTR32rm_EVEX,
  BEXTR32rm_NF,
  BEXTR32rr,
  BEXTR32rr_EVEX,
  BEXTR32rr_NF,
  BEXTR64rm,
  BEXTR64rm_EVEX,
  BEXTR64rm_NF,
  BEXTR64rr,
  BEXTR64rr_EVEX,
  BEXTR64rr_NF,
  BEXTRI32mi,
  BEXTRI32ri,
  BEXTRI64mi,
  BEXTRI64ri,
  BLCFILL32rm,
  BLCFILL32rr,
  BLCFILL64rm,
  BLCFILL64rr,
  BLCI32rm,
  BLCI32rr,
  BLCI64rm,
  BLCI64rr,
  BLCIC32rm,
  BLCIC32rr,
  BLCIC64rm,
  BLCIC64rr,
  BLCMSK32rm,
  BLCMSK32rr,
  BLCMSK64rm,
  BLCMSK64rr,
  BLCS32rm,
  BLCS32rr,
  BLCS64rm,
  BLCS64rr,
  BLENDPDrmi,
  BLENDPDrri,
  BLENDPSrmi,
  BLENDPSrri,
  BLENDVPDrm0,
  BLENDVPDrr0,
  BLENDVPSrm0,
  BLENDVPSrr0,
  BLSFILL32rm,
  BLSFILL32rr,
  BLSFILL64rm,
  BLSFILL64rr,
  BLSI32rm,
  BLSI32rm_EVEX,
  BLSI32rm_NF,
  BLSI32rr,
  BLSI32rr_EVEX,
  BLSI32rr_NF,
  BLSI64rm,
  BLSI64rm_EVEX,
  BLSI64rm_NF,
  BLSI64rr,
  BLSI64rr_EVEX,
  BLSI64rr_NF,
  BLSIC32rm,
  BLSIC32rr,
  BLSIC64rm,
  BLSIC64rr,
  BLSMSK32rm,
  BLSMSK32rm_EVEX,
  BLSMSK32rm_NF,
  BLSMSK32rr,
  BLSMSK32rr_EVEX,
  BLSMSK32rr_NF,
  BLSMSK64rm,
  BLSMSK64rm_EVEX,
  BLSMSK64rm_NF,
  BLSMSK64rr,
  BLSMSK64rr_EVEX,
  BLSMSK64rr_NF,
  BLSR32rm,
  BLSR32rm_EVEX,
  BLSR32rm_NF,
  BLSR32rr,
  BLSR32rr_EVEX,
  BLSR32rr_NF,
  BLSR64rm,
  BLSR64rm_EVEX,
  BLSR64rm_NF,
  BLSR64rr,
  BLSR64rr_EVEX,
  BLSR64rr_NF,
  BOUNDS16rm,
  BOUNDS32rm,
  BSF16rm,
  BSF16rr,
  BSF32rm,
  BSF32rr,
  BSF64rm,
  BSF64rr,
  BSR16rm,
  BSR16rr,
  BSR32rm,
  BSR32rr,
  BSR64rm,
  BSR64rr,
  BSWAP16r_BAD,
  BSWAP32r,
  BSWAP64r,
  BT16mi8,
  BT16mr,
  BT16ri8,
  BT16rr,
  BT32mi8,
  BT32mr,
  BT32ri8,
  BT32rr,
  BT64mi8,
  BT64mr,
  BT64ri8,
  BT64rr,
  BTC16mi8,
  BTC16mr,
  BTC16ri8,
  BTC16rr,
  BTC32mi8,
  BTC32mr,
  BTC32ri8,
  BTC32rr,
  BTC64mi8,
  BTC64mr,
  BTC64ri8,
  BTC64rr,
  BTR16mi8,
  BTR16mr,
  BTR16ri8,
  BTR16rr,
  BTR32mi8,
  BTR32mr,
  BTR32ri8,
  BTR32rr,
  BTR64mi8,
  BTR64mr,
  BTR64ri8,
  BTR64rr,
  BTS16mi8,
  BTS16mr,
  BTS16ri8,
  BTS16rr,
  BTS32mi8,
  BTS32mr,
  BTS32ri8,
  BTS32rr,
  BTS64mi8,
  BTS64mr,
  BTS64ri8,
  BTS64rr,
  BZHI32rm,
  BZHI32rm_EVEX,
  BZHI32rm_NF,
  BZHI32rr,
  BZHI32rr_EVEX,
  BZHI32rr_NF,
  BZHI64rm,
  BZHI64rm_EVEX,
  BZHI64rm_NF,
  BZHI64rr,
  BZHI64rr_EVEX,
  BZHI64rr_NF,
  CALL16m,
  CALL16m_NT,
  CALL16r,
  CALL16r_NT,
  CALL32m,
  CALL32m_NT,
  CALL32r,
  CALL32r_NT,
  CALL64m,
  CALL64m_NT,
  CALL64pcrel32,
  CALL64r,
  CALL64r_NT,
  CALLpcrel16,
  CALLpcrel32,
  CATCHRET,
  CBW,
  CCMP16mi,
  CCMP16mi8,
  CCMP16mr,
  CCMP16ri,
  CCMP16ri8,
  CCMP16rm,
  CCMP16rr,
  CCMP16rr_REV,
  CCMP32mi,
  CCMP32mi8,
  CCMP32mr,
  CCMP32ri,
  CCMP32ri8,
  CCMP32rm,
  CCMP32rr,
  CCMP32rr_REV,
  CCMP64mi32,
  CCMP64mi8,
  CCMP64mr,
  CCMP64ri32,
  CCMP64ri8,
  CCMP64rm,
  CCMP64rr,
  CCMP64rr_REV,
  CCMP8mi,
  CCMP8mr,
  CCMP8ri,
  CCMP8rm,
  CCMP8rr,
  CCMP8rr_REV,
  CDQ,
  CDQE,
  CFCMOV16mr,
  CFCMOV16rm,
  CFCMOV16rm_ND,
  CFCMOV16rr,
  CFCMOV16rr_ND,
  CFCMOV16rr_REV,
  CFCMOV32mr,
  CFCMOV32rm,
  CFCMOV32rm_ND,
  CFCMOV32rr,
  CFCMOV32rr_ND,
  CFCMOV32rr_REV,
  CFCMOV64mr,
  CFCMOV64rm,
  CFCMOV64rm_ND,
  CFCMOV64rr,
  CFCMOV64rr_ND,
  CFCMOV64rr_REV,
  CHS_F,
  CHS_Fp32,
  CHS_Fp64,
  CHS_Fp80,
  CLAC,
  CLC,
  CLD,
  CLDEMOTE,
  CLEANUPRET,
  CLFLUSH,
  CLFLUSHOPT,
  CLGI,
  CLI,
  CLRSSBSY,
  CLTS,
  CLUI,
  CLWB,
  CLZERO32r,
  CLZERO64r,
  CMC,
  CMOV16rm,
  CMOV16rm_ND,
  CMOV16rr,
  CMOV16rr_ND,
  CMOV32rm,
  CMOV32rm_ND,
  CMOV32rr,
  CMOV32rr_ND,
  CMOV64rm,
  CMOV64rm_ND,
  CMOV64rr,
  CMOV64rr_ND,
  CMOVBE_F,
  CMOVBE_Fp32,
  CMOVBE_Fp64,
  CMOVBE_Fp80,
  CMOVB_F,
  CMOVB_Fp32,
  CMOVB_Fp64,
  CMOVB_Fp80,
  CMOVE_F,
  CMOVE_Fp32,
  CMOVE_Fp64,
  CMOVE_Fp80,
  CMOVNBE_F,
  CMOVNBE_Fp32,
  CMOVNBE_Fp64,
  CMOVNBE_Fp80,
  CMOVNB_F,
  CMOVNB_Fp32,
  CMOVNB_Fp64,
  CMOVNB_Fp80,
  CMOVNE_F,
  CMOVNE_Fp32,
  CMOVNE_Fp64,
  CMOVNE_Fp80,
  CMOVNP_F,
  CMOVNP_Fp32,
  CMOVNP_Fp64,
  CMOVNP_Fp80,
  CMOVP_F,
  CMOVP_Fp32,
  CMOVP_Fp64,
  CMOVP_Fp80,
  CMOV_FR16,
  CMOV_FR16X,
  CMOV_FR32,
  CMOV_FR32X,
  CMOV_FR64,
  CMOV_FR64X,
  CMOV_GR16,
  CMOV_GR32,
  CMOV_GR8,
  CMOV_RFP32,
  CMOV_RFP64,
  CMOV_RFP80,
  CMOV_VK1,
  CMOV_VK16,
  CMOV_VK2,
  CMOV_VK32,
  CMOV_VK4,
  CMOV_VK64,
  CMOV_VK8,
  CMOV_VR128,
  CMOV_VR128X,
  CMOV_VR256,
  CMOV_VR256X,
  CMOV_VR512,
  CMOV_VR64,
  CMP16i16,
  CMP16mi,
  CMP16mi8,
  CMP16mr,
  CMP16ri,
  CMP16ri8,
  CMP16rm,
  CMP16rr,
  CMP16rr_REV,
  CMP32i32,
  CMP32mi,
  CMP32mi8,
  CMP32mr,
  CMP32ri,
  CMP32ri8,
  CMP32rm,
  CMP32rr,
  CMP32rr_REV,
  CMP64i32,
  CMP64mi32,
  CMP64mi8,
  CMP64mr,
  CMP64ri32,
  CMP64ri8,
  CMP64rm,
  CMP64rr,
  CMP64rr_REV,
  CMP8i8,
  CMP8mi,
  CMP8mi8,
  CMP8mr,
  CMP8ri,
  CMP8ri8,
  CMP8rm,
  CMP8rr,
  CMP8rr_REV,
  CMPCCXADDmr32,
  CMPCCXADDmr32_EVEX,
  CMPCCXADDmr64,
  CMPCCXADDmr64_EVEX,
  CMPPDrmi,
  CMPPDrri,
  CMPPSrmi,
  CMPPSrri,
  CMPSB,
  CMPSDrmi,
  CMPSDrmi_Int,
  CMPSDrri,
  CMPSDrri_Int,
  CMPSL,
  CMPSQ,
  CMPSSrmi,
  CMPSSrmi_Int,
  CMPSSrri,
  CMPSSrri_Int,
  CMPSW,
  CMPXCHG16B,
  CMPXCHG16rm,
  CMPXCHG16rr,
  CMPXCHG32rm,
  CMPXCHG32rr,
  CMPXCHG64rm,
  CMPXCHG64rr,
  CMPXCHG8B,
  CMPXCHG8rm,
  CMPXCHG8rr,
  COMISDrm,
  COMISDrm_Int,
  COMISDrr,
  COMISDrr_Int,
  COMISSrm,
  COMISSrm_Int,
  COMISSrr,
  COMISSrr_Int,
  COMP_FST0r,
  COM_FIPr,
  COM_FIr,
  COM_FST0r,
  COM_FpIr32,
  COM_FpIr64,
  COM_FpIr80,
  COM_Fpr32,
  COM_Fpr64,
  COM_Fpr80,
  CPUID,
  CQO,
  CRC32r32m16,
  CRC32r32m16_EVEX,
  CRC32r32m32,
  CRC32r32m32_EVEX,
  CRC32r32m8,
  CRC32r32m8_EVEX,
  CRC32r32r16,
  CRC32r32r16_EVEX,
  CRC32r32r32,
  CRC32r32r32_EVEX,
  CRC32r32r8,
  CRC32r32r8_EVEX,
  CRC32r64m64,
  CRC32r64m64_EVEX,
  CRC32r64m8,
  CRC32r64m8_EVEX,
  CRC32r64r64,
  CRC32r64r64_EVEX,
  CRC32r64r8,
  CRC32r64r8_EVEX,
  CS_PREFIX,
  CTEST16mi,
  CTEST16mr,
  CTEST16ri,
  CTEST16rr,
  CTEST32mi,
  CTEST32mr,
  CTEST32ri,
  CTEST32rr,
  CTEST64mi32,
  CTEST64mr,
  CTEST64ri32,
  CTEST64rr,
  CTEST8mi,
  CTEST8mr,
  CTEST8ri,
  CTEST8rr,
  CVTDQ2PDrm,
  CVTDQ2PDrr,
  CVTDQ2PSrm,
  CVTDQ2PSrr,
  CVTPD2DQrm,
  CVTPD2DQrr,
  CVTPD2PSrm,
  CVTPD2PSrr,
  CVTPS2DQrm,
  CVTPS2DQrr,
  CVTPS2PDrm,
  CVTPS2PDrr,
  CVTSD2SI64rm,
  CVTSD2SI64rm_Int,
  CVTSD2SI64rr,
  CVTSD2SI64rr_Int,
  CVTSD2SIrm,
  CVTSD2SIrm_Int,
  CVTSD2SIrr,
  CVTSD2SIrr_Int,
  CVTSD2SSrm,
  CVTSD2SSrm_Int,
  CVTSD2SSrr,
  CVTSD2SSrr_Int,
  CVTSI2SDrm,
  CVTSI2SDrm_Int,
  CVTSI2SDrr,
  CVTSI2SDrr_Int,
  CVTSI2SSrm,
  CVTSI2SSrm_Int,
  CVTSI2SSrr,
  CVTSI2SSrr_Int,
  CVTSI642SDrm,
  CVTSI642SDrm_Int,
  CVTSI642SDrr,
  CVTSI642SDrr_Int,
  CVTSI642SSrm,
  CVTSI642SSrm_Int,
  CVTSI642SSrr,
  CVTSI642SSrr_Int,
  CVTSS2SDrm,
  CVTSS2SDrm_Int,
  CVTSS2SDrr,
  CVTSS2SDrr_Int,
  CVTSS2SI64rm,
  CVTSS2SI64rm_Int,
  CVTSS2SI64rr,
  CVTSS2SI64rr_Int,
  CVTSS2SIrm,
  CVTSS2SIrm_Int,
  CVTSS2SIrr,
  CVTSS2SIrr_Int,
  CVTTPD2DQrm,
  CVTTPD2DQrr,
  CVTTPS2DQrm,
  CVTTPS2DQrr,
  CVTTSD2SI64rm,
  CVTTSD2SI64rm_Int,
  CVTTSD2SI64rr,
  CVTTSD2SI64rr_Int,
  CVTTSD2SIrm,
  CVTTSD2SIrm_Int,
  CVTTSD2SIrr,
  CVTTSD2SIrr_Int,
  CVTTSS2SI64rm,
  CVTTSS2SI64rm_Int,
  CVTTSS2SI64rr,
  CVTTSS2SI64rr_Int,
  CVTTSS2SIrm,
  CVTTSS2SIrm_Int,
  CVTTSS2SIrr,
  CVTTSS2SIrr_Int,
  CWD,
  CWDE,
  DAA,
  DAS,
  DATA16_PREFIX,
  DEC16m,
  DEC16m_EVEX,
  DEC16m_ND,
  DEC16m_NF,
  DEC16m_NF_ND,
  DEC16r,
  DEC16r_EVEX,
  DEC16r_ND,
  DEC16r_NF,
  DEC16r_NF_ND,
  DEC16r_alt,
  DEC32m,
  DEC32m_EVEX,
  DEC32m_ND,
  DEC32m_NF,
  DEC32m_NF_ND,
  DEC32r,
  DEC32r_EVEX,
  DEC32r_ND,
  DEC32r_NF,
  DEC32r_NF_ND,
  DEC32r_alt,
  DEC64m,
  DEC64m_EVEX,
  DEC64m_ND,
  DEC64m_NF,
  DEC64m_NF_ND,
  DEC64r,
  DEC64r_EVEX,
  DEC64r_ND,
  DEC64r_NF,
  DEC64r_NF_ND,
  DEC8m,
  DEC8m_EVEX,
  DEC8m_ND,
  DEC8m_NF,
  DEC8m_NF_ND,
  DEC8r,
  DEC8r_EVEX,
  DEC8r_ND,
  DEC8r_NF,
  DEC8r_NF_ND,
  DIV16m,
  DIV16m_EVEX,
  DIV16m_NF,
  DIV16r,
  DIV16r_EVEX,
  DIV16r_NF,
  DIV32m,
  DIV32m_EVEX,
  DIV32m_NF,
  DIV32r,
  DIV32r_EVEX,
  DIV32r_NF,
  DIV64m,
  DIV64m_EVEX,
  DIV64m_NF,
  DIV64r,
  DIV64r_EVEX,
  DIV64r_NF,
  DIV8m,
  DIV8m_EVEX,
  DIV8m_NF,
  DIV8r,
  DIV8r_EVEX,
  DIV8r_NF,
  DIVPDrm,
  DIVPDrr,
  DIVPSrm,
  DIVPSrr,
  DIVR_F32m,
  DIVR_F64m,
  DIVR_FI16m,
  DIVR_FI32m,
  DIVR_FPrST0,
  DIVR_FST0r,
  DIVR_Fp32m,
  DIVR_Fp64m,
  DIVR_Fp64m32,
  DIVR_Fp80m32,
  DIVR_Fp80m64,
  DIVR_FpI16m32,
  DIVR_FpI16m64,
  DIVR_FpI16m80,
  DIVR_FpI32m32,
  DIVR_FpI32m64,
  DIVR_FpI32m80,
  DIVR_FrST0,
  DIVSDrm,
  DIVSDrm_Int,
  DIVSDrr,
  DIVSDrr_Int,
  DIVSSrm,
  DIVSSrm_Int,
  DIVSSrr,
  DIVSSrr_Int,
  DIV_F32m,
  DIV_F64m,
  DIV_FI16m,
  DIV_FI32m,
  DIV_FPrST0,
  DIV_FST0r,
  DIV_Fp32,
  DIV_Fp32m,
  DIV_Fp64,
  DIV_Fp64m,
  DIV_Fp64m32,
  DIV_Fp80,
  DIV_Fp80m32,
  DIV_Fp80m64,
  DIV_FpI16m32,
  DIV_FpI16m64,
  DIV_FpI16m80,
  DIV_FpI32m32,
  DIV_FpI32m64,
  DIV_FpI32m80,
  DIV_FrST0,
  DPPDrmi,
  DPPDrri,
  DPPSrmi,
  DPPSrri,
  DS_PREFIX,
  DYN_ALLOCA_32,
  DYN_ALLOCA_64,
  EH_RETURN,
  EH_RETURN64,
  EH_SjLj_LongJmp32,
  EH_SjLj_LongJmp64,
  EH_SjLj_SetJmp32,
  EH_SjLj_SetJmp64,
  EH_SjLj_Setup,
  ENCLS,
  ENCLU,
  ENCLV,
  ENCODEKEY128,
  ENCODEKEY256,
  ENDBR32,
  ENDBR64,
  ENQCMD16,
  ENQCMD32,
  ENQCMD32_EVEX,
  ENQCMD64,
  ENQCMD64_EVEX,
  ENQCMDS16,
  ENQCMDS32,
  ENQCMDS32_EVEX,
  ENQCMDS64,
  ENQCMDS64_EVEX,
  ENTER,
  ERETS,
  ERETU,
  ES_PREFIX,
  EXTRACTPSmr,
  EXTRACTPSrr,
  EXTRQ,
  EXTRQI,
  F2XM1,
  FARCALL16i,
  FARCALL16m,
  FARCALL32i,
  FARCALL32m,
  FARCALL64m,
  FARJMP16i,
  FARJMP16m,
  FARJMP32i,
  FARJMP32m,
  FARJMP64m,
  FBLDm,
  FBSTPm,
  FCOM32m,
  FCOM64m,
  FCOMP32m,
  FCOMP64m,
  FCOMPP,
  FCOS,
  FDECSTP,
  FEMMS,
  FFREE,
  FFREEP,
  FICOM16m,
  FICOM32m,
  FICOMP16m,
  FICOMP32m,
  FINCSTP,
  FLDCW16m,
  FLDENVm,
  FLDL2E,
  FLDL2T,
  FLDLG2,
  FLDLN2,
  FLDPI,
  FNCLEX,
  FNINIT,
  FNOP,
  FNSTCW16m,
  FNSTSW16r,
  FNSTSWm,
  FP32_TO_INT16_IN_MEM,
  FP32_TO_INT32_IN_MEM,
  FP32_TO_INT64_IN_MEM,
  FP64_TO_INT16_IN_MEM,
  FP64_TO_INT32_IN_MEM,
  FP64_TO_INT64_IN_MEM,
  FP80_ADDm32,
  FP80_ADDr,
  FP80_TO_INT16_IN_MEM,
  FP80_TO_INT32_IN_MEM,
  FP80_TO_INT64_IN_MEM,
  FPATAN,
  FPREM,
  FPREM1,
  FPTAN,
  FRNDINT,
  FRSTORm,
  FSAVEm,
  FSCALE,
  FSIN,
  FSINCOS,
  FSTENVm,
  FS_PREFIX,
  FXRSTOR,
  FXRSTOR64,
  FXSAVE,
  FXSAVE64,
  FXTRACT,
  FYL2X,
  FYL2XP1,
  GETSEC,
  GF2P8AFFINEINVQBrmi,
  GF2P8AFFINEINVQBrri,
  GF2P8AFFINEQBrmi,
  GF2P8AFFINEQBrri,
  GF2P8MULBrm,
  GF2P8MULBrr,
  GS_PREFIX,
  HADDPDrm,
  HADDPDrr,
  HADDPSrm,
  HADDPSrr,
  HLT,
  HRESET,
  HSUBPDrm,
  HSUBPDrr,
  HSUBPSrm,
  HSUBPSrr,
  IDIV16m,
  IDIV16m_EVEX,
  IDIV16m_NF,
  IDIV16r,
  IDIV16r_EVEX,
  IDIV16r_NF,
  IDIV32m,
  IDIV32m_EVEX,
  IDIV32m_NF,
  IDIV32r,
  IDIV32r_EVEX,
  IDIV32r_NF,
  IDIV64m,
  IDIV64m_EVEX,
  IDIV64m_NF,
  IDIV64r,
  IDIV64r_EVEX,
  IDIV64r_NF,
  IDIV8m,
  IDIV8m_EVEX,
  IDIV8m_NF,
  IDIV8r,
  IDIV8r_EVEX,
  IDIV8r_NF,
  ILD_F16m,
  ILD_F32m,
  ILD_F64m,
  ILD_Fp16m32,
  ILD_Fp16m64,
  ILD_Fp16m80,
  ILD_Fp32m32,
  ILD_Fp32m64,
  ILD_Fp32m80,
  ILD_Fp64m32,
  ILD_Fp64m64,
  ILD_Fp64m80,
  IMUL16m,
  IMUL16m_EVEX,
  IMUL16m_NF,
  IMUL16r,
  IMUL16r_EVEX,
  IMUL16r_NF,
  IMUL16rm,
  IMUL16rm_EVEX,
  IMUL16rm_ND,
  IMUL16rm_NF,
  IMUL16rm_NF_ND,
  IMUL16rmi,
  IMUL16rmi8,
  IMUL16rmi8_EVEX,
  IMUL16rmi8_NF,
  IMUL16rmi_EVEX,
  IMUL16rmi_NF,
  IMUL16rr,
  IMUL16rr_EVEX,
  IMUL16rr_ND,
  IMUL16rr_NF,
  IMUL16rr_NF_ND,
  IMUL16rri,
  IMUL16rri8,
  IMUL16rri8_EVEX,
  IMUL16rri8_NF,
  IMUL16rri_EVEX,
  IMUL16rri_NF,
  IMUL32m,
  IMUL32m_EVEX,
  IMUL32m_NF,
  IMUL32r,
  IMUL32r_EVEX,
  IMUL32r_NF,
  IMUL32rm,
  IMUL32rm_EVEX,
  IMUL32rm_ND,
  IMUL32rm_NF,
  IMUL32rm_NF_ND,
  IMUL32rmi,
  IMUL32rmi8,
  IMUL32rmi8_EVEX,
  IMUL32rmi8_NF,
  IMUL32rmi_EVEX,
  IMUL32rmi_NF,
  IMUL32rr,
  IMUL32rr_EVEX,
  IMUL32rr_ND,
  IMUL32rr_NF,
  IMUL32rr_NF_ND,
  IMUL32rri,
  IMUL32rri8,
  IMUL32rri8_EVEX,
  IMUL32rri8_NF,
  IMUL32rri_EVEX,
  IMUL32rri_NF,
  IMUL64m,
  IMUL64m_EVEX,
  IMUL64m_NF,
  IMUL64r,
  IMUL64r_EVEX,
  IMUL64r_NF,
  IMUL64rm,
  IMUL64rm_EVEX,
  IMUL64rm_ND,
  IMUL64rm_NF,
  IMUL64rm_NF_ND,
  IMUL64rmi32,
  IMUL64rmi32_EVEX,
  IMUL64rmi32_NF,
  IMUL64rmi8,
  IMUL64rmi8_EVEX,
  IMUL64rmi8_NF,
  IMUL64rr,
  IMUL64rr_EVEX,
  IMUL64rr_ND,
  IMUL64rr_NF,
  IMUL64rr_NF_ND,
  IMUL64rri32,
  IMUL64rri32_EVEX,
  IMUL64rri32_NF,
  IMUL64rri8,
  IMUL64rri8_EVEX,
  IMUL64rri8_NF,
  IMUL8m,
  IMUL8m_EVEX,
  IMUL8m_NF,
  IMUL8r,
  IMUL8r_EVEX,
  IMUL8r_NF,
  IMULZU16rmi,
  IMULZU16rmi8,
  IMULZU16rri,
  IMULZU16rri8,
  IMULZU32rmi,
  IMULZU32rmi8,
  IMULZU32rri,
  IMULZU32rri8,
  IMULZU64rmi32,
  IMULZU64rmi8,
  IMULZU64rri32,
  IMULZU64rri8,
  IN16ri,
  IN16rr,
  IN32ri,
  IN32rr,
  IN8ri,
  IN8rr,
  INC16m,
  INC16m_EVEX,
  INC16m_ND,
  INC16m_NF,
  INC16m_NF_ND,
  INC16r,
  INC16r_EVEX,
  INC16r_ND,
  INC16r_NF,
  INC16r_NF_ND,
  INC16r_alt,
  INC32m,
  INC32m_EVEX,
  INC32m_ND,
  INC32m_NF,
  INC32m_NF_ND,
  INC32r,
  INC32r_EVEX,
  INC32r_ND,
  INC32r_NF,
  INC32r_NF_ND,
  INC32r_alt,
  INC64m,
  INC64m_EVEX,
  INC64m_ND,
  INC64m_NF,
  INC64m_NF_ND,
  INC64r,
  INC64r_EVEX,
  INC64r_ND,
  INC64r_NF,
  INC64r_NF_ND,
  INC8m,
  INC8m_EVEX,
  INC8m_ND,
  INC8m_NF,
  INC8m_NF_ND,
  INC8r,
  INC8r_EVEX,
  INC8r_ND,
  INC8r_NF,
  INC8r_NF_ND,
  INCSSPD,
  INCSSPQ,
  INSB,
  INSERTPSrm,
  INSERTPSrr,
  INSERTQ,
  INSERTQI,
  INSL,
  INSW,
  INT,
  INT3,
  INTO,
  INVD,
  INVEPT32,
  INVEPT64,
  INVEPT64_EVEX,
  INVLPG,
  INVLPGA32,
  INVLPGA64,
  INVLPGB32,
  INVLPGB64,
  INVPCID32,
  INVPCID64,
  INVPCID64_EVEX,
  INVVPID32,
  INVVPID64,
  INVVPID64_EVEX,
  IRET,
  IRET16,
  IRET32,
  IRET64,
  ISTT_FP16m,
  ISTT_FP32m,
  ISTT_FP64m,
  ISTT_Fp16m32,
  ISTT_Fp16m64,
  ISTT_Fp16m80,
  ISTT_Fp32m32,
  ISTT_Fp32m64,
  ISTT_Fp32m80,
  ISTT_Fp64m32,
  ISTT_Fp64m64,
  ISTT_Fp64m80,
  IST_F16m,
  IST_F32m,
  IST_FP16m,
  IST_FP32m,
  IST_FP64m,
  IST_Fp16m32,
  IST_Fp16m64,
  IST_Fp16m80,
  IST_Fp32m32,
  IST_Fp32m64,
  IST_Fp32m80,
  IST_Fp64m32,
  IST_Fp64m64,
  IST_Fp64m80,
  Int_eh_sjlj_setup_dispatch,
  JCC_1,
  JCC_2,
  JCC_4,
  JCXZ,
  JECXZ,
  JMP16m,
  JMP16m_NT,
  JMP16r,
  JMP16r_NT,
  JMP32m,
  JMP32m_NT,
  JMP32r,
  JMP32r_NT,
  JMP64m,
  JMP64m_NT,
  JMP64m_REX,
  JMP64r,
  JMP64r_NT,
  JMP64r_REX,
  JMPABS64i,
  JMP_1,
  JMP_2,
  JMP_4,
  JRCXZ,
  KADDBrr,
  KADDDrr,
  KADDQrr,
  KADDWrr,
  KANDBrr,
  KANDDrr,
  KANDNBrr,
  KANDNDrr,
  KANDNQrr,
  KANDNWrr,
  KANDQrr,
  KANDWrr,
  KCFI_CHECK,
  KMOVBkk,
  KMOVBkk_EVEX,
  KMOVBkm,
  KMOVBkm_EVEX,
  KMOVBkr,
  KMOVBkr_EVEX,
  KMOVBmk,
  KMOVBmk_EVEX,
  KMOVBrk,
  KMOVBrk_EVEX,
  KMOVDkk,
  KMOVDkk_EVEX,
  KMOVDkm,
  KMOVDkm_EVEX,
  KMOVDkr,
  KMOVDkr_EVEX,
  KMOVDmk,
  KMOVDmk_EVEX,
  KMOVDrk,
  KMOVDrk_EVEX,
  KMOVQkk,
  KMOVQkk_EVEX,
  KMOVQkm,
  KMOVQkm_EVEX,
  KMOVQkr,
  KMOVQkr_EVEX,
  KMOVQmk,
  KMOVQmk_EVEX,
  KMOVQrk,
  KMOVQrk_EVEX,
  KMOVWkk,
  KMOVWkk_EVEX,
  KMOVWkm,
  KMOVWkm_EVEX,
  KMOVWkr,
  KMOVWkr_EVEX,
  KMOVWmk,
  KMOVWmk_EVEX,
  KMOVWrk,
  KMOVWrk_EVEX,
  KNOTBrr,
  KNOTDrr,
  KNOTQrr,
  KNOTWrr,
  KORBrr,
  KORDrr,
  KORQrr,
  KORTESTBrr,
  KORTESTDrr,
  KORTESTQrr,
  KORTESTWrr,
  KORWrr,
  KSHIFTLBri,
  KSHIFTLDri,
  KSHIFTLQri,
  KSHIFTLWri,
  KSHIFTRBri,
  KSHIFTRDri,
  KSHIFTRQri,
  KSHIFTRWri,
  KTESTBrr,
  KTESTDrr,
  KTESTQrr,
  KTESTWrr,
  KUNPCKBWrr,
  KUNPCKDQrr,
  KUNPCKWDrr,
  KXNORBrr,
  KXNORDrr,
  KXNORQrr,
  KXNORWrr,
  KXORBrr,
  KXORDrr,
  KXORQrr,
  KXORWrr,
  LAHF,
  LAR16rm,
  LAR16rr,
  LAR32rm,
  LAR32rr,
  LAR64rm,
  LAR64rr,
  LCMPXCHG16,
  LCMPXCHG16B,
  LCMPXCHG32,
  LCMPXCHG64,
  LCMPXCHG8,
  LCMPXCHG8B,
  LDDQUrm,
  LDMXCSR,
  LDS16rm,
  LDS32rm,
  LDTILECFG,
  LDTILECFG_EVEX,
  LD_F0,
  LD_F1,
  LD_F32m,
  LD_F64m,
  LD_F80m,
  LD_Fp032,
  LD_Fp064,
  LD_Fp080,
  LD_Fp132,
  LD_Fp164,
  LD_Fp180,
  LD_Fp32m,
  LD_Fp32m64,
  LD_Fp32m80,
  LD_Fp64m,
  LD_Fp64m80,
  LD_Fp80m,
  LD_Frr,
  LEA16r,
  LEA32r,
  LEA64_32r,
  LEA64r,
  LEAVE,
  LEAVE64,
  LES16rm,
  LES32rm,
  LFENCE,
  LFS16rm,
  LFS32rm,
  LFS64rm,
  LGDT16m,
  LGDT32m,
  LGDT64m,
  LGS16rm,
  LGS32rm,
  LGS64rm,
  LIDT16m,
  LIDT32m,
  LIDT64m,
  LKGS16m,
  LKGS16r,
  LLDT16m,
  LLDT16r,
  LLWPCB,
  LLWPCB64,
  LMSW16m,
  LMSW16r,
  LOADIWKEY,
  LOCK_ADD16mi,
  LOCK_ADD16mi8,
  LOCK_ADD16mr,
  LOCK_ADD32mi,
  LOCK_ADD32mi8,
  LOCK_ADD32mr,
  LOCK_ADD64mi32,
  LOCK_ADD64mi8,
  LOCK_ADD64mr,
  LOCK_ADD8mi,
  LOCK_ADD8mr,
  LOCK_AND16mi,
  LOCK_AND16mi8,
  LOCK_AND16mr,
  LOCK_AND32mi,
  LOCK_AND32mi8,
  LOCK_AND32mr,
  LOCK_AND64mi32,
  LOCK_AND64mi8,
  LOCK_AND64mr,
  LOCK_AND8mi,
  LOCK_AND8mr,
  LOCK_BTC16m,
  LOCK_BTC32m,
  LOCK_BTC64m,
  LOCK_BTC_RM16rm,
  LOCK_BTC_RM32rm,
  LOCK_BTC_RM64rm,
  LOCK_BTR16m,
  LOCK_BTR32m,
  LOCK_BTR64m,
  LOCK_BTR_RM16rm,
  LOCK_BTR_RM32rm,
  LOCK_BTR_RM64rm,
  LOCK_BTS16m,
  LOCK_BTS32m,
  LOCK_BTS64m,
  LOCK_BTS_RM16rm,
  LOCK_BTS_RM32rm,
  LOCK_BTS_RM64rm,
  LOCK_DEC16m,
  LOCK_DEC32m,
  LOCK_DEC64m,
  LOCK_DEC8m,
  LOCK_INC16m,
  LOCK_INC32m,
  LOCK_INC64m,
  LOCK_INC8m,
  LOCK_OR16mi,
  LOCK_OR16mi8,
  LOCK_OR16mr,
  LOCK_OR32mi,
  LOCK_OR32mi8,
  LOCK_OR32mr,
  LOCK_OR64mi32,
  LOCK_OR64mi8,
  LOCK_OR64mr,
  LOCK_OR8mi,
  LOCK_OR8mr,
  LOCK_PREFIX,
  LOCK_SUB16mi,
  LOCK_SUB16mi8,
  LOCK_SUB16mr,
  LOCK_SUB32mi,
  LOCK_SUB32mi8,
  LOCK_SUB32mr,
  LOCK_SUB64mi32,
  LOCK_SUB64mi8,
  LOCK_SUB64mr,
  LOCK_SUB8mi,
  LOCK_SUB8mr,
  LOCK_XOR16mi,
  LOCK_XOR16mi8,
  LOCK_XOR16mr,
  LOCK_XOR32mi,
  LOCK_XOR32mi8,
  LOCK_XOR32mr,
  LOCK_XOR64mi32,
  LOCK_XOR64mi8,
  LOCK_XOR64mr,
  LOCK_XOR8mi,
  LOCK_XOR8mr,
  LODSB,
  LODSL,
  LODSQ,
  LODSW,
  LOOP,
  LOOPE,
  LOOPNE,
  LRET16,
  LRET32,
  LRET64,
  LRETI16,
  LRETI32,
  LRETI64,
  LSL16rm,
  LSL16rr,
  LSL32rm,
  LSL32rr,
  LSL64rm,
  LSL64rr,
  LSS16rm,
  LSS32rm,
  LSS64rm,
  LTRm,
  LTRr,
  LWPINS32rmi,
  LWPINS32rri,
  LWPINS64rmi,
  LWPINS64rri,
  LWPVAL32rmi,
  LWPVAL32rri,
  LWPVAL64rmi,
  LWPVAL64rri,
  LXADD16,
  LXADD32,
  LXADD64,
  LXADD8,
  LZCNT16rm,
  LZCNT16rm_EVEX,
  LZCNT16rm_NF,
  LZCNT16rr,
  LZCNT16rr_EVEX,
  LZCNT16rr_NF,
  LZCNT32rm,
  LZCNT32rm_EVEX,
  LZCNT32rm_NF,
  LZCNT32rr,
  LZCNT32rr_EVEX,
  LZCNT32rr_NF,
  LZCNT64rm,
  LZCNT64rm_EVEX,
  LZCNT64rm_NF,
  LZCNT64rr,
  LZCNT64rr_EVEX,
  LZCNT64rr_NF,
  MASKMOVDQU,
  MASKMOVDQU64,
  MASKPAIR16LOAD,
  MASKPAIR16STORE,
  MAXCPDrm,
  MAXCPDrr,
  MAXCPSrm,
  MAXCPSrr,
  MAXCSDrm,
  MAXCSDrr,
  MAXCSSrm,
  MAXCSSrr,
  MAXPDrm,
  MAXPDrr,
  MAXPSrm,
  MAXPSrr,
  MAXSDrm,
  MAXSDrm_Int,
  MAXSDrr,
  MAXSDrr_Int,
  MAXSSrm,
  MAXSSrm_Int,
  MAXSSrr,
  MAXSSrr_Int,
  MFENCE,
  MINCPDrm,
  MINCPDrr,
  MINCPSrm,
  MINCPSrr,
  MINCSDrm,
  MINCSDrr,
  MINCSSrm,
  MINCSSrr,
  MINPDrm,
  MINPDrr,
  MINPSrm,
  MINPSrr,
  MINSDrm,
  MINSDrm_Int,
  MINSDrr,
  MINSDrr_Int,
  MINSSrm,
  MINSSrm_Int,
  MINSSrr,
  MINSSrr_Int,
  MMX_CVTPD2PIrm,
  MMX_CVTPD2PIrr,
  MMX_CVTPI2PDrm,
  MMX_CVTPI2PDrr,
  MMX_CVTPI2PSrm,
  MMX_CVTPI2PSrr,
  MMX_CVTPS2PIrm,
  MMX_CVTPS2PIrr,
  MMX_CVTTPD2PIrm,
  MMX_CVTTPD2PIrr,
  MMX_CVTTPS2PIrm,
  MMX_CVTTPS2PIrr,
  MMX_EMMS,
  MMX_MASKMOVQ,
  MMX_MASKMOVQ64,
  MMX_MOVD64from64mr,
  MMX_MOVD64from64rr,
  MMX_MOVD64grr,
  MMX_MOVD64mr,
  MMX_MOVD64rm,
  MMX_MOVD64rr,
  MMX_MOVD64to64rm,
  MMX_MOVD64to64rr,
  MMX_MOVDQ2Qrr,
  MMX_MOVFR642Qrr,
  MMX_MOVNTQmr,
  MMX_MOVQ2DQrr,
  MMX_MOVQ2FR64rr,
  MMX_MOVQ64mr,
  MMX_MOVQ64rm,
  MMX_MOVQ64rr,
  MMX_MOVQ64rr_REV,
  MMX_PABSBrm,
  MMX_PABSBrr,
  MMX_PABSDrm,
  MMX_PABSDrr,
  MMX_PABSWrm,
  MMX_PABSWrr,
  MMX_PACKSSDWrm,
  MMX_PACKSSDWrr,
  MMX_PACKSSWBrm,
  MMX_PACKSSWBrr,
  MMX_PACKUSWBrm,
  MMX_PACKUSWBrr,
  MMX_PADDBrm,
  MMX_PADDBrr,
  MMX_PADDDrm,
  MMX_PADDDrr,
  MMX_PADDQrm,
  MMX_PADDQrr,
  MMX_PADDSBrm,
  MMX_PADDSBrr,
  MMX_PADDSWrm,
  MMX_PADDSWrr,
  MMX_PADDUSBrm,
  MMX_PADDUSBrr,
  MMX_PADDUSWrm,
  MMX_PADDUSWrr,
  MMX_PADDWrm,
  MMX_PADDWrr,
  MMX_PALIGNRrmi,
  MMX_PALIGNRrri,
  MMX_PANDNrm,
  MMX_PANDNrr,
  MMX_PANDrm,
  MMX_PANDrr,
  MMX_PAVGBrm,
  MMX_PAVGBrr,
  MMX_PAVGWrm,
  MMX_PAVGWrr,
  MMX_PCMPEQBrm,
  MMX_PCMPEQBrr,
  MMX_PCMPEQDrm,
  MMX_PCMPEQDrr,
  MMX_PCMPEQWrm,
  MMX_PCMPEQWrr,
  MMX_PCMPGTBrm,
  MMX_PCMPGTBrr,
  MMX_PCMPGTDrm,
  MMX_PCMPGTDrr,
  MMX_PCMPGTWrm,
  MMX_PCMPGTWrr,
  MMX_PEXTRWrr,
  MMX_PHADDDrm,
  MMX_PHADDDrr,
  MMX_PHADDSWrm,
  MMX_PHADDSWrr,
  MMX_PHADDWrm,
  MMX_PHADDWrr,
  MMX_PHSUBDrm,
  MMX_PHSUBDrr,
  MMX_PHSUBSWrm,
  MMX_PHSUBSWrr,
  MMX_PHSUBWrm,
  MMX_PHSUBWrr,
  MMX_PINSRWrm,
  MMX_PINSRWrr,
  MMX_PMADDUBSWrm,
  MMX_PMADDUBSWrr,
  MMX_PMADDWDrm,
  MMX_PMADDWDrr,
  MMX_PMAXSWrm,
  MMX_PMAXSWrr,
  MMX_PMAXUBrm,
  MMX_PMAXUBrr,
  MMX_PMINSWrm,
  MMX_PMINSWrr,
  MMX_PMINUBrm,
  MMX_PMINUBrr,
  MMX_PMOVMSKBrr,
  MMX_PMULHRSWrm,
  MMX_PMULHRSWrr,
  MMX_PMULHUWrm,
  MMX_PMULHUWrr,
  MMX_PMULHWrm,
  MMX_PMULHWrr,
  MMX_PMULLWrm,
  MMX_PMULLWrr,
  MMX_PMULUDQrm,
  MMX_PMULUDQrr,
  MMX_PORrm,
  MMX_PORrr,
  MMX_PSADBWrm,
  MMX_PSADBWrr,
  MMX_PSHUFBrm,
  MMX_PSHUFBrr,
  MMX_PSHUFWmi,
  MMX_PSHUFWri,
  MMX_PSIGNBrm,
  MMX_PSIGNBrr,
  MMX_PSIGNDrm,
  MMX_PSIGNDrr,
  MMX_PSIGNWrm,
  MMX_PSIGNWrr,
  MMX_PSLLDri,
  MMX_PSLLDrm,
  MMX_PSLLDrr,
  MMX_PSLLQri,
  MMX_PSLLQrm,
  MMX_PSLLQrr,
  MMX_PSLLWri,
  MMX_PSLLWrm,
  MMX_PSLLWrr,
  MMX_PSRADri,
  MMX_PSRADrm,
  MMX_PSRADrr,
  MMX_PSRAWri,
  MMX_PSRAWrm,
  MMX_PSRAWrr,
  MMX_PSRLDri,
  MMX_PSRLDrm,
  MMX_PSRLDrr,
  MMX_PSRLQri,
  MMX_PSRLQrm,
  MMX_PSRLQrr,
  MMX_PSRLWri,
  MMX_PSRLWrm,
  MMX_PSRLWrr,
  MMX_PSUBBrm,
  MMX_PSUBBrr,
  MMX_PSUBDrm,
  MMX_PSUBDrr,
  MMX_PSUBQrm,
  MMX_PSUBQrr,
  MMX_PSUBSBrm,
  MMX_PSUBSBrr,
  MMX_PSUBSWrm,
  MMX_PSUBSWrr,
  MMX_PSUBUSBrm,
  MMX_PSUBUSBrr,
  MMX_PSUBUSWrm,
  MMX_PSUBUSWrr,
  MMX_PSUBWrm,
  MMX_PSUBWrr,
  MMX_PUNPCKHBWrm,
  MMX_PUNPCKHBWrr,
  MMX_PUNPCKHDQrm,
  MMX_PUNPCKHDQrr,
  MMX_PUNPCKHWDrm,
  MMX_PUNPCKHWDrr,
  MMX_PUNPCKLBWrm,
  MMX_PUNPCKLBWrr,
  MMX_PUNPCKLDQrm,
  MMX_PUNPCKLDQrr,
  MMX_PUNPCKLWDrm,
  MMX_PUNPCKLWDrr,
  MMX_PXORrm,
  MMX_PXORrr,
  MONITOR32rrr,
  MONITOR64rrr,
  MONITORX32rrr,
  MONITORX64rrr,
  MONTMUL,
  MOV16ao16,
  MOV16ao32,
  MOV16ao64,
  MOV16mi,
  MOV16mr,
  MOV16ms,
  MOV16o16a,
  MOV16o32a,
  MOV16o64a,
  MOV16ri,
  MOV16ri_alt,
  MOV16rm,
  MOV16rr,
  MOV16rr_REV,
  MOV16rs,
  MOV16sm,
  MOV16sr,
  MOV32ao16,
  MOV32ao32,
  MOV32ao64,
  MOV32cr,
  MOV32dr,
  MOV32mi,
  MOV32mr,
  MOV32o16a,
  MOV32o32a,
  MOV32o64a,
  MOV32rc,
  MOV32rd,
  MOV32ri,
  MOV32ri_alt,
  MOV32rm,
  MOV32rr,
  MOV32rr_REV,
  MOV32rs,
  MOV32sr,
  MOV64ao32,
  MOV64ao64,
  MOV64cr,
  MOV64dr,
  MOV64mi32,
  MOV64mr,
  MOV64o32a,
  MOV64o64a,
  MOV64rc,
  MOV64rd,
  MOV64ri,
  MOV64ri32,
  MOV64rm,
  MOV64rr,
  MOV64rr_REV,
  MOV64rs,
  MOV64sr,
  MOV64toPQIrm,
  MOV64toPQIrr,
  MOV64toSDrr,
  MOV8ao16,
  MOV8ao32,
  MOV8ao64,
  MOV8mi,
  MOV8mr,
  MOV8mr_NOREX,
  MOV8o16a,
  MOV8o32a,
  MOV8o64a,
  MOV8ri,
  MOV8ri_alt,
  MOV8rm,
  MOV8rm_NOREX,
  MOV8rr,
  MOV8rr_NOREX,
  MOV8rr_REV,
  MOVAPDmr,
  MOVAPDrm,
  MOVAPDrr,
  MOVAPDrr_REV,
  MOVAPSmr,
  MOVAPSrm,
  MOVAPSrr,
  MOVAPSrr_REV,
  MOVBE16mr,
  MOVBE16mr_EVEX,
  MOVBE16rm,
  MOVBE16rm_EVEX,
  MOVBE16rr,
  MOVBE16rr_REV,
  MOVBE32mr,
  MOVBE32mr_EVEX,
  MOVBE32rm,
  MOVBE32rm_EVEX,
  MOVBE32rr,
  MOVBE32rr_REV,
  MOVBE64mr,
  MOVBE64mr_EVEX,
  MOVBE64rm,
  MOVBE64rm_EVEX,
  MOVBE64rr,
  MOVBE64rr_REV,
  MOVDDUPrm,
  MOVDDUPrr,
  MOVDI2PDIrm,
  MOVDI2PDIrr,
  MOVDI2SSrr,
  MOVDIR64B16,
  MOVDIR64B32,
  MOVDIR64B32_EVEX,
  MOVDIR64B64,
  MOVDIR64B64_EVEX,
  MOVDIRI32,
  MOVDIRI32_EVEX,
  MOVDIRI64,
  MOVDIRI64_EVEX,
  MOVDQAmr,
  MOVDQArm,
  MOVDQArr,
  MOVDQArr_REV,
  MOVDQUmr,
  MOVDQUrm,
  MOVDQUrr,
  MOVDQUrr_REV,
  MOVHLPSrr,
  MOVHPDmr,
  MOVHPDrm,
  MOVHPSmr,
  MOVHPSrm,
  MOVLHPSrr,
  MOVLPDmr,
  MOVLPDrm,
  MOVLPSmr,
  MOVLPSrm,
  MOVMSKPDrr,
  MOVMSKPSrr,
  MOVNTDQArm,
  MOVNTDQmr,
  MOVNTI_64mr,
  MOVNTImr,
  MOVNTPDmr,
  MOVNTPSmr,
  MOVNTSD,
  MOVNTSS,
  MOVPC32r,
  MOVPDI2DImr,
  MOVPDI2DIrr,
  MOVPQI2QImr,
  MOVPQI2QIrr,
  MOVPQIto64mr,
  MOVPQIto64rr,
  MOVQI2PQIrm,
  MOVSB,
  MOVSDmr,
  MOVSDrm,
  MOVSDrm_alt,
  MOVSDrr,
  MOVSDrr_REV,
  MOVSDto64rr,
  MOVSHDUPrm,
  MOVSHDUPrr,
  MOVSL,
  MOVSLDUPrm,
  MOVSLDUPrr,
  MOVSQ,
  MOVSS2DIrr,
  MOVSSmr,
  MOVSSrm,
  MOVSSrm_alt,
  MOVSSrr,
  MOVSSrr_REV,
  MOVSW,
  MOVSX16rm16,
  MOVSX16rm32,
  MOVSX16rm8,
  MOVSX16rr16,
  MOVSX16rr32,
  MOVSX16rr8,
  MOVSX32rm16,
  MOVSX32rm32,
  MOVSX32rm8,
  MOVSX32rm8_NOREX,
  MOVSX32rr16,
  MOVSX32rr32,
  MOVSX32rr8,
  MOVSX32rr8_NOREX,
  MOVSX64rm16,
  MOVSX64rm32,
  MOVSX64rm8,
  MOVSX64rr16,
  MOVSX64rr32,
  MOVSX64rr8,
  MOVUPDmr,
  MOVUPDrm,
  MOVUPDrr,
  MOVUPDrr_REV,
  MOVUPSmr,
  MOVUPSrm,
  MOVUPSrr,
  MOVUPSrr_REV,
  MOVZPQILo2PQIrr,
  MOVZX16rm16,
  MOVZX16rm8,
  MOVZX16rr16,
  MOVZX16rr8,
  MOVZX32rm16,
  MOVZX32rm8,
  MOVZX32rm8_NOREX,
  MOVZX32rr16,
  MOVZX32rr8,
  MOVZX32rr8_NOREX,
  MOVZX64rm16,
  MOVZX64rm8,
  MOVZX64rr16,
  MOVZX64rr8,
  MPSADBWrmi,
  MPSADBWrri,
  MUL16m,
  MUL16m_EVEX,
  MUL16m_NF,
  MUL16r,
  MUL16r_EVEX,
  MUL16r_NF,
  MUL32m,
  MUL32m_EVEX,
  MUL32m_NF,
  MUL32r,
  MUL32r_EVEX,
  MUL32r_NF,
  MUL64m,
  MUL64m_EVEX,
  MUL64m_NF,
  MUL64r,
  MUL64r_EVEX,
  MUL64r_NF,
  MUL8m,
  MUL8m_EVEX,
  MUL8m_NF,
  MUL8r,
  MUL8r_EVEX,
  MUL8r_NF,
  MULPDrm,
  MULPDrr,
  MULPSrm,
  MULPSrr,
  MULSDrm,
  MULSDrm_Int,
  MULSDrr,
  MULSDrr_Int,
  MULSSrm,
  MULSSrm_Int,
  MULSSrr,
  MULSSrr_Int,
  MULX32Hrm,
  MULX32Hrr,
  MULX32rm,
  MULX32rm_EVEX,
  MULX32rr,
  MULX32rr_EVEX,
  MULX64Hrm,
  MULX64Hrr,
  MULX64rm,
  MULX64rm_EVEX,
  MULX64rr,
  MULX64rr_EVEX,
  MUL_F32m,
  MUL_F64m,
  MUL_FI16m,
  MUL_FI32m,
  MUL_FPrST0,
  MUL_FST0r,
  MUL_Fp32,
  MUL_Fp32m,
  MUL_Fp64,
  MUL_Fp64m,
  MUL_Fp64m32,
  MUL_Fp80,
  MUL_Fp80m32,
  MUL_Fp80m64,
  MUL_FpI16m32,
  MUL_FpI16m64,
  MUL_FpI16m80,
  MUL_FpI32m32,
  MUL_FpI32m64,
  MUL_FpI32m80,
  MUL_FrST0,
  MWAITXrrr,
  MWAITrr,
  NEG16m,
  NEG16m_EVEX,
  NEG16m_ND,
  NEG16m_NF,
  NEG16m_NF_ND,
  NEG16r,
  NEG16r_EVEX,
  NEG16r_ND,
  NEG16r_NF,
  NEG16r_NF_ND,
  NEG32m,
  NEG32m_EVEX,
  NEG32m_ND,
  NEG32m_NF,
  NEG32m_NF_ND,
  NEG32r,
  NEG32r_EVEX,
  NEG32r_ND,
  NEG32r_NF,
  NEG32r_NF_ND,
  NEG64m,
  NEG64m_EVEX,
  NEG64m_ND,
  NEG64m_NF,
  NEG64m_NF_ND,
  NEG64r,
  NEG64r_EVEX,
  NEG64r_ND,
  NEG64r_NF,
  NEG64r_NF_ND,
  NEG8m,
  NEG8m_EVEX,
  NEG8m_ND,
  NEG8m_NF,
  NEG8m_NF_ND,
  NEG8r,
  NEG8r_EVEX,
  NEG8r_ND,
  NEG8r_NF,
  NEG8r_NF_ND,
  NOOP,
  NOOPL,
  NOOPLr,
  NOOPQ,
  NOOPQr,
  NOOPW,
  NOOPWr,
  NOT16m,
  NOT16m_EVEX,
  NOT16m_ND,
  NOT16r,
  NOT16r_EVEX,
  NOT16r_ND,
  NOT32m,
  NOT32m_EVEX,
  NOT32m_ND,
  NOT32r,
  NOT32r_EVEX,
  NOT32r_ND,
  NOT64m,
  NOT64m_EVEX,
  NOT64m_ND,
  NOT64r,
  NOT64r_EVEX,
  NOT64r_ND,
  NOT8m,
  NOT8m_EVEX,
  NOT8m_ND,
  NOT8r,
  NOT8r_EVEX,
  NOT8r_ND,
  OR16i16,
  OR16mi,
  OR16mi8,
  OR16mi8_EVEX,
  OR16mi8_ND,
  OR16mi8_NF,
  OR16mi8_NF_ND,
  OR16mi_EVEX,
  OR16mi_ND,
  OR16mi_NF,
  OR16mi_NF_ND,
  OR16mr,
  OR16mr_EVEX,
  OR16mr_ND,
  OR16mr_NF,
  OR16mr_NF_ND,
  OR16ri,
  OR16ri8,
  OR16ri8_EVEX,
  OR16ri8_ND,
  OR16ri8_NF,
  OR16ri8_NF_ND,
  OR16ri_EVEX,
  OR16ri_ND,
  OR16ri_NF,
  OR16ri_NF_ND,
  OR16rm,
  OR16rm_EVEX,
  OR16rm_ND,
  OR16rm_NF,
  OR16rm_NF_ND,
  OR16rr,
  OR16rr_EVEX,
  OR16rr_EVEX_REV,
  OR16rr_ND,
  OR16rr_ND_REV,
  OR16rr_NF,
  OR16rr_NF_ND,
  OR16rr_NF_ND_REV,
  OR16rr_NF_REV,
  OR16rr_REV,
  OR32i32,
  OR32mi,
  OR32mi8,
  OR32mi8Locked,
  OR32mi8_EVEX,
  OR32mi8_ND,
  OR32mi8_NF,
  OR32mi8_NF_ND,
  OR32mi_EVEX,
  OR32mi_ND,
  OR32mi_NF,
  OR32mi_NF_ND,
  OR32mr,
  OR32mr_EVEX,
  OR32mr_ND,
  OR32mr_NF,
  OR32mr_NF_ND,
  OR32ri,
  OR32ri8,
  OR32ri8_EVEX,
  OR32ri8_ND,
  OR32ri8_NF,
  OR32ri8_NF_ND,
  OR32ri_EVEX,
  OR32ri_ND,
  OR32ri_NF,
  OR32ri_NF_ND,
  OR32rm,
  OR32rm_EVEX,
  OR32rm_ND,
  OR32rm_NF,
  OR32rm_NF_ND,
  OR32rr,
  OR32rr_EVEX,
  OR32rr_EVEX_REV,
  OR32rr_ND,
  OR32rr_ND_REV,
  OR32rr_NF,
  OR32rr_NF_ND,
  OR32rr_NF_ND_REV,
  OR32rr_NF_REV,
  OR32rr_REV,
  OR64i32,
  OR64mi32,
  OR64mi32_EVEX,
  OR64mi32_ND,
  OR64mi32_NF,
  OR64mi32_NF_ND,
  OR64mi8,
  OR64mi8_EVEX,
  OR64mi8_ND,
  OR64mi8_NF,
  OR64mi8_NF_ND,
  OR64mr,
  OR64mr_EVEX,
  OR64mr_ND,
  OR64mr_NF,
  OR64mr_NF_ND,
  OR64ri32,
  OR64ri32_EVEX,
  OR64ri32_ND,
  OR64ri32_NF,
  OR64ri32_NF_ND,
  OR64ri8,
  OR64ri8_EVEX,
  OR64ri8_ND,
  OR64ri8_NF,
  OR64ri8_NF_ND,
  OR64rm,
  OR64rm_EVEX,
  OR64rm_ND,
  OR64rm_NF,
  OR64rm_NF_ND,
  OR64rr,
  OR64rr_EVEX,
  OR64rr_EVEX_REV,
  OR64rr_ND,
  OR64rr_ND_REV,
  OR64rr_NF,
  OR64rr_NF_ND,
  OR64rr_NF_ND_REV,
  OR64rr_NF_REV,
  OR64rr_REV,
  OR8i8,
  OR8mi,
  OR8mi8,
  OR8mi_EVEX,
  OR8mi_ND,
  OR8mi_NF,
  OR8mi_NF_ND,
  OR8mr,
  OR8mr_EVEX,
  OR8mr_ND,
  OR8mr_NF,
  OR8mr_NF_ND,
  OR8ri,
  OR8ri8,
  OR8ri_EVEX,
  OR8ri_ND,
  OR8ri_NF,
  OR8ri_NF_ND,
  OR8rm,
  OR8rm_EVEX,
  OR8rm_ND,
  OR8rm_NF,
  OR8rm_NF_ND,
  OR8rr,
  OR8rr_EVEX,
  OR8rr_EVEX_REV,
  OR8rr_ND,
  OR8rr_ND_REV,
  OR8rr_NF,
  OR8rr_NF_ND,
  OR8rr_NF_ND_REV,
  OR8rr_NF_REV,
  OR8rr_REV,
  ORPDrm,
  ORPDrr,
  ORPSrm,
  ORPSrr,
  OUT16ir,
  OUT16rr,
  OUT32ir,
  OUT32rr,
  OUT8ir,
  OUT8rr,
  OUTSB,
  OUTSL,
  OUTSW,
  PABSBrm,
  PABSBrr,
  PABSDrm,
  PABSDrr,
  PABSWrm,
  PABSWrr,
  PACKSSDWrm,
  PACKSSDWrr,
  PACKSSWBrm,
  PACKSSWBrr,
  PACKUSDWrm,
  PACKUSDWrr,
  PACKUSWBrm,
  PACKUSWBrr,
  PADDBrm,
  PADDBrr,
  PADDDrm,
  PADDDrr,
  PADDQrm,
  PADDQrr,
  PADDSBrm,
  PADDSBrr,
  PADDSWrm,
  PADDSWrr,
  PADDUSBrm,
  PADDUSBrr,
  PADDUSWrm,
  PADDUSWrr,
  PADDWrm,
  PADDWrr,
  PALIGNRrmi,
  PALIGNRrri,
  PANDNrm,
  PANDNrr,
  PANDrm,
  PANDrr,
  PAUSE,
  PAVGBrm,
  PAVGBrr,
  PAVGUSBrm,
  PAVGUSBrr,
  PAVGWrm,
  PAVGWrr,
  PBLENDVBrm0,
  PBLENDVBrr0,
  PBLENDWrmi,
  PBLENDWrri,
  PBNDKB,
  PCLMULQDQrmi,
  PCLMULQDQrri,
  PCMPEQBrm,
  PCMPEQBrr,
  PCMPEQDrm,
  PCMPEQDrr,
  PCMPEQQrm,
  PCMPEQQrr,
  PCMPEQWrm,
  PCMPEQWrr,
  PCMPESTRIrmi,
  PCMPESTRIrri,
  PCMPESTRMrmi,
  PCMPESTRMrri,
  PCMPGTBrm,
  PCMPGTBrr,
  PCMPGTDrm,
  PCMPGTDrr,
  PCMPGTQrm,
  PCMPGTQrr,
  PCMPGTWrm,
  PCMPGTWrr,
  PCMPISTRIrmi,
  PCMPISTRIrri,
  PCMPISTRMrmi,
  PCMPISTRMrri,
  PCONFIG,
  PDEP32rm,
  PDEP32rm_EVEX,
  PDEP32rr,
  PDEP32rr_EVEX,
  PDEP64rm,
  PDEP64rm_EVEX,
  PDEP64rr,
  PDEP64rr_EVEX,
  PEXT32rm,
  PEXT32rm_EVEX,
  PEXT32rr,
  PEXT32rr_EVEX,
  PEXT64rm,
  PEXT64rm_EVEX,
  PEXT64rr,
  PEXT64rr_EVEX,
  PEXTRBmr,
  PEXTRBrr,
  PEXTRDmr,
  PEXTRDrr,
  PEXTRQmr,
  PEXTRQrr,
  PEXTRWmr,
  PEXTRWrr,
  PEXTRWrr_REV,
  PF2IDrm,
  PF2IDrr,
  PF2IWrm,
  PF2IWrr,
  PFACCrm,
  PFACCrr,
  PFADDrm,
  PFADDrr,
  PFCMPEQrm,
  PFCMPEQrr,
  PFCMPGErm,
  PFCMPGErr,
  PFCMPGTrm,
  PFCMPGTrr,
  PFMAXrm,
  PFMAXrr,
  PFMINrm,
  PFMINrr,
  PFMULrm,
  PFMULrr,
  PFNACCrm,
  PFNACCrr,
  PFPNACCrm,
  PFPNACCrr,
  PFRCPIT1rm,
  PFRCPIT1rr,
  PFRCPIT2rm,
  PFRCPIT2rr,
  PFRCPrm,
  PFRCPrr,
  PFRSQIT1rm,
  PFRSQIT1rr,
  PFRSQRTrm,
  PFRSQRTrr,
  PFSUBRrm,
  PFSUBRrr,
  PFSUBrm,
  PFSUBrr,
  PHADDDrm,
  PHADDDrr,
  PHADDSWrm,
  PHADDSWrr,
  PHADDWrm,
  PHADDWrr,
  PHMINPOSUWrm,
  PHMINPOSUWrr,
  PHSUBDrm,
  PHSUBDrr,
  PHSUBSWrm,
  PHSUBSWrr,
  PHSUBWrm,
  PHSUBWrr,
  PI2FDrm,
  PI2FDrr,
  PI2FWrm,
  PI2FWrr,
  PINSRBrm,
  PINSRBrr,
  PINSRDrm,
  PINSRDrr,
  PINSRQrm,
  PINSRQrr,
  PINSRWrm,
  PINSRWrr,
  PMADDUBSWrm,
  PMADDUBSWrr,
  PMADDWDrm,
  PMADDWDrr,
  PMAXSBrm,
  PMAXSBrr,
  PMAXSDrm,
  PMAXSDrr,
  PMAXSWrm,
  PMAXSWrr,
  PMAXUBrm,
  PMAXUBrr,
  PMAXUDrm,
  PMAXUDrr,
  PMAXUWrm,
  PMAXUWrr,
  PMINSBrm,
  PMINSBrr,
  PMINSDrm,
  PMINSDrr,
  PMINSWrm,
  PMINSWrr,
  PMINUBrm,
  PMINUBrr,
  PMINUDrm,
  PMINUDrr,
  PMINUWrm,
  PMINUWrr,
  PMOVMSKBrr,
  PMOVSXBDrm,
  PMOVSXBDrr,
  PMOVSXBQrm,
  PMOVSXBQrr,
  PMOVSXBWrm,
  PMOVSXBWrr,
  PMOVSXDQrm,
  PMOVSXDQrr,
  PMOVSXWDrm,
  PMOVSXWDrr,
  PMOVSXWQrm,
  PMOVSXWQrr,
  PMOVZXBDrm,
  PMOVZXBDrr,
  PMOVZXBQrm,
  PMOVZXBQrr,
  PMOVZXBWrm,
  PMOVZXBWrr,
  PMOVZXDQrm,
  PMOVZXDQrr,
  PMOVZXWDrm,
  PMOVZXWDrr,
  PMOVZXWQrm,
  PMOVZXWQrr,
  PMULDQrm,
  PMULDQrr,
  PMULHRSWrm,
  PMULHRSWrr,
  PMULHRWrm,
  PMULHRWrr,
  PMULHUWrm,
  PMULHUWrr,
  PMULHWrm,
  PMULHWrr,
  PMULLDrm,
  PMULLDrr,
  PMULLWrm,
  PMULLWrr,
  PMULUDQrm,
  PMULUDQrr,
  POP16r,
  POP16rmm,
  POP16rmr,
  POP2,
  POP2P,
  POP32r,
  POP32rmm,
  POP32rmr,
  POP64r,
  POP64rmm,
  POP64rmr,
  POPA16,
  POPA32,
  POPCNT16rm,
  POPCNT16rm_EVEX,
  POPCNT16rm_NF,
  POPCNT16rr,
  POPCNT16rr_EVEX,
  POPCNT16rr_NF,
  POPCNT32rm,
  POPCNT32rm_EVEX,
  POPCNT32rm_NF,
  POPCNT32rr,
  POPCNT32rr_EVEX,
  POPCNT32rr_NF,
  POPCNT64rm,
  POPCNT64rm_EVEX,
  POPCNT64rm_NF,
  POPCNT64rr,
  POPCNT64rr_EVEX,
  POPCNT64rr_NF,
  POPDS16,
  POPDS32,
  POPES16,
  POPES32,
  POPF16,
  POPF32,
  POPF64,
  POPFS16,
  POPFS32,
  POPFS64,
  POPGS16,
  POPGS32,
  POPGS64,
  POPP64r,
  POPSS16,
  POPSS32,
  PORrm,
  PORrr,
  PREFETCH,
  PREFETCHIT0,
  PREFETCHIT1,
  PREFETCHNTA,
  PREFETCHT0,
  PREFETCHT1,
  PREFETCHT2,
  PREFETCHW,
  PREFETCHWT1,
  PROBED_ALLOCA_32,
  PROBED_ALLOCA_64,
  PSADBWrm,
  PSADBWrr,
  PSHUFBrm,
  PSHUFBrr,
  PSHUFDmi,
  PSHUFDri,
  PSHUFHWmi,
  PSHUFHWri,
  PSHUFLWmi,
  PSHUFLWri,
  PSIGNBrm,
  PSIGNBrr,
  PSIGNDrm,
  PSIGNDrr,
  PSIGNWrm,
  PSIGNWrr,
  PSLLDQri,
  PSLLDri,
  PSLLDrm,
  PSLLDrr,
  PSLLQri,
  PSLLQrm,
  PSLLQrr,
  PSLLWri,
  PSLLWrm,
  PSLLWrr,
  PSMASH,
  PSRADri,
  PSRADrm,
  PSRADrr,
  PSRAWri,
  PSRAWrm,
  PSRAWrr,
  PSRLDQri,
  PSRLDri,
  PSRLDrm,
  PSRLDrr,
  PSRLQri,
  PSRLQrm,
  PSRLQrr,
  PSRLWri,
  PSRLWrm,
  PSRLWrr,
  PSUBBrm,
  PSUBBrr,
  PSUBDrm,
  PSUBDrr,
  PSUBQrm,
  PSUBQrr,
  PSUBSBrm,
  PSUBSBrr,
  PSUBSWrm,
  PSUBSWrr,
  PSUBUSBrm,
  PSUBUSBrr,
  PSUBUSWrm,
  PSUBUSWrr,
  PSUBWrm,
  PSUBWrr,
  PSWAPDrm,
  PSWAPDrr,
  PTCMMIMFP16PS,
  PTCMMIMFP16PSV,
  PTCMMRLFP16PS,
  PTCMMRLFP16PSV,
  PTDPBF16PS,
  PTDPBSSD,
  PTDPBSUD,
  PTDPBUSD,
  PTDPBUUD,
  PTDPFP16PS,
  PTESTrm,
  PTESTrr,
  PTILELOADD,
  PTILELOADDT1,
  PTILESTORED,
  PTILEZERO,
  PTWRITE64m,
  PTWRITE64r,
  PTWRITEm,
  PTWRITEr,
  PUNPCKHBWrm,
  PUNPCKHBWrr,
  PUNPCKHDQrm,
  PUNPCKHDQrr,
  PUNPCKHQDQrm,
  PUNPCKHQDQrr,
  PUNPCKHWDrm,
  PUNPCKHWDrr,
  PUNPCKLBWrm,
  PUNPCKLBWrr,
  PUNPCKLDQrm,
  PUNPCKLDQrr,
  PUNPCKLQDQrm,
  PUNPCKLQDQrr,
  PUNPCKLWDrm,
  PUNPCKLWDrr,
  PUSH16i,
  PUSH16i8,
  PUSH16r,
  PUSH16rmm,
  PUSH16rmr,
  PUSH2,
  PUSH2P,
  PUSH32i,
  PUSH32i8,
  PUSH32r,
  PUSH32rmm,
  PUSH32rmr,
  PUSH64i32,
  PUSH64i8,
  PUSH64r,
  PUSH64rmm,
  PUSH64rmr,
  PUSHA16,
  PUSHA32,
  PUSHCS16,
  PUSHCS32,
  PUSHDS16,
  PUSHDS32,
  PUSHES16,
  PUSHES32,
  PUSHF16,
  PUSHF32,
  PUSHF64,
  PUSHFS16,
  PUSHFS32,
  PUSHFS64,
  PUSHGS16,
  PUSHGS32,
  PUSHGS64,
  PUSHP64r,
  PUSHSS16,
  PUSHSS32,
  PVALIDATE32,
  PVALIDATE64,
  PXORrm,
  PXORrr,
  RCL16m1,
  RCL16m1_EVEX,
  RCL16m1_ND,
  RCL16mCL,
  RCL16mCL_EVEX,
  RCL16mCL_ND,
  RCL16mi,
  RCL16mi_EVEX,
  RCL16mi_ND,
  RCL16r1,
  RCL16r1_EVEX,
  RCL16r1_ND,
  RCL16rCL,
  RCL16rCL_EVEX,
  RCL16rCL_ND,
  RCL16ri,
  RCL16ri_EVEX,
  RCL16ri_ND,
  RCL32m1,
  RCL32m1_EVEX,
  RCL32m1_ND,
  RCL32mCL,
  RCL32mCL_EVEX,
  RCL32mCL_ND,
  RCL32mi,
  RCL32mi_EVEX,
  RCL32mi_ND,
  RCL32r1,
  RCL32r1_EVEX,
  RCL32r1_ND,
  RCL32rCL,
  RCL32rCL_EVEX,
  RCL32rCL_ND,
  RCL32ri,
  RCL32ri_EVEX,
  RCL32ri_ND,
  RCL64m1,
  RCL64m1_EVEX,
  RCL64m1_ND,
  RCL64mCL,
  RCL64mCL_EVEX,
  RCL64mCL_ND,
  RCL64mi,
  RCL64mi_EVEX,
  RCL64mi_ND,
  RCL64r1,
  RCL64r1_EVEX,
  RCL64r1_ND,
  RCL64rCL,
  RCL64rCL_EVEX,
  RCL64rCL_ND,
  RCL64ri,
  RCL64ri_EVEX,
  RCL64ri_ND,
  RCL8m1,
  RCL8m1_EVEX,
  RCL8m1_ND,
  RCL8mCL,
  RCL8mCL_EVEX,
  RCL8mCL_ND,
  RCL8mi,
  RCL8mi_EVEX,
  RCL8mi_ND,
  RCL8r1,
  RCL8r1_EVEX,
  RCL8r1_ND,
  RCL8rCL,
  RCL8rCL_EVEX,
  RCL8rCL_ND,
  RCL8ri,
  RCL8ri_EVEX,
  RCL8ri_ND,
  RCPPSm,
  RCPPSr,
  RCPSSm,
  RCPSSm_Int,
  RCPSSr,
  RCPSSr_Int,
  RCR16m1,
  RCR16m1_EVEX,
  RCR16m1_ND,
  RCR16mCL,
  RCR16mCL_EVEX,
  RCR16mCL_ND,
  RCR16mi,
  RCR16mi_EVEX,
  RCR16mi_ND,
  RCR16r1,
  RCR16r1_EVEX,
  RCR16r1_ND,
  RCR16rCL,
  RCR16rCL_EVEX,
  RCR16rCL_ND,
  RCR16ri,
  RCR16ri_EVEX,
  RCR16ri_ND,
  RCR32m1,
  RCR32m1_EVEX,
  RCR32m1_ND,
  RCR32mCL,
  RCR32mCL_EVEX,
  RCR32mCL_ND,
  RCR32mi,
  RCR32mi_EVEX,
  RCR32mi_ND,
  RCR32r1,
  RCR32r1_EVEX,
  RCR32r1_ND,
  RCR32rCL,
  RCR32rCL_EVEX,
  RCR32rCL_ND,
  RCR32ri,
  RCR32ri_EVEX,
  RCR32ri_ND,
  RCR64m1,
  RCR64m1_EVEX,
  RCR64m1_ND,
  RCR64mCL,
  RCR64mCL_EVEX,
  RCR64mCL_ND,
  RCR64mi,
  RCR64mi_EVEX,
  RCR64mi_ND,
  RCR64r1,
  RCR64r1_EVEX,
  RCR64r1_ND,
  RCR64rCL,
  RCR64rCL_EVEX,
  RCR64rCL_ND,
  RCR64ri,
  RCR64ri_EVEX,
  RCR64ri_ND,
  RCR8m1,
  RCR8m1_EVEX,
  RCR8m1_ND,
  RCR8mCL,
  RCR8mCL_EVEX,
  RCR8mCL_ND,
  RCR8mi,
  RCR8mi_EVEX,
  RCR8mi_ND,
  RCR8r1,
  RCR8r1_EVEX,
  RCR8r1_ND,
  RCR8rCL,
  RCR8rCL_EVEX,
  RCR8rCL_ND,
  RCR8ri,
  RCR8ri_EVEX,
  RCR8ri_ND,
  RDFSBASE,
  RDFSBASE64,
  RDGSBASE,
  RDGSBASE64,
  RDMSR,
  RDMSRLIST,
  RDPID32,
  RDPID64,
  RDPKRUr,
  RDPMC,
  RDPRU,
  RDRAND16r,
  RDRAND32r,
  RDRAND64r,
  RDSEED16r,
  RDSEED32r,
  RDSEED64r,
  RDSSPD,
  RDSSPQ,
  RDTSC,
  RDTSCP,
  REPNE_PREFIX,
  REP_MOVSB_32,
  REP_MOVSB_64,
  REP_MOVSD_32,
  REP_MOVSD_64,
  REP_MOVSQ_32,
  REP_MOVSQ_64,
  REP_MOVSW_32,
  REP_MOVSW_64,
  REP_PREFIX,
  REP_STOSB_32,
  REP_STOSB_64,
  REP_STOSD_32,
  REP_STOSD_64,
  REP_STOSQ_32,
  REP_STOSQ_64,
  REP_STOSW_32,
  REP_STOSW_64,
  RET,
  RET16,
  RET32,
  RET64,
  RETI16,
  RETI32,
  RETI64,
  REX64_PREFIX,
  RMPADJUST,
  RMPQUERY,
  RMPUPDATE,
  ROL16m1,
  ROL16m1_EVEX,
  ROL16m1_ND,
  ROL16m1_NF,
  ROL16m1_NF_ND,
  ROL16mCL,
  ROL16mCL_EVEX,
  ROL16mCL_ND,
  ROL16mCL_NF,
  ROL16mCL_NF_ND,
  ROL16mi,
  ROL16mi_EVEX,
  ROL16mi_ND,
  ROL16mi_NF,
  ROL16mi_NF_ND,
  ROL16r1,
  ROL16r1_EVEX,
  ROL16r1_ND,
  ROL16r1_NF,
  ROL16r1_NF_ND,
  ROL16rCL,
  ROL16rCL_EVEX,
  ROL16rCL_ND,
  ROL16rCL_NF,
  ROL16rCL_NF_ND,
  ROL16ri,
  ROL16ri_EVEX,
  ROL16ri_ND,
  ROL16ri_NF,
  ROL16ri_NF_ND,
  ROL32m1,
  ROL32m1_EVEX,
  ROL32m1_ND,
  ROL32m1_NF,
  ROL32m1_NF_ND,
  ROL32mCL,
  ROL32mCL_EVEX,
  ROL32mCL_ND,
  ROL32mCL_NF,
  ROL32mCL_NF_ND,
  ROL32mi,
  ROL32mi_EVEX,
  ROL32mi_ND,
  ROL32mi_NF,
  ROL32mi_NF_ND,
  ROL32r1,
  ROL32r1_EVEX,
  ROL32r1_ND,
  ROL32r1_NF,
  ROL32r1_NF_ND,
  ROL32rCL,
  ROL32rCL_EVEX,
  ROL32rCL_ND,
  ROL32rCL_NF,
  ROL32rCL_NF_ND,
  ROL32ri,
  ROL32ri_EVEX,
  ROL32ri_ND,
  ROL32ri_NF,
  ROL32ri_NF_ND,
  ROL64m1,
  ROL64m1_EVEX,
  ROL64m1_ND,
  ROL64m1_NF,
  ROL64m1_NF_ND,
  ROL64mCL,
  ROL64mCL_EVEX,
  ROL64mCL_ND,
  ROL64mCL_NF,
  ROL64mCL_NF_ND,
  ROL64mi,
  ROL64mi_EVEX,
  ROL64mi_ND,
  ROL64mi_NF,
  ROL64mi_NF_ND,
  ROL64r1,
  ROL64r1_EVEX,
  ROL64r1_ND,
  ROL64r1_NF,
  ROL64r1_NF_ND,
  ROL64rCL,
  ROL64rCL_EVEX,
  ROL64rCL_ND,
  ROL64rCL_NF,
  ROL64rCL_NF_ND,
  ROL64ri,
  ROL64ri_EVEX,
  ROL64ri_ND,
  ROL64ri_NF,
  ROL64ri_NF_ND,
  ROL8m1,
  ROL8m1_EVEX,
  ROL8m1_ND,
  ROL8m1_NF,
  ROL8m1_NF_ND,
  ROL8mCL,
  ROL8mCL_EVEX,
  ROL8mCL_ND,
  ROL8mCL_NF,
  ROL8mCL_NF_ND,
  ROL8mi,
  ROL8mi_EVEX,
  ROL8mi_ND,
  ROL8mi_NF,
  ROL8mi_NF_ND,
  ROL8r1,
  ROL8r1_EVEX,
  ROL8r1_ND,
  ROL8r1_NF,
  ROL8r1_NF_ND,
  ROL8rCL,
  ROL8rCL_EVEX,
  ROL8rCL_ND,
  ROL8rCL_NF,
  ROL8rCL_NF_ND,
  ROL8ri,
  ROL8ri_EVEX,
  ROL8ri_ND,
  ROL8ri_NF,
  ROL8ri_NF_ND,
  ROR16m1,
  ROR16m1_EVEX,
  ROR16m1_ND,
  ROR16m1_NF,
  ROR16m1_NF_ND,
  ROR16mCL,
  ROR16mCL_EVEX,
  ROR16mCL_ND,
  ROR16mCL_NF,
  ROR16mCL_NF_ND,
  ROR16mi,
  ROR16mi_EVEX,
  ROR16mi_ND,
  ROR16mi_NF,
  ROR16mi_NF_ND,
  ROR16r1,
  ROR16r1_EVEX,
  ROR16r1_ND,
  ROR16r1_NF,
  ROR16r1_NF_ND,
  ROR16rCL,
  ROR16rCL_EVEX,
  ROR16rCL_ND,
  ROR16rCL_NF,
  ROR16rCL_NF_ND,
  ROR16ri,
  ROR16ri_EVEX,
  ROR16ri_ND,
  ROR16ri_NF,
  ROR16ri_NF_ND,
  ROR32m1,
  ROR32m1_EVEX,
  ROR32m1_ND,
  ROR32m1_NF,
  ROR32m1_NF_ND,
  ROR32mCL,
  ROR32mCL_EVEX,
  ROR32mCL_ND,
  ROR32mCL_NF,
  ROR32mCL_NF_ND,
  ROR32mi,
  ROR32mi_EVEX,
  ROR32mi_ND,
  ROR32mi_NF,
  ROR32mi_NF_ND,
  ROR32r1,
  ROR32r1_EVEX,
  ROR32r1_ND,
  ROR32r1_NF,
  ROR32r1_NF_ND,
  ROR32rCL,
  ROR32rCL_EVEX,
  ROR32rCL_ND,
  ROR32rCL_NF,
  ROR32rCL_NF_ND,
  ROR32ri,
  ROR32ri_EVEX,
  ROR32ri_ND,
  ROR32ri_NF,
  ROR32ri_NF_ND,
  ROR64m1,
  ROR64m1_EVEX,
  ROR64m1_ND,
  ROR64m1_NF,
  ROR64m1_NF_ND,
  ROR64mCL,
  ROR64mCL_EVEX,
  ROR64mCL_ND,
  ROR64mCL_NF,
  ROR64mCL_NF_ND,
  ROR64mi,
  ROR64mi_EVEX,
  ROR64mi_ND,
  ROR64mi_NF,
  ROR64mi_NF_ND,
  ROR64r1,
  ROR64r1_EVEX,
  ROR64r1_ND,
  ROR64r1_NF,
  ROR64r1_NF_ND,
  ROR64rCL,
  ROR64rCL_EVEX,
  ROR64rCL_ND,
  ROR64rCL_NF,
  ROR64rCL_NF_ND,
  ROR64ri,
  ROR64ri_EVEX,
  ROR64ri_ND,
  ROR64ri_NF,
  ROR64ri_NF_ND,
  ROR8m1,
  ROR8m1_EVEX,
  ROR8m1_ND,
  ROR8m1_NF,
  ROR8m1_NF_ND,
  ROR8mCL,
  ROR8mCL_EVEX,
  ROR8mCL_ND,
  ROR8mCL_NF,
  ROR8mCL_NF_ND,
  ROR8mi,
  ROR8mi_EVEX,
  ROR8mi_ND,
  ROR8mi_NF,
  ROR8mi_NF_ND,
  ROR8r1,
  ROR8r1_EVEX,
  ROR8r1_ND,
  ROR8r1_NF,
  ROR8r1_NF_ND,
  ROR8rCL,
  ROR8rCL_EVEX,
  ROR8rCL_ND,
  ROR8rCL_NF,
  ROR8rCL_NF_ND,
  ROR8ri,
  ROR8ri_EVEX,
  ROR8ri_ND,
  ROR8ri_NF,
  ROR8ri_NF_ND,
  RORX32mi,
  RORX32mi_EVEX,
  RORX32ri,
  RORX32ri_EVEX,
  RORX64mi,
  RORX64mi_EVEX,
  RORX64ri,
  RORX64ri_EVEX,
  ROUNDPDmi,
  ROUNDPDri,
  ROUNDPSmi,
  ROUNDPSri,
  ROUNDSDmi,
  ROUNDSDmi_Int,
  ROUNDSDri,
  ROUNDSDri_Int,
  ROUNDSSmi,
  ROUNDSSmi_Int,
  ROUNDSSri,
  ROUNDSSri_Int,
  RSM,
  RSQRTPSm,
  RSQRTPSr,
  RSQRTSSm,
  RSQRTSSm_Int,
  RSQRTSSr,
  RSQRTSSr_Int,
  RSTORSSP,
  SAHF,
  SALC,
  SAR16m1,
  SAR16m1_EVEX,
  SAR16m1_ND,
  SAR16m1_NF,
  SAR16m1_NF_ND,
  SAR16mCL,
  SAR16mCL_EVEX,
  SAR16mCL_ND,
  SAR16mCL_NF,
  SAR16mCL_NF_ND,
  SAR16mi,
  SAR16mi_EVEX,
  SAR16mi_ND,
  SAR16mi_NF,
  SAR16mi_NF_ND,
  SAR16r1,
  SAR16r1_EVEX,
  SAR16r1_ND,
  SAR16r1_NF,
  SAR16r1_NF_ND,
  SAR16rCL,
  SAR16rCL_EVEX,
  SAR16rCL_ND,
  SAR16rCL_NF,
  SAR16rCL_NF_ND,
  SAR16ri,
  SAR16ri_EVEX,
  SAR16ri_ND,
  SAR16ri_NF,
  SAR16ri_NF_ND,
  SAR32m1,
  SAR32m1_EVEX,
  SAR32m1_ND,
  SAR32m1_NF,
  SAR32m1_NF_ND,
  SAR32mCL,
  SAR32mCL_EVEX,
  SAR32mCL_ND,
  SAR32mCL_NF,
  SAR32mCL_NF_ND,
  SAR32mi,
  SAR32mi_EVEX,
  SAR32mi_ND,
  SAR32mi_NF,
  SAR32mi_NF_ND,
  SAR32r1,
  SAR32r1_EVEX,
  SAR32r1_ND,
  SAR32r1_NF,
  SAR32r1_NF_ND,
  SAR32rCL,
  SAR32rCL_EVEX,
  SAR32rCL_ND,
  SAR32rCL_NF,
  SAR32rCL_NF_ND,
  SAR32ri,
  SAR32ri_EVEX,
  SAR32ri_ND,
  SAR32ri_NF,
  SAR32ri_NF_ND,
  SAR64m1,
  SAR64m1_EVEX,
  SAR64m1_ND,
  SAR64m1_NF,
  SAR64m1_NF_ND,
  SAR64mCL,
  SAR64mCL_EVEX,
  SAR64mCL_ND,
  SAR64mCL_NF,
  SAR64mCL_NF_ND,
  SAR64mi,
  SAR64mi_EVEX,
  SAR64mi_ND,
  SAR64mi_NF,
  SAR64mi_NF_ND,
  SAR64r1,
  SAR64r1_EVEX,
  SAR64r1_ND,
  SAR64r1_NF,
  SAR64r1_NF_ND,
  SAR64rCL,
  SAR64rCL_EVEX,
  SAR64rCL_ND,
  SAR64rCL_NF,
  SAR64rCL_NF_ND,
  SAR64ri,
  SAR64ri_EVEX,
  SAR64ri_ND,
  SAR64ri_NF,
  SAR64ri_NF_ND,
  SAR8m1,
  SAR8m1_EVEX,
  SAR8m1_ND,
  SAR8m1_NF,
  SAR8m1_NF_ND,
  SAR8mCL,
  SAR8mCL_EVEX,
  SAR8mCL_ND,
  SAR8mCL_NF,
  SAR8mCL_NF_ND,
  SAR8mi,
  SAR8mi_EVEX,
  SAR8mi_ND,
  SAR8mi_NF,
  SAR8mi_NF_ND,
  SAR8r1,
  SAR8r1_EVEX,
  SAR8r1_ND,
  SAR8r1_NF,
  SAR8r1_NF_ND,
  SAR8rCL,
  SAR8rCL_EVEX,
  SAR8rCL_ND,
  SAR8rCL_NF,
  SAR8rCL_NF_ND,
  SAR8ri,
  SAR8ri_EVEX,
  SAR8ri_ND,
  SAR8ri_NF,
  SAR8ri_NF_ND,
  SARX32rm,
  SARX32rm_EVEX,
  SARX32rr,
  SARX32rr_EVEX,
  SARX64rm,
  SARX64rm_EVEX,
  SARX64rr,
  SARX64rr_EVEX,
  SAVEPREVSSP,
  SBB16i16,
  SBB16mi,
  SBB16mi8,
  SBB16mi8_EVEX,
  SBB16mi8_ND,
  SBB16mi_EVEX,
  SBB16mi_ND,
  SBB16mr,
  SBB16mr_EVEX,
  SBB16mr_ND,
  SBB16ri,
  SBB16ri8,
  SBB16ri8_EVEX,
  SBB16ri8_ND,
  SBB16ri_EVEX,
  SBB16ri_ND,
  SBB16rm,
  SBB16rm_EVEX,
  SBB16rm_ND,
  SBB16rr,
  SBB16rr_EVEX,
  SBB16rr_EVEX_REV,
  SBB16rr_ND,
  SBB16rr_ND_REV,
  SBB16rr_REV,
  SBB32i32,
  SBB32mi,
  SBB32mi8,
  SBB32mi8_EVEX,
  SBB32mi8_ND,
  SBB32mi_EVEX,
  SBB32mi_ND,
  SBB32mr,
  SBB32mr_EVEX,
  SBB32mr_ND,
  SBB32ri,
  SBB32ri8,
  SBB32ri8_EVEX,
  SBB32ri8_ND,
  SBB32ri_EVEX,
  SBB32ri_ND,
  SBB32rm,
  SBB32rm_EVEX,
  SBB32rm_ND,
  SBB32rr,
  SBB32rr_EVEX,
  SBB32rr_EVEX_REV,
  SBB32rr_ND,
  SBB32rr_ND_REV,
  SBB32rr_REV,
  SBB64i32,
  SBB64mi32,
  SBB64mi32_EVEX,
  SBB64mi32_ND,
  SBB64mi8,
  SBB64mi8_EVEX,
  SBB64mi8_ND,
  SBB64mr,
  SBB64mr_EVEX,
  SBB64mr_ND,
  SBB64ri32,
  SBB64ri32_EVEX,
  SBB64ri32_ND,
  SBB64ri8,
  SBB64ri8_EVEX,
  SBB64ri8_ND,
  SBB64rm,
  SBB64rm_EVEX,
  SBB64rm_ND,
  SBB64rr,
  SBB64rr_EVEX,
  SBB64rr_EVEX_REV,
  SBB64rr_ND,
  SBB64rr_ND_REV,
  SBB64rr_REV,
  SBB8i8,
  SBB8mi,
  SBB8mi8,
  SBB8mi_EVEX,
  SBB8mi_ND,
  SBB8mr,
  SBB8mr_EVEX,
  SBB8mr_ND,
  SBB8ri,
  SBB8ri8,
  SBB8ri_EVEX,
  SBB8ri_ND,
  SBB8rm,
  SBB8rm_EVEX,
  SBB8rm_ND,
  SBB8rr,
  SBB8rr_EVEX,
  SBB8rr_EVEX_REV,
  SBB8rr_ND,
  SBB8rr_ND_REV,
  SBB8rr_REV,
  SCASB,
  SCASL,
  SCASQ,
  SCASW,
  SEAMCALL,
  SEAMOPS,
  SEAMRET,
  SEG_ALLOCA_32,
  SEG_ALLOCA_64,
  SENDUIPI,
  SERIALIZE,
  SETCCm,
  SETCCm_EVEX,
  SETCCr,
  SETCCr_EVEX,
  SETSSBSY,
  SETZUCCm,
  SETZUCCr,
  SFENCE,
  SGDT16m,
  SGDT32m,
  SGDT64m,
  SHA1MSG1rm,
  SHA1MSG1rr,
  SHA1MSG2rm,
  SHA1MSG2rr,
  SHA1NEXTErm,
  SHA1NEXTErr,
  SHA1RNDS4rmi,
  SHA1RNDS4rri,
  SHA256MSG1rm,
  SHA256MSG1rr,
  SHA256MSG2rm,
  SHA256MSG2rr,
  SHA256RNDS2rm,
  SHA256RNDS2rr,
  SHL16m1,
  SHL16m1_EVEX,
  SHL16m1_ND,
  SHL16m1_NF,
  SHL16m1_NF_ND,
  SHL16mCL,
  SHL16mCL_EVEX,
  SHL16mCL_ND,
  SHL16mCL_NF,
  SHL16mCL_NF_ND,
  SHL16mi,
  SHL16mi_EVEX,
  SHL16mi_ND,
  SHL16mi_NF,
  SHL16mi_NF_ND,
  SHL16r1,
  SHL16r1_EVEX,
  SHL16r1_ND,
  SHL16r1_NF,
  SHL16r1_NF_ND,
  SHL16rCL,
  SHL16rCL_EVEX,
  SHL16rCL_ND,
  SHL16rCL_NF,
  SHL16rCL_NF_ND,
  SHL16ri,
  SHL16ri_EVEX,
  SHL16ri_ND,
  SHL16ri_NF,
  SHL16ri_NF_ND,
  SHL32m1,
  SHL32m1_EVEX,
  SHL32m1_ND,
  SHL32m1_NF,
  SHL32m1_NF_ND,
  SHL32mCL,
  SHL32mCL_EVEX,
  SHL32mCL_ND,
  SHL32mCL_NF,
  SHL32mCL_NF_ND,
  SHL32mi,
  SHL32mi_EVEX,
  SHL32mi_ND,
  SHL32mi_NF,
  SHL32mi_NF_ND,
  SHL32r1,
  SHL32r1_EVEX,
  SHL32r1_ND,
  SHL32r1_NF,
  SHL32r1_NF_ND,
  SHL32rCL,
  SHL32rCL_EVEX,
  SHL32rCL_ND,
  SHL32rCL_NF,
  SHL32rCL_NF_ND,
  SHL32ri,
  SHL32ri_EVEX,
  SHL32ri_ND,
  SHL32ri_NF,
  SHL32ri_NF_ND,
  SHL64m1,
  SHL64m1_EVEX,
  SHL64m1_ND,
  SHL64m1_NF,
  SHL64m1_NF_ND,
  SHL64mCL,
  SHL64mCL_EVEX,
  SHL64mCL_ND,
  SHL64mCL_NF,
  SHL64mCL_NF_ND,
  SHL64mi,
  SHL64mi_EVEX,
  SHL64mi_ND,
  SHL64mi_NF,
  SHL64mi_NF_ND,
  SHL64r1,
  SHL64r1_EVEX,
  SHL64r1_ND,
  SHL64r1_NF,
  SHL64r1_NF_ND,
  SHL64rCL,
  SHL64rCL_EVEX,
  SHL64rCL_ND,
  SHL64rCL_NF,
  SHL64rCL_NF_ND,
  SHL64ri,
  SHL64ri_EVEX,
  SHL64ri_ND,
  SHL64ri_NF,
  SHL64ri_NF_ND,
  SHL8m1,
  SHL8m1_EVEX,
  SHL8m1_ND,
  SHL8m1_NF,
  SHL8m1_NF_ND,
  SHL8mCL,
  SHL8mCL_EVEX,
  SHL8mCL_ND,
  SHL8mCL_NF,
  SHL8mCL_NF_ND,
  SHL8mi,
  SHL8mi_EVEX,
  SHL8mi_ND,
  SHL8mi_NF,
  SHL8mi_NF_ND,
  SHL8r1,
  SHL8r1_EVEX,
  SHL8r1_ND,
  SHL8r1_NF,
  SHL8r1_NF_ND,
  SHL8rCL,
  SHL8rCL_EVEX,
  SHL8rCL_ND,
  SHL8rCL_NF,
  SHL8rCL_NF_ND,
  SHL8ri,
  SHL8ri_EVEX,
  SHL8ri_ND,
  SHL8ri_NF,
  SHL8ri_NF_ND,
  SHLD16mrCL,
  SHLD16mrCL_EVEX,
  SHLD16mrCL_ND,
  SHLD16mrCL_NF,
  SHLD16mrCL_NF_ND,
  SHLD16mri8,
  SHLD16mri8_EVEX,
  SHLD16mri8_ND,
  SHLD16mri8_NF,
  SHLD16mri8_NF_ND,
  SHLD16rrCL,
  SHLD16rrCL_EVEX,
  SHLD16rrCL_ND,
  SHLD16rrCL_NF,
  SHLD16rrCL_NF_ND,
  SHLD16rri8,
  SHLD16rri8_EVEX,
  SHLD16rri8_ND,
  SHLD16rri8_NF,
  SHLD16rri8_NF_ND,
  SHLD32mrCL,
  SHLD32mrCL_EVEX,
  SHLD32mrCL_ND,
  SHLD32mrCL_NF,
  SHLD32mrCL_NF_ND,
  SHLD32mri8,
  SHLD32mri8_EVEX,
  SHLD32mri8_ND,
  SHLD32mri8_NF,
  SHLD32mri8_NF_ND,
  SHLD32rrCL,
  SHLD32rrCL_EVEX,
  SHLD32rrCL_ND,
  SHLD32rrCL_NF,
  SHLD32rrCL_NF_ND,
  SHLD32rri8,
  SHLD32rri8_EVEX,
  SHLD32rri8_ND,
  SHLD32rri8_NF,
  SHLD32rri8_NF_ND,
  SHLD64mrCL,
  SHLD64mrCL_EVEX,
  SHLD64mrCL_ND,
  SHLD64mrCL_NF,
  SHLD64mrCL_NF_ND,
  SHLD64mri8,
  SHLD64mri8_EVEX,
  SHLD64mri8_ND,
  SHLD64mri8_NF,
  SHLD64mri8_NF_ND,
  SHLD64rrCL,
  SHLD64rrCL_EVEX,
  SHLD64rrCL_ND,
  SHLD64rrCL_NF,
  SHLD64rrCL_NF_ND,
  SHLD64rri8,
  SHLD64rri8_EVEX,
  SHLD64rri8_ND,
  SHLD64rri8_NF,
  SHLD64rri8_NF_ND,
  SHLX32rm,
  SHLX32rm_EVEX,
  SHLX32rr,
  SHLX32rr_EVEX,
  SHLX64rm,
  SHLX64rm_EVEX,
  SHLX64rr,
  SHLX64rr_EVEX,
  SHR16m1,
  SHR16m1_EVEX,
  SHR16m1_ND,
  SHR16m1_NF,
  SHR16m1_NF_ND,
  SHR16mCL,
  SHR16mCL_EVEX,
  SHR16mCL_ND,
  SHR16mCL_NF,
  SHR16mCL_NF_ND,
  SHR16mi,
  SHR16mi_EVEX,
  SHR16mi_ND,
  SHR16mi_NF,
  SHR16mi_NF_ND,
  SHR16r1,
  SHR16r1_EVEX,
  SHR16r1_ND,
  SHR16r1_NF,
  SHR16r1_NF_ND,
  SHR16rCL,
  SHR16rCL_EVEX,
  SHR16rCL_ND,
  SHR16rCL_NF,
  SHR16rCL_NF_ND,
  SHR16ri,
  SHR16ri_EVEX,
  SHR16ri_ND,
  SHR16ri_NF,
  SHR16ri_NF_ND,
  SHR32m1,
  SHR32m1_EVEX,
  SHR32m1_ND,
  SHR32m1_NF,
  SHR32m1_NF_ND,
  SHR32mCL,
  SHR32mCL_EVEX,
  SHR32mCL_ND,
  SHR32mCL_NF,
  SHR32mCL_NF_ND,
  SHR32mi,
  SHR32mi_EVEX,
  SHR32mi_ND,
  SHR32mi_NF,
  SHR32mi_NF_ND,
  SHR32r1,
  SHR32r1_EVEX,
  SHR32r1_ND,
  SHR32r1_NF,
  SHR32r1_NF_ND,
  SHR32rCL,
  SHR32rCL_EVEX,
  SHR32rCL_ND,
  SHR32rCL_NF,
  SHR32rCL_NF_ND,
  SHR32ri,
  SHR32ri_EVEX,
  SHR32ri_ND,
  SHR32ri_NF,
  SHR32ri_NF_ND,
  SHR64m1,
  SHR64m1_EVEX,
  SHR64m1_ND,
  SHR64m1_NF,
  SHR64m1_NF_ND,
  SHR64mCL,
  SHR64mCL_EVEX,
  SHR64mCL_ND,
  SHR64mCL_NF,
  SHR64mCL_NF_ND,
  SHR64mi,
  SHR64mi_EVEX,
  SHR64mi_ND,
  SHR64mi_NF,
  SHR64mi_NF_ND,
  SHR64r1,
  SHR64r1_EVEX,
  SHR64r1_ND,
  SHR64r1_NF,
  SHR64r1_NF_ND,
  SHR64rCL,
  SHR64rCL_EVEX,
  SHR64rCL_ND,
  SHR64rCL_NF,
  SHR64rCL_NF_ND,
  SHR64ri,
  SHR64ri_EVEX,
  SHR64ri_ND,
  SHR64ri_NF,
  SHR64ri_NF_ND,
  SHR8m1,
  SHR8m1_EVEX,
  SHR8m1_ND,
  SHR8m1_NF,
  SHR8m1_NF_ND,
  SHR8mCL,
  SHR8mCL_EVEX,
  SHR8mCL_ND,
  SHR8mCL_NF,
  SHR8mCL_NF_ND,
  SHR8mi,
  SHR8mi_EVEX,
  SHR8mi_ND,
  SHR8mi_NF,
  SHR8mi_NF_ND,
  SHR8r1,
  SHR8r1_EVEX,
  SHR8r1_ND,
  SHR8r1_NF,
  SHR8r1_NF_ND,
  SHR8rCL,
  SHR8rCL_EVEX,
  SHR8rCL_ND,
  SHR8rCL_NF,
  SHR8rCL_NF_ND,
  SHR8ri,
  SHR8ri_EVEX,
  SHR8ri_ND,
  SHR8ri_NF,
  SHR8ri_NF_ND,
  SHRD16mrCL,
  SHRD16mrCL_EVEX,
  SHRD16mrCL_ND,
  SHRD16mrCL_NF,
  SHRD16mrCL_NF_ND,
  SHRD16mri8,
  SHRD16mri8_EVEX,
  SHRD16mri8_ND,
  SHRD16mri8_NF,
  SHRD16mri8_NF_ND,
  SHRD16rrCL,
  SHRD16rrCL_EVEX,
  SHRD16rrCL_ND,
  SHRD16rrCL_NF,
  SHRD16rrCL_NF_ND,
  SHRD16rri8,
  SHRD16rri8_EVEX,
  SHRD16rri8_ND,
  SHRD16rri8_NF,
  SHRD16rri8_NF_ND,
  SHRD32mrCL,
  SHRD32mrCL_EVEX,
  SHRD32mrCL_ND,
  SHRD32mrCL_NF,
  SHRD32mrCL_NF_ND,
  SHRD32mri8,
  SHRD32mri8_EVEX,
  SHRD32mri8_ND,
  SHRD32mri8_NF,
  SHRD32mri8_NF_ND,
  SHRD32rrCL,
  SHRD32rrCL_EVEX,
  SHRD32rrCL_ND,
  SHRD32rrCL_NF,
  SHRD32rrCL_NF_ND,
  SHRD32rri8,
  SHRD32rri8_EVEX,
  SHRD32rri8_ND,
  SHRD32rri8_NF,
  SHRD32rri8_NF_ND,
  SHRD64mrCL,
  SHRD64mrCL_EVEX,
  SHRD64mrCL_ND,
  SHRD64mrCL_NF,
  SHRD64mrCL_NF_ND,
  SHRD64mri8,
  SHRD64mri8_EVEX,
  SHRD64mri8_ND,
  SHRD64mri8_NF,
  SHRD64mri8_NF_ND,
  SHRD64rrCL,
  SHRD64rrCL_EVEX,
  SHRD64rrCL_ND,
  SHRD64rrCL_NF,
  SHRD64rrCL_NF_ND,
  SHRD64rri8,
  SHRD64rri8_EVEX,
  SHRD64rri8_ND,
  SHRD64rri8_NF,
  SHRD64rri8_NF_ND,
  SHRX32rm,
  SHRX32rm_EVEX,
  SHRX32rr,
  SHRX32rr_EVEX,
  SHRX64rm,
  SHRX64rm_EVEX,
  SHRX64rr,
  SHRX64rr_EVEX,
  SHUFPDrmi,
  SHUFPDrri,
  SHUFPSrmi,
  SHUFPSrri,
  SIDT16m,
  SIDT32m,
  SIDT64m,
  SKINIT,
  SLDT16m,
  SLDT16r,
  SLDT32r,
  SLDT64r,
  SLWPCB,
  SLWPCB64,
  SMSW16m,
  SMSW16r,
  SMSW32r,
  SMSW64r,
  SQRTPDm,
  SQRTPDr,
  SQRTPSm,
  SQRTPSr,
  SQRTSDm,
  SQRTSDm_Int,
  SQRTSDr,
  SQRTSDr_Int,
  SQRTSSm,
  SQRTSSm_Int,
  SQRTSSr,
  SQRTSSr_Int,
  SQRT_F,
  SQRT_Fp32,
  SQRT_Fp64,
  SQRT_Fp80,
  SS_PREFIX,
  STAC,
  STACKALLOC_W_PROBING,
  STC,
  STD,
  STGI,
  STI,
  STMXCSR,
  STOSB,
  STOSL,
  STOSQ,
  STOSW,
  STR16r,
  STR32r,
  STR64r,
  STRm,
  STTILECFG,
  STTILECFG_EVEX,
  STUI,
  ST_F32m,
  ST_F64m,
  ST_FP32m,
  ST_FP64m,
  ST_FP80m,
  ST_FPrr,
  ST_Fp32m,
  ST_Fp64m,
  ST_Fp64m32,
  ST_Fp80m32,
  ST_Fp80m64,
  ST_FpP32m,
  ST_FpP64m,
  ST_FpP64m32,
  ST_FpP80m,
  ST_FpP80m32,
  ST_FpP80m64,
  ST_Frr,
  SUB16i16,
  SUB16mi,
  SUB16mi8,
  SUB16mi8_EVEX,
  SUB16mi8_ND,
  SUB16mi8_NF,
  SUB16mi8_NF_ND,
  SUB16mi_EVEX,
  SUB16mi_ND,
  SUB16mi_NF,
  SUB16mi_NF_ND,
  SUB16mr,
  SUB16mr_EVEX,
  SUB16mr_ND,
  SUB16mr_NF,
  SUB16mr_NF_ND,
  SUB16ri,
  SUB16ri8,
  SUB16ri8_EVEX,
  SUB16ri8_ND,
  SUB16ri8_NF,
  SUB16ri8_NF_ND,
  SUB16ri_EVEX,
  SUB16ri_ND,
  SUB16ri_NF,
  SUB16ri_NF_ND,
  SUB16rm,
  SUB16rm_EVEX,
  SUB16rm_ND,
  SUB16rm_NF,
  SUB16rm_NF_ND,
  SUB16rr,
  SUB16rr_EVEX,
  SUB16rr_EVEX_REV,
  SUB16rr_ND,
  SUB16rr_ND_REV,
  SUB16rr_NF,
  SUB16rr_NF_ND,
  SUB16rr_NF_ND_REV,
  SUB16rr_NF_REV,
  SUB16rr_REV,
  SUB32i32,
  SUB32mi,
  SUB32mi8,
  SUB32mi8_EVEX,
  SUB32mi8_ND,
  SUB32mi8_NF,
  SUB32mi8_NF_ND,
  SUB32mi_EVEX,
  SUB32mi_ND,
  SUB32mi_NF,
  SUB32mi_NF_ND,
  SUB32mr,
  SUB32mr_EVEX,
  SUB32mr_ND,
  SUB32mr_NF,
  SUB32mr_NF_ND,
  SUB32ri,
  SUB32ri8,
  SUB32ri8_EVEX,
  SUB32ri8_ND,
  SUB32ri8_NF,
  SUB32ri8_NF_ND,
  SUB32ri_EVEX,
  SUB32ri_ND,
  SUB32ri_NF,
  SUB32ri_NF_ND,
  SUB32rm,
  SUB32rm_EVEX,
  SUB32rm_ND,
  SUB32rm_NF,
  SUB32rm_NF_ND,
  SUB32rr,
  SUB32rr_EVEX,
  SUB32rr_EVEX_REV,
  SUB32rr_ND,
  SUB32rr_ND_REV,
  SUB32rr_NF,
  SUB32rr_NF_ND,
  SUB32rr_NF_ND_REV,
  SUB32rr_NF_REV,
  SUB32rr_REV,
  SUB64i32,
  SUB64mi32,
  SUB64mi32_EVEX,
  SUB64mi32_ND,
  SUB64mi32_NF,
  SUB64mi32_NF_ND,
  SUB64mi8,
  SUB64mi8_EVEX,
  SUB64mi8_ND,
  SUB64mi8_NF,
  SUB64mi8_NF_ND,
  SUB64mr,
  SUB64mr_EVEX,
  SUB64mr_ND,
  SUB64mr_NF,
  SUB64mr_NF_ND,
  SUB64ri32,
  SUB64ri32_EVEX,
  SUB64ri32_ND,
  SUB64ri32_NF,
  SUB64ri32_NF_ND,
  SUB64ri8,
  SUB64ri8_EVEX,
  SUB64ri8_ND,
  SUB64ri8_NF,
  SUB64ri8_NF_ND,
  SUB64rm,
  SUB64rm_EVEX,
  SUB64rm_ND,
  SUB64rm_NF,
  SUB64rm_NF_ND,
  SUB64rr,
  SUB64rr_EVEX,
  SUB64rr_EVEX_REV,
  SUB64rr_ND,
  SUB64rr_ND_REV,
  SUB64rr_NF,
  SUB64rr_NF_ND,
  SUB64rr_NF_ND_REV,
  SUB64rr_NF_REV,
  SUB64rr_REV,
  SUB8i8,
  SUB8mi,
  SUB8mi8,
  SUB8mi_EVEX,
  SUB8mi_ND,
  SUB8mi_NF,
  SUB8mi_NF_ND,
  SUB8mr,
  SUB8mr_EVEX,
  SUB8mr_ND,
  SUB8mr_NF,
  SUB8mr_NF_ND,
  SUB8ri,
  SUB8ri8,
  SUB8ri_EVEX,
  SUB8ri_ND,
  SUB8ri_NF,
  SUB8ri_NF_ND,
  SUB8rm,
  SUB8rm_EVEX,
  SUB8rm_ND,
  SUB8rm_NF,
  SUB8rm_NF_ND,
  SUB8rr,
  SUB8rr_EVEX,
  SUB8rr_EVEX_REV,
  SUB8rr_ND,
  SUB8rr_ND_REV,
  SUB8rr_NF,
  SUB8rr_NF_ND,
  SUB8rr_NF_ND_REV,
  SUB8rr_NF_REV,
  SUB8rr_REV,
  SUBPDrm,
  SUBPDrr,
  SUBPSrm,
  SUBPSrr,
  SUBR_F32m,
  SUBR_F64m,
  SUBR_FI16m,
  SUBR_FI32m,
  SUBR_FPrST0,
  SUBR_FST0r,
  SUBR_Fp32m,
  SUBR_Fp64m,
  SUBR_Fp64m32,
  SUBR_Fp80m32,
  SUBR_Fp80m64,
  SUBR_FpI16m32,
  SUBR_FpI16m64,
  SUBR_FpI16m80,
  SUBR_FpI32m32,
  SUBR_FpI32m64,
  SUBR_FpI32m80,
  SUBR_FrST0,
  SUBSDrm,
  SUBSDrm_Int,
  SUBSDrr,
  SUBSDrr_Int,
  SUBSSrm,
  SUBSSrm_Int,
  SUBSSrr,
  SUBSSrr_Int,
  SUB_F32m,
  SUB_F64m,
  SUB_FI16m,
  SUB_FI32m,
  SUB_FPrST0,
  SUB_FST0r,
  SUB_Fp32,
  SUB_Fp32m,
  SUB_Fp64,
  SUB_Fp64m,
  SUB_Fp64m32,
  SUB_Fp80,
  SUB_Fp80m32,
  SUB_Fp80m64,
  SUB_FpI16m32,
  SUB_FpI16m64,
  SUB_FpI16m80,
  SUB_FpI32m32,
  SUB_FpI32m64,
  SUB_FpI32m80,
  SUB_FrST0,
  SWAPGS,
  SYSCALL,
  SYSENTER,
  SYSEXIT,
  SYSEXIT64,
  SYSRET,
  SYSRET64,
  T1MSKC32rm,
  T1MSKC32rr,
  T1MSKC64rm,
  T1MSKC64rr,
  TAILJMPd,
  TAILJMPd64,
  TAILJMPd64_CC,
  TAILJMPd_CC,
  TAILJMPm,
  TAILJMPm64,
  TAILJMPm64_REX,
  TAILJMPr,
  TAILJMPr64,
  TAILJMPr64_REX,
  TCMMIMFP16PS,
  TCMMRLFP16PS,
  TCRETURNdi,
  TCRETURNdi64,
  TCRETURNdi64cc,
  TCRETURNdicc,
  TCRETURNmi,
  TCRETURNmi64,
  TCRETURNri,
  TCRETURNri64,
  TDCALL,
  TDPBF16PS,
  TDPBSSD,
  TDPBSUD,
  TDPBUSD,
  TDPBUUD,
  TDPFP16PS,
  TEST16i16,
  TEST16mi,
  TEST16mr,
  TEST16ri,
  TEST16rr,
  TEST32i32,
  TEST32mi,
  TEST32mr,
  TEST32ri,
  TEST32rr,
  TEST64i32,
  TEST64mi32,
  TEST64mr,
  TEST64ri32,
  TEST64rr,
  TEST8i8,
  TEST8mi,
  TEST8mr,
  TEST8ri,
  TEST8rr,
  TESTUI,
  TILELOADD,
  TILELOADDT1,
  TILELOADDT1_EVEX,
  TILELOADD_EVEX,
  TILERELEASE,
  TILESTORED,
  TILESTORED_EVEX,
  TILEZERO,
  TLBSYNC,
  TLSCall_32,
  TLSCall_64,
  TLS_addr32,
  TLS_addr64,
  TLS_addrX32,
  TLS_base_addr32,
  TLS_base_addr64,
  TLS_base_addrX32,
  TLS_desc32,
  TLS_desc64,
  TPAUSE,
  TRAP,
  TST_F,
  TST_Fp32,
  TST_Fp64,
  TST_Fp80,
  TZCNT16rm,
  TZCNT16rm_EVEX,
  TZCNT16rm_NF,
  TZCNT16rr,
  TZCNT16rr_EVEX,
  TZCNT16rr_NF,
  TZCNT32rm,
  TZCNT32rm_EVEX,
  TZCNT32rm_NF,
  TZCNT32rr,
  TZCNT32rr_EVEX,
  TZCNT32rr_NF,
  TZCNT64rm,
  TZCNT64rm_EVEX,
  TZCNT64rm_NF,
  TZCNT64rr,
  TZCNT64rr_EVEX,
  TZCNT64rr_NF,
  TZMSK32rm,
  TZMSK32rr,
  TZMSK64rm,
  TZMSK64rr,
  UBSAN_UD1,
  UCOMISDrm,
  UCOMISDrm_Int,
  UCOMISDrr,
  UCOMISDrr_Int,
  UCOMISSrm,
  UCOMISSrm_Int,
  UCOMISSrr,
  UCOMISSrr_Int,
  UCOM_FIPr,
  UCOM_FIr,
  UCOM_FPPr,
  UCOM_FPr,
  UCOM_FpIr32,
  UCOM_FpIr64,
  UCOM_FpIr80,
  UCOM_Fpr32,
  UCOM_Fpr64,
  UCOM_Fpr80,
  UCOM_Fr,
  UD1Lm,
  UD1Lr,
  UD1Qm,
  UD1Qr,
  UD1Wm,
  UD1Wr,
  UIRET,
  UMONITOR16,
  UMONITOR32,
  UMONITOR64,
  UMWAIT,
  UNPCKHPDrm,
  UNPCKHPDrr,
  UNPCKHPSrm,
  UNPCKHPSrr,
  UNPCKLPDrm,
  UNPCKLPDrr,
  UNPCKLPSrm,
  UNPCKLPSrr,
  URDMSRri,
  URDMSRri_EVEX,
  URDMSRrr,
  URDMSRrr_EVEX,
  UWRMSRir,
  UWRMSRir_EVEX,
  UWRMSRrr,
  UWRMSRrr_EVEX,
  V4FMADDPSrm,
  V4FMADDPSrmk,
  V4FMADDPSrmkz,
  V4FMADDSSrm,
  V4FMADDSSrmk,
  V4FMADDSSrmkz,
  V4FNMADDPSrm,
  V4FNMADDPSrmk,
  V4FNMADDPSrmkz,
  V4FNMADDSSrm,
  V4FNMADDSSrmk,
  V4FNMADDSSrmkz,
  VAARG_64,
  VAARG_X32,
  VADDPDYrm,
  VADDPDYrr,
  VADDPDZ128rm,
  VADDPDZ128rmb,
  VADDPDZ128rmbk,
  VADDPDZ128rmbkz,
  VADDPDZ128rmk,
  VADDPDZ128rmkz,
  VADDPDZ128rr,
  VADDPDZ128rrk,
  VADDPDZ128rrkz,
  VADDPDZ256rm,
  VADDPDZ256rmb,
  VADDPDZ256rmbk,
  VADDPDZ256rmbkz,
  VADDPDZ256rmk,
  VADDPDZ256rmkz,
  VADDPDZ256rr,
  VADDPDZ256rrk,
  VADDPDZ256rrkz,
  VADDPDZrm,
  VADDPDZrmb,
  VADDPDZrmbk,
  VADDPDZrmbkz,
  VADDPDZrmk,
  VADDPDZrmkz,
  VADDPDZrr,
  VADDPDZrrb,
  VADDPDZrrbk,
  VADDPDZrrbkz,
  VADDPDZrrk,
  VADDPDZrrkz,
  VADDPDrm,
  VADDPDrr,
  VADDPHZ128rm,
  VADDPHZ128rmb,
  VADDPHZ128rmbk,
  VADDPHZ128rmbkz,
  VADDPHZ128rmk,
  VADDPHZ128rmkz,
  VADDPHZ128rr,
  VADDPHZ128rrk,
  VADDPHZ128rrkz,
  VADDPHZ256rm,
  VADDPHZ256rmb,
  VADDPHZ256rmbk,
  VADDPHZ256rmbkz,
  VADDPHZ256rmk,
  VADDPHZ256rmkz,
  VADDPHZ256rr,
  VADDPHZ256rrk,
  VADDPHZ256rrkz,
  VADDPHZrm,
  VADDPHZrmb,
  VADDPHZrmbk,
  VADDPHZrmbkz,
  VADDPHZrmk,
  VADDPHZrmkz,
  VADDPHZrr,
  VADDPHZrrb,
  VADDPHZrrbk,
  VADDPHZrrbkz,
  VADDPHZrrk,
  VADDPHZrrkz,
  VADDPSYrm,
  VADDPSYrr,
  VADDPSZ128rm,
  VADDPSZ128rmb,
  VADDPSZ128rmbk,
  VADDPSZ128rmbkz,
  VADDPSZ128rmk,
  VADDPSZ128rmkz,
  VADDPSZ128rr,
  VADDPSZ128rrk,
  VADDPSZ128rrkz,
  VADDPSZ256rm,
  VADDPSZ256rmb,
  VADDPSZ256rmbk,
  VADDPSZ256rmbkz,
  VADDPSZ256rmk,
  VADDPSZ256rmkz,
  VADDPSZ256rr,
  VADDPSZ256rrk,
  VADDPSZ256rrkz,
  VADDPSZrm,
  VADDPSZrmb,
  VADDPSZrmbk,
  VADDPSZrmbkz,
  VADDPSZrmk,
  VADDPSZrmkz,
  VADDPSZrr,
  VADDPSZrrb,
  VADDPSZrrbk,
  VADDPSZrrbkz,
  VADDPSZrrk,
  VADDPSZrrkz,
  VADDPSrm,
  VADDPSrr,
  VADDSDZrm,
  VADDSDZrm_Int,
  VADDSDZrm_Intk,
  VADDSDZrm_Intkz,
  VADDSDZrr,
  VADDSDZrr_Int,
  VADDSDZrr_Intk,
  VADDSDZrr_Intkz,
  VADDSDZrrb_Int,
  VADDSDZrrb_Intk,
  VADDSDZrrb_Intkz,
  VADDSDrm,
  VADDSDrm_Int,
  VADDSDrr,
  VADDSDrr_Int,
  VADDSHZrm,
  VADDSHZrm_Int,
  VADDSHZrm_Intk,
  VADDSHZrm_Intkz,
  VADDSHZrr,
  VADDSHZrr_Int,
  VADDSHZrr_Intk,
  VADDSHZrr_Intkz,
  VADDSHZrrb_Int,
  VADDSHZrrb_Intk,
  VADDSHZrrb_Intkz,
  VADDSSZrm,
  VADDSSZrm_Int,
  VADDSSZrm_Intk,
  VADDSSZrm_Intkz,
  VADDSSZrr,
  VADDSSZrr_Int,
  VADDSSZrr_Intk,
  VADDSSZrr_Intkz,
  VADDSSZrrb_Int,
  VADDSSZrrb_Intk,
  VADDSSZrrb_Intkz,
  VADDSSrm,
  VADDSSrm_Int,
  VADDSSrr,
  VADDSSrr_Int,
  VADDSUBPDYrm,
  VADDSUBPDYrr,
  VADDSUBPDrm,
  VADDSUBPDrr,
  VADDSUBPSYrm,
  VADDSUBPSYrr,
  VADDSUBPSrm,
  VADDSUBPSrr,
  VAESDECLASTYrm,
  VAESDECLASTYrr,
  VAESDECLASTZ128rm,
  VAESDECLASTZ128rr,
  VAESDECLASTZ256rm,
  VAESDECLASTZ256rr,
  VAESDECLASTZrm,
  VAESDECLASTZrr,
  VAESDECLASTrm,
  VAESDECLASTrr,
  VAESDECYrm,
  VAESDECYrr,
  VAESDECZ128rm,
  VAESDECZ128rr,
  VAESDECZ256rm,
  VAESDECZ256rr,
  VAESDECZrm,
  VAESDECZrr,
  VAESDECrm,
  VAESDECrr,
  VAESENCLASTYrm,
  VAESENCLASTYrr,
  VAESENCLASTZ128rm,
  VAESENCLASTZ128rr,
  VAESENCLASTZ256rm,
  VAESENCLASTZ256rr,
  VAESENCLASTZrm,
  VAESENCLASTZrr,
  VAESENCLASTrm,
  VAESENCLASTrr,
  VAESENCYrm,
  VAESENCYrr,
  VAESENCZ128rm,
  VAESENCZ128rr,
  VAESENCZ256rm,
  VAESENCZ256rr,
  VAESENCZrm,
  VAESENCZrr,
  VAESENCrm,
  VAESENCrr,
  VAESIMCrm,
  VAESIMCrr,
  VAESKEYGENASSIST128rm,
  VAESKEYGENASSIST128rr,
  VALIGNDZ128rmbi,
  VALIGNDZ128rmbik,
  VALIGNDZ128rmbikz,
  VALIGNDZ128rmi,
  VALIGNDZ128rmik,
  VALIGNDZ128rmikz,
  VALIGNDZ128rri,
  VALIGNDZ128rrik,
  VALIGNDZ128rrikz,
  VALIGNDZ256rmbi,
  VALIGNDZ256rmbik,
  VALIGNDZ256rmbikz,
  VALIGNDZ256rmi,
  VALIGNDZ256rmik,
  VALIGNDZ256rmikz,
  VALIGNDZ256rri,
  VALIGNDZ256rrik,
  VALIGNDZ256rrikz,
  VALIGNDZrmbi,
  VALIGNDZrmbik,
  VALIGNDZrmbikz,
  VALIGNDZrmi,
  VALIGNDZrmik,
  VALIGNDZrmikz,
  VALIGNDZrri,
  VALIGNDZrrik,
  VALIGNDZrrikz,
  VALIGNQZ128rmbi,
  VALIGNQZ128rmbik,
  VALIGNQZ128rmbikz,
  VALIGNQZ128rmi,
  VALIGNQZ128rmik,
  VALIGNQZ128rmikz,
  VALIGNQZ128rri,
  VALIGNQZ128rrik,
  VALIGNQZ128rrikz,
  VALIGNQZ256rmbi,
  VALIGNQZ256rmbik,
  VALIGNQZ256rmbikz,
  VALIGNQZ256rmi,
  VALIGNQZ256rmik,
  VALIGNQZ256rmikz,
  VALIGNQZ256rri,
  VALIGNQZ256rrik,
  VALIGNQZ256rrikz,
  VALIGNQZrmbi,
  VALIGNQZrmbik,
  VALIGNQZrmbikz,
  VALIGNQZrmi,
  VALIGNQZrmik,
  VALIGNQZrmikz,
  VALIGNQZrri,
  VALIGNQZrrik,
  VALIGNQZrrikz,
  VANDNPDYrm,
  VANDNPDYrr,
  VANDNPDZ128rm,
  VANDNPDZ128rmb,
  VANDNPDZ128rmbk,
  VANDNPDZ128rmbkz,
  VANDNPDZ128rmk,
  VANDNPDZ128rmkz,
  VANDNPDZ128rr,
  VANDNPDZ128rrk,
  VANDNPDZ128rrkz,
  VANDNPDZ256rm,
  VANDNPDZ256rmb,
  VANDNPDZ256rmbk,
  VANDNPDZ256rmbkz,
  VANDNPDZ256rmk,
  VANDNPDZ256rmkz,
  VANDNPDZ256rr,
  VANDNPDZ256rrk,
  VANDNPDZ256rrkz,
  VANDNPDZrm,
  VANDNPDZrmb,
  VANDNPDZrmbk,
  VANDNPDZrmbkz,
  VANDNPDZrmk,
  VANDNPDZrmkz,
  VANDNPDZrr,
  VANDNPDZrrk,
  VANDNPDZrrkz,
  VANDNPDrm,
  VANDNPDrr,
  VANDNPSYrm,
  VANDNPSYrr,
  VANDNPSZ128rm,
  VANDNPSZ128rmb,
  VANDNPSZ128rmbk,
  VANDNPSZ128rmbkz,
  VANDNPSZ128rmk,
  VANDNPSZ128rmkz,
  VANDNPSZ128rr,
  VANDNPSZ128rrk,
  VANDNPSZ128rrkz,
  VANDNPSZ256rm,
  VANDNPSZ256rmb,
  VANDNPSZ256rmbk,
  VANDNPSZ256rmbkz,
  VANDNPSZ256rmk,
  VANDNPSZ256rmkz,
  VANDNPSZ256rr,
  VANDNPSZ256rrk,
  VANDNPSZ256rrkz,
  VANDNPSZrm,
  VANDNPSZrmb,
  VANDNPSZrmbk,
  VANDNPSZrmbkz,
  VANDNPSZrmk,
  VANDNPSZrmkz,
  VANDNPSZrr,
  VANDNPSZrrk,
  VANDNPSZrrkz,
  VANDNPSrm,
  VANDNPSrr,
  VANDPDYrm,
  VANDPDYrr,
  VANDPDZ128rm,
  VANDPDZ128rmb,
  VANDPDZ128rmbk,
  VANDPDZ128rmbkz,
  VANDPDZ128rmk,
  VANDPDZ128rmkz,
  VANDPDZ128rr,
  VANDPDZ128rrk,
  VANDPDZ128rrkz,
  VANDPDZ256rm,
  VANDPDZ256rmb,
  VANDPDZ256rmbk,
  VANDPDZ256rmbkz,
  VANDPDZ256rmk,
  VANDPDZ256rmkz,
  VANDPDZ256rr,
  VANDPDZ256rrk,
  VANDPDZ256rrkz,
  VANDPDZrm,
  VANDPDZrmb,
  VANDPDZrmbk,
  VANDPDZrmbkz,
  VANDPDZrmk,
  VANDPDZrmkz,
  VANDPDZrr,
  VANDPDZrrk,
  VANDPDZrrkz,
  VANDPDrm,
  VANDPDrr,
  VANDPSYrm,
  VANDPSYrr,
  VANDPSZ128rm,
  VANDPSZ128rmb,
  VANDPSZ128rmbk,
  VANDPSZ128rmbkz,
  VANDPSZ128rmk,
  VANDPSZ128rmkz,
  VANDPSZ128rr,
  VANDPSZ128rrk,
  VANDPSZ128rrkz,
  VANDPSZ256rm,
  VANDPSZ256rmb,
  VANDPSZ256rmbk,
  VANDPSZ256rmbkz,
  VANDPSZ256rmk,
  VANDPSZ256rmkz,
  VANDPSZ256rr,
  VANDPSZ256rrk,
  VANDPSZ256rrkz,
  VANDPSZrm,
  VANDPSZrmb,
  VANDPSZrmbk,
  VANDPSZrmbkz,
  VANDPSZrmk,
  VANDPSZrmkz,
  VANDPSZrr,
  VANDPSZrrk,
  VANDPSZrrkz,
  VANDPSrm,
  VANDPSrr,
  VASTART_SAVE_XMM_REGS,
  VBCSTNEBF162PSYrm,
  VBCSTNEBF162PSrm,
  VBCSTNESH2PSYrm,
  VBCSTNESH2PSrm,
  VBLENDMPDZ128rm,
  VBLENDMPDZ128rmb,
  VBLENDMPDZ128rmbk,
  VBLENDMPDZ128rmbkz,
  VBLENDMPDZ128rmk,
  VBLENDMPDZ128rmkz,
  VBLENDMPDZ128rr,
  VBLENDMPDZ128rrk,
  VBLENDMPDZ128rrkz,
  VBLENDMPDZ256rm,
  VBLENDMPDZ256rmb,
  VBLENDMPDZ256rmbk,
  VBLENDMPDZ256rmbkz,
  VBLENDMPDZ256rmk,
  VBLENDMPDZ256rmkz,
  VBLENDMPDZ256rr,
  VBLENDMPDZ256rrk,
  VBLENDMPDZ256rrkz,
  VBLENDMPDZrm,
  VBLENDMPDZrmb,
  VBLENDMPDZrmbk,
  VBLENDMPDZrmbkz,
  VBLENDMPDZrmk,
  VBLENDMPDZrmkz,
  VBLENDMPDZrr,
  VBLENDMPDZrrk,
  VBLENDMPDZrrkz,
  VBLENDMPSZ128rm,
  VBLENDMPSZ128rmb,
  VBLENDMPSZ128rmbk,
  VBLENDMPSZ128rmbkz,
  VBLENDMPSZ128rmk,
  VBLENDMPSZ128rmkz,
  VBLENDMPSZ128rr,
  VBLENDMPSZ128rrk,
  VBLENDMPSZ128rrkz,
  VBLENDMPSZ256rm,
  VBLENDMPSZ256rmb,
  VBLENDMPSZ256rmbk,
  VBLENDMPSZ256rmbkz,
  VBLENDMPSZ256rmk,
  VBLENDMPSZ256rmkz,
  VBLENDMPSZ256rr,
  VBLENDMPSZ256rrk,
  VBLENDMPSZ256rrkz,
  VBLENDMPSZrm,
  VBLENDMPSZrmb,
  VBLENDMPSZrmbk,
  VBLENDMPSZrmbkz,
  VBLENDMPSZrmk,
  VBLENDMPSZrmkz,
  VBLENDMPSZrr,
  VBLENDMPSZrrk,
  VBLENDMPSZrrkz,
  VBLENDPDYrmi,
  VBLENDPDYrri,
  VBLENDPDrmi,
  VBLENDPDrri,
  VBLENDPSYrmi,
  VBLENDPSYrri,
  VBLENDPSrmi,
  VBLENDPSrri,
  VBLENDVPDYrmr,
  VBLENDVPDYrrr,
  VBLENDVPDrmr,
  VBLENDVPDrrr,
  VBLENDVPSYrmr,
  VBLENDVPSYrrr,
  VBLENDVPSrmr,
  VBLENDVPSrrr,
  VBROADCASTF128rm,
  VBROADCASTF32X2Z256rm,
  VBROADCASTF32X2Z256rmk,
  VBROADCASTF32X2Z256rmkz,
  VBROADCASTF32X2Z256rr,
  VBROADCASTF32X2Z256rrk,
  VBROADCASTF32X2Z256rrkz,
  VBROADCASTF32X2Zrm,
  VBROADCASTF32X2Zrmk,
  VBROADCASTF32X2Zrmkz,
  VBROADCASTF32X2Zrr,
  VBROADCASTF32X2Zrrk,
  VBROADCASTF32X2Zrrkz,
  VBROADCASTF32X4Z256rm,
  VBROADCASTF32X4Z256rmk,
  VBROADCASTF32X4Z256rmkz,
  VBROADCASTF32X4rm,
  VBROADCASTF32X4rmk,
  VBROADCASTF32X4rmkz,
  VBROADCASTF32X8rm,
  VBROADCASTF32X8rmk,
  VBROADCASTF32X8rmkz,
  VBROADCASTF64X2Z128rm,
  VBROADCASTF64X2Z128rmk,
  VBROADCASTF64X2Z128rmkz,
  VBROADCASTF64X2rm,
  VBROADCASTF64X2rmk,
  VBROADCASTF64X2rmkz,
  VBROADCASTF64X4rm,
  VBROADCASTF64X4rmk,
  VBROADCASTF64X4rmkz,
  VBROADCASTI128rm,
  VBROADCASTI32X2Z128rm,
  VBROADCASTI32X2Z128rmk,
  VBROADCASTI32X2Z128rmkz,
  VBROADCASTI32X2Z128rr,
  VBROADCASTI32X2Z128rrk,
  VBROADCASTI32X2Z128rrkz,
  VBROADCASTI32X2Z256rm,
  VBROADCASTI32X2Z256rmk,
  VBROADCASTI32X2Z256rmkz,
  VBROADCASTI32X2Z256rr,
  VBROADCASTI32X2Z256rrk,
  VBROADCASTI32X2Z256rrkz,
  VBROADCASTI32X2Zrm,
  VBROADCASTI32X2Zrmk,
  VBROADCASTI32X2Zrmkz,
  VBROADCASTI32X2Zrr,
  VBROADCASTI32X2Zrrk,
  VBROADCASTI32X2Zrrkz,
  VBROADCASTI32X4Z256rm,
  VBROADCASTI32X4Z256rmk,
  VBROADCASTI32X4Z256rmkz,
  VBROADCASTI32X4rm,
  VBROADCASTI32X4rmk,
  VBROADCASTI32X4rmkz,
  VBROADCASTI32X8rm,
  VBROADCASTI32X8rmk,
  VBROADCASTI32X8rmkz,
  VBROADCASTI64X2Z128rm,
  VBROADCASTI64X2Z128rmk,
  VBROADCASTI64X2Z128rmkz,
  VBROADCASTI64X2rm,
  VBROADCASTI64X2rmk,
  VBROADCASTI64X2rmkz,
  VBROADCASTI64X4rm,
  VBROADCASTI64X4rmk,
  VBROADCASTI64X4rmkz,
  VBROADCASTSDYrm,
  VBROADCASTSDYrr,
  VBROADCASTSDZ256rm,
  VBROADCASTSDZ256rmk,
  VBROADCASTSDZ256rmkz,
  VBROADCASTSDZ256rr,
  VBROADCASTSDZ256rrk,
  VBROADCASTSDZ256rrkz,
  VBROADCASTSDZrm,
  VBROADCASTSDZrmk,
  VBROADCASTSDZrmkz,
  VBROADCASTSDZrr,
  VBROADCASTSDZrrk,
  VBROADCASTSDZrrkz,
  VBROADCASTSSYrm,
  VBROADCASTSSYrr,
  VBROADCASTSSZ128rm,
  VBROADCASTSSZ128rmk,
  VBROADCASTSSZ128rmkz,
  VBROADCASTSSZ128rr,
  VBROADCASTSSZ128rrk,
  VBROADCASTSSZ128rrkz,
  VBROADCASTSSZ256rm,
  VBROADCASTSSZ256rmk,
  VBROADCASTSSZ256rmkz,
  VBROADCASTSSZ256rr,
  VBROADCASTSSZ256rrk,
  VBROADCASTSSZ256rrkz,
  VBROADCASTSSZrm,
  VBROADCASTSSZrmk,
  VBROADCASTSSZrmkz,
  VBROADCASTSSZrr,
  VBROADCASTSSZrrk,
  VBROADCASTSSZrrkz,
  VBROADCASTSSrm,
  VBROADCASTSSrr,
  VCMPPDYrmi,
  VCMPPDYrri,
  VCMPPDZ128rmbi,
  VCMPPDZ128rmbik,
  VCMPPDZ128rmi,
  VCMPPDZ128rmik,
  VCMPPDZ128rri,
  VCMPPDZ128rrik,
  VCMPPDZ256rmbi,
  VCMPPDZ256rmbik,
  VCMPPDZ256rmi,
  VCMPPDZ256rmik,
  VCMPPDZ256rri,
  VCMPPDZ256rrik,
  VCMPPDZrmbi,
  VCMPPDZrmbik,
  VCMPPDZrmi,
  VCMPPDZrmik,
  VCMPPDZrri,
  VCMPPDZrrib,
  VCMPPDZrribk,
  VCMPPDZrrik,
  VCMPPDrmi,
  VCMPPDrri,
  VCMPPHZ128rmbi,
  VCMPPHZ128rmbik,
  VCMPPHZ128rmi,
  VCMPPHZ128rmik,
  VCMPPHZ128rri,
  VCMPPHZ128rrik,
  VCMPPHZ256rmbi,
  VCMPPHZ256rmbik,
  VCMPPHZ256rmi,
  VCMPPHZ256rmik,
  VCMPPHZ256rri,
  VCMPPHZ256rrik,
  VCMPPHZrmbi,
  VCMPPHZrmbik,
  VCMPPHZrmi,
  VCMPPHZrmik,
  VCMPPHZrri,
  VCMPPHZrrib,
  VCMPPHZrribk,
  VCMPPHZrrik,
  VCMPPSYrmi,
  VCMPPSYrri,
  VCMPPSZ128rmbi,
  VCMPPSZ128rmbik,
  VCMPPSZ128rmi,
  VCMPPSZ128rmik,
  VCMPPSZ128rri,
  VCMPPSZ128rrik,
  VCMPPSZ256rmbi,
  VCMPPSZ256rmbik,
  VCMPPSZ256rmi,
  VCMPPSZ256rmik,
  VCMPPSZ256rri,
  VCMPPSZ256rrik,
  VCMPPSZrmbi,
  VCMPPSZrmbik,
  VCMPPSZrmi,
  VCMPPSZrmik,
  VCMPPSZrri,
  VCMPPSZrrib,
  VCMPPSZrribk,
  VCMPPSZrrik,
  VCMPPSrmi,
  VCMPPSrri,
  VCMPSDZrmi,
  VCMPSDZrmi_Int,
  VCMPSDZrmi_Intk,
  VCMPSDZrri,
  VCMPSDZrri_Int,
  VCMPSDZrri_Intk,
  VCMPSDZrrib_Int,
  VCMPSDZrrib_Intk,
  VCMPSDrmi,
  VCMPSDrmi_Int,
  VCMPSDrri,
  VCMPSDrri_Int,
  VCMPSHZrmi,
  VCMPSHZrmi_Int,
  VCMPSHZrmi_Intk,
  VCMPSHZrri,
  VCMPSHZrri_Int,
  VCMPSHZrri_Intk,
  VCMPSHZrrib_Int,
  VCMPSHZrrib_Intk,
  VCMPSSZrmi,
  VCMPSSZrmi_Int,
  VCMPSSZrmi_Intk,
  VCMPSSZrri,
  VCMPSSZrri_Int,
  VCMPSSZrri_Intk,
  VCMPSSZrrib_Int,
  VCMPSSZrrib_Intk,
  VCMPSSrmi,
  VCMPSSrmi_Int,
  VCMPSSrri,
  VCMPSSrri_Int,
  VCOMISDZrm,
  VCOMISDZrm_Int,
  VCOMISDZrr,
  VCOMISDZrr_Int,
  VCOMISDZrrb,
  VCOMISDrm,
  VCOMISDrm_Int,
  VCOMISDrr,
  VCOMISDrr_Int,
  VCOMISHZrm,
  VCOMISHZrm_Int,
  VCOMISHZrr,
  VCOMISHZrr_Int,
  VCOMISHZrrb,
  VCOMISSZrm,
  VCOMISSZrm_Int,
  VCOMISSZrr,
  VCOMISSZrr_Int,
  VCOMISSZrrb,
  VCOMISSrm,
  VCOMISSrm_Int,
  VCOMISSrr,
  VCOMISSrr_Int,
  VCOMPRESSPDZ128mr,
  VCOMPRESSPDZ128mrk,
  VCOMPRESSPDZ128rr,
  VCOMPRESSPDZ128rrk,
  VCOMPRESSPDZ128rrkz,
  VCOMPRESSPDZ256mr,
  VCOMPRESSPDZ256mrk,
  VCOMPRESSPDZ256rr,
  VCOMPRESSPDZ256rrk,
  VCOMPRESSPDZ256rrkz,
  VCOMPRESSPDZmr,
  VCOMPRESSPDZmrk,
  VCOMPRESSPDZrr,
  VCOMPRESSPDZrrk,
  VCOMPRESSPDZrrkz,
  VCOMPRESSPSZ128mr,
  VCOMPRESSPSZ128mrk,
  VCOMPRESSPSZ128rr,
  VCOMPRESSPSZ128rrk,
  VCOMPRESSPSZ128rrkz,
  VCOMPRESSPSZ256mr,
  VCOMPRESSPSZ256mrk,
  VCOMPRESSPSZ256rr,
  VCOMPRESSPSZ256rrk,
  VCOMPRESSPSZ256rrkz,
  VCOMPRESSPSZmr,
  VCOMPRESSPSZmrk,
  VCOMPRESSPSZrr,
  VCOMPRESSPSZrrk,
  VCOMPRESSPSZrrkz,
  VCVTDQ2PDYrm,
  VCVTDQ2PDYrr,
  VCVTDQ2PDZ128rm,
  VCVTDQ2PDZ128rmb,
  VCVTDQ2PDZ128rmbk,
  VCVTDQ2PDZ128rmbkz,
  VCVTDQ2PDZ128rmk,
  VCVTDQ2PDZ128rmkz,
  VCVTDQ2PDZ128rr,
  VCVTDQ2PDZ128rrk,
  VCVTDQ2PDZ128rrkz,
  VCVTDQ2PDZ256rm,
  VCVTDQ2PDZ256rmb,
  VCVTDQ2PDZ256rmbk,
  VCVTDQ2PDZ256rmbkz,
  VCVTDQ2PDZ256rmk,
  VCVTDQ2PDZ256rmkz,
  VCVTDQ2PDZ256rr,
  VCVTDQ2PDZ256rrk,
  VCVTDQ2PDZ256rrkz,
  VCVTDQ2PDZrm,
  VCVTDQ2PDZrmb,
  VCVTDQ2PDZrmbk,
  VCVTDQ2PDZrmbkz,
  VCVTDQ2PDZrmk,
  VCVTDQ2PDZrmkz,
  VCVTDQ2PDZrr,
  VCVTDQ2PDZrrk,
  VCVTDQ2PDZrrkz,
  VCVTDQ2PDrm,
  VCVTDQ2PDrr,
  VCVTDQ2PHZ128rm,
  VCVTDQ2PHZ128rmb,
  VCVTDQ2PHZ128rmbk,
  VCVTDQ2PHZ128rmbkz,
  VCVTDQ2PHZ128rmk,
  VCVTDQ2PHZ128rmkz,
  VCVTDQ2PHZ128rr,
  VCVTDQ2PHZ128rrk,
  VCVTDQ2PHZ128rrkz,
  VCVTDQ2PHZ256rm,
  VCVTDQ2PHZ256rmb,
  VCVTDQ2PHZ256rmbk,
  VCVTDQ2PHZ256rmbkz,
  VCVTDQ2PHZ256rmk,
  VCVTDQ2PHZ256rmkz,
  VCVTDQ2PHZ256rr,
  VCVTDQ2PHZ256rrk,
  VCVTDQ2PHZ256rrkz,
  VCVTDQ2PHZrm,
  VCVTDQ2PHZrmb,
  VCVTDQ2PHZrmbk,
  VCVTDQ2PHZrmbkz,
  VCVTDQ2PHZrmk,
  VCVTDQ2PHZrmkz,
  VCVTDQ2PHZrr,
  VCVTDQ2PHZrrb,
  VCVTDQ2PHZrrbk,
  VCVTDQ2PHZrrbkz,
  VCVTDQ2PHZrrk,
  VCVTDQ2PHZrrkz,
  VCVTDQ2PSYrm,
  VCVTDQ2PSYrr,
  VCVTDQ2PSZ128rm,
  VCVTDQ2PSZ128rmb,
  VCVTDQ2PSZ128rmbk,
  VCVTDQ2PSZ128rmbkz,
  VCVTDQ2PSZ128rmk,
  VCVTDQ2PSZ128rmkz,
  VCVTDQ2PSZ128rr,
  VCVTDQ2PSZ128rrk,
  VCVTDQ2PSZ128rrkz,
  VCVTDQ2PSZ256rm,
  VCVTDQ2PSZ256rmb,
  VCVTDQ2PSZ256rmbk,
  VCVTDQ2PSZ256rmbkz,
  VCVTDQ2PSZ256rmk,
  VCVTDQ2PSZ256rmkz,
  VCVTDQ2PSZ256rr,
  VCVTDQ2PSZ256rrk,
  VCVTDQ2PSZ256rrkz,
  VCVTDQ2PSZrm,
  VCVTDQ2PSZrmb,
  VCVTDQ2PSZrmbk,
  VCVTDQ2PSZrmbkz,
  VCVTDQ2PSZrmk,
  VCVTDQ2PSZrmkz,
  VCVTDQ2PSZrr,
  VCVTDQ2PSZrrb,
  VCVTDQ2PSZrrbk,
  VCVTDQ2PSZrrbkz,
  VCVTDQ2PSZrrk,
  VCVTDQ2PSZrrkz,
  VCVTDQ2PSrm,
  VCVTDQ2PSrr,
  VCVTNE2PS2BF16Z128rm,
  VCVTNE2PS2BF16Z128rmb,
  VCVTNE2PS2BF16Z128rmbk,
  VCVTNE2PS2BF16Z128rmbkz,
  VCVTNE2PS2BF16Z128rmk,
  VCVTNE2PS2BF16Z128rmkz,
  VCVTNE2PS2BF16Z128rr,
  VCVTNE2PS2BF16Z128rrk,
  VCVTNE2PS2BF16Z128rrkz,
  VCVTNE2PS2BF16Z256rm,
  VCVTNE2PS2BF16Z256rmb,
  VCVTNE2PS2BF16Z256rmbk,
  VCVTNE2PS2BF16Z256rmbkz,
  VCVTNE2PS2BF16Z256rmk,
  VCVTNE2PS2BF16Z256rmkz,
  VCVTNE2PS2BF16Z256rr,
  VCVTNE2PS2BF16Z256rrk,
  VCVTNE2PS2BF16Z256rrkz,
  VCVTNE2PS2BF16Zrm,
  VCVTNE2PS2BF16Zrmb,
  VCVTNE2PS2BF16Zrmbk,
  VCVTNE2PS2BF16Zrmbkz,
  VCVTNE2PS2BF16Zrmk,
  VCVTNE2PS2BF16Zrmkz,
  VCVTNE2PS2BF16Zrr,
  VCVTNE2PS2BF16Zrrk,
  VCVTNE2PS2BF16Zrrkz,
  VCVTNEEBF162PSYrm,
  VCVTNEEBF162PSrm,
  VCVTNEEPH2PSYrm,
  VCVTNEEPH2PSrm,
  VCVTNEOBF162PSYrm,
  VCVTNEOBF162PSrm,
  VCVTNEOPH2PSYrm,
  VCVTNEOPH2PSrm,
  VCVTNEPS2BF16Yrm,
  VCVTNEPS2BF16Yrr,
  VCVTNEPS2BF16Z128rm,
  VCVTNEPS2BF16Z128rmb,
  VCVTNEPS2BF16Z128rmbk,
  VCVTNEPS2BF16Z128rmbkz,
  VCVTNEPS2BF16Z128rmk,
  VCVTNEPS2BF16Z128rmkz,
  VCVTNEPS2BF16Z128rr,
  VCVTNEPS2BF16Z128rrk,
  VCVTNEPS2BF16Z128rrkz,
  VCVTNEPS2BF16Z256rm,
  VCVTNEPS2BF16Z256rmb,
  VCVTNEPS2BF16Z256rmbk,
  VCVTNEPS2BF16Z256rmbkz,
  VCVTNEPS2BF16Z256rmk,
  VCVTNEPS2BF16Z256rmkz,
  VCVTNEPS2BF16Z256rr,
  VCVTNEPS2BF16Z256rrk,
  VCVTNEPS2BF16Z256rrkz,
  VCVTNEPS2BF16Zrm,
  VCVTNEPS2BF16Zrmb,
  VCVTNEPS2BF16Zrmbk,
  VCVTNEPS2BF16Zrmbkz,
  VCVTNEPS2BF16Zrmk,
  VCVTNEPS2BF16Zrmkz,
  VCVTNEPS2BF16Zrr,
  VCVTNEPS2BF16Zrrk,
  VCVTNEPS2BF16Zrrkz,
  VCVTNEPS2BF16rm,
  VCVTNEPS2BF16rr,
  VCVTPD2DQYrm,
  VCVTPD2DQYrr,
  VCVTPD2DQZ128rm,
  VCVTPD2DQZ128rmb,
  VCVTPD2DQZ128rmbk,
  VCVTPD2DQZ128rmbkz,
  VCVTPD2DQZ128rmk,
  VCVTPD2DQZ128rmkz,
  VCVTPD2DQZ128rr,
  VCVTPD2DQZ128rrk,
  VCVTPD2DQZ128rrkz,
  VCVTPD2DQZ256rm,
  VCVTPD2DQZ256rmb,
  VCVTPD2DQZ256rmbk,
  VCVTPD2DQZ256rmbkz,
  VCVTPD2DQZ256rmk,
  VCVTPD2DQZ256rmkz,
  VCVTPD2DQZ256rr,
  VCVTPD2DQZ256rrk,
  VCVTPD2DQZ256rrkz,
  VCVTPD2DQZrm,
  VCVTPD2DQZrmb,
  VCVTPD2DQZrmbk,
  VCVTPD2DQZrmbkz,
  VCVTPD2DQZrmk,
  VCVTPD2DQZrmkz,
  VCVTPD2DQZrr,
  VCVTPD2DQZrrb,
  VCVTPD2DQZrrbk,
  VCVTPD2DQZrrbkz,
  VCVTPD2DQZrrk,
  VCVTPD2DQZrrkz,
  VCVTPD2DQrm,
  VCVTPD2DQrr,
  VCVTPD2PHZ128rm,
  VCVTPD2PHZ128rmb,
  VCVTPD2PHZ128rmbk,
  VCVTPD2PHZ128rmbkz,
  VCVTPD2PHZ128rmk,
  VCVTPD2PHZ128rmkz,
  VCVTPD2PHZ128rr,
  VCVTPD2PHZ128rrk,
  VCVTPD2PHZ128rrkz,
  VCVTPD2PHZ256rm,
  VCVTPD2PHZ256rmb,
  VCVTPD2PHZ256rmbk,
  VCVTPD2PHZ256rmbkz,
  VCVTPD2PHZ256rmk,
  VCVTPD2PHZ256rmkz,
  VCVTPD2PHZ256rr,
  VCVTPD2PHZ256rrk,
  VCVTPD2PHZ256rrkz,
  VCVTPD2PHZrm,
  VCVTPD2PHZrmb,
  VCVTPD2PHZrmbk,
  VCVTPD2PHZrmbkz,
  VCVTPD2PHZrmk,
  VCVTPD2PHZrmkz,
  VCVTPD2PHZrr,
  VCVTPD2PHZrrb,
  VCVTPD2PHZrrbk,
  VCVTPD2PHZrrbkz,
  VCVTPD2PHZrrk,
  VCVTPD2PHZrrkz,
  VCVTPD2PSYrm,
  VCVTPD2PSYrr,
  VCVTPD2PSZ128rm,
  VCVTPD2PSZ128rmb,
  VCVTPD2PSZ128rmbk,
  VCVTPD2PSZ128rmbkz,
  VCVTPD2PSZ128rmk,
  VCVTPD2PSZ128rmkz,
  VCVTPD2PSZ128rr,
  VCVTPD2PSZ128rrk,
  VCVTPD2PSZ128rrkz,
  VCVTPD2PSZ256rm,
  VCVTPD2PSZ256rmb,
  VCVTPD2PSZ256rmbk,
  VCVTPD2PSZ256rmbkz,
  VCVTPD2PSZ256rmk,
  VCVTPD2PSZ256rmkz,
  VCVTPD2PSZ256rr,
  VCVTPD2PSZ256rrk,
  VCVTPD2PSZ256rrkz,
  VCVTPD2PSZrm,
  VCVTPD2PSZrmb,
  VCVTPD2PSZrmbk,
  VCVTPD2PSZrmbkz,
  VCVTPD2PSZrmk,
  VCVTPD2PSZrmkz,
  VCVTPD2PSZrr,
  VCVTPD2PSZrrb,
  VCVTPD2PSZrrbk,
  VCVTPD2PSZrrbkz,
  VCVTPD2PSZrrk,
  VCVTPD2PSZrrkz,
  VCVTPD2PSrm,
  VCVTPD2PSrr,
  VCVTPD2QQZ128rm,
  VCVTPD2QQZ128rmb,
  VCVTPD2QQZ128rmbk,
  VCVTPD2QQZ128rmbkz,
  VCVTPD2QQZ128rmk,
  VCVTPD2QQZ128rmkz,
  VCVTPD2QQZ128rr,
  VCVTPD2QQZ128rrk,
  VCVTPD2QQZ128rrkz,
  VCVTPD2QQZ256rm,
  VCVTPD2QQZ256rmb,
  VCVTPD2QQZ256rmbk,
  VCVTPD2QQZ256rmbkz,
  VCVTPD2QQZ256rmk,
  VCVTPD2QQZ256rmkz,
  VCVTPD2QQZ256rr,
  VCVTPD2QQZ256rrk,
  VCVTPD2QQZ256rrkz,
  VCVTPD2QQZrm,
  VCVTPD2QQZrmb,
  VCVTPD2QQZrmbk,
  VCVTPD2QQZrmbkz,
  VCVTPD2QQZrmk,
  VCVTPD2QQZrmkz,
  VCVTPD2QQZrr,
  VCVTPD2QQZrrb,
  VCVTPD2QQZrrbk,
  VCVTPD2QQZrrbkz,
  VCVTPD2QQZrrk,
  VCVTPD2QQZrrkz,
  VCVTPD2UDQZ128rm,
  VCVTPD2UDQZ128rmb,
  VCVTPD2UDQZ128rmbk,
  VCVTPD2UDQZ128rmbkz,
  VCVTPD2UDQZ128rmk,
  VCVTPD2UDQZ128rmkz,
  VCVTPD2UDQZ128rr,
  VCVTPD2UDQZ128rrk,
  VCVTPD2UDQZ128rrkz,
  VCVTPD2UDQZ256rm,
  VCVTPD2UDQZ256rmb,
  VCVTPD2UDQZ256rmbk,
  VCVTPD2UDQZ256rmbkz,
  VCVTPD2UDQZ256rmk,
  VCVTPD2UDQZ256rmkz,
  VCVTPD2UDQZ256rr,
  VCVTPD2UDQZ256rrk,
  VCVTPD2UDQZ256rrkz,
  VCVTPD2UDQZrm,
  VCVTPD2UDQZrmb,
  VCVTPD2UDQZrmbk,
  VCVTPD2UDQZrmbkz,
  VCVTPD2UDQZrmk,
  VCVTPD2UDQZrmkz,
  VCVTPD2UDQZrr,
  VCVTPD2UDQZrrb,
  VCVTPD2UDQZrrbk,
  VCVTPD2UDQZrrbkz,
  VCVTPD2UDQZrrk,
  VCVTPD2UDQZrrkz,
  VCVTPD2UQQZ128rm,
  VCVTPD2UQQZ128rmb,
  VCVTPD2UQQZ128rmbk,
  VCVTPD2UQQZ128rmbkz,
  VCVTPD2UQQZ128rmk,
  VCVTPD2UQQZ128rmkz,
  VCVTPD2UQQZ128rr,
  VCVTPD2UQQZ128rrk,
  VCVTPD2UQQZ128rrkz,
  VCVTPD2UQQZ256rm,
  VCVTPD2UQQZ256rmb,
  VCVTPD2UQQZ256rmbk,
  VCVTPD2UQQZ256rmbkz,
  VCVTPD2UQQZ256rmk,
  VCVTPD2UQQZ256rmkz,
  VCVTPD2UQQZ256rr,
  VCVTPD2UQQZ256rrk,
  VCVTPD2UQQZ256rrkz,
  VCVTPD2UQQZrm,
  VCVTPD2UQQZrmb,
  VCVTPD2UQQZrmbk,
  VCVTPD2UQQZrmbkz,
  VCVTPD2UQQZrmk,
  VCVTPD2UQQZrmkz,
  VCVTPD2UQQZrr,
  VCVTPD2UQQZrrb,
  VCVTPD2UQQZrrbk,
  VCVTPD2UQQZrrbkz,
  VCVTPD2UQQZrrk,
  VCVTPD2UQQZrrkz,
  VCVTPH2DQZ128rm,
  VCVTPH2DQZ128rmb,
  VCVTPH2DQZ128rmbk,
  VCVTPH2DQZ128rmbkz,
  VCVTPH2DQZ128rmk,
  VCVTPH2DQZ128rmkz,
  VCVTPH2DQZ128rr,
  VCVTPH2DQZ128rrk,
  VCVTPH2DQZ128rrkz,
  VCVTPH2DQZ256rm,
  VCVTPH2DQZ256rmb,
  VCVTPH2DQZ256rmbk,
  VCVTPH2DQZ256rmbkz,
  VCVTPH2DQZ256rmk,
  VCVTPH2DQZ256rmkz,
  VCVTPH2DQZ256rr,
  VCVTPH2DQZ256rrk,
  VCVTPH2DQZ256rrkz,
  VCVTPH2DQZrm,
  VCVTPH2DQZrmb,
  VCVTPH2DQZrmbk,
  VCVTPH2DQZrmbkz,
  VCVTPH2DQZrmk,
  VCVTPH2DQZrmkz,
  VCVTPH2DQZrr,
  VCVTPH2DQZrrb,
  VCVTPH2DQZrrbk,
  VCVTPH2DQZrrbkz,
  VCVTPH2DQZrrk,
  VCVTPH2DQZrrkz,
  VCVTPH2PDZ128rm,
  VCVTPH2PDZ128rmb,
  VCVTPH2PDZ128rmbk,
  VCVTPH2PDZ128rmbkz,
  VCVTPH2PDZ128rmk,
  VCVTPH2PDZ128rmkz,
  VCVTPH2PDZ128rr,
  VCVTPH2PDZ128rrk,
  VCVTPH2PDZ128rrkz,
  VCVTPH2PDZ256rm,
  VCVTPH2PDZ256rmb,
  VCVTPH2PDZ256rmbk,
  VCVTPH2PDZ256rmbkz,
  VCVTPH2PDZ256rmk,
  VCVTPH2PDZ256rmkz,
  VCVTPH2PDZ256rr,
  VCVTPH2PDZ256rrk,
  VCVTPH2PDZ256rrkz,
  VCVTPH2PDZrm,
  VCVTPH2PDZrmb,
  VCVTPH2PDZrmbk,
  VCVTPH2PDZrmbkz,
  VCVTPH2PDZrmk,
  VCVTPH2PDZrmkz,
  VCVTPH2PDZrr,
  VCVTPH2PDZrrb,
  VCVTPH2PDZrrbk,
  VCVTPH2PDZrrbkz,
  VCVTPH2PDZrrk,
  VCVTPH2PDZrrkz,
  VCVTPH2PSXZ128rm,
  VCVTPH2PSXZ128rmb,
  VCVTPH2PSXZ128rmbk,
  VCVTPH2PSXZ128rmbkz,
  VCVTPH2PSXZ128rmk,
  VCVTPH2PSXZ128rmkz,
  VCVTPH2PSXZ128rr,
  VCVTPH2PSXZ128rrk,
  VCVTPH2PSXZ128rrkz,
  VCVTPH2PSXZ256rm,
  VCVTPH2PSXZ256rmb,
  VCVTPH2PSXZ256rmbk,
  VCVTPH2PSXZ256rmbkz,
  VCVTPH2PSXZ256rmk,
  VCVTPH2PSXZ256rmkz,
  VCVTPH2PSXZ256rr,
  VCVTPH2PSXZ256rrk,
  VCVTPH2PSXZ256rrkz,
  VCVTPH2PSXZrm,
  VCVTPH2PSXZrmb,
  VCVTPH2PSXZrmbk,
  VCVTPH2PSXZrmbkz,
  VCVTPH2PSXZrmk,
  VCVTPH2PSXZrmkz,
  VCVTPH2PSXZrr,
  VCVTPH2PSXZrrb,
  VCVTPH2PSXZrrbk,
  VCVTPH2PSXZrrbkz,
  VCVTPH2PSXZrrk,
  VCVTPH2PSXZrrkz,
  VCVTPH2PSYrm,
  VCVTPH2PSYrr,
  VCVTPH2PSZ128rm,
  VCVTPH2PSZ128rmk,
  VCVTPH2PSZ128rmkz,
  VCVTPH2PSZ128rr,
  VCVTPH2PSZ128rrk,
  VCVTPH2PSZ128rrkz,
  VCVTPH2PSZ256rm,
  VCVTPH2PSZ256rmk,
  VCVTPH2PSZ256rmkz,
  VCVTPH2PSZ256rr,
  VCVTPH2PSZ256rrk,
  VCVTPH2PSZ256rrkz,
  VCVTPH2PSZrm,
  VCVTPH2PSZrmk,
  VCVTPH2PSZrmkz,
  VCVTPH2PSZrr,
  VCVTPH2PSZrrb,
  VCVTPH2PSZrrbk,
  VCVTPH2PSZrrbkz,
  VCVTPH2PSZrrk,
  VCVTPH2PSZrrkz,
  VCVTPH2PSrm,
  VCVTPH2PSrr,
  VCVTPH2QQZ128rm,
  VCVTPH2QQZ128rmb,
  VCVTPH2QQZ128rmbk,
  VCVTPH2QQZ128rmbkz,
  VCVTPH2QQZ128rmk,
  VCVTPH2QQZ128rmkz,
  VCVTPH2QQZ128rr,
  VCVTPH2QQZ128rrk,
  VCVTPH2QQZ128rrkz,
  VCVTPH2QQZ256rm,
  VCVTPH2QQZ256rmb,
  VCVTPH2QQZ256rmbk,
  VCVTPH2QQZ256rmbkz,
  VCVTPH2QQZ256rmk,
  VCVTPH2QQZ256rmkz,
  VCVTPH2QQZ256rr,
  VCVTPH2QQZ256rrk,
  VCVTPH2QQZ256rrkz,
  VCVTPH2QQZrm,
  VCVTPH2QQZrmb,
  VCVTPH2QQZrmbk,
  VCVTPH2QQZrmbkz,
  VCVTPH2QQZrmk,
  VCVTPH2QQZrmkz,
  VCVTPH2QQZrr,
  VCVTPH2QQZrrb,
  VCVTPH2QQZrrbk,
  VCVTPH2QQZrrbkz,
  VCVTPH2QQZrrk,
  VCVTPH2QQZrrkz,
  VCVTPH2UDQZ128rm,
  VCVTPH2UDQZ128rmb,
  VCVTPH2UDQZ128rmbk,
  VCVTPH2UDQZ128rmbkz,
  VCVTPH2UDQZ128rmk,
  VCVTPH2UDQZ128rmkz,
  VCVTPH2UDQZ128rr,
  VCVTPH2UDQZ128rrk,
  VCVTPH2UDQZ128rrkz,
  VCVTPH2UDQZ256rm,
  VCVTPH2UDQZ256rmb,
  VCVTPH2UDQZ256rmbk,
  VCVTPH2UDQZ256rmbkz,
  VCVTPH2UDQZ256rmk,
  VCVTPH2UDQZ256rmkz,
  VCVTPH2UDQZ256rr,
  VCVTPH2UDQZ256rrk,
  VCVTPH2UDQZ256rrkz,
  VCVTPH2UDQZrm,
  VCVTPH2UDQZrmb,
  VCVTPH2UDQZrmbk,
  VCVTPH2UDQZrmbkz,
  VCVTPH2UDQZrmk,
  VCVTPH2UDQZrmkz,
  VCVTPH2UDQZrr,
  VCVTPH2UDQZrrb,
  VCVTPH2UDQZrrbk,
  VCVTPH2UDQZrrbkz,
  VCVTPH2UDQZrrk,
  VCVTPH2UDQZrrkz,
  VCVTPH2UQQZ128rm,
  VCVTPH2UQQZ128rmb,
  VCVTPH2UQQZ128rmbk,
  VCVTPH2UQQZ128rmbkz,
  VCVTPH2UQQZ128rmk,
  VCVTPH2UQQZ128rmkz,
  VCVTPH2UQQZ128rr,
  VCVTPH2UQQZ128rrk,
  VCVTPH2UQQZ128rrkz,
  VCVTPH2UQQZ256rm,
  VCVTPH2UQQZ256rmb,
  VCVTPH2UQQZ256rmbk,
  VCVTPH2UQQZ256rmbkz,
  VCVTPH2UQQZ256rmk,
  VCVTPH2UQQZ256rmkz,
  VCVTPH2UQQZ256rr,
  VCVTPH2UQQZ256rrk,
  VCVTPH2UQQZ256rrkz,
  VCVTPH2UQQZrm,
  VCVTPH2UQQZrmb,
  VCVTPH2UQQZrmbk,
  VCVTPH2UQQZrmbkz,
  VCVTPH2UQQZrmk,
  VCVTPH2UQQZrmkz,
  VCVTPH2UQQZrr,
  VCVTPH2UQQZrrb,
  VCVTPH2UQQZrrbk,
  VCVTPH2UQQZrrbkz,
  VCVTPH2UQQZrrk,
  VCVTPH2UQQZrrkz,
  VCVTPH2UWZ128rm,
  VCVTPH2UWZ128rmb,
  VCVTPH2UWZ128rmbk,
  VCVTPH2UWZ128rmbkz,
  VCVTPH2UWZ128rmk,
  VCVTPH2UWZ128rmkz,
  VCVTPH2UWZ128rr,
  VCVTPH2UWZ128rrk,
  VCVTPH2UWZ128rrkz,
  VCVTPH2UWZ256rm,
  VCVTPH2UWZ256rmb,
  VCVTPH2UWZ256rmbk,
  VCVTPH2UWZ256rmbkz,
  VCVTPH2UWZ256rmk,
  VCVTPH2UWZ256rmkz,
  VCVTPH2UWZ256rr,
  VCVTPH2UWZ256rrk,
  VCVTPH2UWZ256rrkz,
  VCVTPH2UWZrm,
  VCVTPH2UWZrmb,
  VCVTPH2UWZrmbk,
  VCVTPH2UWZrmbkz,
  VCVTPH2UWZrmk,
  VCVTPH2UWZrmkz,
  VCVTPH2UWZrr,
  VCVTPH2UWZrrb,
  VCVTPH2UWZrrbk,
  VCVTPH2UWZrrbkz,
  VCVTPH2UWZrrk,
  VCVTPH2UWZrrkz,
  VCVTPH2WZ128rm,
  VCVTPH2WZ128rmb,
  VCVTPH2WZ128rmbk,
  VCVTPH2WZ128rmbkz,
  VCVTPH2WZ128rmk,
  VCVTPH2WZ128rmkz,
  VCVTPH2WZ128rr,
  VCVTPH2WZ128rrk,
  VCVTPH2WZ128rrkz,
  VCVTPH2WZ256rm,
  VCVTPH2WZ256rmb,
  VCVTPH2WZ256rmbk,
  VCVTPH2WZ256rmbkz,
  VCVTPH2WZ256rmk,
  VCVTPH2WZ256rmkz,
  VCVTPH2WZ256rr,
  VCVTPH2WZ256rrk,
  VCVTPH2WZ256rrkz,
  VCVTPH2WZrm,
  VCVTPH2WZrmb,
  VCVTPH2WZrmbk,
  VCVTPH2WZrmbkz,
  VCVTPH2WZrmk,
  VCVTPH2WZrmkz,
  VCVTPH2WZrr,
  VCVTPH2WZrrb,
  VCVTPH2WZrrbk,
  VCVTPH2WZrrbkz,
  VCVTPH2WZrrk,
  VCVTPH2WZrrkz,
  VCVTPS2DQYrm,
  VCVTPS2DQYrr,
  VCVTPS2DQZ128rm,
  VCVTPS2DQZ128rmb,
  VCVTPS2DQZ128rmbk,
  VCVTPS2DQZ128rmbkz,
  VCVTPS2DQZ128rmk,
  VCVTPS2DQZ128rmkz,
  VCVTPS2DQZ128rr,
  VCVTPS2DQZ128rrk,
  VCVTPS2DQZ128rrkz,
  VCVTPS2DQZ256rm,
  VCVTPS2DQZ256rmb,
  VCVTPS2DQZ256rmbk,
  VCVTPS2DQZ256rmbkz,
  VCVTPS2DQZ256rmk,
  VCVTPS2DQZ256rmkz,
  VCVTPS2DQZ256rr,
  VCVTPS2DQZ256rrk,
  VCVTPS2DQZ256rrkz,
  VCVTPS2DQZrm,
  VCVTPS2DQZrmb,
  VCVTPS2DQZrmbk,
  VCVTPS2DQZrmbkz,
  VCVTPS2DQZrmk,
  VCVTPS2DQZrmkz,
  VCVTPS2DQZrr,
  VCVTPS2DQZrrb,
  VCVTPS2DQZrrbk,
  VCVTPS2DQZrrbkz,
  VCVTPS2DQZrrk,
  VCVTPS2DQZrrkz,
  VCVTPS2DQrm,
  VCVTPS2DQrr,
  VCVTPS2PDYrm,
  VCVTPS2PDYrr,
  VCVTPS2PDZ128rm,
  VCVTPS2PDZ128rmb,
  VCVTPS2PDZ128rmbk,
  VCVTPS2PDZ128rmbkz,
  VCVTPS2PDZ128rmk,
  VCVTPS2PDZ128rmkz,
  VCVTPS2PDZ128rr,
  VCVTPS2PDZ128rrk,
  VCVTPS2PDZ128rrkz,
  VCVTPS2PDZ256rm,
  VCVTPS2PDZ256rmb,
  VCVTPS2PDZ256rmbk,
  VCVTPS2PDZ256rmbkz,
  VCVTPS2PDZ256rmk,
  VCVTPS2PDZ256rmkz,
  VCVTPS2PDZ256rr,
  VCVTPS2PDZ256rrk,
  VCVTPS2PDZ256rrkz,
  VCVTPS2PDZrm,
  VCVTPS2PDZrmb,
  VCVTPS2PDZrmbk,
  VCVTPS2PDZrmbkz,
  VCVTPS2PDZrmk,
  VCVTPS2PDZrmkz,
  VCVTPS2PDZrr,
  VCVTPS2PDZrrb,
  VCVTPS2PDZrrbk,
  VCVTPS2PDZrrbkz,
  VCVTPS2PDZrrk,
  VCVTPS2PDZrrkz,
  VCVTPS2PDrm,
  VCVTPS2PDrr,
  VCVTPS2PHXZ128rm,
  VCVTPS2PHXZ128rmb,
  VCVTPS2PHXZ128rmbk,
  VCVTPS2PHXZ128rmbkz,
  VCVTPS2PHXZ128rmk,
  VCVTPS2PHXZ128rmkz,
  VCVTPS2PHXZ128rr,
  VCVTPS2PHXZ128rrk,
  VCVTPS2PHXZ128rrkz,
  VCVTPS2PHXZ256rm,
  VCVTPS2PHXZ256rmb,
  VCVTPS2PHXZ256rmbk,
  VCVTPS2PHXZ256rmbkz,
  VCVTPS2PHXZ256rmk,
  VCVTPS2PHXZ256rmkz,
  VCVTPS2PHXZ256rr,
  VCVTPS2PHXZ256rrk,
  VCVTPS2PHXZ256rrkz,
  VCVTPS2PHXZrm,
  VCVTPS2PHXZrmb,
  VCVTPS2PHXZrmbk,
  VCVTPS2PHXZrmbkz,
  VCVTPS2PHXZrmk,
  VCVTPS2PHXZrmkz,
  VCVTPS2PHXZrr,
  VCVTPS2PHXZrrb,
  VCVTPS2PHXZrrbk,
  VCVTPS2PHXZrrbkz,
  VCVTPS2PHXZrrk,
  VCVTPS2PHXZrrkz,
  VCVTPS2PHYmr,
  VCVTPS2PHYrr,
  VCVTPS2PHZ128mr,
  VCVTPS2PHZ128mrk,
  VCVTPS2PHZ128rr,
  VCVTPS2PHZ128rrk,
  VCVTPS2PHZ128rrkz,
  VCVTPS2PHZ256mr,
  VCVTPS2PHZ256mrk,
  VCVTPS2PHZ256rr,
  VCVTPS2PHZ256rrk,
  VCVTPS2PHZ256rrkz,
  VCVTPS2PHZmr,
  VCVTPS2PHZmrk,
  VCVTPS2PHZrr,
  VCVTPS2PHZrrb,
  VCVTPS2PHZrrbk,
  VCVTPS2PHZrrbkz,
  VCVTPS2PHZrrk,
  VCVTPS2PHZrrkz,
  VCVTPS2PHmr,
  VCVTPS2PHrr,
  VCVTPS2QQZ128rm,
  VCVTPS2QQZ128rmb,
  VCVTPS2QQZ128rmbk,
  VCVTPS2QQZ128rmbkz,
  VCVTPS2QQZ128rmk,
  VCVTPS2QQZ128rmkz,
  VCVTPS2QQZ128rr,
  VCVTPS2QQZ128rrk,
  VCVTPS2QQZ128rrkz,
  VCVTPS2QQZ256rm,
  VCVTPS2QQZ256rmb,
  VCVTPS2QQZ256rmbk,
  VCVTPS2QQZ256rmbkz,
  VCVTPS2QQZ256rmk,
  VCVTPS2QQZ256rmkz,
  VCVTPS2QQZ256rr,
  VCVTPS2QQZ256rrk,
  VCVTPS2QQZ256rrkz,
  VCVTPS2QQZrm,
  VCVTPS2QQZrmb,
  VCVTPS2QQZrmbk,
  VCVTPS2QQZrmbkz,
  VCVTPS2QQZrmk,
  VCVTPS2QQZrmkz,
  VCVTPS2QQZrr,
  VCVTPS2QQZrrb,
  VCVTPS2QQZrrbk,
  VCVTPS2QQZrrbkz,
  VCVTPS2QQZrrk,
  VCVTPS2QQZrrkz,
  VCVTPS2UDQZ128rm,
  VCVTPS2UDQZ128rmb,
  VCVTPS2UDQZ128rmbk,
  VCVTPS2UDQZ128rmbkz,
  VCVTPS2UDQZ128rmk,
  VCVTPS2UDQZ128rmkz,
  VCVTPS2UDQZ128rr,
  VCVTPS2UDQZ128rrk,
  VCVTPS2UDQZ128rrkz,
  VCVTPS2UDQZ256rm,
  VCVTPS2UDQZ256rmb,
  VCVTPS2UDQZ256rmbk,
  VCVTPS2UDQZ256rmbkz,
  VCVTPS2UDQZ256rmk,
  VCVTPS2UDQZ256rmkz,
  VCVTPS2UDQZ256rr,
  VCVTPS2UDQZ256rrk,
  VCVTPS2UDQZ256rrkz,
  VCVTPS2UDQZrm,
  VCVTPS2UDQZrmb,
  VCVTPS2UDQZrmbk,
  VCVTPS2UDQZrmbkz,
  VCVTPS2UDQZrmk,
  VCVTPS2UDQZrmkz,
  VCVTPS2UDQZrr,
  VCVTPS2UDQZrrb,
  VCVTPS2UDQZrrbk,
  VCVTPS2UDQZrrbkz,
  VCVTPS2UDQZrrk,
  VCVTPS2UDQZrrkz,
  VCVTPS2UQQZ128rm,
  VCVTPS2UQQZ128rmb,
  VCVTPS2UQQZ128rmbk,
  VCVTPS2UQQZ128rmbkz,
  VCVTPS2UQQZ128rmk,
  VCVTPS2UQQZ128rmkz,
  VCVTPS2UQQZ128rr,
  VCVTPS2UQQZ128rrk,
  VCVTPS2UQQZ128rrkz,
  VCVTPS2UQQZ256rm,
  VCVTPS2UQQZ256rmb,
  VCVTPS2UQQZ256rmbk,
  VCVTPS2UQQZ256rmbkz,
  VCVTPS2UQQZ256rmk,
  VCVTPS2UQQZ256rmkz,
  VCVTPS2UQQZ256rr,
  VCVTPS2UQQZ256rrk,
  VCVTPS2UQQZ256rrkz,
  VCVTPS2UQQZrm,
  VCVTPS2UQQZrmb,
  VCVTPS2UQQZrmbk,
  VCVTPS2UQQZrmbkz,
  VCVTPS2UQQZrmk,
  VCVTPS2UQQZrmkz,
  VCVTPS2UQQZrr,
  VCVTPS2UQQZrrb,
  VCVTPS2UQQZrrbk,
  VCVTPS2UQQZrrbkz,
  VCVTPS2UQQZrrk,
  VCVTPS2UQQZrrkz,
  VCVTQQ2PDZ128rm,
  VCVTQQ2PDZ128rmb,
  VCVTQQ2PDZ128rmbk,
  VCVTQQ2PDZ128rmbkz,
  VCVTQQ2PDZ128rmk,
  VCVTQQ2PDZ128rmkz,
  VCVTQQ2PDZ128rr,
  VCVTQQ2PDZ128rrk,
  VCVTQQ2PDZ128rrkz,
  VCVTQQ2PDZ256rm,
  VCVTQQ2PDZ256rmb,
  VCVTQQ2PDZ256rmbk,
  VCVTQQ2PDZ256rmbkz,
  VCVTQQ2PDZ256rmk,
  VCVTQQ2PDZ256rmkz,
  VCVTQQ2PDZ256rr,
  VCVTQQ2PDZ256rrk,
  VCVTQQ2PDZ256rrkz,
  VCVTQQ2PDZrm,
  VCVTQQ2PDZrmb,
  VCVTQQ2PDZrmbk,
  VCVTQQ2PDZrmbkz,
  VCVTQQ2PDZrmk,
  VCVTQQ2PDZrmkz,
  VCVTQQ2PDZrr,
  VCVTQQ2PDZrrb,
  VCVTQQ2PDZrrbk,
  VCVTQQ2PDZrrbkz,
  VCVTQQ2PDZrrk,
  VCVTQQ2PDZrrkz,
  VCVTQQ2PHZ128rm,
  VCVTQQ2PHZ128rmb,
  VCVTQQ2PHZ128rmbk,
  VCVTQQ2PHZ128rmbkz,
  VCVTQQ2PHZ128rmk,
  VCVTQQ2PHZ128rmkz,
  VCVTQQ2PHZ128rr,
  VCVTQQ2PHZ128rrk,
  VCVTQQ2PHZ128rrkz,
  VCVTQQ2PHZ256rm,
  VCVTQQ2PHZ256rmb,
  VCVTQQ2PHZ256rmbk,
  VCVTQQ2PHZ256rmbkz,
  VCVTQQ2PHZ256rmk,
  VCVTQQ2PHZ256rmkz,
  VCVTQQ2PHZ256rr,
  VCVTQQ2PHZ256rrk,
  VCVTQQ2PHZ256rrkz,
  VCVTQQ2PHZrm,
  VCVTQQ2PHZrmb,
  VCVTQQ2PHZrmbk,
  VCVTQQ2PHZrmbkz,
  VCVTQQ2PHZrmk,
  VCVTQQ2PHZrmkz,
  VCVTQQ2PHZrr,
  VCVTQQ2PHZrrb,
  VCVTQQ2PHZrrbk,
  VCVTQQ2PHZrrbkz,
  VCVTQQ2PHZrrk,
  VCVTQQ2PHZrrkz,
  VCVTQQ2PSZ128rm,
  VCVTQQ2PSZ128rmb,
  VCVTQQ2PSZ128rmbk,
  VCVTQQ2PSZ128rmbkz,
  VCVTQQ2PSZ128rmk,
  VCVTQQ2PSZ128rmkz,
  VCVTQQ2PSZ128rr,
  VCVTQQ2PSZ128rrk,
  VCVTQQ2PSZ128rrkz,
  VCVTQQ2PSZ256rm,
  VCVTQQ2PSZ256rmb,
  VCVTQQ2PSZ256rmbk,
  VCVTQQ2PSZ256rmbkz,
  VCVTQQ2PSZ256rmk,
  VCVTQQ2PSZ256rmkz,
  VCVTQQ2PSZ256rr,
  VCVTQQ2PSZ256rrk,
  VCVTQQ2PSZ256rrkz,
  VCVTQQ2PSZrm,
  VCVTQQ2PSZrmb,
  VCVTQQ2PSZrmbk,
  VCVTQQ2PSZrmbkz,
  VCVTQQ2PSZrmk,
  VCVTQQ2PSZrmkz,
  VCVTQQ2PSZrr,
  VCVTQQ2PSZrrb,
  VCVTQQ2PSZrrbk,
  VCVTQQ2PSZrrbkz,
  VCVTQQ2PSZrrk,
  VCVTQQ2PSZrrkz,
  VCVTSD2SHZrm,
  VCVTSD2SHZrm_Int,
  VCVTSD2SHZrm_Intk,
  VCVTSD2SHZrm_Intkz,
  VCVTSD2SHZrr,
  VCVTSD2SHZrr_Int,
  VCVTSD2SHZrr_Intk,
  VCVTSD2SHZrr_Intkz,
  VCVTSD2SHZrrb_Int,
  VCVTSD2SHZrrb_Intk,
  VCVTSD2SHZrrb_Intkz,
  VCVTSD2SI64Zrm,
  VCVTSD2SI64Zrm_Int,
  VCVTSD2SI64Zrr,
  VCVTSD2SI64Zrr_Int,
  VCVTSD2SI64Zrrb_Int,
  VCVTSD2SI64rm,
  VCVTSD2SI64rm_Int,
  VCVTSD2SI64rr,
  VCVTSD2SI64rr_Int,
  VCVTSD2SIZrm,
  VCVTSD2SIZrm_Int,
  VCVTSD2SIZrr,
  VCVTSD2SIZrr_Int,
  VCVTSD2SIZrrb_Int,
  VCVTSD2SIrm,
  VCVTSD2SIrm_Int,
  VCVTSD2SIrr,
  VCVTSD2SIrr_Int,
  VCVTSD2SSZrm,
  VCVTSD2SSZrm_Int,
  VCVTSD2SSZrm_Intk,
  VCVTSD2SSZrm_Intkz,
  VCVTSD2SSZrr,
  VCVTSD2SSZrr_Int,
  VCVTSD2SSZrr_Intk,
  VCVTSD2SSZrr_Intkz,
  VCVTSD2SSZrrb_Int,
  VCVTSD2SSZrrb_Intk,
  VCVTSD2SSZrrb_Intkz,
  VCVTSD2SSrm,
  VCVTSD2SSrm_Int,
  VCVTSD2SSrr,
  VCVTSD2SSrr_Int,
  VCVTSD2USI64Zrm_Int,
  VCVTSD2USI64Zrr_Int,
  VCVTSD2USI64Zrrb_Int,
  VCVTSD2USIZrm_Int,
  VCVTSD2USIZrr_Int,
  VCVTSD2USIZrrb_Int,
  VCVTSH2SDZrm,
  VCVTSH2SDZrm_Int,
  VCVTSH2SDZrm_Intk,
  VCVTSH2SDZrm_Intkz,
  VCVTSH2SDZrr,
  VCVTSH2SDZrr_Int,
  VCVTSH2SDZrr_Intk,
  VCVTSH2SDZrr_Intkz,
  VCVTSH2SDZrrb_Int,
  VCVTSH2SDZrrb_Intk,
  VCVTSH2SDZrrb_Intkz,
  VCVTSH2SI64Zrm_Int,
  VCVTSH2SI64Zrr_Int,
  VCVTSH2SI64Zrrb_Int,
  VCVTSH2SIZrm_Int,
  VCVTSH2SIZrr_Int,
  VCVTSH2SIZrrb_Int,
  VCVTSH2SSZrm,
  VCVTSH2SSZrm_Int,
  VCVTSH2SSZrm_Intk,
  VCVTSH2SSZrm_Intkz,
  VCVTSH2SSZrr,
  VCVTSH2SSZrr_Int,
  VCVTSH2SSZrr_Intk,
  VCVTSH2SSZrr_Intkz,
  VCVTSH2SSZrrb_Int,
  VCVTSH2SSZrrb_Intk,
  VCVTSH2SSZrrb_Intkz,
  VCVTSH2USI64Zrm_Int,
  VCVTSH2USI64Zrr_Int,
  VCVTSH2USI64Zrrb_Int,
  VCVTSH2USIZrm_Int,
  VCVTSH2USIZrr_Int,
  VCVTSH2USIZrrb_Int,
  VCVTSI2SDZrm,
  VCVTSI2SDZrm_Int,
  VCVTSI2SDZrr,
  VCVTSI2SDZrr_Int,
  VCVTSI2SDrm,
  VCVTSI2SDrm_Int,
  VCVTSI2SDrr,
  VCVTSI2SDrr_Int,
  VCVTSI2SHZrm,
  VCVTSI2SHZrm_Int,
  VCVTSI2SHZrr,
  VCVTSI2SHZrr_Int,
  VCVTSI2SHZrrb_Int,
  VCVTSI2SSZrm,
  VCVTSI2SSZrm_Int,
  VCVTSI2SSZrr,
  VCVTSI2SSZrr_Int,
  VCVTSI2SSZrrb_Int,
  VCVTSI2SSrm,
  VCVTSI2SSrm_Int,
  VCVTSI2SSrr,
  VCVTSI2SSrr_Int,
  VCVTSI642SDZrm,
  VCVTSI642SDZrm_Int,
  VCVTSI642SDZrr,
  VCVTSI642SDZrr_Int,
  VCVTSI642SDZrrb_Int,
  VCVTSI642SDrm,
  VCVTSI642SDrm_Int,
  VCVTSI642SDrr,
  VCVTSI642SDrr_Int,
  VCVTSI642SHZrm,
  VCVTSI642SHZrm_Int,
  VCVTSI642SHZrr,
  VCVTSI642SHZrr_Int,
  VCVTSI642SHZrrb_Int,
  VCVTSI642SSZrm,
  VCVTSI642SSZrm_Int,
  VCVTSI642SSZrr,
  VCVTSI642SSZrr_Int,
  VCVTSI642SSZrrb_Int,
  VCVTSI642SSrm,
  VCVTSI642SSrm_Int,
  VCVTSI642SSrr,
  VCVTSI642SSrr_Int,
  VCVTSS2SDZrm,
  VCVTSS2SDZrm_Int,
  VCVTSS2SDZrm_Intk,
  VCVTSS2SDZrm_Intkz,
  VCVTSS2SDZrr,
  VCVTSS2SDZrr_Int,
  VCVTSS2SDZrr_Intk,
  VCVTSS2SDZrr_Intkz,
  VCVTSS2SDZrrb_Int,
  VCVTSS2SDZrrb_Intk,
  VCVTSS2SDZrrb_Intkz,
  VCVTSS2SDrm,
  VCVTSS2SDrm_Int,
  VCVTSS2SDrr,
  VCVTSS2SDrr_Int,
  VCVTSS2SHZrm,
  VCVTSS2SHZrm_Int,
  VCVTSS2SHZrm_Intk,
  VCVTSS2SHZrm_Intkz,
  VCVTSS2SHZrr,
  VCVTSS2SHZrr_Int,
  VCVTSS2SHZrr_Intk,
  VCVTSS2SHZrr_Intkz,
  VCVTSS2SHZrrb_Int,
  VCVTSS2SHZrrb_Intk,
  VCVTSS2SHZrrb_Intkz,
  VCVTSS2SI64Zrm,
  VCVTSS2SI64Zrm_Int,
  VCVTSS2SI64Zrr,
  VCVTSS2SI64Zrr_Int,
  VCVTSS2SI64Zrrb_Int,
  VCVTSS2SI64rm,
  VCVTSS2SI64rm_Int,
  VCVTSS2SI64rr,
  VCVTSS2SI64rr_Int,
  VCVTSS2SIZrm,
  VCVTSS2SIZrm_Int,
  VCVTSS2SIZrr,
  VCVTSS2SIZrr_Int,
  VCVTSS2SIZrrb_Int,
  VCVTSS2SIrm,
  VCVTSS2SIrm_Int,
  VCVTSS2SIrr,
  VCVTSS2SIrr_Int,
  VCVTSS2USI64Zrm_Int,
  VCVTSS2USI64Zrr_Int,
  VCVTSS2USI64Zrrb_Int,
  VCVTSS2USIZrm_Int,
  VCVTSS2USIZrr_Int,
  VCVTSS2USIZrrb_Int,
  VCVTTPD2DQYrm,
  VCVTTPD2DQYrr,
  VCVTTPD2DQZ128rm,
  VCVTTPD2DQZ128rmb,
  VCVTTPD2DQZ128rmbk,
  VCVTTPD2DQZ128rmbkz,
  VCVTTPD2DQZ128rmk,
  VCVTTPD2DQZ128rmkz,
  VCVTTPD2DQZ128rr,
  VCVTTPD2DQZ128rrk,
  VCVTTPD2DQZ128rrkz,
  VCVTTPD2DQZ256rm,
  VCVTTPD2DQZ256rmb,
  VCVTTPD2DQZ256rmbk,
  VCVTTPD2DQZ256rmbkz,
  VCVTTPD2DQZ256rmk,
  VCVTTPD2DQZ256rmkz,
  VCVTTPD2DQZ256rr,
  VCVTTPD2DQZ256rrk,
  VCVTTPD2DQZ256rrkz,
  VCVTTPD2DQZrm,
  VCVTTPD2DQZrmb,
  VCVTTPD2DQZrmbk,
  VCVTTPD2DQZrmbkz,
  VCVTTPD2DQZrmk,
  VCVTTPD2DQZrmkz,
  VCVTTPD2DQZrr,
  VCVTTPD2DQZrrb,
  VCVTTPD2DQZrrbk,
  VCVTTPD2DQZrrbkz,
  VCVTTPD2DQZrrk,
  VCVTTPD2DQZrrkz,
  VCVTTPD2DQrm,
  VCVTTPD2DQrr,
  VCVTTPD2QQZ128rm,
  VCVTTPD2QQZ128rmb,
  VCVTTPD2QQZ128rmbk,
  VCVTTPD2QQZ128rmbkz,
  VCVTTPD2QQZ128rmk,
  VCVTTPD2QQZ128rmkz,
  VCVTTPD2QQZ128rr,
  VCVTTPD2QQZ128rrk,
  VCVTTPD2QQZ128rrkz,
  VCVTTPD2QQZ256rm,
  VCVTTPD2QQZ256rmb,
  VCVTTPD2QQZ256rmbk,
  VCVTTPD2QQZ256rmbkz,
  VCVTTPD2QQZ256rmk,
  VCVTTPD2QQZ256rmkz,
  VCVTTPD2QQZ256rr,
  VCVTTPD2QQZ256rrk,
  VCVTTPD2QQZ256rrkz,
  VCVTTPD2QQZrm,
  VCVTTPD2QQZrmb,
  VCVTTPD2QQZrmbk,
  VCVTTPD2QQZrmbkz,
  VCVTTPD2QQZrmk,
  VCVTTPD2QQZrmkz,
  VCVTTPD2QQZrr,
  VCVTTPD2QQZrrb,
  VCVTTPD2QQZrrbk,
  VCVTTPD2QQZrrbkz,
  VCVTTPD2QQZrrk,
  VCVTTPD2QQZrrkz,
  VCVTTPD2UDQZ128rm,
  VCVTTPD2UDQZ128rmb,
  VCVTTPD2UDQZ128rmbk,
  VCVTTPD2UDQZ128rmbkz,
  VCVTTPD2UDQZ128rmk,
  VCVTTPD2UDQZ128rmkz,
  VCVTTPD2UDQZ128rr,
  VCVTTPD2UDQZ128rrk,
  VCVTTPD2UDQZ128rrkz,
  VCVTTPD2UDQZ256rm,
  VCVTTPD2UDQZ256rmb,
  VCVTTPD2UDQZ256rmbk,
  VCVTTPD2UDQZ256rmbkz,
  VCVTTPD2UDQZ256rmk,
  VCVTTPD2UDQZ256rmkz,
  VCVTTPD2UDQZ256rr,
  VCVTTPD2UDQZ256rrk,
  VCVTTPD2UDQZ256rrkz,
  VCVTTPD2UDQZrm,
  VCVTTPD2UDQZrmb,
  VCVTTPD2UDQZrmbk,
  VCVTTPD2UDQZrmbkz,
  VCVTTPD2UDQZrmk,
  VCVTTPD2UDQZrmkz,
  VCVTTPD2UDQZrr,
  VCVTTPD2UDQZrrb,
  VCVTTPD2UDQZrrbk,
  VCVTTPD2UDQZrrbkz,
  VCVTTPD2UDQZrrk,
  VCVTTPD2UDQZrrkz,
  VCVTTPD2UQQZ128rm,
  VCVTTPD2UQQZ128rmb,
  VCVTTPD2UQQZ128rmbk,
  VCVTTPD2UQQZ128rmbkz,
  VCVTTPD2UQQZ128rmk,
  VCVTTPD2UQQZ128rmkz,
  VCVTTPD2UQQZ128rr,
  VCVTTPD2UQQZ128rrk,
  VCVTTPD2UQQZ128rrkz,
  VCVTTPD2UQQZ256rm,
  VCVTTPD2UQQZ256rmb,
  VCVTTPD2UQQZ256rmbk,
  VCVTTPD2UQQZ256rmbkz,
  VCVTTPD2UQQZ256rmk,
  VCVTTPD2UQQZ256rmkz,
  VCVTTPD2UQQZ256rr,
  VCVTTPD2UQQZ256rrk,
  VCVTTPD2UQQZ256rrkz,
  VCVTTPD2UQQZrm,
  VCVTTPD2UQQZrmb,
  VCVTTPD2UQQZrmbk,
  VCVTTPD2UQQZrmbkz,
  VCVTTPD2UQQZrmk,
  VCVTTPD2UQQZrmkz,
  VCVTTPD2UQQZrr,
  VCVTTPD2UQQZrrb,
  VCVTTPD2UQQZrrbk,
  VCVTTPD2UQQZrrbkz,
  VCVTTPD2UQQZrrk,
  VCVTTPD2UQQZrrkz,
  VCVTTPH2DQZ128rm,
  VCVTTPH2DQZ128rmb,
  VCVTTPH2DQZ128rmbk,
  VCVTTPH2DQZ128rmbkz,
  VCVTTPH2DQZ128rmk,
  VCVTTPH2DQZ128rmkz,
  VCVTTPH2DQZ128rr,
  VCVTTPH2DQZ128rrk,
  VCVTTPH2DQZ128rrkz,
  VCVTTPH2DQZ256rm,
  VCVTTPH2DQZ256rmb,
  VCVTTPH2DQZ256rmbk,
  VCVTTPH2DQZ256rmbkz,
  VCVTTPH2DQZ256rmk,
  VCVTTPH2DQZ256rmkz,
  VCVTTPH2DQZ256rr,
  VCVTTPH2DQZ256rrk,
  VCVTTPH2DQZ256rrkz,
  VCVTTPH2DQZrm,
  VCVTTPH2DQZrmb,
  VCVTTPH2DQZrmbk,
  VCVTTPH2DQZrmbkz,
  VCVTTPH2DQZrmk,
  VCVTTPH2DQZrmkz,
  VCVTTPH2DQZrr,
  VCVTTPH2DQZrrb,
  VCVTTPH2DQZrrbk,
  VCVTTPH2DQZrrbkz,
  VCVTTPH2DQZrrk,
  VCVTTPH2DQZrrkz,
  VCVTTPH2QQZ128rm,
  VCVTTPH2QQZ128rmb,
  VCVTTPH2QQZ128rmbk,
  VCVTTPH2QQZ128rmbkz,
  VCVTTPH2QQZ128rmk,
  VCVTTPH2QQZ128rmkz,
  VCVTTPH2QQZ128rr,
  VCVTTPH2QQZ128rrk,
  VCVTTPH2QQZ128rrkz,
  VCVTTPH2QQZ256rm,
  VCVTTPH2QQZ256rmb,
  VCVTTPH2QQZ256rmbk,
  VCVTTPH2QQZ256rmbkz,
  VCVTTPH2QQZ256rmk,
  VCVTTPH2QQZ256rmkz,
  VCVTTPH2QQZ256rr,
  VCVTTPH2QQZ256rrk,
  VCVTTPH2QQZ256rrkz,
  VCVTTPH2QQZrm,
  VCVTTPH2QQZrmb,
  VCVTTPH2QQZrmbk,
  VCVTTPH2QQZrmbkz,
  VCVTTPH2QQZrmk,
  VCVTTPH2QQZrmkz,
  VCVTTPH2QQZrr,
  VCVTTPH2QQZrrb,
  VCVTTPH2QQZrrbk,
  VCVTTPH2QQZrrbkz,
  VCVTTPH2QQZrrk,
  VCVTTPH2QQZrrkz,
  VCVTTPH2UDQZ128rm,
  VCVTTPH2UDQZ128rmb,
  VCVTTPH2UDQZ128rmbk,
  VCVTTPH2UDQZ128rmbkz,
  VCVTTPH2UDQZ128rmk,
  VCVTTPH2UDQZ128rmkz,
  VCVTTPH2UDQZ128rr,
  VCVTTPH2UDQZ128rrk,
  VCVTTPH2UDQZ128rrkz,
  VCVTTPH2UDQZ256rm,
  VCVTTPH2UDQZ256rmb,
  VCVTTPH2UDQZ256rmbk,
  VCVTTPH2UDQZ256rmbkz,
  VCVTTPH2UDQZ256rmk,
  VCVTTPH2UDQZ256rmkz,
  VCVTTPH2UDQZ256rr,
  VCVTTPH2UDQZ256rrk,
  VCVTTPH2UDQZ256rrkz,
  VCVTTPH2UDQZrm,
  VCVTTPH2UDQZrmb,
  VCVTTPH2UDQZrmbk,
  VCVTTPH2UDQZrmbkz,
  VCVTTPH2UDQZrmk,
  VCVTTPH2UDQZrmkz,
  VCVTTPH2UDQZrr,
  VCVTTPH2UDQZrrb,
  VCVTTPH2UDQZrrbk,
  VCVTTPH2UDQZrrbkz,
  VCVTTPH2UDQZrrk,
  VCVTTPH2UDQZrrkz,
  VCVTTPH2UQQZ128rm,
  VCVTTPH2UQQZ128rmb,
  VCVTTPH2UQQZ128rmbk,
  VCVTTPH2UQQZ128rmbkz,
  VCVTTPH2UQQZ128rmk,
  VCVTTPH2UQQZ128rmkz,
  VCVTTPH2UQQZ128rr,
  VCVTTPH2UQQZ128rrk,
  VCVTTPH2UQQZ128rrkz,
  VCVTTPH2UQQZ256rm,
  VCVTTPH2UQQZ256rmb,
  VCVTTPH2UQQZ256rmbk,
  VCVTTPH2UQQZ256rmbkz,
  VCVTTPH2UQQZ256rmk,
  VCVTTPH2UQQZ256rmkz,
  VCVTTPH2UQQZ256rr,
  VCVTTPH2UQQZ256rrk,
  VCVTTPH2UQQZ256rrkz,
  VCVTTPH2UQQZrm,
  VCVTTPH2UQQZrmb,
  VCVTTPH2UQQZrmbk,
  VCVTTPH2UQQZrmbkz,
  VCVTTPH2UQQZrmk,
  VCVTTPH2UQQZrmkz,
  VCVTTPH2UQQZrr,
  VCVTTPH2UQQZrrb,
  VCVTTPH2UQQZrrbk,
  VCVTTPH2UQQZrrbkz,
  VCVTTPH2UQQZrrk,
  VCVTTPH2UQQZrrkz,
  VCVTTPH2UWZ128rm,
  VCVTTPH2UWZ128rmb,
  VCVTTPH2UWZ128rmbk,
  VCVTTPH2UWZ128rmbkz,
  VCVTTPH2UWZ128rmk,
  VCVTTPH2UWZ128rmkz,
  VCVTTPH2UWZ128rr,
  VCVTTPH2UWZ128rrk,
  VCVTTPH2UWZ128rrkz,
  VCVTTPH2UWZ256rm,
  VCVTTPH2UWZ256rmb,
  VCVTTPH2UWZ256rmbk,
  VCVTTPH2UWZ256rmbkz,
  VCVTTPH2UWZ256rmk,
  VCVTTPH2UWZ256rmkz,
  VCVTTPH2UWZ256rr,
  VCVTTPH2UWZ256rrk,
  VCVTTPH2UWZ256rrkz,
  VCVTTPH2UWZrm,
  VCVTTPH2UWZrmb,
  VCVTTPH2UWZrmbk,
  VCVTTPH2UWZrmbkz,
  VCVTTPH2UWZrmk,
  VCVTTPH2UWZrmkz,
  VCVTTPH2UWZrr,
  VCVTTPH2UWZrrb,
  VCVTTPH2UWZrrbk,
  VCVTTPH2UWZrrbkz,
  VCVTTPH2UWZrrk,
  VCVTTPH2UWZrrkz,
  VCVTTPH2WZ128rm,
  VCVTTPH2WZ128rmb,
  VCVTTPH2WZ128rmbk,
  VCVTTPH2WZ128rmbkz,
  VCVTTPH2WZ128rmk,
  VCVTTPH2WZ128rmkz,
  VCVTTPH2WZ128rr,
  VCVTTPH2WZ128rrk,
  VCVTTPH2WZ128rrkz,
  VCVTTPH2WZ256rm,
  VCVTTPH2WZ256rmb,
  VCVTTPH2WZ256rmbk,
  VCVTTPH2WZ256rmbkz,
  VCVTTPH2WZ256rmk,
  VCVTTPH2WZ256rmkz,
  VCVTTPH2WZ256rr,
  VCVTTPH2WZ256rrk,
  VCVTTPH2WZ256rrkz,
  VCVTTPH2WZrm,
  VCVTTPH2WZrmb,
  VCVTTPH2WZrmbk,
  VCVTTPH2WZrmbkz,
  VCVTTPH2WZrmk,
  VCVTTPH2WZrmkz,
  VCVTTPH2WZrr,
  VCVTTPH2WZrrb,
  VCVTTPH2WZrrbk,
  VCVTTPH2WZrrbkz,
  VCVTTPH2WZrrk,
  VCVTTPH2WZrrkz,
  VCVTTPS2DQYrm,
  VCVTTPS2DQYrr,
  VCVTTPS2DQZ128rm,
  VCVTTPS2DQZ128rmb,
  VCVTTPS2DQZ128rmbk,
  VCVTTPS2DQZ128rmbkz,
  VCVTTPS2DQZ128rmk,
  VCVTTPS2DQZ128rmkz,
  VCVTTPS2DQZ128rr,
  VCVTTPS2DQZ128rrk,
  VCVTTPS2DQZ128rrkz,
  VCVTTPS2DQZ256rm,
  VCVTTPS2DQZ256rmb,
  VCVTTPS2DQZ256rmbk,
  VCVTTPS2DQZ256rmbkz,
  VCVTTPS2DQZ256rmk,
  VCVTTPS2DQZ256rmkz,
  VCVTTPS2DQZ256rr,
  VCVTTPS2DQZ256rrk,
  VCVTTPS2DQZ256rrkz,
  VCVTTPS2DQZrm,
  VCVTTPS2DQZrmb,
  VCVTTPS2DQZrmbk,
  VCVTTPS2DQZrmbkz,
  VCVTTPS2DQZrmk,
  VCVTTPS2DQZrmkz,
  VCVTTPS2DQZrr,
  VCVTTPS2DQZrrb,
  VCVTTPS2DQZrrbk,
  VCVTTPS2DQZrrbkz,
  VCVTTPS2DQZrrk,
  VCVTTPS2DQZrrkz,
  VCVTTPS2DQrm,
  VCVTTPS2DQrr,
  VCVTTPS2QQZ128rm,
  VCVTTPS2QQZ128rmb,
  VCVTTPS2QQZ128rmbk,
  VCVTTPS2QQZ128rmbkz,
  VCVTTPS2QQZ128rmk,
  VCVTTPS2QQZ128rmkz,
  VCVTTPS2QQZ128rr,
  VCVTTPS2QQZ128rrk,
  VCVTTPS2QQZ128rrkz,
  VCVTTPS2QQZ256rm,
  VCVTTPS2QQZ256rmb,
  VCVTTPS2QQZ256rmbk,
  VCVTTPS2QQZ256rmbkz,
  VCVTTPS2QQZ256rmk,
  VCVTTPS2QQZ256rmkz,
  VCVTTPS2QQZ256rr,
  VCVTTPS2QQZ256rrk,
  VCVTTPS2QQZ256rrkz,
  VCVTTPS2QQZrm,
  VCVTTPS2QQZrmb,
  VCVTTPS2QQZrmbk,
  VCVTTPS2QQZrmbkz,
  VCVTTPS2QQZrmk,
  VCVTTPS2QQZrmkz,
  VCVTTPS2QQZrr,
  VCVTTPS2QQZrrb,
  VCVTTPS2QQZrrbk,
  VCVTTPS2QQZrrbkz,
  VCVTTPS2QQZrrk,
  VCVTTPS2QQZrrkz,
  VCVTTPS2UDQZ128rm,
  VCVTTPS2UDQZ128rmb,
  VCVTTPS2UDQZ128rmbk,
  VCVTTPS2UDQZ128rmbkz,
  VCVTTPS2UDQZ128rmk,
  VCVTTPS2UDQZ128rmkz,
  VCVTTPS2UDQZ128rr,
  VCVTTPS2UDQZ128rrk,
  VCVTTPS2UDQZ128rrkz,
  VCVTTPS2UDQZ256rm,
  VCVTTPS2UDQZ256rmb,
  VCVTTPS2UDQZ256rmbk,
  VCVTTPS2UDQZ256rmbkz,
  VCVTTPS2UDQZ256rmk,
  VCVTTPS2UDQZ256rmkz,
  VCVTTPS2UDQZ256rr,
  VCVTTPS2UDQZ256rrk,
  VCVTTPS2UDQZ256rrkz,
  VCVTTPS2UDQZrm,
  VCVTTPS2UDQZrmb,
  VCVTTPS2UDQZrmbk,
  VCVTTPS2UDQZrmbkz,
  VCVTTPS2UDQZrmk,
  VCVTTPS2UDQZrmkz,
  VCVTTPS2UDQZrr,
  VCVTTPS2UDQZrrb,
  VCVTTPS2UDQZrrbk,
  VCVTTPS2UDQZrrbkz,
  VCVTTPS2UDQZrrk,
  VCVTTPS2UDQZrrkz,
  VCVTTPS2UQQZ128rm,
  VCVTTPS2UQQZ128rmb,
  VCVTTPS2UQQZ128rmbk,
  VCVTTPS2UQQZ128rmbkz,
  VCVTTPS2UQQZ128rmk,
  VCVTTPS2UQQZ128rmkz,
  VCVTTPS2UQQZ128rr,
  VCVTTPS2UQQZ128rrk,
  VCVTTPS2UQQZ128rrkz,
  VCVTTPS2UQQZ256rm,
  VCVTTPS2UQQZ256rmb,
  VCVTTPS2UQQZ256rmbk,
  VCVTTPS2UQQZ256rmbkz,
  VCVTTPS2UQQZ256rmk,
  VCVTTPS2UQQZ256rmkz,
  VCVTTPS2UQQZ256rr,
  VCVTTPS2UQQZ256rrk,
  VCVTTPS2UQQZ256rrkz,
  VCVTTPS2UQQZrm,
  VCVTTPS2UQQZrmb,
  VCVTTPS2UQQZrmbk,
  VCVTTPS2UQQZrmbkz,
  VCVTTPS2UQQZrmk,
  VCVTTPS2UQQZrmkz,
  VCVTTPS2UQQZrr,
  VCVTTPS2UQQZrrb,
  VCVTTPS2UQQZrrbk,
  VCVTTPS2UQQZrrbkz,
  VCVTTPS2UQQZrrk,
  VCVTTPS2UQQZrrkz,
  VCVTTSD2SI64Zrm,
  VCVTTSD2SI64Zrm_Int,
  VCVTTSD2SI64Zrr,
  VCVTTSD2SI64Zrr_Int,
  VCVTTSD2SI64Zrrb_Int,
  VCVTTSD2SI64rm,
  VCVTTSD2SI64rm_Int,
  VCVTTSD2SI64rr,
  VCVTTSD2SI64rr_Int,
  VCVTTSD2SIZrm,
  VCVTTSD2SIZrm_Int,
  VCVTTSD2SIZrr,
  VCVTTSD2SIZrr_Int,
  VCVTTSD2SIZrrb_Int,
  VCVTTSD2SIrm,
  VCVTTSD2SIrm_Int,
  VCVTTSD2SIrr,
  VCVTTSD2SIrr_Int,
  VCVTTSD2USI64Zrm,
  VCVTTSD2USI64Zrm_Int,
  VCVTTSD2USI64Zrr,
  VCVTTSD2USI64Zrr_Int,
  VCVTTSD2USI64Zrrb_Int,
  VCVTTSD2USIZrm,
  VCVTTSD2USIZrm_Int,
  VCVTTSD2USIZrr,
  VCVTTSD2USIZrr_Int,
  VCVTTSD2USIZrrb_Int,
  VCVTTSH2SI64Zrm,
  VCVTTSH2SI64Zrm_Int,
  VCVTTSH2SI64Zrr,
  VCVTTSH2SI64Zrr_Int,
  VCVTTSH2SI64Zrrb_Int,
  VCVTTSH2SIZrm,
  VCVTTSH2SIZrm_Int,
  VCVTTSH2SIZrr,
  VCVTTSH2SIZrr_Int,
  VCVTTSH2SIZrrb_Int,
  VCVTTSH2USI64Zrm,
  VCVTTSH2USI64Zrm_Int,
  VCVTTSH2USI64Zrr,
  VCVTTSH2USI64Zrr_Int,
  VCVTTSH2USI64Zrrb_Int,
  VCVTTSH2USIZrm,
  VCVTTSH2USIZrm_Int,
  VCVTTSH2USIZrr,
  VCVTTSH2USIZrr_Int,
  VCVTTSH2USIZrrb_Int,
  VCVTTSS2SI64Zrm,
  VCVTTSS2SI64Zrm_Int,
  VCVTTSS2SI64Zrr,
  VCVTTSS2SI64Zrr_Int,
  VCVTTSS2SI64Zrrb_Int,
  VCVTTSS2SI64rm,
  VCVTTSS2SI64rm_Int,
  VCVTTSS2SI64rr,
  VCVTTSS2SI64rr_Int,
  VCVTTSS2SIZrm,
  VCVTTSS2SIZrm_Int,
  VCVTTSS2SIZrr,
  VCVTTSS2SIZrr_Int,
  VCVTTSS2SIZrrb_Int,
  VCVTTSS2SIrm,
  VCVTTSS2SIrm_Int,
  VCVTTSS2SIrr,
  VCVTTSS2SIrr_Int,
  VCVTTSS2USI64Zrm,
  VCVTTSS2USI64Zrm_Int,
  VCVTTSS2USI64Zrr,
  VCVTTSS2USI64Zrr_Int,
  VCVTTSS2USI64Zrrb_Int,
  VCVTTSS2USIZrm,
  VCVTTSS2USIZrm_Int,
  VCVTTSS2USIZrr,
  VCVTTSS2USIZrr_Int,
  VCVTTSS2USIZrrb_Int,
  VCVTUDQ2PDZ128rm,
  VCVTUDQ2PDZ128rmb,
  VCVTUDQ2PDZ128rmbk,
  VCVTUDQ2PDZ128rmbkz,
  VCVTUDQ2PDZ128rmk,
  VCVTUDQ2PDZ128rmkz,
  VCVTUDQ2PDZ128rr,
  VCVTUDQ2PDZ128rrk,
  VCVTUDQ2PDZ128rrkz,
  VCVTUDQ2PDZ256rm,
  VCVTUDQ2PDZ256rmb,
  VCVTUDQ2PDZ256rmbk,
  VCVTUDQ2PDZ256rmbkz,
  VCVTUDQ2PDZ256rmk,
  VCVTUDQ2PDZ256rmkz,
  VCVTUDQ2PDZ256rr,
  VCVTUDQ2PDZ256rrk,
  VCVTUDQ2PDZ256rrkz,
  VCVTUDQ2PDZrm,
  VCVTUDQ2PDZrmb,
  VCVTUDQ2PDZrmbk,
  VCVTUDQ2PDZrmbkz,
  VCVTUDQ2PDZrmk,
  VCVTUDQ2PDZrmkz,
  VCVTUDQ2PDZrr,
  VCVTUDQ2PDZrrk,
  VCVTUDQ2PDZrrkz,
  VCVTUDQ2PHZ128rm,
  VCVTUDQ2PHZ128rmb,
  VCVTUDQ2PHZ128rmbk,
  VCVTUDQ2PHZ128rmbkz,
  VCVTUDQ2PHZ128rmk,
  VCVTUDQ2PHZ128rmkz,
  VCVTUDQ2PHZ128rr,
  VCVTUDQ2PHZ128rrk,
  VCVTUDQ2PHZ128rrkz,
  VCVTUDQ2PHZ256rm,
  VCVTUDQ2PHZ256rmb,
  VCVTUDQ2PHZ256rmbk,
  VCVTUDQ2PHZ256rmbkz,
  VCVTUDQ2PHZ256rmk,
  VCVTUDQ2PHZ256rmkz,
  VCVTUDQ2PHZ256rr,
  VCVTUDQ2PHZ256rrk,
  VCVTUDQ2PHZ256rrkz,
  VCVTUDQ2PHZrm,
  VCVTUDQ2PHZrmb,
  VCVTUDQ2PHZrmbk,
  VCVTUDQ2PHZrmbkz,
  VCVTUDQ2PHZrmk,
  VCVTUDQ2PHZrmkz,
  VCVTUDQ2PHZrr,
  VCVTUDQ2PHZrrb,
  VCVTUDQ2PHZrrbk,
  VCVTUDQ2PHZrrbkz,
  VCVTUDQ2PHZrrk,
  VCVTUDQ2PHZrrkz,
  VCVTUDQ2PSZ128rm,
  VCVTUDQ2PSZ128rmb,
  VCVTUDQ2PSZ128rmbk,
  VCVTUDQ2PSZ128rmbkz,
  VCVTUDQ2PSZ128rmk,
  VCVTUDQ2PSZ128rmkz,
  VCVTUDQ2PSZ128rr,
  VCVTUDQ2PSZ128rrk,
  VCVTUDQ2PSZ128rrkz,
  VCVTUDQ2PSZ256rm,
  VCVTUDQ2PSZ256rmb,
  VCVTUDQ2PSZ256rmbk,
  VCVTUDQ2PSZ256rmbkz,
  VCVTUDQ2PSZ256rmk,
  VCVTUDQ2PSZ256rmkz,
  VCVTUDQ2PSZ256rr,
  VCVTUDQ2PSZ256rrk,
  VCVTUDQ2PSZ256rrkz,
  VCVTUDQ2PSZrm,
  VCVTUDQ2PSZrmb,
  VCVTUDQ2PSZrmbk,
  VCVTUDQ2PSZrmbkz,
  VCVTUDQ2PSZrmk,
  VCVTUDQ2PSZrmkz,
  VCVTUDQ2PSZrr,
  VCVTUDQ2PSZrrb,
  VCVTUDQ2PSZrrbk,
  VCVTUDQ2PSZrrbkz,
  VCVTUDQ2PSZrrk,
  VCVTUDQ2PSZrrkz,
  VCVTUQQ2PDZ128rm,
  VCVTUQQ2PDZ128rmb,
  VCVTUQQ2PDZ128rmbk,
  VCVTUQQ2PDZ128rmbkz,
  VCVTUQQ2PDZ128rmk,
  VCVTUQQ2PDZ128rmkz,
  VCVTUQQ2PDZ128rr,
  VCVTUQQ2PDZ128rrk,
  VCVTUQQ2PDZ128rrkz,
  VCVTUQQ2PDZ256rm,
  VCVTUQQ2PDZ256rmb,
  VCVTUQQ2PDZ256rmbk,
  VCVTUQQ2PDZ256rmbkz,
  VCVTUQQ2PDZ256rmk,
  VCVTUQQ2PDZ256rmkz,
  VCVTUQQ2PDZ256rr,
  VCVTUQQ2PDZ256rrk,
  VCVTUQQ2PDZ256rrkz,
  VCVTUQQ2PDZrm,
  VCVTUQQ2PDZrmb,
  VCVTUQQ2PDZrmbk,
  VCVTUQQ2PDZrmbkz,
  VCVTUQQ2PDZrmk,
  VCVTUQQ2PDZrmkz,
  VCVTUQQ2PDZrr,
  VCVTUQQ2PDZrrb,
  VCVTUQQ2PDZrrbk,
  VCVTUQQ2PDZrrbkz,
  VCVTUQQ2PDZrrk,
  VCVTUQQ2PDZrrkz,
  VCVTUQQ2PHZ128rm,
  VCVTUQQ2PHZ128rmb,
  VCVTUQQ2PHZ128rmbk,
  VCVTUQQ2PHZ128rmbkz,
  VCVTUQQ2PHZ128rmk,
  VCVTUQQ2PHZ128rmkz,
  VCVTUQQ2PHZ128rr,
  VCVTUQQ2PHZ128rrk,
  VCVTUQQ2PHZ128rrkz,
  VCVTUQQ2PHZ256rm,
  VCVTUQQ2PHZ256rmb,
  VCVTUQQ2PHZ256rmbk,
  VCVTUQQ2PHZ256rmbkz,
  VCVTUQQ2PHZ256rmk,
  VCVTUQQ2PHZ256rmkz,
  VCVTUQQ2PHZ256rr,
  VCVTUQQ2PHZ256rrk,
  VCVTUQQ2PHZ256rrkz,
  VCVTUQQ2PHZrm,
  VCVTUQQ2PHZrmb,
  VCVTUQQ2PHZrmbk,
  VCVTUQQ2PHZrmbkz,
  VCVTUQQ2PHZrmk,
  VCVTUQQ2PHZrmkz,
  VCVTUQQ2PHZrr,
  VCVTUQQ2PHZrrb,
  VCVTUQQ2PHZrrbk,
  VCVTUQQ2PHZrrbkz,
  VCVTUQQ2PHZrrk,
  VCVTUQQ2PHZrrkz,
  VCVTUQQ2PSZ128rm,
  VCVTUQQ2PSZ128rmb,
  VCVTUQQ2PSZ128rmbk,
  VCVTUQQ2PSZ128rmbkz,
  VCVTUQQ2PSZ128rmk,
  VCVTUQQ2PSZ128rmkz,
  VCVTUQQ2PSZ128rr,
  VCVTUQQ2PSZ128rrk,
  VCVTUQQ2PSZ128rrkz,
  VCVTUQQ2PSZ256rm,
  VCVTUQQ2PSZ256rmb,
  VCVTUQQ2PSZ256rmbk,
  VCVTUQQ2PSZ256rmbkz,
  VCVTUQQ2PSZ256rmk,
  VCVTUQQ2PSZ256rmkz,
  VCVTUQQ2PSZ256rr,
  VCVTUQQ2PSZ256rrk,
  VCVTUQQ2PSZ256rrkz,
  VCVTUQQ2PSZrm,
  VCVTUQQ2PSZrmb,
  VCVTUQQ2PSZrmbk,
  VCVTUQQ2PSZrmbkz,
  VCVTUQQ2PSZrmk,
  VCVTUQQ2PSZrmkz,
  VCVTUQQ2PSZrr,
  VCVTUQQ2PSZrrb,
  VCVTUQQ2PSZrrbk,
  VCVTUQQ2PSZrrbkz,
  VCVTUQQ2PSZrrk,
  VCVTUQQ2PSZrrkz,
  VCVTUSI2SDZrm,
  VCVTUSI2SDZrm_Int,
  VCVTUSI2SDZrr,
  VCVTUSI2SDZrr_Int,
  VCVTUSI2SHZrm,
  VCVTUSI2SHZrm_Int,
  VCVTUSI2SHZrr,
  VCVTUSI2SHZrr_Int,
  VCVTUSI2SHZrrb_Int,
  VCVTUSI2SSZrm,
  VCVTUSI2SSZrm_Int,
  VCVTUSI2SSZrr,
  VCVTUSI2SSZrr_Int,
  VCVTUSI2SSZrrb_Int,
  VCVTUSI642SDZrm,
  VCVTUSI642SDZrm_Int,
  VCVTUSI642SDZrr,
  VCVTUSI642SDZrr_Int,
  VCVTUSI642SDZrrb_Int,
  VCVTUSI642SHZrm,
  VCVTUSI642SHZrm_Int,
  VCVTUSI642SHZrr,
  VCVTUSI642SHZrr_Int,
  VCVTUSI642SHZrrb_Int,
  VCVTUSI642SSZrm,
  VCVTUSI642SSZrm_Int,
  VCVTUSI642SSZrr,
  VCVTUSI642SSZrr_Int,
  VCVTUSI642SSZrrb_Int,
  VCVTUW2PHZ128rm,
  VCVTUW2PHZ128rmb,
  VCVTUW2PHZ128rmbk,
  VCVTUW2PHZ128rmbkz,
  VCVTUW2PHZ128rmk,
  VCVTUW2PHZ128rmkz,
  VCVTUW2PHZ128rr,
  VCVTUW2PHZ128rrk,
  VCVTUW2PHZ128rrkz,
  VCVTUW2PHZ256rm,
  VCVTUW2PHZ256rmb,
  VCVTUW2PHZ256rmbk,
  VCVTUW2PHZ256rmbkz,
  VCVTUW2PHZ256rmk,
  VCVTUW2PHZ256rmkz,
  VCVTUW2PHZ256rr,
  VCVTUW2PHZ256rrk,
  VCVTUW2PHZ256rrkz,
  VCVTUW2PHZrm,
  VCVTUW2PHZrmb,
  VCVTUW2PHZrmbk,
  VCVTUW2PHZrmbkz,
  VCVTUW2PHZrmk,
  VCVTUW2PHZrmkz,
  VCVTUW2PHZrr,
  VCVTUW2PHZrrb,
  VCVTUW2PHZrrbk,
  VCVTUW2PHZrrbkz,
  VCVTUW2PHZrrk,
  VCVTUW2PHZrrkz,
  VCVTW2PHZ128rm,
  VCVTW2PHZ128rmb,
  VCVTW2PHZ128rmbk,
  VCVTW2PHZ128rmbkz,
  VCVTW2PHZ128rmk,
  VCVTW2PHZ128rmkz,
  VCVTW2PHZ128rr,
  VCVTW2PHZ128rrk,
  VCVTW2PHZ128rrkz,
  VCVTW2PHZ256rm,
  VCVTW2PHZ256rmb,
  VCVTW2PHZ256rmbk,
  VCVTW2PHZ256rmbkz,
  VCVTW2PHZ256rmk,
  VCVTW2PHZ256rmkz,
  VCVTW2PHZ256rr,
  VCVTW2PHZ256rrk,
  VCVTW2PHZ256rrkz,
  VCVTW2PHZrm,
  VCVTW2PHZrmb,
  VCVTW2PHZrmbk,
  VCVTW2PHZrmbkz,
  VCVTW2PHZrmk,
  VCVTW2PHZrmkz,
  VCVTW2PHZrr,
  VCVTW2PHZrrb,
  VCVTW2PHZrrbk,
  VCVTW2PHZrrbkz,
  VCVTW2PHZrrk,
  VCVTW2PHZrrkz,
  VDBPSADBWZ128rmi,
  VDBPSADBWZ128rmik,
  VDBPSADBWZ128rmikz,
  VDBPSADBWZ128rri,
  VDBPSADBWZ128rrik,
  VDBPSADBWZ128rrikz,
  VDBPSADBWZ256rmi,
  VDBPSADBWZ256rmik,
  VDBPSADBWZ256rmikz,
  VDBPSADBWZ256rri,
  VDBPSADBWZ256rrik,
  VDBPSADBWZ256rrikz,
  VDBPSADBWZrmi,
  VDBPSADBWZrmik,
  VDBPSADBWZrmikz,
  VDBPSADBWZrri,
  VDBPSADBWZrrik,
  VDBPSADBWZrrikz,
  VDIVPDYrm,
  VDIVPDYrr,
  VDIVPDZ128rm,
  VDIVPDZ128rmb,
  VDIVPDZ128rmbk,
  VDIVPDZ128rmbkz,
  VDIVPDZ128rmk,
  VDIVPDZ128rmkz,
  VDIVPDZ128rr,
  VDIVPDZ128rrk,
  VDIVPDZ128rrkz,
  VDIVPDZ256rm,
  VDIVPDZ256rmb,
  VDIVPDZ256rmbk,
  VDIVPDZ256rmbkz,
  VDIVPDZ256rmk,
  VDIVPDZ256rmkz,
  VDIVPDZ256rr,
  VDIVPDZ256rrk,
  VDIVPDZ256rrkz,
  VDIVPDZrm,
  VDIVPDZrmb,
  VDIVPDZrmbk,
  VDIVPDZrmbkz,
  VDIVPDZrmk,
  VDIVPDZrmkz,
  VDIVPDZrr,
  VDIVPDZrrb,
  VDIVPDZrrbk,
  VDIVPDZrrbkz,
  VDIVPDZrrk,
  VDIVPDZrrkz,
  VDIVPDrm,
  VDIVPDrr,
  VDIVPHZ128rm,
  VDIVPHZ128rmb,
  VDIVPHZ128rmbk,
  VDIVPHZ128rmbkz,
  VDIVPHZ128rmk,
  VDIVPHZ128rmkz,
  VDIVPHZ128rr,
  VDIVPHZ128rrk,
  VDIVPHZ128rrkz,
  VDIVPHZ256rm,
  VDIVPHZ256rmb,
  VDIVPHZ256rmbk,
  VDIVPHZ256rmbkz,
  VDIVPHZ256rmk,
  VDIVPHZ256rmkz,
  VDIVPHZ256rr,
  VDIVPHZ256rrk,
  VDIVPHZ256rrkz,
  VDIVPHZrm,
  VDIVPHZrmb,
  VDIVPHZrmbk,
  VDIVPHZrmbkz,
  VDIVPHZrmk,
  VDIVPHZrmkz,
  VDIVPHZrr,
  VDIVPHZrrb,
  VDIVPHZrrbk,
  VDIVPHZrrbkz,
  VDIVPHZrrk,
  VDIVPHZrrkz,
  VDIVPSYrm,
  VDIVPSYrr,
  VDIVPSZ128rm,
  VDIVPSZ128rmb,
  VDIVPSZ128rmbk,
  VDIVPSZ128rmbkz,
  VDIVPSZ128rmk,
  VDIVPSZ128rmkz,
  VDIVPSZ128rr,
  VDIVPSZ128rrk,
  VDIVPSZ128rrkz,
  VDIVPSZ256rm,
  VDIVPSZ256rmb,
  VDIVPSZ256rmbk,
  VDIVPSZ256rmbkz,
  VDIVPSZ256rmk,
  VDIVPSZ256rmkz,
  VDIVPSZ256rr,
  VDIVPSZ256rrk,
  VDIVPSZ256rrkz,
  VDIVPSZrm,
  VDIVPSZrmb,
  VDIVPSZrmbk,
  VDIVPSZrmbkz,
  VDIVPSZrmk,
  VDIVPSZrmkz,
  VDIVPSZrr,
  VDIVPSZrrb,
  VDIVPSZrrbk,
  VDIVPSZrrbkz,
  VDIVPSZrrk,
  VDIVPSZrrkz,
  VDIVPSrm,
  VDIVPSrr,
  VDIVSDZrm,
  VDIVSDZrm_Int,
  VDIVSDZrm_Intk,
  VDIVSDZrm_Intkz,
  VDIVSDZrr,
  VDIVSDZrr_Int,
  VDIVSDZrr_Intk,
  VDIVSDZrr_Intkz,
  VDIVSDZrrb_Int,
  VDIVSDZrrb_Intk,
  VDIVSDZrrb_Intkz,
  VDIVSDrm,
  VDIVSDrm_Int,
  VDIVSDrr,
  VDIVSDrr_Int,
  VDIVSHZrm,
  VDIVSHZrm_Int,
  VDIVSHZrm_Intk,
  VDIVSHZrm_Intkz,
  VDIVSHZrr,
  VDIVSHZrr_Int,
  VDIVSHZrr_Intk,
  VDIVSHZrr_Intkz,
  VDIVSHZrrb_Int,
  VDIVSHZrrb_Intk,
  VDIVSHZrrb_Intkz,
  VDIVSSZrm,
  VDIVSSZrm_Int,
  VDIVSSZrm_Intk,
  VDIVSSZrm_Intkz,
  VDIVSSZrr,
  VDIVSSZrr_Int,
  VDIVSSZrr_Intk,
  VDIVSSZrr_Intkz,
  VDIVSSZrrb_Int,
  VDIVSSZrrb_Intk,
  VDIVSSZrrb_Intkz,
  VDIVSSrm,
  VDIVSSrm_Int,
  VDIVSSrr,
  VDIVSSrr_Int,
  VDPBF16PSZ128m,
  VDPBF16PSZ128mb,
  VDPBF16PSZ128mbk,
  VDPBF16PSZ128mbkz,
  VDPBF16PSZ128mk,
  VDPBF16PSZ128mkz,
  VDPBF16PSZ128r,
  VDPBF16PSZ128rk,
  VDPBF16PSZ128rkz,
  VDPBF16PSZ256m,
  VDPBF16PSZ256mb,
  VDPBF16PSZ256mbk,
  VDPBF16PSZ256mbkz,
  VDPBF16PSZ256mk,
  VDPBF16PSZ256mkz,
  VDPBF16PSZ256r,
  VDPBF16PSZ256rk,
  VDPBF16PSZ256rkz,
  VDPBF16PSZm,
  VDPBF16PSZmb,
  VDPBF16PSZmbk,
  VDPBF16PSZmbkz,
  VDPBF16PSZmk,
  VDPBF16PSZmkz,
  VDPBF16PSZr,
  VDPBF16PSZrk,
  VDPBF16PSZrkz,
  VDPPDrmi,
  VDPPDrri,
  VDPPSYrmi,
  VDPPSYrri,
  VDPPSrmi,
  VDPPSrri,
  VERRm,
  VERRr,
  VERWm,
  VERWr,
  VEXP2PDZm,
  VEXP2PDZmb,
  VEXP2PDZmbk,
  VEXP2PDZmbkz,
  VEXP2PDZmk,
  VEXP2PDZmkz,
  VEXP2PDZr,
  VEXP2PDZrb,
  VEXP2PDZrbk,
  VEXP2PDZrbkz,
  VEXP2PDZrk,
  VEXP2PDZrkz,
  VEXP2PSZm,
  VEXP2PSZmb,
  VEXP2PSZmbk,
  VEXP2PSZmbkz,
  VEXP2PSZmk,
  VEXP2PSZmkz,
  VEXP2PSZr,
  VEXP2PSZrb,
  VEXP2PSZrbk,
  VEXP2PSZrbkz,
  VEXP2PSZrk,
  VEXP2PSZrkz,
  VEXPANDPDZ128rm,
  VEXPANDPDZ128rmk,
  VEXPANDPDZ128rmkz,
  VEXPANDPDZ128rr,
  VEXPANDPDZ128rrk,
  VEXPANDPDZ128rrkz,
  VEXPANDPDZ256rm,
  VEXPANDPDZ256rmk,
  VEXPANDPDZ256rmkz,
  VEXPANDPDZ256rr,
  VEXPANDPDZ256rrk,
  VEXPANDPDZ256rrkz,
  VEXPANDPDZrm,
  VEXPANDPDZrmk,
  VEXPANDPDZrmkz,
  VEXPANDPDZrr,
  VEXPANDPDZrrk,
  VEXPANDPDZrrkz,
  VEXPANDPSZ128rm,
  VEXPANDPSZ128rmk,
  VEXPANDPSZ128rmkz,
  VEXPANDPSZ128rr,
  VEXPANDPSZ128rrk,
  VEXPANDPSZ128rrkz,
  VEXPANDPSZ256rm,
  VEXPANDPSZ256rmk,
  VEXPANDPSZ256rmkz,
  VEXPANDPSZ256rr,
  VEXPANDPSZ256rrk,
  VEXPANDPSZ256rrkz,
  VEXPANDPSZrm,
  VEXPANDPSZrmk,
  VEXPANDPSZrmkz,
  VEXPANDPSZrr,
  VEXPANDPSZrrk,
  VEXPANDPSZrrkz,
  VEXTRACTF128mr,
  VEXTRACTF128rr,
  VEXTRACTF32x4Z256mr,
  VEXTRACTF32x4Z256mrk,
  VEXTRACTF32x4Z256rr,
  VEXTRACTF32x4Z256rrk,
  VEXTRACTF32x4Z256rrkz,
  VEXTRACTF32x4Zmr,
  VEXTRACTF32x4Zmrk,
  VEXTRACTF32x4Zrr,
  VEXTRACTF32x4Zrrk,
  VEXTRACTF32x4Zrrkz,
  VEXTRACTF32x8Zmr,
  VEXTRACTF32x8Zmrk,
  VEXTRACTF32x8Zrr,
  VEXTRACTF32x8Zrrk,
  VEXTRACTF32x8Zrrkz,
  VEXTRACTF64x2Z256mr,
  VEXTRACTF64x2Z256mrk,
  VEXTRACTF64x2Z256rr,
  VEXTRACTF64x2Z256rrk,
  VEXTRACTF64x2Z256rrkz,
  VEXTRACTF64x2Zmr,
  VEXTRACTF64x2Zmrk,
  VEXTRACTF64x2Zrr,
  VEXTRACTF64x2Zrrk,
  VEXTRACTF64x2Zrrkz,
  VEXTRACTF64x4Zmr,
  VEXTRACTF64x4Zmrk,
  VEXTRACTF64x4Zrr,
  VEXTRACTF64x4Zrrk,
  VEXTRACTF64x4Zrrkz,
  VEXTRACTI128mr,
  VEXTRACTI128rr,
  VEXTRACTI32x4Z256mr,
  VEXTRACTI32x4Z256mrk,
  VEXTRACTI32x4Z256rr,
  VEXTRACTI32x4Z256rrk,
  VEXTRACTI32x4Z256rrkz,
  VEXTRACTI32x4Zmr,
  VEXTRACTI32x4Zmrk,
  VEXTRACTI32x4Zrr,
  VEXTRACTI32x4Zrrk,
  VEXTRACTI32x4Zrrkz,
  VEXTRACTI32x8Zmr,
  VEXTRACTI32x8Zmrk,
  VEXTRACTI32x8Zrr,
  VEXTRACTI32x8Zrrk,
  VEXTRACTI32x8Zrrkz,
  VEXTRACTI64x2Z256mr,
  VEXTRACTI64x2Z256mrk,
  VEXTRACTI64x2Z256rr,
  VEXTRACTI64x2Z256rrk,
  VEXTRACTI64x2Z256rrkz,
  VEXTRACTI64x2Zmr,
  VEXTRACTI64x2Zmrk,
  VEXTRACTI64x2Zrr,
  VEXTRACTI64x2Zrrk,
  VEXTRACTI64x2Zrrkz,
  VEXTRACTI64x4Zmr,
  VEXTRACTI64x4Zmrk,
  VEXTRACTI64x4Zrr,
  VEXTRACTI64x4Zrrk,
  VEXTRACTI64x4Zrrkz,
  VEXTRACTPSZmr,
  VEXTRACTPSZrr,
  VEXTRACTPSmr,
  VEXTRACTPSrr,
  VFCMADDCPHZ128m,
  VFCMADDCPHZ128mb,
  VFCMADDCPHZ128mbk,
  VFCMADDCPHZ128mbkz,
  VFCMADDCPHZ128mk,
  VFCMADDCPHZ128mkz,
  VFCMADDCPHZ128r,
  VFCMADDCPHZ128rk,
  VFCMADDCPHZ128rkz,
  VFCMADDCPHZ256m,
  VFCMADDCPHZ256mb,
  VFCMADDCPHZ256mbk,
  VFCMADDCPHZ256mbkz,
  VFCMADDCPHZ256mk,
  VFCMADDCPHZ256mkz,
  VFCMADDCPHZ256r,
  VFCMADDCPHZ256rk,
  VFCMADDCPHZ256rkz,
  VFCMADDCPHZm,
  VFCMADDCPHZmb,
  VFCMADDCPHZmbk,
  VFCMADDCPHZmbkz,
  VFCMADDCPHZmk,
  VFCMADDCPHZmkz,
  VFCMADDCPHZr,
  VFCMADDCPHZrb,
  VFCMADDCPHZrbk,
  VFCMADDCPHZrbkz,
  VFCMADDCPHZrk,
  VFCMADDCPHZrkz,
  VFCMADDCSHZm,
  VFCMADDCSHZmk,
  VFCMADDCSHZmkz,
  VFCMADDCSHZr,
  VFCMADDCSHZrb,
  VFCMADDCSHZrbk,
  VFCMADDCSHZrbkz,
  VFCMADDCSHZrk,
  VFCMADDCSHZrkz,
  VFCMULCPHZ128rm,
  VFCMULCPHZ128rmb,
  VFCMULCPHZ128rmbk,
  VFCMULCPHZ128rmbkz,
  VFCMULCPHZ128rmk,
  VFCMULCPHZ128rmkz,
  VFCMULCPHZ128rr,
  VFCMULCPHZ128rrk,
  VFCMULCPHZ128rrkz,
  VFCMULCPHZ256rm,
  VFCMULCPHZ256rmb,
  VFCMULCPHZ256rmbk,
  VFCMULCPHZ256rmbkz,
  VFCMULCPHZ256rmk,
  VFCMULCPHZ256rmkz,
  VFCMULCPHZ256rr,
  VFCMULCPHZ256rrk,
  VFCMULCPHZ256rrkz,
  VFCMULCPHZrm,
  VFCMULCPHZrmb,
  VFCMULCPHZrmbk,
  VFCMULCPHZrmbkz,
  VFCMULCPHZrmk,
  VFCMULCPHZrmkz,
  VFCMULCPHZrr,
  VFCMULCPHZrrb,
  VFCMULCPHZrrbk,
  VFCMULCPHZrrbkz,
  VFCMULCPHZrrk,
  VFCMULCPHZrrkz,
  VFCMULCSHZrm,
  VFCMULCSHZrmk,
  VFCMULCSHZrmkz,
  VFCMULCSHZrr,
  VFCMULCSHZrrb,
  VFCMULCSHZrrbk,
  VFCMULCSHZrrbkz,
  VFCMULCSHZrrk,
  VFCMULCSHZrrkz,
  VFIXUPIMMPDZ128rmbi,
  VFIXUPIMMPDZ128rmbik,
  VFIXUPIMMPDZ128rmbikz,
  VFIXUPIMMPDZ128rmi,
  VFIXUPIMMPDZ128rmik,
  VFIXUPIMMPDZ128rmikz,
  VFIXUPIMMPDZ128rri,
  VFIXUPIMMPDZ128rrik,
  VFIXUPIMMPDZ128rrikz,
  VFIXUPIMMPDZ256rmbi,
  VFIXUPIMMPDZ256rmbik,
  VFIXUPIMMPDZ256rmbikz,
  VFIXUPIMMPDZ256rmi,
  VFIXUPIMMPDZ256rmik,
  VFIXUPIMMPDZ256rmikz,
  VFIXUPIMMPDZ256rri,
  VFIXUPIMMPDZ256rrik,
  VFIXUPIMMPDZ256rrikz,
  VFIXUPIMMPDZrmbi,
  VFIXUPIMMPDZrmbik,
  VFIXUPIMMPDZrmbikz,
  VFIXUPIMMPDZrmi,
  VFIXUPIMMPDZrmik,
  VFIXUPIMMPDZrmikz,
  VFIXUPIMMPDZrri,
  VFIXUPIMMPDZrrib,
  VFIXUPIMMPDZrribk,
  VFIXUPIMMPDZrribkz,
  VFIXUPIMMPDZrrik,
  VFIXUPIMMPDZrrikz,
  VFIXUPIMMPSZ128rmbi,
  VFIXUPIMMPSZ128rmbik,
  VFIXUPIMMPSZ128rmbikz,
  VFIXUPIMMPSZ128rmi,
  VFIXUPIMMPSZ128rmik,
  VFIXUPIMMPSZ128rmikz,
  VFIXUPIMMPSZ128rri,
  VFIXUPIMMPSZ128rrik,
  VFIXUPIMMPSZ128rrikz,
  VFIXUPIMMPSZ256rmbi,
  VFIXUPIMMPSZ256rmbik,
  VFIXUPIMMPSZ256rmbikz,
  VFIXUPIMMPSZ256rmi,
  VFIXUPIMMPSZ256rmik,
  VFIXUPIMMPSZ256rmikz,
  VFIXUPIMMPSZ256rri,
  VFIXUPIMMPSZ256rrik,
  VFIXUPIMMPSZ256rrikz,
  VFIXUPIMMPSZrmbi,
  VFIXUPIMMPSZrmbik,
  VFIXUPIMMPSZrmbikz,
  VFIXUPIMMPSZrmi,
  VFIXUPIMMPSZrmik,
  VFIXUPIMMPSZrmikz,
  VFIXUPIMMPSZrri,
  VFIXUPIMMPSZrrib,
  VFIXUPIMMPSZrribk,
  VFIXUPIMMPSZrribkz,
  VFIXUPIMMPSZrrik,
  VFIXUPIMMPSZrrikz,
  VFIXUPIMMSDZrmi,
  VFIXUPIMMSDZrmik,
  VFIXUPIMMSDZrmikz,
  VFIXUPIMMSDZrri,
  VFIXUPIMMSDZrrib,
  VFIXUPIMMSDZrribk,
  VFIXUPIMMSDZrribkz,
  VFIXUPIMMSDZrrik,
  VFIXUPIMMSDZrrikz,
  VFIXUPIMMSSZrmi,
  VFIXUPIMMSSZrmik,
  VFIXUPIMMSSZrmikz,
  VFIXUPIMMSSZrri,
  VFIXUPIMMSSZrrib,
  VFIXUPIMMSSZrribk,
  VFIXUPIMMSSZrribkz,
  VFIXUPIMMSSZrrik,
  VFIXUPIMMSSZrrikz,
  VFMADD132PDYm,
  VFMADD132PDYr,
  VFMADD132PDZ128m,
  VFMADD132PDZ128mb,
  VFMADD132PDZ128mbk,
  VFMADD132PDZ128mbkz,
  VFMADD132PDZ128mk,
  VFMADD132PDZ128mkz,
  VFMADD132PDZ128r,
  VFMADD132PDZ128rk,
  VFMADD132PDZ128rkz,
  VFMADD132PDZ256m,
  VFMADD132PDZ256mb,
  VFMADD132PDZ256mbk,
  VFMADD132PDZ256mbkz,
  VFMADD132PDZ256mk,
  VFMADD132PDZ256mkz,
  VFMADD132PDZ256r,
  VFMADD132PDZ256rk,
  VFMADD132PDZ256rkz,
  VFMADD132PDZm,
  VFMADD132PDZmb,
  VFMADD132PDZmbk,
  VFMADD132PDZmbkz,
  VFMADD132PDZmk,
  VFMADD132PDZmkz,
  VFMADD132PDZr,
  VFMADD132PDZrb,
  VFMADD132PDZrbk,
  VFMADD132PDZrbkz,
  VFMADD132PDZrk,
  VFMADD132PDZrkz,
  VFMADD132PDm,
  VFMADD132PDr,
  VFMADD132PHZ128m,
  VFMADD132PHZ128mb,
  VFMADD132PHZ128mbk,
  VFMADD132PHZ128mbkz,
  VFMADD132PHZ128mk,
  VFMADD132PHZ128mkz,
  VFMADD132PHZ128r,
  VFMADD132PHZ128rk,
  VFMADD132PHZ128rkz,
  VFMADD132PHZ256m,
  VFMADD132PHZ256mb,
  VFMADD132PHZ256mbk,
  VFMADD132PHZ256mbkz,
  VFMADD132PHZ256mk,
  VFMADD132PHZ256mkz,
  VFMADD132PHZ256r,
  VFMADD132PHZ256rk,
  VFMADD132PHZ256rkz,
  VFMADD132PHZm,
  VFMADD132PHZmb,
  VFMADD132PHZmbk,
  VFMADD132PHZmbkz,
  VFMADD132PHZmk,
  VFMADD132PHZmkz,
  VFMADD132PHZr,
  VFMADD132PHZrb,
  VFMADD132PHZrbk,
  VFMADD132PHZrbkz,
  VFMADD132PHZrk,
  VFMADD132PHZrkz,
  VFMADD132PSYm,
  VFMADD132PSYr,
  VFMADD132PSZ128m,
  VFMADD132PSZ128mb,
  VFMADD132PSZ128mbk,
  VFMADD132PSZ128mbkz,
  VFMADD132PSZ128mk,
  VFMADD132PSZ128mkz,
  VFMADD132PSZ128r,
  VFMADD132PSZ128rk,
  VFMADD132PSZ128rkz,
  VFMADD132PSZ256m,
  VFMADD132PSZ256mb,
  VFMADD132PSZ256mbk,
  VFMADD132PSZ256mbkz,
  VFMADD132PSZ256mk,
  VFMADD132PSZ256mkz,
  VFMADD132PSZ256r,
  VFMADD132PSZ256rk,
  VFMADD132PSZ256rkz,
  VFMADD132PSZm,
  VFMADD132PSZmb,
  VFMADD132PSZmbk,
  VFMADD132PSZmbkz,
  VFMADD132PSZmk,
  VFMADD132PSZmkz,
  VFMADD132PSZr,
  VFMADD132PSZrb,
  VFMADD132PSZrbk,
  VFMADD132PSZrbkz,
  VFMADD132PSZrk,
  VFMADD132PSZrkz,
  VFMADD132PSm,
  VFMADD132PSr,
  VFMADD132SDZm,
  VFMADD132SDZm_Int,
  VFMADD132SDZm_Intk,
  VFMADD132SDZm_Intkz,
  VFMADD132SDZr,
  VFMADD132SDZr_Int,
  VFMADD132SDZr_Intk,
  VFMADD132SDZr_Intkz,
  VFMADD132SDZrb,
  VFMADD132SDZrb_Int,
  VFMADD132SDZrb_Intk,
  VFMADD132SDZrb_Intkz,
  VFMADD132SDm,
  VFMADD132SDm_Int,
  VFMADD132SDr,
  VFMADD132SDr_Int,
  VFMADD132SHZm,
  VFMADD132SHZm_Int,
  VFMADD132SHZm_Intk,
  VFMADD132SHZm_Intkz,
  VFMADD132SHZr,
  VFMADD132SHZr_Int,
  VFMADD132SHZr_Intk,
  VFMADD132SHZr_Intkz,
  VFMADD132SHZrb,
  VFMADD132SHZrb_Int,
  VFMADD132SHZrb_Intk,
  VFMADD132SHZrb_Intkz,
  VFMADD132SSZm,
  VFMADD132SSZm_Int,
  VFMADD132SSZm_Intk,
  VFMADD132SSZm_Intkz,
  VFMADD132SSZr,
  VFMADD132SSZr_Int,
  VFMADD132SSZr_Intk,
  VFMADD132SSZr_Intkz,
  VFMADD132SSZrb,
  VFMADD132SSZrb_Int,
  VFMADD132SSZrb_Intk,
  VFMADD132SSZrb_Intkz,
  VFMADD132SSm,
  VFMADD132SSm_Int,
  VFMADD132SSr,
  VFMADD132SSr_Int,
  VFMADD213PDYm,
  VFMADD213PDYr,
  VFMADD213PDZ128m,
  VFMADD213PDZ128mb,
  VFMADD213PDZ128mbk,
  VFMADD213PDZ128mbkz,
  VFMADD213PDZ128mk,
  VFMADD213PDZ128mkz,
  VFMADD213PDZ128r,
  VFMADD213PDZ128rk,
  VFMADD213PDZ128rkz,
  VFMADD213PDZ256m,
  VFMADD213PDZ256mb,
  VFMADD213PDZ256mbk,
  VFMADD213PDZ256mbkz,
  VFMADD213PDZ256mk,
  VFMADD213PDZ256mkz,
  VFMADD213PDZ256r,
  VFMADD213PDZ256rk,
  VFMADD213PDZ256rkz,
  VFMADD213PDZm,
  VFMADD213PDZmb,
  VFMADD213PDZmbk,
  VFMADD213PDZmbkz,
  VFMADD213PDZmk,
  VFMADD213PDZmkz,
  VFMADD213PDZr,
  VFMADD213PDZrb,
  VFMADD213PDZrbk,
  VFMADD213PDZrbkz,
  VFMADD213PDZrk,
  VFMADD213PDZrkz,
  VFMADD213PDm,
  VFMADD213PDr,
  VFMADD213PHZ128m,
  VFMADD213PHZ128mb,
  VFMADD213PHZ128mbk,
  VFMADD213PHZ128mbkz,
  VFMADD213PHZ128mk,
  VFMADD213PHZ128mkz,
  VFMADD213PHZ128r,
  VFMADD213PHZ128rk,
  VFMADD213PHZ128rkz,
  VFMADD213PHZ256m,
  VFMADD213PHZ256mb,
  VFMADD213PHZ256mbk,
  VFMADD213PHZ256mbkz,
  VFMADD213PHZ256mk,
  VFMADD213PHZ256mkz,
  VFMADD213PHZ256r,
  VFMADD213PHZ256rk,
  VFMADD213PHZ256rkz,
  VFMADD213PHZm,
  VFMADD213PHZmb,
  VFMADD213PHZmbk,
  VFMADD213PHZmbkz,
  VFMADD213PHZmk,
  VFMADD213PHZmkz,
  VFMADD213PHZr,
  VFMADD213PHZrb,
  VFMADD213PHZrbk,
  VFMADD213PHZrbkz,
  VFMADD213PHZrk,
  VFMADD213PHZrkz,
  VFMADD213PSYm,
  VFMADD213PSYr,
  VFMADD213PSZ128m,
  VFMADD213PSZ128mb,
  VFMADD213PSZ128mbk,
  VFMADD213PSZ128mbkz,
  VFMADD213PSZ128mk,
  VFMADD213PSZ128mkz,
  VFMADD213PSZ128r,
  VFMADD213PSZ128rk,
  VFMADD213PSZ128rkz,
  VFMADD213PSZ256m,
  VFMADD213PSZ256mb,
  VFMADD213PSZ256mbk,
  VFMADD213PSZ256mbkz,
  VFMADD213PSZ256mk,
  VFMADD213PSZ256mkz,
  VFMADD213PSZ256r,
  VFMADD213PSZ256rk,
  VFMADD213PSZ256rkz,
  VFMADD213PSZm,
  VFMADD213PSZmb,
  VFMADD213PSZmbk,
  VFMADD213PSZmbkz,
  VFMADD213PSZmk,
  VFMADD213PSZmkz,
  VFMADD213PSZr,
  VFMADD213PSZrb,
  VFMADD213PSZrbk,
  VFMADD213PSZrbkz,
  VFMADD213PSZrk,
  VFMADD213PSZrkz,
  VFMADD213PSm,
  VFMADD213PSr,
  VFMADD213SDZm,
  VFMADD213SDZm_Int,
  VFMADD213SDZm_Intk,
  VFMADD213SDZm_Intkz,
  VFMADD213SDZr,
  VFMADD213SDZr_Int,
  VFMADD213SDZr_Intk,
  VFMADD213SDZr_Intkz,
  VFMADD213SDZrb,
  VFMADD213SDZrb_Int,
  VFMADD213SDZrb_Intk,
  VFMADD213SDZrb_Intkz,
  VFMADD213SDm,
  VFMADD213SDm_Int,
  VFMADD213SDr,
  VFMADD213SDr_Int,
  VFMADD213SHZm,
  VFMADD213SHZm_Int,
  VFMADD213SHZm_Intk,
  VFMADD213SHZm_Intkz,
  VFMADD213SHZr,
  VFMADD213SHZr_Int,
  VFMADD213SHZr_Intk,
  VFMADD213SHZr_Intkz,
  VFMADD213SHZrb,
  VFMADD213SHZrb_Int,
  VFMADD213SHZrb_Intk,
  VFMADD213SHZrb_Intkz,
  VFMADD213SSZm,
  VFMADD213SSZm_Int,
  VFMADD213SSZm_Intk,
  VFMADD213SSZm_Intkz,
  VFMADD213SSZr,
  VFMADD213SSZr_Int,
  VFMADD213SSZr_Intk,
  VFMADD213SSZr_Intkz,
  VFMADD213SSZrb,
  VFMADD213SSZrb_Int,
  VFMADD213SSZrb_Intk,
  VFMADD213SSZrb_Intkz,
  VFMADD213SSm,
  VFMADD213SSm_Int,
  VFMADD213SSr,
  VFMADD213SSr_Int,
  VFMADD231PDYm,
  VFMADD231PDYr,
  VFMADD231PDZ128m,
  VFMADD231PDZ128mb,
  VFMADD231PDZ128mbk,
  VFMADD231PDZ128mbkz,
  VFMADD231PDZ128mk,
  VFMADD231PDZ128mkz,
  VFMADD231PDZ128r,
  VFMADD231PDZ128rk,
  VFMADD231PDZ128rkz,
  VFMADD231PDZ256m,
  VFMADD231PDZ256mb,
  VFMADD231PDZ256mbk,
  VFMADD231PDZ256mbkz,
  VFMADD231PDZ256mk,
  VFMADD231PDZ256mkz,
  VFMADD231PDZ256r,
  VFMADD231PDZ256rk,
  VFMADD231PDZ256rkz,
  VFMADD231PDZm,
  VFMADD231PDZmb,
  VFMADD231PDZmbk,
  VFMADD231PDZmbkz,
  VFMADD231PDZmk,
  VFMADD231PDZmkz,
  VFMADD231PDZr,
  VFMADD231PDZrb,
  VFMADD231PDZrbk,
  VFMADD231PDZrbkz,
  VFMADD231PDZrk,
  VFMADD231PDZrkz,
  VFMADD231PDm,
  VFMADD231PDr,
  VFMADD231PHZ128m,
  VFMADD231PHZ128mb,
  VFMADD231PHZ128mbk,
  VFMADD231PHZ128mbkz,
  VFMADD231PHZ128mk,
  VFMADD231PHZ128mkz,
  VFMADD231PHZ128r,
  VFMADD231PHZ128rk,
  VFMADD231PHZ128rkz,
  VFMADD231PHZ256m,
  VFMADD231PHZ256mb,
  VFMADD231PHZ256mbk,
  VFMADD231PHZ256mbkz,
  VFMADD231PHZ256mk,
  VFMADD231PHZ256mkz,
  VFMADD231PHZ256r,
  VFMADD231PHZ256rk,
  VFMADD231PHZ256rkz,
  VFMADD231PHZm,
  VFMADD231PHZmb,
  VFMADD231PHZmbk,
  VFMADD231PHZmbkz,
  VFMADD231PHZmk,
  VFMADD231PHZmkz,
  VFMADD231PHZr,
  VFMADD231PHZrb,
  VFMADD231PHZrbk,
  VFMADD231PHZrbkz,
  VFMADD231PHZrk,
  VFMADD231PHZrkz,
  VFMADD231PSYm,
  VFMADD231PSYr,
  VFMADD231PSZ128m,
  VFMADD231PSZ128mb,
  VFMADD231PSZ128mbk,
  VFMADD231PSZ128mbkz,
  VFMADD231PSZ128mk,
  VFMADD231PSZ128mkz,
  VFMADD231PSZ128r,
  VFMADD231PSZ128rk,
  VFMADD231PSZ128rkz,
  VFMADD231PSZ256m,
  VFMADD231PSZ256mb,
  VFMADD231PSZ256mbk,
  VFMADD231PSZ256mbkz,
  VFMADD231PSZ256mk,
  VFMADD231PSZ256mkz,
  VFMADD231PSZ256r,
  VFMADD231PSZ256rk,
  VFMADD231PSZ256rkz,
  VFMADD231PSZm,
  VFMADD231PSZmb,
  VFMADD231PSZmbk,
  VFMADD231PSZmbkz,
  VFMADD231PSZmk,
  VFMADD231PSZmkz,
  VFMADD231PSZr,
  VFMADD231PSZrb,
  VFMADD231PSZrbk,
  VFMADD231PSZrbkz,
  VFMADD231PSZrk,
  VFMADD231PSZrkz,
  VFMADD231PSm,
  VFMADD231PSr,
  VFMADD231SDZm,
  VFMADD231SDZm_Int,
  VFMADD231SDZm_Intk,
  VFMADD231SDZm_Intkz,
  VFMADD231SDZr,
  VFMADD231SDZr_Int,
  VFMADD231SDZr_Intk,
  VFMADD231SDZr_Intkz,
  VFMADD231SDZrb,
  VFMADD231SDZrb_Int,
  VFMADD231SDZrb_Intk,
  VFMADD231SDZrb_Intkz,
  VFMADD231SDm,
  VFMADD231SDm_Int,
  VFMADD231SDr,
  VFMADD231SDr_Int,
  VFMADD231SHZm,
  VFMADD231SHZm_Int,
  VFMADD231SHZm_Intk,
  VFMADD231SHZm_Intkz,
  VFMADD231SHZr,
  VFMADD231SHZr_Int,
  VFMADD231SHZr_Intk,
  VFMADD231SHZr_Intkz,
  VFMADD231SHZrb,
  VFMADD231SHZrb_Int,
  VFMADD231SHZrb_Intk,
  VFMADD231SHZrb_Intkz,
  VFMADD231SSZm,
  VFMADD231SSZm_Int,
  VFMADD231SSZm_Intk,
  VFMADD231SSZm_Intkz,
  VFMADD231SSZr,
  VFMADD231SSZr_Int,
  VFMADD231SSZr_Intk,
  VFMADD231SSZr_Intkz,
  VFMADD231SSZrb,
  VFMADD231SSZrb_Int,
  VFMADD231SSZrb_Intk,
  VFMADD231SSZrb_Intkz,
  VFMADD231SSm,
  VFMADD231SSm_Int,
  VFMADD231SSr,
  VFMADD231SSr_Int,
  VFMADDCPHZ128m,
  VFMADDCPHZ128mb,
  VFMADDCPHZ128mbk,
  VFMADDCPHZ128mbkz,
  VFMADDCPHZ128mk,
  VFMADDCPHZ128mkz,
  VFMADDCPHZ128r,
  VFMADDCPHZ128rk,
  VFMADDCPHZ128rkz,
  VFMADDCPHZ256m,
  VFMADDCPHZ256mb,
  VFMADDCPHZ256mbk,
  VFMADDCPHZ256mbkz,
  VFMADDCPHZ256mk,
  VFMADDCPHZ256mkz,
  VFMADDCPHZ256r,
  VFMADDCPHZ256rk,
  VFMADDCPHZ256rkz,
  VFMADDCPHZm,
  VFMADDCPHZmb,
  VFMADDCPHZmbk,
  VFMADDCPHZmbkz,
  VFMADDCPHZmk,
  VFMADDCPHZmkz,
  VFMADDCPHZr,
  VFMADDCPHZrb,
  VFMADDCPHZrbk,
  VFMADDCPHZrbkz,
  VFMADDCPHZrk,
  VFMADDCPHZrkz,
  VFMADDCSHZm,
  VFMADDCSHZmk,
  VFMADDCSHZmkz,
  VFMADDCSHZr,
  VFMADDCSHZrb,
  VFMADDCSHZrbk,
  VFMADDCSHZrbkz,
  VFMADDCSHZrk,
  VFMADDCSHZrkz,
  VFMADDPD4Ymr,
  VFMADDPD4Yrm,
  VFMADDPD4Yrr,
  VFMADDPD4Yrr_REV,
  VFMADDPD4mr,
  VFMADDPD4rm,
  VFMADDPD4rr,
  VFMADDPD4rr_REV,
  VFMADDPS4Ymr,
  VFMADDPS4Yrm,
  VFMADDPS4Yrr,
  VFMADDPS4Yrr_REV,
  VFMADDPS4mr,
  VFMADDPS4rm,
  VFMADDPS4rr,
  VFMADDPS4rr_REV,
  VFMADDSD4mr,
  VFMADDSD4mr_Int,
  VFMADDSD4rm,
  VFMADDSD4rm_Int,
  VFMADDSD4rr,
  VFMADDSD4rr_Int,
  VFMADDSD4rr_Int_REV,
  VFMADDSD4rr_REV,
  VFMADDSS4mr,
  VFMADDSS4mr_Int,
  VFMADDSS4rm,
  VFMADDSS4rm_Int,
  VFMADDSS4rr,
  VFMADDSS4rr_Int,
  VFMADDSS4rr_Int_REV,
  VFMADDSS4rr_REV,
  VFMADDSUB132PDYm,
  VFMADDSUB132PDYr,
  VFMADDSUB132PDZ128m,
  VFMADDSUB132PDZ128mb,
  VFMADDSUB132PDZ128mbk,
  VFMADDSUB132PDZ128mbkz,
  VFMADDSUB132PDZ128mk,
  VFMADDSUB132PDZ128mkz,
  VFMADDSUB132PDZ128r,
  VFMADDSUB132PDZ128rk,
  VFMADDSUB132PDZ128rkz,
  VFMADDSUB132PDZ256m,
  VFMADDSUB132PDZ256mb,
  VFMADDSUB132PDZ256mbk,
  VFMADDSUB132PDZ256mbkz,
  VFMADDSUB132PDZ256mk,
  VFMADDSUB132PDZ256mkz,
  VFMADDSUB132PDZ256r,
  VFMADDSUB132PDZ256rk,
  VFMADDSUB132PDZ256rkz,
  VFMADDSUB132PDZm,
  VFMADDSUB132PDZmb,
  VFMADDSUB132PDZmbk,
  VFMADDSUB132PDZmbkz,
  VFMADDSUB132PDZmk,
  VFMADDSUB132PDZmkz,
  VFMADDSUB132PDZr,
  VFMADDSUB132PDZrb,
  VFMADDSUB132PDZrbk,
  VFMADDSUB132PDZrbkz,
  VFMADDSUB132PDZrk,
  VFMADDSUB132PDZrkz,
  VFMADDSUB132PDm,
  VFMADDSUB132PDr,
  VFMADDSUB132PHZ128m,
  VFMADDSUB132PHZ128mb,
  VFMADDSUB132PHZ128mbk,
  VFMADDSUB132PHZ128mbkz,
  VFMADDSUB132PHZ128mk,
  VFMADDSUB132PHZ128mkz,
  VFMADDSUB132PHZ128r,
  VFMADDSUB132PHZ128rk,
  VFMADDSUB132PHZ128rkz,
  VFMADDSUB132PHZ256m,
  VFMADDSUB132PHZ256mb,
  VFMADDSUB132PHZ256mbk,
  VFMADDSUB132PHZ256mbkz,
  VFMADDSUB132PHZ256mk,
  VFMADDSUB132PHZ256mkz,
  VFMADDSUB132PHZ256r,
  VFMADDSUB132PHZ256rk,
  VFMADDSUB132PHZ256rkz,
  VFMADDSUB132PHZm,
  VFMADDSUB132PHZmb,
  VFMADDSUB132PHZmbk,
  VFMADDSUB132PHZmbkz,
  VFMADDSUB132PHZmk,
  VFMADDSUB132PHZmkz,
  VFMADDSUB132PHZr,
  VFMADDSUB132PHZrb,
  VFMADDSUB132PHZrbk,
  VFMADDSUB132PHZrbkz,
  VFMADDSUB132PHZrk,
  VFMADDSUB132PHZrkz,
  VFMADDSUB132PSYm,
  VFMADDSUB132PSYr,
  VFMADDSUB132PSZ128m,
  VFMADDSUB132PSZ128mb,
  VFMADDSUB132PSZ128mbk,
  VFMADDSUB132PSZ128mbkz,
  VFMADDSUB132PSZ128mk,
  VFMADDSUB132PSZ128mkz,
  VFMADDSUB132PSZ128r,
  VFMADDSUB132PSZ128rk,
  VFMADDSUB132PSZ128rkz,
  VFMADDSUB132PSZ256m,
  VFMADDSUB132PSZ256mb,
  VFMADDSUB132PSZ256mbk,
  VFMADDSUB132PSZ256mbkz,
  VFMADDSUB132PSZ256mk,
  VFMADDSUB132PSZ256mkz,
  VFMADDSUB132PSZ256r,
  VFMADDSUB132PSZ256rk,
  VFMADDSUB132PSZ256rkz,
  VFMADDSUB132PSZm,
  VFMADDSUB132PSZmb,
  VFMADDSUB132PSZmbk,
  VFMADDSUB132PSZmbkz,
  VFMADDSUB132PSZmk,
  VFMADDSUB132PSZmkz,
  VFMADDSUB132PSZr,
  VFMADDSUB132PSZrb,
  VFMADDSUB132PSZrbk,
  VFMADDSUB132PSZrbkz,
  VFMADDSUB132PSZrk,
  VFMADDSUB132PSZrkz,
  VFMADDSUB132PSm,
  VFMADDSUB132PSr,
  VFMADDSUB213PDYm,
  VFMADDSUB213PDYr,
  VFMADDSUB213PDZ128m,
  VFMADDSUB213PDZ128mb,
  VFMADDSUB213PDZ128mbk,
  VFMADDSUB213PDZ128mbkz,
  VFMADDSUB213PDZ128mk,
  VFMADDSUB213PDZ128mkz,
  VFMADDSUB213PDZ128r,
  VFMADDSUB213PDZ128rk,
  VFMADDSUB213PDZ128rkz,
  VFMADDSUB213PDZ256m,
  VFMADDSUB213PDZ256mb,
  VFMADDSUB213PDZ256mbk,
  VFMADDSUB213PDZ256mbkz,
  VFMADDSUB213PDZ256mk,
  VFMADDSUB213PDZ256mkz,
  VFMADDSUB213PDZ256r,
  VFMADDSUB213PDZ256rk,
  VFMADDSUB213PDZ256rkz,
  VFMADDSUB213PDZm,
  VFMADDSUB213PDZmb,
  VFMADDSUB213PDZmbk,
  VFMADDSUB213PDZmbkz,
  VFMADDSUB213PDZmk,
  VFMADDSUB213PDZmkz,
  VFMADDSUB213PDZr,
  VFMADDSUB213PDZrb,
  VFMADDSUB213PDZrbk,
  VFMADDSUB213PDZrbkz,
  VFMADDSUB213PDZrk,
  VFMADDSUB213PDZrkz,
  VFMADDSUB213PDm,
  VFMADDSUB213PDr,
  VFMADDSUB213PHZ128m,
  VFMADDSUB213PHZ128mb,
  VFMADDSUB213PHZ128mbk,
  VFMADDSUB213PHZ128mbkz,
  VFMADDSUB213PHZ128mk,
  VFMADDSUB213PHZ128mkz,
  VFMADDSUB213PHZ128r,
  VFMADDSUB213PHZ128rk,
  VFMADDSUB213PHZ128rkz,
  VFMADDSUB213PHZ256m,
  VFMADDSUB213PHZ256mb,
  VFMADDSUB213PHZ256mbk,
  VFMADDSUB213PHZ256mbkz,
  VFMADDSUB213PHZ256mk,
  VFMADDSUB213PHZ256mkz,
  VFMADDSUB213PHZ256r,
  VFMADDSUB213PHZ256rk,
  VFMADDSUB213PHZ256rkz,
  VFMADDSUB213PHZm,
  VFMADDSUB213PHZmb,
  VFMADDSUB213PHZmbk,
  VFMADDSUB213PHZmbkz,
  VFMADDSUB213PHZmk,
  VFMADDSUB213PHZmkz,
  VFMADDSUB213PHZr,
  VFMADDSUB213PHZrb,
  VFMADDSUB213PHZrbk,
  VFMADDSUB213PHZrbkz,
  VFMADDSUB213PHZrk,
  VFMADDSUB213PHZrkz,
  VFMADDSUB213PSYm,
  VFMADDSUB213PSYr,
  VFMADDSUB213PSZ128m,
  VFMADDSUB213PSZ128mb,
  VFMADDSUB213PSZ128mbk,
  VFMADDSUB213PSZ128mbkz,
  VFMADDSUB213PSZ128mk,
  VFMADDSUB213PSZ128mkz,
  VFMADDSUB213PSZ128r,
  VFMADDSUB213PSZ128rk,
  VFMADDSUB213PSZ128rkz,
  VFMADDSUB213PSZ256m,
  VFMADDSUB213PSZ256mb,
  VFMADDSUB213PSZ256mbk,
  VFMADDSUB213PSZ256mbkz,
  VFMADDSUB213PSZ256mk,
  VFMADDSUB213PSZ256mkz,
  VFMADDSUB213PSZ256r,
  VFMADDSUB213PSZ256rk,
  VFMADDSUB213PSZ256rkz,
  VFMADDSUB213PSZm,
  VFMADDSUB213PSZmb,
  VFMADDSUB213PSZmbk,
  VFMADDSUB213PSZmbkz,
  VFMADDSUB213PSZmk,
  VFMADDSUB213PSZmkz,
  VFMADDSUB213PSZr,
  VFMADDSUB213PSZrb,
  VFMADDSUB213PSZrbk,
  VFMADDSUB213PSZrbkz,
  VFMADDSUB213PSZrk,
  VFMADDSUB213PSZrkz,
  VFMADDSUB213PSm,
  VFMADDSUB213PSr,
  VFMADDSUB231PDYm,
  VFMADDSUB231PDYr,
  VFMADDSUB231PDZ128m,
  VFMADDSUB231PDZ128mb,
  VFMADDSUB231PDZ128mbk,
  VFMADDSUB231PDZ128mbkz,
  VFMADDSUB231PDZ128mk,
  VFMADDSUB231PDZ128mkz,
  VFMADDSUB231PDZ128r,
  VFMADDSUB231PDZ128rk,
  VFMADDSUB231PDZ128rkz,
  VFMADDSUB231PDZ256m,
  VFMADDSUB231PDZ256mb,
  VFMADDSUB231PDZ256mbk,
  VFMADDSUB231PDZ256mbkz,
  VFMADDSUB231PDZ256mk,
  VFMADDSUB231PDZ256mkz,
  VFMADDSUB231PDZ256r,
  VFMADDSUB231PDZ256rk,
  VFMADDSUB231PDZ256rkz,
  VFMADDSUB231PDZm,
  VFMADDSUB231PDZmb,
  VFMADDSUB231PDZmbk,
  VFMADDSUB231PDZmbkz,
  VFMADDSUB231PDZmk,
  VFMADDSUB231PDZmkz,
  VFMADDSUB231PDZr,
  VFMADDSUB231PDZrb,
  VFMADDSUB231PDZrbk,
  VFMADDSUB231PDZrbkz,
  VFMADDSUB231PDZrk,
  VFMADDSUB231PDZrkz,
  VFMADDSUB231PDm,
  VFMADDSUB231PDr,
  VFMADDSUB231PHZ128m,
  VFMADDSUB231PHZ128mb,
  VFMADDSUB231PHZ128mbk,
  VFMADDSUB231PHZ128mbkz,
  VFMADDSUB231PHZ128mk,
  VFMADDSUB231PHZ128mkz,
  VFMADDSUB231PHZ128r,
  VFMADDSUB231PHZ128rk,
  VFMADDSUB231PHZ128rkz,
  VFMADDSUB231PHZ256m,
  VFMADDSUB231PHZ256mb,
  VFMADDSUB231PHZ256mbk,
  VFMADDSUB231PHZ256mbkz,
  VFMADDSUB231PHZ256mk,
  VFMADDSUB231PHZ256mkz,
  VFMADDSUB231PHZ256r,
  VFMADDSUB231PHZ256rk,
  VFMADDSUB231PHZ256rkz,
  VFMADDSUB231PHZm,
  VFMADDSUB231PHZmb,
  VFMADDSUB231PHZmbk,
  VFMADDSUB231PHZmbkz,
  VFMADDSUB231PHZmk,
  VFMADDSUB231PHZmkz,
  VFMADDSUB231PHZr,
  VFMADDSUB231PHZrb,
  VFMADDSUB231PHZrbk,
  VFMADDSUB231PHZrbkz,
  VFMADDSUB231PHZrk,
  VFMADDSUB231PHZrkz,
  VFMADDSUB231PSYm,
  VFMADDSUB231PSYr,
  VFMADDSUB231PSZ128m,
  VFMADDSUB231PSZ128mb,
  VFMADDSUB231PSZ128mbk,
  VFMADDSUB231PSZ128mbkz,
  VFMADDSUB231PSZ128mk,
  VFMADDSUB231PSZ128mkz,
  VFMADDSUB231PSZ128r,
  VFMADDSUB231PSZ128rk,
  VFMADDSUB231PSZ128rkz,
  VFMADDSUB231PSZ256m,
  VFMADDSUB231PSZ256mb,
  VFMADDSUB231PSZ256mbk,
  VFMADDSUB231PSZ256mbkz,
  VFMADDSUB231PSZ256mk,
  VFMADDSUB231PSZ256mkz,
  VFMADDSUB231PSZ256r,
  VFMADDSUB231PSZ256rk,
  VFMADDSUB231PSZ256rkz,
  VFMADDSUB231PSZm,
  VFMADDSUB231PSZmb,
  VFMADDSUB231PSZmbk,
  VFMADDSUB231PSZmbkz,
  VFMADDSUB231PSZmk,
  VFMADDSUB231PSZmkz,
  VFMADDSUB231PSZr,
  VFMADDSUB231PSZrb,
  VFMADDSUB231PSZrbk,
  VFMADDSUB231PSZrbkz,
  VFMADDSUB231PSZrk,
  VFMADDSUB231PSZrkz,
  VFMADDSUB231PSm,
  VFMADDSUB231PSr,
  VFMADDSUBPD4Ymr,
  VFMADDSUBPD4Yrm,
  VFMADDSUBPD4Yrr,
  VFMADDSUBPD4Yrr_REV,
  VFMADDSUBPD4mr,
  VFMADDSUBPD4rm,
  VFMADDSUBPD4rr,
  VFMADDSUBPD4rr_REV,
  VFMADDSUBPS4Ymr,
  VFMADDSUBPS4Yrm,
  VFMADDSUBPS4Yrr,
  VFMADDSUBPS4Yrr_REV,
  VFMADDSUBPS4mr,
  VFMADDSUBPS4rm,
  VFMADDSUBPS4rr,
  VFMADDSUBPS4rr_REV,
  VFMSUB132PDYm,
  VFMSUB132PDYr,
  VFMSUB132PDZ128m,
  VFMSUB132PDZ128mb,
  VFMSUB132PDZ128mbk,
  VFMSUB132PDZ128mbkz,
  VFMSUB132PDZ128mk,
  VFMSUB132PDZ128mkz,
  VFMSUB132PDZ128r,
  VFMSUB132PDZ128rk,
  VFMSUB132PDZ128rkz,
  VFMSUB132PDZ256m,
  VFMSUB132PDZ256mb,
  VFMSUB132PDZ256mbk,
  VFMSUB132PDZ256mbkz,
  VFMSUB132PDZ256mk,
  VFMSUB132PDZ256mkz,
  VFMSUB132PDZ256r,
  VFMSUB132PDZ256rk,
  VFMSUB132PDZ256rkz,
  VFMSUB132PDZm,
  VFMSUB132PDZmb,
  VFMSUB132PDZmbk,
  VFMSUB132PDZmbkz,
  VFMSUB132PDZmk,
  VFMSUB132PDZmkz,
  VFMSUB132PDZr,
  VFMSUB132PDZrb,
  VFMSUB132PDZrbk,
  VFMSUB132PDZrbkz,
  VFMSUB132PDZrk,
  VFMSUB132PDZrkz,
  VFMSUB132PDm,
  VFMSUB132PDr,
  VFMSUB132PHZ128m,
  VFMSUB132PHZ128mb,
  VFMSUB132PHZ128mbk,
  VFMSUB132PHZ128mbkz,
  VFMSUB132PHZ128mk,
  VFMSUB132PHZ128mkz,
  VFMSUB132PHZ128r,
  VFMSUB132PHZ128rk,
  VFMSUB132PHZ128rkz,
  VFMSUB132PHZ256m,
  VFMSUB132PHZ256mb,
  VFMSUB132PHZ256mbk,
  VFMSUB132PHZ256mbkz,
  VFMSUB132PHZ256mk,
  VFMSUB132PHZ256mkz,
  VFMSUB132PHZ256r,
  VFMSUB132PHZ256rk,
  VFMSUB132PHZ256rkz,
  VFMSUB132PHZm,
  VFMSUB132PHZmb,
  VFMSUB132PHZmbk,
  VFMSUB132PHZmbkz,
  VFMSUB132PHZmk,
  VFMSUB132PHZmkz,
  VFMSUB132PHZr,
  VFMSUB132PHZrb,
  VFMSUB132PHZrbk,
  VFMSUB132PHZrbkz,
  VFMSUB132PHZrk,
  VFMSUB132PHZrkz,
  VFMSUB132PSYm,
  VFMSUB132PSYr,
  VFMSUB132PSZ128m,
  VFMSUB132PSZ128mb,
  VFMSUB132PSZ128mbk,
  VFMSUB132PSZ128mbkz,
  VFMSUB132PSZ128mk,
  VFMSUB132PSZ128mkz,
  VFMSUB132PSZ128r,
  VFMSUB132PSZ128rk,
  VFMSUB132PSZ128rkz,
  VFMSUB132PSZ256m,
  VFMSUB132PSZ256mb,
  VFMSUB132PSZ256mbk,
  VFMSUB132PSZ256mbkz,
  VFMSUB132PSZ256mk,
  VFMSUB132PSZ256mkz,
  VFMSUB132PSZ256r,
  VFMSUB132PSZ256rk,
  VFMSUB132PSZ256rkz,
  VFMSUB132PSZm,
  VFMSUB132PSZmb,
  VFMSUB132PSZmbk,
  VFMSUB132PSZmbkz,
  VFMSUB132PSZmk,
  VFMSUB132PSZmkz,
  VFMSUB132PSZr,
  VFMSUB132PSZrb,
  VFMSUB132PSZrbk,
  VFMSUB132PSZrbkz,
  VFMSUB132PSZrk,
  VFMSUB132PSZrkz,
  VFMSUB132PSm,
  VFMSUB132PSr,
  VFMSUB132SDZm,
  VFMSUB132SDZm_Int,
  VFMSUB132SDZm_Intk,
  VFMSUB132SDZm_Intkz,
  VFMSUB132SDZr,
  VFMSUB132SDZr_Int,
  VFMSUB132SDZr_Intk,
  VFMSUB132SDZr_Intkz,
  VFMSUB132SDZrb,
  VFMSUB132SDZrb_Int,
  VFMSUB132SDZrb_Intk,
  VFMSUB132SDZrb_Intkz,
  VFMSUB132SDm,
  VFMSUB132SDm_Int,
  VFMSUB132SDr,
  VFMSUB132SDr_Int,
  VFMSUB132SHZm,
  VFMSUB132SHZm_Int,
  VFMSUB132SHZm_Intk,
  VFMSUB132SHZm_Intkz,
  VFMSUB132SHZr,
  VFMSUB132SHZr_Int,
  VFMSUB132SHZr_Intk,
  VFMSUB132SHZr_Intkz,
  VFMSUB132SHZrb,
  VFMSUB132SHZrb_Int,
  VFMSUB132SHZrb_Intk,
  VFMSUB132SHZrb_Intkz,
  VFMSUB132SSZm,
  VFMSUB132SSZm_Int,
  VFMSUB132SSZm_Intk,
  VFMSUB132SSZm_Intkz,
  VFMSUB132SSZr,
  VFMSUB132SSZr_Int,
  VFMSUB132SSZr_Intk,
  VFMSUB132SSZr_Intkz,
  VFMSUB132SSZrb,
  VFMSUB132SSZrb_Int,
  VFMSUB132SSZrb_Intk,
  VFMSUB132SSZrb_Intkz,
  VFMSUB132SSm,
  VFMSUB132SSm_Int,
  VFMSUB132SSr,
  VFMSUB132SSr_Int,
  VFMSUB213PDYm,
  VFMSUB213PDYr,
  VFMSUB213PDZ128m,
  VFMSUB213PDZ128mb,
  VFMSUB213PDZ128mbk,
  VFMSUB213PDZ128mbkz,
  VFMSUB213PDZ128mk,
  VFMSUB213PDZ128mkz,
  VFMSUB213PDZ128r,
  VFMSUB213PDZ128rk,
  VFMSUB213PDZ128rkz,
  VFMSUB213PDZ256m,
  VFMSUB213PDZ256mb,
  VFMSUB213PDZ256mbk,
  VFMSUB213PDZ256mbkz,
  VFMSUB213PDZ256mk,
  VFMSUB213PDZ256mkz,
  VFMSUB213PDZ256r,
  VFMSUB213PDZ256rk,
  VFMSUB213PDZ256rkz,
  VFMSUB213PDZm,
  VFMSUB213PDZmb,
  VFMSUB213PDZmbk,
  VFMSUB213PDZmbkz,
  VFMSUB213PDZmk,
  VFMSUB213PDZmkz,
  VFMSUB213PDZr,
  VFMSUB213PDZrb,
  VFMSUB213PDZrbk,
  VFMSUB213PDZrbkz,
  VFMSUB213PDZrk,
  VFMSUB213PDZrkz,
  VFMSUB213PDm,
  VFMSUB213PDr,
  VFMSUB213PHZ128m,
  VFMSUB213PHZ128mb,
  VFMSUB213PHZ128mbk,
  VFMSUB213PHZ128mbkz,
  VFMSUB213PHZ128mk,
  VFMSUB213PHZ128mkz,
  VFMSUB213PHZ128r,
  VFMSUB213PHZ128rk,
  VFMSUB213PHZ128rkz,
  VFMSUB213PHZ256m,
  VFMSUB213PHZ256mb,
  VFMSUB213PHZ256mbk,
  VFMSUB213PHZ256mbkz,
  VFMSUB213PHZ256mk,
  VFMSUB213PHZ256mkz,
  VFMSUB213PHZ256r,
  VFMSUB213PHZ256rk,
  VFMSUB213PHZ256rkz,
  VFMSUB213PHZm,
  VFMSUB213PHZmb,
  VFMSUB213PHZmbk,
  VFMSUB213PHZmbkz,
  VFMSUB213PHZmk,
  VFMSUB213PHZmkz,
  VFMSUB213PHZr,
  VFMSUB213PHZrb,
  VFMSUB213PHZrbk,
  VFMSUB213PHZrbkz,
  VFMSUB213PHZrk,
  VFMSUB213PHZrkz,
  VFMSUB213PSYm,
  VFMSUB213PSYr,
  VFMSUB213PSZ128m,
  VFMSUB213PSZ128mb,
  VFMSUB213PSZ128mbk,
  VFMSUB213PSZ128mbkz,
  VFMSUB213PSZ128mk,
  VFMSUB213PSZ128mkz,
  VFMSUB213PSZ128r,
  VFMSUB213PSZ128rk,
  VFMSUB213PSZ128rkz,
  VFMSUB213PSZ256m,
  VFMSUB213PSZ256mb,
  VFMSUB213PSZ256mbk,
  VFMSUB213PSZ256mbkz,
  VFMSUB213PSZ256mk,
  VFMSUB213PSZ256mkz,
  VFMSUB213PSZ256r,
  VFMSUB213PSZ256rk,
  VFMSUB213PSZ256rkz,
  VFMSUB213PSZm,
  VFMSUB213PSZmb,
  VFMSUB213PSZmbk,
  VFMSUB213PSZmbkz,
  VFMSUB213PSZmk,
  VFMSUB213PSZmkz,
  VFMSUB213PSZr,
  VFMSUB213PSZrb,
  VFMSUB213PSZrbk,
  VFMSUB213PSZrbkz,
  VFMSUB213PSZrk,
  VFMSUB213PSZrkz,
  VFMSUB213PSm,
  VFMSUB213PSr,
  VFMSUB213SDZm,
  VFMSUB213SDZm_Int,
  VFMSUB213SDZm_Intk,
  VFMSUB213SDZm_Intkz,
  VFMSUB213SDZr,
  VFMSUB213SDZr_Int,
  VFMSUB213SDZr_Intk,
  VFMSUB213SDZr_Intkz,
  VFMSUB213SDZrb,
  VFMSUB213SDZrb_Int,
  VFMSUB213SDZrb_Intk,
  VFMSUB213SDZrb_Intkz,
  VFMSUB213SDm,
  VFMSUB213SDm_Int,
  VFMSUB213SDr,
  VFMSUB213SDr_Int,
  VFMSUB213SHZm,
  VFMSUB213SHZm_Int,
  VFMSUB213SHZm_Intk,
  VFMSUB213SHZm_Intkz,
  VFMSUB213SHZr,
  VFMSUB213SHZr_Int,
  VFMSUB213SHZr_Intk,
  VFMSUB213SHZr_Intkz,
  VFMSUB213SHZrb,
  VFMSUB213SHZrb_Int,
  VFMSUB213SHZrb_Intk,
  VFMSUB213SHZrb_Intkz,
  VFMSUB213SSZm,
  VFMSUB213SSZm_Int,
  VFMSUB213SSZm_Intk,
  VFMSUB213SSZm_Intkz,
  VFMSUB213SSZr,
  VFMSUB213SSZr_Int,
  VFMSUB213SSZr_Intk,
  VFMSUB213SSZr_Intkz,
  VFMSUB213SSZrb,
  VFMSUB213SSZrb_Int,
  VFMSUB213SSZrb_Intk,
  VFMSUB213SSZrb_Intkz,
  VFMSUB213SSm,
  VFMSUB213SSm_Int,
  VFMSUB213SSr,
  VFMSUB213SSr_Int,
  VFMSUB231PDYm,
  VFMSUB231PDYr,
  VFMSUB231PDZ128m,
  VFMSUB231PDZ128mb,
  VFMSUB231PDZ128mbk,
  VFMSUB231PDZ128mbkz,
  VFMSUB231PDZ128mk,
  VFMSUB231PDZ128mkz,
  VFMSUB231PDZ128r,
  VFMSUB231PDZ128rk,
  VFMSUB231PDZ128rkz,
  VFMSUB231PDZ256m,
  VFMSUB231PDZ256mb,
  VFMSUB231PDZ256mbk,
  VFMSUB231PDZ256mbkz,
  VFMSUB231PDZ256mk,
  VFMSUB231PDZ256mkz,
  VFMSUB231PDZ256r,
  VFMSUB231PDZ256rk,
  VFMSUB231PDZ256rkz,
  VFMSUB231PDZm,
  VFMSUB231PDZmb,
  VFMSUB231PDZmbk,
  VFMSUB231PDZmbkz,
  VFMSUB231PDZmk,
  VFMSUB231PDZmkz,
  VFMSUB231PDZr,
  VFMSUB231PDZrb,
  VFMSUB231PDZrbk,
  VFMSUB231PDZrbkz,
  VFMSUB231PDZrk,
  VFMSUB231PDZrkz,
  VFMSUB231PDm,
  VFMSUB231PDr,
  VFMSUB231PHZ128m,
  VFMSUB231PHZ128mb,
  VFMSUB231PHZ128mbk,
  VFMSUB231PHZ128mbkz,
  VFMSUB231PHZ128mk,
  VFMSUB231PHZ128mkz,
  VFMSUB231PHZ128r,
  VFMSUB231PHZ128rk,
  VFMSUB231PHZ128rkz,
  VFMSUB231PHZ256m,
  VFMSUB231PHZ256mb,
  VFMSUB231PHZ256mbk,
  VFMSUB231PHZ256mbkz,
  VFMSUB231PHZ256mk,
  VFMSUB231PHZ256mkz,
  VFMSUB231PHZ256r,
  VFMSUB231PHZ256rk,
  VFMSUB231PHZ256rkz,
  VFMSUB231PHZm,
  VFMSUB231PHZmb,
  VFMSUB231PHZmbk,
  VFMSUB231PHZmbkz,
  VFMSUB231PHZmk,
  VFMSUB231PHZmkz,
  VFMSUB231PHZr,
  VFMSUB231PHZrb,
  VFMSUB231PHZrbk,
  VFMSUB231PHZrbkz,
  VFMSUB231PHZrk,
  VFMSUB231PHZrkz,
  VFMSUB231PSYm,
  VFMSUB231PSYr,
  VFMSUB231PSZ128m,
  VFMSUB231PSZ128mb,
  VFMSUB231PSZ128mbk,
  VFMSUB231PSZ128mbkz,
  VFMSUB231PSZ128mk,
  VFMSUB231PSZ128mkz,
  VFMSUB231PSZ128r,
  VFMSUB231PSZ128rk,
  VFMSUB231PSZ128rkz,
  VFMSUB231PSZ256m,
  VFMSUB231PSZ256mb,
  VFMSUB231PSZ256mbk,
  VFMSUB231PSZ256mbkz,
  VFMSUB231PSZ256mk,
  VFMSUB231PSZ256mkz,
  VFMSUB231PSZ256r,
  VFMSUB231PSZ256rk,
  VFMSUB231PSZ256rkz,
  VFMSUB231PSZm,
  VFMSUB231PSZmb,
  VFMSUB231PSZmbk,
  VFMSUB231PSZmbkz,
  VFMSUB231PSZmk,
  VFMSUB231PSZmkz,
  VFMSUB231PSZr,
  VFMSUB231PSZrb,
  VFMSUB231PSZrbk,
  VFMSUB231PSZrbkz,
  VFMSUB231PSZrk,
  VFMSUB231PSZrkz,
  VFMSUB231PSm,
  VFMSUB231PSr,
  VFMSUB231SDZm,
  VFMSUB231SDZm_Int,
  VFMSUB231SDZm_Intk,
  VFMSUB231SDZm_Intkz,
  VFMSUB231SDZr,
  VFMSUB231SDZr_Int,
  VFMSUB231SDZr_Intk,
  VFMSUB231SDZr_Intkz,
  VFMSUB231SDZrb,
  VFMSUB231SDZrb_Int,
  VFMSUB231SDZrb_Intk,
  VFMSUB231SDZrb_Intkz,
  VFMSUB231SDm,
  VFMSUB231SDm_Int,
  VFMSUB231SDr,
  VFMSUB231SDr_Int,
  VFMSUB231SHZm,
  VFMSUB231SHZm_Int,
  VFMSUB231SHZm_Intk,
  VFMSUB231SHZm_Intkz,
  VFMSUB231SHZr,
  VFMSUB231SHZr_Int,
  VFMSUB231SHZr_Intk,
  VFMSUB231SHZr_Intkz,
  VFMSUB231SHZrb,
  VFMSUB231SHZrb_Int,
  VFMSUB231SHZrb_Intk,
  VFMSUB231SHZrb_Intkz,
  VFMSUB231SSZm,
  VFMSUB231SSZm_Int,
  VFMSUB231SSZm_Intk,
  VFMSUB231SSZm_Intkz,
  VFMSUB231SSZr,
  VFMSUB231SSZr_Int,
  VFMSUB231SSZr_Intk,
  VFMSUB231SSZr_Intkz,
  VFMSUB231SSZrb,
  VFMSUB231SSZrb_Int,
  VFMSUB231SSZrb_Intk,
  VFMSUB231SSZrb_Intkz,
  VFMSUB231SSm,
  VFMSUB231SSm_Int,
  VFMSUB231SSr,
  VFMSUB231SSr_Int,
  VFMSUBADD132PDYm,
  VFMSUBADD132PDYr,
  VFMSUBADD132PDZ128m,
  VFMSUBADD132PDZ128mb,
  VFMSUBADD132PDZ128mbk,
  VFMSUBADD132PDZ128mbkz,
  VFMSUBADD132PDZ128mk,
  VFMSUBADD132PDZ128mkz,
  VFMSUBADD132PDZ128r,
  VFMSUBADD132PDZ128rk,
  VFMSUBADD132PDZ128rkz,
  VFMSUBADD132PDZ256m,
  VFMSUBADD132PDZ256mb,
  VFMSUBADD132PDZ256mbk,
  VFMSUBADD132PDZ256mbkz,
  VFMSUBADD132PDZ256mk,
  VFMSUBADD132PDZ256mkz,
  VFMSUBADD132PDZ256r,
  VFMSUBADD132PDZ256rk,
  VFMSUBADD132PDZ256rkz,
  VFMSUBADD132PDZm,
  VFMSUBADD132PDZmb,
  VFMSUBADD132PDZmbk,
  VFMSUBADD132PDZmbkz,
  VFMSUBADD132PDZmk,
  VFMSUBADD132PDZmkz,
  VFMSUBADD132PDZr,
  VFMSUBADD132PDZrb,
  VFMSUBADD132PDZrbk,
  VFMSUBADD132PDZrbkz,
  VFMSUBADD132PDZrk,
  VFMSUBADD132PDZrkz,
  VFMSUBADD132PDm,
  VFMSUBADD132PDr,
  VFMSUBADD132PHZ128m,
  VFMSUBADD132PHZ128mb,
  VFMSUBADD132PHZ128mbk,
  VFMSUBADD132PHZ128mbkz,
  VFMSUBADD132PHZ128mk,
  VFMSUBADD132PHZ128mkz,
  VFMSUBADD132PHZ128r,
  VFMSUBADD132PHZ128rk,
  VFMSUBADD132PHZ128rkz,
  VFMSUBADD132PHZ256m,
  VFMSUBADD132PHZ256mb,
  VFMSUBADD132PHZ256mbk,
  VFMSUBADD132PHZ256mbkz,
  VFMSUBADD132PHZ256mk,
  VFMSUBADD132PHZ256mkz,
  VFMSUBADD132PHZ256r,
  VFMSUBADD132PHZ256rk,
  VFMSUBADD132PHZ256rkz,
  VFMSUBADD132PHZm,
  VFMSUBADD132PHZmb,
  VFMSUBADD132PHZmbk,
  VFMSUBADD132PHZmbkz,
  VFMSUBADD132PHZmk,
  VFMSUBADD132PHZmkz,
  VFMSUBADD132PHZr,
  VFMSUBADD132PHZrb,
  VFMSUBADD132PHZrbk,
  VFMSUBADD132PHZrbkz,
  VFMSUBADD132PHZrk,
  VFMSUBADD132PHZrkz,
  VFMSUBADD132PSYm,
  VFMSUBADD132PSYr,
  VFMSUBADD132PSZ128m,
  VFMSUBADD132PSZ128mb,
  VFMSUBADD132PSZ128mbk,
  VFMSUBADD132PSZ128mbkz,
  VFMSUBADD132PSZ128mk,
  VFMSUBADD132PSZ128mkz,
  VFMSUBADD132PSZ128r,
  VFMSUBADD132PSZ128rk,
  VFMSUBADD132PSZ128rkz,
  VFMSUBADD132PSZ256m,
  VFMSUBADD132PSZ256mb,
  VFMSUBADD132PSZ256mbk,
  VFMSUBADD132PSZ256mbkz,
  VFMSUBADD132PSZ256mk,
  VFMSUBADD132PSZ256mkz,
  VFMSUBADD132PSZ256r,
  VFMSUBADD132PSZ256rk,
  VFMSUBADD132PSZ256rkz,
  VFMSUBADD132PSZm,
  VFMSUBADD132PSZmb,
  VFMSUBADD132PSZmbk,
  VFMSUBADD132PSZmbkz,
  VFMSUBADD132PSZmk,
  VFMSUBADD132PSZmkz,
  VFMSUBADD132PSZr,
  VFMSUBADD132PSZrb,
  VFMSUBADD132PSZrbk,
  VFMSUBADD132PSZrbkz,
  VFMSUBADD132PSZrk,
  VFMSUBADD132PSZrkz,
  VFMSUBADD132PSm,
  VFMSUBADD132PSr,
  VFMSUBADD213PDYm,
  VFMSUBADD213PDYr,
  VFMSUBADD213PDZ128m,
  VFMSUBADD213PDZ128mb,
  VFMSUBADD213PDZ128mbk,
  VFMSUBADD213PDZ128mbkz,
  VFMSUBADD213PDZ128mk,
  VFMSUBADD213PDZ128mkz,
  VFMSUBADD213PDZ128r,
  VFMSUBADD213PDZ128rk,
  VFMSUBADD213PDZ128rkz,
  VFMSUBADD213PDZ256m,
  VFMSUBADD213PDZ256mb,
  VFMSUBADD213PDZ256mbk,
  VFMSUBADD213PDZ256mbkz,
  VFMSUBADD213PDZ256mk,
  VFMSUBADD213PDZ256mkz,
  VFMSUBADD213PDZ256r,
  VFMSUBADD213PDZ256rk,
  VFMSUBADD213PDZ256rkz,
  VFMSUBADD213PDZm,
  VFMSUBADD213PDZmb,
  VFMSUBADD213PDZmbk,
  VFMSUBADD213PDZmbkz,
  VFMSUBADD213PDZmk,
  VFMSUBADD213PDZmkz,
  VFMSUBADD213PDZr,
  VFMSUBADD213PDZrb,
  VFMSUBADD213PDZrbk,
  VFMSUBADD213PDZrbkz,
  VFMSUBADD213PDZrk,
  VFMSUBADD213PDZrkz,
  VFMSUBADD213PDm,
  VFMSUBADD213PDr,
  VFMSUBADD213PHZ128m,
  VFMSUBADD213PHZ128mb,
  VFMSUBADD213PHZ128mbk,
  VFMSUBADD213PHZ128mbkz,
  VFMSUBADD213PHZ128mk,
  VFMSUBADD213PHZ128mkz,
  VFMSUBADD213PHZ128r,
  VFMSUBADD213PHZ128rk,
  VFMSUBADD213PHZ128rkz,
  VFMSUBADD213PHZ256m,
  VFMSUBADD213PHZ256mb,
  VFMSUBADD213PHZ256mbk,
  VFMSUBADD213PHZ256mbkz,
  VFMSUBADD213PHZ256mk,
  VFMSUBADD213PHZ256mkz,
  VFMSUBADD213PHZ256r,
  VFMSUBADD213PHZ256rk,
  VFMSUBADD213PHZ256rkz,
  VFMSUBADD213PHZm,
  VFMSUBADD213PHZmb,
  VFMSUBADD213PHZmbk,
  VFMSUBADD213PHZmbkz,
  VFMSUBADD213PHZmk,
  VFMSUBADD213PHZmkz,
  VFMSUBADD213PHZr,
  VFMSUBADD213PHZrb,
  VFMSUBADD213PHZrbk,
  VFMSUBADD213PHZrbkz,
  VFMSUBADD213PHZrk,
  VFMSUBADD213PHZrkz,
  VFMSUBADD213PSYm,
  VFMSUBADD213PSYr,
  VFMSUBADD213PSZ128m,
  VFMSUBADD213PSZ128mb,
  VFMSUBADD213PSZ128mbk,
  VFMSUBADD213PSZ128mbkz,
  VFMSUBADD213PSZ128mk,
  VFMSUBADD213PSZ128mkz,
  VFMSUBADD213PSZ128r,
  VFMSUBADD213PSZ128rk,
  VFMSUBADD213PSZ128rkz,
  VFMSUBADD213PSZ256m,
  VFMSUBADD213PSZ256mb,
  VFMSUBADD213PSZ256mbk,
  VFMSUBADD213PSZ256mbkz,
  VFMSUBADD213PSZ256mk,
  VFMSUBADD213PSZ256mkz,
  VFMSUBADD213PSZ256r,
  VFMSUBADD213PSZ256rk,
  VFMSUBADD213PSZ256rkz,
  VFMSUBADD213PSZm,
  VFMSUBADD213PSZmb,
  VFMSUBADD213PSZmbk,
  VFMSUBADD213PSZmbkz,
  VFMSUBADD213PSZmk,
  VFMSUBADD213PSZmkz,
  VFMSUBADD213PSZr,
  VFMSUBADD213PSZrb,
  VFMSUBADD213PSZrbk,
  VFMSUBADD213PSZrbkz,
  VFMSUBADD213PSZrk,
  VFMSUBADD213PSZrkz,
  VFMSUBADD213PSm,
  VFMSUBADD213PSr,
  VFMSUBADD231PDYm,
  VFMSUBADD231PDYr,
  VFMSUBADD231PDZ128m,
  VFMSUBADD231PDZ128mb,
  VFMSUBADD231PDZ128mbk,
  VFMSUBADD231PDZ128mbkz,
  VFMSUBADD231PDZ128mk,
  VFMSUBADD231PDZ128mkz,
  VFMSUBADD231PDZ128r,
  VFMSUBADD231PDZ128rk,
  VFMSUBADD231PDZ128rkz,
  VFMSUBADD231PDZ256m,
  VFMSUBADD231PDZ256mb,
  VFMSUBADD231PDZ256mbk,
  VFMSUBADD231PDZ256mbkz,
  VFMSUBADD231PDZ256mk,
  VFMSUBADD231PDZ256mkz,
  VFMSUBADD231PDZ256r,
  VFMSUBADD231PDZ256rk,
  VFMSUBADD231PDZ256rkz,
  VFMSUBADD231PDZm,
  VFMSUBADD231PDZmb,
  VFMSUBADD231PDZmbk,
  VFMSUBADD231PDZmbkz,
  VFMSUBADD231PDZmk,
  VFMSUBADD231PDZmkz,
  VFMSUBADD231PDZr,
  VFMSUBADD231PDZrb,
  VFMSUBADD231PDZrbk,
  VFMSUBADD231PDZrbkz,
  VFMSUBADD231PDZrk,
  VFMSUBADD231PDZrkz,
  VFMSUBADD231PDm,
  VFMSUBADD231PDr,
  VFMSUBADD231PHZ128m,
  VFMSUBADD231PHZ128mb,
  VFMSUBADD231PHZ128mbk,
  VFMSUBADD231PHZ128mbkz,
  VFMSUBADD231PHZ128mk,
  VFMSUBADD231PHZ128mkz,
  VFMSUBADD231PHZ128r,
  VFMSUBADD231PHZ128rk,
  VFMSUBADD231PHZ128rkz,
  VFMSUBADD231PHZ256m,
  VFMSUBADD231PHZ256mb,
  VFMSUBADD231PHZ256mbk,
  VFMSUBADD231PHZ256mbkz,
  VFMSUBADD231PHZ256mk,
  VFMSUBADD231PHZ256mkz,
  VFMSUBADD231PHZ256r,
  VFMSUBADD231PHZ256rk,
  VFMSUBADD231PHZ256rkz,
  VFMSUBADD231PHZm,
  VFMSUBADD231PHZmb,
  VFMSUBADD231PHZmbk,
  VFMSUBADD231PHZmbkz,
  VFMSUBADD231PHZmk,
  VFMSUBADD231PHZmkz,
  VFMSUBADD231PHZr,
  VFMSUBADD231PHZrb,
  VFMSUBADD231PHZrbk,
  VFMSUBADD231PHZrbkz,
  VFMSUBADD231PHZrk,
  VFMSUBADD231PHZrkz,
  VFMSUBADD231PSYm,
  VFMSUBADD231PSYr,
  VFMSUBADD231PSZ128m,
  VFMSUBADD231PSZ128mb,
  VFMSUBADD231PSZ128mbk,
  VFMSUBADD231PSZ128mbkz,
  VFMSUBADD231PSZ128mk,
  VFMSUBADD231PSZ128mkz,
  VFMSUBADD231PSZ128r,
  VFMSUBADD231PSZ128rk,
  VFMSUBADD231PSZ128rkz,
  VFMSUBADD231PSZ256m,
  VFMSUBADD231PSZ256mb,
  VFMSUBADD231PSZ256mbk,
  VFMSUBADD231PSZ256mbkz,
  VFMSUBADD231PSZ256mk,
  VFMSUBADD231PSZ256mkz,
  VFMSUBADD231PSZ256r,
  VFMSUBADD231PSZ256rk,
  VFMSUBADD231PSZ256rkz,
  VFMSUBADD231PSZm,
  VFMSUBADD231PSZmb,
  VFMSUBADD231PSZmbk,
  VFMSUBADD231PSZmbkz,
  VFMSUBADD231PSZmk,
  VFMSUBADD231PSZmkz,
  VFMSUBADD231PSZr,
  VFMSUBADD231PSZrb,
  VFMSUBADD231PSZrbk,
  VFMSUBADD231PSZrbkz,
  VFMSUBADD231PSZrk,
  VFMSUBADD231PSZrkz,
  VFMSUBADD231PSm,
  VFMSUBADD231PSr,
  VFMSUBADDPD4Ymr,
  VFMSUBADDPD4Yrm,
  VFMSUBADDPD4Yrr,
  VFMSUBADDPD4Yrr_REV,
  VFMSUBADDPD4mr,
  VFMSUBADDPD4rm,
  VFMSUBADDPD4rr,
  VFMSUBADDPD4rr_REV,
  VFMSUBADDPS4Ymr,
  VFMSUBADDPS4Yrm,
  VFMSUBADDPS4Yrr,
  VFMSUBADDPS4Yrr_REV,
  VFMSUBADDPS4mr,
  VFMSUBADDPS4rm,
  VFMSUBADDPS4rr,
  VFMSUBADDPS4rr_REV,
  VFMSUBPD4Ymr,
  VFMSUBPD4Yrm,
  VFMSUBPD4Yrr,
  VFMSUBPD4Yrr_REV,
  VFMSUBPD4mr,
  VFMSUBPD4rm,
  VFMSUBPD4rr,
  VFMSUBPD4rr_REV,
  VFMSUBPS4Ymr,
  VFMSUBPS4Yrm,
  VFMSUBPS4Yrr,
  VFMSUBPS4Yrr_REV,
  VFMSUBPS4mr,
  VFMSUBPS4rm,
  VFMSUBPS4rr,
  VFMSUBPS4rr_REV,
  VFMSUBSD4mr,
  VFMSUBSD4mr_Int,
  VFMSUBSD4rm,
  VFMSUBSD4rm_Int,
  VFMSUBSD4rr,
  VFMSUBSD4rr_Int,
  VFMSUBSD4rr_Int_REV,
  VFMSUBSD4rr_REV,
  VFMSUBSS4mr,
  VFMSUBSS4mr_Int,
  VFMSUBSS4rm,
  VFMSUBSS4rm_Int,
  VFMSUBSS4rr,
  VFMSUBSS4rr_Int,
  VFMSUBSS4rr_Int_REV,
  VFMSUBSS4rr_REV,
  VFMULCPHZ128rm,
  VFMULCPHZ128rmb,
  VFMULCPHZ128rmbk,
  VFMULCPHZ128rmbkz,
  VFMULCPHZ128rmk,
  VFMULCPHZ128rmkz,
  VFMULCPHZ128rr,
  VFMULCPHZ128rrk,
  VFMULCPHZ128rrkz,
  VFMULCPHZ256rm,
  VFMULCPHZ256rmb,
  VFMULCPHZ256rmbk,
  VFMULCPHZ256rmbkz,
  VFMULCPHZ256rmk,
  VFMULCPHZ256rmkz,
  VFMULCPHZ256rr,
  VFMULCPHZ256rrk,
  VFMULCPHZ256rrkz,
  VFMULCPHZrm,
  VFMULCPHZrmb,
  VFMULCPHZrmbk,
  VFMULCPHZrmbkz,
  VFMULCPHZrmk,
  VFMULCPHZrmkz,
  VFMULCPHZrr,
  VFMULCPHZrrb,
  VFMULCPHZrrbk,
  VFMULCPHZrrbkz,
  VFMULCPHZrrk,
  VFMULCPHZrrkz,
  VFMULCSHZrm,
  VFMULCSHZrmk,
  VFMULCSHZrmkz,
  VFMULCSHZrr,
  VFMULCSHZrrb,
  VFMULCSHZrrbk,
  VFMULCSHZrrbkz,
  VFMULCSHZrrk,
  VFMULCSHZrrkz,
  VFNMADD132PDYm,
  VFNMADD132PDYr,
  VFNMADD132PDZ128m,
  VFNMADD132PDZ128mb,
  VFNMADD132PDZ128mbk,
  VFNMADD132PDZ128mbkz,
  VFNMADD132PDZ128mk,
  VFNMADD132PDZ128mkz,
  VFNMADD132PDZ128r,
  VFNMADD132PDZ128rk,
  VFNMADD132PDZ128rkz,
  VFNMADD132PDZ256m,
  VFNMADD132PDZ256mb,
  VFNMADD132PDZ256mbk,
  VFNMADD132PDZ256mbkz,
  VFNMADD132PDZ256mk,
  VFNMADD132PDZ256mkz,
  VFNMADD132PDZ256r,
  VFNMADD132PDZ256rk,
  VFNMADD132PDZ256rkz,
  VFNMADD132PDZm,
  VFNMADD132PDZmb,
  VFNMADD132PDZmbk,
  VFNMADD132PDZmbkz,
  VFNMADD132PDZmk,
  VFNMADD132PDZmkz,
  VFNMADD132PDZr,
  VFNMADD132PDZrb,
  VFNMADD132PDZrbk,
  VFNMADD132PDZrbkz,
  VFNMADD132PDZrk,
  VFNMADD132PDZrkz,
  VFNMADD132PDm,
  VFNMADD132PDr,
  VFNMADD132PHZ128m,
  VFNMADD132PHZ128mb,
  VFNMADD132PHZ128mbk,
  VFNMADD132PHZ128mbkz,
  VFNMADD132PHZ128mk,
  VFNMADD132PHZ128mkz,
  VFNMADD132PHZ128r,
  VFNMADD132PHZ128rk,
  VFNMADD132PHZ128rkz,
  VFNMADD132PHZ256m,
  VFNMADD132PHZ256mb,
  VFNMADD132PHZ256mbk,
  VFNMADD132PHZ256mbkz,
  VFNMADD132PHZ256mk,
  VFNMADD132PHZ256mkz,
  VFNMADD132PHZ256r,
  VFNMADD132PHZ256rk,
  VFNMADD132PHZ256rkz,
  VFNMADD132PHZm,
  VFNMADD132PHZmb,
  VFNMADD132PHZmbk,
  VFNMADD132PHZmbkz,
  VFNMADD132PHZmk,
  VFNMADD132PHZmkz,
  VFNMADD132PHZr,
  VFNMADD132PHZrb,
  VFNMADD132PHZrbk,
  VFNMADD132PHZrbkz,
  VFNMADD132PHZrk,
  VFNMADD132PHZrkz,
  VFNMADD132PSYm,
  VFNMADD132PSYr,
  VFNMADD132PSZ128m,
  VFNMADD132PSZ128mb,
  VFNMADD132PSZ128mbk,
  VFNMADD132PSZ128mbkz,
  VFNMADD132PSZ128mk,
  VFNMADD132PSZ128mkz,
  VFNMADD132PSZ128r,
  VFNMADD132PSZ128rk,
  VFNMADD132PSZ128rkz,
  VFNMADD132PSZ256m,
  VFNMADD132PSZ256mb,
  VFNMADD132PSZ256mbk,
  VFNMADD132PSZ256mbkz,
  VFNMADD132PSZ256mk,
  VFNMADD132PSZ256mkz,
  VFNMADD132PSZ256r,
  VFNMADD132PSZ256rk,
  VFNMADD132PSZ256rkz,
  VFNMADD132PSZm,
  VFNMADD132PSZmb,
  VFNMADD132PSZmbk,
  VFNMADD132PSZmbkz,
  VFNMADD132PSZmk,
  VFNMADD132PSZmkz,
  VFNMADD132PSZr,
  VFNMADD132PSZrb,
  VFNMADD132PSZrbk,
  VFNMADD132PSZrbkz,
  VFNMADD132PSZrk,
  VFNMADD132PSZrkz,
  VFNMADD132PSm,
  VFNMADD132PSr,
  VFNMADD132SDZm,
  VFNMADD132SDZm_Int,
  VFNMADD132SDZm_Intk,
  VFNMADD132SDZm_Intkz,
  VFNMADD132SDZr,
  VFNMADD132SDZr_Int,
  VFNMADD132SDZr_Intk,
  VFNMADD132SDZr_Intkz,
  VFNMADD132SDZrb,
  VFNMADD132SDZrb_Int,
  VFNMADD132SDZrb_Intk,
  VFNMADD132SDZrb_Intkz,
  VFNMADD132SDm,
  VFNMADD132SDm_Int,
  VFNMADD132SDr,
  VFNMADD132SDr_Int,
  VFNMADD132SHZm,
  VFNMADD132SHZm_Int,
  VFNMADD132SHZm_Intk,
  VFNMADD132SHZm_Intkz,
  VFNMADD132SHZr,
  VFNMADD132SHZr_Int,
  VFNMADD132SHZr_Intk,
  VFNMADD132SHZr_Intkz,
  VFNMADD132SHZrb,
  VFNMADD132SHZrb_Int,
  VFNMADD132SHZrb_Intk,
  VFNMADD132SHZrb_Intkz,
  VFNMADD132SSZm,
  VFNMADD132SSZm_Int,
  VFNMADD132SSZm_Intk,
  VFNMADD132SSZm_Intkz,
  VFNMADD132SSZr,
  VFNMADD132SSZr_Int,
  VFNMADD132SSZr_Intk,
  VFNMADD132SSZr_Intkz,
  VFNMADD132SSZrb,
  VFNMADD132SSZrb_Int,
  VFNMADD132SSZrb_Intk,
  VFNMADD132SSZrb_Intkz,
  VFNMADD132SSm,
  VFNMADD132SSm_Int,
  VFNMADD132SSr,
  VFNMADD132SSr_Int,
  VFNMADD213PDYm,
  VFNMADD213PDYr,
  VFNMADD213PDZ128m,
  VFNMADD213PDZ128mb,
  VFNMADD213PDZ128mbk,
  VFNMADD213PDZ128mbkz,
  VFNMADD213PDZ128mk,
  VFNMADD213PDZ128mkz,
  VFNMADD213PDZ128r,
  VFNMADD213PDZ128rk,
  VFNMADD213PDZ128rkz,
  VFNMADD213PDZ256m,
  VFNMADD213PDZ256mb,
  VFNMADD213PDZ256mbk,
  VFNMADD213PDZ256mbkz,
  VFNMADD213PDZ256mk,
  VFNMADD213PDZ256mkz,
  VFNMADD213PDZ256r,
  VFNMADD213PDZ256rk,
  VFNMADD213PDZ256rkz,
  VFNMADD213PDZm,
  VFNMADD213PDZmb,
  VFNMADD213PDZmbk,
  VFNMADD213PDZmbkz,
  VFNMADD213PDZmk,
  VFNMADD213PDZmkz,
  VFNMADD213PDZr,
  VFNMADD213PDZrb,
  VFNMADD213PDZrbk,
  VFNMADD213PDZrbkz,
  VFNMADD213PDZrk,
  VFNMADD213PDZrkz,
  VFNMADD213PDm,
  VFNMADD213PDr,
  VFNMADD213PHZ128m,
  VFNMADD213PHZ128mb,
  VFNMADD213PHZ128mbk,
  VFNMADD213PHZ128mbkz,
  VFNMADD213PHZ128mk,
  VFNMADD213PHZ128mkz,
  VFNMADD213PHZ128r,
  VFNMADD213PHZ128rk,
  VFNMADD213PHZ128rkz,
  VFNMADD213PHZ256m,
  VFNMADD213PHZ256mb,
  VFNMADD213PHZ256mbk,
  VFNMADD213PHZ256mbkz,
  VFNMADD213PHZ256mk,
  VFNMADD213PHZ256mkz,
  VFNMADD213PHZ256r,
  VFNMADD213PHZ256rk,
  VFNMADD213PHZ256rkz,
  VFNMADD213PHZm,
  VFNMADD213PHZmb,
  VFNMADD213PHZmbk,
  VFNMADD213PHZmbkz,
  VFNMADD213PHZmk,
  VFNMADD213PHZmkz,
  VFNMADD213PHZr,
  VFNMADD213PHZrb,
  VFNMADD213PHZrbk,
  VFNMADD213PHZrbkz,
  VFNMADD213PHZrk,
  VFNMADD213PHZrkz,
  VFNMADD213PSYm,
  VFNMADD213PSYr,
  VFNMADD213PSZ128m,
  VFNMADD213PSZ128mb,
  VFNMADD213PSZ128mbk,
  VFNMADD213PSZ128mbkz,
  VFNMADD213PSZ128mk,
  VFNMADD213PSZ128mkz,
  VFNMADD213PSZ128r,
  VFNMADD213PSZ128rk,
  VFNMADD213PSZ128rkz,
  VFNMADD213PSZ256m,
  VFNMADD213PSZ256mb,
  VFNMADD213PSZ256mbk,
  VFNMADD213PSZ256mbkz,
  VFNMADD213PSZ256mk,
  VFNMADD213PSZ256mkz,
  VFNMADD213PSZ256r,
  VFNMADD213PSZ256rk,
  VFNMADD213PSZ256rkz,
  VFNMADD213PSZm,
  VFNMADD213PSZmb,
  VFNMADD213PSZmbk,
  VFNMADD213PSZmbkz,
  VFNMADD213PSZmk,
  VFNMADD213PSZmkz,
  VFNMADD213PSZr,
  VFNMADD213PSZrb,
  VFNMADD213PSZrbk,
  VFNMADD213PSZrbkz,
  VFNMADD213PSZrk,
  VFNMADD213PSZrkz,
  VFNMADD213PSm,
  VFNMADD213PSr,
  VFNMADD213SDZm,
  VFNMADD213SDZm_Int,
  VFNMADD213SDZm_Intk,
  VFNMADD213SDZm_Intkz,
  VFNMADD213SDZr,
  VFNMADD213SDZr_Int,
  VFNMADD213SDZr_Intk,
  VFNMADD213SDZr_Intkz,
  VFNMADD213SDZrb,
  VFNMADD213SDZrb_Int,
  VFNMADD213SDZrb_Intk,
  VFNMADD213SDZrb_Intkz,
  VFNMADD213SDm,
  VFNMADD213SDm_Int,
  VFNMADD213SDr,
  VFNMADD213SDr_Int,
  VFNMADD213SHZm,
  VFNMADD213SHZm_Int,
  VFNMADD213SHZm_Intk,
  VFNMADD213SHZm_Intkz,
  VFNMADD213SHZr,
  VFNMADD213SHZr_Int,
  VFNMADD213SHZr_Intk,
  VFNMADD213SHZr_Intkz,
  VFNMADD213SHZrb,
  VFNMADD213SHZrb_Int,
  VFNMADD213SHZrb_Intk,
  VFNMADD213SHZrb_Intkz,
  VFNMADD213SSZm,
  VFNMADD213SSZm_Int,
  VFNMADD213SSZm_Intk,
  VFNMADD213SSZm_Intkz,
  VFNMADD213SSZr,
  VFNMADD213SSZr_Int,
  VFNMADD213SSZr_Intk,
  VFNMADD213SSZr_Intkz,
  VFNMADD213SSZrb,
  VFNMADD213SSZrb_Int,
  VFNMADD213SSZrb_Intk,
  VFNMADD213SSZrb_Intkz,
  VFNMADD213SSm,
  VFNMADD213SSm_Int,
  VFNMADD213SSr,
  VFNMADD213SSr_Int,
  VFNMADD231PDYm,
  VFNMADD231PDYr,
  VFNMADD231PDZ128m,
  VFNMADD231PDZ128mb,
  VFNMADD231PDZ128mbk,
  VFNMADD231PDZ128mbkz,
  VFNMADD231PDZ128mk,
  VFNMADD231PDZ128mkz,
  VFNMADD231PDZ128r,
  VFNMADD231PDZ128rk,
  VFNMADD231PDZ128rkz,
  VFNMADD231PDZ256m,
  VFNMADD231PDZ256mb,
  VFNMADD231PDZ256mbk,
  VFNMADD231PDZ256mbkz,
  VFNMADD231PDZ256mk,
  VFNMADD231PDZ256mkz,
  VFNMADD231PDZ256r,
  VFNMADD231PDZ256rk,
  VFNMADD231PDZ256rkz,
  VFNMADD231PDZm,
  VFNMADD231PDZmb,
  VFNMADD231PDZmbk,
  VFNMADD231PDZmbkz,
  VFNMADD231PDZmk,
  VFNMADD231PDZmkz,
  VFNMADD231PDZr,
  VFNMADD231PDZrb,
  VFNMADD231PDZrbk,
  VFNMADD231PDZrbkz,
  VFNMADD231PDZrk,
  VFNMADD231PDZrkz,
  VFNMADD231PDm,
  VFNMADD231PDr,
  VFNMADD231PHZ128m,
  VFNMADD231PHZ128mb,
  VFNMADD231PHZ128mbk,
  VFNMADD231PHZ128mbkz,
  VFNMADD231PHZ128mk,
  VFNMADD231PHZ128mkz,
  VFNMADD231PHZ128r,
  VFNMADD231PHZ128rk,
  VFNMADD231PHZ128rkz,
  VFNMADD231PHZ256m,
  VFNMADD231PHZ256mb,
  VFNMADD231PHZ256mbk,
  VFNMADD231PHZ256mbkz,
  VFNMADD231PHZ256mk,
  VFNMADD231PHZ256mkz,
  VFNMADD231PHZ256r,
  VFNMADD231PHZ256rk,
  VFNMADD231PHZ256rkz,
  VFNMADD231PHZm,
  VFNMADD231PHZmb,
  VFNMADD231PHZmbk,
  VFNMADD231PHZmbkz,
  VFNMADD231PHZmk,
  VFNMADD231PHZmkz,
  VFNMADD231PHZr,
  VFNMADD231PHZrb,
  VFNMADD231PHZrbk,
  VFNMADD231PHZrbkz,
  VFNMADD231PHZrk,
  VFNMADD231PHZrkz,
  VFNMADD231PSYm,
  VFNMADD231PSYr,
  VFNMADD231PSZ128m,
  VFNMADD231PSZ128mb,
  VFNMADD231PSZ128mbk,
  VFNMADD231PSZ128mbkz,
  VFNMADD231PSZ128mk,
  VFNMADD231PSZ128mkz,
  VFNMADD231PSZ128r,
  VFNMADD231PSZ128rk,
  VFNMADD231PSZ128rkz,
  VFNMADD231PSZ256m,
  VFNMADD231PSZ256mb,
  VFNMADD231PSZ256mbk,
  VFNMADD231PSZ256mbkz,
  VFNMADD231PSZ256mk,
  VFNMADD231PSZ256mkz,
  VFNMADD231PSZ256r,
  VFNMADD231PSZ256rk,
  VFNMADD231PSZ256rkz,
  VFNMADD231PSZm,
  VFNMADD231PSZmb,
  VFNMADD231PSZmbk,
  VFNMADD231PSZmbkz,
  VFNMADD231PSZmk,
  VFNMADD231PSZmkz,
  VFNMADD231PSZr,
  VFNMADD231PSZrb,
  VFNMADD231PSZrbk,
  VFNMADD231PSZrbkz,
  VFNMADD231PSZrk,
  VFNMADD231PSZrkz,
  VFNMADD231PSm,
  VFNMADD231PSr,
  VFNMADD231SDZm,
  VFNMADD231SDZm_Int,
  VFNMADD231SDZm_Intk,
  VFNMADD231SDZm_Intkz,
  VFNMADD231SDZr,
  VFNMADD231SDZr_Int,
  VFNMADD231SDZr_Intk,
  VFNMADD231SDZr_Intkz,
  VFNMADD231SDZrb,
  VFNMADD231SDZrb_Int,
  VFNMADD231SDZrb_Intk,
  VFNMADD231SDZrb_Intkz,
  VFNMADD231SDm,
  VFNMADD231SDm_Int,
  VFNMADD231SDr,
  VFNMADD231SDr_Int,
  VFNMADD231SHZm,
  VFNMADD231SHZm_Int,
  VFNMADD231SHZm_Intk,
  VFNMADD231SHZm_Intkz,
  VFNMADD231SHZr,
  VFNMADD231SHZr_Int,
  VFNMADD231SHZr_Intk,
  VFNMADD231SHZr_Intkz,
  VFNMADD231SHZrb,
  VFNMADD231SHZrb_Int,
  VFNMADD231SHZrb_Intk,
  VFNMADD231SHZrb_Intkz,
  VFNMADD231SSZm,
  VFNMADD231SSZm_Int,
  VFNMADD231SSZm_Intk,
  VFNMADD231SSZm_Intkz,
  VFNMADD231SSZr,
  VFNMADD231SSZr_Int,
  VFNMADD231SSZr_Intk,
  VFNMADD231SSZr_Intkz,
  VFNMADD231SSZrb,
  VFNMADD231SSZrb_Int,
  VFNMADD231SSZrb_Intk,
  VFNMADD231SSZrb_Intkz,
  VFNMADD231SSm,
  VFNMADD231SSm_Int,
  VFNMADD231SSr,
  VFNMADD231SSr_Int,
  VFNMADDPD4Ymr,
  VFNMADDPD4Yrm,
  VFNMADDPD4Yrr,
  VFNMADDPD4Yrr_REV,
  VFNMADDPD4mr,
  VFNMADDPD4rm,
  VFNMADDPD4rr,
  VFNMADDPD4rr_REV,
  VFNMADDPS4Ymr,
  VFNMADDPS4Yrm,
  VFNMADDPS4Yrr,
  VFNMADDPS4Yrr_REV,
  VFNMADDPS4mr,
  VFNMADDPS4rm,
  VFNMADDPS4rr,
  VFNMADDPS4rr_REV,
  VFNMADDSD4mr,
  VFNMADDSD4mr_Int,
  VFNMADDSD4rm,
  VFNMADDSD4rm_Int,
  VFNMADDSD4rr,
  VFNMADDSD4rr_Int,
  VFNMADDSD4rr_Int_REV,
  VFNMADDSD4rr_REV,
  VFNMADDSS4mr,
  VFNMADDSS4mr_Int,
  VFNMADDSS4rm,
  VFNMADDSS4rm_Int,
  VFNMADDSS4rr,
  VFNMADDSS4rr_Int,
  VFNMADDSS4rr_Int_REV,
  VFNMADDSS4rr_REV,
  VFNMSUB132PDYm,
  VFNMSUB132PDYr,
  VFNMSUB132PDZ128m,
  VFNMSUB132PDZ128mb,
  VFNMSUB132PDZ128mbk,
  VFNMSUB132PDZ128mbkz,
  VFNMSUB132PDZ128mk,
  VFNMSUB132PDZ128mkz,
  VFNMSUB132PDZ128r,
  VFNMSUB132PDZ128rk,
  VFNMSUB132PDZ128rkz,
  VFNMSUB132PDZ256m,
  VFNMSUB132PDZ256mb,
  VFNMSUB132PDZ256mbk,
  VFNMSUB132PDZ256mbkz,
  VFNMSUB132PDZ256mk,
  VFNMSUB132PDZ256mkz,
  VFNMSUB132PDZ256r,
  VFNMSUB132PDZ256rk,
  VFNMSUB132PDZ256rkz,
  VFNMSUB132PDZm,
  VFNMSUB132PDZmb,
  VFNMSUB132PDZmbk,
  VFNMSUB132PDZmbkz,
  VFNMSUB132PDZmk,
  VFNMSUB132PDZmkz,
  VFNMSUB132PDZr,
  VFNMSUB132PDZrb,
  VFNMSUB132PDZrbk,
  VFNMSUB132PDZrbkz,
  VFNMSUB132PDZrk,
  VFNMSUB132PDZrkz,
  VFNMSUB132PDm,
  VFNMSUB132PDr,
  VFNMSUB132PHZ128m,
  VFNMSUB132PHZ128mb,
  VFNMSUB132PHZ128mbk,
  VFNMSUB132PHZ128mbkz,
  VFNMSUB132PHZ128mk,
  VFNMSUB132PHZ128mkz,
  VFNMSUB132PHZ128r,
  VFNMSUB132PHZ128rk,
  VFNMSUB132PHZ128rkz,
  VFNMSUB132PHZ256m,
  VFNMSUB132PHZ256mb,
  VFNMSUB132PHZ256mbk,
  VFNMSUB132PHZ256mbkz,
  VFNMSUB132PHZ256mk,
  VFNMSUB132PHZ256mkz,
  VFNMSUB132PHZ256r,
  VFNMSUB132PHZ256rk,
  VFNMSUB132PHZ256rkz,
  VFNMSUB132PHZm,
  VFNMSUB132PHZmb,
  VFNMSUB132PHZmbk,
  VFNMSUB132PHZmbkz,
  VFNMSUB132PHZmk,
  VFNMSUB132PHZmkz,
  VFNMSUB132PHZr,
  VFNMSUB132PHZrb,
  VFNMSUB132PHZrbk,
  VFNMSUB132PHZrbkz,
  VFNMSUB132PHZrk,
  VFNMSUB132PHZrkz,
  VFNMSUB132PSYm,
  VFNMSUB132PSYr,
  VFNMSUB132PSZ128m,
  VFNMSUB132PSZ128mb,
  VFNMSUB132PSZ128mbk,
  VFNMSUB132PSZ128mbkz,
  VFNMSUB132PSZ128mk,
  VFNMSUB132PSZ128mkz,
  VFNMSUB132PSZ128r,
  VFNMSUB132PSZ128rk,
  VFNMSUB132PSZ128rkz,
  VFNMSUB132PSZ256m,
  VFNMSUB132PSZ256mb,
  VFNMSUB132PSZ256mbk,
  VFNMSUB132PSZ256mbkz,
  VFNMSUB132PSZ256mk,
  VFNMSUB132PSZ256mkz,
  VFNMSUB132PSZ256r,
  VFNMSUB132PSZ256rk,
  VFNMSUB132PSZ256rkz,
  VFNMSUB132PSZm,
  VFNMSUB132PSZmb,
  VFNMSUB132PSZmbk,
  VFNMSUB132PSZmbkz,
  VFNMSUB132PSZmk,
  VFNMSUB132PSZmkz,
  VFNMSUB132PSZr,
  VFNMSUB132PSZrb,
  VFNMSUB132PSZrbk,
  VFNMSUB132PSZrbkz,
  VFNMSUB132PSZrk,
  VFNMSUB132PSZrkz,
  VFNMSUB132PSm,
  VFNMSUB132PSr,
  VFNMSUB132SDZm,
  VFNMSUB132SDZm_Int,
  VFNMSUB132SDZm_Intk,
  VFNMSUB132SDZm_Intkz,
  VFNMSUB132SDZr,
  VFNMSUB132SDZr_Int,
  VFNMSUB132SDZr_Intk,
  VFNMSUB132SDZr_Intkz,
  VFNMSUB132SDZrb,
  VFNMSUB132SDZrb_Int,
  VFNMSUB132SDZrb_Intk,
  VFNMSUB132SDZrb_Intkz,
  VFNMSUB132SDm,
  VFNMSUB132SDm_Int,
  VFNMSUB132SDr,
  VFNMSUB132SDr_Int,
  VFNMSUB132SHZm,
  VFNMSUB132SHZm_Int,
  VFNMSUB132SHZm_Intk,
  VFNMSUB132SHZm_Intkz,
  VFNMSUB132SHZr,
  VFNMSUB132SHZr_Int,
  VFNMSUB132SHZr_Intk,
  VFNMSUB132SHZr_Intkz,
  VFNMSUB132SHZrb,
  VFNMSUB132SHZrb_Int,
  VFNMSUB132SHZrb_Intk,
  VFNMSUB132SHZrb_Intkz,
  VFNMSUB132SSZm,
  VFNMSUB132SSZm_Int,
  VFNMSUB132SSZm_Intk,
  VFNMSUB132SSZm_Intkz,
  VFNMSUB132SSZr,
  VFNMSUB132SSZr_Int,
  VFNMSUB132SSZr_Intk,
  VFNMSUB132SSZr_Intkz,
  VFNMSUB132SSZrb,
  VFNMSUB132SSZrb_Int,
  VFNMSUB132SSZrb_Intk,
  VFNMSUB132SSZrb_Intkz,
  VFNMSUB132SSm,
  VFNMSUB132SSm_Int,
  VFNMSUB132SSr,
  VFNMSUB132SSr_Int,
  VFNMSUB213PDYm,
  VFNMSUB213PDYr,
  VFNMSUB213PDZ128m,
  VFNMSUB213PDZ128mb,
  VFNMSUB213PDZ128mbk,
  VFNMSUB213PDZ128mbkz,
  VFNMSUB213PDZ128mk,
  VFNMSUB213PDZ128mkz,
  VFNMSUB213PDZ128r,
  VFNMSUB213PDZ128rk,
  VFNMSUB213PDZ128rkz,
  VFNMSUB213PDZ256m,
  VFNMSUB213PDZ256mb,
  VFNMSUB213PDZ256mbk,
  VFNMSUB213PDZ256mbkz,
  VFNMSUB213PDZ256mk,
  VFNMSUB213PDZ256mkz,
  VFNMSUB213PDZ256r,
  VFNMSUB213PDZ256rk,
  VFNMSUB213PDZ256rkz,
  VFNMSUB213PDZm,
  VFNMSUB213PDZmb,
  VFNMSUB213PDZmbk,
  VFNMSUB213PDZmbkz,
  VFNMSUB213PDZmk,
  VFNMSUB213PDZmkz,
  VFNMSUB213PDZr,
  VFNMSUB213PDZrb,
  VFNMSUB213PDZrbk,
  VFNMSUB213PDZrbkz,
  VFNMSUB213PDZrk,
  VFNMSUB213PDZrkz,
  VFNMSUB213PDm,
  VFNMSUB213PDr,
  VFNMSUB213PHZ128m,
  VFNMSUB213PHZ128mb,
  VFNMSUB213PHZ128mbk,
  VFNMSUB213PHZ128mbkz,
  VFNMSUB213PHZ128mk,
  VFNMSUB213PHZ128mkz,
  VFNMSUB213PHZ128r,
  VFNMSUB213PHZ128rk,
  VFNMSUB213PHZ128rkz,
  VFNMSUB213PHZ256m,
  VFNMSUB213PHZ256mb,
  VFNMSUB213PHZ256mbk,
  VFNMSUB213PHZ256mbkz,
  VFNMSUB213PHZ256mk,
  VFNMSUB213PHZ256mkz,
  VFNMSUB213PHZ256r,
  VFNMSUB213PHZ256rk,
  VFNMSUB213PHZ256rkz,
  VFNMSUB213PHZm,
  VFNMSUB213PHZmb,
  VFNMSUB213PHZmbk,
  VFNMSUB213PHZmbkz,
  VFNMSUB213PHZmk,
  VFNMSUB213PHZmkz,
  VFNMSUB213PHZr,
  VFNMSUB213PHZrb,
  VFNMSUB213PHZrbk,
  VFNMSUB213PHZrbkz,
  VFNMSUB213PHZrk,
  VFNMSUB213PHZrkz,
  VFNMSUB213PSYm,
  VFNMSUB213PSYr,
  VFNMSUB213PSZ128m,
  VFNMSUB213PSZ128mb,
  VFNMSUB213PSZ128mbk,
  VFNMSUB213PSZ128mbkz,
  VFNMSUB213PSZ128mk,
  VFNMSUB213PSZ128mkz,
  VFNMSUB213PSZ128r,
  VFNMSUB213PSZ128rk,
  VFNMSUB213PSZ128rkz,
  VFNMSUB213PSZ256m,
  VFNMSUB213PSZ256mb,
  VFNMSUB213PSZ256mbk,
  VFNMSUB213PSZ256mbkz,
  VFNMSUB213PSZ256mk,
  VFNMSUB213PSZ256mkz,
  VFNMSUB213PSZ256r,
  VFNMSUB213PSZ256rk,
  VFNMSUB213PSZ256rkz,
  VFNMSUB213PSZm,
  VFNMSUB213PSZmb,
  VFNMSUB213PSZmbk,
  VFNMSUB213PSZmbkz,
  VFNMSUB213PSZmk,
  VFNMSUB213PSZmkz,
  VFNMSUB213PSZr,
  VFNMSUB213PSZrb,
  VFNMSUB213PSZrbk,
  VFNMSUB213PSZrbkz,
  VFNMSUB213PSZrk,
  VFNMSUB213PSZrkz,
  VFNMSUB213PSm,
  VFNMSUB213PSr,
  VFNMSUB213SDZm,
  VFNMSUB213SDZm_Int,
  VFNMSUB213SDZm_Intk,
  VFNMSUB213SDZm_Intkz,
  VFNMSUB213SDZr,
  VFNMSUB213SDZr_Int,
  VFNMSUB213SDZr_Intk,
  VFNMSUB213SDZr_Intkz,
  VFNMSUB213SDZrb,
  VFNMSUB213SDZrb_Int,
  VFNMSUB213SDZrb_Intk,
  VFNMSUB213SDZrb_Intkz,
  VFNMSUB213SDm,
  VFNMSUB213SDm_Int,
  VFNMSUB213SDr,
  VFNMSUB213SDr_Int,
  VFNMSUB213SHZm,
  VFNMSUB213SHZm_Int,
  VFNMSUB213SHZm_Intk,
  VFNMSUB213SHZm_Intkz,
  VFNMSUB213SHZr,
  VFNMSUB213SHZr_Int,
  VFNMSUB213SHZr_Intk,
  VFNMSUB213SHZr_Intkz,
  VFNMSUB213SHZrb,
  VFNMSUB213SHZrb_Int,
  VFNMSUB213SHZrb_Intk,
  VFNMSUB213SHZrb_Intkz,
  VFNMSUB213SSZm,
  VFNMSUB213SSZm_Int,
  VFNMSUB213SSZm_Intk,
  VFNMSUB213SSZm_Intkz,
  VFNMSUB213SSZr,
  VFNMSUB213SSZr_Int,
  VFNMSUB213SSZr_Intk,
  VFNMSUB213SSZr_Intkz,
  VFNMSUB213SSZrb,
  VFNMSUB213SSZrb_Int,
  VFNMSUB213SSZrb_Intk,
  VFNMSUB213SSZrb_Intkz,
  VFNMSUB213SSm,
  VFNMSUB213SSm_Int,
  VFNMSUB213SSr,
  VFNMSUB213SSr_Int,
  VFNMSUB231PDYm,
  VFNMSUB231PDYr,
  VFNMSUB231PDZ128m,
  VFNMSUB231PDZ128mb,
  VFNMSUB231PDZ128mbk,
  VFNMSUB231PDZ128mbkz,
  VFNMSUB231PDZ128mk,
  VFNMSUB231PDZ128mkz,
  VFNMSUB231PDZ128r,
  VFNMSUB231PDZ128rk,
  VFNMSUB231PDZ128rkz,
  VFNMSUB231PDZ256m,
  VFNMSUB231PDZ256mb,
  VFNMSUB231PDZ256mbk,
  VFNMSUB231PDZ256mbkz,
  VFNMSUB231PDZ256mk,
  VFNMSUB231PDZ256mkz,
  VFNMSUB231PDZ256r,
  VFNMSUB231PDZ256rk,
  VFNMSUB231PDZ256rkz,
  VFNMSUB231PDZm,
  VFNMSUB231PDZmb,
  VFNMSUB231PDZmbk,
  VFNMSUB231PDZmbkz,
  VFNMSUB231PDZmk,
  VFNMSUB231PDZmkz,
  VFNMSUB231PDZr,
  VFNMSUB231PDZrb,
  VFNMSUB231PDZrbk,
  VFNMSUB231PDZrbkz,
  VFNMSUB231PDZrk,
  VFNMSUB231PDZrkz,
  VFNMSUB231PDm,
  VFNMSUB231PDr,
  VFNMSUB231PHZ128m,
  VFNMSUB231PHZ128mb,
  VFNMSUB231PHZ128mbk,
  VFNMSUB231PHZ128mbkz,
  VFNMSUB231PHZ128mk,
  VFNMSUB231PHZ128mkz,
  VFNMSUB231PHZ128r,
  VFNMSUB231PHZ128rk,
  VFNMSUB231PHZ128rkz,
  VFNMSUB231PHZ256m,
  VFNMSUB231PHZ256mb,
  VFNMSUB231PHZ256mbk,
  VFNMSUB231PHZ256mbkz,
  VFNMSUB231PHZ256mk,
  VFNMSUB231PHZ256mkz,
  VFNMSUB231PHZ256r,
  VFNMSUB231PHZ256rk,
  VFNMSUB231PHZ256rkz,
  VFNMSUB231PHZm,
  VFNMSUB231PHZmb,
  VFNMSUB231PHZmbk,
  VFNMSUB231PHZmbkz,
  VFNMSUB231PHZmk,
  VFNMSUB231PHZmkz,
  VFNMSUB231PHZr,
  VFNMSUB231PHZrb,
  VFNMSUB231PHZrbk,
  VFNMSUB231PHZrbkz,
  VFNMSUB231PHZrk,
  VFNMSUB231PHZrkz,
  VFNMSUB231PSYm,
  VFNMSUB231PSYr,
  VFNMSUB231PSZ128m,
  VFNMSUB231PSZ128mb,
  VFNMSUB231PSZ128mbk,
  VFNMSUB231PSZ128mbkz,
  VFNMSUB231PSZ128mk,
  VFNMSUB231PSZ128mkz,
  VFNMSUB231PSZ128r,
  VFNMSUB231PSZ128rk,
  VFNMSUB231PSZ128rkz,
  VFNMSUB231PSZ256m,
  VFNMSUB231PSZ256mb,
  VFNMSUB231PSZ256mbk,
  VFNMSUB231PSZ256mbkz,
  VFNMSUB231PSZ256mk,
  VFNMSUB231PSZ256mkz,
  VFNMSUB231PSZ256r,
  VFNMSUB231PSZ256rk,
  VFNMSUB231PSZ256rkz,
  VFNMSUB231PSZm,
  VFNMSUB231PSZmb,
  VFNMSUB231PSZmbk,
  VFNMSUB231PSZmbkz,
  VFNMSUB231PSZmk,
  VFNMSUB231PSZmkz,
  VFNMSUB231PSZr,
  VFNMSUB231PSZrb,
  VFNMSUB231PSZrbk,
  VFNMSUB231PSZrbkz,
  VFNMSUB231PSZrk,
  VFNMSUB231PSZrkz,
  VFNMSUB231PSm,
  VFNMSUB231PSr,
  VFNMSUB231SDZm,
  VFNMSUB231SDZm_Int,
  VFNMSUB231SDZm_Intk,
  VFNMSUB231SDZm_Intkz,
  VFNMSUB231SDZr,
  VFNMSUB231SDZr_Int,
  VFNMSUB231SDZr_Intk,
  VFNMSUB231SDZr_Intkz,
  VFNMSUB231SDZrb,
  VFNMSUB231SDZrb_Int,
  VFNMSUB231SDZrb_Intk,
  VFNMSUB231SDZrb_Intkz,
  VFNMSUB231SDm,
  VFNMSUB231SDm_Int,
  VFNMSUB231SDr,
  VFNMSUB231SDr_Int,
  VFNMSUB231SHZm,
  VFNMSUB231SHZm_Int,
  VFNMSUB231SHZm_Intk,
  VFNMSUB231SHZm_Intkz,
  VFNMSUB231SHZr,
  VFNMSUB231SHZr_Int,
  VFNMSUB231SHZr_Intk,
  VFNMSUB231SHZr_Intkz,
  VFNMSUB231SHZrb,
  VFNMSUB231SHZrb_Int,
  VFNMSUB231SHZrb_Intk,
  VFNMSUB231SHZrb_Intkz,
  VFNMSUB231SSZm,
  VFNMSUB231SSZm_Int,
  VFNMSUB231SSZm_Intk,
  VFNMSUB231SSZm_Intkz,
  VFNMSUB231SSZr,
  VFNMSUB231SSZr_Int,
  VFNMSUB231SSZr_Intk,
  VFNMSUB231SSZr_Intkz,
  VFNMSUB231SSZrb,
  VFNMSUB231SSZrb_Int,
  VFNMSUB231SSZrb_Intk,
  VFNMSUB231SSZrb_Intkz,
  VFNMSUB231SSm,
  VFNMSUB231SSm_Int,
  VFNMSUB231SSr,
  VFNMSUB231SSr_Int,
  VFNMSUBPD4Ymr,
  VFNMSUBPD4Yrm,
  VFNMSUBPD4Yrr,
  VFNMSUBPD4Yrr_REV,
  VFNMSUBPD4mr,
  VFNMSUBPD4rm,
  VFNMSUBPD4rr,
  VFNMSUBPD4rr_REV,
  VFNMSUBPS4Ymr,
  VFNMSUBPS4Yrm,
  VFNMSUBPS4Yrr,
  VFNMSUBPS4Yrr_REV,
  VFNMSUBPS4mr,
  VFNMSUBPS4rm,
  VFNMSUBPS4rr,
  VFNMSUBPS4rr_REV,
  VFNMSUBSD4mr,
  VFNMSUBSD4mr_Int,
  VFNMSUBSD4rm,
  VFNMSUBSD4rm_Int,
  VFNMSUBSD4rr,
  VFNMSUBSD4rr_Int,
  VFNMSUBSD4rr_Int_REV,
  VFNMSUBSD4rr_REV,
  VFNMSUBSS4mr,
  VFNMSUBSS4mr_Int,
  VFNMSUBSS4rm,
  VFNMSUBSS4rm_Int,
  VFNMSUBSS4rr,
  VFNMSUBSS4rr_Int,
  VFNMSUBSS4rr_Int_REV,
  VFNMSUBSS4rr_REV,
  VFPCLASSPDZ128rm,
  VFPCLASSPDZ128rmb,
  VFPCLASSPDZ128rmbk,
  VFPCLASSPDZ128rmk,
  VFPCLASSPDZ128rr,
  VFPCLASSPDZ128rrk,
  VFPCLASSPDZ256rm,
  VFPCLASSPDZ256rmb,
  VFPCLASSPDZ256rmbk,
  VFPCLASSPDZ256rmk,
  VFPCLASSPDZ256rr,
  VFPCLASSPDZ256rrk,
  VFPCLASSPDZrm,
  VFPCLASSPDZrmb,
  VFPCLASSPDZrmbk,
  VFPCLASSPDZrmk,
  VFPCLASSPDZrr,
  VFPCLASSPDZrrk,
  VFPCLASSPHZ128rm,
  VFPCLASSPHZ128rmb,
  VFPCLASSPHZ128rmbk,
  VFPCLASSPHZ128rmk,
  VFPCLASSPHZ128rr,
  VFPCLASSPHZ128rrk,
  VFPCLASSPHZ256rm,
  VFPCLASSPHZ256rmb,
  VFPCLASSPHZ256rmbk,
  VFPCLASSPHZ256rmk,
  VFPCLASSPHZ256rr,
  VFPCLASSPHZ256rrk,
  VFPCLASSPHZrm,
  VFPCLASSPHZrmb,
  VFPCLASSPHZrmbk,
  VFPCLASSPHZrmk,
  VFPCLASSPHZrr,
  VFPCLASSPHZrrk,
  VFPCLASSPSZ128rm,
  VFPCLASSPSZ128rmb,
  VFPCLASSPSZ128rmbk,
  VFPCLASSPSZ128rmk,
  VFPCLASSPSZ128rr,
  VFPCLASSPSZ128rrk,
  VFPCLASSPSZ256rm,
  VFPCLASSPSZ256rmb,
  VFPCLASSPSZ256rmbk,
  VFPCLASSPSZ256rmk,
  VFPCLASSPSZ256rr,
  VFPCLASSPSZ256rrk,
  VFPCLASSPSZrm,
  VFPCLASSPSZrmb,
  VFPCLASSPSZrmbk,
  VFPCLASSPSZrmk,
  VFPCLASSPSZrr,
  VFPCLASSPSZrrk,
  VFPCLASSSDZrm,
  VFPCLASSSDZrmk,
  VFPCLASSSDZrr,
  VFPCLASSSDZrrk,
  VFPCLASSSHZrm,
  VFPCLASSSHZrmk,
  VFPCLASSSHZrr,
  VFPCLASSSHZrrk,
  VFPCLASSSSZrm,
  VFPCLASSSSZrmk,
  VFPCLASSSSZrr,
  VFPCLASSSSZrrk,
  VFRCZPDYrm,
  VFRCZPDYrr,
  VFRCZPDrm,
  VFRCZPDrr,
  VFRCZPSYrm,
  VFRCZPSYrr,
  VFRCZPSrm,
  VFRCZPSrr,
  VFRCZSDrm,
  VFRCZSDrr,
  VFRCZSSrm,
  VFRCZSSrr,
  VGATHERDPDYrm,
  VGATHERDPDZ128rm,
  VGATHERDPDZ256rm,
  VGATHERDPDZrm,
  VGATHERDPDrm,
  VGATHERDPSYrm,
  VGATHERDPSZ128rm,
  VGATHERDPSZ256rm,
  VGATHERDPSZrm,
  VGATHERDPSrm,
  VGATHERPF0DPDm,
  VGATHERPF0DPSm,
  VGATHERPF0QPDm,
  VGATHERPF0QPSm,
  VGATHERPF1DPDm,
  VGATHERPF1DPSm,
  VGATHERPF1QPDm,
  VGATHERPF1QPSm,
  VGATHERQPDYrm,
  VGATHERQPDZ128rm,
  VGATHERQPDZ256rm,
  VGATHERQPDZrm,
  VGATHERQPDrm,
  VGATHERQPSYrm,
  VGATHERQPSZ128rm,
  VGATHERQPSZ256rm,
  VGATHERQPSZrm,
  VGATHERQPSrm,
  VGETEXPPDZ128m,
  VGETEXPPDZ128mb,
  VGETEXPPDZ128mbk,
  VGETEXPPDZ128mbkz,
  VGETEXPPDZ128mk,
  VGETEXPPDZ128mkz,
  VGETEXPPDZ128r,
  VGETEXPPDZ128rk,
  VGETEXPPDZ128rkz,
  VGETEXPPDZ256m,
  VGETEXPPDZ256mb,
  VGETEXPPDZ256mbk,
  VGETEXPPDZ256mbkz,
  VGETEXPPDZ256mk,
  VGETEXPPDZ256mkz,
  VGETEXPPDZ256r,
  VGETEXPPDZ256rk,
  VGETEXPPDZ256rkz,
  VGETEXPPDZm,
  VGETEXPPDZmb,
  VGETEXPPDZmbk,
  VGETEXPPDZmbkz,
  VGETEXPPDZmk,
  VGETEXPPDZmkz,
  VGETEXPPDZr,
  VGETEXPPDZrb,
  VGETEXPPDZrbk,
  VGETEXPPDZrbkz,
  VGETEXPPDZrk,
  VGETEXPPDZrkz,
  VGETEXPPHZ128m,
  VGETEXPPHZ128mb,
  VGETEXPPHZ128mbk,
  VGETEXPPHZ128mbkz,
  VGETEXPPHZ128mk,
  VGETEXPPHZ128mkz,
  VGETEXPPHZ128r,
  VGETEXPPHZ128rk,
  VGETEXPPHZ128rkz,
  VGETEXPPHZ256m,
  VGETEXPPHZ256mb,
  VGETEXPPHZ256mbk,
  VGETEXPPHZ256mbkz,
  VGETEXPPHZ256mk,
  VGETEXPPHZ256mkz,
  VGETEXPPHZ256r,
  VGETEXPPHZ256rk,
  VGETEXPPHZ256rkz,
  VGETEXPPHZm,
  VGETEXPPHZmb,
  VGETEXPPHZmbk,
  VGETEXPPHZmbkz,
  VGETEXPPHZmk,
  VGETEXPPHZmkz,
  VGETEXPPHZr,
  VGETEXPPHZrb,
  VGETEXPPHZrbk,
  VGETEXPPHZrbkz,
  VGETEXPPHZrk,
  VGETEXPPHZrkz,
  VGETEXPPSZ128m,
  VGETEXPPSZ128mb,
  VGETEXPPSZ128mbk,
  VGETEXPPSZ128mbkz,
  VGETEXPPSZ128mk,
  VGETEXPPSZ128mkz,
  VGETEXPPSZ128r,
  VGETEXPPSZ128rk,
  VGETEXPPSZ128rkz,
  VGETEXPPSZ256m,
  VGETEXPPSZ256mb,
  VGETEXPPSZ256mbk,
  VGETEXPPSZ256mbkz,
  VGETEXPPSZ256mk,
  VGETEXPPSZ256mkz,
  VGETEXPPSZ256r,
  VGETEXPPSZ256rk,
  VGETEXPPSZ256rkz,
  VGETEXPPSZm,
  VGETEXPPSZmb,
  VGETEXPPSZmbk,
  VGETEXPPSZmbkz,
  VGETEXPPSZmk,
  VGETEXPPSZmkz,
  VGETEXPPSZr,
  VGETEXPPSZrb,
  VGETEXPPSZrbk,
  VGETEXPPSZrbkz,
  VGETEXPPSZrk,
  VGETEXPPSZrkz,
  VGETEXPSDZm,
  VGETEXPSDZmk,
  VGETEXPSDZmkz,
  VGETEXPSDZr,
  VGETEXPSDZrb,
  VGETEXPSDZrbk,
  VGETEXPSDZrbkz,
  VGETEXPSDZrk,
  VGETEXPSDZrkz,
  VGETEXPSHZm,
  VGETEXPSHZmk,
  VGETEXPSHZmkz,
  VGETEXPSHZr,
  VGETEXPSHZrb,
  VGETEXPSHZrbk,
  VGETEXPSHZrbkz,
  VGETEXPSHZrk,
  VGETEXPSHZrkz,
  VGETEXPSSZm,
  VGETEXPSSZmk,
  VGETEXPSSZmkz,
  VGETEXPSSZr,
  VGETEXPSSZrb,
  VGETEXPSSZrbk,
  VGETEXPSSZrbkz,
  VGETEXPSSZrk,
  VGETEXPSSZrkz,
  VGETMANTPDZ128rmbi,
  VGETMANTPDZ128rmbik,
  VGETMANTPDZ128rmbikz,
  VGETMANTPDZ128rmi,
  VGETMANTPDZ128rmik,
  VGETMANTPDZ128rmikz,
  VGETMANTPDZ128rri,
  VGETMANTPDZ128rrik,
  VGETMANTPDZ128rrikz,
  VGETMANTPDZ256rmbi,
  VGETMANTPDZ256rmbik,
  VGETMANTPDZ256rmbikz,
  VGETMANTPDZ256rmi,
  VGETMANTPDZ256rmik,
  VGETMANTPDZ256rmikz,
  VGETMANTPDZ256rri,
  VGETMANTPDZ256rrik,
  VGETMANTPDZ256rrikz,
  VGETMANTPDZrmbi,
  VGETMANTPDZrmbik,
  VGETMANTPDZrmbikz,
  VGETMANTPDZrmi,
  VGETMANTPDZrmik,
  VGETMANTPDZrmikz,
  VGETMANTPDZrri,
  VGETMANTPDZrrib,
  VGETMANTPDZrribk,
  VGETMANTPDZrribkz,
  VGETMANTPDZrrik,
  VGETMANTPDZrrikz,
  VGETMANTPHZ128rmbi,
  VGETMANTPHZ128rmbik,
  VGETMANTPHZ128rmbikz,
  VGETMANTPHZ128rmi,
  VGETMANTPHZ128rmik,
  VGETMANTPHZ128rmikz,
  VGETMANTPHZ128rri,
  VGETMANTPHZ128rrik,
  VGETMANTPHZ128rrikz,
  VGETMANTPHZ256rmbi,
  VGETMANTPHZ256rmbik,
  VGETMANTPHZ256rmbikz,
  VGETMANTPHZ256rmi,
  VGETMANTPHZ256rmik,
  VGETMANTPHZ256rmikz,
  VGETMANTPHZ256rri,
  VGETMANTPHZ256rrik,
  VGETMANTPHZ256rrikz,
  VGETMANTPHZrmbi,
  VGETMANTPHZrmbik,
  VGETMANTPHZrmbikz,
  VGETMANTPHZrmi,
  VGETMANTPHZrmik,
  VGETMANTPHZrmikz,
  VGETMANTPHZrri,
  VGETMANTPHZrrib,
  VGETMANTPHZrribk,
  VGETMANTPHZrribkz,
  VGETMANTPHZrrik,
  VGETMANTPHZrrikz,
  VGETMANTPSZ128rmbi,
  VGETMANTPSZ128rmbik,
  VGETMANTPSZ128rmbikz,
  VGETMANTPSZ128rmi,
  VGETMANTPSZ128rmik,
  VGETMANTPSZ128rmikz,
  VGETMANTPSZ128rri,
  VGETMANTPSZ128rrik,
  VGETMANTPSZ128rrikz,
  VGETMANTPSZ256rmbi,
  VGETMANTPSZ256rmbik,
  VGETMANTPSZ256rmbikz,
  VGETMANTPSZ256rmi,
  VGETMANTPSZ256rmik,
  VGETMANTPSZ256rmikz,
  VGETMANTPSZ256rri,
  VGETMANTPSZ256rrik,
  VGETMANTPSZ256rrikz,
  VGETMANTPSZrmbi,
  VGETMANTPSZrmbik,
  VGETMANTPSZrmbikz,
  VGETMANTPSZrmi,
  VGETMANTPSZrmik,
  VGETMANTPSZrmikz,
  VGETMANTPSZrri,
  VGETMANTPSZrrib,
  VGETMANTPSZrribk,
  VGETMANTPSZrribkz,
  VGETMANTPSZrrik,
  VGETMANTPSZrrikz,
  VGETMANTSDZrmi,
  VGETMANTSDZrmik,
  VGETMANTSDZrmikz,
  VGETMANTSDZrri,
  VGETMANTSDZrrib,
  VGETMANTSDZrribk,
  VGETMANTSDZrribkz,
  VGETMANTSDZrrik,
  VGETMANTSDZrrikz,
  VGETMANTSHZrmi,
  VGETMANTSHZrmik,
  VGETMANTSHZrmikz,
  VGETMANTSHZrri,
  VGETMANTSHZrrib,
  VGETMANTSHZrribk,
  VGETMANTSHZrribkz,
  VGETMANTSHZrrik,
  VGETMANTSHZrrikz,
  VGETMANTSSZrmi,
  VGETMANTSSZrmik,
  VGETMANTSSZrmikz,
  VGETMANTSSZrri,
  VGETMANTSSZrrib,
  VGETMANTSSZrribk,
  VGETMANTSSZrribkz,
  VGETMANTSSZrrik,
  VGETMANTSSZrrikz,
  VGF2P8AFFINEINVQBYrmi,
  VGF2P8AFFINEINVQBYrri,
  VGF2P8AFFINEINVQBZ128rmbi,
  VGF2P8AFFINEINVQBZ128rmbik,
  VGF2P8AFFINEINVQBZ128rmbikz,
  VGF2P8AFFINEINVQBZ128rmi,
  VGF2P8AFFINEINVQBZ128rmik,
  VGF2P8AFFINEINVQBZ128rmikz,
  VGF2P8AFFINEINVQBZ128rri,
  VGF2P8AFFINEINVQBZ128rrik,
  VGF2P8AFFINEINVQBZ128rrikz,
  VGF2P8AFFINEINVQBZ256rmbi,
  VGF2P8AFFINEINVQBZ256rmbik,
  VGF2P8AFFINEINVQBZ256rmbikz,
  VGF2P8AFFINEINVQBZ256rmi,
  VGF2P8AFFINEINVQBZ256rmik,
  VGF2P8AFFINEINVQBZ256rmikz,
  VGF2P8AFFINEINVQBZ256rri,
  VGF2P8AFFINEINVQBZ256rrik,
  VGF2P8AFFINEINVQBZ256rrikz,
  VGF2P8AFFINEINVQBZrmbi,
  VGF2P8AFFINEINVQBZrmbik,
  VGF2P8AFFINEINVQBZrmbikz,
  VGF2P8AFFINEINVQBZrmi,
  VGF2P8AFFINEINVQBZrmik,
  VGF2P8AFFINEINVQBZrmikz,
  VGF2P8AFFINEINVQBZrri,
  VGF2P8AFFINEINVQBZrrik,
  VGF2P8AFFINEINVQBZrrikz,
  VGF2P8AFFINEINVQBrmi,
  VGF2P8AFFINEINVQBrri,
  VGF2P8AFFINEQBYrmi,
  VGF2P8AFFINEQBYrri,
  VGF2P8AFFINEQBZ128rmbi,
  VGF2P8AFFINEQBZ128rmbik,
  VGF2P8AFFINEQBZ128rmbikz,
  VGF2P8AFFINEQBZ128rmi,
  VGF2P8AFFINEQBZ128rmik,
  VGF2P8AFFINEQBZ128rmikz,
  VGF2P8AFFINEQBZ128rri,
  VGF2P8AFFINEQBZ128rrik,
  VGF2P8AFFINEQBZ128rrikz,
  VGF2P8AFFINEQBZ256rmbi,
  VGF2P8AFFINEQBZ256rmbik,
  VGF2P8AFFINEQBZ256rmbikz,
  VGF2P8AFFINEQBZ256rmi,
  VGF2P8AFFINEQBZ256rmik,
  VGF2P8AFFINEQBZ256rmikz,
  VGF2P8AFFINEQBZ256rri,
  VGF2P8AFFINEQBZ256rrik,
  VGF2P8AFFINEQBZ256rrikz,
  VGF2P8AFFINEQBZrmbi,
  VGF2P8AFFINEQBZrmbik,
  VGF2P8AFFINEQBZrmbikz,
  VGF2P8AFFINEQBZrmi,
  VGF2P8AFFINEQBZrmik,
  VGF2P8AFFINEQBZrmikz,
  VGF2P8AFFINEQBZrri,
  VGF2P8AFFINEQBZrrik,
  VGF2P8AFFINEQBZrrikz,
  VGF2P8AFFINEQBrmi,
  VGF2P8AFFINEQBrri,
  VGF2P8MULBYrm,
  VGF2P8MULBYrr,
  VGF2P8MULBZ128rm,
  VGF2P8MULBZ128rmk,
  VGF2P8MULBZ128rmkz,
  VGF2P8MULBZ128rr,
  VGF2P8MULBZ128rrk,
  VGF2P8MULBZ128rrkz,
  VGF2P8MULBZ256rm,
  VGF2P8MULBZ256rmk,
  VGF2P8MULBZ256rmkz,
  VGF2P8MULBZ256rr,
  VGF2P8MULBZ256rrk,
  VGF2P8MULBZ256rrkz,
  VGF2P8MULBZrm,
  VGF2P8MULBZrmk,
  VGF2P8MULBZrmkz,
  VGF2P8MULBZrr,
  VGF2P8MULBZrrk,
  VGF2P8MULBZrrkz,
  VGF2P8MULBrm,
  VGF2P8MULBrr,
  VHADDPDYrm,
  VHADDPDYrr,
  VHADDPDrm,
  VHADDPDrr,
  VHADDPSYrm,
  VHADDPSYrr,
  VHADDPSrm,
  VHADDPSrr,
  VHSUBPDYrm,
  VHSUBPDYrr,
  VHSUBPDrm,
  VHSUBPDrr,
  VHSUBPSYrm,
  VHSUBPSYrr,
  VHSUBPSrm,
  VHSUBPSrr,
  VINSERTF128rm,
  VINSERTF128rr,
  VINSERTF32x4Z256rm,
  VINSERTF32x4Z256rmk,
  VINSERTF32x4Z256rmkz,
  VINSERTF32x4Z256rr,
  VINSERTF32x4Z256rrk,
  VINSERTF32x4Z256rrkz,
  VINSERTF32x4Zrm,
  VINSERTF32x4Zrmk,
  VINSERTF32x4Zrmkz,
  VINSERTF32x4Zrr,
  VINSERTF32x4Zrrk,
  VINSERTF32x4Zrrkz,
  VINSERTF32x8Zrm,
  VINSERTF32x8Zrmk,
  VINSERTF32x8Zrmkz,
  VINSERTF32x8Zrr,
  VINSERTF32x8Zrrk,
  VINSERTF32x8Zrrkz,
  VINSERTF64x2Z256rm,
  VINSERTF64x2Z256rmk,
  VINSERTF64x2Z256rmkz,
  VINSERTF64x2Z256rr,
  VINSERTF64x2Z256rrk,
  VINSERTF64x2Z256rrkz,
  VINSERTF64x2Zrm,
  VINSERTF64x2Zrmk,
  VINSERTF64x2Zrmkz,
  VINSERTF64x2Zrr,
  VINSERTF64x2Zrrk,
  VINSERTF64x2Zrrkz,
  VINSERTF64x4Zrm,
  VINSERTF64x4Zrmk,
  VINSERTF64x4Zrmkz,
  VINSERTF64x4Zrr,
  VINSERTF64x4Zrrk,
  VINSERTF64x4Zrrkz,
  VINSERTI128rm,
  VINSERTI128rr,
  VINSERTI32x4Z256rm,
  VINSERTI32x4Z256rmk,
  VINSERTI32x4Z256rmkz,
  VINSERTI32x4Z256rr,
  VINSERTI32x4Z256rrk,
  VINSERTI32x4Z256rrkz,
  VINSERTI32x4Zrm,
  VINSERTI32x4Zrmk,
  VINSERTI32x4Zrmkz,
  VINSERTI32x4Zrr,
  VINSERTI32x4Zrrk,
  VINSERTI32x4Zrrkz,
  VINSERTI32x8Zrm,
  VINSERTI32x8Zrmk,
  VINSERTI32x8Zrmkz,
  VINSERTI32x8Zrr,
  VINSERTI32x8Zrrk,
  VINSERTI32x8Zrrkz,
  VINSERTI64x2Z256rm,
  VINSERTI64x2Z256rmk,
  VINSERTI64x2Z256rmkz,
  VINSERTI64x2Z256rr,
  VINSERTI64x2Z256rrk,
  VINSERTI64x2Z256rrkz,
  VINSERTI64x2Zrm,
  VINSERTI64x2Zrmk,
  VINSERTI64x2Zrmkz,
  VINSERTI64x2Zrr,
  VINSERTI64x2Zrrk,
  VINSERTI64x2Zrrkz,
  VINSERTI64x4Zrm,
  VINSERTI64x4Zrmk,
  VINSERTI64x4Zrmkz,
  VINSERTI64x4Zrr,
  VINSERTI64x4Zrrk,
  VINSERTI64x4Zrrkz,
  VINSERTPSZrm,
  VINSERTPSZrr,
  VINSERTPSrm,
  VINSERTPSrr,
  VLDDQUYrm,
  VLDDQUrm,
  VLDMXCSR,
  VMASKMOVDQU,
  VMASKMOVDQU64,
  VMASKMOVPDYmr,
  VMASKMOVPDYrm,
  VMASKMOVPDmr,
  VMASKMOVPDrm,
  VMASKMOVPSYmr,
  VMASKMOVPSYrm,
  VMASKMOVPSmr,
  VMASKMOVPSrm,
  VMAXCPDYrm,
  VMAXCPDYrr,
  VMAXCPDZ128rm,
  VMAXCPDZ128rmb,
  VMAXCPDZ128rmbk,
  VMAXCPDZ128rmbkz,
  VMAXCPDZ128rmk,
  VMAXCPDZ128rmkz,
  VMAXCPDZ128rr,
  VMAXCPDZ128rrk,
  VMAXCPDZ128rrkz,
  VMAXCPDZ256rm,
  VMAXCPDZ256rmb,
  VMAXCPDZ256rmbk,
  VMAXCPDZ256rmbkz,
  VMAXCPDZ256rmk,
  VMAXCPDZ256rmkz,
  VMAXCPDZ256rr,
  VMAXCPDZ256rrk,
  VMAXCPDZ256rrkz,
  VMAXCPDZrm,
  VMAXCPDZrmb,
  VMAXCPDZrmbk,
  VMAXCPDZrmbkz,
  VMAXCPDZrmk,
  VMAXCPDZrmkz,
  VMAXCPDZrr,
  VMAXCPDZrrk,
  VMAXCPDZrrkz,
  VMAXCPDrm,
  VMAXCPDrr,
  VMAXCPHZ128rm,
  VMAXCPHZ128rmb,
  VMAXCPHZ128rmbk,
  VMAXCPHZ128rmbkz,
  VMAXCPHZ128rmk,
  VMAXCPHZ128rmkz,
  VMAXCPHZ128rr,
  VMAXCPHZ128rrk,
  VMAXCPHZ128rrkz,
  VMAXCPHZ256rm,
  VMAXCPHZ256rmb,
  VMAXCPHZ256rmbk,
  VMAXCPHZ256rmbkz,
  VMAXCPHZ256rmk,
  VMAXCPHZ256rmkz,
  VMAXCPHZ256rr,
  VMAXCPHZ256rrk,
  VMAXCPHZ256rrkz,
  VMAXCPHZrm,
  VMAXCPHZrmb,
  VMAXCPHZrmbk,
  VMAXCPHZrmbkz,
  VMAXCPHZrmk,
  VMAXCPHZrmkz,
  VMAXCPHZrr,
  VMAXCPHZrrk,
  VMAXCPHZrrkz,
  VMAXCPSYrm,
  VMAXCPSYrr,
  VMAXCPSZ128rm,
  VMAXCPSZ128rmb,
  VMAXCPSZ128rmbk,
  VMAXCPSZ128rmbkz,
  VMAXCPSZ128rmk,
  VMAXCPSZ128rmkz,
  VMAXCPSZ128rr,
  VMAXCPSZ128rrk,
  VMAXCPSZ128rrkz,
  VMAXCPSZ256rm,
  VMAXCPSZ256rmb,
  VMAXCPSZ256rmbk,
  VMAXCPSZ256rmbkz,
  VMAXCPSZ256rmk,
  VMAXCPSZ256rmkz,
  VMAXCPSZ256rr,
  VMAXCPSZ256rrk,
  VMAXCPSZ256rrkz,
  VMAXCPSZrm,
  VMAXCPSZrmb,
  VMAXCPSZrmbk,
  VMAXCPSZrmbkz,
  VMAXCPSZrmk,
  VMAXCPSZrmkz,
  VMAXCPSZrr,
  VMAXCPSZrrk,
  VMAXCPSZrrkz,
  VMAXCPSrm,
  VMAXCPSrr,
  VMAXCSDZrm,
  VMAXCSDZrr,
  VMAXCSDrm,
  VMAXCSDrr,
  VMAXCSHZrm,
  VMAXCSHZrr,
  VMAXCSSZrm,
  VMAXCSSZrr,
  VMAXCSSrm,
  VMAXCSSrr,
  VMAXPDYrm,
  VMAXPDYrr,
  VMAXPDZ128rm,
  VMAXPDZ128rmb,
  VMAXPDZ128rmbk,
  VMAXPDZ128rmbkz,
  VMAXPDZ128rmk,
  VMAXPDZ128rmkz,
  VMAXPDZ128rr,
  VMAXPDZ128rrk,
  VMAXPDZ128rrkz,
  VMAXPDZ256rm,
  VMAXPDZ256rmb,
  VMAXPDZ256rmbk,
  VMAXPDZ256rmbkz,
  VMAXPDZ256rmk,
  VMAXPDZ256rmkz,
  VMAXPDZ256rr,
  VMAXPDZ256rrk,
  VMAXPDZ256rrkz,
  VMAXPDZrm,
  VMAXPDZrmb,
  VMAXPDZrmbk,
  VMAXPDZrmbkz,
  VMAXPDZrmk,
  VMAXPDZrmkz,
  VMAXPDZrr,
  VMAXPDZrrb,
  VMAXPDZrrbk,
  VMAXPDZrrbkz,
  VMAXPDZrrk,
  VMAXPDZrrkz,
  VMAXPDrm,
  VMAXPDrr,
  VMAXPHZ128rm,
  VMAXPHZ128rmb,
  VMAXPHZ128rmbk,
  VMAXPHZ128rmbkz,
  VMAXPHZ128rmk,
  VMAXPHZ128rmkz,
  VMAXPHZ128rr,
  VMAXPHZ128rrk,
  VMAXPHZ128rrkz,
  VMAXPHZ256rm,
  VMAXPHZ256rmb,
  VMAXPHZ256rmbk,
  VMAXPHZ256rmbkz,
  VMAXPHZ256rmk,
  VMAXPHZ256rmkz,
  VMAXPHZ256rr,
  VMAXPHZ256rrk,
  VMAXPHZ256rrkz,
  VMAXPHZrm,
  VMAXPHZrmb,
  VMAXPHZrmbk,
  VMAXPHZrmbkz,
  VMAXPHZrmk,
  VMAXPHZrmkz,
  VMAXPHZrr,
  VMAXPHZrrb,
  VMAXPHZrrbk,
  VMAXPHZrrbkz,
  VMAXPHZrrk,
  VMAXPHZrrkz,
  VMAXPSYrm,
  VMAXPSYrr,
  VMAXPSZ128rm,
  VMAXPSZ128rmb,
  VMAXPSZ128rmbk,
  VMAXPSZ128rmbkz,
  VMAXPSZ128rmk,
  VMAXPSZ128rmkz,
  VMAXPSZ128rr,
  VMAXPSZ128rrk,
  VMAXPSZ128rrkz,
  VMAXPSZ256rm,
  VMAXPSZ256rmb,
  VMAXPSZ256rmbk,
  VMAXPSZ256rmbkz,
  VMAXPSZ256rmk,
  VMAXPSZ256rmkz,
  VMAXPSZ256rr,
  VMAXPSZ256rrk,
  VMAXPSZ256rrkz,
  VMAXPSZrm,
  VMAXPSZrmb,
  VMAXPSZrmbk,
  VMAXPSZrmbkz,
  VMAXPSZrmk,
  VMAXPSZrmkz,
  VMAXPSZrr,
  VMAXPSZrrb,
  VMAXPSZrrbk,
  VMAXPSZrrbkz,
  VMAXPSZrrk,
  VMAXPSZrrkz,
  VMAXPSrm,
  VMAXPSrr,
  VMAXSDZrm,
  VMAXSDZrm_Int,
  VMAXSDZrm_Intk,
  VMAXSDZrm_Intkz,
  VMAXSDZrr,
  VMAXSDZrr_Int,
  VMAXSDZrr_Intk,
  VMAXSDZrr_Intkz,
  VMAXSDZrrb_Int,
  VMAXSDZrrb_Intk,
  VMAXSDZrrb_Intkz,
  VMAXSDrm,
  VMAXSDrm_Int,
  VMAXSDrr,
  VMAXSDrr_Int,
  VMAXSHZrm,
  VMAXSHZrm_Int,
  VMAXSHZrm_Intk,
  VMAXSHZrm_Intkz,
  VMAXSHZrr,
  VMAXSHZrr_Int,
  VMAXSHZrr_Intk,
  VMAXSHZrr_Intkz,
  VMAXSHZrrb_Int,
  VMAXSHZrrb_Intk,
  VMAXSHZrrb_Intkz,
  VMAXSSZrm,
  VMAXSSZrm_Int,
  VMAXSSZrm_Intk,
  VMAXSSZrm_Intkz,
  VMAXSSZrr,
  VMAXSSZrr_Int,
  VMAXSSZrr_Intk,
  VMAXSSZrr_Intkz,
  VMAXSSZrrb_Int,
  VMAXSSZrrb_Intk,
  VMAXSSZrrb_Intkz,
  VMAXSSrm,
  VMAXSSrm_Int,
  VMAXSSrr,
  VMAXSSrr_Int,
  VMCALL,
  VMCLEARm,
  VMFUNC,
  VMINCPDYrm,
  VMINCPDYrr,
  VMINCPDZ128rm,
  VMINCPDZ128rmb,
  VMINCPDZ128rmbk,
  VMINCPDZ128rmbkz,
  VMINCPDZ128rmk,
  VMINCPDZ128rmkz,
  VMINCPDZ128rr,
  VMINCPDZ128rrk,
  VMINCPDZ128rrkz,
  VMINCPDZ256rm,
  VMINCPDZ256rmb,
  VMINCPDZ256rmbk,
  VMINCPDZ256rmbkz,
  VMINCPDZ256rmk,
  VMINCPDZ256rmkz,
  VMINCPDZ256rr,
  VMINCPDZ256rrk,
  VMINCPDZ256rrkz,
  VMINCPDZrm,
  VMINCPDZrmb,
  VMINCPDZrmbk,
  VMINCPDZrmbkz,
  VMINCPDZrmk,
  VMINCPDZrmkz,
  VMINCPDZrr,
  VMINCPDZrrk,
  VMINCPDZrrkz,
  VMINCPDrm,
  VMINCPDrr,
  VMINCPHZ128rm,
  VMINCPHZ128rmb,
  VMINCPHZ128rmbk,
  VMINCPHZ128rmbkz,
  VMINCPHZ128rmk,
  VMINCPHZ128rmkz,
  VMINCPHZ128rr,
  VMINCPHZ128rrk,
  VMINCPHZ128rrkz,
  VMINCPHZ256rm,
  VMINCPHZ256rmb,
  VMINCPHZ256rmbk,
  VMINCPHZ256rmbkz,
  VMINCPHZ256rmk,
  VMINCPHZ256rmkz,
  VMINCPHZ256rr,
  VMINCPHZ256rrk,
  VMINCPHZ256rrkz,
  VMINCPHZrm,
  VMINCPHZrmb,
  VMINCPHZrmbk,
  VMINCPHZrmbkz,
  VMINCPHZrmk,
  VMINCPHZrmkz,
  VMINCPHZrr,
  VMINCPHZrrk,
  VMINCPHZrrkz,
  VMINCPSYrm,
  VMINCPSYrr,
  VMINCPSZ128rm,
  VMINCPSZ128rmb,
  VMINCPSZ128rmbk,
  VMINCPSZ128rmbkz,
  VMINCPSZ128rmk,
  VMINCPSZ128rmkz,
  VMINCPSZ128rr,
  VMINCPSZ128rrk,
  VMINCPSZ128rrkz,
  VMINCPSZ256rm,
  VMINCPSZ256rmb,
  VMINCPSZ256rmbk,
  VMINCPSZ256rmbkz,
  VMINCPSZ256rmk,
  VMINCPSZ256rmkz,
  VMINCPSZ256rr,
  VMINCPSZ256rrk,
  VMINCPSZ256rrkz,
  VMINCPSZrm,
  VMINCPSZrmb,
  VMINCPSZrmbk,
  VMINCPSZrmbkz,
  VMINCPSZrmk,
  VMINCPSZrmkz,
  VMINCPSZrr,
  VMINCPSZrrk,
  VMINCPSZrrkz,
  VMINCPSrm,
  VMINCPSrr,
  VMINCSDZrm,
  VMINCSDZrr,
  VMINCSDrm,
  VMINCSDrr,
  VMINCSHZrm,
  VMINCSHZrr,
  VMINCSSZrm,
  VMINCSSZrr,
  VMINCSSrm,
  VMINCSSrr,
  VMINPDYrm,
  VMINPDYrr,
  VMINPDZ128rm,
  VMINPDZ128rmb,
  VMINPDZ128rmbk,
  VMINPDZ128rmbkz,
  VMINPDZ128rmk,
  VMINPDZ128rmkz,
  VMINPDZ128rr,
  VMINPDZ128rrk,
  VMINPDZ128rrkz,
  VMINPDZ256rm,
  VMINPDZ256rmb,
  VMINPDZ256rmbk,
  VMINPDZ256rmbkz,
  VMINPDZ256rmk,
  VMINPDZ256rmkz,
  VMINPDZ256rr,
  VMINPDZ256rrk,
  VMINPDZ256rrkz,
  VMINPDZrm,
  VMINPDZrmb,
  VMINPDZrmbk,
  VMINPDZrmbkz,
  VMINPDZrmk,
  VMINPDZrmkz,
  VMINPDZrr,
  VMINPDZrrb,
  VMINPDZrrbk,
  VMINPDZrrbkz,
  VMINPDZrrk,
  VMINPDZrrkz,
  VMINPDrm,
  VMINPDrr,
  VMINPHZ128rm,
  VMINPHZ128rmb,
  VMINPHZ128rmbk,
  VMINPHZ128rmbkz,
  VMINPHZ128rmk,
  VMINPHZ128rmkz,
  VMINPHZ128rr,
  VMINPHZ128rrk,
  VMINPHZ128rrkz,
  VMINPHZ256rm,
  VMINPHZ256rmb,
  VMINPHZ256rmbk,
  VMINPHZ256rmbkz,
  VMINPHZ256rmk,
  VMINPHZ256rmkz,
  VMINPHZ256rr,
  VMINPHZ256rrk,
  VMINPHZ256rrkz,
  VMINPHZrm,
  VMINPHZrmb,
  VMINPHZrmbk,
  VMINPHZrmbkz,
  VMINPHZrmk,
  VMINPHZrmkz,
  VMINPHZrr,
  VMINPHZrrb,
  VMINPHZrrbk,
  VMINPHZrrbkz,
  VMINPHZrrk,
  VMINPHZrrkz,
  VMINPSYrm,
  VMINPSYrr,
  VMINPSZ128rm,
  VMINPSZ128rmb,
  VMINPSZ128rmbk,
  VMINPSZ128rmbkz,
  VMINPSZ128rmk,
  VMINPSZ128rmkz,
  VMINPSZ128rr,
  VMINPSZ128rrk,
  VMINPSZ128rrkz,
  VMINPSZ256rm,
  VMINPSZ256rmb,
  VMINPSZ256rmbk,
  VMINPSZ256rmbkz,
  VMINPSZ256rmk,
  VMINPSZ256rmkz,
  VMINPSZ256rr,
  VMINPSZ256rrk,
  VMINPSZ256rrkz,
  VMINPSZrm,
  VMINPSZrmb,
  VMINPSZrmbk,
  VMINPSZrmbkz,
  VMINPSZrmk,
  VMINPSZrmkz,
  VMINPSZrr,
  VMINPSZrrb,
  VMINPSZrrbk,
  VMINPSZrrbkz,
  VMINPSZrrk,
  VMINPSZrrkz,
  VMINPSrm,
  VMINPSrr,
  VMINSDZrm,
  VMINSDZrm_Int,
  VMINSDZrm_Intk,
  VMINSDZrm_Intkz,
  VMINSDZrr,
  VMINSDZrr_Int,
  VMINSDZrr_Intk,
  VMINSDZrr_Intkz,
  VMINSDZrrb_Int,
  VMINSDZrrb_Intk,
  VMINSDZrrb_Intkz,
  VMINSDrm,
  VMINSDrm_Int,
  VMINSDrr,
  VMINSDrr_Int,
  VMINSHZrm,
  VMINSHZrm_Int,
  VMINSHZrm_Intk,
  VMINSHZrm_Intkz,
  VMINSHZrr,
  VMINSHZrr_Int,
  VMINSHZrr_Intk,
  VMINSHZrr_Intkz,
  VMINSHZrrb_Int,
  VMINSHZrrb_Intk,
  VMINSHZrrb_Intkz,
  VMINSSZrm,
  VMINSSZrm_Int,
  VMINSSZrm_Intk,
  VMINSSZrm_Intkz,
  VMINSSZrr,
  VMINSSZrr_Int,
  VMINSSZrr_Intk,
  VMINSSZrr_Intkz,
  VMINSSZrrb_Int,
  VMINSSZrrb_Intk,
  VMINSSZrrb_Intkz,
  VMINSSrm,
  VMINSSrm_Int,
  VMINSSrr,
  VMINSSrr_Int,
  VMLAUNCH,
  VMLOAD32,
  VMLOAD64,
  VMMCALL,
  VMOV64toPQIZrm,
  VMOV64toPQIZrr,
  VMOV64toPQIrm,
  VMOV64toPQIrr,
  VMOV64toSDZrr,
  VMOV64toSDrr,
  VMOVAPDYmr,
  VMOVAPDYrm,
  VMOVAPDYrr,
  VMOVAPDYrr_REV,
  VMOVAPDZ128mr,
  VMOVAPDZ128mrk,
  VMOVAPDZ128rm,
  VMOVAPDZ128rmk,
  VMOVAPDZ128rmkz,
  VMOVAPDZ128rr,
  VMOVAPDZ128rr_REV,
  VMOVAPDZ128rrk,
  VMOVAPDZ128rrk_REV,
  VMOVAPDZ128rrkz,
  VMOVAPDZ128rrkz_REV,
  VMOVAPDZ256mr,
  VMOVAPDZ256mrk,
  VMOVAPDZ256rm,
  VMOVAPDZ256rmk,
  VMOVAPDZ256rmkz,
  VMOVAPDZ256rr,
  VMOVAPDZ256rr_REV,
  VMOVAPDZ256rrk,
  VMOVAPDZ256rrk_REV,
  VMOVAPDZ256rrkz,
  VMOVAPDZ256rrkz_REV,
  VMOVAPDZmr,
  VMOVAPDZmrk,
  VMOVAPDZrm,
  VMOVAPDZrmk,
  VMOVAPDZrmkz,
  VMOVAPDZrr,
  VMOVAPDZrr_REV,
  VMOVAPDZrrk,
  VMOVAPDZrrk_REV,
  VMOVAPDZrrkz,
  VMOVAPDZrrkz_REV,
  VMOVAPDmr,
  VMOVAPDrm,
  VMOVAPDrr,
  VMOVAPDrr_REV,
  VMOVAPSYmr,
  VMOVAPSYrm,
  VMOVAPSYrr,
  VMOVAPSYrr_REV,
  VMOVAPSZ128mr,
  VMOVAPSZ128mrk,
  VMOVAPSZ128rm,
  VMOVAPSZ128rmk,
  VMOVAPSZ128rmkz,
  VMOVAPSZ128rr,
  VMOVAPSZ128rr_REV,
  VMOVAPSZ128rrk,
  VMOVAPSZ128rrk_REV,
  VMOVAPSZ128rrkz,
  VMOVAPSZ128rrkz_REV,
  VMOVAPSZ256mr,
  VMOVAPSZ256mrk,
  VMOVAPSZ256rm,
  VMOVAPSZ256rmk,
  VMOVAPSZ256rmkz,
  VMOVAPSZ256rr,
  VMOVAPSZ256rr_REV,
  VMOVAPSZ256rrk,
  VMOVAPSZ256rrk_REV,
  VMOVAPSZ256rrkz,
  VMOVAPSZ256rrkz_REV,
  VMOVAPSZmr,
  VMOVAPSZmrk,
  VMOVAPSZrm,
  VMOVAPSZrmk,
  VMOVAPSZrmkz,
  VMOVAPSZrr,
  VMOVAPSZrr_REV,
  VMOVAPSZrrk,
  VMOVAPSZrrk_REV,
  VMOVAPSZrrkz,
  VMOVAPSZrrkz_REV,
  VMOVAPSmr,
  VMOVAPSrm,
  VMOVAPSrr,
  VMOVAPSrr_REV,
  VMOVDDUPYrm,
  VMOVDDUPYrr,
  VMOVDDUPZ128rm,
  VMOVDDUPZ128rmk,
  VMOVDDUPZ128rmkz,
  VMOVDDUPZ128rr,
  VMOVDDUPZ128rrk,
  VMOVDDUPZ128rrkz,
  VMOVDDUPZ256rm,
  VMOVDDUPZ256rmk,
  VMOVDDUPZ256rmkz,
  VMOVDDUPZ256rr,
  VMOVDDUPZ256rrk,
  VMOVDDUPZ256rrkz,
  VMOVDDUPZrm,
  VMOVDDUPZrmk,
  VMOVDDUPZrmkz,
  VMOVDDUPZrr,
  VMOVDDUPZrrk,
  VMOVDDUPZrrkz,
  VMOVDDUPrm,
  VMOVDDUPrr,
  VMOVDI2PDIZrm,
  VMOVDI2PDIZrr,
  VMOVDI2PDIrm,
  VMOVDI2PDIrr,
  VMOVDI2SSZrr,
  VMOVDI2SSrr,
  VMOVDQA32Z128mr,
  VMOVDQA32Z128mrk,
  VMOVDQA32Z128rm,
  VMOVDQA32Z128rmk,
  VMOVDQA32Z128rmkz,
  VMOVDQA32Z128rr,
  VMOVDQA32Z128rr_REV,
  VMOVDQA32Z128rrk,
  VMOVDQA32Z128rrk_REV,
  VMOVDQA32Z128rrkz,
  VMOVDQA32Z128rrkz_REV,
  VMOVDQA32Z256mr,
  VMOVDQA32Z256mrk,
  VMOVDQA32Z256rm,
  VMOVDQA32Z256rmk,
  VMOVDQA32Z256rmkz,
  VMOVDQA32Z256rr,
  VMOVDQA32Z256rr_REV,
  VMOVDQA32Z256rrk,
  VMOVDQA32Z256rrk_REV,
  VMOVDQA32Z256rrkz,
  VMOVDQA32Z256rrkz_REV,
  VMOVDQA32Zmr,
  VMOVDQA32Zmrk,
  VMOVDQA32Zrm,
  VMOVDQA32Zrmk,
  VMOVDQA32Zrmkz,
  VMOVDQA32Zrr,
  VMOVDQA32Zrr_REV,
  VMOVDQA32Zrrk,
  VMOVDQA32Zrrk_REV,
  VMOVDQA32Zrrkz,
  VMOVDQA32Zrrkz_REV,
  VMOVDQA64Z128mr,
  VMOVDQA64Z128mrk,
  VMOVDQA64Z128rm,
  VMOVDQA64Z128rmk,
  VMOVDQA64Z128rmkz,
  VMOVDQA64Z128rr,
  VMOVDQA64Z128rr_REV,
  VMOVDQA64Z128rrk,
  VMOVDQA64Z128rrk_REV,
  VMOVDQA64Z128rrkz,
  VMOVDQA64Z128rrkz_REV,
  VMOVDQA64Z256mr,
  VMOVDQA64Z256mrk,
  VMOVDQA64Z256rm,
  VMOVDQA64Z256rmk,
  VMOVDQA64Z256rmkz,
  VMOVDQA64Z256rr,
  VMOVDQA64Z256rr_REV,
  VMOVDQA64Z256rrk,
  VMOVDQA64Z256rrk_REV,
  VMOVDQA64Z256rrkz,
  VMOVDQA64Z256rrkz_REV,
  VMOVDQA64Zmr,
  VMOVDQA64Zmrk,
  VMOVDQA64Zrm,
  VMOVDQA64Zrmk,
  VMOVDQA64Zrmkz,
  VMOVDQA64Zrr,
  VMOVDQA64Zrr_REV,
  VMOVDQA64Zrrk,
  VMOVDQA64Zrrk_REV,
  VMOVDQA64Zrrkz,
  VMOVDQA64Zrrkz_REV,
  VMOVDQAYmr,
  VMOVDQAYrm,
  VMOVDQAYrr,
  VMOVDQAYrr_REV,
  VMOVDQAmr,
  VMOVDQArm,
  VMOVDQArr,
  VMOVDQArr_REV,
  VMOVDQU16Z128mr,
  VMOVDQU16Z128mrk,
  VMOVDQU16Z128rm,
  VMOVDQU16Z128rmk,
  VMOVDQU16Z128rmkz,
  VMOVDQU16Z128rr,
  VMOVDQU16Z128rr_REV,
  VMOVDQU16Z128rrk,
  VMOVDQU16Z128rrk_REV,
  VMOVDQU16Z128rrkz,
  VMOVDQU16Z128rrkz_REV,
  VMOVDQU16Z256mr,
  VMOVDQU16Z256mrk,
  VMOVDQU16Z256rm,
  VMOVDQU16Z256rmk,
  VMOVDQU16Z256rmkz,
  VMOVDQU16Z256rr,
  VMOVDQU16Z256rr_REV,
  VMOVDQU16Z256rrk,
  VMOVDQU16Z256rrk_REV,
  VMOVDQU16Z256rrkz,
  VMOVDQU16Z256rrkz_REV,
  VMOVDQU16Zmr,
  VMOVDQU16Zmrk,
  VMOVDQU16Zrm,
  VMOVDQU16Zrmk,
  VMOVDQU16Zrmkz,
  VMOVDQU16Zrr,
  VMOVDQU16Zrr_REV,
  VMOVDQU16Zrrk,
  VMOVDQU16Zrrk_REV,
  VMOVDQU16Zrrkz,
  VMOVDQU16Zrrkz_REV,
  VMOVDQU32Z128mr,
  VMOVDQU32Z128mrk,
  VMOVDQU32Z128rm,
  VMOVDQU32Z128rmk,
  VMOVDQU32Z128rmkz,
  VMOVDQU32Z128rr,
  VMOVDQU32Z128rr_REV,
  VMOVDQU32Z128rrk,
  VMOVDQU32Z128rrk_REV,
  VMOVDQU32Z128rrkz,
  VMOVDQU32Z128rrkz_REV,
  VMOVDQU32Z256mr,
  VMOVDQU32Z256mrk,
  VMOVDQU32Z256rm,
  VMOVDQU32Z256rmk,
  VMOVDQU32Z256rmkz,
  VMOVDQU32Z256rr,
  VMOVDQU32Z256rr_REV,
  VMOVDQU32Z256rrk,
  VMOVDQU32Z256rrk_REV,
  VMOVDQU32Z256rrkz,
  VMOVDQU32Z256rrkz_REV,
  VMOVDQU32Zmr,
  VMOVDQU32Zmrk,
  VMOVDQU32Zrm,
  VMOVDQU32Zrmk,
  VMOVDQU32Zrmkz,
  VMOVDQU32Zrr,
  VMOVDQU32Zrr_REV,
  VMOVDQU32Zrrk,
  VMOVDQU32Zrrk_REV,
  VMOVDQU32Zrrkz,
  VMOVDQU32Zrrkz_REV,
  VMOVDQU64Z128mr,
  VMOVDQU64Z128mrk,
  VMOVDQU64Z128rm,
  VMOVDQU64Z128rmk,
  VMOVDQU64Z128rmkz,
  VMOVDQU64Z128rr,
  VMOVDQU64Z128rr_REV,
  VMOVDQU64Z128rrk,
  VMOVDQU64Z128rrk_REV,
  VMOVDQU64Z128rrkz,
  VMOVDQU64Z128rrkz_REV,
  VMOVDQU64Z256mr,
  VMOVDQU64Z256mrk,
  VMOVDQU64Z256rm,
  VMOVDQU64Z256rmk,
  VMOVDQU64Z256rmkz,
  VMOVDQU64Z256rr,
  VMOVDQU64Z256rr_REV,
  VMOVDQU64Z256rrk,
  VMOVDQU64Z256rrk_REV,
  VMOVDQU64Z256rrkz,
  VMOVDQU64Z256rrkz_REV,
  VMOVDQU64Zmr,
  VMOVDQU64Zmrk,
  VMOVDQU64Zrm,
  VMOVDQU64Zrmk,
  VMOVDQU64Zrmkz,
  VMOVDQU64Zrr,
  VMOVDQU64Zrr_REV,
  VMOVDQU64Zrrk,
  VMOVDQU64Zrrk_REV,
  VMOVDQU64Zrrkz,
  VMOVDQU64Zrrkz_REV,
  VMOVDQU8Z128mr,
  VMOVDQU8Z128mrk,
  VMOVDQU8Z128rm,
  VMOVDQU8Z128rmk,
  VMOVDQU8Z128rmkz,
  VMOVDQU8Z128rr,
  VMOVDQU8Z128rr_REV,
  VMOVDQU8Z128rrk,
  VMOVDQU8Z128rrk_REV,
  VMOVDQU8Z128rrkz,
  VMOVDQU8Z128rrkz_REV,
  VMOVDQU8Z256mr,
  VMOVDQU8Z256mrk,
  VMOVDQU8Z256rm,
  VMOVDQU8Z256rmk,
  VMOVDQU8Z256rmkz,
  VMOVDQU8Z256rr,
  VMOVDQU8Z256rr_REV,
  VMOVDQU8Z256rrk,
  VMOVDQU8Z256rrk_REV,
  VMOVDQU8Z256rrkz,
  VMOVDQU8Z256rrkz_REV,
  VMOVDQU8Zmr,
  VMOVDQU8Zmrk,
  VMOVDQU8Zrm,
  VMOVDQU8Zrmk,
  VMOVDQU8Zrmkz,
  VMOVDQU8Zrr,
  VMOVDQU8Zrr_REV,
  VMOVDQU8Zrrk,
  VMOVDQU8Zrrk_REV,
  VMOVDQU8Zrrkz,
  VMOVDQU8Zrrkz_REV,
  VMOVDQUYmr,
  VMOVDQUYrm,
  VMOVDQUYrr,
  VMOVDQUYrr_REV,
  VMOVDQUmr,
  VMOVDQUrm,
  VMOVDQUrr,
  VMOVDQUrr_REV,
  VMOVHLPSZrr,
  VMOVHLPSrr,
  VMOVHPDZ128mr,
  VMOVHPDZ128rm,
  VMOVHPDmr,
  VMOVHPDrm,
  VMOVHPSZ128mr,
  VMOVHPSZ128rm,
  VMOVHPSmr,
  VMOVHPSrm,
  VMOVLHPSZrr,
  VMOVLHPSrr,
  VMOVLPDZ128mr,
  VMOVLPDZ128rm,
  VMOVLPDmr,
  VMOVLPDrm,
  VMOVLPSZ128mr,
  VMOVLPSZ128rm,
  VMOVLPSmr,
  VMOVLPSrm,
  VMOVMSKPDYrr,
  VMOVMSKPDrr,
  VMOVMSKPSYrr,
  VMOVMSKPSrr,
  VMOVNTDQAYrm,
  VMOVNTDQAZ128rm,
  VMOVNTDQAZ256rm,
  VMOVNTDQAZrm,
  VMOVNTDQArm,
  VMOVNTDQYmr,
  VMOVNTDQZ128mr,
  VMOVNTDQZ256mr,
  VMOVNTDQZmr,
  VMOVNTDQmr,
  VMOVNTPDYmr,
  VMOVNTPDZ128mr,
  VMOVNTPDZ256mr,
  VMOVNTPDZmr,
  VMOVNTPDmr,
  VMOVNTPSYmr,
  VMOVNTPSZ128mr,
  VMOVNTPSZ256mr,
  VMOVNTPSZmr,
  VMOVNTPSmr,
  VMOVPDI2DIZmr,
  VMOVPDI2DIZrr,
  VMOVPDI2DImr,
  VMOVPDI2DIrr,
  VMOVPQI2QIZmr,
  VMOVPQI2QIZrr,
  VMOVPQI2QImr,
  VMOVPQI2QIrr,
  VMOVPQIto64Zmr,
  VMOVPQIto64Zrr,
  VMOVPQIto64mr,
  VMOVPQIto64rr,
  VMOVQI2PQIZrm,
  VMOVQI2PQIrm,
  VMOVSDZmr,
  VMOVSDZmrk,
  VMOVSDZrm,
  VMOVSDZrm_alt,
  VMOVSDZrmk,
  VMOVSDZrmkz,
  VMOVSDZrr,
  VMOVSDZrr_REV,
  VMOVSDZrrk,
  VMOVSDZrrk_REV,
  VMOVSDZrrkz,
  VMOVSDZrrkz_REV,
  VMOVSDmr,
  VMOVSDrm,
  VMOVSDrm_alt,
  VMOVSDrr,
  VMOVSDrr_REV,
  VMOVSDto64Zrr,
  VMOVSDto64rr,
  VMOVSH2Wrr,
  VMOVSHDUPYrm,
  VMOVSHDUPYrr,
  VMOVSHDUPZ128rm,
  VMOVSHDUPZ128rmk,
  VMOVSHDUPZ128rmkz,
  VMOVSHDUPZ128rr,
  VMOVSHDUPZ128rrk,
  VMOVSHDUPZ128rrkz,
  VMOVSHDUPZ256rm,
  VMOVSHDUPZ256rmk,
  VMOVSHDUPZ256rmkz,
  VMOVSHDUPZ256rr,
  VMOVSHDUPZ256rrk,
  VMOVSHDUPZ256rrkz,
  VMOVSHDUPZrm,
  VMOVSHDUPZrmk,
  VMOVSHDUPZrmkz,
  VMOVSHDUPZrr,
  VMOVSHDUPZrrk,
  VMOVSHDUPZrrkz,
  VMOVSHDUPrm,
  VMOVSHDUPrr,
  VMOVSHZmr,
  VMOVSHZmrk,
  VMOVSHZrm,
  VMOVSHZrm_alt,
  VMOVSHZrmk,
  VMOVSHZrmkz,
  VMOVSHZrr,
  VMOVSHZrr_REV,
  VMOVSHZrrk,
  VMOVSHZrrk_REV,
  VMOVSHZrrkz,
  VMOVSHZrrkz_REV,
  VMOVSHtoW64rr,
  VMOVSLDUPYrm,
  VMOVSLDUPYrr,
  VMOVSLDUPZ128rm,
  VMOVSLDUPZ128rmk,
  VMOVSLDUPZ128rmkz,
  VMOVSLDUPZ128rr,
  VMOVSLDUPZ128rrk,
  VMOVSLDUPZ128rrkz,
  VMOVSLDUPZ256rm,
  VMOVSLDUPZ256rmk,
  VMOVSLDUPZ256rmkz,
  VMOVSLDUPZ256rr,
  VMOVSLDUPZ256rrk,
  VMOVSLDUPZ256rrkz,
  VMOVSLDUPZrm,
  VMOVSLDUPZrmk,
  VMOVSLDUPZrmkz,
  VMOVSLDUPZrr,
  VMOVSLDUPZrrk,
  VMOVSLDUPZrrkz,
  VMOVSLDUPrm,
  VMOVSLDUPrr,
  VMOVSS2DIZrr,
  VMOVSS2DIrr,
  VMOVSSZmr,
  VMOVSSZmrk,
  VMOVSSZrm,
  VMOVSSZrm_alt,
  VMOVSSZrmk,
  VMOVSSZrmkz,
  VMOVSSZrr,
  VMOVSSZrr_REV,
  VMOVSSZrrk,
  VMOVSSZrrk_REV,
  VMOVSSZrrkz,
  VMOVSSZrrkz_REV,
  VMOVSSmr,
  VMOVSSrm,
  VMOVSSrm_alt,
  VMOVSSrr,
  VMOVSSrr_REV,
  VMOVUPDYmr,
  VMOVUPDYrm,
  VMOVUPDYrr,
  VMOVUPDYrr_REV,
  VMOVUPDZ128mr,
  VMOVUPDZ128mrk,
  VMOVUPDZ128rm,
  VMOVUPDZ128rmk,
  VMOVUPDZ128rmkz,
  VMOVUPDZ128rr,
  VMOVUPDZ128rr_REV,
  VMOVUPDZ128rrk,
  VMOVUPDZ128rrk_REV,
  VMOVUPDZ128rrkz,
  VMOVUPDZ128rrkz_REV,
  VMOVUPDZ256mr,
  VMOVUPDZ256mrk,
  VMOVUPDZ256rm,
  VMOVUPDZ256rmk,
  VMOVUPDZ256rmkz,
  VMOVUPDZ256rr,
  VMOVUPDZ256rr_REV,
  VMOVUPDZ256rrk,
  VMOVUPDZ256rrk_REV,
  VMOVUPDZ256rrkz,
  VMOVUPDZ256rrkz_REV,
  VMOVUPDZmr,
  VMOVUPDZmrk,
  VMOVUPDZrm,
  VMOVUPDZrmk,
  VMOVUPDZrmkz,
  VMOVUPDZrr,
  VMOVUPDZrr_REV,
  VMOVUPDZrrk,
  VMOVUPDZrrk_REV,
  VMOVUPDZrrkz,
  VMOVUPDZrrkz_REV,
  VMOVUPDmr,
  VMOVUPDrm,
  VMOVUPDrr,
  VMOVUPDrr_REV,
  VMOVUPSYmr,
  VMOVUPSYrm,
  VMOVUPSYrr,
  VMOVUPSYrr_REV,
  VMOVUPSZ128mr,
  VMOVUPSZ128mrk,
  VMOVUPSZ128rm,
  VMOVUPSZ128rmk,
  VMOVUPSZ128rmkz,
  VMOVUPSZ128rr,
  VMOVUPSZ128rr_REV,
  VMOVUPSZ128rrk,
  VMOVUPSZ128rrk_REV,
  VMOVUPSZ128rrkz,
  VMOVUPSZ128rrkz_REV,
  VMOVUPSZ256mr,
  VMOVUPSZ256mrk,
  VMOVUPSZ256rm,
  VMOVUPSZ256rmk,
  VMOVUPSZ256rmkz,
  VMOVUPSZ256rr,
  VMOVUPSZ256rr_REV,
  VMOVUPSZ256rrk,
  VMOVUPSZ256rrk_REV,
  VMOVUPSZ256rrkz,
  VMOVUPSZ256rrkz_REV,
  VMOVUPSZmr,
  VMOVUPSZmrk,
  VMOVUPSZrm,
  VMOVUPSZrmk,
  VMOVUPSZrmkz,
  VMOVUPSZrr,
  VMOVUPSZrr_REV,
  VMOVUPSZrrk,
  VMOVUPSZrrk_REV,
  VMOVUPSZrrkz,
  VMOVUPSZrrkz_REV,
  VMOVUPSmr,
  VMOVUPSrm,
  VMOVUPSrr,
  VMOVUPSrr_REV,
  VMOVW2SHrr,
  VMOVW64toSHrr,
  VMOVWmr,
  VMOVWrm,
  VMOVZPQILo2PQIZrr,
  VMOVZPQILo2PQIrr,
  VMPSADBWYrmi,
  VMPSADBWYrri,
  VMPSADBWrmi,
  VMPSADBWrri,
  VMPTRLDm,
  VMPTRSTm,
  VMREAD32mr,
  VMREAD32rr,
  VMREAD64mr,
  VMREAD64rr,
  VMRESUME,
  VMRUN32,
  VMRUN64,
  VMSAVE32,
  VMSAVE64,
  VMULPDYrm,
  VMULPDYrr,
  VMULPDZ128rm,
  VMULPDZ128rmb,
  VMULPDZ128rmbk,
  VMULPDZ128rmbkz,
  VMULPDZ128rmk,
  VMULPDZ128rmkz,
  VMULPDZ128rr,
  VMULPDZ128rrk,
  VMULPDZ128rrkz,
  VMULPDZ256rm,
  VMULPDZ256rmb,
  VMULPDZ256rmbk,
  VMULPDZ256rmbkz,
  VMULPDZ256rmk,
  VMULPDZ256rmkz,
  VMULPDZ256rr,
  VMULPDZ256rrk,
  VMULPDZ256rrkz,
  VMULPDZrm,
  VMULPDZrmb,
  VMULPDZrmbk,
  VMULPDZrmbkz,
  VMULPDZrmk,
  VMULPDZrmkz,
  VMULPDZrr,
  VMULPDZrrb,
  VMULPDZrrbk,
  VMULPDZrrbkz,
  VMULPDZrrk,
  VMULPDZrrkz,
  VMULPDrm,
  VMULPDrr,
  VMULPHZ128rm,
  VMULPHZ128rmb,
  VMULPHZ128rmbk,
  VMULPHZ128rmbkz,
  VMULPHZ128rmk,
  VMULPHZ128rmkz,
  VMULPHZ128rr,
  VMULPHZ128rrk,
  VMULPHZ128rrkz,
  VMULPHZ256rm,
  VMULPHZ256rmb,
  VMULPHZ256rmbk,
  VMULPHZ256rmbkz,
  VMULPHZ256rmk,
  VMULPHZ256rmkz,
  VMULPHZ256rr,
  VMULPHZ256rrk,
  VMULPHZ256rrkz,
  VMULPHZrm,
  VMULPHZrmb,
  VMULPHZrmbk,
  VMULPHZrmbkz,
  VMULPHZrmk,
  VMULPHZrmkz,
  VMULPHZrr,
  VMULPHZrrb,
  VMULPHZrrbk,
  VMULPHZrrbkz,
  VMULPHZrrk,
  VMULPHZrrkz,
  VMULPSYrm,
  VMULPSYrr,
  VMULPSZ128rm,
  VMULPSZ128rmb,
  VMULPSZ128rmbk,
  VMULPSZ128rmbkz,
  VMULPSZ128rmk,
  VMULPSZ128rmkz,
  VMULPSZ128rr,
  VMULPSZ128rrk,
  VMULPSZ128rrkz,
  VMULPSZ256rm,
  VMULPSZ256rmb,
  VMULPSZ256rmbk,
  VMULPSZ256rmbkz,
  VMULPSZ256rmk,
  VMULPSZ256rmkz,
  VMULPSZ256rr,
  VMULPSZ256rrk,
  VMULPSZ256rrkz,
  VMULPSZrm,
  VMULPSZrmb,
  VMULPSZrmbk,
  VMULPSZrmbkz,
  VMULPSZrmk,
  VMULPSZrmkz,
  VMULPSZrr,
  VMULPSZrrb,
  VMULPSZrrbk,
  VMULPSZrrbkz,
  VMULPSZrrk,
  VMULPSZrrkz,
  VMULPSrm,
  VMULPSrr,
  VMULSDZrm,
  VMULSDZrm_Int,
  VMULSDZrm_Intk,
  VMULSDZrm_Intkz,
  VMULSDZrr,
  VMULSDZrr_Int,
  VMULSDZrr_Intk,
  VMULSDZrr_Intkz,
  VMULSDZrrb_Int,
  VMULSDZrrb_Intk,
  VMULSDZrrb_Intkz,
  VMULSDrm,
  VMULSDrm_Int,
  VMULSDrr,
  VMULSDrr_Int,
  VMULSHZrm,
  VMULSHZrm_Int,
  VMULSHZrm_Intk,
  VMULSHZrm_Intkz,
  VMULSHZrr,
  VMULSHZrr_Int,
  VMULSHZrr_Intk,
  VMULSHZrr_Intkz,
  VMULSHZrrb_Int,
  VMULSHZrrb_Intk,
  VMULSHZrrb_Intkz,
  VMULSSZrm,
  VMULSSZrm_Int,
  VMULSSZrm_Intk,
  VMULSSZrm_Intkz,
  VMULSSZrr,
  VMULSSZrr_Int,
  VMULSSZrr_Intk,
  VMULSSZrr_Intkz,
  VMULSSZrrb_Int,
  VMULSSZrrb_Intk,
  VMULSSZrrb_Intkz,
  VMULSSrm,
  VMULSSrm_Int,
  VMULSSrr,
  VMULSSrr_Int,
  VMWRITE32rm,
  VMWRITE32rr,
  VMWRITE64rm,
  VMWRITE64rr,
  VMXOFF,
  VMXON,
  VORPDYrm,
  VORPDYrr,
  VORPDZ128rm,
  VORPDZ128rmb,
  VORPDZ128rmbk,
  VORPDZ128rmbkz,
  VORPDZ128rmk,
  VORPDZ128rmkz,
  VORPDZ128rr,
  VORPDZ128rrk,
  VORPDZ128rrkz,
  VORPDZ256rm,
  VORPDZ256rmb,
  VORPDZ256rmbk,
  VORPDZ256rmbkz,
  VORPDZ256rmk,
  VORPDZ256rmkz,
  VORPDZ256rr,
  VORPDZ256rrk,
  VORPDZ256rrkz,
  VORPDZrm,
  VORPDZrmb,
  VORPDZrmbk,
  VORPDZrmbkz,
  VORPDZrmk,
  VORPDZrmkz,
  VORPDZrr,
  VORPDZrrk,
  VORPDZrrkz,
  VORPDrm,
  VORPDrr,
  VORPSYrm,
  VORPSYrr,
  VORPSZ128rm,
  VORPSZ128rmb,
  VORPSZ128rmbk,
  VORPSZ128rmbkz,
  VORPSZ128rmk,
  VORPSZ128rmkz,
  VORPSZ128rr,
  VORPSZ128rrk,
  VORPSZ128rrkz,
  VORPSZ256rm,
  VORPSZ256rmb,
  VORPSZ256rmbk,
  VORPSZ256rmbkz,
  VORPSZ256rmk,
  VORPSZ256rmkz,
  VORPSZ256rr,
  VORPSZ256rrk,
  VORPSZ256rrkz,
  VORPSZrm,
  VORPSZrmb,
  VORPSZrmbk,
  VORPSZrmbkz,
  VORPSZrmk,
  VORPSZrmkz,
  VORPSZrr,
  VORPSZrrk,
  VORPSZrrkz,
  VORPSrm,
  VORPSrr,
  VP2INTERSECTDZ128rm,
  VP2INTERSECTDZ128rmb,
  VP2INTERSECTDZ128rr,
  VP2INTERSECTDZ256rm,
  VP2INTERSECTDZ256rmb,
  VP2INTERSECTDZ256rr,
  VP2INTERSECTDZrm,
  VP2INTERSECTDZrmb,
  VP2INTERSECTDZrr,
  VP2INTERSECTQZ128rm,
  VP2INTERSECTQZ128rmb,
  VP2INTERSECTQZ128rr,
  VP2INTERSECTQZ256rm,
  VP2INTERSECTQZ256rmb,
  VP2INTERSECTQZ256rr,
  VP2INTERSECTQZrm,
  VP2INTERSECTQZrmb,
  VP2INTERSECTQZrr,
  VP4DPWSSDSrm,
  VP4DPWSSDSrmk,
  VP4DPWSSDSrmkz,
  VP4DPWSSDrm,
  VP4DPWSSDrmk,
  VP4DPWSSDrmkz,
  VPABSBYrm,
  VPABSBYrr,
  VPABSBZ128rm,
  VPABSBZ128rmk,
  VPABSBZ128rmkz,
  VPABSBZ128rr,
  VPABSBZ128rrk,
  VPABSBZ128rrkz,
  VPABSBZ256rm,
  VPABSBZ256rmk,
  VPABSBZ256rmkz,
  VPABSBZ256rr,
  VPABSBZ256rrk,
  VPABSBZ256rrkz,
  VPABSBZrm,
  VPABSBZrmk,
  VPABSBZrmkz,
  VPABSBZrr,
  VPABSBZrrk,
  VPABSBZrrkz,
  VPABSBrm,
  VPABSBrr,
  VPABSDYrm,
  VPABSDYrr,
  VPABSDZ128rm,
  VPABSDZ128rmb,
  VPABSDZ128rmbk,
  VPABSDZ128rmbkz,
  VPABSDZ128rmk,
  VPABSDZ128rmkz,
  VPABSDZ128rr,
  VPABSDZ128rrk,
  VPABSDZ128rrkz,
  VPABSDZ256rm,
  VPABSDZ256rmb,
  VPABSDZ256rmbk,
  VPABSDZ256rmbkz,
  VPABSDZ256rmk,
  VPABSDZ256rmkz,
  VPABSDZ256rr,
  VPABSDZ256rrk,
  VPABSDZ256rrkz,
  VPABSDZrm,
  VPABSDZrmb,
  VPABSDZrmbk,
  VPABSDZrmbkz,
  VPABSDZrmk,
  VPABSDZrmkz,
  VPABSDZrr,
  VPABSDZrrk,
  VPABSDZrrkz,
  VPABSDrm,
  VPABSDrr,
  VPABSQZ128rm,
  VPABSQZ128rmb,
  VPABSQZ128rmbk,
  VPABSQZ128rmbkz,
  VPABSQZ128rmk,
  VPABSQZ128rmkz,
  VPABSQZ128rr,
  VPABSQZ128rrk,
  VPABSQZ128rrkz,
  VPABSQZ256rm,
  VPABSQZ256rmb,
  VPABSQZ256rmbk,
  VPABSQZ256rmbkz,
  VPABSQZ256rmk,
  VPABSQZ256rmkz,
  VPABSQZ256rr,
  VPABSQZ256rrk,
  VPABSQZ256rrkz,
  VPABSQZrm,
  VPABSQZrmb,
  VPABSQZrmbk,
  VPABSQZrmbkz,
  VPABSQZrmk,
  VPABSQZrmkz,
  VPABSQZrr,
  VPABSQZrrk,
  VPABSQZrrkz,
  VPABSWYrm,
  VPABSWYrr,
  VPABSWZ128rm,
  VPABSWZ128rmk,
  VPABSWZ128rmkz,
  VPABSWZ128rr,
  VPABSWZ128rrk,
  VPABSWZ128rrkz,
  VPABSWZ256rm,
  VPABSWZ256rmk,
  VPABSWZ256rmkz,
  VPABSWZ256rr,
  VPABSWZ256rrk,
  VPABSWZ256rrkz,
  VPABSWZrm,
  VPABSWZrmk,
  VPABSWZrmkz,
  VPABSWZrr,
  VPABSWZrrk,
  VPABSWZrrkz,
  VPABSWrm,
  VPABSWrr,
  VPACKSSDWYrm,
  VPACKSSDWYrr,
  VPACKSSDWZ128rm,
  VPACKSSDWZ128rmb,
  VPACKSSDWZ128rmbk,
  VPACKSSDWZ128rmbkz,
  VPACKSSDWZ128rmk,
  VPACKSSDWZ128rmkz,
  VPACKSSDWZ128rr,
  VPACKSSDWZ128rrk,
  VPACKSSDWZ128rrkz,
  VPACKSSDWZ256rm,
  VPACKSSDWZ256rmb,
  VPACKSSDWZ256rmbk,
  VPACKSSDWZ256rmbkz,
  VPACKSSDWZ256rmk,
  VPACKSSDWZ256rmkz,
  VPACKSSDWZ256rr,
  VPACKSSDWZ256rrk,
  VPACKSSDWZ256rrkz,
  VPACKSSDWZrm,
  VPACKSSDWZrmb,
  VPACKSSDWZrmbk,
  VPACKSSDWZrmbkz,
  VPACKSSDWZrmk,
  VPACKSSDWZrmkz,
  VPACKSSDWZrr,
  VPACKSSDWZrrk,
  VPACKSSDWZrrkz,
  VPACKSSDWrm,
  VPACKSSDWrr,
  VPACKSSWBYrm,
  VPACKSSWBYrr,
  VPACKSSWBZ128rm,
  VPACKSSWBZ128rmk,
  VPACKSSWBZ128rmkz,
  VPACKSSWBZ128rr,
  VPACKSSWBZ128rrk,
  VPACKSSWBZ128rrkz,
  VPACKSSWBZ256rm,
  VPACKSSWBZ256rmk,
  VPACKSSWBZ256rmkz,
  VPACKSSWBZ256rr,
  VPACKSSWBZ256rrk,
  VPACKSSWBZ256rrkz,
  VPACKSSWBZrm,
  VPACKSSWBZrmk,
  VPACKSSWBZrmkz,
  VPACKSSWBZrr,
  VPACKSSWBZrrk,
  VPACKSSWBZrrkz,
  VPACKSSWBrm,
  VPACKSSWBrr,
  VPACKUSDWYrm,
  VPACKUSDWYrr,
  VPACKUSDWZ128rm,
  VPACKUSDWZ128rmb,
  VPACKUSDWZ128rmbk,
  VPACKUSDWZ128rmbkz,
  VPACKUSDWZ128rmk,
  VPACKUSDWZ128rmkz,
  VPACKUSDWZ128rr,
  VPACKUSDWZ128rrk,
  VPACKUSDWZ128rrkz,
  VPACKUSDWZ256rm,
  VPACKUSDWZ256rmb,
  VPACKUSDWZ256rmbk,
  VPACKUSDWZ256rmbkz,
  VPACKUSDWZ256rmk,
  VPACKUSDWZ256rmkz,
  VPACKUSDWZ256rr,
  VPACKUSDWZ256rrk,
  VPACKUSDWZ256rrkz,
  VPACKUSDWZrm,
  VPACKUSDWZrmb,
  VPACKUSDWZrmbk,
  VPACKUSDWZrmbkz,
  VPACKUSDWZrmk,
  VPACKUSDWZrmkz,
  VPACKUSDWZrr,
  VPACKUSDWZrrk,
  VPACKUSDWZrrkz,
  VPACKUSDWrm,
  VPACKUSDWrr,
  VPACKUSWBYrm,
  VPACKUSWBYrr,
  VPACKUSWBZ128rm,
  VPACKUSWBZ128rmk,
  VPACKUSWBZ128rmkz,
  VPACKUSWBZ128rr,
  VPACKUSWBZ128rrk,
  VPACKUSWBZ128rrkz,
  VPACKUSWBZ256rm,
  VPACKUSWBZ256rmk,
  VPACKUSWBZ256rmkz,
  VPACKUSWBZ256rr,
  VPACKUSWBZ256rrk,
  VPACKUSWBZ256rrkz,
  VPACKUSWBZrm,
  VPACKUSWBZrmk,
  VPACKUSWBZrmkz,
  VPACKUSWBZrr,
  VPACKUSWBZrrk,
  VPACKUSWBZrrkz,
  VPACKUSWBrm,
  VPACKUSWBrr,
  VPADDBYrm,
  VPADDBYrr,
  VPADDBZ128rm,
  VPADDBZ128rmk,
  VPADDBZ128rmkz,
  VPADDBZ128rr,
  VPADDBZ128rrk,
  VPADDBZ128rrkz,
  VPADDBZ256rm,
  VPADDBZ256rmk,
  VPADDBZ256rmkz,
  VPADDBZ256rr,
  VPADDBZ256rrk,
  VPADDBZ256rrkz,
  VPADDBZrm,
  VPADDBZrmk,
  VPADDBZrmkz,
  VPADDBZrr,
  VPADDBZrrk,
  VPADDBZrrkz,
  VPADDBrm,
  VPADDBrr,
  VPADDDYrm,
  VPADDDYrr,
  VPADDDZ128rm,
  VPADDDZ128rmb,
  VPADDDZ128rmbk,
  VPADDDZ128rmbkz,
  VPADDDZ128rmk,
  VPADDDZ128rmkz,
  VPADDDZ128rr,
  VPADDDZ128rrk,
  VPADDDZ128rrkz,
  VPADDDZ256rm,
  VPADDDZ256rmb,
  VPADDDZ256rmbk,
  VPADDDZ256rmbkz,
  VPADDDZ256rmk,
  VPADDDZ256rmkz,
  VPADDDZ256rr,
  VPADDDZ256rrk,
  VPADDDZ256rrkz,
  VPADDDZrm,
  VPADDDZrmb,
  VPADDDZrmbk,
  VPADDDZrmbkz,
  VPADDDZrmk,
  VPADDDZrmkz,
  VPADDDZrr,
  VPADDDZrrk,
  VPADDDZrrkz,
  VPADDDrm,
  VPADDDrr,
  VPADDQYrm,
  VPADDQYrr,
  VPADDQZ128rm,
  VPADDQZ128rmb,
  VPADDQZ128rmbk,
  VPADDQZ128rmbkz,
  VPADDQZ128rmk,
  VPADDQZ128rmkz,
  VPADDQZ128rr,
  VPADDQZ128rrk,
  VPADDQZ128rrkz,
  VPADDQZ256rm,
  VPADDQZ256rmb,
  VPADDQZ256rmbk,
  VPADDQZ256rmbkz,
  VPADDQZ256rmk,
  VPADDQZ256rmkz,
  VPADDQZ256rr,
  VPADDQZ256rrk,
  VPADDQZ256rrkz,
  VPADDQZrm,
  VPADDQZrmb,
  VPADDQZrmbk,
  VPADDQZrmbkz,
  VPADDQZrmk,
  VPADDQZrmkz,
  VPADDQZrr,
  VPADDQZrrk,
  VPADDQZrrkz,
  VPADDQrm,
  VPADDQrr,
  VPADDSBYrm,
  VPADDSBYrr,
  VPADDSBZ128rm,
  VPADDSBZ128rmk,
  VPADDSBZ128rmkz,
  VPADDSBZ128rr,
  VPADDSBZ128rrk,
  VPADDSBZ128rrkz,
  VPADDSBZ256rm,
  VPADDSBZ256rmk,
  VPADDSBZ256rmkz,
  VPADDSBZ256rr,
  VPADDSBZ256rrk,
  VPADDSBZ256rrkz,
  VPADDSBZrm,
  VPADDSBZrmk,
  VPADDSBZrmkz,
  VPADDSBZrr,
  VPADDSBZrrk,
  VPADDSBZrrkz,
  VPADDSBrm,
  VPADDSBrr,
  VPADDSWYrm,
  VPADDSWYrr,
  VPADDSWZ128rm,
  VPADDSWZ128rmk,
  VPADDSWZ128rmkz,
  VPADDSWZ128rr,
  VPADDSWZ128rrk,
  VPADDSWZ128rrkz,
  VPADDSWZ256rm,
  VPADDSWZ256rmk,
  VPADDSWZ256rmkz,
  VPADDSWZ256rr,
  VPADDSWZ256rrk,
  VPADDSWZ256rrkz,
  VPADDSWZrm,
  VPADDSWZrmk,
  VPADDSWZrmkz,
  VPADDSWZrr,
  VPADDSWZrrk,
  VPADDSWZrrkz,
  VPADDSWrm,
  VPADDSWrr,
  VPADDUSBYrm,
  VPADDUSBYrr,
  VPADDUSBZ128rm,
  VPADDUSBZ128rmk,
  VPADDUSBZ128rmkz,
  VPADDUSBZ128rr,
  VPADDUSBZ128rrk,
  VPADDUSBZ128rrkz,
  VPADDUSBZ256rm,
  VPADDUSBZ256rmk,
  VPADDUSBZ256rmkz,
  VPADDUSBZ256rr,
  VPADDUSBZ256rrk,
  VPADDUSBZ256rrkz,
  VPADDUSBZrm,
  VPADDUSBZrmk,
  VPADDUSBZrmkz,
  VPADDUSBZrr,
  VPADDUSBZrrk,
  VPADDUSBZrrkz,
  VPADDUSBrm,
  VPADDUSBrr,
  VPADDUSWYrm,
  VPADDUSWYrr,
  VPADDUSWZ128rm,
  VPADDUSWZ128rmk,
  VPADDUSWZ128rmkz,
  VPADDUSWZ128rr,
  VPADDUSWZ128rrk,
  VPADDUSWZ128rrkz,
  VPADDUSWZ256rm,
  VPADDUSWZ256rmk,
  VPADDUSWZ256rmkz,
  VPADDUSWZ256rr,
  VPADDUSWZ256rrk,
  VPADDUSWZ256rrkz,
  VPADDUSWZrm,
  VPADDUSWZrmk,
  VPADDUSWZrmkz,
  VPADDUSWZrr,
  VPADDUSWZrrk,
  VPADDUSWZrrkz,
  VPADDUSWrm,
  VPADDUSWrr,
  VPADDWYrm,
  VPADDWYrr,
  VPADDWZ128rm,
  VPADDWZ128rmk,
  VPADDWZ128rmkz,
  VPADDWZ128rr,
  VPADDWZ128rrk,
  VPADDWZ128rrkz,
  VPADDWZ256rm,
  VPADDWZ256rmk,
  VPADDWZ256rmkz,
  VPADDWZ256rr,
  VPADDWZ256rrk,
  VPADDWZ256rrkz,
  VPADDWZrm,
  VPADDWZrmk,
  VPADDWZrmkz,
  VPADDWZrr,
  VPADDWZrrk,
  VPADDWZrrkz,
  VPADDWrm,
  VPADDWrr,
  VPALIGNRYrmi,
  VPALIGNRYrri,
  VPALIGNRZ128rmi,
  VPALIGNRZ128rmik,
  VPALIGNRZ128rmikz,
  VPALIGNRZ128rri,
  VPALIGNRZ128rrik,
  VPALIGNRZ128rrikz,
  VPALIGNRZ256rmi,
  VPALIGNRZ256rmik,
  VPALIGNRZ256rmikz,
  VPALIGNRZ256rri,
  VPALIGNRZ256rrik,
  VPALIGNRZ256rrikz,
  VPALIGNRZrmi,
  VPALIGNRZrmik,
  VPALIGNRZrmikz,
  VPALIGNRZrri,
  VPALIGNRZrrik,
  VPALIGNRZrrikz,
  VPALIGNRrmi,
  VPALIGNRrri,
  VPANDDZ128rm,
  VPANDDZ128rmb,
  VPANDDZ128rmbk,
  VPANDDZ128rmbkz,
  VPANDDZ128rmk,
  VPANDDZ128rmkz,
  VPANDDZ128rr,
  VPANDDZ128rrk,
  VPANDDZ128rrkz,
  VPANDDZ256rm,
  VPANDDZ256rmb,
  VPANDDZ256rmbk,
  VPANDDZ256rmbkz,
  VPANDDZ256rmk,
  VPANDDZ256rmkz,
  VPANDDZ256rr,
  VPANDDZ256rrk,
  VPANDDZ256rrkz,
  VPANDDZrm,
  VPANDDZrmb,
  VPANDDZrmbk,
  VPANDDZrmbkz,
  VPANDDZrmk,
  VPANDDZrmkz,
  VPANDDZrr,
  VPANDDZrrk,
  VPANDDZrrkz,
  VPANDNDZ128rm,
  VPANDNDZ128rmb,
  VPANDNDZ128rmbk,
  VPANDNDZ128rmbkz,
  VPANDNDZ128rmk,
  VPANDNDZ128rmkz,
  VPANDNDZ128rr,
  VPANDNDZ128rrk,
  VPANDNDZ128rrkz,
  VPANDNDZ256rm,
  VPANDNDZ256rmb,
  VPANDNDZ256rmbk,
  VPANDNDZ256rmbkz,
  VPANDNDZ256rmk,
  VPANDNDZ256rmkz,
  VPANDNDZ256rr,
  VPANDNDZ256rrk,
  VPANDNDZ256rrkz,
  VPANDNDZrm,
  VPANDNDZrmb,
  VPANDNDZrmbk,
  VPANDNDZrmbkz,
  VPANDNDZrmk,
  VPANDNDZrmkz,
  VPANDNDZrr,
  VPANDNDZrrk,
  VPANDNDZrrkz,
  VPANDNQZ128rm,
  VPANDNQZ128rmb,
  VPANDNQZ128rmbk,
  VPANDNQZ128rmbkz,
  VPANDNQZ128rmk,
  VPANDNQZ128rmkz,
  VPANDNQZ128rr,
  VPANDNQZ128rrk,
  VPANDNQZ128rrkz,
  VPANDNQZ256rm,
  VPANDNQZ256rmb,
  VPANDNQZ256rmbk,
  VPANDNQZ256rmbkz,
  VPANDNQZ256rmk,
  VPANDNQZ256rmkz,
  VPANDNQZ256rr,
  VPANDNQZ256rrk,
  VPANDNQZ256rrkz,
  VPANDNQZrm,
  VPANDNQZrmb,
  VPANDNQZrmbk,
  VPANDNQZrmbkz,
  VPANDNQZrmk,
  VPANDNQZrmkz,
  VPANDNQZrr,
  VPANDNQZrrk,
  VPANDNQZrrkz,
  VPANDNYrm,
  VPANDNYrr,
  VPANDNrm,
  VPANDNrr,
  VPANDQZ128rm,
  VPANDQZ128rmb,
  VPANDQZ128rmbk,
  VPANDQZ128rmbkz,
  VPANDQZ128rmk,
  VPANDQZ128rmkz,
  VPANDQZ128rr,
  VPANDQZ128rrk,
  VPANDQZ128rrkz,
  VPANDQZ256rm,
  VPANDQZ256rmb,
  VPANDQZ256rmbk,
  VPANDQZ256rmbkz,
  VPANDQZ256rmk,
  VPANDQZ256rmkz,
  VPANDQZ256rr,
  VPANDQZ256rrk,
  VPANDQZ256rrkz,
  VPANDQZrm,
  VPANDQZrmb,
  VPANDQZrmbk,
  VPANDQZrmbkz,
  VPANDQZrmk,
  VPANDQZrmkz,
  VPANDQZrr,
  VPANDQZrrk,
  VPANDQZrrkz,
  VPANDYrm,
  VPANDYrr,
  VPANDrm,
  VPANDrr,
  VPAVGBYrm,
  VPAVGBYrr,
  VPAVGBZ128rm,
  VPAVGBZ128rmk,
  VPAVGBZ128rmkz,
  VPAVGBZ128rr,
  VPAVGBZ128rrk,
  VPAVGBZ128rrkz,
  VPAVGBZ256rm,
  VPAVGBZ256rmk,
  VPAVGBZ256rmkz,
  VPAVGBZ256rr,
  VPAVGBZ256rrk,
  VPAVGBZ256rrkz,
  VPAVGBZrm,
  VPAVGBZrmk,
  VPAVGBZrmkz,
  VPAVGBZrr,
  VPAVGBZrrk,
  VPAVGBZrrkz,
  VPAVGBrm,
  VPAVGBrr,
  VPAVGWYrm,
  VPAVGWYrr,
  VPAVGWZ128rm,
  VPAVGWZ128rmk,
  VPAVGWZ128rmkz,
  VPAVGWZ128rr,
  VPAVGWZ128rrk,
  VPAVGWZ128rrkz,
  VPAVGWZ256rm,
  VPAVGWZ256rmk,
  VPAVGWZ256rmkz,
  VPAVGWZ256rr,
  VPAVGWZ256rrk,
  VPAVGWZ256rrkz,
  VPAVGWZrm,
  VPAVGWZrmk,
  VPAVGWZrmkz,
  VPAVGWZrr,
  VPAVGWZrrk,
  VPAVGWZrrkz,
  VPAVGWrm,
  VPAVGWrr,
  VPBLENDDYrmi,
  VPBLENDDYrri,
  VPBLENDDrmi,
  VPBLENDDrri,
  VPBLENDMBZ128rm,
  VPBLENDMBZ128rmk,
  VPBLENDMBZ128rmkz,
  VPBLENDMBZ128rr,
  VPBLENDMBZ128rrk,
  VPBLENDMBZ128rrkz,
  VPBLENDMBZ256rm,
  VPBLENDMBZ256rmk,
  VPBLENDMBZ256rmkz,
  VPBLENDMBZ256rr,
  VPBLENDMBZ256rrk,
  VPBLENDMBZ256rrkz,
  VPBLENDMBZrm,
  VPBLENDMBZrmk,
  VPBLENDMBZrmkz,
  VPBLENDMBZrr,
  VPBLENDMBZrrk,
  VPBLENDMBZrrkz,
  VPBLENDMDZ128rm,
  VPBLENDMDZ128rmb,
  VPBLENDMDZ128rmbk,
  VPBLENDMDZ128rmbkz,
  VPBLENDMDZ128rmk,
  VPBLENDMDZ128rmkz,
  VPBLENDMDZ128rr,
  VPBLENDMDZ128rrk,
  VPBLENDMDZ128rrkz,
  VPBLENDMDZ256rm,
  VPBLENDMDZ256rmb,
  VPBLENDMDZ256rmbk,
  VPBLENDMDZ256rmbkz,
  VPBLENDMDZ256rmk,
  VPBLENDMDZ256rmkz,
  VPBLENDMDZ256rr,
  VPBLENDMDZ256rrk,
  VPBLENDMDZ256rrkz,
  VPBLENDMDZrm,
  VPBLENDMDZrmb,
  VPBLENDMDZrmbk,
  VPBLENDMDZrmbkz,
  VPBLENDMDZrmk,
  VPBLENDMDZrmkz,
  VPBLENDMDZrr,
  VPBLENDMDZrrk,
  VPBLENDMDZrrkz,
  VPBLENDMQZ128rm,
  VPBLENDMQZ128rmb,
  VPBLENDMQZ128rmbk,
  VPBLENDMQZ128rmbkz,
  VPBLENDMQZ128rmk,
  VPBLENDMQZ128rmkz,
  VPBLENDMQZ128rr,
  VPBLENDMQZ128rrk,
  VPBLENDMQZ128rrkz,
  VPBLENDMQZ256rm,
  VPBLENDMQZ256rmb,
  VPBLENDMQZ256rmbk,
  VPBLENDMQZ256rmbkz,
  VPBLENDMQZ256rmk,
  VPBLENDMQZ256rmkz,
  VPBLENDMQZ256rr,
  VPBLENDMQZ256rrk,
  VPBLENDMQZ256rrkz,
  VPBLENDMQZrm,
  VPBLENDMQZrmb,
  VPBLENDMQZrmbk,
  VPBLENDMQZrmbkz,
  VPBLENDMQZrmk,
  VPBLENDMQZrmkz,
  VPBLENDMQZrr,
  VPBLENDMQZrrk,
  VPBLENDMQZrrkz,
  VPBLENDMWZ128rm,
  VPBLENDMWZ128rmk,
  VPBLENDMWZ128rmkz,
  VPBLENDMWZ128rr,
  VPBLENDMWZ128rrk,
  VPBLENDMWZ128rrkz,
  VPBLENDMWZ256rm,
  VPBLENDMWZ256rmk,
  VPBLENDMWZ256rmkz,
  VPBLENDMWZ256rr,
  VPBLENDMWZ256rrk,
  VPBLENDMWZ256rrkz,
  VPBLENDMWZrm,
  VPBLENDMWZrmk,
  VPBLENDMWZrmkz,
  VPBLENDMWZrr,
  VPBLENDMWZrrk,
  VPBLENDMWZrrkz,
  VPBLENDVBYrmr,
  VPBLENDVBYrrr,
  VPBLENDVBrmr,
  VPBLENDVBrrr,
  VPBLENDWYrmi,
  VPBLENDWYrri,
  VPBLENDWrmi,
  VPBLENDWrri,
  VPBROADCASTBYrm,
  VPBROADCASTBYrr,
  VPBROADCASTBZ128rm,
  VPBROADCASTBZ128rmk,
  VPBROADCASTBZ128rmkz,
  VPBROADCASTBZ128rr,
  VPBROADCASTBZ128rrk,
  VPBROADCASTBZ128rrkz,
  VPBROADCASTBZ256rm,
  VPBROADCASTBZ256rmk,
  VPBROADCASTBZ256rmkz,
  VPBROADCASTBZ256rr,
  VPBROADCASTBZ256rrk,
  VPBROADCASTBZ256rrkz,
  VPBROADCASTBZrm,
  VPBROADCASTBZrmk,
  VPBROADCASTBZrmkz,
  VPBROADCASTBZrr,
  VPBROADCASTBZrrk,
  VPBROADCASTBZrrkz,
  VPBROADCASTBrZ128rr,
  VPBROADCASTBrZ128rrk,
  VPBROADCASTBrZ128rrkz,
  VPBROADCASTBrZ256rr,
  VPBROADCASTBrZ256rrk,
  VPBROADCASTBrZ256rrkz,
  VPBROADCASTBrZrr,
  VPBROADCASTBrZrrk,
  VPBROADCASTBrZrrkz,
  VPBROADCASTBrm,
  VPBROADCASTBrr,
  VPBROADCASTDYrm,
  VPBROADCASTDYrr,
  VPBROADCASTDZ128rm,
  VPBROADCASTDZ128rmk,
  VPBROADCASTDZ128rmkz,
  VPBROADCASTDZ128rr,
  VPBROADCASTDZ128rrk,
  VPBROADCASTDZ128rrkz,
  VPBROADCASTDZ256rm,
  VPBROADCASTDZ256rmk,
  VPBROADCASTDZ256rmkz,
  VPBROADCASTDZ256rr,
  VPBROADCASTDZ256rrk,
  VPBROADCASTDZ256rrkz,
  VPBROADCASTDZrm,
  VPBROADCASTDZrmk,
  VPBROADCASTDZrmkz,
  VPBROADCASTDZrr,
  VPBROADCASTDZrrk,
  VPBROADCASTDZrrkz,
  VPBROADCASTDrZ128rr,
  VPBROADCASTDrZ128rrk,
  VPBROADCASTDrZ128rrkz,
  VPBROADCASTDrZ256rr,
  VPBROADCASTDrZ256rrk,
  VPBROADCASTDrZ256rrkz,
  VPBROADCASTDrZrr,
  VPBROADCASTDrZrrk,
  VPBROADCASTDrZrrkz,
  VPBROADCASTDrm,
  VPBROADCASTDrr,
  VPBROADCASTMB2QZ128rr,
  VPBROADCASTMB2QZ256rr,
  VPBROADCASTMB2QZrr,
  VPBROADCASTMW2DZ128rr,
  VPBROADCASTMW2DZ256rr,
  VPBROADCASTMW2DZrr,
  VPBROADCASTQYrm,
  VPBROADCASTQYrr,
  VPBROADCASTQZ128rm,
  VPBROADCASTQZ128rmk,
  VPBROADCASTQZ128rmkz,
  VPBROADCASTQZ128rr,
  VPBROADCASTQZ128rrk,
  VPBROADCASTQZ128rrkz,
  VPBROADCASTQZ256rm,
  VPBROADCASTQZ256rmk,
  VPBROADCASTQZ256rmkz,
  VPBROADCASTQZ256rr,
  VPBROADCASTQZ256rrk,
  VPBROADCASTQZ256rrkz,
  VPBROADCASTQZrm,
  VPBROADCASTQZrmk,
  VPBROADCASTQZrmkz,
  VPBROADCASTQZrr,
  VPBROADCASTQZrrk,
  VPBROADCASTQZrrkz,
  VPBROADCASTQrZ128rr,
  VPBROADCASTQrZ128rrk,
  VPBROADCASTQrZ128rrkz,
  VPBROADCASTQrZ256rr,
  VPBROADCASTQrZ256rrk,
  VPBROADCASTQrZ256rrkz,
  VPBROADCASTQrZrr,
  VPBROADCASTQrZrrk,
  VPBROADCASTQrZrrkz,
  VPBROADCASTQrm,
  VPBROADCASTQrr,
  VPBROADCASTWYrm,
  VPBROADCASTWYrr,
  VPBROADCASTWZ128rm,
  VPBROADCASTWZ128rmk,
  VPBROADCASTWZ128rmkz,
  VPBROADCASTWZ128rr,
  VPBROADCASTWZ128rrk,
  VPBROADCASTWZ128rrkz,
  VPBROADCASTWZ256rm,
  VPBROADCASTWZ256rmk,
  VPBROADCASTWZ256rmkz,
  VPBROADCASTWZ256rr,
  VPBROADCASTWZ256rrk,
  VPBROADCASTWZ256rrkz,
  VPBROADCASTWZrm,
  VPBROADCASTWZrmk,
  VPBROADCASTWZrmkz,
  VPBROADCASTWZrr,
  VPBROADCASTWZrrk,
  VPBROADCASTWZrrkz,
  VPBROADCASTWrZ128rr,
  VPBROADCASTWrZ128rrk,
  VPBROADCASTWrZ128rrkz,
  VPBROADCASTWrZ256rr,
  VPBROADCASTWrZ256rrk,
  VPBROADCASTWrZ256rrkz,
  VPBROADCASTWrZrr,
  VPBROADCASTWrZrrk,
  VPBROADCASTWrZrrkz,
  VPBROADCASTWrm,
  VPBROADCASTWrr,
  VPCLMULQDQYrmi,
  VPCLMULQDQYrri,
  VPCLMULQDQZ128rmi,
  VPCLMULQDQZ128rri,
  VPCLMULQDQZ256rmi,
  VPCLMULQDQZ256rri,
  VPCLMULQDQZrmi,
  VPCLMULQDQZrri,
  VPCLMULQDQrmi,
  VPCLMULQDQrri,
  VPCMOVYrmr,
  VPCMOVYrrm,
  VPCMOVYrrr,
  VPCMOVYrrr_REV,
  VPCMOVrmr,
  VPCMOVrrm,
  VPCMOVrrr,
  VPCMOVrrr_REV,
  VPCMPBZ128rmi,
  VPCMPBZ128rmik,
  VPCMPBZ128rri,
  VPCMPBZ128rrik,
  VPCMPBZ256rmi,
  VPCMPBZ256rmik,
  VPCMPBZ256rri,
  VPCMPBZ256rrik,
  VPCMPBZrmi,
  VPCMPBZrmik,
  VPCMPBZrri,
  VPCMPBZrrik,
  VPCMPDZ128rmi,
  VPCMPDZ128rmib,
  VPCMPDZ128rmibk,
  VPCMPDZ128rmik,
  VPCMPDZ128rri,
  VPCMPDZ128rrik,
  VPCMPDZ256rmi,
  VPCMPDZ256rmib,
  VPCMPDZ256rmibk,
  VPCMPDZ256rmik,
  VPCMPDZ256rri,
  VPCMPDZ256rrik,
  VPCMPDZrmi,
  VPCMPDZrmib,
  VPCMPDZrmibk,
  VPCMPDZrmik,
  VPCMPDZrri,
  VPCMPDZrrik,
  VPCMPEQBYrm,
  VPCMPEQBYrr,
  VPCMPEQBZ128rm,
  VPCMPEQBZ128rmk,
  VPCMPEQBZ128rr,
  VPCMPEQBZ128rrk,
  VPCMPEQBZ256rm,
  VPCMPEQBZ256rmk,
  VPCMPEQBZ256rr,
  VPCMPEQBZ256rrk,
  VPCMPEQBZrm,
  VPCMPEQBZrmk,
  VPCMPEQBZrr,
  VPCMPEQBZrrk,
  VPCMPEQBrm,
  VPCMPEQBrr,
  VPCMPEQDYrm,
  VPCMPEQDYrr,
  VPCMPEQDZ128rm,
  VPCMPEQDZ128rmb,
  VPCMPEQDZ128rmbk,
  VPCMPEQDZ128rmk,
  VPCMPEQDZ128rr,
  VPCMPEQDZ128rrk,
  VPCMPEQDZ256rm,
  VPCMPEQDZ256rmb,
  VPCMPEQDZ256rmbk,
  VPCMPEQDZ256rmk,
  VPCMPEQDZ256rr,
  VPCMPEQDZ256rrk,
  VPCMPEQDZrm,
  VPCMPEQDZrmb,
  VPCMPEQDZrmbk,
  VPCMPEQDZrmk,
  VPCMPEQDZrr,
  VPCMPEQDZrrk,
  VPCMPEQDrm,
  VPCMPEQDrr,
  VPCMPEQQYrm,
  VPCMPEQQYrr,
  VPCMPEQQZ128rm,
  VPCMPEQQZ128rmb,
  VPCMPEQQZ128rmbk,
  VPCMPEQQZ128rmk,
  VPCMPEQQZ128rr,
  VPCMPEQQZ128rrk,
  VPCMPEQQZ256rm,
  VPCMPEQQZ256rmb,
  VPCMPEQQZ256rmbk,
  VPCMPEQQZ256rmk,
  VPCMPEQQZ256rr,
  VPCMPEQQZ256rrk,
  VPCMPEQQZrm,
  VPCMPEQQZrmb,
  VPCMPEQQZrmbk,
  VPCMPEQQZrmk,
  VPCMPEQQZrr,
  VPCMPEQQZrrk,
  VPCMPEQQrm,
  VPCMPEQQrr,
  VPCMPEQWYrm,
  VPCMPEQWYrr,
  VPCMPEQWZ128rm,
  VPCMPEQWZ128rmk,
  VPCMPEQWZ128rr,
  VPCMPEQWZ128rrk,
  VPCMPEQWZ256rm,
  VPCMPEQWZ256rmk,
  VPCMPEQWZ256rr,
  VPCMPEQWZ256rrk,
  VPCMPEQWZrm,
  VPCMPEQWZrmk,
  VPCMPEQWZrr,
  VPCMPEQWZrrk,
  VPCMPEQWrm,
  VPCMPEQWrr,
  VPCMPESTRIrmi,
  VPCMPESTRIrri,
  VPCMPESTRMrmi,
  VPCMPESTRMrri,
  VPCMPGTBYrm,
  VPCMPGTBYrr,
  VPCMPGTBZ128rm,
  VPCMPGTBZ128rmk,
  VPCMPGTBZ128rr,
  VPCMPGTBZ128rrk,
  VPCMPGTBZ256rm,
  VPCMPGTBZ256rmk,
  VPCMPGTBZ256rr,
  VPCMPGTBZ256rrk,
  VPCMPGTBZrm,
  VPCMPGTBZrmk,
  VPCMPGTBZrr,
  VPCMPGTBZrrk,
  VPCMPGTBrm,
  VPCMPGTBrr,
  VPCMPGTDYrm,
  VPCMPGTDYrr,
  VPCMPGTDZ128rm,
  VPCMPGTDZ128rmb,
  VPCMPGTDZ128rmbk,
  VPCMPGTDZ128rmk,
  VPCMPGTDZ128rr,
  VPCMPGTDZ128rrk,
  VPCMPGTDZ256rm,
  VPCMPGTDZ256rmb,
  VPCMPGTDZ256rmbk,
  VPCMPGTDZ256rmk,
  VPCMPGTDZ256rr,
  VPCMPGTDZ256rrk,
  VPCMPGTDZrm,
  VPCMPGTDZrmb,
  VPCMPGTDZrmbk,
  VPCMPGTDZrmk,
  VPCMPGTDZrr,
  VPCMPGTDZrrk,
  VPCMPGTDrm,
  VPCMPGTDrr,
  VPCMPGTQYrm,
  VPCMPGTQYrr,
  VPCMPGTQZ128rm,
  VPCMPGTQZ128rmb,
  VPCMPGTQZ128rmbk,
  VPCMPGTQZ128rmk,
  VPCMPGTQZ128rr,
  VPCMPGTQZ128rrk,
  VPCMPGTQZ256rm,
  VPCMPGTQZ256rmb,
  VPCMPGTQZ256rmbk,
  VPCMPGTQZ256rmk,
  VPCMPGTQZ256rr,
  VPCMPGTQZ256rrk,
  VPCMPGTQZrm,
  VPCMPGTQZrmb,
  VPCMPGTQZrmbk,
  VPCMPGTQZrmk,
  VPCMPGTQZrr,
  VPCMPGTQZrrk,
  VPCMPGTQrm,
  VPCMPGTQrr,
  VPCMPGTWYrm,
  VPCMPGTWYrr,
  VPCMPGTWZ128rm,
  VPCMPGTWZ128rmk,
  VPCMPGTWZ128rr,
  VPCMPGTWZ128rrk,
  VPCMPGTWZ256rm,
  VPCMPGTWZ256rmk,
  VPCMPGTWZ256rr,
  VPCMPGTWZ256rrk,
  VPCMPGTWZrm,
  VPCMPGTWZrmk,
  VPCMPGTWZrr,
  VPCMPGTWZrrk,
  VPCMPGTWrm,
  VPCMPGTWrr,
  VPCMPISTRIrmi,
  VPCMPISTRIrri,
  VPCMPISTRMrmi,
  VPCMPISTRMrri,
  VPCMPQZ128rmi,
  VPCMPQZ128rmib,
  VPCMPQZ128rmibk,
  VPCMPQZ128rmik,
  VPCMPQZ128rri,
  VPCMPQZ128rrik,
  VPCMPQZ256rmi,
  VPCMPQZ256rmib,
  VPCMPQZ256rmibk,
  VPCMPQZ256rmik,
  VPCMPQZ256rri,
  VPCMPQZ256rrik,
  VPCMPQZrmi,
  VPCMPQZrmib,
  VPCMPQZrmibk,
  VPCMPQZrmik,
  VPCMPQZrri,
  VPCMPQZrrik,
  VPCMPUBZ128rmi,
  VPCMPUBZ128rmik,
  VPCMPUBZ128rri,
  VPCMPUBZ128rrik,
  VPCMPUBZ256rmi,
  VPCMPUBZ256rmik,
  VPCMPUBZ256rri,
  VPCMPUBZ256rrik,
  VPCMPUBZrmi,
  VPCMPUBZrmik,
  VPCMPUBZrri,
  VPCMPUBZrrik,
  VPCMPUDZ128rmi,
  VPCMPUDZ128rmib,
  VPCMPUDZ128rmibk,
  VPCMPUDZ128rmik,
  VPCMPUDZ128rri,
  VPCMPUDZ128rrik,
  VPCMPUDZ256rmi,
  VPCMPUDZ256rmib,
  VPCMPUDZ256rmibk,
  VPCMPUDZ256rmik,
  VPCMPUDZ256rri,
  VPCMPUDZ256rrik,
  VPCMPUDZrmi,
  VPCMPUDZrmib,
  VPCMPUDZrmibk,
  VPCMPUDZrmik,
  VPCMPUDZrri,
  VPCMPUDZrrik,
  VPCMPUQZ128rmi,
  VPCMPUQZ128rmib,
  VPCMPUQZ128rmibk,
  VPCMPUQZ128rmik,
  VPCMPUQZ128rri,
  VPCMPUQZ128rrik,
  VPCMPUQZ256rmi,
  VPCMPUQZ256rmib,
  VPCMPUQZ256rmibk,
  VPCMPUQZ256rmik,
  VPCMPUQZ256rri,
  VPCMPUQZ256rrik,
  VPCMPUQZrmi,
  VPCMPUQZrmib,
  VPCMPUQZrmibk,
  VPCMPUQZrmik,
  VPCMPUQZrri,
  VPCMPUQZrrik,
  VPCMPUWZ128rmi,
  VPCMPUWZ128rmik,
  VPCMPUWZ128rri,
  VPCMPUWZ128rrik,
  VPCMPUWZ256rmi,
  VPCMPUWZ256rmik,
  VPCMPUWZ256rri,
  VPCMPUWZ256rrik,
  VPCMPUWZrmi,
  VPCMPUWZrmik,
  VPCMPUWZrri,
  VPCMPUWZrrik,
  VPCMPWZ128rmi,
  VPCMPWZ128rmik,
  VPCMPWZ128rri,
  VPCMPWZ128rrik,
  VPCMPWZ256rmi,
  VPCMPWZ256rmik,
  VPCMPWZ256rri,
  VPCMPWZ256rrik,
  VPCMPWZrmi,
  VPCMPWZrmik,
  VPCMPWZrri,
  VPCMPWZrrik,
  VPCOMBmi,
  VPCOMBri,
  VPCOMDmi,
  VPCOMDri,
  VPCOMPRESSBZ128mr,
  VPCOMPRESSBZ128mrk,
  VPCOMPRESSBZ128rr,
  VPCOMPRESSBZ128rrk,
  VPCOMPRESSBZ128rrkz,
  VPCOMPRESSBZ256mr,
  VPCOMPRESSBZ256mrk,
  VPCOMPRESSBZ256rr,
  VPCOMPRESSBZ256rrk,
  VPCOMPRESSBZ256rrkz,
  VPCOMPRESSBZmr,
  VPCOMPRESSBZmrk,
  VPCOMPRESSBZrr,
  VPCOMPRESSBZrrk,
  VPCOMPRESSBZrrkz,
  VPCOMPRESSDZ128mr,
  VPCOMPRESSDZ128mrk,
  VPCOMPRESSDZ128rr,
  VPCOMPRESSDZ128rrk,
  VPCOMPRESSDZ128rrkz,
  VPCOMPRESSDZ256mr,
  VPCOMPRESSDZ256mrk,
  VPCOMPRESSDZ256rr,
  VPCOMPRESSDZ256rrk,
  VPCOMPRESSDZ256rrkz,
  VPCOMPRESSDZmr,
  VPCOMPRESSDZmrk,
  VPCOMPRESSDZrr,
  VPCOMPRESSDZrrk,
  VPCOMPRESSDZrrkz,
  VPCOMPRESSQZ128mr,
  VPCOMPRESSQZ128mrk,
  VPCOMPRESSQZ128rr,
  VPCOMPRESSQZ128rrk,
  VPCOMPRESSQZ128rrkz,
  VPCOMPRESSQZ256mr,
  VPCOMPRESSQZ256mrk,
  VPCOMPRESSQZ256rr,
  VPCOMPRESSQZ256rrk,
  VPCOMPRESSQZ256rrkz,
  VPCOMPRESSQZmr,
  VPCOMPRESSQZmrk,
  VPCOMPRESSQZrr,
  VPCOMPRESSQZrrk,
  VPCOMPRESSQZrrkz,
  VPCOMPRESSWZ128mr,
  VPCOMPRESSWZ128mrk,
  VPCOMPRESSWZ128rr,
  VPCOMPRESSWZ128rrk,
  VPCOMPRESSWZ128rrkz,
  VPCOMPRESSWZ256mr,
  VPCOMPRESSWZ256mrk,
  VPCOMPRESSWZ256rr,
  VPCOMPRESSWZ256rrk,
  VPCOMPRESSWZ256rrkz,
  VPCOMPRESSWZmr,
  VPCOMPRESSWZmrk,
  VPCOMPRESSWZrr,
  VPCOMPRESSWZrrk,
  VPCOMPRESSWZrrkz,
  VPCOMQmi,
  VPCOMQri,
  VPCOMUBmi,
  VPCOMUBri,
  VPCOMUDmi,
  VPCOMUDri,
  VPCOMUQmi,
  VPCOMUQri,
  VPCOMUWmi,
  VPCOMUWri,
  VPCOMWmi,
  VPCOMWri,
  VPCONFLICTDZ128rm,
  VPCONFLICTDZ128rmb,
  VPCONFLICTDZ128rmbk,
  VPCONFLICTDZ128rmbkz,
  VPCONFLICTDZ128rmk,
  VPCONFLICTDZ128rmkz,
  VPCONFLICTDZ128rr,
  VPCONFLICTDZ128rrk,
  VPCONFLICTDZ128rrkz,
  VPCONFLICTDZ256rm,
  VPCONFLICTDZ256rmb,
  VPCONFLICTDZ256rmbk,
  VPCONFLICTDZ256rmbkz,
  VPCONFLICTDZ256rmk,
  VPCONFLICTDZ256rmkz,
  VPCONFLICTDZ256rr,
  VPCONFLICTDZ256rrk,
  VPCONFLICTDZ256rrkz,
  VPCONFLICTDZrm,
  VPCONFLICTDZrmb,
  VPCONFLICTDZrmbk,
  VPCONFLICTDZrmbkz,
  VPCONFLICTDZrmk,
  VPCONFLICTDZrmkz,
  VPCONFLICTDZrr,
  VPCONFLICTDZrrk,
  VPCONFLICTDZrrkz,
  VPCONFLICTQZ128rm,
  VPCONFLICTQZ128rmb,
  VPCONFLICTQZ128rmbk,
  VPCONFLICTQZ128rmbkz,
  VPCONFLICTQZ128rmk,
  VPCONFLICTQZ128rmkz,
  VPCONFLICTQZ128rr,
  VPCONFLICTQZ128rrk,
  VPCONFLICTQZ128rrkz,
  VPCONFLICTQZ256rm,
  VPCONFLICTQZ256rmb,
  VPCONFLICTQZ256rmbk,
  VPCONFLICTQZ256rmbkz,
  VPCONFLICTQZ256rmk,
  VPCONFLICTQZ256rmkz,
  VPCONFLICTQZ256rr,
  VPCONFLICTQZ256rrk,
  VPCONFLICTQZ256rrkz,
  VPCONFLICTQZrm,
  VPCONFLICTQZrmb,
  VPCONFLICTQZrmbk,
  VPCONFLICTQZrmbkz,
  VPCONFLICTQZrmk,
  VPCONFLICTQZrmkz,
  VPCONFLICTQZrr,
  VPCONFLICTQZrrk,
  VPCONFLICTQZrrkz,
  VPDPBSSDSYrm,
  VPDPBSSDSYrr,
  VPDPBSSDSrm,
  VPDPBSSDSrr,
  VPDPBSSDYrm,
  VPDPBSSDYrr,
  VPDPBSSDrm,
  VPDPBSSDrr,
  VPDPBSUDSYrm,
  VPDPBSUDSYrr,
  VPDPBSUDSrm,
  VPDPBSUDSrr,
  VPDPBSUDYrm,
  VPDPBSUDYrr,
  VPDPBSUDrm,
  VPDPBSUDrr,
  VPDPBUSDSYrm,
  VPDPBUSDSYrr,
  VPDPBUSDSZ128m,
  VPDPBUSDSZ128mb,
  VPDPBUSDSZ128mbk,
  VPDPBUSDSZ128mbkz,
  VPDPBUSDSZ128mk,
  VPDPBUSDSZ128mkz,
  VPDPBUSDSZ128r,
  VPDPBUSDSZ128rk,
  VPDPBUSDSZ128rkz,
  VPDPBUSDSZ256m,
  VPDPBUSDSZ256mb,
  VPDPBUSDSZ256mbk,
  VPDPBUSDSZ256mbkz,
  VPDPBUSDSZ256mk,
  VPDPBUSDSZ256mkz,
  VPDPBUSDSZ256r,
  VPDPBUSDSZ256rk,
  VPDPBUSDSZ256rkz,
  VPDPBUSDSZm,
  VPDPBUSDSZmb,
  VPDPBUSDSZmbk,
  VPDPBUSDSZmbkz,
  VPDPBUSDSZmk,
  VPDPBUSDSZmkz,
  VPDPBUSDSZr,
  VPDPBUSDSZrk,
  VPDPBUSDSZrkz,
  VPDPBUSDSrm,
  VPDPBUSDSrr,
  VPDPBUSDYrm,
  VPDPBUSDYrr,
  VPDPBUSDZ128m,
  VPDPBUSDZ128mb,
  VPDPBUSDZ128mbk,
  VPDPBUSDZ128mbkz,
  VPDPBUSDZ128mk,
  VPDPBUSDZ128mkz,
  VPDPBUSDZ128r,
  VPDPBUSDZ128rk,
  VPDPBUSDZ128rkz,
  VPDPBUSDZ256m,
  VPDPBUSDZ256mb,
  VPDPBUSDZ256mbk,
  VPDPBUSDZ256mbkz,
  VPDPBUSDZ256mk,
  VPDPBUSDZ256mkz,
  VPDPBUSDZ256r,
  VPDPBUSDZ256rk,
  VPDPBUSDZ256rkz,
  VPDPBUSDZm,
  VPDPBUSDZmb,
  VPDPBUSDZmbk,
  VPDPBUSDZmbkz,
  VPDPBUSDZmk,
  VPDPBUSDZmkz,
  VPDPBUSDZr,
  VPDPBUSDZrk,
  VPDPBUSDZrkz,
  VPDPBUSDrm,
  VPDPBUSDrr,
  VPDPBUUDSYrm,
  VPDPBUUDSYrr,
  VPDPBUUDSrm,
  VPDPBUUDSrr,
  VPDPBUUDYrm,
  VPDPBUUDYrr,
  VPDPBUUDrm,
  VPDPBUUDrr,
  VPDPWSSDSYrm,
  VPDPWSSDSYrr,
  VPDPWSSDSZ128m,
  VPDPWSSDSZ128mb,
  VPDPWSSDSZ128mbk,
  VPDPWSSDSZ128mbkz,
  VPDPWSSDSZ128mk,
  VPDPWSSDSZ128mkz,
  VPDPWSSDSZ128r,
  VPDPWSSDSZ128rk,
  VPDPWSSDSZ128rkz,
  VPDPWSSDSZ256m,
  VPDPWSSDSZ256mb,
  VPDPWSSDSZ256mbk,
  VPDPWSSDSZ256mbkz,
  VPDPWSSDSZ256mk,
  VPDPWSSDSZ256mkz,
  VPDPWSSDSZ256r,
  VPDPWSSDSZ256rk,
  VPDPWSSDSZ256rkz,
  VPDPWSSDSZm,
  VPDPWSSDSZmb,
  VPDPWSSDSZmbk,
  VPDPWSSDSZmbkz,
  VPDPWSSDSZmk,
  VPDPWSSDSZmkz,
  VPDPWSSDSZr,
  VPDPWSSDSZrk,
  VPDPWSSDSZrkz,
  VPDPWSSDSrm,
  VPDPWSSDSrr,
  VPDPWSSDYrm,
  VPDPWSSDYrr,
  VPDPWSSDZ128m,
  VPDPWSSDZ128mb,
  VPDPWSSDZ128mbk,
  VPDPWSSDZ128mbkz,
  VPDPWSSDZ128mk,
  VPDPWSSDZ128mkz,
  VPDPWSSDZ128r,
  VPDPWSSDZ128rk,
  VPDPWSSDZ128rkz,
  VPDPWSSDZ256m,
  VPDPWSSDZ256mb,
  VPDPWSSDZ256mbk,
  VPDPWSSDZ256mbkz,
  VPDPWSSDZ256mk,
  VPDPWSSDZ256mkz,
  VPDPWSSDZ256r,
  VPDPWSSDZ256rk,
  VPDPWSSDZ256rkz,
  VPDPWSSDZm,
  VPDPWSSDZmb,
  VPDPWSSDZmbk,
  VPDPWSSDZmbkz,
  VPDPWSSDZmk,
  VPDPWSSDZmkz,
  VPDPWSSDZr,
  VPDPWSSDZrk,
  VPDPWSSDZrkz,
  VPDPWSSDrm,
  VPDPWSSDrr,
  VPDPWSUDSYrm,
  VPDPWSUDSYrr,
  VPDPWSUDSrm,
  VPDPWSUDSrr,
  VPDPWSUDYrm,
  VPDPWSUDYrr,
  VPDPWSUDrm,
  VPDPWSUDrr,
  VPDPWUSDSYrm,
  VPDPWUSDSYrr,
  VPDPWUSDSrm,
  VPDPWUSDSrr,
  VPDPWUSDYrm,
  VPDPWUSDYrr,
  VPDPWUSDrm,
  VPDPWUSDrr,
  VPDPWUUDSYrm,
  VPDPWUUDSYrr,
  VPDPWUUDSrm,
  VPDPWUUDSrr,
  VPDPWUUDYrm,
  VPDPWUUDYrr,
  VPDPWUUDrm,
  VPDPWUUDrr,
  VPERM2F128rm,
  VPERM2F128rr,
  VPERM2I128rm,
  VPERM2I128rr,
  VPERMBZ128rm,
  VPERMBZ128rmk,
  VPERMBZ128rmkz,
  VPERMBZ128rr,
  VPERMBZ128rrk,
  VPERMBZ128rrkz,
  VPERMBZ256rm,
  VPERMBZ256rmk,
  VPERMBZ256rmkz,
  VPERMBZ256rr,
  VPERMBZ256rrk,
  VPERMBZ256rrkz,
  VPERMBZrm,
  VPERMBZrmk,
  VPERMBZrmkz,
  VPERMBZrr,
  VPERMBZrrk,
  VPERMBZrrkz,
  VPERMDYrm,
  VPERMDYrr,
  VPERMDZ256rm,
  VPERMDZ256rmb,
  VPERMDZ256rmbk,
  VPERMDZ256rmbkz,
  VPERMDZ256rmk,
  VPERMDZ256rmkz,
  VPERMDZ256rr,
  VPERMDZ256rrk,
  VPERMDZ256rrkz,
  VPERMDZrm,
  VPERMDZrmb,
  VPERMDZrmbk,
  VPERMDZrmbkz,
  VPERMDZrmk,
  VPERMDZrmkz,
  VPERMDZrr,
  VPERMDZrrk,
  VPERMDZrrkz,
  VPERMI2BZ128rm,
  VPERMI2BZ128rmk,
  VPERMI2BZ128rmkz,
  VPERMI2BZ128rr,
  VPERMI2BZ128rrk,
  VPERMI2BZ128rrkz,
  VPERMI2BZ256rm,
  VPERMI2BZ256rmk,
  VPERMI2BZ256rmkz,
  VPERMI2BZ256rr,
  VPERMI2BZ256rrk,
  VPERMI2BZ256rrkz,
  VPERMI2BZrm,
  VPERMI2BZrmk,
  VPERMI2BZrmkz,
  VPERMI2BZrr,
  VPERMI2BZrrk,
  VPERMI2BZrrkz,
  VPERMI2DZ128rm,
  VPERMI2DZ128rmb,
  VPERMI2DZ128rmbk,
  VPERMI2DZ128rmbkz,
  VPERMI2DZ128rmk,
  VPERMI2DZ128rmkz,
  VPERMI2DZ128rr,
  VPERMI2DZ128rrk,
  VPERMI2DZ128rrkz,
  VPERMI2DZ256rm,
  VPERMI2DZ256rmb,
  VPERMI2DZ256rmbk,
  VPERMI2DZ256rmbkz,
  VPERMI2DZ256rmk,
  VPERMI2DZ256rmkz,
  VPERMI2DZ256rr,
  VPERMI2DZ256rrk,
  VPERMI2DZ256rrkz,
  VPERMI2DZrm,
  VPERMI2DZrmb,
  VPERMI2DZrmbk,
  VPERMI2DZrmbkz,
  VPERMI2DZrmk,
  VPERMI2DZrmkz,
  VPERMI2DZrr,
  VPERMI2DZrrk,
  VPERMI2DZrrkz,
  VPERMI2PDZ128rm,
  VPERMI2PDZ128rmb,
  VPERMI2PDZ128rmbk,
  VPERMI2PDZ128rmbkz,
  VPERMI2PDZ128rmk,
  VPERMI2PDZ128rmkz,
  VPERMI2PDZ128rr,
  VPERMI2PDZ128rrk,
  VPERMI2PDZ128rrkz,
  VPERMI2PDZ256rm,
  VPERMI2PDZ256rmb,
  VPERMI2PDZ256rmbk,
  VPERMI2PDZ256rmbkz,
  VPERMI2PDZ256rmk,
  VPERMI2PDZ256rmkz,
  VPERMI2PDZ256rr,
  VPERMI2PDZ256rrk,
  VPERMI2PDZ256rrkz,
  VPERMI2PDZrm,
  VPERMI2PDZrmb,
  VPERMI2PDZrmbk,
  VPERMI2PDZrmbkz,
  VPERMI2PDZrmk,
  VPERMI2PDZrmkz,
  VPERMI2PDZrr,
  VPERMI2PDZrrk,
  VPERMI2PDZrrkz,
  VPERMI2PSZ128rm,
  VPERMI2PSZ128rmb,
  VPERMI2PSZ128rmbk,
  VPERMI2PSZ128rmbkz,
  VPERMI2PSZ128rmk,
  VPERMI2PSZ128rmkz,
  VPERMI2PSZ128rr,
  VPERMI2PSZ128rrk,
  VPERMI2PSZ128rrkz,
  VPERMI2PSZ256rm,
  VPERMI2PSZ256rmb,
  VPERMI2PSZ256rmbk,
  VPERMI2PSZ256rmbkz,
  VPERMI2PSZ256rmk,
  VPERMI2PSZ256rmkz,
  VPERMI2PSZ256rr,
  VPERMI2PSZ256rrk,
  VPERMI2PSZ256rrkz,
  VPERMI2PSZrm,
  VPERMI2PSZrmb,
  VPERMI2PSZrmbk,
  VPERMI2PSZrmbkz,
  VPERMI2PSZrmk,
  VPERMI2PSZrmkz,
  VPERMI2PSZrr,
  VPERMI2PSZrrk,
  VPERMI2PSZrrkz,
  VPERMI2QZ128rm,
  VPERMI2QZ128rmb,
  VPERMI2QZ128rmbk,
  VPERMI2QZ128rmbkz,
  VPERMI2QZ128rmk,
  VPERMI2QZ128rmkz,
  VPERMI2QZ128rr,
  VPERMI2QZ128rrk,
  VPERMI2QZ128rrkz,
  VPERMI2QZ256rm,
  VPERMI2QZ256rmb,
  VPERMI2QZ256rmbk,
  VPERMI2QZ256rmbkz,
  VPERMI2QZ256rmk,
  VPERMI2QZ256rmkz,
  VPERMI2QZ256rr,
  VPERMI2QZ256rrk,
  VPERMI2QZ256rrkz,
  VPERMI2QZrm,
  VPERMI2QZrmb,
  VPERMI2QZrmbk,
  VPERMI2QZrmbkz,
  VPERMI2QZrmk,
  VPERMI2QZrmkz,
  VPERMI2QZrr,
  VPERMI2QZrrk,
  VPERMI2QZrrkz,
  VPERMI2WZ128rm,
  VPERMI2WZ128rmk,
  VPERMI2WZ128rmkz,
  VPERMI2WZ128rr,
  VPERMI2WZ128rrk,
  VPERMI2WZ128rrkz,
  VPERMI2WZ256rm,
  VPERMI2WZ256rmk,
  VPERMI2WZ256rmkz,
  VPERMI2WZ256rr,
  VPERMI2WZ256rrk,
  VPERMI2WZ256rrkz,
  VPERMI2WZrm,
  VPERMI2WZrmk,
  VPERMI2WZrmkz,
  VPERMI2WZrr,
  VPERMI2WZrrk,
  VPERMI2WZrrkz,
  VPERMIL2PDYmr,
  VPERMIL2PDYrm,
  VPERMIL2PDYrr,
  VPERMIL2PDYrr_REV,
  VPERMIL2PDmr,
  VPERMIL2PDrm,
  VPERMIL2PDrr,
  VPERMIL2PDrr_REV,
  VPERMIL2PSYmr,
  VPERMIL2PSYrm,
  VPERMIL2PSYrr,
  VPERMIL2PSYrr_REV,
  VPERMIL2PSmr,
  VPERMIL2PSrm,
  VPERMIL2PSrr,
  VPERMIL2PSrr_REV,
  VPERMILPDYmi,
  VPERMILPDYri,
  VPERMILPDYrm,
  VPERMILPDYrr,
  VPERMILPDZ128mbi,
  VPERMILPDZ128mbik,
  VPERMILPDZ128mbikz,
  VPERMILPDZ128mi,
  VPERMILPDZ128mik,
  VPERMILPDZ128mikz,
  VPERMILPDZ128ri,
  VPERMILPDZ128rik,
  VPERMILPDZ128rikz,
  VPERMILPDZ128rm,
  VPERMILPDZ128rmb,
  VPERMILPDZ128rmbk,
  VPERMILPDZ128rmbkz,
  VPERMILPDZ128rmk,
  VPERMILPDZ128rmkz,
  VPERMILPDZ128rr,
  VPERMILPDZ128rrk,
  VPERMILPDZ128rrkz,
  VPERMILPDZ256mbi,
  VPERMILPDZ256mbik,
  VPERMILPDZ256mbikz,
  VPERMILPDZ256mi,
  VPERMILPDZ256mik,
  VPERMILPDZ256mikz,
  VPERMILPDZ256ri,
  VPERMILPDZ256rik,
  VPERMILPDZ256rikz,
  VPERMILPDZ256rm,
  VPERMILPDZ256rmb,
  VPERMILPDZ256rmbk,
  VPERMILPDZ256rmbkz,
  VPERMILPDZ256rmk,
  VPERMILPDZ256rmkz,
  VPERMILPDZ256rr,
  VPERMILPDZ256rrk,
  VPERMILPDZ256rrkz,
  VPERMILPDZmbi,
  VPERMILPDZmbik,
  VPERMILPDZmbikz,
  VPERMILPDZmi,
  VPERMILPDZmik,
  VPERMILPDZmikz,
  VPERMILPDZri,
  VPERMILPDZrik,
  VPERMILPDZrikz,
  VPERMILPDZrm,
  VPERMILPDZrmb,
  VPERMILPDZrmbk,
  VPERMILPDZrmbkz,
  VPERMILPDZrmk,
  VPERMILPDZrmkz,
  VPERMILPDZrr,
  VPERMILPDZrrk,
  VPERMILPDZrrkz,
  VPERMILPDmi,
  VPERMILPDri,
  VPERMILPDrm,
  VPERMILPDrr,
  VPERMILPSYmi,
  VPERMILPSYri,
  VPERMILPSYrm,
  VPERMILPSYrr,
  VPERMILPSZ128mbi,
  VPERMILPSZ128mbik,
  VPERMILPSZ128mbikz,
  VPERMILPSZ128mi,
  VPERMILPSZ128mik,
  VPERMILPSZ128mikz,
  VPERMILPSZ128ri,
  VPERMILPSZ128rik,
  VPERMILPSZ128rikz,
  VPERMILPSZ128rm,
  VPERMILPSZ128rmb,
  VPERMILPSZ128rmbk,
  VPERMILPSZ128rmbkz,
  VPERMILPSZ128rmk,
  VPERMILPSZ128rmkz,
  VPERMILPSZ128rr,
  VPERMILPSZ128rrk,
  VPERMILPSZ128rrkz,
  VPERMILPSZ256mbi,
  VPERMILPSZ256mbik,
  VPERMILPSZ256mbikz,
  VPERMILPSZ256mi,
  VPERMILPSZ256mik,
  VPERMILPSZ256mikz,
  VPERMILPSZ256ri,
  VPERMILPSZ256rik,
  VPERMILPSZ256rikz,
  VPERMILPSZ256rm,
  VPERMILPSZ256rmb,
  VPERMILPSZ256rmbk,
  VPERMILPSZ256rmbkz,
  VPERMILPSZ256rmk,
  VPERMILPSZ256rmkz,
  VPERMILPSZ256rr,
  VPERMILPSZ256rrk,
  VPERMILPSZ256rrkz,
  VPERMILPSZmbi,
  VPERMILPSZmbik,
  VPERMILPSZmbikz,
  VPERMILPSZmi,
  VPERMILPSZmik,
  VPERMILPSZmikz,
  VPERMILPSZri,
  VPERMILPSZrik,
  VPERMILPSZrikz,
  VPERMILPSZrm,
  VPERMILPSZrmb,
  VPERMILPSZrmbk,
  VPERMILPSZrmbkz,
  VPERMILPSZrmk,
  VPERMILPSZrmkz,
  VPERMILPSZrr,
  VPERMILPSZrrk,
  VPERMILPSZrrkz,
  VPERMILPSmi,
  VPERMILPSri,
  VPERMILPSrm,
  VPERMILPSrr,
  VPERMPDYmi,
  VPERMPDYri,
  VPERMPDZ256mbi,
  VPERMPDZ256mbik,
  VPERMPDZ256mbikz,
  VPERMPDZ256mi,
  VPERMPDZ256mik,
  VPERMPDZ256mikz,
  VPERMPDZ256ri,
  VPERMPDZ256rik,
  VPERMPDZ256rikz,
  VPERMPDZ256rm,
  VPERMPDZ256rmb,
  VPERMPDZ256rmbk,
  VPERMPDZ256rmbkz,
  VPERMPDZ256rmk,
  VPERMPDZ256rmkz,
  VPERMPDZ256rr,
  VPERMPDZ256rrk,
  VPERMPDZ256rrkz,
  VPERMPDZmbi,
  VPERMPDZmbik,
  VPERMPDZmbikz,
  VPERMPDZmi,
  VPERMPDZmik,
  VPERMPDZmikz,
  VPERMPDZri,
  VPERMPDZrik,
  VPERMPDZrikz,
  VPERMPDZrm,
  VPERMPDZrmb,
  VPERMPDZrmbk,
  VPERMPDZrmbkz,
  VPERMPDZrmk,
  VPERMPDZrmkz,
  VPERMPDZrr,
  VPERMPDZrrk,
  VPERMPDZrrkz,
  VPERMPSYrm,
  VPERMPSYrr,
  VPERMPSZ256rm,
  VPERMPSZ256rmb,
  VPERMPSZ256rmbk,
  VPERMPSZ256rmbkz,
  VPERMPSZ256rmk,
  VPERMPSZ256rmkz,
  VPERMPSZ256rr,
  VPERMPSZ256rrk,
  VPERMPSZ256rrkz,
  VPERMPSZrm,
  VPERMPSZrmb,
  VPERMPSZrmbk,
  VPERMPSZrmbkz,
  VPERMPSZrmk,
  VPERMPSZrmkz,
  VPERMPSZrr,
  VPERMPSZrrk,
  VPERMPSZrrkz,
  VPERMQYmi,
  VPERMQYri,
  VPERMQZ256mbi,
  VPERMQZ256mbik,
  VPERMQZ256mbikz,
  VPERMQZ256mi,
  VPERMQZ256mik,
  VPERMQZ256mikz,
  VPERMQZ256ri,
  VPERMQZ256rik,
  VPERMQZ256rikz,
  VPERMQZ256rm,
  VPERMQZ256rmb,
  VPERMQZ256rmbk,
  VPERMQZ256rmbkz,
  VPERMQZ256rmk,
  VPERMQZ256rmkz,
  VPERMQZ256rr,
  VPERMQZ256rrk,
  VPERMQZ256rrkz,
  VPERMQZmbi,
  VPERMQZmbik,
  VPERMQZmbikz,
  VPERMQZmi,
  VPERMQZmik,
  VPERMQZmikz,
  VPERMQZri,
  VPERMQZrik,
  VPERMQZrikz,
  VPERMQZrm,
  VPERMQZrmb,
  VPERMQZrmbk,
  VPERMQZrmbkz,
  VPERMQZrmk,
  VPERMQZrmkz,
  VPERMQZrr,
  VPERMQZrrk,
  VPERMQZrrkz,
  VPERMT2BZ128rm,
  VPERMT2BZ128rmk,
  VPERMT2BZ128rmkz,
  VPERMT2BZ128rr,
  VPERMT2BZ128rrk,
  VPERMT2BZ128rrkz,
  VPERMT2BZ256rm,
  VPERMT2BZ256rmk,
  VPERMT2BZ256rmkz,
  VPERMT2BZ256rr,
  VPERMT2BZ256rrk,
  VPERMT2BZ256rrkz,
  VPERMT2BZrm,
  VPERMT2BZrmk,
  VPERMT2BZrmkz,
  VPERMT2BZrr,
  VPERMT2BZrrk,
  VPERMT2BZrrkz,
  VPERMT2DZ128rm,
  VPERMT2DZ128rmb,
  VPERMT2DZ128rmbk,
  VPERMT2DZ128rmbkz,
  VPERMT2DZ128rmk,
  VPERMT2DZ128rmkz,
  VPERMT2DZ128rr,
  VPERMT2DZ128rrk,
  VPERMT2DZ128rrkz,
  VPERMT2DZ256rm,
  VPERMT2DZ256rmb,
  VPERMT2DZ256rmbk,
  VPERMT2DZ256rmbkz,
  VPERMT2DZ256rmk,
  VPERMT2DZ256rmkz,
  VPERMT2DZ256rr,
  VPERMT2DZ256rrk,
  VPERMT2DZ256rrkz,
  VPERMT2DZrm,
  VPERMT2DZrmb,
  VPERMT2DZrmbk,
  VPERMT2DZrmbkz,
  VPERMT2DZrmk,
  VPERMT2DZrmkz,
  VPERMT2DZrr,
  VPERMT2DZrrk,
  VPERMT2DZrrkz,
  VPERMT2PDZ128rm,
  VPERMT2PDZ128rmb,
  VPERMT2PDZ128rmbk,
  VPERMT2PDZ128rmbkz,
  VPERMT2PDZ128rmk,
  VPERMT2PDZ128rmkz,
  VPERMT2PDZ128rr,
  VPERMT2PDZ128rrk,
  VPERMT2PDZ128rrkz,
  VPERMT2PDZ256rm,
  VPERMT2PDZ256rmb,
  VPERMT2PDZ256rmbk,
  VPERMT2PDZ256rmbkz,
  VPERMT2PDZ256rmk,
  VPERMT2PDZ256rmkz,
  VPERMT2PDZ256rr,
  VPERMT2PDZ256rrk,
  VPERMT2PDZ256rrkz,
  VPERMT2PDZrm,
  VPERMT2PDZrmb,
  VPERMT2PDZrmbk,
  VPERMT2PDZrmbkz,
  VPERMT2PDZrmk,
  VPERMT2PDZrmkz,
  VPERMT2PDZrr,
  VPERMT2PDZrrk,
  VPERMT2PDZrrkz,
  VPERMT2PSZ128rm,
  VPERMT2PSZ128rmb,
  VPERMT2PSZ128rmbk,
  VPERMT2PSZ128rmbkz,
  VPERMT2PSZ128rmk,
  VPERMT2PSZ128rmkz,
  VPERMT2PSZ128rr,
  VPERMT2PSZ128rrk,
  VPERMT2PSZ128rrkz,
  VPERMT2PSZ256rm,
  VPERMT2PSZ256rmb,
  VPERMT2PSZ256rmbk,
  VPERMT2PSZ256rmbkz,
  VPERMT2PSZ256rmk,
  VPERMT2PSZ256rmkz,
  VPERMT2PSZ256rr,
  VPERMT2PSZ256rrk,
  VPERMT2PSZ256rrkz,
  VPERMT2PSZrm,
  VPERMT2PSZrmb,
  VPERMT2PSZrmbk,
  VPERMT2PSZrmbkz,
  VPERMT2PSZrmk,
  VPERMT2PSZrmkz,
  VPERMT2PSZrr,
  VPERMT2PSZrrk,
  VPERMT2PSZrrkz,
  VPERMT2QZ128rm,
  VPERMT2QZ128rmb,
  VPERMT2QZ128rmbk,
  VPERMT2QZ128rmbkz,
  VPERMT2QZ128rmk,
  VPERMT2QZ128rmkz,
  VPERMT2QZ128rr,
  VPERMT2QZ128rrk,
  VPERMT2QZ128rrkz,
  VPERMT2QZ256rm,
  VPERMT2QZ256rmb,
  VPERMT2QZ256rmbk,
  VPERMT2QZ256rmbkz,
  VPERMT2QZ256rmk,
  VPERMT2QZ256rmkz,
  VPERMT2QZ256rr,
  VPERMT2QZ256rrk,
  VPERMT2QZ256rrkz,
  VPERMT2QZrm,
  VPERMT2QZrmb,
  VPERMT2QZrmbk,
  VPERMT2QZrmbkz,
  VPERMT2QZrmk,
  VPERMT2QZrmkz,
  VPERMT2QZrr,
  VPERMT2QZrrk,
  VPERMT2QZrrkz,
  VPERMT2WZ128rm,
  VPERMT2WZ128rmk,
  VPERMT2WZ128rmkz,
  VPERMT2WZ128rr,
  VPERMT2WZ128rrk,
  VPERMT2WZ128rrkz,
  VPERMT2WZ256rm,
  VPERMT2WZ256rmk,
  VPERMT2WZ256rmkz,
  VPERMT2WZ256rr,
  VPERMT2WZ256rrk,
  VPERMT2WZ256rrkz,
  VPERMT2WZrm,
  VPERMT2WZrmk,
  VPERMT2WZrmkz,
  VPERMT2WZrr,
  VPERMT2WZrrk,
  VPERMT2WZrrkz,
  VPERMWZ128rm,
  VPERMWZ128rmk,
  VPERMWZ128rmkz,
  VPERMWZ128rr,
  VPERMWZ128rrk,
  VPERMWZ128rrkz,
  VPERMWZ256rm,
  VPERMWZ256rmk,
  VPERMWZ256rmkz,
  VPERMWZ256rr,
  VPERMWZ256rrk,
  VPERMWZ256rrkz,
  VPERMWZrm,
  VPERMWZrmk,
  VPERMWZrmkz,
  VPERMWZrr,
  VPERMWZrrk,
  VPERMWZrrkz,
  VPEXPANDBZ128rm,
  VPEXPANDBZ128rmk,
  VPEXPANDBZ128rmkz,
  VPEXPANDBZ128rr,
  VPEXPANDBZ128rrk,
  VPEXPANDBZ128rrkz,
  VPEXPANDBZ256rm,
  VPEXPANDBZ256rmk,
  VPEXPANDBZ256rmkz,
  VPEXPANDBZ256rr,
  VPEXPANDBZ256rrk,
  VPEXPANDBZ256rrkz,
  VPEXPANDBZrm,
  VPEXPANDBZrmk,
  VPEXPANDBZrmkz,
  VPEXPANDBZrr,
  VPEXPANDBZrrk,
  VPEXPANDBZrrkz,
  VPEXPANDDZ128rm,
  VPEXPANDDZ128rmk,
  VPEXPANDDZ128rmkz,
  VPEXPANDDZ128rr,
  VPEXPANDDZ128rrk,
  VPEXPANDDZ128rrkz,
  VPEXPANDDZ256rm,
  VPEXPANDDZ256rmk,
  VPEXPANDDZ256rmkz,
  VPEXPANDDZ256rr,
  VPEXPANDDZ256rrk,
  VPEXPANDDZ256rrkz,
  VPEXPANDDZrm,
  VPEXPANDDZrmk,
  VPEXPANDDZrmkz,
  VPEXPANDDZrr,
  VPEXPANDDZrrk,
  VPEXPANDDZrrkz,
  VPEXPANDQZ128rm,
  VPEXPANDQZ128rmk,
  VPEXPANDQZ128rmkz,
  VPEXPANDQZ128rr,
  VPEXPANDQZ128rrk,
  VPEXPANDQZ128rrkz,
  VPEXPANDQZ256rm,
  VPEXPANDQZ256rmk,
  VPEXPANDQZ256rmkz,
  VPEXPANDQZ256rr,
  VPEXPANDQZ256rrk,
  VPEXPANDQZ256rrkz,
  VPEXPANDQZrm,
  VPEXPANDQZrmk,
  VPEXPANDQZrmkz,
  VPEXPANDQZrr,
  VPEXPANDQZrrk,
  VPEXPANDQZrrkz,
  VPEXPANDWZ128rm,
  VPEXPANDWZ128rmk,
  VPEXPANDWZ128rmkz,
  VPEXPANDWZ128rr,
  VPEXPANDWZ128rrk,
  VPEXPANDWZ128rrkz,
  VPEXPANDWZ256rm,
  VPEXPANDWZ256rmk,
  VPEXPANDWZ256rmkz,
  VPEXPANDWZ256rr,
  VPEXPANDWZ256rrk,
  VPEXPANDWZ256rrkz,
  VPEXPANDWZrm,
  VPEXPANDWZrmk,
  VPEXPANDWZrmkz,
  VPEXPANDWZrr,
  VPEXPANDWZrrk,
  VPEXPANDWZrrkz,
  VPEXTRBZmr,
  VPEXTRBZrr,
  VPEXTRBmr,
  VPEXTRBrr,
  VPEXTRDZmr,
  VPEXTRDZrr,
  VPEXTRDmr,
  VPEXTRDrr,
  VPEXTRQZmr,
  VPEXTRQZrr,
  VPEXTRQmr,
  VPEXTRQrr,
  VPEXTRWZmr,
  VPEXTRWZrr,
  VPEXTRWZrr_REV,
  VPEXTRWmr,
  VPEXTRWrr,
  VPEXTRWrr_REV,
  VPGATHERDDYrm,
  VPGATHERDDZ128rm,
  VPGATHERDDZ256rm,
  VPGATHERDDZrm,
  VPGATHERDDrm,
  VPGATHERDQYrm,
  VPGATHERDQZ128rm,
  VPGATHERDQZ256rm,
  VPGATHERDQZrm,
  VPGATHERDQrm,
  VPGATHERQDYrm,
  VPGATHERQDZ128rm,
  VPGATHERQDZ256rm,
  VPGATHERQDZrm,
  VPGATHERQDrm,
  VPGATHERQQYrm,
  VPGATHERQQZ128rm,
  VPGATHERQQZ256rm,
  VPGATHERQQZrm,
  VPGATHERQQrm,
  VPHADDBDrm,
  VPHADDBDrr,
  VPHADDBQrm,
  VPHADDBQrr,
  VPHADDBWrm,
  VPHADDBWrr,
  VPHADDDQrm,
  VPHADDDQrr,
  VPHADDDYrm,
  VPHADDDYrr,
  VPHADDDrm,
  VPHADDDrr,
  VPHADDSWYrm,
  VPHADDSWYrr,
  VPHADDSWrm,
  VPHADDSWrr,
  VPHADDUBDrm,
  VPHADDUBDrr,
  VPHADDUBQrm,
  VPHADDUBQrr,
  VPHADDUBWrm,
  VPHADDUBWrr,
  VPHADDUDQrm,
  VPHADDUDQrr,
  VPHADDUWDrm,
  VPHADDUWDrr,
  VPHADDUWQrm,
  VPHADDUWQrr,
  VPHADDWDrm,
  VPHADDWDrr,
  VPHADDWQrm,
  VPHADDWQrr,
  VPHADDWYrm,
  VPHADDWYrr,
  VPHADDWrm,
  VPHADDWrr,
  VPHMINPOSUWrm,
  VPHMINPOSUWrr,
  VPHSUBBWrm,
  VPHSUBBWrr,
  VPHSUBDQrm,
  VPHSUBDQrr,
  VPHSUBDYrm,
  VPHSUBDYrr,
  VPHSUBDrm,
  VPHSUBDrr,
  VPHSUBSWYrm,
  VPHSUBSWYrr,
  VPHSUBSWrm,
  VPHSUBSWrr,
  VPHSUBWDrm,
  VPHSUBWDrr,
  VPHSUBWYrm,
  VPHSUBWYrr,
  VPHSUBWrm,
  VPHSUBWrr,
  VPINSRBZrm,
  VPINSRBZrr,
  VPINSRBrm,
  VPINSRBrr,
  VPINSRDZrm,
  VPINSRDZrr,
  VPINSRDrm,
  VPINSRDrr,
  VPINSRQZrm,
  VPINSRQZrr,
  VPINSRQrm,
  VPINSRQrr,
  VPINSRWZrm,
  VPINSRWZrr,
  VPINSRWrm,
  VPINSRWrr,
  VPLZCNTDZ128rm,
  VPLZCNTDZ128rmb,
  VPLZCNTDZ128rmbk,
  VPLZCNTDZ128rmbkz,
  VPLZCNTDZ128rmk,
  VPLZCNTDZ128rmkz,
  VPLZCNTDZ128rr,
  VPLZCNTDZ128rrk,
  VPLZCNTDZ128rrkz,
  VPLZCNTDZ256rm,
  VPLZCNTDZ256rmb,
  VPLZCNTDZ256rmbk,
  VPLZCNTDZ256rmbkz,
  VPLZCNTDZ256rmk,
  VPLZCNTDZ256rmkz,
  VPLZCNTDZ256rr,
  VPLZCNTDZ256rrk,
  VPLZCNTDZ256rrkz,
  VPLZCNTDZrm,
  VPLZCNTDZrmb,
  VPLZCNTDZrmbk,
  VPLZCNTDZrmbkz,
  VPLZCNTDZrmk,
  VPLZCNTDZrmkz,
  VPLZCNTDZrr,
  VPLZCNTDZrrk,
  VPLZCNTDZrrkz,
  VPLZCNTQZ128rm,
  VPLZCNTQZ128rmb,
  VPLZCNTQZ128rmbk,
  VPLZCNTQZ128rmbkz,
  VPLZCNTQZ128rmk,
  VPLZCNTQZ128rmkz,
  VPLZCNTQZ128rr,
  VPLZCNTQZ128rrk,
  VPLZCNTQZ128rrkz,
  VPLZCNTQZ256rm,
  VPLZCNTQZ256rmb,
  VPLZCNTQZ256rmbk,
  VPLZCNTQZ256rmbkz,
  VPLZCNTQZ256rmk,
  VPLZCNTQZ256rmkz,
  VPLZCNTQZ256rr,
  VPLZCNTQZ256rrk,
  VPLZCNTQZ256rrkz,
  VPLZCNTQZrm,
  VPLZCNTQZrmb,
  VPLZCNTQZrmbk,
  VPLZCNTQZrmbkz,
  VPLZCNTQZrmk,
  VPLZCNTQZrmkz,
  VPLZCNTQZrr,
  VPLZCNTQZrrk,
  VPLZCNTQZrrkz,
  VPMACSDDrm,
  VPMACSDDrr,
  VPMACSDQHrm,
  VPMACSDQHrr,
  VPMACSDQLrm,
  VPMACSDQLrr,
  VPMACSSDDrm,
  VPMACSSDDrr,
  VPMACSSDQHrm,
  VPMACSSDQHrr,
  VPMACSSDQLrm,
  VPMACSSDQLrr,
  VPMACSSWDrm,
  VPMACSSWDrr,
  VPMACSSWWrm,
  VPMACSSWWrr,
  VPMACSWDrm,
  VPMACSWDrr,
  VPMACSWWrm,
  VPMACSWWrr,
  VPMADCSSWDrm,
  VPMADCSSWDrr,
  VPMADCSWDrm,
  VPMADCSWDrr,
  VPMADD52HUQYrm,
  VPMADD52HUQYrr,
  VPMADD52HUQZ128m,
  VPMADD52HUQZ128mb,
  VPMADD52HUQZ128mbk,
  VPMADD52HUQZ128mbkz,
  VPMADD52HUQZ128mk,
  VPMADD52HUQZ128mkz,
  VPMADD52HUQZ128r,
  VPMADD52HUQZ128rk,
  VPMADD52HUQZ128rkz,
  VPMADD52HUQZ256m,
  VPMADD52HUQZ256mb,
  VPMADD52HUQZ256mbk,
  VPMADD52HUQZ256mbkz,
  VPMADD52HUQZ256mk,
  VPMADD52HUQZ256mkz,
  VPMADD52HUQZ256r,
  VPMADD52HUQZ256rk,
  VPMADD52HUQZ256rkz,
  VPMADD52HUQZm,
  VPMADD52HUQZmb,
  VPMADD52HUQZmbk,
  VPMADD52HUQZmbkz,
  VPMADD52HUQZmk,
  VPMADD52HUQZmkz,
  VPMADD52HUQZr,
  VPMADD52HUQZrk,
  VPMADD52HUQZrkz,
  VPMADD52HUQrm,
  VPMADD52HUQrr,
  VPMADD52LUQYrm,
  VPMADD52LUQYrr,
  VPMADD52LUQZ128m,
  VPMADD52LUQZ128mb,
  VPMADD52LUQZ128mbk,
  VPMADD52LUQZ128mbkz,
  VPMADD52LUQZ128mk,
  VPMADD52LUQZ128mkz,
  VPMADD52LUQZ128r,
  VPMADD52LUQZ128rk,
  VPMADD52LUQZ128rkz,
  VPMADD52LUQZ256m,
  VPMADD52LUQZ256mb,
  VPMADD52LUQZ256mbk,
  VPMADD52LUQZ256mbkz,
  VPMADD52LUQZ256mk,
  VPMADD52LUQZ256mkz,
  VPMADD52LUQZ256r,
  VPMADD52LUQZ256rk,
  VPMADD52LUQZ256rkz,
  VPMADD52LUQZm,
  VPMADD52LUQZmb,
  VPMADD52LUQZmbk,
  VPMADD52LUQZmbkz,
  VPMADD52LUQZmk,
  VPMADD52LUQZmkz,
  VPMADD52LUQZr,
  VPMADD52LUQZrk,
  VPMADD52LUQZrkz,
  VPMADD52LUQrm,
  VPMADD52LUQrr,
  VPMADDUBSWYrm,
  VPMADDUBSWYrr,
  VPMADDUBSWZ128rm,
  VPMADDUBSWZ128rmk,
  VPMADDUBSWZ128rmkz,
  VPMADDUBSWZ128rr,
  VPMADDUBSWZ128rrk,
  VPMADDUBSWZ128rrkz,
  VPMADDUBSWZ256rm,
  VPMADDUBSWZ256rmk,
  VPMADDUBSWZ256rmkz,
  VPMADDUBSWZ256rr,
  VPMADDUBSWZ256rrk,
  VPMADDUBSWZ256rrkz,
  VPMADDUBSWZrm,
  VPMADDUBSWZrmk,
  VPMADDUBSWZrmkz,
  VPMADDUBSWZrr,
  VPMADDUBSWZrrk,
  VPMADDUBSWZrrkz,
  VPMADDUBSWrm,
  VPMADDUBSWrr,
  VPMADDWDYrm,
  VPMADDWDYrr,
  VPMADDWDZ128rm,
  VPMADDWDZ128rmk,
  VPMADDWDZ128rmkz,
  VPMADDWDZ128rr,
  VPMADDWDZ128rrk,
  VPMADDWDZ128rrkz,
  VPMADDWDZ256rm,
  VPMADDWDZ256rmk,
  VPMADDWDZ256rmkz,
  VPMADDWDZ256rr,
  VPMADDWDZ256rrk,
  VPMADDWDZ256rrkz,
  VPMADDWDZrm,
  VPMADDWDZrmk,
  VPMADDWDZrmkz,
  VPMADDWDZrr,
  VPMADDWDZrrk,
  VPMADDWDZrrkz,
  VPMADDWDrm,
  VPMADDWDrr,
  VPMASKMOVDYmr,
  VPMASKMOVDYrm,
  VPMASKMOVDmr,
  VPMASKMOVDrm,
  VPMASKMOVQYmr,
  VPMASKMOVQYrm,
  VPMASKMOVQmr,
  VPMASKMOVQrm,
  VPMAXSBYrm,
  VPMAXSBYrr,
  VPMAXSBZ128rm,
  VPMAXSBZ128rmk,
  VPMAXSBZ128rmkz,
  VPMAXSBZ128rr,
  VPMAXSBZ128rrk,
  VPMAXSBZ128rrkz,
  VPMAXSBZ256rm,
  VPMAXSBZ256rmk,
  VPMAXSBZ256rmkz,
  VPMAXSBZ256rr,
  VPMAXSBZ256rrk,
  VPMAXSBZ256rrkz,
  VPMAXSBZrm,
  VPMAXSBZrmk,
  VPMAXSBZrmkz,
  VPMAXSBZrr,
  VPMAXSBZrrk,
  VPMAXSBZrrkz,
  VPMAXSBrm,
  VPMAXSBrr,
  VPMAXSDYrm,
  VPMAXSDYrr,
  VPMAXSDZ128rm,
  VPMAXSDZ128rmb,
  VPMAXSDZ128rmbk,
  VPMAXSDZ128rmbkz,
  VPMAXSDZ128rmk,
  VPMAXSDZ128rmkz,
  VPMAXSDZ128rr,
  VPMAXSDZ128rrk,
  VPMAXSDZ128rrkz,
  VPMAXSDZ256rm,
  VPMAXSDZ256rmb,
  VPMAXSDZ256rmbk,
  VPMAXSDZ256rmbkz,
  VPMAXSDZ256rmk,
  VPMAXSDZ256rmkz,
  VPMAXSDZ256rr,
  VPMAXSDZ256rrk,
  VPMAXSDZ256rrkz,
  VPMAXSDZrm,
  VPMAXSDZrmb,
  VPMAXSDZrmbk,
  VPMAXSDZrmbkz,
  VPMAXSDZrmk,
  VPMAXSDZrmkz,
  VPMAXSDZrr,
  VPMAXSDZrrk,
  VPMAXSDZrrkz,
  VPMAXSDrm,
  VPMAXSDrr,
  VPMAXSQZ128rm,
  VPMAXSQZ128rmb,
  VPMAXSQZ128rmbk,
  VPMAXSQZ128rmbkz,
  VPMAXSQZ128rmk,
  VPMAXSQZ128rmkz,
  VPMAXSQZ128rr,
  VPMAXSQZ128rrk,
  VPMAXSQZ128rrkz,
  VPMAXSQZ256rm,
  VPMAXSQZ256rmb,
  VPMAXSQZ256rmbk,
  VPMAXSQZ256rmbkz,
  VPMAXSQZ256rmk,
  VPMAXSQZ256rmkz,
  VPMAXSQZ256rr,
  VPMAXSQZ256rrk,
  VPMAXSQZ256rrkz,
  VPMAXSQZrm,
  VPMAXSQZrmb,
  VPMAXSQZrmbk,
  VPMAXSQZrmbkz,
  VPMAXSQZrmk,
  VPMAXSQZrmkz,
  VPMAXSQZrr,
  VPMAXSQZrrk,
  VPMAXSQZrrkz,
  VPMAXSWYrm,
  VPMAXSWYrr,
  VPMAXSWZ128rm,
  VPMAXSWZ128rmk,
  VPMAXSWZ128rmkz,
  VPMAXSWZ128rr,
  VPMAXSWZ128rrk,
  VPMAXSWZ128rrkz,
  VPMAXSWZ256rm,
  VPMAXSWZ256rmk,
  VPMAXSWZ256rmkz,
  VPMAXSWZ256rr,
  VPMAXSWZ256rrk,
  VPMAXSWZ256rrkz,
  VPMAXSWZrm,
  VPMAXSWZrmk,
  VPMAXSWZrmkz,
  VPMAXSWZrr,
  VPMAXSWZrrk,
  VPMAXSWZrrkz,
  VPMAXSWrm,
  VPMAXSWrr,
  VPMAXUBYrm,
  VPMAXUBYrr,
  VPMAXUBZ128rm,
  VPMAXUBZ128rmk,
  VPMAXUBZ128rmkz,
  VPMAXUBZ128rr,
  VPMAXUBZ128rrk,
  VPMAXUBZ128rrkz,
  VPMAXUBZ256rm,
  VPMAXUBZ256rmk,
  VPMAXUBZ256rmkz,
  VPMAXUBZ256rr,
  VPMAXUBZ256rrk,
  VPMAXUBZ256rrkz,
  VPMAXUBZrm,
  VPMAXUBZrmk,
  VPMAXUBZrmkz,
  VPMAXUBZrr,
  VPMAXUBZrrk,
  VPMAXUBZrrkz,
  VPMAXUBrm,
  VPMAXUBrr,
  VPMAXUDYrm,
  VPMAXUDYrr,
  VPMAXUDZ128rm,
  VPMAXUDZ128rmb,
  VPMAXUDZ128rmbk,
  VPMAXUDZ128rmbkz,
  VPMAXUDZ128rmk,
  VPMAXUDZ128rmkz,
  VPMAXUDZ128rr,
  VPMAXUDZ128rrk,
  VPMAXUDZ128rrkz,
  VPMAXUDZ256rm,
  VPMAXUDZ256rmb,
  VPMAXUDZ256rmbk,
  VPMAXUDZ256rmbkz,
  VPMAXUDZ256rmk,
  VPMAXUDZ256rmkz,
  VPMAXUDZ256rr,
  VPMAXUDZ256rrk,
  VPMAXUDZ256rrkz,
  VPMAXUDZrm,
  VPMAXUDZrmb,
  VPMAXUDZrmbk,
  VPMAXUDZrmbkz,
  VPMAXUDZrmk,
  VPMAXUDZrmkz,
  VPMAXUDZrr,
  VPMAXUDZrrk,
  VPMAXUDZrrkz,
  VPMAXUDrm,
  VPMAXUDrr,
  VPMAXUQZ128rm,
  VPMAXUQZ128rmb,
  VPMAXUQZ128rmbk,
  VPMAXUQZ128rmbkz,
  VPMAXUQZ128rmk,
  VPMAXUQZ128rmkz,
  VPMAXUQZ128rr,
  VPMAXUQZ128rrk,
  VPMAXUQZ128rrkz,
  VPMAXUQZ256rm,
  VPMAXUQZ256rmb,
  VPMAXUQZ256rmbk,
  VPMAXUQZ256rmbkz,
  VPMAXUQZ256rmk,
  VPMAXUQZ256rmkz,
  VPMAXUQZ256rr,
  VPMAXUQZ256rrk,
  VPMAXUQZ256rrkz,
  VPMAXUQZrm,
  VPMAXUQZrmb,
  VPMAXUQZrmbk,
  VPMAXUQZrmbkz,
  VPMAXUQZrmk,
  VPMAXUQZrmkz,
  VPMAXUQZrr,
  VPMAXUQZrrk,
  VPMAXUQZrrkz,
  VPMAXUWYrm,
  VPMAXUWYrr,
  VPMAXUWZ128rm,
  VPMAXUWZ128rmk,
  VPMAXUWZ128rmkz,
  VPMAXUWZ128rr,
  VPMAXUWZ128rrk,
  VPMAXUWZ128rrkz,
  VPMAXUWZ256rm,
  VPMAXUWZ256rmk,
  VPMAXUWZ256rmkz,
  VPMAXUWZ256rr,
  VPMAXUWZ256rrk,
  VPMAXUWZ256rrkz,
  VPMAXUWZrm,
  VPMAXUWZrmk,
  VPMAXUWZrmkz,
  VPMAXUWZrr,
  VPMAXUWZrrk,
  VPMAXUWZrrkz,
  VPMAXUWrm,
  VPMAXUWrr,
  VPMINSBYrm,
  VPMINSBYrr,
  VPMINSBZ128rm,
  VPMINSBZ128rmk,
  VPMINSBZ128rmkz,
  VPMINSBZ128rr,
  VPMINSBZ128rrk,
  VPMINSBZ128rrkz,
  VPMINSBZ256rm,
  VPMINSBZ256rmk,
  VPMINSBZ256rmkz,
  VPMINSBZ256rr,
  VPMINSBZ256rrk,
  VPMINSBZ256rrkz,
  VPMINSBZrm,
  VPMINSBZrmk,
  VPMINSBZrmkz,
  VPMINSBZrr,
  VPMINSBZrrk,
  VPMINSBZrrkz,
  VPMINSBrm,
  VPMINSBrr,
  VPMINSDYrm,
  VPMINSDYrr,
  VPMINSDZ128rm,
  VPMINSDZ128rmb,
  VPMINSDZ128rmbk,
  VPMINSDZ128rmbkz,
  VPMINSDZ128rmk,
  VPMINSDZ128rmkz,
  VPMINSDZ128rr,
  VPMINSDZ128rrk,
  VPMINSDZ128rrkz,
  VPMINSDZ256rm,
  VPMINSDZ256rmb,
  VPMINSDZ256rmbk,
  VPMINSDZ256rmbkz,
  VPMINSDZ256rmk,
  VPMINSDZ256rmkz,
  VPMINSDZ256rr,
  VPMINSDZ256rrk,
  VPMINSDZ256rrkz,
  VPMINSDZrm,
  VPMINSDZrmb,
  VPMINSDZrmbk,
  VPMINSDZrmbkz,
  VPMINSDZrmk,
  VPMINSDZrmkz,
  VPMINSDZrr,
  VPMINSDZrrk,
  VPMINSDZrrkz,
  VPMINSDrm,
  VPMINSDrr,
  VPMINSQZ128rm,
  VPMINSQZ128rmb,
  VPMINSQZ128rmbk,
  VPMINSQZ128rmbkz,
  VPMINSQZ128rmk,
  VPMINSQZ128rmkz,
  VPMINSQZ128rr,
  VPMINSQZ128rrk,
  VPMINSQZ128rrkz,
  VPMINSQZ256rm,
  VPMINSQZ256rmb,
  VPMINSQZ256rmbk,
  VPMINSQZ256rmbkz,
  VPMINSQZ256rmk,
  VPMINSQZ256rmkz,
  VPMINSQZ256rr,
  VPMINSQZ256rrk,
  VPMINSQZ256rrkz,
  VPMINSQZrm,
  VPMINSQZrmb,
  VPMINSQZrmbk,
  VPMINSQZrmbkz,
  VPMINSQZrmk,
  VPMINSQZrmkz,
  VPMINSQZrr,
  VPMINSQZrrk,
  VPMINSQZrrkz,
  VPMINSWYrm,
  VPMINSWYrr,
  VPMINSWZ128rm,
  VPMINSWZ128rmk,
  VPMINSWZ128rmkz,
  VPMINSWZ128rr,
  VPMINSWZ128rrk,
  VPMINSWZ128rrkz,
  VPMINSWZ256rm,
  VPMINSWZ256rmk,
  VPMINSWZ256rmkz,
  VPMINSWZ256rr,
  VPMINSWZ256rrk,
  VPMINSWZ256rrkz,
  VPMINSWZrm,
  VPMINSWZrmk,
  VPMINSWZrmkz,
  VPMINSWZrr,
  VPMINSWZrrk,
  VPMINSWZrrkz,
  VPMINSWrm,
  VPMINSWrr,
  VPMINUBYrm,
  VPMINUBYrr,
  VPMINUBZ128rm,
  VPMINUBZ128rmk,
  VPMINUBZ128rmkz,
  VPMINUBZ128rr,
  VPMINUBZ128rrk,
  VPMINUBZ128rrkz,
  VPMINUBZ256rm,
  VPMINUBZ256rmk,
  VPMINUBZ256rmkz,
  VPMINUBZ256rr,
  VPMINUBZ256rrk,
  VPMINUBZ256rrkz,
  VPMINUBZrm,
  VPMINUBZrmk,
  VPMINUBZrmkz,
  VPMINUBZrr,
  VPMINUBZrrk,
  VPMINUBZrrkz,
  VPMINUBrm,
  VPMINUBrr,
  VPMINUDYrm,
  VPMINUDYrr,
  VPMINUDZ128rm,
  VPMINUDZ128rmb,
  VPMINUDZ128rmbk,
  VPMINUDZ128rmbkz,
  VPMINUDZ128rmk,
  VPMINUDZ128rmkz,
  VPMINUDZ128rr,
  VPMINUDZ128rrk,
  VPMINUDZ128rrkz,
  VPMINUDZ256rm,
  VPMINUDZ256rmb,
  VPMINUDZ256rmbk,
  VPMINUDZ256rmbkz,
  VPMINUDZ256rmk,
  VPMINUDZ256rmkz,
  VPMINUDZ256rr,
  VPMINUDZ256rrk,
  VPMINUDZ256rrkz,
  VPMINUDZrm,
  VPMINUDZrmb,
  VPMINUDZrmbk,
  VPMINUDZrmbkz,
  VPMINUDZrmk,
  VPMINUDZrmkz,
  VPMINUDZrr,
  VPMINUDZrrk,
  VPMINUDZrrkz,
  VPMINUDrm,
  VPMINUDrr,
  VPMINUQZ128rm,
  VPMINUQZ128rmb,
  VPMINUQZ128rmbk,
  VPMINUQZ128rmbkz,
  VPMINUQZ128rmk,
  VPMINUQZ128rmkz,
  VPMINUQZ128rr,
  VPMINUQZ128rrk,
  VPMINUQZ128rrkz,
  VPMINUQZ256rm,
  VPMINUQZ256rmb,
  VPMINUQZ256rmbk,
  VPMINUQZ256rmbkz,
  VPMINUQZ256rmk,
  VPMINUQZ256rmkz,
  VPMINUQZ256rr,
  VPMINUQZ256rrk,
  VPMINUQZ256rrkz,
  VPMINUQZrm,
  VPMINUQZrmb,
  VPMINUQZrmbk,
  VPMINUQZrmbkz,
  VPMINUQZrmk,
  VPMINUQZrmkz,
  VPMINUQZrr,
  VPMINUQZrrk,
  VPMINUQZrrkz,
  VPMINUWYrm,
  VPMINUWYrr,
  VPMINUWZ128rm,
  VPMINUWZ128rmk,
  VPMINUWZ128rmkz,
  VPMINUWZ128rr,
  VPMINUWZ128rrk,
  VPMINUWZ128rrkz,
  VPMINUWZ256rm,
  VPMINUWZ256rmk,
  VPMINUWZ256rmkz,
  VPMINUWZ256rr,
  VPMINUWZ256rrk,
  VPMINUWZ256rrkz,
  VPMINUWZrm,
  VPMINUWZrmk,
  VPMINUWZrmkz,
  VPMINUWZrr,
  VPMINUWZrrk,
  VPMINUWZrrkz,
  VPMINUWrm,
  VPMINUWrr,
  VPMOVB2MZ128rr,
  VPMOVB2MZ256rr,
  VPMOVB2MZrr,
  VPMOVD2MZ128rr,
  VPMOVD2MZ256rr,
  VPMOVD2MZrr,
  VPMOVDBZ128mr,
  VPMOVDBZ128mrk,
  VPMOVDBZ128rr,
  VPMOVDBZ128rrk,
  VPMOVDBZ128rrkz,
  VPMOVDBZ256mr,
  VPMOVDBZ256mrk,
  VPMOVDBZ256rr,
  VPMOVDBZ256rrk,
  VPMOVDBZ256rrkz,
  VPMOVDBZmr,
  VPMOVDBZmrk,
  VPMOVDBZrr,
  VPMOVDBZrrk,
  VPMOVDBZrrkz,
  VPMOVDWZ128mr,
  VPMOVDWZ128mrk,
  VPMOVDWZ128rr,
  VPMOVDWZ128rrk,
  VPMOVDWZ128rrkz,
  VPMOVDWZ256mr,
  VPMOVDWZ256mrk,
  VPMOVDWZ256rr,
  VPMOVDWZ256rrk,
  VPMOVDWZ256rrkz,
  VPMOVDWZmr,
  VPMOVDWZmrk,
  VPMOVDWZrr,
  VPMOVDWZrrk,
  VPMOVDWZrrkz,
  VPMOVM2BZ128rr,
  VPMOVM2BZ256rr,
  VPMOVM2BZrr,
  VPMOVM2DZ128rr,
  VPMOVM2DZ256rr,
  VPMOVM2DZrr,
  VPMOVM2QZ128rr,
  VPMOVM2QZ256rr,
  VPMOVM2QZrr,
  VPMOVM2WZ128rr,
  VPMOVM2WZ256rr,
  VPMOVM2WZrr,
  VPMOVMSKBYrr,
  VPMOVMSKBrr,
  VPMOVQ2MZ128rr,
  VPMOVQ2MZ256rr,
  VPMOVQ2MZrr,
  VPMOVQBZ128mr,
  VPMOVQBZ128mrk,
  VPMOVQBZ128rr,
  VPMOVQBZ128rrk,
  VPMOVQBZ128rrkz,
  VPMOVQBZ256mr,
  VPMOVQBZ256mrk,
  VPMOVQBZ256rr,
  VPMOVQBZ256rrk,
  VPMOVQBZ256rrkz,
  VPMOVQBZmr,
  VPMOVQBZmrk,
  VPMOVQBZrr,
  VPMOVQBZrrk,
  VPMOVQBZrrkz,
  VPMOVQDZ128mr,
  VPMOVQDZ128mrk,
  VPMOVQDZ128rr,
  VPMOVQDZ128rrk,
  VPMOVQDZ128rrkz,
  VPMOVQDZ256mr,
  VPMOVQDZ256mrk,
  VPMOVQDZ256rr,
  VPMOVQDZ256rrk,
  VPMOVQDZ256rrkz,
  VPMOVQDZmr,
  VPMOVQDZmrk,
  VPMOVQDZrr,
  VPMOVQDZrrk,
  VPMOVQDZrrkz,
  VPMOVQWZ128mr,
  VPMOVQWZ128mrk,
  VPMOVQWZ128rr,
  VPMOVQWZ128rrk,
  VPMOVQWZ128rrkz,
  VPMOVQWZ256mr,
  VPMOVQWZ256mrk,
  VPMOVQWZ256rr,
  VPMOVQWZ256rrk,
  VPMOVQWZ256rrkz,
  VPMOVQWZmr,
  VPMOVQWZmrk,
  VPMOVQWZrr,
  VPMOVQWZrrk,
  VPMOVQWZrrkz,
  VPMOVSDBZ128mr,
  VPMOVSDBZ128mrk,
  VPMOVSDBZ128rr,
  VPMOVSDBZ128rrk,
  VPMOVSDBZ128rrkz,
  VPMOVSDBZ256mr,
  VPMOVSDBZ256mrk,
  VPMOVSDBZ256rr,
  VPMOVSDBZ256rrk,
  VPMOVSDBZ256rrkz,
  VPMOVSDBZmr,
  VPMOVSDBZmrk,
  VPMOVSDBZrr,
  VPMOVSDBZrrk,
  VPMOVSDBZrrkz,
  VPMOVSDWZ128mr,
  VPMOVSDWZ128mrk,
  VPMOVSDWZ128rr,
  VPMOVSDWZ128rrk,
  VPMOVSDWZ128rrkz,
  VPMOVSDWZ256mr,
  VPMOVSDWZ256mrk,
  VPMOVSDWZ256rr,
  VPMOVSDWZ256rrk,
  VPMOVSDWZ256rrkz,
  VPMOVSDWZmr,
  VPMOVSDWZmrk,
  VPMOVSDWZrr,
  VPMOVSDWZrrk,
  VPMOVSDWZrrkz,
  VPMOVSQBZ128mr,
  VPMOVSQBZ128mrk,
  VPMOVSQBZ128rr,
  VPMOVSQBZ128rrk,
  VPMOVSQBZ128rrkz,
  VPMOVSQBZ256mr,
  VPMOVSQBZ256mrk,
  VPMOVSQBZ256rr,
  VPMOVSQBZ256rrk,
  VPMOVSQBZ256rrkz,
  VPMOVSQBZmr,
  VPMOVSQBZmrk,
  VPMOVSQBZrr,
  VPMOVSQBZrrk,
  VPMOVSQBZrrkz,
  VPMOVSQDZ128mr,
  VPMOVSQDZ128mrk,
  VPMOVSQDZ128rr,
  VPMOVSQDZ128rrk,
  VPMOVSQDZ128rrkz,
  VPMOVSQDZ256mr,
  VPMOVSQDZ256mrk,
  VPMOVSQDZ256rr,
  VPMOVSQDZ256rrk,
  VPMOVSQDZ256rrkz,
  VPMOVSQDZmr,
  VPMOVSQDZmrk,
  VPMOVSQDZrr,
  VPMOVSQDZrrk,
  VPMOVSQDZrrkz,
  VPMOVSQWZ128mr,
  VPMOVSQWZ128mrk,
  VPMOVSQWZ128rr,
  VPMOVSQWZ128rrk,
  VPMOVSQWZ128rrkz,
  VPMOVSQWZ256mr,
  VPMOVSQWZ256mrk,
  VPMOVSQWZ256rr,
  VPMOVSQWZ256rrk,
  VPMOVSQWZ256rrkz,
  VPMOVSQWZmr,
  VPMOVSQWZmrk,
  VPMOVSQWZrr,
  VPMOVSQWZrrk,
  VPMOVSQWZrrkz,
  VPMOVSWBZ128mr,
  VPMOVSWBZ128mrk,
  VPMOVSWBZ128rr,
  VPMOVSWBZ128rrk,
  VPMOVSWBZ128rrkz,
  VPMOVSWBZ256mr,
  VPMOVSWBZ256mrk,
  VPMOVSWBZ256rr,
  VPMOVSWBZ256rrk,
  VPMOVSWBZ256rrkz,
  VPMOVSWBZmr,
  VPMOVSWBZmrk,
  VPMOVSWBZrr,
  VPMOVSWBZrrk,
  VPMOVSWBZrrkz,
  VPMOVSXBDYrm,
  VPMOVSXBDYrr,
  VPMOVSXBDZ128rm,
  VPMOVSXBDZ128rmk,
  VPMOVSXBDZ128rmkz,
  VPMOVSXBDZ128rr,
  VPMOVSXBDZ128rrk,
  VPMOVSXBDZ128rrkz,
  VPMOVSXBDZ256rm,
  VPMOVSXBDZ256rmk,
  VPMOVSXBDZ256rmkz,
  VPMOVSXBDZ256rr,
  VPMOVSXBDZ256rrk,
  VPMOVSXBDZ256rrkz,
  VPMOVSXBDZrm,
  VPMOVSXBDZrmk,
  VPMOVSXBDZrmkz,
  VPMOVSXBDZrr,
  VPMOVSXBDZrrk,
  VPMOVSXBDZrrkz,
  VPMOVSXBDrm,
  VPMOVSXBDrr,
  VPMOVSXBQYrm,
  VPMOVSXBQYrr,
  VPMOVSXBQZ128rm,
  VPMOVSXBQZ128rmk,
  VPMOVSXBQZ128rmkz,
  VPMOVSXBQZ128rr,
  VPMOVSXBQZ128rrk,
  VPMOVSXBQZ128rrkz,
  VPMOVSXBQZ256rm,
  VPMOVSXBQZ256rmk,
  VPMOVSXBQZ256rmkz,
  VPMOVSXBQZ256rr,
  VPMOVSXBQZ256rrk,
  VPMOVSXBQZ256rrkz,
  VPMOVSXBQZrm,
  VPMOVSXBQZrmk,
  VPMOVSXBQZrmkz,
  VPMOVSXBQZrr,
  VPMOVSXBQZrrk,
  VPMOVSXBQZrrkz,
  VPMOVSXBQrm,
  VPMOVSXBQrr,
  VPMOVSXBWYrm,
  VPMOVSXBWYrr,
  VPMOVSXBWZ128rm,
  VPMOVSXBWZ128rmk,
  VPMOVSXBWZ128rmkz,
  VPMOVSXBWZ128rr,
  VPMOVSXBWZ128rrk,
  VPMOVSXBWZ128rrkz,
  VPMOVSXBWZ256rm,
  VPMOVSXBWZ256rmk,
  VPMOVSXBWZ256rmkz,
  VPMOVSXBWZ256rr,
  VPMOVSXBWZ256rrk,
  VPMOVSXBWZ256rrkz,
  VPMOVSXBWZrm,
  VPMOVSXBWZrmk,
  VPMOVSXBWZrmkz,
  VPMOVSXBWZrr,
  VPMOVSXBWZrrk,
  VPMOVSXBWZrrkz,
  VPMOVSXBWrm,
  VPMOVSXBWrr,
  VPMOVSXDQYrm,
  VPMOVSXDQYrr,
  VPMOVSXDQZ128rm,
  VPMOVSXDQZ128rmk,
  VPMOVSXDQZ128rmkz,
  VPMOVSXDQZ128rr,
  VPMOVSXDQZ128rrk,
  VPMOVSXDQZ128rrkz,
  VPMOVSXDQZ256rm,
  VPMOVSXDQZ256rmk,
  VPMOVSXDQZ256rmkz,
  VPMOVSXDQZ256rr,
  VPMOVSXDQZ256rrk,
  VPMOVSXDQZ256rrkz,
  VPMOVSXDQZrm,
  VPMOVSXDQZrmk,
  VPMOVSXDQZrmkz,
  VPMOVSXDQZrr,
  VPMOVSXDQZrrk,
  VPMOVSXDQZrrkz,
  VPMOVSXDQrm,
  VPMOVSXDQrr,
  VPMOVSXWDYrm,
  VPMOVSXWDYrr,
  VPMOVSXWDZ128rm,
  VPMOVSXWDZ128rmk,
  VPMOVSXWDZ128rmkz,
  VPMOVSXWDZ128rr,
  VPMOVSXWDZ128rrk,
  VPMOVSXWDZ128rrkz,
  VPMOVSXWDZ256rm,
  VPMOVSXWDZ256rmk,
  VPMOVSXWDZ256rmkz,
  VPMOVSXWDZ256rr,
  VPMOVSXWDZ256rrk,
  VPMOVSXWDZ256rrkz,
  VPMOVSXWDZrm,
  VPMOVSXWDZrmk,
  VPMOVSXWDZrmkz,
  VPMOVSXWDZrr,
  VPMOVSXWDZrrk,
  VPMOVSXWDZrrkz,
  VPMOVSXWDrm,
  VPMOVSXWDrr,
  VPMOVSXWQYrm,
  VPMOVSXWQYrr,
  VPMOVSXWQZ128rm,
  VPMOVSXWQZ128rmk,
  VPMOVSXWQZ128rmkz,
  VPMOVSXWQZ128rr,
  VPMOVSXWQZ128rrk,
  VPMOVSXWQZ128rrkz,
  VPMOVSXWQZ256rm,
  VPMOVSXWQZ256rmk,
  VPMOVSXWQZ256rmkz,
  VPMOVSXWQZ256rr,
  VPMOVSXWQZ256rrk,
  VPMOVSXWQZ256rrkz,
  VPMOVSXWQZrm,
  VPMOVSXWQZrmk,
  VPMOVSXWQZrmkz,
  VPMOVSXWQZrr,
  VPMOVSXWQZrrk,
  VPMOVSXWQZrrkz,
  VPMOVSXWQrm,
  VPMOVSXWQrr,
  VPMOVUSDBZ128mr,
  VPMOVUSDBZ128mrk,
  VPMOVUSDBZ128rr,
  VPMOVUSDBZ128rrk,
  VPMOVUSDBZ128rrkz,
  VPMOVUSDBZ256mr,
  VPMOVUSDBZ256mrk,
  VPMOVUSDBZ256rr,
  VPMOVUSDBZ256rrk,
  VPMOVUSDBZ256rrkz,
  VPMOVUSDBZmr,
  VPMOVUSDBZmrk,
  VPMOVUSDBZrr,
  VPMOVUSDBZrrk,
  VPMOVUSDBZrrkz,
  VPMOVUSDWZ128mr,
  VPMOVUSDWZ128mrk,
  VPMOVUSDWZ128rr,
  VPMOVUSDWZ128rrk,
  VPMOVUSDWZ128rrkz,
  VPMOVUSDWZ256mr,
  VPMOVUSDWZ256mrk,
  VPMOVUSDWZ256rr,
  VPMOVUSDWZ256rrk,
  VPMOVUSDWZ256rrkz,
  VPMOVUSDWZmr,
  VPMOVUSDWZmrk,
  VPMOVUSDWZrr,
  VPMOVUSDWZrrk,
  VPMOVUSDWZrrkz,
  VPMOVUSQBZ128mr,
  VPMOVUSQBZ128mrk,
  VPMOVUSQBZ128rr,
  VPMOVUSQBZ128rrk,
  VPMOVUSQBZ128rrkz,
  VPMOVUSQBZ256mr,
  VPMOVUSQBZ256mrk,
  VPMOVUSQBZ256rr,
  VPMOVUSQBZ256rrk,
  VPMOVUSQBZ256rrkz,
  VPMOVUSQBZmr,
  VPMOVUSQBZmrk,
  VPMOVUSQBZrr,
  VPMOVUSQBZrrk,
  VPMOVUSQBZrrkz,
  VPMOVUSQDZ128mr,
  VPMOVUSQDZ128mrk,
  VPMOVUSQDZ128rr,
  VPMOVUSQDZ128rrk,
  VPMOVUSQDZ128rrkz,
  VPMOVUSQDZ256mr,
  VPMOVUSQDZ256mrk,
  VPMOVUSQDZ256rr,
  VPMOVUSQDZ256rrk,
  VPMOVUSQDZ256rrkz,
  VPMOVUSQDZmr,
  VPMOVUSQDZmrk,
  VPMOVUSQDZrr,
  VPMOVUSQDZrrk,
  VPMOVUSQDZrrkz,
  VPMOVUSQWZ128mr,
  VPMOVUSQWZ128mrk,
  VPMOVUSQWZ128rr,
  VPMOVUSQWZ128rrk,
  VPMOVUSQWZ128rrkz,
  VPMOVUSQWZ256mr,
  VPMOVUSQWZ256mrk,
  VPMOVUSQWZ256rr,
  VPMOVUSQWZ256rrk,
  VPMOVUSQWZ256rrkz,
  VPMOVUSQWZmr,
  VPMOVUSQWZmrk,
  VPMOVUSQWZrr,
  VPMOVUSQWZrrk,
  VPMOVUSQWZrrkz,
  VPMOVUSWBZ128mr,
  VPMOVUSWBZ128mrk,
  VPMOVUSWBZ128rr,
  VPMOVUSWBZ128rrk,
  VPMOVUSWBZ128rrkz,
  VPMOVUSWBZ256mr,
  VPMOVUSWBZ256mrk,
  VPMOVUSWBZ256rr,
  VPMOVUSWBZ256rrk,
  VPMOVUSWBZ256rrkz,
  VPMOVUSWBZmr,
  VPMOVUSWBZmrk,
  VPMOVUSWBZrr,
  VPMOVUSWBZrrk,
  VPMOVUSWBZrrkz,
  VPMOVW2MZ128rr,
  VPMOVW2MZ256rr,
  VPMOVW2MZrr,
  VPMOVWBZ128mr,
  VPMOVWBZ128mrk,
  VPMOVWBZ128rr,
  VPMOVWBZ128rrk,
  VPMOVWBZ128rrkz,
  VPMOVWBZ256mr,
  VPMOVWBZ256mrk,
  VPMOVWBZ256rr,
  VPMOVWBZ256rrk,
  VPMOVWBZ256rrkz,
  VPMOVWBZmr,
  VPMOVWBZmrk,
  VPMOVWBZrr,
  VPMOVWBZrrk,
  VPMOVWBZrrkz,
  VPMOVZXBDYrm,
  VPMOVZXBDYrr,
  VPMOVZXBDZ128rm,
  VPMOVZXBDZ128rmk,
  VPMOVZXBDZ128rmkz,
  VPMOVZXBDZ128rr,
  VPMOVZXBDZ128rrk,
  VPMOVZXBDZ128rrkz,
  VPMOVZXBDZ256rm,
  VPMOVZXBDZ256rmk,
  VPMOVZXBDZ256rmkz,
  VPMOVZXBDZ256rr,
  VPMOVZXBDZ256rrk,
  VPMOVZXBDZ256rrkz,
  VPMOVZXBDZrm,
  VPMOVZXBDZrmk,
  VPMOVZXBDZrmkz,
  VPMOVZXBDZrr,
  VPMOVZXBDZrrk,
  VPMOVZXBDZrrkz,
  VPMOVZXBDrm,
  VPMOVZXBDrr,
  VPMOVZXBQYrm,
  VPMOVZXBQYrr,
  VPMOVZXBQZ128rm,
  VPMOVZXBQZ128rmk,
  VPMOVZXBQZ128rmkz,
  VPMOVZXBQZ128rr,
  VPMOVZXBQZ128rrk,
  VPMOVZXBQZ128rrkz,
  VPMOVZXBQZ256rm,
  VPMOVZXBQZ256rmk,
  VPMOVZXBQZ256rmkz,
  VPMOVZXBQZ256rr,
  VPMOVZXBQZ256rrk,
  VPMOVZXBQZ256rrkz,
  VPMOVZXBQZrm,
  VPMOVZXBQZrmk,
  VPMOVZXBQZrmkz,
  VPMOVZXBQZrr,
  VPMOVZXBQZrrk,
  VPMOVZXBQZrrkz,
  VPMOVZXBQrm,
  VPMOVZXBQrr,
  VPMOVZXBWYrm,
  VPMOVZXBWYrr,
  VPMOVZXBWZ128rm,
  VPMOVZXBWZ128rmk,
  VPMOVZXBWZ128rmkz,
  VPMOVZXBWZ128rr,
  VPMOVZXBWZ128rrk,
  VPMOVZXBWZ128rrkz,
  VPMOVZXBWZ256rm,
  VPMOVZXBWZ256rmk,
  VPMOVZXBWZ256rmkz,
  VPMOVZXBWZ256rr,
  VPMOVZXBWZ256rrk,
  VPMOVZXBWZ256rrkz,
  VPMOVZXBWZrm,
  VPMOVZXBWZrmk,
  VPMOVZXBWZrmkz,
  VPMOVZXBWZrr,
  VPMOVZXBWZrrk,
  VPMOVZXBWZrrkz,
  VPMOVZXBWrm,
  VPMOVZXBWrr,
  VPMOVZXDQYrm,
  VPMOVZXDQYrr,
  VPMOVZXDQZ128rm,
  VPMOVZXDQZ128rmk,
  VPMOVZXDQZ128rmkz,
  VPMOVZXDQZ128rr,
  VPMOVZXDQZ128rrk,
  VPMOVZXDQZ128rrkz,
  VPMOVZXDQZ256rm,
  VPMOVZXDQZ256rmk,
  VPMOVZXDQZ256rmkz,
  VPMOVZXDQZ256rr,
  VPMOVZXDQZ256rrk,
  VPMOVZXDQZ256rrkz,
  VPMOVZXDQZrm,
  VPMOVZXDQZrmk,
  VPMOVZXDQZrmkz,
  VPMOVZXDQZrr,
  VPMOVZXDQZrrk,
  VPMOVZXDQZrrkz,
  VPMOVZXDQrm,
  VPMOVZXDQrr,
  VPMOVZXWDYrm,
  VPMOVZXWDYrr,
  VPMOVZXWDZ128rm,
  VPMOVZXWDZ128rmk,
  VPMOVZXWDZ128rmkz,
  VPMOVZXWDZ128rr,
  VPMOVZXWDZ128rrk,
  VPMOVZXWDZ128rrkz,
  VPMOVZXWDZ256rm,
  VPMOVZXWDZ256rmk,
  VPMOVZXWDZ256rmkz,
  VPMOVZXWDZ256rr,
  VPMOVZXWDZ256rrk,
  VPMOVZXWDZ256rrkz,
  VPMOVZXWDZrm,
  VPMOVZXWDZrmk,
  VPMOVZXWDZrmkz,
  VPMOVZXWDZrr,
  VPMOVZXWDZrrk,
  VPMOVZXWDZrrkz,
  VPMOVZXWDrm,
  VPMOVZXWDrr,
  VPMOVZXWQYrm,
  VPMOVZXWQYrr,
  VPMOVZXWQZ128rm,
  VPMOVZXWQZ128rmk,
  VPMOVZXWQZ128rmkz,
  VPMOVZXWQZ128rr,
  VPMOVZXWQZ128rrk,
  VPMOVZXWQZ128rrkz,
  VPMOVZXWQZ256rm,
  VPMOVZXWQZ256rmk,
  VPMOVZXWQZ256rmkz,
  VPMOVZXWQZ256rr,
  VPMOVZXWQZ256rrk,
  VPMOVZXWQZ256rrkz,
  VPMOVZXWQZrm,
  VPMOVZXWQZrmk,
  VPMOVZXWQZrmkz,
  VPMOVZXWQZrr,
  VPMOVZXWQZrrk,
  VPMOVZXWQZrrkz,
  VPMOVZXWQrm,
  VPMOVZXWQrr,
  VPMULDQYrm,
  VPMULDQYrr,
  VPMULDQZ128rm,
  VPMULDQZ128rmb,
  VPMULDQZ128rmbk,
  VPMULDQZ128rmbkz,
  VPMULDQZ128rmk,
  VPMULDQZ128rmkz,
  VPMULDQZ128rr,
  VPMULDQZ128rrk,
  VPMULDQZ128rrkz,
  VPMULDQZ256rm,
  VPMULDQZ256rmb,
  VPMULDQZ256rmbk,
  VPMULDQZ256rmbkz,
  VPMULDQZ256rmk,
  VPMULDQZ256rmkz,
  VPMULDQZ256rr,
  VPMULDQZ256rrk,
  VPMULDQZ256rrkz,
  VPMULDQZrm,
  VPMULDQZrmb,
  VPMULDQZrmbk,
  VPMULDQZrmbkz,
  VPMULDQZrmk,
  VPMULDQZrmkz,
  VPMULDQZrr,
  VPMULDQZrrk,
  VPMULDQZrrkz,
  VPMULDQrm,
  VPMULDQrr,
  VPMULHRSWYrm,
  VPMULHRSWYrr,
  VPMULHRSWZ128rm,
  VPMULHRSWZ128rmk,
  VPMULHRSWZ128rmkz,
  VPMULHRSWZ128rr,
  VPMULHRSWZ128rrk,
  VPMULHRSWZ128rrkz,
  VPMULHRSWZ256rm,
  VPMULHRSWZ256rmk,
  VPMULHRSWZ256rmkz,
  VPMULHRSWZ256rr,
  VPMULHRSWZ256rrk,
  VPMULHRSWZ256rrkz,
  VPMULHRSWZrm,
  VPMULHRSWZrmk,
  VPMULHRSWZrmkz,
  VPMULHRSWZrr,
  VPMULHRSWZrrk,
  VPMULHRSWZrrkz,
  VPMULHRSWrm,
  VPMULHRSWrr,
  VPMULHUWYrm,
  VPMULHUWYrr,
  VPMULHUWZ128rm,
  VPMULHUWZ128rmk,
  VPMULHUWZ128rmkz,
  VPMULHUWZ128rr,
  VPMULHUWZ128rrk,
  VPMULHUWZ128rrkz,
  VPMULHUWZ256rm,
  VPMULHUWZ256rmk,
  VPMULHUWZ256rmkz,
  VPMULHUWZ256rr,
  VPMULHUWZ256rrk,
  VPMULHUWZ256rrkz,
  VPMULHUWZrm,
  VPMULHUWZrmk,
  VPMULHUWZrmkz,
  VPMULHUWZrr,
  VPMULHUWZrrk,
  VPMULHUWZrrkz,
  VPMULHUWrm,
  VPMULHUWrr,
  VPMULHWYrm,
  VPMULHWYrr,
  VPMULHWZ128rm,
  VPMULHWZ128rmk,
  VPMULHWZ128rmkz,
  VPMULHWZ128rr,
  VPMULHWZ128rrk,
  VPMULHWZ128rrkz,
  VPMULHWZ256rm,
  VPMULHWZ256rmk,
  VPMULHWZ256rmkz,
  VPMULHWZ256rr,
  VPMULHWZ256rrk,
  VPMULHWZ256rrkz,
  VPMULHWZrm,
  VPMULHWZrmk,
  VPMULHWZrmkz,
  VPMULHWZrr,
  VPMULHWZrrk,
  VPMULHWZrrkz,
  VPMULHWrm,
  VPMULHWrr,
  VPMULLDYrm,
  VPMULLDYrr,
  VPMULLDZ128rm,
  VPMULLDZ128rmb,
  VPMULLDZ128rmbk,
  VPMULLDZ128rmbkz,
  VPMULLDZ128rmk,
  VPMULLDZ128rmkz,
  VPMULLDZ128rr,
  VPMULLDZ128rrk,
  VPMULLDZ128rrkz,
  VPMULLDZ256rm,
  VPMULLDZ256rmb,
  VPMULLDZ256rmbk,
  VPMULLDZ256rmbkz,
  VPMULLDZ256rmk,
  VPMULLDZ256rmkz,
  VPMULLDZ256rr,
  VPMULLDZ256rrk,
  VPMULLDZ256rrkz,
  VPMULLDZrm,
  VPMULLDZrmb,
  VPMULLDZrmbk,
  VPMULLDZrmbkz,
  VPMULLDZrmk,
  VPMULLDZrmkz,
  VPMULLDZrr,
  VPMULLDZrrk,
  VPMULLDZrrkz,
  VPMULLDrm,
  VPMULLDrr,
  VPMULLQZ128rm,
  VPMULLQZ128rmb,
  VPMULLQZ128rmbk,
  VPMULLQZ128rmbkz,
  VPMULLQZ128rmk,
  VPMULLQZ128rmkz,
  VPMULLQZ128rr,
  VPMULLQZ128rrk,
  VPMULLQZ128rrkz,
  VPMULLQZ256rm,
  VPMULLQZ256rmb,
  VPMULLQZ256rmbk,
  VPMULLQZ256rmbkz,
  VPMULLQZ256rmk,
  VPMULLQZ256rmkz,
  VPMULLQZ256rr,
  VPMULLQZ256rrk,
  VPMULLQZ256rrkz,
  VPMULLQZrm,
  VPMULLQZrmb,
  VPMULLQZrmbk,
  VPMULLQZrmbkz,
  VPMULLQZrmk,
  VPMULLQZrmkz,
  VPMULLQZrr,
  VPMULLQZrrk,
  VPMULLQZrrkz,
  VPMULLWYrm,
  VPMULLWYrr,
  VPMULLWZ128rm,
  VPMULLWZ128rmk,
  VPMULLWZ128rmkz,
  VPMULLWZ128rr,
  VPMULLWZ128rrk,
  VPMULLWZ128rrkz,
  VPMULLWZ256rm,
  VPMULLWZ256rmk,
  VPMULLWZ256rmkz,
  VPMULLWZ256rr,
  VPMULLWZ256rrk,
  VPMULLWZ256rrkz,
  VPMULLWZrm,
  VPMULLWZrmk,
  VPMULLWZrmkz,
  VPMULLWZrr,
  VPMULLWZrrk,
  VPMULLWZrrkz,
  VPMULLWrm,
  VPMULLWrr,
  VPMULTISHIFTQBZ128rm,
  VPMULTISHIFTQBZ128rmb,
  VPMULTISHIFTQBZ128rmbk,
  VPMULTISHIFTQBZ128rmbkz,
  VPMULTISHIFTQBZ128rmk,
  VPMULTISHIFTQBZ128rmkz,
  VPMULTISHIFTQBZ128rr,
  VPMULTISHIFTQBZ128rrk,
  VPMULTISHIFTQBZ128rrkz,
  VPMULTISHIFTQBZ256rm,
  VPMULTISHIFTQBZ256rmb,
  VPMULTISHIFTQBZ256rmbk,
  VPMULTISHIFTQBZ256rmbkz,
  VPMULTISHIFTQBZ256rmk,
  VPMULTISHIFTQBZ256rmkz,
  VPMULTISHIFTQBZ256rr,
  VPMULTISHIFTQBZ256rrk,
  VPMULTISHIFTQBZ256rrkz,
  VPMULTISHIFTQBZrm,
  VPMULTISHIFTQBZrmb,
  VPMULTISHIFTQBZrmbk,
  VPMULTISHIFTQBZrmbkz,
  VPMULTISHIFTQBZrmk,
  VPMULTISHIFTQBZrmkz,
  VPMULTISHIFTQBZrr,
  VPMULTISHIFTQBZrrk,
  VPMULTISHIFTQBZrrkz,
  VPMULUDQYrm,
  VPMULUDQYrr,
  VPMULUDQZ128rm,
  VPMULUDQZ128rmb,
  VPMULUDQZ128rmbk,
  VPMULUDQZ128rmbkz,
  VPMULUDQZ128rmk,
  VPMULUDQZ128rmkz,
  VPMULUDQZ128rr,
  VPMULUDQZ128rrk,
  VPMULUDQZ128rrkz,
  VPMULUDQZ256rm,
  VPMULUDQZ256rmb,
  VPMULUDQZ256rmbk,
  VPMULUDQZ256rmbkz,
  VPMULUDQZ256rmk,
  VPMULUDQZ256rmkz,
  VPMULUDQZ256rr,
  VPMULUDQZ256rrk,
  VPMULUDQZ256rrkz,
  VPMULUDQZrm,
  VPMULUDQZrmb,
  VPMULUDQZrmbk,
  VPMULUDQZrmbkz,
  VPMULUDQZrmk,
  VPMULUDQZrmkz,
  VPMULUDQZrr,
  VPMULUDQZrrk,
  VPMULUDQZrrkz,
  VPMULUDQrm,
  VPMULUDQrr,
  VPOPCNTBZ128rm,
  VPOPCNTBZ128rmk,
  VPOPCNTBZ128rmkz,
  VPOPCNTBZ128rr,
  VPOPCNTBZ128rrk,
  VPOPCNTBZ128rrkz,
  VPOPCNTBZ256rm,
  VPOPCNTBZ256rmk,
  VPOPCNTBZ256rmkz,
  VPOPCNTBZ256rr,
  VPOPCNTBZ256rrk,
  VPOPCNTBZ256rrkz,
  VPOPCNTBZrm,
  VPOPCNTBZrmk,
  VPOPCNTBZrmkz,
  VPOPCNTBZrr,
  VPOPCNTBZrrk,
  VPOPCNTBZrrkz,
  VPOPCNTDZ128rm,
  VPOPCNTDZ128rmb,
  VPOPCNTDZ128rmbk,
  VPOPCNTDZ128rmbkz,
  VPOPCNTDZ128rmk,
  VPOPCNTDZ128rmkz,
  VPOPCNTDZ128rr,
  VPOPCNTDZ128rrk,
  VPOPCNTDZ128rrkz,
  VPOPCNTDZ256rm,
  VPOPCNTDZ256rmb,
  VPOPCNTDZ256rmbk,
  VPOPCNTDZ256rmbkz,
  VPOPCNTDZ256rmk,
  VPOPCNTDZ256rmkz,
  VPOPCNTDZ256rr,
  VPOPCNTDZ256rrk,
  VPOPCNTDZ256rrkz,
  VPOPCNTDZrm,
  VPOPCNTDZrmb,
  VPOPCNTDZrmbk,
  VPOPCNTDZrmbkz,
  VPOPCNTDZrmk,
  VPOPCNTDZrmkz,
  VPOPCNTDZrr,
  VPOPCNTDZrrk,
  VPOPCNTDZrrkz,
  VPOPCNTQZ128rm,
  VPOPCNTQZ128rmb,
  VPOPCNTQZ128rmbk,
  VPOPCNTQZ128rmbkz,
  VPOPCNTQZ128rmk,
  VPOPCNTQZ128rmkz,
  VPOPCNTQZ128rr,
  VPOPCNTQZ128rrk,
  VPOPCNTQZ128rrkz,
  VPOPCNTQZ256rm,
  VPOPCNTQZ256rmb,
  VPOPCNTQZ256rmbk,
  VPOPCNTQZ256rmbkz,
  VPOPCNTQZ256rmk,
  VPOPCNTQZ256rmkz,
  VPOPCNTQZ256rr,
  VPOPCNTQZ256rrk,
  VPOPCNTQZ256rrkz,
  VPOPCNTQZrm,
  VPOPCNTQZrmb,
  VPOPCNTQZrmbk,
  VPOPCNTQZrmbkz,
  VPOPCNTQZrmk,
  VPOPCNTQZrmkz,
  VPOPCNTQZrr,
  VPOPCNTQZrrk,
  VPOPCNTQZrrkz,
  VPOPCNTWZ128rm,
  VPOPCNTWZ128rmk,
  VPOPCNTWZ128rmkz,
  VPOPCNTWZ128rr,
  VPOPCNTWZ128rrk,
  VPOPCNTWZ128rrkz,
  VPOPCNTWZ256rm,
  VPOPCNTWZ256rmk,
  VPOPCNTWZ256rmkz,
  VPOPCNTWZ256rr,
  VPOPCNTWZ256rrk,
  VPOPCNTWZ256rrkz,
  VPOPCNTWZrm,
  VPOPCNTWZrmk,
  VPOPCNTWZrmkz,
  VPOPCNTWZrr,
  VPOPCNTWZrrk,
  VPOPCNTWZrrkz,
  VPORDZ128rm,
  VPORDZ128rmb,
  VPORDZ128rmbk,
  VPORDZ128rmbkz,
  VPORDZ128rmk,
  VPORDZ128rmkz,
  VPORDZ128rr,
  VPORDZ128rrk,
  VPORDZ128rrkz,
  VPORDZ256rm,
  VPORDZ256rmb,
  VPORDZ256rmbk,
  VPORDZ256rmbkz,
  VPORDZ256rmk,
  VPORDZ256rmkz,
  VPORDZ256rr,
  VPORDZ256rrk,
  VPORDZ256rrkz,
  VPORDZrm,
  VPORDZrmb,
  VPORDZrmbk,
  VPORDZrmbkz,
  VPORDZrmk,
  VPORDZrmkz,
  VPORDZrr,
  VPORDZrrk,
  VPORDZrrkz,
  VPORQZ128rm,
  VPORQZ128rmb,
  VPORQZ128rmbk,
  VPORQZ128rmbkz,
  VPORQZ128rmk,
  VPORQZ128rmkz,
  VPORQZ128rr,
  VPORQZ128rrk,
  VPORQZ128rrkz,
  VPORQZ256rm,
  VPORQZ256rmb,
  VPORQZ256rmbk,
  VPORQZ256rmbkz,
  VPORQZ256rmk,
  VPORQZ256rmkz,
  VPORQZ256rr,
  VPORQZ256rrk,
  VPORQZ256rrkz,
  VPORQZrm,
  VPORQZrmb,
  VPORQZrmbk,
  VPORQZrmbkz,
  VPORQZrmk,
  VPORQZrmkz,
  VPORQZrr,
  VPORQZrrk,
  VPORQZrrkz,
  VPORYrm,
  VPORYrr,
  VPORrm,
  VPORrr,
  VPPERMrmr,
  VPPERMrrm,
  VPPERMrrr,
  VPPERMrrr_REV,
  VPROLDZ128mbi,
  VPROLDZ128mbik,
  VPROLDZ128mbikz,
  VPROLDZ128mi,
  VPROLDZ128mik,
  VPROLDZ128mikz,
  VPROLDZ128ri,
  VPROLDZ128rik,
  VPROLDZ128rikz,
  VPROLDZ256mbi,
  VPROLDZ256mbik,
  VPROLDZ256mbikz,
  VPROLDZ256mi,
  VPROLDZ256mik,
  VPROLDZ256mikz,
  VPROLDZ256ri,
  VPROLDZ256rik,
  VPROLDZ256rikz,
  VPROLDZmbi,
  VPROLDZmbik,
  VPROLDZmbikz,
  VPROLDZmi,
  VPROLDZmik,
  VPROLDZmikz,
  VPROLDZri,
  VPROLDZrik,
  VPROLDZrikz,
  VPROLQZ128mbi,
  VPROLQZ128mbik,
  VPROLQZ128mbikz,
  VPROLQZ128mi,
  VPROLQZ128mik,
  VPROLQZ128mikz,
  VPROLQZ128ri,
  VPROLQZ128rik,
  VPROLQZ128rikz,
  VPROLQZ256mbi,
  VPROLQZ256mbik,
  VPROLQZ256mbikz,
  VPROLQZ256mi,
  VPROLQZ256mik,
  VPROLQZ256mikz,
  VPROLQZ256ri,
  VPROLQZ256rik,
  VPROLQZ256rikz,
  VPROLQZmbi,
  VPROLQZmbik,
  VPROLQZmbikz,
  VPROLQZmi,
  VPROLQZmik,
  VPROLQZmikz,
  VPROLQZri,
  VPROLQZrik,
  VPROLQZrikz,
  VPROLVDZ128rm,
  VPROLVDZ128rmb,
  VPROLVDZ128rmbk,
  VPROLVDZ128rmbkz,
  VPROLVDZ128rmk,
  VPROLVDZ128rmkz,
  VPROLVDZ128rr,
  VPROLVDZ128rrk,
  VPROLVDZ128rrkz,
  VPROLVDZ256rm,
  VPROLVDZ256rmb,
  VPROLVDZ256rmbk,
  VPROLVDZ256rmbkz,
  VPROLVDZ256rmk,
  VPROLVDZ256rmkz,
  VPROLVDZ256rr,
  VPROLVDZ256rrk,
  VPROLVDZ256rrkz,
  VPROLVDZrm,
  VPROLVDZrmb,
  VPROLVDZrmbk,
  VPROLVDZrmbkz,
  VPROLVDZrmk,
  VPROLVDZrmkz,
  VPROLVDZrr,
  VPROLVDZrrk,
  VPROLVDZrrkz,
  VPROLVQZ128rm,
  VPROLVQZ128rmb,
  VPROLVQZ128rmbk,
  VPROLVQZ128rmbkz,
  VPROLVQZ128rmk,
  VPROLVQZ128rmkz,
  VPROLVQZ128rr,
  VPROLVQZ128rrk,
  VPROLVQZ128rrkz,
  VPROLVQZ256rm,
  VPROLVQZ256rmb,
  VPROLVQZ256rmbk,
  VPROLVQZ256rmbkz,
  VPROLVQZ256rmk,
  VPROLVQZ256rmkz,
  VPROLVQZ256rr,
  VPROLVQZ256rrk,
  VPROLVQZ256rrkz,
  VPROLVQZrm,
  VPROLVQZrmb,
  VPROLVQZrmbk,
  VPROLVQZrmbkz,
  VPROLVQZrmk,
  VPROLVQZrmkz,
  VPROLVQZrr,
  VPROLVQZrrk,
  VPROLVQZrrkz,
  VPRORDZ128mbi,
  VPRORDZ128mbik,
  VPRORDZ128mbikz,
  VPRORDZ128mi,
  VPRORDZ128mik,
  VPRORDZ128mikz,
  VPRORDZ128ri,
  VPRORDZ128rik,
  VPRORDZ128rikz,
  VPRORDZ256mbi,
  VPRORDZ256mbik,
  VPRORDZ256mbikz,
  VPRORDZ256mi,
  VPRORDZ256mik,
  VPRORDZ256mikz,
  VPRORDZ256ri,
  VPRORDZ256rik,
  VPRORDZ256rikz,
  VPRORDZmbi,
  VPRORDZmbik,
  VPRORDZmbikz,
  VPRORDZmi,
  VPRORDZmik,
  VPRORDZmikz,
  VPRORDZri,
  VPRORDZrik,
  VPRORDZrikz,
  VPRORQZ128mbi,
  VPRORQZ128mbik,
  VPRORQZ128mbikz,
  VPRORQZ128mi,
  VPRORQZ128mik,
  VPRORQZ128mikz,
  VPRORQZ128ri,
  VPRORQZ128rik,
  VPRORQZ128rikz,
  VPRORQZ256mbi,
  VPRORQZ256mbik,
  VPRORQZ256mbikz,
  VPRORQZ256mi,
  VPRORQZ256mik,
  VPRORQZ256mikz,
  VPRORQZ256ri,
  VPRORQZ256rik,
  VPRORQZ256rikz,
  VPRORQZmbi,
  VPRORQZmbik,
  VPRORQZmbikz,
  VPRORQZmi,
  VPRORQZmik,
  VPRORQZmikz,
  VPRORQZri,
  VPRORQZrik,
  VPRORQZrikz,
  VPRORVDZ128rm,
  VPRORVDZ128rmb,
  VPRORVDZ128rmbk,
  VPRORVDZ128rmbkz,
  VPRORVDZ128rmk,
  VPRORVDZ128rmkz,
  VPRORVDZ128rr,
  VPRORVDZ128rrk,
  VPRORVDZ128rrkz,
  VPRORVDZ256rm,
  VPRORVDZ256rmb,
  VPRORVDZ256rmbk,
  VPRORVDZ256rmbkz,
  VPRORVDZ256rmk,
  VPRORVDZ256rmkz,
  VPRORVDZ256rr,
  VPRORVDZ256rrk,
  VPRORVDZ256rrkz,
  VPRORVDZrm,
  VPRORVDZrmb,
  VPRORVDZrmbk,
  VPRORVDZrmbkz,
  VPRORVDZrmk,
  VPRORVDZrmkz,
  VPRORVDZrr,
  VPRORVDZrrk,
  VPRORVDZrrkz,
  VPRORVQZ128rm,
  VPRORVQZ128rmb,
  VPRORVQZ128rmbk,
  VPRORVQZ128rmbkz,
  VPRORVQZ128rmk,
  VPRORVQZ128rmkz,
  VPRORVQZ128rr,
  VPRORVQZ128rrk,
  VPRORVQZ128rrkz,
  VPRORVQZ256rm,
  VPRORVQZ256rmb,
  VPRORVQZ256rmbk,
  VPRORVQZ256rmbkz,
  VPRORVQZ256rmk,
  VPRORVQZ256rmkz,
  VPRORVQZ256rr,
  VPRORVQZ256rrk,
  VPRORVQZ256rrkz,
  VPRORVQZrm,
  VPRORVQZrmb,
  VPRORVQZrmbk,
  VPRORVQZrmbkz,
  VPRORVQZrmk,
  VPRORVQZrmkz,
  VPRORVQZrr,
  VPRORVQZrrk,
  VPRORVQZrrkz,
  VPROTBmi,
  VPROTBmr,
  VPROTBri,
  VPROTBrm,
  VPROTBrr,
  VPROTBrr_REV,
  VPROTDmi,
  VPROTDmr,
  VPROTDri,
  VPROTDrm,
  VPROTDrr,
  VPROTDrr_REV,
  VPROTQmi,
  VPROTQmr,
  VPROTQri,
  VPROTQrm,
  VPROTQrr,
  VPROTQrr_REV,
  VPROTWmi,
  VPROTWmr,
  VPROTWri,
  VPROTWrm,
  VPROTWrr,
  VPROTWrr_REV,
  VPSADBWYrm,
  VPSADBWYrr,
  VPSADBWZ128rm,
  VPSADBWZ128rr,
  VPSADBWZ256rm,
  VPSADBWZ256rr,
  VPSADBWZrm,
  VPSADBWZrr,
  VPSADBWrm,
  VPSADBWrr,
  VPSCATTERDDZ128mr,
  VPSCATTERDDZ256mr,
  VPSCATTERDDZmr,
  VPSCATTERDQZ128mr,
  VPSCATTERDQZ256mr,
  VPSCATTERDQZmr,
  VPSCATTERQDZ128mr,
  VPSCATTERQDZ256mr,
  VPSCATTERQDZmr,
  VPSCATTERQQZ128mr,
  VPSCATTERQQZ256mr,
  VPSCATTERQQZmr,
  VPSHABmr,
  VPSHABrm,
  VPSHABrr,
  VPSHABrr_REV,
  VPSHADmr,
  VPSHADrm,
  VPSHADrr,
  VPSHADrr_REV,
  VPSHAQmr,
  VPSHAQrm,
  VPSHAQrr,
  VPSHAQrr_REV,
  VPSHAWmr,
  VPSHAWrm,
  VPSHAWrr,
  VPSHAWrr_REV,
  VPSHLBmr,
  VPSHLBrm,
  VPSHLBrr,
  VPSHLBrr_REV,
  VPSHLDDZ128rmbi,
  VPSHLDDZ128rmbik,
  VPSHLDDZ128rmbikz,
  VPSHLDDZ128rmi,
  VPSHLDDZ128rmik,
  VPSHLDDZ128rmikz,
  VPSHLDDZ128rri,
  VPSHLDDZ128rrik,
  VPSHLDDZ128rrikz,
  VPSHLDDZ256rmbi,
  VPSHLDDZ256rmbik,
  VPSHLDDZ256rmbikz,
  VPSHLDDZ256rmi,
  VPSHLDDZ256rmik,
  VPSHLDDZ256rmikz,
  VPSHLDDZ256rri,
  VPSHLDDZ256rrik,
  VPSHLDDZ256rrikz,
  VPSHLDDZrmbi,
  VPSHLDDZrmbik,
  VPSHLDDZrmbikz,
  VPSHLDDZrmi,
  VPSHLDDZrmik,
  VPSHLDDZrmikz,
  VPSHLDDZrri,
  VPSHLDDZrrik,
  VPSHLDDZrrikz,
  VPSHLDQZ128rmbi,
  VPSHLDQZ128rmbik,
  VPSHLDQZ128rmbikz,
  VPSHLDQZ128rmi,
  VPSHLDQZ128rmik,
  VPSHLDQZ128rmikz,
  VPSHLDQZ128rri,
  VPSHLDQZ128rrik,
  VPSHLDQZ128rrikz,
  VPSHLDQZ256rmbi,
  VPSHLDQZ256rmbik,
  VPSHLDQZ256rmbikz,
  VPSHLDQZ256rmi,
  VPSHLDQZ256rmik,
  VPSHLDQZ256rmikz,
  VPSHLDQZ256rri,
  VPSHLDQZ256rrik,
  VPSHLDQZ256rrikz,
  VPSHLDQZrmbi,
  VPSHLDQZrmbik,
  VPSHLDQZrmbikz,
  VPSHLDQZrmi,
  VPSHLDQZrmik,
  VPSHLDQZrmikz,
  VPSHLDQZrri,
  VPSHLDQZrrik,
  VPSHLDQZrrikz,
  VPSHLDVDZ128m,
  VPSHLDVDZ128mb,
  VPSHLDVDZ128mbk,
  VPSHLDVDZ128mbkz,
  VPSHLDVDZ128mk,
  VPSHLDVDZ128mkz,
  VPSHLDVDZ128r,
  VPSHLDVDZ128rk,
  VPSHLDVDZ128rkz,
  VPSHLDVDZ256m,
  VPSHLDVDZ256mb,
  VPSHLDVDZ256mbk,
  VPSHLDVDZ256mbkz,
  VPSHLDVDZ256mk,
  VPSHLDVDZ256mkz,
  VPSHLDVDZ256r,
  VPSHLDVDZ256rk,
  VPSHLDVDZ256rkz,
  VPSHLDVDZm,
  VPSHLDVDZmb,
  VPSHLDVDZmbk,
  VPSHLDVDZmbkz,
  VPSHLDVDZmk,
  VPSHLDVDZmkz,
  VPSHLDVDZr,
  VPSHLDVDZrk,
  VPSHLDVDZrkz,
  VPSHLDVQZ128m,
  VPSHLDVQZ128mb,
  VPSHLDVQZ128mbk,
  VPSHLDVQZ128mbkz,
  VPSHLDVQZ128mk,
  VPSHLDVQZ128mkz,
  VPSHLDVQZ128r,
  VPSHLDVQZ128rk,
  VPSHLDVQZ128rkz,
  VPSHLDVQZ256m,
  VPSHLDVQZ256mb,
  VPSHLDVQZ256mbk,
  VPSHLDVQZ256mbkz,
  VPSHLDVQZ256mk,
  VPSHLDVQZ256mkz,
  VPSHLDVQZ256r,
  VPSHLDVQZ256rk,
  VPSHLDVQZ256rkz,
  VPSHLDVQZm,
  VPSHLDVQZmb,
  VPSHLDVQZmbk,
  VPSHLDVQZmbkz,
  VPSHLDVQZmk,
  VPSHLDVQZmkz,
  VPSHLDVQZr,
  VPSHLDVQZrk,
  VPSHLDVQZrkz,
  VPSHLDVWZ128m,
  VPSHLDVWZ128mk,
  VPSHLDVWZ128mkz,
  VPSHLDVWZ128r,
  VPSHLDVWZ128rk,
  VPSHLDVWZ128rkz,
  VPSHLDVWZ256m,
  VPSHLDVWZ256mk,
  VPSHLDVWZ256mkz,
  VPSHLDVWZ256r,
  VPSHLDVWZ256rk,
  VPSHLDVWZ256rkz,
  VPSHLDVWZm,
  VPSHLDVWZmk,
  VPSHLDVWZmkz,
  VPSHLDVWZr,
  VPSHLDVWZrk,
  VPSHLDVWZrkz,
  VPSHLDWZ128rmi,
  VPSHLDWZ128rmik,
  VPSHLDWZ128rmikz,
  VPSHLDWZ128rri,
  VPSHLDWZ128rrik,
  VPSHLDWZ128rrikz,
  VPSHLDWZ256rmi,
  VPSHLDWZ256rmik,
  VPSHLDWZ256rmikz,
  VPSHLDWZ256rri,
  VPSHLDWZ256rrik,
  VPSHLDWZ256rrikz,
  VPSHLDWZrmi,
  VPSHLDWZrmik,
  VPSHLDWZrmikz,
  VPSHLDWZrri,
  VPSHLDWZrrik,
  VPSHLDWZrrikz,
  VPSHLDmr,
  VPSHLDrm,
  VPSHLDrr,
  VPSHLDrr_REV,
  VPSHLQmr,
  VPSHLQrm,
  VPSHLQrr,
  VPSHLQrr_REV,
  VPSHLWmr,
  VPSHLWrm,
  VPSHLWrr,
  VPSHLWrr_REV,
  VPSHRDDZ128rmbi,
  VPSHRDDZ128rmbik,
  VPSHRDDZ128rmbikz,
  VPSHRDDZ128rmi,
  VPSHRDDZ128rmik,
  VPSHRDDZ128rmikz,
  VPSHRDDZ128rri,
  VPSHRDDZ128rrik,
  VPSHRDDZ128rrikz,
  VPSHRDDZ256rmbi,
  VPSHRDDZ256rmbik,
  VPSHRDDZ256rmbikz,
  VPSHRDDZ256rmi,
  VPSHRDDZ256rmik,
  VPSHRDDZ256rmikz,
  VPSHRDDZ256rri,
  VPSHRDDZ256rrik,
  VPSHRDDZ256rrikz,
  VPSHRDDZrmbi,
  VPSHRDDZrmbik,
  VPSHRDDZrmbikz,
  VPSHRDDZrmi,
  VPSHRDDZrmik,
  VPSHRDDZrmikz,
  VPSHRDDZrri,
  VPSHRDDZrrik,
  VPSHRDDZrrikz,
  VPSHRDQZ128rmbi,
  VPSHRDQZ128rmbik,
  VPSHRDQZ128rmbikz,
  VPSHRDQZ128rmi,
  VPSHRDQZ128rmik,
  VPSHRDQZ128rmikz,
  VPSHRDQZ128rri,
  VPSHRDQZ128rrik,
  VPSHRDQZ128rrikz,
  VPSHRDQZ256rmbi,
  VPSHRDQZ256rmbik,
  VPSHRDQZ256rmbikz,
  VPSHRDQZ256rmi,
  VPSHRDQZ256rmik,
  VPSHRDQZ256rmikz,
  VPSHRDQZ256rri,
  VPSHRDQZ256rrik,
  VPSHRDQZ256rrikz,
  VPSHRDQZrmbi,
  VPSHRDQZrmbik,
  VPSHRDQZrmbikz,
  VPSHRDQZrmi,
  VPSHRDQZrmik,
  VPSHRDQZrmikz,
  VPSHRDQZrri,
  VPSHRDQZrrik,
  VPSHRDQZrrikz,
  VPSHRDVDZ128m,
  VPSHRDVDZ128mb,
  VPSHRDVDZ128mbk,
  VPSHRDVDZ128mbkz,
  VPSHRDVDZ128mk,
  VPSHRDVDZ128mkz,
  VPSHRDVDZ128r,
  VPSHRDVDZ128rk,
  VPSHRDVDZ128rkz,
  VPSHRDVDZ256m,
  VPSHRDVDZ256mb,
  VPSHRDVDZ256mbk,
  VPSHRDVDZ256mbkz,
  VPSHRDVDZ256mk,
  VPSHRDVDZ256mkz,
  VPSHRDVDZ256r,
  VPSHRDVDZ256rk,
  VPSHRDVDZ256rkz,
  VPSHRDVDZm,
  VPSHRDVDZmb,
  VPSHRDVDZmbk,
  VPSHRDVDZmbkz,
  VPSHRDVDZmk,
  VPSHRDVDZmkz,
  VPSHRDVDZr,
  VPSHRDVDZrk,
  VPSHRDVDZrkz,
  VPSHRDVQZ128m,
  VPSHRDVQZ128mb,
  VPSHRDVQZ128mbk,
  VPSHRDVQZ128mbkz,
  VPSHRDVQZ128mk,
  VPSHRDVQZ128mkz,
  VPSHRDVQZ128r,
  VPSHRDVQZ128rk,
  VPSHRDVQZ128rkz,
  VPSHRDVQZ256m,
  VPSHRDVQZ256mb,
  VPSHRDVQZ256mbk,
  VPSHRDVQZ256mbkz,
  VPSHRDVQZ256mk,
  VPSHRDVQZ256mkz,
  VPSHRDVQZ256r,
  VPSHRDVQZ256rk,
  VPSHRDVQZ256rkz,
  VPSHRDVQZm,
  VPSHRDVQZmb,
  VPSHRDVQZmbk,
  VPSHRDVQZmbkz,
  VPSHRDVQZmk,
  VPSHRDVQZmkz,
  VPSHRDVQZr,
  VPSHRDVQZrk,
  VPSHRDVQZrkz,
  VPSHRDVWZ128m,
  VPSHRDVWZ128mk,
  VPSHRDVWZ128mkz,
  VPSHRDVWZ128r,
  VPSHRDVWZ128rk,
  VPSHRDVWZ128rkz,
  VPSHRDVWZ256m,
  VPSHRDVWZ256mk,
  VPSHRDVWZ256mkz,
  VPSHRDVWZ256r,
  VPSHRDVWZ256rk,
  VPSHRDVWZ256rkz,
  VPSHRDVWZm,
  VPSHRDVWZmk,
  VPSHRDVWZmkz,
  VPSHRDVWZr,
  VPSHRDVWZrk,
  VPSHRDVWZrkz,
  VPSHRDWZ128rmi,
  VPSHRDWZ128rmik,
  VPSHRDWZ128rmikz,
  VPSHRDWZ128rri,
  VPSHRDWZ128rrik,
  VPSHRDWZ128rrikz,
  VPSHRDWZ256rmi,
  VPSHRDWZ256rmik,
  VPSHRDWZ256rmikz,
  VPSHRDWZ256rri,
  VPSHRDWZ256rrik,
  VPSHRDWZ256rrikz,
  VPSHRDWZrmi,
  VPSHRDWZrmik,
  VPSHRDWZrmikz,
  VPSHRDWZrri,
  VPSHRDWZrrik,
  VPSHRDWZrrikz,
  VPSHUFBITQMBZ128rm,
  VPSHUFBITQMBZ128rmk,
  VPSHUFBITQMBZ128rr,
  VPSHUFBITQMBZ128rrk,
  VPSHUFBITQMBZ256rm,
  VPSHUFBITQMBZ256rmk,
  VPSHUFBITQMBZ256rr,
  VPSHUFBITQMBZ256rrk,
  VPSHUFBITQMBZrm,
  VPSHUFBITQMBZrmk,
  VPSHUFBITQMBZrr,
  VPSHUFBITQMBZrrk,
  VPSHUFBYrm,
  VPSHUFBYrr,
  VPSHUFBZ128rm,
  VPSHUFBZ128rmk,
  VPSHUFBZ128rmkz,
  VPSHUFBZ128rr,
  VPSHUFBZ128rrk,
  VPSHUFBZ128rrkz,
  VPSHUFBZ256rm,
  VPSHUFBZ256rmk,
  VPSHUFBZ256rmkz,
  VPSHUFBZ256rr,
  VPSHUFBZ256rrk,
  VPSHUFBZ256rrkz,
  VPSHUFBZrm,
  VPSHUFBZrmk,
  VPSHUFBZrmkz,
  VPSHUFBZrr,
  VPSHUFBZrrk,
  VPSHUFBZrrkz,
  VPSHUFBrm,
  VPSHUFBrr,
  VPSHUFDYmi,
  VPSHUFDYri,
  VPSHUFDZ128mbi,
  VPSHUFDZ128mbik,
  VPSHUFDZ128mbikz,
  VPSHUFDZ128mi,
  VPSHUFDZ128mik,
  VPSHUFDZ128mikz,
  VPSHUFDZ128ri,
  VPSHUFDZ128rik,
  VPSHUFDZ128rikz,
  VPSHUFDZ256mbi,
  VPSHUFDZ256mbik,
  VPSHUFDZ256mbikz,
  VPSHUFDZ256mi,
  VPSHUFDZ256mik,
  VPSHUFDZ256mikz,
  VPSHUFDZ256ri,
  VPSHUFDZ256rik,
  VPSHUFDZ256rikz,
  VPSHUFDZmbi,
  VPSHUFDZmbik,
  VPSHUFDZmbikz,
  VPSHUFDZmi,
  VPSHUFDZmik,
  VPSHUFDZmikz,
  VPSHUFDZri,
  VPSHUFDZrik,
  VPSHUFDZrikz,
  VPSHUFDmi,
  VPSHUFDri,
  VPSHUFHWYmi,
  VPSHUFHWYri,
  VPSHUFHWZ128mi,
  VPSHUFHWZ128mik,
  VPSHUFHWZ128mikz,
  VPSHUFHWZ128ri,
  VPSHUFHWZ128rik,
  VPSHUFHWZ128rikz,
  VPSHUFHWZ256mi,
  VPSHUFHWZ256mik,
  VPSHUFHWZ256mikz,
  VPSHUFHWZ256ri,
  VPSHUFHWZ256rik,
  VPSHUFHWZ256rikz,
  VPSHUFHWZmi,
  VPSHUFHWZmik,
  VPSHUFHWZmikz,
  VPSHUFHWZri,
  VPSHUFHWZrik,
  VPSHUFHWZrikz,
  VPSHUFHWmi,
  VPSHUFHWri,
  VPSHUFLWYmi,
  VPSHUFLWYri,
  VPSHUFLWZ128mi,
  VPSHUFLWZ128mik,
  VPSHUFLWZ128mikz,
  VPSHUFLWZ128ri,
  VPSHUFLWZ128rik,
  VPSHUFLWZ128rikz,
  VPSHUFLWZ256mi,
  VPSHUFLWZ256mik,
  VPSHUFLWZ256mikz,
  VPSHUFLWZ256ri,
  VPSHUFLWZ256rik,
  VPSHUFLWZ256rikz,
  VPSHUFLWZmi,
  VPSHUFLWZmik,
  VPSHUFLWZmikz,
  VPSHUFLWZri,
  VPSHUFLWZrik,
  VPSHUFLWZrikz,
  VPSHUFLWmi,
  VPSHUFLWri,
  VPSIGNBYrm,
  VPSIGNBYrr,
  VPSIGNBrm,
  VPSIGNBrr,
  VPSIGNDYrm,
  VPSIGNDYrr,
  VPSIGNDrm,
  VPSIGNDrr,
  VPSIGNWYrm,
  VPSIGNWYrr,
  VPSIGNWrm,
  VPSIGNWrr,
  VPSLLDQYri,
  VPSLLDQZ128mi,
  VPSLLDQZ128ri,
  VPSLLDQZ256mi,
  VPSLLDQZ256ri,
  VPSLLDQZmi,
  VPSLLDQZri,
  VPSLLDQri,
  VPSLLDYri,
  VPSLLDYrm,
  VPSLLDYrr,
  VPSLLDZ128mbi,
  VPSLLDZ128mbik,
  VPSLLDZ128mbikz,
  VPSLLDZ128mi,
  VPSLLDZ128mik,
  VPSLLDZ128mikz,
  VPSLLDZ128ri,
  VPSLLDZ128rik,
  VPSLLDZ128rikz,
  VPSLLDZ128rm,
  VPSLLDZ128rmk,
  VPSLLDZ128rmkz,
  VPSLLDZ128rr,
  VPSLLDZ128rrk,
  VPSLLDZ128rrkz,
  VPSLLDZ256mbi,
  VPSLLDZ256mbik,
  VPSLLDZ256mbikz,
  VPSLLDZ256mi,
  VPSLLDZ256mik,
  VPSLLDZ256mikz,
  VPSLLDZ256ri,
  VPSLLDZ256rik,
  VPSLLDZ256rikz,
  VPSLLDZ256rm,
  VPSLLDZ256rmk,
  VPSLLDZ256rmkz,
  VPSLLDZ256rr,
  VPSLLDZ256rrk,
  VPSLLDZ256rrkz,
  VPSLLDZmbi,
  VPSLLDZmbik,
  VPSLLDZmbikz,
  VPSLLDZmi,
  VPSLLDZmik,
  VPSLLDZmikz,
  VPSLLDZri,
  VPSLLDZrik,
  VPSLLDZrikz,
  VPSLLDZrm,
  VPSLLDZrmk,
  VPSLLDZrmkz,
  VPSLLDZrr,
  VPSLLDZrrk,
  VPSLLDZrrkz,
  VPSLLDri,
  VPSLLDrm,
  VPSLLDrr,
  VPSLLQYri,
  VPSLLQYrm,
  VPSLLQYrr,
  VPSLLQZ128mbi,
  VPSLLQZ128mbik,
  VPSLLQZ128mbikz,
  VPSLLQZ128mi,
  VPSLLQZ128mik,
  VPSLLQZ128mikz,
  VPSLLQZ128ri,
  VPSLLQZ128rik,
  VPSLLQZ128rikz,
  VPSLLQZ128rm,
  VPSLLQZ128rmk,
  VPSLLQZ128rmkz,
  VPSLLQZ128rr,
  VPSLLQZ128rrk,
  VPSLLQZ128rrkz,
  VPSLLQZ256mbi,
  VPSLLQZ256mbik,
  VPSLLQZ256mbikz,
  VPSLLQZ256mi,
  VPSLLQZ256mik,
  VPSLLQZ256mikz,
  VPSLLQZ256ri,
  VPSLLQZ256rik,
  VPSLLQZ256rikz,
  VPSLLQZ256rm,
  VPSLLQZ256rmk,
  VPSLLQZ256rmkz,
  VPSLLQZ256rr,
  VPSLLQZ256rrk,
  VPSLLQZ256rrkz,
  VPSLLQZmbi,
  VPSLLQZmbik,
  VPSLLQZmbikz,
  VPSLLQZmi,
  VPSLLQZmik,
  VPSLLQZmikz,
  VPSLLQZri,
  VPSLLQZrik,
  VPSLLQZrikz,
  VPSLLQZrm,
  VPSLLQZrmk,
  VPSLLQZrmkz,
  VPSLLQZrr,
  VPSLLQZrrk,
  VPSLLQZrrkz,
  VPSLLQri,
  VPSLLQrm,
  VPSLLQrr,
  VPSLLVDYrm,
  VPSLLVDYrr,
  VPSLLVDZ128rm,
  VPSLLVDZ128rmb,
  VPSLLVDZ128rmbk,
  VPSLLVDZ128rmbkz,
  VPSLLVDZ128rmk,
  VPSLLVDZ128rmkz,
  VPSLLVDZ128rr,
  VPSLLVDZ128rrk,
  VPSLLVDZ128rrkz,
  VPSLLVDZ256rm,
  VPSLLVDZ256rmb,
  VPSLLVDZ256rmbk,
  VPSLLVDZ256rmbkz,
  VPSLLVDZ256rmk,
  VPSLLVDZ256rmkz,
  VPSLLVDZ256rr,
  VPSLLVDZ256rrk,
  VPSLLVDZ256rrkz,
  VPSLLVDZrm,
  VPSLLVDZrmb,
  VPSLLVDZrmbk,
  VPSLLVDZrmbkz,
  VPSLLVDZrmk,
  VPSLLVDZrmkz,
  VPSLLVDZrr,
  VPSLLVDZrrk,
  VPSLLVDZrrkz,
  VPSLLVDrm,
  VPSLLVDrr,
  VPSLLVQYrm,
  VPSLLVQYrr,
  VPSLLVQZ128rm,
  VPSLLVQZ128rmb,
  VPSLLVQZ128rmbk,
  VPSLLVQZ128rmbkz,
  VPSLLVQZ128rmk,
  VPSLLVQZ128rmkz,
  VPSLLVQZ128rr,
  VPSLLVQZ128rrk,
  VPSLLVQZ128rrkz,
  VPSLLVQZ256rm,
  VPSLLVQZ256rmb,
  VPSLLVQZ256rmbk,
  VPSLLVQZ256rmbkz,
  VPSLLVQZ256rmk,
  VPSLLVQZ256rmkz,
  VPSLLVQZ256rr,
  VPSLLVQZ256rrk,
  VPSLLVQZ256rrkz,
  VPSLLVQZrm,
  VPSLLVQZrmb,
  VPSLLVQZrmbk,
  VPSLLVQZrmbkz,
  VPSLLVQZrmk,
  VPSLLVQZrmkz,
  VPSLLVQZrr,
  VPSLLVQZrrk,
  VPSLLVQZrrkz,
  VPSLLVQrm,
  VPSLLVQrr,
  VPSLLVWZ128rm,
  VPSLLVWZ128rmk,
  VPSLLVWZ128rmkz,
  VPSLLVWZ128rr,
  VPSLLVWZ128rrk,
  VPSLLVWZ128rrkz,
  VPSLLVWZ256rm,
  VPSLLVWZ256rmk,
  VPSLLVWZ256rmkz,
  VPSLLVWZ256rr,
  VPSLLVWZ256rrk,
  VPSLLVWZ256rrkz,
  VPSLLVWZrm,
  VPSLLVWZrmk,
  VPSLLVWZrmkz,
  VPSLLVWZrr,
  VPSLLVWZrrk,
  VPSLLVWZrrkz,
  VPSLLWYri,
  VPSLLWYrm,
  VPSLLWYrr,
  VPSLLWZ128mi,
  VPSLLWZ128mik,
  VPSLLWZ128mikz,
  VPSLLWZ128ri,
  VPSLLWZ128rik,
  VPSLLWZ128rikz,
  VPSLLWZ128rm,
  VPSLLWZ128rmk,
  VPSLLWZ128rmkz,
  VPSLLWZ128rr,
  VPSLLWZ128rrk,
  VPSLLWZ128rrkz,
  VPSLLWZ256mi,
  VPSLLWZ256mik,
  VPSLLWZ256mikz,
  VPSLLWZ256ri,
  VPSLLWZ256rik,
  VPSLLWZ256rikz,
  VPSLLWZ256rm,
  VPSLLWZ256rmk,
  VPSLLWZ256rmkz,
  VPSLLWZ256rr,
  VPSLLWZ256rrk,
  VPSLLWZ256rrkz,
  VPSLLWZmi,
  VPSLLWZmik,
  VPSLLWZmikz,
  VPSLLWZri,
  VPSLLWZrik,
  VPSLLWZrikz,
  VPSLLWZrm,
  VPSLLWZrmk,
  VPSLLWZrmkz,
  VPSLLWZrr,
  VPSLLWZrrk,
  VPSLLWZrrkz,
  VPSLLWri,
  VPSLLWrm,
  VPSLLWrr,
  VPSRADYri,
  VPSRADYrm,
  VPSRADYrr,
  VPSRADZ128mbi,
  VPSRADZ128mbik,
  VPSRADZ128mbikz,
  VPSRADZ128mi,
  VPSRADZ128mik,
  VPSRADZ128mikz,
  VPSRADZ128ri,
  VPSRADZ128rik,
  VPSRADZ128rikz,
  VPSRADZ128rm,
  VPSRADZ128rmk,
  VPSRADZ128rmkz,
  VPSRADZ128rr,
  VPSRADZ128rrk,
  VPSRADZ128rrkz,
  VPSRADZ256mbi,
  VPSRADZ256mbik,
  VPSRADZ256mbikz,
  VPSRADZ256mi,
  VPSRADZ256mik,
  VPSRADZ256mikz,
  VPSRADZ256ri,
  VPSRADZ256rik,
  VPSRADZ256rikz,
  VPSRADZ256rm,
  VPSRADZ256rmk,
  VPSRADZ256rmkz,
  VPSRADZ256rr,
  VPSRADZ256rrk,
  VPSRADZ256rrkz,
  VPSRADZmbi,
  VPSRADZmbik,
  VPSRADZmbikz,
  VPSRADZmi,
  VPSRADZmik,
  VPSRADZmikz,
  VPSRADZri,
  VPSRADZrik,
  VPSRADZrikz,
  VPSRADZrm,
  VPSRADZrmk,
  VPSRADZrmkz,
  VPSRADZrr,
  VPSRADZrrk,
  VPSRADZrrkz,
  VPSRADri,
  VPSRADrm,
  VPSRADrr,
  VPSRAQZ128mbi,
  VPSRAQZ128mbik,
  VPSRAQZ128mbikz,
  VPSRAQZ128mi,
  VPSRAQZ128mik,
  VPSRAQZ128mikz,
  VPSRAQZ128ri,
  VPSRAQZ128rik,
  VPSRAQZ128rikz,
  VPSRAQZ128rm,
  VPSRAQZ128rmk,
  VPSRAQZ128rmkz,
  VPSRAQZ128rr,
  VPSRAQZ128rrk,
  VPSRAQZ128rrkz,
  VPSRAQZ256mbi,
  VPSRAQZ256mbik,
  VPSRAQZ256mbikz,
  VPSRAQZ256mi,
  VPSRAQZ256mik,
  VPSRAQZ256mikz,
  VPSRAQZ256ri,
  VPSRAQZ256rik,
  VPSRAQZ256rikz,
  VPSRAQZ256rm,
  VPSRAQZ256rmk,
  VPSRAQZ256rmkz,
  VPSRAQZ256rr,
  VPSRAQZ256rrk,
  VPSRAQZ256rrkz,
  VPSRAQZmbi,
  VPSRAQZmbik,
  VPSRAQZmbikz,
  VPSRAQZmi,
  VPSRAQZmik,
  VPSRAQZmikz,
  VPSRAQZri,
  VPSRAQZrik,
  VPSRAQZrikz,
  VPSRAQZrm,
  VPSRAQZrmk,
  VPSRAQZrmkz,
  VPSRAQZrr,
  VPSRAQZrrk,
  VPSRAQZrrkz,
  VPSRAVDYrm,
  VPSRAVDYrr,
  VPSRAVDZ128rm,
  VPSRAVDZ128rmb,
  VPSRAVDZ128rmbk,
  VPSRAVDZ128rmbkz,
  VPSRAVDZ128rmk,
  VPSRAVDZ128rmkz,
  VPSRAVDZ128rr,
  VPSRAVDZ128rrk,
  VPSRAVDZ128rrkz,
  VPSRAVDZ256rm,
  VPSRAVDZ256rmb,
  VPSRAVDZ256rmbk,
  VPSRAVDZ256rmbkz,
  VPSRAVDZ256rmk,
  VPSRAVDZ256rmkz,
  VPSRAVDZ256rr,
  VPSRAVDZ256rrk,
  VPSRAVDZ256rrkz,
  VPSRAVDZrm,
  VPSRAVDZrmb,
  VPSRAVDZrmbk,
  VPSRAVDZrmbkz,
  VPSRAVDZrmk,
  VPSRAVDZrmkz,
  VPSRAVDZrr,
  VPSRAVDZrrk,
  VPSRAVDZrrkz,
  VPSRAVDrm,
  VPSRAVDrr,
  VPSRAVQZ128rm,
  VPSRAVQZ128rmb,
  VPSRAVQZ128rmbk,
  VPSRAVQZ128rmbkz,
  VPSRAVQZ128rmk,
  VPSRAVQZ128rmkz,
  VPSRAVQZ128rr,
  VPSRAVQZ128rrk,
  VPSRAVQZ128rrkz,
  VPSRAVQZ256rm,
  VPSRAVQZ256rmb,
  VPSRAVQZ256rmbk,
  VPSRAVQZ256rmbkz,
  VPSRAVQZ256rmk,
  VPSRAVQZ256rmkz,
  VPSRAVQZ256rr,
  VPSRAVQZ256rrk,
  VPSRAVQZ256rrkz,
  VPSRAVQZrm,
  VPSRAVQZrmb,
  VPSRAVQZrmbk,
  VPSRAVQZrmbkz,
  VPSRAVQZrmk,
  VPSRAVQZrmkz,
  VPSRAVQZrr,
  VPSRAVQZrrk,
  VPSRAVQZrrkz,
  VPSRAVWZ128rm,
  VPSRAVWZ128rmk,
  VPSRAVWZ128rmkz,
  VPSRAVWZ128rr,
  VPSRAVWZ128rrk,
  VPSRAVWZ128rrkz,
  VPSRAVWZ256rm,
  VPSRAVWZ256rmk,
  VPSRAVWZ256rmkz,
  VPSRAVWZ256rr,
  VPSRAVWZ256rrk,
  VPSRAVWZ256rrkz,
  VPSRAVWZrm,
  VPSRAVWZrmk,
  VPSRAVWZrmkz,
  VPSRAVWZrr,
  VPSRAVWZrrk,
  VPSRAVWZrrkz,
  VPSRAWYri,
  VPSRAWYrm,
  VPSRAWYrr,
  VPSRAWZ128mi,
  VPSRAWZ128mik,
  VPSRAWZ128mikz,
  VPSRAWZ128ri,
  VPSRAWZ128rik,
  VPSRAWZ128rikz,
  VPSRAWZ128rm,
  VPSRAWZ128rmk,
  VPSRAWZ128rmkz,
  VPSRAWZ128rr,
  VPSRAWZ128rrk,
  VPSRAWZ128rrkz,
  VPSRAWZ256mi,
  VPSRAWZ256mik,
  VPSRAWZ256mikz,
  VPSRAWZ256ri,
  VPSRAWZ256rik,
  VPSRAWZ256rikz,
  VPSRAWZ256rm,
  VPSRAWZ256rmk,
  VPSRAWZ256rmkz,
  VPSRAWZ256rr,
  VPSRAWZ256rrk,
  VPSRAWZ256rrkz,
  VPSRAWZmi,
  VPSRAWZmik,
  VPSRAWZmikz,
  VPSRAWZri,
  VPSRAWZrik,
  VPSRAWZrikz,
  VPSRAWZrm,
  VPSRAWZrmk,
  VPSRAWZrmkz,
  VPSRAWZrr,
  VPSRAWZrrk,
  VPSRAWZrrkz,
  VPSRAWri,
  VPSRAWrm,
  VPSRAWrr,
  VPSRLDQYri,
  VPSRLDQZ128mi,
  VPSRLDQZ128ri,
  VPSRLDQZ256mi,
  VPSRLDQZ256ri,
  VPSRLDQZmi,
  VPSRLDQZri,
  VPSRLDQri,
  VPSRLDYri,
  VPSRLDYrm,
  VPSRLDYrr,
  VPSRLDZ128mbi,
  VPSRLDZ128mbik,
  VPSRLDZ128mbikz,
  VPSRLDZ128mi,
  VPSRLDZ128mik,
  VPSRLDZ128mikz,
  VPSRLDZ128ri,
  VPSRLDZ128rik,
  VPSRLDZ128rikz,
  VPSRLDZ128rm,
  VPSRLDZ128rmk,
  VPSRLDZ128rmkz,
  VPSRLDZ128rr,
  VPSRLDZ128rrk,
  VPSRLDZ128rrkz,
  VPSRLDZ256mbi,
  VPSRLDZ256mbik,
  VPSRLDZ256mbikz,
  VPSRLDZ256mi,
  VPSRLDZ256mik,
  VPSRLDZ256mikz,
  VPSRLDZ256ri,
  VPSRLDZ256rik,
  VPSRLDZ256rikz,
  VPSRLDZ256rm,
  VPSRLDZ256rmk,
  VPSRLDZ256rmkz,
  VPSRLDZ256rr,
  VPSRLDZ256rrk,
  VPSRLDZ256rrkz,
  VPSRLDZmbi,
  VPSRLDZmbik,
  VPSRLDZmbikz,
  VPSRLDZmi,
  VPSRLDZmik,
  VPSRLDZmikz,
  VPSRLDZri,
  VPSRLDZrik,
  VPSRLDZrikz,
  VPSRLDZrm,
  VPSRLDZrmk,
  VPSRLDZrmkz,
  VPSRLDZrr,
  VPSRLDZrrk,
  VPSRLDZrrkz,
  VPSRLDri,
  VPSRLDrm,
  VPSRLDrr,
  VPSRLQYri,
  VPSRLQYrm,
  VPSRLQYrr,
  VPSRLQZ128mbi,
  VPSRLQZ128mbik,
  VPSRLQZ128mbikz,
  VPSRLQZ128mi,
  VPSRLQZ128mik,
  VPSRLQZ128mikz,
  VPSRLQZ128ri,
  VPSRLQZ128rik,
  VPSRLQZ128rikz,
  VPSRLQZ128rm,
  VPSRLQZ128rmk,
  VPSRLQZ128rmkz,
  VPSRLQZ128rr,
  VPSRLQZ128rrk,
  VPSRLQZ128rrkz,
  VPSRLQZ256mbi,
  VPSRLQZ256mbik,
  VPSRLQZ256mbikz,
  VPSRLQZ256mi,
  VPSRLQZ256mik,
  VPSRLQZ256mikz,
  VPSRLQZ256ri,
  VPSRLQZ256rik,
  VPSRLQZ256rikz,
  VPSRLQZ256rm,
  VPSRLQZ256rmk,
  VPSRLQZ256rmkz,
  VPSRLQZ256rr,
  VPSRLQZ256rrk,
  VPSRLQZ256rrkz,
  VPSRLQZmbi,
  VPSRLQZmbik,
  VPSRLQZmbikz,
  VPSRLQZmi,
  VPSRLQZmik,
  VPSRLQZmikz,
  VPSRLQZri,
  VPSRLQZrik,
  VPSRLQZrikz,
  VPSRLQZrm,
  VPSRLQZrmk,
  VPSRLQZrmkz,
  VPSRLQZrr,
  VPSRLQZrrk,
  VPSRLQZrrkz,
  VPSRLQri,
  VPSRLQrm,
  VPSRLQrr,
  VPSRLVDYrm,
  VPSRLVDYrr,
  VPSRLVDZ128rm,
  VPSRLVDZ128rmb,
  VPSRLVDZ128rmbk,
  VPSRLVDZ128rmbkz,
  VPSRLVDZ128rmk,
  VPSRLVDZ128rmkz,
  VPSRLVDZ128rr,
  VPSRLVDZ128rrk,
  VPSRLVDZ128rrkz,
  VPSRLVDZ256rm,
  VPSRLVDZ256rmb,
  VPSRLVDZ256rmbk,
  VPSRLVDZ256rmbkz,
  VPSRLVDZ256rmk,
  VPSRLVDZ256rmkz,
  VPSRLVDZ256rr,
  VPSRLVDZ256rrk,
  VPSRLVDZ256rrkz,
  VPSRLVDZrm,
  VPSRLVDZrmb,
  VPSRLVDZrmbk,
  VPSRLVDZrmbkz,
  VPSRLVDZrmk,
  VPSRLVDZrmkz,
  VPSRLVDZrr,
  VPSRLVDZrrk,
  VPSRLVDZrrkz,
  VPSRLVDrm,
  VPSRLVDrr,
  VPSRLVQYrm,
  VPSRLVQYrr,
  VPSRLVQZ128rm,
  VPSRLVQZ128rmb,
  VPSRLVQZ128rmbk,
  VPSRLVQZ128rmbkz,
  VPSRLVQZ128rmk,
  VPSRLVQZ128rmkz,
  VPSRLVQZ128rr,
  VPSRLVQZ128rrk,
  VPSRLVQZ128rrkz,
  VPSRLVQZ256rm,
  VPSRLVQZ256rmb,
  VPSRLVQZ256rmbk,
  VPSRLVQZ256rmbkz,
  VPSRLVQZ256rmk,
  VPSRLVQZ256rmkz,
  VPSRLVQZ256rr,
  VPSRLVQZ256rrk,
  VPSRLVQZ256rrkz,
  VPSRLVQZrm,
  VPSRLVQZrmb,
  VPSRLVQZrmbk,
  VPSRLVQZrmbkz,
  VPSRLVQZrmk,
  VPSRLVQZrmkz,
  VPSRLVQZrr,
  VPSRLVQZrrk,
  VPSRLVQZrrkz,
  VPSRLVQrm,
  VPSRLVQrr,
  VPSRLVWZ128rm,
  VPSRLVWZ128rmk,
  VPSRLVWZ128rmkz,
  VPSRLVWZ128rr,
  VPSRLVWZ128rrk,
  VPSRLVWZ128rrkz,
  VPSRLVWZ256rm,
  VPSRLVWZ256rmk,
  VPSRLVWZ256rmkz,
  VPSRLVWZ256rr,
  VPSRLVWZ256rrk,
  VPSRLVWZ256rrkz,
  VPSRLVWZrm,
  VPSRLVWZrmk,
  VPSRLVWZrmkz,
  VPSRLVWZrr,
  VPSRLVWZrrk,
  VPSRLVWZrrkz,
  VPSRLWYri,
  VPSRLWYrm,
  VPSRLWYrr,
  VPSRLWZ128mi,
  VPSRLWZ128mik,
  VPSRLWZ128mikz,
  VPSRLWZ128ri,
  VPSRLWZ128rik,
  VPSRLWZ128rikz,
  VPSRLWZ128rm,
  VPSRLWZ128rmk,
  VPSRLWZ128rmkz,
  VPSRLWZ128rr,
  VPSRLWZ128rrk,
  VPSRLWZ128rrkz,
  VPSRLWZ256mi,
  VPSRLWZ256mik,
  VPSRLWZ256mikz,
  VPSRLWZ256ri,
  VPSRLWZ256rik,
  VPSRLWZ256rikz,
  VPSRLWZ256rm,
  VPSRLWZ256rmk,
  VPSRLWZ256rmkz,
  VPSRLWZ256rr,
  VPSRLWZ256rrk,
  VPSRLWZ256rrkz,
  VPSRLWZmi,
  VPSRLWZmik,
  VPSRLWZmikz,
  VPSRLWZri,
  VPSRLWZrik,
  VPSRLWZrikz,
  VPSRLWZrm,
  VPSRLWZrmk,
  VPSRLWZrmkz,
  VPSRLWZrr,
  VPSRLWZrrk,
  VPSRLWZrrkz,
  VPSRLWri,
  VPSRLWrm,
  VPSRLWrr,
  VPSUBBYrm,
  VPSUBBYrr,
  VPSUBBZ128rm,
  VPSUBBZ128rmk,
  VPSUBBZ128rmkz,
  VPSUBBZ128rr,
  VPSUBBZ128rrk,
  VPSUBBZ128rrkz,
  VPSUBBZ256rm,
  VPSUBBZ256rmk,
  VPSUBBZ256rmkz,
  VPSUBBZ256rr,
  VPSUBBZ256rrk,
  VPSUBBZ256rrkz,
  VPSUBBZrm,
  VPSUBBZrmk,
  VPSUBBZrmkz,
  VPSUBBZrr,
  VPSUBBZrrk,
  VPSUBBZrrkz,
  VPSUBBrm,
  VPSUBBrr,
  VPSUBDYrm,
  VPSUBDYrr,
  VPSUBDZ128rm,
  VPSUBDZ128rmb,
  VPSUBDZ128rmbk,
  VPSUBDZ128rmbkz,
  VPSUBDZ128rmk,
  VPSUBDZ128rmkz,
  VPSUBDZ128rr,
  VPSUBDZ128rrk,
  VPSUBDZ128rrkz,
  VPSUBDZ256rm,
  VPSUBDZ256rmb,
  VPSUBDZ256rmbk,
  VPSUBDZ256rmbkz,
  VPSUBDZ256rmk,
  VPSUBDZ256rmkz,
  VPSUBDZ256rr,
  VPSUBDZ256rrk,
  VPSUBDZ256rrkz,
  VPSUBDZrm,
  VPSUBDZrmb,
  VPSUBDZrmbk,
  VPSUBDZrmbkz,
  VPSUBDZrmk,
  VPSUBDZrmkz,
  VPSUBDZrr,
  VPSUBDZrrk,
  VPSUBDZrrkz,
  VPSUBDrm,
  VPSUBDrr,
  VPSUBQYrm,
  VPSUBQYrr,
  VPSUBQZ128rm,
  VPSUBQZ128rmb,
  VPSUBQZ128rmbk,
  VPSUBQZ128rmbkz,
  VPSUBQZ128rmk,
  VPSUBQZ128rmkz,
  VPSUBQZ128rr,
  VPSUBQZ128rrk,
  VPSUBQZ128rrkz,
  VPSUBQZ256rm,
  VPSUBQZ256rmb,
  VPSUBQZ256rmbk,
  VPSUBQZ256rmbkz,
  VPSUBQZ256rmk,
  VPSUBQZ256rmkz,
  VPSUBQZ256rr,
  VPSUBQZ256rrk,
  VPSUBQZ256rrkz,
  VPSUBQZrm,
  VPSUBQZrmb,
  VPSUBQZrmbk,
  VPSUBQZrmbkz,
  VPSUBQZrmk,
  VPSUBQZrmkz,
  VPSUBQZrr,
  VPSUBQZrrk,
  VPSUBQZrrkz,
  VPSUBQrm,
  VPSUBQrr,
  VPSUBSBYrm,
  VPSUBSBYrr,
  VPSUBSBZ128rm,
  VPSUBSBZ128rmk,
  VPSUBSBZ128rmkz,
  VPSUBSBZ128rr,
  VPSUBSBZ128rrk,
  VPSUBSBZ128rrkz,
  VPSUBSBZ256rm,
  VPSUBSBZ256rmk,
  VPSUBSBZ256rmkz,
  VPSUBSBZ256rr,
  VPSUBSBZ256rrk,
  VPSUBSBZ256rrkz,
  VPSUBSBZrm,
  VPSUBSBZrmk,
  VPSUBSBZrmkz,
  VPSUBSBZrr,
  VPSUBSBZrrk,
  VPSUBSBZrrkz,
  VPSUBSBrm,
  VPSUBSBrr,
  VPSUBSWYrm,
  VPSUBSWYrr,
  VPSUBSWZ128rm,
  VPSUBSWZ128rmk,
  VPSUBSWZ128rmkz,
  VPSUBSWZ128rr,
  VPSUBSWZ128rrk,
  VPSUBSWZ128rrkz,
  VPSUBSWZ256rm,
  VPSUBSWZ256rmk,
  VPSUBSWZ256rmkz,
  VPSUBSWZ256rr,
  VPSUBSWZ256rrk,
  VPSUBSWZ256rrkz,
  VPSUBSWZrm,
  VPSUBSWZrmk,
  VPSUBSWZrmkz,
  VPSUBSWZrr,
  VPSUBSWZrrk,
  VPSUBSWZrrkz,
  VPSUBSWrm,
  VPSUBSWrr,
  VPSUBUSBYrm,
  VPSUBUSBYrr,
  VPSUBUSBZ128rm,
  VPSUBUSBZ128rmk,
  VPSUBUSBZ128rmkz,
  VPSUBUSBZ128rr,
  VPSUBUSBZ128rrk,
  VPSUBUSBZ128rrkz,
  VPSUBUSBZ256rm,
  VPSUBUSBZ256rmk,
  VPSUBUSBZ256rmkz,
  VPSUBUSBZ256rr,
  VPSUBUSBZ256rrk,
  VPSUBUSBZ256rrkz,
  VPSUBUSBZrm,
  VPSUBUSBZrmk,
  VPSUBUSBZrmkz,
  VPSUBUSBZrr,
  VPSUBUSBZrrk,
  VPSUBUSBZrrkz,
  VPSUBUSBrm,
  VPSUBUSBrr,
  VPSUBUSWYrm,
  VPSUBUSWYrr,
  VPSUBUSWZ128rm,
  VPSUBUSWZ128rmk,
  VPSUBUSWZ128rmkz,
  VPSUBUSWZ128rr,
  VPSUBUSWZ128rrk,
  VPSUBUSWZ128rrkz,
  VPSUBUSWZ256rm,
  VPSUBUSWZ256rmk,
  VPSUBUSWZ256rmkz,
  VPSUBUSWZ256rr,
  VPSUBUSWZ256rrk,
  VPSUBUSWZ256rrkz,
  VPSUBUSWZrm,
  VPSUBUSWZrmk,
  VPSUBUSWZrmkz,
  VPSUBUSWZrr,
  VPSUBUSWZrrk,
  VPSUBUSWZrrkz,
  VPSUBUSWrm,
  VPSUBUSWrr,
  VPSUBWYrm,
  VPSUBWYrr,
  VPSUBWZ128rm,
  VPSUBWZ128rmk,
  VPSUBWZ128rmkz,
  VPSUBWZ128rr,
  VPSUBWZ128rrk,
  VPSUBWZ128rrkz,
  VPSUBWZ256rm,
  VPSUBWZ256rmk,
  VPSUBWZ256rmkz,
  VPSUBWZ256rr,
  VPSUBWZ256rrk,
  VPSUBWZ256rrkz,
  VPSUBWZrm,
  VPSUBWZrmk,
  VPSUBWZrmkz,
  VPSUBWZrr,
  VPSUBWZrrk,
  VPSUBWZrrkz,
  VPSUBWrm,
  VPSUBWrr,
  VPTERNLOGDZ128rmbi,
  VPTERNLOGDZ128rmbik,
  VPTERNLOGDZ128rmbikz,
  VPTERNLOGDZ128rmi,
  VPTERNLOGDZ128rmik,
  VPTERNLOGDZ128rmikz,
  VPTERNLOGDZ128rri,
  VPTERNLOGDZ128rrik,
  VPTERNLOGDZ128rrikz,
  VPTERNLOGDZ256rmbi,
  VPTERNLOGDZ256rmbik,
  VPTERNLOGDZ256rmbikz,
  VPTERNLOGDZ256rmi,
  VPTERNLOGDZ256rmik,
  VPTERNLOGDZ256rmikz,
  VPTERNLOGDZ256rri,
  VPTERNLOGDZ256rrik,
  VPTERNLOGDZ256rrikz,
  VPTERNLOGDZrmbi,
  VPTERNLOGDZrmbik,
  VPTERNLOGDZrmbikz,
  VPTERNLOGDZrmi,
  VPTERNLOGDZrmik,
  VPTERNLOGDZrmikz,
  VPTERNLOGDZrri,
  VPTERNLOGDZrrik,
  VPTERNLOGDZrrikz,
  VPTERNLOGQZ128rmbi,
  VPTERNLOGQZ128rmbik,
  VPTERNLOGQZ128rmbikz,
  VPTERNLOGQZ128rmi,
  VPTERNLOGQZ128rmik,
  VPTERNLOGQZ128rmikz,
  VPTERNLOGQZ128rri,
  VPTERNLOGQZ128rrik,
  VPTERNLOGQZ128rrikz,
  VPTERNLOGQZ256rmbi,
  VPTERNLOGQZ256rmbik,
  VPTERNLOGQZ256rmbikz,
  VPTERNLOGQZ256rmi,
  VPTERNLOGQZ256rmik,
  VPTERNLOGQZ256rmikz,
  VPTERNLOGQZ256rri,
  VPTERNLOGQZ256rrik,
  VPTERNLOGQZ256rrikz,
  VPTERNLOGQZrmbi,
  VPTERNLOGQZrmbik,
  VPTERNLOGQZrmbikz,
  VPTERNLOGQZrmi,
  VPTERNLOGQZrmik,
  VPTERNLOGQZrmikz,
  VPTERNLOGQZrri,
  VPTERNLOGQZrrik,
  VPTERNLOGQZrrikz,
  VPTESTMBZ128rm,
  VPTESTMBZ128rmk,
  VPTESTMBZ128rr,
  VPTESTMBZ128rrk,
  VPTESTMBZ256rm,
  VPTESTMBZ256rmk,
  VPTESTMBZ256rr,
  VPTESTMBZ256rrk,
  VPTESTMBZrm,
  VPTESTMBZrmk,
  VPTESTMBZrr,
  VPTESTMBZrrk,
  VPTESTMDZ128rm,
  VPTESTMDZ128rmb,
  VPTESTMDZ128rmbk,
  VPTESTMDZ128rmk,
  VPTESTMDZ128rr,
  VPTESTMDZ128rrk,
  VPTESTMDZ256rm,
  VPTESTMDZ256rmb,
  VPTESTMDZ256rmbk,
  VPTESTMDZ256rmk,
  VPTESTMDZ256rr,
  VPTESTMDZ256rrk,
  VPTESTMDZrm,
  VPTESTMDZrmb,
  VPTESTMDZrmbk,
  VPTESTMDZrmk,
  VPTESTMDZrr,
  VPTESTMDZrrk,
  VPTESTMQZ128rm,
  VPTESTMQZ128rmb,
  VPTESTMQZ128rmbk,
  VPTESTMQZ128rmk,
  VPTESTMQZ128rr,
  VPTESTMQZ128rrk,
  VPTESTMQZ256rm,
  VPTESTMQZ256rmb,
  VPTESTMQZ256rmbk,
  VPTESTMQZ256rmk,
  VPTESTMQZ256rr,
  VPTESTMQZ256rrk,
  VPTESTMQZrm,
  VPTESTMQZrmb,
  VPTESTMQZrmbk,
  VPTESTMQZrmk,
  VPTESTMQZrr,
  VPTESTMQZrrk,
  VPTESTMWZ128rm,
  VPTESTMWZ128rmk,
  VPTESTMWZ128rr,
  VPTESTMWZ128rrk,
  VPTESTMWZ256rm,
  VPTESTMWZ256rmk,
  VPTESTMWZ256rr,
  VPTESTMWZ256rrk,
  VPTESTMWZrm,
  VPTESTMWZrmk,
  VPTESTMWZrr,
  VPTESTMWZrrk,
  VPTESTNMBZ128rm,
  VPTESTNMBZ128rmk,
  VPTESTNMBZ128rr,
  VPTESTNMBZ128rrk,
  VPTESTNMBZ256rm,
  VPTESTNMBZ256rmk,
  VPTESTNMBZ256rr,
  VPTESTNMBZ256rrk,
  VPTESTNMBZrm,
  VPTESTNMBZrmk,
  VPTESTNMBZrr,
  VPTESTNMBZrrk,
  VPTESTNMDZ128rm,
  VPTESTNMDZ128rmb,
  VPTESTNMDZ128rmbk,
  VPTESTNMDZ128rmk,
  VPTESTNMDZ128rr,
  VPTESTNMDZ128rrk,
  VPTESTNMDZ256rm,
  VPTESTNMDZ256rmb,
  VPTESTNMDZ256rmbk,
  VPTESTNMDZ256rmk,
  VPTESTNMDZ256rr,
  VPTESTNMDZ256rrk,
  VPTESTNMDZrm,
  VPTESTNMDZrmb,
  VPTESTNMDZrmbk,
  VPTESTNMDZrmk,
  VPTESTNMDZrr,
  VPTESTNMDZrrk,
  VPTESTNMQZ128rm,
  VPTESTNMQZ128rmb,
  VPTESTNMQZ128rmbk,
  VPTESTNMQZ128rmk,
  VPTESTNMQZ128rr,
  VPTESTNMQZ128rrk,
  VPTESTNMQZ256rm,
  VPTESTNMQZ256rmb,
  VPTESTNMQZ256rmbk,
  VPTESTNMQZ256rmk,
  VPTESTNMQZ256rr,
  VPTESTNMQZ256rrk,
  VPTESTNMQZrm,
  VPTESTNMQZrmb,
  VPTESTNMQZrmbk,
  VPTESTNMQZrmk,
  VPTESTNMQZrr,
  VPTESTNMQZrrk,
  VPTESTNMWZ128rm,
  VPTESTNMWZ128rmk,
  VPTESTNMWZ128rr,
  VPTESTNMWZ128rrk,
  VPTESTNMWZ256rm,
  VPTESTNMWZ256rmk,
  VPTESTNMWZ256rr,
  VPTESTNMWZ256rrk,
  VPTESTNMWZrm,
  VPTESTNMWZrmk,
  VPTESTNMWZrr,
  VPTESTNMWZrrk,
  VPTESTYrm,
  VPTESTYrr,
  VPTESTrm,
  VPTESTrr,
  VPUNPCKHBWYrm,
  VPUNPCKHBWYrr,
  VPUNPCKHBWZ128rm,
  VPUNPCKHBWZ128rmk,
  VPUNPCKHBWZ128rmkz,
  VPUNPCKHBWZ128rr,
  VPUNPCKHBWZ128rrk,
  VPUNPCKHBWZ128rrkz,
  VPUNPCKHBWZ256rm,
  VPUNPCKHBWZ256rmk,
  VPUNPCKHBWZ256rmkz,
  VPUNPCKHBWZ256rr,
  VPUNPCKHBWZ256rrk,
  VPUNPCKHBWZ256rrkz,
  VPUNPCKHBWZrm,
  VPUNPCKHBWZrmk,
  VPUNPCKHBWZrmkz,
  VPUNPCKHBWZrr,
  VPUNPCKHBWZrrk,
  VPUNPCKHBWZrrkz,
  VPUNPCKHBWrm,
  VPUNPCKHBWrr,
  VPUNPCKHDQYrm,
  VPUNPCKHDQYrr,
  VPUNPCKHDQZ128rm,
  VPUNPCKHDQZ128rmb,
  VPUNPCKHDQZ128rmbk,
  VPUNPCKHDQZ128rmbkz,
  VPUNPCKHDQZ128rmk,
  VPUNPCKHDQZ128rmkz,
  VPUNPCKHDQZ128rr,
  VPUNPCKHDQZ128rrk,
  VPUNPCKHDQZ128rrkz,
  VPUNPCKHDQZ256rm,
  VPUNPCKHDQZ256rmb,
  VPUNPCKHDQZ256rmbk,
  VPUNPCKHDQZ256rmbkz,
  VPUNPCKHDQZ256rmk,
  VPUNPCKHDQZ256rmkz,
  VPUNPCKHDQZ256rr,
  VPUNPCKHDQZ256rrk,
  VPUNPCKHDQZ256rrkz,
  VPUNPCKHDQZrm,
  VPUNPCKHDQZrmb,
  VPUNPCKHDQZrmbk,
  VPUNPCKHDQZrmbkz,
  VPUNPCKHDQZrmk,
  VPUNPCKHDQZrmkz,
  VPUNPCKHDQZrr,
  VPUNPCKHDQZrrk,
  VPUNPCKHDQZrrkz,
  VPUNPCKHDQrm,
  VPUNPCKHDQrr,
  VPUNPCKHQDQYrm,
  VPUNPCKHQDQYrr,
  VPUNPCKHQDQZ128rm,
  VPUNPCKHQDQZ128rmb,
  VPUNPCKHQDQZ128rmbk,
  VPUNPCKHQDQZ128rmbkz,
  VPUNPCKHQDQZ128rmk,
  VPUNPCKHQDQZ128rmkz,
  VPUNPCKHQDQZ128rr,
  VPUNPCKHQDQZ128rrk,
  VPUNPCKHQDQZ128rrkz,
  VPUNPCKHQDQZ256rm,
  VPUNPCKHQDQZ256rmb,
  VPUNPCKHQDQZ256rmbk,
  VPUNPCKHQDQZ256rmbkz,
  VPUNPCKHQDQZ256rmk,
  VPUNPCKHQDQZ256rmkz,
  VPUNPCKHQDQZ256rr,
  VPUNPCKHQDQZ256rrk,
  VPUNPCKHQDQZ256rrkz,
  VPUNPCKHQDQZrm,
  VPUNPCKHQDQZrmb,
  VPUNPCKHQDQZrmbk,
  VPUNPCKHQDQZrmbkz,
  VPUNPCKHQDQZrmk,
  VPUNPCKHQDQZrmkz,
  VPUNPCKHQDQZrr,
  VPUNPCKHQDQZrrk,
  VPUNPCKHQDQZrrkz,
  VPUNPCKHQDQrm,
  VPUNPCKHQDQrr,
  VPUNPCKHWDYrm,
  VPUNPCKHWDYrr,
  VPUNPCKHWDZ128rm,
  VPUNPCKHWDZ128rmk,
  VPUNPCKHWDZ128rmkz,
  VPUNPCKHWDZ128rr,
  VPUNPCKHWDZ128rrk,
  VPUNPCKHWDZ128rrkz,
  VPUNPCKHWDZ256rm,
  VPUNPCKHWDZ256rmk,
  VPUNPCKHWDZ256rmkz,
  VPUNPCKHWDZ256rr,
  VPUNPCKHWDZ256rrk,
  VPUNPCKHWDZ256rrkz,
  VPUNPCKHWDZrm,
  VPUNPCKHWDZrmk,
  VPUNPCKHWDZrmkz,
  VPUNPCKHWDZrr,
  VPUNPCKHWDZrrk,
  VPUNPCKHWDZrrkz,
  VPUNPCKHWDrm,
  VPUNPCKHWDrr,
  VPUNPCKLBWYrm,
  VPUNPCKLBWYrr,
  VPUNPCKLBWZ128rm,
  VPUNPCKLBWZ128rmk,
  VPUNPCKLBWZ128rmkz,
  VPUNPCKLBWZ128rr,
  VPUNPCKLBWZ128rrk,
  VPUNPCKLBWZ128rrkz,
  VPUNPCKLBWZ256rm,
  VPUNPCKLBWZ256rmk,
  VPUNPCKLBWZ256rmkz,
  VPUNPCKLBWZ256rr,
  VPUNPCKLBWZ256rrk,
  VPUNPCKLBWZ256rrkz,
  VPUNPCKLBWZrm,
  VPUNPCKLBWZrmk,
  VPUNPCKLBWZrmkz,
  VPUNPCKLBWZrr,
  VPUNPCKLBWZrrk,
  VPUNPCKLBWZrrkz,
  VPUNPCKLBWrm,
  VPUNPCKLBWrr,
  VPUNPCKLDQYrm,
  VPUNPCKLDQYrr,
  VPUNPCKLDQZ128rm,
  VPUNPCKLDQZ128rmb,
  VPUNPCKLDQZ128rmbk,
  VPUNPCKLDQZ128rmbkz,
  VPUNPCKLDQZ128rmk,
  VPUNPCKLDQZ128rmkz,
  VPUNPCKLDQZ128rr,
  VPUNPCKLDQZ128rrk,
  VPUNPCKLDQZ128rrkz,
  VPUNPCKLDQZ256rm,
  VPUNPCKLDQZ256rmb,
  VPUNPCKLDQZ256rmbk,
  VPUNPCKLDQZ256rmbkz,
  VPUNPCKLDQZ256rmk,
  VPUNPCKLDQZ256rmkz,
  VPUNPCKLDQZ256rr,
  VPUNPCKLDQZ256rrk,
  VPUNPCKLDQZ256rrkz,
  VPUNPCKLDQZrm,
  VPUNPCKLDQZrmb,
  VPUNPCKLDQZrmbk,
  VPUNPCKLDQZrmbkz,
  VPUNPCKLDQZrmk,
  VPUNPCKLDQZrmkz,
  VPUNPCKLDQZrr,
  VPUNPCKLDQZrrk,
  VPUNPCKLDQZrrkz,
  VPUNPCKLDQrm,
  VPUNPCKLDQrr,
  VPUNPCKLQDQYrm,
  VPUNPCKLQDQYrr,
  VPUNPCKLQDQZ128rm,
  VPUNPCKLQDQZ128rmb,
  VPUNPCKLQDQZ128rmbk,
  VPUNPCKLQDQZ128rmbkz,
  VPUNPCKLQDQZ128rmk,
  VPUNPCKLQDQZ128rmkz,
  VPUNPCKLQDQZ128rr,
  VPUNPCKLQDQZ128rrk,
  VPUNPCKLQDQZ128rrkz,
  VPUNPCKLQDQZ256rm,
  VPUNPCKLQDQZ256rmb,
  VPUNPCKLQDQZ256rmbk,
  VPUNPCKLQDQZ256rmbkz,
  VPUNPCKLQDQZ256rmk,
  VPUNPCKLQDQZ256rmkz,
  VPUNPCKLQDQZ256rr,
  VPUNPCKLQDQZ256rrk,
  VPUNPCKLQDQZ256rrkz,
  VPUNPCKLQDQZrm,
  VPUNPCKLQDQZrmb,
  VPUNPCKLQDQZrmbk,
  VPUNPCKLQDQZrmbkz,
  VPUNPCKLQDQZrmk,
  VPUNPCKLQDQZrmkz,
  VPUNPCKLQDQZrr,
  VPUNPCKLQDQZrrk,
  VPUNPCKLQDQZrrkz,
  VPUNPCKLQDQrm,
  VPUNPCKLQDQrr,
  VPUNPCKLWDYrm,
  VPUNPCKLWDYrr,
  VPUNPCKLWDZ128rm,
  VPUNPCKLWDZ128rmk,
  VPUNPCKLWDZ128rmkz,
  VPUNPCKLWDZ128rr,
  VPUNPCKLWDZ128rrk,
  VPUNPCKLWDZ128rrkz,
  VPUNPCKLWDZ256rm,
  VPUNPCKLWDZ256rmk,
  VPUNPCKLWDZ256rmkz,
  VPUNPCKLWDZ256rr,
  VPUNPCKLWDZ256rrk,
  VPUNPCKLWDZ256rrkz,
  VPUNPCKLWDZrm,
  VPUNPCKLWDZrmk,
  VPUNPCKLWDZrmkz,
  VPUNPCKLWDZrr,
  VPUNPCKLWDZrrk,
  VPUNPCKLWDZrrkz,
  VPUNPCKLWDrm,
  VPUNPCKLWDrr,
  VPXORDZ128rm,
  VPXORDZ128rmb,
  VPXORDZ128rmbk,
  VPXORDZ128rmbkz,
  VPXORDZ128rmk,
  VPXORDZ128rmkz,
  VPXORDZ128rr,
  VPXORDZ128rrk,
  VPXORDZ128rrkz,
  VPXORDZ256rm,
  VPXORDZ256rmb,
  VPXORDZ256rmbk,
  VPXORDZ256rmbkz,
  VPXORDZ256rmk,
  VPXORDZ256rmkz,
  VPXORDZ256rr,
  VPXORDZ256rrk,
  VPXORDZ256rrkz,
  VPXORDZrm,
  VPXORDZrmb,
  VPXORDZrmbk,
  VPXORDZrmbkz,
  VPXORDZrmk,
  VPXORDZrmkz,
  VPXORDZrr,
  VPXORDZrrk,
  VPXORDZrrkz,
  VPXORQZ128rm,
  VPXORQZ128rmb,
  VPXORQZ128rmbk,
  VPXORQZ128rmbkz,
  VPXORQZ128rmk,
  VPXORQZ128rmkz,
  VPXORQZ128rr,
  VPXORQZ128rrk,
  VPXORQZ128rrkz,
  VPXORQZ256rm,
  VPXORQZ256rmb,
  VPXORQZ256rmbk,
  VPXORQZ256rmbkz,
  VPXORQZ256rmk,
  VPXORQZ256rmkz,
  VPXORQZ256rr,
  VPXORQZ256rrk,
  VPXORQZ256rrkz,
  VPXORQZrm,
  VPXORQZrmb,
  VPXORQZrmbk,
  VPXORQZrmbkz,
  VPXORQZrmk,
  VPXORQZrmkz,
  VPXORQZrr,
  VPXORQZrrk,
  VPXORQZrrkz,
  VPXORYrm,
  VPXORYrr,
  VPXORrm,
  VPXORrr,
  VRANGEPDZ128rmbi,
  VRANGEPDZ128rmbik,
  VRANGEPDZ128rmbikz,
  VRANGEPDZ128rmi,
  VRANGEPDZ128rmik,
  VRANGEPDZ128rmikz,
  VRANGEPDZ128rri,
  VRANGEPDZ128rrik,
  VRANGEPDZ128rrikz,
  VRANGEPDZ256rmbi,
  VRANGEPDZ256rmbik,
  VRANGEPDZ256rmbikz,
  VRANGEPDZ256rmi,
  VRANGEPDZ256rmik,
  VRANGEPDZ256rmikz,
  VRANGEPDZ256rri,
  VRANGEPDZ256rrik,
  VRANGEPDZ256rrikz,
  VRANGEPDZrmbi,
  VRANGEPDZrmbik,
  VRANGEPDZrmbikz,
  VRANGEPDZrmi,
  VRANGEPDZrmik,
  VRANGEPDZrmikz,
  VRANGEPDZrri,
  VRANGEPDZrrib,
  VRANGEPDZrribk,
  VRANGEPDZrribkz,
  VRANGEPDZrrik,
  VRANGEPDZrrikz,
  VRANGEPSZ128rmbi,
  VRANGEPSZ128rmbik,
  VRANGEPSZ128rmbikz,
  VRANGEPSZ128rmi,
  VRANGEPSZ128rmik,
  VRANGEPSZ128rmikz,
  VRANGEPSZ128rri,
  VRANGEPSZ128rrik,
  VRANGEPSZ128rrikz,
  VRANGEPSZ256rmbi,
  VRANGEPSZ256rmbik,
  VRANGEPSZ256rmbikz,
  VRANGEPSZ256rmi,
  VRANGEPSZ256rmik,
  VRANGEPSZ256rmikz,
  VRANGEPSZ256rri,
  VRANGEPSZ256rrik,
  VRANGEPSZ256rrikz,
  VRANGEPSZrmbi,
  VRANGEPSZrmbik,
  VRANGEPSZrmbikz,
  VRANGEPSZrmi,
  VRANGEPSZrmik,
  VRANGEPSZrmikz,
  VRANGEPSZrri,
  VRANGEPSZrrib,
  VRANGEPSZrribk,
  VRANGEPSZrribkz,
  VRANGEPSZrrik,
  VRANGEPSZrrikz,
  VRANGESDZrmi,
  VRANGESDZrmik,
  VRANGESDZrmikz,
  VRANGESDZrri,
  VRANGESDZrrib,
  VRANGESDZrribk,
  VRANGESDZrribkz,
  VRANGESDZrrik,
  VRANGESDZrrikz,
  VRANGESSZrmi,
  VRANGESSZrmik,
  VRANGESSZrmikz,
  VRANGESSZrri,
  VRANGESSZrrib,
  VRANGESSZrribk,
  VRANGESSZrribkz,
  VRANGESSZrrik,
  VRANGESSZrrikz,
  VRCP14PDZ128m,
  VRCP14PDZ128mb,
  VRCP14PDZ128mbk,
  VRCP14PDZ128mbkz,
  VRCP14PDZ128mk,
  VRCP14PDZ128mkz,
  VRCP14PDZ128r,
  VRCP14PDZ128rk,
  VRCP14PDZ128rkz,
  VRCP14PDZ256m,
  VRCP14PDZ256mb,
  VRCP14PDZ256mbk,
  VRCP14PDZ256mbkz,
  VRCP14PDZ256mk,
  VRCP14PDZ256mkz,
  VRCP14PDZ256r,
  VRCP14PDZ256rk,
  VRCP14PDZ256rkz,
  VRCP14PDZm,
  VRCP14PDZmb,
  VRCP14PDZmbk,
  VRCP14PDZmbkz,
  VRCP14PDZmk,
  VRCP14PDZmkz,
  VRCP14PDZr,
  VRCP14PDZrk,
  VRCP14PDZrkz,
  VRCP14PSZ128m,
  VRCP14PSZ128mb,
  VRCP14PSZ128mbk,
  VRCP14PSZ128mbkz,
  VRCP14PSZ128mk,
  VRCP14PSZ128mkz,
  VRCP14PSZ128r,
  VRCP14PSZ128rk,
  VRCP14PSZ128rkz,
  VRCP14PSZ256m,
  VRCP14PSZ256mb,
  VRCP14PSZ256mbk,
  VRCP14PSZ256mbkz,
  VRCP14PSZ256mk,
  VRCP14PSZ256mkz,
  VRCP14PSZ256r,
  VRCP14PSZ256rk,
  VRCP14PSZ256rkz,
  VRCP14PSZm,
  VRCP14PSZmb,
  VRCP14PSZmbk,
  VRCP14PSZmbkz,
  VRCP14PSZmk,
  VRCP14PSZmkz,
  VRCP14PSZr,
  VRCP14PSZrk,
  VRCP14PSZrkz,
  VRCP14SDZrm,
  VRCP14SDZrmk,
  VRCP14SDZrmkz,
  VRCP14SDZrr,
  VRCP14SDZrrk,
  VRCP14SDZrrkz,
  VRCP14SSZrm,
  VRCP14SSZrmk,
  VRCP14SSZrmkz,
  VRCP14SSZrr,
  VRCP14SSZrrk,
  VRCP14SSZrrkz,
  VRCP28PDZm,
  VRCP28PDZmb,
  VRCP28PDZmbk,
  VRCP28PDZmbkz,
  VRCP28PDZmk,
  VRCP28PDZmkz,
  VRCP28PDZr,
  VRCP28PDZrb,
  VRCP28PDZrbk,
  VRCP28PDZrbkz,
  VRCP28PDZrk,
  VRCP28PDZrkz,
  VRCP28PSZm,
  VRCP28PSZmb,
  VRCP28PSZmbk,
  VRCP28PSZmbkz,
  VRCP28PSZmk,
  VRCP28PSZmkz,
  VRCP28PSZr,
  VRCP28PSZrb,
  VRCP28PSZrbk,
  VRCP28PSZrbkz,
  VRCP28PSZrk,
  VRCP28PSZrkz,
  VRCP28SDZm,
  VRCP28SDZmk,
  VRCP28SDZmkz,
  VRCP28SDZr,
  VRCP28SDZrb,
  VRCP28SDZrbk,
  VRCP28SDZrbkz,
  VRCP28SDZrk,
  VRCP28SDZrkz,
  VRCP28SSZm,
  VRCP28SSZmk,
  VRCP28SSZmkz,
  VRCP28SSZr,
  VRCP28SSZrb,
  VRCP28SSZrbk,
  VRCP28SSZrbkz,
  VRCP28SSZrk,
  VRCP28SSZrkz,
  VRCPPHZ128m,
  VRCPPHZ128mb,
  VRCPPHZ128mbk,
  VRCPPHZ128mbkz,
  VRCPPHZ128mk,
  VRCPPHZ128mkz,
  VRCPPHZ128r,
  VRCPPHZ128rk,
  VRCPPHZ128rkz,
  VRCPPHZ256m,
  VRCPPHZ256mb,
  VRCPPHZ256mbk,
  VRCPPHZ256mbkz,
  VRCPPHZ256mk,
  VRCPPHZ256mkz,
  VRCPPHZ256r,
  VRCPPHZ256rk,
  VRCPPHZ256rkz,
  VRCPPHZm,
  VRCPPHZmb,
  VRCPPHZmbk,
  VRCPPHZmbkz,
  VRCPPHZmk,
  VRCPPHZmkz,
  VRCPPHZr,
  VRCPPHZrk,
  VRCPPHZrkz,
  VRCPPSYm,
  VRCPPSYr,
  VRCPPSm,
  VRCPPSr,
  VRCPSHZrm,
  VRCPSHZrmk,
  VRCPSHZrmkz,
  VRCPSHZrr,
  VRCPSHZrrk,
  VRCPSHZrrkz,
  VRCPSSm,
  VRCPSSm_Int,
  VRCPSSr,
  VRCPSSr_Int,
  VREDUCEPDZ128rmbi,
  VREDUCEPDZ128rmbik,
  VREDUCEPDZ128rmbikz,
  VREDUCEPDZ128rmi,
  VREDUCEPDZ128rmik,
  VREDUCEPDZ128rmikz,
  VREDUCEPDZ128rri,
  VREDUCEPDZ128rrik,
  VREDUCEPDZ128rrikz,
  VREDUCEPDZ256rmbi,
  VREDUCEPDZ256rmbik,
  VREDUCEPDZ256rmbikz,
  VREDUCEPDZ256rmi,
  VREDUCEPDZ256rmik,
  VREDUCEPDZ256rmikz,
  VREDUCEPDZ256rri,
  VREDUCEPDZ256rrik,
  VREDUCEPDZ256rrikz,
  VREDUCEPDZrmbi,
  VREDUCEPDZrmbik,
  VREDUCEPDZrmbikz,
  VREDUCEPDZrmi,
  VREDUCEPDZrmik,
  VREDUCEPDZrmikz,
  VREDUCEPDZrri,
  VREDUCEPDZrrib,
  VREDUCEPDZrribk,
  VREDUCEPDZrribkz,
  VREDUCEPDZrrik,
  VREDUCEPDZrrikz,
  VREDUCEPHZ128rmbi,
  VREDUCEPHZ128rmbik,
  VREDUCEPHZ128rmbikz,
  VREDUCEPHZ128rmi,
  VREDUCEPHZ128rmik,
  VREDUCEPHZ128rmikz,
  VREDUCEPHZ128rri,
  VREDUCEPHZ128rrik,
  VREDUCEPHZ128rrikz,
  VREDUCEPHZ256rmbi,
  VREDUCEPHZ256rmbik,
  VREDUCEPHZ256rmbikz,
  VREDUCEPHZ256rmi,
  VREDUCEPHZ256rmik,
  VREDUCEPHZ256rmikz,
  VREDUCEPHZ256rri,
  VREDUCEPHZ256rrik,
  VREDUCEPHZ256rrikz,
  VREDUCEPHZrmbi,
  VREDUCEPHZrmbik,
  VREDUCEPHZrmbikz,
  VREDUCEPHZrmi,
  VREDUCEPHZrmik,
  VREDUCEPHZrmikz,
  VREDUCEPHZrri,
  VREDUCEPHZrrib,
  VREDUCEPHZrribk,
  VREDUCEPHZrribkz,
  VREDUCEPHZrrik,
  VREDUCEPHZrrikz,
  VREDUCEPSZ128rmbi,
  VREDUCEPSZ128rmbik,
  VREDUCEPSZ128rmbikz,
  VREDUCEPSZ128rmi,
  VREDUCEPSZ128rmik,
  VREDUCEPSZ128rmikz,
  VREDUCEPSZ128rri,
  VREDUCEPSZ128rrik,
  VREDUCEPSZ128rrikz,
  VREDUCEPSZ256rmbi,
  VREDUCEPSZ256rmbik,
  VREDUCEPSZ256rmbikz,
  VREDUCEPSZ256rmi,
  VREDUCEPSZ256rmik,
  VREDUCEPSZ256rmikz,
  VREDUCEPSZ256rri,
  VREDUCEPSZ256rrik,
  VREDUCEPSZ256rrikz,
  VREDUCEPSZrmbi,
  VREDUCEPSZrmbik,
  VREDUCEPSZrmbikz,
  VREDUCEPSZrmi,
  VREDUCEPSZrmik,
  VREDUCEPSZrmikz,
  VREDUCEPSZrri,
  VREDUCEPSZrrib,
  VREDUCEPSZrribk,
  VREDUCEPSZrribkz,
  VREDUCEPSZrrik,
  VREDUCEPSZrrikz,
  VREDUCESDZrmi,
  VREDUCESDZrmik,
  VREDUCESDZrmikz,
  VREDUCESDZrri,
  VREDUCESDZrrib,
  VREDUCESDZrribk,
  VREDUCESDZrribkz,
  VREDUCESDZrrik,
  VREDUCESDZrrikz,
  VREDUCESHZrmi,
  VREDUCESHZrmik,
  VREDUCESHZrmikz,
  VREDUCESHZrri,
  VREDUCESHZrrib,
  VREDUCESHZrribk,
  VREDUCESHZrribkz,
  VREDUCESHZrrik,
  VREDUCESHZrrikz,
  VREDUCESSZrmi,
  VREDUCESSZrmik,
  VREDUCESSZrmikz,
  VREDUCESSZrri,
  VREDUCESSZrrib,
  VREDUCESSZrribk,
  VREDUCESSZrribkz,
  VREDUCESSZrrik,
  VREDUCESSZrrikz,
  VRNDSCALEPDZ128rmbi,
  VRNDSCALEPDZ128rmbik,
  VRNDSCALEPDZ128rmbikz,
  VRNDSCALEPDZ128rmi,
  VRNDSCALEPDZ128rmik,
  VRNDSCALEPDZ128rmikz,
  VRNDSCALEPDZ128rri,
  VRNDSCALEPDZ128rrik,
  VRNDSCALEPDZ128rrikz,
  VRNDSCALEPDZ256rmbi,
  VRNDSCALEPDZ256rmbik,
  VRNDSCALEPDZ256rmbikz,
  VRNDSCALEPDZ256rmi,
  VRNDSCALEPDZ256rmik,
  VRNDSCALEPDZ256rmikz,
  VRNDSCALEPDZ256rri,
  VRNDSCALEPDZ256rrik,
  VRNDSCALEPDZ256rrikz,
  VRNDSCALEPDZrmbi,
  VRNDSCALEPDZrmbik,
  VRNDSCALEPDZrmbikz,
  VRNDSCALEPDZrmi,
  VRNDSCALEPDZrmik,
  VRNDSCALEPDZrmikz,
  VRNDSCALEPDZrri,
  VRNDSCALEPDZrrib,
  VRNDSCALEPDZrribk,
  VRNDSCALEPDZrribkz,
  VRNDSCALEPDZrrik,
  VRNDSCALEPDZrrikz,
  VRNDSCALEPHZ128rmbi,
  VRNDSCALEPHZ128rmbik,
  VRNDSCALEPHZ128rmbikz,
  VRNDSCALEPHZ128rmi,
  VRNDSCALEPHZ128rmik,
  VRNDSCALEPHZ128rmikz,
  VRNDSCALEPHZ128rri,
  VRNDSCALEPHZ128rrik,
  VRNDSCALEPHZ128rrikz,
  VRNDSCALEPHZ256rmbi,
  VRNDSCALEPHZ256rmbik,
  VRNDSCALEPHZ256rmbikz,
  VRNDSCALEPHZ256rmi,
  VRNDSCALEPHZ256rmik,
  VRNDSCALEPHZ256rmikz,
  VRNDSCALEPHZ256rri,
  VRNDSCALEPHZ256rrik,
  VRNDSCALEPHZ256rrikz,
  VRNDSCALEPHZrmbi,
  VRNDSCALEPHZrmbik,
  VRNDSCALEPHZrmbikz,
  VRNDSCALEPHZrmi,
  VRNDSCALEPHZrmik,
  VRNDSCALEPHZrmikz,
  VRNDSCALEPHZrri,
  VRNDSCALEPHZrrib,
  VRNDSCALEPHZrribk,
  VRNDSCALEPHZrribkz,
  VRNDSCALEPHZrrik,
  VRNDSCALEPHZrrikz,
  VRNDSCALEPSZ128rmbi,
  VRNDSCALEPSZ128rmbik,
  VRNDSCALEPSZ128rmbikz,
  VRNDSCALEPSZ128rmi,
  VRNDSCALEPSZ128rmik,
  VRNDSCALEPSZ128rmikz,
  VRNDSCALEPSZ128rri,
  VRNDSCALEPSZ128rrik,
  VRNDSCALEPSZ128rrikz,
  VRNDSCALEPSZ256rmbi,
  VRNDSCALEPSZ256rmbik,
  VRNDSCALEPSZ256rmbikz,
  VRNDSCALEPSZ256rmi,
  VRNDSCALEPSZ256rmik,
  VRNDSCALEPSZ256rmikz,
  VRNDSCALEPSZ256rri,
  VRNDSCALEPSZ256rrik,
  VRNDSCALEPSZ256rrikz,
  VRNDSCALEPSZrmbi,
  VRNDSCALEPSZrmbik,
  VRNDSCALEPSZrmbikz,
  VRNDSCALEPSZrmi,
  VRNDSCALEPSZrmik,
  VRNDSCALEPSZrmikz,
  VRNDSCALEPSZrri,
  VRNDSCALEPSZrrib,
  VRNDSCALEPSZrribk,
  VRNDSCALEPSZrribkz,
  VRNDSCALEPSZrrik,
  VRNDSCALEPSZrrikz,
  VRNDSCALESDZm,
  VRNDSCALESDZm_Int,
  VRNDSCALESDZm_Intk,
  VRNDSCALESDZm_Intkz,
  VRNDSCALESDZr,
  VRNDSCALESDZr_Int,
  VRNDSCALESDZr_Intk,
  VRNDSCALESDZr_Intkz,
  VRNDSCALESDZrb_Int,
  VRNDSCALESDZrb_Intk,
  VRNDSCALESDZrb_Intkz,
  VRNDSCALESHZm,
  VRNDSCALESHZm_Int,
  VRNDSCALESHZm_Intk,
  VRNDSCALESHZm_Intkz,
  VRNDSCALESHZr,
  VRNDSCALESHZr_Int,
  VRNDSCALESHZr_Intk,
  VRNDSCALESHZr_Intkz,
  VRNDSCALESHZrb_Int,
  VRNDSCALESHZrb_Intk,
  VRNDSCALESHZrb_Intkz,
  VRNDSCALESSZm,
  VRNDSCALESSZm_Int,
  VRNDSCALESSZm_Intk,
  VRNDSCALESSZm_Intkz,
  VRNDSCALESSZr,
  VRNDSCALESSZr_Int,
  VRNDSCALESSZr_Intk,
  VRNDSCALESSZr_Intkz,
  VRNDSCALESSZrb_Int,
  VRNDSCALESSZrb_Intk,
  VRNDSCALESSZrb_Intkz,
  VROUNDPDYmi,
  VROUNDPDYri,
  VROUNDPDmi,
  VROUNDPDri,
  VROUNDPSYmi,
  VROUNDPSYri,
  VROUNDPSmi,
  VROUNDPSri,
  VROUNDSDmi,
  VROUNDSDmi_Int,
  VROUNDSDri,
  VROUNDSDri_Int,
  VROUNDSSmi,
  VROUNDSSmi_Int,
  VROUNDSSri,
  VROUNDSSri_Int,
  VRSQRT14PDZ128m,
  VRSQRT14PDZ128mb,
  VRSQRT14PDZ128mbk,
  VRSQRT14PDZ128mbkz,
  VRSQRT14PDZ128mk,
  VRSQRT14PDZ128mkz,
  VRSQRT14PDZ128r,
  VRSQRT14PDZ128rk,
  VRSQRT14PDZ128rkz,
  VRSQRT14PDZ256m,
  VRSQRT14PDZ256mb,
  VRSQRT14PDZ256mbk,
  VRSQRT14PDZ256mbkz,
  VRSQRT14PDZ256mk,
  VRSQRT14PDZ256mkz,
  VRSQRT14PDZ256r,
  VRSQRT14PDZ256rk,
  VRSQRT14PDZ256rkz,
  VRSQRT14PDZm,
  VRSQRT14PDZmb,
  VRSQRT14PDZmbk,
  VRSQRT14PDZmbkz,
  VRSQRT14PDZmk,
  VRSQRT14PDZmkz,
  VRSQRT14PDZr,
  VRSQRT14PDZrk,
  VRSQRT14PDZrkz,
  VRSQRT14PSZ128m,
  VRSQRT14PSZ128mb,
  VRSQRT14PSZ128mbk,
  VRSQRT14PSZ128mbkz,
  VRSQRT14PSZ128mk,
  VRSQRT14PSZ128mkz,
  VRSQRT14PSZ128r,
  VRSQRT14PSZ128rk,
  VRSQRT14PSZ128rkz,
  VRSQRT14PSZ256m,
  VRSQRT14PSZ256mb,
  VRSQRT14PSZ256mbk,
  VRSQRT14PSZ256mbkz,
  VRSQRT14PSZ256mk,
  VRSQRT14PSZ256mkz,
  VRSQRT14PSZ256r,
  VRSQRT14PSZ256rk,
  VRSQRT14PSZ256rkz,
  VRSQRT14PSZm,
  VRSQRT14PSZmb,
  VRSQRT14PSZmbk,
  VRSQRT14PSZmbkz,
  VRSQRT14PSZmk,
  VRSQRT14PSZmkz,
  VRSQRT14PSZr,
  VRSQRT14PSZrk,
  VRSQRT14PSZrkz,
  VRSQRT14SDZrm,
  VRSQRT14SDZrmk,
  VRSQRT14SDZrmkz,
  VRSQRT14SDZrr,
  VRSQRT14SDZrrk,
  VRSQRT14SDZrrkz,
  VRSQRT14SSZrm,
  VRSQRT14SSZrmk,
  VRSQRT14SSZrmkz,
  VRSQRT14SSZrr,
  VRSQRT14SSZrrk,
  VRSQRT14SSZrrkz,
  VRSQRT28PDZm,
  VRSQRT28PDZmb,
  VRSQRT28PDZmbk,
  VRSQRT28PDZmbkz,
  VRSQRT28PDZmk,
  VRSQRT28PDZmkz,
  VRSQRT28PDZr,
  VRSQRT28PDZrb,
  VRSQRT28PDZrbk,
  VRSQRT28PDZrbkz,
  VRSQRT28PDZrk,
  VRSQRT28PDZrkz,
  VRSQRT28PSZm,
  VRSQRT28PSZmb,
  VRSQRT28PSZmbk,
  VRSQRT28PSZmbkz,
  VRSQRT28PSZmk,
  VRSQRT28PSZmkz,
  VRSQRT28PSZr,
  VRSQRT28PSZrb,
  VRSQRT28PSZrbk,
  VRSQRT28PSZrbkz,
  VRSQRT28PSZrk,
  VRSQRT28PSZrkz,
  VRSQRT28SDZm,
  VRSQRT28SDZmk,
  VRSQRT28SDZmkz,
  VRSQRT28SDZr,
  VRSQRT28SDZrb,
  VRSQRT28SDZrbk,
  VRSQRT28SDZrbkz,
  VRSQRT28SDZrk,
  VRSQRT28SDZrkz,
  VRSQRT28SSZm,
  VRSQRT28SSZmk,
  VRSQRT28SSZmkz,
  VRSQRT28SSZr,
  VRSQRT28SSZrb,
  VRSQRT28SSZrbk,
  VRSQRT28SSZrbkz,
  VRSQRT28SSZrk,
  VRSQRT28SSZrkz,
  VRSQRTPHZ128m,
  VRSQRTPHZ128mb,
  VRSQRTPHZ128mbk,
  VRSQRTPHZ128mbkz,
  VRSQRTPHZ128mk,
  VRSQRTPHZ128mkz,
  VRSQRTPHZ128r,
  VRSQRTPHZ128rk,
  VRSQRTPHZ128rkz,
  VRSQRTPHZ256m,
  VRSQRTPHZ256mb,
  VRSQRTPHZ256mbk,
  VRSQRTPHZ256mbkz,
  VRSQRTPHZ256mk,
  VRSQRTPHZ256mkz,
  VRSQRTPHZ256r,
  VRSQRTPHZ256rk,
  VRSQRTPHZ256rkz,
  VRSQRTPHZm,
  VRSQRTPHZmb,
  VRSQRTPHZmbk,
  VRSQRTPHZmbkz,
  VRSQRTPHZmk,
  VRSQRTPHZmkz,
  VRSQRTPHZr,
  VRSQRTPHZrk,
  VRSQRTPHZrkz,
  VRSQRTPSYm,
  VRSQRTPSYr,
  VRSQRTPSm,
  VRSQRTPSr,
  VRSQRTSHZrm,
  VRSQRTSHZrmk,
  VRSQRTSHZrmkz,
  VRSQRTSHZrr,
  VRSQRTSHZrrk,
  VRSQRTSHZrrkz,
  VRSQRTSSm,
  VRSQRTSSm_Int,
  VRSQRTSSr,
  VRSQRTSSr_Int,
  VSCALEFPDZ128rm,
  VSCALEFPDZ128rmb,
  VSCALEFPDZ128rmbk,
  VSCALEFPDZ128rmbkz,
  VSCALEFPDZ128rmk,
  VSCALEFPDZ128rmkz,
  VSCALEFPDZ128rr,
  VSCALEFPDZ128rrk,
  VSCALEFPDZ128rrkz,
  VSCALEFPDZ256rm,
  VSCALEFPDZ256rmb,
  VSCALEFPDZ256rmbk,
  VSCALEFPDZ256rmbkz,
  VSCALEFPDZ256rmk,
  VSCALEFPDZ256rmkz,
  VSCALEFPDZ256rr,
  VSCALEFPDZ256rrk,
  VSCALEFPDZ256rrkz,
  VSCALEFPDZrm,
  VSCALEFPDZrmb,
  VSCALEFPDZrmbk,
  VSCALEFPDZrmbkz,
  VSCALEFPDZrmk,
  VSCALEFPDZrmkz,
  VSCALEFPDZrr,
  VSCALEFPDZrrb,
  VSCALEFPDZrrbk,
  VSCALEFPDZrrbkz,
  VSCALEFPDZrrk,
  VSCALEFPDZrrkz,
  VSCALEFPHZ128rm,
  VSCALEFPHZ128rmb,
  VSCALEFPHZ128rmbk,
  VSCALEFPHZ128rmbkz,
  VSCALEFPHZ128rmk,
  VSCALEFPHZ128rmkz,
  VSCALEFPHZ128rr,
  VSCALEFPHZ128rrk,
  VSCALEFPHZ128rrkz,
  VSCALEFPHZ256rm,
  VSCALEFPHZ256rmb,
  VSCALEFPHZ256rmbk,
  VSCALEFPHZ256rmbkz,
  VSCALEFPHZ256rmk,
  VSCALEFPHZ256rmkz,
  VSCALEFPHZ256rr,
  VSCALEFPHZ256rrk,
  VSCALEFPHZ256rrkz,
  VSCALEFPHZrm,
  VSCALEFPHZrmb,
  VSCALEFPHZrmbk,
  VSCALEFPHZrmbkz,
  VSCALEFPHZrmk,
  VSCALEFPHZrmkz,
  VSCALEFPHZrr,
  VSCALEFPHZrrb,
  VSCALEFPHZrrbk,
  VSCALEFPHZrrbkz,
  VSCALEFPHZrrk,
  VSCALEFPHZrrkz,
  VSCALEFPSZ128rm,
  VSCALEFPSZ128rmb,
  VSCALEFPSZ128rmbk,
  VSCALEFPSZ128rmbkz,
  VSCALEFPSZ128rmk,
  VSCALEFPSZ128rmkz,
  VSCALEFPSZ128rr,
  VSCALEFPSZ128rrk,
  VSCALEFPSZ128rrkz,
  VSCALEFPSZ256rm,
  VSCALEFPSZ256rmb,
  VSCALEFPSZ256rmbk,
  VSCALEFPSZ256rmbkz,
  VSCALEFPSZ256rmk,
  VSCALEFPSZ256rmkz,
  VSCALEFPSZ256rr,
  VSCALEFPSZ256rrk,
  VSCALEFPSZ256rrkz,
  VSCALEFPSZrm,
  VSCALEFPSZrmb,
  VSCALEFPSZrmbk,
  VSCALEFPSZrmbkz,
  VSCALEFPSZrmk,
  VSCALEFPSZrmkz,
  VSCALEFPSZrr,
  VSCALEFPSZrrb,
  VSCALEFPSZrrbk,
  VSCALEFPSZrrbkz,
  VSCALEFPSZrrk,
  VSCALEFPSZrrkz,
  VSCALEFSDZrm,
  VSCALEFSDZrmk,
  VSCALEFSDZrmkz,
  VSCALEFSDZrr,
  VSCALEFSDZrrb_Int,
  VSCALEFSDZrrb_Intk,
  VSCALEFSDZrrb_Intkz,
  VSCALEFSDZrrk,
  VSCALEFSDZrrkz,
  VSCALEFSHZrm,
  VSCALEFSHZrmk,
  VSCALEFSHZrmkz,
  VSCALEFSHZrr,
  VSCALEFSHZrrb_Int,
  VSCALEFSHZrrb_Intk,
  VSCALEFSHZrrb_Intkz,
  VSCALEFSHZrrk,
  VSCALEFSHZrrkz,
  VSCALEFSSZrm,
  VSCALEFSSZrmk,
  VSCALEFSSZrmkz,
  VSCALEFSSZrr,
  VSCALEFSSZrrb_Int,
  VSCALEFSSZrrb_Intk,
  VSCALEFSSZrrb_Intkz,
  VSCALEFSSZrrk,
  VSCALEFSSZrrkz,
  VSCATTERDPDZ128mr,
  VSCATTERDPDZ256mr,
  VSCATTERDPDZmr,
  VSCATTERDPSZ128mr,
  VSCATTERDPSZ256mr,
  VSCATTERDPSZmr,
  VSCATTERPF0DPDm,
  VSCATTERPF0DPSm,
  VSCATTERPF0QPDm,
  VSCATTERPF0QPSm,
  VSCATTERPF1DPDm,
  VSCATTERPF1DPSm,
  VSCATTERPF1QPDm,
  VSCATTERPF1QPSm,
  VSCATTERQPDZ128mr,
  VSCATTERQPDZ256mr,
  VSCATTERQPDZmr,
  VSCATTERQPSZ128mr,
  VSCATTERQPSZ256mr,
  VSCATTERQPSZmr,
  VSHA512MSG1rr,
  VSHA512MSG2rr,
  VSHA512RNDS2rr,
  VSHUFF32X4Z256rmbi,
  VSHUFF32X4Z256rmbik,
  VSHUFF32X4Z256rmbikz,
  VSHUFF32X4Z256rmi,
  VSHUFF32X4Z256rmik,
  VSHUFF32X4Z256rmikz,
  VSHUFF32X4Z256rri,
  VSHUFF32X4Z256rrik,
  VSHUFF32X4Z256rrikz,
  VSHUFF32X4Zrmbi,
  VSHUFF32X4Zrmbik,
  VSHUFF32X4Zrmbikz,
  VSHUFF32X4Zrmi,
  VSHUFF32X4Zrmik,
  VSHUFF32X4Zrmikz,
  VSHUFF32X4Zrri,
  VSHUFF32X4Zrrik,
  VSHUFF32X4Zrrikz,
  VSHUFF64X2Z256rmbi,
  VSHUFF64X2Z256rmbik,
  VSHUFF64X2Z256rmbikz,
  VSHUFF64X2Z256rmi,
  VSHUFF64X2Z256rmik,
  VSHUFF64X2Z256rmikz,
  VSHUFF64X2Z256rri,
  VSHUFF64X2Z256rrik,
  VSHUFF64X2Z256rrikz,
  VSHUFF64X2Zrmbi,
  VSHUFF64X2Zrmbik,
  VSHUFF64X2Zrmbikz,
  VSHUFF64X2Zrmi,
  VSHUFF64X2Zrmik,
  VSHUFF64X2Zrmikz,
  VSHUFF64X2Zrri,
  VSHUFF64X2Zrrik,
  VSHUFF64X2Zrrikz,
  VSHUFI32X4Z256rmbi,
  VSHUFI32X4Z256rmbik,
  VSHUFI32X4Z256rmbikz,
  VSHUFI32X4Z256rmi,
  VSHUFI32X4Z256rmik,
  VSHUFI32X4Z256rmikz,
  VSHUFI32X4Z256rri,
  VSHUFI32X4Z256rrik,
  VSHUFI32X4Z256rrikz,
  VSHUFI32X4Zrmbi,
  VSHUFI32X4Zrmbik,
  VSHUFI32X4Zrmbikz,
  VSHUFI32X4Zrmi,
  VSHUFI32X4Zrmik,
  VSHUFI32X4Zrmikz,
  VSHUFI32X4Zrri,
  VSHUFI32X4Zrrik,
  VSHUFI32X4Zrrikz,
  VSHUFI64X2Z256rmbi,
  VSHUFI64X2Z256rmbik,
  VSHUFI64X2Z256rmbikz,
  VSHUFI64X2Z256rmi,
  VSHUFI64X2Z256rmik,
  VSHUFI64X2Z256rmikz,
  VSHUFI64X2Z256rri,
  VSHUFI64X2Z256rrik,
  VSHUFI64X2Z256rrikz,
  VSHUFI64X2Zrmbi,
  VSHUFI64X2Zrmbik,
  VSHUFI64X2Zrmbikz,
  VSHUFI64X2Zrmi,
  VSHUFI64X2Zrmik,
  VSHUFI64X2Zrmikz,
  VSHUFI64X2Zrri,
  VSHUFI64X2Zrrik,
  VSHUFI64X2Zrrikz,
  VSHUFPDYrmi,
  VSHUFPDYrri,
  VSHUFPDZ128rmbi,
  VSHUFPDZ128rmbik,
  VSHUFPDZ128rmbikz,
  VSHUFPDZ128rmi,
  VSHUFPDZ128rmik,
  VSHUFPDZ128rmikz,
  VSHUFPDZ128rri,
  VSHUFPDZ128rrik,
  VSHUFPDZ128rrikz,
  VSHUFPDZ256rmbi,
  VSHUFPDZ256rmbik,
  VSHUFPDZ256rmbikz,
  VSHUFPDZ256rmi,
  VSHUFPDZ256rmik,
  VSHUFPDZ256rmikz,
  VSHUFPDZ256rri,
  VSHUFPDZ256rrik,
  VSHUFPDZ256rrikz,
  VSHUFPDZrmbi,
  VSHUFPDZrmbik,
  VSHUFPDZrmbikz,
  VSHUFPDZrmi,
  VSHUFPDZrmik,
  VSHUFPDZrmikz,
  VSHUFPDZrri,
  VSHUFPDZrrik,
  VSHUFPDZrrikz,
  VSHUFPDrmi,
  VSHUFPDrri,
  VSHUFPSYrmi,
  VSHUFPSYrri,
  VSHUFPSZ128rmbi,
  VSHUFPSZ128rmbik,
  VSHUFPSZ128rmbikz,
  VSHUFPSZ128rmi,
  VSHUFPSZ128rmik,
  VSHUFPSZ128rmikz,
  VSHUFPSZ128rri,
  VSHUFPSZ128rrik,
  VSHUFPSZ128rrikz,
  VSHUFPSZ256rmbi,
  VSHUFPSZ256rmbik,
  VSHUFPSZ256rmbikz,
  VSHUFPSZ256rmi,
  VSHUFPSZ256rmik,
  VSHUFPSZ256rmikz,
  VSHUFPSZ256rri,
  VSHUFPSZ256rrik,
  VSHUFPSZ256rrikz,
  VSHUFPSZrmbi,
  VSHUFPSZrmbik,
  VSHUFPSZrmbikz,
  VSHUFPSZrmi,
  VSHUFPSZrmik,
  VSHUFPSZrmikz,
  VSHUFPSZrri,
  VSHUFPSZrrik,
  VSHUFPSZrrikz,
  VSHUFPSrmi,
  VSHUFPSrri,
  VSM3MSG1rm,
  VSM3MSG1rr,
  VSM3MSG2rm,
  VSM3MSG2rr,
  VSM3RNDS2rm,
  VSM3RNDS2rr,
  VSM4KEY4Yrm,
  VSM4KEY4Yrr,
  VSM4KEY4rm,
  VSM4KEY4rr,
  VSM4RNDS4Yrm,
  VSM4RNDS4Yrr,
  VSM4RNDS4rm,
  VSM4RNDS4rr,
  VSQRTPDYm,
  VSQRTPDYr,
  VSQRTPDZ128m,
  VSQRTPDZ128mb,
  VSQRTPDZ128mbk,
  VSQRTPDZ128mbkz,
  VSQRTPDZ128mk,
  VSQRTPDZ128mkz,
  VSQRTPDZ128r,
  VSQRTPDZ128rk,
  VSQRTPDZ128rkz,
  VSQRTPDZ256m,
  VSQRTPDZ256mb,
  VSQRTPDZ256mbk,
  VSQRTPDZ256mbkz,
  VSQRTPDZ256mk,
  VSQRTPDZ256mkz,
  VSQRTPDZ256r,
  VSQRTPDZ256rk,
  VSQRTPDZ256rkz,
  VSQRTPDZm,
  VSQRTPDZmb,
  VSQRTPDZmbk,
  VSQRTPDZmbkz,
  VSQRTPDZmk,
  VSQRTPDZmkz,
  VSQRTPDZr,
  VSQRTPDZrb,
  VSQRTPDZrbk,
  VSQRTPDZrbkz,
  VSQRTPDZrk,
  VSQRTPDZrkz,
  VSQRTPDm,
  VSQRTPDr,
  VSQRTPHZ128m,
  VSQRTPHZ128mb,
  VSQRTPHZ128mbk,
  VSQRTPHZ128mbkz,
  VSQRTPHZ128mk,
  VSQRTPHZ128mkz,
  VSQRTPHZ128r,
  VSQRTPHZ128rk,
  VSQRTPHZ128rkz,
  VSQRTPHZ256m,
  VSQRTPHZ256mb,
  VSQRTPHZ256mbk,
  VSQRTPHZ256mbkz,
  VSQRTPHZ256mk,
  VSQRTPHZ256mkz,
  VSQRTPHZ256r,
  VSQRTPHZ256rk,
  VSQRTPHZ256rkz,
  VSQRTPHZm,
  VSQRTPHZmb,
  VSQRTPHZmbk,
  VSQRTPHZmbkz,
  VSQRTPHZmk,
  VSQRTPHZmkz,
  VSQRTPHZr,
  VSQRTPHZrb,
  VSQRTPHZrbk,
  VSQRTPHZrbkz,
  VSQRTPHZrk,
  VSQRTPHZrkz,
  VSQRTPSYm,
  VSQRTPSYr,
  VSQRTPSZ128m,
  VSQRTPSZ128mb,
  VSQRTPSZ128mbk,
  VSQRTPSZ128mbkz,
  VSQRTPSZ128mk,
  VSQRTPSZ128mkz,
  VSQRTPSZ128r,
  VSQRTPSZ128rk,
  VSQRTPSZ128rkz,
  VSQRTPSZ256m,
  VSQRTPSZ256mb,
  VSQRTPSZ256mbk,
  VSQRTPSZ256mbkz,
  VSQRTPSZ256mk,
  VSQRTPSZ256mkz,
  VSQRTPSZ256r,
  VSQRTPSZ256rk,
  VSQRTPSZ256rkz,
  VSQRTPSZm,
  VSQRTPSZmb,
  VSQRTPSZmbk,
  VSQRTPSZmbkz,
  VSQRTPSZmk,
  VSQRTPSZmkz,
  VSQRTPSZr,
  VSQRTPSZrb,
  VSQRTPSZrbk,
  VSQRTPSZrbkz,
  VSQRTPSZrk,
  VSQRTPSZrkz,
  VSQRTPSm,
  VSQRTPSr,
  VSQRTSDZm,
  VSQRTSDZm_Int,
  VSQRTSDZm_Intk,
  VSQRTSDZm_Intkz,
  VSQRTSDZr,
  VSQRTSDZr_Int,
  VSQRTSDZr_Intk,
  VSQRTSDZr_Intkz,
  VSQRTSDZrb_Int,
  VSQRTSDZrb_Intk,
  VSQRTSDZrb_Intkz,
  VSQRTSDm,
  VSQRTSDm_Int,
  VSQRTSDr,
  VSQRTSDr_Int,
  VSQRTSHZm,
  VSQRTSHZm_Int,
  VSQRTSHZm_Intk,
  VSQRTSHZm_Intkz,
  VSQRTSHZr,
  VSQRTSHZr_Int,
  VSQRTSHZr_Intk,
  VSQRTSHZr_Intkz,
  VSQRTSHZrb_Int,
  VSQRTSHZrb_Intk,
  VSQRTSHZrb_Intkz,
  VSQRTSSZm,
  VSQRTSSZm_Int,
  VSQRTSSZm_Intk,
  VSQRTSSZm_Intkz,
  VSQRTSSZr,
  VSQRTSSZr_Int,
  VSQRTSSZr_Intk,
  VSQRTSSZr_Intkz,
  VSQRTSSZrb_Int,
  VSQRTSSZrb_Intk,
  VSQRTSSZrb_Intkz,
  VSQRTSSm,
  VSQRTSSm_Int,
  VSQRTSSr,
  VSQRTSSr_Int,
  VSTMXCSR,
  VSUBPDYrm,
  VSUBPDYrr,
  VSUBPDZ128rm,
  VSUBPDZ128rmb,
  VSUBPDZ128rmbk,
  VSUBPDZ128rmbkz,
  VSUBPDZ128rmk,
  VSUBPDZ128rmkz,
  VSUBPDZ128rr,
  VSUBPDZ128rrk,
  VSUBPDZ128rrkz,
  VSUBPDZ256rm,
  VSUBPDZ256rmb,
  VSUBPDZ256rmbk,
  VSUBPDZ256rmbkz,
  VSUBPDZ256rmk,
  VSUBPDZ256rmkz,
  VSUBPDZ256rr,
  VSUBPDZ256rrk,
  VSUBPDZ256rrkz,
  VSUBPDZrm,
  VSUBPDZrmb,
  VSUBPDZrmbk,
  VSUBPDZrmbkz,
  VSUBPDZrmk,
  VSUBPDZrmkz,
  VSUBPDZrr,
  VSUBPDZrrb,
  VSUBPDZrrbk,
  VSUBPDZrrbkz,
  VSUBPDZrrk,
  VSUBPDZrrkz,
  VSUBPDrm,
  VSUBPDrr,
  VSUBPHZ128rm,
  VSUBPHZ128rmb,
  VSUBPHZ128rmbk,
  VSUBPHZ128rmbkz,
  VSUBPHZ128rmk,
  VSUBPHZ128rmkz,
  VSUBPHZ128rr,
  VSUBPHZ128rrk,
  VSUBPHZ128rrkz,
  VSUBPHZ256rm,
  VSUBPHZ256rmb,
  VSUBPHZ256rmbk,
  VSUBPHZ256rmbkz,
  VSUBPHZ256rmk,
  VSUBPHZ256rmkz,
  VSUBPHZ256rr,
  VSUBPHZ256rrk,
  VSUBPHZ256rrkz,
  VSUBPHZrm,
  VSUBPHZrmb,
  VSUBPHZrmbk,
  VSUBPHZrmbkz,
  VSUBPHZrmk,
  VSUBPHZrmkz,
  VSUBPHZrr,
  VSUBPHZrrb,
  VSUBPHZrrbk,
  VSUBPHZrrbkz,
  VSUBPHZrrk,
  VSUBPHZrrkz,
  VSUBPSYrm,
  VSUBPSYrr,
  VSUBPSZ128rm,
  VSUBPSZ128rmb,
  VSUBPSZ128rmbk,
  VSUBPSZ128rmbkz,
  VSUBPSZ128rmk,
  VSUBPSZ128rmkz,
  VSUBPSZ128rr,
  VSUBPSZ128rrk,
  VSUBPSZ128rrkz,
  VSUBPSZ256rm,
  VSUBPSZ256rmb,
  VSUBPSZ256rmbk,
  VSUBPSZ256rmbkz,
  VSUBPSZ256rmk,
  VSUBPSZ256rmkz,
  VSUBPSZ256rr,
  VSUBPSZ256rrk,
  VSUBPSZ256rrkz,
  VSUBPSZrm,
  VSUBPSZrmb,
  VSUBPSZrmbk,
  VSUBPSZrmbkz,
  VSUBPSZrmk,
  VSUBPSZrmkz,
  VSUBPSZrr,
  VSUBPSZrrb,
  VSUBPSZrrbk,
  VSUBPSZrrbkz,
  VSUBPSZrrk,
  VSUBPSZrrkz,
  VSUBPSrm,
  VSUBPSrr,
  VSUBSDZrm,
  VSUBSDZrm_Int,
  VSUBSDZrm_Intk,
  VSUBSDZrm_Intkz,
  VSUBSDZrr,
  VSUBSDZrr_Int,
  VSUBSDZrr_Intk,
  VSUBSDZrr_Intkz,
  VSUBSDZrrb_Int,
  VSUBSDZrrb_Intk,
  VSUBSDZrrb_Intkz,
  VSUBSDrm,
  VSUBSDrm_Int,
  VSUBSDrr,
  VSUBSDrr_Int,
  VSUBSHZrm,
  VSUBSHZrm_Int,
  VSUBSHZrm_Intk,
  VSUBSHZrm_Intkz,
  VSUBSHZrr,
  VSUBSHZrr_Int,
  VSUBSHZrr_Intk,
  VSUBSHZrr_Intkz,
  VSUBSHZrrb_Int,
  VSUBSHZrrb_Intk,
  VSUBSHZrrb_Intkz,
  VSUBSSZrm,
  VSUBSSZrm_Int,
  VSUBSSZrm_Intk,
  VSUBSSZrm_Intkz,
  VSUBSSZrr,
  VSUBSSZrr_Int,
  VSUBSSZrr_Intk,
  VSUBSSZrr_Intkz,
  VSUBSSZrrb_Int,
  VSUBSSZrrb_Intk,
  VSUBSSZrrb_Intkz,
  VSUBSSrm,
  VSUBSSrm_Int,
  VSUBSSrr,
  VSUBSSrr_Int,
  VTESTPDYrm,
  VTESTPDYrr,
  VTESTPDrm,
  VTESTPDrr,
  VTESTPSYrm,
  VTESTPSYrr,
  VTESTPSrm,
  VTESTPSrr,
  VUCOMISDZrm,
  VUCOMISDZrm_Int,
  VUCOMISDZrr,
  VUCOMISDZrr_Int,
  VUCOMISDZrrb,
  VUCOMISDrm,
  VUCOMISDrm_Int,
  VUCOMISDrr,
  VUCOMISDrr_Int,
  VUCOMISHZrm,
  VUCOMISHZrm_Int,
  VUCOMISHZrr,
  VUCOMISHZrr_Int,
  VUCOMISHZrrb,
  VUCOMISSZrm,
  VUCOMISSZrm_Int,
  VUCOMISSZrr,
  VUCOMISSZrr_Int,
  VUCOMISSZrrb,
  VUCOMISSrm,
  VUCOMISSrm_Int,
  VUCOMISSrr,
  VUCOMISSrr_Int,
  VUNPCKHPDYrm,
  VUNPCKHPDYrr,
  VUNPCKHPDZ128rm,
  VUNPCKHPDZ128rmb,
  VUNPCKHPDZ128rmbk,
  VUNPCKHPDZ128rmbkz,
  VUNPCKHPDZ128rmk,
  VUNPCKHPDZ128rmkz,
  VUNPCKHPDZ128rr,
  VUNPCKHPDZ128rrk,
  VUNPCKHPDZ128rrkz,
  VUNPCKHPDZ256rm,
  VUNPCKHPDZ256rmb,
  VUNPCKHPDZ256rmbk,
  VUNPCKHPDZ256rmbkz,
  VUNPCKHPDZ256rmk,
  VUNPCKHPDZ256rmkz,
  VUNPCKHPDZ256rr,
  VUNPCKHPDZ256rrk,
  VUNPCKHPDZ256rrkz,
  VUNPCKHPDZrm,
  VUNPCKHPDZrmb,
  VUNPCKHPDZrmbk,
  VUNPCKHPDZrmbkz,
  VUNPCKHPDZrmk,
  VUNPCKHPDZrmkz,
  VUNPCKHPDZrr,
  VUNPCKHPDZrrk,
  VUNPCKHPDZrrkz,
  VUNPCKHPDrm,
  VUNPCKHPDrr,
  VUNPCKHPSYrm,
  VUNPCKHPSYrr,
  VUNPCKHPSZ128rm,
  VUNPCKHPSZ128rmb,
  VUNPCKHPSZ128rmbk,
  VUNPCKHPSZ128rmbkz,
  VUNPCKHPSZ128rmk,
  VUNPCKHPSZ128rmkz,
  VUNPCKHPSZ128rr,
  VUNPCKHPSZ128rrk,
  VUNPCKHPSZ128rrkz,
  VUNPCKHPSZ256rm,
  VUNPCKHPSZ256rmb,
  VUNPCKHPSZ256rmbk,
  VUNPCKHPSZ256rmbkz,
  VUNPCKHPSZ256rmk,
  VUNPCKHPSZ256rmkz,
  VUNPCKHPSZ256rr,
  VUNPCKHPSZ256rrk,
  VUNPCKHPSZ256rrkz,
  VUNPCKHPSZrm,
  VUNPCKHPSZrmb,
  VUNPCKHPSZrmbk,
  VUNPCKHPSZrmbkz,
  VUNPCKHPSZrmk,
  VUNPCKHPSZrmkz,
  VUNPCKHPSZrr,
  VUNPCKHPSZrrk,
  VUNPCKHPSZrrkz,
  VUNPCKHPSrm,
  VUNPCKHPSrr,
  VUNPCKLPDYrm,
  VUNPCKLPDYrr,
  VUNPCKLPDZ128rm,
  VUNPCKLPDZ128rmb,
  VUNPCKLPDZ128rmbk,
  VUNPCKLPDZ128rmbkz,
  VUNPCKLPDZ128rmk,
  VUNPCKLPDZ128rmkz,
  VUNPCKLPDZ128rr,
  VUNPCKLPDZ128rrk,
  VUNPCKLPDZ128rrkz,
  VUNPCKLPDZ256rm,
  VUNPCKLPDZ256rmb,
  VUNPCKLPDZ256rmbk,
  VUNPCKLPDZ256rmbkz,
  VUNPCKLPDZ256rmk,
  VUNPCKLPDZ256rmkz,
  VUNPCKLPDZ256rr,
  VUNPCKLPDZ256rrk,
  VUNPCKLPDZ256rrkz,
  VUNPCKLPDZrm,
  VUNPCKLPDZrmb,
  VUNPCKLPDZrmbk,
  VUNPCKLPDZrmbkz,
  VUNPCKLPDZrmk,
  VUNPCKLPDZrmkz,
  VUNPCKLPDZrr,
  VUNPCKLPDZrrk,
  VUNPCKLPDZrrkz,
  VUNPCKLPDrm,
  VUNPCKLPDrr,
  VUNPCKLPSYrm,
  VUNPCKLPSYrr,
  VUNPCKLPSZ128rm,
  VUNPCKLPSZ128rmb,
  VUNPCKLPSZ128rmbk,
  VUNPCKLPSZ128rmbkz,
  VUNPCKLPSZ128rmk,
  VUNPCKLPSZ128rmkz,
  VUNPCKLPSZ128rr,
  VUNPCKLPSZ128rrk,
  VUNPCKLPSZ128rrkz,
  VUNPCKLPSZ256rm,
  VUNPCKLPSZ256rmb,
  VUNPCKLPSZ256rmbk,
  VUNPCKLPSZ256rmbkz,
  VUNPCKLPSZ256rmk,
  VUNPCKLPSZ256rmkz,
  VUNPCKLPSZ256rr,
  VUNPCKLPSZ256rrk,
  VUNPCKLPSZ256rrkz,
  VUNPCKLPSZrm,
  VUNPCKLPSZrmb,
  VUNPCKLPSZrmbk,
  VUNPCKLPSZrmbkz,
  VUNPCKLPSZrmk,
  VUNPCKLPSZrmkz,
  VUNPCKLPSZrr,
  VUNPCKLPSZrrk,
  VUNPCKLPSZrrkz,
  VUNPCKLPSrm,
  VUNPCKLPSrr,
  VXORPDYrm,
  VXORPDYrr,
  VXORPDZ128rm,
  VXORPDZ128rmb,
  VXORPDZ128rmbk,
  VXORPDZ128rmbkz,
  VXORPDZ128rmk,
  VXORPDZ128rmkz,
  VXORPDZ128rr,
  VXORPDZ128rrk,
  VXORPDZ128rrkz,
  VXORPDZ256rm,
  VXORPDZ256rmb,
  VXORPDZ256rmbk,
  VXORPDZ256rmbkz,
  VXORPDZ256rmk,
  VXORPDZ256rmkz,
  VXORPDZ256rr,
  VXORPDZ256rrk,
  VXORPDZ256rrkz,
  VXORPDZrm,
  VXORPDZrmb,
  VXORPDZrmbk,
  VXORPDZrmbkz,
  VXORPDZrmk,
  VXORPDZrmkz,
  VXORPDZrr,
  VXORPDZrrk,
  VXORPDZrrkz,
  VXORPDrm,
  VXORPDrr,
  VXORPSYrm,
  VXORPSYrr,
  VXORPSZ128rm,
  VXORPSZ128rmb,
  VXORPSZ128rmbk,
  VXORPSZ128rmbkz,
  VXORPSZ128rmk,
  VXORPSZ128rmkz,
  VXORPSZ128rr,
  VXORPSZ128rrk,
  VXORPSZ128rrkz,
  VXORPSZ256rm,
  VXORPSZ256rmb,
  VXORPSZ256rmbk,
  VXORPSZ256rmbkz,
  VXORPSZ256rmk,
  VXORPSZ256rmkz,
  VXORPSZ256rr,
  VXORPSZ256rrk,
  VXORPSZ256rrkz,
  VXORPSZrm,
  VXORPSZrmb,
  VXORPSZrmbk,
  VXORPSZrmbkz,
  VXORPSZrmk,
  VXORPSZrmkz,
  VXORPSZrr,
  VXORPSZrrk,
  VXORPSZrrkz,
  VXORPSrm,
  VXORPSrr,
  VZEROALL,
  VZEROUPPER,
  WAIT,
  WBINVD,
  WBNOINVD,
  WRFSBASE,
  WRFSBASE64,
  WRGSBASE,
  WRGSBASE64,
  WRMSR,
  WRMSRLIST,
  WRMSRNS,
  WRPKRUr,
  WRSSD,
  WRSSD_EVEX,
  WRSSQ,
  WRSSQ_EVEX,
  WRUSSD,
  WRUSSD_EVEX,
  WRUSSQ,
  WRUSSQ_EVEX,
  XABORT,
  XACQUIRE_PREFIX,
  XADD16rm,
  XADD16rr,
  XADD32rm,
  XADD32rr,
  XADD64rm,
  XADD64rr,
  XADD8rm,
  XADD8rr,
  XAM_F,
  XAM_Fp32,
  XAM_Fp64,
  XAM_Fp80,
  XBEGIN,
  XBEGIN_2,
  XBEGIN_4,
  XCHG16ar,
  XCHG16rm,
  XCHG16rr,
  XCHG32ar,
  XCHG32rm,
  XCHG32rr,
  XCHG64ar,
  XCHG64rm,
  XCHG64rr,
  XCHG8rm,
  XCHG8rr,
  XCH_F,
  XCRYPTCBC,
  XCRYPTCFB,
  XCRYPTCTR,
  XCRYPTECB,
  XCRYPTOFB,
  XEND,
  XGETBV,
  XLAT,
  XOR16i16,
  XOR16mi,
  XOR16mi8,
  XOR16mi8_EVEX,
  XOR16mi8_ND,
  XOR16mi8_NF,
  XOR16mi8_NF_ND,
  XOR16mi_EVEX,
  XOR16mi_ND,
  XOR16mi_NF,
  XOR16mi_NF_ND,
  XOR16mr,
  XOR16mr_EVEX,
  XOR16mr_ND,
  XOR16mr_NF,
  XOR16mr_NF_ND,
  XOR16ri,
  XOR16ri8,
  XOR16ri8_EVEX,
  XOR16ri8_ND,
  XOR16ri8_NF,
  XOR16ri8_NF_ND,
  XOR16ri_EVEX,
  XOR16ri_ND,
  XOR16ri_NF,
  XOR16ri_NF_ND,
  XOR16rm,
  XOR16rm_EVEX,
  XOR16rm_ND,
  XOR16rm_NF,
  XOR16rm_NF_ND,
  XOR16rr,
  XOR16rr_EVEX,
  XOR16rr_EVEX_REV,
  XOR16rr_ND,
  XOR16rr_ND_REV,
  XOR16rr_NF,
  XOR16rr_NF_ND,
  XOR16rr_NF_ND_REV,
  XOR16rr_NF_REV,
  XOR16rr_REV,
  XOR32i32,
  XOR32mi,
  XOR32mi8,
  XOR32mi8_EVEX,
  XOR32mi8_ND,
  XOR32mi8_NF,
  XOR32mi8_NF_ND,
  XOR32mi_EVEX,
  XOR32mi_ND,
  XOR32mi_NF,
  XOR32mi_NF_ND,
  XOR32mr,
  XOR32mr_EVEX,
  XOR32mr_ND,
  XOR32mr_NF,
  XOR32mr_NF_ND,
  XOR32ri,
  XOR32ri8,
  XOR32ri8_EVEX,
  XOR32ri8_ND,
  XOR32ri8_NF,
  XOR32ri8_NF_ND,
  XOR32ri_EVEX,
  XOR32ri_ND,
  XOR32ri_NF,
  XOR32ri_NF_ND,
  XOR32rm,
  XOR32rm_EVEX,
  XOR32rm_ND,
  XOR32rm_NF,
  XOR32rm_NF_ND,
  XOR32rr,
  XOR32rr_EVEX,
  XOR32rr_EVEX_REV,
  XOR32rr_ND,
  XOR32rr_ND_REV,
  XOR32rr_NF,
  XOR32rr_NF_ND,
  XOR32rr_NF_ND_REV,
  XOR32rr_NF_REV,
  XOR32rr_REV,
  XOR64i32,
  XOR64mi32,
  XOR64mi32_EVEX,
  XOR64mi32_ND,
  XOR64mi32_NF,
  XOR64mi32_NF_ND,
  XOR64mi8,
  XOR64mi8_EVEX,
  XOR64mi8_ND,
  XOR64mi8_NF,
  XOR64mi8_NF_ND,
  XOR64mr,
  XOR64mr_EVEX,
  XOR64mr_ND,
  XOR64mr_NF,
  XOR64mr_NF_ND,
  XOR64ri32,
  XOR64ri32_EVEX,
  XOR64ri32_ND,
  XOR64ri32_NF,
  XOR64ri32_NF_ND,
  XOR64ri8,
  XOR64ri8_EVEX,
  XOR64ri8_ND,
  XOR64ri8_NF,
  XOR64ri8_NF_ND,
  XOR64rm,
  XOR64rm_EVEX,
  XOR64rm_ND,
  XOR64rm_NF,
  XOR64rm_NF_ND,
  XOR64rr,
  XOR64rr_EVEX,
  XOR64rr_EVEX_REV,
  XOR64rr_ND,
  XOR64rr_ND_REV,
  XOR64rr_NF,
  XOR64rr_NF_ND,
  XOR64rr_NF_ND_REV,
  XOR64rr_NF_REV,
  XOR64rr_REV,
  XOR8i8,
  XOR8mi,
  XOR8mi8,
  XOR8mi_EVEX,
  XOR8mi_ND,
  XOR8mi_NF,
  XOR8mi_NF_ND,
  XOR8mr,
  XOR8mr_EVEX,
  XOR8mr_ND,
  XOR8mr_NF,
  XOR8mr_NF_ND,
  XOR8ri,
  XOR8ri8,
  XOR8ri_EVEX,
  XOR8ri_ND,
  XOR8ri_NF,
  XOR8ri_NF_ND,
  XOR8rm,
  XOR8rm_EVEX,
  XOR8rm_ND,
  XOR8rm_NF,
  XOR8rm_NF_ND,
  XOR8rr,
  XOR8rr_EVEX,
  XOR8rr_EVEX_REV,
  XOR8rr_ND,
  XOR8rr_ND_REV,
  XOR8rr_NF,
  XOR8rr_NF_ND,
  XOR8rr_NF_ND_REV,
  XOR8rr_NF_REV,
  XOR8rr_NOREX,
  XOR8rr_REV,
  XORPDrm,
  XORPDrr,
  XORPSrm,
  XORPSrr,
  XRELEASE_PREFIX,
  XRESLDTRK,
  XRSTOR,
  XRSTOR64,
  XRSTORS,
  XRSTORS64,
  XSAVE,
  XSAVE64,
  XSAVEC,
  XSAVEC64,
  XSAVEOPT,
  XSAVEOPT64,
  XSAVES,
  XSAVES64,
  XSETBV,
  XSHA1,
  XSHA256,
  XSTORE,
  XSUSLDTRK,
  XTEST,
  INSTRUCTION_LIST_END,
  UNKNOWN(u64),
}

impl From<u64> for Opcode {
    fn from(value: u64) -> Self {
        match value {
          0 => Opcode::PHI,
          1 => Opcode::INLINEASM,
          2 => Opcode::INLINEASM_BR,
          3 => Opcode::CFI_INSTRUCTION,
          4 => Opcode::EH_LABEL,
          5 => Opcode::GC_LABEL,
          6 => Opcode::ANNOTATION_LABEL,
          7 => Opcode::KILL,
          8 => Opcode::EXTRACT_SUBREG,
          9 => Opcode::INSERT_SUBREG,
          10 => Opcode::IMPLICIT_DEF,
          11 => Opcode::SUBREG_TO_REG,
          12 => Opcode::COPY_TO_REGCLASS,
          13 => Opcode::DBG_VALUE,
          14 => Opcode::DBG_VALUE_LIST,
          15 => Opcode::DBG_INSTR_REF,
          16 => Opcode::DBG_PHI,
          17 => Opcode::DBG_LABEL,
          18 => Opcode::REG_SEQUENCE,
          19 => Opcode::COPY,
          20 => Opcode::BUNDLE,
          21 => Opcode::LIFETIME_START,
          22 => Opcode::LIFETIME_END,
          23 => Opcode::PSEUDO_PROBE,
          24 => Opcode::ARITH_FENCE,
          25 => Opcode::STACKMAP,
          26 => Opcode::FENTRY_CALL,
          27 => Opcode::PATCHPOINT,
          28 => Opcode::LOAD_STACK_GUARD,
          29 => Opcode::PREALLOCATED_SETUP,
          30 => Opcode::PREALLOCATED_ARG,
          31 => Opcode::STATEPOINT,
          32 => Opcode::LOCAL_ESCAPE,
          33 => Opcode::FAULTING_OP,
          34 => Opcode::PATCHABLE_OP,
          35 => Opcode::PATCHABLE_FUNCTION_ENTER,
          36 => Opcode::PATCHABLE_RET,
          37 => Opcode::PATCHABLE_FUNCTION_EXIT,
          38 => Opcode::PATCHABLE_TAIL_CALL,
          39 => Opcode::PATCHABLE_EVENT_CALL,
          40 => Opcode::PATCHABLE_TYPED_EVENT_CALL,
          41 => Opcode::ICALL_BRANCH_FUNNEL,
          42 => Opcode::MEMBARRIER,
          43 => Opcode::JUMP_TABLE_DEBUG_INFO,
          44 => Opcode::CONVERGENCECTRL_ENTRY,
          45 => Opcode::CONVERGENCECTRL_ANCHOR,
          46 => Opcode::CONVERGENCECTRL_LOOP,
          47 => Opcode::CONVERGENCECTRL_GLUE,
          48 => Opcode::G_ASSERT_SEXT,
          49 => Opcode::G_ASSERT_ZEXT,
          50 => Opcode::G_ASSERT_ALIGN,
          51 => Opcode::G_ADD,
          52 => Opcode::G_SUB,
          53 => Opcode::G_MUL,
          54 => Opcode::G_SDIV,
          55 => Opcode::G_UDIV,
          56 => Opcode::G_SREM,
          57 => Opcode::G_UREM,
          58 => Opcode::G_SDIVREM,
          59 => Opcode::G_UDIVREM,
          60 => Opcode::G_AND,
          61 => Opcode::G_OR,
          62 => Opcode::G_XOR,
          63 => Opcode::G_IMPLICIT_DEF,
          64 => Opcode::G_PHI,
          65 => Opcode::G_FRAME_INDEX,
          66 => Opcode::G_GLOBAL_VALUE,
          67 => Opcode::G_PTRAUTH_GLOBAL_VALUE,
          68 => Opcode::G_CONSTANT_POOL,
          69 => Opcode::G_EXTRACT,
          70 => Opcode::G_UNMERGE_VALUES,
          71 => Opcode::G_INSERT,
          72 => Opcode::G_MERGE_VALUES,
          73 => Opcode::G_BUILD_VECTOR,
          74 => Opcode::G_BUILD_VECTOR_TRUNC,
          75 => Opcode::G_CONCAT_VECTORS,
          76 => Opcode::G_PTRTOINT,
          77 => Opcode::G_INTTOPTR,
          78 => Opcode::G_BITCAST,
          79 => Opcode::G_FREEZE,
          80 => Opcode::G_CONSTANT_FOLD_BARRIER,
          81 => Opcode::G_INTRINSIC_FPTRUNC_ROUND,
          82 => Opcode::G_INTRINSIC_TRUNC,
          83 => Opcode::G_INTRINSIC_ROUND,
          84 => Opcode::G_INTRINSIC_LRINT,
          85 => Opcode::G_INTRINSIC_LLRINT,
          86 => Opcode::G_INTRINSIC_ROUNDEVEN,
          87 => Opcode::G_READCYCLECOUNTER,
          88 => Opcode::G_READSTEADYCOUNTER,
          89 => Opcode::G_LOAD,
          90 => Opcode::G_SEXTLOAD,
          91 => Opcode::G_ZEXTLOAD,
          92 => Opcode::G_INDEXED_LOAD,
          93 => Opcode::G_INDEXED_SEXTLOAD,
          94 => Opcode::G_INDEXED_ZEXTLOAD,
          95 => Opcode::G_STORE,
          96 => Opcode::G_INDEXED_STORE,
          97 => Opcode::G_ATOMIC_CMPXCHG_WITH_SUCCESS,
          98 => Opcode::G_ATOMIC_CMPXCHG,
          99 => Opcode::G_ATOMICRMW_XCHG,
          100 => Opcode::G_ATOMICRMW_ADD,
          101 => Opcode::G_ATOMICRMW_SUB,
          102 => Opcode::G_ATOMICRMW_AND,
          103 => Opcode::G_ATOMICRMW_NAND,
          104 => Opcode::G_ATOMICRMW_OR,
          105 => Opcode::G_ATOMICRMW_XOR,
          106 => Opcode::G_ATOMICRMW_MAX,
          107 => Opcode::G_ATOMICRMW_MIN,
          108 => Opcode::G_ATOMICRMW_UMAX,
          109 => Opcode::G_ATOMICRMW_UMIN,
          110 => Opcode::G_ATOMICRMW_FADD,
          111 => Opcode::G_ATOMICRMW_FSUB,
          112 => Opcode::G_ATOMICRMW_FMAX,
          113 => Opcode::G_ATOMICRMW_FMIN,
          114 => Opcode::G_ATOMICRMW_UINC_WRAP,
          115 => Opcode::G_ATOMICRMW_UDEC_WRAP,
          116 => Opcode::G_FENCE,
          117 => Opcode::G_PREFETCH,
          118 => Opcode::G_BRCOND,
          119 => Opcode::G_BRINDIRECT,
          120 => Opcode::G_INVOKE_REGION_START,
          121 => Opcode::G_INTRINSIC,
          122 => Opcode::G_INTRINSIC_W_SIDE_EFFECTS,
          123 => Opcode::G_INTRINSIC_CONVERGENT,
          124 => Opcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS,
          125 => Opcode::G_ANYEXT,
          126 => Opcode::G_TRUNC,
          127 => Opcode::G_CONSTANT,
          128 => Opcode::G_FCONSTANT,
          129 => Opcode::G_VASTART,
          130 => Opcode::G_VAARG,
          131 => Opcode::G_SEXT,
          132 => Opcode::G_SEXT_INREG,
          133 => Opcode::G_ZEXT,
          134 => Opcode::G_SHL,
          135 => Opcode::G_LSHR,
          136 => Opcode::G_ASHR,
          137 => Opcode::G_FSHL,
          138 => Opcode::G_FSHR,
          139 => Opcode::G_ROTR,
          140 => Opcode::G_ROTL,
          141 => Opcode::G_ICMP,
          142 => Opcode::G_FCMP,
          143 => Opcode::G_SCMP,
          144 => Opcode::G_UCMP,
          145 => Opcode::G_SELECT,
          146 => Opcode::G_UADDO,
          147 => Opcode::G_UADDE,
          148 => Opcode::G_USUBO,
          149 => Opcode::G_USUBE,
          150 => Opcode::G_SADDO,
          151 => Opcode::G_SADDE,
          152 => Opcode::G_SSUBO,
          153 => Opcode::G_SSUBE,
          154 => Opcode::G_UMULO,
          155 => Opcode::G_SMULO,
          156 => Opcode::G_UMULH,
          157 => Opcode::G_SMULH,
          158 => Opcode::G_UADDSAT,
          159 => Opcode::G_SADDSAT,
          160 => Opcode::G_USUBSAT,
          161 => Opcode::G_SSUBSAT,
          162 => Opcode::G_USHLSAT,
          163 => Opcode::G_SSHLSAT,
          164 => Opcode::G_SMULFIX,
          165 => Opcode::G_UMULFIX,
          166 => Opcode::G_SMULFIXSAT,
          167 => Opcode::G_UMULFIXSAT,
          168 => Opcode::G_SDIVFIX,
          169 => Opcode::G_UDIVFIX,
          170 => Opcode::G_SDIVFIXSAT,
          171 => Opcode::G_UDIVFIXSAT,
          172 => Opcode::G_FADD,
          173 => Opcode::G_FSUB,
          174 => Opcode::G_FMUL,
          175 => Opcode::G_FMA,
          176 => Opcode::G_FMAD,
          177 => Opcode::G_FDIV,
          178 => Opcode::G_FREM,
          179 => Opcode::G_FPOW,
          180 => Opcode::G_FPOWI,
          181 => Opcode::G_FEXP,
          182 => Opcode::G_FEXP2,
          183 => Opcode::G_FEXP10,
          184 => Opcode::G_FLOG,
          185 => Opcode::G_FLOG2,
          186 => Opcode::G_FLOG10,
          187 => Opcode::G_FLDEXP,
          188 => Opcode::G_FFREXP,
          189 => Opcode::G_FNEG,
          190 => Opcode::G_FPEXT,
          191 => Opcode::G_FPTRUNC,
          192 => Opcode::G_FPTOSI,
          193 => Opcode::G_FPTOUI,
          194 => Opcode::G_SITOFP,
          195 => Opcode::G_UITOFP,
          196 => Opcode::G_FABS,
          197 => Opcode::G_FCOPYSIGN,
          198 => Opcode::G_IS_FPCLASS,
          199 => Opcode::G_FCANONICALIZE,
          200 => Opcode::G_FMINNUM,
          201 => Opcode::G_FMAXNUM,
          202 => Opcode::G_FMINNUM_IEEE,
          203 => Opcode::G_FMAXNUM_IEEE,
          204 => Opcode::G_FMINIMUM,
          205 => Opcode::G_FMAXIMUM,
          206 => Opcode::G_GET_FPENV,
          207 => Opcode::G_SET_FPENV,
          208 => Opcode::G_RESET_FPENV,
          209 => Opcode::G_GET_FPMODE,
          210 => Opcode::G_SET_FPMODE,
          211 => Opcode::G_RESET_FPMODE,
          212 => Opcode::G_PTR_ADD,
          213 => Opcode::G_PTRMASK,
          214 => Opcode::G_SMIN,
          215 => Opcode::G_SMAX,
          216 => Opcode::G_UMIN,
          217 => Opcode::G_UMAX,
          218 => Opcode::G_ABS,
          219 => Opcode::G_LROUND,
          220 => Opcode::G_LLROUND,
          221 => Opcode::G_BR,
          222 => Opcode::G_BRJT,
          223 => Opcode::G_VSCALE,
          224 => Opcode::G_INSERT_SUBVECTOR,
          225 => Opcode::G_EXTRACT_SUBVECTOR,
          226 => Opcode::G_INSERT_VECTOR_ELT,
          227 => Opcode::G_EXTRACT_VECTOR_ELT,
          228 => Opcode::G_SHUFFLE_VECTOR,
          229 => Opcode::G_SPLAT_VECTOR,
          230 => Opcode::G_VECTOR_COMPRESS,
          231 => Opcode::G_CTTZ,
          232 => Opcode::G_CTTZ_ZERO_UNDEF,
          233 => Opcode::G_CTLZ,
          234 => Opcode::G_CTLZ_ZERO_UNDEF,
          235 => Opcode::G_CTPOP,
          236 => Opcode::G_BSWAP,
          237 => Opcode::G_BITREVERSE,
          238 => Opcode::G_FCEIL,
          239 => Opcode::G_FCOS,
          240 => Opcode::G_FSIN,
          241 => Opcode::G_FTAN,
          242 => Opcode::G_FACOS,
          243 => Opcode::G_FASIN,
          244 => Opcode::G_FATAN,
          245 => Opcode::G_FCOSH,
          246 => Opcode::G_FSINH,
          247 => Opcode::G_FTANH,
          248 => Opcode::G_FSQRT,
          249 => Opcode::G_FFLOOR,
          250 => Opcode::G_FRINT,
          251 => Opcode::G_FNEARBYINT,
          252 => Opcode::G_ADDRSPACE_CAST,
          253 => Opcode::G_BLOCK_ADDR,
          254 => Opcode::G_JUMP_TABLE,
          255 => Opcode::G_DYN_STACKALLOC,
          256 => Opcode::G_STACKSAVE,
          257 => Opcode::G_STACKRESTORE,
          258 => Opcode::G_STRICT_FADD,
          259 => Opcode::G_STRICT_FSUB,
          260 => Opcode::G_STRICT_FMUL,
          261 => Opcode::G_STRICT_FDIV,
          262 => Opcode::G_STRICT_FREM,
          263 => Opcode::G_STRICT_FMA,
          264 => Opcode::G_STRICT_FSQRT,
          265 => Opcode::G_STRICT_FLDEXP,
          266 => Opcode::G_READ_REGISTER,
          267 => Opcode::G_WRITE_REGISTER,
          268 => Opcode::G_MEMCPY,
          269 => Opcode::G_MEMCPY_INLINE,
          270 => Opcode::G_MEMMOVE,
          271 => Opcode::G_MEMSET,
          272 => Opcode::G_BZERO,
          273 => Opcode::G_TRAP,
          274 => Opcode::G_DEBUGTRAP,
          275 => Opcode::G_UBSANTRAP,
          276 => Opcode::G_VECREDUCE_SEQ_FADD,
          277 => Opcode::G_VECREDUCE_SEQ_FMUL,
          278 => Opcode::G_VECREDUCE_FADD,
          279 => Opcode::G_VECREDUCE_FMUL,
          280 => Opcode::G_VECREDUCE_FMAX,
          281 => Opcode::G_VECREDUCE_FMIN,
          282 => Opcode::G_VECREDUCE_FMAXIMUM,
          283 => Opcode::G_VECREDUCE_FMINIMUM,
          284 => Opcode::G_VECREDUCE_ADD,
          285 => Opcode::G_VECREDUCE_MUL,
          286 => Opcode::G_VECREDUCE_AND,
          287 => Opcode::G_VECREDUCE_OR,
          288 => Opcode::G_VECREDUCE_XOR,
          289 => Opcode::G_VECREDUCE_SMAX,
          290 => Opcode::G_VECREDUCE_SMIN,
          291 => Opcode::G_VECREDUCE_UMAX,
          292 => Opcode::G_VECREDUCE_UMIN,
          293 => Opcode::G_SBFX,
          294 => Opcode::G_UBFX,
          295 => Opcode::ADD16ri_DB,
          296 => Opcode::ADD16rr_DB,
          297 => Opcode::ADD32ri_DB,
          298 => Opcode::ADD32rr_DB,
          299 => Opcode::ADD64ri32_DB,
          300 => Opcode::ADD64rr_DB,
          301 => Opcode::ADD8ri_DB,
          302 => Opcode::ADD8rr_DB,
          303 => Opcode::AVX1_SETALLONES,
          304 => Opcode::AVX2_SETALLONES,
          305 => Opcode::AVX512_128_SET0,
          306 => Opcode::AVX512_256_SET0,
          307 => Opcode::AVX512_512_SET0,
          308 => Opcode::AVX512_512_SETALLONES,
          309 => Opcode::AVX512_512_SEXT_MASK_32,
          310 => Opcode::AVX512_512_SEXT_MASK_64,
          311 => Opcode::AVX512_FsFLD0F128,
          312 => Opcode::AVX512_FsFLD0SD,
          313 => Opcode::AVX512_FsFLD0SH,
          314 => Opcode::AVX512_FsFLD0SS,
          315 => Opcode::AVX_SET0,
          316 => Opcode::CALL64m_RVMARKER,
          317 => Opcode::CALL64pcrel32_RVMARKER,
          318 => Opcode::CALL64r_RVMARKER,
          319 => Opcode::FsFLD0F128,
          320 => Opcode::FsFLD0SD,
          321 => Opcode::FsFLD0SH,
          322 => Opcode::FsFLD0SS,
          323 => Opcode::INDIRECT_THUNK_CALL32,
          324 => Opcode::INDIRECT_THUNK_CALL64,
          325 => Opcode::INDIRECT_THUNK_TCRETURN32,
          326 => Opcode::INDIRECT_THUNK_TCRETURN64,
          327 => Opcode::KSET0D,
          328 => Opcode::KSET0Q,
          329 => Opcode::KSET0W,
          330 => Opcode::KSET1D,
          331 => Opcode::KSET1Q,
          332 => Opcode::KSET1W,
          333 => Opcode::LCMPXCHG16B_NO_RBX,
          334 => Opcode::LCMPXCHG16B_SAVE_RBX,
          335 => Opcode::MMX_SET0,
          336 => Opcode::MORESTACK_RET,
          337 => Opcode::MORESTACK_RET_RESTORE_R10,
          338 => Opcode::MOV32ImmSExti8,
          339 => Opcode::MOV32r0,
          340 => Opcode::MOV32r1,
          341 => Opcode::MOV32r_1,
          342 => Opcode::MOV32ri64,
          343 => Opcode::MOV64ImmSExti8,
          344 => Opcode::MWAITX,
          345 => Opcode::MWAITX_SAVE_RBX,
          346 => Opcode::PLDTILECFGV,
          347 => Opcode::PLEA32r,
          348 => Opcode::PLEA64r,
          349 => Opcode::PTDPBF16PSV,
          350 => Opcode::PTDPBSSDV,
          351 => Opcode::PTDPBSUDV,
          352 => Opcode::PTDPBUSDV,
          353 => Opcode::PTDPBUUDV,
          354 => Opcode::PTDPFP16PSV,
          355 => Opcode::PTILELOADDT1V,
          356 => Opcode::PTILELOADDV,
          357 => Opcode::PTILESTOREDV,
          358 => Opcode::PTILEZEROV,
          359 => Opcode::RDFLAGS32,
          360 => Opcode::RDFLAGS64,
          361 => Opcode::SEH_EndPrologue,
          362 => Opcode::SEH_Epilogue,
          363 => Opcode::SEH_PushFrame,
          364 => Opcode::SEH_PushReg,
          365 => Opcode::SEH_SaveReg,
          366 => Opcode::SEH_SaveXMM,
          367 => Opcode::SEH_SetFrame,
          368 => Opcode::SEH_StackAlign,
          369 => Opcode::SEH_StackAlloc,
          370 => Opcode::SETB_C32r,
          371 => Opcode::SETB_C64r,
          372 => Opcode::SHLDROT32ri,
          373 => Opcode::SHLDROT64ri,
          374 => Opcode::SHRDROT32ri,
          375 => Opcode::SHRDROT64ri,
          376 => Opcode::VMOVAPSZ128mr_NOVLX,
          377 => Opcode::VMOVAPSZ128rm_NOVLX,
          378 => Opcode::VMOVAPSZ256mr_NOVLX,
          379 => Opcode::VMOVAPSZ256rm_NOVLX,
          380 => Opcode::VMOVUPSZ128mr_NOVLX,
          381 => Opcode::VMOVUPSZ128rm_NOVLX,
          382 => Opcode::VMOVUPSZ256mr_NOVLX,
          383 => Opcode::VMOVUPSZ256rm_NOVLX,
          384 => Opcode::V_SET0,
          385 => Opcode::V_SETALLONES,
          386 => Opcode::WRFLAGS32,
          387 => Opcode::WRFLAGS64,
          388 => Opcode::XABORT_DEF,
          389 => Opcode::XOR32_FP,
          390 => Opcode::XOR64_FP,
          391 => Opcode::AAA,
          392 => Opcode::AAD8i8,
          393 => Opcode::AADD32mr,
          394 => Opcode::AADD32mr_EVEX,
          395 => Opcode::AADD64mr,
          396 => Opcode::AADD64mr_EVEX,
          397 => Opcode::AAM8i8,
          398 => Opcode::AAND32mr,
          399 => Opcode::AAND32mr_EVEX,
          400 => Opcode::AAND64mr,
          401 => Opcode::AAND64mr_EVEX,
          402 => Opcode::AAS,
          403 => Opcode::ABS_F,
          404 => Opcode::ABS_Fp32,
          405 => Opcode::ABS_Fp64,
          406 => Opcode::ABS_Fp80,
          407 => Opcode::ADC16i16,
          408 => Opcode::ADC16mi,
          409 => Opcode::ADC16mi8,
          410 => Opcode::ADC16mi8_EVEX,
          411 => Opcode::ADC16mi8_ND,
          412 => Opcode::ADC16mi_EVEX,
          413 => Opcode::ADC16mi_ND,
          414 => Opcode::ADC16mr,
          415 => Opcode::ADC16mr_EVEX,
          416 => Opcode::ADC16mr_ND,
          417 => Opcode::ADC16ri,
          418 => Opcode::ADC16ri8,
          419 => Opcode::ADC16ri8_EVEX,
          420 => Opcode::ADC16ri8_ND,
          421 => Opcode::ADC16ri_EVEX,
          422 => Opcode::ADC16ri_ND,
          423 => Opcode::ADC16rm,
          424 => Opcode::ADC16rm_EVEX,
          425 => Opcode::ADC16rm_ND,
          426 => Opcode::ADC16rr,
          427 => Opcode::ADC16rr_EVEX,
          428 => Opcode::ADC16rr_EVEX_REV,
          429 => Opcode::ADC16rr_ND,
          430 => Opcode::ADC16rr_ND_REV,
          431 => Opcode::ADC16rr_REV,
          432 => Opcode::ADC32i32,
          433 => Opcode::ADC32mi,
          434 => Opcode::ADC32mi8,
          435 => Opcode::ADC32mi8_EVEX,
          436 => Opcode::ADC32mi8_ND,
          437 => Opcode::ADC32mi_EVEX,
          438 => Opcode::ADC32mi_ND,
          439 => Opcode::ADC32mr,
          440 => Opcode::ADC32mr_EVEX,
          441 => Opcode::ADC32mr_ND,
          442 => Opcode::ADC32ri,
          443 => Opcode::ADC32ri8,
          444 => Opcode::ADC32ri8_EVEX,
          445 => Opcode::ADC32ri8_ND,
          446 => Opcode::ADC32ri_EVEX,
          447 => Opcode::ADC32ri_ND,
          448 => Opcode::ADC32rm,
          449 => Opcode::ADC32rm_EVEX,
          450 => Opcode::ADC32rm_ND,
          451 => Opcode::ADC32rr,
          452 => Opcode::ADC32rr_EVEX,
          453 => Opcode::ADC32rr_EVEX_REV,
          454 => Opcode::ADC32rr_ND,
          455 => Opcode::ADC32rr_ND_REV,
          456 => Opcode::ADC32rr_REV,
          457 => Opcode::ADC64i32,
          458 => Opcode::ADC64mi32,
          459 => Opcode::ADC64mi32_EVEX,
          460 => Opcode::ADC64mi32_ND,
          461 => Opcode::ADC64mi8,
          462 => Opcode::ADC64mi8_EVEX,
          463 => Opcode::ADC64mi8_ND,
          464 => Opcode::ADC64mr,
          465 => Opcode::ADC64mr_EVEX,
          466 => Opcode::ADC64mr_ND,
          467 => Opcode::ADC64ri32,
          468 => Opcode::ADC64ri32_EVEX,
          469 => Opcode::ADC64ri32_ND,
          470 => Opcode::ADC64ri8,
          471 => Opcode::ADC64ri8_EVEX,
          472 => Opcode::ADC64ri8_ND,
          473 => Opcode::ADC64rm,
          474 => Opcode::ADC64rm_EVEX,
          475 => Opcode::ADC64rm_ND,
          476 => Opcode::ADC64rr,
          477 => Opcode::ADC64rr_EVEX,
          478 => Opcode::ADC64rr_EVEX_REV,
          479 => Opcode::ADC64rr_ND,
          480 => Opcode::ADC64rr_ND_REV,
          481 => Opcode::ADC64rr_REV,
          482 => Opcode::ADC8i8,
          483 => Opcode::ADC8mi,
          484 => Opcode::ADC8mi8,
          485 => Opcode::ADC8mi_EVEX,
          486 => Opcode::ADC8mi_ND,
          487 => Opcode::ADC8mr,
          488 => Opcode::ADC8mr_EVEX,
          489 => Opcode::ADC8mr_ND,
          490 => Opcode::ADC8ri,
          491 => Opcode::ADC8ri8,
          492 => Opcode::ADC8ri_EVEX,
          493 => Opcode::ADC8ri_ND,
          494 => Opcode::ADC8rm,
          495 => Opcode::ADC8rm_EVEX,
          496 => Opcode::ADC8rm_ND,
          497 => Opcode::ADC8rr,
          498 => Opcode::ADC8rr_EVEX,
          499 => Opcode::ADC8rr_EVEX_REV,
          500 => Opcode::ADC8rr_ND,
          501 => Opcode::ADC8rr_ND_REV,
          502 => Opcode::ADC8rr_REV,
          503 => Opcode::ADCX32rm,
          504 => Opcode::ADCX32rm_EVEX,
          505 => Opcode::ADCX32rm_ND,
          506 => Opcode::ADCX32rr,
          507 => Opcode::ADCX32rr_EVEX,
          508 => Opcode::ADCX32rr_ND,
          509 => Opcode::ADCX64rm,
          510 => Opcode::ADCX64rm_EVEX,
          511 => Opcode::ADCX64rm_ND,
          512 => Opcode::ADCX64rr,
          513 => Opcode::ADCX64rr_EVEX,
          514 => Opcode::ADCX64rr_ND,
          515 => Opcode::ADD16i16,
          516 => Opcode::ADD16mi,
          517 => Opcode::ADD16mi8,
          518 => Opcode::ADD16mi8_EVEX,
          519 => Opcode::ADD16mi8_ND,
          520 => Opcode::ADD16mi8_NF,
          521 => Opcode::ADD16mi8_NF_ND,
          522 => Opcode::ADD16mi_EVEX,
          523 => Opcode::ADD16mi_ND,
          524 => Opcode::ADD16mi_NF,
          525 => Opcode::ADD16mi_NF_ND,
          526 => Opcode::ADD16mr,
          527 => Opcode::ADD16mr_EVEX,
          528 => Opcode::ADD16mr_ND,
          529 => Opcode::ADD16mr_NF,
          530 => Opcode::ADD16mr_NF_ND,
          531 => Opcode::ADD16ri,
          532 => Opcode::ADD16ri8,
          533 => Opcode::ADD16ri8_EVEX,
          534 => Opcode::ADD16ri8_ND,
          535 => Opcode::ADD16ri8_NF,
          536 => Opcode::ADD16ri8_NF_ND,
          537 => Opcode::ADD16ri_EVEX,
          538 => Opcode::ADD16ri_ND,
          539 => Opcode::ADD16ri_NF,
          540 => Opcode::ADD16ri_NF_ND,
          541 => Opcode::ADD16rm,
          542 => Opcode::ADD16rm_EVEX,
          543 => Opcode::ADD16rm_ND,
          544 => Opcode::ADD16rm_NF,
          545 => Opcode::ADD16rm_NF_ND,
          546 => Opcode::ADD16rr,
          547 => Opcode::ADD16rr_EVEX,
          548 => Opcode::ADD16rr_EVEX_REV,
          549 => Opcode::ADD16rr_ND,
          550 => Opcode::ADD16rr_ND_REV,
          551 => Opcode::ADD16rr_NF,
          552 => Opcode::ADD16rr_NF_ND,
          553 => Opcode::ADD16rr_NF_ND_REV,
          554 => Opcode::ADD16rr_NF_REV,
          555 => Opcode::ADD16rr_REV,
          556 => Opcode::ADD32i32,
          557 => Opcode::ADD32mi,
          558 => Opcode::ADD32mi8,
          559 => Opcode::ADD32mi8_EVEX,
          560 => Opcode::ADD32mi8_ND,
          561 => Opcode::ADD32mi8_NF,
          562 => Opcode::ADD32mi8_NF_ND,
          563 => Opcode::ADD32mi_EVEX,
          564 => Opcode::ADD32mi_ND,
          565 => Opcode::ADD32mi_NF,
          566 => Opcode::ADD32mi_NF_ND,
          567 => Opcode::ADD32mr,
          568 => Opcode::ADD32mr_EVEX,
          569 => Opcode::ADD32mr_ND,
          570 => Opcode::ADD32mr_NF,
          571 => Opcode::ADD32mr_NF_ND,
          572 => Opcode::ADD32ri,
          573 => Opcode::ADD32ri8,
          574 => Opcode::ADD32ri8_EVEX,
          575 => Opcode::ADD32ri8_ND,
          576 => Opcode::ADD32ri8_NF,
          577 => Opcode::ADD32ri8_NF_ND,
          578 => Opcode::ADD32ri_EVEX,
          579 => Opcode::ADD32ri_ND,
          580 => Opcode::ADD32ri_NF,
          581 => Opcode::ADD32ri_NF_ND,
          582 => Opcode::ADD32rm,
          583 => Opcode::ADD32rm_EVEX,
          584 => Opcode::ADD32rm_ND,
          585 => Opcode::ADD32rm_NF,
          586 => Opcode::ADD32rm_NF_ND,
          587 => Opcode::ADD32rr,
          588 => Opcode::ADD32rr_EVEX,
          589 => Opcode::ADD32rr_EVEX_REV,
          590 => Opcode::ADD32rr_ND,
          591 => Opcode::ADD32rr_ND_REV,
          592 => Opcode::ADD32rr_NF,
          593 => Opcode::ADD32rr_NF_ND,
          594 => Opcode::ADD32rr_NF_ND_REV,
          595 => Opcode::ADD32rr_NF_REV,
          596 => Opcode::ADD32rr_REV,
          597 => Opcode::ADD64i32,
          598 => Opcode::ADD64mi32,
          599 => Opcode::ADD64mi32_EVEX,
          600 => Opcode::ADD64mi32_ND,
          601 => Opcode::ADD64mi32_NF,
          602 => Opcode::ADD64mi32_NF_ND,
          603 => Opcode::ADD64mi8,
          604 => Opcode::ADD64mi8_EVEX,
          605 => Opcode::ADD64mi8_ND,
          606 => Opcode::ADD64mi8_NF,
          607 => Opcode::ADD64mi8_NF_ND,
          608 => Opcode::ADD64mr,
          609 => Opcode::ADD64mr_EVEX,
          610 => Opcode::ADD64mr_ND,
          611 => Opcode::ADD64mr_NF,
          612 => Opcode::ADD64mr_NF_ND,
          613 => Opcode::ADD64ri32,
          614 => Opcode::ADD64ri32_EVEX,
          615 => Opcode::ADD64ri32_ND,
          616 => Opcode::ADD64ri32_NF,
          617 => Opcode::ADD64ri32_NF_ND,
          618 => Opcode::ADD64ri8,
          619 => Opcode::ADD64ri8_EVEX,
          620 => Opcode::ADD64ri8_ND,
          621 => Opcode::ADD64ri8_NF,
          622 => Opcode::ADD64ri8_NF_ND,
          623 => Opcode::ADD64rm,
          624 => Opcode::ADD64rm_EVEX,
          625 => Opcode::ADD64rm_ND,
          626 => Opcode::ADD64rm_NF,
          627 => Opcode::ADD64rm_NF_ND,
          628 => Opcode::ADD64rr,
          629 => Opcode::ADD64rr_EVEX,
          630 => Opcode::ADD64rr_EVEX_REV,
          631 => Opcode::ADD64rr_ND,
          632 => Opcode::ADD64rr_ND_REV,
          633 => Opcode::ADD64rr_NF,
          634 => Opcode::ADD64rr_NF_ND,
          635 => Opcode::ADD64rr_NF_ND_REV,
          636 => Opcode::ADD64rr_NF_REV,
          637 => Opcode::ADD64rr_REV,
          638 => Opcode::ADD8i8,
          639 => Opcode::ADD8mi,
          640 => Opcode::ADD8mi8,
          641 => Opcode::ADD8mi_EVEX,
          642 => Opcode::ADD8mi_ND,
          643 => Opcode::ADD8mi_NF,
          644 => Opcode::ADD8mi_NF_ND,
          645 => Opcode::ADD8mr,
          646 => Opcode::ADD8mr_EVEX,
          647 => Opcode::ADD8mr_ND,
          648 => Opcode::ADD8mr_NF,
          649 => Opcode::ADD8mr_NF_ND,
          650 => Opcode::ADD8ri,
          651 => Opcode::ADD8ri8,
          652 => Opcode::ADD8ri_EVEX,
          653 => Opcode::ADD8ri_ND,
          654 => Opcode::ADD8ri_NF,
          655 => Opcode::ADD8ri_NF_ND,
          656 => Opcode::ADD8rm,
          657 => Opcode::ADD8rm_EVEX,
          658 => Opcode::ADD8rm_ND,
          659 => Opcode::ADD8rm_NF,
          660 => Opcode::ADD8rm_NF_ND,
          661 => Opcode::ADD8rr,
          662 => Opcode::ADD8rr_EVEX,
          663 => Opcode::ADD8rr_EVEX_REV,
          664 => Opcode::ADD8rr_ND,
          665 => Opcode::ADD8rr_ND_REV,
          666 => Opcode::ADD8rr_NF,
          667 => Opcode::ADD8rr_NF_ND,
          668 => Opcode::ADD8rr_NF_ND_REV,
          669 => Opcode::ADD8rr_NF_REV,
          670 => Opcode::ADD8rr_REV,
          671 => Opcode::ADDPDrm,
          672 => Opcode::ADDPDrr,
          673 => Opcode::ADDPSrm,
          674 => Opcode::ADDPSrr,
          675 => Opcode::ADDR16_PREFIX,
          676 => Opcode::ADDR32_PREFIX,
          677 => Opcode::ADDSDrm,
          678 => Opcode::ADDSDrm_Int,
          679 => Opcode::ADDSDrr,
          680 => Opcode::ADDSDrr_Int,
          681 => Opcode::ADDSSrm,
          682 => Opcode::ADDSSrm_Int,
          683 => Opcode::ADDSSrr,
          684 => Opcode::ADDSSrr_Int,
          685 => Opcode::ADDSUBPDrm,
          686 => Opcode::ADDSUBPDrr,
          687 => Opcode::ADDSUBPSrm,
          688 => Opcode::ADDSUBPSrr,
          689 => Opcode::ADD_F32m,
          690 => Opcode::ADD_F64m,
          691 => Opcode::ADD_FI16m,
          692 => Opcode::ADD_FI32m,
          693 => Opcode::ADD_FPrST0,
          694 => Opcode::ADD_FST0r,
          695 => Opcode::ADD_Fp32,
          696 => Opcode::ADD_Fp32m,
          697 => Opcode::ADD_Fp64,
          698 => Opcode::ADD_Fp64m,
          699 => Opcode::ADD_Fp64m32,
          700 => Opcode::ADD_Fp80,
          701 => Opcode::ADD_Fp80m32,
          702 => Opcode::ADD_Fp80m64,
          703 => Opcode::ADD_FpI16m32,
          704 => Opcode::ADD_FpI16m64,
          705 => Opcode::ADD_FpI16m80,
          706 => Opcode::ADD_FpI32m32,
          707 => Opcode::ADD_FpI32m64,
          708 => Opcode::ADD_FpI32m80,
          709 => Opcode::ADD_FrST0,
          710 => Opcode::ADJCALLSTACKDOWN32,
          711 => Opcode::ADJCALLSTACKDOWN64,
          712 => Opcode::ADJCALLSTACKUP32,
          713 => Opcode::ADJCALLSTACKUP64,
          714 => Opcode::ADOX32rm,
          715 => Opcode::ADOX32rm_EVEX,
          716 => Opcode::ADOX32rm_ND,
          717 => Opcode::ADOX32rr,
          718 => Opcode::ADOX32rr_EVEX,
          719 => Opcode::ADOX32rr_ND,
          720 => Opcode::ADOX64rm,
          721 => Opcode::ADOX64rm_EVEX,
          722 => Opcode::ADOX64rm_ND,
          723 => Opcode::ADOX64rr,
          724 => Opcode::ADOX64rr_EVEX,
          725 => Opcode::ADOX64rr_ND,
          726 => Opcode::AESDEC128KL,
          727 => Opcode::AESDEC256KL,
          728 => Opcode::AESDECLASTrm,
          729 => Opcode::AESDECLASTrr,
          730 => Opcode::AESDECWIDE128KL,
          731 => Opcode::AESDECWIDE256KL,
          732 => Opcode::AESDECrm,
          733 => Opcode::AESDECrr,
          734 => Opcode::AESENC128KL,
          735 => Opcode::AESENC256KL,
          736 => Opcode::AESENCLASTrm,
          737 => Opcode::AESENCLASTrr,
          738 => Opcode::AESENCWIDE128KL,
          739 => Opcode::AESENCWIDE256KL,
          740 => Opcode::AESENCrm,
          741 => Opcode::AESENCrr,
          742 => Opcode::AESIMCrm,
          743 => Opcode::AESIMCrr,
          744 => Opcode::AESKEYGENASSIST128rm,
          745 => Opcode::AESKEYGENASSIST128rr,
          746 => Opcode::AND16i16,
          747 => Opcode::AND16mi,
          748 => Opcode::AND16mi8,
          749 => Opcode::AND16mi8_EVEX,
          750 => Opcode::AND16mi8_ND,
          751 => Opcode::AND16mi8_NF,
          752 => Opcode::AND16mi8_NF_ND,
          753 => Opcode::AND16mi_EVEX,
          754 => Opcode::AND16mi_ND,
          755 => Opcode::AND16mi_NF,
          756 => Opcode::AND16mi_NF_ND,
          757 => Opcode::AND16mr,
          758 => Opcode::AND16mr_EVEX,
          759 => Opcode::AND16mr_ND,
          760 => Opcode::AND16mr_NF,
          761 => Opcode::AND16mr_NF_ND,
          762 => Opcode::AND16ri,
          763 => Opcode::AND16ri8,
          764 => Opcode::AND16ri8_EVEX,
          765 => Opcode::AND16ri8_ND,
          766 => Opcode::AND16ri8_NF,
          767 => Opcode::AND16ri8_NF_ND,
          768 => Opcode::AND16ri_EVEX,
          769 => Opcode::AND16ri_ND,
          770 => Opcode::AND16ri_NF,
          771 => Opcode::AND16ri_NF_ND,
          772 => Opcode::AND16rm,
          773 => Opcode::AND16rm_EVEX,
          774 => Opcode::AND16rm_ND,
          775 => Opcode::AND16rm_NF,
          776 => Opcode::AND16rm_NF_ND,
          777 => Opcode::AND16rr,
          778 => Opcode::AND16rr_EVEX,
          779 => Opcode::AND16rr_EVEX_REV,
          780 => Opcode::AND16rr_ND,
          781 => Opcode::AND16rr_ND_REV,
          782 => Opcode::AND16rr_NF,
          783 => Opcode::AND16rr_NF_ND,
          784 => Opcode::AND16rr_NF_ND_REV,
          785 => Opcode::AND16rr_NF_REV,
          786 => Opcode::AND16rr_REV,
          787 => Opcode::AND32i32,
          788 => Opcode::AND32mi,
          789 => Opcode::AND32mi8,
          790 => Opcode::AND32mi8_EVEX,
          791 => Opcode::AND32mi8_ND,
          792 => Opcode::AND32mi8_NF,
          793 => Opcode::AND32mi8_NF_ND,
          794 => Opcode::AND32mi_EVEX,
          795 => Opcode::AND32mi_ND,
          796 => Opcode::AND32mi_NF,
          797 => Opcode::AND32mi_NF_ND,
          798 => Opcode::AND32mr,
          799 => Opcode::AND32mr_EVEX,
          800 => Opcode::AND32mr_ND,
          801 => Opcode::AND32mr_NF,
          802 => Opcode::AND32mr_NF_ND,
          803 => Opcode::AND32ri,
          804 => Opcode::AND32ri8,
          805 => Opcode::AND32ri8_EVEX,
          806 => Opcode::AND32ri8_ND,
          807 => Opcode::AND32ri8_NF,
          808 => Opcode::AND32ri8_NF_ND,
          809 => Opcode::AND32ri_EVEX,
          810 => Opcode::AND32ri_ND,
          811 => Opcode::AND32ri_NF,
          812 => Opcode::AND32ri_NF_ND,
          813 => Opcode::AND32rm,
          814 => Opcode::AND32rm_EVEX,
          815 => Opcode::AND32rm_ND,
          816 => Opcode::AND32rm_NF,
          817 => Opcode::AND32rm_NF_ND,
          818 => Opcode::AND32rr,
          819 => Opcode::AND32rr_EVEX,
          820 => Opcode::AND32rr_EVEX_REV,
          821 => Opcode::AND32rr_ND,
          822 => Opcode::AND32rr_ND_REV,
          823 => Opcode::AND32rr_NF,
          824 => Opcode::AND32rr_NF_ND,
          825 => Opcode::AND32rr_NF_ND_REV,
          826 => Opcode::AND32rr_NF_REV,
          827 => Opcode::AND32rr_REV,
          828 => Opcode::AND64i32,
          829 => Opcode::AND64mi32,
          830 => Opcode::AND64mi32_EVEX,
          831 => Opcode::AND64mi32_ND,
          832 => Opcode::AND64mi32_NF,
          833 => Opcode::AND64mi32_NF_ND,
          834 => Opcode::AND64mi8,
          835 => Opcode::AND64mi8_EVEX,
          836 => Opcode::AND64mi8_ND,
          837 => Opcode::AND64mi8_NF,
          838 => Opcode::AND64mi8_NF_ND,
          839 => Opcode::AND64mr,
          840 => Opcode::AND64mr_EVEX,
          841 => Opcode::AND64mr_ND,
          842 => Opcode::AND64mr_NF,
          843 => Opcode::AND64mr_NF_ND,
          844 => Opcode::AND64ri32,
          845 => Opcode::AND64ri32_EVEX,
          846 => Opcode::AND64ri32_ND,
          847 => Opcode::AND64ri32_NF,
          848 => Opcode::AND64ri32_NF_ND,
          849 => Opcode::AND64ri8,
          850 => Opcode::AND64ri8_EVEX,
          851 => Opcode::AND64ri8_ND,
          852 => Opcode::AND64ri8_NF,
          853 => Opcode::AND64ri8_NF_ND,
          854 => Opcode::AND64rm,
          855 => Opcode::AND64rm_EVEX,
          856 => Opcode::AND64rm_ND,
          857 => Opcode::AND64rm_NF,
          858 => Opcode::AND64rm_NF_ND,
          859 => Opcode::AND64rr,
          860 => Opcode::AND64rr_EVEX,
          861 => Opcode::AND64rr_EVEX_REV,
          862 => Opcode::AND64rr_ND,
          863 => Opcode::AND64rr_ND_REV,
          864 => Opcode::AND64rr_NF,
          865 => Opcode::AND64rr_NF_ND,
          866 => Opcode::AND64rr_NF_ND_REV,
          867 => Opcode::AND64rr_NF_REV,
          868 => Opcode::AND64rr_REV,
          869 => Opcode::AND8i8,
          870 => Opcode::AND8mi,
          871 => Opcode::AND8mi8,
          872 => Opcode::AND8mi_EVEX,
          873 => Opcode::AND8mi_ND,
          874 => Opcode::AND8mi_NF,
          875 => Opcode::AND8mi_NF_ND,
          876 => Opcode::AND8mr,
          877 => Opcode::AND8mr_EVEX,
          878 => Opcode::AND8mr_ND,
          879 => Opcode::AND8mr_NF,
          880 => Opcode::AND8mr_NF_ND,
          881 => Opcode::AND8ri,
          882 => Opcode::AND8ri8,
          883 => Opcode::AND8ri_EVEX,
          884 => Opcode::AND8ri_ND,
          885 => Opcode::AND8ri_NF,
          886 => Opcode::AND8ri_NF_ND,
          887 => Opcode::AND8rm,
          888 => Opcode::AND8rm_EVEX,
          889 => Opcode::AND8rm_ND,
          890 => Opcode::AND8rm_NF,
          891 => Opcode::AND8rm_NF_ND,
          892 => Opcode::AND8rr,
          893 => Opcode::AND8rr_EVEX,
          894 => Opcode::AND8rr_EVEX_REV,
          895 => Opcode::AND8rr_ND,
          896 => Opcode::AND8rr_ND_REV,
          897 => Opcode::AND8rr_NF,
          898 => Opcode::AND8rr_NF_ND,
          899 => Opcode::AND8rr_NF_ND_REV,
          900 => Opcode::AND8rr_NF_REV,
          901 => Opcode::AND8rr_REV,
          902 => Opcode::ANDN32rm,
          903 => Opcode::ANDN32rm_EVEX,
          904 => Opcode::ANDN32rm_NF,
          905 => Opcode::ANDN32rr,
          906 => Opcode::ANDN32rr_EVEX,
          907 => Opcode::ANDN32rr_NF,
          908 => Opcode::ANDN64rm,
          909 => Opcode::ANDN64rm_EVEX,
          910 => Opcode::ANDN64rm_NF,
          911 => Opcode::ANDN64rr,
          912 => Opcode::ANDN64rr_EVEX,
          913 => Opcode::ANDN64rr_NF,
          914 => Opcode::ANDNPDrm,
          915 => Opcode::ANDNPDrr,
          916 => Opcode::ANDNPSrm,
          917 => Opcode::ANDNPSrr,
          918 => Opcode::ANDPDrm,
          919 => Opcode::ANDPDrr,
          920 => Opcode::ANDPSrm,
          921 => Opcode::ANDPSrr,
          922 => Opcode::AOR32mr,
          923 => Opcode::AOR32mr_EVEX,
          924 => Opcode::AOR64mr,
          925 => Opcode::AOR64mr_EVEX,
          926 => Opcode::ARPL16mr,
          927 => Opcode::ARPL16rr,
          928 => Opcode::ASAN_CHECK_MEMACCESS,
          929 => Opcode::AXOR32mr,
          930 => Opcode::AXOR32mr_EVEX,
          931 => Opcode::AXOR64mr,
          932 => Opcode::AXOR64mr_EVEX,
          933 => Opcode::BEXTR32rm,
          934 => Opcode::BEXTR32rm_EVEX,
          935 => Opcode::BEXTR32rm_NF,
          936 => Opcode::BEXTR32rr,
          937 => Opcode::BEXTR32rr_EVEX,
          938 => Opcode::BEXTR32rr_NF,
          939 => Opcode::BEXTR64rm,
          940 => Opcode::BEXTR64rm_EVEX,
          941 => Opcode::BEXTR64rm_NF,
          942 => Opcode::BEXTR64rr,
          943 => Opcode::BEXTR64rr_EVEX,
          944 => Opcode::BEXTR64rr_NF,
          945 => Opcode::BEXTRI32mi,
          946 => Opcode::BEXTRI32ri,
          947 => Opcode::BEXTRI64mi,
          948 => Opcode::BEXTRI64ri,
          949 => Opcode::BLCFILL32rm,
          950 => Opcode::BLCFILL32rr,
          951 => Opcode::BLCFILL64rm,
          952 => Opcode::BLCFILL64rr,
          953 => Opcode::BLCI32rm,
          954 => Opcode::BLCI32rr,
          955 => Opcode::BLCI64rm,
          956 => Opcode::BLCI64rr,
          957 => Opcode::BLCIC32rm,
          958 => Opcode::BLCIC32rr,
          959 => Opcode::BLCIC64rm,
          960 => Opcode::BLCIC64rr,
          961 => Opcode::BLCMSK32rm,
          962 => Opcode::BLCMSK32rr,
          963 => Opcode::BLCMSK64rm,
          964 => Opcode::BLCMSK64rr,
          965 => Opcode::BLCS32rm,
          966 => Opcode::BLCS32rr,
          967 => Opcode::BLCS64rm,
          968 => Opcode::BLCS64rr,
          969 => Opcode::BLENDPDrmi,
          970 => Opcode::BLENDPDrri,
          971 => Opcode::BLENDPSrmi,
          972 => Opcode::BLENDPSrri,
          973 => Opcode::BLENDVPDrm0,
          974 => Opcode::BLENDVPDrr0,
          975 => Opcode::BLENDVPSrm0,
          976 => Opcode::BLENDVPSrr0,
          977 => Opcode::BLSFILL32rm,
          978 => Opcode::BLSFILL32rr,
          979 => Opcode::BLSFILL64rm,
          980 => Opcode::BLSFILL64rr,
          981 => Opcode::BLSI32rm,
          982 => Opcode::BLSI32rm_EVEX,
          983 => Opcode::BLSI32rm_NF,
          984 => Opcode::BLSI32rr,
          985 => Opcode::BLSI32rr_EVEX,
          986 => Opcode::BLSI32rr_NF,
          987 => Opcode::BLSI64rm,
          988 => Opcode::BLSI64rm_EVEX,
          989 => Opcode::BLSI64rm_NF,
          990 => Opcode::BLSI64rr,
          991 => Opcode::BLSI64rr_EVEX,
          992 => Opcode::BLSI64rr_NF,
          993 => Opcode::BLSIC32rm,
          994 => Opcode::BLSIC32rr,
          995 => Opcode::BLSIC64rm,
          996 => Opcode::BLSIC64rr,
          997 => Opcode::BLSMSK32rm,
          998 => Opcode::BLSMSK32rm_EVEX,
          999 => Opcode::BLSMSK32rm_NF,
          1000 => Opcode::BLSMSK32rr,
          1001 => Opcode::BLSMSK32rr_EVEX,
          1002 => Opcode::BLSMSK32rr_NF,
          1003 => Opcode::BLSMSK64rm,
          1004 => Opcode::BLSMSK64rm_EVEX,
          1005 => Opcode::BLSMSK64rm_NF,
          1006 => Opcode::BLSMSK64rr,
          1007 => Opcode::BLSMSK64rr_EVEX,
          1008 => Opcode::BLSMSK64rr_NF,
          1009 => Opcode::BLSR32rm,
          1010 => Opcode::BLSR32rm_EVEX,
          1011 => Opcode::BLSR32rm_NF,
          1012 => Opcode::BLSR32rr,
          1013 => Opcode::BLSR32rr_EVEX,
          1014 => Opcode::BLSR32rr_NF,
          1015 => Opcode::BLSR64rm,
          1016 => Opcode::BLSR64rm_EVEX,
          1017 => Opcode::BLSR64rm_NF,
          1018 => Opcode::BLSR64rr,
          1019 => Opcode::BLSR64rr_EVEX,
          1020 => Opcode::BLSR64rr_NF,
          1021 => Opcode::BOUNDS16rm,
          1022 => Opcode::BOUNDS32rm,
          1023 => Opcode::BSF16rm,
          1024 => Opcode::BSF16rr,
          1025 => Opcode::BSF32rm,
          1026 => Opcode::BSF32rr,
          1027 => Opcode::BSF64rm,
          1028 => Opcode::BSF64rr,
          1029 => Opcode::BSR16rm,
          1030 => Opcode::BSR16rr,
          1031 => Opcode::BSR32rm,
          1032 => Opcode::BSR32rr,
          1033 => Opcode::BSR64rm,
          1034 => Opcode::BSR64rr,
          1035 => Opcode::BSWAP16r_BAD,
          1036 => Opcode::BSWAP32r,
          1037 => Opcode::BSWAP64r,
          1038 => Opcode::BT16mi8,
          1039 => Opcode::BT16mr,
          1040 => Opcode::BT16ri8,
          1041 => Opcode::BT16rr,
          1042 => Opcode::BT32mi8,
          1043 => Opcode::BT32mr,
          1044 => Opcode::BT32ri8,
          1045 => Opcode::BT32rr,
          1046 => Opcode::BT64mi8,
          1047 => Opcode::BT64mr,
          1048 => Opcode::BT64ri8,
          1049 => Opcode::BT64rr,
          1050 => Opcode::BTC16mi8,
          1051 => Opcode::BTC16mr,
          1052 => Opcode::BTC16ri8,
          1053 => Opcode::BTC16rr,
          1054 => Opcode::BTC32mi8,
          1055 => Opcode::BTC32mr,
          1056 => Opcode::BTC32ri8,
          1057 => Opcode::BTC32rr,
          1058 => Opcode::BTC64mi8,
          1059 => Opcode::BTC64mr,
          1060 => Opcode::BTC64ri8,
          1061 => Opcode::BTC64rr,
          1062 => Opcode::BTR16mi8,
          1063 => Opcode::BTR16mr,
          1064 => Opcode::BTR16ri8,
          1065 => Opcode::BTR16rr,
          1066 => Opcode::BTR32mi8,
          1067 => Opcode::BTR32mr,
          1068 => Opcode::BTR32ri8,
          1069 => Opcode::BTR32rr,
          1070 => Opcode::BTR64mi8,
          1071 => Opcode::BTR64mr,
          1072 => Opcode::BTR64ri8,
          1073 => Opcode::BTR64rr,
          1074 => Opcode::BTS16mi8,
          1075 => Opcode::BTS16mr,
          1076 => Opcode::BTS16ri8,
          1077 => Opcode::BTS16rr,
          1078 => Opcode::BTS32mi8,
          1079 => Opcode::BTS32mr,
          1080 => Opcode::BTS32ri8,
          1081 => Opcode::BTS32rr,
          1082 => Opcode::BTS64mi8,
          1083 => Opcode::BTS64mr,
          1084 => Opcode::BTS64ri8,
          1085 => Opcode::BTS64rr,
          1086 => Opcode::BZHI32rm,
          1087 => Opcode::BZHI32rm_EVEX,
          1088 => Opcode::BZHI32rm_NF,
          1089 => Opcode::BZHI32rr,
          1090 => Opcode::BZHI32rr_EVEX,
          1091 => Opcode::BZHI32rr_NF,
          1092 => Opcode::BZHI64rm,
          1093 => Opcode::BZHI64rm_EVEX,
          1094 => Opcode::BZHI64rm_NF,
          1095 => Opcode::BZHI64rr,
          1096 => Opcode::BZHI64rr_EVEX,
          1097 => Opcode::BZHI64rr_NF,
          1098 => Opcode::CALL16m,
          1099 => Opcode::CALL16m_NT,
          1100 => Opcode::CALL16r,
          1101 => Opcode::CALL16r_NT,
          1102 => Opcode::CALL32m,
          1103 => Opcode::CALL32m_NT,
          1104 => Opcode::CALL32r,
          1105 => Opcode::CALL32r_NT,
          1106 => Opcode::CALL64m,
          1107 => Opcode::CALL64m_NT,
          1108 => Opcode::CALL64pcrel32,
          1109 => Opcode::CALL64r,
          1110 => Opcode::CALL64r_NT,
          1111 => Opcode::CALLpcrel16,
          1112 => Opcode::CALLpcrel32,
          1113 => Opcode::CATCHRET,
          1114 => Opcode::CBW,
          1115 => Opcode::CCMP16mi,
          1116 => Opcode::CCMP16mi8,
          1117 => Opcode::CCMP16mr,
          1118 => Opcode::CCMP16ri,
          1119 => Opcode::CCMP16ri8,
          1120 => Opcode::CCMP16rm,
          1121 => Opcode::CCMP16rr,
          1122 => Opcode::CCMP16rr_REV,
          1123 => Opcode::CCMP32mi,
          1124 => Opcode::CCMP32mi8,
          1125 => Opcode::CCMP32mr,
          1126 => Opcode::CCMP32ri,
          1127 => Opcode::CCMP32ri8,
          1128 => Opcode::CCMP32rm,
          1129 => Opcode::CCMP32rr,
          1130 => Opcode::CCMP32rr_REV,
          1131 => Opcode::CCMP64mi32,
          1132 => Opcode::CCMP64mi8,
          1133 => Opcode::CCMP64mr,
          1134 => Opcode::CCMP64ri32,
          1135 => Opcode::CCMP64ri8,
          1136 => Opcode::CCMP64rm,
          1137 => Opcode::CCMP64rr,
          1138 => Opcode::CCMP64rr_REV,
          1139 => Opcode::CCMP8mi,
          1140 => Opcode::CCMP8mr,
          1141 => Opcode::CCMP8ri,
          1142 => Opcode::CCMP8rm,
          1143 => Opcode::CCMP8rr,
          1144 => Opcode::CCMP8rr_REV,
          1145 => Opcode::CDQ,
          1146 => Opcode::CDQE,
          1147 => Opcode::CFCMOV16mr,
          1148 => Opcode::CFCMOV16rm,
          1149 => Opcode::CFCMOV16rm_ND,
          1150 => Opcode::CFCMOV16rr,
          1151 => Opcode::CFCMOV16rr_ND,
          1152 => Opcode::CFCMOV16rr_REV,
          1153 => Opcode::CFCMOV32mr,
          1154 => Opcode::CFCMOV32rm,
          1155 => Opcode::CFCMOV32rm_ND,
          1156 => Opcode::CFCMOV32rr,
          1157 => Opcode::CFCMOV32rr_ND,
          1158 => Opcode::CFCMOV32rr_REV,
          1159 => Opcode::CFCMOV64mr,
          1160 => Opcode::CFCMOV64rm,
          1161 => Opcode::CFCMOV64rm_ND,
          1162 => Opcode::CFCMOV64rr,
          1163 => Opcode::CFCMOV64rr_ND,
          1164 => Opcode::CFCMOV64rr_REV,
          1165 => Opcode::CHS_F,
          1166 => Opcode::CHS_Fp32,
          1167 => Opcode::CHS_Fp64,
          1168 => Opcode::CHS_Fp80,
          1169 => Opcode::CLAC,
          1170 => Opcode::CLC,
          1171 => Opcode::CLD,
          1172 => Opcode::CLDEMOTE,
          1173 => Opcode::CLEANUPRET,
          1174 => Opcode::CLFLUSH,
          1175 => Opcode::CLFLUSHOPT,
          1176 => Opcode::CLGI,
          1177 => Opcode::CLI,
          1178 => Opcode::CLRSSBSY,
          1179 => Opcode::CLTS,
          1180 => Opcode::CLUI,
          1181 => Opcode::CLWB,
          1182 => Opcode::CLZERO32r,
          1183 => Opcode::CLZERO64r,
          1184 => Opcode::CMC,
          1185 => Opcode::CMOV16rm,
          1186 => Opcode::CMOV16rm_ND,
          1187 => Opcode::CMOV16rr,
          1188 => Opcode::CMOV16rr_ND,
          1189 => Opcode::CMOV32rm,
          1190 => Opcode::CMOV32rm_ND,
          1191 => Opcode::CMOV32rr,
          1192 => Opcode::CMOV32rr_ND,
          1193 => Opcode::CMOV64rm,
          1194 => Opcode::CMOV64rm_ND,
          1195 => Opcode::CMOV64rr,
          1196 => Opcode::CMOV64rr_ND,
          1197 => Opcode::CMOVBE_F,
          1198 => Opcode::CMOVBE_Fp32,
          1199 => Opcode::CMOVBE_Fp64,
          1200 => Opcode::CMOVBE_Fp80,
          1201 => Opcode::CMOVB_F,
          1202 => Opcode::CMOVB_Fp32,
          1203 => Opcode::CMOVB_Fp64,
          1204 => Opcode::CMOVB_Fp80,
          1205 => Opcode::CMOVE_F,
          1206 => Opcode::CMOVE_Fp32,
          1207 => Opcode::CMOVE_Fp64,
          1208 => Opcode::CMOVE_Fp80,
          1209 => Opcode::CMOVNBE_F,
          1210 => Opcode::CMOVNBE_Fp32,
          1211 => Opcode::CMOVNBE_Fp64,
          1212 => Opcode::CMOVNBE_Fp80,
          1213 => Opcode::CMOVNB_F,
          1214 => Opcode::CMOVNB_Fp32,
          1215 => Opcode::CMOVNB_Fp64,
          1216 => Opcode::CMOVNB_Fp80,
          1217 => Opcode::CMOVNE_F,
          1218 => Opcode::CMOVNE_Fp32,
          1219 => Opcode::CMOVNE_Fp64,
          1220 => Opcode::CMOVNE_Fp80,
          1221 => Opcode::CMOVNP_F,
          1222 => Opcode::CMOVNP_Fp32,
          1223 => Opcode::CMOVNP_Fp64,
          1224 => Opcode::CMOVNP_Fp80,
          1225 => Opcode::CMOVP_F,
          1226 => Opcode::CMOVP_Fp32,
          1227 => Opcode::CMOVP_Fp64,
          1228 => Opcode::CMOVP_Fp80,
          1229 => Opcode::CMOV_FR16,
          1230 => Opcode::CMOV_FR16X,
          1231 => Opcode::CMOV_FR32,
          1232 => Opcode::CMOV_FR32X,
          1233 => Opcode::CMOV_FR64,
          1234 => Opcode::CMOV_FR64X,
          1235 => Opcode::CMOV_GR16,
          1236 => Opcode::CMOV_GR32,
          1237 => Opcode::CMOV_GR8,
          1238 => Opcode::CMOV_RFP32,
          1239 => Opcode::CMOV_RFP64,
          1240 => Opcode::CMOV_RFP80,
          1241 => Opcode::CMOV_VK1,
          1242 => Opcode::CMOV_VK16,
          1243 => Opcode::CMOV_VK2,
          1244 => Opcode::CMOV_VK32,
          1245 => Opcode::CMOV_VK4,
          1246 => Opcode::CMOV_VK64,
          1247 => Opcode::CMOV_VK8,
          1248 => Opcode::CMOV_VR128,
          1249 => Opcode::CMOV_VR128X,
          1250 => Opcode::CMOV_VR256,
          1251 => Opcode::CMOV_VR256X,
          1252 => Opcode::CMOV_VR512,
          1253 => Opcode::CMOV_VR64,
          1254 => Opcode::CMP16i16,
          1255 => Opcode::CMP16mi,
          1256 => Opcode::CMP16mi8,
          1257 => Opcode::CMP16mr,
          1258 => Opcode::CMP16ri,
          1259 => Opcode::CMP16ri8,
          1260 => Opcode::CMP16rm,
          1261 => Opcode::CMP16rr,
          1262 => Opcode::CMP16rr_REV,
          1263 => Opcode::CMP32i32,
          1264 => Opcode::CMP32mi,
          1265 => Opcode::CMP32mi8,
          1266 => Opcode::CMP32mr,
          1267 => Opcode::CMP32ri,
          1268 => Opcode::CMP32ri8,
          1269 => Opcode::CMP32rm,
          1270 => Opcode::CMP32rr,
          1271 => Opcode::CMP32rr_REV,
          1272 => Opcode::CMP64i32,
          1273 => Opcode::CMP64mi32,
          1274 => Opcode::CMP64mi8,
          1275 => Opcode::CMP64mr,
          1276 => Opcode::CMP64ri32,
          1277 => Opcode::CMP64ri8,
          1278 => Opcode::CMP64rm,
          1279 => Opcode::CMP64rr,
          1280 => Opcode::CMP64rr_REV,
          1281 => Opcode::CMP8i8,
          1282 => Opcode::CMP8mi,
          1283 => Opcode::CMP8mi8,
          1284 => Opcode::CMP8mr,
          1285 => Opcode::CMP8ri,
          1286 => Opcode::CMP8ri8,
          1287 => Opcode::CMP8rm,
          1288 => Opcode::CMP8rr,
          1289 => Opcode::CMP8rr_REV,
          1290 => Opcode::CMPCCXADDmr32,
          1291 => Opcode::CMPCCXADDmr32_EVEX,
          1292 => Opcode::CMPCCXADDmr64,
          1293 => Opcode::CMPCCXADDmr64_EVEX,
          1294 => Opcode::CMPPDrmi,
          1295 => Opcode::CMPPDrri,
          1296 => Opcode::CMPPSrmi,
          1297 => Opcode::CMPPSrri,
          1298 => Opcode::CMPSB,
          1299 => Opcode::CMPSDrmi,
          1300 => Opcode::CMPSDrmi_Int,
          1301 => Opcode::CMPSDrri,
          1302 => Opcode::CMPSDrri_Int,
          1303 => Opcode::CMPSL,
          1304 => Opcode::CMPSQ,
          1305 => Opcode::CMPSSrmi,
          1306 => Opcode::CMPSSrmi_Int,
          1307 => Opcode::CMPSSrri,
          1308 => Opcode::CMPSSrri_Int,
          1309 => Opcode::CMPSW,
          1310 => Opcode::CMPXCHG16B,
          1311 => Opcode::CMPXCHG16rm,
          1312 => Opcode::CMPXCHG16rr,
          1313 => Opcode::CMPXCHG32rm,
          1314 => Opcode::CMPXCHG32rr,
          1315 => Opcode::CMPXCHG64rm,
          1316 => Opcode::CMPXCHG64rr,
          1317 => Opcode::CMPXCHG8B,
          1318 => Opcode::CMPXCHG8rm,
          1319 => Opcode::CMPXCHG8rr,
          1320 => Opcode::COMISDrm,
          1321 => Opcode::COMISDrm_Int,
          1322 => Opcode::COMISDrr,
          1323 => Opcode::COMISDrr_Int,
          1324 => Opcode::COMISSrm,
          1325 => Opcode::COMISSrm_Int,
          1326 => Opcode::COMISSrr,
          1327 => Opcode::COMISSrr_Int,
          1328 => Opcode::COMP_FST0r,
          1329 => Opcode::COM_FIPr,
          1330 => Opcode::COM_FIr,
          1331 => Opcode::COM_FST0r,
          1332 => Opcode::COM_FpIr32,
          1333 => Opcode::COM_FpIr64,
          1334 => Opcode::COM_FpIr80,
          1335 => Opcode::COM_Fpr32,
          1336 => Opcode::COM_Fpr64,
          1337 => Opcode::COM_Fpr80,
          1338 => Opcode::CPUID,
          1339 => Opcode::CQO,
          1340 => Opcode::CRC32r32m16,
          1341 => Opcode::CRC32r32m16_EVEX,
          1342 => Opcode::CRC32r32m32,
          1343 => Opcode::CRC32r32m32_EVEX,
          1344 => Opcode::CRC32r32m8,
          1345 => Opcode::CRC32r32m8_EVEX,
          1346 => Opcode::CRC32r32r16,
          1347 => Opcode::CRC32r32r16_EVEX,
          1348 => Opcode::CRC32r32r32,
          1349 => Opcode::CRC32r32r32_EVEX,
          1350 => Opcode::CRC32r32r8,
          1351 => Opcode::CRC32r32r8_EVEX,
          1352 => Opcode::CRC32r64m64,
          1353 => Opcode::CRC32r64m64_EVEX,
          1354 => Opcode::CRC32r64m8,
          1355 => Opcode::CRC32r64m8_EVEX,
          1356 => Opcode::CRC32r64r64,
          1357 => Opcode::CRC32r64r64_EVEX,
          1358 => Opcode::CRC32r64r8,
          1359 => Opcode::CRC32r64r8_EVEX,
          1360 => Opcode::CS_PREFIX,
          1361 => Opcode::CTEST16mi,
          1362 => Opcode::CTEST16mr,
          1363 => Opcode::CTEST16ri,
          1364 => Opcode::CTEST16rr,
          1365 => Opcode::CTEST32mi,
          1366 => Opcode::CTEST32mr,
          1367 => Opcode::CTEST32ri,
          1368 => Opcode::CTEST32rr,
          1369 => Opcode::CTEST64mi32,
          1370 => Opcode::CTEST64mr,
          1371 => Opcode::CTEST64ri32,
          1372 => Opcode::CTEST64rr,
          1373 => Opcode::CTEST8mi,
          1374 => Opcode::CTEST8mr,
          1375 => Opcode::CTEST8ri,
          1376 => Opcode::CTEST8rr,
          1377 => Opcode::CVTDQ2PDrm,
          1378 => Opcode::CVTDQ2PDrr,
          1379 => Opcode::CVTDQ2PSrm,
          1380 => Opcode::CVTDQ2PSrr,
          1381 => Opcode::CVTPD2DQrm,
          1382 => Opcode::CVTPD2DQrr,
          1383 => Opcode::CVTPD2PSrm,
          1384 => Opcode::CVTPD2PSrr,
          1385 => Opcode::CVTPS2DQrm,
          1386 => Opcode::CVTPS2DQrr,
          1387 => Opcode::CVTPS2PDrm,
          1388 => Opcode::CVTPS2PDrr,
          1389 => Opcode::CVTSD2SI64rm,
          1390 => Opcode::CVTSD2SI64rm_Int,
          1391 => Opcode::CVTSD2SI64rr,
          1392 => Opcode::CVTSD2SI64rr_Int,
          1393 => Opcode::CVTSD2SIrm,
          1394 => Opcode::CVTSD2SIrm_Int,
          1395 => Opcode::CVTSD2SIrr,
          1396 => Opcode::CVTSD2SIrr_Int,
          1397 => Opcode::CVTSD2SSrm,
          1398 => Opcode::CVTSD2SSrm_Int,
          1399 => Opcode::CVTSD2SSrr,
          1400 => Opcode::CVTSD2SSrr_Int,
          1401 => Opcode::CVTSI2SDrm,
          1402 => Opcode::CVTSI2SDrm_Int,
          1403 => Opcode::CVTSI2SDrr,
          1404 => Opcode::CVTSI2SDrr_Int,
          1405 => Opcode::CVTSI2SSrm,
          1406 => Opcode::CVTSI2SSrm_Int,
          1407 => Opcode::CVTSI2SSrr,
          1408 => Opcode::CVTSI2SSrr_Int,
          1409 => Opcode::CVTSI642SDrm,
          1410 => Opcode::CVTSI642SDrm_Int,
          1411 => Opcode::CVTSI642SDrr,
          1412 => Opcode::CVTSI642SDrr_Int,
          1413 => Opcode::CVTSI642SSrm,
          1414 => Opcode::CVTSI642SSrm_Int,
          1415 => Opcode::CVTSI642SSrr,
          1416 => Opcode::CVTSI642SSrr_Int,
          1417 => Opcode::CVTSS2SDrm,
          1418 => Opcode::CVTSS2SDrm_Int,
          1419 => Opcode::CVTSS2SDrr,
          1420 => Opcode::CVTSS2SDrr_Int,
          1421 => Opcode::CVTSS2SI64rm,
          1422 => Opcode::CVTSS2SI64rm_Int,
          1423 => Opcode::CVTSS2SI64rr,
          1424 => Opcode::CVTSS2SI64rr_Int,
          1425 => Opcode::CVTSS2SIrm,
          1426 => Opcode::CVTSS2SIrm_Int,
          1427 => Opcode::CVTSS2SIrr,
          1428 => Opcode::CVTSS2SIrr_Int,
          1429 => Opcode::CVTTPD2DQrm,
          1430 => Opcode::CVTTPD2DQrr,
          1431 => Opcode::CVTTPS2DQrm,
          1432 => Opcode::CVTTPS2DQrr,
          1433 => Opcode::CVTTSD2SI64rm,
          1434 => Opcode::CVTTSD2SI64rm_Int,
          1435 => Opcode::CVTTSD2SI64rr,
          1436 => Opcode::CVTTSD2SI64rr_Int,
          1437 => Opcode::CVTTSD2SIrm,
          1438 => Opcode::CVTTSD2SIrm_Int,
          1439 => Opcode::CVTTSD2SIrr,
          1440 => Opcode::CVTTSD2SIrr_Int,
          1441 => Opcode::CVTTSS2SI64rm,
          1442 => Opcode::CVTTSS2SI64rm_Int,
          1443 => Opcode::CVTTSS2SI64rr,
          1444 => Opcode::CVTTSS2SI64rr_Int,
          1445 => Opcode::CVTTSS2SIrm,
          1446 => Opcode::CVTTSS2SIrm_Int,
          1447 => Opcode::CVTTSS2SIrr,
          1448 => Opcode::CVTTSS2SIrr_Int,
          1449 => Opcode::CWD,
          1450 => Opcode::CWDE,
          1451 => Opcode::DAA,
          1452 => Opcode::DAS,
          1453 => Opcode::DATA16_PREFIX,
          1454 => Opcode::DEC16m,
          1455 => Opcode::DEC16m_EVEX,
          1456 => Opcode::DEC16m_ND,
          1457 => Opcode::DEC16m_NF,
          1458 => Opcode::DEC16m_NF_ND,
          1459 => Opcode::DEC16r,
          1460 => Opcode::DEC16r_EVEX,
          1461 => Opcode::DEC16r_ND,
          1462 => Opcode::DEC16r_NF,
          1463 => Opcode::DEC16r_NF_ND,
          1464 => Opcode::DEC16r_alt,
          1465 => Opcode::DEC32m,
          1466 => Opcode::DEC32m_EVEX,
          1467 => Opcode::DEC32m_ND,
          1468 => Opcode::DEC32m_NF,
          1469 => Opcode::DEC32m_NF_ND,
          1470 => Opcode::DEC32r,
          1471 => Opcode::DEC32r_EVEX,
          1472 => Opcode::DEC32r_ND,
          1473 => Opcode::DEC32r_NF,
          1474 => Opcode::DEC32r_NF_ND,
          1475 => Opcode::DEC32r_alt,
          1476 => Opcode::DEC64m,
          1477 => Opcode::DEC64m_EVEX,
          1478 => Opcode::DEC64m_ND,
          1479 => Opcode::DEC64m_NF,
          1480 => Opcode::DEC64m_NF_ND,
          1481 => Opcode::DEC64r,
          1482 => Opcode::DEC64r_EVEX,
          1483 => Opcode::DEC64r_ND,
          1484 => Opcode::DEC64r_NF,
          1485 => Opcode::DEC64r_NF_ND,
          1486 => Opcode::DEC8m,
          1487 => Opcode::DEC8m_EVEX,
          1488 => Opcode::DEC8m_ND,
          1489 => Opcode::DEC8m_NF,
          1490 => Opcode::DEC8m_NF_ND,
          1491 => Opcode::DEC8r,
          1492 => Opcode::DEC8r_EVEX,
          1493 => Opcode::DEC8r_ND,
          1494 => Opcode::DEC8r_NF,
          1495 => Opcode::DEC8r_NF_ND,
          1496 => Opcode::DIV16m,
          1497 => Opcode::DIV16m_EVEX,
          1498 => Opcode::DIV16m_NF,
          1499 => Opcode::DIV16r,
          1500 => Opcode::DIV16r_EVEX,
          1501 => Opcode::DIV16r_NF,
          1502 => Opcode::DIV32m,
          1503 => Opcode::DIV32m_EVEX,
          1504 => Opcode::DIV32m_NF,
          1505 => Opcode::DIV32r,
          1506 => Opcode::DIV32r_EVEX,
          1507 => Opcode::DIV32r_NF,
          1508 => Opcode::DIV64m,
          1509 => Opcode::DIV64m_EVEX,
          1510 => Opcode::DIV64m_NF,
          1511 => Opcode::DIV64r,
          1512 => Opcode::DIV64r_EVEX,
          1513 => Opcode::DIV64r_NF,
          1514 => Opcode::DIV8m,
          1515 => Opcode::DIV8m_EVEX,
          1516 => Opcode::DIV8m_NF,
          1517 => Opcode::DIV8r,
          1518 => Opcode::DIV8r_EVEX,
          1519 => Opcode::DIV8r_NF,
          1520 => Opcode::DIVPDrm,
          1521 => Opcode::DIVPDrr,
          1522 => Opcode::DIVPSrm,
          1523 => Opcode::DIVPSrr,
          1524 => Opcode::DIVR_F32m,
          1525 => Opcode::DIVR_F64m,
          1526 => Opcode::DIVR_FI16m,
          1527 => Opcode::DIVR_FI32m,
          1528 => Opcode::DIVR_FPrST0,
          1529 => Opcode::DIVR_FST0r,
          1530 => Opcode::DIVR_Fp32m,
          1531 => Opcode::DIVR_Fp64m,
          1532 => Opcode::DIVR_Fp64m32,
          1533 => Opcode::DIVR_Fp80m32,
          1534 => Opcode::DIVR_Fp80m64,
          1535 => Opcode::DIVR_FpI16m32,
          1536 => Opcode::DIVR_FpI16m64,
          1537 => Opcode::DIVR_FpI16m80,
          1538 => Opcode::DIVR_FpI32m32,
          1539 => Opcode::DIVR_FpI32m64,
          1540 => Opcode::DIVR_FpI32m80,
          1541 => Opcode::DIVR_FrST0,
          1542 => Opcode::DIVSDrm,
          1543 => Opcode::DIVSDrm_Int,
          1544 => Opcode::DIVSDrr,
          1545 => Opcode::DIVSDrr_Int,
          1546 => Opcode::DIVSSrm,
          1547 => Opcode::DIVSSrm_Int,
          1548 => Opcode::DIVSSrr,
          1549 => Opcode::DIVSSrr_Int,
          1550 => Opcode::DIV_F32m,
          1551 => Opcode::DIV_F64m,
          1552 => Opcode::DIV_FI16m,
          1553 => Opcode::DIV_FI32m,
          1554 => Opcode::DIV_FPrST0,
          1555 => Opcode::DIV_FST0r,
          1556 => Opcode::DIV_Fp32,
          1557 => Opcode::DIV_Fp32m,
          1558 => Opcode::DIV_Fp64,
          1559 => Opcode::DIV_Fp64m,
          1560 => Opcode::DIV_Fp64m32,
          1561 => Opcode::DIV_Fp80,
          1562 => Opcode::DIV_Fp80m32,
          1563 => Opcode::DIV_Fp80m64,
          1564 => Opcode::DIV_FpI16m32,
          1565 => Opcode::DIV_FpI16m64,
          1566 => Opcode::DIV_FpI16m80,
          1567 => Opcode::DIV_FpI32m32,
          1568 => Opcode::DIV_FpI32m64,
          1569 => Opcode::DIV_FpI32m80,
          1570 => Opcode::DIV_FrST0,
          1571 => Opcode::DPPDrmi,
          1572 => Opcode::DPPDrri,
          1573 => Opcode::DPPSrmi,
          1574 => Opcode::DPPSrri,
          1575 => Opcode::DS_PREFIX,
          1576 => Opcode::DYN_ALLOCA_32,
          1577 => Opcode::DYN_ALLOCA_64,
          1578 => Opcode::EH_RETURN,
          1579 => Opcode::EH_RETURN64,
          1580 => Opcode::EH_SjLj_LongJmp32,
          1581 => Opcode::EH_SjLj_LongJmp64,
          1582 => Opcode::EH_SjLj_SetJmp32,
          1583 => Opcode::EH_SjLj_SetJmp64,
          1584 => Opcode::EH_SjLj_Setup,
          1585 => Opcode::ENCLS,
          1586 => Opcode::ENCLU,
          1587 => Opcode::ENCLV,
          1588 => Opcode::ENCODEKEY128,
          1589 => Opcode::ENCODEKEY256,
          1590 => Opcode::ENDBR32,
          1591 => Opcode::ENDBR64,
          1592 => Opcode::ENQCMD16,
          1593 => Opcode::ENQCMD32,
          1594 => Opcode::ENQCMD32_EVEX,
          1595 => Opcode::ENQCMD64,
          1596 => Opcode::ENQCMD64_EVEX,
          1597 => Opcode::ENQCMDS16,
          1598 => Opcode::ENQCMDS32,
          1599 => Opcode::ENQCMDS32_EVEX,
          1600 => Opcode::ENQCMDS64,
          1601 => Opcode::ENQCMDS64_EVEX,
          1602 => Opcode::ENTER,
          1603 => Opcode::ERETS,
          1604 => Opcode::ERETU,
          1605 => Opcode::ES_PREFIX,
          1606 => Opcode::EXTRACTPSmr,
          1607 => Opcode::EXTRACTPSrr,
          1608 => Opcode::EXTRQ,
          1609 => Opcode::EXTRQI,
          1610 => Opcode::F2XM1,
          1611 => Opcode::FARCALL16i,
          1612 => Opcode::FARCALL16m,
          1613 => Opcode::FARCALL32i,
          1614 => Opcode::FARCALL32m,
          1615 => Opcode::FARCALL64m,
          1616 => Opcode::FARJMP16i,
          1617 => Opcode::FARJMP16m,
          1618 => Opcode::FARJMP32i,
          1619 => Opcode::FARJMP32m,
          1620 => Opcode::FARJMP64m,
          1621 => Opcode::FBLDm,
          1622 => Opcode::FBSTPm,
          1623 => Opcode::FCOM32m,
          1624 => Opcode::FCOM64m,
          1625 => Opcode::FCOMP32m,
          1626 => Opcode::FCOMP64m,
          1627 => Opcode::FCOMPP,
          1628 => Opcode::FCOS,
          1629 => Opcode::FDECSTP,
          1630 => Opcode::FEMMS,
          1631 => Opcode::FFREE,
          1632 => Opcode::FFREEP,
          1633 => Opcode::FICOM16m,
          1634 => Opcode::FICOM32m,
          1635 => Opcode::FICOMP16m,
          1636 => Opcode::FICOMP32m,
          1637 => Opcode::FINCSTP,
          1638 => Opcode::FLDCW16m,
          1639 => Opcode::FLDENVm,
          1640 => Opcode::FLDL2E,
          1641 => Opcode::FLDL2T,
          1642 => Opcode::FLDLG2,
          1643 => Opcode::FLDLN2,
          1644 => Opcode::FLDPI,
          1645 => Opcode::FNCLEX,
          1646 => Opcode::FNINIT,
          1647 => Opcode::FNOP,
          1648 => Opcode::FNSTCW16m,
          1649 => Opcode::FNSTSW16r,
          1650 => Opcode::FNSTSWm,
          1651 => Opcode::FP32_TO_INT16_IN_MEM,
          1652 => Opcode::FP32_TO_INT32_IN_MEM,
          1653 => Opcode::FP32_TO_INT64_IN_MEM,
          1654 => Opcode::FP64_TO_INT16_IN_MEM,
          1655 => Opcode::FP64_TO_INT32_IN_MEM,
          1656 => Opcode::FP64_TO_INT64_IN_MEM,
          1657 => Opcode::FP80_ADDm32,
          1658 => Opcode::FP80_ADDr,
          1659 => Opcode::FP80_TO_INT16_IN_MEM,
          1660 => Opcode::FP80_TO_INT32_IN_MEM,
          1661 => Opcode::FP80_TO_INT64_IN_MEM,
          1662 => Opcode::FPATAN,
          1663 => Opcode::FPREM,
          1664 => Opcode::FPREM1,
          1665 => Opcode::FPTAN,
          1666 => Opcode::FRNDINT,
          1667 => Opcode::FRSTORm,
          1668 => Opcode::FSAVEm,
          1669 => Opcode::FSCALE,
          1670 => Opcode::FSIN,
          1671 => Opcode::FSINCOS,
          1672 => Opcode::FSTENVm,
          1673 => Opcode::FS_PREFIX,
          1674 => Opcode::FXRSTOR,
          1675 => Opcode::FXRSTOR64,
          1676 => Opcode::FXSAVE,
          1677 => Opcode::FXSAVE64,
          1678 => Opcode::FXTRACT,
          1679 => Opcode::FYL2X,
          1680 => Opcode::FYL2XP1,
          1681 => Opcode::GETSEC,
          1682 => Opcode::GF2P8AFFINEINVQBrmi,
          1683 => Opcode::GF2P8AFFINEINVQBrri,
          1684 => Opcode::GF2P8AFFINEQBrmi,
          1685 => Opcode::GF2P8AFFINEQBrri,
          1686 => Opcode::GF2P8MULBrm,
          1687 => Opcode::GF2P8MULBrr,
          1688 => Opcode::GS_PREFIX,
          1689 => Opcode::HADDPDrm,
          1690 => Opcode::HADDPDrr,
          1691 => Opcode::HADDPSrm,
          1692 => Opcode::HADDPSrr,
          1693 => Opcode::HLT,
          1694 => Opcode::HRESET,
          1695 => Opcode::HSUBPDrm,
          1696 => Opcode::HSUBPDrr,
          1697 => Opcode::HSUBPSrm,
          1698 => Opcode::HSUBPSrr,
          1699 => Opcode::IDIV16m,
          1700 => Opcode::IDIV16m_EVEX,
          1701 => Opcode::IDIV16m_NF,
          1702 => Opcode::IDIV16r,
          1703 => Opcode::IDIV16r_EVEX,
          1704 => Opcode::IDIV16r_NF,
          1705 => Opcode::IDIV32m,
          1706 => Opcode::IDIV32m_EVEX,
          1707 => Opcode::IDIV32m_NF,
          1708 => Opcode::IDIV32r,
          1709 => Opcode::IDIV32r_EVEX,
          1710 => Opcode::IDIV32r_NF,
          1711 => Opcode::IDIV64m,
          1712 => Opcode::IDIV64m_EVEX,
          1713 => Opcode::IDIV64m_NF,
          1714 => Opcode::IDIV64r,
          1715 => Opcode::IDIV64r_EVEX,
          1716 => Opcode::IDIV64r_NF,
          1717 => Opcode::IDIV8m,
          1718 => Opcode::IDIV8m_EVEX,
          1719 => Opcode::IDIV8m_NF,
          1720 => Opcode::IDIV8r,
          1721 => Opcode::IDIV8r_EVEX,
          1722 => Opcode::IDIV8r_NF,
          1723 => Opcode::ILD_F16m,
          1724 => Opcode::ILD_F32m,
          1725 => Opcode::ILD_F64m,
          1726 => Opcode::ILD_Fp16m32,
          1727 => Opcode::ILD_Fp16m64,
          1728 => Opcode::ILD_Fp16m80,
          1729 => Opcode::ILD_Fp32m32,
          1730 => Opcode::ILD_Fp32m64,
          1731 => Opcode::ILD_Fp32m80,
          1732 => Opcode::ILD_Fp64m32,
          1733 => Opcode::ILD_Fp64m64,
          1734 => Opcode::ILD_Fp64m80,
          1735 => Opcode::IMUL16m,
          1736 => Opcode::IMUL16m_EVEX,
          1737 => Opcode::IMUL16m_NF,
          1738 => Opcode::IMUL16r,
          1739 => Opcode::IMUL16r_EVEX,
          1740 => Opcode::IMUL16r_NF,
          1741 => Opcode::IMUL16rm,
          1742 => Opcode::IMUL16rm_EVEX,
          1743 => Opcode::IMUL16rm_ND,
          1744 => Opcode::IMUL16rm_NF,
          1745 => Opcode::IMUL16rm_NF_ND,
          1746 => Opcode::IMUL16rmi,
          1747 => Opcode::IMUL16rmi8,
          1748 => Opcode::IMUL16rmi8_EVEX,
          1749 => Opcode::IMUL16rmi8_NF,
          1750 => Opcode::IMUL16rmi_EVEX,
          1751 => Opcode::IMUL16rmi_NF,
          1752 => Opcode::IMUL16rr,
          1753 => Opcode::IMUL16rr_EVEX,
          1754 => Opcode::IMUL16rr_ND,
          1755 => Opcode::IMUL16rr_NF,
          1756 => Opcode::IMUL16rr_NF_ND,
          1757 => Opcode::IMUL16rri,
          1758 => Opcode::IMUL16rri8,
          1759 => Opcode::IMUL16rri8_EVEX,
          1760 => Opcode::IMUL16rri8_NF,
          1761 => Opcode::IMUL16rri_EVEX,
          1762 => Opcode::IMUL16rri_NF,
          1763 => Opcode::IMUL32m,
          1764 => Opcode::IMUL32m_EVEX,
          1765 => Opcode::IMUL32m_NF,
          1766 => Opcode::IMUL32r,
          1767 => Opcode::IMUL32r_EVEX,
          1768 => Opcode::IMUL32r_NF,
          1769 => Opcode::IMUL32rm,
          1770 => Opcode::IMUL32rm_EVEX,
          1771 => Opcode::IMUL32rm_ND,
          1772 => Opcode::IMUL32rm_NF,
          1773 => Opcode::IMUL32rm_NF_ND,
          1774 => Opcode::IMUL32rmi,
          1775 => Opcode::IMUL32rmi8,
          1776 => Opcode::IMUL32rmi8_EVEX,
          1777 => Opcode::IMUL32rmi8_NF,
          1778 => Opcode::IMUL32rmi_EVEX,
          1779 => Opcode::IMUL32rmi_NF,
          1780 => Opcode::IMUL32rr,
          1781 => Opcode::IMUL32rr_EVEX,
          1782 => Opcode::IMUL32rr_ND,
          1783 => Opcode::IMUL32rr_NF,
          1784 => Opcode::IMUL32rr_NF_ND,
          1785 => Opcode::IMUL32rri,
          1786 => Opcode::IMUL32rri8,
          1787 => Opcode::IMUL32rri8_EVEX,
          1788 => Opcode::IMUL32rri8_NF,
          1789 => Opcode::IMUL32rri_EVEX,
          1790 => Opcode::IMUL32rri_NF,
          1791 => Opcode::IMUL64m,
          1792 => Opcode::IMUL64m_EVEX,
          1793 => Opcode::IMUL64m_NF,
          1794 => Opcode::IMUL64r,
          1795 => Opcode::IMUL64r_EVEX,
          1796 => Opcode::IMUL64r_NF,
          1797 => Opcode::IMUL64rm,
          1798 => Opcode::IMUL64rm_EVEX,
          1799 => Opcode::IMUL64rm_ND,
          1800 => Opcode::IMUL64rm_NF,
          1801 => Opcode::IMUL64rm_NF_ND,
          1802 => Opcode::IMUL64rmi32,
          1803 => Opcode::IMUL64rmi32_EVEX,
          1804 => Opcode::IMUL64rmi32_NF,
          1805 => Opcode::IMUL64rmi8,
          1806 => Opcode::IMUL64rmi8_EVEX,
          1807 => Opcode::IMUL64rmi8_NF,
          1808 => Opcode::IMUL64rr,
          1809 => Opcode::IMUL64rr_EVEX,
          1810 => Opcode::IMUL64rr_ND,
          1811 => Opcode::IMUL64rr_NF,
          1812 => Opcode::IMUL64rr_NF_ND,
          1813 => Opcode::IMUL64rri32,
          1814 => Opcode::IMUL64rri32_EVEX,
          1815 => Opcode::IMUL64rri32_NF,
          1816 => Opcode::IMUL64rri8,
          1817 => Opcode::IMUL64rri8_EVEX,
          1818 => Opcode::IMUL64rri8_NF,
          1819 => Opcode::IMUL8m,
          1820 => Opcode::IMUL8m_EVEX,
          1821 => Opcode::IMUL8m_NF,
          1822 => Opcode::IMUL8r,
          1823 => Opcode::IMUL8r_EVEX,
          1824 => Opcode::IMUL8r_NF,
          1825 => Opcode::IMULZU16rmi,
          1826 => Opcode::IMULZU16rmi8,
          1827 => Opcode::IMULZU16rri,
          1828 => Opcode::IMULZU16rri8,
          1829 => Opcode::IMULZU32rmi,
          1830 => Opcode::IMULZU32rmi8,
          1831 => Opcode::IMULZU32rri,
          1832 => Opcode::IMULZU32rri8,
          1833 => Opcode::IMULZU64rmi32,
          1834 => Opcode::IMULZU64rmi8,
          1835 => Opcode::IMULZU64rri32,
          1836 => Opcode::IMULZU64rri8,
          1837 => Opcode::IN16ri,
          1838 => Opcode::IN16rr,
          1839 => Opcode::IN32ri,
          1840 => Opcode::IN32rr,
          1841 => Opcode::IN8ri,
          1842 => Opcode::IN8rr,
          1843 => Opcode::INC16m,
          1844 => Opcode::INC16m_EVEX,
          1845 => Opcode::INC16m_ND,
          1846 => Opcode::INC16m_NF,
          1847 => Opcode::INC16m_NF_ND,
          1848 => Opcode::INC16r,
          1849 => Opcode::INC16r_EVEX,
          1850 => Opcode::INC16r_ND,
          1851 => Opcode::INC16r_NF,
          1852 => Opcode::INC16r_NF_ND,
          1853 => Opcode::INC16r_alt,
          1854 => Opcode::INC32m,
          1855 => Opcode::INC32m_EVEX,
          1856 => Opcode::INC32m_ND,
          1857 => Opcode::INC32m_NF,
          1858 => Opcode::INC32m_NF_ND,
          1859 => Opcode::INC32r,
          1860 => Opcode::INC32r_EVEX,
          1861 => Opcode::INC32r_ND,
          1862 => Opcode::INC32r_NF,
          1863 => Opcode::INC32r_NF_ND,
          1864 => Opcode::INC32r_alt,
          1865 => Opcode::INC64m,
          1866 => Opcode::INC64m_EVEX,
          1867 => Opcode::INC64m_ND,
          1868 => Opcode::INC64m_NF,
          1869 => Opcode::INC64m_NF_ND,
          1870 => Opcode::INC64r,
          1871 => Opcode::INC64r_EVEX,
          1872 => Opcode::INC64r_ND,
          1873 => Opcode::INC64r_NF,
          1874 => Opcode::INC64r_NF_ND,
          1875 => Opcode::INC8m,
          1876 => Opcode::INC8m_EVEX,
          1877 => Opcode::INC8m_ND,
          1878 => Opcode::INC8m_NF,
          1879 => Opcode::INC8m_NF_ND,
          1880 => Opcode::INC8r,
          1881 => Opcode::INC8r_EVEX,
          1882 => Opcode::INC8r_ND,
          1883 => Opcode::INC8r_NF,
          1884 => Opcode::INC8r_NF_ND,
          1885 => Opcode::INCSSPD,
          1886 => Opcode::INCSSPQ,
          1887 => Opcode::INSB,
          1888 => Opcode::INSERTPSrm,
          1889 => Opcode::INSERTPSrr,
          1890 => Opcode::INSERTQ,
          1891 => Opcode::INSERTQI,
          1892 => Opcode::INSL,
          1893 => Opcode::INSW,
          1894 => Opcode::INT,
          1895 => Opcode::INT3,
          1896 => Opcode::INTO,
          1897 => Opcode::INVD,
          1898 => Opcode::INVEPT32,
          1899 => Opcode::INVEPT64,
          1900 => Opcode::INVEPT64_EVEX,
          1901 => Opcode::INVLPG,
          1902 => Opcode::INVLPGA32,
          1903 => Opcode::INVLPGA64,
          1904 => Opcode::INVLPGB32,
          1905 => Opcode::INVLPGB64,
          1906 => Opcode::INVPCID32,
          1907 => Opcode::INVPCID64,
          1908 => Opcode::INVPCID64_EVEX,
          1909 => Opcode::INVVPID32,
          1910 => Opcode::INVVPID64,
          1911 => Opcode::INVVPID64_EVEX,
          1912 => Opcode::IRET,
          1913 => Opcode::IRET16,
          1914 => Opcode::IRET32,
          1915 => Opcode::IRET64,
          1916 => Opcode::ISTT_FP16m,
          1917 => Opcode::ISTT_FP32m,
          1918 => Opcode::ISTT_FP64m,
          1919 => Opcode::ISTT_Fp16m32,
          1920 => Opcode::ISTT_Fp16m64,
          1921 => Opcode::ISTT_Fp16m80,
          1922 => Opcode::ISTT_Fp32m32,
          1923 => Opcode::ISTT_Fp32m64,
          1924 => Opcode::ISTT_Fp32m80,
          1925 => Opcode::ISTT_Fp64m32,
          1926 => Opcode::ISTT_Fp64m64,
          1927 => Opcode::ISTT_Fp64m80,
          1928 => Opcode::IST_F16m,
          1929 => Opcode::IST_F32m,
          1930 => Opcode::IST_FP16m,
          1931 => Opcode::IST_FP32m,
          1932 => Opcode::IST_FP64m,
          1933 => Opcode::IST_Fp16m32,
          1934 => Opcode::IST_Fp16m64,
          1935 => Opcode::IST_Fp16m80,
          1936 => Opcode::IST_Fp32m32,
          1937 => Opcode::IST_Fp32m64,
          1938 => Opcode::IST_Fp32m80,
          1939 => Opcode::IST_Fp64m32,
          1940 => Opcode::IST_Fp64m64,
          1941 => Opcode::IST_Fp64m80,
          1942 => Opcode::Int_eh_sjlj_setup_dispatch,
          1943 => Opcode::JCC_1,
          1944 => Opcode::JCC_2,
          1945 => Opcode::JCC_4,
          1946 => Opcode::JCXZ,
          1947 => Opcode::JECXZ,
          1948 => Opcode::JMP16m,
          1949 => Opcode::JMP16m_NT,
          1950 => Opcode::JMP16r,
          1951 => Opcode::JMP16r_NT,
          1952 => Opcode::JMP32m,
          1953 => Opcode::JMP32m_NT,
          1954 => Opcode::JMP32r,
          1955 => Opcode::JMP32r_NT,
          1956 => Opcode::JMP64m,
          1957 => Opcode::JMP64m_NT,
          1958 => Opcode::JMP64m_REX,
          1959 => Opcode::JMP64r,
          1960 => Opcode::JMP64r_NT,
          1961 => Opcode::JMP64r_REX,
          1962 => Opcode::JMPABS64i,
          1963 => Opcode::JMP_1,
          1964 => Opcode::JMP_2,
          1965 => Opcode::JMP_4,
          1966 => Opcode::JRCXZ,
          1967 => Opcode::KADDBrr,
          1968 => Opcode::KADDDrr,
          1969 => Opcode::KADDQrr,
          1970 => Opcode::KADDWrr,
          1971 => Opcode::KANDBrr,
          1972 => Opcode::KANDDrr,
          1973 => Opcode::KANDNBrr,
          1974 => Opcode::KANDNDrr,
          1975 => Opcode::KANDNQrr,
          1976 => Opcode::KANDNWrr,
          1977 => Opcode::KANDQrr,
          1978 => Opcode::KANDWrr,
          1979 => Opcode::KCFI_CHECK,
          1980 => Opcode::KMOVBkk,
          1981 => Opcode::KMOVBkk_EVEX,
          1982 => Opcode::KMOVBkm,
          1983 => Opcode::KMOVBkm_EVEX,
          1984 => Opcode::KMOVBkr,
          1985 => Opcode::KMOVBkr_EVEX,
          1986 => Opcode::KMOVBmk,
          1987 => Opcode::KMOVBmk_EVEX,
          1988 => Opcode::KMOVBrk,
          1989 => Opcode::KMOVBrk_EVEX,
          1990 => Opcode::KMOVDkk,
          1991 => Opcode::KMOVDkk_EVEX,
          1992 => Opcode::KMOVDkm,
          1993 => Opcode::KMOVDkm_EVEX,
          1994 => Opcode::KMOVDkr,
          1995 => Opcode::KMOVDkr_EVEX,
          1996 => Opcode::KMOVDmk,
          1997 => Opcode::KMOVDmk_EVEX,
          1998 => Opcode::KMOVDrk,
          1999 => Opcode::KMOVDrk_EVEX,
          2000 => Opcode::KMOVQkk,
          2001 => Opcode::KMOVQkk_EVEX,
          2002 => Opcode::KMOVQkm,
          2003 => Opcode::KMOVQkm_EVEX,
          2004 => Opcode::KMOVQkr,
          2005 => Opcode::KMOVQkr_EVEX,
          2006 => Opcode::KMOVQmk,
          2007 => Opcode::KMOVQmk_EVEX,
          2008 => Opcode::KMOVQrk,
          2009 => Opcode::KMOVQrk_EVEX,
          2010 => Opcode::KMOVWkk,
          2011 => Opcode::KMOVWkk_EVEX,
          2012 => Opcode::KMOVWkm,
          2013 => Opcode::KMOVWkm_EVEX,
          2014 => Opcode::KMOVWkr,
          2015 => Opcode::KMOVWkr_EVEX,
          2016 => Opcode::KMOVWmk,
          2017 => Opcode::KMOVWmk_EVEX,
          2018 => Opcode::KMOVWrk,
          2019 => Opcode::KMOVWrk_EVEX,
          2020 => Opcode::KNOTBrr,
          2021 => Opcode::KNOTDrr,
          2022 => Opcode::KNOTQrr,
          2023 => Opcode::KNOTWrr,
          2024 => Opcode::KORBrr,
          2025 => Opcode::KORDrr,
          2026 => Opcode::KORQrr,
          2027 => Opcode::KORTESTBrr,
          2028 => Opcode::KORTESTDrr,
          2029 => Opcode::KORTESTQrr,
          2030 => Opcode::KORTESTWrr,
          2031 => Opcode::KORWrr,
          2032 => Opcode::KSHIFTLBri,
          2033 => Opcode::KSHIFTLDri,
          2034 => Opcode::KSHIFTLQri,
          2035 => Opcode::KSHIFTLWri,
          2036 => Opcode::KSHIFTRBri,
          2037 => Opcode::KSHIFTRDri,
          2038 => Opcode::KSHIFTRQri,
          2039 => Opcode::KSHIFTRWri,
          2040 => Opcode::KTESTBrr,
          2041 => Opcode::KTESTDrr,
          2042 => Opcode::KTESTQrr,
          2043 => Opcode::KTESTWrr,
          2044 => Opcode::KUNPCKBWrr,
          2045 => Opcode::KUNPCKDQrr,
          2046 => Opcode::KUNPCKWDrr,
          2047 => Opcode::KXNORBrr,
          2048 => Opcode::KXNORDrr,
          2049 => Opcode::KXNORQrr,
          2050 => Opcode::KXNORWrr,
          2051 => Opcode::KXORBrr,
          2052 => Opcode::KXORDrr,
          2053 => Opcode::KXORQrr,
          2054 => Opcode::KXORWrr,
          2055 => Opcode::LAHF,
          2056 => Opcode::LAR16rm,
          2057 => Opcode::LAR16rr,
          2058 => Opcode::LAR32rm,
          2059 => Opcode::LAR32rr,
          2060 => Opcode::LAR64rm,
          2061 => Opcode::LAR64rr,
          2062 => Opcode::LCMPXCHG16,
          2063 => Opcode::LCMPXCHG16B,
          2064 => Opcode::LCMPXCHG32,
          2065 => Opcode::LCMPXCHG64,
          2066 => Opcode::LCMPXCHG8,
          2067 => Opcode::LCMPXCHG8B,
          2068 => Opcode::LDDQUrm,
          2069 => Opcode::LDMXCSR,
          2070 => Opcode::LDS16rm,
          2071 => Opcode::LDS32rm,
          2072 => Opcode::LDTILECFG,
          2073 => Opcode::LDTILECFG_EVEX,
          2074 => Opcode::LD_F0,
          2075 => Opcode::LD_F1,
          2076 => Opcode::LD_F32m,
          2077 => Opcode::LD_F64m,
          2078 => Opcode::LD_F80m,
          2079 => Opcode::LD_Fp032,
          2080 => Opcode::LD_Fp064,
          2081 => Opcode::LD_Fp080,
          2082 => Opcode::LD_Fp132,
          2083 => Opcode::LD_Fp164,
          2084 => Opcode::LD_Fp180,
          2085 => Opcode::LD_Fp32m,
          2086 => Opcode::LD_Fp32m64,
          2087 => Opcode::LD_Fp32m80,
          2088 => Opcode::LD_Fp64m,
          2089 => Opcode::LD_Fp64m80,
          2090 => Opcode::LD_Fp80m,
          2091 => Opcode::LD_Frr,
          2092 => Opcode::LEA16r,
          2093 => Opcode::LEA32r,
          2094 => Opcode::LEA64_32r,
          2095 => Opcode::LEA64r,
          2096 => Opcode::LEAVE,
          2097 => Opcode::LEAVE64,
          2098 => Opcode::LES16rm,
          2099 => Opcode::LES32rm,
          2100 => Opcode::LFENCE,
          2101 => Opcode::LFS16rm,
          2102 => Opcode::LFS32rm,
          2103 => Opcode::LFS64rm,
          2104 => Opcode::LGDT16m,
          2105 => Opcode::LGDT32m,
          2106 => Opcode::LGDT64m,
          2107 => Opcode::LGS16rm,
          2108 => Opcode::LGS32rm,
          2109 => Opcode::LGS64rm,
          2110 => Opcode::LIDT16m,
          2111 => Opcode::LIDT32m,
          2112 => Opcode::LIDT64m,
          2113 => Opcode::LKGS16m,
          2114 => Opcode::LKGS16r,
          2115 => Opcode::LLDT16m,
          2116 => Opcode::LLDT16r,
          2117 => Opcode::LLWPCB,
          2118 => Opcode::LLWPCB64,
          2119 => Opcode::LMSW16m,
          2120 => Opcode::LMSW16r,
          2121 => Opcode::LOADIWKEY,
          2122 => Opcode::LOCK_ADD16mi,
          2123 => Opcode::LOCK_ADD16mi8,
          2124 => Opcode::LOCK_ADD16mr,
          2125 => Opcode::LOCK_ADD32mi,
          2126 => Opcode::LOCK_ADD32mi8,
          2127 => Opcode::LOCK_ADD32mr,
          2128 => Opcode::LOCK_ADD64mi32,
          2129 => Opcode::LOCK_ADD64mi8,
          2130 => Opcode::LOCK_ADD64mr,
          2131 => Opcode::LOCK_ADD8mi,
          2132 => Opcode::LOCK_ADD8mr,
          2133 => Opcode::LOCK_AND16mi,
          2134 => Opcode::LOCK_AND16mi8,
          2135 => Opcode::LOCK_AND16mr,
          2136 => Opcode::LOCK_AND32mi,
          2137 => Opcode::LOCK_AND32mi8,
          2138 => Opcode::LOCK_AND32mr,
          2139 => Opcode::LOCK_AND64mi32,
          2140 => Opcode::LOCK_AND64mi8,
          2141 => Opcode::LOCK_AND64mr,
          2142 => Opcode::LOCK_AND8mi,
          2143 => Opcode::LOCK_AND8mr,
          2144 => Opcode::LOCK_BTC16m,
          2145 => Opcode::LOCK_BTC32m,
          2146 => Opcode::LOCK_BTC64m,
          2147 => Opcode::LOCK_BTC_RM16rm,
          2148 => Opcode::LOCK_BTC_RM32rm,
          2149 => Opcode::LOCK_BTC_RM64rm,
          2150 => Opcode::LOCK_BTR16m,
          2151 => Opcode::LOCK_BTR32m,
          2152 => Opcode::LOCK_BTR64m,
          2153 => Opcode::LOCK_BTR_RM16rm,
          2154 => Opcode::LOCK_BTR_RM32rm,
          2155 => Opcode::LOCK_BTR_RM64rm,
          2156 => Opcode::LOCK_BTS16m,
          2157 => Opcode::LOCK_BTS32m,
          2158 => Opcode::LOCK_BTS64m,
          2159 => Opcode::LOCK_BTS_RM16rm,
          2160 => Opcode::LOCK_BTS_RM32rm,
          2161 => Opcode::LOCK_BTS_RM64rm,
          2162 => Opcode::LOCK_DEC16m,
          2163 => Opcode::LOCK_DEC32m,
          2164 => Opcode::LOCK_DEC64m,
          2165 => Opcode::LOCK_DEC8m,
          2166 => Opcode::LOCK_INC16m,
          2167 => Opcode::LOCK_INC32m,
          2168 => Opcode::LOCK_INC64m,
          2169 => Opcode::LOCK_INC8m,
          2170 => Opcode::LOCK_OR16mi,
          2171 => Opcode::LOCK_OR16mi8,
          2172 => Opcode::LOCK_OR16mr,
          2173 => Opcode::LOCK_OR32mi,
          2174 => Opcode::LOCK_OR32mi8,
          2175 => Opcode::LOCK_OR32mr,
          2176 => Opcode::LOCK_OR64mi32,
          2177 => Opcode::LOCK_OR64mi8,
          2178 => Opcode::LOCK_OR64mr,
          2179 => Opcode::LOCK_OR8mi,
          2180 => Opcode::LOCK_OR8mr,
          2181 => Opcode::LOCK_PREFIX,
          2182 => Opcode::LOCK_SUB16mi,
          2183 => Opcode::LOCK_SUB16mi8,
          2184 => Opcode::LOCK_SUB16mr,
          2185 => Opcode::LOCK_SUB32mi,
          2186 => Opcode::LOCK_SUB32mi8,
          2187 => Opcode::LOCK_SUB32mr,
          2188 => Opcode::LOCK_SUB64mi32,
          2189 => Opcode::LOCK_SUB64mi8,
          2190 => Opcode::LOCK_SUB64mr,
          2191 => Opcode::LOCK_SUB8mi,
          2192 => Opcode::LOCK_SUB8mr,
          2193 => Opcode::LOCK_XOR16mi,
          2194 => Opcode::LOCK_XOR16mi8,
          2195 => Opcode::LOCK_XOR16mr,
          2196 => Opcode::LOCK_XOR32mi,
          2197 => Opcode::LOCK_XOR32mi8,
          2198 => Opcode::LOCK_XOR32mr,
          2199 => Opcode::LOCK_XOR64mi32,
          2200 => Opcode::LOCK_XOR64mi8,
          2201 => Opcode::LOCK_XOR64mr,
          2202 => Opcode::LOCK_XOR8mi,
          2203 => Opcode::LOCK_XOR8mr,
          2204 => Opcode::LODSB,
          2205 => Opcode::LODSL,
          2206 => Opcode::LODSQ,
          2207 => Opcode::LODSW,
          2208 => Opcode::LOOP,
          2209 => Opcode::LOOPE,
          2210 => Opcode::LOOPNE,
          2211 => Opcode::LRET16,
          2212 => Opcode::LRET32,
          2213 => Opcode::LRET64,
          2214 => Opcode::LRETI16,
          2215 => Opcode::LRETI32,
          2216 => Opcode::LRETI64,
          2217 => Opcode::LSL16rm,
          2218 => Opcode::LSL16rr,
          2219 => Opcode::LSL32rm,
          2220 => Opcode::LSL32rr,
          2221 => Opcode::LSL64rm,
          2222 => Opcode::LSL64rr,
          2223 => Opcode::LSS16rm,
          2224 => Opcode::LSS32rm,
          2225 => Opcode::LSS64rm,
          2226 => Opcode::LTRm,
          2227 => Opcode::LTRr,
          2228 => Opcode::LWPINS32rmi,
          2229 => Opcode::LWPINS32rri,
          2230 => Opcode::LWPINS64rmi,
          2231 => Opcode::LWPINS64rri,
          2232 => Opcode::LWPVAL32rmi,
          2233 => Opcode::LWPVAL32rri,
          2234 => Opcode::LWPVAL64rmi,
          2235 => Opcode::LWPVAL64rri,
          2236 => Opcode::LXADD16,
          2237 => Opcode::LXADD32,
          2238 => Opcode::LXADD64,
          2239 => Opcode::LXADD8,
          2240 => Opcode::LZCNT16rm,
          2241 => Opcode::LZCNT16rm_EVEX,
          2242 => Opcode::LZCNT16rm_NF,
          2243 => Opcode::LZCNT16rr,
          2244 => Opcode::LZCNT16rr_EVEX,
          2245 => Opcode::LZCNT16rr_NF,
          2246 => Opcode::LZCNT32rm,
          2247 => Opcode::LZCNT32rm_EVEX,
          2248 => Opcode::LZCNT32rm_NF,
          2249 => Opcode::LZCNT32rr,
          2250 => Opcode::LZCNT32rr_EVEX,
          2251 => Opcode::LZCNT32rr_NF,
          2252 => Opcode::LZCNT64rm,
          2253 => Opcode::LZCNT64rm_EVEX,
          2254 => Opcode::LZCNT64rm_NF,
          2255 => Opcode::LZCNT64rr,
          2256 => Opcode::LZCNT64rr_EVEX,
          2257 => Opcode::LZCNT64rr_NF,
          2258 => Opcode::MASKMOVDQU,
          2259 => Opcode::MASKMOVDQU64,
          2260 => Opcode::MASKPAIR16LOAD,
          2261 => Opcode::MASKPAIR16STORE,
          2262 => Opcode::MAXCPDrm,
          2263 => Opcode::MAXCPDrr,
          2264 => Opcode::MAXCPSrm,
          2265 => Opcode::MAXCPSrr,
          2266 => Opcode::MAXCSDrm,
          2267 => Opcode::MAXCSDrr,
          2268 => Opcode::MAXCSSrm,
          2269 => Opcode::MAXCSSrr,
          2270 => Opcode::MAXPDrm,
          2271 => Opcode::MAXPDrr,
          2272 => Opcode::MAXPSrm,
          2273 => Opcode::MAXPSrr,
          2274 => Opcode::MAXSDrm,
          2275 => Opcode::MAXSDrm_Int,
          2276 => Opcode::MAXSDrr,
          2277 => Opcode::MAXSDrr_Int,
          2278 => Opcode::MAXSSrm,
          2279 => Opcode::MAXSSrm_Int,
          2280 => Opcode::MAXSSrr,
          2281 => Opcode::MAXSSrr_Int,
          2282 => Opcode::MFENCE,
          2283 => Opcode::MINCPDrm,
          2284 => Opcode::MINCPDrr,
          2285 => Opcode::MINCPSrm,
          2286 => Opcode::MINCPSrr,
          2287 => Opcode::MINCSDrm,
          2288 => Opcode::MINCSDrr,
          2289 => Opcode::MINCSSrm,
          2290 => Opcode::MINCSSrr,
          2291 => Opcode::MINPDrm,
          2292 => Opcode::MINPDrr,
          2293 => Opcode::MINPSrm,
          2294 => Opcode::MINPSrr,
          2295 => Opcode::MINSDrm,
          2296 => Opcode::MINSDrm_Int,
          2297 => Opcode::MINSDrr,
          2298 => Opcode::MINSDrr_Int,
          2299 => Opcode::MINSSrm,
          2300 => Opcode::MINSSrm_Int,
          2301 => Opcode::MINSSrr,
          2302 => Opcode::MINSSrr_Int,
          2303 => Opcode::MMX_CVTPD2PIrm,
          2304 => Opcode::MMX_CVTPD2PIrr,
          2305 => Opcode::MMX_CVTPI2PDrm,
          2306 => Opcode::MMX_CVTPI2PDrr,
          2307 => Opcode::MMX_CVTPI2PSrm,
          2308 => Opcode::MMX_CVTPI2PSrr,
          2309 => Opcode::MMX_CVTPS2PIrm,
          2310 => Opcode::MMX_CVTPS2PIrr,
          2311 => Opcode::MMX_CVTTPD2PIrm,
          2312 => Opcode::MMX_CVTTPD2PIrr,
          2313 => Opcode::MMX_CVTTPS2PIrm,
          2314 => Opcode::MMX_CVTTPS2PIrr,
          2315 => Opcode::MMX_EMMS,
          2316 => Opcode::MMX_MASKMOVQ,
          2317 => Opcode::MMX_MASKMOVQ64,
          2318 => Opcode::MMX_MOVD64from64mr,
          2319 => Opcode::MMX_MOVD64from64rr,
          2320 => Opcode::MMX_MOVD64grr,
          2321 => Opcode::MMX_MOVD64mr,
          2322 => Opcode::MMX_MOVD64rm,
          2323 => Opcode::MMX_MOVD64rr,
          2324 => Opcode::MMX_MOVD64to64rm,
          2325 => Opcode::MMX_MOVD64to64rr,
          2326 => Opcode::MMX_MOVDQ2Qrr,
          2327 => Opcode::MMX_MOVFR642Qrr,
          2328 => Opcode::MMX_MOVNTQmr,
          2329 => Opcode::MMX_MOVQ2DQrr,
          2330 => Opcode::MMX_MOVQ2FR64rr,
          2331 => Opcode::MMX_MOVQ64mr,
          2332 => Opcode::MMX_MOVQ64rm,
          2333 => Opcode::MMX_MOVQ64rr,
          2334 => Opcode::MMX_MOVQ64rr_REV,
          2335 => Opcode::MMX_PABSBrm,
          2336 => Opcode::MMX_PABSBrr,
          2337 => Opcode::MMX_PABSDrm,
          2338 => Opcode::MMX_PABSDrr,
          2339 => Opcode::MMX_PABSWrm,
          2340 => Opcode::MMX_PABSWrr,
          2341 => Opcode::MMX_PACKSSDWrm,
          2342 => Opcode::MMX_PACKSSDWrr,
          2343 => Opcode::MMX_PACKSSWBrm,
          2344 => Opcode::MMX_PACKSSWBrr,
          2345 => Opcode::MMX_PACKUSWBrm,
          2346 => Opcode::MMX_PACKUSWBrr,
          2347 => Opcode::MMX_PADDBrm,
          2348 => Opcode::MMX_PADDBrr,
          2349 => Opcode::MMX_PADDDrm,
          2350 => Opcode::MMX_PADDDrr,
          2351 => Opcode::MMX_PADDQrm,
          2352 => Opcode::MMX_PADDQrr,
          2353 => Opcode::MMX_PADDSBrm,
          2354 => Opcode::MMX_PADDSBrr,
          2355 => Opcode::MMX_PADDSWrm,
          2356 => Opcode::MMX_PADDSWrr,
          2357 => Opcode::MMX_PADDUSBrm,
          2358 => Opcode::MMX_PADDUSBrr,
          2359 => Opcode::MMX_PADDUSWrm,
          2360 => Opcode::MMX_PADDUSWrr,
          2361 => Opcode::MMX_PADDWrm,
          2362 => Opcode::MMX_PADDWrr,
          2363 => Opcode::MMX_PALIGNRrmi,
          2364 => Opcode::MMX_PALIGNRrri,
          2365 => Opcode::MMX_PANDNrm,
          2366 => Opcode::MMX_PANDNrr,
          2367 => Opcode::MMX_PANDrm,
          2368 => Opcode::MMX_PANDrr,
          2369 => Opcode::MMX_PAVGBrm,
          2370 => Opcode::MMX_PAVGBrr,
          2371 => Opcode::MMX_PAVGWrm,
          2372 => Opcode::MMX_PAVGWrr,
          2373 => Opcode::MMX_PCMPEQBrm,
          2374 => Opcode::MMX_PCMPEQBrr,
          2375 => Opcode::MMX_PCMPEQDrm,
          2376 => Opcode::MMX_PCMPEQDrr,
          2377 => Opcode::MMX_PCMPEQWrm,
          2378 => Opcode::MMX_PCMPEQWrr,
          2379 => Opcode::MMX_PCMPGTBrm,
          2380 => Opcode::MMX_PCMPGTBrr,
          2381 => Opcode::MMX_PCMPGTDrm,
          2382 => Opcode::MMX_PCMPGTDrr,
          2383 => Opcode::MMX_PCMPGTWrm,
          2384 => Opcode::MMX_PCMPGTWrr,
          2385 => Opcode::MMX_PEXTRWrr,
          2386 => Opcode::MMX_PHADDDrm,
          2387 => Opcode::MMX_PHADDDrr,
          2388 => Opcode::MMX_PHADDSWrm,
          2389 => Opcode::MMX_PHADDSWrr,
          2390 => Opcode::MMX_PHADDWrm,
          2391 => Opcode::MMX_PHADDWrr,
          2392 => Opcode::MMX_PHSUBDrm,
          2393 => Opcode::MMX_PHSUBDrr,
          2394 => Opcode::MMX_PHSUBSWrm,
          2395 => Opcode::MMX_PHSUBSWrr,
          2396 => Opcode::MMX_PHSUBWrm,
          2397 => Opcode::MMX_PHSUBWrr,
          2398 => Opcode::MMX_PINSRWrm,
          2399 => Opcode::MMX_PINSRWrr,
          2400 => Opcode::MMX_PMADDUBSWrm,
          2401 => Opcode::MMX_PMADDUBSWrr,
          2402 => Opcode::MMX_PMADDWDrm,
          2403 => Opcode::MMX_PMADDWDrr,
          2404 => Opcode::MMX_PMAXSWrm,
          2405 => Opcode::MMX_PMAXSWrr,
          2406 => Opcode::MMX_PMAXUBrm,
          2407 => Opcode::MMX_PMAXUBrr,
          2408 => Opcode::MMX_PMINSWrm,
          2409 => Opcode::MMX_PMINSWrr,
          2410 => Opcode::MMX_PMINUBrm,
          2411 => Opcode::MMX_PMINUBrr,
          2412 => Opcode::MMX_PMOVMSKBrr,
          2413 => Opcode::MMX_PMULHRSWrm,
          2414 => Opcode::MMX_PMULHRSWrr,
          2415 => Opcode::MMX_PMULHUWrm,
          2416 => Opcode::MMX_PMULHUWrr,
          2417 => Opcode::MMX_PMULHWrm,
          2418 => Opcode::MMX_PMULHWrr,
          2419 => Opcode::MMX_PMULLWrm,
          2420 => Opcode::MMX_PMULLWrr,
          2421 => Opcode::MMX_PMULUDQrm,
          2422 => Opcode::MMX_PMULUDQrr,
          2423 => Opcode::MMX_PORrm,
          2424 => Opcode::MMX_PORrr,
          2425 => Opcode::MMX_PSADBWrm,
          2426 => Opcode::MMX_PSADBWrr,
          2427 => Opcode::MMX_PSHUFBrm,
          2428 => Opcode::MMX_PSHUFBrr,
          2429 => Opcode::MMX_PSHUFWmi,
          2430 => Opcode::MMX_PSHUFWri,
          2431 => Opcode::MMX_PSIGNBrm,
          2432 => Opcode::MMX_PSIGNBrr,
          2433 => Opcode::MMX_PSIGNDrm,
          2434 => Opcode::MMX_PSIGNDrr,
          2435 => Opcode::MMX_PSIGNWrm,
          2436 => Opcode::MMX_PSIGNWrr,
          2437 => Opcode::MMX_PSLLDri,
          2438 => Opcode::MMX_PSLLDrm,
          2439 => Opcode::MMX_PSLLDrr,
          2440 => Opcode::MMX_PSLLQri,
          2441 => Opcode::MMX_PSLLQrm,
          2442 => Opcode::MMX_PSLLQrr,
          2443 => Opcode::MMX_PSLLWri,
          2444 => Opcode::MMX_PSLLWrm,
          2445 => Opcode::MMX_PSLLWrr,
          2446 => Opcode::MMX_PSRADri,
          2447 => Opcode::MMX_PSRADrm,
          2448 => Opcode::MMX_PSRADrr,
          2449 => Opcode::MMX_PSRAWri,
          2450 => Opcode::MMX_PSRAWrm,
          2451 => Opcode::MMX_PSRAWrr,
          2452 => Opcode::MMX_PSRLDri,
          2453 => Opcode::MMX_PSRLDrm,
          2454 => Opcode::MMX_PSRLDrr,
          2455 => Opcode::MMX_PSRLQri,
          2456 => Opcode::MMX_PSRLQrm,
          2457 => Opcode::MMX_PSRLQrr,
          2458 => Opcode::MMX_PSRLWri,
          2459 => Opcode::MMX_PSRLWrm,
          2460 => Opcode::MMX_PSRLWrr,
          2461 => Opcode::MMX_PSUBBrm,
          2462 => Opcode::MMX_PSUBBrr,
          2463 => Opcode::MMX_PSUBDrm,
          2464 => Opcode::MMX_PSUBDrr,
          2465 => Opcode::MMX_PSUBQrm,
          2466 => Opcode::MMX_PSUBQrr,
          2467 => Opcode::MMX_PSUBSBrm,
          2468 => Opcode::MMX_PSUBSBrr,
          2469 => Opcode::MMX_PSUBSWrm,
          2470 => Opcode::MMX_PSUBSWrr,
          2471 => Opcode::MMX_PSUBUSBrm,
          2472 => Opcode::MMX_PSUBUSBrr,
          2473 => Opcode::MMX_PSUBUSWrm,
          2474 => Opcode::MMX_PSUBUSWrr,
          2475 => Opcode::MMX_PSUBWrm,
          2476 => Opcode::MMX_PSUBWrr,
          2477 => Opcode::MMX_PUNPCKHBWrm,
          2478 => Opcode::MMX_PUNPCKHBWrr,
          2479 => Opcode::MMX_PUNPCKHDQrm,
          2480 => Opcode::MMX_PUNPCKHDQrr,
          2481 => Opcode::MMX_PUNPCKHWDrm,
          2482 => Opcode::MMX_PUNPCKHWDrr,
          2483 => Opcode::MMX_PUNPCKLBWrm,
          2484 => Opcode::MMX_PUNPCKLBWrr,
          2485 => Opcode::MMX_PUNPCKLDQrm,
          2486 => Opcode::MMX_PUNPCKLDQrr,
          2487 => Opcode::MMX_PUNPCKLWDrm,
          2488 => Opcode::MMX_PUNPCKLWDrr,
          2489 => Opcode::MMX_PXORrm,
          2490 => Opcode::MMX_PXORrr,
          2491 => Opcode::MONITOR32rrr,
          2492 => Opcode::MONITOR64rrr,
          2493 => Opcode::MONITORX32rrr,
          2494 => Opcode::MONITORX64rrr,
          2495 => Opcode::MONTMUL,
          2496 => Opcode::MOV16ao16,
          2497 => Opcode::MOV16ao32,
          2498 => Opcode::MOV16ao64,
          2499 => Opcode::MOV16mi,
          2500 => Opcode::MOV16mr,
          2501 => Opcode::MOV16ms,
          2502 => Opcode::MOV16o16a,
          2503 => Opcode::MOV16o32a,
          2504 => Opcode::MOV16o64a,
          2505 => Opcode::MOV16ri,
          2506 => Opcode::MOV16ri_alt,
          2507 => Opcode::MOV16rm,
          2508 => Opcode::MOV16rr,
          2509 => Opcode::MOV16rr_REV,
          2510 => Opcode::MOV16rs,
          2511 => Opcode::MOV16sm,
          2512 => Opcode::MOV16sr,
          2513 => Opcode::MOV32ao16,
          2514 => Opcode::MOV32ao32,
          2515 => Opcode::MOV32ao64,
          2516 => Opcode::MOV32cr,
          2517 => Opcode::MOV32dr,
          2518 => Opcode::MOV32mi,
          2519 => Opcode::MOV32mr,
          2520 => Opcode::MOV32o16a,
          2521 => Opcode::MOV32o32a,
          2522 => Opcode::MOV32o64a,
          2523 => Opcode::MOV32rc,
          2524 => Opcode::MOV32rd,
          2525 => Opcode::MOV32ri,
          2526 => Opcode::MOV32ri_alt,
          2527 => Opcode::MOV32rm,
          2528 => Opcode::MOV32rr,
          2529 => Opcode::MOV32rr_REV,
          2530 => Opcode::MOV32rs,
          2531 => Opcode::MOV32sr,
          2532 => Opcode::MOV64ao32,
          2533 => Opcode::MOV64ao64,
          2534 => Opcode::MOV64cr,
          2535 => Opcode::MOV64dr,
          2536 => Opcode::MOV64mi32,
          2537 => Opcode::MOV64mr,
          2538 => Opcode::MOV64o32a,
          2539 => Opcode::MOV64o64a,
          2540 => Opcode::MOV64rc,
          2541 => Opcode::MOV64rd,
          2542 => Opcode::MOV64ri,
          2543 => Opcode::MOV64ri32,
          2544 => Opcode::MOV64rm,
          2545 => Opcode::MOV64rr,
          2546 => Opcode::MOV64rr_REV,
          2547 => Opcode::MOV64rs,
          2548 => Opcode::MOV64sr,
          2549 => Opcode::MOV64toPQIrm,
          2550 => Opcode::MOV64toPQIrr,
          2551 => Opcode::MOV64toSDrr,
          2552 => Opcode::MOV8ao16,
          2553 => Opcode::MOV8ao32,
          2554 => Opcode::MOV8ao64,
          2555 => Opcode::MOV8mi,
          2556 => Opcode::MOV8mr,
          2557 => Opcode::MOV8mr_NOREX,
          2558 => Opcode::MOV8o16a,
          2559 => Opcode::MOV8o32a,
          2560 => Opcode::MOV8o64a,
          2561 => Opcode::MOV8ri,
          2562 => Opcode::MOV8ri_alt,
          2563 => Opcode::MOV8rm,
          2564 => Opcode::MOV8rm_NOREX,
          2565 => Opcode::MOV8rr,
          2566 => Opcode::MOV8rr_NOREX,
          2567 => Opcode::MOV8rr_REV,
          2568 => Opcode::MOVAPDmr,
          2569 => Opcode::MOVAPDrm,
          2570 => Opcode::MOVAPDrr,
          2571 => Opcode::MOVAPDrr_REV,
          2572 => Opcode::MOVAPSmr,
          2573 => Opcode::MOVAPSrm,
          2574 => Opcode::MOVAPSrr,
          2575 => Opcode::MOVAPSrr_REV,
          2576 => Opcode::MOVBE16mr,
          2577 => Opcode::MOVBE16mr_EVEX,
          2578 => Opcode::MOVBE16rm,
          2579 => Opcode::MOVBE16rm_EVEX,
          2580 => Opcode::MOVBE16rr,
          2581 => Opcode::MOVBE16rr_REV,
          2582 => Opcode::MOVBE32mr,
          2583 => Opcode::MOVBE32mr_EVEX,
          2584 => Opcode::MOVBE32rm,
          2585 => Opcode::MOVBE32rm_EVEX,
          2586 => Opcode::MOVBE32rr,
          2587 => Opcode::MOVBE32rr_REV,
          2588 => Opcode::MOVBE64mr,
          2589 => Opcode::MOVBE64mr_EVEX,
          2590 => Opcode::MOVBE64rm,
          2591 => Opcode::MOVBE64rm_EVEX,
          2592 => Opcode::MOVBE64rr,
          2593 => Opcode::MOVBE64rr_REV,
          2594 => Opcode::MOVDDUPrm,
          2595 => Opcode::MOVDDUPrr,
          2596 => Opcode::MOVDI2PDIrm,
          2597 => Opcode::MOVDI2PDIrr,
          2598 => Opcode::MOVDI2SSrr,
          2599 => Opcode::MOVDIR64B16,
          2600 => Opcode::MOVDIR64B32,
          2601 => Opcode::MOVDIR64B32_EVEX,
          2602 => Opcode::MOVDIR64B64,
          2603 => Opcode::MOVDIR64B64_EVEX,
          2604 => Opcode::MOVDIRI32,
          2605 => Opcode::MOVDIRI32_EVEX,
          2606 => Opcode::MOVDIRI64,
          2607 => Opcode::MOVDIRI64_EVEX,
          2608 => Opcode::MOVDQAmr,
          2609 => Opcode::MOVDQArm,
          2610 => Opcode::MOVDQArr,
          2611 => Opcode::MOVDQArr_REV,
          2612 => Opcode::MOVDQUmr,
          2613 => Opcode::MOVDQUrm,
          2614 => Opcode::MOVDQUrr,
          2615 => Opcode::MOVDQUrr_REV,
          2616 => Opcode::MOVHLPSrr,
          2617 => Opcode::MOVHPDmr,
          2618 => Opcode::MOVHPDrm,
          2619 => Opcode::MOVHPSmr,
          2620 => Opcode::MOVHPSrm,
          2621 => Opcode::MOVLHPSrr,
          2622 => Opcode::MOVLPDmr,
          2623 => Opcode::MOVLPDrm,
          2624 => Opcode::MOVLPSmr,
          2625 => Opcode::MOVLPSrm,
          2626 => Opcode::MOVMSKPDrr,
          2627 => Opcode::MOVMSKPSrr,
          2628 => Opcode::MOVNTDQArm,
          2629 => Opcode::MOVNTDQmr,
          2630 => Opcode::MOVNTI_64mr,
          2631 => Opcode::MOVNTImr,
          2632 => Opcode::MOVNTPDmr,
          2633 => Opcode::MOVNTPSmr,
          2634 => Opcode::MOVNTSD,
          2635 => Opcode::MOVNTSS,
          2636 => Opcode::MOVPC32r,
          2637 => Opcode::MOVPDI2DImr,
          2638 => Opcode::MOVPDI2DIrr,
          2639 => Opcode::MOVPQI2QImr,
          2640 => Opcode::MOVPQI2QIrr,
          2641 => Opcode::MOVPQIto64mr,
          2642 => Opcode::MOVPQIto64rr,
          2643 => Opcode::MOVQI2PQIrm,
          2644 => Opcode::MOVSB,
          2645 => Opcode::MOVSDmr,
          2646 => Opcode::MOVSDrm,
          2647 => Opcode::MOVSDrm_alt,
          2648 => Opcode::MOVSDrr,
          2649 => Opcode::MOVSDrr_REV,
          2650 => Opcode::MOVSDto64rr,
          2651 => Opcode::MOVSHDUPrm,
          2652 => Opcode::MOVSHDUPrr,
          2653 => Opcode::MOVSL,
          2654 => Opcode::MOVSLDUPrm,
          2655 => Opcode::MOVSLDUPrr,
          2656 => Opcode::MOVSQ,
          2657 => Opcode::MOVSS2DIrr,
          2658 => Opcode::MOVSSmr,
          2659 => Opcode::MOVSSrm,
          2660 => Opcode::MOVSSrm_alt,
          2661 => Opcode::MOVSSrr,
          2662 => Opcode::MOVSSrr_REV,
          2663 => Opcode::MOVSW,
          2664 => Opcode::MOVSX16rm16,
          2665 => Opcode::MOVSX16rm32,
          2666 => Opcode::MOVSX16rm8,
          2667 => Opcode::MOVSX16rr16,
          2668 => Opcode::MOVSX16rr32,
          2669 => Opcode::MOVSX16rr8,
          2670 => Opcode::MOVSX32rm16,
          2671 => Opcode::MOVSX32rm32,
          2672 => Opcode::MOVSX32rm8,
          2673 => Opcode::MOVSX32rm8_NOREX,
          2674 => Opcode::MOVSX32rr16,
          2675 => Opcode::MOVSX32rr32,
          2676 => Opcode::MOVSX32rr8,
          2677 => Opcode::MOVSX32rr8_NOREX,
          2678 => Opcode::MOVSX64rm16,
          2679 => Opcode::MOVSX64rm32,
          2680 => Opcode::MOVSX64rm8,
          2681 => Opcode::MOVSX64rr16,
          2682 => Opcode::MOVSX64rr32,
          2683 => Opcode::MOVSX64rr8,
          2684 => Opcode::MOVUPDmr,
          2685 => Opcode::MOVUPDrm,
          2686 => Opcode::MOVUPDrr,
          2687 => Opcode::MOVUPDrr_REV,
          2688 => Opcode::MOVUPSmr,
          2689 => Opcode::MOVUPSrm,
          2690 => Opcode::MOVUPSrr,
          2691 => Opcode::MOVUPSrr_REV,
          2692 => Opcode::MOVZPQILo2PQIrr,
          2693 => Opcode::MOVZX16rm16,
          2694 => Opcode::MOVZX16rm8,
          2695 => Opcode::MOVZX16rr16,
          2696 => Opcode::MOVZX16rr8,
          2697 => Opcode::MOVZX32rm16,
          2698 => Opcode::MOVZX32rm8,
          2699 => Opcode::MOVZX32rm8_NOREX,
          2700 => Opcode::MOVZX32rr16,
          2701 => Opcode::MOVZX32rr8,
          2702 => Opcode::MOVZX32rr8_NOREX,
          2703 => Opcode::MOVZX64rm16,
          2704 => Opcode::MOVZX64rm8,
          2705 => Opcode::MOVZX64rr16,
          2706 => Opcode::MOVZX64rr8,
          2707 => Opcode::MPSADBWrmi,
          2708 => Opcode::MPSADBWrri,
          2709 => Opcode::MUL16m,
          2710 => Opcode::MUL16m_EVEX,
          2711 => Opcode::MUL16m_NF,
          2712 => Opcode::MUL16r,
          2713 => Opcode::MUL16r_EVEX,
          2714 => Opcode::MUL16r_NF,
          2715 => Opcode::MUL32m,
          2716 => Opcode::MUL32m_EVEX,
          2717 => Opcode::MUL32m_NF,
          2718 => Opcode::MUL32r,
          2719 => Opcode::MUL32r_EVEX,
          2720 => Opcode::MUL32r_NF,
          2721 => Opcode::MUL64m,
          2722 => Opcode::MUL64m_EVEX,
          2723 => Opcode::MUL64m_NF,
          2724 => Opcode::MUL64r,
          2725 => Opcode::MUL64r_EVEX,
          2726 => Opcode::MUL64r_NF,
          2727 => Opcode::MUL8m,
          2728 => Opcode::MUL8m_EVEX,
          2729 => Opcode::MUL8m_NF,
          2730 => Opcode::MUL8r,
          2731 => Opcode::MUL8r_EVEX,
          2732 => Opcode::MUL8r_NF,
          2733 => Opcode::MULPDrm,
          2734 => Opcode::MULPDrr,
          2735 => Opcode::MULPSrm,
          2736 => Opcode::MULPSrr,
          2737 => Opcode::MULSDrm,
          2738 => Opcode::MULSDrm_Int,
          2739 => Opcode::MULSDrr,
          2740 => Opcode::MULSDrr_Int,
          2741 => Opcode::MULSSrm,
          2742 => Opcode::MULSSrm_Int,
          2743 => Opcode::MULSSrr,
          2744 => Opcode::MULSSrr_Int,
          2745 => Opcode::MULX32Hrm,
          2746 => Opcode::MULX32Hrr,
          2747 => Opcode::MULX32rm,
          2748 => Opcode::MULX32rm_EVEX,
          2749 => Opcode::MULX32rr,
          2750 => Opcode::MULX32rr_EVEX,
          2751 => Opcode::MULX64Hrm,
          2752 => Opcode::MULX64Hrr,
          2753 => Opcode::MULX64rm,
          2754 => Opcode::MULX64rm_EVEX,
          2755 => Opcode::MULX64rr,
          2756 => Opcode::MULX64rr_EVEX,
          2757 => Opcode::MUL_F32m,
          2758 => Opcode::MUL_F64m,
          2759 => Opcode::MUL_FI16m,
          2760 => Opcode::MUL_FI32m,
          2761 => Opcode::MUL_FPrST0,
          2762 => Opcode::MUL_FST0r,
          2763 => Opcode::MUL_Fp32,
          2764 => Opcode::MUL_Fp32m,
          2765 => Opcode::MUL_Fp64,
          2766 => Opcode::MUL_Fp64m,
          2767 => Opcode::MUL_Fp64m32,
          2768 => Opcode::MUL_Fp80,
          2769 => Opcode::MUL_Fp80m32,
          2770 => Opcode::MUL_Fp80m64,
          2771 => Opcode::MUL_FpI16m32,
          2772 => Opcode::MUL_FpI16m64,
          2773 => Opcode::MUL_FpI16m80,
          2774 => Opcode::MUL_FpI32m32,
          2775 => Opcode::MUL_FpI32m64,
          2776 => Opcode::MUL_FpI32m80,
          2777 => Opcode::MUL_FrST0,
          2778 => Opcode::MWAITXrrr,
          2779 => Opcode::MWAITrr,
          2780 => Opcode::NEG16m,
          2781 => Opcode::NEG16m_EVEX,
          2782 => Opcode::NEG16m_ND,
          2783 => Opcode::NEG16m_NF,
          2784 => Opcode::NEG16m_NF_ND,
          2785 => Opcode::NEG16r,
          2786 => Opcode::NEG16r_EVEX,
          2787 => Opcode::NEG16r_ND,
          2788 => Opcode::NEG16r_NF,
          2789 => Opcode::NEG16r_NF_ND,
          2790 => Opcode::NEG32m,
          2791 => Opcode::NEG32m_EVEX,
          2792 => Opcode::NEG32m_ND,
          2793 => Opcode::NEG32m_NF,
          2794 => Opcode::NEG32m_NF_ND,
          2795 => Opcode::NEG32r,
          2796 => Opcode::NEG32r_EVEX,
          2797 => Opcode::NEG32r_ND,
          2798 => Opcode::NEG32r_NF,
          2799 => Opcode::NEG32r_NF_ND,
          2800 => Opcode::NEG64m,
          2801 => Opcode::NEG64m_EVEX,
          2802 => Opcode::NEG64m_ND,
          2803 => Opcode::NEG64m_NF,
          2804 => Opcode::NEG64m_NF_ND,
          2805 => Opcode::NEG64r,
          2806 => Opcode::NEG64r_EVEX,
          2807 => Opcode::NEG64r_ND,
          2808 => Opcode::NEG64r_NF,
          2809 => Opcode::NEG64r_NF_ND,
          2810 => Opcode::NEG8m,
          2811 => Opcode::NEG8m_EVEX,
          2812 => Opcode::NEG8m_ND,
          2813 => Opcode::NEG8m_NF,
          2814 => Opcode::NEG8m_NF_ND,
          2815 => Opcode::NEG8r,
          2816 => Opcode::NEG8r_EVEX,
          2817 => Opcode::NEG8r_ND,
          2818 => Opcode::NEG8r_NF,
          2819 => Opcode::NEG8r_NF_ND,
          2820 => Opcode::NOOP,
          2821 => Opcode::NOOPL,
          2822 => Opcode::NOOPLr,
          2823 => Opcode::NOOPQ,
          2824 => Opcode::NOOPQr,
          2825 => Opcode::NOOPW,
          2826 => Opcode::NOOPWr,
          2827 => Opcode::NOT16m,
          2828 => Opcode::NOT16m_EVEX,
          2829 => Opcode::NOT16m_ND,
          2830 => Opcode::NOT16r,
          2831 => Opcode::NOT16r_EVEX,
          2832 => Opcode::NOT16r_ND,
          2833 => Opcode::NOT32m,
          2834 => Opcode::NOT32m_EVEX,
          2835 => Opcode::NOT32m_ND,
          2836 => Opcode::NOT32r,
          2837 => Opcode::NOT32r_EVEX,
          2838 => Opcode::NOT32r_ND,
          2839 => Opcode::NOT64m,
          2840 => Opcode::NOT64m_EVEX,
          2841 => Opcode::NOT64m_ND,
          2842 => Opcode::NOT64r,
          2843 => Opcode::NOT64r_EVEX,
          2844 => Opcode::NOT64r_ND,
          2845 => Opcode::NOT8m,
          2846 => Opcode::NOT8m_EVEX,
          2847 => Opcode::NOT8m_ND,
          2848 => Opcode::NOT8r,
          2849 => Opcode::NOT8r_EVEX,
          2850 => Opcode::NOT8r_ND,
          2851 => Opcode::OR16i16,
          2852 => Opcode::OR16mi,
          2853 => Opcode::OR16mi8,
          2854 => Opcode::OR16mi8_EVEX,
          2855 => Opcode::OR16mi8_ND,
          2856 => Opcode::OR16mi8_NF,
          2857 => Opcode::OR16mi8_NF_ND,
          2858 => Opcode::OR16mi_EVEX,
          2859 => Opcode::OR16mi_ND,
          2860 => Opcode::OR16mi_NF,
          2861 => Opcode::OR16mi_NF_ND,
          2862 => Opcode::OR16mr,
          2863 => Opcode::OR16mr_EVEX,
          2864 => Opcode::OR16mr_ND,
          2865 => Opcode::OR16mr_NF,
          2866 => Opcode::OR16mr_NF_ND,
          2867 => Opcode::OR16ri,
          2868 => Opcode::OR16ri8,
          2869 => Opcode::OR16ri8_EVEX,
          2870 => Opcode::OR16ri8_ND,
          2871 => Opcode::OR16ri8_NF,
          2872 => Opcode::OR16ri8_NF_ND,
          2873 => Opcode::OR16ri_EVEX,
          2874 => Opcode::OR16ri_ND,
          2875 => Opcode::OR16ri_NF,
          2876 => Opcode::OR16ri_NF_ND,
          2877 => Opcode::OR16rm,
          2878 => Opcode::OR16rm_EVEX,
          2879 => Opcode::OR16rm_ND,
          2880 => Opcode::OR16rm_NF,
          2881 => Opcode::OR16rm_NF_ND,
          2882 => Opcode::OR16rr,
          2883 => Opcode::OR16rr_EVEX,
          2884 => Opcode::OR16rr_EVEX_REV,
          2885 => Opcode::OR16rr_ND,
          2886 => Opcode::OR16rr_ND_REV,
          2887 => Opcode::OR16rr_NF,
          2888 => Opcode::OR16rr_NF_ND,
          2889 => Opcode::OR16rr_NF_ND_REV,
          2890 => Opcode::OR16rr_NF_REV,
          2891 => Opcode::OR16rr_REV,
          2892 => Opcode::OR32i32,
          2893 => Opcode::OR32mi,
          2894 => Opcode::OR32mi8,
          2895 => Opcode::OR32mi8Locked,
          2896 => Opcode::OR32mi8_EVEX,
          2897 => Opcode::OR32mi8_ND,
          2898 => Opcode::OR32mi8_NF,
          2899 => Opcode::OR32mi8_NF_ND,
          2900 => Opcode::OR32mi_EVEX,
          2901 => Opcode::OR32mi_ND,
          2902 => Opcode::OR32mi_NF,
          2903 => Opcode::OR32mi_NF_ND,
          2904 => Opcode::OR32mr,
          2905 => Opcode::OR32mr_EVEX,
          2906 => Opcode::OR32mr_ND,
          2907 => Opcode::OR32mr_NF,
          2908 => Opcode::OR32mr_NF_ND,
          2909 => Opcode::OR32ri,
          2910 => Opcode::OR32ri8,
          2911 => Opcode::OR32ri8_EVEX,
          2912 => Opcode::OR32ri8_ND,
          2913 => Opcode::OR32ri8_NF,
          2914 => Opcode::OR32ri8_NF_ND,
          2915 => Opcode::OR32ri_EVEX,
          2916 => Opcode::OR32ri_ND,
          2917 => Opcode::OR32ri_NF,
          2918 => Opcode::OR32ri_NF_ND,
          2919 => Opcode::OR32rm,
          2920 => Opcode::OR32rm_EVEX,
          2921 => Opcode::OR32rm_ND,
          2922 => Opcode::OR32rm_NF,
          2923 => Opcode::OR32rm_NF_ND,
          2924 => Opcode::OR32rr,
          2925 => Opcode::OR32rr_EVEX,
          2926 => Opcode::OR32rr_EVEX_REV,
          2927 => Opcode::OR32rr_ND,
          2928 => Opcode::OR32rr_ND_REV,
          2929 => Opcode::OR32rr_NF,
          2930 => Opcode::OR32rr_NF_ND,
          2931 => Opcode::OR32rr_NF_ND_REV,
          2932 => Opcode::OR32rr_NF_REV,
          2933 => Opcode::OR32rr_REV,
          2934 => Opcode::OR64i32,
          2935 => Opcode::OR64mi32,
          2936 => Opcode::OR64mi32_EVEX,
          2937 => Opcode::OR64mi32_ND,
          2938 => Opcode::OR64mi32_NF,
          2939 => Opcode::OR64mi32_NF_ND,
          2940 => Opcode::OR64mi8,
          2941 => Opcode::OR64mi8_EVEX,
          2942 => Opcode::OR64mi8_ND,
          2943 => Opcode::OR64mi8_NF,
          2944 => Opcode::OR64mi8_NF_ND,
          2945 => Opcode::OR64mr,
          2946 => Opcode::OR64mr_EVEX,
          2947 => Opcode::OR64mr_ND,
          2948 => Opcode::OR64mr_NF,
          2949 => Opcode::OR64mr_NF_ND,
          2950 => Opcode::OR64ri32,
          2951 => Opcode::OR64ri32_EVEX,
          2952 => Opcode::OR64ri32_ND,
          2953 => Opcode::OR64ri32_NF,
          2954 => Opcode::OR64ri32_NF_ND,
          2955 => Opcode::OR64ri8,
          2956 => Opcode::OR64ri8_EVEX,
          2957 => Opcode::OR64ri8_ND,
          2958 => Opcode::OR64ri8_NF,
          2959 => Opcode::OR64ri8_NF_ND,
          2960 => Opcode::OR64rm,
          2961 => Opcode::OR64rm_EVEX,
          2962 => Opcode::OR64rm_ND,
          2963 => Opcode::OR64rm_NF,
          2964 => Opcode::OR64rm_NF_ND,
          2965 => Opcode::OR64rr,
          2966 => Opcode::OR64rr_EVEX,
          2967 => Opcode::OR64rr_EVEX_REV,
          2968 => Opcode::OR64rr_ND,
          2969 => Opcode::OR64rr_ND_REV,
          2970 => Opcode::OR64rr_NF,
          2971 => Opcode::OR64rr_NF_ND,
          2972 => Opcode::OR64rr_NF_ND_REV,
          2973 => Opcode::OR64rr_NF_REV,
          2974 => Opcode::OR64rr_REV,
          2975 => Opcode::OR8i8,
          2976 => Opcode::OR8mi,
          2977 => Opcode::OR8mi8,
          2978 => Opcode::OR8mi_EVEX,
          2979 => Opcode::OR8mi_ND,
          2980 => Opcode::OR8mi_NF,
          2981 => Opcode::OR8mi_NF_ND,
          2982 => Opcode::OR8mr,
          2983 => Opcode::OR8mr_EVEX,
          2984 => Opcode::OR8mr_ND,
          2985 => Opcode::OR8mr_NF,
          2986 => Opcode::OR8mr_NF_ND,
          2987 => Opcode::OR8ri,
          2988 => Opcode::OR8ri8,
          2989 => Opcode::OR8ri_EVEX,
          2990 => Opcode::OR8ri_ND,
          2991 => Opcode::OR8ri_NF,
          2992 => Opcode::OR8ri_NF_ND,
          2993 => Opcode::OR8rm,
          2994 => Opcode::OR8rm_EVEX,
          2995 => Opcode::OR8rm_ND,
          2996 => Opcode::OR8rm_NF,
          2997 => Opcode::OR8rm_NF_ND,
          2998 => Opcode::OR8rr,
          2999 => Opcode::OR8rr_EVEX,
          3000 => Opcode::OR8rr_EVEX_REV,
          3001 => Opcode::OR8rr_ND,
          3002 => Opcode::OR8rr_ND_REV,
          3003 => Opcode::OR8rr_NF,
          3004 => Opcode::OR8rr_NF_ND,
          3005 => Opcode::OR8rr_NF_ND_REV,
          3006 => Opcode::OR8rr_NF_REV,
          3007 => Opcode::OR8rr_REV,
          3008 => Opcode::ORPDrm,
          3009 => Opcode::ORPDrr,
          3010 => Opcode::ORPSrm,
          3011 => Opcode::ORPSrr,
          3012 => Opcode::OUT16ir,
          3013 => Opcode::OUT16rr,
          3014 => Opcode::OUT32ir,
          3015 => Opcode::OUT32rr,
          3016 => Opcode::OUT8ir,
          3017 => Opcode::OUT8rr,
          3018 => Opcode::OUTSB,
          3019 => Opcode::OUTSL,
          3020 => Opcode::OUTSW,
          3021 => Opcode::PABSBrm,
          3022 => Opcode::PABSBrr,
          3023 => Opcode::PABSDrm,
          3024 => Opcode::PABSDrr,
          3025 => Opcode::PABSWrm,
          3026 => Opcode::PABSWrr,
          3027 => Opcode::PACKSSDWrm,
          3028 => Opcode::PACKSSDWrr,
          3029 => Opcode::PACKSSWBrm,
          3030 => Opcode::PACKSSWBrr,
          3031 => Opcode::PACKUSDWrm,
          3032 => Opcode::PACKUSDWrr,
          3033 => Opcode::PACKUSWBrm,
          3034 => Opcode::PACKUSWBrr,
          3035 => Opcode::PADDBrm,
          3036 => Opcode::PADDBrr,
          3037 => Opcode::PADDDrm,
          3038 => Opcode::PADDDrr,
          3039 => Opcode::PADDQrm,
          3040 => Opcode::PADDQrr,
          3041 => Opcode::PADDSBrm,
          3042 => Opcode::PADDSBrr,
          3043 => Opcode::PADDSWrm,
          3044 => Opcode::PADDSWrr,
          3045 => Opcode::PADDUSBrm,
          3046 => Opcode::PADDUSBrr,
          3047 => Opcode::PADDUSWrm,
          3048 => Opcode::PADDUSWrr,
          3049 => Opcode::PADDWrm,
          3050 => Opcode::PADDWrr,
          3051 => Opcode::PALIGNRrmi,
          3052 => Opcode::PALIGNRrri,
          3053 => Opcode::PANDNrm,
          3054 => Opcode::PANDNrr,
          3055 => Opcode::PANDrm,
          3056 => Opcode::PANDrr,
          3057 => Opcode::PAUSE,
          3058 => Opcode::PAVGBrm,
          3059 => Opcode::PAVGBrr,
          3060 => Opcode::PAVGUSBrm,
          3061 => Opcode::PAVGUSBrr,
          3062 => Opcode::PAVGWrm,
          3063 => Opcode::PAVGWrr,
          3064 => Opcode::PBLENDVBrm0,
          3065 => Opcode::PBLENDVBrr0,
          3066 => Opcode::PBLENDWrmi,
          3067 => Opcode::PBLENDWrri,
          3068 => Opcode::PBNDKB,
          3069 => Opcode::PCLMULQDQrmi,
          3070 => Opcode::PCLMULQDQrri,
          3071 => Opcode::PCMPEQBrm,
          3072 => Opcode::PCMPEQBrr,
          3073 => Opcode::PCMPEQDrm,
          3074 => Opcode::PCMPEQDrr,
          3075 => Opcode::PCMPEQQrm,
          3076 => Opcode::PCMPEQQrr,
          3077 => Opcode::PCMPEQWrm,
          3078 => Opcode::PCMPEQWrr,
          3079 => Opcode::PCMPESTRIrmi,
          3080 => Opcode::PCMPESTRIrri,
          3081 => Opcode::PCMPESTRMrmi,
          3082 => Opcode::PCMPESTRMrri,
          3083 => Opcode::PCMPGTBrm,
          3084 => Opcode::PCMPGTBrr,
          3085 => Opcode::PCMPGTDrm,
          3086 => Opcode::PCMPGTDrr,
          3087 => Opcode::PCMPGTQrm,
          3088 => Opcode::PCMPGTQrr,
          3089 => Opcode::PCMPGTWrm,
          3090 => Opcode::PCMPGTWrr,
          3091 => Opcode::PCMPISTRIrmi,
          3092 => Opcode::PCMPISTRIrri,
          3093 => Opcode::PCMPISTRMrmi,
          3094 => Opcode::PCMPISTRMrri,
          3095 => Opcode::PCONFIG,
          3096 => Opcode::PDEP32rm,
          3097 => Opcode::PDEP32rm_EVEX,
          3098 => Opcode::PDEP32rr,
          3099 => Opcode::PDEP32rr_EVEX,
          3100 => Opcode::PDEP64rm,
          3101 => Opcode::PDEP64rm_EVEX,
          3102 => Opcode::PDEP64rr,
          3103 => Opcode::PDEP64rr_EVEX,
          3104 => Opcode::PEXT32rm,
          3105 => Opcode::PEXT32rm_EVEX,
          3106 => Opcode::PEXT32rr,
          3107 => Opcode::PEXT32rr_EVEX,
          3108 => Opcode::PEXT64rm,
          3109 => Opcode::PEXT64rm_EVEX,
          3110 => Opcode::PEXT64rr,
          3111 => Opcode::PEXT64rr_EVEX,
          3112 => Opcode::PEXTRBmr,
          3113 => Opcode::PEXTRBrr,
          3114 => Opcode::PEXTRDmr,
          3115 => Opcode::PEXTRDrr,
          3116 => Opcode::PEXTRQmr,
          3117 => Opcode::PEXTRQrr,
          3118 => Opcode::PEXTRWmr,
          3119 => Opcode::PEXTRWrr,
          3120 => Opcode::PEXTRWrr_REV,
          3121 => Opcode::PF2IDrm,
          3122 => Opcode::PF2IDrr,
          3123 => Opcode::PF2IWrm,
          3124 => Opcode::PF2IWrr,
          3125 => Opcode::PFACCrm,
          3126 => Opcode::PFACCrr,
          3127 => Opcode::PFADDrm,
          3128 => Opcode::PFADDrr,
          3129 => Opcode::PFCMPEQrm,
          3130 => Opcode::PFCMPEQrr,
          3131 => Opcode::PFCMPGErm,
          3132 => Opcode::PFCMPGErr,
          3133 => Opcode::PFCMPGTrm,
          3134 => Opcode::PFCMPGTrr,
          3135 => Opcode::PFMAXrm,
          3136 => Opcode::PFMAXrr,
          3137 => Opcode::PFMINrm,
          3138 => Opcode::PFMINrr,
          3139 => Opcode::PFMULrm,
          3140 => Opcode::PFMULrr,
          3141 => Opcode::PFNACCrm,
          3142 => Opcode::PFNACCrr,
          3143 => Opcode::PFPNACCrm,
          3144 => Opcode::PFPNACCrr,
          3145 => Opcode::PFRCPIT1rm,
          3146 => Opcode::PFRCPIT1rr,
          3147 => Opcode::PFRCPIT2rm,
          3148 => Opcode::PFRCPIT2rr,
          3149 => Opcode::PFRCPrm,
          3150 => Opcode::PFRCPrr,
          3151 => Opcode::PFRSQIT1rm,
          3152 => Opcode::PFRSQIT1rr,
          3153 => Opcode::PFRSQRTrm,
          3154 => Opcode::PFRSQRTrr,
          3155 => Opcode::PFSUBRrm,
          3156 => Opcode::PFSUBRrr,
          3157 => Opcode::PFSUBrm,
          3158 => Opcode::PFSUBrr,
          3159 => Opcode::PHADDDrm,
          3160 => Opcode::PHADDDrr,
          3161 => Opcode::PHADDSWrm,
          3162 => Opcode::PHADDSWrr,
          3163 => Opcode::PHADDWrm,
          3164 => Opcode::PHADDWrr,
          3165 => Opcode::PHMINPOSUWrm,
          3166 => Opcode::PHMINPOSUWrr,
          3167 => Opcode::PHSUBDrm,
          3168 => Opcode::PHSUBDrr,
          3169 => Opcode::PHSUBSWrm,
          3170 => Opcode::PHSUBSWrr,
          3171 => Opcode::PHSUBWrm,
          3172 => Opcode::PHSUBWrr,
          3173 => Opcode::PI2FDrm,
          3174 => Opcode::PI2FDrr,
          3175 => Opcode::PI2FWrm,
          3176 => Opcode::PI2FWrr,
          3177 => Opcode::PINSRBrm,
          3178 => Opcode::PINSRBrr,
          3179 => Opcode::PINSRDrm,
          3180 => Opcode::PINSRDrr,
          3181 => Opcode::PINSRQrm,
          3182 => Opcode::PINSRQrr,
          3183 => Opcode::PINSRWrm,
          3184 => Opcode::PINSRWrr,
          3185 => Opcode::PMADDUBSWrm,
          3186 => Opcode::PMADDUBSWrr,
          3187 => Opcode::PMADDWDrm,
          3188 => Opcode::PMADDWDrr,
          3189 => Opcode::PMAXSBrm,
          3190 => Opcode::PMAXSBrr,
          3191 => Opcode::PMAXSDrm,
          3192 => Opcode::PMAXSDrr,
          3193 => Opcode::PMAXSWrm,
          3194 => Opcode::PMAXSWrr,
          3195 => Opcode::PMAXUBrm,
          3196 => Opcode::PMAXUBrr,
          3197 => Opcode::PMAXUDrm,
          3198 => Opcode::PMAXUDrr,
          3199 => Opcode::PMAXUWrm,
          3200 => Opcode::PMAXUWrr,
          3201 => Opcode::PMINSBrm,
          3202 => Opcode::PMINSBrr,
          3203 => Opcode::PMINSDrm,
          3204 => Opcode::PMINSDrr,
          3205 => Opcode::PMINSWrm,
          3206 => Opcode::PMINSWrr,
          3207 => Opcode::PMINUBrm,
          3208 => Opcode::PMINUBrr,
          3209 => Opcode::PMINUDrm,
          3210 => Opcode::PMINUDrr,
          3211 => Opcode::PMINUWrm,
          3212 => Opcode::PMINUWrr,
          3213 => Opcode::PMOVMSKBrr,
          3214 => Opcode::PMOVSXBDrm,
          3215 => Opcode::PMOVSXBDrr,
          3216 => Opcode::PMOVSXBQrm,
          3217 => Opcode::PMOVSXBQrr,
          3218 => Opcode::PMOVSXBWrm,
          3219 => Opcode::PMOVSXBWrr,
          3220 => Opcode::PMOVSXDQrm,
          3221 => Opcode::PMOVSXDQrr,
          3222 => Opcode::PMOVSXWDrm,
          3223 => Opcode::PMOVSXWDrr,
          3224 => Opcode::PMOVSXWQrm,
          3225 => Opcode::PMOVSXWQrr,
          3226 => Opcode::PMOVZXBDrm,
          3227 => Opcode::PMOVZXBDrr,
          3228 => Opcode::PMOVZXBQrm,
          3229 => Opcode::PMOVZXBQrr,
          3230 => Opcode::PMOVZXBWrm,
          3231 => Opcode::PMOVZXBWrr,
          3232 => Opcode::PMOVZXDQrm,
          3233 => Opcode::PMOVZXDQrr,
          3234 => Opcode::PMOVZXWDrm,
          3235 => Opcode::PMOVZXWDrr,
          3236 => Opcode::PMOVZXWQrm,
          3237 => Opcode::PMOVZXWQrr,
          3238 => Opcode::PMULDQrm,
          3239 => Opcode::PMULDQrr,
          3240 => Opcode::PMULHRSWrm,
          3241 => Opcode::PMULHRSWrr,
          3242 => Opcode::PMULHRWrm,
          3243 => Opcode::PMULHRWrr,
          3244 => Opcode::PMULHUWrm,
          3245 => Opcode::PMULHUWrr,
          3246 => Opcode::PMULHWrm,
          3247 => Opcode::PMULHWrr,
          3248 => Opcode::PMULLDrm,
          3249 => Opcode::PMULLDrr,
          3250 => Opcode::PMULLWrm,
          3251 => Opcode::PMULLWrr,
          3252 => Opcode::PMULUDQrm,
          3253 => Opcode::PMULUDQrr,
          3254 => Opcode::POP16r,
          3255 => Opcode::POP16rmm,
          3256 => Opcode::POP16rmr,
          3257 => Opcode::POP2,
          3258 => Opcode::POP2P,
          3259 => Opcode::POP32r,
          3260 => Opcode::POP32rmm,
          3261 => Opcode::POP32rmr,
          3262 => Opcode::POP64r,
          3263 => Opcode::POP64rmm,
          3264 => Opcode::POP64rmr,
          3265 => Opcode::POPA16,
          3266 => Opcode::POPA32,
          3267 => Opcode::POPCNT16rm,
          3268 => Opcode::POPCNT16rm_EVEX,
          3269 => Opcode::POPCNT16rm_NF,
          3270 => Opcode::POPCNT16rr,
          3271 => Opcode::POPCNT16rr_EVEX,
          3272 => Opcode::POPCNT16rr_NF,
          3273 => Opcode::POPCNT32rm,
          3274 => Opcode::POPCNT32rm_EVEX,
          3275 => Opcode::POPCNT32rm_NF,
          3276 => Opcode::POPCNT32rr,
          3277 => Opcode::POPCNT32rr_EVEX,
          3278 => Opcode::POPCNT32rr_NF,
          3279 => Opcode::POPCNT64rm,
          3280 => Opcode::POPCNT64rm_EVEX,
          3281 => Opcode::POPCNT64rm_NF,
          3282 => Opcode::POPCNT64rr,
          3283 => Opcode::POPCNT64rr_EVEX,
          3284 => Opcode::POPCNT64rr_NF,
          3285 => Opcode::POPDS16,
          3286 => Opcode::POPDS32,
          3287 => Opcode::POPES16,
          3288 => Opcode::POPES32,
          3289 => Opcode::POPF16,
          3290 => Opcode::POPF32,
          3291 => Opcode::POPF64,
          3292 => Opcode::POPFS16,
          3293 => Opcode::POPFS32,
          3294 => Opcode::POPFS64,
          3295 => Opcode::POPGS16,
          3296 => Opcode::POPGS32,
          3297 => Opcode::POPGS64,
          3298 => Opcode::POPP64r,
          3299 => Opcode::POPSS16,
          3300 => Opcode::POPSS32,
          3301 => Opcode::PORrm,
          3302 => Opcode::PORrr,
          3303 => Opcode::PREFETCH,
          3304 => Opcode::PREFETCHIT0,
          3305 => Opcode::PREFETCHIT1,
          3306 => Opcode::PREFETCHNTA,
          3307 => Opcode::PREFETCHT0,
          3308 => Opcode::PREFETCHT1,
          3309 => Opcode::PREFETCHT2,
          3310 => Opcode::PREFETCHW,
          3311 => Opcode::PREFETCHWT1,
          3312 => Opcode::PROBED_ALLOCA_32,
          3313 => Opcode::PROBED_ALLOCA_64,
          3314 => Opcode::PSADBWrm,
          3315 => Opcode::PSADBWrr,
          3316 => Opcode::PSHUFBrm,
          3317 => Opcode::PSHUFBrr,
          3318 => Opcode::PSHUFDmi,
          3319 => Opcode::PSHUFDri,
          3320 => Opcode::PSHUFHWmi,
          3321 => Opcode::PSHUFHWri,
          3322 => Opcode::PSHUFLWmi,
          3323 => Opcode::PSHUFLWri,
          3324 => Opcode::PSIGNBrm,
          3325 => Opcode::PSIGNBrr,
          3326 => Opcode::PSIGNDrm,
          3327 => Opcode::PSIGNDrr,
          3328 => Opcode::PSIGNWrm,
          3329 => Opcode::PSIGNWrr,
          3330 => Opcode::PSLLDQri,
          3331 => Opcode::PSLLDri,
          3332 => Opcode::PSLLDrm,
          3333 => Opcode::PSLLDrr,
          3334 => Opcode::PSLLQri,
          3335 => Opcode::PSLLQrm,
          3336 => Opcode::PSLLQrr,
          3337 => Opcode::PSLLWri,
          3338 => Opcode::PSLLWrm,
          3339 => Opcode::PSLLWrr,
          3340 => Opcode::PSMASH,
          3341 => Opcode::PSRADri,
          3342 => Opcode::PSRADrm,
          3343 => Opcode::PSRADrr,
          3344 => Opcode::PSRAWri,
          3345 => Opcode::PSRAWrm,
          3346 => Opcode::PSRAWrr,
          3347 => Opcode::PSRLDQri,
          3348 => Opcode::PSRLDri,
          3349 => Opcode::PSRLDrm,
          3350 => Opcode::PSRLDrr,
          3351 => Opcode::PSRLQri,
          3352 => Opcode::PSRLQrm,
          3353 => Opcode::PSRLQrr,
          3354 => Opcode::PSRLWri,
          3355 => Opcode::PSRLWrm,
          3356 => Opcode::PSRLWrr,
          3357 => Opcode::PSUBBrm,
          3358 => Opcode::PSUBBrr,
          3359 => Opcode::PSUBDrm,
          3360 => Opcode::PSUBDrr,
          3361 => Opcode::PSUBQrm,
          3362 => Opcode::PSUBQrr,
          3363 => Opcode::PSUBSBrm,
          3364 => Opcode::PSUBSBrr,
          3365 => Opcode::PSUBSWrm,
          3366 => Opcode::PSUBSWrr,
          3367 => Opcode::PSUBUSBrm,
          3368 => Opcode::PSUBUSBrr,
          3369 => Opcode::PSUBUSWrm,
          3370 => Opcode::PSUBUSWrr,
          3371 => Opcode::PSUBWrm,
          3372 => Opcode::PSUBWrr,
          3373 => Opcode::PSWAPDrm,
          3374 => Opcode::PSWAPDrr,
          3375 => Opcode::PTCMMIMFP16PS,
          3376 => Opcode::PTCMMIMFP16PSV,
          3377 => Opcode::PTCMMRLFP16PS,
          3378 => Opcode::PTCMMRLFP16PSV,
          3379 => Opcode::PTDPBF16PS,
          3380 => Opcode::PTDPBSSD,
          3381 => Opcode::PTDPBSUD,
          3382 => Opcode::PTDPBUSD,
          3383 => Opcode::PTDPBUUD,
          3384 => Opcode::PTDPFP16PS,
          3385 => Opcode::PTESTrm,
          3386 => Opcode::PTESTrr,
          3387 => Opcode::PTILELOADD,
          3388 => Opcode::PTILELOADDT1,
          3389 => Opcode::PTILESTORED,
          3390 => Opcode::PTILEZERO,
          3391 => Opcode::PTWRITE64m,
          3392 => Opcode::PTWRITE64r,
          3393 => Opcode::PTWRITEm,
          3394 => Opcode::PTWRITEr,
          3395 => Opcode::PUNPCKHBWrm,
          3396 => Opcode::PUNPCKHBWrr,
          3397 => Opcode::PUNPCKHDQrm,
          3398 => Opcode::PUNPCKHDQrr,
          3399 => Opcode::PUNPCKHQDQrm,
          3400 => Opcode::PUNPCKHQDQrr,
          3401 => Opcode::PUNPCKHWDrm,
          3402 => Opcode::PUNPCKHWDrr,
          3403 => Opcode::PUNPCKLBWrm,
          3404 => Opcode::PUNPCKLBWrr,
          3405 => Opcode::PUNPCKLDQrm,
          3406 => Opcode::PUNPCKLDQrr,
          3407 => Opcode::PUNPCKLQDQrm,
          3408 => Opcode::PUNPCKLQDQrr,
          3409 => Opcode::PUNPCKLWDrm,
          3410 => Opcode::PUNPCKLWDrr,
          3411 => Opcode::PUSH16i,
          3412 => Opcode::PUSH16i8,
          3413 => Opcode::PUSH16r,
          3414 => Opcode::PUSH16rmm,
          3415 => Opcode::PUSH16rmr,
          3416 => Opcode::PUSH2,
          3417 => Opcode::PUSH2P,
          3418 => Opcode::PUSH32i,
          3419 => Opcode::PUSH32i8,
          3420 => Opcode::PUSH32r,
          3421 => Opcode::PUSH32rmm,
          3422 => Opcode::PUSH32rmr,
          3423 => Opcode::PUSH64i32,
          3424 => Opcode::PUSH64i8,
          3425 => Opcode::PUSH64r,
          3426 => Opcode::PUSH64rmm,
          3427 => Opcode::PUSH64rmr,
          3428 => Opcode::PUSHA16,
          3429 => Opcode::PUSHA32,
          3430 => Opcode::PUSHCS16,
          3431 => Opcode::PUSHCS32,
          3432 => Opcode::PUSHDS16,
          3433 => Opcode::PUSHDS32,
          3434 => Opcode::PUSHES16,
          3435 => Opcode::PUSHES32,
          3436 => Opcode::PUSHF16,
          3437 => Opcode::PUSHF32,
          3438 => Opcode::PUSHF64,
          3439 => Opcode::PUSHFS16,
          3440 => Opcode::PUSHFS32,
          3441 => Opcode::PUSHFS64,
          3442 => Opcode::PUSHGS16,
          3443 => Opcode::PUSHGS32,
          3444 => Opcode::PUSHGS64,
          3445 => Opcode::PUSHP64r,
          3446 => Opcode::PUSHSS16,
          3447 => Opcode::PUSHSS32,
          3448 => Opcode::PVALIDATE32,
          3449 => Opcode::PVALIDATE64,
          3450 => Opcode::PXORrm,
          3451 => Opcode::PXORrr,
          3452 => Opcode::RCL16m1,
          3453 => Opcode::RCL16m1_EVEX,
          3454 => Opcode::RCL16m1_ND,
          3455 => Opcode::RCL16mCL,
          3456 => Opcode::RCL16mCL_EVEX,
          3457 => Opcode::RCL16mCL_ND,
          3458 => Opcode::RCL16mi,
          3459 => Opcode::RCL16mi_EVEX,
          3460 => Opcode::RCL16mi_ND,
          3461 => Opcode::RCL16r1,
          3462 => Opcode::RCL16r1_EVEX,
          3463 => Opcode::RCL16r1_ND,
          3464 => Opcode::RCL16rCL,
          3465 => Opcode::RCL16rCL_EVEX,
          3466 => Opcode::RCL16rCL_ND,
          3467 => Opcode::RCL16ri,
          3468 => Opcode::RCL16ri_EVEX,
          3469 => Opcode::RCL16ri_ND,
          3470 => Opcode::RCL32m1,
          3471 => Opcode::RCL32m1_EVEX,
          3472 => Opcode::RCL32m1_ND,
          3473 => Opcode::RCL32mCL,
          3474 => Opcode::RCL32mCL_EVEX,
          3475 => Opcode::RCL32mCL_ND,
          3476 => Opcode::RCL32mi,
          3477 => Opcode::RCL32mi_EVEX,
          3478 => Opcode::RCL32mi_ND,
          3479 => Opcode::RCL32r1,
          3480 => Opcode::RCL32r1_EVEX,
          3481 => Opcode::RCL32r1_ND,
          3482 => Opcode::RCL32rCL,
          3483 => Opcode::RCL32rCL_EVEX,
          3484 => Opcode::RCL32rCL_ND,
          3485 => Opcode::RCL32ri,
          3486 => Opcode::RCL32ri_EVEX,
          3487 => Opcode::RCL32ri_ND,
          3488 => Opcode::RCL64m1,
          3489 => Opcode::RCL64m1_EVEX,
          3490 => Opcode::RCL64m1_ND,
          3491 => Opcode::RCL64mCL,
          3492 => Opcode::RCL64mCL_EVEX,
          3493 => Opcode::RCL64mCL_ND,
          3494 => Opcode::RCL64mi,
          3495 => Opcode::RCL64mi_EVEX,
          3496 => Opcode::RCL64mi_ND,
          3497 => Opcode::RCL64r1,
          3498 => Opcode::RCL64r1_EVEX,
          3499 => Opcode::RCL64r1_ND,
          3500 => Opcode::RCL64rCL,
          3501 => Opcode::RCL64rCL_EVEX,
          3502 => Opcode::RCL64rCL_ND,
          3503 => Opcode::RCL64ri,
          3504 => Opcode::RCL64ri_EVEX,
          3505 => Opcode::RCL64ri_ND,
          3506 => Opcode::RCL8m1,
          3507 => Opcode::RCL8m1_EVEX,
          3508 => Opcode::RCL8m1_ND,
          3509 => Opcode::RCL8mCL,
          3510 => Opcode::RCL8mCL_EVEX,
          3511 => Opcode::RCL8mCL_ND,
          3512 => Opcode::RCL8mi,
          3513 => Opcode::RCL8mi_EVEX,
          3514 => Opcode::RCL8mi_ND,
          3515 => Opcode::RCL8r1,
          3516 => Opcode::RCL8r1_EVEX,
          3517 => Opcode::RCL8r1_ND,
          3518 => Opcode::RCL8rCL,
          3519 => Opcode::RCL8rCL_EVEX,
          3520 => Opcode::RCL8rCL_ND,
          3521 => Opcode::RCL8ri,
          3522 => Opcode::RCL8ri_EVEX,
          3523 => Opcode::RCL8ri_ND,
          3524 => Opcode::RCPPSm,
          3525 => Opcode::RCPPSr,
          3526 => Opcode::RCPSSm,
          3527 => Opcode::RCPSSm_Int,
          3528 => Opcode::RCPSSr,
          3529 => Opcode::RCPSSr_Int,
          3530 => Opcode::RCR16m1,
          3531 => Opcode::RCR16m1_EVEX,
          3532 => Opcode::RCR16m1_ND,
          3533 => Opcode::RCR16mCL,
          3534 => Opcode::RCR16mCL_EVEX,
          3535 => Opcode::RCR16mCL_ND,
          3536 => Opcode::RCR16mi,
          3537 => Opcode::RCR16mi_EVEX,
          3538 => Opcode::RCR16mi_ND,
          3539 => Opcode::RCR16r1,
          3540 => Opcode::RCR16r1_EVEX,
          3541 => Opcode::RCR16r1_ND,
          3542 => Opcode::RCR16rCL,
          3543 => Opcode::RCR16rCL_EVEX,
          3544 => Opcode::RCR16rCL_ND,
          3545 => Opcode::RCR16ri,
          3546 => Opcode::RCR16ri_EVEX,
          3547 => Opcode::RCR16ri_ND,
          3548 => Opcode::RCR32m1,
          3549 => Opcode::RCR32m1_EVEX,
          3550 => Opcode::RCR32m1_ND,
          3551 => Opcode::RCR32mCL,
          3552 => Opcode::RCR32mCL_EVEX,
          3553 => Opcode::RCR32mCL_ND,
          3554 => Opcode::RCR32mi,
          3555 => Opcode::RCR32mi_EVEX,
          3556 => Opcode::RCR32mi_ND,
          3557 => Opcode::RCR32r1,
          3558 => Opcode::RCR32r1_EVEX,
          3559 => Opcode::RCR32r1_ND,
          3560 => Opcode::RCR32rCL,
          3561 => Opcode::RCR32rCL_EVEX,
          3562 => Opcode::RCR32rCL_ND,
          3563 => Opcode::RCR32ri,
          3564 => Opcode::RCR32ri_EVEX,
          3565 => Opcode::RCR32ri_ND,
          3566 => Opcode::RCR64m1,
          3567 => Opcode::RCR64m1_EVEX,
          3568 => Opcode::RCR64m1_ND,
          3569 => Opcode::RCR64mCL,
          3570 => Opcode::RCR64mCL_EVEX,
          3571 => Opcode::RCR64mCL_ND,
          3572 => Opcode::RCR64mi,
          3573 => Opcode::RCR64mi_EVEX,
          3574 => Opcode::RCR64mi_ND,
          3575 => Opcode::RCR64r1,
          3576 => Opcode::RCR64r1_EVEX,
          3577 => Opcode::RCR64r1_ND,
          3578 => Opcode::RCR64rCL,
          3579 => Opcode::RCR64rCL_EVEX,
          3580 => Opcode::RCR64rCL_ND,
          3581 => Opcode::RCR64ri,
          3582 => Opcode::RCR64ri_EVEX,
          3583 => Opcode::RCR64ri_ND,
          3584 => Opcode::RCR8m1,
          3585 => Opcode::RCR8m1_EVEX,
          3586 => Opcode::RCR8m1_ND,
          3587 => Opcode::RCR8mCL,
          3588 => Opcode::RCR8mCL_EVEX,
          3589 => Opcode::RCR8mCL_ND,
          3590 => Opcode::RCR8mi,
          3591 => Opcode::RCR8mi_EVEX,
          3592 => Opcode::RCR8mi_ND,
          3593 => Opcode::RCR8r1,
          3594 => Opcode::RCR8r1_EVEX,
          3595 => Opcode::RCR8r1_ND,
          3596 => Opcode::RCR8rCL,
          3597 => Opcode::RCR8rCL_EVEX,
          3598 => Opcode::RCR8rCL_ND,
          3599 => Opcode::RCR8ri,
          3600 => Opcode::RCR8ri_EVEX,
          3601 => Opcode::RCR8ri_ND,
          3602 => Opcode::RDFSBASE,
          3603 => Opcode::RDFSBASE64,
          3604 => Opcode::RDGSBASE,
          3605 => Opcode::RDGSBASE64,
          3606 => Opcode::RDMSR,
          3607 => Opcode::RDMSRLIST,
          3608 => Opcode::RDPID32,
          3609 => Opcode::RDPID64,
          3610 => Opcode::RDPKRUr,
          3611 => Opcode::RDPMC,
          3612 => Opcode::RDPRU,
          3613 => Opcode::RDRAND16r,
          3614 => Opcode::RDRAND32r,
          3615 => Opcode::RDRAND64r,
          3616 => Opcode::RDSEED16r,
          3617 => Opcode::RDSEED32r,
          3618 => Opcode::RDSEED64r,
          3619 => Opcode::RDSSPD,
          3620 => Opcode::RDSSPQ,
          3621 => Opcode::RDTSC,
          3622 => Opcode::RDTSCP,
          3623 => Opcode::REPNE_PREFIX,
          3624 => Opcode::REP_MOVSB_32,
          3625 => Opcode::REP_MOVSB_64,
          3626 => Opcode::REP_MOVSD_32,
          3627 => Opcode::REP_MOVSD_64,
          3628 => Opcode::REP_MOVSQ_32,
          3629 => Opcode::REP_MOVSQ_64,
          3630 => Opcode::REP_MOVSW_32,
          3631 => Opcode::REP_MOVSW_64,
          3632 => Opcode::REP_PREFIX,
          3633 => Opcode::REP_STOSB_32,
          3634 => Opcode::REP_STOSB_64,
          3635 => Opcode::REP_STOSD_32,
          3636 => Opcode::REP_STOSD_64,
          3637 => Opcode::REP_STOSQ_32,
          3638 => Opcode::REP_STOSQ_64,
          3639 => Opcode::REP_STOSW_32,
          3640 => Opcode::REP_STOSW_64,
          3641 => Opcode::RET,
          3642 => Opcode::RET16,
          3643 => Opcode::RET32,
          3644 => Opcode::RET64,
          3645 => Opcode::RETI16,
          3646 => Opcode::RETI32,
          3647 => Opcode::RETI64,
          3648 => Opcode::REX64_PREFIX,
          3649 => Opcode::RMPADJUST,
          3650 => Opcode::RMPQUERY,
          3651 => Opcode::RMPUPDATE,
          3652 => Opcode::ROL16m1,
          3653 => Opcode::ROL16m1_EVEX,
          3654 => Opcode::ROL16m1_ND,
          3655 => Opcode::ROL16m1_NF,
          3656 => Opcode::ROL16m1_NF_ND,
          3657 => Opcode::ROL16mCL,
          3658 => Opcode::ROL16mCL_EVEX,
          3659 => Opcode::ROL16mCL_ND,
          3660 => Opcode::ROL16mCL_NF,
          3661 => Opcode::ROL16mCL_NF_ND,
          3662 => Opcode::ROL16mi,
          3663 => Opcode::ROL16mi_EVEX,
          3664 => Opcode::ROL16mi_ND,
          3665 => Opcode::ROL16mi_NF,
          3666 => Opcode::ROL16mi_NF_ND,
          3667 => Opcode::ROL16r1,
          3668 => Opcode::ROL16r1_EVEX,
          3669 => Opcode::ROL16r1_ND,
          3670 => Opcode::ROL16r1_NF,
          3671 => Opcode::ROL16r1_NF_ND,
          3672 => Opcode::ROL16rCL,
          3673 => Opcode::ROL16rCL_EVEX,
          3674 => Opcode::ROL16rCL_ND,
          3675 => Opcode::ROL16rCL_NF,
          3676 => Opcode::ROL16rCL_NF_ND,
          3677 => Opcode::ROL16ri,
          3678 => Opcode::ROL16ri_EVEX,
          3679 => Opcode::ROL16ri_ND,
          3680 => Opcode::ROL16ri_NF,
          3681 => Opcode::ROL16ri_NF_ND,
          3682 => Opcode::ROL32m1,
          3683 => Opcode::ROL32m1_EVEX,
          3684 => Opcode::ROL32m1_ND,
          3685 => Opcode::ROL32m1_NF,
          3686 => Opcode::ROL32m1_NF_ND,
          3687 => Opcode::ROL32mCL,
          3688 => Opcode::ROL32mCL_EVEX,
          3689 => Opcode::ROL32mCL_ND,
          3690 => Opcode::ROL32mCL_NF,
          3691 => Opcode::ROL32mCL_NF_ND,
          3692 => Opcode::ROL32mi,
          3693 => Opcode::ROL32mi_EVEX,
          3694 => Opcode::ROL32mi_ND,
          3695 => Opcode::ROL32mi_NF,
          3696 => Opcode::ROL32mi_NF_ND,
          3697 => Opcode::ROL32r1,
          3698 => Opcode::ROL32r1_EVEX,
          3699 => Opcode::ROL32r1_ND,
          3700 => Opcode::ROL32r1_NF,
          3701 => Opcode::ROL32r1_NF_ND,
          3702 => Opcode::ROL32rCL,
          3703 => Opcode::ROL32rCL_EVEX,
          3704 => Opcode::ROL32rCL_ND,
          3705 => Opcode::ROL32rCL_NF,
          3706 => Opcode::ROL32rCL_NF_ND,
          3707 => Opcode::ROL32ri,
          3708 => Opcode::ROL32ri_EVEX,
          3709 => Opcode::ROL32ri_ND,
          3710 => Opcode::ROL32ri_NF,
          3711 => Opcode::ROL32ri_NF_ND,
          3712 => Opcode::ROL64m1,
          3713 => Opcode::ROL64m1_EVEX,
          3714 => Opcode::ROL64m1_ND,
          3715 => Opcode::ROL64m1_NF,
          3716 => Opcode::ROL64m1_NF_ND,
          3717 => Opcode::ROL64mCL,
          3718 => Opcode::ROL64mCL_EVEX,
          3719 => Opcode::ROL64mCL_ND,
          3720 => Opcode::ROL64mCL_NF,
          3721 => Opcode::ROL64mCL_NF_ND,
          3722 => Opcode::ROL64mi,
          3723 => Opcode::ROL64mi_EVEX,
          3724 => Opcode::ROL64mi_ND,
          3725 => Opcode::ROL64mi_NF,
          3726 => Opcode::ROL64mi_NF_ND,
          3727 => Opcode::ROL64r1,
          3728 => Opcode::ROL64r1_EVEX,
          3729 => Opcode::ROL64r1_ND,
          3730 => Opcode::ROL64r1_NF,
          3731 => Opcode::ROL64r1_NF_ND,
          3732 => Opcode::ROL64rCL,
          3733 => Opcode::ROL64rCL_EVEX,
          3734 => Opcode::ROL64rCL_ND,
          3735 => Opcode::ROL64rCL_NF,
          3736 => Opcode::ROL64rCL_NF_ND,
          3737 => Opcode::ROL64ri,
          3738 => Opcode::ROL64ri_EVEX,
          3739 => Opcode::ROL64ri_ND,
          3740 => Opcode::ROL64ri_NF,
          3741 => Opcode::ROL64ri_NF_ND,
          3742 => Opcode::ROL8m1,
          3743 => Opcode::ROL8m1_EVEX,
          3744 => Opcode::ROL8m1_ND,
          3745 => Opcode::ROL8m1_NF,
          3746 => Opcode::ROL8m1_NF_ND,
          3747 => Opcode::ROL8mCL,
          3748 => Opcode::ROL8mCL_EVEX,
          3749 => Opcode::ROL8mCL_ND,
          3750 => Opcode::ROL8mCL_NF,
          3751 => Opcode::ROL8mCL_NF_ND,
          3752 => Opcode::ROL8mi,
          3753 => Opcode::ROL8mi_EVEX,
          3754 => Opcode::ROL8mi_ND,
          3755 => Opcode::ROL8mi_NF,
          3756 => Opcode::ROL8mi_NF_ND,
          3757 => Opcode::ROL8r1,
          3758 => Opcode::ROL8r1_EVEX,
          3759 => Opcode::ROL8r1_ND,
          3760 => Opcode::ROL8r1_NF,
          3761 => Opcode::ROL8r1_NF_ND,
          3762 => Opcode::ROL8rCL,
          3763 => Opcode::ROL8rCL_EVEX,
          3764 => Opcode::ROL8rCL_ND,
          3765 => Opcode::ROL8rCL_NF,
          3766 => Opcode::ROL8rCL_NF_ND,
          3767 => Opcode::ROL8ri,
          3768 => Opcode::ROL8ri_EVEX,
          3769 => Opcode::ROL8ri_ND,
          3770 => Opcode::ROL8ri_NF,
          3771 => Opcode::ROL8ri_NF_ND,
          3772 => Opcode::ROR16m1,
          3773 => Opcode::ROR16m1_EVEX,
          3774 => Opcode::ROR16m1_ND,
          3775 => Opcode::ROR16m1_NF,
          3776 => Opcode::ROR16m1_NF_ND,
          3777 => Opcode::ROR16mCL,
          3778 => Opcode::ROR16mCL_EVEX,
          3779 => Opcode::ROR16mCL_ND,
          3780 => Opcode::ROR16mCL_NF,
          3781 => Opcode::ROR16mCL_NF_ND,
          3782 => Opcode::ROR16mi,
          3783 => Opcode::ROR16mi_EVEX,
          3784 => Opcode::ROR16mi_ND,
          3785 => Opcode::ROR16mi_NF,
          3786 => Opcode::ROR16mi_NF_ND,
          3787 => Opcode::ROR16r1,
          3788 => Opcode::ROR16r1_EVEX,
          3789 => Opcode::ROR16r1_ND,
          3790 => Opcode::ROR16r1_NF,
          3791 => Opcode::ROR16r1_NF_ND,
          3792 => Opcode::ROR16rCL,
          3793 => Opcode::ROR16rCL_EVEX,
          3794 => Opcode::ROR16rCL_ND,
          3795 => Opcode::ROR16rCL_NF,
          3796 => Opcode::ROR16rCL_NF_ND,
          3797 => Opcode::ROR16ri,
          3798 => Opcode::ROR16ri_EVEX,
          3799 => Opcode::ROR16ri_ND,
          3800 => Opcode::ROR16ri_NF,
          3801 => Opcode::ROR16ri_NF_ND,
          3802 => Opcode::ROR32m1,
          3803 => Opcode::ROR32m1_EVEX,
          3804 => Opcode::ROR32m1_ND,
          3805 => Opcode::ROR32m1_NF,
          3806 => Opcode::ROR32m1_NF_ND,
          3807 => Opcode::ROR32mCL,
          3808 => Opcode::ROR32mCL_EVEX,
          3809 => Opcode::ROR32mCL_ND,
          3810 => Opcode::ROR32mCL_NF,
          3811 => Opcode::ROR32mCL_NF_ND,
          3812 => Opcode::ROR32mi,
          3813 => Opcode::ROR32mi_EVEX,
          3814 => Opcode::ROR32mi_ND,
          3815 => Opcode::ROR32mi_NF,
          3816 => Opcode::ROR32mi_NF_ND,
          3817 => Opcode::ROR32r1,
          3818 => Opcode::ROR32r1_EVEX,
          3819 => Opcode::ROR32r1_ND,
          3820 => Opcode::ROR32r1_NF,
          3821 => Opcode::ROR32r1_NF_ND,
          3822 => Opcode::ROR32rCL,
          3823 => Opcode::ROR32rCL_EVEX,
          3824 => Opcode::ROR32rCL_ND,
          3825 => Opcode::ROR32rCL_NF,
          3826 => Opcode::ROR32rCL_NF_ND,
          3827 => Opcode::ROR32ri,
          3828 => Opcode::ROR32ri_EVEX,
          3829 => Opcode::ROR32ri_ND,
          3830 => Opcode::ROR32ri_NF,
          3831 => Opcode::ROR32ri_NF_ND,
          3832 => Opcode::ROR64m1,
          3833 => Opcode::ROR64m1_EVEX,
          3834 => Opcode::ROR64m1_ND,
          3835 => Opcode::ROR64m1_NF,
          3836 => Opcode::ROR64m1_NF_ND,
          3837 => Opcode::ROR64mCL,
          3838 => Opcode::ROR64mCL_EVEX,
          3839 => Opcode::ROR64mCL_ND,
          3840 => Opcode::ROR64mCL_NF,
          3841 => Opcode::ROR64mCL_NF_ND,
          3842 => Opcode::ROR64mi,
          3843 => Opcode::ROR64mi_EVEX,
          3844 => Opcode::ROR64mi_ND,
          3845 => Opcode::ROR64mi_NF,
          3846 => Opcode::ROR64mi_NF_ND,
          3847 => Opcode::ROR64r1,
          3848 => Opcode::ROR64r1_EVEX,
          3849 => Opcode::ROR64r1_ND,
          3850 => Opcode::ROR64r1_NF,
          3851 => Opcode::ROR64r1_NF_ND,
          3852 => Opcode::ROR64rCL,
          3853 => Opcode::ROR64rCL_EVEX,
          3854 => Opcode::ROR64rCL_ND,
          3855 => Opcode::ROR64rCL_NF,
          3856 => Opcode::ROR64rCL_NF_ND,
          3857 => Opcode::ROR64ri,
          3858 => Opcode::ROR64ri_EVEX,
          3859 => Opcode::ROR64ri_ND,
          3860 => Opcode::ROR64ri_NF,
          3861 => Opcode::ROR64ri_NF_ND,
          3862 => Opcode::ROR8m1,
          3863 => Opcode::ROR8m1_EVEX,
          3864 => Opcode::ROR8m1_ND,
          3865 => Opcode::ROR8m1_NF,
          3866 => Opcode::ROR8m1_NF_ND,
          3867 => Opcode::ROR8mCL,
          3868 => Opcode::ROR8mCL_EVEX,
          3869 => Opcode::ROR8mCL_ND,
          3870 => Opcode::ROR8mCL_NF,
          3871 => Opcode::ROR8mCL_NF_ND,
          3872 => Opcode::ROR8mi,
          3873 => Opcode::ROR8mi_EVEX,
          3874 => Opcode::ROR8mi_ND,
          3875 => Opcode::ROR8mi_NF,
          3876 => Opcode::ROR8mi_NF_ND,
          3877 => Opcode::ROR8r1,
          3878 => Opcode::ROR8r1_EVEX,
          3879 => Opcode::ROR8r1_ND,
          3880 => Opcode::ROR8r1_NF,
          3881 => Opcode::ROR8r1_NF_ND,
          3882 => Opcode::ROR8rCL,
          3883 => Opcode::ROR8rCL_EVEX,
          3884 => Opcode::ROR8rCL_ND,
          3885 => Opcode::ROR8rCL_NF,
          3886 => Opcode::ROR8rCL_NF_ND,
          3887 => Opcode::ROR8ri,
          3888 => Opcode::ROR8ri_EVEX,
          3889 => Opcode::ROR8ri_ND,
          3890 => Opcode::ROR8ri_NF,
          3891 => Opcode::ROR8ri_NF_ND,
          3892 => Opcode::RORX32mi,
          3893 => Opcode::RORX32mi_EVEX,
          3894 => Opcode::RORX32ri,
          3895 => Opcode::RORX32ri_EVEX,
          3896 => Opcode::RORX64mi,
          3897 => Opcode::RORX64mi_EVEX,
          3898 => Opcode::RORX64ri,
          3899 => Opcode::RORX64ri_EVEX,
          3900 => Opcode::ROUNDPDmi,
          3901 => Opcode::ROUNDPDri,
          3902 => Opcode::ROUNDPSmi,
          3903 => Opcode::ROUNDPSri,
          3904 => Opcode::ROUNDSDmi,
          3905 => Opcode::ROUNDSDmi_Int,
          3906 => Opcode::ROUNDSDri,
          3907 => Opcode::ROUNDSDri_Int,
          3908 => Opcode::ROUNDSSmi,
          3909 => Opcode::ROUNDSSmi_Int,
          3910 => Opcode::ROUNDSSri,
          3911 => Opcode::ROUNDSSri_Int,
          3912 => Opcode::RSM,
          3913 => Opcode::RSQRTPSm,
          3914 => Opcode::RSQRTPSr,
          3915 => Opcode::RSQRTSSm,
          3916 => Opcode::RSQRTSSm_Int,
          3917 => Opcode::RSQRTSSr,
          3918 => Opcode::RSQRTSSr_Int,
          3919 => Opcode::RSTORSSP,
          3920 => Opcode::SAHF,
          3921 => Opcode::SALC,
          3922 => Opcode::SAR16m1,
          3923 => Opcode::SAR16m1_EVEX,
          3924 => Opcode::SAR16m1_ND,
          3925 => Opcode::SAR16m1_NF,
          3926 => Opcode::SAR16m1_NF_ND,
          3927 => Opcode::SAR16mCL,
          3928 => Opcode::SAR16mCL_EVEX,
          3929 => Opcode::SAR16mCL_ND,
          3930 => Opcode::SAR16mCL_NF,
          3931 => Opcode::SAR16mCL_NF_ND,
          3932 => Opcode::SAR16mi,
          3933 => Opcode::SAR16mi_EVEX,
          3934 => Opcode::SAR16mi_ND,
          3935 => Opcode::SAR16mi_NF,
          3936 => Opcode::SAR16mi_NF_ND,
          3937 => Opcode::SAR16r1,
          3938 => Opcode::SAR16r1_EVEX,
          3939 => Opcode::SAR16r1_ND,
          3940 => Opcode::SAR16r1_NF,
          3941 => Opcode::SAR16r1_NF_ND,
          3942 => Opcode::SAR16rCL,
          3943 => Opcode::SAR16rCL_EVEX,
          3944 => Opcode::SAR16rCL_ND,
          3945 => Opcode::SAR16rCL_NF,
          3946 => Opcode::SAR16rCL_NF_ND,
          3947 => Opcode::SAR16ri,
          3948 => Opcode::SAR16ri_EVEX,
          3949 => Opcode::SAR16ri_ND,
          3950 => Opcode::SAR16ri_NF,
          3951 => Opcode::SAR16ri_NF_ND,
          3952 => Opcode::SAR32m1,
          3953 => Opcode::SAR32m1_EVEX,
          3954 => Opcode::SAR32m1_ND,
          3955 => Opcode::SAR32m1_NF,
          3956 => Opcode::SAR32m1_NF_ND,
          3957 => Opcode::SAR32mCL,
          3958 => Opcode::SAR32mCL_EVEX,
          3959 => Opcode::SAR32mCL_ND,
          3960 => Opcode::SAR32mCL_NF,
          3961 => Opcode::SAR32mCL_NF_ND,
          3962 => Opcode::SAR32mi,
          3963 => Opcode::SAR32mi_EVEX,
          3964 => Opcode::SAR32mi_ND,
          3965 => Opcode::SAR32mi_NF,
          3966 => Opcode::SAR32mi_NF_ND,
          3967 => Opcode::SAR32r1,
          3968 => Opcode::SAR32r1_EVEX,
          3969 => Opcode::SAR32r1_ND,
          3970 => Opcode::SAR32r1_NF,
          3971 => Opcode::SAR32r1_NF_ND,
          3972 => Opcode::SAR32rCL,
          3973 => Opcode::SAR32rCL_EVEX,
          3974 => Opcode::SAR32rCL_ND,
          3975 => Opcode::SAR32rCL_NF,
          3976 => Opcode::SAR32rCL_NF_ND,
          3977 => Opcode::SAR32ri,
          3978 => Opcode::SAR32ri_EVEX,
          3979 => Opcode::SAR32ri_ND,
          3980 => Opcode::SAR32ri_NF,
          3981 => Opcode::SAR32ri_NF_ND,
          3982 => Opcode::SAR64m1,
          3983 => Opcode::SAR64m1_EVEX,
          3984 => Opcode::SAR64m1_ND,
          3985 => Opcode::SAR64m1_NF,
          3986 => Opcode::SAR64m1_NF_ND,
          3987 => Opcode::SAR64mCL,
          3988 => Opcode::SAR64mCL_EVEX,
          3989 => Opcode::SAR64mCL_ND,
          3990 => Opcode::SAR64mCL_NF,
          3991 => Opcode::SAR64mCL_NF_ND,
          3992 => Opcode::SAR64mi,
          3993 => Opcode::SAR64mi_EVEX,
          3994 => Opcode::SAR64mi_ND,
          3995 => Opcode::SAR64mi_NF,
          3996 => Opcode::SAR64mi_NF_ND,
          3997 => Opcode::SAR64r1,
          3998 => Opcode::SAR64r1_EVEX,
          3999 => Opcode::SAR64r1_ND,
          4000 => Opcode::SAR64r1_NF,
          4001 => Opcode::SAR64r1_NF_ND,
          4002 => Opcode::SAR64rCL,
          4003 => Opcode::SAR64rCL_EVEX,
          4004 => Opcode::SAR64rCL_ND,
          4005 => Opcode::SAR64rCL_NF,
          4006 => Opcode::SAR64rCL_NF_ND,
          4007 => Opcode::SAR64ri,
          4008 => Opcode::SAR64ri_EVEX,
          4009 => Opcode::SAR64ri_ND,
          4010 => Opcode::SAR64ri_NF,
          4011 => Opcode::SAR64ri_NF_ND,
          4012 => Opcode::SAR8m1,
          4013 => Opcode::SAR8m1_EVEX,
          4014 => Opcode::SAR8m1_ND,
          4015 => Opcode::SAR8m1_NF,
          4016 => Opcode::SAR8m1_NF_ND,
          4017 => Opcode::SAR8mCL,
          4018 => Opcode::SAR8mCL_EVEX,
          4019 => Opcode::SAR8mCL_ND,
          4020 => Opcode::SAR8mCL_NF,
          4021 => Opcode::SAR8mCL_NF_ND,
          4022 => Opcode::SAR8mi,
          4023 => Opcode::SAR8mi_EVEX,
          4024 => Opcode::SAR8mi_ND,
          4025 => Opcode::SAR8mi_NF,
          4026 => Opcode::SAR8mi_NF_ND,
          4027 => Opcode::SAR8r1,
          4028 => Opcode::SAR8r1_EVEX,
          4029 => Opcode::SAR8r1_ND,
          4030 => Opcode::SAR8r1_NF,
          4031 => Opcode::SAR8r1_NF_ND,
          4032 => Opcode::SAR8rCL,
          4033 => Opcode::SAR8rCL_EVEX,
          4034 => Opcode::SAR8rCL_ND,
          4035 => Opcode::SAR8rCL_NF,
          4036 => Opcode::SAR8rCL_NF_ND,
          4037 => Opcode::SAR8ri,
          4038 => Opcode::SAR8ri_EVEX,
          4039 => Opcode::SAR8ri_ND,
          4040 => Opcode::SAR8ri_NF,
          4041 => Opcode::SAR8ri_NF_ND,
          4042 => Opcode::SARX32rm,
          4043 => Opcode::SARX32rm_EVEX,
          4044 => Opcode::SARX32rr,
          4045 => Opcode::SARX32rr_EVEX,
          4046 => Opcode::SARX64rm,
          4047 => Opcode::SARX64rm_EVEX,
          4048 => Opcode::SARX64rr,
          4049 => Opcode::SARX64rr_EVEX,
          4050 => Opcode::SAVEPREVSSP,
          4051 => Opcode::SBB16i16,
          4052 => Opcode::SBB16mi,
          4053 => Opcode::SBB16mi8,
          4054 => Opcode::SBB16mi8_EVEX,
          4055 => Opcode::SBB16mi8_ND,
          4056 => Opcode::SBB16mi_EVEX,
          4057 => Opcode::SBB16mi_ND,
          4058 => Opcode::SBB16mr,
          4059 => Opcode::SBB16mr_EVEX,
          4060 => Opcode::SBB16mr_ND,
          4061 => Opcode::SBB16ri,
          4062 => Opcode::SBB16ri8,
          4063 => Opcode::SBB16ri8_EVEX,
          4064 => Opcode::SBB16ri8_ND,
          4065 => Opcode::SBB16ri_EVEX,
          4066 => Opcode::SBB16ri_ND,
          4067 => Opcode::SBB16rm,
          4068 => Opcode::SBB16rm_EVEX,
          4069 => Opcode::SBB16rm_ND,
          4070 => Opcode::SBB16rr,
          4071 => Opcode::SBB16rr_EVEX,
          4072 => Opcode::SBB16rr_EVEX_REV,
          4073 => Opcode::SBB16rr_ND,
          4074 => Opcode::SBB16rr_ND_REV,
          4075 => Opcode::SBB16rr_REV,
          4076 => Opcode::SBB32i32,
          4077 => Opcode::SBB32mi,
          4078 => Opcode::SBB32mi8,
          4079 => Opcode::SBB32mi8_EVEX,
          4080 => Opcode::SBB32mi8_ND,
          4081 => Opcode::SBB32mi_EVEX,
          4082 => Opcode::SBB32mi_ND,
          4083 => Opcode::SBB32mr,
          4084 => Opcode::SBB32mr_EVEX,
          4085 => Opcode::SBB32mr_ND,
          4086 => Opcode::SBB32ri,
          4087 => Opcode::SBB32ri8,
          4088 => Opcode::SBB32ri8_EVEX,
          4089 => Opcode::SBB32ri8_ND,
          4090 => Opcode::SBB32ri_EVEX,
          4091 => Opcode::SBB32ri_ND,
          4092 => Opcode::SBB32rm,
          4093 => Opcode::SBB32rm_EVEX,
          4094 => Opcode::SBB32rm_ND,
          4095 => Opcode::SBB32rr,
          4096 => Opcode::SBB32rr_EVEX,
          4097 => Opcode::SBB32rr_EVEX_REV,
          4098 => Opcode::SBB32rr_ND,
          4099 => Opcode::SBB32rr_ND_REV,
          4100 => Opcode::SBB32rr_REV,
          4101 => Opcode::SBB64i32,
          4102 => Opcode::SBB64mi32,
          4103 => Opcode::SBB64mi32_EVEX,
          4104 => Opcode::SBB64mi32_ND,
          4105 => Opcode::SBB64mi8,
          4106 => Opcode::SBB64mi8_EVEX,
          4107 => Opcode::SBB64mi8_ND,
          4108 => Opcode::SBB64mr,
          4109 => Opcode::SBB64mr_EVEX,
          4110 => Opcode::SBB64mr_ND,
          4111 => Opcode::SBB64ri32,
          4112 => Opcode::SBB64ri32_EVEX,
          4113 => Opcode::SBB64ri32_ND,
          4114 => Opcode::SBB64ri8,
          4115 => Opcode::SBB64ri8_EVEX,
          4116 => Opcode::SBB64ri8_ND,
          4117 => Opcode::SBB64rm,
          4118 => Opcode::SBB64rm_EVEX,
          4119 => Opcode::SBB64rm_ND,
          4120 => Opcode::SBB64rr,
          4121 => Opcode::SBB64rr_EVEX,
          4122 => Opcode::SBB64rr_EVEX_REV,
          4123 => Opcode::SBB64rr_ND,
          4124 => Opcode::SBB64rr_ND_REV,
          4125 => Opcode::SBB64rr_REV,
          4126 => Opcode::SBB8i8,
          4127 => Opcode::SBB8mi,
          4128 => Opcode::SBB8mi8,
          4129 => Opcode::SBB8mi_EVEX,
          4130 => Opcode::SBB8mi_ND,
          4131 => Opcode::SBB8mr,
          4132 => Opcode::SBB8mr_EVEX,
          4133 => Opcode::SBB8mr_ND,
          4134 => Opcode::SBB8ri,
          4135 => Opcode::SBB8ri8,
          4136 => Opcode::SBB8ri_EVEX,
          4137 => Opcode::SBB8ri_ND,
          4138 => Opcode::SBB8rm,
          4139 => Opcode::SBB8rm_EVEX,
          4140 => Opcode::SBB8rm_ND,
          4141 => Opcode::SBB8rr,
          4142 => Opcode::SBB8rr_EVEX,
          4143 => Opcode::SBB8rr_EVEX_REV,
          4144 => Opcode::SBB8rr_ND,
          4145 => Opcode::SBB8rr_ND_REV,
          4146 => Opcode::SBB8rr_REV,
          4147 => Opcode::SCASB,
          4148 => Opcode::SCASL,
          4149 => Opcode::SCASQ,
          4150 => Opcode::SCASW,
          4151 => Opcode::SEAMCALL,
          4152 => Opcode::SEAMOPS,
          4153 => Opcode::SEAMRET,
          4154 => Opcode::SEG_ALLOCA_32,
          4155 => Opcode::SEG_ALLOCA_64,
          4156 => Opcode::SENDUIPI,
          4157 => Opcode::SERIALIZE,
          4158 => Opcode::SETCCm,
          4159 => Opcode::SETCCm_EVEX,
          4160 => Opcode::SETCCr,
          4161 => Opcode::SETCCr_EVEX,
          4162 => Opcode::SETSSBSY,
          4163 => Opcode::SETZUCCm,
          4164 => Opcode::SETZUCCr,
          4165 => Opcode::SFENCE,
          4166 => Opcode::SGDT16m,
          4167 => Opcode::SGDT32m,
          4168 => Opcode::SGDT64m,
          4169 => Opcode::SHA1MSG1rm,
          4170 => Opcode::SHA1MSG1rr,
          4171 => Opcode::SHA1MSG2rm,
          4172 => Opcode::SHA1MSG2rr,
          4173 => Opcode::SHA1NEXTErm,
          4174 => Opcode::SHA1NEXTErr,
          4175 => Opcode::SHA1RNDS4rmi,
          4176 => Opcode::SHA1RNDS4rri,
          4177 => Opcode::SHA256MSG1rm,
          4178 => Opcode::SHA256MSG1rr,
          4179 => Opcode::SHA256MSG2rm,
          4180 => Opcode::SHA256MSG2rr,
          4181 => Opcode::SHA256RNDS2rm,
          4182 => Opcode::SHA256RNDS2rr,
          4183 => Opcode::SHL16m1,
          4184 => Opcode::SHL16m1_EVEX,
          4185 => Opcode::SHL16m1_ND,
          4186 => Opcode::SHL16m1_NF,
          4187 => Opcode::SHL16m1_NF_ND,
          4188 => Opcode::SHL16mCL,
          4189 => Opcode::SHL16mCL_EVEX,
          4190 => Opcode::SHL16mCL_ND,
          4191 => Opcode::SHL16mCL_NF,
          4192 => Opcode::SHL16mCL_NF_ND,
          4193 => Opcode::SHL16mi,
          4194 => Opcode::SHL16mi_EVEX,
          4195 => Opcode::SHL16mi_ND,
          4196 => Opcode::SHL16mi_NF,
          4197 => Opcode::SHL16mi_NF_ND,
          4198 => Opcode::SHL16r1,
          4199 => Opcode::SHL16r1_EVEX,
          4200 => Opcode::SHL16r1_ND,
          4201 => Opcode::SHL16r1_NF,
          4202 => Opcode::SHL16r1_NF_ND,
          4203 => Opcode::SHL16rCL,
          4204 => Opcode::SHL16rCL_EVEX,
          4205 => Opcode::SHL16rCL_ND,
          4206 => Opcode::SHL16rCL_NF,
          4207 => Opcode::SHL16rCL_NF_ND,
          4208 => Opcode::SHL16ri,
          4209 => Opcode::SHL16ri_EVEX,
          4210 => Opcode::SHL16ri_ND,
          4211 => Opcode::SHL16ri_NF,
          4212 => Opcode::SHL16ri_NF_ND,
          4213 => Opcode::SHL32m1,
          4214 => Opcode::SHL32m1_EVEX,
          4215 => Opcode::SHL32m1_ND,
          4216 => Opcode::SHL32m1_NF,
          4217 => Opcode::SHL32m1_NF_ND,
          4218 => Opcode::SHL32mCL,
          4219 => Opcode::SHL32mCL_EVEX,
          4220 => Opcode::SHL32mCL_ND,
          4221 => Opcode::SHL32mCL_NF,
          4222 => Opcode::SHL32mCL_NF_ND,
          4223 => Opcode::SHL32mi,
          4224 => Opcode::SHL32mi_EVEX,
          4225 => Opcode::SHL32mi_ND,
          4226 => Opcode::SHL32mi_NF,
          4227 => Opcode::SHL32mi_NF_ND,
          4228 => Opcode::SHL32r1,
          4229 => Opcode::SHL32r1_EVEX,
          4230 => Opcode::SHL32r1_ND,
          4231 => Opcode::SHL32r1_NF,
          4232 => Opcode::SHL32r1_NF_ND,
          4233 => Opcode::SHL32rCL,
          4234 => Opcode::SHL32rCL_EVEX,
          4235 => Opcode::SHL32rCL_ND,
          4236 => Opcode::SHL32rCL_NF,
          4237 => Opcode::SHL32rCL_NF_ND,
          4238 => Opcode::SHL32ri,
          4239 => Opcode::SHL32ri_EVEX,
          4240 => Opcode::SHL32ri_ND,
          4241 => Opcode::SHL32ri_NF,
          4242 => Opcode::SHL32ri_NF_ND,
          4243 => Opcode::SHL64m1,
          4244 => Opcode::SHL64m1_EVEX,
          4245 => Opcode::SHL64m1_ND,
          4246 => Opcode::SHL64m1_NF,
          4247 => Opcode::SHL64m1_NF_ND,
          4248 => Opcode::SHL64mCL,
          4249 => Opcode::SHL64mCL_EVEX,
          4250 => Opcode::SHL64mCL_ND,
          4251 => Opcode::SHL64mCL_NF,
          4252 => Opcode::SHL64mCL_NF_ND,
          4253 => Opcode::SHL64mi,
          4254 => Opcode::SHL64mi_EVEX,
          4255 => Opcode::SHL64mi_ND,
          4256 => Opcode::SHL64mi_NF,
          4257 => Opcode::SHL64mi_NF_ND,
          4258 => Opcode::SHL64r1,
          4259 => Opcode::SHL64r1_EVEX,
          4260 => Opcode::SHL64r1_ND,
          4261 => Opcode::SHL64r1_NF,
          4262 => Opcode::SHL64r1_NF_ND,
          4263 => Opcode::SHL64rCL,
          4264 => Opcode::SHL64rCL_EVEX,
          4265 => Opcode::SHL64rCL_ND,
          4266 => Opcode::SHL64rCL_NF,
          4267 => Opcode::SHL64rCL_NF_ND,
          4268 => Opcode::SHL64ri,
          4269 => Opcode::SHL64ri_EVEX,
          4270 => Opcode::SHL64ri_ND,
          4271 => Opcode::SHL64ri_NF,
          4272 => Opcode::SHL64ri_NF_ND,
          4273 => Opcode::SHL8m1,
          4274 => Opcode::SHL8m1_EVEX,
          4275 => Opcode::SHL8m1_ND,
          4276 => Opcode::SHL8m1_NF,
          4277 => Opcode::SHL8m1_NF_ND,
          4278 => Opcode::SHL8mCL,
          4279 => Opcode::SHL8mCL_EVEX,
          4280 => Opcode::SHL8mCL_ND,
          4281 => Opcode::SHL8mCL_NF,
          4282 => Opcode::SHL8mCL_NF_ND,
          4283 => Opcode::SHL8mi,
          4284 => Opcode::SHL8mi_EVEX,
          4285 => Opcode::SHL8mi_ND,
          4286 => Opcode::SHL8mi_NF,
          4287 => Opcode::SHL8mi_NF_ND,
          4288 => Opcode::SHL8r1,
          4289 => Opcode::SHL8r1_EVEX,
          4290 => Opcode::SHL8r1_ND,
          4291 => Opcode::SHL8r1_NF,
          4292 => Opcode::SHL8r1_NF_ND,
          4293 => Opcode::SHL8rCL,
          4294 => Opcode::SHL8rCL_EVEX,
          4295 => Opcode::SHL8rCL_ND,
          4296 => Opcode::SHL8rCL_NF,
          4297 => Opcode::SHL8rCL_NF_ND,
          4298 => Opcode::SHL8ri,
          4299 => Opcode::SHL8ri_EVEX,
          4300 => Opcode::SHL8ri_ND,
          4301 => Opcode::SHL8ri_NF,
          4302 => Opcode::SHL8ri_NF_ND,
          4303 => Opcode::SHLD16mrCL,
          4304 => Opcode::SHLD16mrCL_EVEX,
          4305 => Opcode::SHLD16mrCL_ND,
          4306 => Opcode::SHLD16mrCL_NF,
          4307 => Opcode::SHLD16mrCL_NF_ND,
          4308 => Opcode::SHLD16mri8,
          4309 => Opcode::SHLD16mri8_EVEX,
          4310 => Opcode::SHLD16mri8_ND,
          4311 => Opcode::SHLD16mri8_NF,
          4312 => Opcode::SHLD16mri8_NF_ND,
          4313 => Opcode::SHLD16rrCL,
          4314 => Opcode::SHLD16rrCL_EVEX,
          4315 => Opcode::SHLD16rrCL_ND,
          4316 => Opcode::SHLD16rrCL_NF,
          4317 => Opcode::SHLD16rrCL_NF_ND,
          4318 => Opcode::SHLD16rri8,
          4319 => Opcode::SHLD16rri8_EVEX,
          4320 => Opcode::SHLD16rri8_ND,
          4321 => Opcode::SHLD16rri8_NF,
          4322 => Opcode::SHLD16rri8_NF_ND,
          4323 => Opcode::SHLD32mrCL,
          4324 => Opcode::SHLD32mrCL_EVEX,
          4325 => Opcode::SHLD32mrCL_ND,
          4326 => Opcode::SHLD32mrCL_NF,
          4327 => Opcode::SHLD32mrCL_NF_ND,
          4328 => Opcode::SHLD32mri8,
          4329 => Opcode::SHLD32mri8_EVEX,
          4330 => Opcode::SHLD32mri8_ND,
          4331 => Opcode::SHLD32mri8_NF,
          4332 => Opcode::SHLD32mri8_NF_ND,
          4333 => Opcode::SHLD32rrCL,
          4334 => Opcode::SHLD32rrCL_EVEX,
          4335 => Opcode::SHLD32rrCL_ND,
          4336 => Opcode::SHLD32rrCL_NF,
          4337 => Opcode::SHLD32rrCL_NF_ND,
          4338 => Opcode::SHLD32rri8,
          4339 => Opcode::SHLD32rri8_EVEX,
          4340 => Opcode::SHLD32rri8_ND,
          4341 => Opcode::SHLD32rri8_NF,
          4342 => Opcode::SHLD32rri8_NF_ND,
          4343 => Opcode::SHLD64mrCL,
          4344 => Opcode::SHLD64mrCL_EVEX,
          4345 => Opcode::SHLD64mrCL_ND,
          4346 => Opcode::SHLD64mrCL_NF,
          4347 => Opcode::SHLD64mrCL_NF_ND,
          4348 => Opcode::SHLD64mri8,
          4349 => Opcode::SHLD64mri8_EVEX,
          4350 => Opcode::SHLD64mri8_ND,
          4351 => Opcode::SHLD64mri8_NF,
          4352 => Opcode::SHLD64mri8_NF_ND,
          4353 => Opcode::SHLD64rrCL,
          4354 => Opcode::SHLD64rrCL_EVEX,
          4355 => Opcode::SHLD64rrCL_ND,
          4356 => Opcode::SHLD64rrCL_NF,
          4357 => Opcode::SHLD64rrCL_NF_ND,
          4358 => Opcode::SHLD64rri8,
          4359 => Opcode::SHLD64rri8_EVEX,
          4360 => Opcode::SHLD64rri8_ND,
          4361 => Opcode::SHLD64rri8_NF,
          4362 => Opcode::SHLD64rri8_NF_ND,
          4363 => Opcode::SHLX32rm,
          4364 => Opcode::SHLX32rm_EVEX,
          4365 => Opcode::SHLX32rr,
          4366 => Opcode::SHLX32rr_EVEX,
          4367 => Opcode::SHLX64rm,
          4368 => Opcode::SHLX64rm_EVEX,
          4369 => Opcode::SHLX64rr,
          4370 => Opcode::SHLX64rr_EVEX,
          4371 => Opcode::SHR16m1,
          4372 => Opcode::SHR16m1_EVEX,
          4373 => Opcode::SHR16m1_ND,
          4374 => Opcode::SHR16m1_NF,
          4375 => Opcode::SHR16m1_NF_ND,
          4376 => Opcode::SHR16mCL,
          4377 => Opcode::SHR16mCL_EVEX,
          4378 => Opcode::SHR16mCL_ND,
          4379 => Opcode::SHR16mCL_NF,
          4380 => Opcode::SHR16mCL_NF_ND,
          4381 => Opcode::SHR16mi,
          4382 => Opcode::SHR16mi_EVEX,
          4383 => Opcode::SHR16mi_ND,
          4384 => Opcode::SHR16mi_NF,
          4385 => Opcode::SHR16mi_NF_ND,
          4386 => Opcode::SHR16r1,
          4387 => Opcode::SHR16r1_EVEX,
          4388 => Opcode::SHR16r1_ND,
          4389 => Opcode::SHR16r1_NF,
          4390 => Opcode::SHR16r1_NF_ND,
          4391 => Opcode::SHR16rCL,
          4392 => Opcode::SHR16rCL_EVEX,
          4393 => Opcode::SHR16rCL_ND,
          4394 => Opcode::SHR16rCL_NF,
          4395 => Opcode::SHR16rCL_NF_ND,
          4396 => Opcode::SHR16ri,
          4397 => Opcode::SHR16ri_EVEX,
          4398 => Opcode::SHR16ri_ND,
          4399 => Opcode::SHR16ri_NF,
          4400 => Opcode::SHR16ri_NF_ND,
          4401 => Opcode::SHR32m1,
          4402 => Opcode::SHR32m1_EVEX,
          4403 => Opcode::SHR32m1_ND,
          4404 => Opcode::SHR32m1_NF,
          4405 => Opcode::SHR32m1_NF_ND,
          4406 => Opcode::SHR32mCL,
          4407 => Opcode::SHR32mCL_EVEX,
          4408 => Opcode::SHR32mCL_ND,
          4409 => Opcode::SHR32mCL_NF,
          4410 => Opcode::SHR32mCL_NF_ND,
          4411 => Opcode::SHR32mi,
          4412 => Opcode::SHR32mi_EVEX,
          4413 => Opcode::SHR32mi_ND,
          4414 => Opcode::SHR32mi_NF,
          4415 => Opcode::SHR32mi_NF_ND,
          4416 => Opcode::SHR32r1,
          4417 => Opcode::SHR32r1_EVEX,
          4418 => Opcode::SHR32r1_ND,
          4419 => Opcode::SHR32r1_NF,
          4420 => Opcode::SHR32r1_NF_ND,
          4421 => Opcode::SHR32rCL,
          4422 => Opcode::SHR32rCL_EVEX,
          4423 => Opcode::SHR32rCL_ND,
          4424 => Opcode::SHR32rCL_NF,
          4425 => Opcode::SHR32rCL_NF_ND,
          4426 => Opcode::SHR32ri,
          4427 => Opcode::SHR32ri_EVEX,
          4428 => Opcode::SHR32ri_ND,
          4429 => Opcode::SHR32ri_NF,
          4430 => Opcode::SHR32ri_NF_ND,
          4431 => Opcode::SHR64m1,
          4432 => Opcode::SHR64m1_EVEX,
          4433 => Opcode::SHR64m1_ND,
          4434 => Opcode::SHR64m1_NF,
          4435 => Opcode::SHR64m1_NF_ND,
          4436 => Opcode::SHR64mCL,
          4437 => Opcode::SHR64mCL_EVEX,
          4438 => Opcode::SHR64mCL_ND,
          4439 => Opcode::SHR64mCL_NF,
          4440 => Opcode::SHR64mCL_NF_ND,
          4441 => Opcode::SHR64mi,
          4442 => Opcode::SHR64mi_EVEX,
          4443 => Opcode::SHR64mi_ND,
          4444 => Opcode::SHR64mi_NF,
          4445 => Opcode::SHR64mi_NF_ND,
          4446 => Opcode::SHR64r1,
          4447 => Opcode::SHR64r1_EVEX,
          4448 => Opcode::SHR64r1_ND,
          4449 => Opcode::SHR64r1_NF,
          4450 => Opcode::SHR64r1_NF_ND,
          4451 => Opcode::SHR64rCL,
          4452 => Opcode::SHR64rCL_EVEX,
          4453 => Opcode::SHR64rCL_ND,
          4454 => Opcode::SHR64rCL_NF,
          4455 => Opcode::SHR64rCL_NF_ND,
          4456 => Opcode::SHR64ri,
          4457 => Opcode::SHR64ri_EVEX,
          4458 => Opcode::SHR64ri_ND,
          4459 => Opcode::SHR64ri_NF,
          4460 => Opcode::SHR64ri_NF_ND,
          4461 => Opcode::SHR8m1,
          4462 => Opcode::SHR8m1_EVEX,
          4463 => Opcode::SHR8m1_ND,
          4464 => Opcode::SHR8m1_NF,
          4465 => Opcode::SHR8m1_NF_ND,
          4466 => Opcode::SHR8mCL,
          4467 => Opcode::SHR8mCL_EVEX,
          4468 => Opcode::SHR8mCL_ND,
          4469 => Opcode::SHR8mCL_NF,
          4470 => Opcode::SHR8mCL_NF_ND,
          4471 => Opcode::SHR8mi,
          4472 => Opcode::SHR8mi_EVEX,
          4473 => Opcode::SHR8mi_ND,
          4474 => Opcode::SHR8mi_NF,
          4475 => Opcode::SHR8mi_NF_ND,
          4476 => Opcode::SHR8r1,
          4477 => Opcode::SHR8r1_EVEX,
          4478 => Opcode::SHR8r1_ND,
          4479 => Opcode::SHR8r1_NF,
          4480 => Opcode::SHR8r1_NF_ND,
          4481 => Opcode::SHR8rCL,
          4482 => Opcode::SHR8rCL_EVEX,
          4483 => Opcode::SHR8rCL_ND,
          4484 => Opcode::SHR8rCL_NF,
          4485 => Opcode::SHR8rCL_NF_ND,
          4486 => Opcode::SHR8ri,
          4487 => Opcode::SHR8ri_EVEX,
          4488 => Opcode::SHR8ri_ND,
          4489 => Opcode::SHR8ri_NF,
          4490 => Opcode::SHR8ri_NF_ND,
          4491 => Opcode::SHRD16mrCL,
          4492 => Opcode::SHRD16mrCL_EVEX,
          4493 => Opcode::SHRD16mrCL_ND,
          4494 => Opcode::SHRD16mrCL_NF,
          4495 => Opcode::SHRD16mrCL_NF_ND,
          4496 => Opcode::SHRD16mri8,
          4497 => Opcode::SHRD16mri8_EVEX,
          4498 => Opcode::SHRD16mri8_ND,
          4499 => Opcode::SHRD16mri8_NF,
          4500 => Opcode::SHRD16mri8_NF_ND,
          4501 => Opcode::SHRD16rrCL,
          4502 => Opcode::SHRD16rrCL_EVEX,
          4503 => Opcode::SHRD16rrCL_ND,
          4504 => Opcode::SHRD16rrCL_NF,
          4505 => Opcode::SHRD16rrCL_NF_ND,
          4506 => Opcode::SHRD16rri8,
          4507 => Opcode::SHRD16rri8_EVEX,
          4508 => Opcode::SHRD16rri8_ND,
          4509 => Opcode::SHRD16rri8_NF,
          4510 => Opcode::SHRD16rri8_NF_ND,
          4511 => Opcode::SHRD32mrCL,
          4512 => Opcode::SHRD32mrCL_EVEX,
          4513 => Opcode::SHRD32mrCL_ND,
          4514 => Opcode::SHRD32mrCL_NF,
          4515 => Opcode::SHRD32mrCL_NF_ND,
          4516 => Opcode::SHRD32mri8,
          4517 => Opcode::SHRD32mri8_EVEX,
          4518 => Opcode::SHRD32mri8_ND,
          4519 => Opcode::SHRD32mri8_NF,
          4520 => Opcode::SHRD32mri8_NF_ND,
          4521 => Opcode::SHRD32rrCL,
          4522 => Opcode::SHRD32rrCL_EVEX,
          4523 => Opcode::SHRD32rrCL_ND,
          4524 => Opcode::SHRD32rrCL_NF,
          4525 => Opcode::SHRD32rrCL_NF_ND,
          4526 => Opcode::SHRD32rri8,
          4527 => Opcode::SHRD32rri8_EVEX,
          4528 => Opcode::SHRD32rri8_ND,
          4529 => Opcode::SHRD32rri8_NF,
          4530 => Opcode::SHRD32rri8_NF_ND,
          4531 => Opcode::SHRD64mrCL,
          4532 => Opcode::SHRD64mrCL_EVEX,
          4533 => Opcode::SHRD64mrCL_ND,
          4534 => Opcode::SHRD64mrCL_NF,
          4535 => Opcode::SHRD64mrCL_NF_ND,
          4536 => Opcode::SHRD64mri8,
          4537 => Opcode::SHRD64mri8_EVEX,
          4538 => Opcode::SHRD64mri8_ND,
          4539 => Opcode::SHRD64mri8_NF,
          4540 => Opcode::SHRD64mri8_NF_ND,
          4541 => Opcode::SHRD64rrCL,
          4542 => Opcode::SHRD64rrCL_EVEX,
          4543 => Opcode::SHRD64rrCL_ND,
          4544 => Opcode::SHRD64rrCL_NF,
          4545 => Opcode::SHRD64rrCL_NF_ND,
          4546 => Opcode::SHRD64rri8,
          4547 => Opcode::SHRD64rri8_EVEX,
          4548 => Opcode::SHRD64rri8_ND,
          4549 => Opcode::SHRD64rri8_NF,
          4550 => Opcode::SHRD64rri8_NF_ND,
          4551 => Opcode::SHRX32rm,
          4552 => Opcode::SHRX32rm_EVEX,
          4553 => Opcode::SHRX32rr,
          4554 => Opcode::SHRX32rr_EVEX,
          4555 => Opcode::SHRX64rm,
          4556 => Opcode::SHRX64rm_EVEX,
          4557 => Opcode::SHRX64rr,
          4558 => Opcode::SHRX64rr_EVEX,
          4559 => Opcode::SHUFPDrmi,
          4560 => Opcode::SHUFPDrri,
          4561 => Opcode::SHUFPSrmi,
          4562 => Opcode::SHUFPSrri,
          4563 => Opcode::SIDT16m,
          4564 => Opcode::SIDT32m,
          4565 => Opcode::SIDT64m,
          4566 => Opcode::SKINIT,
          4567 => Opcode::SLDT16m,
          4568 => Opcode::SLDT16r,
          4569 => Opcode::SLDT32r,
          4570 => Opcode::SLDT64r,
          4571 => Opcode::SLWPCB,
          4572 => Opcode::SLWPCB64,
          4573 => Opcode::SMSW16m,
          4574 => Opcode::SMSW16r,
          4575 => Opcode::SMSW32r,
          4576 => Opcode::SMSW64r,
          4577 => Opcode::SQRTPDm,
          4578 => Opcode::SQRTPDr,
          4579 => Opcode::SQRTPSm,
          4580 => Opcode::SQRTPSr,
          4581 => Opcode::SQRTSDm,
          4582 => Opcode::SQRTSDm_Int,
          4583 => Opcode::SQRTSDr,
          4584 => Opcode::SQRTSDr_Int,
          4585 => Opcode::SQRTSSm,
          4586 => Opcode::SQRTSSm_Int,
          4587 => Opcode::SQRTSSr,
          4588 => Opcode::SQRTSSr_Int,
          4589 => Opcode::SQRT_F,
          4590 => Opcode::SQRT_Fp32,
          4591 => Opcode::SQRT_Fp64,
          4592 => Opcode::SQRT_Fp80,
          4593 => Opcode::SS_PREFIX,
          4594 => Opcode::STAC,
          4595 => Opcode::STACKALLOC_W_PROBING,
          4596 => Opcode::STC,
          4597 => Opcode::STD,
          4598 => Opcode::STGI,
          4599 => Opcode::STI,
          4600 => Opcode::STMXCSR,
          4601 => Opcode::STOSB,
          4602 => Opcode::STOSL,
          4603 => Opcode::STOSQ,
          4604 => Opcode::STOSW,
          4605 => Opcode::STR16r,
          4606 => Opcode::STR32r,
          4607 => Opcode::STR64r,
          4608 => Opcode::STRm,
          4609 => Opcode::STTILECFG,
          4610 => Opcode::STTILECFG_EVEX,
          4611 => Opcode::STUI,
          4612 => Opcode::ST_F32m,
          4613 => Opcode::ST_F64m,
          4614 => Opcode::ST_FP32m,
          4615 => Opcode::ST_FP64m,
          4616 => Opcode::ST_FP80m,
          4617 => Opcode::ST_FPrr,
          4618 => Opcode::ST_Fp32m,
          4619 => Opcode::ST_Fp64m,
          4620 => Opcode::ST_Fp64m32,
          4621 => Opcode::ST_Fp80m32,
          4622 => Opcode::ST_Fp80m64,
          4623 => Opcode::ST_FpP32m,
          4624 => Opcode::ST_FpP64m,
          4625 => Opcode::ST_FpP64m32,
          4626 => Opcode::ST_FpP80m,
          4627 => Opcode::ST_FpP80m32,
          4628 => Opcode::ST_FpP80m64,
          4629 => Opcode::ST_Frr,
          4630 => Opcode::SUB16i16,
          4631 => Opcode::SUB16mi,
          4632 => Opcode::SUB16mi8,
          4633 => Opcode::SUB16mi8_EVEX,
          4634 => Opcode::SUB16mi8_ND,
          4635 => Opcode::SUB16mi8_NF,
          4636 => Opcode::SUB16mi8_NF_ND,
          4637 => Opcode::SUB16mi_EVEX,
          4638 => Opcode::SUB16mi_ND,
          4639 => Opcode::SUB16mi_NF,
          4640 => Opcode::SUB16mi_NF_ND,
          4641 => Opcode::SUB16mr,
          4642 => Opcode::SUB16mr_EVEX,
          4643 => Opcode::SUB16mr_ND,
          4644 => Opcode::SUB16mr_NF,
          4645 => Opcode::SUB16mr_NF_ND,
          4646 => Opcode::SUB16ri,
          4647 => Opcode::SUB16ri8,
          4648 => Opcode::SUB16ri8_EVEX,
          4649 => Opcode::SUB16ri8_ND,
          4650 => Opcode::SUB16ri8_NF,
          4651 => Opcode::SUB16ri8_NF_ND,
          4652 => Opcode::SUB16ri_EVEX,
          4653 => Opcode::SUB16ri_ND,
          4654 => Opcode::SUB16ri_NF,
          4655 => Opcode::SUB16ri_NF_ND,
          4656 => Opcode::SUB16rm,
          4657 => Opcode::SUB16rm_EVEX,
          4658 => Opcode::SUB16rm_ND,
          4659 => Opcode::SUB16rm_NF,
          4660 => Opcode::SUB16rm_NF_ND,
          4661 => Opcode::SUB16rr,
          4662 => Opcode::SUB16rr_EVEX,
          4663 => Opcode::SUB16rr_EVEX_REV,
          4664 => Opcode::SUB16rr_ND,
          4665 => Opcode::SUB16rr_ND_REV,
          4666 => Opcode::SUB16rr_NF,
          4667 => Opcode::SUB16rr_NF_ND,
          4668 => Opcode::SUB16rr_NF_ND_REV,
          4669 => Opcode::SUB16rr_NF_REV,
          4670 => Opcode::SUB16rr_REV,
          4671 => Opcode::SUB32i32,
          4672 => Opcode::SUB32mi,
          4673 => Opcode::SUB32mi8,
          4674 => Opcode::SUB32mi8_EVEX,
          4675 => Opcode::SUB32mi8_ND,
          4676 => Opcode::SUB32mi8_NF,
          4677 => Opcode::SUB32mi8_NF_ND,
          4678 => Opcode::SUB32mi_EVEX,
          4679 => Opcode::SUB32mi_ND,
          4680 => Opcode::SUB32mi_NF,
          4681 => Opcode::SUB32mi_NF_ND,
          4682 => Opcode::SUB32mr,
          4683 => Opcode::SUB32mr_EVEX,
          4684 => Opcode::SUB32mr_ND,
          4685 => Opcode::SUB32mr_NF,
          4686 => Opcode::SUB32mr_NF_ND,
          4687 => Opcode::SUB32ri,
          4688 => Opcode::SUB32ri8,
          4689 => Opcode::SUB32ri8_EVEX,
          4690 => Opcode::SUB32ri8_ND,
          4691 => Opcode::SUB32ri8_NF,
          4692 => Opcode::SUB32ri8_NF_ND,
          4693 => Opcode::SUB32ri_EVEX,
          4694 => Opcode::SUB32ri_ND,
          4695 => Opcode::SUB32ri_NF,
          4696 => Opcode::SUB32ri_NF_ND,
          4697 => Opcode::SUB32rm,
          4698 => Opcode::SUB32rm_EVEX,
          4699 => Opcode::SUB32rm_ND,
          4700 => Opcode::SUB32rm_NF,
          4701 => Opcode::SUB32rm_NF_ND,
          4702 => Opcode::SUB32rr,
          4703 => Opcode::SUB32rr_EVEX,
          4704 => Opcode::SUB32rr_EVEX_REV,
          4705 => Opcode::SUB32rr_ND,
          4706 => Opcode::SUB32rr_ND_REV,
          4707 => Opcode::SUB32rr_NF,
          4708 => Opcode::SUB32rr_NF_ND,
          4709 => Opcode::SUB32rr_NF_ND_REV,
          4710 => Opcode::SUB32rr_NF_REV,
          4711 => Opcode::SUB32rr_REV,
          4712 => Opcode::SUB64i32,
          4713 => Opcode::SUB64mi32,
          4714 => Opcode::SUB64mi32_EVEX,
          4715 => Opcode::SUB64mi32_ND,
          4716 => Opcode::SUB64mi32_NF,
          4717 => Opcode::SUB64mi32_NF_ND,
          4718 => Opcode::SUB64mi8,
          4719 => Opcode::SUB64mi8_EVEX,
          4720 => Opcode::SUB64mi8_ND,
          4721 => Opcode::SUB64mi8_NF,
          4722 => Opcode::SUB64mi8_NF_ND,
          4723 => Opcode::SUB64mr,
          4724 => Opcode::SUB64mr_EVEX,
          4725 => Opcode::SUB64mr_ND,
          4726 => Opcode::SUB64mr_NF,
          4727 => Opcode::SUB64mr_NF_ND,
          4728 => Opcode::SUB64ri32,
          4729 => Opcode::SUB64ri32_EVEX,
          4730 => Opcode::SUB64ri32_ND,
          4731 => Opcode::SUB64ri32_NF,
          4732 => Opcode::SUB64ri32_NF_ND,
          4733 => Opcode::SUB64ri8,
          4734 => Opcode::SUB64ri8_EVEX,
          4735 => Opcode::SUB64ri8_ND,
          4736 => Opcode::SUB64ri8_NF,
          4737 => Opcode::SUB64ri8_NF_ND,
          4738 => Opcode::SUB64rm,
          4739 => Opcode::SUB64rm_EVEX,
          4740 => Opcode::SUB64rm_ND,
          4741 => Opcode::SUB64rm_NF,
          4742 => Opcode::SUB64rm_NF_ND,
          4743 => Opcode::SUB64rr,
          4744 => Opcode::SUB64rr_EVEX,
          4745 => Opcode::SUB64rr_EVEX_REV,
          4746 => Opcode::SUB64rr_ND,
          4747 => Opcode::SUB64rr_ND_REV,
          4748 => Opcode::SUB64rr_NF,
          4749 => Opcode::SUB64rr_NF_ND,
          4750 => Opcode::SUB64rr_NF_ND_REV,
          4751 => Opcode::SUB64rr_NF_REV,
          4752 => Opcode::SUB64rr_REV,
          4753 => Opcode::SUB8i8,
          4754 => Opcode::SUB8mi,
          4755 => Opcode::SUB8mi8,
          4756 => Opcode::SUB8mi_EVEX,
          4757 => Opcode::SUB8mi_ND,
          4758 => Opcode::SUB8mi_NF,
          4759 => Opcode::SUB8mi_NF_ND,
          4760 => Opcode::SUB8mr,
          4761 => Opcode::SUB8mr_EVEX,
          4762 => Opcode::SUB8mr_ND,
          4763 => Opcode::SUB8mr_NF,
          4764 => Opcode::SUB8mr_NF_ND,
          4765 => Opcode::SUB8ri,
          4766 => Opcode::SUB8ri8,
          4767 => Opcode::SUB8ri_EVEX,
          4768 => Opcode::SUB8ri_ND,
          4769 => Opcode::SUB8ri_NF,
          4770 => Opcode::SUB8ri_NF_ND,
          4771 => Opcode::SUB8rm,
          4772 => Opcode::SUB8rm_EVEX,
          4773 => Opcode::SUB8rm_ND,
          4774 => Opcode::SUB8rm_NF,
          4775 => Opcode::SUB8rm_NF_ND,
          4776 => Opcode::SUB8rr,
          4777 => Opcode::SUB8rr_EVEX,
          4778 => Opcode::SUB8rr_EVEX_REV,
          4779 => Opcode::SUB8rr_ND,
          4780 => Opcode::SUB8rr_ND_REV,
          4781 => Opcode::SUB8rr_NF,
          4782 => Opcode::SUB8rr_NF_ND,
          4783 => Opcode::SUB8rr_NF_ND_REV,
          4784 => Opcode::SUB8rr_NF_REV,
          4785 => Opcode::SUB8rr_REV,
          4786 => Opcode::SUBPDrm,
          4787 => Opcode::SUBPDrr,
          4788 => Opcode::SUBPSrm,
          4789 => Opcode::SUBPSrr,
          4790 => Opcode::SUBR_F32m,
          4791 => Opcode::SUBR_F64m,
          4792 => Opcode::SUBR_FI16m,
          4793 => Opcode::SUBR_FI32m,
          4794 => Opcode::SUBR_FPrST0,
          4795 => Opcode::SUBR_FST0r,
          4796 => Opcode::SUBR_Fp32m,
          4797 => Opcode::SUBR_Fp64m,
          4798 => Opcode::SUBR_Fp64m32,
          4799 => Opcode::SUBR_Fp80m32,
          4800 => Opcode::SUBR_Fp80m64,
          4801 => Opcode::SUBR_FpI16m32,
          4802 => Opcode::SUBR_FpI16m64,
          4803 => Opcode::SUBR_FpI16m80,
          4804 => Opcode::SUBR_FpI32m32,
          4805 => Opcode::SUBR_FpI32m64,
          4806 => Opcode::SUBR_FpI32m80,
          4807 => Opcode::SUBR_FrST0,
          4808 => Opcode::SUBSDrm,
          4809 => Opcode::SUBSDrm_Int,
          4810 => Opcode::SUBSDrr,
          4811 => Opcode::SUBSDrr_Int,
          4812 => Opcode::SUBSSrm,
          4813 => Opcode::SUBSSrm_Int,
          4814 => Opcode::SUBSSrr,
          4815 => Opcode::SUBSSrr_Int,
          4816 => Opcode::SUB_F32m,
          4817 => Opcode::SUB_F64m,
          4818 => Opcode::SUB_FI16m,
          4819 => Opcode::SUB_FI32m,
          4820 => Opcode::SUB_FPrST0,
          4821 => Opcode::SUB_FST0r,
          4822 => Opcode::SUB_Fp32,
          4823 => Opcode::SUB_Fp32m,
          4824 => Opcode::SUB_Fp64,
          4825 => Opcode::SUB_Fp64m,
          4826 => Opcode::SUB_Fp64m32,
          4827 => Opcode::SUB_Fp80,
          4828 => Opcode::SUB_Fp80m32,
          4829 => Opcode::SUB_Fp80m64,
          4830 => Opcode::SUB_FpI16m32,
          4831 => Opcode::SUB_FpI16m64,
          4832 => Opcode::SUB_FpI16m80,
          4833 => Opcode::SUB_FpI32m32,
          4834 => Opcode::SUB_FpI32m64,
          4835 => Opcode::SUB_FpI32m80,
          4836 => Opcode::SUB_FrST0,
          4837 => Opcode::SWAPGS,
          4838 => Opcode::SYSCALL,
          4839 => Opcode::SYSENTER,
          4840 => Opcode::SYSEXIT,
          4841 => Opcode::SYSEXIT64,
          4842 => Opcode::SYSRET,
          4843 => Opcode::SYSRET64,
          4844 => Opcode::T1MSKC32rm,
          4845 => Opcode::T1MSKC32rr,
          4846 => Opcode::T1MSKC64rm,
          4847 => Opcode::T1MSKC64rr,
          4848 => Opcode::TAILJMPd,
          4849 => Opcode::TAILJMPd64,
          4850 => Opcode::TAILJMPd64_CC,
          4851 => Opcode::TAILJMPd_CC,
          4852 => Opcode::TAILJMPm,
          4853 => Opcode::TAILJMPm64,
          4854 => Opcode::TAILJMPm64_REX,
          4855 => Opcode::TAILJMPr,
          4856 => Opcode::TAILJMPr64,
          4857 => Opcode::TAILJMPr64_REX,
          4858 => Opcode::TCMMIMFP16PS,
          4859 => Opcode::TCMMRLFP16PS,
          4860 => Opcode::TCRETURNdi,
          4861 => Opcode::TCRETURNdi64,
          4862 => Opcode::TCRETURNdi64cc,
          4863 => Opcode::TCRETURNdicc,
          4864 => Opcode::TCRETURNmi,
          4865 => Opcode::TCRETURNmi64,
          4866 => Opcode::TCRETURNri,
          4867 => Opcode::TCRETURNri64,
          4868 => Opcode::TDCALL,
          4869 => Opcode::TDPBF16PS,
          4870 => Opcode::TDPBSSD,
          4871 => Opcode::TDPBSUD,
          4872 => Opcode::TDPBUSD,
          4873 => Opcode::TDPBUUD,
          4874 => Opcode::TDPFP16PS,
          4875 => Opcode::TEST16i16,
          4876 => Opcode::TEST16mi,
          4877 => Opcode::TEST16mr,
          4878 => Opcode::TEST16ri,
          4879 => Opcode::TEST16rr,
          4880 => Opcode::TEST32i32,
          4881 => Opcode::TEST32mi,
          4882 => Opcode::TEST32mr,
          4883 => Opcode::TEST32ri,
          4884 => Opcode::TEST32rr,
          4885 => Opcode::TEST64i32,
          4886 => Opcode::TEST64mi32,
          4887 => Opcode::TEST64mr,
          4888 => Opcode::TEST64ri32,
          4889 => Opcode::TEST64rr,
          4890 => Opcode::TEST8i8,
          4891 => Opcode::TEST8mi,
          4892 => Opcode::TEST8mr,
          4893 => Opcode::TEST8ri,
          4894 => Opcode::TEST8rr,
          4895 => Opcode::TESTUI,
          4896 => Opcode::TILELOADD,
          4897 => Opcode::TILELOADDT1,
          4898 => Opcode::TILELOADDT1_EVEX,
          4899 => Opcode::TILELOADD_EVEX,
          4900 => Opcode::TILERELEASE,
          4901 => Opcode::TILESTORED,
          4902 => Opcode::TILESTORED_EVEX,
          4903 => Opcode::TILEZERO,
          4904 => Opcode::TLBSYNC,
          4905 => Opcode::TLSCall_32,
          4906 => Opcode::TLSCall_64,
          4907 => Opcode::TLS_addr32,
          4908 => Opcode::TLS_addr64,
          4909 => Opcode::TLS_addrX32,
          4910 => Opcode::TLS_base_addr32,
          4911 => Opcode::TLS_base_addr64,
          4912 => Opcode::TLS_base_addrX32,
          4913 => Opcode::TLS_desc32,
          4914 => Opcode::TLS_desc64,
          4915 => Opcode::TPAUSE,
          4916 => Opcode::TRAP,
          4917 => Opcode::TST_F,
          4918 => Opcode::TST_Fp32,
          4919 => Opcode::TST_Fp64,
          4920 => Opcode::TST_Fp80,
          4921 => Opcode::TZCNT16rm,
          4922 => Opcode::TZCNT16rm_EVEX,
          4923 => Opcode::TZCNT16rm_NF,
          4924 => Opcode::TZCNT16rr,
          4925 => Opcode::TZCNT16rr_EVEX,
          4926 => Opcode::TZCNT16rr_NF,
          4927 => Opcode::TZCNT32rm,
          4928 => Opcode::TZCNT32rm_EVEX,
          4929 => Opcode::TZCNT32rm_NF,
          4930 => Opcode::TZCNT32rr,
          4931 => Opcode::TZCNT32rr_EVEX,
          4932 => Opcode::TZCNT32rr_NF,
          4933 => Opcode::TZCNT64rm,
          4934 => Opcode::TZCNT64rm_EVEX,
          4935 => Opcode::TZCNT64rm_NF,
          4936 => Opcode::TZCNT64rr,
          4937 => Opcode::TZCNT64rr_EVEX,
          4938 => Opcode::TZCNT64rr_NF,
          4939 => Opcode::TZMSK32rm,
          4940 => Opcode::TZMSK32rr,
          4941 => Opcode::TZMSK64rm,
          4942 => Opcode::TZMSK64rr,
          4943 => Opcode::UBSAN_UD1,
          4944 => Opcode::UCOMISDrm,
          4945 => Opcode::UCOMISDrm_Int,
          4946 => Opcode::UCOMISDrr,
          4947 => Opcode::UCOMISDrr_Int,
          4948 => Opcode::UCOMISSrm,
          4949 => Opcode::UCOMISSrm_Int,
          4950 => Opcode::UCOMISSrr,
          4951 => Opcode::UCOMISSrr_Int,
          4952 => Opcode::UCOM_FIPr,
          4953 => Opcode::UCOM_FIr,
          4954 => Opcode::UCOM_FPPr,
          4955 => Opcode::UCOM_FPr,
          4956 => Opcode::UCOM_FpIr32,
          4957 => Opcode::UCOM_FpIr64,
          4958 => Opcode::UCOM_FpIr80,
          4959 => Opcode::UCOM_Fpr32,
          4960 => Opcode::UCOM_Fpr64,
          4961 => Opcode::UCOM_Fpr80,
          4962 => Opcode::UCOM_Fr,
          4963 => Opcode::UD1Lm,
          4964 => Opcode::UD1Lr,
          4965 => Opcode::UD1Qm,
          4966 => Opcode::UD1Qr,
          4967 => Opcode::UD1Wm,
          4968 => Opcode::UD1Wr,
          4969 => Opcode::UIRET,
          4970 => Opcode::UMONITOR16,
          4971 => Opcode::UMONITOR32,
          4972 => Opcode::UMONITOR64,
          4973 => Opcode::UMWAIT,
          4974 => Opcode::UNPCKHPDrm,
          4975 => Opcode::UNPCKHPDrr,
          4976 => Opcode::UNPCKHPSrm,
          4977 => Opcode::UNPCKHPSrr,
          4978 => Opcode::UNPCKLPDrm,
          4979 => Opcode::UNPCKLPDrr,
          4980 => Opcode::UNPCKLPSrm,
          4981 => Opcode::UNPCKLPSrr,
          4982 => Opcode::URDMSRri,
          4983 => Opcode::URDMSRri_EVEX,
          4984 => Opcode::URDMSRrr,
          4985 => Opcode::URDMSRrr_EVEX,
          4986 => Opcode::UWRMSRir,
          4987 => Opcode::UWRMSRir_EVEX,
          4988 => Opcode::UWRMSRrr,
          4989 => Opcode::UWRMSRrr_EVEX,
          4990 => Opcode::V4FMADDPSrm,
          4991 => Opcode::V4FMADDPSrmk,
          4992 => Opcode::V4FMADDPSrmkz,
          4993 => Opcode::V4FMADDSSrm,
          4994 => Opcode::V4FMADDSSrmk,
          4995 => Opcode::V4FMADDSSrmkz,
          4996 => Opcode::V4FNMADDPSrm,
          4997 => Opcode::V4FNMADDPSrmk,
          4998 => Opcode::V4FNMADDPSrmkz,
          4999 => Opcode::V4FNMADDSSrm,
          5000 => Opcode::V4FNMADDSSrmk,
          5001 => Opcode::V4FNMADDSSrmkz,
          5002 => Opcode::VAARG_64,
          5003 => Opcode::VAARG_X32,
          5004 => Opcode::VADDPDYrm,
          5005 => Opcode::VADDPDYrr,
          5006 => Opcode::VADDPDZ128rm,
          5007 => Opcode::VADDPDZ128rmb,
          5008 => Opcode::VADDPDZ128rmbk,
          5009 => Opcode::VADDPDZ128rmbkz,
          5010 => Opcode::VADDPDZ128rmk,
          5011 => Opcode::VADDPDZ128rmkz,
          5012 => Opcode::VADDPDZ128rr,
          5013 => Opcode::VADDPDZ128rrk,
          5014 => Opcode::VADDPDZ128rrkz,
          5015 => Opcode::VADDPDZ256rm,
          5016 => Opcode::VADDPDZ256rmb,
          5017 => Opcode::VADDPDZ256rmbk,
          5018 => Opcode::VADDPDZ256rmbkz,
          5019 => Opcode::VADDPDZ256rmk,
          5020 => Opcode::VADDPDZ256rmkz,
          5021 => Opcode::VADDPDZ256rr,
          5022 => Opcode::VADDPDZ256rrk,
          5023 => Opcode::VADDPDZ256rrkz,
          5024 => Opcode::VADDPDZrm,
          5025 => Opcode::VADDPDZrmb,
          5026 => Opcode::VADDPDZrmbk,
          5027 => Opcode::VADDPDZrmbkz,
          5028 => Opcode::VADDPDZrmk,
          5029 => Opcode::VADDPDZrmkz,
          5030 => Opcode::VADDPDZrr,
          5031 => Opcode::VADDPDZrrb,
          5032 => Opcode::VADDPDZrrbk,
          5033 => Opcode::VADDPDZrrbkz,
          5034 => Opcode::VADDPDZrrk,
          5035 => Opcode::VADDPDZrrkz,
          5036 => Opcode::VADDPDrm,
          5037 => Opcode::VADDPDrr,
          5038 => Opcode::VADDPHZ128rm,
          5039 => Opcode::VADDPHZ128rmb,
          5040 => Opcode::VADDPHZ128rmbk,
          5041 => Opcode::VADDPHZ128rmbkz,
          5042 => Opcode::VADDPHZ128rmk,
          5043 => Opcode::VADDPHZ128rmkz,
          5044 => Opcode::VADDPHZ128rr,
          5045 => Opcode::VADDPHZ128rrk,
          5046 => Opcode::VADDPHZ128rrkz,
          5047 => Opcode::VADDPHZ256rm,
          5048 => Opcode::VADDPHZ256rmb,
          5049 => Opcode::VADDPHZ256rmbk,
          5050 => Opcode::VADDPHZ256rmbkz,
          5051 => Opcode::VADDPHZ256rmk,
          5052 => Opcode::VADDPHZ256rmkz,
          5053 => Opcode::VADDPHZ256rr,
          5054 => Opcode::VADDPHZ256rrk,
          5055 => Opcode::VADDPHZ256rrkz,
          5056 => Opcode::VADDPHZrm,
          5057 => Opcode::VADDPHZrmb,
          5058 => Opcode::VADDPHZrmbk,
          5059 => Opcode::VADDPHZrmbkz,
          5060 => Opcode::VADDPHZrmk,
          5061 => Opcode::VADDPHZrmkz,
          5062 => Opcode::VADDPHZrr,
          5063 => Opcode::VADDPHZrrb,
          5064 => Opcode::VADDPHZrrbk,
          5065 => Opcode::VADDPHZrrbkz,
          5066 => Opcode::VADDPHZrrk,
          5067 => Opcode::VADDPHZrrkz,
          5068 => Opcode::VADDPSYrm,
          5069 => Opcode::VADDPSYrr,
          5070 => Opcode::VADDPSZ128rm,
          5071 => Opcode::VADDPSZ128rmb,
          5072 => Opcode::VADDPSZ128rmbk,
          5073 => Opcode::VADDPSZ128rmbkz,
          5074 => Opcode::VADDPSZ128rmk,
          5075 => Opcode::VADDPSZ128rmkz,
          5076 => Opcode::VADDPSZ128rr,
          5077 => Opcode::VADDPSZ128rrk,
          5078 => Opcode::VADDPSZ128rrkz,
          5079 => Opcode::VADDPSZ256rm,
          5080 => Opcode::VADDPSZ256rmb,
          5081 => Opcode::VADDPSZ256rmbk,
          5082 => Opcode::VADDPSZ256rmbkz,
          5083 => Opcode::VADDPSZ256rmk,
          5084 => Opcode::VADDPSZ256rmkz,
          5085 => Opcode::VADDPSZ256rr,
          5086 => Opcode::VADDPSZ256rrk,
          5087 => Opcode::VADDPSZ256rrkz,
          5088 => Opcode::VADDPSZrm,
          5089 => Opcode::VADDPSZrmb,
          5090 => Opcode::VADDPSZrmbk,
          5091 => Opcode::VADDPSZrmbkz,
          5092 => Opcode::VADDPSZrmk,
          5093 => Opcode::VADDPSZrmkz,
          5094 => Opcode::VADDPSZrr,
          5095 => Opcode::VADDPSZrrb,
          5096 => Opcode::VADDPSZrrbk,
          5097 => Opcode::VADDPSZrrbkz,
          5098 => Opcode::VADDPSZrrk,
          5099 => Opcode::VADDPSZrrkz,
          5100 => Opcode::VADDPSrm,
          5101 => Opcode::VADDPSrr,
          5102 => Opcode::VADDSDZrm,
          5103 => Opcode::VADDSDZrm_Int,
          5104 => Opcode::VADDSDZrm_Intk,
          5105 => Opcode::VADDSDZrm_Intkz,
          5106 => Opcode::VADDSDZrr,
          5107 => Opcode::VADDSDZrr_Int,
          5108 => Opcode::VADDSDZrr_Intk,
          5109 => Opcode::VADDSDZrr_Intkz,
          5110 => Opcode::VADDSDZrrb_Int,
          5111 => Opcode::VADDSDZrrb_Intk,
          5112 => Opcode::VADDSDZrrb_Intkz,
          5113 => Opcode::VADDSDrm,
          5114 => Opcode::VADDSDrm_Int,
          5115 => Opcode::VADDSDrr,
          5116 => Opcode::VADDSDrr_Int,
          5117 => Opcode::VADDSHZrm,
          5118 => Opcode::VADDSHZrm_Int,
          5119 => Opcode::VADDSHZrm_Intk,
          5120 => Opcode::VADDSHZrm_Intkz,
          5121 => Opcode::VADDSHZrr,
          5122 => Opcode::VADDSHZrr_Int,
          5123 => Opcode::VADDSHZrr_Intk,
          5124 => Opcode::VADDSHZrr_Intkz,
          5125 => Opcode::VADDSHZrrb_Int,
          5126 => Opcode::VADDSHZrrb_Intk,
          5127 => Opcode::VADDSHZrrb_Intkz,
          5128 => Opcode::VADDSSZrm,
          5129 => Opcode::VADDSSZrm_Int,
          5130 => Opcode::VADDSSZrm_Intk,
          5131 => Opcode::VADDSSZrm_Intkz,
          5132 => Opcode::VADDSSZrr,
          5133 => Opcode::VADDSSZrr_Int,
          5134 => Opcode::VADDSSZrr_Intk,
          5135 => Opcode::VADDSSZrr_Intkz,
          5136 => Opcode::VADDSSZrrb_Int,
          5137 => Opcode::VADDSSZrrb_Intk,
          5138 => Opcode::VADDSSZrrb_Intkz,
          5139 => Opcode::VADDSSrm,
          5140 => Opcode::VADDSSrm_Int,
          5141 => Opcode::VADDSSrr,
          5142 => Opcode::VADDSSrr_Int,
          5143 => Opcode::VADDSUBPDYrm,
          5144 => Opcode::VADDSUBPDYrr,
          5145 => Opcode::VADDSUBPDrm,
          5146 => Opcode::VADDSUBPDrr,
          5147 => Opcode::VADDSUBPSYrm,
          5148 => Opcode::VADDSUBPSYrr,
          5149 => Opcode::VADDSUBPSrm,
          5150 => Opcode::VADDSUBPSrr,
          5151 => Opcode::VAESDECLASTYrm,
          5152 => Opcode::VAESDECLASTYrr,
          5153 => Opcode::VAESDECLASTZ128rm,
          5154 => Opcode::VAESDECLASTZ128rr,
          5155 => Opcode::VAESDECLASTZ256rm,
          5156 => Opcode::VAESDECLASTZ256rr,
          5157 => Opcode::VAESDECLASTZrm,
          5158 => Opcode::VAESDECLASTZrr,
          5159 => Opcode::VAESDECLASTrm,
          5160 => Opcode::VAESDECLASTrr,
          5161 => Opcode::VAESDECYrm,
          5162 => Opcode::VAESDECYrr,
          5163 => Opcode::VAESDECZ128rm,
          5164 => Opcode::VAESDECZ128rr,
          5165 => Opcode::VAESDECZ256rm,
          5166 => Opcode::VAESDECZ256rr,
          5167 => Opcode::VAESDECZrm,
          5168 => Opcode::VAESDECZrr,
          5169 => Opcode::VAESDECrm,
          5170 => Opcode::VAESDECrr,
          5171 => Opcode::VAESENCLASTYrm,
          5172 => Opcode::VAESENCLASTYrr,
          5173 => Opcode::VAESENCLASTZ128rm,
          5174 => Opcode::VAESENCLASTZ128rr,
          5175 => Opcode::VAESENCLASTZ256rm,
          5176 => Opcode::VAESENCLASTZ256rr,
          5177 => Opcode::VAESENCLASTZrm,
          5178 => Opcode::VAESENCLASTZrr,
          5179 => Opcode::VAESENCLASTrm,
          5180 => Opcode::VAESENCLASTrr,
          5181 => Opcode::VAESENCYrm,
          5182 => Opcode::VAESENCYrr,
          5183 => Opcode::VAESENCZ128rm,
          5184 => Opcode::VAESENCZ128rr,
          5185 => Opcode::VAESENCZ256rm,
          5186 => Opcode::VAESENCZ256rr,
          5187 => Opcode::VAESENCZrm,
          5188 => Opcode::VAESENCZrr,
          5189 => Opcode::VAESENCrm,
          5190 => Opcode::VAESENCrr,
          5191 => Opcode::VAESIMCrm,
          5192 => Opcode::VAESIMCrr,
          5193 => Opcode::VAESKEYGENASSIST128rm,
          5194 => Opcode::VAESKEYGENASSIST128rr,
          5195 => Opcode::VALIGNDZ128rmbi,
          5196 => Opcode::VALIGNDZ128rmbik,
          5197 => Opcode::VALIGNDZ128rmbikz,
          5198 => Opcode::VALIGNDZ128rmi,
          5199 => Opcode::VALIGNDZ128rmik,
          5200 => Opcode::VALIGNDZ128rmikz,
          5201 => Opcode::VALIGNDZ128rri,
          5202 => Opcode::VALIGNDZ128rrik,
          5203 => Opcode::VALIGNDZ128rrikz,
          5204 => Opcode::VALIGNDZ256rmbi,
          5205 => Opcode::VALIGNDZ256rmbik,
          5206 => Opcode::VALIGNDZ256rmbikz,
          5207 => Opcode::VALIGNDZ256rmi,
          5208 => Opcode::VALIGNDZ256rmik,
          5209 => Opcode::VALIGNDZ256rmikz,
          5210 => Opcode::VALIGNDZ256rri,
          5211 => Opcode::VALIGNDZ256rrik,
          5212 => Opcode::VALIGNDZ256rrikz,
          5213 => Opcode::VALIGNDZrmbi,
          5214 => Opcode::VALIGNDZrmbik,
          5215 => Opcode::VALIGNDZrmbikz,
          5216 => Opcode::VALIGNDZrmi,
          5217 => Opcode::VALIGNDZrmik,
          5218 => Opcode::VALIGNDZrmikz,
          5219 => Opcode::VALIGNDZrri,
          5220 => Opcode::VALIGNDZrrik,
          5221 => Opcode::VALIGNDZrrikz,
          5222 => Opcode::VALIGNQZ128rmbi,
          5223 => Opcode::VALIGNQZ128rmbik,
          5224 => Opcode::VALIGNQZ128rmbikz,
          5225 => Opcode::VALIGNQZ128rmi,
          5226 => Opcode::VALIGNQZ128rmik,
          5227 => Opcode::VALIGNQZ128rmikz,
          5228 => Opcode::VALIGNQZ128rri,
          5229 => Opcode::VALIGNQZ128rrik,
          5230 => Opcode::VALIGNQZ128rrikz,
          5231 => Opcode::VALIGNQZ256rmbi,
          5232 => Opcode::VALIGNQZ256rmbik,
          5233 => Opcode::VALIGNQZ256rmbikz,
          5234 => Opcode::VALIGNQZ256rmi,
          5235 => Opcode::VALIGNQZ256rmik,
          5236 => Opcode::VALIGNQZ256rmikz,
          5237 => Opcode::VALIGNQZ256rri,
          5238 => Opcode::VALIGNQZ256rrik,
          5239 => Opcode::VALIGNQZ256rrikz,
          5240 => Opcode::VALIGNQZrmbi,
          5241 => Opcode::VALIGNQZrmbik,
          5242 => Opcode::VALIGNQZrmbikz,
          5243 => Opcode::VALIGNQZrmi,
          5244 => Opcode::VALIGNQZrmik,
          5245 => Opcode::VALIGNQZrmikz,
          5246 => Opcode::VALIGNQZrri,
          5247 => Opcode::VALIGNQZrrik,
          5248 => Opcode::VALIGNQZrrikz,
          5249 => Opcode::VANDNPDYrm,
          5250 => Opcode::VANDNPDYrr,
          5251 => Opcode::VANDNPDZ128rm,
          5252 => Opcode::VANDNPDZ128rmb,
          5253 => Opcode::VANDNPDZ128rmbk,
          5254 => Opcode::VANDNPDZ128rmbkz,
          5255 => Opcode::VANDNPDZ128rmk,
          5256 => Opcode::VANDNPDZ128rmkz,
          5257 => Opcode::VANDNPDZ128rr,
          5258 => Opcode::VANDNPDZ128rrk,
          5259 => Opcode::VANDNPDZ128rrkz,
          5260 => Opcode::VANDNPDZ256rm,
          5261 => Opcode::VANDNPDZ256rmb,
          5262 => Opcode::VANDNPDZ256rmbk,
          5263 => Opcode::VANDNPDZ256rmbkz,
          5264 => Opcode::VANDNPDZ256rmk,
          5265 => Opcode::VANDNPDZ256rmkz,
          5266 => Opcode::VANDNPDZ256rr,
          5267 => Opcode::VANDNPDZ256rrk,
          5268 => Opcode::VANDNPDZ256rrkz,
          5269 => Opcode::VANDNPDZrm,
          5270 => Opcode::VANDNPDZrmb,
          5271 => Opcode::VANDNPDZrmbk,
          5272 => Opcode::VANDNPDZrmbkz,
          5273 => Opcode::VANDNPDZrmk,
          5274 => Opcode::VANDNPDZrmkz,
          5275 => Opcode::VANDNPDZrr,
          5276 => Opcode::VANDNPDZrrk,
          5277 => Opcode::VANDNPDZrrkz,
          5278 => Opcode::VANDNPDrm,
          5279 => Opcode::VANDNPDrr,
          5280 => Opcode::VANDNPSYrm,
          5281 => Opcode::VANDNPSYrr,
          5282 => Opcode::VANDNPSZ128rm,
          5283 => Opcode::VANDNPSZ128rmb,
          5284 => Opcode::VANDNPSZ128rmbk,
          5285 => Opcode::VANDNPSZ128rmbkz,
          5286 => Opcode::VANDNPSZ128rmk,
          5287 => Opcode::VANDNPSZ128rmkz,
          5288 => Opcode::VANDNPSZ128rr,
          5289 => Opcode::VANDNPSZ128rrk,
          5290 => Opcode::VANDNPSZ128rrkz,
          5291 => Opcode::VANDNPSZ256rm,
          5292 => Opcode::VANDNPSZ256rmb,
          5293 => Opcode::VANDNPSZ256rmbk,
          5294 => Opcode::VANDNPSZ256rmbkz,
          5295 => Opcode::VANDNPSZ256rmk,
          5296 => Opcode::VANDNPSZ256rmkz,
          5297 => Opcode::VANDNPSZ256rr,
          5298 => Opcode::VANDNPSZ256rrk,
          5299 => Opcode::VANDNPSZ256rrkz,
          5300 => Opcode::VANDNPSZrm,
          5301 => Opcode::VANDNPSZrmb,
          5302 => Opcode::VANDNPSZrmbk,
          5303 => Opcode::VANDNPSZrmbkz,
          5304 => Opcode::VANDNPSZrmk,
          5305 => Opcode::VANDNPSZrmkz,
          5306 => Opcode::VANDNPSZrr,
          5307 => Opcode::VANDNPSZrrk,
          5308 => Opcode::VANDNPSZrrkz,
          5309 => Opcode::VANDNPSrm,
          5310 => Opcode::VANDNPSrr,
          5311 => Opcode::VANDPDYrm,
          5312 => Opcode::VANDPDYrr,
          5313 => Opcode::VANDPDZ128rm,
          5314 => Opcode::VANDPDZ128rmb,
          5315 => Opcode::VANDPDZ128rmbk,
          5316 => Opcode::VANDPDZ128rmbkz,
          5317 => Opcode::VANDPDZ128rmk,
          5318 => Opcode::VANDPDZ128rmkz,
          5319 => Opcode::VANDPDZ128rr,
          5320 => Opcode::VANDPDZ128rrk,
          5321 => Opcode::VANDPDZ128rrkz,
          5322 => Opcode::VANDPDZ256rm,
          5323 => Opcode::VANDPDZ256rmb,
          5324 => Opcode::VANDPDZ256rmbk,
          5325 => Opcode::VANDPDZ256rmbkz,
          5326 => Opcode::VANDPDZ256rmk,
          5327 => Opcode::VANDPDZ256rmkz,
          5328 => Opcode::VANDPDZ256rr,
          5329 => Opcode::VANDPDZ256rrk,
          5330 => Opcode::VANDPDZ256rrkz,
          5331 => Opcode::VANDPDZrm,
          5332 => Opcode::VANDPDZrmb,
          5333 => Opcode::VANDPDZrmbk,
          5334 => Opcode::VANDPDZrmbkz,
          5335 => Opcode::VANDPDZrmk,
          5336 => Opcode::VANDPDZrmkz,
          5337 => Opcode::VANDPDZrr,
          5338 => Opcode::VANDPDZrrk,
          5339 => Opcode::VANDPDZrrkz,
          5340 => Opcode::VANDPDrm,
          5341 => Opcode::VANDPDrr,
          5342 => Opcode::VANDPSYrm,
          5343 => Opcode::VANDPSYrr,
          5344 => Opcode::VANDPSZ128rm,
          5345 => Opcode::VANDPSZ128rmb,
          5346 => Opcode::VANDPSZ128rmbk,
          5347 => Opcode::VANDPSZ128rmbkz,
          5348 => Opcode::VANDPSZ128rmk,
          5349 => Opcode::VANDPSZ128rmkz,
          5350 => Opcode::VANDPSZ128rr,
          5351 => Opcode::VANDPSZ128rrk,
          5352 => Opcode::VANDPSZ128rrkz,
          5353 => Opcode::VANDPSZ256rm,
          5354 => Opcode::VANDPSZ256rmb,
          5355 => Opcode::VANDPSZ256rmbk,
          5356 => Opcode::VANDPSZ256rmbkz,
          5357 => Opcode::VANDPSZ256rmk,
          5358 => Opcode::VANDPSZ256rmkz,
          5359 => Opcode::VANDPSZ256rr,
          5360 => Opcode::VANDPSZ256rrk,
          5361 => Opcode::VANDPSZ256rrkz,
          5362 => Opcode::VANDPSZrm,
          5363 => Opcode::VANDPSZrmb,
          5364 => Opcode::VANDPSZrmbk,
          5365 => Opcode::VANDPSZrmbkz,
          5366 => Opcode::VANDPSZrmk,
          5367 => Opcode::VANDPSZrmkz,
          5368 => Opcode::VANDPSZrr,
          5369 => Opcode::VANDPSZrrk,
          5370 => Opcode::VANDPSZrrkz,
          5371 => Opcode::VANDPSrm,
          5372 => Opcode::VANDPSrr,
          5373 => Opcode::VASTART_SAVE_XMM_REGS,
          5374 => Opcode::VBCSTNEBF162PSYrm,
          5375 => Opcode::VBCSTNEBF162PSrm,
          5376 => Opcode::VBCSTNESH2PSYrm,
          5377 => Opcode::VBCSTNESH2PSrm,
          5378 => Opcode::VBLENDMPDZ128rm,
          5379 => Opcode::VBLENDMPDZ128rmb,
          5380 => Opcode::VBLENDMPDZ128rmbk,
          5381 => Opcode::VBLENDMPDZ128rmbkz,
          5382 => Opcode::VBLENDMPDZ128rmk,
          5383 => Opcode::VBLENDMPDZ128rmkz,
          5384 => Opcode::VBLENDMPDZ128rr,
          5385 => Opcode::VBLENDMPDZ128rrk,
          5386 => Opcode::VBLENDMPDZ128rrkz,
          5387 => Opcode::VBLENDMPDZ256rm,
          5388 => Opcode::VBLENDMPDZ256rmb,
          5389 => Opcode::VBLENDMPDZ256rmbk,
          5390 => Opcode::VBLENDMPDZ256rmbkz,
          5391 => Opcode::VBLENDMPDZ256rmk,
          5392 => Opcode::VBLENDMPDZ256rmkz,
          5393 => Opcode::VBLENDMPDZ256rr,
          5394 => Opcode::VBLENDMPDZ256rrk,
          5395 => Opcode::VBLENDMPDZ256rrkz,
          5396 => Opcode::VBLENDMPDZrm,
          5397 => Opcode::VBLENDMPDZrmb,
          5398 => Opcode::VBLENDMPDZrmbk,
          5399 => Opcode::VBLENDMPDZrmbkz,
          5400 => Opcode::VBLENDMPDZrmk,
          5401 => Opcode::VBLENDMPDZrmkz,
          5402 => Opcode::VBLENDMPDZrr,
          5403 => Opcode::VBLENDMPDZrrk,
          5404 => Opcode::VBLENDMPDZrrkz,
          5405 => Opcode::VBLENDMPSZ128rm,
          5406 => Opcode::VBLENDMPSZ128rmb,
          5407 => Opcode::VBLENDMPSZ128rmbk,
          5408 => Opcode::VBLENDMPSZ128rmbkz,
          5409 => Opcode::VBLENDMPSZ128rmk,
          5410 => Opcode::VBLENDMPSZ128rmkz,
          5411 => Opcode::VBLENDMPSZ128rr,
          5412 => Opcode::VBLENDMPSZ128rrk,
          5413 => Opcode::VBLENDMPSZ128rrkz,
          5414 => Opcode::VBLENDMPSZ256rm,
          5415 => Opcode::VBLENDMPSZ256rmb,
          5416 => Opcode::VBLENDMPSZ256rmbk,
          5417 => Opcode::VBLENDMPSZ256rmbkz,
          5418 => Opcode::VBLENDMPSZ256rmk,
          5419 => Opcode::VBLENDMPSZ256rmkz,
          5420 => Opcode::VBLENDMPSZ256rr,
          5421 => Opcode::VBLENDMPSZ256rrk,
          5422 => Opcode::VBLENDMPSZ256rrkz,
          5423 => Opcode::VBLENDMPSZrm,
          5424 => Opcode::VBLENDMPSZrmb,
          5425 => Opcode::VBLENDMPSZrmbk,
          5426 => Opcode::VBLENDMPSZrmbkz,
          5427 => Opcode::VBLENDMPSZrmk,
          5428 => Opcode::VBLENDMPSZrmkz,
          5429 => Opcode::VBLENDMPSZrr,
          5430 => Opcode::VBLENDMPSZrrk,
          5431 => Opcode::VBLENDMPSZrrkz,
          5432 => Opcode::VBLENDPDYrmi,
          5433 => Opcode::VBLENDPDYrri,
          5434 => Opcode::VBLENDPDrmi,
          5435 => Opcode::VBLENDPDrri,
          5436 => Opcode::VBLENDPSYrmi,
          5437 => Opcode::VBLENDPSYrri,
          5438 => Opcode::VBLENDPSrmi,
          5439 => Opcode::VBLENDPSrri,
          5440 => Opcode::VBLENDVPDYrmr,
          5441 => Opcode::VBLENDVPDYrrr,
          5442 => Opcode::VBLENDVPDrmr,
          5443 => Opcode::VBLENDVPDrrr,
          5444 => Opcode::VBLENDVPSYrmr,
          5445 => Opcode::VBLENDVPSYrrr,
          5446 => Opcode::VBLENDVPSrmr,
          5447 => Opcode::VBLENDVPSrrr,
          5448 => Opcode::VBROADCASTF128rm,
          5449 => Opcode::VBROADCASTF32X2Z256rm,
          5450 => Opcode::VBROADCASTF32X2Z256rmk,
          5451 => Opcode::VBROADCASTF32X2Z256rmkz,
          5452 => Opcode::VBROADCASTF32X2Z256rr,
          5453 => Opcode::VBROADCASTF32X2Z256rrk,
          5454 => Opcode::VBROADCASTF32X2Z256rrkz,
          5455 => Opcode::VBROADCASTF32X2Zrm,
          5456 => Opcode::VBROADCASTF32X2Zrmk,
          5457 => Opcode::VBROADCASTF32X2Zrmkz,
          5458 => Opcode::VBROADCASTF32X2Zrr,
          5459 => Opcode::VBROADCASTF32X2Zrrk,
          5460 => Opcode::VBROADCASTF32X2Zrrkz,
          5461 => Opcode::VBROADCASTF32X4Z256rm,
          5462 => Opcode::VBROADCASTF32X4Z256rmk,
          5463 => Opcode::VBROADCASTF32X4Z256rmkz,
          5464 => Opcode::VBROADCASTF32X4rm,
          5465 => Opcode::VBROADCASTF32X4rmk,
          5466 => Opcode::VBROADCASTF32X4rmkz,
          5467 => Opcode::VBROADCASTF32X8rm,
          5468 => Opcode::VBROADCASTF32X8rmk,
          5469 => Opcode::VBROADCASTF32X8rmkz,
          5470 => Opcode::VBROADCASTF64X2Z128rm,
          5471 => Opcode::VBROADCASTF64X2Z128rmk,
          5472 => Opcode::VBROADCASTF64X2Z128rmkz,
          5473 => Opcode::VBROADCASTF64X2rm,
          5474 => Opcode::VBROADCASTF64X2rmk,
          5475 => Opcode::VBROADCASTF64X2rmkz,
          5476 => Opcode::VBROADCASTF64X4rm,
          5477 => Opcode::VBROADCASTF64X4rmk,
          5478 => Opcode::VBROADCASTF64X4rmkz,
          5479 => Opcode::VBROADCASTI128rm,
          5480 => Opcode::VBROADCASTI32X2Z128rm,
          5481 => Opcode::VBROADCASTI32X2Z128rmk,
          5482 => Opcode::VBROADCASTI32X2Z128rmkz,
          5483 => Opcode::VBROADCASTI32X2Z128rr,
          5484 => Opcode::VBROADCASTI32X2Z128rrk,
          5485 => Opcode::VBROADCASTI32X2Z128rrkz,
          5486 => Opcode::VBROADCASTI32X2Z256rm,
          5487 => Opcode::VBROADCASTI32X2Z256rmk,
          5488 => Opcode::VBROADCASTI32X2Z256rmkz,
          5489 => Opcode::VBROADCASTI32X2Z256rr,
          5490 => Opcode::VBROADCASTI32X2Z256rrk,
          5491 => Opcode::VBROADCASTI32X2Z256rrkz,
          5492 => Opcode::VBROADCASTI32X2Zrm,
          5493 => Opcode::VBROADCASTI32X2Zrmk,
          5494 => Opcode::VBROADCASTI32X2Zrmkz,
          5495 => Opcode::VBROADCASTI32X2Zrr,
          5496 => Opcode::VBROADCASTI32X2Zrrk,
          5497 => Opcode::VBROADCASTI32X2Zrrkz,
          5498 => Opcode::VBROADCASTI32X4Z256rm,
          5499 => Opcode::VBROADCASTI32X4Z256rmk,
          5500 => Opcode::VBROADCASTI32X4Z256rmkz,
          5501 => Opcode::VBROADCASTI32X4rm,
          5502 => Opcode::VBROADCASTI32X4rmk,
          5503 => Opcode::VBROADCASTI32X4rmkz,
          5504 => Opcode::VBROADCASTI32X8rm,
          5505 => Opcode::VBROADCASTI32X8rmk,
          5506 => Opcode::VBROADCASTI32X8rmkz,
          5507 => Opcode::VBROADCASTI64X2Z128rm,
          5508 => Opcode::VBROADCASTI64X2Z128rmk,
          5509 => Opcode::VBROADCASTI64X2Z128rmkz,
          5510 => Opcode::VBROADCASTI64X2rm,
          5511 => Opcode::VBROADCASTI64X2rmk,
          5512 => Opcode::VBROADCASTI64X2rmkz,
          5513 => Opcode::VBROADCASTI64X4rm,
          5514 => Opcode::VBROADCASTI64X4rmk,
          5515 => Opcode::VBROADCASTI64X4rmkz,
          5516 => Opcode::VBROADCASTSDYrm,
          5517 => Opcode::VBROADCASTSDYrr,
          5518 => Opcode::VBROADCASTSDZ256rm,
          5519 => Opcode::VBROADCASTSDZ256rmk,
          5520 => Opcode::VBROADCASTSDZ256rmkz,
          5521 => Opcode::VBROADCASTSDZ256rr,
          5522 => Opcode::VBROADCASTSDZ256rrk,
          5523 => Opcode::VBROADCASTSDZ256rrkz,
          5524 => Opcode::VBROADCASTSDZrm,
          5525 => Opcode::VBROADCASTSDZrmk,
          5526 => Opcode::VBROADCASTSDZrmkz,
          5527 => Opcode::VBROADCASTSDZrr,
          5528 => Opcode::VBROADCASTSDZrrk,
          5529 => Opcode::VBROADCASTSDZrrkz,
          5530 => Opcode::VBROADCASTSSYrm,
          5531 => Opcode::VBROADCASTSSYrr,
          5532 => Opcode::VBROADCASTSSZ128rm,
          5533 => Opcode::VBROADCASTSSZ128rmk,
          5534 => Opcode::VBROADCASTSSZ128rmkz,
          5535 => Opcode::VBROADCASTSSZ128rr,
          5536 => Opcode::VBROADCASTSSZ128rrk,
          5537 => Opcode::VBROADCASTSSZ128rrkz,
          5538 => Opcode::VBROADCASTSSZ256rm,
          5539 => Opcode::VBROADCASTSSZ256rmk,
          5540 => Opcode::VBROADCASTSSZ256rmkz,
          5541 => Opcode::VBROADCASTSSZ256rr,
          5542 => Opcode::VBROADCASTSSZ256rrk,
          5543 => Opcode::VBROADCASTSSZ256rrkz,
          5544 => Opcode::VBROADCASTSSZrm,
          5545 => Opcode::VBROADCASTSSZrmk,
          5546 => Opcode::VBROADCASTSSZrmkz,
          5547 => Opcode::VBROADCASTSSZrr,
          5548 => Opcode::VBROADCASTSSZrrk,
          5549 => Opcode::VBROADCASTSSZrrkz,
          5550 => Opcode::VBROADCASTSSrm,
          5551 => Opcode::VBROADCASTSSrr,
          5552 => Opcode::VCMPPDYrmi,
          5553 => Opcode::VCMPPDYrri,
          5554 => Opcode::VCMPPDZ128rmbi,
          5555 => Opcode::VCMPPDZ128rmbik,
          5556 => Opcode::VCMPPDZ128rmi,
          5557 => Opcode::VCMPPDZ128rmik,
          5558 => Opcode::VCMPPDZ128rri,
          5559 => Opcode::VCMPPDZ128rrik,
          5560 => Opcode::VCMPPDZ256rmbi,
          5561 => Opcode::VCMPPDZ256rmbik,
          5562 => Opcode::VCMPPDZ256rmi,
          5563 => Opcode::VCMPPDZ256rmik,
          5564 => Opcode::VCMPPDZ256rri,
          5565 => Opcode::VCMPPDZ256rrik,
          5566 => Opcode::VCMPPDZrmbi,
          5567 => Opcode::VCMPPDZrmbik,
          5568 => Opcode::VCMPPDZrmi,
          5569 => Opcode::VCMPPDZrmik,
          5570 => Opcode::VCMPPDZrri,
          5571 => Opcode::VCMPPDZrrib,
          5572 => Opcode::VCMPPDZrribk,
          5573 => Opcode::VCMPPDZrrik,
          5574 => Opcode::VCMPPDrmi,
          5575 => Opcode::VCMPPDrri,
          5576 => Opcode::VCMPPHZ128rmbi,
          5577 => Opcode::VCMPPHZ128rmbik,
          5578 => Opcode::VCMPPHZ128rmi,
          5579 => Opcode::VCMPPHZ128rmik,
          5580 => Opcode::VCMPPHZ128rri,
          5581 => Opcode::VCMPPHZ128rrik,
          5582 => Opcode::VCMPPHZ256rmbi,
          5583 => Opcode::VCMPPHZ256rmbik,
          5584 => Opcode::VCMPPHZ256rmi,
          5585 => Opcode::VCMPPHZ256rmik,
          5586 => Opcode::VCMPPHZ256rri,
          5587 => Opcode::VCMPPHZ256rrik,
          5588 => Opcode::VCMPPHZrmbi,
          5589 => Opcode::VCMPPHZrmbik,
          5590 => Opcode::VCMPPHZrmi,
          5591 => Opcode::VCMPPHZrmik,
          5592 => Opcode::VCMPPHZrri,
          5593 => Opcode::VCMPPHZrrib,
          5594 => Opcode::VCMPPHZrribk,
          5595 => Opcode::VCMPPHZrrik,
          5596 => Opcode::VCMPPSYrmi,
          5597 => Opcode::VCMPPSYrri,
          5598 => Opcode::VCMPPSZ128rmbi,
          5599 => Opcode::VCMPPSZ128rmbik,
          5600 => Opcode::VCMPPSZ128rmi,
          5601 => Opcode::VCMPPSZ128rmik,
          5602 => Opcode::VCMPPSZ128rri,
          5603 => Opcode::VCMPPSZ128rrik,
          5604 => Opcode::VCMPPSZ256rmbi,
          5605 => Opcode::VCMPPSZ256rmbik,
          5606 => Opcode::VCMPPSZ256rmi,
          5607 => Opcode::VCMPPSZ256rmik,
          5608 => Opcode::VCMPPSZ256rri,
          5609 => Opcode::VCMPPSZ256rrik,
          5610 => Opcode::VCMPPSZrmbi,
          5611 => Opcode::VCMPPSZrmbik,
          5612 => Opcode::VCMPPSZrmi,
          5613 => Opcode::VCMPPSZrmik,
          5614 => Opcode::VCMPPSZrri,
          5615 => Opcode::VCMPPSZrrib,
          5616 => Opcode::VCMPPSZrribk,
          5617 => Opcode::VCMPPSZrrik,
          5618 => Opcode::VCMPPSrmi,
          5619 => Opcode::VCMPPSrri,
          5620 => Opcode::VCMPSDZrmi,
          5621 => Opcode::VCMPSDZrmi_Int,
          5622 => Opcode::VCMPSDZrmi_Intk,
          5623 => Opcode::VCMPSDZrri,
          5624 => Opcode::VCMPSDZrri_Int,
          5625 => Opcode::VCMPSDZrri_Intk,
          5626 => Opcode::VCMPSDZrrib_Int,
          5627 => Opcode::VCMPSDZrrib_Intk,
          5628 => Opcode::VCMPSDrmi,
          5629 => Opcode::VCMPSDrmi_Int,
          5630 => Opcode::VCMPSDrri,
          5631 => Opcode::VCMPSDrri_Int,
          5632 => Opcode::VCMPSHZrmi,
          5633 => Opcode::VCMPSHZrmi_Int,
          5634 => Opcode::VCMPSHZrmi_Intk,
          5635 => Opcode::VCMPSHZrri,
          5636 => Opcode::VCMPSHZrri_Int,
          5637 => Opcode::VCMPSHZrri_Intk,
          5638 => Opcode::VCMPSHZrrib_Int,
          5639 => Opcode::VCMPSHZrrib_Intk,
          5640 => Opcode::VCMPSSZrmi,
          5641 => Opcode::VCMPSSZrmi_Int,
          5642 => Opcode::VCMPSSZrmi_Intk,
          5643 => Opcode::VCMPSSZrri,
          5644 => Opcode::VCMPSSZrri_Int,
          5645 => Opcode::VCMPSSZrri_Intk,
          5646 => Opcode::VCMPSSZrrib_Int,
          5647 => Opcode::VCMPSSZrrib_Intk,
          5648 => Opcode::VCMPSSrmi,
          5649 => Opcode::VCMPSSrmi_Int,
          5650 => Opcode::VCMPSSrri,
          5651 => Opcode::VCMPSSrri_Int,
          5652 => Opcode::VCOMISDZrm,
          5653 => Opcode::VCOMISDZrm_Int,
          5654 => Opcode::VCOMISDZrr,
          5655 => Opcode::VCOMISDZrr_Int,
          5656 => Opcode::VCOMISDZrrb,
          5657 => Opcode::VCOMISDrm,
          5658 => Opcode::VCOMISDrm_Int,
          5659 => Opcode::VCOMISDrr,
          5660 => Opcode::VCOMISDrr_Int,
          5661 => Opcode::VCOMISHZrm,
          5662 => Opcode::VCOMISHZrm_Int,
          5663 => Opcode::VCOMISHZrr,
          5664 => Opcode::VCOMISHZrr_Int,
          5665 => Opcode::VCOMISHZrrb,
          5666 => Opcode::VCOMISSZrm,
          5667 => Opcode::VCOMISSZrm_Int,
          5668 => Opcode::VCOMISSZrr,
          5669 => Opcode::VCOMISSZrr_Int,
          5670 => Opcode::VCOMISSZrrb,
          5671 => Opcode::VCOMISSrm,
          5672 => Opcode::VCOMISSrm_Int,
          5673 => Opcode::VCOMISSrr,
          5674 => Opcode::VCOMISSrr_Int,
          5675 => Opcode::VCOMPRESSPDZ128mr,
          5676 => Opcode::VCOMPRESSPDZ128mrk,
          5677 => Opcode::VCOMPRESSPDZ128rr,
          5678 => Opcode::VCOMPRESSPDZ128rrk,
          5679 => Opcode::VCOMPRESSPDZ128rrkz,
          5680 => Opcode::VCOMPRESSPDZ256mr,
          5681 => Opcode::VCOMPRESSPDZ256mrk,
          5682 => Opcode::VCOMPRESSPDZ256rr,
          5683 => Opcode::VCOMPRESSPDZ256rrk,
          5684 => Opcode::VCOMPRESSPDZ256rrkz,
          5685 => Opcode::VCOMPRESSPDZmr,
          5686 => Opcode::VCOMPRESSPDZmrk,
          5687 => Opcode::VCOMPRESSPDZrr,
          5688 => Opcode::VCOMPRESSPDZrrk,
          5689 => Opcode::VCOMPRESSPDZrrkz,
          5690 => Opcode::VCOMPRESSPSZ128mr,
          5691 => Opcode::VCOMPRESSPSZ128mrk,
          5692 => Opcode::VCOMPRESSPSZ128rr,
          5693 => Opcode::VCOMPRESSPSZ128rrk,
          5694 => Opcode::VCOMPRESSPSZ128rrkz,
          5695 => Opcode::VCOMPRESSPSZ256mr,
          5696 => Opcode::VCOMPRESSPSZ256mrk,
          5697 => Opcode::VCOMPRESSPSZ256rr,
          5698 => Opcode::VCOMPRESSPSZ256rrk,
          5699 => Opcode::VCOMPRESSPSZ256rrkz,
          5700 => Opcode::VCOMPRESSPSZmr,
          5701 => Opcode::VCOMPRESSPSZmrk,
          5702 => Opcode::VCOMPRESSPSZrr,
          5703 => Opcode::VCOMPRESSPSZrrk,
          5704 => Opcode::VCOMPRESSPSZrrkz,
          5705 => Opcode::VCVTDQ2PDYrm,
          5706 => Opcode::VCVTDQ2PDYrr,
          5707 => Opcode::VCVTDQ2PDZ128rm,
          5708 => Opcode::VCVTDQ2PDZ128rmb,
          5709 => Opcode::VCVTDQ2PDZ128rmbk,
          5710 => Opcode::VCVTDQ2PDZ128rmbkz,
          5711 => Opcode::VCVTDQ2PDZ128rmk,
          5712 => Opcode::VCVTDQ2PDZ128rmkz,
          5713 => Opcode::VCVTDQ2PDZ128rr,
          5714 => Opcode::VCVTDQ2PDZ128rrk,
          5715 => Opcode::VCVTDQ2PDZ128rrkz,
          5716 => Opcode::VCVTDQ2PDZ256rm,
          5717 => Opcode::VCVTDQ2PDZ256rmb,
          5718 => Opcode::VCVTDQ2PDZ256rmbk,
          5719 => Opcode::VCVTDQ2PDZ256rmbkz,
          5720 => Opcode::VCVTDQ2PDZ256rmk,
          5721 => Opcode::VCVTDQ2PDZ256rmkz,
          5722 => Opcode::VCVTDQ2PDZ256rr,
          5723 => Opcode::VCVTDQ2PDZ256rrk,
          5724 => Opcode::VCVTDQ2PDZ256rrkz,
          5725 => Opcode::VCVTDQ2PDZrm,
          5726 => Opcode::VCVTDQ2PDZrmb,
          5727 => Opcode::VCVTDQ2PDZrmbk,
          5728 => Opcode::VCVTDQ2PDZrmbkz,
          5729 => Opcode::VCVTDQ2PDZrmk,
          5730 => Opcode::VCVTDQ2PDZrmkz,
          5731 => Opcode::VCVTDQ2PDZrr,
          5732 => Opcode::VCVTDQ2PDZrrk,
          5733 => Opcode::VCVTDQ2PDZrrkz,
          5734 => Opcode::VCVTDQ2PDrm,
          5735 => Opcode::VCVTDQ2PDrr,
          5736 => Opcode::VCVTDQ2PHZ128rm,
          5737 => Opcode::VCVTDQ2PHZ128rmb,
          5738 => Opcode::VCVTDQ2PHZ128rmbk,
          5739 => Opcode::VCVTDQ2PHZ128rmbkz,
          5740 => Opcode::VCVTDQ2PHZ128rmk,
          5741 => Opcode::VCVTDQ2PHZ128rmkz,
          5742 => Opcode::VCVTDQ2PHZ128rr,
          5743 => Opcode::VCVTDQ2PHZ128rrk,
          5744 => Opcode::VCVTDQ2PHZ128rrkz,
          5745 => Opcode::VCVTDQ2PHZ256rm,
          5746 => Opcode::VCVTDQ2PHZ256rmb,
          5747 => Opcode::VCVTDQ2PHZ256rmbk,
          5748 => Opcode::VCVTDQ2PHZ256rmbkz,
          5749 => Opcode::VCVTDQ2PHZ256rmk,
          5750 => Opcode::VCVTDQ2PHZ256rmkz,
          5751 => Opcode::VCVTDQ2PHZ256rr,
          5752 => Opcode::VCVTDQ2PHZ256rrk,
          5753 => Opcode::VCVTDQ2PHZ256rrkz,
          5754 => Opcode::VCVTDQ2PHZrm,
          5755 => Opcode::VCVTDQ2PHZrmb,
          5756 => Opcode::VCVTDQ2PHZrmbk,
          5757 => Opcode::VCVTDQ2PHZrmbkz,
          5758 => Opcode::VCVTDQ2PHZrmk,
          5759 => Opcode::VCVTDQ2PHZrmkz,
          5760 => Opcode::VCVTDQ2PHZrr,
          5761 => Opcode::VCVTDQ2PHZrrb,
          5762 => Opcode::VCVTDQ2PHZrrbk,
          5763 => Opcode::VCVTDQ2PHZrrbkz,
          5764 => Opcode::VCVTDQ2PHZrrk,
          5765 => Opcode::VCVTDQ2PHZrrkz,
          5766 => Opcode::VCVTDQ2PSYrm,
          5767 => Opcode::VCVTDQ2PSYrr,
          5768 => Opcode::VCVTDQ2PSZ128rm,
          5769 => Opcode::VCVTDQ2PSZ128rmb,
          5770 => Opcode::VCVTDQ2PSZ128rmbk,
          5771 => Opcode::VCVTDQ2PSZ128rmbkz,
          5772 => Opcode::VCVTDQ2PSZ128rmk,
          5773 => Opcode::VCVTDQ2PSZ128rmkz,
          5774 => Opcode::VCVTDQ2PSZ128rr,
          5775 => Opcode::VCVTDQ2PSZ128rrk,
          5776 => Opcode::VCVTDQ2PSZ128rrkz,
          5777 => Opcode::VCVTDQ2PSZ256rm,
          5778 => Opcode::VCVTDQ2PSZ256rmb,
          5779 => Opcode::VCVTDQ2PSZ256rmbk,
          5780 => Opcode::VCVTDQ2PSZ256rmbkz,
          5781 => Opcode::VCVTDQ2PSZ256rmk,
          5782 => Opcode::VCVTDQ2PSZ256rmkz,
          5783 => Opcode::VCVTDQ2PSZ256rr,
          5784 => Opcode::VCVTDQ2PSZ256rrk,
          5785 => Opcode::VCVTDQ2PSZ256rrkz,
          5786 => Opcode::VCVTDQ2PSZrm,
          5787 => Opcode::VCVTDQ2PSZrmb,
          5788 => Opcode::VCVTDQ2PSZrmbk,
          5789 => Opcode::VCVTDQ2PSZrmbkz,
          5790 => Opcode::VCVTDQ2PSZrmk,
          5791 => Opcode::VCVTDQ2PSZrmkz,
          5792 => Opcode::VCVTDQ2PSZrr,
          5793 => Opcode::VCVTDQ2PSZrrb,
          5794 => Opcode::VCVTDQ2PSZrrbk,
          5795 => Opcode::VCVTDQ2PSZrrbkz,
          5796 => Opcode::VCVTDQ2PSZrrk,
          5797 => Opcode::VCVTDQ2PSZrrkz,
          5798 => Opcode::VCVTDQ2PSrm,
          5799 => Opcode::VCVTDQ2PSrr,
          5800 => Opcode::VCVTNE2PS2BF16Z128rm,
          5801 => Opcode::VCVTNE2PS2BF16Z128rmb,
          5802 => Opcode::VCVTNE2PS2BF16Z128rmbk,
          5803 => Opcode::VCVTNE2PS2BF16Z128rmbkz,
          5804 => Opcode::VCVTNE2PS2BF16Z128rmk,
          5805 => Opcode::VCVTNE2PS2BF16Z128rmkz,
          5806 => Opcode::VCVTNE2PS2BF16Z128rr,
          5807 => Opcode::VCVTNE2PS2BF16Z128rrk,
          5808 => Opcode::VCVTNE2PS2BF16Z128rrkz,
          5809 => Opcode::VCVTNE2PS2BF16Z256rm,
          5810 => Opcode::VCVTNE2PS2BF16Z256rmb,
          5811 => Opcode::VCVTNE2PS2BF16Z256rmbk,
          5812 => Opcode::VCVTNE2PS2BF16Z256rmbkz,
          5813 => Opcode::VCVTNE2PS2BF16Z256rmk,
          5814 => Opcode::VCVTNE2PS2BF16Z256rmkz,
          5815 => Opcode::VCVTNE2PS2BF16Z256rr,
          5816 => Opcode::VCVTNE2PS2BF16Z256rrk,
          5817 => Opcode::VCVTNE2PS2BF16Z256rrkz,
          5818 => Opcode::VCVTNE2PS2BF16Zrm,
          5819 => Opcode::VCVTNE2PS2BF16Zrmb,
          5820 => Opcode::VCVTNE2PS2BF16Zrmbk,
          5821 => Opcode::VCVTNE2PS2BF16Zrmbkz,
          5822 => Opcode::VCVTNE2PS2BF16Zrmk,
          5823 => Opcode::VCVTNE2PS2BF16Zrmkz,
          5824 => Opcode::VCVTNE2PS2BF16Zrr,
          5825 => Opcode::VCVTNE2PS2BF16Zrrk,
          5826 => Opcode::VCVTNE2PS2BF16Zrrkz,
          5827 => Opcode::VCVTNEEBF162PSYrm,
          5828 => Opcode::VCVTNEEBF162PSrm,
          5829 => Opcode::VCVTNEEPH2PSYrm,
          5830 => Opcode::VCVTNEEPH2PSrm,
          5831 => Opcode::VCVTNEOBF162PSYrm,
          5832 => Opcode::VCVTNEOBF162PSrm,
          5833 => Opcode::VCVTNEOPH2PSYrm,
          5834 => Opcode::VCVTNEOPH2PSrm,
          5835 => Opcode::VCVTNEPS2BF16Yrm,
          5836 => Opcode::VCVTNEPS2BF16Yrr,
          5837 => Opcode::VCVTNEPS2BF16Z128rm,
          5838 => Opcode::VCVTNEPS2BF16Z128rmb,
          5839 => Opcode::VCVTNEPS2BF16Z128rmbk,
          5840 => Opcode::VCVTNEPS2BF16Z128rmbkz,
          5841 => Opcode::VCVTNEPS2BF16Z128rmk,
          5842 => Opcode::VCVTNEPS2BF16Z128rmkz,
          5843 => Opcode::VCVTNEPS2BF16Z128rr,
          5844 => Opcode::VCVTNEPS2BF16Z128rrk,
          5845 => Opcode::VCVTNEPS2BF16Z128rrkz,
          5846 => Opcode::VCVTNEPS2BF16Z256rm,
          5847 => Opcode::VCVTNEPS2BF16Z256rmb,
          5848 => Opcode::VCVTNEPS2BF16Z256rmbk,
          5849 => Opcode::VCVTNEPS2BF16Z256rmbkz,
          5850 => Opcode::VCVTNEPS2BF16Z256rmk,
          5851 => Opcode::VCVTNEPS2BF16Z256rmkz,
          5852 => Opcode::VCVTNEPS2BF16Z256rr,
          5853 => Opcode::VCVTNEPS2BF16Z256rrk,
          5854 => Opcode::VCVTNEPS2BF16Z256rrkz,
          5855 => Opcode::VCVTNEPS2BF16Zrm,
          5856 => Opcode::VCVTNEPS2BF16Zrmb,
          5857 => Opcode::VCVTNEPS2BF16Zrmbk,
          5858 => Opcode::VCVTNEPS2BF16Zrmbkz,
          5859 => Opcode::VCVTNEPS2BF16Zrmk,
          5860 => Opcode::VCVTNEPS2BF16Zrmkz,
          5861 => Opcode::VCVTNEPS2BF16Zrr,
          5862 => Opcode::VCVTNEPS2BF16Zrrk,
          5863 => Opcode::VCVTNEPS2BF16Zrrkz,
          5864 => Opcode::VCVTNEPS2BF16rm,
          5865 => Opcode::VCVTNEPS2BF16rr,
          5866 => Opcode::VCVTPD2DQYrm,
          5867 => Opcode::VCVTPD2DQYrr,
          5868 => Opcode::VCVTPD2DQZ128rm,
          5869 => Opcode::VCVTPD2DQZ128rmb,
          5870 => Opcode::VCVTPD2DQZ128rmbk,
          5871 => Opcode::VCVTPD2DQZ128rmbkz,
          5872 => Opcode::VCVTPD2DQZ128rmk,
          5873 => Opcode::VCVTPD2DQZ128rmkz,
          5874 => Opcode::VCVTPD2DQZ128rr,
          5875 => Opcode::VCVTPD2DQZ128rrk,
          5876 => Opcode::VCVTPD2DQZ128rrkz,
          5877 => Opcode::VCVTPD2DQZ256rm,
          5878 => Opcode::VCVTPD2DQZ256rmb,
          5879 => Opcode::VCVTPD2DQZ256rmbk,
          5880 => Opcode::VCVTPD2DQZ256rmbkz,
          5881 => Opcode::VCVTPD2DQZ256rmk,
          5882 => Opcode::VCVTPD2DQZ256rmkz,
          5883 => Opcode::VCVTPD2DQZ256rr,
          5884 => Opcode::VCVTPD2DQZ256rrk,
          5885 => Opcode::VCVTPD2DQZ256rrkz,
          5886 => Opcode::VCVTPD2DQZrm,
          5887 => Opcode::VCVTPD2DQZrmb,
          5888 => Opcode::VCVTPD2DQZrmbk,
          5889 => Opcode::VCVTPD2DQZrmbkz,
          5890 => Opcode::VCVTPD2DQZrmk,
          5891 => Opcode::VCVTPD2DQZrmkz,
          5892 => Opcode::VCVTPD2DQZrr,
          5893 => Opcode::VCVTPD2DQZrrb,
          5894 => Opcode::VCVTPD2DQZrrbk,
          5895 => Opcode::VCVTPD2DQZrrbkz,
          5896 => Opcode::VCVTPD2DQZrrk,
          5897 => Opcode::VCVTPD2DQZrrkz,
          5898 => Opcode::VCVTPD2DQrm,
          5899 => Opcode::VCVTPD2DQrr,
          5900 => Opcode::VCVTPD2PHZ128rm,
          5901 => Opcode::VCVTPD2PHZ128rmb,
          5902 => Opcode::VCVTPD2PHZ128rmbk,
          5903 => Opcode::VCVTPD2PHZ128rmbkz,
          5904 => Opcode::VCVTPD2PHZ128rmk,
          5905 => Opcode::VCVTPD2PHZ128rmkz,
          5906 => Opcode::VCVTPD2PHZ128rr,
          5907 => Opcode::VCVTPD2PHZ128rrk,
          5908 => Opcode::VCVTPD2PHZ128rrkz,
          5909 => Opcode::VCVTPD2PHZ256rm,
          5910 => Opcode::VCVTPD2PHZ256rmb,
          5911 => Opcode::VCVTPD2PHZ256rmbk,
          5912 => Opcode::VCVTPD2PHZ256rmbkz,
          5913 => Opcode::VCVTPD2PHZ256rmk,
          5914 => Opcode::VCVTPD2PHZ256rmkz,
          5915 => Opcode::VCVTPD2PHZ256rr,
          5916 => Opcode::VCVTPD2PHZ256rrk,
          5917 => Opcode::VCVTPD2PHZ256rrkz,
          5918 => Opcode::VCVTPD2PHZrm,
          5919 => Opcode::VCVTPD2PHZrmb,
          5920 => Opcode::VCVTPD2PHZrmbk,
          5921 => Opcode::VCVTPD2PHZrmbkz,
          5922 => Opcode::VCVTPD2PHZrmk,
          5923 => Opcode::VCVTPD2PHZrmkz,
          5924 => Opcode::VCVTPD2PHZrr,
          5925 => Opcode::VCVTPD2PHZrrb,
          5926 => Opcode::VCVTPD2PHZrrbk,
          5927 => Opcode::VCVTPD2PHZrrbkz,
          5928 => Opcode::VCVTPD2PHZrrk,
          5929 => Opcode::VCVTPD2PHZrrkz,
          5930 => Opcode::VCVTPD2PSYrm,
          5931 => Opcode::VCVTPD2PSYrr,
          5932 => Opcode::VCVTPD2PSZ128rm,
          5933 => Opcode::VCVTPD2PSZ128rmb,
          5934 => Opcode::VCVTPD2PSZ128rmbk,
          5935 => Opcode::VCVTPD2PSZ128rmbkz,
          5936 => Opcode::VCVTPD2PSZ128rmk,
          5937 => Opcode::VCVTPD2PSZ128rmkz,
          5938 => Opcode::VCVTPD2PSZ128rr,
          5939 => Opcode::VCVTPD2PSZ128rrk,
          5940 => Opcode::VCVTPD2PSZ128rrkz,
          5941 => Opcode::VCVTPD2PSZ256rm,
          5942 => Opcode::VCVTPD2PSZ256rmb,
          5943 => Opcode::VCVTPD2PSZ256rmbk,
          5944 => Opcode::VCVTPD2PSZ256rmbkz,
          5945 => Opcode::VCVTPD2PSZ256rmk,
          5946 => Opcode::VCVTPD2PSZ256rmkz,
          5947 => Opcode::VCVTPD2PSZ256rr,
          5948 => Opcode::VCVTPD2PSZ256rrk,
          5949 => Opcode::VCVTPD2PSZ256rrkz,
          5950 => Opcode::VCVTPD2PSZrm,
          5951 => Opcode::VCVTPD2PSZrmb,
          5952 => Opcode::VCVTPD2PSZrmbk,
          5953 => Opcode::VCVTPD2PSZrmbkz,
          5954 => Opcode::VCVTPD2PSZrmk,
          5955 => Opcode::VCVTPD2PSZrmkz,
          5956 => Opcode::VCVTPD2PSZrr,
          5957 => Opcode::VCVTPD2PSZrrb,
          5958 => Opcode::VCVTPD2PSZrrbk,
          5959 => Opcode::VCVTPD2PSZrrbkz,
          5960 => Opcode::VCVTPD2PSZrrk,
          5961 => Opcode::VCVTPD2PSZrrkz,
          5962 => Opcode::VCVTPD2PSrm,
          5963 => Opcode::VCVTPD2PSrr,
          5964 => Opcode::VCVTPD2QQZ128rm,
          5965 => Opcode::VCVTPD2QQZ128rmb,
          5966 => Opcode::VCVTPD2QQZ128rmbk,
          5967 => Opcode::VCVTPD2QQZ128rmbkz,
          5968 => Opcode::VCVTPD2QQZ128rmk,
          5969 => Opcode::VCVTPD2QQZ128rmkz,
          5970 => Opcode::VCVTPD2QQZ128rr,
          5971 => Opcode::VCVTPD2QQZ128rrk,
          5972 => Opcode::VCVTPD2QQZ128rrkz,
          5973 => Opcode::VCVTPD2QQZ256rm,
          5974 => Opcode::VCVTPD2QQZ256rmb,
          5975 => Opcode::VCVTPD2QQZ256rmbk,
          5976 => Opcode::VCVTPD2QQZ256rmbkz,
          5977 => Opcode::VCVTPD2QQZ256rmk,
          5978 => Opcode::VCVTPD2QQZ256rmkz,
          5979 => Opcode::VCVTPD2QQZ256rr,
          5980 => Opcode::VCVTPD2QQZ256rrk,
          5981 => Opcode::VCVTPD2QQZ256rrkz,
          5982 => Opcode::VCVTPD2QQZrm,
          5983 => Opcode::VCVTPD2QQZrmb,
          5984 => Opcode::VCVTPD2QQZrmbk,
          5985 => Opcode::VCVTPD2QQZrmbkz,
          5986 => Opcode::VCVTPD2QQZrmk,
          5987 => Opcode::VCVTPD2QQZrmkz,
          5988 => Opcode::VCVTPD2QQZrr,
          5989 => Opcode::VCVTPD2QQZrrb,
          5990 => Opcode::VCVTPD2QQZrrbk,
          5991 => Opcode::VCVTPD2QQZrrbkz,
          5992 => Opcode::VCVTPD2QQZrrk,
          5993 => Opcode::VCVTPD2QQZrrkz,
          5994 => Opcode::VCVTPD2UDQZ128rm,
          5995 => Opcode::VCVTPD2UDQZ128rmb,
          5996 => Opcode::VCVTPD2UDQZ128rmbk,
          5997 => Opcode::VCVTPD2UDQZ128rmbkz,
          5998 => Opcode::VCVTPD2UDQZ128rmk,
          5999 => Opcode::VCVTPD2UDQZ128rmkz,
          6000 => Opcode::VCVTPD2UDQZ128rr,
          6001 => Opcode::VCVTPD2UDQZ128rrk,
          6002 => Opcode::VCVTPD2UDQZ128rrkz,
          6003 => Opcode::VCVTPD2UDQZ256rm,
          6004 => Opcode::VCVTPD2UDQZ256rmb,
          6005 => Opcode::VCVTPD2UDQZ256rmbk,
          6006 => Opcode::VCVTPD2UDQZ256rmbkz,
          6007 => Opcode::VCVTPD2UDQZ256rmk,
          6008 => Opcode::VCVTPD2UDQZ256rmkz,
          6009 => Opcode::VCVTPD2UDQZ256rr,
          6010 => Opcode::VCVTPD2UDQZ256rrk,
          6011 => Opcode::VCVTPD2UDQZ256rrkz,
          6012 => Opcode::VCVTPD2UDQZrm,
          6013 => Opcode::VCVTPD2UDQZrmb,
          6014 => Opcode::VCVTPD2UDQZrmbk,
          6015 => Opcode::VCVTPD2UDQZrmbkz,
          6016 => Opcode::VCVTPD2UDQZrmk,
          6017 => Opcode::VCVTPD2UDQZrmkz,
          6018 => Opcode::VCVTPD2UDQZrr,
          6019 => Opcode::VCVTPD2UDQZrrb,
          6020 => Opcode::VCVTPD2UDQZrrbk,
          6021 => Opcode::VCVTPD2UDQZrrbkz,
          6022 => Opcode::VCVTPD2UDQZrrk,
          6023 => Opcode::VCVTPD2UDQZrrkz,
          6024 => Opcode::VCVTPD2UQQZ128rm,
          6025 => Opcode::VCVTPD2UQQZ128rmb,
          6026 => Opcode::VCVTPD2UQQZ128rmbk,
          6027 => Opcode::VCVTPD2UQQZ128rmbkz,
          6028 => Opcode::VCVTPD2UQQZ128rmk,
          6029 => Opcode::VCVTPD2UQQZ128rmkz,
          6030 => Opcode::VCVTPD2UQQZ128rr,
          6031 => Opcode::VCVTPD2UQQZ128rrk,
          6032 => Opcode::VCVTPD2UQQZ128rrkz,
          6033 => Opcode::VCVTPD2UQQZ256rm,
          6034 => Opcode::VCVTPD2UQQZ256rmb,
          6035 => Opcode::VCVTPD2UQQZ256rmbk,
          6036 => Opcode::VCVTPD2UQQZ256rmbkz,
          6037 => Opcode::VCVTPD2UQQZ256rmk,
          6038 => Opcode::VCVTPD2UQQZ256rmkz,
          6039 => Opcode::VCVTPD2UQQZ256rr,
          6040 => Opcode::VCVTPD2UQQZ256rrk,
          6041 => Opcode::VCVTPD2UQQZ256rrkz,
          6042 => Opcode::VCVTPD2UQQZrm,
          6043 => Opcode::VCVTPD2UQQZrmb,
          6044 => Opcode::VCVTPD2UQQZrmbk,
          6045 => Opcode::VCVTPD2UQQZrmbkz,
          6046 => Opcode::VCVTPD2UQQZrmk,
          6047 => Opcode::VCVTPD2UQQZrmkz,
          6048 => Opcode::VCVTPD2UQQZrr,
          6049 => Opcode::VCVTPD2UQQZrrb,
          6050 => Opcode::VCVTPD2UQQZrrbk,
          6051 => Opcode::VCVTPD2UQQZrrbkz,
          6052 => Opcode::VCVTPD2UQQZrrk,
          6053 => Opcode::VCVTPD2UQQZrrkz,
          6054 => Opcode::VCVTPH2DQZ128rm,
          6055 => Opcode::VCVTPH2DQZ128rmb,
          6056 => Opcode::VCVTPH2DQZ128rmbk,
          6057 => Opcode::VCVTPH2DQZ128rmbkz,
          6058 => Opcode::VCVTPH2DQZ128rmk,
          6059 => Opcode::VCVTPH2DQZ128rmkz,
          6060 => Opcode::VCVTPH2DQZ128rr,
          6061 => Opcode::VCVTPH2DQZ128rrk,
          6062 => Opcode::VCVTPH2DQZ128rrkz,
          6063 => Opcode::VCVTPH2DQZ256rm,
          6064 => Opcode::VCVTPH2DQZ256rmb,
          6065 => Opcode::VCVTPH2DQZ256rmbk,
          6066 => Opcode::VCVTPH2DQZ256rmbkz,
          6067 => Opcode::VCVTPH2DQZ256rmk,
          6068 => Opcode::VCVTPH2DQZ256rmkz,
          6069 => Opcode::VCVTPH2DQZ256rr,
          6070 => Opcode::VCVTPH2DQZ256rrk,
          6071 => Opcode::VCVTPH2DQZ256rrkz,
          6072 => Opcode::VCVTPH2DQZrm,
          6073 => Opcode::VCVTPH2DQZrmb,
          6074 => Opcode::VCVTPH2DQZrmbk,
          6075 => Opcode::VCVTPH2DQZrmbkz,
          6076 => Opcode::VCVTPH2DQZrmk,
          6077 => Opcode::VCVTPH2DQZrmkz,
          6078 => Opcode::VCVTPH2DQZrr,
          6079 => Opcode::VCVTPH2DQZrrb,
          6080 => Opcode::VCVTPH2DQZrrbk,
          6081 => Opcode::VCVTPH2DQZrrbkz,
          6082 => Opcode::VCVTPH2DQZrrk,
          6083 => Opcode::VCVTPH2DQZrrkz,
          6084 => Opcode::VCVTPH2PDZ128rm,
          6085 => Opcode::VCVTPH2PDZ128rmb,
          6086 => Opcode::VCVTPH2PDZ128rmbk,
          6087 => Opcode::VCVTPH2PDZ128rmbkz,
          6088 => Opcode::VCVTPH2PDZ128rmk,
          6089 => Opcode::VCVTPH2PDZ128rmkz,
          6090 => Opcode::VCVTPH2PDZ128rr,
          6091 => Opcode::VCVTPH2PDZ128rrk,
          6092 => Opcode::VCVTPH2PDZ128rrkz,
          6093 => Opcode::VCVTPH2PDZ256rm,
          6094 => Opcode::VCVTPH2PDZ256rmb,
          6095 => Opcode::VCVTPH2PDZ256rmbk,
          6096 => Opcode::VCVTPH2PDZ256rmbkz,
          6097 => Opcode::VCVTPH2PDZ256rmk,
          6098 => Opcode::VCVTPH2PDZ256rmkz,
          6099 => Opcode::VCVTPH2PDZ256rr,
          6100 => Opcode::VCVTPH2PDZ256rrk,
          6101 => Opcode::VCVTPH2PDZ256rrkz,
          6102 => Opcode::VCVTPH2PDZrm,
          6103 => Opcode::VCVTPH2PDZrmb,
          6104 => Opcode::VCVTPH2PDZrmbk,
          6105 => Opcode::VCVTPH2PDZrmbkz,
          6106 => Opcode::VCVTPH2PDZrmk,
          6107 => Opcode::VCVTPH2PDZrmkz,
          6108 => Opcode::VCVTPH2PDZrr,
          6109 => Opcode::VCVTPH2PDZrrb,
          6110 => Opcode::VCVTPH2PDZrrbk,
          6111 => Opcode::VCVTPH2PDZrrbkz,
          6112 => Opcode::VCVTPH2PDZrrk,
          6113 => Opcode::VCVTPH2PDZrrkz,
          6114 => Opcode::VCVTPH2PSXZ128rm,
          6115 => Opcode::VCVTPH2PSXZ128rmb,
          6116 => Opcode::VCVTPH2PSXZ128rmbk,
          6117 => Opcode::VCVTPH2PSXZ128rmbkz,
          6118 => Opcode::VCVTPH2PSXZ128rmk,
          6119 => Opcode::VCVTPH2PSXZ128rmkz,
          6120 => Opcode::VCVTPH2PSXZ128rr,
          6121 => Opcode::VCVTPH2PSXZ128rrk,
          6122 => Opcode::VCVTPH2PSXZ128rrkz,
          6123 => Opcode::VCVTPH2PSXZ256rm,
          6124 => Opcode::VCVTPH2PSXZ256rmb,
          6125 => Opcode::VCVTPH2PSXZ256rmbk,
          6126 => Opcode::VCVTPH2PSXZ256rmbkz,
          6127 => Opcode::VCVTPH2PSXZ256rmk,
          6128 => Opcode::VCVTPH2PSXZ256rmkz,
          6129 => Opcode::VCVTPH2PSXZ256rr,
          6130 => Opcode::VCVTPH2PSXZ256rrk,
          6131 => Opcode::VCVTPH2PSXZ256rrkz,
          6132 => Opcode::VCVTPH2PSXZrm,
          6133 => Opcode::VCVTPH2PSXZrmb,
          6134 => Opcode::VCVTPH2PSXZrmbk,
          6135 => Opcode::VCVTPH2PSXZrmbkz,
          6136 => Opcode::VCVTPH2PSXZrmk,
          6137 => Opcode::VCVTPH2PSXZrmkz,
          6138 => Opcode::VCVTPH2PSXZrr,
          6139 => Opcode::VCVTPH2PSXZrrb,
          6140 => Opcode::VCVTPH2PSXZrrbk,
          6141 => Opcode::VCVTPH2PSXZrrbkz,
          6142 => Opcode::VCVTPH2PSXZrrk,
          6143 => Opcode::VCVTPH2PSXZrrkz,
          6144 => Opcode::VCVTPH2PSYrm,
          6145 => Opcode::VCVTPH2PSYrr,
          6146 => Opcode::VCVTPH2PSZ128rm,
          6147 => Opcode::VCVTPH2PSZ128rmk,
          6148 => Opcode::VCVTPH2PSZ128rmkz,
          6149 => Opcode::VCVTPH2PSZ128rr,
          6150 => Opcode::VCVTPH2PSZ128rrk,
          6151 => Opcode::VCVTPH2PSZ128rrkz,
          6152 => Opcode::VCVTPH2PSZ256rm,
          6153 => Opcode::VCVTPH2PSZ256rmk,
          6154 => Opcode::VCVTPH2PSZ256rmkz,
          6155 => Opcode::VCVTPH2PSZ256rr,
          6156 => Opcode::VCVTPH2PSZ256rrk,
          6157 => Opcode::VCVTPH2PSZ256rrkz,
          6158 => Opcode::VCVTPH2PSZrm,
          6159 => Opcode::VCVTPH2PSZrmk,
          6160 => Opcode::VCVTPH2PSZrmkz,
          6161 => Opcode::VCVTPH2PSZrr,
          6162 => Opcode::VCVTPH2PSZrrb,
          6163 => Opcode::VCVTPH2PSZrrbk,
          6164 => Opcode::VCVTPH2PSZrrbkz,
          6165 => Opcode::VCVTPH2PSZrrk,
          6166 => Opcode::VCVTPH2PSZrrkz,
          6167 => Opcode::VCVTPH2PSrm,
          6168 => Opcode::VCVTPH2PSrr,
          6169 => Opcode::VCVTPH2QQZ128rm,
          6170 => Opcode::VCVTPH2QQZ128rmb,
          6171 => Opcode::VCVTPH2QQZ128rmbk,
          6172 => Opcode::VCVTPH2QQZ128rmbkz,
          6173 => Opcode::VCVTPH2QQZ128rmk,
          6174 => Opcode::VCVTPH2QQZ128rmkz,
          6175 => Opcode::VCVTPH2QQZ128rr,
          6176 => Opcode::VCVTPH2QQZ128rrk,
          6177 => Opcode::VCVTPH2QQZ128rrkz,
          6178 => Opcode::VCVTPH2QQZ256rm,
          6179 => Opcode::VCVTPH2QQZ256rmb,
          6180 => Opcode::VCVTPH2QQZ256rmbk,
          6181 => Opcode::VCVTPH2QQZ256rmbkz,
          6182 => Opcode::VCVTPH2QQZ256rmk,
          6183 => Opcode::VCVTPH2QQZ256rmkz,
          6184 => Opcode::VCVTPH2QQZ256rr,
          6185 => Opcode::VCVTPH2QQZ256rrk,
          6186 => Opcode::VCVTPH2QQZ256rrkz,
          6187 => Opcode::VCVTPH2QQZrm,
          6188 => Opcode::VCVTPH2QQZrmb,
          6189 => Opcode::VCVTPH2QQZrmbk,
          6190 => Opcode::VCVTPH2QQZrmbkz,
          6191 => Opcode::VCVTPH2QQZrmk,
          6192 => Opcode::VCVTPH2QQZrmkz,
          6193 => Opcode::VCVTPH2QQZrr,
          6194 => Opcode::VCVTPH2QQZrrb,
          6195 => Opcode::VCVTPH2QQZrrbk,
          6196 => Opcode::VCVTPH2QQZrrbkz,
          6197 => Opcode::VCVTPH2QQZrrk,
          6198 => Opcode::VCVTPH2QQZrrkz,
          6199 => Opcode::VCVTPH2UDQZ128rm,
          6200 => Opcode::VCVTPH2UDQZ128rmb,
          6201 => Opcode::VCVTPH2UDQZ128rmbk,
          6202 => Opcode::VCVTPH2UDQZ128rmbkz,
          6203 => Opcode::VCVTPH2UDQZ128rmk,
          6204 => Opcode::VCVTPH2UDQZ128rmkz,
          6205 => Opcode::VCVTPH2UDQZ128rr,
          6206 => Opcode::VCVTPH2UDQZ128rrk,
          6207 => Opcode::VCVTPH2UDQZ128rrkz,
          6208 => Opcode::VCVTPH2UDQZ256rm,
          6209 => Opcode::VCVTPH2UDQZ256rmb,
          6210 => Opcode::VCVTPH2UDQZ256rmbk,
          6211 => Opcode::VCVTPH2UDQZ256rmbkz,
          6212 => Opcode::VCVTPH2UDQZ256rmk,
          6213 => Opcode::VCVTPH2UDQZ256rmkz,
          6214 => Opcode::VCVTPH2UDQZ256rr,
          6215 => Opcode::VCVTPH2UDQZ256rrk,
          6216 => Opcode::VCVTPH2UDQZ256rrkz,
          6217 => Opcode::VCVTPH2UDQZrm,
          6218 => Opcode::VCVTPH2UDQZrmb,
          6219 => Opcode::VCVTPH2UDQZrmbk,
          6220 => Opcode::VCVTPH2UDQZrmbkz,
          6221 => Opcode::VCVTPH2UDQZrmk,
          6222 => Opcode::VCVTPH2UDQZrmkz,
          6223 => Opcode::VCVTPH2UDQZrr,
          6224 => Opcode::VCVTPH2UDQZrrb,
          6225 => Opcode::VCVTPH2UDQZrrbk,
          6226 => Opcode::VCVTPH2UDQZrrbkz,
          6227 => Opcode::VCVTPH2UDQZrrk,
          6228 => Opcode::VCVTPH2UDQZrrkz,
          6229 => Opcode::VCVTPH2UQQZ128rm,
          6230 => Opcode::VCVTPH2UQQZ128rmb,
          6231 => Opcode::VCVTPH2UQQZ128rmbk,
          6232 => Opcode::VCVTPH2UQQZ128rmbkz,
          6233 => Opcode::VCVTPH2UQQZ128rmk,
          6234 => Opcode::VCVTPH2UQQZ128rmkz,
          6235 => Opcode::VCVTPH2UQQZ128rr,
          6236 => Opcode::VCVTPH2UQQZ128rrk,
          6237 => Opcode::VCVTPH2UQQZ128rrkz,
          6238 => Opcode::VCVTPH2UQQZ256rm,
          6239 => Opcode::VCVTPH2UQQZ256rmb,
          6240 => Opcode::VCVTPH2UQQZ256rmbk,
          6241 => Opcode::VCVTPH2UQQZ256rmbkz,
          6242 => Opcode::VCVTPH2UQQZ256rmk,
          6243 => Opcode::VCVTPH2UQQZ256rmkz,
          6244 => Opcode::VCVTPH2UQQZ256rr,
          6245 => Opcode::VCVTPH2UQQZ256rrk,
          6246 => Opcode::VCVTPH2UQQZ256rrkz,
          6247 => Opcode::VCVTPH2UQQZrm,
          6248 => Opcode::VCVTPH2UQQZrmb,
          6249 => Opcode::VCVTPH2UQQZrmbk,
          6250 => Opcode::VCVTPH2UQQZrmbkz,
          6251 => Opcode::VCVTPH2UQQZrmk,
          6252 => Opcode::VCVTPH2UQQZrmkz,
          6253 => Opcode::VCVTPH2UQQZrr,
          6254 => Opcode::VCVTPH2UQQZrrb,
          6255 => Opcode::VCVTPH2UQQZrrbk,
          6256 => Opcode::VCVTPH2UQQZrrbkz,
          6257 => Opcode::VCVTPH2UQQZrrk,
          6258 => Opcode::VCVTPH2UQQZrrkz,
          6259 => Opcode::VCVTPH2UWZ128rm,
          6260 => Opcode::VCVTPH2UWZ128rmb,
          6261 => Opcode::VCVTPH2UWZ128rmbk,
          6262 => Opcode::VCVTPH2UWZ128rmbkz,
          6263 => Opcode::VCVTPH2UWZ128rmk,
          6264 => Opcode::VCVTPH2UWZ128rmkz,
          6265 => Opcode::VCVTPH2UWZ128rr,
          6266 => Opcode::VCVTPH2UWZ128rrk,
          6267 => Opcode::VCVTPH2UWZ128rrkz,
          6268 => Opcode::VCVTPH2UWZ256rm,
          6269 => Opcode::VCVTPH2UWZ256rmb,
          6270 => Opcode::VCVTPH2UWZ256rmbk,
          6271 => Opcode::VCVTPH2UWZ256rmbkz,
          6272 => Opcode::VCVTPH2UWZ256rmk,
          6273 => Opcode::VCVTPH2UWZ256rmkz,
          6274 => Opcode::VCVTPH2UWZ256rr,
          6275 => Opcode::VCVTPH2UWZ256rrk,
          6276 => Opcode::VCVTPH2UWZ256rrkz,
          6277 => Opcode::VCVTPH2UWZrm,
          6278 => Opcode::VCVTPH2UWZrmb,
          6279 => Opcode::VCVTPH2UWZrmbk,
          6280 => Opcode::VCVTPH2UWZrmbkz,
          6281 => Opcode::VCVTPH2UWZrmk,
          6282 => Opcode::VCVTPH2UWZrmkz,
          6283 => Opcode::VCVTPH2UWZrr,
          6284 => Opcode::VCVTPH2UWZrrb,
          6285 => Opcode::VCVTPH2UWZrrbk,
          6286 => Opcode::VCVTPH2UWZrrbkz,
          6287 => Opcode::VCVTPH2UWZrrk,
          6288 => Opcode::VCVTPH2UWZrrkz,
          6289 => Opcode::VCVTPH2WZ128rm,
          6290 => Opcode::VCVTPH2WZ128rmb,
          6291 => Opcode::VCVTPH2WZ128rmbk,
          6292 => Opcode::VCVTPH2WZ128rmbkz,
          6293 => Opcode::VCVTPH2WZ128rmk,
          6294 => Opcode::VCVTPH2WZ128rmkz,
          6295 => Opcode::VCVTPH2WZ128rr,
          6296 => Opcode::VCVTPH2WZ128rrk,
          6297 => Opcode::VCVTPH2WZ128rrkz,
          6298 => Opcode::VCVTPH2WZ256rm,
          6299 => Opcode::VCVTPH2WZ256rmb,
          6300 => Opcode::VCVTPH2WZ256rmbk,
          6301 => Opcode::VCVTPH2WZ256rmbkz,
          6302 => Opcode::VCVTPH2WZ256rmk,
          6303 => Opcode::VCVTPH2WZ256rmkz,
          6304 => Opcode::VCVTPH2WZ256rr,
          6305 => Opcode::VCVTPH2WZ256rrk,
          6306 => Opcode::VCVTPH2WZ256rrkz,
          6307 => Opcode::VCVTPH2WZrm,
          6308 => Opcode::VCVTPH2WZrmb,
          6309 => Opcode::VCVTPH2WZrmbk,
          6310 => Opcode::VCVTPH2WZrmbkz,
          6311 => Opcode::VCVTPH2WZrmk,
          6312 => Opcode::VCVTPH2WZrmkz,
          6313 => Opcode::VCVTPH2WZrr,
          6314 => Opcode::VCVTPH2WZrrb,
          6315 => Opcode::VCVTPH2WZrrbk,
          6316 => Opcode::VCVTPH2WZrrbkz,
          6317 => Opcode::VCVTPH2WZrrk,
          6318 => Opcode::VCVTPH2WZrrkz,
          6319 => Opcode::VCVTPS2DQYrm,
          6320 => Opcode::VCVTPS2DQYrr,
          6321 => Opcode::VCVTPS2DQZ128rm,
          6322 => Opcode::VCVTPS2DQZ128rmb,
          6323 => Opcode::VCVTPS2DQZ128rmbk,
          6324 => Opcode::VCVTPS2DQZ128rmbkz,
          6325 => Opcode::VCVTPS2DQZ128rmk,
          6326 => Opcode::VCVTPS2DQZ128rmkz,
          6327 => Opcode::VCVTPS2DQZ128rr,
          6328 => Opcode::VCVTPS2DQZ128rrk,
          6329 => Opcode::VCVTPS2DQZ128rrkz,
          6330 => Opcode::VCVTPS2DQZ256rm,
          6331 => Opcode::VCVTPS2DQZ256rmb,
          6332 => Opcode::VCVTPS2DQZ256rmbk,
          6333 => Opcode::VCVTPS2DQZ256rmbkz,
          6334 => Opcode::VCVTPS2DQZ256rmk,
          6335 => Opcode::VCVTPS2DQZ256rmkz,
          6336 => Opcode::VCVTPS2DQZ256rr,
          6337 => Opcode::VCVTPS2DQZ256rrk,
          6338 => Opcode::VCVTPS2DQZ256rrkz,
          6339 => Opcode::VCVTPS2DQZrm,
          6340 => Opcode::VCVTPS2DQZrmb,
          6341 => Opcode::VCVTPS2DQZrmbk,
          6342 => Opcode::VCVTPS2DQZrmbkz,
          6343 => Opcode::VCVTPS2DQZrmk,
          6344 => Opcode::VCVTPS2DQZrmkz,
          6345 => Opcode::VCVTPS2DQZrr,
          6346 => Opcode::VCVTPS2DQZrrb,
          6347 => Opcode::VCVTPS2DQZrrbk,
          6348 => Opcode::VCVTPS2DQZrrbkz,
          6349 => Opcode::VCVTPS2DQZrrk,
          6350 => Opcode::VCVTPS2DQZrrkz,
          6351 => Opcode::VCVTPS2DQrm,
          6352 => Opcode::VCVTPS2DQrr,
          6353 => Opcode::VCVTPS2PDYrm,
          6354 => Opcode::VCVTPS2PDYrr,
          6355 => Opcode::VCVTPS2PDZ128rm,
          6356 => Opcode::VCVTPS2PDZ128rmb,
          6357 => Opcode::VCVTPS2PDZ128rmbk,
          6358 => Opcode::VCVTPS2PDZ128rmbkz,
          6359 => Opcode::VCVTPS2PDZ128rmk,
          6360 => Opcode::VCVTPS2PDZ128rmkz,
          6361 => Opcode::VCVTPS2PDZ128rr,
          6362 => Opcode::VCVTPS2PDZ128rrk,
          6363 => Opcode::VCVTPS2PDZ128rrkz,
          6364 => Opcode::VCVTPS2PDZ256rm,
          6365 => Opcode::VCVTPS2PDZ256rmb,
          6366 => Opcode::VCVTPS2PDZ256rmbk,
          6367 => Opcode::VCVTPS2PDZ256rmbkz,
          6368 => Opcode::VCVTPS2PDZ256rmk,
          6369 => Opcode::VCVTPS2PDZ256rmkz,
          6370 => Opcode::VCVTPS2PDZ256rr,
          6371 => Opcode::VCVTPS2PDZ256rrk,
          6372 => Opcode::VCVTPS2PDZ256rrkz,
          6373 => Opcode::VCVTPS2PDZrm,
          6374 => Opcode::VCVTPS2PDZrmb,
          6375 => Opcode::VCVTPS2PDZrmbk,
          6376 => Opcode::VCVTPS2PDZrmbkz,
          6377 => Opcode::VCVTPS2PDZrmk,
          6378 => Opcode::VCVTPS2PDZrmkz,
          6379 => Opcode::VCVTPS2PDZrr,
          6380 => Opcode::VCVTPS2PDZrrb,
          6381 => Opcode::VCVTPS2PDZrrbk,
          6382 => Opcode::VCVTPS2PDZrrbkz,
          6383 => Opcode::VCVTPS2PDZrrk,
          6384 => Opcode::VCVTPS2PDZrrkz,
          6385 => Opcode::VCVTPS2PDrm,
          6386 => Opcode::VCVTPS2PDrr,
          6387 => Opcode::VCVTPS2PHXZ128rm,
          6388 => Opcode::VCVTPS2PHXZ128rmb,
          6389 => Opcode::VCVTPS2PHXZ128rmbk,
          6390 => Opcode::VCVTPS2PHXZ128rmbkz,
          6391 => Opcode::VCVTPS2PHXZ128rmk,
          6392 => Opcode::VCVTPS2PHXZ128rmkz,
          6393 => Opcode::VCVTPS2PHXZ128rr,
          6394 => Opcode::VCVTPS2PHXZ128rrk,
          6395 => Opcode::VCVTPS2PHXZ128rrkz,
          6396 => Opcode::VCVTPS2PHXZ256rm,
          6397 => Opcode::VCVTPS2PHXZ256rmb,
          6398 => Opcode::VCVTPS2PHXZ256rmbk,
          6399 => Opcode::VCVTPS2PHXZ256rmbkz,
          6400 => Opcode::VCVTPS2PHXZ256rmk,
          6401 => Opcode::VCVTPS2PHXZ256rmkz,
          6402 => Opcode::VCVTPS2PHXZ256rr,
          6403 => Opcode::VCVTPS2PHXZ256rrk,
          6404 => Opcode::VCVTPS2PHXZ256rrkz,
          6405 => Opcode::VCVTPS2PHXZrm,
          6406 => Opcode::VCVTPS2PHXZrmb,
          6407 => Opcode::VCVTPS2PHXZrmbk,
          6408 => Opcode::VCVTPS2PHXZrmbkz,
          6409 => Opcode::VCVTPS2PHXZrmk,
          6410 => Opcode::VCVTPS2PHXZrmkz,
          6411 => Opcode::VCVTPS2PHXZrr,
          6412 => Opcode::VCVTPS2PHXZrrb,
          6413 => Opcode::VCVTPS2PHXZrrbk,
          6414 => Opcode::VCVTPS2PHXZrrbkz,
          6415 => Opcode::VCVTPS2PHXZrrk,
          6416 => Opcode::VCVTPS2PHXZrrkz,
          6417 => Opcode::VCVTPS2PHYmr,
          6418 => Opcode::VCVTPS2PHYrr,
          6419 => Opcode::VCVTPS2PHZ128mr,
          6420 => Opcode::VCVTPS2PHZ128mrk,
          6421 => Opcode::VCVTPS2PHZ128rr,
          6422 => Opcode::VCVTPS2PHZ128rrk,
          6423 => Opcode::VCVTPS2PHZ128rrkz,
          6424 => Opcode::VCVTPS2PHZ256mr,
          6425 => Opcode::VCVTPS2PHZ256mrk,
          6426 => Opcode::VCVTPS2PHZ256rr,
          6427 => Opcode::VCVTPS2PHZ256rrk,
          6428 => Opcode::VCVTPS2PHZ256rrkz,
          6429 => Opcode::VCVTPS2PHZmr,
          6430 => Opcode::VCVTPS2PHZmrk,
          6431 => Opcode::VCVTPS2PHZrr,
          6432 => Opcode::VCVTPS2PHZrrb,
          6433 => Opcode::VCVTPS2PHZrrbk,
          6434 => Opcode::VCVTPS2PHZrrbkz,
          6435 => Opcode::VCVTPS2PHZrrk,
          6436 => Opcode::VCVTPS2PHZrrkz,
          6437 => Opcode::VCVTPS2PHmr,
          6438 => Opcode::VCVTPS2PHrr,
          6439 => Opcode::VCVTPS2QQZ128rm,
          6440 => Opcode::VCVTPS2QQZ128rmb,
          6441 => Opcode::VCVTPS2QQZ128rmbk,
          6442 => Opcode::VCVTPS2QQZ128rmbkz,
          6443 => Opcode::VCVTPS2QQZ128rmk,
          6444 => Opcode::VCVTPS2QQZ128rmkz,
          6445 => Opcode::VCVTPS2QQZ128rr,
          6446 => Opcode::VCVTPS2QQZ128rrk,
          6447 => Opcode::VCVTPS2QQZ128rrkz,
          6448 => Opcode::VCVTPS2QQZ256rm,
          6449 => Opcode::VCVTPS2QQZ256rmb,
          6450 => Opcode::VCVTPS2QQZ256rmbk,
          6451 => Opcode::VCVTPS2QQZ256rmbkz,
          6452 => Opcode::VCVTPS2QQZ256rmk,
          6453 => Opcode::VCVTPS2QQZ256rmkz,
          6454 => Opcode::VCVTPS2QQZ256rr,
          6455 => Opcode::VCVTPS2QQZ256rrk,
          6456 => Opcode::VCVTPS2QQZ256rrkz,
          6457 => Opcode::VCVTPS2QQZrm,
          6458 => Opcode::VCVTPS2QQZrmb,
          6459 => Opcode::VCVTPS2QQZrmbk,
          6460 => Opcode::VCVTPS2QQZrmbkz,
          6461 => Opcode::VCVTPS2QQZrmk,
          6462 => Opcode::VCVTPS2QQZrmkz,
          6463 => Opcode::VCVTPS2QQZrr,
          6464 => Opcode::VCVTPS2QQZrrb,
          6465 => Opcode::VCVTPS2QQZrrbk,
          6466 => Opcode::VCVTPS2QQZrrbkz,
          6467 => Opcode::VCVTPS2QQZrrk,
          6468 => Opcode::VCVTPS2QQZrrkz,
          6469 => Opcode::VCVTPS2UDQZ128rm,
          6470 => Opcode::VCVTPS2UDQZ128rmb,
          6471 => Opcode::VCVTPS2UDQZ128rmbk,
          6472 => Opcode::VCVTPS2UDQZ128rmbkz,
          6473 => Opcode::VCVTPS2UDQZ128rmk,
          6474 => Opcode::VCVTPS2UDQZ128rmkz,
          6475 => Opcode::VCVTPS2UDQZ128rr,
          6476 => Opcode::VCVTPS2UDQZ128rrk,
          6477 => Opcode::VCVTPS2UDQZ128rrkz,
          6478 => Opcode::VCVTPS2UDQZ256rm,
          6479 => Opcode::VCVTPS2UDQZ256rmb,
          6480 => Opcode::VCVTPS2UDQZ256rmbk,
          6481 => Opcode::VCVTPS2UDQZ256rmbkz,
          6482 => Opcode::VCVTPS2UDQZ256rmk,
          6483 => Opcode::VCVTPS2UDQZ256rmkz,
          6484 => Opcode::VCVTPS2UDQZ256rr,
          6485 => Opcode::VCVTPS2UDQZ256rrk,
          6486 => Opcode::VCVTPS2UDQZ256rrkz,
          6487 => Opcode::VCVTPS2UDQZrm,
          6488 => Opcode::VCVTPS2UDQZrmb,
          6489 => Opcode::VCVTPS2UDQZrmbk,
          6490 => Opcode::VCVTPS2UDQZrmbkz,
          6491 => Opcode::VCVTPS2UDQZrmk,
          6492 => Opcode::VCVTPS2UDQZrmkz,
          6493 => Opcode::VCVTPS2UDQZrr,
          6494 => Opcode::VCVTPS2UDQZrrb,
          6495 => Opcode::VCVTPS2UDQZrrbk,
          6496 => Opcode::VCVTPS2UDQZrrbkz,
          6497 => Opcode::VCVTPS2UDQZrrk,
          6498 => Opcode::VCVTPS2UDQZrrkz,
          6499 => Opcode::VCVTPS2UQQZ128rm,
          6500 => Opcode::VCVTPS2UQQZ128rmb,
          6501 => Opcode::VCVTPS2UQQZ128rmbk,
          6502 => Opcode::VCVTPS2UQQZ128rmbkz,
          6503 => Opcode::VCVTPS2UQQZ128rmk,
          6504 => Opcode::VCVTPS2UQQZ128rmkz,
          6505 => Opcode::VCVTPS2UQQZ128rr,
          6506 => Opcode::VCVTPS2UQQZ128rrk,
          6507 => Opcode::VCVTPS2UQQZ128rrkz,
          6508 => Opcode::VCVTPS2UQQZ256rm,
          6509 => Opcode::VCVTPS2UQQZ256rmb,
          6510 => Opcode::VCVTPS2UQQZ256rmbk,
          6511 => Opcode::VCVTPS2UQQZ256rmbkz,
          6512 => Opcode::VCVTPS2UQQZ256rmk,
          6513 => Opcode::VCVTPS2UQQZ256rmkz,
          6514 => Opcode::VCVTPS2UQQZ256rr,
          6515 => Opcode::VCVTPS2UQQZ256rrk,
          6516 => Opcode::VCVTPS2UQQZ256rrkz,
          6517 => Opcode::VCVTPS2UQQZrm,
          6518 => Opcode::VCVTPS2UQQZrmb,
          6519 => Opcode::VCVTPS2UQQZrmbk,
          6520 => Opcode::VCVTPS2UQQZrmbkz,
          6521 => Opcode::VCVTPS2UQQZrmk,
          6522 => Opcode::VCVTPS2UQQZrmkz,
          6523 => Opcode::VCVTPS2UQQZrr,
          6524 => Opcode::VCVTPS2UQQZrrb,
          6525 => Opcode::VCVTPS2UQQZrrbk,
          6526 => Opcode::VCVTPS2UQQZrrbkz,
          6527 => Opcode::VCVTPS2UQQZrrk,
          6528 => Opcode::VCVTPS2UQQZrrkz,
          6529 => Opcode::VCVTQQ2PDZ128rm,
          6530 => Opcode::VCVTQQ2PDZ128rmb,
          6531 => Opcode::VCVTQQ2PDZ128rmbk,
          6532 => Opcode::VCVTQQ2PDZ128rmbkz,
          6533 => Opcode::VCVTQQ2PDZ128rmk,
          6534 => Opcode::VCVTQQ2PDZ128rmkz,
          6535 => Opcode::VCVTQQ2PDZ128rr,
          6536 => Opcode::VCVTQQ2PDZ128rrk,
          6537 => Opcode::VCVTQQ2PDZ128rrkz,
          6538 => Opcode::VCVTQQ2PDZ256rm,
          6539 => Opcode::VCVTQQ2PDZ256rmb,
          6540 => Opcode::VCVTQQ2PDZ256rmbk,
          6541 => Opcode::VCVTQQ2PDZ256rmbkz,
          6542 => Opcode::VCVTQQ2PDZ256rmk,
          6543 => Opcode::VCVTQQ2PDZ256rmkz,
          6544 => Opcode::VCVTQQ2PDZ256rr,
          6545 => Opcode::VCVTQQ2PDZ256rrk,
          6546 => Opcode::VCVTQQ2PDZ256rrkz,
          6547 => Opcode::VCVTQQ2PDZrm,
          6548 => Opcode::VCVTQQ2PDZrmb,
          6549 => Opcode::VCVTQQ2PDZrmbk,
          6550 => Opcode::VCVTQQ2PDZrmbkz,
          6551 => Opcode::VCVTQQ2PDZrmk,
          6552 => Opcode::VCVTQQ2PDZrmkz,
          6553 => Opcode::VCVTQQ2PDZrr,
          6554 => Opcode::VCVTQQ2PDZrrb,
          6555 => Opcode::VCVTQQ2PDZrrbk,
          6556 => Opcode::VCVTQQ2PDZrrbkz,
          6557 => Opcode::VCVTQQ2PDZrrk,
          6558 => Opcode::VCVTQQ2PDZrrkz,
          6559 => Opcode::VCVTQQ2PHZ128rm,
          6560 => Opcode::VCVTQQ2PHZ128rmb,
          6561 => Opcode::VCVTQQ2PHZ128rmbk,
          6562 => Opcode::VCVTQQ2PHZ128rmbkz,
          6563 => Opcode::VCVTQQ2PHZ128rmk,
          6564 => Opcode::VCVTQQ2PHZ128rmkz,
          6565 => Opcode::VCVTQQ2PHZ128rr,
          6566 => Opcode::VCVTQQ2PHZ128rrk,
          6567 => Opcode::VCVTQQ2PHZ128rrkz,
          6568 => Opcode::VCVTQQ2PHZ256rm,
          6569 => Opcode::VCVTQQ2PHZ256rmb,
          6570 => Opcode::VCVTQQ2PHZ256rmbk,
          6571 => Opcode::VCVTQQ2PHZ256rmbkz,
          6572 => Opcode::VCVTQQ2PHZ256rmk,
          6573 => Opcode::VCVTQQ2PHZ256rmkz,
          6574 => Opcode::VCVTQQ2PHZ256rr,
          6575 => Opcode::VCVTQQ2PHZ256rrk,
          6576 => Opcode::VCVTQQ2PHZ256rrkz,
          6577 => Opcode::VCVTQQ2PHZrm,
          6578 => Opcode::VCVTQQ2PHZrmb,
          6579 => Opcode::VCVTQQ2PHZrmbk,
          6580 => Opcode::VCVTQQ2PHZrmbkz,
          6581 => Opcode::VCVTQQ2PHZrmk,
          6582 => Opcode::VCVTQQ2PHZrmkz,
          6583 => Opcode::VCVTQQ2PHZrr,
          6584 => Opcode::VCVTQQ2PHZrrb,
          6585 => Opcode::VCVTQQ2PHZrrbk,
          6586 => Opcode::VCVTQQ2PHZrrbkz,
          6587 => Opcode::VCVTQQ2PHZrrk,
          6588 => Opcode::VCVTQQ2PHZrrkz,
          6589 => Opcode::VCVTQQ2PSZ128rm,
          6590 => Opcode::VCVTQQ2PSZ128rmb,
          6591 => Opcode::VCVTQQ2PSZ128rmbk,
          6592 => Opcode::VCVTQQ2PSZ128rmbkz,
          6593 => Opcode::VCVTQQ2PSZ128rmk,
          6594 => Opcode::VCVTQQ2PSZ128rmkz,
          6595 => Opcode::VCVTQQ2PSZ128rr,
          6596 => Opcode::VCVTQQ2PSZ128rrk,
          6597 => Opcode::VCVTQQ2PSZ128rrkz,
          6598 => Opcode::VCVTQQ2PSZ256rm,
          6599 => Opcode::VCVTQQ2PSZ256rmb,
          6600 => Opcode::VCVTQQ2PSZ256rmbk,
          6601 => Opcode::VCVTQQ2PSZ256rmbkz,
          6602 => Opcode::VCVTQQ2PSZ256rmk,
          6603 => Opcode::VCVTQQ2PSZ256rmkz,
          6604 => Opcode::VCVTQQ2PSZ256rr,
          6605 => Opcode::VCVTQQ2PSZ256rrk,
          6606 => Opcode::VCVTQQ2PSZ256rrkz,
          6607 => Opcode::VCVTQQ2PSZrm,
          6608 => Opcode::VCVTQQ2PSZrmb,
          6609 => Opcode::VCVTQQ2PSZrmbk,
          6610 => Opcode::VCVTQQ2PSZrmbkz,
          6611 => Opcode::VCVTQQ2PSZrmk,
          6612 => Opcode::VCVTQQ2PSZrmkz,
          6613 => Opcode::VCVTQQ2PSZrr,
          6614 => Opcode::VCVTQQ2PSZrrb,
          6615 => Opcode::VCVTQQ2PSZrrbk,
          6616 => Opcode::VCVTQQ2PSZrrbkz,
          6617 => Opcode::VCVTQQ2PSZrrk,
          6618 => Opcode::VCVTQQ2PSZrrkz,
          6619 => Opcode::VCVTSD2SHZrm,
          6620 => Opcode::VCVTSD2SHZrm_Int,
          6621 => Opcode::VCVTSD2SHZrm_Intk,
          6622 => Opcode::VCVTSD2SHZrm_Intkz,
          6623 => Opcode::VCVTSD2SHZrr,
          6624 => Opcode::VCVTSD2SHZrr_Int,
          6625 => Opcode::VCVTSD2SHZrr_Intk,
          6626 => Opcode::VCVTSD2SHZrr_Intkz,
          6627 => Opcode::VCVTSD2SHZrrb_Int,
          6628 => Opcode::VCVTSD2SHZrrb_Intk,
          6629 => Opcode::VCVTSD2SHZrrb_Intkz,
          6630 => Opcode::VCVTSD2SI64Zrm,
          6631 => Opcode::VCVTSD2SI64Zrm_Int,
          6632 => Opcode::VCVTSD2SI64Zrr,
          6633 => Opcode::VCVTSD2SI64Zrr_Int,
          6634 => Opcode::VCVTSD2SI64Zrrb_Int,
          6635 => Opcode::VCVTSD2SI64rm,
          6636 => Opcode::VCVTSD2SI64rm_Int,
          6637 => Opcode::VCVTSD2SI64rr,
          6638 => Opcode::VCVTSD2SI64rr_Int,
          6639 => Opcode::VCVTSD2SIZrm,
          6640 => Opcode::VCVTSD2SIZrm_Int,
          6641 => Opcode::VCVTSD2SIZrr,
          6642 => Opcode::VCVTSD2SIZrr_Int,
          6643 => Opcode::VCVTSD2SIZrrb_Int,
          6644 => Opcode::VCVTSD2SIrm,
          6645 => Opcode::VCVTSD2SIrm_Int,
          6646 => Opcode::VCVTSD2SIrr,
          6647 => Opcode::VCVTSD2SIrr_Int,
          6648 => Opcode::VCVTSD2SSZrm,
          6649 => Opcode::VCVTSD2SSZrm_Int,
          6650 => Opcode::VCVTSD2SSZrm_Intk,
          6651 => Opcode::VCVTSD2SSZrm_Intkz,
          6652 => Opcode::VCVTSD2SSZrr,
          6653 => Opcode::VCVTSD2SSZrr_Int,
          6654 => Opcode::VCVTSD2SSZrr_Intk,
          6655 => Opcode::VCVTSD2SSZrr_Intkz,
          6656 => Opcode::VCVTSD2SSZrrb_Int,
          6657 => Opcode::VCVTSD2SSZrrb_Intk,
          6658 => Opcode::VCVTSD2SSZrrb_Intkz,
          6659 => Opcode::VCVTSD2SSrm,
          6660 => Opcode::VCVTSD2SSrm_Int,
          6661 => Opcode::VCVTSD2SSrr,
          6662 => Opcode::VCVTSD2SSrr_Int,
          6663 => Opcode::VCVTSD2USI64Zrm_Int,
          6664 => Opcode::VCVTSD2USI64Zrr_Int,
          6665 => Opcode::VCVTSD2USI64Zrrb_Int,
          6666 => Opcode::VCVTSD2USIZrm_Int,
          6667 => Opcode::VCVTSD2USIZrr_Int,
          6668 => Opcode::VCVTSD2USIZrrb_Int,
          6669 => Opcode::VCVTSH2SDZrm,
          6670 => Opcode::VCVTSH2SDZrm_Int,
          6671 => Opcode::VCVTSH2SDZrm_Intk,
          6672 => Opcode::VCVTSH2SDZrm_Intkz,
          6673 => Opcode::VCVTSH2SDZrr,
          6674 => Opcode::VCVTSH2SDZrr_Int,
          6675 => Opcode::VCVTSH2SDZrr_Intk,
          6676 => Opcode::VCVTSH2SDZrr_Intkz,
          6677 => Opcode::VCVTSH2SDZrrb_Int,
          6678 => Opcode::VCVTSH2SDZrrb_Intk,
          6679 => Opcode::VCVTSH2SDZrrb_Intkz,
          6680 => Opcode::VCVTSH2SI64Zrm_Int,
          6681 => Opcode::VCVTSH2SI64Zrr_Int,
          6682 => Opcode::VCVTSH2SI64Zrrb_Int,
          6683 => Opcode::VCVTSH2SIZrm_Int,
          6684 => Opcode::VCVTSH2SIZrr_Int,
          6685 => Opcode::VCVTSH2SIZrrb_Int,
          6686 => Opcode::VCVTSH2SSZrm,
          6687 => Opcode::VCVTSH2SSZrm_Int,
          6688 => Opcode::VCVTSH2SSZrm_Intk,
          6689 => Opcode::VCVTSH2SSZrm_Intkz,
          6690 => Opcode::VCVTSH2SSZrr,
          6691 => Opcode::VCVTSH2SSZrr_Int,
          6692 => Opcode::VCVTSH2SSZrr_Intk,
          6693 => Opcode::VCVTSH2SSZrr_Intkz,
          6694 => Opcode::VCVTSH2SSZrrb_Int,
          6695 => Opcode::VCVTSH2SSZrrb_Intk,
          6696 => Opcode::VCVTSH2SSZrrb_Intkz,
          6697 => Opcode::VCVTSH2USI64Zrm_Int,
          6698 => Opcode::VCVTSH2USI64Zrr_Int,
          6699 => Opcode::VCVTSH2USI64Zrrb_Int,
          6700 => Opcode::VCVTSH2USIZrm_Int,
          6701 => Opcode::VCVTSH2USIZrr_Int,
          6702 => Opcode::VCVTSH2USIZrrb_Int,
          6703 => Opcode::VCVTSI2SDZrm,
          6704 => Opcode::VCVTSI2SDZrm_Int,
          6705 => Opcode::VCVTSI2SDZrr,
          6706 => Opcode::VCVTSI2SDZrr_Int,
          6707 => Opcode::VCVTSI2SDrm,
          6708 => Opcode::VCVTSI2SDrm_Int,
          6709 => Opcode::VCVTSI2SDrr,
          6710 => Opcode::VCVTSI2SDrr_Int,
          6711 => Opcode::VCVTSI2SHZrm,
          6712 => Opcode::VCVTSI2SHZrm_Int,
          6713 => Opcode::VCVTSI2SHZrr,
          6714 => Opcode::VCVTSI2SHZrr_Int,
          6715 => Opcode::VCVTSI2SHZrrb_Int,
          6716 => Opcode::VCVTSI2SSZrm,
          6717 => Opcode::VCVTSI2SSZrm_Int,
          6718 => Opcode::VCVTSI2SSZrr,
          6719 => Opcode::VCVTSI2SSZrr_Int,
          6720 => Opcode::VCVTSI2SSZrrb_Int,
          6721 => Opcode::VCVTSI2SSrm,
          6722 => Opcode::VCVTSI2SSrm_Int,
          6723 => Opcode::VCVTSI2SSrr,
          6724 => Opcode::VCVTSI2SSrr_Int,
          6725 => Opcode::VCVTSI642SDZrm,
          6726 => Opcode::VCVTSI642SDZrm_Int,
          6727 => Opcode::VCVTSI642SDZrr,
          6728 => Opcode::VCVTSI642SDZrr_Int,
          6729 => Opcode::VCVTSI642SDZrrb_Int,
          6730 => Opcode::VCVTSI642SDrm,
          6731 => Opcode::VCVTSI642SDrm_Int,
          6732 => Opcode::VCVTSI642SDrr,
          6733 => Opcode::VCVTSI642SDrr_Int,
          6734 => Opcode::VCVTSI642SHZrm,
          6735 => Opcode::VCVTSI642SHZrm_Int,
          6736 => Opcode::VCVTSI642SHZrr,
          6737 => Opcode::VCVTSI642SHZrr_Int,
          6738 => Opcode::VCVTSI642SHZrrb_Int,
          6739 => Opcode::VCVTSI642SSZrm,
          6740 => Opcode::VCVTSI642SSZrm_Int,
          6741 => Opcode::VCVTSI642SSZrr,
          6742 => Opcode::VCVTSI642SSZrr_Int,
          6743 => Opcode::VCVTSI642SSZrrb_Int,
          6744 => Opcode::VCVTSI642SSrm,
          6745 => Opcode::VCVTSI642SSrm_Int,
          6746 => Opcode::VCVTSI642SSrr,
          6747 => Opcode::VCVTSI642SSrr_Int,
          6748 => Opcode::VCVTSS2SDZrm,
          6749 => Opcode::VCVTSS2SDZrm_Int,
          6750 => Opcode::VCVTSS2SDZrm_Intk,
          6751 => Opcode::VCVTSS2SDZrm_Intkz,
          6752 => Opcode::VCVTSS2SDZrr,
          6753 => Opcode::VCVTSS2SDZrr_Int,
          6754 => Opcode::VCVTSS2SDZrr_Intk,
          6755 => Opcode::VCVTSS2SDZrr_Intkz,
          6756 => Opcode::VCVTSS2SDZrrb_Int,
          6757 => Opcode::VCVTSS2SDZrrb_Intk,
          6758 => Opcode::VCVTSS2SDZrrb_Intkz,
          6759 => Opcode::VCVTSS2SDrm,
          6760 => Opcode::VCVTSS2SDrm_Int,
          6761 => Opcode::VCVTSS2SDrr,
          6762 => Opcode::VCVTSS2SDrr_Int,
          6763 => Opcode::VCVTSS2SHZrm,
          6764 => Opcode::VCVTSS2SHZrm_Int,
          6765 => Opcode::VCVTSS2SHZrm_Intk,
          6766 => Opcode::VCVTSS2SHZrm_Intkz,
          6767 => Opcode::VCVTSS2SHZrr,
          6768 => Opcode::VCVTSS2SHZrr_Int,
          6769 => Opcode::VCVTSS2SHZrr_Intk,
          6770 => Opcode::VCVTSS2SHZrr_Intkz,
          6771 => Opcode::VCVTSS2SHZrrb_Int,
          6772 => Opcode::VCVTSS2SHZrrb_Intk,
          6773 => Opcode::VCVTSS2SHZrrb_Intkz,
          6774 => Opcode::VCVTSS2SI64Zrm,
          6775 => Opcode::VCVTSS2SI64Zrm_Int,
          6776 => Opcode::VCVTSS2SI64Zrr,
          6777 => Opcode::VCVTSS2SI64Zrr_Int,
          6778 => Opcode::VCVTSS2SI64Zrrb_Int,
          6779 => Opcode::VCVTSS2SI64rm,
          6780 => Opcode::VCVTSS2SI64rm_Int,
          6781 => Opcode::VCVTSS2SI64rr,
          6782 => Opcode::VCVTSS2SI64rr_Int,
          6783 => Opcode::VCVTSS2SIZrm,
          6784 => Opcode::VCVTSS2SIZrm_Int,
          6785 => Opcode::VCVTSS2SIZrr,
          6786 => Opcode::VCVTSS2SIZrr_Int,
          6787 => Opcode::VCVTSS2SIZrrb_Int,
          6788 => Opcode::VCVTSS2SIrm,
          6789 => Opcode::VCVTSS2SIrm_Int,
          6790 => Opcode::VCVTSS2SIrr,
          6791 => Opcode::VCVTSS2SIrr_Int,
          6792 => Opcode::VCVTSS2USI64Zrm_Int,
          6793 => Opcode::VCVTSS2USI64Zrr_Int,
          6794 => Opcode::VCVTSS2USI64Zrrb_Int,
          6795 => Opcode::VCVTSS2USIZrm_Int,
          6796 => Opcode::VCVTSS2USIZrr_Int,
          6797 => Opcode::VCVTSS2USIZrrb_Int,
          6798 => Opcode::VCVTTPD2DQYrm,
          6799 => Opcode::VCVTTPD2DQYrr,
          6800 => Opcode::VCVTTPD2DQZ128rm,
          6801 => Opcode::VCVTTPD2DQZ128rmb,
          6802 => Opcode::VCVTTPD2DQZ128rmbk,
          6803 => Opcode::VCVTTPD2DQZ128rmbkz,
          6804 => Opcode::VCVTTPD2DQZ128rmk,
          6805 => Opcode::VCVTTPD2DQZ128rmkz,
          6806 => Opcode::VCVTTPD2DQZ128rr,
          6807 => Opcode::VCVTTPD2DQZ128rrk,
          6808 => Opcode::VCVTTPD2DQZ128rrkz,
          6809 => Opcode::VCVTTPD2DQZ256rm,
          6810 => Opcode::VCVTTPD2DQZ256rmb,
          6811 => Opcode::VCVTTPD2DQZ256rmbk,
          6812 => Opcode::VCVTTPD2DQZ256rmbkz,
          6813 => Opcode::VCVTTPD2DQZ256rmk,
          6814 => Opcode::VCVTTPD2DQZ256rmkz,
          6815 => Opcode::VCVTTPD2DQZ256rr,
          6816 => Opcode::VCVTTPD2DQZ256rrk,
          6817 => Opcode::VCVTTPD2DQZ256rrkz,
          6818 => Opcode::VCVTTPD2DQZrm,
          6819 => Opcode::VCVTTPD2DQZrmb,
          6820 => Opcode::VCVTTPD2DQZrmbk,
          6821 => Opcode::VCVTTPD2DQZrmbkz,
          6822 => Opcode::VCVTTPD2DQZrmk,
          6823 => Opcode::VCVTTPD2DQZrmkz,
          6824 => Opcode::VCVTTPD2DQZrr,
          6825 => Opcode::VCVTTPD2DQZrrb,
          6826 => Opcode::VCVTTPD2DQZrrbk,
          6827 => Opcode::VCVTTPD2DQZrrbkz,
          6828 => Opcode::VCVTTPD2DQZrrk,
          6829 => Opcode::VCVTTPD2DQZrrkz,
          6830 => Opcode::VCVTTPD2DQrm,
          6831 => Opcode::VCVTTPD2DQrr,
          6832 => Opcode::VCVTTPD2QQZ128rm,
          6833 => Opcode::VCVTTPD2QQZ128rmb,
          6834 => Opcode::VCVTTPD2QQZ128rmbk,
          6835 => Opcode::VCVTTPD2QQZ128rmbkz,
          6836 => Opcode::VCVTTPD2QQZ128rmk,
          6837 => Opcode::VCVTTPD2QQZ128rmkz,
          6838 => Opcode::VCVTTPD2QQZ128rr,
          6839 => Opcode::VCVTTPD2QQZ128rrk,
          6840 => Opcode::VCVTTPD2QQZ128rrkz,
          6841 => Opcode::VCVTTPD2QQZ256rm,
          6842 => Opcode::VCVTTPD2QQZ256rmb,
          6843 => Opcode::VCVTTPD2QQZ256rmbk,
          6844 => Opcode::VCVTTPD2QQZ256rmbkz,
          6845 => Opcode::VCVTTPD2QQZ256rmk,
          6846 => Opcode::VCVTTPD2QQZ256rmkz,
          6847 => Opcode::VCVTTPD2QQZ256rr,
          6848 => Opcode::VCVTTPD2QQZ256rrk,
          6849 => Opcode::VCVTTPD2QQZ256rrkz,
          6850 => Opcode::VCVTTPD2QQZrm,
          6851 => Opcode::VCVTTPD2QQZrmb,
          6852 => Opcode::VCVTTPD2QQZrmbk,
          6853 => Opcode::VCVTTPD2QQZrmbkz,
          6854 => Opcode::VCVTTPD2QQZrmk,
          6855 => Opcode::VCVTTPD2QQZrmkz,
          6856 => Opcode::VCVTTPD2QQZrr,
          6857 => Opcode::VCVTTPD2QQZrrb,
          6858 => Opcode::VCVTTPD2QQZrrbk,
          6859 => Opcode::VCVTTPD2QQZrrbkz,
          6860 => Opcode::VCVTTPD2QQZrrk,
          6861 => Opcode::VCVTTPD2QQZrrkz,
          6862 => Opcode::VCVTTPD2UDQZ128rm,
          6863 => Opcode::VCVTTPD2UDQZ128rmb,
          6864 => Opcode::VCVTTPD2UDQZ128rmbk,
          6865 => Opcode::VCVTTPD2UDQZ128rmbkz,
          6866 => Opcode::VCVTTPD2UDQZ128rmk,
          6867 => Opcode::VCVTTPD2UDQZ128rmkz,
          6868 => Opcode::VCVTTPD2UDQZ128rr,
          6869 => Opcode::VCVTTPD2UDQZ128rrk,
          6870 => Opcode::VCVTTPD2UDQZ128rrkz,
          6871 => Opcode::VCVTTPD2UDQZ256rm,
          6872 => Opcode::VCVTTPD2UDQZ256rmb,
          6873 => Opcode::VCVTTPD2UDQZ256rmbk,
          6874 => Opcode::VCVTTPD2UDQZ256rmbkz,
          6875 => Opcode::VCVTTPD2UDQZ256rmk,
          6876 => Opcode::VCVTTPD2UDQZ256rmkz,
          6877 => Opcode::VCVTTPD2UDQZ256rr,
          6878 => Opcode::VCVTTPD2UDQZ256rrk,
          6879 => Opcode::VCVTTPD2UDQZ256rrkz,
          6880 => Opcode::VCVTTPD2UDQZrm,
          6881 => Opcode::VCVTTPD2UDQZrmb,
          6882 => Opcode::VCVTTPD2UDQZrmbk,
          6883 => Opcode::VCVTTPD2UDQZrmbkz,
          6884 => Opcode::VCVTTPD2UDQZrmk,
          6885 => Opcode::VCVTTPD2UDQZrmkz,
          6886 => Opcode::VCVTTPD2UDQZrr,
          6887 => Opcode::VCVTTPD2UDQZrrb,
          6888 => Opcode::VCVTTPD2UDQZrrbk,
          6889 => Opcode::VCVTTPD2UDQZrrbkz,
          6890 => Opcode::VCVTTPD2UDQZrrk,
          6891 => Opcode::VCVTTPD2UDQZrrkz,
          6892 => Opcode::VCVTTPD2UQQZ128rm,
          6893 => Opcode::VCVTTPD2UQQZ128rmb,
          6894 => Opcode::VCVTTPD2UQQZ128rmbk,
          6895 => Opcode::VCVTTPD2UQQZ128rmbkz,
          6896 => Opcode::VCVTTPD2UQQZ128rmk,
          6897 => Opcode::VCVTTPD2UQQZ128rmkz,
          6898 => Opcode::VCVTTPD2UQQZ128rr,
          6899 => Opcode::VCVTTPD2UQQZ128rrk,
          6900 => Opcode::VCVTTPD2UQQZ128rrkz,
          6901 => Opcode::VCVTTPD2UQQZ256rm,
          6902 => Opcode::VCVTTPD2UQQZ256rmb,
          6903 => Opcode::VCVTTPD2UQQZ256rmbk,
          6904 => Opcode::VCVTTPD2UQQZ256rmbkz,
          6905 => Opcode::VCVTTPD2UQQZ256rmk,
          6906 => Opcode::VCVTTPD2UQQZ256rmkz,
          6907 => Opcode::VCVTTPD2UQQZ256rr,
          6908 => Opcode::VCVTTPD2UQQZ256rrk,
          6909 => Opcode::VCVTTPD2UQQZ256rrkz,
          6910 => Opcode::VCVTTPD2UQQZrm,
          6911 => Opcode::VCVTTPD2UQQZrmb,
          6912 => Opcode::VCVTTPD2UQQZrmbk,
          6913 => Opcode::VCVTTPD2UQQZrmbkz,
          6914 => Opcode::VCVTTPD2UQQZrmk,
          6915 => Opcode::VCVTTPD2UQQZrmkz,
          6916 => Opcode::VCVTTPD2UQQZrr,
          6917 => Opcode::VCVTTPD2UQQZrrb,
          6918 => Opcode::VCVTTPD2UQQZrrbk,
          6919 => Opcode::VCVTTPD2UQQZrrbkz,
          6920 => Opcode::VCVTTPD2UQQZrrk,
          6921 => Opcode::VCVTTPD2UQQZrrkz,
          6922 => Opcode::VCVTTPH2DQZ128rm,
          6923 => Opcode::VCVTTPH2DQZ128rmb,
          6924 => Opcode::VCVTTPH2DQZ128rmbk,
          6925 => Opcode::VCVTTPH2DQZ128rmbkz,
          6926 => Opcode::VCVTTPH2DQZ128rmk,
          6927 => Opcode::VCVTTPH2DQZ128rmkz,
          6928 => Opcode::VCVTTPH2DQZ128rr,
          6929 => Opcode::VCVTTPH2DQZ128rrk,
          6930 => Opcode::VCVTTPH2DQZ128rrkz,
          6931 => Opcode::VCVTTPH2DQZ256rm,
          6932 => Opcode::VCVTTPH2DQZ256rmb,
          6933 => Opcode::VCVTTPH2DQZ256rmbk,
          6934 => Opcode::VCVTTPH2DQZ256rmbkz,
          6935 => Opcode::VCVTTPH2DQZ256rmk,
          6936 => Opcode::VCVTTPH2DQZ256rmkz,
          6937 => Opcode::VCVTTPH2DQZ256rr,
          6938 => Opcode::VCVTTPH2DQZ256rrk,
          6939 => Opcode::VCVTTPH2DQZ256rrkz,
          6940 => Opcode::VCVTTPH2DQZrm,
          6941 => Opcode::VCVTTPH2DQZrmb,
          6942 => Opcode::VCVTTPH2DQZrmbk,
          6943 => Opcode::VCVTTPH2DQZrmbkz,
          6944 => Opcode::VCVTTPH2DQZrmk,
          6945 => Opcode::VCVTTPH2DQZrmkz,
          6946 => Opcode::VCVTTPH2DQZrr,
          6947 => Opcode::VCVTTPH2DQZrrb,
          6948 => Opcode::VCVTTPH2DQZrrbk,
          6949 => Opcode::VCVTTPH2DQZrrbkz,
          6950 => Opcode::VCVTTPH2DQZrrk,
          6951 => Opcode::VCVTTPH2DQZrrkz,
          6952 => Opcode::VCVTTPH2QQZ128rm,
          6953 => Opcode::VCVTTPH2QQZ128rmb,
          6954 => Opcode::VCVTTPH2QQZ128rmbk,
          6955 => Opcode::VCVTTPH2QQZ128rmbkz,
          6956 => Opcode::VCVTTPH2QQZ128rmk,
          6957 => Opcode::VCVTTPH2QQZ128rmkz,
          6958 => Opcode::VCVTTPH2QQZ128rr,
          6959 => Opcode::VCVTTPH2QQZ128rrk,
          6960 => Opcode::VCVTTPH2QQZ128rrkz,
          6961 => Opcode::VCVTTPH2QQZ256rm,
          6962 => Opcode::VCVTTPH2QQZ256rmb,
          6963 => Opcode::VCVTTPH2QQZ256rmbk,
          6964 => Opcode::VCVTTPH2QQZ256rmbkz,
          6965 => Opcode::VCVTTPH2QQZ256rmk,
          6966 => Opcode::VCVTTPH2QQZ256rmkz,
          6967 => Opcode::VCVTTPH2QQZ256rr,
          6968 => Opcode::VCVTTPH2QQZ256rrk,
          6969 => Opcode::VCVTTPH2QQZ256rrkz,
          6970 => Opcode::VCVTTPH2QQZrm,
          6971 => Opcode::VCVTTPH2QQZrmb,
          6972 => Opcode::VCVTTPH2QQZrmbk,
          6973 => Opcode::VCVTTPH2QQZrmbkz,
          6974 => Opcode::VCVTTPH2QQZrmk,
          6975 => Opcode::VCVTTPH2QQZrmkz,
          6976 => Opcode::VCVTTPH2QQZrr,
          6977 => Opcode::VCVTTPH2QQZrrb,
          6978 => Opcode::VCVTTPH2QQZrrbk,
          6979 => Opcode::VCVTTPH2QQZrrbkz,
          6980 => Opcode::VCVTTPH2QQZrrk,
          6981 => Opcode::VCVTTPH2QQZrrkz,
          6982 => Opcode::VCVTTPH2UDQZ128rm,
          6983 => Opcode::VCVTTPH2UDQZ128rmb,
          6984 => Opcode::VCVTTPH2UDQZ128rmbk,
          6985 => Opcode::VCVTTPH2UDQZ128rmbkz,
          6986 => Opcode::VCVTTPH2UDQZ128rmk,
          6987 => Opcode::VCVTTPH2UDQZ128rmkz,
          6988 => Opcode::VCVTTPH2UDQZ128rr,
          6989 => Opcode::VCVTTPH2UDQZ128rrk,
          6990 => Opcode::VCVTTPH2UDQZ128rrkz,
          6991 => Opcode::VCVTTPH2UDQZ256rm,
          6992 => Opcode::VCVTTPH2UDQZ256rmb,
          6993 => Opcode::VCVTTPH2UDQZ256rmbk,
          6994 => Opcode::VCVTTPH2UDQZ256rmbkz,
          6995 => Opcode::VCVTTPH2UDQZ256rmk,
          6996 => Opcode::VCVTTPH2UDQZ256rmkz,
          6997 => Opcode::VCVTTPH2UDQZ256rr,
          6998 => Opcode::VCVTTPH2UDQZ256rrk,
          6999 => Opcode::VCVTTPH2UDQZ256rrkz,
          7000 => Opcode::VCVTTPH2UDQZrm,
          7001 => Opcode::VCVTTPH2UDQZrmb,
          7002 => Opcode::VCVTTPH2UDQZrmbk,
          7003 => Opcode::VCVTTPH2UDQZrmbkz,
          7004 => Opcode::VCVTTPH2UDQZrmk,
          7005 => Opcode::VCVTTPH2UDQZrmkz,
          7006 => Opcode::VCVTTPH2UDQZrr,
          7007 => Opcode::VCVTTPH2UDQZrrb,
          7008 => Opcode::VCVTTPH2UDQZrrbk,
          7009 => Opcode::VCVTTPH2UDQZrrbkz,
          7010 => Opcode::VCVTTPH2UDQZrrk,
          7011 => Opcode::VCVTTPH2UDQZrrkz,
          7012 => Opcode::VCVTTPH2UQQZ128rm,
          7013 => Opcode::VCVTTPH2UQQZ128rmb,
          7014 => Opcode::VCVTTPH2UQQZ128rmbk,
          7015 => Opcode::VCVTTPH2UQQZ128rmbkz,
          7016 => Opcode::VCVTTPH2UQQZ128rmk,
          7017 => Opcode::VCVTTPH2UQQZ128rmkz,
          7018 => Opcode::VCVTTPH2UQQZ128rr,
          7019 => Opcode::VCVTTPH2UQQZ128rrk,
          7020 => Opcode::VCVTTPH2UQQZ128rrkz,
          7021 => Opcode::VCVTTPH2UQQZ256rm,
          7022 => Opcode::VCVTTPH2UQQZ256rmb,
          7023 => Opcode::VCVTTPH2UQQZ256rmbk,
          7024 => Opcode::VCVTTPH2UQQZ256rmbkz,
          7025 => Opcode::VCVTTPH2UQQZ256rmk,
          7026 => Opcode::VCVTTPH2UQQZ256rmkz,
          7027 => Opcode::VCVTTPH2UQQZ256rr,
          7028 => Opcode::VCVTTPH2UQQZ256rrk,
          7029 => Opcode::VCVTTPH2UQQZ256rrkz,
          7030 => Opcode::VCVTTPH2UQQZrm,
          7031 => Opcode::VCVTTPH2UQQZrmb,
          7032 => Opcode::VCVTTPH2UQQZrmbk,
          7033 => Opcode::VCVTTPH2UQQZrmbkz,
          7034 => Opcode::VCVTTPH2UQQZrmk,
          7035 => Opcode::VCVTTPH2UQQZrmkz,
          7036 => Opcode::VCVTTPH2UQQZrr,
          7037 => Opcode::VCVTTPH2UQQZrrb,
          7038 => Opcode::VCVTTPH2UQQZrrbk,
          7039 => Opcode::VCVTTPH2UQQZrrbkz,
          7040 => Opcode::VCVTTPH2UQQZrrk,
          7041 => Opcode::VCVTTPH2UQQZrrkz,
          7042 => Opcode::VCVTTPH2UWZ128rm,
          7043 => Opcode::VCVTTPH2UWZ128rmb,
          7044 => Opcode::VCVTTPH2UWZ128rmbk,
          7045 => Opcode::VCVTTPH2UWZ128rmbkz,
          7046 => Opcode::VCVTTPH2UWZ128rmk,
          7047 => Opcode::VCVTTPH2UWZ128rmkz,
          7048 => Opcode::VCVTTPH2UWZ128rr,
          7049 => Opcode::VCVTTPH2UWZ128rrk,
          7050 => Opcode::VCVTTPH2UWZ128rrkz,
          7051 => Opcode::VCVTTPH2UWZ256rm,
          7052 => Opcode::VCVTTPH2UWZ256rmb,
          7053 => Opcode::VCVTTPH2UWZ256rmbk,
          7054 => Opcode::VCVTTPH2UWZ256rmbkz,
          7055 => Opcode::VCVTTPH2UWZ256rmk,
          7056 => Opcode::VCVTTPH2UWZ256rmkz,
          7057 => Opcode::VCVTTPH2UWZ256rr,
          7058 => Opcode::VCVTTPH2UWZ256rrk,
          7059 => Opcode::VCVTTPH2UWZ256rrkz,
          7060 => Opcode::VCVTTPH2UWZrm,
          7061 => Opcode::VCVTTPH2UWZrmb,
          7062 => Opcode::VCVTTPH2UWZrmbk,
          7063 => Opcode::VCVTTPH2UWZrmbkz,
          7064 => Opcode::VCVTTPH2UWZrmk,
          7065 => Opcode::VCVTTPH2UWZrmkz,
          7066 => Opcode::VCVTTPH2UWZrr,
          7067 => Opcode::VCVTTPH2UWZrrb,
          7068 => Opcode::VCVTTPH2UWZrrbk,
          7069 => Opcode::VCVTTPH2UWZrrbkz,
          7070 => Opcode::VCVTTPH2UWZrrk,
          7071 => Opcode::VCVTTPH2UWZrrkz,
          7072 => Opcode::VCVTTPH2WZ128rm,
          7073 => Opcode::VCVTTPH2WZ128rmb,
          7074 => Opcode::VCVTTPH2WZ128rmbk,
          7075 => Opcode::VCVTTPH2WZ128rmbkz,
          7076 => Opcode::VCVTTPH2WZ128rmk,
          7077 => Opcode::VCVTTPH2WZ128rmkz,
          7078 => Opcode::VCVTTPH2WZ128rr,
          7079 => Opcode::VCVTTPH2WZ128rrk,
          7080 => Opcode::VCVTTPH2WZ128rrkz,
          7081 => Opcode::VCVTTPH2WZ256rm,
          7082 => Opcode::VCVTTPH2WZ256rmb,
          7083 => Opcode::VCVTTPH2WZ256rmbk,
          7084 => Opcode::VCVTTPH2WZ256rmbkz,
          7085 => Opcode::VCVTTPH2WZ256rmk,
          7086 => Opcode::VCVTTPH2WZ256rmkz,
          7087 => Opcode::VCVTTPH2WZ256rr,
          7088 => Opcode::VCVTTPH2WZ256rrk,
          7089 => Opcode::VCVTTPH2WZ256rrkz,
          7090 => Opcode::VCVTTPH2WZrm,
          7091 => Opcode::VCVTTPH2WZrmb,
          7092 => Opcode::VCVTTPH2WZrmbk,
          7093 => Opcode::VCVTTPH2WZrmbkz,
          7094 => Opcode::VCVTTPH2WZrmk,
          7095 => Opcode::VCVTTPH2WZrmkz,
          7096 => Opcode::VCVTTPH2WZrr,
          7097 => Opcode::VCVTTPH2WZrrb,
          7098 => Opcode::VCVTTPH2WZrrbk,
          7099 => Opcode::VCVTTPH2WZrrbkz,
          7100 => Opcode::VCVTTPH2WZrrk,
          7101 => Opcode::VCVTTPH2WZrrkz,
          7102 => Opcode::VCVTTPS2DQYrm,
          7103 => Opcode::VCVTTPS2DQYrr,
          7104 => Opcode::VCVTTPS2DQZ128rm,
          7105 => Opcode::VCVTTPS2DQZ128rmb,
          7106 => Opcode::VCVTTPS2DQZ128rmbk,
          7107 => Opcode::VCVTTPS2DQZ128rmbkz,
          7108 => Opcode::VCVTTPS2DQZ128rmk,
          7109 => Opcode::VCVTTPS2DQZ128rmkz,
          7110 => Opcode::VCVTTPS2DQZ128rr,
          7111 => Opcode::VCVTTPS2DQZ128rrk,
          7112 => Opcode::VCVTTPS2DQZ128rrkz,
          7113 => Opcode::VCVTTPS2DQZ256rm,
          7114 => Opcode::VCVTTPS2DQZ256rmb,
          7115 => Opcode::VCVTTPS2DQZ256rmbk,
          7116 => Opcode::VCVTTPS2DQZ256rmbkz,
          7117 => Opcode::VCVTTPS2DQZ256rmk,
          7118 => Opcode::VCVTTPS2DQZ256rmkz,
          7119 => Opcode::VCVTTPS2DQZ256rr,
          7120 => Opcode::VCVTTPS2DQZ256rrk,
          7121 => Opcode::VCVTTPS2DQZ256rrkz,
          7122 => Opcode::VCVTTPS2DQZrm,
          7123 => Opcode::VCVTTPS2DQZrmb,
          7124 => Opcode::VCVTTPS2DQZrmbk,
          7125 => Opcode::VCVTTPS2DQZrmbkz,
          7126 => Opcode::VCVTTPS2DQZrmk,
          7127 => Opcode::VCVTTPS2DQZrmkz,
          7128 => Opcode::VCVTTPS2DQZrr,
          7129 => Opcode::VCVTTPS2DQZrrb,
          7130 => Opcode::VCVTTPS2DQZrrbk,
          7131 => Opcode::VCVTTPS2DQZrrbkz,
          7132 => Opcode::VCVTTPS2DQZrrk,
          7133 => Opcode::VCVTTPS2DQZrrkz,
          7134 => Opcode::VCVTTPS2DQrm,
          7135 => Opcode::VCVTTPS2DQrr,
          7136 => Opcode::VCVTTPS2QQZ128rm,
          7137 => Opcode::VCVTTPS2QQZ128rmb,
          7138 => Opcode::VCVTTPS2QQZ128rmbk,
          7139 => Opcode::VCVTTPS2QQZ128rmbkz,
          7140 => Opcode::VCVTTPS2QQZ128rmk,
          7141 => Opcode::VCVTTPS2QQZ128rmkz,
          7142 => Opcode::VCVTTPS2QQZ128rr,
          7143 => Opcode::VCVTTPS2QQZ128rrk,
          7144 => Opcode::VCVTTPS2QQZ128rrkz,
          7145 => Opcode::VCVTTPS2QQZ256rm,
          7146 => Opcode::VCVTTPS2QQZ256rmb,
          7147 => Opcode::VCVTTPS2QQZ256rmbk,
          7148 => Opcode::VCVTTPS2QQZ256rmbkz,
          7149 => Opcode::VCVTTPS2QQZ256rmk,
          7150 => Opcode::VCVTTPS2QQZ256rmkz,
          7151 => Opcode::VCVTTPS2QQZ256rr,
          7152 => Opcode::VCVTTPS2QQZ256rrk,
          7153 => Opcode::VCVTTPS2QQZ256rrkz,
          7154 => Opcode::VCVTTPS2QQZrm,
          7155 => Opcode::VCVTTPS2QQZrmb,
          7156 => Opcode::VCVTTPS2QQZrmbk,
          7157 => Opcode::VCVTTPS2QQZrmbkz,
          7158 => Opcode::VCVTTPS2QQZrmk,
          7159 => Opcode::VCVTTPS2QQZrmkz,
          7160 => Opcode::VCVTTPS2QQZrr,
          7161 => Opcode::VCVTTPS2QQZrrb,
          7162 => Opcode::VCVTTPS2QQZrrbk,
          7163 => Opcode::VCVTTPS2QQZrrbkz,
          7164 => Opcode::VCVTTPS2QQZrrk,
          7165 => Opcode::VCVTTPS2QQZrrkz,
          7166 => Opcode::VCVTTPS2UDQZ128rm,
          7167 => Opcode::VCVTTPS2UDQZ128rmb,
          7168 => Opcode::VCVTTPS2UDQZ128rmbk,
          7169 => Opcode::VCVTTPS2UDQZ128rmbkz,
          7170 => Opcode::VCVTTPS2UDQZ128rmk,
          7171 => Opcode::VCVTTPS2UDQZ128rmkz,
          7172 => Opcode::VCVTTPS2UDQZ128rr,
          7173 => Opcode::VCVTTPS2UDQZ128rrk,
          7174 => Opcode::VCVTTPS2UDQZ128rrkz,
          7175 => Opcode::VCVTTPS2UDQZ256rm,
          7176 => Opcode::VCVTTPS2UDQZ256rmb,
          7177 => Opcode::VCVTTPS2UDQZ256rmbk,
          7178 => Opcode::VCVTTPS2UDQZ256rmbkz,
          7179 => Opcode::VCVTTPS2UDQZ256rmk,
          7180 => Opcode::VCVTTPS2UDQZ256rmkz,
          7181 => Opcode::VCVTTPS2UDQZ256rr,
          7182 => Opcode::VCVTTPS2UDQZ256rrk,
          7183 => Opcode::VCVTTPS2UDQZ256rrkz,
          7184 => Opcode::VCVTTPS2UDQZrm,
          7185 => Opcode::VCVTTPS2UDQZrmb,
          7186 => Opcode::VCVTTPS2UDQZrmbk,
          7187 => Opcode::VCVTTPS2UDQZrmbkz,
          7188 => Opcode::VCVTTPS2UDQZrmk,
          7189 => Opcode::VCVTTPS2UDQZrmkz,
          7190 => Opcode::VCVTTPS2UDQZrr,
          7191 => Opcode::VCVTTPS2UDQZrrb,
          7192 => Opcode::VCVTTPS2UDQZrrbk,
          7193 => Opcode::VCVTTPS2UDQZrrbkz,
          7194 => Opcode::VCVTTPS2UDQZrrk,
          7195 => Opcode::VCVTTPS2UDQZrrkz,
          7196 => Opcode::VCVTTPS2UQQZ128rm,
          7197 => Opcode::VCVTTPS2UQQZ128rmb,
          7198 => Opcode::VCVTTPS2UQQZ128rmbk,
          7199 => Opcode::VCVTTPS2UQQZ128rmbkz,
          7200 => Opcode::VCVTTPS2UQQZ128rmk,
          7201 => Opcode::VCVTTPS2UQQZ128rmkz,
          7202 => Opcode::VCVTTPS2UQQZ128rr,
          7203 => Opcode::VCVTTPS2UQQZ128rrk,
          7204 => Opcode::VCVTTPS2UQQZ128rrkz,
          7205 => Opcode::VCVTTPS2UQQZ256rm,
          7206 => Opcode::VCVTTPS2UQQZ256rmb,
          7207 => Opcode::VCVTTPS2UQQZ256rmbk,
          7208 => Opcode::VCVTTPS2UQQZ256rmbkz,
          7209 => Opcode::VCVTTPS2UQQZ256rmk,
          7210 => Opcode::VCVTTPS2UQQZ256rmkz,
          7211 => Opcode::VCVTTPS2UQQZ256rr,
          7212 => Opcode::VCVTTPS2UQQZ256rrk,
          7213 => Opcode::VCVTTPS2UQQZ256rrkz,
          7214 => Opcode::VCVTTPS2UQQZrm,
          7215 => Opcode::VCVTTPS2UQQZrmb,
          7216 => Opcode::VCVTTPS2UQQZrmbk,
          7217 => Opcode::VCVTTPS2UQQZrmbkz,
          7218 => Opcode::VCVTTPS2UQQZrmk,
          7219 => Opcode::VCVTTPS2UQQZrmkz,
          7220 => Opcode::VCVTTPS2UQQZrr,
          7221 => Opcode::VCVTTPS2UQQZrrb,
          7222 => Opcode::VCVTTPS2UQQZrrbk,
          7223 => Opcode::VCVTTPS2UQQZrrbkz,
          7224 => Opcode::VCVTTPS2UQQZrrk,
          7225 => Opcode::VCVTTPS2UQQZrrkz,
          7226 => Opcode::VCVTTSD2SI64Zrm,
          7227 => Opcode::VCVTTSD2SI64Zrm_Int,
          7228 => Opcode::VCVTTSD2SI64Zrr,
          7229 => Opcode::VCVTTSD2SI64Zrr_Int,
          7230 => Opcode::VCVTTSD2SI64Zrrb_Int,
          7231 => Opcode::VCVTTSD2SI64rm,
          7232 => Opcode::VCVTTSD2SI64rm_Int,
          7233 => Opcode::VCVTTSD2SI64rr,
          7234 => Opcode::VCVTTSD2SI64rr_Int,
          7235 => Opcode::VCVTTSD2SIZrm,
          7236 => Opcode::VCVTTSD2SIZrm_Int,
          7237 => Opcode::VCVTTSD2SIZrr,
          7238 => Opcode::VCVTTSD2SIZrr_Int,
          7239 => Opcode::VCVTTSD2SIZrrb_Int,
          7240 => Opcode::VCVTTSD2SIrm,
          7241 => Opcode::VCVTTSD2SIrm_Int,
          7242 => Opcode::VCVTTSD2SIrr,
          7243 => Opcode::VCVTTSD2SIrr_Int,
          7244 => Opcode::VCVTTSD2USI64Zrm,
          7245 => Opcode::VCVTTSD2USI64Zrm_Int,
          7246 => Opcode::VCVTTSD2USI64Zrr,
          7247 => Opcode::VCVTTSD2USI64Zrr_Int,
          7248 => Opcode::VCVTTSD2USI64Zrrb_Int,
          7249 => Opcode::VCVTTSD2USIZrm,
          7250 => Opcode::VCVTTSD2USIZrm_Int,
          7251 => Opcode::VCVTTSD2USIZrr,
          7252 => Opcode::VCVTTSD2USIZrr_Int,
          7253 => Opcode::VCVTTSD2USIZrrb_Int,
          7254 => Opcode::VCVTTSH2SI64Zrm,
          7255 => Opcode::VCVTTSH2SI64Zrm_Int,
          7256 => Opcode::VCVTTSH2SI64Zrr,
          7257 => Opcode::VCVTTSH2SI64Zrr_Int,
          7258 => Opcode::VCVTTSH2SI64Zrrb_Int,
          7259 => Opcode::VCVTTSH2SIZrm,
          7260 => Opcode::VCVTTSH2SIZrm_Int,
          7261 => Opcode::VCVTTSH2SIZrr,
          7262 => Opcode::VCVTTSH2SIZrr_Int,
          7263 => Opcode::VCVTTSH2SIZrrb_Int,
          7264 => Opcode::VCVTTSH2USI64Zrm,
          7265 => Opcode::VCVTTSH2USI64Zrm_Int,
          7266 => Opcode::VCVTTSH2USI64Zrr,
          7267 => Opcode::VCVTTSH2USI64Zrr_Int,
          7268 => Opcode::VCVTTSH2USI64Zrrb_Int,
          7269 => Opcode::VCVTTSH2USIZrm,
          7270 => Opcode::VCVTTSH2USIZrm_Int,
          7271 => Opcode::VCVTTSH2USIZrr,
          7272 => Opcode::VCVTTSH2USIZrr_Int,
          7273 => Opcode::VCVTTSH2USIZrrb_Int,
          7274 => Opcode::VCVTTSS2SI64Zrm,
          7275 => Opcode::VCVTTSS2SI64Zrm_Int,
          7276 => Opcode::VCVTTSS2SI64Zrr,
          7277 => Opcode::VCVTTSS2SI64Zrr_Int,
          7278 => Opcode::VCVTTSS2SI64Zrrb_Int,
          7279 => Opcode::VCVTTSS2SI64rm,
          7280 => Opcode::VCVTTSS2SI64rm_Int,
          7281 => Opcode::VCVTTSS2SI64rr,
          7282 => Opcode::VCVTTSS2SI64rr_Int,
          7283 => Opcode::VCVTTSS2SIZrm,
          7284 => Opcode::VCVTTSS2SIZrm_Int,
          7285 => Opcode::VCVTTSS2SIZrr,
          7286 => Opcode::VCVTTSS2SIZrr_Int,
          7287 => Opcode::VCVTTSS2SIZrrb_Int,
          7288 => Opcode::VCVTTSS2SIrm,
          7289 => Opcode::VCVTTSS2SIrm_Int,
          7290 => Opcode::VCVTTSS2SIrr,
          7291 => Opcode::VCVTTSS2SIrr_Int,
          7292 => Opcode::VCVTTSS2USI64Zrm,
          7293 => Opcode::VCVTTSS2USI64Zrm_Int,
          7294 => Opcode::VCVTTSS2USI64Zrr,
          7295 => Opcode::VCVTTSS2USI64Zrr_Int,
          7296 => Opcode::VCVTTSS2USI64Zrrb_Int,
          7297 => Opcode::VCVTTSS2USIZrm,
          7298 => Opcode::VCVTTSS2USIZrm_Int,
          7299 => Opcode::VCVTTSS2USIZrr,
          7300 => Opcode::VCVTTSS2USIZrr_Int,
          7301 => Opcode::VCVTTSS2USIZrrb_Int,
          7302 => Opcode::VCVTUDQ2PDZ128rm,
          7303 => Opcode::VCVTUDQ2PDZ128rmb,
          7304 => Opcode::VCVTUDQ2PDZ128rmbk,
          7305 => Opcode::VCVTUDQ2PDZ128rmbkz,
          7306 => Opcode::VCVTUDQ2PDZ128rmk,
          7307 => Opcode::VCVTUDQ2PDZ128rmkz,
          7308 => Opcode::VCVTUDQ2PDZ128rr,
          7309 => Opcode::VCVTUDQ2PDZ128rrk,
          7310 => Opcode::VCVTUDQ2PDZ128rrkz,
          7311 => Opcode::VCVTUDQ2PDZ256rm,
          7312 => Opcode::VCVTUDQ2PDZ256rmb,
          7313 => Opcode::VCVTUDQ2PDZ256rmbk,
          7314 => Opcode::VCVTUDQ2PDZ256rmbkz,
          7315 => Opcode::VCVTUDQ2PDZ256rmk,
          7316 => Opcode::VCVTUDQ2PDZ256rmkz,
          7317 => Opcode::VCVTUDQ2PDZ256rr,
          7318 => Opcode::VCVTUDQ2PDZ256rrk,
          7319 => Opcode::VCVTUDQ2PDZ256rrkz,
          7320 => Opcode::VCVTUDQ2PDZrm,
          7321 => Opcode::VCVTUDQ2PDZrmb,
          7322 => Opcode::VCVTUDQ2PDZrmbk,
          7323 => Opcode::VCVTUDQ2PDZrmbkz,
          7324 => Opcode::VCVTUDQ2PDZrmk,
          7325 => Opcode::VCVTUDQ2PDZrmkz,
          7326 => Opcode::VCVTUDQ2PDZrr,
          7327 => Opcode::VCVTUDQ2PDZrrk,
          7328 => Opcode::VCVTUDQ2PDZrrkz,
          7329 => Opcode::VCVTUDQ2PHZ128rm,
          7330 => Opcode::VCVTUDQ2PHZ128rmb,
          7331 => Opcode::VCVTUDQ2PHZ128rmbk,
          7332 => Opcode::VCVTUDQ2PHZ128rmbkz,
          7333 => Opcode::VCVTUDQ2PHZ128rmk,
          7334 => Opcode::VCVTUDQ2PHZ128rmkz,
          7335 => Opcode::VCVTUDQ2PHZ128rr,
          7336 => Opcode::VCVTUDQ2PHZ128rrk,
          7337 => Opcode::VCVTUDQ2PHZ128rrkz,
          7338 => Opcode::VCVTUDQ2PHZ256rm,
          7339 => Opcode::VCVTUDQ2PHZ256rmb,
          7340 => Opcode::VCVTUDQ2PHZ256rmbk,
          7341 => Opcode::VCVTUDQ2PHZ256rmbkz,
          7342 => Opcode::VCVTUDQ2PHZ256rmk,
          7343 => Opcode::VCVTUDQ2PHZ256rmkz,
          7344 => Opcode::VCVTUDQ2PHZ256rr,
          7345 => Opcode::VCVTUDQ2PHZ256rrk,
          7346 => Opcode::VCVTUDQ2PHZ256rrkz,
          7347 => Opcode::VCVTUDQ2PHZrm,
          7348 => Opcode::VCVTUDQ2PHZrmb,
          7349 => Opcode::VCVTUDQ2PHZrmbk,
          7350 => Opcode::VCVTUDQ2PHZrmbkz,
          7351 => Opcode::VCVTUDQ2PHZrmk,
          7352 => Opcode::VCVTUDQ2PHZrmkz,
          7353 => Opcode::VCVTUDQ2PHZrr,
          7354 => Opcode::VCVTUDQ2PHZrrb,
          7355 => Opcode::VCVTUDQ2PHZrrbk,
          7356 => Opcode::VCVTUDQ2PHZrrbkz,
          7357 => Opcode::VCVTUDQ2PHZrrk,
          7358 => Opcode::VCVTUDQ2PHZrrkz,
          7359 => Opcode::VCVTUDQ2PSZ128rm,
          7360 => Opcode::VCVTUDQ2PSZ128rmb,
          7361 => Opcode::VCVTUDQ2PSZ128rmbk,
          7362 => Opcode::VCVTUDQ2PSZ128rmbkz,
          7363 => Opcode::VCVTUDQ2PSZ128rmk,
          7364 => Opcode::VCVTUDQ2PSZ128rmkz,
          7365 => Opcode::VCVTUDQ2PSZ128rr,
          7366 => Opcode::VCVTUDQ2PSZ128rrk,
          7367 => Opcode::VCVTUDQ2PSZ128rrkz,
          7368 => Opcode::VCVTUDQ2PSZ256rm,
          7369 => Opcode::VCVTUDQ2PSZ256rmb,
          7370 => Opcode::VCVTUDQ2PSZ256rmbk,
          7371 => Opcode::VCVTUDQ2PSZ256rmbkz,
          7372 => Opcode::VCVTUDQ2PSZ256rmk,
          7373 => Opcode::VCVTUDQ2PSZ256rmkz,
          7374 => Opcode::VCVTUDQ2PSZ256rr,
          7375 => Opcode::VCVTUDQ2PSZ256rrk,
          7376 => Opcode::VCVTUDQ2PSZ256rrkz,
          7377 => Opcode::VCVTUDQ2PSZrm,
          7378 => Opcode::VCVTUDQ2PSZrmb,
          7379 => Opcode::VCVTUDQ2PSZrmbk,
          7380 => Opcode::VCVTUDQ2PSZrmbkz,
          7381 => Opcode::VCVTUDQ2PSZrmk,
          7382 => Opcode::VCVTUDQ2PSZrmkz,
          7383 => Opcode::VCVTUDQ2PSZrr,
          7384 => Opcode::VCVTUDQ2PSZrrb,
          7385 => Opcode::VCVTUDQ2PSZrrbk,
          7386 => Opcode::VCVTUDQ2PSZrrbkz,
          7387 => Opcode::VCVTUDQ2PSZrrk,
          7388 => Opcode::VCVTUDQ2PSZrrkz,
          7389 => Opcode::VCVTUQQ2PDZ128rm,
          7390 => Opcode::VCVTUQQ2PDZ128rmb,
          7391 => Opcode::VCVTUQQ2PDZ128rmbk,
          7392 => Opcode::VCVTUQQ2PDZ128rmbkz,
          7393 => Opcode::VCVTUQQ2PDZ128rmk,
          7394 => Opcode::VCVTUQQ2PDZ128rmkz,
          7395 => Opcode::VCVTUQQ2PDZ128rr,
          7396 => Opcode::VCVTUQQ2PDZ128rrk,
          7397 => Opcode::VCVTUQQ2PDZ128rrkz,
          7398 => Opcode::VCVTUQQ2PDZ256rm,
          7399 => Opcode::VCVTUQQ2PDZ256rmb,
          7400 => Opcode::VCVTUQQ2PDZ256rmbk,
          7401 => Opcode::VCVTUQQ2PDZ256rmbkz,
          7402 => Opcode::VCVTUQQ2PDZ256rmk,
          7403 => Opcode::VCVTUQQ2PDZ256rmkz,
          7404 => Opcode::VCVTUQQ2PDZ256rr,
          7405 => Opcode::VCVTUQQ2PDZ256rrk,
          7406 => Opcode::VCVTUQQ2PDZ256rrkz,
          7407 => Opcode::VCVTUQQ2PDZrm,
          7408 => Opcode::VCVTUQQ2PDZrmb,
          7409 => Opcode::VCVTUQQ2PDZrmbk,
          7410 => Opcode::VCVTUQQ2PDZrmbkz,
          7411 => Opcode::VCVTUQQ2PDZrmk,
          7412 => Opcode::VCVTUQQ2PDZrmkz,
          7413 => Opcode::VCVTUQQ2PDZrr,
          7414 => Opcode::VCVTUQQ2PDZrrb,
          7415 => Opcode::VCVTUQQ2PDZrrbk,
          7416 => Opcode::VCVTUQQ2PDZrrbkz,
          7417 => Opcode::VCVTUQQ2PDZrrk,
          7418 => Opcode::VCVTUQQ2PDZrrkz,
          7419 => Opcode::VCVTUQQ2PHZ128rm,
          7420 => Opcode::VCVTUQQ2PHZ128rmb,
          7421 => Opcode::VCVTUQQ2PHZ128rmbk,
          7422 => Opcode::VCVTUQQ2PHZ128rmbkz,
          7423 => Opcode::VCVTUQQ2PHZ128rmk,
          7424 => Opcode::VCVTUQQ2PHZ128rmkz,
          7425 => Opcode::VCVTUQQ2PHZ128rr,
          7426 => Opcode::VCVTUQQ2PHZ128rrk,
          7427 => Opcode::VCVTUQQ2PHZ128rrkz,
          7428 => Opcode::VCVTUQQ2PHZ256rm,
          7429 => Opcode::VCVTUQQ2PHZ256rmb,
          7430 => Opcode::VCVTUQQ2PHZ256rmbk,
          7431 => Opcode::VCVTUQQ2PHZ256rmbkz,
          7432 => Opcode::VCVTUQQ2PHZ256rmk,
          7433 => Opcode::VCVTUQQ2PHZ256rmkz,
          7434 => Opcode::VCVTUQQ2PHZ256rr,
          7435 => Opcode::VCVTUQQ2PHZ256rrk,
          7436 => Opcode::VCVTUQQ2PHZ256rrkz,
          7437 => Opcode::VCVTUQQ2PHZrm,
          7438 => Opcode::VCVTUQQ2PHZrmb,
          7439 => Opcode::VCVTUQQ2PHZrmbk,
          7440 => Opcode::VCVTUQQ2PHZrmbkz,
          7441 => Opcode::VCVTUQQ2PHZrmk,
          7442 => Opcode::VCVTUQQ2PHZrmkz,
          7443 => Opcode::VCVTUQQ2PHZrr,
          7444 => Opcode::VCVTUQQ2PHZrrb,
          7445 => Opcode::VCVTUQQ2PHZrrbk,
          7446 => Opcode::VCVTUQQ2PHZrrbkz,
          7447 => Opcode::VCVTUQQ2PHZrrk,
          7448 => Opcode::VCVTUQQ2PHZrrkz,
          7449 => Opcode::VCVTUQQ2PSZ128rm,
          7450 => Opcode::VCVTUQQ2PSZ128rmb,
          7451 => Opcode::VCVTUQQ2PSZ128rmbk,
          7452 => Opcode::VCVTUQQ2PSZ128rmbkz,
          7453 => Opcode::VCVTUQQ2PSZ128rmk,
          7454 => Opcode::VCVTUQQ2PSZ128rmkz,
          7455 => Opcode::VCVTUQQ2PSZ128rr,
          7456 => Opcode::VCVTUQQ2PSZ128rrk,
          7457 => Opcode::VCVTUQQ2PSZ128rrkz,
          7458 => Opcode::VCVTUQQ2PSZ256rm,
          7459 => Opcode::VCVTUQQ2PSZ256rmb,
          7460 => Opcode::VCVTUQQ2PSZ256rmbk,
          7461 => Opcode::VCVTUQQ2PSZ256rmbkz,
          7462 => Opcode::VCVTUQQ2PSZ256rmk,
          7463 => Opcode::VCVTUQQ2PSZ256rmkz,
          7464 => Opcode::VCVTUQQ2PSZ256rr,
          7465 => Opcode::VCVTUQQ2PSZ256rrk,
          7466 => Opcode::VCVTUQQ2PSZ256rrkz,
          7467 => Opcode::VCVTUQQ2PSZrm,
          7468 => Opcode::VCVTUQQ2PSZrmb,
          7469 => Opcode::VCVTUQQ2PSZrmbk,
          7470 => Opcode::VCVTUQQ2PSZrmbkz,
          7471 => Opcode::VCVTUQQ2PSZrmk,
          7472 => Opcode::VCVTUQQ2PSZrmkz,
          7473 => Opcode::VCVTUQQ2PSZrr,
          7474 => Opcode::VCVTUQQ2PSZrrb,
          7475 => Opcode::VCVTUQQ2PSZrrbk,
          7476 => Opcode::VCVTUQQ2PSZrrbkz,
          7477 => Opcode::VCVTUQQ2PSZrrk,
          7478 => Opcode::VCVTUQQ2PSZrrkz,
          7479 => Opcode::VCVTUSI2SDZrm,
          7480 => Opcode::VCVTUSI2SDZrm_Int,
          7481 => Opcode::VCVTUSI2SDZrr,
          7482 => Opcode::VCVTUSI2SDZrr_Int,
          7483 => Opcode::VCVTUSI2SHZrm,
          7484 => Opcode::VCVTUSI2SHZrm_Int,
          7485 => Opcode::VCVTUSI2SHZrr,
          7486 => Opcode::VCVTUSI2SHZrr_Int,
          7487 => Opcode::VCVTUSI2SHZrrb_Int,
          7488 => Opcode::VCVTUSI2SSZrm,
          7489 => Opcode::VCVTUSI2SSZrm_Int,
          7490 => Opcode::VCVTUSI2SSZrr,
          7491 => Opcode::VCVTUSI2SSZrr_Int,
          7492 => Opcode::VCVTUSI2SSZrrb_Int,
          7493 => Opcode::VCVTUSI642SDZrm,
          7494 => Opcode::VCVTUSI642SDZrm_Int,
          7495 => Opcode::VCVTUSI642SDZrr,
          7496 => Opcode::VCVTUSI642SDZrr_Int,
          7497 => Opcode::VCVTUSI642SDZrrb_Int,
          7498 => Opcode::VCVTUSI642SHZrm,
          7499 => Opcode::VCVTUSI642SHZrm_Int,
          7500 => Opcode::VCVTUSI642SHZrr,
          7501 => Opcode::VCVTUSI642SHZrr_Int,
          7502 => Opcode::VCVTUSI642SHZrrb_Int,
          7503 => Opcode::VCVTUSI642SSZrm,
          7504 => Opcode::VCVTUSI642SSZrm_Int,
          7505 => Opcode::VCVTUSI642SSZrr,
          7506 => Opcode::VCVTUSI642SSZrr_Int,
          7507 => Opcode::VCVTUSI642SSZrrb_Int,
          7508 => Opcode::VCVTUW2PHZ128rm,
          7509 => Opcode::VCVTUW2PHZ128rmb,
          7510 => Opcode::VCVTUW2PHZ128rmbk,
          7511 => Opcode::VCVTUW2PHZ128rmbkz,
          7512 => Opcode::VCVTUW2PHZ128rmk,
          7513 => Opcode::VCVTUW2PHZ128rmkz,
          7514 => Opcode::VCVTUW2PHZ128rr,
          7515 => Opcode::VCVTUW2PHZ128rrk,
          7516 => Opcode::VCVTUW2PHZ128rrkz,
          7517 => Opcode::VCVTUW2PHZ256rm,
          7518 => Opcode::VCVTUW2PHZ256rmb,
          7519 => Opcode::VCVTUW2PHZ256rmbk,
          7520 => Opcode::VCVTUW2PHZ256rmbkz,
          7521 => Opcode::VCVTUW2PHZ256rmk,
          7522 => Opcode::VCVTUW2PHZ256rmkz,
          7523 => Opcode::VCVTUW2PHZ256rr,
          7524 => Opcode::VCVTUW2PHZ256rrk,
          7525 => Opcode::VCVTUW2PHZ256rrkz,
          7526 => Opcode::VCVTUW2PHZrm,
          7527 => Opcode::VCVTUW2PHZrmb,
          7528 => Opcode::VCVTUW2PHZrmbk,
          7529 => Opcode::VCVTUW2PHZrmbkz,
          7530 => Opcode::VCVTUW2PHZrmk,
          7531 => Opcode::VCVTUW2PHZrmkz,
          7532 => Opcode::VCVTUW2PHZrr,
          7533 => Opcode::VCVTUW2PHZrrb,
          7534 => Opcode::VCVTUW2PHZrrbk,
          7535 => Opcode::VCVTUW2PHZrrbkz,
          7536 => Opcode::VCVTUW2PHZrrk,
          7537 => Opcode::VCVTUW2PHZrrkz,
          7538 => Opcode::VCVTW2PHZ128rm,
          7539 => Opcode::VCVTW2PHZ128rmb,
          7540 => Opcode::VCVTW2PHZ128rmbk,
          7541 => Opcode::VCVTW2PHZ128rmbkz,
          7542 => Opcode::VCVTW2PHZ128rmk,
          7543 => Opcode::VCVTW2PHZ128rmkz,
          7544 => Opcode::VCVTW2PHZ128rr,
          7545 => Opcode::VCVTW2PHZ128rrk,
          7546 => Opcode::VCVTW2PHZ128rrkz,
          7547 => Opcode::VCVTW2PHZ256rm,
          7548 => Opcode::VCVTW2PHZ256rmb,
          7549 => Opcode::VCVTW2PHZ256rmbk,
          7550 => Opcode::VCVTW2PHZ256rmbkz,
          7551 => Opcode::VCVTW2PHZ256rmk,
          7552 => Opcode::VCVTW2PHZ256rmkz,
          7553 => Opcode::VCVTW2PHZ256rr,
          7554 => Opcode::VCVTW2PHZ256rrk,
          7555 => Opcode::VCVTW2PHZ256rrkz,
          7556 => Opcode::VCVTW2PHZrm,
          7557 => Opcode::VCVTW2PHZrmb,
          7558 => Opcode::VCVTW2PHZrmbk,
          7559 => Opcode::VCVTW2PHZrmbkz,
          7560 => Opcode::VCVTW2PHZrmk,
          7561 => Opcode::VCVTW2PHZrmkz,
          7562 => Opcode::VCVTW2PHZrr,
          7563 => Opcode::VCVTW2PHZrrb,
          7564 => Opcode::VCVTW2PHZrrbk,
          7565 => Opcode::VCVTW2PHZrrbkz,
          7566 => Opcode::VCVTW2PHZrrk,
          7567 => Opcode::VCVTW2PHZrrkz,
          7568 => Opcode::VDBPSADBWZ128rmi,
          7569 => Opcode::VDBPSADBWZ128rmik,
          7570 => Opcode::VDBPSADBWZ128rmikz,
          7571 => Opcode::VDBPSADBWZ128rri,
          7572 => Opcode::VDBPSADBWZ128rrik,
          7573 => Opcode::VDBPSADBWZ128rrikz,
          7574 => Opcode::VDBPSADBWZ256rmi,
          7575 => Opcode::VDBPSADBWZ256rmik,
          7576 => Opcode::VDBPSADBWZ256rmikz,
          7577 => Opcode::VDBPSADBWZ256rri,
          7578 => Opcode::VDBPSADBWZ256rrik,
          7579 => Opcode::VDBPSADBWZ256rrikz,
          7580 => Opcode::VDBPSADBWZrmi,
          7581 => Opcode::VDBPSADBWZrmik,
          7582 => Opcode::VDBPSADBWZrmikz,
          7583 => Opcode::VDBPSADBWZrri,
          7584 => Opcode::VDBPSADBWZrrik,
          7585 => Opcode::VDBPSADBWZrrikz,
          7586 => Opcode::VDIVPDYrm,
          7587 => Opcode::VDIVPDYrr,
          7588 => Opcode::VDIVPDZ128rm,
          7589 => Opcode::VDIVPDZ128rmb,
          7590 => Opcode::VDIVPDZ128rmbk,
          7591 => Opcode::VDIVPDZ128rmbkz,
          7592 => Opcode::VDIVPDZ128rmk,
          7593 => Opcode::VDIVPDZ128rmkz,
          7594 => Opcode::VDIVPDZ128rr,
          7595 => Opcode::VDIVPDZ128rrk,
          7596 => Opcode::VDIVPDZ128rrkz,
          7597 => Opcode::VDIVPDZ256rm,
          7598 => Opcode::VDIVPDZ256rmb,
          7599 => Opcode::VDIVPDZ256rmbk,
          7600 => Opcode::VDIVPDZ256rmbkz,
          7601 => Opcode::VDIVPDZ256rmk,
          7602 => Opcode::VDIVPDZ256rmkz,
          7603 => Opcode::VDIVPDZ256rr,
          7604 => Opcode::VDIVPDZ256rrk,
          7605 => Opcode::VDIVPDZ256rrkz,
          7606 => Opcode::VDIVPDZrm,
          7607 => Opcode::VDIVPDZrmb,
          7608 => Opcode::VDIVPDZrmbk,
          7609 => Opcode::VDIVPDZrmbkz,
          7610 => Opcode::VDIVPDZrmk,
          7611 => Opcode::VDIVPDZrmkz,
          7612 => Opcode::VDIVPDZrr,
          7613 => Opcode::VDIVPDZrrb,
          7614 => Opcode::VDIVPDZrrbk,
          7615 => Opcode::VDIVPDZrrbkz,
          7616 => Opcode::VDIVPDZrrk,
          7617 => Opcode::VDIVPDZrrkz,
          7618 => Opcode::VDIVPDrm,
          7619 => Opcode::VDIVPDrr,
          7620 => Opcode::VDIVPHZ128rm,
          7621 => Opcode::VDIVPHZ128rmb,
          7622 => Opcode::VDIVPHZ128rmbk,
          7623 => Opcode::VDIVPHZ128rmbkz,
          7624 => Opcode::VDIVPHZ128rmk,
          7625 => Opcode::VDIVPHZ128rmkz,
          7626 => Opcode::VDIVPHZ128rr,
          7627 => Opcode::VDIVPHZ128rrk,
          7628 => Opcode::VDIVPHZ128rrkz,
          7629 => Opcode::VDIVPHZ256rm,
          7630 => Opcode::VDIVPHZ256rmb,
          7631 => Opcode::VDIVPHZ256rmbk,
          7632 => Opcode::VDIVPHZ256rmbkz,
          7633 => Opcode::VDIVPHZ256rmk,
          7634 => Opcode::VDIVPHZ256rmkz,
          7635 => Opcode::VDIVPHZ256rr,
          7636 => Opcode::VDIVPHZ256rrk,
          7637 => Opcode::VDIVPHZ256rrkz,
          7638 => Opcode::VDIVPHZrm,
          7639 => Opcode::VDIVPHZrmb,
          7640 => Opcode::VDIVPHZrmbk,
          7641 => Opcode::VDIVPHZrmbkz,
          7642 => Opcode::VDIVPHZrmk,
          7643 => Opcode::VDIVPHZrmkz,
          7644 => Opcode::VDIVPHZrr,
          7645 => Opcode::VDIVPHZrrb,
          7646 => Opcode::VDIVPHZrrbk,
          7647 => Opcode::VDIVPHZrrbkz,
          7648 => Opcode::VDIVPHZrrk,
          7649 => Opcode::VDIVPHZrrkz,
          7650 => Opcode::VDIVPSYrm,
          7651 => Opcode::VDIVPSYrr,
          7652 => Opcode::VDIVPSZ128rm,
          7653 => Opcode::VDIVPSZ128rmb,
          7654 => Opcode::VDIVPSZ128rmbk,
          7655 => Opcode::VDIVPSZ128rmbkz,
          7656 => Opcode::VDIVPSZ128rmk,
          7657 => Opcode::VDIVPSZ128rmkz,
          7658 => Opcode::VDIVPSZ128rr,
          7659 => Opcode::VDIVPSZ128rrk,
          7660 => Opcode::VDIVPSZ128rrkz,
          7661 => Opcode::VDIVPSZ256rm,
          7662 => Opcode::VDIVPSZ256rmb,
          7663 => Opcode::VDIVPSZ256rmbk,
          7664 => Opcode::VDIVPSZ256rmbkz,
          7665 => Opcode::VDIVPSZ256rmk,
          7666 => Opcode::VDIVPSZ256rmkz,
          7667 => Opcode::VDIVPSZ256rr,
          7668 => Opcode::VDIVPSZ256rrk,
          7669 => Opcode::VDIVPSZ256rrkz,
          7670 => Opcode::VDIVPSZrm,
          7671 => Opcode::VDIVPSZrmb,
          7672 => Opcode::VDIVPSZrmbk,
          7673 => Opcode::VDIVPSZrmbkz,
          7674 => Opcode::VDIVPSZrmk,
          7675 => Opcode::VDIVPSZrmkz,
          7676 => Opcode::VDIVPSZrr,
          7677 => Opcode::VDIVPSZrrb,
          7678 => Opcode::VDIVPSZrrbk,
          7679 => Opcode::VDIVPSZrrbkz,
          7680 => Opcode::VDIVPSZrrk,
          7681 => Opcode::VDIVPSZrrkz,
          7682 => Opcode::VDIVPSrm,
          7683 => Opcode::VDIVPSrr,
          7684 => Opcode::VDIVSDZrm,
          7685 => Opcode::VDIVSDZrm_Int,
          7686 => Opcode::VDIVSDZrm_Intk,
          7687 => Opcode::VDIVSDZrm_Intkz,
          7688 => Opcode::VDIVSDZrr,
          7689 => Opcode::VDIVSDZrr_Int,
          7690 => Opcode::VDIVSDZrr_Intk,
          7691 => Opcode::VDIVSDZrr_Intkz,
          7692 => Opcode::VDIVSDZrrb_Int,
          7693 => Opcode::VDIVSDZrrb_Intk,
          7694 => Opcode::VDIVSDZrrb_Intkz,
          7695 => Opcode::VDIVSDrm,
          7696 => Opcode::VDIVSDrm_Int,
          7697 => Opcode::VDIVSDrr,
          7698 => Opcode::VDIVSDrr_Int,
          7699 => Opcode::VDIVSHZrm,
          7700 => Opcode::VDIVSHZrm_Int,
          7701 => Opcode::VDIVSHZrm_Intk,
          7702 => Opcode::VDIVSHZrm_Intkz,
          7703 => Opcode::VDIVSHZrr,
          7704 => Opcode::VDIVSHZrr_Int,
          7705 => Opcode::VDIVSHZrr_Intk,
          7706 => Opcode::VDIVSHZrr_Intkz,
          7707 => Opcode::VDIVSHZrrb_Int,
          7708 => Opcode::VDIVSHZrrb_Intk,
          7709 => Opcode::VDIVSHZrrb_Intkz,
          7710 => Opcode::VDIVSSZrm,
          7711 => Opcode::VDIVSSZrm_Int,
          7712 => Opcode::VDIVSSZrm_Intk,
          7713 => Opcode::VDIVSSZrm_Intkz,
          7714 => Opcode::VDIVSSZrr,
          7715 => Opcode::VDIVSSZrr_Int,
          7716 => Opcode::VDIVSSZrr_Intk,
          7717 => Opcode::VDIVSSZrr_Intkz,
          7718 => Opcode::VDIVSSZrrb_Int,
          7719 => Opcode::VDIVSSZrrb_Intk,
          7720 => Opcode::VDIVSSZrrb_Intkz,
          7721 => Opcode::VDIVSSrm,
          7722 => Opcode::VDIVSSrm_Int,
          7723 => Opcode::VDIVSSrr,
          7724 => Opcode::VDIVSSrr_Int,
          7725 => Opcode::VDPBF16PSZ128m,
          7726 => Opcode::VDPBF16PSZ128mb,
          7727 => Opcode::VDPBF16PSZ128mbk,
          7728 => Opcode::VDPBF16PSZ128mbkz,
          7729 => Opcode::VDPBF16PSZ128mk,
          7730 => Opcode::VDPBF16PSZ128mkz,
          7731 => Opcode::VDPBF16PSZ128r,
          7732 => Opcode::VDPBF16PSZ128rk,
          7733 => Opcode::VDPBF16PSZ128rkz,
          7734 => Opcode::VDPBF16PSZ256m,
          7735 => Opcode::VDPBF16PSZ256mb,
          7736 => Opcode::VDPBF16PSZ256mbk,
          7737 => Opcode::VDPBF16PSZ256mbkz,
          7738 => Opcode::VDPBF16PSZ256mk,
          7739 => Opcode::VDPBF16PSZ256mkz,
          7740 => Opcode::VDPBF16PSZ256r,
          7741 => Opcode::VDPBF16PSZ256rk,
          7742 => Opcode::VDPBF16PSZ256rkz,
          7743 => Opcode::VDPBF16PSZm,
          7744 => Opcode::VDPBF16PSZmb,
          7745 => Opcode::VDPBF16PSZmbk,
          7746 => Opcode::VDPBF16PSZmbkz,
          7747 => Opcode::VDPBF16PSZmk,
          7748 => Opcode::VDPBF16PSZmkz,
          7749 => Opcode::VDPBF16PSZr,
          7750 => Opcode::VDPBF16PSZrk,
          7751 => Opcode::VDPBF16PSZrkz,
          7752 => Opcode::VDPPDrmi,
          7753 => Opcode::VDPPDrri,
          7754 => Opcode::VDPPSYrmi,
          7755 => Opcode::VDPPSYrri,
          7756 => Opcode::VDPPSrmi,
          7757 => Opcode::VDPPSrri,
          7758 => Opcode::VERRm,
          7759 => Opcode::VERRr,
          7760 => Opcode::VERWm,
          7761 => Opcode::VERWr,
          7762 => Opcode::VEXP2PDZm,
          7763 => Opcode::VEXP2PDZmb,
          7764 => Opcode::VEXP2PDZmbk,
          7765 => Opcode::VEXP2PDZmbkz,
          7766 => Opcode::VEXP2PDZmk,
          7767 => Opcode::VEXP2PDZmkz,
          7768 => Opcode::VEXP2PDZr,
          7769 => Opcode::VEXP2PDZrb,
          7770 => Opcode::VEXP2PDZrbk,
          7771 => Opcode::VEXP2PDZrbkz,
          7772 => Opcode::VEXP2PDZrk,
          7773 => Opcode::VEXP2PDZrkz,
          7774 => Opcode::VEXP2PSZm,
          7775 => Opcode::VEXP2PSZmb,
          7776 => Opcode::VEXP2PSZmbk,
          7777 => Opcode::VEXP2PSZmbkz,
          7778 => Opcode::VEXP2PSZmk,
          7779 => Opcode::VEXP2PSZmkz,
          7780 => Opcode::VEXP2PSZr,
          7781 => Opcode::VEXP2PSZrb,
          7782 => Opcode::VEXP2PSZrbk,
          7783 => Opcode::VEXP2PSZrbkz,
          7784 => Opcode::VEXP2PSZrk,
          7785 => Opcode::VEXP2PSZrkz,
          7786 => Opcode::VEXPANDPDZ128rm,
          7787 => Opcode::VEXPANDPDZ128rmk,
          7788 => Opcode::VEXPANDPDZ128rmkz,
          7789 => Opcode::VEXPANDPDZ128rr,
          7790 => Opcode::VEXPANDPDZ128rrk,
          7791 => Opcode::VEXPANDPDZ128rrkz,
          7792 => Opcode::VEXPANDPDZ256rm,
          7793 => Opcode::VEXPANDPDZ256rmk,
          7794 => Opcode::VEXPANDPDZ256rmkz,
          7795 => Opcode::VEXPANDPDZ256rr,
          7796 => Opcode::VEXPANDPDZ256rrk,
          7797 => Opcode::VEXPANDPDZ256rrkz,
          7798 => Opcode::VEXPANDPDZrm,
          7799 => Opcode::VEXPANDPDZrmk,
          7800 => Opcode::VEXPANDPDZrmkz,
          7801 => Opcode::VEXPANDPDZrr,
          7802 => Opcode::VEXPANDPDZrrk,
          7803 => Opcode::VEXPANDPDZrrkz,
          7804 => Opcode::VEXPANDPSZ128rm,
          7805 => Opcode::VEXPANDPSZ128rmk,
          7806 => Opcode::VEXPANDPSZ128rmkz,
          7807 => Opcode::VEXPANDPSZ128rr,
          7808 => Opcode::VEXPANDPSZ128rrk,
          7809 => Opcode::VEXPANDPSZ128rrkz,
          7810 => Opcode::VEXPANDPSZ256rm,
          7811 => Opcode::VEXPANDPSZ256rmk,
          7812 => Opcode::VEXPANDPSZ256rmkz,
          7813 => Opcode::VEXPANDPSZ256rr,
          7814 => Opcode::VEXPANDPSZ256rrk,
          7815 => Opcode::VEXPANDPSZ256rrkz,
          7816 => Opcode::VEXPANDPSZrm,
          7817 => Opcode::VEXPANDPSZrmk,
          7818 => Opcode::VEXPANDPSZrmkz,
          7819 => Opcode::VEXPANDPSZrr,
          7820 => Opcode::VEXPANDPSZrrk,
          7821 => Opcode::VEXPANDPSZrrkz,
          7822 => Opcode::VEXTRACTF128mr,
          7823 => Opcode::VEXTRACTF128rr,
          7824 => Opcode::VEXTRACTF32x4Z256mr,
          7825 => Opcode::VEXTRACTF32x4Z256mrk,
          7826 => Opcode::VEXTRACTF32x4Z256rr,
          7827 => Opcode::VEXTRACTF32x4Z256rrk,
          7828 => Opcode::VEXTRACTF32x4Z256rrkz,
          7829 => Opcode::VEXTRACTF32x4Zmr,
          7830 => Opcode::VEXTRACTF32x4Zmrk,
          7831 => Opcode::VEXTRACTF32x4Zrr,
          7832 => Opcode::VEXTRACTF32x4Zrrk,
          7833 => Opcode::VEXTRACTF32x4Zrrkz,
          7834 => Opcode::VEXTRACTF32x8Zmr,
          7835 => Opcode::VEXTRACTF32x8Zmrk,
          7836 => Opcode::VEXTRACTF32x8Zrr,
          7837 => Opcode::VEXTRACTF32x8Zrrk,
          7838 => Opcode::VEXTRACTF32x8Zrrkz,
          7839 => Opcode::VEXTRACTF64x2Z256mr,
          7840 => Opcode::VEXTRACTF64x2Z256mrk,
          7841 => Opcode::VEXTRACTF64x2Z256rr,
          7842 => Opcode::VEXTRACTF64x2Z256rrk,
          7843 => Opcode::VEXTRACTF64x2Z256rrkz,
          7844 => Opcode::VEXTRACTF64x2Zmr,
          7845 => Opcode::VEXTRACTF64x2Zmrk,
          7846 => Opcode::VEXTRACTF64x2Zrr,
          7847 => Opcode::VEXTRACTF64x2Zrrk,
          7848 => Opcode::VEXTRACTF64x2Zrrkz,
          7849 => Opcode::VEXTRACTF64x4Zmr,
          7850 => Opcode::VEXTRACTF64x4Zmrk,
          7851 => Opcode::VEXTRACTF64x4Zrr,
          7852 => Opcode::VEXTRACTF64x4Zrrk,
          7853 => Opcode::VEXTRACTF64x4Zrrkz,
          7854 => Opcode::VEXTRACTI128mr,
          7855 => Opcode::VEXTRACTI128rr,
          7856 => Opcode::VEXTRACTI32x4Z256mr,
          7857 => Opcode::VEXTRACTI32x4Z256mrk,
          7858 => Opcode::VEXTRACTI32x4Z256rr,
          7859 => Opcode::VEXTRACTI32x4Z256rrk,
          7860 => Opcode::VEXTRACTI32x4Z256rrkz,
          7861 => Opcode::VEXTRACTI32x4Zmr,
          7862 => Opcode::VEXTRACTI32x4Zmrk,
          7863 => Opcode::VEXTRACTI32x4Zrr,
          7864 => Opcode::VEXTRACTI32x4Zrrk,
          7865 => Opcode::VEXTRACTI32x4Zrrkz,
          7866 => Opcode::VEXTRACTI32x8Zmr,
          7867 => Opcode::VEXTRACTI32x8Zmrk,
          7868 => Opcode::VEXTRACTI32x8Zrr,
          7869 => Opcode::VEXTRACTI32x8Zrrk,
          7870 => Opcode::VEXTRACTI32x8Zrrkz,
          7871 => Opcode::VEXTRACTI64x2Z256mr,
          7872 => Opcode::VEXTRACTI64x2Z256mrk,
          7873 => Opcode::VEXTRACTI64x2Z256rr,
          7874 => Opcode::VEXTRACTI64x2Z256rrk,
          7875 => Opcode::VEXTRACTI64x2Z256rrkz,
          7876 => Opcode::VEXTRACTI64x2Zmr,
          7877 => Opcode::VEXTRACTI64x2Zmrk,
          7878 => Opcode::VEXTRACTI64x2Zrr,
          7879 => Opcode::VEXTRACTI64x2Zrrk,
          7880 => Opcode::VEXTRACTI64x2Zrrkz,
          7881 => Opcode::VEXTRACTI64x4Zmr,
          7882 => Opcode::VEXTRACTI64x4Zmrk,
          7883 => Opcode::VEXTRACTI64x4Zrr,
          7884 => Opcode::VEXTRACTI64x4Zrrk,
          7885 => Opcode::VEXTRACTI64x4Zrrkz,
          7886 => Opcode::VEXTRACTPSZmr,
          7887 => Opcode::VEXTRACTPSZrr,
          7888 => Opcode::VEXTRACTPSmr,
          7889 => Opcode::VEXTRACTPSrr,
          7890 => Opcode::VFCMADDCPHZ128m,
          7891 => Opcode::VFCMADDCPHZ128mb,
          7892 => Opcode::VFCMADDCPHZ128mbk,
          7893 => Opcode::VFCMADDCPHZ128mbkz,
          7894 => Opcode::VFCMADDCPHZ128mk,
          7895 => Opcode::VFCMADDCPHZ128mkz,
          7896 => Opcode::VFCMADDCPHZ128r,
          7897 => Opcode::VFCMADDCPHZ128rk,
          7898 => Opcode::VFCMADDCPHZ128rkz,
          7899 => Opcode::VFCMADDCPHZ256m,
          7900 => Opcode::VFCMADDCPHZ256mb,
          7901 => Opcode::VFCMADDCPHZ256mbk,
          7902 => Opcode::VFCMADDCPHZ256mbkz,
          7903 => Opcode::VFCMADDCPHZ256mk,
          7904 => Opcode::VFCMADDCPHZ256mkz,
          7905 => Opcode::VFCMADDCPHZ256r,
          7906 => Opcode::VFCMADDCPHZ256rk,
          7907 => Opcode::VFCMADDCPHZ256rkz,
          7908 => Opcode::VFCMADDCPHZm,
          7909 => Opcode::VFCMADDCPHZmb,
          7910 => Opcode::VFCMADDCPHZmbk,
          7911 => Opcode::VFCMADDCPHZmbkz,
          7912 => Opcode::VFCMADDCPHZmk,
          7913 => Opcode::VFCMADDCPHZmkz,
          7914 => Opcode::VFCMADDCPHZr,
          7915 => Opcode::VFCMADDCPHZrb,
          7916 => Opcode::VFCMADDCPHZrbk,
          7917 => Opcode::VFCMADDCPHZrbkz,
          7918 => Opcode::VFCMADDCPHZrk,
          7919 => Opcode::VFCMADDCPHZrkz,
          7920 => Opcode::VFCMADDCSHZm,
          7921 => Opcode::VFCMADDCSHZmk,
          7922 => Opcode::VFCMADDCSHZmkz,
          7923 => Opcode::VFCMADDCSHZr,
          7924 => Opcode::VFCMADDCSHZrb,
          7925 => Opcode::VFCMADDCSHZrbk,
          7926 => Opcode::VFCMADDCSHZrbkz,
          7927 => Opcode::VFCMADDCSHZrk,
          7928 => Opcode::VFCMADDCSHZrkz,
          7929 => Opcode::VFCMULCPHZ128rm,
          7930 => Opcode::VFCMULCPHZ128rmb,
          7931 => Opcode::VFCMULCPHZ128rmbk,
          7932 => Opcode::VFCMULCPHZ128rmbkz,
          7933 => Opcode::VFCMULCPHZ128rmk,
          7934 => Opcode::VFCMULCPHZ128rmkz,
          7935 => Opcode::VFCMULCPHZ128rr,
          7936 => Opcode::VFCMULCPHZ128rrk,
          7937 => Opcode::VFCMULCPHZ128rrkz,
          7938 => Opcode::VFCMULCPHZ256rm,
          7939 => Opcode::VFCMULCPHZ256rmb,
          7940 => Opcode::VFCMULCPHZ256rmbk,
          7941 => Opcode::VFCMULCPHZ256rmbkz,
          7942 => Opcode::VFCMULCPHZ256rmk,
          7943 => Opcode::VFCMULCPHZ256rmkz,
          7944 => Opcode::VFCMULCPHZ256rr,
          7945 => Opcode::VFCMULCPHZ256rrk,
          7946 => Opcode::VFCMULCPHZ256rrkz,
          7947 => Opcode::VFCMULCPHZrm,
          7948 => Opcode::VFCMULCPHZrmb,
          7949 => Opcode::VFCMULCPHZrmbk,
          7950 => Opcode::VFCMULCPHZrmbkz,
          7951 => Opcode::VFCMULCPHZrmk,
          7952 => Opcode::VFCMULCPHZrmkz,
          7953 => Opcode::VFCMULCPHZrr,
          7954 => Opcode::VFCMULCPHZrrb,
          7955 => Opcode::VFCMULCPHZrrbk,
          7956 => Opcode::VFCMULCPHZrrbkz,
          7957 => Opcode::VFCMULCPHZrrk,
          7958 => Opcode::VFCMULCPHZrrkz,
          7959 => Opcode::VFCMULCSHZrm,
          7960 => Opcode::VFCMULCSHZrmk,
          7961 => Opcode::VFCMULCSHZrmkz,
          7962 => Opcode::VFCMULCSHZrr,
          7963 => Opcode::VFCMULCSHZrrb,
          7964 => Opcode::VFCMULCSHZrrbk,
          7965 => Opcode::VFCMULCSHZrrbkz,
          7966 => Opcode::VFCMULCSHZrrk,
          7967 => Opcode::VFCMULCSHZrrkz,
          7968 => Opcode::VFIXUPIMMPDZ128rmbi,
          7969 => Opcode::VFIXUPIMMPDZ128rmbik,
          7970 => Opcode::VFIXUPIMMPDZ128rmbikz,
          7971 => Opcode::VFIXUPIMMPDZ128rmi,
          7972 => Opcode::VFIXUPIMMPDZ128rmik,
          7973 => Opcode::VFIXUPIMMPDZ128rmikz,
          7974 => Opcode::VFIXUPIMMPDZ128rri,
          7975 => Opcode::VFIXUPIMMPDZ128rrik,
          7976 => Opcode::VFIXUPIMMPDZ128rrikz,
          7977 => Opcode::VFIXUPIMMPDZ256rmbi,
          7978 => Opcode::VFIXUPIMMPDZ256rmbik,
          7979 => Opcode::VFIXUPIMMPDZ256rmbikz,
          7980 => Opcode::VFIXUPIMMPDZ256rmi,
          7981 => Opcode::VFIXUPIMMPDZ256rmik,
          7982 => Opcode::VFIXUPIMMPDZ256rmikz,
          7983 => Opcode::VFIXUPIMMPDZ256rri,
          7984 => Opcode::VFIXUPIMMPDZ256rrik,
          7985 => Opcode::VFIXUPIMMPDZ256rrikz,
          7986 => Opcode::VFIXUPIMMPDZrmbi,
          7987 => Opcode::VFIXUPIMMPDZrmbik,
          7988 => Opcode::VFIXUPIMMPDZrmbikz,
          7989 => Opcode::VFIXUPIMMPDZrmi,
          7990 => Opcode::VFIXUPIMMPDZrmik,
          7991 => Opcode::VFIXUPIMMPDZrmikz,
          7992 => Opcode::VFIXUPIMMPDZrri,
          7993 => Opcode::VFIXUPIMMPDZrrib,
          7994 => Opcode::VFIXUPIMMPDZrribk,
          7995 => Opcode::VFIXUPIMMPDZrribkz,
          7996 => Opcode::VFIXUPIMMPDZrrik,
          7997 => Opcode::VFIXUPIMMPDZrrikz,
          7998 => Opcode::VFIXUPIMMPSZ128rmbi,
          7999 => Opcode::VFIXUPIMMPSZ128rmbik,
          8000 => Opcode::VFIXUPIMMPSZ128rmbikz,
          8001 => Opcode::VFIXUPIMMPSZ128rmi,
          8002 => Opcode::VFIXUPIMMPSZ128rmik,
          8003 => Opcode::VFIXUPIMMPSZ128rmikz,
          8004 => Opcode::VFIXUPIMMPSZ128rri,
          8005 => Opcode::VFIXUPIMMPSZ128rrik,
          8006 => Opcode::VFIXUPIMMPSZ128rrikz,
          8007 => Opcode::VFIXUPIMMPSZ256rmbi,
          8008 => Opcode::VFIXUPIMMPSZ256rmbik,
          8009 => Opcode::VFIXUPIMMPSZ256rmbikz,
          8010 => Opcode::VFIXUPIMMPSZ256rmi,
          8011 => Opcode::VFIXUPIMMPSZ256rmik,
          8012 => Opcode::VFIXUPIMMPSZ256rmikz,
          8013 => Opcode::VFIXUPIMMPSZ256rri,
          8014 => Opcode::VFIXUPIMMPSZ256rrik,
          8015 => Opcode::VFIXUPIMMPSZ256rrikz,
          8016 => Opcode::VFIXUPIMMPSZrmbi,
          8017 => Opcode::VFIXUPIMMPSZrmbik,
          8018 => Opcode::VFIXUPIMMPSZrmbikz,
          8019 => Opcode::VFIXUPIMMPSZrmi,
          8020 => Opcode::VFIXUPIMMPSZrmik,
          8021 => Opcode::VFIXUPIMMPSZrmikz,
          8022 => Opcode::VFIXUPIMMPSZrri,
          8023 => Opcode::VFIXUPIMMPSZrrib,
          8024 => Opcode::VFIXUPIMMPSZrribk,
          8025 => Opcode::VFIXUPIMMPSZrribkz,
          8026 => Opcode::VFIXUPIMMPSZrrik,
          8027 => Opcode::VFIXUPIMMPSZrrikz,
          8028 => Opcode::VFIXUPIMMSDZrmi,
          8029 => Opcode::VFIXUPIMMSDZrmik,
          8030 => Opcode::VFIXUPIMMSDZrmikz,
          8031 => Opcode::VFIXUPIMMSDZrri,
          8032 => Opcode::VFIXUPIMMSDZrrib,
          8033 => Opcode::VFIXUPIMMSDZrribk,
          8034 => Opcode::VFIXUPIMMSDZrribkz,
          8035 => Opcode::VFIXUPIMMSDZrrik,
          8036 => Opcode::VFIXUPIMMSDZrrikz,
          8037 => Opcode::VFIXUPIMMSSZrmi,
          8038 => Opcode::VFIXUPIMMSSZrmik,
          8039 => Opcode::VFIXUPIMMSSZrmikz,
          8040 => Opcode::VFIXUPIMMSSZrri,
          8041 => Opcode::VFIXUPIMMSSZrrib,
          8042 => Opcode::VFIXUPIMMSSZrribk,
          8043 => Opcode::VFIXUPIMMSSZrribkz,
          8044 => Opcode::VFIXUPIMMSSZrrik,
          8045 => Opcode::VFIXUPIMMSSZrrikz,
          8046 => Opcode::VFMADD132PDYm,
          8047 => Opcode::VFMADD132PDYr,
          8048 => Opcode::VFMADD132PDZ128m,
          8049 => Opcode::VFMADD132PDZ128mb,
          8050 => Opcode::VFMADD132PDZ128mbk,
          8051 => Opcode::VFMADD132PDZ128mbkz,
          8052 => Opcode::VFMADD132PDZ128mk,
          8053 => Opcode::VFMADD132PDZ128mkz,
          8054 => Opcode::VFMADD132PDZ128r,
          8055 => Opcode::VFMADD132PDZ128rk,
          8056 => Opcode::VFMADD132PDZ128rkz,
          8057 => Opcode::VFMADD132PDZ256m,
          8058 => Opcode::VFMADD132PDZ256mb,
          8059 => Opcode::VFMADD132PDZ256mbk,
          8060 => Opcode::VFMADD132PDZ256mbkz,
          8061 => Opcode::VFMADD132PDZ256mk,
          8062 => Opcode::VFMADD132PDZ256mkz,
          8063 => Opcode::VFMADD132PDZ256r,
          8064 => Opcode::VFMADD132PDZ256rk,
          8065 => Opcode::VFMADD132PDZ256rkz,
          8066 => Opcode::VFMADD132PDZm,
          8067 => Opcode::VFMADD132PDZmb,
          8068 => Opcode::VFMADD132PDZmbk,
          8069 => Opcode::VFMADD132PDZmbkz,
          8070 => Opcode::VFMADD132PDZmk,
          8071 => Opcode::VFMADD132PDZmkz,
          8072 => Opcode::VFMADD132PDZr,
          8073 => Opcode::VFMADD132PDZrb,
          8074 => Opcode::VFMADD132PDZrbk,
          8075 => Opcode::VFMADD132PDZrbkz,
          8076 => Opcode::VFMADD132PDZrk,
          8077 => Opcode::VFMADD132PDZrkz,
          8078 => Opcode::VFMADD132PDm,
          8079 => Opcode::VFMADD132PDr,
          8080 => Opcode::VFMADD132PHZ128m,
          8081 => Opcode::VFMADD132PHZ128mb,
          8082 => Opcode::VFMADD132PHZ128mbk,
          8083 => Opcode::VFMADD132PHZ128mbkz,
          8084 => Opcode::VFMADD132PHZ128mk,
          8085 => Opcode::VFMADD132PHZ128mkz,
          8086 => Opcode::VFMADD132PHZ128r,
          8087 => Opcode::VFMADD132PHZ128rk,
          8088 => Opcode::VFMADD132PHZ128rkz,
          8089 => Opcode::VFMADD132PHZ256m,
          8090 => Opcode::VFMADD132PHZ256mb,
          8091 => Opcode::VFMADD132PHZ256mbk,
          8092 => Opcode::VFMADD132PHZ256mbkz,
          8093 => Opcode::VFMADD132PHZ256mk,
          8094 => Opcode::VFMADD132PHZ256mkz,
          8095 => Opcode::VFMADD132PHZ256r,
          8096 => Opcode::VFMADD132PHZ256rk,
          8097 => Opcode::VFMADD132PHZ256rkz,
          8098 => Opcode::VFMADD132PHZm,
          8099 => Opcode::VFMADD132PHZmb,
          8100 => Opcode::VFMADD132PHZmbk,
          8101 => Opcode::VFMADD132PHZmbkz,
          8102 => Opcode::VFMADD132PHZmk,
          8103 => Opcode::VFMADD132PHZmkz,
          8104 => Opcode::VFMADD132PHZr,
          8105 => Opcode::VFMADD132PHZrb,
          8106 => Opcode::VFMADD132PHZrbk,
          8107 => Opcode::VFMADD132PHZrbkz,
          8108 => Opcode::VFMADD132PHZrk,
          8109 => Opcode::VFMADD132PHZrkz,
          8110 => Opcode::VFMADD132PSYm,
          8111 => Opcode::VFMADD132PSYr,
          8112 => Opcode::VFMADD132PSZ128m,
          8113 => Opcode::VFMADD132PSZ128mb,
          8114 => Opcode::VFMADD132PSZ128mbk,
          8115 => Opcode::VFMADD132PSZ128mbkz,
          8116 => Opcode::VFMADD132PSZ128mk,
          8117 => Opcode::VFMADD132PSZ128mkz,
          8118 => Opcode::VFMADD132PSZ128r,
          8119 => Opcode::VFMADD132PSZ128rk,
          8120 => Opcode::VFMADD132PSZ128rkz,
          8121 => Opcode::VFMADD132PSZ256m,
          8122 => Opcode::VFMADD132PSZ256mb,
          8123 => Opcode::VFMADD132PSZ256mbk,
          8124 => Opcode::VFMADD132PSZ256mbkz,
          8125 => Opcode::VFMADD132PSZ256mk,
          8126 => Opcode::VFMADD132PSZ256mkz,
          8127 => Opcode::VFMADD132PSZ256r,
          8128 => Opcode::VFMADD132PSZ256rk,
          8129 => Opcode::VFMADD132PSZ256rkz,
          8130 => Opcode::VFMADD132PSZm,
          8131 => Opcode::VFMADD132PSZmb,
          8132 => Opcode::VFMADD132PSZmbk,
          8133 => Opcode::VFMADD132PSZmbkz,
          8134 => Opcode::VFMADD132PSZmk,
          8135 => Opcode::VFMADD132PSZmkz,
          8136 => Opcode::VFMADD132PSZr,
          8137 => Opcode::VFMADD132PSZrb,
          8138 => Opcode::VFMADD132PSZrbk,
          8139 => Opcode::VFMADD132PSZrbkz,
          8140 => Opcode::VFMADD132PSZrk,
          8141 => Opcode::VFMADD132PSZrkz,
          8142 => Opcode::VFMADD132PSm,
          8143 => Opcode::VFMADD132PSr,
          8144 => Opcode::VFMADD132SDZm,
          8145 => Opcode::VFMADD132SDZm_Int,
          8146 => Opcode::VFMADD132SDZm_Intk,
          8147 => Opcode::VFMADD132SDZm_Intkz,
          8148 => Opcode::VFMADD132SDZr,
          8149 => Opcode::VFMADD132SDZr_Int,
          8150 => Opcode::VFMADD132SDZr_Intk,
          8151 => Opcode::VFMADD132SDZr_Intkz,
          8152 => Opcode::VFMADD132SDZrb,
          8153 => Opcode::VFMADD132SDZrb_Int,
          8154 => Opcode::VFMADD132SDZrb_Intk,
          8155 => Opcode::VFMADD132SDZrb_Intkz,
          8156 => Opcode::VFMADD132SDm,
          8157 => Opcode::VFMADD132SDm_Int,
          8158 => Opcode::VFMADD132SDr,
          8159 => Opcode::VFMADD132SDr_Int,
          8160 => Opcode::VFMADD132SHZm,
          8161 => Opcode::VFMADD132SHZm_Int,
          8162 => Opcode::VFMADD132SHZm_Intk,
          8163 => Opcode::VFMADD132SHZm_Intkz,
          8164 => Opcode::VFMADD132SHZr,
          8165 => Opcode::VFMADD132SHZr_Int,
          8166 => Opcode::VFMADD132SHZr_Intk,
          8167 => Opcode::VFMADD132SHZr_Intkz,
          8168 => Opcode::VFMADD132SHZrb,
          8169 => Opcode::VFMADD132SHZrb_Int,
          8170 => Opcode::VFMADD132SHZrb_Intk,
          8171 => Opcode::VFMADD132SHZrb_Intkz,
          8172 => Opcode::VFMADD132SSZm,
          8173 => Opcode::VFMADD132SSZm_Int,
          8174 => Opcode::VFMADD132SSZm_Intk,
          8175 => Opcode::VFMADD132SSZm_Intkz,
          8176 => Opcode::VFMADD132SSZr,
          8177 => Opcode::VFMADD132SSZr_Int,
          8178 => Opcode::VFMADD132SSZr_Intk,
          8179 => Opcode::VFMADD132SSZr_Intkz,
          8180 => Opcode::VFMADD132SSZrb,
          8181 => Opcode::VFMADD132SSZrb_Int,
          8182 => Opcode::VFMADD132SSZrb_Intk,
          8183 => Opcode::VFMADD132SSZrb_Intkz,
          8184 => Opcode::VFMADD132SSm,
          8185 => Opcode::VFMADD132SSm_Int,
          8186 => Opcode::VFMADD132SSr,
          8187 => Opcode::VFMADD132SSr_Int,
          8188 => Opcode::VFMADD213PDYm,
          8189 => Opcode::VFMADD213PDYr,
          8190 => Opcode::VFMADD213PDZ128m,
          8191 => Opcode::VFMADD213PDZ128mb,
          8192 => Opcode::VFMADD213PDZ128mbk,
          8193 => Opcode::VFMADD213PDZ128mbkz,
          8194 => Opcode::VFMADD213PDZ128mk,
          8195 => Opcode::VFMADD213PDZ128mkz,
          8196 => Opcode::VFMADD213PDZ128r,
          8197 => Opcode::VFMADD213PDZ128rk,
          8198 => Opcode::VFMADD213PDZ128rkz,
          8199 => Opcode::VFMADD213PDZ256m,
          8200 => Opcode::VFMADD213PDZ256mb,
          8201 => Opcode::VFMADD213PDZ256mbk,
          8202 => Opcode::VFMADD213PDZ256mbkz,
          8203 => Opcode::VFMADD213PDZ256mk,
          8204 => Opcode::VFMADD213PDZ256mkz,
          8205 => Opcode::VFMADD213PDZ256r,
          8206 => Opcode::VFMADD213PDZ256rk,
          8207 => Opcode::VFMADD213PDZ256rkz,
          8208 => Opcode::VFMADD213PDZm,
          8209 => Opcode::VFMADD213PDZmb,
          8210 => Opcode::VFMADD213PDZmbk,
          8211 => Opcode::VFMADD213PDZmbkz,
          8212 => Opcode::VFMADD213PDZmk,
          8213 => Opcode::VFMADD213PDZmkz,
          8214 => Opcode::VFMADD213PDZr,
          8215 => Opcode::VFMADD213PDZrb,
          8216 => Opcode::VFMADD213PDZrbk,
          8217 => Opcode::VFMADD213PDZrbkz,
          8218 => Opcode::VFMADD213PDZrk,
          8219 => Opcode::VFMADD213PDZrkz,
          8220 => Opcode::VFMADD213PDm,
          8221 => Opcode::VFMADD213PDr,
          8222 => Opcode::VFMADD213PHZ128m,
          8223 => Opcode::VFMADD213PHZ128mb,
          8224 => Opcode::VFMADD213PHZ128mbk,
          8225 => Opcode::VFMADD213PHZ128mbkz,
          8226 => Opcode::VFMADD213PHZ128mk,
          8227 => Opcode::VFMADD213PHZ128mkz,
          8228 => Opcode::VFMADD213PHZ128r,
          8229 => Opcode::VFMADD213PHZ128rk,
          8230 => Opcode::VFMADD213PHZ128rkz,
          8231 => Opcode::VFMADD213PHZ256m,
          8232 => Opcode::VFMADD213PHZ256mb,
          8233 => Opcode::VFMADD213PHZ256mbk,
          8234 => Opcode::VFMADD213PHZ256mbkz,
          8235 => Opcode::VFMADD213PHZ256mk,
          8236 => Opcode::VFMADD213PHZ256mkz,
          8237 => Opcode::VFMADD213PHZ256r,
          8238 => Opcode::VFMADD213PHZ256rk,
          8239 => Opcode::VFMADD213PHZ256rkz,
          8240 => Opcode::VFMADD213PHZm,
          8241 => Opcode::VFMADD213PHZmb,
          8242 => Opcode::VFMADD213PHZmbk,
          8243 => Opcode::VFMADD213PHZmbkz,
          8244 => Opcode::VFMADD213PHZmk,
          8245 => Opcode::VFMADD213PHZmkz,
          8246 => Opcode::VFMADD213PHZr,
          8247 => Opcode::VFMADD213PHZrb,
          8248 => Opcode::VFMADD213PHZrbk,
          8249 => Opcode::VFMADD213PHZrbkz,
          8250 => Opcode::VFMADD213PHZrk,
          8251 => Opcode::VFMADD213PHZrkz,
          8252 => Opcode::VFMADD213PSYm,
          8253 => Opcode::VFMADD213PSYr,
          8254 => Opcode::VFMADD213PSZ128m,
          8255 => Opcode::VFMADD213PSZ128mb,
          8256 => Opcode::VFMADD213PSZ128mbk,
          8257 => Opcode::VFMADD213PSZ128mbkz,
          8258 => Opcode::VFMADD213PSZ128mk,
          8259 => Opcode::VFMADD213PSZ128mkz,
          8260 => Opcode::VFMADD213PSZ128r,
          8261 => Opcode::VFMADD213PSZ128rk,
          8262 => Opcode::VFMADD213PSZ128rkz,
          8263 => Opcode::VFMADD213PSZ256m,
          8264 => Opcode::VFMADD213PSZ256mb,
          8265 => Opcode::VFMADD213PSZ256mbk,
          8266 => Opcode::VFMADD213PSZ256mbkz,
          8267 => Opcode::VFMADD213PSZ256mk,
          8268 => Opcode::VFMADD213PSZ256mkz,
          8269 => Opcode::VFMADD213PSZ256r,
          8270 => Opcode::VFMADD213PSZ256rk,
          8271 => Opcode::VFMADD213PSZ256rkz,
          8272 => Opcode::VFMADD213PSZm,
          8273 => Opcode::VFMADD213PSZmb,
          8274 => Opcode::VFMADD213PSZmbk,
          8275 => Opcode::VFMADD213PSZmbkz,
          8276 => Opcode::VFMADD213PSZmk,
          8277 => Opcode::VFMADD213PSZmkz,
          8278 => Opcode::VFMADD213PSZr,
          8279 => Opcode::VFMADD213PSZrb,
          8280 => Opcode::VFMADD213PSZrbk,
          8281 => Opcode::VFMADD213PSZrbkz,
          8282 => Opcode::VFMADD213PSZrk,
          8283 => Opcode::VFMADD213PSZrkz,
          8284 => Opcode::VFMADD213PSm,
          8285 => Opcode::VFMADD213PSr,
          8286 => Opcode::VFMADD213SDZm,
          8287 => Opcode::VFMADD213SDZm_Int,
          8288 => Opcode::VFMADD213SDZm_Intk,
          8289 => Opcode::VFMADD213SDZm_Intkz,
          8290 => Opcode::VFMADD213SDZr,
          8291 => Opcode::VFMADD213SDZr_Int,
          8292 => Opcode::VFMADD213SDZr_Intk,
          8293 => Opcode::VFMADD213SDZr_Intkz,
          8294 => Opcode::VFMADD213SDZrb,
          8295 => Opcode::VFMADD213SDZrb_Int,
          8296 => Opcode::VFMADD213SDZrb_Intk,
          8297 => Opcode::VFMADD213SDZrb_Intkz,
          8298 => Opcode::VFMADD213SDm,
          8299 => Opcode::VFMADD213SDm_Int,
          8300 => Opcode::VFMADD213SDr,
          8301 => Opcode::VFMADD213SDr_Int,
          8302 => Opcode::VFMADD213SHZm,
          8303 => Opcode::VFMADD213SHZm_Int,
          8304 => Opcode::VFMADD213SHZm_Intk,
          8305 => Opcode::VFMADD213SHZm_Intkz,
          8306 => Opcode::VFMADD213SHZr,
          8307 => Opcode::VFMADD213SHZr_Int,
          8308 => Opcode::VFMADD213SHZr_Intk,
          8309 => Opcode::VFMADD213SHZr_Intkz,
          8310 => Opcode::VFMADD213SHZrb,
          8311 => Opcode::VFMADD213SHZrb_Int,
          8312 => Opcode::VFMADD213SHZrb_Intk,
          8313 => Opcode::VFMADD213SHZrb_Intkz,
          8314 => Opcode::VFMADD213SSZm,
          8315 => Opcode::VFMADD213SSZm_Int,
          8316 => Opcode::VFMADD213SSZm_Intk,
          8317 => Opcode::VFMADD213SSZm_Intkz,
          8318 => Opcode::VFMADD213SSZr,
          8319 => Opcode::VFMADD213SSZr_Int,
          8320 => Opcode::VFMADD213SSZr_Intk,
          8321 => Opcode::VFMADD213SSZr_Intkz,
          8322 => Opcode::VFMADD213SSZrb,
          8323 => Opcode::VFMADD213SSZrb_Int,
          8324 => Opcode::VFMADD213SSZrb_Intk,
          8325 => Opcode::VFMADD213SSZrb_Intkz,
          8326 => Opcode::VFMADD213SSm,
          8327 => Opcode::VFMADD213SSm_Int,
          8328 => Opcode::VFMADD213SSr,
          8329 => Opcode::VFMADD213SSr_Int,
          8330 => Opcode::VFMADD231PDYm,
          8331 => Opcode::VFMADD231PDYr,
          8332 => Opcode::VFMADD231PDZ128m,
          8333 => Opcode::VFMADD231PDZ128mb,
          8334 => Opcode::VFMADD231PDZ128mbk,
          8335 => Opcode::VFMADD231PDZ128mbkz,
          8336 => Opcode::VFMADD231PDZ128mk,
          8337 => Opcode::VFMADD231PDZ128mkz,
          8338 => Opcode::VFMADD231PDZ128r,
          8339 => Opcode::VFMADD231PDZ128rk,
          8340 => Opcode::VFMADD231PDZ128rkz,
          8341 => Opcode::VFMADD231PDZ256m,
          8342 => Opcode::VFMADD231PDZ256mb,
          8343 => Opcode::VFMADD231PDZ256mbk,
          8344 => Opcode::VFMADD231PDZ256mbkz,
          8345 => Opcode::VFMADD231PDZ256mk,
          8346 => Opcode::VFMADD231PDZ256mkz,
          8347 => Opcode::VFMADD231PDZ256r,
          8348 => Opcode::VFMADD231PDZ256rk,
          8349 => Opcode::VFMADD231PDZ256rkz,
          8350 => Opcode::VFMADD231PDZm,
          8351 => Opcode::VFMADD231PDZmb,
          8352 => Opcode::VFMADD231PDZmbk,
          8353 => Opcode::VFMADD231PDZmbkz,
          8354 => Opcode::VFMADD231PDZmk,
          8355 => Opcode::VFMADD231PDZmkz,
          8356 => Opcode::VFMADD231PDZr,
          8357 => Opcode::VFMADD231PDZrb,
          8358 => Opcode::VFMADD231PDZrbk,
          8359 => Opcode::VFMADD231PDZrbkz,
          8360 => Opcode::VFMADD231PDZrk,
          8361 => Opcode::VFMADD231PDZrkz,
          8362 => Opcode::VFMADD231PDm,
          8363 => Opcode::VFMADD231PDr,
          8364 => Opcode::VFMADD231PHZ128m,
          8365 => Opcode::VFMADD231PHZ128mb,
          8366 => Opcode::VFMADD231PHZ128mbk,
          8367 => Opcode::VFMADD231PHZ128mbkz,
          8368 => Opcode::VFMADD231PHZ128mk,
          8369 => Opcode::VFMADD231PHZ128mkz,
          8370 => Opcode::VFMADD231PHZ128r,
          8371 => Opcode::VFMADD231PHZ128rk,
          8372 => Opcode::VFMADD231PHZ128rkz,
          8373 => Opcode::VFMADD231PHZ256m,
          8374 => Opcode::VFMADD231PHZ256mb,
          8375 => Opcode::VFMADD231PHZ256mbk,
          8376 => Opcode::VFMADD231PHZ256mbkz,
          8377 => Opcode::VFMADD231PHZ256mk,
          8378 => Opcode::VFMADD231PHZ256mkz,
          8379 => Opcode::VFMADD231PHZ256r,
          8380 => Opcode::VFMADD231PHZ256rk,
          8381 => Opcode::VFMADD231PHZ256rkz,
          8382 => Opcode::VFMADD231PHZm,
          8383 => Opcode::VFMADD231PHZmb,
          8384 => Opcode::VFMADD231PHZmbk,
          8385 => Opcode::VFMADD231PHZmbkz,
          8386 => Opcode::VFMADD231PHZmk,
          8387 => Opcode::VFMADD231PHZmkz,
          8388 => Opcode::VFMADD231PHZr,
          8389 => Opcode::VFMADD231PHZrb,
          8390 => Opcode::VFMADD231PHZrbk,
          8391 => Opcode::VFMADD231PHZrbkz,
          8392 => Opcode::VFMADD231PHZrk,
          8393 => Opcode::VFMADD231PHZrkz,
          8394 => Opcode::VFMADD231PSYm,
          8395 => Opcode::VFMADD231PSYr,
          8396 => Opcode::VFMADD231PSZ128m,
          8397 => Opcode::VFMADD231PSZ128mb,
          8398 => Opcode::VFMADD231PSZ128mbk,
          8399 => Opcode::VFMADD231PSZ128mbkz,
          8400 => Opcode::VFMADD231PSZ128mk,
          8401 => Opcode::VFMADD231PSZ128mkz,
          8402 => Opcode::VFMADD231PSZ128r,
          8403 => Opcode::VFMADD231PSZ128rk,
          8404 => Opcode::VFMADD231PSZ128rkz,
          8405 => Opcode::VFMADD231PSZ256m,
          8406 => Opcode::VFMADD231PSZ256mb,
          8407 => Opcode::VFMADD231PSZ256mbk,
          8408 => Opcode::VFMADD231PSZ256mbkz,
          8409 => Opcode::VFMADD231PSZ256mk,
          8410 => Opcode::VFMADD231PSZ256mkz,
          8411 => Opcode::VFMADD231PSZ256r,
          8412 => Opcode::VFMADD231PSZ256rk,
          8413 => Opcode::VFMADD231PSZ256rkz,
          8414 => Opcode::VFMADD231PSZm,
          8415 => Opcode::VFMADD231PSZmb,
          8416 => Opcode::VFMADD231PSZmbk,
          8417 => Opcode::VFMADD231PSZmbkz,
          8418 => Opcode::VFMADD231PSZmk,
          8419 => Opcode::VFMADD231PSZmkz,
          8420 => Opcode::VFMADD231PSZr,
          8421 => Opcode::VFMADD231PSZrb,
          8422 => Opcode::VFMADD231PSZrbk,
          8423 => Opcode::VFMADD231PSZrbkz,
          8424 => Opcode::VFMADD231PSZrk,
          8425 => Opcode::VFMADD231PSZrkz,
          8426 => Opcode::VFMADD231PSm,
          8427 => Opcode::VFMADD231PSr,
          8428 => Opcode::VFMADD231SDZm,
          8429 => Opcode::VFMADD231SDZm_Int,
          8430 => Opcode::VFMADD231SDZm_Intk,
          8431 => Opcode::VFMADD231SDZm_Intkz,
          8432 => Opcode::VFMADD231SDZr,
          8433 => Opcode::VFMADD231SDZr_Int,
          8434 => Opcode::VFMADD231SDZr_Intk,
          8435 => Opcode::VFMADD231SDZr_Intkz,
          8436 => Opcode::VFMADD231SDZrb,
          8437 => Opcode::VFMADD231SDZrb_Int,
          8438 => Opcode::VFMADD231SDZrb_Intk,
          8439 => Opcode::VFMADD231SDZrb_Intkz,
          8440 => Opcode::VFMADD231SDm,
          8441 => Opcode::VFMADD231SDm_Int,
          8442 => Opcode::VFMADD231SDr,
          8443 => Opcode::VFMADD231SDr_Int,
          8444 => Opcode::VFMADD231SHZm,
          8445 => Opcode::VFMADD231SHZm_Int,
          8446 => Opcode::VFMADD231SHZm_Intk,
          8447 => Opcode::VFMADD231SHZm_Intkz,
          8448 => Opcode::VFMADD231SHZr,
          8449 => Opcode::VFMADD231SHZr_Int,
          8450 => Opcode::VFMADD231SHZr_Intk,
          8451 => Opcode::VFMADD231SHZr_Intkz,
          8452 => Opcode::VFMADD231SHZrb,
          8453 => Opcode::VFMADD231SHZrb_Int,
          8454 => Opcode::VFMADD231SHZrb_Intk,
          8455 => Opcode::VFMADD231SHZrb_Intkz,
          8456 => Opcode::VFMADD231SSZm,
          8457 => Opcode::VFMADD231SSZm_Int,
          8458 => Opcode::VFMADD231SSZm_Intk,
          8459 => Opcode::VFMADD231SSZm_Intkz,
          8460 => Opcode::VFMADD231SSZr,
          8461 => Opcode::VFMADD231SSZr_Int,
          8462 => Opcode::VFMADD231SSZr_Intk,
          8463 => Opcode::VFMADD231SSZr_Intkz,
          8464 => Opcode::VFMADD231SSZrb,
          8465 => Opcode::VFMADD231SSZrb_Int,
          8466 => Opcode::VFMADD231SSZrb_Intk,
          8467 => Opcode::VFMADD231SSZrb_Intkz,
          8468 => Opcode::VFMADD231SSm,
          8469 => Opcode::VFMADD231SSm_Int,
          8470 => Opcode::VFMADD231SSr,
          8471 => Opcode::VFMADD231SSr_Int,
          8472 => Opcode::VFMADDCPHZ128m,
          8473 => Opcode::VFMADDCPHZ128mb,
          8474 => Opcode::VFMADDCPHZ128mbk,
          8475 => Opcode::VFMADDCPHZ128mbkz,
          8476 => Opcode::VFMADDCPHZ128mk,
          8477 => Opcode::VFMADDCPHZ128mkz,
          8478 => Opcode::VFMADDCPHZ128r,
          8479 => Opcode::VFMADDCPHZ128rk,
          8480 => Opcode::VFMADDCPHZ128rkz,
          8481 => Opcode::VFMADDCPHZ256m,
          8482 => Opcode::VFMADDCPHZ256mb,
          8483 => Opcode::VFMADDCPHZ256mbk,
          8484 => Opcode::VFMADDCPHZ256mbkz,
          8485 => Opcode::VFMADDCPHZ256mk,
          8486 => Opcode::VFMADDCPHZ256mkz,
          8487 => Opcode::VFMADDCPHZ256r,
          8488 => Opcode::VFMADDCPHZ256rk,
          8489 => Opcode::VFMADDCPHZ256rkz,
          8490 => Opcode::VFMADDCPHZm,
          8491 => Opcode::VFMADDCPHZmb,
          8492 => Opcode::VFMADDCPHZmbk,
          8493 => Opcode::VFMADDCPHZmbkz,
          8494 => Opcode::VFMADDCPHZmk,
          8495 => Opcode::VFMADDCPHZmkz,
          8496 => Opcode::VFMADDCPHZr,
          8497 => Opcode::VFMADDCPHZrb,
          8498 => Opcode::VFMADDCPHZrbk,
          8499 => Opcode::VFMADDCPHZrbkz,
          8500 => Opcode::VFMADDCPHZrk,
          8501 => Opcode::VFMADDCPHZrkz,
          8502 => Opcode::VFMADDCSHZm,
          8503 => Opcode::VFMADDCSHZmk,
          8504 => Opcode::VFMADDCSHZmkz,
          8505 => Opcode::VFMADDCSHZr,
          8506 => Opcode::VFMADDCSHZrb,
          8507 => Opcode::VFMADDCSHZrbk,
          8508 => Opcode::VFMADDCSHZrbkz,
          8509 => Opcode::VFMADDCSHZrk,
          8510 => Opcode::VFMADDCSHZrkz,
          8511 => Opcode::VFMADDPD4Ymr,
          8512 => Opcode::VFMADDPD4Yrm,
          8513 => Opcode::VFMADDPD4Yrr,
          8514 => Opcode::VFMADDPD4Yrr_REV,
          8515 => Opcode::VFMADDPD4mr,
          8516 => Opcode::VFMADDPD4rm,
          8517 => Opcode::VFMADDPD4rr,
          8518 => Opcode::VFMADDPD4rr_REV,
          8519 => Opcode::VFMADDPS4Ymr,
          8520 => Opcode::VFMADDPS4Yrm,
          8521 => Opcode::VFMADDPS4Yrr,
          8522 => Opcode::VFMADDPS4Yrr_REV,
          8523 => Opcode::VFMADDPS4mr,
          8524 => Opcode::VFMADDPS4rm,
          8525 => Opcode::VFMADDPS4rr,
          8526 => Opcode::VFMADDPS4rr_REV,
          8527 => Opcode::VFMADDSD4mr,
          8528 => Opcode::VFMADDSD4mr_Int,
          8529 => Opcode::VFMADDSD4rm,
          8530 => Opcode::VFMADDSD4rm_Int,
          8531 => Opcode::VFMADDSD4rr,
          8532 => Opcode::VFMADDSD4rr_Int,
          8533 => Opcode::VFMADDSD4rr_Int_REV,
          8534 => Opcode::VFMADDSD4rr_REV,
          8535 => Opcode::VFMADDSS4mr,
          8536 => Opcode::VFMADDSS4mr_Int,
          8537 => Opcode::VFMADDSS4rm,
          8538 => Opcode::VFMADDSS4rm_Int,
          8539 => Opcode::VFMADDSS4rr,
          8540 => Opcode::VFMADDSS4rr_Int,
          8541 => Opcode::VFMADDSS4rr_Int_REV,
          8542 => Opcode::VFMADDSS4rr_REV,
          8543 => Opcode::VFMADDSUB132PDYm,
          8544 => Opcode::VFMADDSUB132PDYr,
          8545 => Opcode::VFMADDSUB132PDZ128m,
          8546 => Opcode::VFMADDSUB132PDZ128mb,
          8547 => Opcode::VFMADDSUB132PDZ128mbk,
          8548 => Opcode::VFMADDSUB132PDZ128mbkz,
          8549 => Opcode::VFMADDSUB132PDZ128mk,
          8550 => Opcode::VFMADDSUB132PDZ128mkz,
          8551 => Opcode::VFMADDSUB132PDZ128r,
          8552 => Opcode::VFMADDSUB132PDZ128rk,
          8553 => Opcode::VFMADDSUB132PDZ128rkz,
          8554 => Opcode::VFMADDSUB132PDZ256m,
          8555 => Opcode::VFMADDSUB132PDZ256mb,
          8556 => Opcode::VFMADDSUB132PDZ256mbk,
          8557 => Opcode::VFMADDSUB132PDZ256mbkz,
          8558 => Opcode::VFMADDSUB132PDZ256mk,
          8559 => Opcode::VFMADDSUB132PDZ256mkz,
          8560 => Opcode::VFMADDSUB132PDZ256r,
          8561 => Opcode::VFMADDSUB132PDZ256rk,
          8562 => Opcode::VFMADDSUB132PDZ256rkz,
          8563 => Opcode::VFMADDSUB132PDZm,
          8564 => Opcode::VFMADDSUB132PDZmb,
          8565 => Opcode::VFMADDSUB132PDZmbk,
          8566 => Opcode::VFMADDSUB132PDZmbkz,
          8567 => Opcode::VFMADDSUB132PDZmk,
          8568 => Opcode::VFMADDSUB132PDZmkz,
          8569 => Opcode::VFMADDSUB132PDZr,
          8570 => Opcode::VFMADDSUB132PDZrb,
          8571 => Opcode::VFMADDSUB132PDZrbk,
          8572 => Opcode::VFMADDSUB132PDZrbkz,
          8573 => Opcode::VFMADDSUB132PDZrk,
          8574 => Opcode::VFMADDSUB132PDZrkz,
          8575 => Opcode::VFMADDSUB132PDm,
          8576 => Opcode::VFMADDSUB132PDr,
          8577 => Opcode::VFMADDSUB132PHZ128m,
          8578 => Opcode::VFMADDSUB132PHZ128mb,
          8579 => Opcode::VFMADDSUB132PHZ128mbk,
          8580 => Opcode::VFMADDSUB132PHZ128mbkz,
          8581 => Opcode::VFMADDSUB132PHZ128mk,
          8582 => Opcode::VFMADDSUB132PHZ128mkz,
          8583 => Opcode::VFMADDSUB132PHZ128r,
          8584 => Opcode::VFMADDSUB132PHZ128rk,
          8585 => Opcode::VFMADDSUB132PHZ128rkz,
          8586 => Opcode::VFMADDSUB132PHZ256m,
          8587 => Opcode::VFMADDSUB132PHZ256mb,
          8588 => Opcode::VFMADDSUB132PHZ256mbk,
          8589 => Opcode::VFMADDSUB132PHZ256mbkz,
          8590 => Opcode::VFMADDSUB132PHZ256mk,
          8591 => Opcode::VFMADDSUB132PHZ256mkz,
          8592 => Opcode::VFMADDSUB132PHZ256r,
          8593 => Opcode::VFMADDSUB132PHZ256rk,
          8594 => Opcode::VFMADDSUB132PHZ256rkz,
          8595 => Opcode::VFMADDSUB132PHZm,
          8596 => Opcode::VFMADDSUB132PHZmb,
          8597 => Opcode::VFMADDSUB132PHZmbk,
          8598 => Opcode::VFMADDSUB132PHZmbkz,
          8599 => Opcode::VFMADDSUB132PHZmk,
          8600 => Opcode::VFMADDSUB132PHZmkz,
          8601 => Opcode::VFMADDSUB132PHZr,
          8602 => Opcode::VFMADDSUB132PHZrb,
          8603 => Opcode::VFMADDSUB132PHZrbk,
          8604 => Opcode::VFMADDSUB132PHZrbkz,
          8605 => Opcode::VFMADDSUB132PHZrk,
          8606 => Opcode::VFMADDSUB132PHZrkz,
          8607 => Opcode::VFMADDSUB132PSYm,
          8608 => Opcode::VFMADDSUB132PSYr,
          8609 => Opcode::VFMADDSUB132PSZ128m,
          8610 => Opcode::VFMADDSUB132PSZ128mb,
          8611 => Opcode::VFMADDSUB132PSZ128mbk,
          8612 => Opcode::VFMADDSUB132PSZ128mbkz,
          8613 => Opcode::VFMADDSUB132PSZ128mk,
          8614 => Opcode::VFMADDSUB132PSZ128mkz,
          8615 => Opcode::VFMADDSUB132PSZ128r,
          8616 => Opcode::VFMADDSUB132PSZ128rk,
          8617 => Opcode::VFMADDSUB132PSZ128rkz,
          8618 => Opcode::VFMADDSUB132PSZ256m,
          8619 => Opcode::VFMADDSUB132PSZ256mb,
          8620 => Opcode::VFMADDSUB132PSZ256mbk,
          8621 => Opcode::VFMADDSUB132PSZ256mbkz,
          8622 => Opcode::VFMADDSUB132PSZ256mk,
          8623 => Opcode::VFMADDSUB132PSZ256mkz,
          8624 => Opcode::VFMADDSUB132PSZ256r,
          8625 => Opcode::VFMADDSUB132PSZ256rk,
          8626 => Opcode::VFMADDSUB132PSZ256rkz,
          8627 => Opcode::VFMADDSUB132PSZm,
          8628 => Opcode::VFMADDSUB132PSZmb,
          8629 => Opcode::VFMADDSUB132PSZmbk,
          8630 => Opcode::VFMADDSUB132PSZmbkz,
          8631 => Opcode::VFMADDSUB132PSZmk,
          8632 => Opcode::VFMADDSUB132PSZmkz,
          8633 => Opcode::VFMADDSUB132PSZr,
          8634 => Opcode::VFMADDSUB132PSZrb,
          8635 => Opcode::VFMADDSUB132PSZrbk,
          8636 => Opcode::VFMADDSUB132PSZrbkz,
          8637 => Opcode::VFMADDSUB132PSZrk,
          8638 => Opcode::VFMADDSUB132PSZrkz,
          8639 => Opcode::VFMADDSUB132PSm,
          8640 => Opcode::VFMADDSUB132PSr,
          8641 => Opcode::VFMADDSUB213PDYm,
          8642 => Opcode::VFMADDSUB213PDYr,
          8643 => Opcode::VFMADDSUB213PDZ128m,
          8644 => Opcode::VFMADDSUB213PDZ128mb,
          8645 => Opcode::VFMADDSUB213PDZ128mbk,
          8646 => Opcode::VFMADDSUB213PDZ128mbkz,
          8647 => Opcode::VFMADDSUB213PDZ128mk,
          8648 => Opcode::VFMADDSUB213PDZ128mkz,
          8649 => Opcode::VFMADDSUB213PDZ128r,
          8650 => Opcode::VFMADDSUB213PDZ128rk,
          8651 => Opcode::VFMADDSUB213PDZ128rkz,
          8652 => Opcode::VFMADDSUB213PDZ256m,
          8653 => Opcode::VFMADDSUB213PDZ256mb,
          8654 => Opcode::VFMADDSUB213PDZ256mbk,
          8655 => Opcode::VFMADDSUB213PDZ256mbkz,
          8656 => Opcode::VFMADDSUB213PDZ256mk,
          8657 => Opcode::VFMADDSUB213PDZ256mkz,
          8658 => Opcode::VFMADDSUB213PDZ256r,
          8659 => Opcode::VFMADDSUB213PDZ256rk,
          8660 => Opcode::VFMADDSUB213PDZ256rkz,
          8661 => Opcode::VFMADDSUB213PDZm,
          8662 => Opcode::VFMADDSUB213PDZmb,
          8663 => Opcode::VFMADDSUB213PDZmbk,
          8664 => Opcode::VFMADDSUB213PDZmbkz,
          8665 => Opcode::VFMADDSUB213PDZmk,
          8666 => Opcode::VFMADDSUB213PDZmkz,
          8667 => Opcode::VFMADDSUB213PDZr,
          8668 => Opcode::VFMADDSUB213PDZrb,
          8669 => Opcode::VFMADDSUB213PDZrbk,
          8670 => Opcode::VFMADDSUB213PDZrbkz,
          8671 => Opcode::VFMADDSUB213PDZrk,
          8672 => Opcode::VFMADDSUB213PDZrkz,
          8673 => Opcode::VFMADDSUB213PDm,
          8674 => Opcode::VFMADDSUB213PDr,
          8675 => Opcode::VFMADDSUB213PHZ128m,
          8676 => Opcode::VFMADDSUB213PHZ128mb,
          8677 => Opcode::VFMADDSUB213PHZ128mbk,
          8678 => Opcode::VFMADDSUB213PHZ128mbkz,
          8679 => Opcode::VFMADDSUB213PHZ128mk,
          8680 => Opcode::VFMADDSUB213PHZ128mkz,
          8681 => Opcode::VFMADDSUB213PHZ128r,
          8682 => Opcode::VFMADDSUB213PHZ128rk,
          8683 => Opcode::VFMADDSUB213PHZ128rkz,
          8684 => Opcode::VFMADDSUB213PHZ256m,
          8685 => Opcode::VFMADDSUB213PHZ256mb,
          8686 => Opcode::VFMADDSUB213PHZ256mbk,
          8687 => Opcode::VFMADDSUB213PHZ256mbkz,
          8688 => Opcode::VFMADDSUB213PHZ256mk,
          8689 => Opcode::VFMADDSUB213PHZ256mkz,
          8690 => Opcode::VFMADDSUB213PHZ256r,
          8691 => Opcode::VFMADDSUB213PHZ256rk,
          8692 => Opcode::VFMADDSUB213PHZ256rkz,
          8693 => Opcode::VFMADDSUB213PHZm,
          8694 => Opcode::VFMADDSUB213PHZmb,
          8695 => Opcode::VFMADDSUB213PHZmbk,
          8696 => Opcode::VFMADDSUB213PHZmbkz,
          8697 => Opcode::VFMADDSUB213PHZmk,
          8698 => Opcode::VFMADDSUB213PHZmkz,
          8699 => Opcode::VFMADDSUB213PHZr,
          8700 => Opcode::VFMADDSUB213PHZrb,
          8701 => Opcode::VFMADDSUB213PHZrbk,
          8702 => Opcode::VFMADDSUB213PHZrbkz,
          8703 => Opcode::VFMADDSUB213PHZrk,
          8704 => Opcode::VFMADDSUB213PHZrkz,
          8705 => Opcode::VFMADDSUB213PSYm,
          8706 => Opcode::VFMADDSUB213PSYr,
          8707 => Opcode::VFMADDSUB213PSZ128m,
          8708 => Opcode::VFMADDSUB213PSZ128mb,
          8709 => Opcode::VFMADDSUB213PSZ128mbk,
          8710 => Opcode::VFMADDSUB213PSZ128mbkz,
          8711 => Opcode::VFMADDSUB213PSZ128mk,
          8712 => Opcode::VFMADDSUB213PSZ128mkz,
          8713 => Opcode::VFMADDSUB213PSZ128r,
          8714 => Opcode::VFMADDSUB213PSZ128rk,
          8715 => Opcode::VFMADDSUB213PSZ128rkz,
          8716 => Opcode::VFMADDSUB213PSZ256m,
          8717 => Opcode::VFMADDSUB213PSZ256mb,
          8718 => Opcode::VFMADDSUB213PSZ256mbk,
          8719 => Opcode::VFMADDSUB213PSZ256mbkz,
          8720 => Opcode::VFMADDSUB213PSZ256mk,
          8721 => Opcode::VFMADDSUB213PSZ256mkz,
          8722 => Opcode::VFMADDSUB213PSZ256r,
          8723 => Opcode::VFMADDSUB213PSZ256rk,
          8724 => Opcode::VFMADDSUB213PSZ256rkz,
          8725 => Opcode::VFMADDSUB213PSZm,
          8726 => Opcode::VFMADDSUB213PSZmb,
          8727 => Opcode::VFMADDSUB213PSZmbk,
          8728 => Opcode::VFMADDSUB213PSZmbkz,
          8729 => Opcode::VFMADDSUB213PSZmk,
          8730 => Opcode::VFMADDSUB213PSZmkz,
          8731 => Opcode::VFMADDSUB213PSZr,
          8732 => Opcode::VFMADDSUB213PSZrb,
          8733 => Opcode::VFMADDSUB213PSZrbk,
          8734 => Opcode::VFMADDSUB213PSZrbkz,
          8735 => Opcode::VFMADDSUB213PSZrk,
          8736 => Opcode::VFMADDSUB213PSZrkz,
          8737 => Opcode::VFMADDSUB213PSm,
          8738 => Opcode::VFMADDSUB213PSr,
          8739 => Opcode::VFMADDSUB231PDYm,
          8740 => Opcode::VFMADDSUB231PDYr,
          8741 => Opcode::VFMADDSUB231PDZ128m,
          8742 => Opcode::VFMADDSUB231PDZ128mb,
          8743 => Opcode::VFMADDSUB231PDZ128mbk,
          8744 => Opcode::VFMADDSUB231PDZ128mbkz,
          8745 => Opcode::VFMADDSUB231PDZ128mk,
          8746 => Opcode::VFMADDSUB231PDZ128mkz,
          8747 => Opcode::VFMADDSUB231PDZ128r,
          8748 => Opcode::VFMADDSUB231PDZ128rk,
          8749 => Opcode::VFMADDSUB231PDZ128rkz,
          8750 => Opcode::VFMADDSUB231PDZ256m,
          8751 => Opcode::VFMADDSUB231PDZ256mb,
          8752 => Opcode::VFMADDSUB231PDZ256mbk,
          8753 => Opcode::VFMADDSUB231PDZ256mbkz,
          8754 => Opcode::VFMADDSUB231PDZ256mk,
          8755 => Opcode::VFMADDSUB231PDZ256mkz,
          8756 => Opcode::VFMADDSUB231PDZ256r,
          8757 => Opcode::VFMADDSUB231PDZ256rk,
          8758 => Opcode::VFMADDSUB231PDZ256rkz,
          8759 => Opcode::VFMADDSUB231PDZm,
          8760 => Opcode::VFMADDSUB231PDZmb,
          8761 => Opcode::VFMADDSUB231PDZmbk,
          8762 => Opcode::VFMADDSUB231PDZmbkz,
          8763 => Opcode::VFMADDSUB231PDZmk,
          8764 => Opcode::VFMADDSUB231PDZmkz,
          8765 => Opcode::VFMADDSUB231PDZr,
          8766 => Opcode::VFMADDSUB231PDZrb,
          8767 => Opcode::VFMADDSUB231PDZrbk,
          8768 => Opcode::VFMADDSUB231PDZrbkz,
          8769 => Opcode::VFMADDSUB231PDZrk,
          8770 => Opcode::VFMADDSUB231PDZrkz,
          8771 => Opcode::VFMADDSUB231PDm,
          8772 => Opcode::VFMADDSUB231PDr,
          8773 => Opcode::VFMADDSUB231PHZ128m,
          8774 => Opcode::VFMADDSUB231PHZ128mb,
          8775 => Opcode::VFMADDSUB231PHZ128mbk,
          8776 => Opcode::VFMADDSUB231PHZ128mbkz,
          8777 => Opcode::VFMADDSUB231PHZ128mk,
          8778 => Opcode::VFMADDSUB231PHZ128mkz,
          8779 => Opcode::VFMADDSUB231PHZ128r,
          8780 => Opcode::VFMADDSUB231PHZ128rk,
          8781 => Opcode::VFMADDSUB231PHZ128rkz,
          8782 => Opcode::VFMADDSUB231PHZ256m,
          8783 => Opcode::VFMADDSUB231PHZ256mb,
          8784 => Opcode::VFMADDSUB231PHZ256mbk,
          8785 => Opcode::VFMADDSUB231PHZ256mbkz,
          8786 => Opcode::VFMADDSUB231PHZ256mk,
          8787 => Opcode::VFMADDSUB231PHZ256mkz,
          8788 => Opcode::VFMADDSUB231PHZ256r,
          8789 => Opcode::VFMADDSUB231PHZ256rk,
          8790 => Opcode::VFMADDSUB231PHZ256rkz,
          8791 => Opcode::VFMADDSUB231PHZm,
          8792 => Opcode::VFMADDSUB231PHZmb,
          8793 => Opcode::VFMADDSUB231PHZmbk,
          8794 => Opcode::VFMADDSUB231PHZmbkz,
          8795 => Opcode::VFMADDSUB231PHZmk,
          8796 => Opcode::VFMADDSUB231PHZmkz,
          8797 => Opcode::VFMADDSUB231PHZr,
          8798 => Opcode::VFMADDSUB231PHZrb,
          8799 => Opcode::VFMADDSUB231PHZrbk,
          8800 => Opcode::VFMADDSUB231PHZrbkz,
          8801 => Opcode::VFMADDSUB231PHZrk,
          8802 => Opcode::VFMADDSUB231PHZrkz,
          8803 => Opcode::VFMADDSUB231PSYm,
          8804 => Opcode::VFMADDSUB231PSYr,
          8805 => Opcode::VFMADDSUB231PSZ128m,
          8806 => Opcode::VFMADDSUB231PSZ128mb,
          8807 => Opcode::VFMADDSUB231PSZ128mbk,
          8808 => Opcode::VFMADDSUB231PSZ128mbkz,
          8809 => Opcode::VFMADDSUB231PSZ128mk,
          8810 => Opcode::VFMADDSUB231PSZ128mkz,
          8811 => Opcode::VFMADDSUB231PSZ128r,
          8812 => Opcode::VFMADDSUB231PSZ128rk,
          8813 => Opcode::VFMADDSUB231PSZ128rkz,
          8814 => Opcode::VFMADDSUB231PSZ256m,
          8815 => Opcode::VFMADDSUB231PSZ256mb,
          8816 => Opcode::VFMADDSUB231PSZ256mbk,
          8817 => Opcode::VFMADDSUB231PSZ256mbkz,
          8818 => Opcode::VFMADDSUB231PSZ256mk,
          8819 => Opcode::VFMADDSUB231PSZ256mkz,
          8820 => Opcode::VFMADDSUB231PSZ256r,
          8821 => Opcode::VFMADDSUB231PSZ256rk,
          8822 => Opcode::VFMADDSUB231PSZ256rkz,
          8823 => Opcode::VFMADDSUB231PSZm,
          8824 => Opcode::VFMADDSUB231PSZmb,
          8825 => Opcode::VFMADDSUB231PSZmbk,
          8826 => Opcode::VFMADDSUB231PSZmbkz,
          8827 => Opcode::VFMADDSUB231PSZmk,
          8828 => Opcode::VFMADDSUB231PSZmkz,
          8829 => Opcode::VFMADDSUB231PSZr,
          8830 => Opcode::VFMADDSUB231PSZrb,
          8831 => Opcode::VFMADDSUB231PSZrbk,
          8832 => Opcode::VFMADDSUB231PSZrbkz,
          8833 => Opcode::VFMADDSUB231PSZrk,
          8834 => Opcode::VFMADDSUB231PSZrkz,
          8835 => Opcode::VFMADDSUB231PSm,
          8836 => Opcode::VFMADDSUB231PSr,
          8837 => Opcode::VFMADDSUBPD4Ymr,
          8838 => Opcode::VFMADDSUBPD4Yrm,
          8839 => Opcode::VFMADDSUBPD4Yrr,
          8840 => Opcode::VFMADDSUBPD4Yrr_REV,
          8841 => Opcode::VFMADDSUBPD4mr,
          8842 => Opcode::VFMADDSUBPD4rm,
          8843 => Opcode::VFMADDSUBPD4rr,
          8844 => Opcode::VFMADDSUBPD4rr_REV,
          8845 => Opcode::VFMADDSUBPS4Ymr,
          8846 => Opcode::VFMADDSUBPS4Yrm,
          8847 => Opcode::VFMADDSUBPS4Yrr,
          8848 => Opcode::VFMADDSUBPS4Yrr_REV,
          8849 => Opcode::VFMADDSUBPS4mr,
          8850 => Opcode::VFMADDSUBPS4rm,
          8851 => Opcode::VFMADDSUBPS4rr,
          8852 => Opcode::VFMADDSUBPS4rr_REV,
          8853 => Opcode::VFMSUB132PDYm,
          8854 => Opcode::VFMSUB132PDYr,
          8855 => Opcode::VFMSUB132PDZ128m,
          8856 => Opcode::VFMSUB132PDZ128mb,
          8857 => Opcode::VFMSUB132PDZ128mbk,
          8858 => Opcode::VFMSUB132PDZ128mbkz,
          8859 => Opcode::VFMSUB132PDZ128mk,
          8860 => Opcode::VFMSUB132PDZ128mkz,
          8861 => Opcode::VFMSUB132PDZ128r,
          8862 => Opcode::VFMSUB132PDZ128rk,
          8863 => Opcode::VFMSUB132PDZ128rkz,
          8864 => Opcode::VFMSUB132PDZ256m,
          8865 => Opcode::VFMSUB132PDZ256mb,
          8866 => Opcode::VFMSUB132PDZ256mbk,
          8867 => Opcode::VFMSUB132PDZ256mbkz,
          8868 => Opcode::VFMSUB132PDZ256mk,
          8869 => Opcode::VFMSUB132PDZ256mkz,
          8870 => Opcode::VFMSUB132PDZ256r,
          8871 => Opcode::VFMSUB132PDZ256rk,
          8872 => Opcode::VFMSUB132PDZ256rkz,
          8873 => Opcode::VFMSUB132PDZm,
          8874 => Opcode::VFMSUB132PDZmb,
          8875 => Opcode::VFMSUB132PDZmbk,
          8876 => Opcode::VFMSUB132PDZmbkz,
          8877 => Opcode::VFMSUB132PDZmk,
          8878 => Opcode::VFMSUB132PDZmkz,
          8879 => Opcode::VFMSUB132PDZr,
          8880 => Opcode::VFMSUB132PDZrb,
          8881 => Opcode::VFMSUB132PDZrbk,
          8882 => Opcode::VFMSUB132PDZrbkz,
          8883 => Opcode::VFMSUB132PDZrk,
          8884 => Opcode::VFMSUB132PDZrkz,
          8885 => Opcode::VFMSUB132PDm,
          8886 => Opcode::VFMSUB132PDr,
          8887 => Opcode::VFMSUB132PHZ128m,
          8888 => Opcode::VFMSUB132PHZ128mb,
          8889 => Opcode::VFMSUB132PHZ128mbk,
          8890 => Opcode::VFMSUB132PHZ128mbkz,
          8891 => Opcode::VFMSUB132PHZ128mk,
          8892 => Opcode::VFMSUB132PHZ128mkz,
          8893 => Opcode::VFMSUB132PHZ128r,
          8894 => Opcode::VFMSUB132PHZ128rk,
          8895 => Opcode::VFMSUB132PHZ128rkz,
          8896 => Opcode::VFMSUB132PHZ256m,
          8897 => Opcode::VFMSUB132PHZ256mb,
          8898 => Opcode::VFMSUB132PHZ256mbk,
          8899 => Opcode::VFMSUB132PHZ256mbkz,
          8900 => Opcode::VFMSUB132PHZ256mk,
          8901 => Opcode::VFMSUB132PHZ256mkz,
          8902 => Opcode::VFMSUB132PHZ256r,
          8903 => Opcode::VFMSUB132PHZ256rk,
          8904 => Opcode::VFMSUB132PHZ256rkz,
          8905 => Opcode::VFMSUB132PHZm,
          8906 => Opcode::VFMSUB132PHZmb,
          8907 => Opcode::VFMSUB132PHZmbk,
          8908 => Opcode::VFMSUB132PHZmbkz,
          8909 => Opcode::VFMSUB132PHZmk,
          8910 => Opcode::VFMSUB132PHZmkz,
          8911 => Opcode::VFMSUB132PHZr,
          8912 => Opcode::VFMSUB132PHZrb,
          8913 => Opcode::VFMSUB132PHZrbk,
          8914 => Opcode::VFMSUB132PHZrbkz,
          8915 => Opcode::VFMSUB132PHZrk,
          8916 => Opcode::VFMSUB132PHZrkz,
          8917 => Opcode::VFMSUB132PSYm,
          8918 => Opcode::VFMSUB132PSYr,
          8919 => Opcode::VFMSUB132PSZ128m,
          8920 => Opcode::VFMSUB132PSZ128mb,
          8921 => Opcode::VFMSUB132PSZ128mbk,
          8922 => Opcode::VFMSUB132PSZ128mbkz,
          8923 => Opcode::VFMSUB132PSZ128mk,
          8924 => Opcode::VFMSUB132PSZ128mkz,
          8925 => Opcode::VFMSUB132PSZ128r,
          8926 => Opcode::VFMSUB132PSZ128rk,
          8927 => Opcode::VFMSUB132PSZ128rkz,
          8928 => Opcode::VFMSUB132PSZ256m,
          8929 => Opcode::VFMSUB132PSZ256mb,
          8930 => Opcode::VFMSUB132PSZ256mbk,
          8931 => Opcode::VFMSUB132PSZ256mbkz,
          8932 => Opcode::VFMSUB132PSZ256mk,
          8933 => Opcode::VFMSUB132PSZ256mkz,
          8934 => Opcode::VFMSUB132PSZ256r,
          8935 => Opcode::VFMSUB132PSZ256rk,
          8936 => Opcode::VFMSUB132PSZ256rkz,
          8937 => Opcode::VFMSUB132PSZm,
          8938 => Opcode::VFMSUB132PSZmb,
          8939 => Opcode::VFMSUB132PSZmbk,
          8940 => Opcode::VFMSUB132PSZmbkz,
          8941 => Opcode::VFMSUB132PSZmk,
          8942 => Opcode::VFMSUB132PSZmkz,
          8943 => Opcode::VFMSUB132PSZr,
          8944 => Opcode::VFMSUB132PSZrb,
          8945 => Opcode::VFMSUB132PSZrbk,
          8946 => Opcode::VFMSUB132PSZrbkz,
          8947 => Opcode::VFMSUB132PSZrk,
          8948 => Opcode::VFMSUB132PSZrkz,
          8949 => Opcode::VFMSUB132PSm,
          8950 => Opcode::VFMSUB132PSr,
          8951 => Opcode::VFMSUB132SDZm,
          8952 => Opcode::VFMSUB132SDZm_Int,
          8953 => Opcode::VFMSUB132SDZm_Intk,
          8954 => Opcode::VFMSUB132SDZm_Intkz,
          8955 => Opcode::VFMSUB132SDZr,
          8956 => Opcode::VFMSUB132SDZr_Int,
          8957 => Opcode::VFMSUB132SDZr_Intk,
          8958 => Opcode::VFMSUB132SDZr_Intkz,
          8959 => Opcode::VFMSUB132SDZrb,
          8960 => Opcode::VFMSUB132SDZrb_Int,
          8961 => Opcode::VFMSUB132SDZrb_Intk,
          8962 => Opcode::VFMSUB132SDZrb_Intkz,
          8963 => Opcode::VFMSUB132SDm,
          8964 => Opcode::VFMSUB132SDm_Int,
          8965 => Opcode::VFMSUB132SDr,
          8966 => Opcode::VFMSUB132SDr_Int,
          8967 => Opcode::VFMSUB132SHZm,
          8968 => Opcode::VFMSUB132SHZm_Int,
          8969 => Opcode::VFMSUB132SHZm_Intk,
          8970 => Opcode::VFMSUB132SHZm_Intkz,
          8971 => Opcode::VFMSUB132SHZr,
          8972 => Opcode::VFMSUB132SHZr_Int,
          8973 => Opcode::VFMSUB132SHZr_Intk,
          8974 => Opcode::VFMSUB132SHZr_Intkz,
          8975 => Opcode::VFMSUB132SHZrb,
          8976 => Opcode::VFMSUB132SHZrb_Int,
          8977 => Opcode::VFMSUB132SHZrb_Intk,
          8978 => Opcode::VFMSUB132SHZrb_Intkz,
          8979 => Opcode::VFMSUB132SSZm,
          8980 => Opcode::VFMSUB132SSZm_Int,
          8981 => Opcode::VFMSUB132SSZm_Intk,
          8982 => Opcode::VFMSUB132SSZm_Intkz,
          8983 => Opcode::VFMSUB132SSZr,
          8984 => Opcode::VFMSUB132SSZr_Int,
          8985 => Opcode::VFMSUB132SSZr_Intk,
          8986 => Opcode::VFMSUB132SSZr_Intkz,
          8987 => Opcode::VFMSUB132SSZrb,
          8988 => Opcode::VFMSUB132SSZrb_Int,
          8989 => Opcode::VFMSUB132SSZrb_Intk,
          8990 => Opcode::VFMSUB132SSZrb_Intkz,
          8991 => Opcode::VFMSUB132SSm,
          8992 => Opcode::VFMSUB132SSm_Int,
          8993 => Opcode::VFMSUB132SSr,
          8994 => Opcode::VFMSUB132SSr_Int,
          8995 => Opcode::VFMSUB213PDYm,
          8996 => Opcode::VFMSUB213PDYr,
          8997 => Opcode::VFMSUB213PDZ128m,
          8998 => Opcode::VFMSUB213PDZ128mb,
          8999 => Opcode::VFMSUB213PDZ128mbk,
          9000 => Opcode::VFMSUB213PDZ128mbkz,
          9001 => Opcode::VFMSUB213PDZ128mk,
          9002 => Opcode::VFMSUB213PDZ128mkz,
          9003 => Opcode::VFMSUB213PDZ128r,
          9004 => Opcode::VFMSUB213PDZ128rk,
          9005 => Opcode::VFMSUB213PDZ128rkz,
          9006 => Opcode::VFMSUB213PDZ256m,
          9007 => Opcode::VFMSUB213PDZ256mb,
          9008 => Opcode::VFMSUB213PDZ256mbk,
          9009 => Opcode::VFMSUB213PDZ256mbkz,
          9010 => Opcode::VFMSUB213PDZ256mk,
          9011 => Opcode::VFMSUB213PDZ256mkz,
          9012 => Opcode::VFMSUB213PDZ256r,
          9013 => Opcode::VFMSUB213PDZ256rk,
          9014 => Opcode::VFMSUB213PDZ256rkz,
          9015 => Opcode::VFMSUB213PDZm,
          9016 => Opcode::VFMSUB213PDZmb,
          9017 => Opcode::VFMSUB213PDZmbk,
          9018 => Opcode::VFMSUB213PDZmbkz,
          9019 => Opcode::VFMSUB213PDZmk,
          9020 => Opcode::VFMSUB213PDZmkz,
          9021 => Opcode::VFMSUB213PDZr,
          9022 => Opcode::VFMSUB213PDZrb,
          9023 => Opcode::VFMSUB213PDZrbk,
          9024 => Opcode::VFMSUB213PDZrbkz,
          9025 => Opcode::VFMSUB213PDZrk,
          9026 => Opcode::VFMSUB213PDZrkz,
          9027 => Opcode::VFMSUB213PDm,
          9028 => Opcode::VFMSUB213PDr,
          9029 => Opcode::VFMSUB213PHZ128m,
          9030 => Opcode::VFMSUB213PHZ128mb,
          9031 => Opcode::VFMSUB213PHZ128mbk,
          9032 => Opcode::VFMSUB213PHZ128mbkz,
          9033 => Opcode::VFMSUB213PHZ128mk,
          9034 => Opcode::VFMSUB213PHZ128mkz,
          9035 => Opcode::VFMSUB213PHZ128r,
          9036 => Opcode::VFMSUB213PHZ128rk,
          9037 => Opcode::VFMSUB213PHZ128rkz,
          9038 => Opcode::VFMSUB213PHZ256m,
          9039 => Opcode::VFMSUB213PHZ256mb,
          9040 => Opcode::VFMSUB213PHZ256mbk,
          9041 => Opcode::VFMSUB213PHZ256mbkz,
          9042 => Opcode::VFMSUB213PHZ256mk,
          9043 => Opcode::VFMSUB213PHZ256mkz,
          9044 => Opcode::VFMSUB213PHZ256r,
          9045 => Opcode::VFMSUB213PHZ256rk,
          9046 => Opcode::VFMSUB213PHZ256rkz,
          9047 => Opcode::VFMSUB213PHZm,
          9048 => Opcode::VFMSUB213PHZmb,
          9049 => Opcode::VFMSUB213PHZmbk,
          9050 => Opcode::VFMSUB213PHZmbkz,
          9051 => Opcode::VFMSUB213PHZmk,
          9052 => Opcode::VFMSUB213PHZmkz,
          9053 => Opcode::VFMSUB213PHZr,
          9054 => Opcode::VFMSUB213PHZrb,
          9055 => Opcode::VFMSUB213PHZrbk,
          9056 => Opcode::VFMSUB213PHZrbkz,
          9057 => Opcode::VFMSUB213PHZrk,
          9058 => Opcode::VFMSUB213PHZrkz,
          9059 => Opcode::VFMSUB213PSYm,
          9060 => Opcode::VFMSUB213PSYr,
          9061 => Opcode::VFMSUB213PSZ128m,
          9062 => Opcode::VFMSUB213PSZ128mb,
          9063 => Opcode::VFMSUB213PSZ128mbk,
          9064 => Opcode::VFMSUB213PSZ128mbkz,
          9065 => Opcode::VFMSUB213PSZ128mk,
          9066 => Opcode::VFMSUB213PSZ128mkz,
          9067 => Opcode::VFMSUB213PSZ128r,
          9068 => Opcode::VFMSUB213PSZ128rk,
          9069 => Opcode::VFMSUB213PSZ128rkz,
          9070 => Opcode::VFMSUB213PSZ256m,
          9071 => Opcode::VFMSUB213PSZ256mb,
          9072 => Opcode::VFMSUB213PSZ256mbk,
          9073 => Opcode::VFMSUB213PSZ256mbkz,
          9074 => Opcode::VFMSUB213PSZ256mk,
          9075 => Opcode::VFMSUB213PSZ256mkz,
          9076 => Opcode::VFMSUB213PSZ256r,
          9077 => Opcode::VFMSUB213PSZ256rk,
          9078 => Opcode::VFMSUB213PSZ256rkz,
          9079 => Opcode::VFMSUB213PSZm,
          9080 => Opcode::VFMSUB213PSZmb,
          9081 => Opcode::VFMSUB213PSZmbk,
          9082 => Opcode::VFMSUB213PSZmbkz,
          9083 => Opcode::VFMSUB213PSZmk,
          9084 => Opcode::VFMSUB213PSZmkz,
          9085 => Opcode::VFMSUB213PSZr,
          9086 => Opcode::VFMSUB213PSZrb,
          9087 => Opcode::VFMSUB213PSZrbk,
          9088 => Opcode::VFMSUB213PSZrbkz,
          9089 => Opcode::VFMSUB213PSZrk,
          9090 => Opcode::VFMSUB213PSZrkz,
          9091 => Opcode::VFMSUB213PSm,
          9092 => Opcode::VFMSUB213PSr,
          9093 => Opcode::VFMSUB213SDZm,
          9094 => Opcode::VFMSUB213SDZm_Int,
          9095 => Opcode::VFMSUB213SDZm_Intk,
          9096 => Opcode::VFMSUB213SDZm_Intkz,
          9097 => Opcode::VFMSUB213SDZr,
          9098 => Opcode::VFMSUB213SDZr_Int,
          9099 => Opcode::VFMSUB213SDZr_Intk,
          9100 => Opcode::VFMSUB213SDZr_Intkz,
          9101 => Opcode::VFMSUB213SDZrb,
          9102 => Opcode::VFMSUB213SDZrb_Int,
          9103 => Opcode::VFMSUB213SDZrb_Intk,
          9104 => Opcode::VFMSUB213SDZrb_Intkz,
          9105 => Opcode::VFMSUB213SDm,
          9106 => Opcode::VFMSUB213SDm_Int,
          9107 => Opcode::VFMSUB213SDr,
          9108 => Opcode::VFMSUB213SDr_Int,
          9109 => Opcode::VFMSUB213SHZm,
          9110 => Opcode::VFMSUB213SHZm_Int,
          9111 => Opcode::VFMSUB213SHZm_Intk,
          9112 => Opcode::VFMSUB213SHZm_Intkz,
          9113 => Opcode::VFMSUB213SHZr,
          9114 => Opcode::VFMSUB213SHZr_Int,
          9115 => Opcode::VFMSUB213SHZr_Intk,
          9116 => Opcode::VFMSUB213SHZr_Intkz,
          9117 => Opcode::VFMSUB213SHZrb,
          9118 => Opcode::VFMSUB213SHZrb_Int,
          9119 => Opcode::VFMSUB213SHZrb_Intk,
          9120 => Opcode::VFMSUB213SHZrb_Intkz,
          9121 => Opcode::VFMSUB213SSZm,
          9122 => Opcode::VFMSUB213SSZm_Int,
          9123 => Opcode::VFMSUB213SSZm_Intk,
          9124 => Opcode::VFMSUB213SSZm_Intkz,
          9125 => Opcode::VFMSUB213SSZr,
          9126 => Opcode::VFMSUB213SSZr_Int,
          9127 => Opcode::VFMSUB213SSZr_Intk,
          9128 => Opcode::VFMSUB213SSZr_Intkz,
          9129 => Opcode::VFMSUB213SSZrb,
          9130 => Opcode::VFMSUB213SSZrb_Int,
          9131 => Opcode::VFMSUB213SSZrb_Intk,
          9132 => Opcode::VFMSUB213SSZrb_Intkz,
          9133 => Opcode::VFMSUB213SSm,
          9134 => Opcode::VFMSUB213SSm_Int,
          9135 => Opcode::VFMSUB213SSr,
          9136 => Opcode::VFMSUB213SSr_Int,
          9137 => Opcode::VFMSUB231PDYm,
          9138 => Opcode::VFMSUB231PDYr,
          9139 => Opcode::VFMSUB231PDZ128m,
          9140 => Opcode::VFMSUB231PDZ128mb,
          9141 => Opcode::VFMSUB231PDZ128mbk,
          9142 => Opcode::VFMSUB231PDZ128mbkz,
          9143 => Opcode::VFMSUB231PDZ128mk,
          9144 => Opcode::VFMSUB231PDZ128mkz,
          9145 => Opcode::VFMSUB231PDZ128r,
          9146 => Opcode::VFMSUB231PDZ128rk,
          9147 => Opcode::VFMSUB231PDZ128rkz,
          9148 => Opcode::VFMSUB231PDZ256m,
          9149 => Opcode::VFMSUB231PDZ256mb,
          9150 => Opcode::VFMSUB231PDZ256mbk,
          9151 => Opcode::VFMSUB231PDZ256mbkz,
          9152 => Opcode::VFMSUB231PDZ256mk,
          9153 => Opcode::VFMSUB231PDZ256mkz,
          9154 => Opcode::VFMSUB231PDZ256r,
          9155 => Opcode::VFMSUB231PDZ256rk,
          9156 => Opcode::VFMSUB231PDZ256rkz,
          9157 => Opcode::VFMSUB231PDZm,
          9158 => Opcode::VFMSUB231PDZmb,
          9159 => Opcode::VFMSUB231PDZmbk,
          9160 => Opcode::VFMSUB231PDZmbkz,
          9161 => Opcode::VFMSUB231PDZmk,
          9162 => Opcode::VFMSUB231PDZmkz,
          9163 => Opcode::VFMSUB231PDZr,
          9164 => Opcode::VFMSUB231PDZrb,
          9165 => Opcode::VFMSUB231PDZrbk,
          9166 => Opcode::VFMSUB231PDZrbkz,
          9167 => Opcode::VFMSUB231PDZrk,
          9168 => Opcode::VFMSUB231PDZrkz,
          9169 => Opcode::VFMSUB231PDm,
          9170 => Opcode::VFMSUB231PDr,
          9171 => Opcode::VFMSUB231PHZ128m,
          9172 => Opcode::VFMSUB231PHZ128mb,
          9173 => Opcode::VFMSUB231PHZ128mbk,
          9174 => Opcode::VFMSUB231PHZ128mbkz,
          9175 => Opcode::VFMSUB231PHZ128mk,
          9176 => Opcode::VFMSUB231PHZ128mkz,
          9177 => Opcode::VFMSUB231PHZ128r,
          9178 => Opcode::VFMSUB231PHZ128rk,
          9179 => Opcode::VFMSUB231PHZ128rkz,
          9180 => Opcode::VFMSUB231PHZ256m,
          9181 => Opcode::VFMSUB231PHZ256mb,
          9182 => Opcode::VFMSUB231PHZ256mbk,
          9183 => Opcode::VFMSUB231PHZ256mbkz,
          9184 => Opcode::VFMSUB231PHZ256mk,
          9185 => Opcode::VFMSUB231PHZ256mkz,
          9186 => Opcode::VFMSUB231PHZ256r,
          9187 => Opcode::VFMSUB231PHZ256rk,
          9188 => Opcode::VFMSUB231PHZ256rkz,
          9189 => Opcode::VFMSUB231PHZm,
          9190 => Opcode::VFMSUB231PHZmb,
          9191 => Opcode::VFMSUB231PHZmbk,
          9192 => Opcode::VFMSUB231PHZmbkz,
          9193 => Opcode::VFMSUB231PHZmk,
          9194 => Opcode::VFMSUB231PHZmkz,
          9195 => Opcode::VFMSUB231PHZr,
          9196 => Opcode::VFMSUB231PHZrb,
          9197 => Opcode::VFMSUB231PHZrbk,
          9198 => Opcode::VFMSUB231PHZrbkz,
          9199 => Opcode::VFMSUB231PHZrk,
          9200 => Opcode::VFMSUB231PHZrkz,
          9201 => Opcode::VFMSUB231PSYm,
          9202 => Opcode::VFMSUB231PSYr,
          9203 => Opcode::VFMSUB231PSZ128m,
          9204 => Opcode::VFMSUB231PSZ128mb,
          9205 => Opcode::VFMSUB231PSZ128mbk,
          9206 => Opcode::VFMSUB231PSZ128mbkz,
          9207 => Opcode::VFMSUB231PSZ128mk,
          9208 => Opcode::VFMSUB231PSZ128mkz,
          9209 => Opcode::VFMSUB231PSZ128r,
          9210 => Opcode::VFMSUB231PSZ128rk,
          9211 => Opcode::VFMSUB231PSZ128rkz,
          9212 => Opcode::VFMSUB231PSZ256m,
          9213 => Opcode::VFMSUB231PSZ256mb,
          9214 => Opcode::VFMSUB231PSZ256mbk,
          9215 => Opcode::VFMSUB231PSZ256mbkz,
          9216 => Opcode::VFMSUB231PSZ256mk,
          9217 => Opcode::VFMSUB231PSZ256mkz,
          9218 => Opcode::VFMSUB231PSZ256r,
          9219 => Opcode::VFMSUB231PSZ256rk,
          9220 => Opcode::VFMSUB231PSZ256rkz,
          9221 => Opcode::VFMSUB231PSZm,
          9222 => Opcode::VFMSUB231PSZmb,
          9223 => Opcode::VFMSUB231PSZmbk,
          9224 => Opcode::VFMSUB231PSZmbkz,
          9225 => Opcode::VFMSUB231PSZmk,
          9226 => Opcode::VFMSUB231PSZmkz,
          9227 => Opcode::VFMSUB231PSZr,
          9228 => Opcode::VFMSUB231PSZrb,
          9229 => Opcode::VFMSUB231PSZrbk,
          9230 => Opcode::VFMSUB231PSZrbkz,
          9231 => Opcode::VFMSUB231PSZrk,
          9232 => Opcode::VFMSUB231PSZrkz,
          9233 => Opcode::VFMSUB231PSm,
          9234 => Opcode::VFMSUB231PSr,
          9235 => Opcode::VFMSUB231SDZm,
          9236 => Opcode::VFMSUB231SDZm_Int,
          9237 => Opcode::VFMSUB231SDZm_Intk,
          9238 => Opcode::VFMSUB231SDZm_Intkz,
          9239 => Opcode::VFMSUB231SDZr,
          9240 => Opcode::VFMSUB231SDZr_Int,
          9241 => Opcode::VFMSUB231SDZr_Intk,
          9242 => Opcode::VFMSUB231SDZr_Intkz,
          9243 => Opcode::VFMSUB231SDZrb,
          9244 => Opcode::VFMSUB231SDZrb_Int,
          9245 => Opcode::VFMSUB231SDZrb_Intk,
          9246 => Opcode::VFMSUB231SDZrb_Intkz,
          9247 => Opcode::VFMSUB231SDm,
          9248 => Opcode::VFMSUB231SDm_Int,
          9249 => Opcode::VFMSUB231SDr,
          9250 => Opcode::VFMSUB231SDr_Int,
          9251 => Opcode::VFMSUB231SHZm,
          9252 => Opcode::VFMSUB231SHZm_Int,
          9253 => Opcode::VFMSUB231SHZm_Intk,
          9254 => Opcode::VFMSUB231SHZm_Intkz,
          9255 => Opcode::VFMSUB231SHZr,
          9256 => Opcode::VFMSUB231SHZr_Int,
          9257 => Opcode::VFMSUB231SHZr_Intk,
          9258 => Opcode::VFMSUB231SHZr_Intkz,
          9259 => Opcode::VFMSUB231SHZrb,
          9260 => Opcode::VFMSUB231SHZrb_Int,
          9261 => Opcode::VFMSUB231SHZrb_Intk,
          9262 => Opcode::VFMSUB231SHZrb_Intkz,
          9263 => Opcode::VFMSUB231SSZm,
          9264 => Opcode::VFMSUB231SSZm_Int,
          9265 => Opcode::VFMSUB231SSZm_Intk,
          9266 => Opcode::VFMSUB231SSZm_Intkz,
          9267 => Opcode::VFMSUB231SSZr,
          9268 => Opcode::VFMSUB231SSZr_Int,
          9269 => Opcode::VFMSUB231SSZr_Intk,
          9270 => Opcode::VFMSUB231SSZr_Intkz,
          9271 => Opcode::VFMSUB231SSZrb,
          9272 => Opcode::VFMSUB231SSZrb_Int,
          9273 => Opcode::VFMSUB231SSZrb_Intk,
          9274 => Opcode::VFMSUB231SSZrb_Intkz,
          9275 => Opcode::VFMSUB231SSm,
          9276 => Opcode::VFMSUB231SSm_Int,
          9277 => Opcode::VFMSUB231SSr,
          9278 => Opcode::VFMSUB231SSr_Int,
          9279 => Opcode::VFMSUBADD132PDYm,
          9280 => Opcode::VFMSUBADD132PDYr,
          9281 => Opcode::VFMSUBADD132PDZ128m,
          9282 => Opcode::VFMSUBADD132PDZ128mb,
          9283 => Opcode::VFMSUBADD132PDZ128mbk,
          9284 => Opcode::VFMSUBADD132PDZ128mbkz,
          9285 => Opcode::VFMSUBADD132PDZ128mk,
          9286 => Opcode::VFMSUBADD132PDZ128mkz,
          9287 => Opcode::VFMSUBADD132PDZ128r,
          9288 => Opcode::VFMSUBADD132PDZ128rk,
          9289 => Opcode::VFMSUBADD132PDZ128rkz,
          9290 => Opcode::VFMSUBADD132PDZ256m,
          9291 => Opcode::VFMSUBADD132PDZ256mb,
          9292 => Opcode::VFMSUBADD132PDZ256mbk,
          9293 => Opcode::VFMSUBADD132PDZ256mbkz,
          9294 => Opcode::VFMSUBADD132PDZ256mk,
          9295 => Opcode::VFMSUBADD132PDZ256mkz,
          9296 => Opcode::VFMSUBADD132PDZ256r,
          9297 => Opcode::VFMSUBADD132PDZ256rk,
          9298 => Opcode::VFMSUBADD132PDZ256rkz,
          9299 => Opcode::VFMSUBADD132PDZm,
          9300 => Opcode::VFMSUBADD132PDZmb,
          9301 => Opcode::VFMSUBADD132PDZmbk,
          9302 => Opcode::VFMSUBADD132PDZmbkz,
          9303 => Opcode::VFMSUBADD132PDZmk,
          9304 => Opcode::VFMSUBADD132PDZmkz,
          9305 => Opcode::VFMSUBADD132PDZr,
          9306 => Opcode::VFMSUBADD132PDZrb,
          9307 => Opcode::VFMSUBADD132PDZrbk,
          9308 => Opcode::VFMSUBADD132PDZrbkz,
          9309 => Opcode::VFMSUBADD132PDZrk,
          9310 => Opcode::VFMSUBADD132PDZrkz,
          9311 => Opcode::VFMSUBADD132PDm,
          9312 => Opcode::VFMSUBADD132PDr,
          9313 => Opcode::VFMSUBADD132PHZ128m,
          9314 => Opcode::VFMSUBADD132PHZ128mb,
          9315 => Opcode::VFMSUBADD132PHZ128mbk,
          9316 => Opcode::VFMSUBADD132PHZ128mbkz,
          9317 => Opcode::VFMSUBADD132PHZ128mk,
          9318 => Opcode::VFMSUBADD132PHZ128mkz,
          9319 => Opcode::VFMSUBADD132PHZ128r,
          9320 => Opcode::VFMSUBADD132PHZ128rk,
          9321 => Opcode::VFMSUBADD132PHZ128rkz,
          9322 => Opcode::VFMSUBADD132PHZ256m,
          9323 => Opcode::VFMSUBADD132PHZ256mb,
          9324 => Opcode::VFMSUBADD132PHZ256mbk,
          9325 => Opcode::VFMSUBADD132PHZ256mbkz,
          9326 => Opcode::VFMSUBADD132PHZ256mk,
          9327 => Opcode::VFMSUBADD132PHZ256mkz,
          9328 => Opcode::VFMSUBADD132PHZ256r,
          9329 => Opcode::VFMSUBADD132PHZ256rk,
          9330 => Opcode::VFMSUBADD132PHZ256rkz,
          9331 => Opcode::VFMSUBADD132PHZm,
          9332 => Opcode::VFMSUBADD132PHZmb,
          9333 => Opcode::VFMSUBADD132PHZmbk,
          9334 => Opcode::VFMSUBADD132PHZmbkz,
          9335 => Opcode::VFMSUBADD132PHZmk,
          9336 => Opcode::VFMSUBADD132PHZmkz,
          9337 => Opcode::VFMSUBADD132PHZr,
          9338 => Opcode::VFMSUBADD132PHZrb,
          9339 => Opcode::VFMSUBADD132PHZrbk,
          9340 => Opcode::VFMSUBADD132PHZrbkz,
          9341 => Opcode::VFMSUBADD132PHZrk,
          9342 => Opcode::VFMSUBADD132PHZrkz,
          9343 => Opcode::VFMSUBADD132PSYm,
          9344 => Opcode::VFMSUBADD132PSYr,
          9345 => Opcode::VFMSUBADD132PSZ128m,
          9346 => Opcode::VFMSUBADD132PSZ128mb,
          9347 => Opcode::VFMSUBADD132PSZ128mbk,
          9348 => Opcode::VFMSUBADD132PSZ128mbkz,
          9349 => Opcode::VFMSUBADD132PSZ128mk,
          9350 => Opcode::VFMSUBADD132PSZ128mkz,
          9351 => Opcode::VFMSUBADD132PSZ128r,
          9352 => Opcode::VFMSUBADD132PSZ128rk,
          9353 => Opcode::VFMSUBADD132PSZ128rkz,
          9354 => Opcode::VFMSUBADD132PSZ256m,
          9355 => Opcode::VFMSUBADD132PSZ256mb,
          9356 => Opcode::VFMSUBADD132PSZ256mbk,
          9357 => Opcode::VFMSUBADD132PSZ256mbkz,
          9358 => Opcode::VFMSUBADD132PSZ256mk,
          9359 => Opcode::VFMSUBADD132PSZ256mkz,
          9360 => Opcode::VFMSUBADD132PSZ256r,
          9361 => Opcode::VFMSUBADD132PSZ256rk,
          9362 => Opcode::VFMSUBADD132PSZ256rkz,
          9363 => Opcode::VFMSUBADD132PSZm,
          9364 => Opcode::VFMSUBADD132PSZmb,
          9365 => Opcode::VFMSUBADD132PSZmbk,
          9366 => Opcode::VFMSUBADD132PSZmbkz,
          9367 => Opcode::VFMSUBADD132PSZmk,
          9368 => Opcode::VFMSUBADD132PSZmkz,
          9369 => Opcode::VFMSUBADD132PSZr,
          9370 => Opcode::VFMSUBADD132PSZrb,
          9371 => Opcode::VFMSUBADD132PSZrbk,
          9372 => Opcode::VFMSUBADD132PSZrbkz,
          9373 => Opcode::VFMSUBADD132PSZrk,
          9374 => Opcode::VFMSUBADD132PSZrkz,
          9375 => Opcode::VFMSUBADD132PSm,
          9376 => Opcode::VFMSUBADD132PSr,
          9377 => Opcode::VFMSUBADD213PDYm,
          9378 => Opcode::VFMSUBADD213PDYr,
          9379 => Opcode::VFMSUBADD213PDZ128m,
          9380 => Opcode::VFMSUBADD213PDZ128mb,
          9381 => Opcode::VFMSUBADD213PDZ128mbk,
          9382 => Opcode::VFMSUBADD213PDZ128mbkz,
          9383 => Opcode::VFMSUBADD213PDZ128mk,
          9384 => Opcode::VFMSUBADD213PDZ128mkz,
          9385 => Opcode::VFMSUBADD213PDZ128r,
          9386 => Opcode::VFMSUBADD213PDZ128rk,
          9387 => Opcode::VFMSUBADD213PDZ128rkz,
          9388 => Opcode::VFMSUBADD213PDZ256m,
          9389 => Opcode::VFMSUBADD213PDZ256mb,
          9390 => Opcode::VFMSUBADD213PDZ256mbk,
          9391 => Opcode::VFMSUBADD213PDZ256mbkz,
          9392 => Opcode::VFMSUBADD213PDZ256mk,
          9393 => Opcode::VFMSUBADD213PDZ256mkz,
          9394 => Opcode::VFMSUBADD213PDZ256r,
          9395 => Opcode::VFMSUBADD213PDZ256rk,
          9396 => Opcode::VFMSUBADD213PDZ256rkz,
          9397 => Opcode::VFMSUBADD213PDZm,
          9398 => Opcode::VFMSUBADD213PDZmb,
          9399 => Opcode::VFMSUBADD213PDZmbk,
          9400 => Opcode::VFMSUBADD213PDZmbkz,
          9401 => Opcode::VFMSUBADD213PDZmk,
          9402 => Opcode::VFMSUBADD213PDZmkz,
          9403 => Opcode::VFMSUBADD213PDZr,
          9404 => Opcode::VFMSUBADD213PDZrb,
          9405 => Opcode::VFMSUBADD213PDZrbk,
          9406 => Opcode::VFMSUBADD213PDZrbkz,
          9407 => Opcode::VFMSUBADD213PDZrk,
          9408 => Opcode::VFMSUBADD213PDZrkz,
          9409 => Opcode::VFMSUBADD213PDm,
          9410 => Opcode::VFMSUBADD213PDr,
          9411 => Opcode::VFMSUBADD213PHZ128m,
          9412 => Opcode::VFMSUBADD213PHZ128mb,
          9413 => Opcode::VFMSUBADD213PHZ128mbk,
          9414 => Opcode::VFMSUBADD213PHZ128mbkz,
          9415 => Opcode::VFMSUBADD213PHZ128mk,
          9416 => Opcode::VFMSUBADD213PHZ128mkz,
          9417 => Opcode::VFMSUBADD213PHZ128r,
          9418 => Opcode::VFMSUBADD213PHZ128rk,
          9419 => Opcode::VFMSUBADD213PHZ128rkz,
          9420 => Opcode::VFMSUBADD213PHZ256m,
          9421 => Opcode::VFMSUBADD213PHZ256mb,
          9422 => Opcode::VFMSUBADD213PHZ256mbk,
          9423 => Opcode::VFMSUBADD213PHZ256mbkz,
          9424 => Opcode::VFMSUBADD213PHZ256mk,
          9425 => Opcode::VFMSUBADD213PHZ256mkz,
          9426 => Opcode::VFMSUBADD213PHZ256r,
          9427 => Opcode::VFMSUBADD213PHZ256rk,
          9428 => Opcode::VFMSUBADD213PHZ256rkz,
          9429 => Opcode::VFMSUBADD213PHZm,
          9430 => Opcode::VFMSUBADD213PHZmb,
          9431 => Opcode::VFMSUBADD213PHZmbk,
          9432 => Opcode::VFMSUBADD213PHZmbkz,
          9433 => Opcode::VFMSUBADD213PHZmk,
          9434 => Opcode::VFMSUBADD213PHZmkz,
          9435 => Opcode::VFMSUBADD213PHZr,
          9436 => Opcode::VFMSUBADD213PHZrb,
          9437 => Opcode::VFMSUBADD213PHZrbk,
          9438 => Opcode::VFMSUBADD213PHZrbkz,
          9439 => Opcode::VFMSUBADD213PHZrk,
          9440 => Opcode::VFMSUBADD213PHZrkz,
          9441 => Opcode::VFMSUBADD213PSYm,
          9442 => Opcode::VFMSUBADD213PSYr,
          9443 => Opcode::VFMSUBADD213PSZ128m,
          9444 => Opcode::VFMSUBADD213PSZ128mb,
          9445 => Opcode::VFMSUBADD213PSZ128mbk,
          9446 => Opcode::VFMSUBADD213PSZ128mbkz,
          9447 => Opcode::VFMSUBADD213PSZ128mk,
          9448 => Opcode::VFMSUBADD213PSZ128mkz,
          9449 => Opcode::VFMSUBADD213PSZ128r,
          9450 => Opcode::VFMSUBADD213PSZ128rk,
          9451 => Opcode::VFMSUBADD213PSZ128rkz,
          9452 => Opcode::VFMSUBADD213PSZ256m,
          9453 => Opcode::VFMSUBADD213PSZ256mb,
          9454 => Opcode::VFMSUBADD213PSZ256mbk,
          9455 => Opcode::VFMSUBADD213PSZ256mbkz,
          9456 => Opcode::VFMSUBADD213PSZ256mk,
          9457 => Opcode::VFMSUBADD213PSZ256mkz,
          9458 => Opcode::VFMSUBADD213PSZ256r,
          9459 => Opcode::VFMSUBADD213PSZ256rk,
          9460 => Opcode::VFMSUBADD213PSZ256rkz,
          9461 => Opcode::VFMSUBADD213PSZm,
          9462 => Opcode::VFMSUBADD213PSZmb,
          9463 => Opcode::VFMSUBADD213PSZmbk,
          9464 => Opcode::VFMSUBADD213PSZmbkz,
          9465 => Opcode::VFMSUBADD213PSZmk,
          9466 => Opcode::VFMSUBADD213PSZmkz,
          9467 => Opcode::VFMSUBADD213PSZr,
          9468 => Opcode::VFMSUBADD213PSZrb,
          9469 => Opcode::VFMSUBADD213PSZrbk,
          9470 => Opcode::VFMSUBADD213PSZrbkz,
          9471 => Opcode::VFMSUBADD213PSZrk,
          9472 => Opcode::VFMSUBADD213PSZrkz,
          9473 => Opcode::VFMSUBADD213PSm,
          9474 => Opcode::VFMSUBADD213PSr,
          9475 => Opcode::VFMSUBADD231PDYm,
          9476 => Opcode::VFMSUBADD231PDYr,
          9477 => Opcode::VFMSUBADD231PDZ128m,
          9478 => Opcode::VFMSUBADD231PDZ128mb,
          9479 => Opcode::VFMSUBADD231PDZ128mbk,
          9480 => Opcode::VFMSUBADD231PDZ128mbkz,
          9481 => Opcode::VFMSUBADD231PDZ128mk,
          9482 => Opcode::VFMSUBADD231PDZ128mkz,
          9483 => Opcode::VFMSUBADD231PDZ128r,
          9484 => Opcode::VFMSUBADD231PDZ128rk,
          9485 => Opcode::VFMSUBADD231PDZ128rkz,
          9486 => Opcode::VFMSUBADD231PDZ256m,
          9487 => Opcode::VFMSUBADD231PDZ256mb,
          9488 => Opcode::VFMSUBADD231PDZ256mbk,
          9489 => Opcode::VFMSUBADD231PDZ256mbkz,
          9490 => Opcode::VFMSUBADD231PDZ256mk,
          9491 => Opcode::VFMSUBADD231PDZ256mkz,
          9492 => Opcode::VFMSUBADD231PDZ256r,
          9493 => Opcode::VFMSUBADD231PDZ256rk,
          9494 => Opcode::VFMSUBADD231PDZ256rkz,
          9495 => Opcode::VFMSUBADD231PDZm,
          9496 => Opcode::VFMSUBADD231PDZmb,
          9497 => Opcode::VFMSUBADD231PDZmbk,
          9498 => Opcode::VFMSUBADD231PDZmbkz,
          9499 => Opcode::VFMSUBADD231PDZmk,
          9500 => Opcode::VFMSUBADD231PDZmkz,
          9501 => Opcode::VFMSUBADD231PDZr,
          9502 => Opcode::VFMSUBADD231PDZrb,
          9503 => Opcode::VFMSUBADD231PDZrbk,
          9504 => Opcode::VFMSUBADD231PDZrbkz,
          9505 => Opcode::VFMSUBADD231PDZrk,
          9506 => Opcode::VFMSUBADD231PDZrkz,
          9507 => Opcode::VFMSUBADD231PDm,
          9508 => Opcode::VFMSUBADD231PDr,
          9509 => Opcode::VFMSUBADD231PHZ128m,
          9510 => Opcode::VFMSUBADD231PHZ128mb,
          9511 => Opcode::VFMSUBADD231PHZ128mbk,
          9512 => Opcode::VFMSUBADD231PHZ128mbkz,
          9513 => Opcode::VFMSUBADD231PHZ128mk,
          9514 => Opcode::VFMSUBADD231PHZ128mkz,
          9515 => Opcode::VFMSUBADD231PHZ128r,
          9516 => Opcode::VFMSUBADD231PHZ128rk,
          9517 => Opcode::VFMSUBADD231PHZ128rkz,
          9518 => Opcode::VFMSUBADD231PHZ256m,
          9519 => Opcode::VFMSUBADD231PHZ256mb,
          9520 => Opcode::VFMSUBADD231PHZ256mbk,
          9521 => Opcode::VFMSUBADD231PHZ256mbkz,
          9522 => Opcode::VFMSUBADD231PHZ256mk,
          9523 => Opcode::VFMSUBADD231PHZ256mkz,
          9524 => Opcode::VFMSUBADD231PHZ256r,
          9525 => Opcode::VFMSUBADD231PHZ256rk,
          9526 => Opcode::VFMSUBADD231PHZ256rkz,
          9527 => Opcode::VFMSUBADD231PHZm,
          9528 => Opcode::VFMSUBADD231PHZmb,
          9529 => Opcode::VFMSUBADD231PHZmbk,
          9530 => Opcode::VFMSUBADD231PHZmbkz,
          9531 => Opcode::VFMSUBADD231PHZmk,
          9532 => Opcode::VFMSUBADD231PHZmkz,
          9533 => Opcode::VFMSUBADD231PHZr,
          9534 => Opcode::VFMSUBADD231PHZrb,
          9535 => Opcode::VFMSUBADD231PHZrbk,
          9536 => Opcode::VFMSUBADD231PHZrbkz,
          9537 => Opcode::VFMSUBADD231PHZrk,
          9538 => Opcode::VFMSUBADD231PHZrkz,
          9539 => Opcode::VFMSUBADD231PSYm,
          9540 => Opcode::VFMSUBADD231PSYr,
          9541 => Opcode::VFMSUBADD231PSZ128m,
          9542 => Opcode::VFMSUBADD231PSZ128mb,
          9543 => Opcode::VFMSUBADD231PSZ128mbk,
          9544 => Opcode::VFMSUBADD231PSZ128mbkz,
          9545 => Opcode::VFMSUBADD231PSZ128mk,
          9546 => Opcode::VFMSUBADD231PSZ128mkz,
          9547 => Opcode::VFMSUBADD231PSZ128r,
          9548 => Opcode::VFMSUBADD231PSZ128rk,
          9549 => Opcode::VFMSUBADD231PSZ128rkz,
          9550 => Opcode::VFMSUBADD231PSZ256m,
          9551 => Opcode::VFMSUBADD231PSZ256mb,
          9552 => Opcode::VFMSUBADD231PSZ256mbk,
          9553 => Opcode::VFMSUBADD231PSZ256mbkz,
          9554 => Opcode::VFMSUBADD231PSZ256mk,
          9555 => Opcode::VFMSUBADD231PSZ256mkz,
          9556 => Opcode::VFMSUBADD231PSZ256r,
          9557 => Opcode::VFMSUBADD231PSZ256rk,
          9558 => Opcode::VFMSUBADD231PSZ256rkz,
          9559 => Opcode::VFMSUBADD231PSZm,
          9560 => Opcode::VFMSUBADD231PSZmb,
          9561 => Opcode::VFMSUBADD231PSZmbk,
          9562 => Opcode::VFMSUBADD231PSZmbkz,
          9563 => Opcode::VFMSUBADD231PSZmk,
          9564 => Opcode::VFMSUBADD231PSZmkz,
          9565 => Opcode::VFMSUBADD231PSZr,
          9566 => Opcode::VFMSUBADD231PSZrb,
          9567 => Opcode::VFMSUBADD231PSZrbk,
          9568 => Opcode::VFMSUBADD231PSZrbkz,
          9569 => Opcode::VFMSUBADD231PSZrk,
          9570 => Opcode::VFMSUBADD231PSZrkz,
          9571 => Opcode::VFMSUBADD231PSm,
          9572 => Opcode::VFMSUBADD231PSr,
          9573 => Opcode::VFMSUBADDPD4Ymr,
          9574 => Opcode::VFMSUBADDPD4Yrm,
          9575 => Opcode::VFMSUBADDPD4Yrr,
          9576 => Opcode::VFMSUBADDPD4Yrr_REV,
          9577 => Opcode::VFMSUBADDPD4mr,
          9578 => Opcode::VFMSUBADDPD4rm,
          9579 => Opcode::VFMSUBADDPD4rr,
          9580 => Opcode::VFMSUBADDPD4rr_REV,
          9581 => Opcode::VFMSUBADDPS4Ymr,
          9582 => Opcode::VFMSUBADDPS4Yrm,
          9583 => Opcode::VFMSUBADDPS4Yrr,
          9584 => Opcode::VFMSUBADDPS4Yrr_REV,
          9585 => Opcode::VFMSUBADDPS4mr,
          9586 => Opcode::VFMSUBADDPS4rm,
          9587 => Opcode::VFMSUBADDPS4rr,
          9588 => Opcode::VFMSUBADDPS4rr_REV,
          9589 => Opcode::VFMSUBPD4Ymr,
          9590 => Opcode::VFMSUBPD4Yrm,
          9591 => Opcode::VFMSUBPD4Yrr,
          9592 => Opcode::VFMSUBPD4Yrr_REV,
          9593 => Opcode::VFMSUBPD4mr,
          9594 => Opcode::VFMSUBPD4rm,
          9595 => Opcode::VFMSUBPD4rr,
          9596 => Opcode::VFMSUBPD4rr_REV,
          9597 => Opcode::VFMSUBPS4Ymr,
          9598 => Opcode::VFMSUBPS4Yrm,
          9599 => Opcode::VFMSUBPS4Yrr,
          9600 => Opcode::VFMSUBPS4Yrr_REV,
          9601 => Opcode::VFMSUBPS4mr,
          9602 => Opcode::VFMSUBPS4rm,
          9603 => Opcode::VFMSUBPS4rr,
          9604 => Opcode::VFMSUBPS4rr_REV,
          9605 => Opcode::VFMSUBSD4mr,
          9606 => Opcode::VFMSUBSD4mr_Int,
          9607 => Opcode::VFMSUBSD4rm,
          9608 => Opcode::VFMSUBSD4rm_Int,
          9609 => Opcode::VFMSUBSD4rr,
          9610 => Opcode::VFMSUBSD4rr_Int,
          9611 => Opcode::VFMSUBSD4rr_Int_REV,
          9612 => Opcode::VFMSUBSD4rr_REV,
          9613 => Opcode::VFMSUBSS4mr,
          9614 => Opcode::VFMSUBSS4mr_Int,
          9615 => Opcode::VFMSUBSS4rm,
          9616 => Opcode::VFMSUBSS4rm_Int,
          9617 => Opcode::VFMSUBSS4rr,
          9618 => Opcode::VFMSUBSS4rr_Int,
          9619 => Opcode::VFMSUBSS4rr_Int_REV,
          9620 => Opcode::VFMSUBSS4rr_REV,
          9621 => Opcode::VFMULCPHZ128rm,
          9622 => Opcode::VFMULCPHZ128rmb,
          9623 => Opcode::VFMULCPHZ128rmbk,
          9624 => Opcode::VFMULCPHZ128rmbkz,
          9625 => Opcode::VFMULCPHZ128rmk,
          9626 => Opcode::VFMULCPHZ128rmkz,
          9627 => Opcode::VFMULCPHZ128rr,
          9628 => Opcode::VFMULCPHZ128rrk,
          9629 => Opcode::VFMULCPHZ128rrkz,
          9630 => Opcode::VFMULCPHZ256rm,
          9631 => Opcode::VFMULCPHZ256rmb,
          9632 => Opcode::VFMULCPHZ256rmbk,
          9633 => Opcode::VFMULCPHZ256rmbkz,
          9634 => Opcode::VFMULCPHZ256rmk,
          9635 => Opcode::VFMULCPHZ256rmkz,
          9636 => Opcode::VFMULCPHZ256rr,
          9637 => Opcode::VFMULCPHZ256rrk,
          9638 => Opcode::VFMULCPHZ256rrkz,
          9639 => Opcode::VFMULCPHZrm,
          9640 => Opcode::VFMULCPHZrmb,
          9641 => Opcode::VFMULCPHZrmbk,
          9642 => Opcode::VFMULCPHZrmbkz,
          9643 => Opcode::VFMULCPHZrmk,
          9644 => Opcode::VFMULCPHZrmkz,
          9645 => Opcode::VFMULCPHZrr,
          9646 => Opcode::VFMULCPHZrrb,
          9647 => Opcode::VFMULCPHZrrbk,
          9648 => Opcode::VFMULCPHZrrbkz,
          9649 => Opcode::VFMULCPHZrrk,
          9650 => Opcode::VFMULCPHZrrkz,
          9651 => Opcode::VFMULCSHZrm,
          9652 => Opcode::VFMULCSHZrmk,
          9653 => Opcode::VFMULCSHZrmkz,
          9654 => Opcode::VFMULCSHZrr,
          9655 => Opcode::VFMULCSHZrrb,
          9656 => Opcode::VFMULCSHZrrbk,
          9657 => Opcode::VFMULCSHZrrbkz,
          9658 => Opcode::VFMULCSHZrrk,
          9659 => Opcode::VFMULCSHZrrkz,
          9660 => Opcode::VFNMADD132PDYm,
          9661 => Opcode::VFNMADD132PDYr,
          9662 => Opcode::VFNMADD132PDZ128m,
          9663 => Opcode::VFNMADD132PDZ128mb,
          9664 => Opcode::VFNMADD132PDZ128mbk,
          9665 => Opcode::VFNMADD132PDZ128mbkz,
          9666 => Opcode::VFNMADD132PDZ128mk,
          9667 => Opcode::VFNMADD132PDZ128mkz,
          9668 => Opcode::VFNMADD132PDZ128r,
          9669 => Opcode::VFNMADD132PDZ128rk,
          9670 => Opcode::VFNMADD132PDZ128rkz,
          9671 => Opcode::VFNMADD132PDZ256m,
          9672 => Opcode::VFNMADD132PDZ256mb,
          9673 => Opcode::VFNMADD132PDZ256mbk,
          9674 => Opcode::VFNMADD132PDZ256mbkz,
          9675 => Opcode::VFNMADD132PDZ256mk,
          9676 => Opcode::VFNMADD132PDZ256mkz,
          9677 => Opcode::VFNMADD132PDZ256r,
          9678 => Opcode::VFNMADD132PDZ256rk,
          9679 => Opcode::VFNMADD132PDZ256rkz,
          9680 => Opcode::VFNMADD132PDZm,
          9681 => Opcode::VFNMADD132PDZmb,
          9682 => Opcode::VFNMADD132PDZmbk,
          9683 => Opcode::VFNMADD132PDZmbkz,
          9684 => Opcode::VFNMADD132PDZmk,
          9685 => Opcode::VFNMADD132PDZmkz,
          9686 => Opcode::VFNMADD132PDZr,
          9687 => Opcode::VFNMADD132PDZrb,
          9688 => Opcode::VFNMADD132PDZrbk,
          9689 => Opcode::VFNMADD132PDZrbkz,
          9690 => Opcode::VFNMADD132PDZrk,
          9691 => Opcode::VFNMADD132PDZrkz,
          9692 => Opcode::VFNMADD132PDm,
          9693 => Opcode::VFNMADD132PDr,
          9694 => Opcode::VFNMADD132PHZ128m,
          9695 => Opcode::VFNMADD132PHZ128mb,
          9696 => Opcode::VFNMADD132PHZ128mbk,
          9697 => Opcode::VFNMADD132PHZ128mbkz,
          9698 => Opcode::VFNMADD132PHZ128mk,
          9699 => Opcode::VFNMADD132PHZ128mkz,
          9700 => Opcode::VFNMADD132PHZ128r,
          9701 => Opcode::VFNMADD132PHZ128rk,
          9702 => Opcode::VFNMADD132PHZ128rkz,
          9703 => Opcode::VFNMADD132PHZ256m,
          9704 => Opcode::VFNMADD132PHZ256mb,
          9705 => Opcode::VFNMADD132PHZ256mbk,
          9706 => Opcode::VFNMADD132PHZ256mbkz,
          9707 => Opcode::VFNMADD132PHZ256mk,
          9708 => Opcode::VFNMADD132PHZ256mkz,
          9709 => Opcode::VFNMADD132PHZ256r,
          9710 => Opcode::VFNMADD132PHZ256rk,
          9711 => Opcode::VFNMADD132PHZ256rkz,
          9712 => Opcode::VFNMADD132PHZm,
          9713 => Opcode::VFNMADD132PHZmb,
          9714 => Opcode::VFNMADD132PHZmbk,
          9715 => Opcode::VFNMADD132PHZmbkz,
          9716 => Opcode::VFNMADD132PHZmk,
          9717 => Opcode::VFNMADD132PHZmkz,
          9718 => Opcode::VFNMADD132PHZr,
          9719 => Opcode::VFNMADD132PHZrb,
          9720 => Opcode::VFNMADD132PHZrbk,
          9721 => Opcode::VFNMADD132PHZrbkz,
          9722 => Opcode::VFNMADD132PHZrk,
          9723 => Opcode::VFNMADD132PHZrkz,
          9724 => Opcode::VFNMADD132PSYm,
          9725 => Opcode::VFNMADD132PSYr,
          9726 => Opcode::VFNMADD132PSZ128m,
          9727 => Opcode::VFNMADD132PSZ128mb,
          9728 => Opcode::VFNMADD132PSZ128mbk,
          9729 => Opcode::VFNMADD132PSZ128mbkz,
          9730 => Opcode::VFNMADD132PSZ128mk,
          9731 => Opcode::VFNMADD132PSZ128mkz,
          9732 => Opcode::VFNMADD132PSZ128r,
          9733 => Opcode::VFNMADD132PSZ128rk,
          9734 => Opcode::VFNMADD132PSZ128rkz,
          9735 => Opcode::VFNMADD132PSZ256m,
          9736 => Opcode::VFNMADD132PSZ256mb,
          9737 => Opcode::VFNMADD132PSZ256mbk,
          9738 => Opcode::VFNMADD132PSZ256mbkz,
          9739 => Opcode::VFNMADD132PSZ256mk,
          9740 => Opcode::VFNMADD132PSZ256mkz,
          9741 => Opcode::VFNMADD132PSZ256r,
          9742 => Opcode::VFNMADD132PSZ256rk,
          9743 => Opcode::VFNMADD132PSZ256rkz,
          9744 => Opcode::VFNMADD132PSZm,
          9745 => Opcode::VFNMADD132PSZmb,
          9746 => Opcode::VFNMADD132PSZmbk,
          9747 => Opcode::VFNMADD132PSZmbkz,
          9748 => Opcode::VFNMADD132PSZmk,
          9749 => Opcode::VFNMADD132PSZmkz,
          9750 => Opcode::VFNMADD132PSZr,
          9751 => Opcode::VFNMADD132PSZrb,
          9752 => Opcode::VFNMADD132PSZrbk,
          9753 => Opcode::VFNMADD132PSZrbkz,
          9754 => Opcode::VFNMADD132PSZrk,
          9755 => Opcode::VFNMADD132PSZrkz,
          9756 => Opcode::VFNMADD132PSm,
          9757 => Opcode::VFNMADD132PSr,
          9758 => Opcode::VFNMADD132SDZm,
          9759 => Opcode::VFNMADD132SDZm_Int,
          9760 => Opcode::VFNMADD132SDZm_Intk,
          9761 => Opcode::VFNMADD132SDZm_Intkz,
          9762 => Opcode::VFNMADD132SDZr,
          9763 => Opcode::VFNMADD132SDZr_Int,
          9764 => Opcode::VFNMADD132SDZr_Intk,
          9765 => Opcode::VFNMADD132SDZr_Intkz,
          9766 => Opcode::VFNMADD132SDZrb,
          9767 => Opcode::VFNMADD132SDZrb_Int,
          9768 => Opcode::VFNMADD132SDZrb_Intk,
          9769 => Opcode::VFNMADD132SDZrb_Intkz,
          9770 => Opcode::VFNMADD132SDm,
          9771 => Opcode::VFNMADD132SDm_Int,
          9772 => Opcode::VFNMADD132SDr,
          9773 => Opcode::VFNMADD132SDr_Int,
          9774 => Opcode::VFNMADD132SHZm,
          9775 => Opcode::VFNMADD132SHZm_Int,
          9776 => Opcode::VFNMADD132SHZm_Intk,
          9777 => Opcode::VFNMADD132SHZm_Intkz,
          9778 => Opcode::VFNMADD132SHZr,
          9779 => Opcode::VFNMADD132SHZr_Int,
          9780 => Opcode::VFNMADD132SHZr_Intk,
          9781 => Opcode::VFNMADD132SHZr_Intkz,
          9782 => Opcode::VFNMADD132SHZrb,
          9783 => Opcode::VFNMADD132SHZrb_Int,
          9784 => Opcode::VFNMADD132SHZrb_Intk,
          9785 => Opcode::VFNMADD132SHZrb_Intkz,
          9786 => Opcode::VFNMADD132SSZm,
          9787 => Opcode::VFNMADD132SSZm_Int,
          9788 => Opcode::VFNMADD132SSZm_Intk,
          9789 => Opcode::VFNMADD132SSZm_Intkz,
          9790 => Opcode::VFNMADD132SSZr,
          9791 => Opcode::VFNMADD132SSZr_Int,
          9792 => Opcode::VFNMADD132SSZr_Intk,
          9793 => Opcode::VFNMADD132SSZr_Intkz,
          9794 => Opcode::VFNMADD132SSZrb,
          9795 => Opcode::VFNMADD132SSZrb_Int,
          9796 => Opcode::VFNMADD132SSZrb_Intk,
          9797 => Opcode::VFNMADD132SSZrb_Intkz,
          9798 => Opcode::VFNMADD132SSm,
          9799 => Opcode::VFNMADD132SSm_Int,
          9800 => Opcode::VFNMADD132SSr,
          9801 => Opcode::VFNMADD132SSr_Int,
          9802 => Opcode::VFNMADD213PDYm,
          9803 => Opcode::VFNMADD213PDYr,
          9804 => Opcode::VFNMADD213PDZ128m,
          9805 => Opcode::VFNMADD213PDZ128mb,
          9806 => Opcode::VFNMADD213PDZ128mbk,
          9807 => Opcode::VFNMADD213PDZ128mbkz,
          9808 => Opcode::VFNMADD213PDZ128mk,
          9809 => Opcode::VFNMADD213PDZ128mkz,
          9810 => Opcode::VFNMADD213PDZ128r,
          9811 => Opcode::VFNMADD213PDZ128rk,
          9812 => Opcode::VFNMADD213PDZ128rkz,
          9813 => Opcode::VFNMADD213PDZ256m,
          9814 => Opcode::VFNMADD213PDZ256mb,
          9815 => Opcode::VFNMADD213PDZ256mbk,
          9816 => Opcode::VFNMADD213PDZ256mbkz,
          9817 => Opcode::VFNMADD213PDZ256mk,
          9818 => Opcode::VFNMADD213PDZ256mkz,
          9819 => Opcode::VFNMADD213PDZ256r,
          9820 => Opcode::VFNMADD213PDZ256rk,
          9821 => Opcode::VFNMADD213PDZ256rkz,
          9822 => Opcode::VFNMADD213PDZm,
          9823 => Opcode::VFNMADD213PDZmb,
          9824 => Opcode::VFNMADD213PDZmbk,
          9825 => Opcode::VFNMADD213PDZmbkz,
          9826 => Opcode::VFNMADD213PDZmk,
          9827 => Opcode::VFNMADD213PDZmkz,
          9828 => Opcode::VFNMADD213PDZr,
          9829 => Opcode::VFNMADD213PDZrb,
          9830 => Opcode::VFNMADD213PDZrbk,
          9831 => Opcode::VFNMADD213PDZrbkz,
          9832 => Opcode::VFNMADD213PDZrk,
          9833 => Opcode::VFNMADD213PDZrkz,
          9834 => Opcode::VFNMADD213PDm,
          9835 => Opcode::VFNMADD213PDr,
          9836 => Opcode::VFNMADD213PHZ128m,
          9837 => Opcode::VFNMADD213PHZ128mb,
          9838 => Opcode::VFNMADD213PHZ128mbk,
          9839 => Opcode::VFNMADD213PHZ128mbkz,
          9840 => Opcode::VFNMADD213PHZ128mk,
          9841 => Opcode::VFNMADD213PHZ128mkz,
          9842 => Opcode::VFNMADD213PHZ128r,
          9843 => Opcode::VFNMADD213PHZ128rk,
          9844 => Opcode::VFNMADD213PHZ128rkz,
          9845 => Opcode::VFNMADD213PHZ256m,
          9846 => Opcode::VFNMADD213PHZ256mb,
          9847 => Opcode::VFNMADD213PHZ256mbk,
          9848 => Opcode::VFNMADD213PHZ256mbkz,
          9849 => Opcode::VFNMADD213PHZ256mk,
          9850 => Opcode::VFNMADD213PHZ256mkz,
          9851 => Opcode::VFNMADD213PHZ256r,
          9852 => Opcode::VFNMADD213PHZ256rk,
          9853 => Opcode::VFNMADD213PHZ256rkz,
          9854 => Opcode::VFNMADD213PHZm,
          9855 => Opcode::VFNMADD213PHZmb,
          9856 => Opcode::VFNMADD213PHZmbk,
          9857 => Opcode::VFNMADD213PHZmbkz,
          9858 => Opcode::VFNMADD213PHZmk,
          9859 => Opcode::VFNMADD213PHZmkz,
          9860 => Opcode::VFNMADD213PHZr,
          9861 => Opcode::VFNMADD213PHZrb,
          9862 => Opcode::VFNMADD213PHZrbk,
          9863 => Opcode::VFNMADD213PHZrbkz,
          9864 => Opcode::VFNMADD213PHZrk,
          9865 => Opcode::VFNMADD213PHZrkz,
          9866 => Opcode::VFNMADD213PSYm,
          9867 => Opcode::VFNMADD213PSYr,
          9868 => Opcode::VFNMADD213PSZ128m,
          9869 => Opcode::VFNMADD213PSZ128mb,
          9870 => Opcode::VFNMADD213PSZ128mbk,
          9871 => Opcode::VFNMADD213PSZ128mbkz,
          9872 => Opcode::VFNMADD213PSZ128mk,
          9873 => Opcode::VFNMADD213PSZ128mkz,
          9874 => Opcode::VFNMADD213PSZ128r,
          9875 => Opcode::VFNMADD213PSZ128rk,
          9876 => Opcode::VFNMADD213PSZ128rkz,
          9877 => Opcode::VFNMADD213PSZ256m,
          9878 => Opcode::VFNMADD213PSZ256mb,
          9879 => Opcode::VFNMADD213PSZ256mbk,
          9880 => Opcode::VFNMADD213PSZ256mbkz,
          9881 => Opcode::VFNMADD213PSZ256mk,
          9882 => Opcode::VFNMADD213PSZ256mkz,
          9883 => Opcode::VFNMADD213PSZ256r,
          9884 => Opcode::VFNMADD213PSZ256rk,
          9885 => Opcode::VFNMADD213PSZ256rkz,
          9886 => Opcode::VFNMADD213PSZm,
          9887 => Opcode::VFNMADD213PSZmb,
          9888 => Opcode::VFNMADD213PSZmbk,
          9889 => Opcode::VFNMADD213PSZmbkz,
          9890 => Opcode::VFNMADD213PSZmk,
          9891 => Opcode::VFNMADD213PSZmkz,
          9892 => Opcode::VFNMADD213PSZr,
          9893 => Opcode::VFNMADD213PSZrb,
          9894 => Opcode::VFNMADD213PSZrbk,
          9895 => Opcode::VFNMADD213PSZrbkz,
          9896 => Opcode::VFNMADD213PSZrk,
          9897 => Opcode::VFNMADD213PSZrkz,
          9898 => Opcode::VFNMADD213PSm,
          9899 => Opcode::VFNMADD213PSr,
          9900 => Opcode::VFNMADD213SDZm,
          9901 => Opcode::VFNMADD213SDZm_Int,
          9902 => Opcode::VFNMADD213SDZm_Intk,
          9903 => Opcode::VFNMADD213SDZm_Intkz,
          9904 => Opcode::VFNMADD213SDZr,
          9905 => Opcode::VFNMADD213SDZr_Int,
          9906 => Opcode::VFNMADD213SDZr_Intk,
          9907 => Opcode::VFNMADD213SDZr_Intkz,
          9908 => Opcode::VFNMADD213SDZrb,
          9909 => Opcode::VFNMADD213SDZrb_Int,
          9910 => Opcode::VFNMADD213SDZrb_Intk,
          9911 => Opcode::VFNMADD213SDZrb_Intkz,
          9912 => Opcode::VFNMADD213SDm,
          9913 => Opcode::VFNMADD213SDm_Int,
          9914 => Opcode::VFNMADD213SDr,
          9915 => Opcode::VFNMADD213SDr_Int,
          9916 => Opcode::VFNMADD213SHZm,
          9917 => Opcode::VFNMADD213SHZm_Int,
          9918 => Opcode::VFNMADD213SHZm_Intk,
          9919 => Opcode::VFNMADD213SHZm_Intkz,
          9920 => Opcode::VFNMADD213SHZr,
          9921 => Opcode::VFNMADD213SHZr_Int,
          9922 => Opcode::VFNMADD213SHZr_Intk,
          9923 => Opcode::VFNMADD213SHZr_Intkz,
          9924 => Opcode::VFNMADD213SHZrb,
          9925 => Opcode::VFNMADD213SHZrb_Int,
          9926 => Opcode::VFNMADD213SHZrb_Intk,
          9927 => Opcode::VFNMADD213SHZrb_Intkz,
          9928 => Opcode::VFNMADD213SSZm,
          9929 => Opcode::VFNMADD213SSZm_Int,
          9930 => Opcode::VFNMADD213SSZm_Intk,
          9931 => Opcode::VFNMADD213SSZm_Intkz,
          9932 => Opcode::VFNMADD213SSZr,
          9933 => Opcode::VFNMADD213SSZr_Int,
          9934 => Opcode::VFNMADD213SSZr_Intk,
          9935 => Opcode::VFNMADD213SSZr_Intkz,
          9936 => Opcode::VFNMADD213SSZrb,
          9937 => Opcode::VFNMADD213SSZrb_Int,
          9938 => Opcode::VFNMADD213SSZrb_Intk,
          9939 => Opcode::VFNMADD213SSZrb_Intkz,
          9940 => Opcode::VFNMADD213SSm,
          9941 => Opcode::VFNMADD213SSm_Int,
          9942 => Opcode::VFNMADD213SSr,
          9943 => Opcode::VFNMADD213SSr_Int,
          9944 => Opcode::VFNMADD231PDYm,
          9945 => Opcode::VFNMADD231PDYr,
          9946 => Opcode::VFNMADD231PDZ128m,
          9947 => Opcode::VFNMADD231PDZ128mb,
          9948 => Opcode::VFNMADD231PDZ128mbk,
          9949 => Opcode::VFNMADD231PDZ128mbkz,
          9950 => Opcode::VFNMADD231PDZ128mk,
          9951 => Opcode::VFNMADD231PDZ128mkz,
          9952 => Opcode::VFNMADD231PDZ128r,
          9953 => Opcode::VFNMADD231PDZ128rk,
          9954 => Opcode::VFNMADD231PDZ128rkz,
          9955 => Opcode::VFNMADD231PDZ256m,
          9956 => Opcode::VFNMADD231PDZ256mb,
          9957 => Opcode::VFNMADD231PDZ256mbk,
          9958 => Opcode::VFNMADD231PDZ256mbkz,
          9959 => Opcode::VFNMADD231PDZ256mk,
          9960 => Opcode::VFNMADD231PDZ256mkz,
          9961 => Opcode::VFNMADD231PDZ256r,
          9962 => Opcode::VFNMADD231PDZ256rk,
          9963 => Opcode::VFNMADD231PDZ256rkz,
          9964 => Opcode::VFNMADD231PDZm,
          9965 => Opcode::VFNMADD231PDZmb,
          9966 => Opcode::VFNMADD231PDZmbk,
          9967 => Opcode::VFNMADD231PDZmbkz,
          9968 => Opcode::VFNMADD231PDZmk,
          9969 => Opcode::VFNMADD231PDZmkz,
          9970 => Opcode::VFNMADD231PDZr,
          9971 => Opcode::VFNMADD231PDZrb,
          9972 => Opcode::VFNMADD231PDZrbk,
          9973 => Opcode::VFNMADD231PDZrbkz,
          9974 => Opcode::VFNMADD231PDZrk,
          9975 => Opcode::VFNMADD231PDZrkz,
          9976 => Opcode::VFNMADD231PDm,
          9977 => Opcode::VFNMADD231PDr,
          9978 => Opcode::VFNMADD231PHZ128m,
          9979 => Opcode::VFNMADD231PHZ128mb,
          9980 => Opcode::VFNMADD231PHZ128mbk,
          9981 => Opcode::VFNMADD231PHZ128mbkz,
          9982 => Opcode::VFNMADD231PHZ128mk,
          9983 => Opcode::VFNMADD231PHZ128mkz,
          9984 => Opcode::VFNMADD231PHZ128r,
          9985 => Opcode::VFNMADD231PHZ128rk,
          9986 => Opcode::VFNMADD231PHZ128rkz,
          9987 => Opcode::VFNMADD231PHZ256m,
          9988 => Opcode::VFNMADD231PHZ256mb,
          9989 => Opcode::VFNMADD231PHZ256mbk,
          9990 => Opcode::VFNMADD231PHZ256mbkz,
          9991 => Opcode::VFNMADD231PHZ256mk,
          9992 => Opcode::VFNMADD231PHZ256mkz,
          9993 => Opcode::VFNMADD231PHZ256r,
          9994 => Opcode::VFNMADD231PHZ256rk,
          9995 => Opcode::VFNMADD231PHZ256rkz,
          9996 => Opcode::VFNMADD231PHZm,
          9997 => Opcode::VFNMADD231PHZmb,
          9998 => Opcode::VFNMADD231PHZmbk,
          9999 => Opcode::VFNMADD231PHZmbkz,
          10000 => Opcode::VFNMADD231PHZmk,
          10001 => Opcode::VFNMADD231PHZmkz,
          10002 => Opcode::VFNMADD231PHZr,
          10003 => Opcode::VFNMADD231PHZrb,
          10004 => Opcode::VFNMADD231PHZrbk,
          10005 => Opcode::VFNMADD231PHZrbkz,
          10006 => Opcode::VFNMADD231PHZrk,
          10007 => Opcode::VFNMADD231PHZrkz,
          10008 => Opcode::VFNMADD231PSYm,
          10009 => Opcode::VFNMADD231PSYr,
          10010 => Opcode::VFNMADD231PSZ128m,
          10011 => Opcode::VFNMADD231PSZ128mb,
          10012 => Opcode::VFNMADD231PSZ128mbk,
          10013 => Opcode::VFNMADD231PSZ128mbkz,
          10014 => Opcode::VFNMADD231PSZ128mk,
          10015 => Opcode::VFNMADD231PSZ128mkz,
          10016 => Opcode::VFNMADD231PSZ128r,
          10017 => Opcode::VFNMADD231PSZ128rk,
          10018 => Opcode::VFNMADD231PSZ128rkz,
          10019 => Opcode::VFNMADD231PSZ256m,
          10020 => Opcode::VFNMADD231PSZ256mb,
          10021 => Opcode::VFNMADD231PSZ256mbk,
          10022 => Opcode::VFNMADD231PSZ256mbkz,
          10023 => Opcode::VFNMADD231PSZ256mk,
          10024 => Opcode::VFNMADD231PSZ256mkz,
          10025 => Opcode::VFNMADD231PSZ256r,
          10026 => Opcode::VFNMADD231PSZ256rk,
          10027 => Opcode::VFNMADD231PSZ256rkz,
          10028 => Opcode::VFNMADD231PSZm,
          10029 => Opcode::VFNMADD231PSZmb,
          10030 => Opcode::VFNMADD231PSZmbk,
          10031 => Opcode::VFNMADD231PSZmbkz,
          10032 => Opcode::VFNMADD231PSZmk,
          10033 => Opcode::VFNMADD231PSZmkz,
          10034 => Opcode::VFNMADD231PSZr,
          10035 => Opcode::VFNMADD231PSZrb,
          10036 => Opcode::VFNMADD231PSZrbk,
          10037 => Opcode::VFNMADD231PSZrbkz,
          10038 => Opcode::VFNMADD231PSZrk,
          10039 => Opcode::VFNMADD231PSZrkz,
          10040 => Opcode::VFNMADD231PSm,
          10041 => Opcode::VFNMADD231PSr,
          10042 => Opcode::VFNMADD231SDZm,
          10043 => Opcode::VFNMADD231SDZm_Int,
          10044 => Opcode::VFNMADD231SDZm_Intk,
          10045 => Opcode::VFNMADD231SDZm_Intkz,
          10046 => Opcode::VFNMADD231SDZr,
          10047 => Opcode::VFNMADD231SDZr_Int,
          10048 => Opcode::VFNMADD231SDZr_Intk,
          10049 => Opcode::VFNMADD231SDZr_Intkz,
          10050 => Opcode::VFNMADD231SDZrb,
          10051 => Opcode::VFNMADD231SDZrb_Int,
          10052 => Opcode::VFNMADD231SDZrb_Intk,
          10053 => Opcode::VFNMADD231SDZrb_Intkz,
          10054 => Opcode::VFNMADD231SDm,
          10055 => Opcode::VFNMADD231SDm_Int,
          10056 => Opcode::VFNMADD231SDr,
          10057 => Opcode::VFNMADD231SDr_Int,
          10058 => Opcode::VFNMADD231SHZm,
          10059 => Opcode::VFNMADD231SHZm_Int,
          10060 => Opcode::VFNMADD231SHZm_Intk,
          10061 => Opcode::VFNMADD231SHZm_Intkz,
          10062 => Opcode::VFNMADD231SHZr,
          10063 => Opcode::VFNMADD231SHZr_Int,
          10064 => Opcode::VFNMADD231SHZr_Intk,
          10065 => Opcode::VFNMADD231SHZr_Intkz,
          10066 => Opcode::VFNMADD231SHZrb,
          10067 => Opcode::VFNMADD231SHZrb_Int,
          10068 => Opcode::VFNMADD231SHZrb_Intk,
          10069 => Opcode::VFNMADD231SHZrb_Intkz,
          10070 => Opcode::VFNMADD231SSZm,
          10071 => Opcode::VFNMADD231SSZm_Int,
          10072 => Opcode::VFNMADD231SSZm_Intk,
          10073 => Opcode::VFNMADD231SSZm_Intkz,
          10074 => Opcode::VFNMADD231SSZr,
          10075 => Opcode::VFNMADD231SSZr_Int,
          10076 => Opcode::VFNMADD231SSZr_Intk,
          10077 => Opcode::VFNMADD231SSZr_Intkz,
          10078 => Opcode::VFNMADD231SSZrb,
          10079 => Opcode::VFNMADD231SSZrb_Int,
          10080 => Opcode::VFNMADD231SSZrb_Intk,
          10081 => Opcode::VFNMADD231SSZrb_Intkz,
          10082 => Opcode::VFNMADD231SSm,
          10083 => Opcode::VFNMADD231SSm_Int,
          10084 => Opcode::VFNMADD231SSr,
          10085 => Opcode::VFNMADD231SSr_Int,
          10086 => Opcode::VFNMADDPD4Ymr,
          10087 => Opcode::VFNMADDPD4Yrm,
          10088 => Opcode::VFNMADDPD4Yrr,
          10089 => Opcode::VFNMADDPD4Yrr_REV,
          10090 => Opcode::VFNMADDPD4mr,
          10091 => Opcode::VFNMADDPD4rm,
          10092 => Opcode::VFNMADDPD4rr,
          10093 => Opcode::VFNMADDPD4rr_REV,
          10094 => Opcode::VFNMADDPS4Ymr,
          10095 => Opcode::VFNMADDPS4Yrm,
          10096 => Opcode::VFNMADDPS4Yrr,
          10097 => Opcode::VFNMADDPS4Yrr_REV,
          10098 => Opcode::VFNMADDPS4mr,
          10099 => Opcode::VFNMADDPS4rm,
          10100 => Opcode::VFNMADDPS4rr,
          10101 => Opcode::VFNMADDPS4rr_REV,
          10102 => Opcode::VFNMADDSD4mr,
          10103 => Opcode::VFNMADDSD4mr_Int,
          10104 => Opcode::VFNMADDSD4rm,
          10105 => Opcode::VFNMADDSD4rm_Int,
          10106 => Opcode::VFNMADDSD4rr,
          10107 => Opcode::VFNMADDSD4rr_Int,
          10108 => Opcode::VFNMADDSD4rr_Int_REV,
          10109 => Opcode::VFNMADDSD4rr_REV,
          10110 => Opcode::VFNMADDSS4mr,
          10111 => Opcode::VFNMADDSS4mr_Int,
          10112 => Opcode::VFNMADDSS4rm,
          10113 => Opcode::VFNMADDSS4rm_Int,
          10114 => Opcode::VFNMADDSS4rr,
          10115 => Opcode::VFNMADDSS4rr_Int,
          10116 => Opcode::VFNMADDSS4rr_Int_REV,
          10117 => Opcode::VFNMADDSS4rr_REV,
          10118 => Opcode::VFNMSUB132PDYm,
          10119 => Opcode::VFNMSUB132PDYr,
          10120 => Opcode::VFNMSUB132PDZ128m,
          10121 => Opcode::VFNMSUB132PDZ128mb,
          10122 => Opcode::VFNMSUB132PDZ128mbk,
          10123 => Opcode::VFNMSUB132PDZ128mbkz,
          10124 => Opcode::VFNMSUB132PDZ128mk,
          10125 => Opcode::VFNMSUB132PDZ128mkz,
          10126 => Opcode::VFNMSUB132PDZ128r,
          10127 => Opcode::VFNMSUB132PDZ128rk,
          10128 => Opcode::VFNMSUB132PDZ128rkz,
          10129 => Opcode::VFNMSUB132PDZ256m,
          10130 => Opcode::VFNMSUB132PDZ256mb,
          10131 => Opcode::VFNMSUB132PDZ256mbk,
          10132 => Opcode::VFNMSUB132PDZ256mbkz,
          10133 => Opcode::VFNMSUB132PDZ256mk,
          10134 => Opcode::VFNMSUB132PDZ256mkz,
          10135 => Opcode::VFNMSUB132PDZ256r,
          10136 => Opcode::VFNMSUB132PDZ256rk,
          10137 => Opcode::VFNMSUB132PDZ256rkz,
          10138 => Opcode::VFNMSUB132PDZm,
          10139 => Opcode::VFNMSUB132PDZmb,
          10140 => Opcode::VFNMSUB132PDZmbk,
          10141 => Opcode::VFNMSUB132PDZmbkz,
          10142 => Opcode::VFNMSUB132PDZmk,
          10143 => Opcode::VFNMSUB132PDZmkz,
          10144 => Opcode::VFNMSUB132PDZr,
          10145 => Opcode::VFNMSUB132PDZrb,
          10146 => Opcode::VFNMSUB132PDZrbk,
          10147 => Opcode::VFNMSUB132PDZrbkz,
          10148 => Opcode::VFNMSUB132PDZrk,
          10149 => Opcode::VFNMSUB132PDZrkz,
          10150 => Opcode::VFNMSUB132PDm,
          10151 => Opcode::VFNMSUB132PDr,
          10152 => Opcode::VFNMSUB132PHZ128m,
          10153 => Opcode::VFNMSUB132PHZ128mb,
          10154 => Opcode::VFNMSUB132PHZ128mbk,
          10155 => Opcode::VFNMSUB132PHZ128mbkz,
          10156 => Opcode::VFNMSUB132PHZ128mk,
          10157 => Opcode::VFNMSUB132PHZ128mkz,
          10158 => Opcode::VFNMSUB132PHZ128r,
          10159 => Opcode::VFNMSUB132PHZ128rk,
          10160 => Opcode::VFNMSUB132PHZ128rkz,
          10161 => Opcode::VFNMSUB132PHZ256m,
          10162 => Opcode::VFNMSUB132PHZ256mb,
          10163 => Opcode::VFNMSUB132PHZ256mbk,
          10164 => Opcode::VFNMSUB132PHZ256mbkz,
          10165 => Opcode::VFNMSUB132PHZ256mk,
          10166 => Opcode::VFNMSUB132PHZ256mkz,
          10167 => Opcode::VFNMSUB132PHZ256r,
          10168 => Opcode::VFNMSUB132PHZ256rk,
          10169 => Opcode::VFNMSUB132PHZ256rkz,
          10170 => Opcode::VFNMSUB132PHZm,
          10171 => Opcode::VFNMSUB132PHZmb,
          10172 => Opcode::VFNMSUB132PHZmbk,
          10173 => Opcode::VFNMSUB132PHZmbkz,
          10174 => Opcode::VFNMSUB132PHZmk,
          10175 => Opcode::VFNMSUB132PHZmkz,
          10176 => Opcode::VFNMSUB132PHZr,
          10177 => Opcode::VFNMSUB132PHZrb,
          10178 => Opcode::VFNMSUB132PHZrbk,
          10179 => Opcode::VFNMSUB132PHZrbkz,
          10180 => Opcode::VFNMSUB132PHZrk,
          10181 => Opcode::VFNMSUB132PHZrkz,
          10182 => Opcode::VFNMSUB132PSYm,
          10183 => Opcode::VFNMSUB132PSYr,
          10184 => Opcode::VFNMSUB132PSZ128m,
          10185 => Opcode::VFNMSUB132PSZ128mb,
          10186 => Opcode::VFNMSUB132PSZ128mbk,
          10187 => Opcode::VFNMSUB132PSZ128mbkz,
          10188 => Opcode::VFNMSUB132PSZ128mk,
          10189 => Opcode::VFNMSUB132PSZ128mkz,
          10190 => Opcode::VFNMSUB132PSZ128r,
          10191 => Opcode::VFNMSUB132PSZ128rk,
          10192 => Opcode::VFNMSUB132PSZ128rkz,
          10193 => Opcode::VFNMSUB132PSZ256m,
          10194 => Opcode::VFNMSUB132PSZ256mb,
          10195 => Opcode::VFNMSUB132PSZ256mbk,
          10196 => Opcode::VFNMSUB132PSZ256mbkz,
          10197 => Opcode::VFNMSUB132PSZ256mk,
          10198 => Opcode::VFNMSUB132PSZ256mkz,
          10199 => Opcode::VFNMSUB132PSZ256r,
          10200 => Opcode::VFNMSUB132PSZ256rk,
          10201 => Opcode::VFNMSUB132PSZ256rkz,
          10202 => Opcode::VFNMSUB132PSZm,
          10203 => Opcode::VFNMSUB132PSZmb,
          10204 => Opcode::VFNMSUB132PSZmbk,
          10205 => Opcode::VFNMSUB132PSZmbkz,
          10206 => Opcode::VFNMSUB132PSZmk,
          10207 => Opcode::VFNMSUB132PSZmkz,
          10208 => Opcode::VFNMSUB132PSZr,
          10209 => Opcode::VFNMSUB132PSZrb,
          10210 => Opcode::VFNMSUB132PSZrbk,
          10211 => Opcode::VFNMSUB132PSZrbkz,
          10212 => Opcode::VFNMSUB132PSZrk,
          10213 => Opcode::VFNMSUB132PSZrkz,
          10214 => Opcode::VFNMSUB132PSm,
          10215 => Opcode::VFNMSUB132PSr,
          10216 => Opcode::VFNMSUB132SDZm,
          10217 => Opcode::VFNMSUB132SDZm_Int,
          10218 => Opcode::VFNMSUB132SDZm_Intk,
          10219 => Opcode::VFNMSUB132SDZm_Intkz,
          10220 => Opcode::VFNMSUB132SDZr,
          10221 => Opcode::VFNMSUB132SDZr_Int,
          10222 => Opcode::VFNMSUB132SDZr_Intk,
          10223 => Opcode::VFNMSUB132SDZr_Intkz,
          10224 => Opcode::VFNMSUB132SDZrb,
          10225 => Opcode::VFNMSUB132SDZrb_Int,
          10226 => Opcode::VFNMSUB132SDZrb_Intk,
          10227 => Opcode::VFNMSUB132SDZrb_Intkz,
          10228 => Opcode::VFNMSUB132SDm,
          10229 => Opcode::VFNMSUB132SDm_Int,
          10230 => Opcode::VFNMSUB132SDr,
          10231 => Opcode::VFNMSUB132SDr_Int,
          10232 => Opcode::VFNMSUB132SHZm,
          10233 => Opcode::VFNMSUB132SHZm_Int,
          10234 => Opcode::VFNMSUB132SHZm_Intk,
          10235 => Opcode::VFNMSUB132SHZm_Intkz,
          10236 => Opcode::VFNMSUB132SHZr,
          10237 => Opcode::VFNMSUB132SHZr_Int,
          10238 => Opcode::VFNMSUB132SHZr_Intk,
          10239 => Opcode::VFNMSUB132SHZr_Intkz,
          10240 => Opcode::VFNMSUB132SHZrb,
          10241 => Opcode::VFNMSUB132SHZrb_Int,
          10242 => Opcode::VFNMSUB132SHZrb_Intk,
          10243 => Opcode::VFNMSUB132SHZrb_Intkz,
          10244 => Opcode::VFNMSUB132SSZm,
          10245 => Opcode::VFNMSUB132SSZm_Int,
          10246 => Opcode::VFNMSUB132SSZm_Intk,
          10247 => Opcode::VFNMSUB132SSZm_Intkz,
          10248 => Opcode::VFNMSUB132SSZr,
          10249 => Opcode::VFNMSUB132SSZr_Int,
          10250 => Opcode::VFNMSUB132SSZr_Intk,
          10251 => Opcode::VFNMSUB132SSZr_Intkz,
          10252 => Opcode::VFNMSUB132SSZrb,
          10253 => Opcode::VFNMSUB132SSZrb_Int,
          10254 => Opcode::VFNMSUB132SSZrb_Intk,
          10255 => Opcode::VFNMSUB132SSZrb_Intkz,
          10256 => Opcode::VFNMSUB132SSm,
          10257 => Opcode::VFNMSUB132SSm_Int,
          10258 => Opcode::VFNMSUB132SSr,
          10259 => Opcode::VFNMSUB132SSr_Int,
          10260 => Opcode::VFNMSUB213PDYm,
          10261 => Opcode::VFNMSUB213PDYr,
          10262 => Opcode::VFNMSUB213PDZ128m,
          10263 => Opcode::VFNMSUB213PDZ128mb,
          10264 => Opcode::VFNMSUB213PDZ128mbk,
          10265 => Opcode::VFNMSUB213PDZ128mbkz,
          10266 => Opcode::VFNMSUB213PDZ128mk,
          10267 => Opcode::VFNMSUB213PDZ128mkz,
          10268 => Opcode::VFNMSUB213PDZ128r,
          10269 => Opcode::VFNMSUB213PDZ128rk,
          10270 => Opcode::VFNMSUB213PDZ128rkz,
          10271 => Opcode::VFNMSUB213PDZ256m,
          10272 => Opcode::VFNMSUB213PDZ256mb,
          10273 => Opcode::VFNMSUB213PDZ256mbk,
          10274 => Opcode::VFNMSUB213PDZ256mbkz,
          10275 => Opcode::VFNMSUB213PDZ256mk,
          10276 => Opcode::VFNMSUB213PDZ256mkz,
          10277 => Opcode::VFNMSUB213PDZ256r,
          10278 => Opcode::VFNMSUB213PDZ256rk,
          10279 => Opcode::VFNMSUB213PDZ256rkz,
          10280 => Opcode::VFNMSUB213PDZm,
          10281 => Opcode::VFNMSUB213PDZmb,
          10282 => Opcode::VFNMSUB213PDZmbk,
          10283 => Opcode::VFNMSUB213PDZmbkz,
          10284 => Opcode::VFNMSUB213PDZmk,
          10285 => Opcode::VFNMSUB213PDZmkz,
          10286 => Opcode::VFNMSUB213PDZr,
          10287 => Opcode::VFNMSUB213PDZrb,
          10288 => Opcode::VFNMSUB213PDZrbk,
          10289 => Opcode::VFNMSUB213PDZrbkz,
          10290 => Opcode::VFNMSUB213PDZrk,
          10291 => Opcode::VFNMSUB213PDZrkz,
          10292 => Opcode::VFNMSUB213PDm,
          10293 => Opcode::VFNMSUB213PDr,
          10294 => Opcode::VFNMSUB213PHZ128m,
          10295 => Opcode::VFNMSUB213PHZ128mb,
          10296 => Opcode::VFNMSUB213PHZ128mbk,
          10297 => Opcode::VFNMSUB213PHZ128mbkz,
          10298 => Opcode::VFNMSUB213PHZ128mk,
          10299 => Opcode::VFNMSUB213PHZ128mkz,
          10300 => Opcode::VFNMSUB213PHZ128r,
          10301 => Opcode::VFNMSUB213PHZ128rk,
          10302 => Opcode::VFNMSUB213PHZ128rkz,
          10303 => Opcode::VFNMSUB213PHZ256m,
          10304 => Opcode::VFNMSUB213PHZ256mb,
          10305 => Opcode::VFNMSUB213PHZ256mbk,
          10306 => Opcode::VFNMSUB213PHZ256mbkz,
          10307 => Opcode::VFNMSUB213PHZ256mk,
          10308 => Opcode::VFNMSUB213PHZ256mkz,
          10309 => Opcode::VFNMSUB213PHZ256r,
          10310 => Opcode::VFNMSUB213PHZ256rk,
          10311 => Opcode::VFNMSUB213PHZ256rkz,
          10312 => Opcode::VFNMSUB213PHZm,
          10313 => Opcode::VFNMSUB213PHZmb,
          10314 => Opcode::VFNMSUB213PHZmbk,
          10315 => Opcode::VFNMSUB213PHZmbkz,
          10316 => Opcode::VFNMSUB213PHZmk,
          10317 => Opcode::VFNMSUB213PHZmkz,
          10318 => Opcode::VFNMSUB213PHZr,
          10319 => Opcode::VFNMSUB213PHZrb,
          10320 => Opcode::VFNMSUB213PHZrbk,
          10321 => Opcode::VFNMSUB213PHZrbkz,
          10322 => Opcode::VFNMSUB213PHZrk,
          10323 => Opcode::VFNMSUB213PHZrkz,
          10324 => Opcode::VFNMSUB213PSYm,
          10325 => Opcode::VFNMSUB213PSYr,
          10326 => Opcode::VFNMSUB213PSZ128m,
          10327 => Opcode::VFNMSUB213PSZ128mb,
          10328 => Opcode::VFNMSUB213PSZ128mbk,
          10329 => Opcode::VFNMSUB213PSZ128mbkz,
          10330 => Opcode::VFNMSUB213PSZ128mk,
          10331 => Opcode::VFNMSUB213PSZ128mkz,
          10332 => Opcode::VFNMSUB213PSZ128r,
          10333 => Opcode::VFNMSUB213PSZ128rk,
          10334 => Opcode::VFNMSUB213PSZ128rkz,
          10335 => Opcode::VFNMSUB213PSZ256m,
          10336 => Opcode::VFNMSUB213PSZ256mb,
          10337 => Opcode::VFNMSUB213PSZ256mbk,
          10338 => Opcode::VFNMSUB213PSZ256mbkz,
          10339 => Opcode::VFNMSUB213PSZ256mk,
          10340 => Opcode::VFNMSUB213PSZ256mkz,
          10341 => Opcode::VFNMSUB213PSZ256r,
          10342 => Opcode::VFNMSUB213PSZ256rk,
          10343 => Opcode::VFNMSUB213PSZ256rkz,
          10344 => Opcode::VFNMSUB213PSZm,
          10345 => Opcode::VFNMSUB213PSZmb,
          10346 => Opcode::VFNMSUB213PSZmbk,
          10347 => Opcode::VFNMSUB213PSZmbkz,
          10348 => Opcode::VFNMSUB213PSZmk,
          10349 => Opcode::VFNMSUB213PSZmkz,
          10350 => Opcode::VFNMSUB213PSZr,
          10351 => Opcode::VFNMSUB213PSZrb,
          10352 => Opcode::VFNMSUB213PSZrbk,
          10353 => Opcode::VFNMSUB213PSZrbkz,
          10354 => Opcode::VFNMSUB213PSZrk,
          10355 => Opcode::VFNMSUB213PSZrkz,
          10356 => Opcode::VFNMSUB213PSm,
          10357 => Opcode::VFNMSUB213PSr,
          10358 => Opcode::VFNMSUB213SDZm,
          10359 => Opcode::VFNMSUB213SDZm_Int,
          10360 => Opcode::VFNMSUB213SDZm_Intk,
          10361 => Opcode::VFNMSUB213SDZm_Intkz,
          10362 => Opcode::VFNMSUB213SDZr,
          10363 => Opcode::VFNMSUB213SDZr_Int,
          10364 => Opcode::VFNMSUB213SDZr_Intk,
          10365 => Opcode::VFNMSUB213SDZr_Intkz,
          10366 => Opcode::VFNMSUB213SDZrb,
          10367 => Opcode::VFNMSUB213SDZrb_Int,
          10368 => Opcode::VFNMSUB213SDZrb_Intk,
          10369 => Opcode::VFNMSUB213SDZrb_Intkz,
          10370 => Opcode::VFNMSUB213SDm,
          10371 => Opcode::VFNMSUB213SDm_Int,
          10372 => Opcode::VFNMSUB213SDr,
          10373 => Opcode::VFNMSUB213SDr_Int,
          10374 => Opcode::VFNMSUB213SHZm,
          10375 => Opcode::VFNMSUB213SHZm_Int,
          10376 => Opcode::VFNMSUB213SHZm_Intk,
          10377 => Opcode::VFNMSUB213SHZm_Intkz,
          10378 => Opcode::VFNMSUB213SHZr,
          10379 => Opcode::VFNMSUB213SHZr_Int,
          10380 => Opcode::VFNMSUB213SHZr_Intk,
          10381 => Opcode::VFNMSUB213SHZr_Intkz,
          10382 => Opcode::VFNMSUB213SHZrb,
          10383 => Opcode::VFNMSUB213SHZrb_Int,
          10384 => Opcode::VFNMSUB213SHZrb_Intk,
          10385 => Opcode::VFNMSUB213SHZrb_Intkz,
          10386 => Opcode::VFNMSUB213SSZm,
          10387 => Opcode::VFNMSUB213SSZm_Int,
          10388 => Opcode::VFNMSUB213SSZm_Intk,
          10389 => Opcode::VFNMSUB213SSZm_Intkz,
          10390 => Opcode::VFNMSUB213SSZr,
          10391 => Opcode::VFNMSUB213SSZr_Int,
          10392 => Opcode::VFNMSUB213SSZr_Intk,
          10393 => Opcode::VFNMSUB213SSZr_Intkz,
          10394 => Opcode::VFNMSUB213SSZrb,
          10395 => Opcode::VFNMSUB213SSZrb_Int,
          10396 => Opcode::VFNMSUB213SSZrb_Intk,
          10397 => Opcode::VFNMSUB213SSZrb_Intkz,
          10398 => Opcode::VFNMSUB213SSm,
          10399 => Opcode::VFNMSUB213SSm_Int,
          10400 => Opcode::VFNMSUB213SSr,
          10401 => Opcode::VFNMSUB213SSr_Int,
          10402 => Opcode::VFNMSUB231PDYm,
          10403 => Opcode::VFNMSUB231PDYr,
          10404 => Opcode::VFNMSUB231PDZ128m,
          10405 => Opcode::VFNMSUB231PDZ128mb,
          10406 => Opcode::VFNMSUB231PDZ128mbk,
          10407 => Opcode::VFNMSUB231PDZ128mbkz,
          10408 => Opcode::VFNMSUB231PDZ128mk,
          10409 => Opcode::VFNMSUB231PDZ128mkz,
          10410 => Opcode::VFNMSUB231PDZ128r,
          10411 => Opcode::VFNMSUB231PDZ128rk,
          10412 => Opcode::VFNMSUB231PDZ128rkz,
          10413 => Opcode::VFNMSUB231PDZ256m,
          10414 => Opcode::VFNMSUB231PDZ256mb,
          10415 => Opcode::VFNMSUB231PDZ256mbk,
          10416 => Opcode::VFNMSUB231PDZ256mbkz,
          10417 => Opcode::VFNMSUB231PDZ256mk,
          10418 => Opcode::VFNMSUB231PDZ256mkz,
          10419 => Opcode::VFNMSUB231PDZ256r,
          10420 => Opcode::VFNMSUB231PDZ256rk,
          10421 => Opcode::VFNMSUB231PDZ256rkz,
          10422 => Opcode::VFNMSUB231PDZm,
          10423 => Opcode::VFNMSUB231PDZmb,
          10424 => Opcode::VFNMSUB231PDZmbk,
          10425 => Opcode::VFNMSUB231PDZmbkz,
          10426 => Opcode::VFNMSUB231PDZmk,
          10427 => Opcode::VFNMSUB231PDZmkz,
          10428 => Opcode::VFNMSUB231PDZr,
          10429 => Opcode::VFNMSUB231PDZrb,
          10430 => Opcode::VFNMSUB231PDZrbk,
          10431 => Opcode::VFNMSUB231PDZrbkz,
          10432 => Opcode::VFNMSUB231PDZrk,
          10433 => Opcode::VFNMSUB231PDZrkz,
          10434 => Opcode::VFNMSUB231PDm,
          10435 => Opcode::VFNMSUB231PDr,
          10436 => Opcode::VFNMSUB231PHZ128m,
          10437 => Opcode::VFNMSUB231PHZ128mb,
          10438 => Opcode::VFNMSUB231PHZ128mbk,
          10439 => Opcode::VFNMSUB231PHZ128mbkz,
          10440 => Opcode::VFNMSUB231PHZ128mk,
          10441 => Opcode::VFNMSUB231PHZ128mkz,
          10442 => Opcode::VFNMSUB231PHZ128r,
          10443 => Opcode::VFNMSUB231PHZ128rk,
          10444 => Opcode::VFNMSUB231PHZ128rkz,
          10445 => Opcode::VFNMSUB231PHZ256m,
          10446 => Opcode::VFNMSUB231PHZ256mb,
          10447 => Opcode::VFNMSUB231PHZ256mbk,
          10448 => Opcode::VFNMSUB231PHZ256mbkz,
          10449 => Opcode::VFNMSUB231PHZ256mk,
          10450 => Opcode::VFNMSUB231PHZ256mkz,
          10451 => Opcode::VFNMSUB231PHZ256r,
          10452 => Opcode::VFNMSUB231PHZ256rk,
          10453 => Opcode::VFNMSUB231PHZ256rkz,
          10454 => Opcode::VFNMSUB231PHZm,
          10455 => Opcode::VFNMSUB231PHZmb,
          10456 => Opcode::VFNMSUB231PHZmbk,
          10457 => Opcode::VFNMSUB231PHZmbkz,
          10458 => Opcode::VFNMSUB231PHZmk,
          10459 => Opcode::VFNMSUB231PHZmkz,
          10460 => Opcode::VFNMSUB231PHZr,
          10461 => Opcode::VFNMSUB231PHZrb,
          10462 => Opcode::VFNMSUB231PHZrbk,
          10463 => Opcode::VFNMSUB231PHZrbkz,
          10464 => Opcode::VFNMSUB231PHZrk,
          10465 => Opcode::VFNMSUB231PHZrkz,
          10466 => Opcode::VFNMSUB231PSYm,
          10467 => Opcode::VFNMSUB231PSYr,
          10468 => Opcode::VFNMSUB231PSZ128m,
          10469 => Opcode::VFNMSUB231PSZ128mb,
          10470 => Opcode::VFNMSUB231PSZ128mbk,
          10471 => Opcode::VFNMSUB231PSZ128mbkz,
          10472 => Opcode::VFNMSUB231PSZ128mk,
          10473 => Opcode::VFNMSUB231PSZ128mkz,
          10474 => Opcode::VFNMSUB231PSZ128r,
          10475 => Opcode::VFNMSUB231PSZ128rk,
          10476 => Opcode::VFNMSUB231PSZ128rkz,
          10477 => Opcode::VFNMSUB231PSZ256m,
          10478 => Opcode::VFNMSUB231PSZ256mb,
          10479 => Opcode::VFNMSUB231PSZ256mbk,
          10480 => Opcode::VFNMSUB231PSZ256mbkz,
          10481 => Opcode::VFNMSUB231PSZ256mk,
          10482 => Opcode::VFNMSUB231PSZ256mkz,
          10483 => Opcode::VFNMSUB231PSZ256r,
          10484 => Opcode::VFNMSUB231PSZ256rk,
          10485 => Opcode::VFNMSUB231PSZ256rkz,
          10486 => Opcode::VFNMSUB231PSZm,
          10487 => Opcode::VFNMSUB231PSZmb,
          10488 => Opcode::VFNMSUB231PSZmbk,
          10489 => Opcode::VFNMSUB231PSZmbkz,
          10490 => Opcode::VFNMSUB231PSZmk,
          10491 => Opcode::VFNMSUB231PSZmkz,
          10492 => Opcode::VFNMSUB231PSZr,
          10493 => Opcode::VFNMSUB231PSZrb,
          10494 => Opcode::VFNMSUB231PSZrbk,
          10495 => Opcode::VFNMSUB231PSZrbkz,
          10496 => Opcode::VFNMSUB231PSZrk,
          10497 => Opcode::VFNMSUB231PSZrkz,
          10498 => Opcode::VFNMSUB231PSm,
          10499 => Opcode::VFNMSUB231PSr,
          10500 => Opcode::VFNMSUB231SDZm,
          10501 => Opcode::VFNMSUB231SDZm_Int,
          10502 => Opcode::VFNMSUB231SDZm_Intk,
          10503 => Opcode::VFNMSUB231SDZm_Intkz,
          10504 => Opcode::VFNMSUB231SDZr,
          10505 => Opcode::VFNMSUB231SDZr_Int,
          10506 => Opcode::VFNMSUB231SDZr_Intk,
          10507 => Opcode::VFNMSUB231SDZr_Intkz,
          10508 => Opcode::VFNMSUB231SDZrb,
          10509 => Opcode::VFNMSUB231SDZrb_Int,
          10510 => Opcode::VFNMSUB231SDZrb_Intk,
          10511 => Opcode::VFNMSUB231SDZrb_Intkz,
          10512 => Opcode::VFNMSUB231SDm,
          10513 => Opcode::VFNMSUB231SDm_Int,
          10514 => Opcode::VFNMSUB231SDr,
          10515 => Opcode::VFNMSUB231SDr_Int,
          10516 => Opcode::VFNMSUB231SHZm,
          10517 => Opcode::VFNMSUB231SHZm_Int,
          10518 => Opcode::VFNMSUB231SHZm_Intk,
          10519 => Opcode::VFNMSUB231SHZm_Intkz,
          10520 => Opcode::VFNMSUB231SHZr,
          10521 => Opcode::VFNMSUB231SHZr_Int,
          10522 => Opcode::VFNMSUB231SHZr_Intk,
          10523 => Opcode::VFNMSUB231SHZr_Intkz,
          10524 => Opcode::VFNMSUB231SHZrb,
          10525 => Opcode::VFNMSUB231SHZrb_Int,
          10526 => Opcode::VFNMSUB231SHZrb_Intk,
          10527 => Opcode::VFNMSUB231SHZrb_Intkz,
          10528 => Opcode::VFNMSUB231SSZm,
          10529 => Opcode::VFNMSUB231SSZm_Int,
          10530 => Opcode::VFNMSUB231SSZm_Intk,
          10531 => Opcode::VFNMSUB231SSZm_Intkz,
          10532 => Opcode::VFNMSUB231SSZr,
          10533 => Opcode::VFNMSUB231SSZr_Int,
          10534 => Opcode::VFNMSUB231SSZr_Intk,
          10535 => Opcode::VFNMSUB231SSZr_Intkz,
          10536 => Opcode::VFNMSUB231SSZrb,
          10537 => Opcode::VFNMSUB231SSZrb_Int,
          10538 => Opcode::VFNMSUB231SSZrb_Intk,
          10539 => Opcode::VFNMSUB231SSZrb_Intkz,
          10540 => Opcode::VFNMSUB231SSm,
          10541 => Opcode::VFNMSUB231SSm_Int,
          10542 => Opcode::VFNMSUB231SSr,
          10543 => Opcode::VFNMSUB231SSr_Int,
          10544 => Opcode::VFNMSUBPD4Ymr,
          10545 => Opcode::VFNMSUBPD4Yrm,
          10546 => Opcode::VFNMSUBPD4Yrr,
          10547 => Opcode::VFNMSUBPD4Yrr_REV,
          10548 => Opcode::VFNMSUBPD4mr,
          10549 => Opcode::VFNMSUBPD4rm,
          10550 => Opcode::VFNMSUBPD4rr,
          10551 => Opcode::VFNMSUBPD4rr_REV,
          10552 => Opcode::VFNMSUBPS4Ymr,
          10553 => Opcode::VFNMSUBPS4Yrm,
          10554 => Opcode::VFNMSUBPS4Yrr,
          10555 => Opcode::VFNMSUBPS4Yrr_REV,
          10556 => Opcode::VFNMSUBPS4mr,
          10557 => Opcode::VFNMSUBPS4rm,
          10558 => Opcode::VFNMSUBPS4rr,
          10559 => Opcode::VFNMSUBPS4rr_REV,
          10560 => Opcode::VFNMSUBSD4mr,
          10561 => Opcode::VFNMSUBSD4mr_Int,
          10562 => Opcode::VFNMSUBSD4rm,
          10563 => Opcode::VFNMSUBSD4rm_Int,
          10564 => Opcode::VFNMSUBSD4rr,
          10565 => Opcode::VFNMSUBSD4rr_Int,
          10566 => Opcode::VFNMSUBSD4rr_Int_REV,
          10567 => Opcode::VFNMSUBSD4rr_REV,
          10568 => Opcode::VFNMSUBSS4mr,
          10569 => Opcode::VFNMSUBSS4mr_Int,
          10570 => Opcode::VFNMSUBSS4rm,
          10571 => Opcode::VFNMSUBSS4rm_Int,
          10572 => Opcode::VFNMSUBSS4rr,
          10573 => Opcode::VFNMSUBSS4rr_Int,
          10574 => Opcode::VFNMSUBSS4rr_Int_REV,
          10575 => Opcode::VFNMSUBSS4rr_REV,
          10576 => Opcode::VFPCLASSPDZ128rm,
          10577 => Opcode::VFPCLASSPDZ128rmb,
          10578 => Opcode::VFPCLASSPDZ128rmbk,
          10579 => Opcode::VFPCLASSPDZ128rmk,
          10580 => Opcode::VFPCLASSPDZ128rr,
          10581 => Opcode::VFPCLASSPDZ128rrk,
          10582 => Opcode::VFPCLASSPDZ256rm,
          10583 => Opcode::VFPCLASSPDZ256rmb,
          10584 => Opcode::VFPCLASSPDZ256rmbk,
          10585 => Opcode::VFPCLASSPDZ256rmk,
          10586 => Opcode::VFPCLASSPDZ256rr,
          10587 => Opcode::VFPCLASSPDZ256rrk,
          10588 => Opcode::VFPCLASSPDZrm,
          10589 => Opcode::VFPCLASSPDZrmb,
          10590 => Opcode::VFPCLASSPDZrmbk,
          10591 => Opcode::VFPCLASSPDZrmk,
          10592 => Opcode::VFPCLASSPDZrr,
          10593 => Opcode::VFPCLASSPDZrrk,
          10594 => Opcode::VFPCLASSPHZ128rm,
          10595 => Opcode::VFPCLASSPHZ128rmb,
          10596 => Opcode::VFPCLASSPHZ128rmbk,
          10597 => Opcode::VFPCLASSPHZ128rmk,
          10598 => Opcode::VFPCLASSPHZ128rr,
          10599 => Opcode::VFPCLASSPHZ128rrk,
          10600 => Opcode::VFPCLASSPHZ256rm,
          10601 => Opcode::VFPCLASSPHZ256rmb,
          10602 => Opcode::VFPCLASSPHZ256rmbk,
          10603 => Opcode::VFPCLASSPHZ256rmk,
          10604 => Opcode::VFPCLASSPHZ256rr,
          10605 => Opcode::VFPCLASSPHZ256rrk,
          10606 => Opcode::VFPCLASSPHZrm,
          10607 => Opcode::VFPCLASSPHZrmb,
          10608 => Opcode::VFPCLASSPHZrmbk,
          10609 => Opcode::VFPCLASSPHZrmk,
          10610 => Opcode::VFPCLASSPHZrr,
          10611 => Opcode::VFPCLASSPHZrrk,
          10612 => Opcode::VFPCLASSPSZ128rm,
          10613 => Opcode::VFPCLASSPSZ128rmb,
          10614 => Opcode::VFPCLASSPSZ128rmbk,
          10615 => Opcode::VFPCLASSPSZ128rmk,
          10616 => Opcode::VFPCLASSPSZ128rr,
          10617 => Opcode::VFPCLASSPSZ128rrk,
          10618 => Opcode::VFPCLASSPSZ256rm,
          10619 => Opcode::VFPCLASSPSZ256rmb,
          10620 => Opcode::VFPCLASSPSZ256rmbk,
          10621 => Opcode::VFPCLASSPSZ256rmk,
          10622 => Opcode::VFPCLASSPSZ256rr,
          10623 => Opcode::VFPCLASSPSZ256rrk,
          10624 => Opcode::VFPCLASSPSZrm,
          10625 => Opcode::VFPCLASSPSZrmb,
          10626 => Opcode::VFPCLASSPSZrmbk,
          10627 => Opcode::VFPCLASSPSZrmk,
          10628 => Opcode::VFPCLASSPSZrr,
          10629 => Opcode::VFPCLASSPSZrrk,
          10630 => Opcode::VFPCLASSSDZrm,
          10631 => Opcode::VFPCLASSSDZrmk,
          10632 => Opcode::VFPCLASSSDZrr,
          10633 => Opcode::VFPCLASSSDZrrk,
          10634 => Opcode::VFPCLASSSHZrm,
          10635 => Opcode::VFPCLASSSHZrmk,
          10636 => Opcode::VFPCLASSSHZrr,
          10637 => Opcode::VFPCLASSSHZrrk,
          10638 => Opcode::VFPCLASSSSZrm,
          10639 => Opcode::VFPCLASSSSZrmk,
          10640 => Opcode::VFPCLASSSSZrr,
          10641 => Opcode::VFPCLASSSSZrrk,
          10642 => Opcode::VFRCZPDYrm,
          10643 => Opcode::VFRCZPDYrr,
          10644 => Opcode::VFRCZPDrm,
          10645 => Opcode::VFRCZPDrr,
          10646 => Opcode::VFRCZPSYrm,
          10647 => Opcode::VFRCZPSYrr,
          10648 => Opcode::VFRCZPSrm,
          10649 => Opcode::VFRCZPSrr,
          10650 => Opcode::VFRCZSDrm,
          10651 => Opcode::VFRCZSDrr,
          10652 => Opcode::VFRCZSSrm,
          10653 => Opcode::VFRCZSSrr,
          10654 => Opcode::VGATHERDPDYrm,
          10655 => Opcode::VGATHERDPDZ128rm,
          10656 => Opcode::VGATHERDPDZ256rm,
          10657 => Opcode::VGATHERDPDZrm,
          10658 => Opcode::VGATHERDPDrm,
          10659 => Opcode::VGATHERDPSYrm,
          10660 => Opcode::VGATHERDPSZ128rm,
          10661 => Opcode::VGATHERDPSZ256rm,
          10662 => Opcode::VGATHERDPSZrm,
          10663 => Opcode::VGATHERDPSrm,
          10664 => Opcode::VGATHERPF0DPDm,
          10665 => Opcode::VGATHERPF0DPSm,
          10666 => Opcode::VGATHERPF0QPDm,
          10667 => Opcode::VGATHERPF0QPSm,
          10668 => Opcode::VGATHERPF1DPDm,
          10669 => Opcode::VGATHERPF1DPSm,
          10670 => Opcode::VGATHERPF1QPDm,
          10671 => Opcode::VGATHERPF1QPSm,
          10672 => Opcode::VGATHERQPDYrm,
          10673 => Opcode::VGATHERQPDZ128rm,
          10674 => Opcode::VGATHERQPDZ256rm,
          10675 => Opcode::VGATHERQPDZrm,
          10676 => Opcode::VGATHERQPDrm,
          10677 => Opcode::VGATHERQPSYrm,
          10678 => Opcode::VGATHERQPSZ128rm,
          10679 => Opcode::VGATHERQPSZ256rm,
          10680 => Opcode::VGATHERQPSZrm,
          10681 => Opcode::VGATHERQPSrm,
          10682 => Opcode::VGETEXPPDZ128m,
          10683 => Opcode::VGETEXPPDZ128mb,
          10684 => Opcode::VGETEXPPDZ128mbk,
          10685 => Opcode::VGETEXPPDZ128mbkz,
          10686 => Opcode::VGETEXPPDZ128mk,
          10687 => Opcode::VGETEXPPDZ128mkz,
          10688 => Opcode::VGETEXPPDZ128r,
          10689 => Opcode::VGETEXPPDZ128rk,
          10690 => Opcode::VGETEXPPDZ128rkz,
          10691 => Opcode::VGETEXPPDZ256m,
          10692 => Opcode::VGETEXPPDZ256mb,
          10693 => Opcode::VGETEXPPDZ256mbk,
          10694 => Opcode::VGETEXPPDZ256mbkz,
          10695 => Opcode::VGETEXPPDZ256mk,
          10696 => Opcode::VGETEXPPDZ256mkz,
          10697 => Opcode::VGETEXPPDZ256r,
          10698 => Opcode::VGETEXPPDZ256rk,
          10699 => Opcode::VGETEXPPDZ256rkz,
          10700 => Opcode::VGETEXPPDZm,
          10701 => Opcode::VGETEXPPDZmb,
          10702 => Opcode::VGETEXPPDZmbk,
          10703 => Opcode::VGETEXPPDZmbkz,
          10704 => Opcode::VGETEXPPDZmk,
          10705 => Opcode::VGETEXPPDZmkz,
          10706 => Opcode::VGETEXPPDZr,
          10707 => Opcode::VGETEXPPDZrb,
          10708 => Opcode::VGETEXPPDZrbk,
          10709 => Opcode::VGETEXPPDZrbkz,
          10710 => Opcode::VGETEXPPDZrk,
          10711 => Opcode::VGETEXPPDZrkz,
          10712 => Opcode::VGETEXPPHZ128m,
          10713 => Opcode::VGETEXPPHZ128mb,
          10714 => Opcode::VGETEXPPHZ128mbk,
          10715 => Opcode::VGETEXPPHZ128mbkz,
          10716 => Opcode::VGETEXPPHZ128mk,
          10717 => Opcode::VGETEXPPHZ128mkz,
          10718 => Opcode::VGETEXPPHZ128r,
          10719 => Opcode::VGETEXPPHZ128rk,
          10720 => Opcode::VGETEXPPHZ128rkz,
          10721 => Opcode::VGETEXPPHZ256m,
          10722 => Opcode::VGETEXPPHZ256mb,
          10723 => Opcode::VGETEXPPHZ256mbk,
          10724 => Opcode::VGETEXPPHZ256mbkz,
          10725 => Opcode::VGETEXPPHZ256mk,
          10726 => Opcode::VGETEXPPHZ256mkz,
          10727 => Opcode::VGETEXPPHZ256r,
          10728 => Opcode::VGETEXPPHZ256rk,
          10729 => Opcode::VGETEXPPHZ256rkz,
          10730 => Opcode::VGETEXPPHZm,
          10731 => Opcode::VGETEXPPHZmb,
          10732 => Opcode::VGETEXPPHZmbk,
          10733 => Opcode::VGETEXPPHZmbkz,
          10734 => Opcode::VGETEXPPHZmk,
          10735 => Opcode::VGETEXPPHZmkz,
          10736 => Opcode::VGETEXPPHZr,
          10737 => Opcode::VGETEXPPHZrb,
          10738 => Opcode::VGETEXPPHZrbk,
          10739 => Opcode::VGETEXPPHZrbkz,
          10740 => Opcode::VGETEXPPHZrk,
          10741 => Opcode::VGETEXPPHZrkz,
          10742 => Opcode::VGETEXPPSZ128m,
          10743 => Opcode::VGETEXPPSZ128mb,
          10744 => Opcode::VGETEXPPSZ128mbk,
          10745 => Opcode::VGETEXPPSZ128mbkz,
          10746 => Opcode::VGETEXPPSZ128mk,
          10747 => Opcode::VGETEXPPSZ128mkz,
          10748 => Opcode::VGETEXPPSZ128r,
          10749 => Opcode::VGETEXPPSZ128rk,
          10750 => Opcode::VGETEXPPSZ128rkz,
          10751 => Opcode::VGETEXPPSZ256m,
          10752 => Opcode::VGETEXPPSZ256mb,
          10753 => Opcode::VGETEXPPSZ256mbk,
          10754 => Opcode::VGETEXPPSZ256mbkz,
          10755 => Opcode::VGETEXPPSZ256mk,
          10756 => Opcode::VGETEXPPSZ256mkz,
          10757 => Opcode::VGETEXPPSZ256r,
          10758 => Opcode::VGETEXPPSZ256rk,
          10759 => Opcode::VGETEXPPSZ256rkz,
          10760 => Opcode::VGETEXPPSZm,
          10761 => Opcode::VGETEXPPSZmb,
          10762 => Opcode::VGETEXPPSZmbk,
          10763 => Opcode::VGETEXPPSZmbkz,
          10764 => Opcode::VGETEXPPSZmk,
          10765 => Opcode::VGETEXPPSZmkz,
          10766 => Opcode::VGETEXPPSZr,
          10767 => Opcode::VGETEXPPSZrb,
          10768 => Opcode::VGETEXPPSZrbk,
          10769 => Opcode::VGETEXPPSZrbkz,
          10770 => Opcode::VGETEXPPSZrk,
          10771 => Opcode::VGETEXPPSZrkz,
          10772 => Opcode::VGETEXPSDZm,
          10773 => Opcode::VGETEXPSDZmk,
          10774 => Opcode::VGETEXPSDZmkz,
          10775 => Opcode::VGETEXPSDZr,
          10776 => Opcode::VGETEXPSDZrb,
          10777 => Opcode::VGETEXPSDZrbk,
          10778 => Opcode::VGETEXPSDZrbkz,
          10779 => Opcode::VGETEXPSDZrk,
          10780 => Opcode::VGETEXPSDZrkz,
          10781 => Opcode::VGETEXPSHZm,
          10782 => Opcode::VGETEXPSHZmk,
          10783 => Opcode::VGETEXPSHZmkz,
          10784 => Opcode::VGETEXPSHZr,
          10785 => Opcode::VGETEXPSHZrb,
          10786 => Opcode::VGETEXPSHZrbk,
          10787 => Opcode::VGETEXPSHZrbkz,
          10788 => Opcode::VGETEXPSHZrk,
          10789 => Opcode::VGETEXPSHZrkz,
          10790 => Opcode::VGETEXPSSZm,
          10791 => Opcode::VGETEXPSSZmk,
          10792 => Opcode::VGETEXPSSZmkz,
          10793 => Opcode::VGETEXPSSZr,
          10794 => Opcode::VGETEXPSSZrb,
          10795 => Opcode::VGETEXPSSZrbk,
          10796 => Opcode::VGETEXPSSZrbkz,
          10797 => Opcode::VGETEXPSSZrk,
          10798 => Opcode::VGETEXPSSZrkz,
          10799 => Opcode::VGETMANTPDZ128rmbi,
          10800 => Opcode::VGETMANTPDZ128rmbik,
          10801 => Opcode::VGETMANTPDZ128rmbikz,
          10802 => Opcode::VGETMANTPDZ128rmi,
          10803 => Opcode::VGETMANTPDZ128rmik,
          10804 => Opcode::VGETMANTPDZ128rmikz,
          10805 => Opcode::VGETMANTPDZ128rri,
          10806 => Opcode::VGETMANTPDZ128rrik,
          10807 => Opcode::VGETMANTPDZ128rrikz,
          10808 => Opcode::VGETMANTPDZ256rmbi,
          10809 => Opcode::VGETMANTPDZ256rmbik,
          10810 => Opcode::VGETMANTPDZ256rmbikz,
          10811 => Opcode::VGETMANTPDZ256rmi,
          10812 => Opcode::VGETMANTPDZ256rmik,
          10813 => Opcode::VGETMANTPDZ256rmikz,
          10814 => Opcode::VGETMANTPDZ256rri,
          10815 => Opcode::VGETMANTPDZ256rrik,
          10816 => Opcode::VGETMANTPDZ256rrikz,
          10817 => Opcode::VGETMANTPDZrmbi,
          10818 => Opcode::VGETMANTPDZrmbik,
          10819 => Opcode::VGETMANTPDZrmbikz,
          10820 => Opcode::VGETMANTPDZrmi,
          10821 => Opcode::VGETMANTPDZrmik,
          10822 => Opcode::VGETMANTPDZrmikz,
          10823 => Opcode::VGETMANTPDZrri,
          10824 => Opcode::VGETMANTPDZrrib,
          10825 => Opcode::VGETMANTPDZrribk,
          10826 => Opcode::VGETMANTPDZrribkz,
          10827 => Opcode::VGETMANTPDZrrik,
          10828 => Opcode::VGETMANTPDZrrikz,
          10829 => Opcode::VGETMANTPHZ128rmbi,
          10830 => Opcode::VGETMANTPHZ128rmbik,
          10831 => Opcode::VGETMANTPHZ128rmbikz,
          10832 => Opcode::VGETMANTPHZ128rmi,
          10833 => Opcode::VGETMANTPHZ128rmik,
          10834 => Opcode::VGETMANTPHZ128rmikz,
          10835 => Opcode::VGETMANTPHZ128rri,
          10836 => Opcode::VGETMANTPHZ128rrik,
          10837 => Opcode::VGETMANTPHZ128rrikz,
          10838 => Opcode::VGETMANTPHZ256rmbi,
          10839 => Opcode::VGETMANTPHZ256rmbik,
          10840 => Opcode::VGETMANTPHZ256rmbikz,
          10841 => Opcode::VGETMANTPHZ256rmi,
          10842 => Opcode::VGETMANTPHZ256rmik,
          10843 => Opcode::VGETMANTPHZ256rmikz,
          10844 => Opcode::VGETMANTPHZ256rri,
          10845 => Opcode::VGETMANTPHZ256rrik,
          10846 => Opcode::VGETMANTPHZ256rrikz,
          10847 => Opcode::VGETMANTPHZrmbi,
          10848 => Opcode::VGETMANTPHZrmbik,
          10849 => Opcode::VGETMANTPHZrmbikz,
          10850 => Opcode::VGETMANTPHZrmi,
          10851 => Opcode::VGETMANTPHZrmik,
          10852 => Opcode::VGETMANTPHZrmikz,
          10853 => Opcode::VGETMANTPHZrri,
          10854 => Opcode::VGETMANTPHZrrib,
          10855 => Opcode::VGETMANTPHZrribk,
          10856 => Opcode::VGETMANTPHZrribkz,
          10857 => Opcode::VGETMANTPHZrrik,
          10858 => Opcode::VGETMANTPHZrrikz,
          10859 => Opcode::VGETMANTPSZ128rmbi,
          10860 => Opcode::VGETMANTPSZ128rmbik,
          10861 => Opcode::VGETMANTPSZ128rmbikz,
          10862 => Opcode::VGETMANTPSZ128rmi,
          10863 => Opcode::VGETMANTPSZ128rmik,
          10864 => Opcode::VGETMANTPSZ128rmikz,
          10865 => Opcode::VGETMANTPSZ128rri,
          10866 => Opcode::VGETMANTPSZ128rrik,
          10867 => Opcode::VGETMANTPSZ128rrikz,
          10868 => Opcode::VGETMANTPSZ256rmbi,
          10869 => Opcode::VGETMANTPSZ256rmbik,
          10870 => Opcode::VGETMANTPSZ256rmbikz,
          10871 => Opcode::VGETMANTPSZ256rmi,
          10872 => Opcode::VGETMANTPSZ256rmik,
          10873 => Opcode::VGETMANTPSZ256rmikz,
          10874 => Opcode::VGETMANTPSZ256rri,
          10875 => Opcode::VGETMANTPSZ256rrik,
          10876 => Opcode::VGETMANTPSZ256rrikz,
          10877 => Opcode::VGETMANTPSZrmbi,
          10878 => Opcode::VGETMANTPSZrmbik,
          10879 => Opcode::VGETMANTPSZrmbikz,
          10880 => Opcode::VGETMANTPSZrmi,
          10881 => Opcode::VGETMANTPSZrmik,
          10882 => Opcode::VGETMANTPSZrmikz,
          10883 => Opcode::VGETMANTPSZrri,
          10884 => Opcode::VGETMANTPSZrrib,
          10885 => Opcode::VGETMANTPSZrribk,
          10886 => Opcode::VGETMANTPSZrribkz,
          10887 => Opcode::VGETMANTPSZrrik,
          10888 => Opcode::VGETMANTPSZrrikz,
          10889 => Opcode::VGETMANTSDZrmi,
          10890 => Opcode::VGETMANTSDZrmik,
          10891 => Opcode::VGETMANTSDZrmikz,
          10892 => Opcode::VGETMANTSDZrri,
          10893 => Opcode::VGETMANTSDZrrib,
          10894 => Opcode::VGETMANTSDZrribk,
          10895 => Opcode::VGETMANTSDZrribkz,
          10896 => Opcode::VGETMANTSDZrrik,
          10897 => Opcode::VGETMANTSDZrrikz,
          10898 => Opcode::VGETMANTSHZrmi,
          10899 => Opcode::VGETMANTSHZrmik,
          10900 => Opcode::VGETMANTSHZrmikz,
          10901 => Opcode::VGETMANTSHZrri,
          10902 => Opcode::VGETMANTSHZrrib,
          10903 => Opcode::VGETMANTSHZrribk,
          10904 => Opcode::VGETMANTSHZrribkz,
          10905 => Opcode::VGETMANTSHZrrik,
          10906 => Opcode::VGETMANTSHZrrikz,
          10907 => Opcode::VGETMANTSSZrmi,
          10908 => Opcode::VGETMANTSSZrmik,
          10909 => Opcode::VGETMANTSSZrmikz,
          10910 => Opcode::VGETMANTSSZrri,
          10911 => Opcode::VGETMANTSSZrrib,
          10912 => Opcode::VGETMANTSSZrribk,
          10913 => Opcode::VGETMANTSSZrribkz,
          10914 => Opcode::VGETMANTSSZrrik,
          10915 => Opcode::VGETMANTSSZrrikz,
          10916 => Opcode::VGF2P8AFFINEINVQBYrmi,
          10917 => Opcode::VGF2P8AFFINEINVQBYrri,
          10918 => Opcode::VGF2P8AFFINEINVQBZ128rmbi,
          10919 => Opcode::VGF2P8AFFINEINVQBZ128rmbik,
          10920 => Opcode::VGF2P8AFFINEINVQBZ128rmbikz,
          10921 => Opcode::VGF2P8AFFINEINVQBZ128rmi,
          10922 => Opcode::VGF2P8AFFINEINVQBZ128rmik,
          10923 => Opcode::VGF2P8AFFINEINVQBZ128rmikz,
          10924 => Opcode::VGF2P8AFFINEINVQBZ128rri,
          10925 => Opcode::VGF2P8AFFINEINVQBZ128rrik,
          10926 => Opcode::VGF2P8AFFINEINVQBZ128rrikz,
          10927 => Opcode::VGF2P8AFFINEINVQBZ256rmbi,
          10928 => Opcode::VGF2P8AFFINEINVQBZ256rmbik,
          10929 => Opcode::VGF2P8AFFINEINVQBZ256rmbikz,
          10930 => Opcode::VGF2P8AFFINEINVQBZ256rmi,
          10931 => Opcode::VGF2P8AFFINEINVQBZ256rmik,
          10932 => Opcode::VGF2P8AFFINEINVQBZ256rmikz,
          10933 => Opcode::VGF2P8AFFINEINVQBZ256rri,
          10934 => Opcode::VGF2P8AFFINEINVQBZ256rrik,
          10935 => Opcode::VGF2P8AFFINEINVQBZ256rrikz,
          10936 => Opcode::VGF2P8AFFINEINVQBZrmbi,
          10937 => Opcode::VGF2P8AFFINEINVQBZrmbik,
          10938 => Opcode::VGF2P8AFFINEINVQBZrmbikz,
          10939 => Opcode::VGF2P8AFFINEINVQBZrmi,
          10940 => Opcode::VGF2P8AFFINEINVQBZrmik,
          10941 => Opcode::VGF2P8AFFINEINVQBZrmikz,
          10942 => Opcode::VGF2P8AFFINEINVQBZrri,
          10943 => Opcode::VGF2P8AFFINEINVQBZrrik,
          10944 => Opcode::VGF2P8AFFINEINVQBZrrikz,
          10945 => Opcode::VGF2P8AFFINEINVQBrmi,
          10946 => Opcode::VGF2P8AFFINEINVQBrri,
          10947 => Opcode::VGF2P8AFFINEQBYrmi,
          10948 => Opcode::VGF2P8AFFINEQBYrri,
          10949 => Opcode::VGF2P8AFFINEQBZ128rmbi,
          10950 => Opcode::VGF2P8AFFINEQBZ128rmbik,
          10951 => Opcode::VGF2P8AFFINEQBZ128rmbikz,
          10952 => Opcode::VGF2P8AFFINEQBZ128rmi,
          10953 => Opcode::VGF2P8AFFINEQBZ128rmik,
          10954 => Opcode::VGF2P8AFFINEQBZ128rmikz,
          10955 => Opcode::VGF2P8AFFINEQBZ128rri,
          10956 => Opcode::VGF2P8AFFINEQBZ128rrik,
          10957 => Opcode::VGF2P8AFFINEQBZ128rrikz,
          10958 => Opcode::VGF2P8AFFINEQBZ256rmbi,
          10959 => Opcode::VGF2P8AFFINEQBZ256rmbik,
          10960 => Opcode::VGF2P8AFFINEQBZ256rmbikz,
          10961 => Opcode::VGF2P8AFFINEQBZ256rmi,
          10962 => Opcode::VGF2P8AFFINEQBZ256rmik,
          10963 => Opcode::VGF2P8AFFINEQBZ256rmikz,
          10964 => Opcode::VGF2P8AFFINEQBZ256rri,
          10965 => Opcode::VGF2P8AFFINEQBZ256rrik,
          10966 => Opcode::VGF2P8AFFINEQBZ256rrikz,
          10967 => Opcode::VGF2P8AFFINEQBZrmbi,
          10968 => Opcode::VGF2P8AFFINEQBZrmbik,
          10969 => Opcode::VGF2P8AFFINEQBZrmbikz,
          10970 => Opcode::VGF2P8AFFINEQBZrmi,
          10971 => Opcode::VGF2P8AFFINEQBZrmik,
          10972 => Opcode::VGF2P8AFFINEQBZrmikz,
          10973 => Opcode::VGF2P8AFFINEQBZrri,
          10974 => Opcode::VGF2P8AFFINEQBZrrik,
          10975 => Opcode::VGF2P8AFFINEQBZrrikz,
          10976 => Opcode::VGF2P8AFFINEQBrmi,
          10977 => Opcode::VGF2P8AFFINEQBrri,
          10978 => Opcode::VGF2P8MULBYrm,
          10979 => Opcode::VGF2P8MULBYrr,
          10980 => Opcode::VGF2P8MULBZ128rm,
          10981 => Opcode::VGF2P8MULBZ128rmk,
          10982 => Opcode::VGF2P8MULBZ128rmkz,
          10983 => Opcode::VGF2P8MULBZ128rr,
          10984 => Opcode::VGF2P8MULBZ128rrk,
          10985 => Opcode::VGF2P8MULBZ128rrkz,
          10986 => Opcode::VGF2P8MULBZ256rm,
          10987 => Opcode::VGF2P8MULBZ256rmk,
          10988 => Opcode::VGF2P8MULBZ256rmkz,
          10989 => Opcode::VGF2P8MULBZ256rr,
          10990 => Opcode::VGF2P8MULBZ256rrk,
          10991 => Opcode::VGF2P8MULBZ256rrkz,
          10992 => Opcode::VGF2P8MULBZrm,
          10993 => Opcode::VGF2P8MULBZrmk,
          10994 => Opcode::VGF2P8MULBZrmkz,
          10995 => Opcode::VGF2P8MULBZrr,
          10996 => Opcode::VGF2P8MULBZrrk,
          10997 => Opcode::VGF2P8MULBZrrkz,
          10998 => Opcode::VGF2P8MULBrm,
          10999 => Opcode::VGF2P8MULBrr,
          11000 => Opcode::VHADDPDYrm,
          11001 => Opcode::VHADDPDYrr,
          11002 => Opcode::VHADDPDrm,
          11003 => Opcode::VHADDPDrr,
          11004 => Opcode::VHADDPSYrm,
          11005 => Opcode::VHADDPSYrr,
          11006 => Opcode::VHADDPSrm,
          11007 => Opcode::VHADDPSrr,
          11008 => Opcode::VHSUBPDYrm,
          11009 => Opcode::VHSUBPDYrr,
          11010 => Opcode::VHSUBPDrm,
          11011 => Opcode::VHSUBPDrr,
          11012 => Opcode::VHSUBPSYrm,
          11013 => Opcode::VHSUBPSYrr,
          11014 => Opcode::VHSUBPSrm,
          11015 => Opcode::VHSUBPSrr,
          11016 => Opcode::VINSERTF128rm,
          11017 => Opcode::VINSERTF128rr,
          11018 => Opcode::VINSERTF32x4Z256rm,
          11019 => Opcode::VINSERTF32x4Z256rmk,
          11020 => Opcode::VINSERTF32x4Z256rmkz,
          11021 => Opcode::VINSERTF32x4Z256rr,
          11022 => Opcode::VINSERTF32x4Z256rrk,
          11023 => Opcode::VINSERTF32x4Z256rrkz,
          11024 => Opcode::VINSERTF32x4Zrm,
          11025 => Opcode::VINSERTF32x4Zrmk,
          11026 => Opcode::VINSERTF32x4Zrmkz,
          11027 => Opcode::VINSERTF32x4Zrr,
          11028 => Opcode::VINSERTF32x4Zrrk,
          11029 => Opcode::VINSERTF32x4Zrrkz,
          11030 => Opcode::VINSERTF32x8Zrm,
          11031 => Opcode::VINSERTF32x8Zrmk,
          11032 => Opcode::VINSERTF32x8Zrmkz,
          11033 => Opcode::VINSERTF32x8Zrr,
          11034 => Opcode::VINSERTF32x8Zrrk,
          11035 => Opcode::VINSERTF32x8Zrrkz,
          11036 => Opcode::VINSERTF64x2Z256rm,
          11037 => Opcode::VINSERTF64x2Z256rmk,
          11038 => Opcode::VINSERTF64x2Z256rmkz,
          11039 => Opcode::VINSERTF64x2Z256rr,
          11040 => Opcode::VINSERTF64x2Z256rrk,
          11041 => Opcode::VINSERTF64x2Z256rrkz,
          11042 => Opcode::VINSERTF64x2Zrm,
          11043 => Opcode::VINSERTF64x2Zrmk,
          11044 => Opcode::VINSERTF64x2Zrmkz,
          11045 => Opcode::VINSERTF64x2Zrr,
          11046 => Opcode::VINSERTF64x2Zrrk,
          11047 => Opcode::VINSERTF64x2Zrrkz,
          11048 => Opcode::VINSERTF64x4Zrm,
          11049 => Opcode::VINSERTF64x4Zrmk,
          11050 => Opcode::VINSERTF64x4Zrmkz,
          11051 => Opcode::VINSERTF64x4Zrr,
          11052 => Opcode::VINSERTF64x4Zrrk,
          11053 => Opcode::VINSERTF64x4Zrrkz,
          11054 => Opcode::VINSERTI128rm,
          11055 => Opcode::VINSERTI128rr,
          11056 => Opcode::VINSERTI32x4Z256rm,
          11057 => Opcode::VINSERTI32x4Z256rmk,
          11058 => Opcode::VINSERTI32x4Z256rmkz,
          11059 => Opcode::VINSERTI32x4Z256rr,
          11060 => Opcode::VINSERTI32x4Z256rrk,
          11061 => Opcode::VINSERTI32x4Z256rrkz,
          11062 => Opcode::VINSERTI32x4Zrm,
          11063 => Opcode::VINSERTI32x4Zrmk,
          11064 => Opcode::VINSERTI32x4Zrmkz,
          11065 => Opcode::VINSERTI32x4Zrr,
          11066 => Opcode::VINSERTI32x4Zrrk,
          11067 => Opcode::VINSERTI32x4Zrrkz,
          11068 => Opcode::VINSERTI32x8Zrm,
          11069 => Opcode::VINSERTI32x8Zrmk,
          11070 => Opcode::VINSERTI32x8Zrmkz,
          11071 => Opcode::VINSERTI32x8Zrr,
          11072 => Opcode::VINSERTI32x8Zrrk,
          11073 => Opcode::VINSERTI32x8Zrrkz,
          11074 => Opcode::VINSERTI64x2Z256rm,
          11075 => Opcode::VINSERTI64x2Z256rmk,
          11076 => Opcode::VINSERTI64x2Z256rmkz,
          11077 => Opcode::VINSERTI64x2Z256rr,
          11078 => Opcode::VINSERTI64x2Z256rrk,
          11079 => Opcode::VINSERTI64x2Z256rrkz,
          11080 => Opcode::VINSERTI64x2Zrm,
          11081 => Opcode::VINSERTI64x2Zrmk,
          11082 => Opcode::VINSERTI64x2Zrmkz,
          11083 => Opcode::VINSERTI64x2Zrr,
          11084 => Opcode::VINSERTI64x2Zrrk,
          11085 => Opcode::VINSERTI64x2Zrrkz,
          11086 => Opcode::VINSERTI64x4Zrm,
          11087 => Opcode::VINSERTI64x4Zrmk,
          11088 => Opcode::VINSERTI64x4Zrmkz,
          11089 => Opcode::VINSERTI64x4Zrr,
          11090 => Opcode::VINSERTI64x4Zrrk,
          11091 => Opcode::VINSERTI64x4Zrrkz,
          11092 => Opcode::VINSERTPSZrm,
          11093 => Opcode::VINSERTPSZrr,
          11094 => Opcode::VINSERTPSrm,
          11095 => Opcode::VINSERTPSrr,
          11096 => Opcode::VLDDQUYrm,
          11097 => Opcode::VLDDQUrm,
          11098 => Opcode::VLDMXCSR,
          11099 => Opcode::VMASKMOVDQU,
          11100 => Opcode::VMASKMOVDQU64,
          11101 => Opcode::VMASKMOVPDYmr,
          11102 => Opcode::VMASKMOVPDYrm,
          11103 => Opcode::VMASKMOVPDmr,
          11104 => Opcode::VMASKMOVPDrm,
          11105 => Opcode::VMASKMOVPSYmr,
          11106 => Opcode::VMASKMOVPSYrm,
          11107 => Opcode::VMASKMOVPSmr,
          11108 => Opcode::VMASKMOVPSrm,
          11109 => Opcode::VMAXCPDYrm,
          11110 => Opcode::VMAXCPDYrr,
          11111 => Opcode::VMAXCPDZ128rm,
          11112 => Opcode::VMAXCPDZ128rmb,
          11113 => Opcode::VMAXCPDZ128rmbk,
          11114 => Opcode::VMAXCPDZ128rmbkz,
          11115 => Opcode::VMAXCPDZ128rmk,
          11116 => Opcode::VMAXCPDZ128rmkz,
          11117 => Opcode::VMAXCPDZ128rr,
          11118 => Opcode::VMAXCPDZ128rrk,
          11119 => Opcode::VMAXCPDZ128rrkz,
          11120 => Opcode::VMAXCPDZ256rm,
          11121 => Opcode::VMAXCPDZ256rmb,
          11122 => Opcode::VMAXCPDZ256rmbk,
          11123 => Opcode::VMAXCPDZ256rmbkz,
          11124 => Opcode::VMAXCPDZ256rmk,
          11125 => Opcode::VMAXCPDZ256rmkz,
          11126 => Opcode::VMAXCPDZ256rr,
          11127 => Opcode::VMAXCPDZ256rrk,
          11128 => Opcode::VMAXCPDZ256rrkz,
          11129 => Opcode::VMAXCPDZrm,
          11130 => Opcode::VMAXCPDZrmb,
          11131 => Opcode::VMAXCPDZrmbk,
          11132 => Opcode::VMAXCPDZrmbkz,
          11133 => Opcode::VMAXCPDZrmk,
          11134 => Opcode::VMAXCPDZrmkz,
          11135 => Opcode::VMAXCPDZrr,
          11136 => Opcode::VMAXCPDZrrk,
          11137 => Opcode::VMAXCPDZrrkz,
          11138 => Opcode::VMAXCPDrm,
          11139 => Opcode::VMAXCPDrr,
          11140 => Opcode::VMAXCPHZ128rm,
          11141 => Opcode::VMAXCPHZ128rmb,
          11142 => Opcode::VMAXCPHZ128rmbk,
          11143 => Opcode::VMAXCPHZ128rmbkz,
          11144 => Opcode::VMAXCPHZ128rmk,
          11145 => Opcode::VMAXCPHZ128rmkz,
          11146 => Opcode::VMAXCPHZ128rr,
          11147 => Opcode::VMAXCPHZ128rrk,
          11148 => Opcode::VMAXCPHZ128rrkz,
          11149 => Opcode::VMAXCPHZ256rm,
          11150 => Opcode::VMAXCPHZ256rmb,
          11151 => Opcode::VMAXCPHZ256rmbk,
          11152 => Opcode::VMAXCPHZ256rmbkz,
          11153 => Opcode::VMAXCPHZ256rmk,
          11154 => Opcode::VMAXCPHZ256rmkz,
          11155 => Opcode::VMAXCPHZ256rr,
          11156 => Opcode::VMAXCPHZ256rrk,
          11157 => Opcode::VMAXCPHZ256rrkz,
          11158 => Opcode::VMAXCPHZrm,
          11159 => Opcode::VMAXCPHZrmb,
          11160 => Opcode::VMAXCPHZrmbk,
          11161 => Opcode::VMAXCPHZrmbkz,
          11162 => Opcode::VMAXCPHZrmk,
          11163 => Opcode::VMAXCPHZrmkz,
          11164 => Opcode::VMAXCPHZrr,
          11165 => Opcode::VMAXCPHZrrk,
          11166 => Opcode::VMAXCPHZrrkz,
          11167 => Opcode::VMAXCPSYrm,
          11168 => Opcode::VMAXCPSYrr,
          11169 => Opcode::VMAXCPSZ128rm,
          11170 => Opcode::VMAXCPSZ128rmb,
          11171 => Opcode::VMAXCPSZ128rmbk,
          11172 => Opcode::VMAXCPSZ128rmbkz,
          11173 => Opcode::VMAXCPSZ128rmk,
          11174 => Opcode::VMAXCPSZ128rmkz,
          11175 => Opcode::VMAXCPSZ128rr,
          11176 => Opcode::VMAXCPSZ128rrk,
          11177 => Opcode::VMAXCPSZ128rrkz,
          11178 => Opcode::VMAXCPSZ256rm,
          11179 => Opcode::VMAXCPSZ256rmb,
          11180 => Opcode::VMAXCPSZ256rmbk,
          11181 => Opcode::VMAXCPSZ256rmbkz,
          11182 => Opcode::VMAXCPSZ256rmk,
          11183 => Opcode::VMAXCPSZ256rmkz,
          11184 => Opcode::VMAXCPSZ256rr,
          11185 => Opcode::VMAXCPSZ256rrk,
          11186 => Opcode::VMAXCPSZ256rrkz,
          11187 => Opcode::VMAXCPSZrm,
          11188 => Opcode::VMAXCPSZrmb,
          11189 => Opcode::VMAXCPSZrmbk,
          11190 => Opcode::VMAXCPSZrmbkz,
          11191 => Opcode::VMAXCPSZrmk,
          11192 => Opcode::VMAXCPSZrmkz,
          11193 => Opcode::VMAXCPSZrr,
          11194 => Opcode::VMAXCPSZrrk,
          11195 => Opcode::VMAXCPSZrrkz,
          11196 => Opcode::VMAXCPSrm,
          11197 => Opcode::VMAXCPSrr,
          11198 => Opcode::VMAXCSDZrm,
          11199 => Opcode::VMAXCSDZrr,
          11200 => Opcode::VMAXCSDrm,
          11201 => Opcode::VMAXCSDrr,
          11202 => Opcode::VMAXCSHZrm,
          11203 => Opcode::VMAXCSHZrr,
          11204 => Opcode::VMAXCSSZrm,
          11205 => Opcode::VMAXCSSZrr,
          11206 => Opcode::VMAXCSSrm,
          11207 => Opcode::VMAXCSSrr,
          11208 => Opcode::VMAXPDYrm,
          11209 => Opcode::VMAXPDYrr,
          11210 => Opcode::VMAXPDZ128rm,
          11211 => Opcode::VMAXPDZ128rmb,
          11212 => Opcode::VMAXPDZ128rmbk,
          11213 => Opcode::VMAXPDZ128rmbkz,
          11214 => Opcode::VMAXPDZ128rmk,
          11215 => Opcode::VMAXPDZ128rmkz,
          11216 => Opcode::VMAXPDZ128rr,
          11217 => Opcode::VMAXPDZ128rrk,
          11218 => Opcode::VMAXPDZ128rrkz,
          11219 => Opcode::VMAXPDZ256rm,
          11220 => Opcode::VMAXPDZ256rmb,
          11221 => Opcode::VMAXPDZ256rmbk,
          11222 => Opcode::VMAXPDZ256rmbkz,
          11223 => Opcode::VMAXPDZ256rmk,
          11224 => Opcode::VMAXPDZ256rmkz,
          11225 => Opcode::VMAXPDZ256rr,
          11226 => Opcode::VMAXPDZ256rrk,
          11227 => Opcode::VMAXPDZ256rrkz,
          11228 => Opcode::VMAXPDZrm,
          11229 => Opcode::VMAXPDZrmb,
          11230 => Opcode::VMAXPDZrmbk,
          11231 => Opcode::VMAXPDZrmbkz,
          11232 => Opcode::VMAXPDZrmk,
          11233 => Opcode::VMAXPDZrmkz,
          11234 => Opcode::VMAXPDZrr,
          11235 => Opcode::VMAXPDZrrb,
          11236 => Opcode::VMAXPDZrrbk,
          11237 => Opcode::VMAXPDZrrbkz,
          11238 => Opcode::VMAXPDZrrk,
          11239 => Opcode::VMAXPDZrrkz,
          11240 => Opcode::VMAXPDrm,
          11241 => Opcode::VMAXPDrr,
          11242 => Opcode::VMAXPHZ128rm,
          11243 => Opcode::VMAXPHZ128rmb,
          11244 => Opcode::VMAXPHZ128rmbk,
          11245 => Opcode::VMAXPHZ128rmbkz,
          11246 => Opcode::VMAXPHZ128rmk,
          11247 => Opcode::VMAXPHZ128rmkz,
          11248 => Opcode::VMAXPHZ128rr,
          11249 => Opcode::VMAXPHZ128rrk,
          11250 => Opcode::VMAXPHZ128rrkz,
          11251 => Opcode::VMAXPHZ256rm,
          11252 => Opcode::VMAXPHZ256rmb,
          11253 => Opcode::VMAXPHZ256rmbk,
          11254 => Opcode::VMAXPHZ256rmbkz,
          11255 => Opcode::VMAXPHZ256rmk,
          11256 => Opcode::VMAXPHZ256rmkz,
          11257 => Opcode::VMAXPHZ256rr,
          11258 => Opcode::VMAXPHZ256rrk,
          11259 => Opcode::VMAXPHZ256rrkz,
          11260 => Opcode::VMAXPHZrm,
          11261 => Opcode::VMAXPHZrmb,
          11262 => Opcode::VMAXPHZrmbk,
          11263 => Opcode::VMAXPHZrmbkz,
          11264 => Opcode::VMAXPHZrmk,
          11265 => Opcode::VMAXPHZrmkz,
          11266 => Opcode::VMAXPHZrr,
          11267 => Opcode::VMAXPHZrrb,
          11268 => Opcode::VMAXPHZrrbk,
          11269 => Opcode::VMAXPHZrrbkz,
          11270 => Opcode::VMAXPHZrrk,
          11271 => Opcode::VMAXPHZrrkz,
          11272 => Opcode::VMAXPSYrm,
          11273 => Opcode::VMAXPSYrr,
          11274 => Opcode::VMAXPSZ128rm,
          11275 => Opcode::VMAXPSZ128rmb,
          11276 => Opcode::VMAXPSZ128rmbk,
          11277 => Opcode::VMAXPSZ128rmbkz,
          11278 => Opcode::VMAXPSZ128rmk,
          11279 => Opcode::VMAXPSZ128rmkz,
          11280 => Opcode::VMAXPSZ128rr,
          11281 => Opcode::VMAXPSZ128rrk,
          11282 => Opcode::VMAXPSZ128rrkz,
          11283 => Opcode::VMAXPSZ256rm,
          11284 => Opcode::VMAXPSZ256rmb,
          11285 => Opcode::VMAXPSZ256rmbk,
          11286 => Opcode::VMAXPSZ256rmbkz,
          11287 => Opcode::VMAXPSZ256rmk,
          11288 => Opcode::VMAXPSZ256rmkz,
          11289 => Opcode::VMAXPSZ256rr,
          11290 => Opcode::VMAXPSZ256rrk,
          11291 => Opcode::VMAXPSZ256rrkz,
          11292 => Opcode::VMAXPSZrm,
          11293 => Opcode::VMAXPSZrmb,
          11294 => Opcode::VMAXPSZrmbk,
          11295 => Opcode::VMAXPSZrmbkz,
          11296 => Opcode::VMAXPSZrmk,
          11297 => Opcode::VMAXPSZrmkz,
          11298 => Opcode::VMAXPSZrr,
          11299 => Opcode::VMAXPSZrrb,
          11300 => Opcode::VMAXPSZrrbk,
          11301 => Opcode::VMAXPSZrrbkz,
          11302 => Opcode::VMAXPSZrrk,
          11303 => Opcode::VMAXPSZrrkz,
          11304 => Opcode::VMAXPSrm,
          11305 => Opcode::VMAXPSrr,
          11306 => Opcode::VMAXSDZrm,
          11307 => Opcode::VMAXSDZrm_Int,
          11308 => Opcode::VMAXSDZrm_Intk,
          11309 => Opcode::VMAXSDZrm_Intkz,
          11310 => Opcode::VMAXSDZrr,
          11311 => Opcode::VMAXSDZrr_Int,
          11312 => Opcode::VMAXSDZrr_Intk,
          11313 => Opcode::VMAXSDZrr_Intkz,
          11314 => Opcode::VMAXSDZrrb_Int,
          11315 => Opcode::VMAXSDZrrb_Intk,
          11316 => Opcode::VMAXSDZrrb_Intkz,
          11317 => Opcode::VMAXSDrm,
          11318 => Opcode::VMAXSDrm_Int,
          11319 => Opcode::VMAXSDrr,
          11320 => Opcode::VMAXSDrr_Int,
          11321 => Opcode::VMAXSHZrm,
          11322 => Opcode::VMAXSHZrm_Int,
          11323 => Opcode::VMAXSHZrm_Intk,
          11324 => Opcode::VMAXSHZrm_Intkz,
          11325 => Opcode::VMAXSHZrr,
          11326 => Opcode::VMAXSHZrr_Int,
          11327 => Opcode::VMAXSHZrr_Intk,
          11328 => Opcode::VMAXSHZrr_Intkz,
          11329 => Opcode::VMAXSHZrrb_Int,
          11330 => Opcode::VMAXSHZrrb_Intk,
          11331 => Opcode::VMAXSHZrrb_Intkz,
          11332 => Opcode::VMAXSSZrm,
          11333 => Opcode::VMAXSSZrm_Int,
          11334 => Opcode::VMAXSSZrm_Intk,
          11335 => Opcode::VMAXSSZrm_Intkz,
          11336 => Opcode::VMAXSSZrr,
          11337 => Opcode::VMAXSSZrr_Int,
          11338 => Opcode::VMAXSSZrr_Intk,
          11339 => Opcode::VMAXSSZrr_Intkz,
          11340 => Opcode::VMAXSSZrrb_Int,
          11341 => Opcode::VMAXSSZrrb_Intk,
          11342 => Opcode::VMAXSSZrrb_Intkz,
          11343 => Opcode::VMAXSSrm,
          11344 => Opcode::VMAXSSrm_Int,
          11345 => Opcode::VMAXSSrr,
          11346 => Opcode::VMAXSSrr_Int,
          11347 => Opcode::VMCALL,
          11348 => Opcode::VMCLEARm,
          11349 => Opcode::VMFUNC,
          11350 => Opcode::VMINCPDYrm,
          11351 => Opcode::VMINCPDYrr,
          11352 => Opcode::VMINCPDZ128rm,
          11353 => Opcode::VMINCPDZ128rmb,
          11354 => Opcode::VMINCPDZ128rmbk,
          11355 => Opcode::VMINCPDZ128rmbkz,
          11356 => Opcode::VMINCPDZ128rmk,
          11357 => Opcode::VMINCPDZ128rmkz,
          11358 => Opcode::VMINCPDZ128rr,
          11359 => Opcode::VMINCPDZ128rrk,
          11360 => Opcode::VMINCPDZ128rrkz,
          11361 => Opcode::VMINCPDZ256rm,
          11362 => Opcode::VMINCPDZ256rmb,
          11363 => Opcode::VMINCPDZ256rmbk,
          11364 => Opcode::VMINCPDZ256rmbkz,
          11365 => Opcode::VMINCPDZ256rmk,
          11366 => Opcode::VMINCPDZ256rmkz,
          11367 => Opcode::VMINCPDZ256rr,
          11368 => Opcode::VMINCPDZ256rrk,
          11369 => Opcode::VMINCPDZ256rrkz,
          11370 => Opcode::VMINCPDZrm,
          11371 => Opcode::VMINCPDZrmb,
          11372 => Opcode::VMINCPDZrmbk,
          11373 => Opcode::VMINCPDZrmbkz,
          11374 => Opcode::VMINCPDZrmk,
          11375 => Opcode::VMINCPDZrmkz,
          11376 => Opcode::VMINCPDZrr,
          11377 => Opcode::VMINCPDZrrk,
          11378 => Opcode::VMINCPDZrrkz,
          11379 => Opcode::VMINCPDrm,
          11380 => Opcode::VMINCPDrr,
          11381 => Opcode::VMINCPHZ128rm,
          11382 => Opcode::VMINCPHZ128rmb,
          11383 => Opcode::VMINCPHZ128rmbk,
          11384 => Opcode::VMINCPHZ128rmbkz,
          11385 => Opcode::VMINCPHZ128rmk,
          11386 => Opcode::VMINCPHZ128rmkz,
          11387 => Opcode::VMINCPHZ128rr,
          11388 => Opcode::VMINCPHZ128rrk,
          11389 => Opcode::VMINCPHZ128rrkz,
          11390 => Opcode::VMINCPHZ256rm,
          11391 => Opcode::VMINCPHZ256rmb,
          11392 => Opcode::VMINCPHZ256rmbk,
          11393 => Opcode::VMINCPHZ256rmbkz,
          11394 => Opcode::VMINCPHZ256rmk,
          11395 => Opcode::VMINCPHZ256rmkz,
          11396 => Opcode::VMINCPHZ256rr,
          11397 => Opcode::VMINCPHZ256rrk,
          11398 => Opcode::VMINCPHZ256rrkz,
          11399 => Opcode::VMINCPHZrm,
          11400 => Opcode::VMINCPHZrmb,
          11401 => Opcode::VMINCPHZrmbk,
          11402 => Opcode::VMINCPHZrmbkz,
          11403 => Opcode::VMINCPHZrmk,
          11404 => Opcode::VMINCPHZrmkz,
          11405 => Opcode::VMINCPHZrr,
          11406 => Opcode::VMINCPHZrrk,
          11407 => Opcode::VMINCPHZrrkz,
          11408 => Opcode::VMINCPSYrm,
          11409 => Opcode::VMINCPSYrr,
          11410 => Opcode::VMINCPSZ128rm,
          11411 => Opcode::VMINCPSZ128rmb,
          11412 => Opcode::VMINCPSZ128rmbk,
          11413 => Opcode::VMINCPSZ128rmbkz,
          11414 => Opcode::VMINCPSZ128rmk,
          11415 => Opcode::VMINCPSZ128rmkz,
          11416 => Opcode::VMINCPSZ128rr,
          11417 => Opcode::VMINCPSZ128rrk,
          11418 => Opcode::VMINCPSZ128rrkz,
          11419 => Opcode::VMINCPSZ256rm,
          11420 => Opcode::VMINCPSZ256rmb,
          11421 => Opcode::VMINCPSZ256rmbk,
          11422 => Opcode::VMINCPSZ256rmbkz,
          11423 => Opcode::VMINCPSZ256rmk,
          11424 => Opcode::VMINCPSZ256rmkz,
          11425 => Opcode::VMINCPSZ256rr,
          11426 => Opcode::VMINCPSZ256rrk,
          11427 => Opcode::VMINCPSZ256rrkz,
          11428 => Opcode::VMINCPSZrm,
          11429 => Opcode::VMINCPSZrmb,
          11430 => Opcode::VMINCPSZrmbk,
          11431 => Opcode::VMINCPSZrmbkz,
          11432 => Opcode::VMINCPSZrmk,
          11433 => Opcode::VMINCPSZrmkz,
          11434 => Opcode::VMINCPSZrr,
          11435 => Opcode::VMINCPSZrrk,
          11436 => Opcode::VMINCPSZrrkz,
          11437 => Opcode::VMINCPSrm,
          11438 => Opcode::VMINCPSrr,
          11439 => Opcode::VMINCSDZrm,
          11440 => Opcode::VMINCSDZrr,
          11441 => Opcode::VMINCSDrm,
          11442 => Opcode::VMINCSDrr,
          11443 => Opcode::VMINCSHZrm,
          11444 => Opcode::VMINCSHZrr,
          11445 => Opcode::VMINCSSZrm,
          11446 => Opcode::VMINCSSZrr,
          11447 => Opcode::VMINCSSrm,
          11448 => Opcode::VMINCSSrr,
          11449 => Opcode::VMINPDYrm,
          11450 => Opcode::VMINPDYrr,
          11451 => Opcode::VMINPDZ128rm,
          11452 => Opcode::VMINPDZ128rmb,
          11453 => Opcode::VMINPDZ128rmbk,
          11454 => Opcode::VMINPDZ128rmbkz,
          11455 => Opcode::VMINPDZ128rmk,
          11456 => Opcode::VMINPDZ128rmkz,
          11457 => Opcode::VMINPDZ128rr,
          11458 => Opcode::VMINPDZ128rrk,
          11459 => Opcode::VMINPDZ128rrkz,
          11460 => Opcode::VMINPDZ256rm,
          11461 => Opcode::VMINPDZ256rmb,
          11462 => Opcode::VMINPDZ256rmbk,
          11463 => Opcode::VMINPDZ256rmbkz,
          11464 => Opcode::VMINPDZ256rmk,
          11465 => Opcode::VMINPDZ256rmkz,
          11466 => Opcode::VMINPDZ256rr,
          11467 => Opcode::VMINPDZ256rrk,
          11468 => Opcode::VMINPDZ256rrkz,
          11469 => Opcode::VMINPDZrm,
          11470 => Opcode::VMINPDZrmb,
          11471 => Opcode::VMINPDZrmbk,
          11472 => Opcode::VMINPDZrmbkz,
          11473 => Opcode::VMINPDZrmk,
          11474 => Opcode::VMINPDZrmkz,
          11475 => Opcode::VMINPDZrr,
          11476 => Opcode::VMINPDZrrb,
          11477 => Opcode::VMINPDZrrbk,
          11478 => Opcode::VMINPDZrrbkz,
          11479 => Opcode::VMINPDZrrk,
          11480 => Opcode::VMINPDZrrkz,
          11481 => Opcode::VMINPDrm,
          11482 => Opcode::VMINPDrr,
          11483 => Opcode::VMINPHZ128rm,
          11484 => Opcode::VMINPHZ128rmb,
          11485 => Opcode::VMINPHZ128rmbk,
          11486 => Opcode::VMINPHZ128rmbkz,
          11487 => Opcode::VMINPHZ128rmk,
          11488 => Opcode::VMINPHZ128rmkz,
          11489 => Opcode::VMINPHZ128rr,
          11490 => Opcode::VMINPHZ128rrk,
          11491 => Opcode::VMINPHZ128rrkz,
          11492 => Opcode::VMINPHZ256rm,
          11493 => Opcode::VMINPHZ256rmb,
          11494 => Opcode::VMINPHZ256rmbk,
          11495 => Opcode::VMINPHZ256rmbkz,
          11496 => Opcode::VMINPHZ256rmk,
          11497 => Opcode::VMINPHZ256rmkz,
          11498 => Opcode::VMINPHZ256rr,
          11499 => Opcode::VMINPHZ256rrk,
          11500 => Opcode::VMINPHZ256rrkz,
          11501 => Opcode::VMINPHZrm,
          11502 => Opcode::VMINPHZrmb,
          11503 => Opcode::VMINPHZrmbk,
          11504 => Opcode::VMINPHZrmbkz,
          11505 => Opcode::VMINPHZrmk,
          11506 => Opcode::VMINPHZrmkz,
          11507 => Opcode::VMINPHZrr,
          11508 => Opcode::VMINPHZrrb,
          11509 => Opcode::VMINPHZrrbk,
          11510 => Opcode::VMINPHZrrbkz,
          11511 => Opcode::VMINPHZrrk,
          11512 => Opcode::VMINPHZrrkz,
          11513 => Opcode::VMINPSYrm,
          11514 => Opcode::VMINPSYrr,
          11515 => Opcode::VMINPSZ128rm,
          11516 => Opcode::VMINPSZ128rmb,
          11517 => Opcode::VMINPSZ128rmbk,
          11518 => Opcode::VMINPSZ128rmbkz,
          11519 => Opcode::VMINPSZ128rmk,
          11520 => Opcode::VMINPSZ128rmkz,
          11521 => Opcode::VMINPSZ128rr,
          11522 => Opcode::VMINPSZ128rrk,
          11523 => Opcode::VMINPSZ128rrkz,
          11524 => Opcode::VMINPSZ256rm,
          11525 => Opcode::VMINPSZ256rmb,
          11526 => Opcode::VMINPSZ256rmbk,
          11527 => Opcode::VMINPSZ256rmbkz,
          11528 => Opcode::VMINPSZ256rmk,
          11529 => Opcode::VMINPSZ256rmkz,
          11530 => Opcode::VMINPSZ256rr,
          11531 => Opcode::VMINPSZ256rrk,
          11532 => Opcode::VMINPSZ256rrkz,
          11533 => Opcode::VMINPSZrm,
          11534 => Opcode::VMINPSZrmb,
          11535 => Opcode::VMINPSZrmbk,
          11536 => Opcode::VMINPSZrmbkz,
          11537 => Opcode::VMINPSZrmk,
          11538 => Opcode::VMINPSZrmkz,
          11539 => Opcode::VMINPSZrr,
          11540 => Opcode::VMINPSZrrb,
          11541 => Opcode::VMINPSZrrbk,
          11542 => Opcode::VMINPSZrrbkz,
          11543 => Opcode::VMINPSZrrk,
          11544 => Opcode::VMINPSZrrkz,
          11545 => Opcode::VMINPSrm,
          11546 => Opcode::VMINPSrr,
          11547 => Opcode::VMINSDZrm,
          11548 => Opcode::VMINSDZrm_Int,
          11549 => Opcode::VMINSDZrm_Intk,
          11550 => Opcode::VMINSDZrm_Intkz,
          11551 => Opcode::VMINSDZrr,
          11552 => Opcode::VMINSDZrr_Int,
          11553 => Opcode::VMINSDZrr_Intk,
          11554 => Opcode::VMINSDZrr_Intkz,
          11555 => Opcode::VMINSDZrrb_Int,
          11556 => Opcode::VMINSDZrrb_Intk,
          11557 => Opcode::VMINSDZrrb_Intkz,
          11558 => Opcode::VMINSDrm,
          11559 => Opcode::VMINSDrm_Int,
          11560 => Opcode::VMINSDrr,
          11561 => Opcode::VMINSDrr_Int,
          11562 => Opcode::VMINSHZrm,
          11563 => Opcode::VMINSHZrm_Int,
          11564 => Opcode::VMINSHZrm_Intk,
          11565 => Opcode::VMINSHZrm_Intkz,
          11566 => Opcode::VMINSHZrr,
          11567 => Opcode::VMINSHZrr_Int,
          11568 => Opcode::VMINSHZrr_Intk,
          11569 => Opcode::VMINSHZrr_Intkz,
          11570 => Opcode::VMINSHZrrb_Int,
          11571 => Opcode::VMINSHZrrb_Intk,
          11572 => Opcode::VMINSHZrrb_Intkz,
          11573 => Opcode::VMINSSZrm,
          11574 => Opcode::VMINSSZrm_Int,
          11575 => Opcode::VMINSSZrm_Intk,
          11576 => Opcode::VMINSSZrm_Intkz,
          11577 => Opcode::VMINSSZrr,
          11578 => Opcode::VMINSSZrr_Int,
          11579 => Opcode::VMINSSZrr_Intk,
          11580 => Opcode::VMINSSZrr_Intkz,
          11581 => Opcode::VMINSSZrrb_Int,
          11582 => Opcode::VMINSSZrrb_Intk,
          11583 => Opcode::VMINSSZrrb_Intkz,
          11584 => Opcode::VMINSSrm,
          11585 => Opcode::VMINSSrm_Int,
          11586 => Opcode::VMINSSrr,
          11587 => Opcode::VMINSSrr_Int,
          11588 => Opcode::VMLAUNCH,
          11589 => Opcode::VMLOAD32,
          11590 => Opcode::VMLOAD64,
          11591 => Opcode::VMMCALL,
          11592 => Opcode::VMOV64toPQIZrm,
          11593 => Opcode::VMOV64toPQIZrr,
          11594 => Opcode::VMOV64toPQIrm,
          11595 => Opcode::VMOV64toPQIrr,
          11596 => Opcode::VMOV64toSDZrr,
          11597 => Opcode::VMOV64toSDrr,
          11598 => Opcode::VMOVAPDYmr,
          11599 => Opcode::VMOVAPDYrm,
          11600 => Opcode::VMOVAPDYrr,
          11601 => Opcode::VMOVAPDYrr_REV,
          11602 => Opcode::VMOVAPDZ128mr,
          11603 => Opcode::VMOVAPDZ128mrk,
          11604 => Opcode::VMOVAPDZ128rm,
          11605 => Opcode::VMOVAPDZ128rmk,
          11606 => Opcode::VMOVAPDZ128rmkz,
          11607 => Opcode::VMOVAPDZ128rr,
          11608 => Opcode::VMOVAPDZ128rr_REV,
          11609 => Opcode::VMOVAPDZ128rrk,
          11610 => Opcode::VMOVAPDZ128rrk_REV,
          11611 => Opcode::VMOVAPDZ128rrkz,
          11612 => Opcode::VMOVAPDZ128rrkz_REV,
          11613 => Opcode::VMOVAPDZ256mr,
          11614 => Opcode::VMOVAPDZ256mrk,
          11615 => Opcode::VMOVAPDZ256rm,
          11616 => Opcode::VMOVAPDZ256rmk,
          11617 => Opcode::VMOVAPDZ256rmkz,
          11618 => Opcode::VMOVAPDZ256rr,
          11619 => Opcode::VMOVAPDZ256rr_REV,
          11620 => Opcode::VMOVAPDZ256rrk,
          11621 => Opcode::VMOVAPDZ256rrk_REV,
          11622 => Opcode::VMOVAPDZ256rrkz,
          11623 => Opcode::VMOVAPDZ256rrkz_REV,
          11624 => Opcode::VMOVAPDZmr,
          11625 => Opcode::VMOVAPDZmrk,
          11626 => Opcode::VMOVAPDZrm,
          11627 => Opcode::VMOVAPDZrmk,
          11628 => Opcode::VMOVAPDZrmkz,
          11629 => Opcode::VMOVAPDZrr,
          11630 => Opcode::VMOVAPDZrr_REV,
          11631 => Opcode::VMOVAPDZrrk,
          11632 => Opcode::VMOVAPDZrrk_REV,
          11633 => Opcode::VMOVAPDZrrkz,
          11634 => Opcode::VMOVAPDZrrkz_REV,
          11635 => Opcode::VMOVAPDmr,
          11636 => Opcode::VMOVAPDrm,
          11637 => Opcode::VMOVAPDrr,
          11638 => Opcode::VMOVAPDrr_REV,
          11639 => Opcode::VMOVAPSYmr,
          11640 => Opcode::VMOVAPSYrm,
          11641 => Opcode::VMOVAPSYrr,
          11642 => Opcode::VMOVAPSYrr_REV,
          11643 => Opcode::VMOVAPSZ128mr,
          11644 => Opcode::VMOVAPSZ128mrk,
          11645 => Opcode::VMOVAPSZ128rm,
          11646 => Opcode::VMOVAPSZ128rmk,
          11647 => Opcode::VMOVAPSZ128rmkz,
          11648 => Opcode::VMOVAPSZ128rr,
          11649 => Opcode::VMOVAPSZ128rr_REV,
          11650 => Opcode::VMOVAPSZ128rrk,
          11651 => Opcode::VMOVAPSZ128rrk_REV,
          11652 => Opcode::VMOVAPSZ128rrkz,
          11653 => Opcode::VMOVAPSZ128rrkz_REV,
          11654 => Opcode::VMOVAPSZ256mr,
          11655 => Opcode::VMOVAPSZ256mrk,
          11656 => Opcode::VMOVAPSZ256rm,
          11657 => Opcode::VMOVAPSZ256rmk,
          11658 => Opcode::VMOVAPSZ256rmkz,
          11659 => Opcode::VMOVAPSZ256rr,
          11660 => Opcode::VMOVAPSZ256rr_REV,
          11661 => Opcode::VMOVAPSZ256rrk,
          11662 => Opcode::VMOVAPSZ256rrk_REV,
          11663 => Opcode::VMOVAPSZ256rrkz,
          11664 => Opcode::VMOVAPSZ256rrkz_REV,
          11665 => Opcode::VMOVAPSZmr,
          11666 => Opcode::VMOVAPSZmrk,
          11667 => Opcode::VMOVAPSZrm,
          11668 => Opcode::VMOVAPSZrmk,
          11669 => Opcode::VMOVAPSZrmkz,
          11670 => Opcode::VMOVAPSZrr,
          11671 => Opcode::VMOVAPSZrr_REV,
          11672 => Opcode::VMOVAPSZrrk,
          11673 => Opcode::VMOVAPSZrrk_REV,
          11674 => Opcode::VMOVAPSZrrkz,
          11675 => Opcode::VMOVAPSZrrkz_REV,
          11676 => Opcode::VMOVAPSmr,
          11677 => Opcode::VMOVAPSrm,
          11678 => Opcode::VMOVAPSrr,
          11679 => Opcode::VMOVAPSrr_REV,
          11680 => Opcode::VMOVDDUPYrm,
          11681 => Opcode::VMOVDDUPYrr,
          11682 => Opcode::VMOVDDUPZ128rm,
          11683 => Opcode::VMOVDDUPZ128rmk,
          11684 => Opcode::VMOVDDUPZ128rmkz,
          11685 => Opcode::VMOVDDUPZ128rr,
          11686 => Opcode::VMOVDDUPZ128rrk,
          11687 => Opcode::VMOVDDUPZ128rrkz,
          11688 => Opcode::VMOVDDUPZ256rm,
          11689 => Opcode::VMOVDDUPZ256rmk,
          11690 => Opcode::VMOVDDUPZ256rmkz,
          11691 => Opcode::VMOVDDUPZ256rr,
          11692 => Opcode::VMOVDDUPZ256rrk,
          11693 => Opcode::VMOVDDUPZ256rrkz,
          11694 => Opcode::VMOVDDUPZrm,
          11695 => Opcode::VMOVDDUPZrmk,
          11696 => Opcode::VMOVDDUPZrmkz,
          11697 => Opcode::VMOVDDUPZrr,
          11698 => Opcode::VMOVDDUPZrrk,
          11699 => Opcode::VMOVDDUPZrrkz,
          11700 => Opcode::VMOVDDUPrm,
          11701 => Opcode::VMOVDDUPrr,
          11702 => Opcode::VMOVDI2PDIZrm,
          11703 => Opcode::VMOVDI2PDIZrr,
          11704 => Opcode::VMOVDI2PDIrm,
          11705 => Opcode::VMOVDI2PDIrr,
          11706 => Opcode::VMOVDI2SSZrr,
          11707 => Opcode::VMOVDI2SSrr,
          11708 => Opcode::VMOVDQA32Z128mr,
          11709 => Opcode::VMOVDQA32Z128mrk,
          11710 => Opcode::VMOVDQA32Z128rm,
          11711 => Opcode::VMOVDQA32Z128rmk,
          11712 => Opcode::VMOVDQA32Z128rmkz,
          11713 => Opcode::VMOVDQA32Z128rr,
          11714 => Opcode::VMOVDQA32Z128rr_REV,
          11715 => Opcode::VMOVDQA32Z128rrk,
          11716 => Opcode::VMOVDQA32Z128rrk_REV,
          11717 => Opcode::VMOVDQA32Z128rrkz,
          11718 => Opcode::VMOVDQA32Z128rrkz_REV,
          11719 => Opcode::VMOVDQA32Z256mr,
          11720 => Opcode::VMOVDQA32Z256mrk,
          11721 => Opcode::VMOVDQA32Z256rm,
          11722 => Opcode::VMOVDQA32Z256rmk,
          11723 => Opcode::VMOVDQA32Z256rmkz,
          11724 => Opcode::VMOVDQA32Z256rr,
          11725 => Opcode::VMOVDQA32Z256rr_REV,
          11726 => Opcode::VMOVDQA32Z256rrk,
          11727 => Opcode::VMOVDQA32Z256rrk_REV,
          11728 => Opcode::VMOVDQA32Z256rrkz,
          11729 => Opcode::VMOVDQA32Z256rrkz_REV,
          11730 => Opcode::VMOVDQA32Zmr,
          11731 => Opcode::VMOVDQA32Zmrk,
          11732 => Opcode::VMOVDQA32Zrm,
          11733 => Opcode::VMOVDQA32Zrmk,
          11734 => Opcode::VMOVDQA32Zrmkz,
          11735 => Opcode::VMOVDQA32Zrr,
          11736 => Opcode::VMOVDQA32Zrr_REV,
          11737 => Opcode::VMOVDQA32Zrrk,
          11738 => Opcode::VMOVDQA32Zrrk_REV,
          11739 => Opcode::VMOVDQA32Zrrkz,
          11740 => Opcode::VMOVDQA32Zrrkz_REV,
          11741 => Opcode::VMOVDQA64Z128mr,
          11742 => Opcode::VMOVDQA64Z128mrk,
          11743 => Opcode::VMOVDQA64Z128rm,
          11744 => Opcode::VMOVDQA64Z128rmk,
          11745 => Opcode::VMOVDQA64Z128rmkz,
          11746 => Opcode::VMOVDQA64Z128rr,
          11747 => Opcode::VMOVDQA64Z128rr_REV,
          11748 => Opcode::VMOVDQA64Z128rrk,
          11749 => Opcode::VMOVDQA64Z128rrk_REV,
          11750 => Opcode::VMOVDQA64Z128rrkz,
          11751 => Opcode::VMOVDQA64Z128rrkz_REV,
          11752 => Opcode::VMOVDQA64Z256mr,
          11753 => Opcode::VMOVDQA64Z256mrk,
          11754 => Opcode::VMOVDQA64Z256rm,
          11755 => Opcode::VMOVDQA64Z256rmk,
          11756 => Opcode::VMOVDQA64Z256rmkz,
          11757 => Opcode::VMOVDQA64Z256rr,
          11758 => Opcode::VMOVDQA64Z256rr_REV,
          11759 => Opcode::VMOVDQA64Z256rrk,
          11760 => Opcode::VMOVDQA64Z256rrk_REV,
          11761 => Opcode::VMOVDQA64Z256rrkz,
          11762 => Opcode::VMOVDQA64Z256rrkz_REV,
          11763 => Opcode::VMOVDQA64Zmr,
          11764 => Opcode::VMOVDQA64Zmrk,
          11765 => Opcode::VMOVDQA64Zrm,
          11766 => Opcode::VMOVDQA64Zrmk,
          11767 => Opcode::VMOVDQA64Zrmkz,
          11768 => Opcode::VMOVDQA64Zrr,
          11769 => Opcode::VMOVDQA64Zrr_REV,
          11770 => Opcode::VMOVDQA64Zrrk,
          11771 => Opcode::VMOVDQA64Zrrk_REV,
          11772 => Opcode::VMOVDQA64Zrrkz,
          11773 => Opcode::VMOVDQA64Zrrkz_REV,
          11774 => Opcode::VMOVDQAYmr,
          11775 => Opcode::VMOVDQAYrm,
          11776 => Opcode::VMOVDQAYrr,
          11777 => Opcode::VMOVDQAYrr_REV,
          11778 => Opcode::VMOVDQAmr,
          11779 => Opcode::VMOVDQArm,
          11780 => Opcode::VMOVDQArr,
          11781 => Opcode::VMOVDQArr_REV,
          11782 => Opcode::VMOVDQU16Z128mr,
          11783 => Opcode::VMOVDQU16Z128mrk,
          11784 => Opcode::VMOVDQU16Z128rm,
          11785 => Opcode::VMOVDQU16Z128rmk,
          11786 => Opcode::VMOVDQU16Z128rmkz,
          11787 => Opcode::VMOVDQU16Z128rr,
          11788 => Opcode::VMOVDQU16Z128rr_REV,
          11789 => Opcode::VMOVDQU16Z128rrk,
          11790 => Opcode::VMOVDQU16Z128rrk_REV,
          11791 => Opcode::VMOVDQU16Z128rrkz,
          11792 => Opcode::VMOVDQU16Z128rrkz_REV,
          11793 => Opcode::VMOVDQU16Z256mr,
          11794 => Opcode::VMOVDQU16Z256mrk,
          11795 => Opcode::VMOVDQU16Z256rm,
          11796 => Opcode::VMOVDQU16Z256rmk,
          11797 => Opcode::VMOVDQU16Z256rmkz,
          11798 => Opcode::VMOVDQU16Z256rr,
          11799 => Opcode::VMOVDQU16Z256rr_REV,
          11800 => Opcode::VMOVDQU16Z256rrk,
          11801 => Opcode::VMOVDQU16Z256rrk_REV,
          11802 => Opcode::VMOVDQU16Z256rrkz,
          11803 => Opcode::VMOVDQU16Z256rrkz_REV,
          11804 => Opcode::VMOVDQU16Zmr,
          11805 => Opcode::VMOVDQU16Zmrk,
          11806 => Opcode::VMOVDQU16Zrm,
          11807 => Opcode::VMOVDQU16Zrmk,
          11808 => Opcode::VMOVDQU16Zrmkz,
          11809 => Opcode::VMOVDQU16Zrr,
          11810 => Opcode::VMOVDQU16Zrr_REV,
          11811 => Opcode::VMOVDQU16Zrrk,
          11812 => Opcode::VMOVDQU16Zrrk_REV,
          11813 => Opcode::VMOVDQU16Zrrkz,
          11814 => Opcode::VMOVDQU16Zrrkz_REV,
          11815 => Opcode::VMOVDQU32Z128mr,
          11816 => Opcode::VMOVDQU32Z128mrk,
          11817 => Opcode::VMOVDQU32Z128rm,
          11818 => Opcode::VMOVDQU32Z128rmk,
          11819 => Opcode::VMOVDQU32Z128rmkz,
          11820 => Opcode::VMOVDQU32Z128rr,
          11821 => Opcode::VMOVDQU32Z128rr_REV,
          11822 => Opcode::VMOVDQU32Z128rrk,
          11823 => Opcode::VMOVDQU32Z128rrk_REV,
          11824 => Opcode::VMOVDQU32Z128rrkz,
          11825 => Opcode::VMOVDQU32Z128rrkz_REV,
          11826 => Opcode::VMOVDQU32Z256mr,
          11827 => Opcode::VMOVDQU32Z256mrk,
          11828 => Opcode::VMOVDQU32Z256rm,
          11829 => Opcode::VMOVDQU32Z256rmk,
          11830 => Opcode::VMOVDQU32Z256rmkz,
          11831 => Opcode::VMOVDQU32Z256rr,
          11832 => Opcode::VMOVDQU32Z256rr_REV,
          11833 => Opcode::VMOVDQU32Z256rrk,
          11834 => Opcode::VMOVDQU32Z256rrk_REV,
          11835 => Opcode::VMOVDQU32Z256rrkz,
          11836 => Opcode::VMOVDQU32Z256rrkz_REV,
          11837 => Opcode::VMOVDQU32Zmr,
          11838 => Opcode::VMOVDQU32Zmrk,
          11839 => Opcode::VMOVDQU32Zrm,
          11840 => Opcode::VMOVDQU32Zrmk,
          11841 => Opcode::VMOVDQU32Zrmkz,
          11842 => Opcode::VMOVDQU32Zrr,
          11843 => Opcode::VMOVDQU32Zrr_REV,
          11844 => Opcode::VMOVDQU32Zrrk,
          11845 => Opcode::VMOVDQU32Zrrk_REV,
          11846 => Opcode::VMOVDQU32Zrrkz,
          11847 => Opcode::VMOVDQU32Zrrkz_REV,
          11848 => Opcode::VMOVDQU64Z128mr,
          11849 => Opcode::VMOVDQU64Z128mrk,
          11850 => Opcode::VMOVDQU64Z128rm,
          11851 => Opcode::VMOVDQU64Z128rmk,
          11852 => Opcode::VMOVDQU64Z128rmkz,
          11853 => Opcode::VMOVDQU64Z128rr,
          11854 => Opcode::VMOVDQU64Z128rr_REV,
          11855 => Opcode::VMOVDQU64Z128rrk,
          11856 => Opcode::VMOVDQU64Z128rrk_REV,
          11857 => Opcode::VMOVDQU64Z128rrkz,
          11858 => Opcode::VMOVDQU64Z128rrkz_REV,
          11859 => Opcode::VMOVDQU64Z256mr,
          11860 => Opcode::VMOVDQU64Z256mrk,
          11861 => Opcode::VMOVDQU64Z256rm,
          11862 => Opcode::VMOVDQU64Z256rmk,
          11863 => Opcode::VMOVDQU64Z256rmkz,
          11864 => Opcode::VMOVDQU64Z256rr,
          11865 => Opcode::VMOVDQU64Z256rr_REV,
          11866 => Opcode::VMOVDQU64Z256rrk,
          11867 => Opcode::VMOVDQU64Z256rrk_REV,
          11868 => Opcode::VMOVDQU64Z256rrkz,
          11869 => Opcode::VMOVDQU64Z256rrkz_REV,
          11870 => Opcode::VMOVDQU64Zmr,
          11871 => Opcode::VMOVDQU64Zmrk,
          11872 => Opcode::VMOVDQU64Zrm,
          11873 => Opcode::VMOVDQU64Zrmk,
          11874 => Opcode::VMOVDQU64Zrmkz,
          11875 => Opcode::VMOVDQU64Zrr,
          11876 => Opcode::VMOVDQU64Zrr_REV,
          11877 => Opcode::VMOVDQU64Zrrk,
          11878 => Opcode::VMOVDQU64Zrrk_REV,
          11879 => Opcode::VMOVDQU64Zrrkz,
          11880 => Opcode::VMOVDQU64Zrrkz_REV,
          11881 => Opcode::VMOVDQU8Z128mr,
          11882 => Opcode::VMOVDQU8Z128mrk,
          11883 => Opcode::VMOVDQU8Z128rm,
          11884 => Opcode::VMOVDQU8Z128rmk,
          11885 => Opcode::VMOVDQU8Z128rmkz,
          11886 => Opcode::VMOVDQU8Z128rr,
          11887 => Opcode::VMOVDQU8Z128rr_REV,
          11888 => Opcode::VMOVDQU8Z128rrk,
          11889 => Opcode::VMOVDQU8Z128rrk_REV,
          11890 => Opcode::VMOVDQU8Z128rrkz,
          11891 => Opcode::VMOVDQU8Z128rrkz_REV,
          11892 => Opcode::VMOVDQU8Z256mr,
          11893 => Opcode::VMOVDQU8Z256mrk,
          11894 => Opcode::VMOVDQU8Z256rm,
          11895 => Opcode::VMOVDQU8Z256rmk,
          11896 => Opcode::VMOVDQU8Z256rmkz,
          11897 => Opcode::VMOVDQU8Z256rr,
          11898 => Opcode::VMOVDQU8Z256rr_REV,
          11899 => Opcode::VMOVDQU8Z256rrk,
          11900 => Opcode::VMOVDQU8Z256rrk_REV,
          11901 => Opcode::VMOVDQU8Z256rrkz,
          11902 => Opcode::VMOVDQU8Z256rrkz_REV,
          11903 => Opcode::VMOVDQU8Zmr,
          11904 => Opcode::VMOVDQU8Zmrk,
          11905 => Opcode::VMOVDQU8Zrm,
          11906 => Opcode::VMOVDQU8Zrmk,
          11907 => Opcode::VMOVDQU8Zrmkz,
          11908 => Opcode::VMOVDQU8Zrr,
          11909 => Opcode::VMOVDQU8Zrr_REV,
          11910 => Opcode::VMOVDQU8Zrrk,
          11911 => Opcode::VMOVDQU8Zrrk_REV,
          11912 => Opcode::VMOVDQU8Zrrkz,
          11913 => Opcode::VMOVDQU8Zrrkz_REV,
          11914 => Opcode::VMOVDQUYmr,
          11915 => Opcode::VMOVDQUYrm,
          11916 => Opcode::VMOVDQUYrr,
          11917 => Opcode::VMOVDQUYrr_REV,
          11918 => Opcode::VMOVDQUmr,
          11919 => Opcode::VMOVDQUrm,
          11920 => Opcode::VMOVDQUrr,
          11921 => Opcode::VMOVDQUrr_REV,
          11922 => Opcode::VMOVHLPSZrr,
          11923 => Opcode::VMOVHLPSrr,
          11924 => Opcode::VMOVHPDZ128mr,
          11925 => Opcode::VMOVHPDZ128rm,
          11926 => Opcode::VMOVHPDmr,
          11927 => Opcode::VMOVHPDrm,
          11928 => Opcode::VMOVHPSZ128mr,
          11929 => Opcode::VMOVHPSZ128rm,
          11930 => Opcode::VMOVHPSmr,
          11931 => Opcode::VMOVHPSrm,
          11932 => Opcode::VMOVLHPSZrr,
          11933 => Opcode::VMOVLHPSrr,
          11934 => Opcode::VMOVLPDZ128mr,
          11935 => Opcode::VMOVLPDZ128rm,
          11936 => Opcode::VMOVLPDmr,
          11937 => Opcode::VMOVLPDrm,
          11938 => Opcode::VMOVLPSZ128mr,
          11939 => Opcode::VMOVLPSZ128rm,
          11940 => Opcode::VMOVLPSmr,
          11941 => Opcode::VMOVLPSrm,
          11942 => Opcode::VMOVMSKPDYrr,
          11943 => Opcode::VMOVMSKPDrr,
          11944 => Opcode::VMOVMSKPSYrr,
          11945 => Opcode::VMOVMSKPSrr,
          11946 => Opcode::VMOVNTDQAYrm,
          11947 => Opcode::VMOVNTDQAZ128rm,
          11948 => Opcode::VMOVNTDQAZ256rm,
          11949 => Opcode::VMOVNTDQAZrm,
          11950 => Opcode::VMOVNTDQArm,
          11951 => Opcode::VMOVNTDQYmr,
          11952 => Opcode::VMOVNTDQZ128mr,
          11953 => Opcode::VMOVNTDQZ256mr,
          11954 => Opcode::VMOVNTDQZmr,
          11955 => Opcode::VMOVNTDQmr,
          11956 => Opcode::VMOVNTPDYmr,
          11957 => Opcode::VMOVNTPDZ128mr,
          11958 => Opcode::VMOVNTPDZ256mr,
          11959 => Opcode::VMOVNTPDZmr,
          11960 => Opcode::VMOVNTPDmr,
          11961 => Opcode::VMOVNTPSYmr,
          11962 => Opcode::VMOVNTPSZ128mr,
          11963 => Opcode::VMOVNTPSZ256mr,
          11964 => Opcode::VMOVNTPSZmr,
          11965 => Opcode::VMOVNTPSmr,
          11966 => Opcode::VMOVPDI2DIZmr,
          11967 => Opcode::VMOVPDI2DIZrr,
          11968 => Opcode::VMOVPDI2DImr,
          11969 => Opcode::VMOVPDI2DIrr,
          11970 => Opcode::VMOVPQI2QIZmr,
          11971 => Opcode::VMOVPQI2QIZrr,
          11972 => Opcode::VMOVPQI2QImr,
          11973 => Opcode::VMOVPQI2QIrr,
          11974 => Opcode::VMOVPQIto64Zmr,
          11975 => Opcode::VMOVPQIto64Zrr,
          11976 => Opcode::VMOVPQIto64mr,
          11977 => Opcode::VMOVPQIto64rr,
          11978 => Opcode::VMOVQI2PQIZrm,
          11979 => Opcode::VMOVQI2PQIrm,
          11980 => Opcode::VMOVSDZmr,
          11981 => Opcode::VMOVSDZmrk,
          11982 => Opcode::VMOVSDZrm,
          11983 => Opcode::VMOVSDZrm_alt,
          11984 => Opcode::VMOVSDZrmk,
          11985 => Opcode::VMOVSDZrmkz,
          11986 => Opcode::VMOVSDZrr,
          11987 => Opcode::VMOVSDZrr_REV,
          11988 => Opcode::VMOVSDZrrk,
          11989 => Opcode::VMOVSDZrrk_REV,
          11990 => Opcode::VMOVSDZrrkz,
          11991 => Opcode::VMOVSDZrrkz_REV,
          11992 => Opcode::VMOVSDmr,
          11993 => Opcode::VMOVSDrm,
          11994 => Opcode::VMOVSDrm_alt,
          11995 => Opcode::VMOVSDrr,
          11996 => Opcode::VMOVSDrr_REV,
          11997 => Opcode::VMOVSDto64Zrr,
          11998 => Opcode::VMOVSDto64rr,
          11999 => Opcode::VMOVSH2Wrr,
          12000 => Opcode::VMOVSHDUPYrm,
          12001 => Opcode::VMOVSHDUPYrr,
          12002 => Opcode::VMOVSHDUPZ128rm,
          12003 => Opcode::VMOVSHDUPZ128rmk,
          12004 => Opcode::VMOVSHDUPZ128rmkz,
          12005 => Opcode::VMOVSHDUPZ128rr,
          12006 => Opcode::VMOVSHDUPZ128rrk,
          12007 => Opcode::VMOVSHDUPZ128rrkz,
          12008 => Opcode::VMOVSHDUPZ256rm,
          12009 => Opcode::VMOVSHDUPZ256rmk,
          12010 => Opcode::VMOVSHDUPZ256rmkz,
          12011 => Opcode::VMOVSHDUPZ256rr,
          12012 => Opcode::VMOVSHDUPZ256rrk,
          12013 => Opcode::VMOVSHDUPZ256rrkz,
          12014 => Opcode::VMOVSHDUPZrm,
          12015 => Opcode::VMOVSHDUPZrmk,
          12016 => Opcode::VMOVSHDUPZrmkz,
          12017 => Opcode::VMOVSHDUPZrr,
          12018 => Opcode::VMOVSHDUPZrrk,
          12019 => Opcode::VMOVSHDUPZrrkz,
          12020 => Opcode::VMOVSHDUPrm,
          12021 => Opcode::VMOVSHDUPrr,
          12022 => Opcode::VMOVSHZmr,
          12023 => Opcode::VMOVSHZmrk,
          12024 => Opcode::VMOVSHZrm,
          12025 => Opcode::VMOVSHZrm_alt,
          12026 => Opcode::VMOVSHZrmk,
          12027 => Opcode::VMOVSHZrmkz,
          12028 => Opcode::VMOVSHZrr,
          12029 => Opcode::VMOVSHZrr_REV,
          12030 => Opcode::VMOVSHZrrk,
          12031 => Opcode::VMOVSHZrrk_REV,
          12032 => Opcode::VMOVSHZrrkz,
          12033 => Opcode::VMOVSHZrrkz_REV,
          12034 => Opcode::VMOVSHtoW64rr,
          12035 => Opcode::VMOVSLDUPYrm,
          12036 => Opcode::VMOVSLDUPYrr,
          12037 => Opcode::VMOVSLDUPZ128rm,
          12038 => Opcode::VMOVSLDUPZ128rmk,
          12039 => Opcode::VMOVSLDUPZ128rmkz,
          12040 => Opcode::VMOVSLDUPZ128rr,
          12041 => Opcode::VMOVSLDUPZ128rrk,
          12042 => Opcode::VMOVSLDUPZ128rrkz,
          12043 => Opcode::VMOVSLDUPZ256rm,
          12044 => Opcode::VMOVSLDUPZ256rmk,
          12045 => Opcode::VMOVSLDUPZ256rmkz,
          12046 => Opcode::VMOVSLDUPZ256rr,
          12047 => Opcode::VMOVSLDUPZ256rrk,
          12048 => Opcode::VMOVSLDUPZ256rrkz,
          12049 => Opcode::VMOVSLDUPZrm,
          12050 => Opcode::VMOVSLDUPZrmk,
          12051 => Opcode::VMOVSLDUPZrmkz,
          12052 => Opcode::VMOVSLDUPZrr,
          12053 => Opcode::VMOVSLDUPZrrk,
          12054 => Opcode::VMOVSLDUPZrrkz,
          12055 => Opcode::VMOVSLDUPrm,
          12056 => Opcode::VMOVSLDUPrr,
          12057 => Opcode::VMOVSS2DIZrr,
          12058 => Opcode::VMOVSS2DIrr,
          12059 => Opcode::VMOVSSZmr,
          12060 => Opcode::VMOVSSZmrk,
          12061 => Opcode::VMOVSSZrm,
          12062 => Opcode::VMOVSSZrm_alt,
          12063 => Opcode::VMOVSSZrmk,
          12064 => Opcode::VMOVSSZrmkz,
          12065 => Opcode::VMOVSSZrr,
          12066 => Opcode::VMOVSSZrr_REV,
          12067 => Opcode::VMOVSSZrrk,
          12068 => Opcode::VMOVSSZrrk_REV,
          12069 => Opcode::VMOVSSZrrkz,
          12070 => Opcode::VMOVSSZrrkz_REV,
          12071 => Opcode::VMOVSSmr,
          12072 => Opcode::VMOVSSrm,
          12073 => Opcode::VMOVSSrm_alt,
          12074 => Opcode::VMOVSSrr,
          12075 => Opcode::VMOVSSrr_REV,
          12076 => Opcode::VMOVUPDYmr,
          12077 => Opcode::VMOVUPDYrm,
          12078 => Opcode::VMOVUPDYrr,
          12079 => Opcode::VMOVUPDYrr_REV,
          12080 => Opcode::VMOVUPDZ128mr,
          12081 => Opcode::VMOVUPDZ128mrk,
          12082 => Opcode::VMOVUPDZ128rm,
          12083 => Opcode::VMOVUPDZ128rmk,
          12084 => Opcode::VMOVUPDZ128rmkz,
          12085 => Opcode::VMOVUPDZ128rr,
          12086 => Opcode::VMOVUPDZ128rr_REV,
          12087 => Opcode::VMOVUPDZ128rrk,
          12088 => Opcode::VMOVUPDZ128rrk_REV,
          12089 => Opcode::VMOVUPDZ128rrkz,
          12090 => Opcode::VMOVUPDZ128rrkz_REV,
          12091 => Opcode::VMOVUPDZ256mr,
          12092 => Opcode::VMOVUPDZ256mrk,
          12093 => Opcode::VMOVUPDZ256rm,
          12094 => Opcode::VMOVUPDZ256rmk,
          12095 => Opcode::VMOVUPDZ256rmkz,
          12096 => Opcode::VMOVUPDZ256rr,
          12097 => Opcode::VMOVUPDZ256rr_REV,
          12098 => Opcode::VMOVUPDZ256rrk,
          12099 => Opcode::VMOVUPDZ256rrk_REV,
          12100 => Opcode::VMOVUPDZ256rrkz,
          12101 => Opcode::VMOVUPDZ256rrkz_REV,
          12102 => Opcode::VMOVUPDZmr,
          12103 => Opcode::VMOVUPDZmrk,
          12104 => Opcode::VMOVUPDZrm,
          12105 => Opcode::VMOVUPDZrmk,
          12106 => Opcode::VMOVUPDZrmkz,
          12107 => Opcode::VMOVUPDZrr,
          12108 => Opcode::VMOVUPDZrr_REV,
          12109 => Opcode::VMOVUPDZrrk,
          12110 => Opcode::VMOVUPDZrrk_REV,
          12111 => Opcode::VMOVUPDZrrkz,
          12112 => Opcode::VMOVUPDZrrkz_REV,
          12113 => Opcode::VMOVUPDmr,
          12114 => Opcode::VMOVUPDrm,
          12115 => Opcode::VMOVUPDrr,
          12116 => Opcode::VMOVUPDrr_REV,
          12117 => Opcode::VMOVUPSYmr,
          12118 => Opcode::VMOVUPSYrm,
          12119 => Opcode::VMOVUPSYrr,
          12120 => Opcode::VMOVUPSYrr_REV,
          12121 => Opcode::VMOVUPSZ128mr,
          12122 => Opcode::VMOVUPSZ128mrk,
          12123 => Opcode::VMOVUPSZ128rm,
          12124 => Opcode::VMOVUPSZ128rmk,
          12125 => Opcode::VMOVUPSZ128rmkz,
          12126 => Opcode::VMOVUPSZ128rr,
          12127 => Opcode::VMOVUPSZ128rr_REV,
          12128 => Opcode::VMOVUPSZ128rrk,
          12129 => Opcode::VMOVUPSZ128rrk_REV,
          12130 => Opcode::VMOVUPSZ128rrkz,
          12131 => Opcode::VMOVUPSZ128rrkz_REV,
          12132 => Opcode::VMOVUPSZ256mr,
          12133 => Opcode::VMOVUPSZ256mrk,
          12134 => Opcode::VMOVUPSZ256rm,
          12135 => Opcode::VMOVUPSZ256rmk,
          12136 => Opcode::VMOVUPSZ256rmkz,
          12137 => Opcode::VMOVUPSZ256rr,
          12138 => Opcode::VMOVUPSZ256rr_REV,
          12139 => Opcode::VMOVUPSZ256rrk,
          12140 => Opcode::VMOVUPSZ256rrk_REV,
          12141 => Opcode::VMOVUPSZ256rrkz,
          12142 => Opcode::VMOVUPSZ256rrkz_REV,
          12143 => Opcode::VMOVUPSZmr,
          12144 => Opcode::VMOVUPSZmrk,
          12145 => Opcode::VMOVUPSZrm,
          12146 => Opcode::VMOVUPSZrmk,
          12147 => Opcode::VMOVUPSZrmkz,
          12148 => Opcode::VMOVUPSZrr,
          12149 => Opcode::VMOVUPSZrr_REV,
          12150 => Opcode::VMOVUPSZrrk,
          12151 => Opcode::VMOVUPSZrrk_REV,
          12152 => Opcode::VMOVUPSZrrkz,
          12153 => Opcode::VMOVUPSZrrkz_REV,
          12154 => Opcode::VMOVUPSmr,
          12155 => Opcode::VMOVUPSrm,
          12156 => Opcode::VMOVUPSrr,
          12157 => Opcode::VMOVUPSrr_REV,
          12158 => Opcode::VMOVW2SHrr,
          12159 => Opcode::VMOVW64toSHrr,
          12160 => Opcode::VMOVWmr,
          12161 => Opcode::VMOVWrm,
          12162 => Opcode::VMOVZPQILo2PQIZrr,
          12163 => Opcode::VMOVZPQILo2PQIrr,
          12164 => Opcode::VMPSADBWYrmi,
          12165 => Opcode::VMPSADBWYrri,
          12166 => Opcode::VMPSADBWrmi,
          12167 => Opcode::VMPSADBWrri,
          12168 => Opcode::VMPTRLDm,
          12169 => Opcode::VMPTRSTm,
          12170 => Opcode::VMREAD32mr,
          12171 => Opcode::VMREAD32rr,
          12172 => Opcode::VMREAD64mr,
          12173 => Opcode::VMREAD64rr,
          12174 => Opcode::VMRESUME,
          12175 => Opcode::VMRUN32,
          12176 => Opcode::VMRUN64,
          12177 => Opcode::VMSAVE32,
          12178 => Opcode::VMSAVE64,
          12179 => Opcode::VMULPDYrm,
          12180 => Opcode::VMULPDYrr,
          12181 => Opcode::VMULPDZ128rm,
          12182 => Opcode::VMULPDZ128rmb,
          12183 => Opcode::VMULPDZ128rmbk,
          12184 => Opcode::VMULPDZ128rmbkz,
          12185 => Opcode::VMULPDZ128rmk,
          12186 => Opcode::VMULPDZ128rmkz,
          12187 => Opcode::VMULPDZ128rr,
          12188 => Opcode::VMULPDZ128rrk,
          12189 => Opcode::VMULPDZ128rrkz,
          12190 => Opcode::VMULPDZ256rm,
          12191 => Opcode::VMULPDZ256rmb,
          12192 => Opcode::VMULPDZ256rmbk,
          12193 => Opcode::VMULPDZ256rmbkz,
          12194 => Opcode::VMULPDZ256rmk,
          12195 => Opcode::VMULPDZ256rmkz,
          12196 => Opcode::VMULPDZ256rr,
          12197 => Opcode::VMULPDZ256rrk,
          12198 => Opcode::VMULPDZ256rrkz,
          12199 => Opcode::VMULPDZrm,
          12200 => Opcode::VMULPDZrmb,
          12201 => Opcode::VMULPDZrmbk,
          12202 => Opcode::VMULPDZrmbkz,
          12203 => Opcode::VMULPDZrmk,
          12204 => Opcode::VMULPDZrmkz,
          12205 => Opcode::VMULPDZrr,
          12206 => Opcode::VMULPDZrrb,
          12207 => Opcode::VMULPDZrrbk,
          12208 => Opcode::VMULPDZrrbkz,
          12209 => Opcode::VMULPDZrrk,
          12210 => Opcode::VMULPDZrrkz,
          12211 => Opcode::VMULPDrm,
          12212 => Opcode::VMULPDrr,
          12213 => Opcode::VMULPHZ128rm,
          12214 => Opcode::VMULPHZ128rmb,
          12215 => Opcode::VMULPHZ128rmbk,
          12216 => Opcode::VMULPHZ128rmbkz,
          12217 => Opcode::VMULPHZ128rmk,
          12218 => Opcode::VMULPHZ128rmkz,
          12219 => Opcode::VMULPHZ128rr,
          12220 => Opcode::VMULPHZ128rrk,
          12221 => Opcode::VMULPHZ128rrkz,
          12222 => Opcode::VMULPHZ256rm,
          12223 => Opcode::VMULPHZ256rmb,
          12224 => Opcode::VMULPHZ256rmbk,
          12225 => Opcode::VMULPHZ256rmbkz,
          12226 => Opcode::VMULPHZ256rmk,
          12227 => Opcode::VMULPHZ256rmkz,
          12228 => Opcode::VMULPHZ256rr,
          12229 => Opcode::VMULPHZ256rrk,
          12230 => Opcode::VMULPHZ256rrkz,
          12231 => Opcode::VMULPHZrm,
          12232 => Opcode::VMULPHZrmb,
          12233 => Opcode::VMULPHZrmbk,
          12234 => Opcode::VMULPHZrmbkz,
          12235 => Opcode::VMULPHZrmk,
          12236 => Opcode::VMULPHZrmkz,
          12237 => Opcode::VMULPHZrr,
          12238 => Opcode::VMULPHZrrb,
          12239 => Opcode::VMULPHZrrbk,
          12240 => Opcode::VMULPHZrrbkz,
          12241 => Opcode::VMULPHZrrk,
          12242 => Opcode::VMULPHZrrkz,
          12243 => Opcode::VMULPSYrm,
          12244 => Opcode::VMULPSYrr,
          12245 => Opcode::VMULPSZ128rm,
          12246 => Opcode::VMULPSZ128rmb,
          12247 => Opcode::VMULPSZ128rmbk,
          12248 => Opcode::VMULPSZ128rmbkz,
          12249 => Opcode::VMULPSZ128rmk,
          12250 => Opcode::VMULPSZ128rmkz,
          12251 => Opcode::VMULPSZ128rr,
          12252 => Opcode::VMULPSZ128rrk,
          12253 => Opcode::VMULPSZ128rrkz,
          12254 => Opcode::VMULPSZ256rm,
          12255 => Opcode::VMULPSZ256rmb,
          12256 => Opcode::VMULPSZ256rmbk,
          12257 => Opcode::VMULPSZ256rmbkz,
          12258 => Opcode::VMULPSZ256rmk,
          12259 => Opcode::VMULPSZ256rmkz,
          12260 => Opcode::VMULPSZ256rr,
          12261 => Opcode::VMULPSZ256rrk,
          12262 => Opcode::VMULPSZ256rrkz,
          12263 => Opcode::VMULPSZrm,
          12264 => Opcode::VMULPSZrmb,
          12265 => Opcode::VMULPSZrmbk,
          12266 => Opcode::VMULPSZrmbkz,
          12267 => Opcode::VMULPSZrmk,
          12268 => Opcode::VMULPSZrmkz,
          12269 => Opcode::VMULPSZrr,
          12270 => Opcode::VMULPSZrrb,
          12271 => Opcode::VMULPSZrrbk,
          12272 => Opcode::VMULPSZrrbkz,
          12273 => Opcode::VMULPSZrrk,
          12274 => Opcode::VMULPSZrrkz,
          12275 => Opcode::VMULPSrm,
          12276 => Opcode::VMULPSrr,
          12277 => Opcode::VMULSDZrm,
          12278 => Opcode::VMULSDZrm_Int,
          12279 => Opcode::VMULSDZrm_Intk,
          12280 => Opcode::VMULSDZrm_Intkz,
          12281 => Opcode::VMULSDZrr,
          12282 => Opcode::VMULSDZrr_Int,
          12283 => Opcode::VMULSDZrr_Intk,
          12284 => Opcode::VMULSDZrr_Intkz,
          12285 => Opcode::VMULSDZrrb_Int,
          12286 => Opcode::VMULSDZrrb_Intk,
          12287 => Opcode::VMULSDZrrb_Intkz,
          12288 => Opcode::VMULSDrm,
          12289 => Opcode::VMULSDrm_Int,
          12290 => Opcode::VMULSDrr,
          12291 => Opcode::VMULSDrr_Int,
          12292 => Opcode::VMULSHZrm,
          12293 => Opcode::VMULSHZrm_Int,
          12294 => Opcode::VMULSHZrm_Intk,
          12295 => Opcode::VMULSHZrm_Intkz,
          12296 => Opcode::VMULSHZrr,
          12297 => Opcode::VMULSHZrr_Int,
          12298 => Opcode::VMULSHZrr_Intk,
          12299 => Opcode::VMULSHZrr_Intkz,
          12300 => Opcode::VMULSHZrrb_Int,
          12301 => Opcode::VMULSHZrrb_Intk,
          12302 => Opcode::VMULSHZrrb_Intkz,
          12303 => Opcode::VMULSSZrm,
          12304 => Opcode::VMULSSZrm_Int,
          12305 => Opcode::VMULSSZrm_Intk,
          12306 => Opcode::VMULSSZrm_Intkz,
          12307 => Opcode::VMULSSZrr,
          12308 => Opcode::VMULSSZrr_Int,
          12309 => Opcode::VMULSSZrr_Intk,
          12310 => Opcode::VMULSSZrr_Intkz,
          12311 => Opcode::VMULSSZrrb_Int,
          12312 => Opcode::VMULSSZrrb_Intk,
          12313 => Opcode::VMULSSZrrb_Intkz,
          12314 => Opcode::VMULSSrm,
          12315 => Opcode::VMULSSrm_Int,
          12316 => Opcode::VMULSSrr,
          12317 => Opcode::VMULSSrr_Int,
          12318 => Opcode::VMWRITE32rm,
          12319 => Opcode::VMWRITE32rr,
          12320 => Opcode::VMWRITE64rm,
          12321 => Opcode::VMWRITE64rr,
          12322 => Opcode::VMXOFF,
          12323 => Opcode::VMXON,
          12324 => Opcode::VORPDYrm,
          12325 => Opcode::VORPDYrr,
          12326 => Opcode::VORPDZ128rm,
          12327 => Opcode::VORPDZ128rmb,
          12328 => Opcode::VORPDZ128rmbk,
          12329 => Opcode::VORPDZ128rmbkz,
          12330 => Opcode::VORPDZ128rmk,
          12331 => Opcode::VORPDZ128rmkz,
          12332 => Opcode::VORPDZ128rr,
          12333 => Opcode::VORPDZ128rrk,
          12334 => Opcode::VORPDZ128rrkz,
          12335 => Opcode::VORPDZ256rm,
          12336 => Opcode::VORPDZ256rmb,
          12337 => Opcode::VORPDZ256rmbk,
          12338 => Opcode::VORPDZ256rmbkz,
          12339 => Opcode::VORPDZ256rmk,
          12340 => Opcode::VORPDZ256rmkz,
          12341 => Opcode::VORPDZ256rr,
          12342 => Opcode::VORPDZ256rrk,
          12343 => Opcode::VORPDZ256rrkz,
          12344 => Opcode::VORPDZrm,
          12345 => Opcode::VORPDZrmb,
          12346 => Opcode::VORPDZrmbk,
          12347 => Opcode::VORPDZrmbkz,
          12348 => Opcode::VORPDZrmk,
          12349 => Opcode::VORPDZrmkz,
          12350 => Opcode::VORPDZrr,
          12351 => Opcode::VORPDZrrk,
          12352 => Opcode::VORPDZrrkz,
          12353 => Opcode::VORPDrm,
          12354 => Opcode::VORPDrr,
          12355 => Opcode::VORPSYrm,
          12356 => Opcode::VORPSYrr,
          12357 => Opcode::VORPSZ128rm,
          12358 => Opcode::VORPSZ128rmb,
          12359 => Opcode::VORPSZ128rmbk,
          12360 => Opcode::VORPSZ128rmbkz,
          12361 => Opcode::VORPSZ128rmk,
          12362 => Opcode::VORPSZ128rmkz,
          12363 => Opcode::VORPSZ128rr,
          12364 => Opcode::VORPSZ128rrk,
          12365 => Opcode::VORPSZ128rrkz,
          12366 => Opcode::VORPSZ256rm,
          12367 => Opcode::VORPSZ256rmb,
          12368 => Opcode::VORPSZ256rmbk,
          12369 => Opcode::VORPSZ256rmbkz,
          12370 => Opcode::VORPSZ256rmk,
          12371 => Opcode::VORPSZ256rmkz,
          12372 => Opcode::VORPSZ256rr,
          12373 => Opcode::VORPSZ256rrk,
          12374 => Opcode::VORPSZ256rrkz,
          12375 => Opcode::VORPSZrm,
          12376 => Opcode::VORPSZrmb,
          12377 => Opcode::VORPSZrmbk,
          12378 => Opcode::VORPSZrmbkz,
          12379 => Opcode::VORPSZrmk,
          12380 => Opcode::VORPSZrmkz,
          12381 => Opcode::VORPSZrr,
          12382 => Opcode::VORPSZrrk,
          12383 => Opcode::VORPSZrrkz,
          12384 => Opcode::VORPSrm,
          12385 => Opcode::VORPSrr,
          12386 => Opcode::VP2INTERSECTDZ128rm,
          12387 => Opcode::VP2INTERSECTDZ128rmb,
          12388 => Opcode::VP2INTERSECTDZ128rr,
          12389 => Opcode::VP2INTERSECTDZ256rm,
          12390 => Opcode::VP2INTERSECTDZ256rmb,
          12391 => Opcode::VP2INTERSECTDZ256rr,
          12392 => Opcode::VP2INTERSECTDZrm,
          12393 => Opcode::VP2INTERSECTDZrmb,
          12394 => Opcode::VP2INTERSECTDZrr,
          12395 => Opcode::VP2INTERSECTQZ128rm,
          12396 => Opcode::VP2INTERSECTQZ128rmb,
          12397 => Opcode::VP2INTERSECTQZ128rr,
          12398 => Opcode::VP2INTERSECTQZ256rm,
          12399 => Opcode::VP2INTERSECTQZ256rmb,
          12400 => Opcode::VP2INTERSECTQZ256rr,
          12401 => Opcode::VP2INTERSECTQZrm,
          12402 => Opcode::VP2INTERSECTQZrmb,
          12403 => Opcode::VP2INTERSECTQZrr,
          12404 => Opcode::VP4DPWSSDSrm,
          12405 => Opcode::VP4DPWSSDSrmk,
          12406 => Opcode::VP4DPWSSDSrmkz,
          12407 => Opcode::VP4DPWSSDrm,
          12408 => Opcode::VP4DPWSSDrmk,
          12409 => Opcode::VP4DPWSSDrmkz,
          12410 => Opcode::VPABSBYrm,
          12411 => Opcode::VPABSBYrr,
          12412 => Opcode::VPABSBZ128rm,
          12413 => Opcode::VPABSBZ128rmk,
          12414 => Opcode::VPABSBZ128rmkz,
          12415 => Opcode::VPABSBZ128rr,
          12416 => Opcode::VPABSBZ128rrk,
          12417 => Opcode::VPABSBZ128rrkz,
          12418 => Opcode::VPABSBZ256rm,
          12419 => Opcode::VPABSBZ256rmk,
          12420 => Opcode::VPABSBZ256rmkz,
          12421 => Opcode::VPABSBZ256rr,
          12422 => Opcode::VPABSBZ256rrk,
          12423 => Opcode::VPABSBZ256rrkz,
          12424 => Opcode::VPABSBZrm,
          12425 => Opcode::VPABSBZrmk,
          12426 => Opcode::VPABSBZrmkz,
          12427 => Opcode::VPABSBZrr,
          12428 => Opcode::VPABSBZrrk,
          12429 => Opcode::VPABSBZrrkz,
          12430 => Opcode::VPABSBrm,
          12431 => Opcode::VPABSBrr,
          12432 => Opcode::VPABSDYrm,
          12433 => Opcode::VPABSDYrr,
          12434 => Opcode::VPABSDZ128rm,
          12435 => Opcode::VPABSDZ128rmb,
          12436 => Opcode::VPABSDZ128rmbk,
          12437 => Opcode::VPABSDZ128rmbkz,
          12438 => Opcode::VPABSDZ128rmk,
          12439 => Opcode::VPABSDZ128rmkz,
          12440 => Opcode::VPABSDZ128rr,
          12441 => Opcode::VPABSDZ128rrk,
          12442 => Opcode::VPABSDZ128rrkz,
          12443 => Opcode::VPABSDZ256rm,
          12444 => Opcode::VPABSDZ256rmb,
          12445 => Opcode::VPABSDZ256rmbk,
          12446 => Opcode::VPABSDZ256rmbkz,
          12447 => Opcode::VPABSDZ256rmk,
          12448 => Opcode::VPABSDZ256rmkz,
          12449 => Opcode::VPABSDZ256rr,
          12450 => Opcode::VPABSDZ256rrk,
          12451 => Opcode::VPABSDZ256rrkz,
          12452 => Opcode::VPABSDZrm,
          12453 => Opcode::VPABSDZrmb,
          12454 => Opcode::VPABSDZrmbk,
          12455 => Opcode::VPABSDZrmbkz,
          12456 => Opcode::VPABSDZrmk,
          12457 => Opcode::VPABSDZrmkz,
          12458 => Opcode::VPABSDZrr,
          12459 => Opcode::VPABSDZrrk,
          12460 => Opcode::VPABSDZrrkz,
          12461 => Opcode::VPABSDrm,
          12462 => Opcode::VPABSDrr,
          12463 => Opcode::VPABSQZ128rm,
          12464 => Opcode::VPABSQZ128rmb,
          12465 => Opcode::VPABSQZ128rmbk,
          12466 => Opcode::VPABSQZ128rmbkz,
          12467 => Opcode::VPABSQZ128rmk,
          12468 => Opcode::VPABSQZ128rmkz,
          12469 => Opcode::VPABSQZ128rr,
          12470 => Opcode::VPABSQZ128rrk,
          12471 => Opcode::VPABSQZ128rrkz,
          12472 => Opcode::VPABSQZ256rm,
          12473 => Opcode::VPABSQZ256rmb,
          12474 => Opcode::VPABSQZ256rmbk,
          12475 => Opcode::VPABSQZ256rmbkz,
          12476 => Opcode::VPABSQZ256rmk,
          12477 => Opcode::VPABSQZ256rmkz,
          12478 => Opcode::VPABSQZ256rr,
          12479 => Opcode::VPABSQZ256rrk,
          12480 => Opcode::VPABSQZ256rrkz,
          12481 => Opcode::VPABSQZrm,
          12482 => Opcode::VPABSQZrmb,
          12483 => Opcode::VPABSQZrmbk,
          12484 => Opcode::VPABSQZrmbkz,
          12485 => Opcode::VPABSQZrmk,
          12486 => Opcode::VPABSQZrmkz,
          12487 => Opcode::VPABSQZrr,
          12488 => Opcode::VPABSQZrrk,
          12489 => Opcode::VPABSQZrrkz,
          12490 => Opcode::VPABSWYrm,
          12491 => Opcode::VPABSWYrr,
          12492 => Opcode::VPABSWZ128rm,
          12493 => Opcode::VPABSWZ128rmk,
          12494 => Opcode::VPABSWZ128rmkz,
          12495 => Opcode::VPABSWZ128rr,
          12496 => Opcode::VPABSWZ128rrk,
          12497 => Opcode::VPABSWZ128rrkz,
          12498 => Opcode::VPABSWZ256rm,
          12499 => Opcode::VPABSWZ256rmk,
          12500 => Opcode::VPABSWZ256rmkz,
          12501 => Opcode::VPABSWZ256rr,
          12502 => Opcode::VPABSWZ256rrk,
          12503 => Opcode::VPABSWZ256rrkz,
          12504 => Opcode::VPABSWZrm,
          12505 => Opcode::VPABSWZrmk,
          12506 => Opcode::VPABSWZrmkz,
          12507 => Opcode::VPABSWZrr,
          12508 => Opcode::VPABSWZrrk,
          12509 => Opcode::VPABSWZrrkz,
          12510 => Opcode::VPABSWrm,
          12511 => Opcode::VPABSWrr,
          12512 => Opcode::VPACKSSDWYrm,
          12513 => Opcode::VPACKSSDWYrr,
          12514 => Opcode::VPACKSSDWZ128rm,
          12515 => Opcode::VPACKSSDWZ128rmb,
          12516 => Opcode::VPACKSSDWZ128rmbk,
          12517 => Opcode::VPACKSSDWZ128rmbkz,
          12518 => Opcode::VPACKSSDWZ128rmk,
          12519 => Opcode::VPACKSSDWZ128rmkz,
          12520 => Opcode::VPACKSSDWZ128rr,
          12521 => Opcode::VPACKSSDWZ128rrk,
          12522 => Opcode::VPACKSSDWZ128rrkz,
          12523 => Opcode::VPACKSSDWZ256rm,
          12524 => Opcode::VPACKSSDWZ256rmb,
          12525 => Opcode::VPACKSSDWZ256rmbk,
          12526 => Opcode::VPACKSSDWZ256rmbkz,
          12527 => Opcode::VPACKSSDWZ256rmk,
          12528 => Opcode::VPACKSSDWZ256rmkz,
          12529 => Opcode::VPACKSSDWZ256rr,
          12530 => Opcode::VPACKSSDWZ256rrk,
          12531 => Opcode::VPACKSSDWZ256rrkz,
          12532 => Opcode::VPACKSSDWZrm,
          12533 => Opcode::VPACKSSDWZrmb,
          12534 => Opcode::VPACKSSDWZrmbk,
          12535 => Opcode::VPACKSSDWZrmbkz,
          12536 => Opcode::VPACKSSDWZrmk,
          12537 => Opcode::VPACKSSDWZrmkz,
          12538 => Opcode::VPACKSSDWZrr,
          12539 => Opcode::VPACKSSDWZrrk,
          12540 => Opcode::VPACKSSDWZrrkz,
          12541 => Opcode::VPACKSSDWrm,
          12542 => Opcode::VPACKSSDWrr,
          12543 => Opcode::VPACKSSWBYrm,
          12544 => Opcode::VPACKSSWBYrr,
          12545 => Opcode::VPACKSSWBZ128rm,
          12546 => Opcode::VPACKSSWBZ128rmk,
          12547 => Opcode::VPACKSSWBZ128rmkz,
          12548 => Opcode::VPACKSSWBZ128rr,
          12549 => Opcode::VPACKSSWBZ128rrk,
          12550 => Opcode::VPACKSSWBZ128rrkz,
          12551 => Opcode::VPACKSSWBZ256rm,
          12552 => Opcode::VPACKSSWBZ256rmk,
          12553 => Opcode::VPACKSSWBZ256rmkz,
          12554 => Opcode::VPACKSSWBZ256rr,
          12555 => Opcode::VPACKSSWBZ256rrk,
          12556 => Opcode::VPACKSSWBZ256rrkz,
          12557 => Opcode::VPACKSSWBZrm,
          12558 => Opcode::VPACKSSWBZrmk,
          12559 => Opcode::VPACKSSWBZrmkz,
          12560 => Opcode::VPACKSSWBZrr,
          12561 => Opcode::VPACKSSWBZrrk,
          12562 => Opcode::VPACKSSWBZrrkz,
          12563 => Opcode::VPACKSSWBrm,
          12564 => Opcode::VPACKSSWBrr,
          12565 => Opcode::VPACKUSDWYrm,
          12566 => Opcode::VPACKUSDWYrr,
          12567 => Opcode::VPACKUSDWZ128rm,
          12568 => Opcode::VPACKUSDWZ128rmb,
          12569 => Opcode::VPACKUSDWZ128rmbk,
          12570 => Opcode::VPACKUSDWZ128rmbkz,
          12571 => Opcode::VPACKUSDWZ128rmk,
          12572 => Opcode::VPACKUSDWZ128rmkz,
          12573 => Opcode::VPACKUSDWZ128rr,
          12574 => Opcode::VPACKUSDWZ128rrk,
          12575 => Opcode::VPACKUSDWZ128rrkz,
          12576 => Opcode::VPACKUSDWZ256rm,
          12577 => Opcode::VPACKUSDWZ256rmb,
          12578 => Opcode::VPACKUSDWZ256rmbk,
          12579 => Opcode::VPACKUSDWZ256rmbkz,
          12580 => Opcode::VPACKUSDWZ256rmk,
          12581 => Opcode::VPACKUSDWZ256rmkz,
          12582 => Opcode::VPACKUSDWZ256rr,
          12583 => Opcode::VPACKUSDWZ256rrk,
          12584 => Opcode::VPACKUSDWZ256rrkz,
          12585 => Opcode::VPACKUSDWZrm,
          12586 => Opcode::VPACKUSDWZrmb,
          12587 => Opcode::VPACKUSDWZrmbk,
          12588 => Opcode::VPACKUSDWZrmbkz,
          12589 => Opcode::VPACKUSDWZrmk,
          12590 => Opcode::VPACKUSDWZrmkz,
          12591 => Opcode::VPACKUSDWZrr,
          12592 => Opcode::VPACKUSDWZrrk,
          12593 => Opcode::VPACKUSDWZrrkz,
          12594 => Opcode::VPACKUSDWrm,
          12595 => Opcode::VPACKUSDWrr,
          12596 => Opcode::VPACKUSWBYrm,
          12597 => Opcode::VPACKUSWBYrr,
          12598 => Opcode::VPACKUSWBZ128rm,
          12599 => Opcode::VPACKUSWBZ128rmk,
          12600 => Opcode::VPACKUSWBZ128rmkz,
          12601 => Opcode::VPACKUSWBZ128rr,
          12602 => Opcode::VPACKUSWBZ128rrk,
          12603 => Opcode::VPACKUSWBZ128rrkz,
          12604 => Opcode::VPACKUSWBZ256rm,
          12605 => Opcode::VPACKUSWBZ256rmk,
          12606 => Opcode::VPACKUSWBZ256rmkz,
          12607 => Opcode::VPACKUSWBZ256rr,
          12608 => Opcode::VPACKUSWBZ256rrk,
          12609 => Opcode::VPACKUSWBZ256rrkz,
          12610 => Opcode::VPACKUSWBZrm,
          12611 => Opcode::VPACKUSWBZrmk,
          12612 => Opcode::VPACKUSWBZrmkz,
          12613 => Opcode::VPACKUSWBZrr,
          12614 => Opcode::VPACKUSWBZrrk,
          12615 => Opcode::VPACKUSWBZrrkz,
          12616 => Opcode::VPACKUSWBrm,
          12617 => Opcode::VPACKUSWBrr,
          12618 => Opcode::VPADDBYrm,
          12619 => Opcode::VPADDBYrr,
          12620 => Opcode::VPADDBZ128rm,
          12621 => Opcode::VPADDBZ128rmk,
          12622 => Opcode::VPADDBZ128rmkz,
          12623 => Opcode::VPADDBZ128rr,
          12624 => Opcode::VPADDBZ128rrk,
          12625 => Opcode::VPADDBZ128rrkz,
          12626 => Opcode::VPADDBZ256rm,
          12627 => Opcode::VPADDBZ256rmk,
          12628 => Opcode::VPADDBZ256rmkz,
          12629 => Opcode::VPADDBZ256rr,
          12630 => Opcode::VPADDBZ256rrk,
          12631 => Opcode::VPADDBZ256rrkz,
          12632 => Opcode::VPADDBZrm,
          12633 => Opcode::VPADDBZrmk,
          12634 => Opcode::VPADDBZrmkz,
          12635 => Opcode::VPADDBZrr,
          12636 => Opcode::VPADDBZrrk,
          12637 => Opcode::VPADDBZrrkz,
          12638 => Opcode::VPADDBrm,
          12639 => Opcode::VPADDBrr,
          12640 => Opcode::VPADDDYrm,
          12641 => Opcode::VPADDDYrr,
          12642 => Opcode::VPADDDZ128rm,
          12643 => Opcode::VPADDDZ128rmb,
          12644 => Opcode::VPADDDZ128rmbk,
          12645 => Opcode::VPADDDZ128rmbkz,
          12646 => Opcode::VPADDDZ128rmk,
          12647 => Opcode::VPADDDZ128rmkz,
          12648 => Opcode::VPADDDZ128rr,
          12649 => Opcode::VPADDDZ128rrk,
          12650 => Opcode::VPADDDZ128rrkz,
          12651 => Opcode::VPADDDZ256rm,
          12652 => Opcode::VPADDDZ256rmb,
          12653 => Opcode::VPADDDZ256rmbk,
          12654 => Opcode::VPADDDZ256rmbkz,
          12655 => Opcode::VPADDDZ256rmk,
          12656 => Opcode::VPADDDZ256rmkz,
          12657 => Opcode::VPADDDZ256rr,
          12658 => Opcode::VPADDDZ256rrk,
          12659 => Opcode::VPADDDZ256rrkz,
          12660 => Opcode::VPADDDZrm,
          12661 => Opcode::VPADDDZrmb,
          12662 => Opcode::VPADDDZrmbk,
          12663 => Opcode::VPADDDZrmbkz,
          12664 => Opcode::VPADDDZrmk,
          12665 => Opcode::VPADDDZrmkz,
          12666 => Opcode::VPADDDZrr,
          12667 => Opcode::VPADDDZrrk,
          12668 => Opcode::VPADDDZrrkz,
          12669 => Opcode::VPADDDrm,
          12670 => Opcode::VPADDDrr,
          12671 => Opcode::VPADDQYrm,
          12672 => Opcode::VPADDQYrr,
          12673 => Opcode::VPADDQZ128rm,
          12674 => Opcode::VPADDQZ128rmb,
          12675 => Opcode::VPADDQZ128rmbk,
          12676 => Opcode::VPADDQZ128rmbkz,
          12677 => Opcode::VPADDQZ128rmk,
          12678 => Opcode::VPADDQZ128rmkz,
          12679 => Opcode::VPADDQZ128rr,
          12680 => Opcode::VPADDQZ128rrk,
          12681 => Opcode::VPADDQZ128rrkz,
          12682 => Opcode::VPADDQZ256rm,
          12683 => Opcode::VPADDQZ256rmb,
          12684 => Opcode::VPADDQZ256rmbk,
          12685 => Opcode::VPADDQZ256rmbkz,
          12686 => Opcode::VPADDQZ256rmk,
          12687 => Opcode::VPADDQZ256rmkz,
          12688 => Opcode::VPADDQZ256rr,
          12689 => Opcode::VPADDQZ256rrk,
          12690 => Opcode::VPADDQZ256rrkz,
          12691 => Opcode::VPADDQZrm,
          12692 => Opcode::VPADDQZrmb,
          12693 => Opcode::VPADDQZrmbk,
          12694 => Opcode::VPADDQZrmbkz,
          12695 => Opcode::VPADDQZrmk,
          12696 => Opcode::VPADDQZrmkz,
          12697 => Opcode::VPADDQZrr,
          12698 => Opcode::VPADDQZrrk,
          12699 => Opcode::VPADDQZrrkz,
          12700 => Opcode::VPADDQrm,
          12701 => Opcode::VPADDQrr,
          12702 => Opcode::VPADDSBYrm,
          12703 => Opcode::VPADDSBYrr,
          12704 => Opcode::VPADDSBZ128rm,
          12705 => Opcode::VPADDSBZ128rmk,
          12706 => Opcode::VPADDSBZ128rmkz,
          12707 => Opcode::VPADDSBZ128rr,
          12708 => Opcode::VPADDSBZ128rrk,
          12709 => Opcode::VPADDSBZ128rrkz,
          12710 => Opcode::VPADDSBZ256rm,
          12711 => Opcode::VPADDSBZ256rmk,
          12712 => Opcode::VPADDSBZ256rmkz,
          12713 => Opcode::VPADDSBZ256rr,
          12714 => Opcode::VPADDSBZ256rrk,
          12715 => Opcode::VPADDSBZ256rrkz,
          12716 => Opcode::VPADDSBZrm,
          12717 => Opcode::VPADDSBZrmk,
          12718 => Opcode::VPADDSBZrmkz,
          12719 => Opcode::VPADDSBZrr,
          12720 => Opcode::VPADDSBZrrk,
          12721 => Opcode::VPADDSBZrrkz,
          12722 => Opcode::VPADDSBrm,
          12723 => Opcode::VPADDSBrr,
          12724 => Opcode::VPADDSWYrm,
          12725 => Opcode::VPADDSWYrr,
          12726 => Opcode::VPADDSWZ128rm,
          12727 => Opcode::VPADDSWZ128rmk,
          12728 => Opcode::VPADDSWZ128rmkz,
          12729 => Opcode::VPADDSWZ128rr,
          12730 => Opcode::VPADDSWZ128rrk,
          12731 => Opcode::VPADDSWZ128rrkz,
          12732 => Opcode::VPADDSWZ256rm,
          12733 => Opcode::VPADDSWZ256rmk,
          12734 => Opcode::VPADDSWZ256rmkz,
          12735 => Opcode::VPADDSWZ256rr,
          12736 => Opcode::VPADDSWZ256rrk,
          12737 => Opcode::VPADDSWZ256rrkz,
          12738 => Opcode::VPADDSWZrm,
          12739 => Opcode::VPADDSWZrmk,
          12740 => Opcode::VPADDSWZrmkz,
          12741 => Opcode::VPADDSWZrr,
          12742 => Opcode::VPADDSWZrrk,
          12743 => Opcode::VPADDSWZrrkz,
          12744 => Opcode::VPADDSWrm,
          12745 => Opcode::VPADDSWrr,
          12746 => Opcode::VPADDUSBYrm,
          12747 => Opcode::VPADDUSBYrr,
          12748 => Opcode::VPADDUSBZ128rm,
          12749 => Opcode::VPADDUSBZ128rmk,
          12750 => Opcode::VPADDUSBZ128rmkz,
          12751 => Opcode::VPADDUSBZ128rr,
          12752 => Opcode::VPADDUSBZ128rrk,
          12753 => Opcode::VPADDUSBZ128rrkz,
          12754 => Opcode::VPADDUSBZ256rm,
          12755 => Opcode::VPADDUSBZ256rmk,
          12756 => Opcode::VPADDUSBZ256rmkz,
          12757 => Opcode::VPADDUSBZ256rr,
          12758 => Opcode::VPADDUSBZ256rrk,
          12759 => Opcode::VPADDUSBZ256rrkz,
          12760 => Opcode::VPADDUSBZrm,
          12761 => Opcode::VPADDUSBZrmk,
          12762 => Opcode::VPADDUSBZrmkz,
          12763 => Opcode::VPADDUSBZrr,
          12764 => Opcode::VPADDUSBZrrk,
          12765 => Opcode::VPADDUSBZrrkz,
          12766 => Opcode::VPADDUSBrm,
          12767 => Opcode::VPADDUSBrr,
          12768 => Opcode::VPADDUSWYrm,
          12769 => Opcode::VPADDUSWYrr,
          12770 => Opcode::VPADDUSWZ128rm,
          12771 => Opcode::VPADDUSWZ128rmk,
          12772 => Opcode::VPADDUSWZ128rmkz,
          12773 => Opcode::VPADDUSWZ128rr,
          12774 => Opcode::VPADDUSWZ128rrk,
          12775 => Opcode::VPADDUSWZ128rrkz,
          12776 => Opcode::VPADDUSWZ256rm,
          12777 => Opcode::VPADDUSWZ256rmk,
          12778 => Opcode::VPADDUSWZ256rmkz,
          12779 => Opcode::VPADDUSWZ256rr,
          12780 => Opcode::VPADDUSWZ256rrk,
          12781 => Opcode::VPADDUSWZ256rrkz,
          12782 => Opcode::VPADDUSWZrm,
          12783 => Opcode::VPADDUSWZrmk,
          12784 => Opcode::VPADDUSWZrmkz,
          12785 => Opcode::VPADDUSWZrr,
          12786 => Opcode::VPADDUSWZrrk,
          12787 => Opcode::VPADDUSWZrrkz,
          12788 => Opcode::VPADDUSWrm,
          12789 => Opcode::VPADDUSWrr,
          12790 => Opcode::VPADDWYrm,
          12791 => Opcode::VPADDWYrr,
          12792 => Opcode::VPADDWZ128rm,
          12793 => Opcode::VPADDWZ128rmk,
          12794 => Opcode::VPADDWZ128rmkz,
          12795 => Opcode::VPADDWZ128rr,
          12796 => Opcode::VPADDWZ128rrk,
          12797 => Opcode::VPADDWZ128rrkz,
          12798 => Opcode::VPADDWZ256rm,
          12799 => Opcode::VPADDWZ256rmk,
          12800 => Opcode::VPADDWZ256rmkz,
          12801 => Opcode::VPADDWZ256rr,
          12802 => Opcode::VPADDWZ256rrk,
          12803 => Opcode::VPADDWZ256rrkz,
          12804 => Opcode::VPADDWZrm,
          12805 => Opcode::VPADDWZrmk,
          12806 => Opcode::VPADDWZrmkz,
          12807 => Opcode::VPADDWZrr,
          12808 => Opcode::VPADDWZrrk,
          12809 => Opcode::VPADDWZrrkz,
          12810 => Opcode::VPADDWrm,
          12811 => Opcode::VPADDWrr,
          12812 => Opcode::VPALIGNRYrmi,
          12813 => Opcode::VPALIGNRYrri,
          12814 => Opcode::VPALIGNRZ128rmi,
          12815 => Opcode::VPALIGNRZ128rmik,
          12816 => Opcode::VPALIGNRZ128rmikz,
          12817 => Opcode::VPALIGNRZ128rri,
          12818 => Opcode::VPALIGNRZ128rrik,
          12819 => Opcode::VPALIGNRZ128rrikz,
          12820 => Opcode::VPALIGNRZ256rmi,
          12821 => Opcode::VPALIGNRZ256rmik,
          12822 => Opcode::VPALIGNRZ256rmikz,
          12823 => Opcode::VPALIGNRZ256rri,
          12824 => Opcode::VPALIGNRZ256rrik,
          12825 => Opcode::VPALIGNRZ256rrikz,
          12826 => Opcode::VPALIGNRZrmi,
          12827 => Opcode::VPALIGNRZrmik,
          12828 => Opcode::VPALIGNRZrmikz,
          12829 => Opcode::VPALIGNRZrri,
          12830 => Opcode::VPALIGNRZrrik,
          12831 => Opcode::VPALIGNRZrrikz,
          12832 => Opcode::VPALIGNRrmi,
          12833 => Opcode::VPALIGNRrri,
          12834 => Opcode::VPANDDZ128rm,
          12835 => Opcode::VPANDDZ128rmb,
          12836 => Opcode::VPANDDZ128rmbk,
          12837 => Opcode::VPANDDZ128rmbkz,
          12838 => Opcode::VPANDDZ128rmk,
          12839 => Opcode::VPANDDZ128rmkz,
          12840 => Opcode::VPANDDZ128rr,
          12841 => Opcode::VPANDDZ128rrk,
          12842 => Opcode::VPANDDZ128rrkz,
          12843 => Opcode::VPANDDZ256rm,
          12844 => Opcode::VPANDDZ256rmb,
          12845 => Opcode::VPANDDZ256rmbk,
          12846 => Opcode::VPANDDZ256rmbkz,
          12847 => Opcode::VPANDDZ256rmk,
          12848 => Opcode::VPANDDZ256rmkz,
          12849 => Opcode::VPANDDZ256rr,
          12850 => Opcode::VPANDDZ256rrk,
          12851 => Opcode::VPANDDZ256rrkz,
          12852 => Opcode::VPANDDZrm,
          12853 => Opcode::VPANDDZrmb,
          12854 => Opcode::VPANDDZrmbk,
          12855 => Opcode::VPANDDZrmbkz,
          12856 => Opcode::VPANDDZrmk,
          12857 => Opcode::VPANDDZrmkz,
          12858 => Opcode::VPANDDZrr,
          12859 => Opcode::VPANDDZrrk,
          12860 => Opcode::VPANDDZrrkz,
          12861 => Opcode::VPANDNDZ128rm,
          12862 => Opcode::VPANDNDZ128rmb,
          12863 => Opcode::VPANDNDZ128rmbk,
          12864 => Opcode::VPANDNDZ128rmbkz,
          12865 => Opcode::VPANDNDZ128rmk,
          12866 => Opcode::VPANDNDZ128rmkz,
          12867 => Opcode::VPANDNDZ128rr,
          12868 => Opcode::VPANDNDZ128rrk,
          12869 => Opcode::VPANDNDZ128rrkz,
          12870 => Opcode::VPANDNDZ256rm,
          12871 => Opcode::VPANDNDZ256rmb,
          12872 => Opcode::VPANDNDZ256rmbk,
          12873 => Opcode::VPANDNDZ256rmbkz,
          12874 => Opcode::VPANDNDZ256rmk,
          12875 => Opcode::VPANDNDZ256rmkz,
          12876 => Opcode::VPANDNDZ256rr,
          12877 => Opcode::VPANDNDZ256rrk,
          12878 => Opcode::VPANDNDZ256rrkz,
          12879 => Opcode::VPANDNDZrm,
          12880 => Opcode::VPANDNDZrmb,
          12881 => Opcode::VPANDNDZrmbk,
          12882 => Opcode::VPANDNDZrmbkz,
          12883 => Opcode::VPANDNDZrmk,
          12884 => Opcode::VPANDNDZrmkz,
          12885 => Opcode::VPANDNDZrr,
          12886 => Opcode::VPANDNDZrrk,
          12887 => Opcode::VPANDNDZrrkz,
          12888 => Opcode::VPANDNQZ128rm,
          12889 => Opcode::VPANDNQZ128rmb,
          12890 => Opcode::VPANDNQZ128rmbk,
          12891 => Opcode::VPANDNQZ128rmbkz,
          12892 => Opcode::VPANDNQZ128rmk,
          12893 => Opcode::VPANDNQZ128rmkz,
          12894 => Opcode::VPANDNQZ128rr,
          12895 => Opcode::VPANDNQZ128rrk,
          12896 => Opcode::VPANDNQZ128rrkz,
          12897 => Opcode::VPANDNQZ256rm,
          12898 => Opcode::VPANDNQZ256rmb,
          12899 => Opcode::VPANDNQZ256rmbk,
          12900 => Opcode::VPANDNQZ256rmbkz,
          12901 => Opcode::VPANDNQZ256rmk,
          12902 => Opcode::VPANDNQZ256rmkz,
          12903 => Opcode::VPANDNQZ256rr,
          12904 => Opcode::VPANDNQZ256rrk,
          12905 => Opcode::VPANDNQZ256rrkz,
          12906 => Opcode::VPANDNQZrm,
          12907 => Opcode::VPANDNQZrmb,
          12908 => Opcode::VPANDNQZrmbk,
          12909 => Opcode::VPANDNQZrmbkz,
          12910 => Opcode::VPANDNQZrmk,
          12911 => Opcode::VPANDNQZrmkz,
          12912 => Opcode::VPANDNQZrr,
          12913 => Opcode::VPANDNQZrrk,
          12914 => Opcode::VPANDNQZrrkz,
          12915 => Opcode::VPANDNYrm,
          12916 => Opcode::VPANDNYrr,
          12917 => Opcode::VPANDNrm,
          12918 => Opcode::VPANDNrr,
          12919 => Opcode::VPANDQZ128rm,
          12920 => Opcode::VPANDQZ128rmb,
          12921 => Opcode::VPANDQZ128rmbk,
          12922 => Opcode::VPANDQZ128rmbkz,
          12923 => Opcode::VPANDQZ128rmk,
          12924 => Opcode::VPANDQZ128rmkz,
          12925 => Opcode::VPANDQZ128rr,
          12926 => Opcode::VPANDQZ128rrk,
          12927 => Opcode::VPANDQZ128rrkz,
          12928 => Opcode::VPANDQZ256rm,
          12929 => Opcode::VPANDQZ256rmb,
          12930 => Opcode::VPANDQZ256rmbk,
          12931 => Opcode::VPANDQZ256rmbkz,
          12932 => Opcode::VPANDQZ256rmk,
          12933 => Opcode::VPANDQZ256rmkz,
          12934 => Opcode::VPANDQZ256rr,
          12935 => Opcode::VPANDQZ256rrk,
          12936 => Opcode::VPANDQZ256rrkz,
          12937 => Opcode::VPANDQZrm,
          12938 => Opcode::VPANDQZrmb,
          12939 => Opcode::VPANDQZrmbk,
          12940 => Opcode::VPANDQZrmbkz,
          12941 => Opcode::VPANDQZrmk,
          12942 => Opcode::VPANDQZrmkz,
          12943 => Opcode::VPANDQZrr,
          12944 => Opcode::VPANDQZrrk,
          12945 => Opcode::VPANDQZrrkz,
          12946 => Opcode::VPANDYrm,
          12947 => Opcode::VPANDYrr,
          12948 => Opcode::VPANDrm,
          12949 => Opcode::VPANDrr,
          12950 => Opcode::VPAVGBYrm,
          12951 => Opcode::VPAVGBYrr,
          12952 => Opcode::VPAVGBZ128rm,
          12953 => Opcode::VPAVGBZ128rmk,
          12954 => Opcode::VPAVGBZ128rmkz,
          12955 => Opcode::VPAVGBZ128rr,
          12956 => Opcode::VPAVGBZ128rrk,
          12957 => Opcode::VPAVGBZ128rrkz,
          12958 => Opcode::VPAVGBZ256rm,
          12959 => Opcode::VPAVGBZ256rmk,
          12960 => Opcode::VPAVGBZ256rmkz,
          12961 => Opcode::VPAVGBZ256rr,
          12962 => Opcode::VPAVGBZ256rrk,
          12963 => Opcode::VPAVGBZ256rrkz,
          12964 => Opcode::VPAVGBZrm,
          12965 => Opcode::VPAVGBZrmk,
          12966 => Opcode::VPAVGBZrmkz,
          12967 => Opcode::VPAVGBZrr,
          12968 => Opcode::VPAVGBZrrk,
          12969 => Opcode::VPAVGBZrrkz,
          12970 => Opcode::VPAVGBrm,
          12971 => Opcode::VPAVGBrr,
          12972 => Opcode::VPAVGWYrm,
          12973 => Opcode::VPAVGWYrr,
          12974 => Opcode::VPAVGWZ128rm,
          12975 => Opcode::VPAVGWZ128rmk,
          12976 => Opcode::VPAVGWZ128rmkz,
          12977 => Opcode::VPAVGWZ128rr,
          12978 => Opcode::VPAVGWZ128rrk,
          12979 => Opcode::VPAVGWZ128rrkz,
          12980 => Opcode::VPAVGWZ256rm,
          12981 => Opcode::VPAVGWZ256rmk,
          12982 => Opcode::VPAVGWZ256rmkz,
          12983 => Opcode::VPAVGWZ256rr,
          12984 => Opcode::VPAVGWZ256rrk,
          12985 => Opcode::VPAVGWZ256rrkz,
          12986 => Opcode::VPAVGWZrm,
          12987 => Opcode::VPAVGWZrmk,
          12988 => Opcode::VPAVGWZrmkz,
          12989 => Opcode::VPAVGWZrr,
          12990 => Opcode::VPAVGWZrrk,
          12991 => Opcode::VPAVGWZrrkz,
          12992 => Opcode::VPAVGWrm,
          12993 => Opcode::VPAVGWrr,
          12994 => Opcode::VPBLENDDYrmi,
          12995 => Opcode::VPBLENDDYrri,
          12996 => Opcode::VPBLENDDrmi,
          12997 => Opcode::VPBLENDDrri,
          12998 => Opcode::VPBLENDMBZ128rm,
          12999 => Opcode::VPBLENDMBZ128rmk,
          13000 => Opcode::VPBLENDMBZ128rmkz,
          13001 => Opcode::VPBLENDMBZ128rr,
          13002 => Opcode::VPBLENDMBZ128rrk,
          13003 => Opcode::VPBLENDMBZ128rrkz,
          13004 => Opcode::VPBLENDMBZ256rm,
          13005 => Opcode::VPBLENDMBZ256rmk,
          13006 => Opcode::VPBLENDMBZ256rmkz,
          13007 => Opcode::VPBLENDMBZ256rr,
          13008 => Opcode::VPBLENDMBZ256rrk,
          13009 => Opcode::VPBLENDMBZ256rrkz,
          13010 => Opcode::VPBLENDMBZrm,
          13011 => Opcode::VPBLENDMBZrmk,
          13012 => Opcode::VPBLENDMBZrmkz,
          13013 => Opcode::VPBLENDMBZrr,
          13014 => Opcode::VPBLENDMBZrrk,
          13015 => Opcode::VPBLENDMBZrrkz,
          13016 => Opcode::VPBLENDMDZ128rm,
          13017 => Opcode::VPBLENDMDZ128rmb,
          13018 => Opcode::VPBLENDMDZ128rmbk,
          13019 => Opcode::VPBLENDMDZ128rmbkz,
          13020 => Opcode::VPBLENDMDZ128rmk,
          13021 => Opcode::VPBLENDMDZ128rmkz,
          13022 => Opcode::VPBLENDMDZ128rr,
          13023 => Opcode::VPBLENDMDZ128rrk,
          13024 => Opcode::VPBLENDMDZ128rrkz,
          13025 => Opcode::VPBLENDMDZ256rm,
          13026 => Opcode::VPBLENDMDZ256rmb,
          13027 => Opcode::VPBLENDMDZ256rmbk,
          13028 => Opcode::VPBLENDMDZ256rmbkz,
          13029 => Opcode::VPBLENDMDZ256rmk,
          13030 => Opcode::VPBLENDMDZ256rmkz,
          13031 => Opcode::VPBLENDMDZ256rr,
          13032 => Opcode::VPBLENDMDZ256rrk,
          13033 => Opcode::VPBLENDMDZ256rrkz,
          13034 => Opcode::VPBLENDMDZrm,
          13035 => Opcode::VPBLENDMDZrmb,
          13036 => Opcode::VPBLENDMDZrmbk,
          13037 => Opcode::VPBLENDMDZrmbkz,
          13038 => Opcode::VPBLENDMDZrmk,
          13039 => Opcode::VPBLENDMDZrmkz,
          13040 => Opcode::VPBLENDMDZrr,
          13041 => Opcode::VPBLENDMDZrrk,
          13042 => Opcode::VPBLENDMDZrrkz,
          13043 => Opcode::VPBLENDMQZ128rm,
          13044 => Opcode::VPBLENDMQZ128rmb,
          13045 => Opcode::VPBLENDMQZ128rmbk,
          13046 => Opcode::VPBLENDMQZ128rmbkz,
          13047 => Opcode::VPBLENDMQZ128rmk,
          13048 => Opcode::VPBLENDMQZ128rmkz,
          13049 => Opcode::VPBLENDMQZ128rr,
          13050 => Opcode::VPBLENDMQZ128rrk,
          13051 => Opcode::VPBLENDMQZ128rrkz,
          13052 => Opcode::VPBLENDMQZ256rm,
          13053 => Opcode::VPBLENDMQZ256rmb,
          13054 => Opcode::VPBLENDMQZ256rmbk,
          13055 => Opcode::VPBLENDMQZ256rmbkz,
          13056 => Opcode::VPBLENDMQZ256rmk,
          13057 => Opcode::VPBLENDMQZ256rmkz,
          13058 => Opcode::VPBLENDMQZ256rr,
          13059 => Opcode::VPBLENDMQZ256rrk,
          13060 => Opcode::VPBLENDMQZ256rrkz,
          13061 => Opcode::VPBLENDMQZrm,
          13062 => Opcode::VPBLENDMQZrmb,
          13063 => Opcode::VPBLENDMQZrmbk,
          13064 => Opcode::VPBLENDMQZrmbkz,
          13065 => Opcode::VPBLENDMQZrmk,
          13066 => Opcode::VPBLENDMQZrmkz,
          13067 => Opcode::VPBLENDMQZrr,
          13068 => Opcode::VPBLENDMQZrrk,
          13069 => Opcode::VPBLENDMQZrrkz,
          13070 => Opcode::VPBLENDMWZ128rm,
          13071 => Opcode::VPBLENDMWZ128rmk,
          13072 => Opcode::VPBLENDMWZ128rmkz,
          13073 => Opcode::VPBLENDMWZ128rr,
          13074 => Opcode::VPBLENDMWZ128rrk,
          13075 => Opcode::VPBLENDMWZ128rrkz,
          13076 => Opcode::VPBLENDMWZ256rm,
          13077 => Opcode::VPBLENDMWZ256rmk,
          13078 => Opcode::VPBLENDMWZ256rmkz,
          13079 => Opcode::VPBLENDMWZ256rr,
          13080 => Opcode::VPBLENDMWZ256rrk,
          13081 => Opcode::VPBLENDMWZ256rrkz,
          13082 => Opcode::VPBLENDMWZrm,
          13083 => Opcode::VPBLENDMWZrmk,
          13084 => Opcode::VPBLENDMWZrmkz,
          13085 => Opcode::VPBLENDMWZrr,
          13086 => Opcode::VPBLENDMWZrrk,
          13087 => Opcode::VPBLENDMWZrrkz,
          13088 => Opcode::VPBLENDVBYrmr,
          13089 => Opcode::VPBLENDVBYrrr,
          13090 => Opcode::VPBLENDVBrmr,
          13091 => Opcode::VPBLENDVBrrr,
          13092 => Opcode::VPBLENDWYrmi,
          13093 => Opcode::VPBLENDWYrri,
          13094 => Opcode::VPBLENDWrmi,
          13095 => Opcode::VPBLENDWrri,
          13096 => Opcode::VPBROADCASTBYrm,
          13097 => Opcode::VPBROADCASTBYrr,
          13098 => Opcode::VPBROADCASTBZ128rm,
          13099 => Opcode::VPBROADCASTBZ128rmk,
          13100 => Opcode::VPBROADCASTBZ128rmkz,
          13101 => Opcode::VPBROADCASTBZ128rr,
          13102 => Opcode::VPBROADCASTBZ128rrk,
          13103 => Opcode::VPBROADCASTBZ128rrkz,
          13104 => Opcode::VPBROADCASTBZ256rm,
          13105 => Opcode::VPBROADCASTBZ256rmk,
          13106 => Opcode::VPBROADCASTBZ256rmkz,
          13107 => Opcode::VPBROADCASTBZ256rr,
          13108 => Opcode::VPBROADCASTBZ256rrk,
          13109 => Opcode::VPBROADCASTBZ256rrkz,
          13110 => Opcode::VPBROADCASTBZrm,
          13111 => Opcode::VPBROADCASTBZrmk,
          13112 => Opcode::VPBROADCASTBZrmkz,
          13113 => Opcode::VPBROADCASTBZrr,
          13114 => Opcode::VPBROADCASTBZrrk,
          13115 => Opcode::VPBROADCASTBZrrkz,
          13116 => Opcode::VPBROADCASTBrZ128rr,
          13117 => Opcode::VPBROADCASTBrZ128rrk,
          13118 => Opcode::VPBROADCASTBrZ128rrkz,
          13119 => Opcode::VPBROADCASTBrZ256rr,
          13120 => Opcode::VPBROADCASTBrZ256rrk,
          13121 => Opcode::VPBROADCASTBrZ256rrkz,
          13122 => Opcode::VPBROADCASTBrZrr,
          13123 => Opcode::VPBROADCASTBrZrrk,
          13124 => Opcode::VPBROADCASTBrZrrkz,
          13125 => Opcode::VPBROADCASTBrm,
          13126 => Opcode::VPBROADCASTBrr,
          13127 => Opcode::VPBROADCASTDYrm,
          13128 => Opcode::VPBROADCASTDYrr,
          13129 => Opcode::VPBROADCASTDZ128rm,
          13130 => Opcode::VPBROADCASTDZ128rmk,
          13131 => Opcode::VPBROADCASTDZ128rmkz,
          13132 => Opcode::VPBROADCASTDZ128rr,
          13133 => Opcode::VPBROADCASTDZ128rrk,
          13134 => Opcode::VPBROADCASTDZ128rrkz,
          13135 => Opcode::VPBROADCASTDZ256rm,
          13136 => Opcode::VPBROADCASTDZ256rmk,
          13137 => Opcode::VPBROADCASTDZ256rmkz,
          13138 => Opcode::VPBROADCASTDZ256rr,
          13139 => Opcode::VPBROADCASTDZ256rrk,
          13140 => Opcode::VPBROADCASTDZ256rrkz,
          13141 => Opcode::VPBROADCASTDZrm,
          13142 => Opcode::VPBROADCASTDZrmk,
          13143 => Opcode::VPBROADCASTDZrmkz,
          13144 => Opcode::VPBROADCASTDZrr,
          13145 => Opcode::VPBROADCASTDZrrk,
          13146 => Opcode::VPBROADCASTDZrrkz,
          13147 => Opcode::VPBROADCASTDrZ128rr,
          13148 => Opcode::VPBROADCASTDrZ128rrk,
          13149 => Opcode::VPBROADCASTDrZ128rrkz,
          13150 => Opcode::VPBROADCASTDrZ256rr,
          13151 => Opcode::VPBROADCASTDrZ256rrk,
          13152 => Opcode::VPBROADCASTDrZ256rrkz,
          13153 => Opcode::VPBROADCASTDrZrr,
          13154 => Opcode::VPBROADCASTDrZrrk,
          13155 => Opcode::VPBROADCASTDrZrrkz,
          13156 => Opcode::VPBROADCASTDrm,
          13157 => Opcode::VPBROADCASTDrr,
          13158 => Opcode::VPBROADCASTMB2QZ128rr,
          13159 => Opcode::VPBROADCASTMB2QZ256rr,
          13160 => Opcode::VPBROADCASTMB2QZrr,
          13161 => Opcode::VPBROADCASTMW2DZ128rr,
          13162 => Opcode::VPBROADCASTMW2DZ256rr,
          13163 => Opcode::VPBROADCASTMW2DZrr,
          13164 => Opcode::VPBROADCASTQYrm,
          13165 => Opcode::VPBROADCASTQYrr,
          13166 => Opcode::VPBROADCASTQZ128rm,
          13167 => Opcode::VPBROADCASTQZ128rmk,
          13168 => Opcode::VPBROADCASTQZ128rmkz,
          13169 => Opcode::VPBROADCASTQZ128rr,
          13170 => Opcode::VPBROADCASTQZ128rrk,
          13171 => Opcode::VPBROADCASTQZ128rrkz,
          13172 => Opcode::VPBROADCASTQZ256rm,
          13173 => Opcode::VPBROADCASTQZ256rmk,
          13174 => Opcode::VPBROADCASTQZ256rmkz,
          13175 => Opcode::VPBROADCASTQZ256rr,
          13176 => Opcode::VPBROADCASTQZ256rrk,
          13177 => Opcode::VPBROADCASTQZ256rrkz,
          13178 => Opcode::VPBROADCASTQZrm,
          13179 => Opcode::VPBROADCASTQZrmk,
          13180 => Opcode::VPBROADCASTQZrmkz,
          13181 => Opcode::VPBROADCASTQZrr,
          13182 => Opcode::VPBROADCASTQZrrk,
          13183 => Opcode::VPBROADCASTQZrrkz,
          13184 => Opcode::VPBROADCASTQrZ128rr,
          13185 => Opcode::VPBROADCASTQrZ128rrk,
          13186 => Opcode::VPBROADCASTQrZ128rrkz,
          13187 => Opcode::VPBROADCASTQrZ256rr,
          13188 => Opcode::VPBROADCASTQrZ256rrk,
          13189 => Opcode::VPBROADCASTQrZ256rrkz,
          13190 => Opcode::VPBROADCASTQrZrr,
          13191 => Opcode::VPBROADCASTQrZrrk,
          13192 => Opcode::VPBROADCASTQrZrrkz,
          13193 => Opcode::VPBROADCASTQrm,
          13194 => Opcode::VPBROADCASTQrr,
          13195 => Opcode::VPBROADCASTWYrm,
          13196 => Opcode::VPBROADCASTWYrr,
          13197 => Opcode::VPBROADCASTWZ128rm,
          13198 => Opcode::VPBROADCASTWZ128rmk,
          13199 => Opcode::VPBROADCASTWZ128rmkz,
          13200 => Opcode::VPBROADCASTWZ128rr,
          13201 => Opcode::VPBROADCASTWZ128rrk,
          13202 => Opcode::VPBROADCASTWZ128rrkz,
          13203 => Opcode::VPBROADCASTWZ256rm,
          13204 => Opcode::VPBROADCASTWZ256rmk,
          13205 => Opcode::VPBROADCASTWZ256rmkz,
          13206 => Opcode::VPBROADCASTWZ256rr,
          13207 => Opcode::VPBROADCASTWZ256rrk,
          13208 => Opcode::VPBROADCASTWZ256rrkz,
          13209 => Opcode::VPBROADCASTWZrm,
          13210 => Opcode::VPBROADCASTWZrmk,
          13211 => Opcode::VPBROADCASTWZrmkz,
          13212 => Opcode::VPBROADCASTWZrr,
          13213 => Opcode::VPBROADCASTWZrrk,
          13214 => Opcode::VPBROADCASTWZrrkz,
          13215 => Opcode::VPBROADCASTWrZ128rr,
          13216 => Opcode::VPBROADCASTWrZ128rrk,
          13217 => Opcode::VPBROADCASTWrZ128rrkz,
          13218 => Opcode::VPBROADCASTWrZ256rr,
          13219 => Opcode::VPBROADCASTWrZ256rrk,
          13220 => Opcode::VPBROADCASTWrZ256rrkz,
          13221 => Opcode::VPBROADCASTWrZrr,
          13222 => Opcode::VPBROADCASTWrZrrk,
          13223 => Opcode::VPBROADCASTWrZrrkz,
          13224 => Opcode::VPBROADCASTWrm,
          13225 => Opcode::VPBROADCASTWrr,
          13226 => Opcode::VPCLMULQDQYrmi,
          13227 => Opcode::VPCLMULQDQYrri,
          13228 => Opcode::VPCLMULQDQZ128rmi,
          13229 => Opcode::VPCLMULQDQZ128rri,
          13230 => Opcode::VPCLMULQDQZ256rmi,
          13231 => Opcode::VPCLMULQDQZ256rri,
          13232 => Opcode::VPCLMULQDQZrmi,
          13233 => Opcode::VPCLMULQDQZrri,
          13234 => Opcode::VPCLMULQDQrmi,
          13235 => Opcode::VPCLMULQDQrri,
          13236 => Opcode::VPCMOVYrmr,
          13237 => Opcode::VPCMOVYrrm,
          13238 => Opcode::VPCMOVYrrr,
          13239 => Opcode::VPCMOVYrrr_REV,
          13240 => Opcode::VPCMOVrmr,
          13241 => Opcode::VPCMOVrrm,
          13242 => Opcode::VPCMOVrrr,
          13243 => Opcode::VPCMOVrrr_REV,
          13244 => Opcode::VPCMPBZ128rmi,
          13245 => Opcode::VPCMPBZ128rmik,
          13246 => Opcode::VPCMPBZ128rri,
          13247 => Opcode::VPCMPBZ128rrik,
          13248 => Opcode::VPCMPBZ256rmi,
          13249 => Opcode::VPCMPBZ256rmik,
          13250 => Opcode::VPCMPBZ256rri,
          13251 => Opcode::VPCMPBZ256rrik,
          13252 => Opcode::VPCMPBZrmi,
          13253 => Opcode::VPCMPBZrmik,
          13254 => Opcode::VPCMPBZrri,
          13255 => Opcode::VPCMPBZrrik,
          13256 => Opcode::VPCMPDZ128rmi,
          13257 => Opcode::VPCMPDZ128rmib,
          13258 => Opcode::VPCMPDZ128rmibk,
          13259 => Opcode::VPCMPDZ128rmik,
          13260 => Opcode::VPCMPDZ128rri,
          13261 => Opcode::VPCMPDZ128rrik,
          13262 => Opcode::VPCMPDZ256rmi,
          13263 => Opcode::VPCMPDZ256rmib,
          13264 => Opcode::VPCMPDZ256rmibk,
          13265 => Opcode::VPCMPDZ256rmik,
          13266 => Opcode::VPCMPDZ256rri,
          13267 => Opcode::VPCMPDZ256rrik,
          13268 => Opcode::VPCMPDZrmi,
          13269 => Opcode::VPCMPDZrmib,
          13270 => Opcode::VPCMPDZrmibk,
          13271 => Opcode::VPCMPDZrmik,
          13272 => Opcode::VPCMPDZrri,
          13273 => Opcode::VPCMPDZrrik,
          13274 => Opcode::VPCMPEQBYrm,
          13275 => Opcode::VPCMPEQBYrr,
          13276 => Opcode::VPCMPEQBZ128rm,
          13277 => Opcode::VPCMPEQBZ128rmk,
          13278 => Opcode::VPCMPEQBZ128rr,
          13279 => Opcode::VPCMPEQBZ128rrk,
          13280 => Opcode::VPCMPEQBZ256rm,
          13281 => Opcode::VPCMPEQBZ256rmk,
          13282 => Opcode::VPCMPEQBZ256rr,
          13283 => Opcode::VPCMPEQBZ256rrk,
          13284 => Opcode::VPCMPEQBZrm,
          13285 => Opcode::VPCMPEQBZrmk,
          13286 => Opcode::VPCMPEQBZrr,
          13287 => Opcode::VPCMPEQBZrrk,
          13288 => Opcode::VPCMPEQBrm,
          13289 => Opcode::VPCMPEQBrr,
          13290 => Opcode::VPCMPEQDYrm,
          13291 => Opcode::VPCMPEQDYrr,
          13292 => Opcode::VPCMPEQDZ128rm,
          13293 => Opcode::VPCMPEQDZ128rmb,
          13294 => Opcode::VPCMPEQDZ128rmbk,
          13295 => Opcode::VPCMPEQDZ128rmk,
          13296 => Opcode::VPCMPEQDZ128rr,
          13297 => Opcode::VPCMPEQDZ128rrk,
          13298 => Opcode::VPCMPEQDZ256rm,
          13299 => Opcode::VPCMPEQDZ256rmb,
          13300 => Opcode::VPCMPEQDZ256rmbk,
          13301 => Opcode::VPCMPEQDZ256rmk,
          13302 => Opcode::VPCMPEQDZ256rr,
          13303 => Opcode::VPCMPEQDZ256rrk,
          13304 => Opcode::VPCMPEQDZrm,
          13305 => Opcode::VPCMPEQDZrmb,
          13306 => Opcode::VPCMPEQDZrmbk,
          13307 => Opcode::VPCMPEQDZrmk,
          13308 => Opcode::VPCMPEQDZrr,
          13309 => Opcode::VPCMPEQDZrrk,
          13310 => Opcode::VPCMPEQDrm,
          13311 => Opcode::VPCMPEQDrr,
          13312 => Opcode::VPCMPEQQYrm,
          13313 => Opcode::VPCMPEQQYrr,
          13314 => Opcode::VPCMPEQQZ128rm,
          13315 => Opcode::VPCMPEQQZ128rmb,
          13316 => Opcode::VPCMPEQQZ128rmbk,
          13317 => Opcode::VPCMPEQQZ128rmk,
          13318 => Opcode::VPCMPEQQZ128rr,
          13319 => Opcode::VPCMPEQQZ128rrk,
          13320 => Opcode::VPCMPEQQZ256rm,
          13321 => Opcode::VPCMPEQQZ256rmb,
          13322 => Opcode::VPCMPEQQZ256rmbk,
          13323 => Opcode::VPCMPEQQZ256rmk,
          13324 => Opcode::VPCMPEQQZ256rr,
          13325 => Opcode::VPCMPEQQZ256rrk,
          13326 => Opcode::VPCMPEQQZrm,
          13327 => Opcode::VPCMPEQQZrmb,
          13328 => Opcode::VPCMPEQQZrmbk,
          13329 => Opcode::VPCMPEQQZrmk,
          13330 => Opcode::VPCMPEQQZrr,
          13331 => Opcode::VPCMPEQQZrrk,
          13332 => Opcode::VPCMPEQQrm,
          13333 => Opcode::VPCMPEQQrr,
          13334 => Opcode::VPCMPEQWYrm,
          13335 => Opcode::VPCMPEQWYrr,
          13336 => Opcode::VPCMPEQWZ128rm,
          13337 => Opcode::VPCMPEQWZ128rmk,
          13338 => Opcode::VPCMPEQWZ128rr,
          13339 => Opcode::VPCMPEQWZ128rrk,
          13340 => Opcode::VPCMPEQWZ256rm,
          13341 => Opcode::VPCMPEQWZ256rmk,
          13342 => Opcode::VPCMPEQWZ256rr,
          13343 => Opcode::VPCMPEQWZ256rrk,
          13344 => Opcode::VPCMPEQWZrm,
          13345 => Opcode::VPCMPEQWZrmk,
          13346 => Opcode::VPCMPEQWZrr,
          13347 => Opcode::VPCMPEQWZrrk,
          13348 => Opcode::VPCMPEQWrm,
          13349 => Opcode::VPCMPEQWrr,
          13350 => Opcode::VPCMPESTRIrmi,
          13351 => Opcode::VPCMPESTRIrri,
          13352 => Opcode::VPCMPESTRMrmi,
          13353 => Opcode::VPCMPESTRMrri,
          13354 => Opcode::VPCMPGTBYrm,
          13355 => Opcode::VPCMPGTBYrr,
          13356 => Opcode::VPCMPGTBZ128rm,
          13357 => Opcode::VPCMPGTBZ128rmk,
          13358 => Opcode::VPCMPGTBZ128rr,
          13359 => Opcode::VPCMPGTBZ128rrk,
          13360 => Opcode::VPCMPGTBZ256rm,
          13361 => Opcode::VPCMPGTBZ256rmk,
          13362 => Opcode::VPCMPGTBZ256rr,
          13363 => Opcode::VPCMPGTBZ256rrk,
          13364 => Opcode::VPCMPGTBZrm,
          13365 => Opcode::VPCMPGTBZrmk,
          13366 => Opcode::VPCMPGTBZrr,
          13367 => Opcode::VPCMPGTBZrrk,
          13368 => Opcode::VPCMPGTBrm,
          13369 => Opcode::VPCMPGTBrr,
          13370 => Opcode::VPCMPGTDYrm,
          13371 => Opcode::VPCMPGTDYrr,
          13372 => Opcode::VPCMPGTDZ128rm,
          13373 => Opcode::VPCMPGTDZ128rmb,
          13374 => Opcode::VPCMPGTDZ128rmbk,
          13375 => Opcode::VPCMPGTDZ128rmk,
          13376 => Opcode::VPCMPGTDZ128rr,
          13377 => Opcode::VPCMPGTDZ128rrk,
          13378 => Opcode::VPCMPGTDZ256rm,
          13379 => Opcode::VPCMPGTDZ256rmb,
          13380 => Opcode::VPCMPGTDZ256rmbk,
          13381 => Opcode::VPCMPGTDZ256rmk,
          13382 => Opcode::VPCMPGTDZ256rr,
          13383 => Opcode::VPCMPGTDZ256rrk,
          13384 => Opcode::VPCMPGTDZrm,
          13385 => Opcode::VPCMPGTDZrmb,
          13386 => Opcode::VPCMPGTDZrmbk,
          13387 => Opcode::VPCMPGTDZrmk,
          13388 => Opcode::VPCMPGTDZrr,
          13389 => Opcode::VPCMPGTDZrrk,
          13390 => Opcode::VPCMPGTDrm,
          13391 => Opcode::VPCMPGTDrr,
          13392 => Opcode::VPCMPGTQYrm,
          13393 => Opcode::VPCMPGTQYrr,
          13394 => Opcode::VPCMPGTQZ128rm,
          13395 => Opcode::VPCMPGTQZ128rmb,
          13396 => Opcode::VPCMPGTQZ128rmbk,
          13397 => Opcode::VPCMPGTQZ128rmk,
          13398 => Opcode::VPCMPGTQZ128rr,
          13399 => Opcode::VPCMPGTQZ128rrk,
          13400 => Opcode::VPCMPGTQZ256rm,
          13401 => Opcode::VPCMPGTQZ256rmb,
          13402 => Opcode::VPCMPGTQZ256rmbk,
          13403 => Opcode::VPCMPGTQZ256rmk,
          13404 => Opcode::VPCMPGTQZ256rr,
          13405 => Opcode::VPCMPGTQZ256rrk,
          13406 => Opcode::VPCMPGTQZrm,
          13407 => Opcode::VPCMPGTQZrmb,
          13408 => Opcode::VPCMPGTQZrmbk,
          13409 => Opcode::VPCMPGTQZrmk,
          13410 => Opcode::VPCMPGTQZrr,
          13411 => Opcode::VPCMPGTQZrrk,
          13412 => Opcode::VPCMPGTQrm,
          13413 => Opcode::VPCMPGTQrr,
          13414 => Opcode::VPCMPGTWYrm,
          13415 => Opcode::VPCMPGTWYrr,
          13416 => Opcode::VPCMPGTWZ128rm,
          13417 => Opcode::VPCMPGTWZ128rmk,
          13418 => Opcode::VPCMPGTWZ128rr,
          13419 => Opcode::VPCMPGTWZ128rrk,
          13420 => Opcode::VPCMPGTWZ256rm,
          13421 => Opcode::VPCMPGTWZ256rmk,
          13422 => Opcode::VPCMPGTWZ256rr,
          13423 => Opcode::VPCMPGTWZ256rrk,
          13424 => Opcode::VPCMPGTWZrm,
          13425 => Opcode::VPCMPGTWZrmk,
          13426 => Opcode::VPCMPGTWZrr,
          13427 => Opcode::VPCMPGTWZrrk,
          13428 => Opcode::VPCMPGTWrm,
          13429 => Opcode::VPCMPGTWrr,
          13430 => Opcode::VPCMPISTRIrmi,
          13431 => Opcode::VPCMPISTRIrri,
          13432 => Opcode::VPCMPISTRMrmi,
          13433 => Opcode::VPCMPISTRMrri,
          13434 => Opcode::VPCMPQZ128rmi,
          13435 => Opcode::VPCMPQZ128rmib,
          13436 => Opcode::VPCMPQZ128rmibk,
          13437 => Opcode::VPCMPQZ128rmik,
          13438 => Opcode::VPCMPQZ128rri,
          13439 => Opcode::VPCMPQZ128rrik,
          13440 => Opcode::VPCMPQZ256rmi,
          13441 => Opcode::VPCMPQZ256rmib,
          13442 => Opcode::VPCMPQZ256rmibk,
          13443 => Opcode::VPCMPQZ256rmik,
          13444 => Opcode::VPCMPQZ256rri,
          13445 => Opcode::VPCMPQZ256rrik,
          13446 => Opcode::VPCMPQZrmi,
          13447 => Opcode::VPCMPQZrmib,
          13448 => Opcode::VPCMPQZrmibk,
          13449 => Opcode::VPCMPQZrmik,
          13450 => Opcode::VPCMPQZrri,
          13451 => Opcode::VPCMPQZrrik,
          13452 => Opcode::VPCMPUBZ128rmi,
          13453 => Opcode::VPCMPUBZ128rmik,
          13454 => Opcode::VPCMPUBZ128rri,
          13455 => Opcode::VPCMPUBZ128rrik,
          13456 => Opcode::VPCMPUBZ256rmi,
          13457 => Opcode::VPCMPUBZ256rmik,
          13458 => Opcode::VPCMPUBZ256rri,
          13459 => Opcode::VPCMPUBZ256rrik,
          13460 => Opcode::VPCMPUBZrmi,
          13461 => Opcode::VPCMPUBZrmik,
          13462 => Opcode::VPCMPUBZrri,
          13463 => Opcode::VPCMPUBZrrik,
          13464 => Opcode::VPCMPUDZ128rmi,
          13465 => Opcode::VPCMPUDZ128rmib,
          13466 => Opcode::VPCMPUDZ128rmibk,
          13467 => Opcode::VPCMPUDZ128rmik,
          13468 => Opcode::VPCMPUDZ128rri,
          13469 => Opcode::VPCMPUDZ128rrik,
          13470 => Opcode::VPCMPUDZ256rmi,
          13471 => Opcode::VPCMPUDZ256rmib,
          13472 => Opcode::VPCMPUDZ256rmibk,
          13473 => Opcode::VPCMPUDZ256rmik,
          13474 => Opcode::VPCMPUDZ256rri,
          13475 => Opcode::VPCMPUDZ256rrik,
          13476 => Opcode::VPCMPUDZrmi,
          13477 => Opcode::VPCMPUDZrmib,
          13478 => Opcode::VPCMPUDZrmibk,
          13479 => Opcode::VPCMPUDZrmik,
          13480 => Opcode::VPCMPUDZrri,
          13481 => Opcode::VPCMPUDZrrik,
          13482 => Opcode::VPCMPUQZ128rmi,
          13483 => Opcode::VPCMPUQZ128rmib,
          13484 => Opcode::VPCMPUQZ128rmibk,
          13485 => Opcode::VPCMPUQZ128rmik,
          13486 => Opcode::VPCMPUQZ128rri,
          13487 => Opcode::VPCMPUQZ128rrik,
          13488 => Opcode::VPCMPUQZ256rmi,
          13489 => Opcode::VPCMPUQZ256rmib,
          13490 => Opcode::VPCMPUQZ256rmibk,
          13491 => Opcode::VPCMPUQZ256rmik,
          13492 => Opcode::VPCMPUQZ256rri,
          13493 => Opcode::VPCMPUQZ256rrik,
          13494 => Opcode::VPCMPUQZrmi,
          13495 => Opcode::VPCMPUQZrmib,
          13496 => Opcode::VPCMPUQZrmibk,
          13497 => Opcode::VPCMPUQZrmik,
          13498 => Opcode::VPCMPUQZrri,
          13499 => Opcode::VPCMPUQZrrik,
          13500 => Opcode::VPCMPUWZ128rmi,
          13501 => Opcode::VPCMPUWZ128rmik,
          13502 => Opcode::VPCMPUWZ128rri,
          13503 => Opcode::VPCMPUWZ128rrik,
          13504 => Opcode::VPCMPUWZ256rmi,
          13505 => Opcode::VPCMPUWZ256rmik,
          13506 => Opcode::VPCMPUWZ256rri,
          13507 => Opcode::VPCMPUWZ256rrik,
          13508 => Opcode::VPCMPUWZrmi,
          13509 => Opcode::VPCMPUWZrmik,
          13510 => Opcode::VPCMPUWZrri,
          13511 => Opcode::VPCMPUWZrrik,
          13512 => Opcode::VPCMPWZ128rmi,
          13513 => Opcode::VPCMPWZ128rmik,
          13514 => Opcode::VPCMPWZ128rri,
          13515 => Opcode::VPCMPWZ128rrik,
          13516 => Opcode::VPCMPWZ256rmi,
          13517 => Opcode::VPCMPWZ256rmik,
          13518 => Opcode::VPCMPWZ256rri,
          13519 => Opcode::VPCMPWZ256rrik,
          13520 => Opcode::VPCMPWZrmi,
          13521 => Opcode::VPCMPWZrmik,
          13522 => Opcode::VPCMPWZrri,
          13523 => Opcode::VPCMPWZrrik,
          13524 => Opcode::VPCOMBmi,
          13525 => Opcode::VPCOMBri,
          13526 => Opcode::VPCOMDmi,
          13527 => Opcode::VPCOMDri,
          13528 => Opcode::VPCOMPRESSBZ128mr,
          13529 => Opcode::VPCOMPRESSBZ128mrk,
          13530 => Opcode::VPCOMPRESSBZ128rr,
          13531 => Opcode::VPCOMPRESSBZ128rrk,
          13532 => Opcode::VPCOMPRESSBZ128rrkz,
          13533 => Opcode::VPCOMPRESSBZ256mr,
          13534 => Opcode::VPCOMPRESSBZ256mrk,
          13535 => Opcode::VPCOMPRESSBZ256rr,
          13536 => Opcode::VPCOMPRESSBZ256rrk,
          13537 => Opcode::VPCOMPRESSBZ256rrkz,
          13538 => Opcode::VPCOMPRESSBZmr,
          13539 => Opcode::VPCOMPRESSBZmrk,
          13540 => Opcode::VPCOMPRESSBZrr,
          13541 => Opcode::VPCOMPRESSBZrrk,
          13542 => Opcode::VPCOMPRESSBZrrkz,
          13543 => Opcode::VPCOMPRESSDZ128mr,
          13544 => Opcode::VPCOMPRESSDZ128mrk,
          13545 => Opcode::VPCOMPRESSDZ128rr,
          13546 => Opcode::VPCOMPRESSDZ128rrk,
          13547 => Opcode::VPCOMPRESSDZ128rrkz,
          13548 => Opcode::VPCOMPRESSDZ256mr,
          13549 => Opcode::VPCOMPRESSDZ256mrk,
          13550 => Opcode::VPCOMPRESSDZ256rr,
          13551 => Opcode::VPCOMPRESSDZ256rrk,
          13552 => Opcode::VPCOMPRESSDZ256rrkz,
          13553 => Opcode::VPCOMPRESSDZmr,
          13554 => Opcode::VPCOMPRESSDZmrk,
          13555 => Opcode::VPCOMPRESSDZrr,
          13556 => Opcode::VPCOMPRESSDZrrk,
          13557 => Opcode::VPCOMPRESSDZrrkz,
          13558 => Opcode::VPCOMPRESSQZ128mr,
          13559 => Opcode::VPCOMPRESSQZ128mrk,
          13560 => Opcode::VPCOMPRESSQZ128rr,
          13561 => Opcode::VPCOMPRESSQZ128rrk,
          13562 => Opcode::VPCOMPRESSQZ128rrkz,
          13563 => Opcode::VPCOMPRESSQZ256mr,
          13564 => Opcode::VPCOMPRESSQZ256mrk,
          13565 => Opcode::VPCOMPRESSQZ256rr,
          13566 => Opcode::VPCOMPRESSQZ256rrk,
          13567 => Opcode::VPCOMPRESSQZ256rrkz,
          13568 => Opcode::VPCOMPRESSQZmr,
          13569 => Opcode::VPCOMPRESSQZmrk,
          13570 => Opcode::VPCOMPRESSQZrr,
          13571 => Opcode::VPCOMPRESSQZrrk,
          13572 => Opcode::VPCOMPRESSQZrrkz,
          13573 => Opcode::VPCOMPRESSWZ128mr,
          13574 => Opcode::VPCOMPRESSWZ128mrk,
          13575 => Opcode::VPCOMPRESSWZ128rr,
          13576 => Opcode::VPCOMPRESSWZ128rrk,
          13577 => Opcode::VPCOMPRESSWZ128rrkz,
          13578 => Opcode::VPCOMPRESSWZ256mr,
          13579 => Opcode::VPCOMPRESSWZ256mrk,
          13580 => Opcode::VPCOMPRESSWZ256rr,
          13581 => Opcode::VPCOMPRESSWZ256rrk,
          13582 => Opcode::VPCOMPRESSWZ256rrkz,
          13583 => Opcode::VPCOMPRESSWZmr,
          13584 => Opcode::VPCOMPRESSWZmrk,
          13585 => Opcode::VPCOMPRESSWZrr,
          13586 => Opcode::VPCOMPRESSWZrrk,
          13587 => Opcode::VPCOMPRESSWZrrkz,
          13588 => Opcode::VPCOMQmi,
          13589 => Opcode::VPCOMQri,
          13590 => Opcode::VPCOMUBmi,
          13591 => Opcode::VPCOMUBri,
          13592 => Opcode::VPCOMUDmi,
          13593 => Opcode::VPCOMUDri,
          13594 => Opcode::VPCOMUQmi,
          13595 => Opcode::VPCOMUQri,
          13596 => Opcode::VPCOMUWmi,
          13597 => Opcode::VPCOMUWri,
          13598 => Opcode::VPCOMWmi,
          13599 => Opcode::VPCOMWri,
          13600 => Opcode::VPCONFLICTDZ128rm,
          13601 => Opcode::VPCONFLICTDZ128rmb,
          13602 => Opcode::VPCONFLICTDZ128rmbk,
          13603 => Opcode::VPCONFLICTDZ128rmbkz,
          13604 => Opcode::VPCONFLICTDZ128rmk,
          13605 => Opcode::VPCONFLICTDZ128rmkz,
          13606 => Opcode::VPCONFLICTDZ128rr,
          13607 => Opcode::VPCONFLICTDZ128rrk,
          13608 => Opcode::VPCONFLICTDZ128rrkz,
          13609 => Opcode::VPCONFLICTDZ256rm,
          13610 => Opcode::VPCONFLICTDZ256rmb,
          13611 => Opcode::VPCONFLICTDZ256rmbk,
          13612 => Opcode::VPCONFLICTDZ256rmbkz,
          13613 => Opcode::VPCONFLICTDZ256rmk,
          13614 => Opcode::VPCONFLICTDZ256rmkz,
          13615 => Opcode::VPCONFLICTDZ256rr,
          13616 => Opcode::VPCONFLICTDZ256rrk,
          13617 => Opcode::VPCONFLICTDZ256rrkz,
          13618 => Opcode::VPCONFLICTDZrm,
          13619 => Opcode::VPCONFLICTDZrmb,
          13620 => Opcode::VPCONFLICTDZrmbk,
          13621 => Opcode::VPCONFLICTDZrmbkz,
          13622 => Opcode::VPCONFLICTDZrmk,
          13623 => Opcode::VPCONFLICTDZrmkz,
          13624 => Opcode::VPCONFLICTDZrr,
          13625 => Opcode::VPCONFLICTDZrrk,
          13626 => Opcode::VPCONFLICTDZrrkz,
          13627 => Opcode::VPCONFLICTQZ128rm,
          13628 => Opcode::VPCONFLICTQZ128rmb,
          13629 => Opcode::VPCONFLICTQZ128rmbk,
          13630 => Opcode::VPCONFLICTQZ128rmbkz,
          13631 => Opcode::VPCONFLICTQZ128rmk,
          13632 => Opcode::VPCONFLICTQZ128rmkz,
          13633 => Opcode::VPCONFLICTQZ128rr,
          13634 => Opcode::VPCONFLICTQZ128rrk,
          13635 => Opcode::VPCONFLICTQZ128rrkz,
          13636 => Opcode::VPCONFLICTQZ256rm,
          13637 => Opcode::VPCONFLICTQZ256rmb,
          13638 => Opcode::VPCONFLICTQZ256rmbk,
          13639 => Opcode::VPCONFLICTQZ256rmbkz,
          13640 => Opcode::VPCONFLICTQZ256rmk,
          13641 => Opcode::VPCONFLICTQZ256rmkz,
          13642 => Opcode::VPCONFLICTQZ256rr,
          13643 => Opcode::VPCONFLICTQZ256rrk,
          13644 => Opcode::VPCONFLICTQZ256rrkz,
          13645 => Opcode::VPCONFLICTQZrm,
          13646 => Opcode::VPCONFLICTQZrmb,
          13647 => Opcode::VPCONFLICTQZrmbk,
          13648 => Opcode::VPCONFLICTQZrmbkz,
          13649 => Opcode::VPCONFLICTQZrmk,
          13650 => Opcode::VPCONFLICTQZrmkz,
          13651 => Opcode::VPCONFLICTQZrr,
          13652 => Opcode::VPCONFLICTQZrrk,
          13653 => Opcode::VPCONFLICTQZrrkz,
          13654 => Opcode::VPDPBSSDSYrm,
          13655 => Opcode::VPDPBSSDSYrr,
          13656 => Opcode::VPDPBSSDSrm,
          13657 => Opcode::VPDPBSSDSrr,
          13658 => Opcode::VPDPBSSDYrm,
          13659 => Opcode::VPDPBSSDYrr,
          13660 => Opcode::VPDPBSSDrm,
          13661 => Opcode::VPDPBSSDrr,
          13662 => Opcode::VPDPBSUDSYrm,
          13663 => Opcode::VPDPBSUDSYrr,
          13664 => Opcode::VPDPBSUDSrm,
          13665 => Opcode::VPDPBSUDSrr,
          13666 => Opcode::VPDPBSUDYrm,
          13667 => Opcode::VPDPBSUDYrr,
          13668 => Opcode::VPDPBSUDrm,
          13669 => Opcode::VPDPBSUDrr,
          13670 => Opcode::VPDPBUSDSYrm,
          13671 => Opcode::VPDPBUSDSYrr,
          13672 => Opcode::VPDPBUSDSZ128m,
          13673 => Opcode::VPDPBUSDSZ128mb,
          13674 => Opcode::VPDPBUSDSZ128mbk,
          13675 => Opcode::VPDPBUSDSZ128mbkz,
          13676 => Opcode::VPDPBUSDSZ128mk,
          13677 => Opcode::VPDPBUSDSZ128mkz,
          13678 => Opcode::VPDPBUSDSZ128r,
          13679 => Opcode::VPDPBUSDSZ128rk,
          13680 => Opcode::VPDPBUSDSZ128rkz,
          13681 => Opcode::VPDPBUSDSZ256m,
          13682 => Opcode::VPDPBUSDSZ256mb,
          13683 => Opcode::VPDPBUSDSZ256mbk,
          13684 => Opcode::VPDPBUSDSZ256mbkz,
          13685 => Opcode::VPDPBUSDSZ256mk,
          13686 => Opcode::VPDPBUSDSZ256mkz,
          13687 => Opcode::VPDPBUSDSZ256r,
          13688 => Opcode::VPDPBUSDSZ256rk,
          13689 => Opcode::VPDPBUSDSZ256rkz,
          13690 => Opcode::VPDPBUSDSZm,
          13691 => Opcode::VPDPBUSDSZmb,
          13692 => Opcode::VPDPBUSDSZmbk,
          13693 => Opcode::VPDPBUSDSZmbkz,
          13694 => Opcode::VPDPBUSDSZmk,
          13695 => Opcode::VPDPBUSDSZmkz,
          13696 => Opcode::VPDPBUSDSZr,
          13697 => Opcode::VPDPBUSDSZrk,
          13698 => Opcode::VPDPBUSDSZrkz,
          13699 => Opcode::VPDPBUSDSrm,
          13700 => Opcode::VPDPBUSDSrr,
          13701 => Opcode::VPDPBUSDYrm,
          13702 => Opcode::VPDPBUSDYrr,
          13703 => Opcode::VPDPBUSDZ128m,
          13704 => Opcode::VPDPBUSDZ128mb,
          13705 => Opcode::VPDPBUSDZ128mbk,
          13706 => Opcode::VPDPBUSDZ128mbkz,
          13707 => Opcode::VPDPBUSDZ128mk,
          13708 => Opcode::VPDPBUSDZ128mkz,
          13709 => Opcode::VPDPBUSDZ128r,
          13710 => Opcode::VPDPBUSDZ128rk,
          13711 => Opcode::VPDPBUSDZ128rkz,
          13712 => Opcode::VPDPBUSDZ256m,
          13713 => Opcode::VPDPBUSDZ256mb,
          13714 => Opcode::VPDPBUSDZ256mbk,
          13715 => Opcode::VPDPBUSDZ256mbkz,
          13716 => Opcode::VPDPBUSDZ256mk,
          13717 => Opcode::VPDPBUSDZ256mkz,
          13718 => Opcode::VPDPBUSDZ256r,
          13719 => Opcode::VPDPBUSDZ256rk,
          13720 => Opcode::VPDPBUSDZ256rkz,
          13721 => Opcode::VPDPBUSDZm,
          13722 => Opcode::VPDPBUSDZmb,
          13723 => Opcode::VPDPBUSDZmbk,
          13724 => Opcode::VPDPBUSDZmbkz,
          13725 => Opcode::VPDPBUSDZmk,
          13726 => Opcode::VPDPBUSDZmkz,
          13727 => Opcode::VPDPBUSDZr,
          13728 => Opcode::VPDPBUSDZrk,
          13729 => Opcode::VPDPBUSDZrkz,
          13730 => Opcode::VPDPBUSDrm,
          13731 => Opcode::VPDPBUSDrr,
          13732 => Opcode::VPDPBUUDSYrm,
          13733 => Opcode::VPDPBUUDSYrr,
          13734 => Opcode::VPDPBUUDSrm,
          13735 => Opcode::VPDPBUUDSrr,
          13736 => Opcode::VPDPBUUDYrm,
          13737 => Opcode::VPDPBUUDYrr,
          13738 => Opcode::VPDPBUUDrm,
          13739 => Opcode::VPDPBUUDrr,
          13740 => Opcode::VPDPWSSDSYrm,
          13741 => Opcode::VPDPWSSDSYrr,
          13742 => Opcode::VPDPWSSDSZ128m,
          13743 => Opcode::VPDPWSSDSZ128mb,
          13744 => Opcode::VPDPWSSDSZ128mbk,
          13745 => Opcode::VPDPWSSDSZ128mbkz,
          13746 => Opcode::VPDPWSSDSZ128mk,
          13747 => Opcode::VPDPWSSDSZ128mkz,
          13748 => Opcode::VPDPWSSDSZ128r,
          13749 => Opcode::VPDPWSSDSZ128rk,
          13750 => Opcode::VPDPWSSDSZ128rkz,
          13751 => Opcode::VPDPWSSDSZ256m,
          13752 => Opcode::VPDPWSSDSZ256mb,
          13753 => Opcode::VPDPWSSDSZ256mbk,
          13754 => Opcode::VPDPWSSDSZ256mbkz,
          13755 => Opcode::VPDPWSSDSZ256mk,
          13756 => Opcode::VPDPWSSDSZ256mkz,
          13757 => Opcode::VPDPWSSDSZ256r,
          13758 => Opcode::VPDPWSSDSZ256rk,
          13759 => Opcode::VPDPWSSDSZ256rkz,
          13760 => Opcode::VPDPWSSDSZm,
          13761 => Opcode::VPDPWSSDSZmb,
          13762 => Opcode::VPDPWSSDSZmbk,
          13763 => Opcode::VPDPWSSDSZmbkz,
          13764 => Opcode::VPDPWSSDSZmk,
          13765 => Opcode::VPDPWSSDSZmkz,
          13766 => Opcode::VPDPWSSDSZr,
          13767 => Opcode::VPDPWSSDSZrk,
          13768 => Opcode::VPDPWSSDSZrkz,
          13769 => Opcode::VPDPWSSDSrm,
          13770 => Opcode::VPDPWSSDSrr,
          13771 => Opcode::VPDPWSSDYrm,
          13772 => Opcode::VPDPWSSDYrr,
          13773 => Opcode::VPDPWSSDZ128m,
          13774 => Opcode::VPDPWSSDZ128mb,
          13775 => Opcode::VPDPWSSDZ128mbk,
          13776 => Opcode::VPDPWSSDZ128mbkz,
          13777 => Opcode::VPDPWSSDZ128mk,
          13778 => Opcode::VPDPWSSDZ128mkz,
          13779 => Opcode::VPDPWSSDZ128r,
          13780 => Opcode::VPDPWSSDZ128rk,
          13781 => Opcode::VPDPWSSDZ128rkz,
          13782 => Opcode::VPDPWSSDZ256m,
          13783 => Opcode::VPDPWSSDZ256mb,
          13784 => Opcode::VPDPWSSDZ256mbk,
          13785 => Opcode::VPDPWSSDZ256mbkz,
          13786 => Opcode::VPDPWSSDZ256mk,
          13787 => Opcode::VPDPWSSDZ256mkz,
          13788 => Opcode::VPDPWSSDZ256r,
          13789 => Opcode::VPDPWSSDZ256rk,
          13790 => Opcode::VPDPWSSDZ256rkz,
          13791 => Opcode::VPDPWSSDZm,
          13792 => Opcode::VPDPWSSDZmb,
          13793 => Opcode::VPDPWSSDZmbk,
          13794 => Opcode::VPDPWSSDZmbkz,
          13795 => Opcode::VPDPWSSDZmk,
          13796 => Opcode::VPDPWSSDZmkz,
          13797 => Opcode::VPDPWSSDZr,
          13798 => Opcode::VPDPWSSDZrk,
          13799 => Opcode::VPDPWSSDZrkz,
          13800 => Opcode::VPDPWSSDrm,
          13801 => Opcode::VPDPWSSDrr,
          13802 => Opcode::VPDPWSUDSYrm,
          13803 => Opcode::VPDPWSUDSYrr,
          13804 => Opcode::VPDPWSUDSrm,
          13805 => Opcode::VPDPWSUDSrr,
          13806 => Opcode::VPDPWSUDYrm,
          13807 => Opcode::VPDPWSUDYrr,
          13808 => Opcode::VPDPWSUDrm,
          13809 => Opcode::VPDPWSUDrr,
          13810 => Opcode::VPDPWUSDSYrm,
          13811 => Opcode::VPDPWUSDSYrr,
          13812 => Opcode::VPDPWUSDSrm,
          13813 => Opcode::VPDPWUSDSrr,
          13814 => Opcode::VPDPWUSDYrm,
          13815 => Opcode::VPDPWUSDYrr,
          13816 => Opcode::VPDPWUSDrm,
          13817 => Opcode::VPDPWUSDrr,
          13818 => Opcode::VPDPWUUDSYrm,
          13819 => Opcode::VPDPWUUDSYrr,
          13820 => Opcode::VPDPWUUDSrm,
          13821 => Opcode::VPDPWUUDSrr,
          13822 => Opcode::VPDPWUUDYrm,
          13823 => Opcode::VPDPWUUDYrr,
          13824 => Opcode::VPDPWUUDrm,
          13825 => Opcode::VPDPWUUDrr,
          13826 => Opcode::VPERM2F128rm,
          13827 => Opcode::VPERM2F128rr,
          13828 => Opcode::VPERM2I128rm,
          13829 => Opcode::VPERM2I128rr,
          13830 => Opcode::VPERMBZ128rm,
          13831 => Opcode::VPERMBZ128rmk,
          13832 => Opcode::VPERMBZ128rmkz,
          13833 => Opcode::VPERMBZ128rr,
          13834 => Opcode::VPERMBZ128rrk,
          13835 => Opcode::VPERMBZ128rrkz,
          13836 => Opcode::VPERMBZ256rm,
          13837 => Opcode::VPERMBZ256rmk,
          13838 => Opcode::VPERMBZ256rmkz,
          13839 => Opcode::VPERMBZ256rr,
          13840 => Opcode::VPERMBZ256rrk,
          13841 => Opcode::VPERMBZ256rrkz,
          13842 => Opcode::VPERMBZrm,
          13843 => Opcode::VPERMBZrmk,
          13844 => Opcode::VPERMBZrmkz,
          13845 => Opcode::VPERMBZrr,
          13846 => Opcode::VPERMBZrrk,
          13847 => Opcode::VPERMBZrrkz,
          13848 => Opcode::VPERMDYrm,
          13849 => Opcode::VPERMDYrr,
          13850 => Opcode::VPERMDZ256rm,
          13851 => Opcode::VPERMDZ256rmb,
          13852 => Opcode::VPERMDZ256rmbk,
          13853 => Opcode::VPERMDZ256rmbkz,
          13854 => Opcode::VPERMDZ256rmk,
          13855 => Opcode::VPERMDZ256rmkz,
          13856 => Opcode::VPERMDZ256rr,
          13857 => Opcode::VPERMDZ256rrk,
          13858 => Opcode::VPERMDZ256rrkz,
          13859 => Opcode::VPERMDZrm,
          13860 => Opcode::VPERMDZrmb,
          13861 => Opcode::VPERMDZrmbk,
          13862 => Opcode::VPERMDZrmbkz,
          13863 => Opcode::VPERMDZrmk,
          13864 => Opcode::VPERMDZrmkz,
          13865 => Opcode::VPERMDZrr,
          13866 => Opcode::VPERMDZrrk,
          13867 => Opcode::VPERMDZrrkz,
          13868 => Opcode::VPERMI2BZ128rm,
          13869 => Opcode::VPERMI2BZ128rmk,
          13870 => Opcode::VPERMI2BZ128rmkz,
          13871 => Opcode::VPERMI2BZ128rr,
          13872 => Opcode::VPERMI2BZ128rrk,
          13873 => Opcode::VPERMI2BZ128rrkz,
          13874 => Opcode::VPERMI2BZ256rm,
          13875 => Opcode::VPERMI2BZ256rmk,
          13876 => Opcode::VPERMI2BZ256rmkz,
          13877 => Opcode::VPERMI2BZ256rr,
          13878 => Opcode::VPERMI2BZ256rrk,
          13879 => Opcode::VPERMI2BZ256rrkz,
          13880 => Opcode::VPERMI2BZrm,
          13881 => Opcode::VPERMI2BZrmk,
          13882 => Opcode::VPERMI2BZrmkz,
          13883 => Opcode::VPERMI2BZrr,
          13884 => Opcode::VPERMI2BZrrk,
          13885 => Opcode::VPERMI2BZrrkz,
          13886 => Opcode::VPERMI2DZ128rm,
          13887 => Opcode::VPERMI2DZ128rmb,
          13888 => Opcode::VPERMI2DZ128rmbk,
          13889 => Opcode::VPERMI2DZ128rmbkz,
          13890 => Opcode::VPERMI2DZ128rmk,
          13891 => Opcode::VPERMI2DZ128rmkz,
          13892 => Opcode::VPERMI2DZ128rr,
          13893 => Opcode::VPERMI2DZ128rrk,
          13894 => Opcode::VPERMI2DZ128rrkz,
          13895 => Opcode::VPERMI2DZ256rm,
          13896 => Opcode::VPERMI2DZ256rmb,
          13897 => Opcode::VPERMI2DZ256rmbk,
          13898 => Opcode::VPERMI2DZ256rmbkz,
          13899 => Opcode::VPERMI2DZ256rmk,
          13900 => Opcode::VPERMI2DZ256rmkz,
          13901 => Opcode::VPERMI2DZ256rr,
          13902 => Opcode::VPERMI2DZ256rrk,
          13903 => Opcode::VPERMI2DZ256rrkz,
          13904 => Opcode::VPERMI2DZrm,
          13905 => Opcode::VPERMI2DZrmb,
          13906 => Opcode::VPERMI2DZrmbk,
          13907 => Opcode::VPERMI2DZrmbkz,
          13908 => Opcode::VPERMI2DZrmk,
          13909 => Opcode::VPERMI2DZrmkz,
          13910 => Opcode::VPERMI2DZrr,
          13911 => Opcode::VPERMI2DZrrk,
          13912 => Opcode::VPERMI2DZrrkz,
          13913 => Opcode::VPERMI2PDZ128rm,
          13914 => Opcode::VPERMI2PDZ128rmb,
          13915 => Opcode::VPERMI2PDZ128rmbk,
          13916 => Opcode::VPERMI2PDZ128rmbkz,
          13917 => Opcode::VPERMI2PDZ128rmk,
          13918 => Opcode::VPERMI2PDZ128rmkz,
          13919 => Opcode::VPERMI2PDZ128rr,
          13920 => Opcode::VPERMI2PDZ128rrk,
          13921 => Opcode::VPERMI2PDZ128rrkz,
          13922 => Opcode::VPERMI2PDZ256rm,
          13923 => Opcode::VPERMI2PDZ256rmb,
          13924 => Opcode::VPERMI2PDZ256rmbk,
          13925 => Opcode::VPERMI2PDZ256rmbkz,
          13926 => Opcode::VPERMI2PDZ256rmk,
          13927 => Opcode::VPERMI2PDZ256rmkz,
          13928 => Opcode::VPERMI2PDZ256rr,
          13929 => Opcode::VPERMI2PDZ256rrk,
          13930 => Opcode::VPERMI2PDZ256rrkz,
          13931 => Opcode::VPERMI2PDZrm,
          13932 => Opcode::VPERMI2PDZrmb,
          13933 => Opcode::VPERMI2PDZrmbk,
          13934 => Opcode::VPERMI2PDZrmbkz,
          13935 => Opcode::VPERMI2PDZrmk,
          13936 => Opcode::VPERMI2PDZrmkz,
          13937 => Opcode::VPERMI2PDZrr,
          13938 => Opcode::VPERMI2PDZrrk,
          13939 => Opcode::VPERMI2PDZrrkz,
          13940 => Opcode::VPERMI2PSZ128rm,
          13941 => Opcode::VPERMI2PSZ128rmb,
          13942 => Opcode::VPERMI2PSZ128rmbk,
          13943 => Opcode::VPERMI2PSZ128rmbkz,
          13944 => Opcode::VPERMI2PSZ128rmk,
          13945 => Opcode::VPERMI2PSZ128rmkz,
          13946 => Opcode::VPERMI2PSZ128rr,
          13947 => Opcode::VPERMI2PSZ128rrk,
          13948 => Opcode::VPERMI2PSZ128rrkz,
          13949 => Opcode::VPERMI2PSZ256rm,
          13950 => Opcode::VPERMI2PSZ256rmb,
          13951 => Opcode::VPERMI2PSZ256rmbk,
          13952 => Opcode::VPERMI2PSZ256rmbkz,
          13953 => Opcode::VPERMI2PSZ256rmk,
          13954 => Opcode::VPERMI2PSZ256rmkz,
          13955 => Opcode::VPERMI2PSZ256rr,
          13956 => Opcode::VPERMI2PSZ256rrk,
          13957 => Opcode::VPERMI2PSZ256rrkz,
          13958 => Opcode::VPERMI2PSZrm,
          13959 => Opcode::VPERMI2PSZrmb,
          13960 => Opcode::VPERMI2PSZrmbk,
          13961 => Opcode::VPERMI2PSZrmbkz,
          13962 => Opcode::VPERMI2PSZrmk,
          13963 => Opcode::VPERMI2PSZrmkz,
          13964 => Opcode::VPERMI2PSZrr,
          13965 => Opcode::VPERMI2PSZrrk,
          13966 => Opcode::VPERMI2PSZrrkz,
          13967 => Opcode::VPERMI2QZ128rm,
          13968 => Opcode::VPERMI2QZ128rmb,
          13969 => Opcode::VPERMI2QZ128rmbk,
          13970 => Opcode::VPERMI2QZ128rmbkz,
          13971 => Opcode::VPERMI2QZ128rmk,
          13972 => Opcode::VPERMI2QZ128rmkz,
          13973 => Opcode::VPERMI2QZ128rr,
          13974 => Opcode::VPERMI2QZ128rrk,
          13975 => Opcode::VPERMI2QZ128rrkz,
          13976 => Opcode::VPERMI2QZ256rm,
          13977 => Opcode::VPERMI2QZ256rmb,
          13978 => Opcode::VPERMI2QZ256rmbk,
          13979 => Opcode::VPERMI2QZ256rmbkz,
          13980 => Opcode::VPERMI2QZ256rmk,
          13981 => Opcode::VPERMI2QZ256rmkz,
          13982 => Opcode::VPERMI2QZ256rr,
          13983 => Opcode::VPERMI2QZ256rrk,
          13984 => Opcode::VPERMI2QZ256rrkz,
          13985 => Opcode::VPERMI2QZrm,
          13986 => Opcode::VPERMI2QZrmb,
          13987 => Opcode::VPERMI2QZrmbk,
          13988 => Opcode::VPERMI2QZrmbkz,
          13989 => Opcode::VPERMI2QZrmk,
          13990 => Opcode::VPERMI2QZrmkz,
          13991 => Opcode::VPERMI2QZrr,
          13992 => Opcode::VPERMI2QZrrk,
          13993 => Opcode::VPERMI2QZrrkz,
          13994 => Opcode::VPERMI2WZ128rm,
          13995 => Opcode::VPERMI2WZ128rmk,
          13996 => Opcode::VPERMI2WZ128rmkz,
          13997 => Opcode::VPERMI2WZ128rr,
          13998 => Opcode::VPERMI2WZ128rrk,
          13999 => Opcode::VPERMI2WZ128rrkz,
          14000 => Opcode::VPERMI2WZ256rm,
          14001 => Opcode::VPERMI2WZ256rmk,
          14002 => Opcode::VPERMI2WZ256rmkz,
          14003 => Opcode::VPERMI2WZ256rr,
          14004 => Opcode::VPERMI2WZ256rrk,
          14005 => Opcode::VPERMI2WZ256rrkz,
          14006 => Opcode::VPERMI2WZrm,
          14007 => Opcode::VPERMI2WZrmk,
          14008 => Opcode::VPERMI2WZrmkz,
          14009 => Opcode::VPERMI2WZrr,
          14010 => Opcode::VPERMI2WZrrk,
          14011 => Opcode::VPERMI2WZrrkz,
          14012 => Opcode::VPERMIL2PDYmr,
          14013 => Opcode::VPERMIL2PDYrm,
          14014 => Opcode::VPERMIL2PDYrr,
          14015 => Opcode::VPERMIL2PDYrr_REV,
          14016 => Opcode::VPERMIL2PDmr,
          14017 => Opcode::VPERMIL2PDrm,
          14018 => Opcode::VPERMIL2PDrr,
          14019 => Opcode::VPERMIL2PDrr_REV,
          14020 => Opcode::VPERMIL2PSYmr,
          14021 => Opcode::VPERMIL2PSYrm,
          14022 => Opcode::VPERMIL2PSYrr,
          14023 => Opcode::VPERMIL2PSYrr_REV,
          14024 => Opcode::VPERMIL2PSmr,
          14025 => Opcode::VPERMIL2PSrm,
          14026 => Opcode::VPERMIL2PSrr,
          14027 => Opcode::VPERMIL2PSrr_REV,
          14028 => Opcode::VPERMILPDYmi,
          14029 => Opcode::VPERMILPDYri,
          14030 => Opcode::VPERMILPDYrm,
          14031 => Opcode::VPERMILPDYrr,
          14032 => Opcode::VPERMILPDZ128mbi,
          14033 => Opcode::VPERMILPDZ128mbik,
          14034 => Opcode::VPERMILPDZ128mbikz,
          14035 => Opcode::VPERMILPDZ128mi,
          14036 => Opcode::VPERMILPDZ128mik,
          14037 => Opcode::VPERMILPDZ128mikz,
          14038 => Opcode::VPERMILPDZ128ri,
          14039 => Opcode::VPERMILPDZ128rik,
          14040 => Opcode::VPERMILPDZ128rikz,
          14041 => Opcode::VPERMILPDZ128rm,
          14042 => Opcode::VPERMILPDZ128rmb,
          14043 => Opcode::VPERMILPDZ128rmbk,
          14044 => Opcode::VPERMILPDZ128rmbkz,
          14045 => Opcode::VPERMILPDZ128rmk,
          14046 => Opcode::VPERMILPDZ128rmkz,
          14047 => Opcode::VPERMILPDZ128rr,
          14048 => Opcode::VPERMILPDZ128rrk,
          14049 => Opcode::VPERMILPDZ128rrkz,
          14050 => Opcode::VPERMILPDZ256mbi,
          14051 => Opcode::VPERMILPDZ256mbik,
          14052 => Opcode::VPERMILPDZ256mbikz,
          14053 => Opcode::VPERMILPDZ256mi,
          14054 => Opcode::VPERMILPDZ256mik,
          14055 => Opcode::VPERMILPDZ256mikz,
          14056 => Opcode::VPERMILPDZ256ri,
          14057 => Opcode::VPERMILPDZ256rik,
          14058 => Opcode::VPERMILPDZ256rikz,
          14059 => Opcode::VPERMILPDZ256rm,
          14060 => Opcode::VPERMILPDZ256rmb,
          14061 => Opcode::VPERMILPDZ256rmbk,
          14062 => Opcode::VPERMILPDZ256rmbkz,
          14063 => Opcode::VPERMILPDZ256rmk,
          14064 => Opcode::VPERMILPDZ256rmkz,
          14065 => Opcode::VPERMILPDZ256rr,
          14066 => Opcode::VPERMILPDZ256rrk,
          14067 => Opcode::VPERMILPDZ256rrkz,
          14068 => Opcode::VPERMILPDZmbi,
          14069 => Opcode::VPERMILPDZmbik,
          14070 => Opcode::VPERMILPDZmbikz,
          14071 => Opcode::VPERMILPDZmi,
          14072 => Opcode::VPERMILPDZmik,
          14073 => Opcode::VPERMILPDZmikz,
          14074 => Opcode::VPERMILPDZri,
          14075 => Opcode::VPERMILPDZrik,
          14076 => Opcode::VPERMILPDZrikz,
          14077 => Opcode::VPERMILPDZrm,
          14078 => Opcode::VPERMILPDZrmb,
          14079 => Opcode::VPERMILPDZrmbk,
          14080 => Opcode::VPERMILPDZrmbkz,
          14081 => Opcode::VPERMILPDZrmk,
          14082 => Opcode::VPERMILPDZrmkz,
          14083 => Opcode::VPERMILPDZrr,
          14084 => Opcode::VPERMILPDZrrk,
          14085 => Opcode::VPERMILPDZrrkz,
          14086 => Opcode::VPERMILPDmi,
          14087 => Opcode::VPERMILPDri,
          14088 => Opcode::VPERMILPDrm,
          14089 => Opcode::VPERMILPDrr,
          14090 => Opcode::VPERMILPSYmi,
          14091 => Opcode::VPERMILPSYri,
          14092 => Opcode::VPERMILPSYrm,
          14093 => Opcode::VPERMILPSYrr,
          14094 => Opcode::VPERMILPSZ128mbi,
          14095 => Opcode::VPERMILPSZ128mbik,
          14096 => Opcode::VPERMILPSZ128mbikz,
          14097 => Opcode::VPERMILPSZ128mi,
          14098 => Opcode::VPERMILPSZ128mik,
          14099 => Opcode::VPERMILPSZ128mikz,
          14100 => Opcode::VPERMILPSZ128ri,
          14101 => Opcode::VPERMILPSZ128rik,
          14102 => Opcode::VPERMILPSZ128rikz,
          14103 => Opcode::VPERMILPSZ128rm,
          14104 => Opcode::VPERMILPSZ128rmb,
          14105 => Opcode::VPERMILPSZ128rmbk,
          14106 => Opcode::VPERMILPSZ128rmbkz,
          14107 => Opcode::VPERMILPSZ128rmk,
          14108 => Opcode::VPERMILPSZ128rmkz,
          14109 => Opcode::VPERMILPSZ128rr,
          14110 => Opcode::VPERMILPSZ128rrk,
          14111 => Opcode::VPERMILPSZ128rrkz,
          14112 => Opcode::VPERMILPSZ256mbi,
          14113 => Opcode::VPERMILPSZ256mbik,
          14114 => Opcode::VPERMILPSZ256mbikz,
          14115 => Opcode::VPERMILPSZ256mi,
          14116 => Opcode::VPERMILPSZ256mik,
          14117 => Opcode::VPERMILPSZ256mikz,
          14118 => Opcode::VPERMILPSZ256ri,
          14119 => Opcode::VPERMILPSZ256rik,
          14120 => Opcode::VPERMILPSZ256rikz,
          14121 => Opcode::VPERMILPSZ256rm,
          14122 => Opcode::VPERMILPSZ256rmb,
          14123 => Opcode::VPERMILPSZ256rmbk,
          14124 => Opcode::VPERMILPSZ256rmbkz,
          14125 => Opcode::VPERMILPSZ256rmk,
          14126 => Opcode::VPERMILPSZ256rmkz,
          14127 => Opcode::VPERMILPSZ256rr,
          14128 => Opcode::VPERMILPSZ256rrk,
          14129 => Opcode::VPERMILPSZ256rrkz,
          14130 => Opcode::VPERMILPSZmbi,
          14131 => Opcode::VPERMILPSZmbik,
          14132 => Opcode::VPERMILPSZmbikz,
          14133 => Opcode::VPERMILPSZmi,
          14134 => Opcode::VPERMILPSZmik,
          14135 => Opcode::VPERMILPSZmikz,
          14136 => Opcode::VPERMILPSZri,
          14137 => Opcode::VPERMILPSZrik,
          14138 => Opcode::VPERMILPSZrikz,
          14139 => Opcode::VPERMILPSZrm,
          14140 => Opcode::VPERMILPSZrmb,
          14141 => Opcode::VPERMILPSZrmbk,
          14142 => Opcode::VPERMILPSZrmbkz,
          14143 => Opcode::VPERMILPSZrmk,
          14144 => Opcode::VPERMILPSZrmkz,
          14145 => Opcode::VPERMILPSZrr,
          14146 => Opcode::VPERMILPSZrrk,
          14147 => Opcode::VPERMILPSZrrkz,
          14148 => Opcode::VPERMILPSmi,
          14149 => Opcode::VPERMILPSri,
          14150 => Opcode::VPERMILPSrm,
          14151 => Opcode::VPERMILPSrr,
          14152 => Opcode::VPERMPDYmi,
          14153 => Opcode::VPERMPDYri,
          14154 => Opcode::VPERMPDZ256mbi,
          14155 => Opcode::VPERMPDZ256mbik,
          14156 => Opcode::VPERMPDZ256mbikz,
          14157 => Opcode::VPERMPDZ256mi,
          14158 => Opcode::VPERMPDZ256mik,
          14159 => Opcode::VPERMPDZ256mikz,
          14160 => Opcode::VPERMPDZ256ri,
          14161 => Opcode::VPERMPDZ256rik,
          14162 => Opcode::VPERMPDZ256rikz,
          14163 => Opcode::VPERMPDZ256rm,
          14164 => Opcode::VPERMPDZ256rmb,
          14165 => Opcode::VPERMPDZ256rmbk,
          14166 => Opcode::VPERMPDZ256rmbkz,
          14167 => Opcode::VPERMPDZ256rmk,
          14168 => Opcode::VPERMPDZ256rmkz,
          14169 => Opcode::VPERMPDZ256rr,
          14170 => Opcode::VPERMPDZ256rrk,
          14171 => Opcode::VPERMPDZ256rrkz,
          14172 => Opcode::VPERMPDZmbi,
          14173 => Opcode::VPERMPDZmbik,
          14174 => Opcode::VPERMPDZmbikz,
          14175 => Opcode::VPERMPDZmi,
          14176 => Opcode::VPERMPDZmik,
          14177 => Opcode::VPERMPDZmikz,
          14178 => Opcode::VPERMPDZri,
          14179 => Opcode::VPERMPDZrik,
          14180 => Opcode::VPERMPDZrikz,
          14181 => Opcode::VPERMPDZrm,
          14182 => Opcode::VPERMPDZrmb,
          14183 => Opcode::VPERMPDZrmbk,
          14184 => Opcode::VPERMPDZrmbkz,
          14185 => Opcode::VPERMPDZrmk,
          14186 => Opcode::VPERMPDZrmkz,
          14187 => Opcode::VPERMPDZrr,
          14188 => Opcode::VPERMPDZrrk,
          14189 => Opcode::VPERMPDZrrkz,
          14190 => Opcode::VPERMPSYrm,
          14191 => Opcode::VPERMPSYrr,
          14192 => Opcode::VPERMPSZ256rm,
          14193 => Opcode::VPERMPSZ256rmb,
          14194 => Opcode::VPERMPSZ256rmbk,
          14195 => Opcode::VPERMPSZ256rmbkz,
          14196 => Opcode::VPERMPSZ256rmk,
          14197 => Opcode::VPERMPSZ256rmkz,
          14198 => Opcode::VPERMPSZ256rr,
          14199 => Opcode::VPERMPSZ256rrk,
          14200 => Opcode::VPERMPSZ256rrkz,
          14201 => Opcode::VPERMPSZrm,
          14202 => Opcode::VPERMPSZrmb,
          14203 => Opcode::VPERMPSZrmbk,
          14204 => Opcode::VPERMPSZrmbkz,
          14205 => Opcode::VPERMPSZrmk,
          14206 => Opcode::VPERMPSZrmkz,
          14207 => Opcode::VPERMPSZrr,
          14208 => Opcode::VPERMPSZrrk,
          14209 => Opcode::VPERMPSZrrkz,
          14210 => Opcode::VPERMQYmi,
          14211 => Opcode::VPERMQYri,
          14212 => Opcode::VPERMQZ256mbi,
          14213 => Opcode::VPERMQZ256mbik,
          14214 => Opcode::VPERMQZ256mbikz,
          14215 => Opcode::VPERMQZ256mi,
          14216 => Opcode::VPERMQZ256mik,
          14217 => Opcode::VPERMQZ256mikz,
          14218 => Opcode::VPERMQZ256ri,
          14219 => Opcode::VPERMQZ256rik,
          14220 => Opcode::VPERMQZ256rikz,
          14221 => Opcode::VPERMQZ256rm,
          14222 => Opcode::VPERMQZ256rmb,
          14223 => Opcode::VPERMQZ256rmbk,
          14224 => Opcode::VPERMQZ256rmbkz,
          14225 => Opcode::VPERMQZ256rmk,
          14226 => Opcode::VPERMQZ256rmkz,
          14227 => Opcode::VPERMQZ256rr,
          14228 => Opcode::VPERMQZ256rrk,
          14229 => Opcode::VPERMQZ256rrkz,
          14230 => Opcode::VPERMQZmbi,
          14231 => Opcode::VPERMQZmbik,
          14232 => Opcode::VPERMQZmbikz,
          14233 => Opcode::VPERMQZmi,
          14234 => Opcode::VPERMQZmik,
          14235 => Opcode::VPERMQZmikz,
          14236 => Opcode::VPERMQZri,
          14237 => Opcode::VPERMQZrik,
          14238 => Opcode::VPERMQZrikz,
          14239 => Opcode::VPERMQZrm,
          14240 => Opcode::VPERMQZrmb,
          14241 => Opcode::VPERMQZrmbk,
          14242 => Opcode::VPERMQZrmbkz,
          14243 => Opcode::VPERMQZrmk,
          14244 => Opcode::VPERMQZrmkz,
          14245 => Opcode::VPERMQZrr,
          14246 => Opcode::VPERMQZrrk,
          14247 => Opcode::VPERMQZrrkz,
          14248 => Opcode::VPERMT2BZ128rm,
          14249 => Opcode::VPERMT2BZ128rmk,
          14250 => Opcode::VPERMT2BZ128rmkz,
          14251 => Opcode::VPERMT2BZ128rr,
          14252 => Opcode::VPERMT2BZ128rrk,
          14253 => Opcode::VPERMT2BZ128rrkz,
          14254 => Opcode::VPERMT2BZ256rm,
          14255 => Opcode::VPERMT2BZ256rmk,
          14256 => Opcode::VPERMT2BZ256rmkz,
          14257 => Opcode::VPERMT2BZ256rr,
          14258 => Opcode::VPERMT2BZ256rrk,
          14259 => Opcode::VPERMT2BZ256rrkz,
          14260 => Opcode::VPERMT2BZrm,
          14261 => Opcode::VPERMT2BZrmk,
          14262 => Opcode::VPERMT2BZrmkz,
          14263 => Opcode::VPERMT2BZrr,
          14264 => Opcode::VPERMT2BZrrk,
          14265 => Opcode::VPERMT2BZrrkz,
          14266 => Opcode::VPERMT2DZ128rm,
          14267 => Opcode::VPERMT2DZ128rmb,
          14268 => Opcode::VPERMT2DZ128rmbk,
          14269 => Opcode::VPERMT2DZ128rmbkz,
          14270 => Opcode::VPERMT2DZ128rmk,
          14271 => Opcode::VPERMT2DZ128rmkz,
          14272 => Opcode::VPERMT2DZ128rr,
          14273 => Opcode::VPERMT2DZ128rrk,
          14274 => Opcode::VPERMT2DZ128rrkz,
          14275 => Opcode::VPERMT2DZ256rm,
          14276 => Opcode::VPERMT2DZ256rmb,
          14277 => Opcode::VPERMT2DZ256rmbk,
          14278 => Opcode::VPERMT2DZ256rmbkz,
          14279 => Opcode::VPERMT2DZ256rmk,
          14280 => Opcode::VPERMT2DZ256rmkz,
          14281 => Opcode::VPERMT2DZ256rr,
          14282 => Opcode::VPERMT2DZ256rrk,
          14283 => Opcode::VPERMT2DZ256rrkz,
          14284 => Opcode::VPERMT2DZrm,
          14285 => Opcode::VPERMT2DZrmb,
          14286 => Opcode::VPERMT2DZrmbk,
          14287 => Opcode::VPERMT2DZrmbkz,
          14288 => Opcode::VPERMT2DZrmk,
          14289 => Opcode::VPERMT2DZrmkz,
          14290 => Opcode::VPERMT2DZrr,
          14291 => Opcode::VPERMT2DZrrk,
          14292 => Opcode::VPERMT2DZrrkz,
          14293 => Opcode::VPERMT2PDZ128rm,
          14294 => Opcode::VPERMT2PDZ128rmb,
          14295 => Opcode::VPERMT2PDZ128rmbk,
          14296 => Opcode::VPERMT2PDZ128rmbkz,
          14297 => Opcode::VPERMT2PDZ128rmk,
          14298 => Opcode::VPERMT2PDZ128rmkz,
          14299 => Opcode::VPERMT2PDZ128rr,
          14300 => Opcode::VPERMT2PDZ128rrk,
          14301 => Opcode::VPERMT2PDZ128rrkz,
          14302 => Opcode::VPERMT2PDZ256rm,
          14303 => Opcode::VPERMT2PDZ256rmb,
          14304 => Opcode::VPERMT2PDZ256rmbk,
          14305 => Opcode::VPERMT2PDZ256rmbkz,
          14306 => Opcode::VPERMT2PDZ256rmk,
          14307 => Opcode::VPERMT2PDZ256rmkz,
          14308 => Opcode::VPERMT2PDZ256rr,
          14309 => Opcode::VPERMT2PDZ256rrk,
          14310 => Opcode::VPERMT2PDZ256rrkz,
          14311 => Opcode::VPERMT2PDZrm,
          14312 => Opcode::VPERMT2PDZrmb,
          14313 => Opcode::VPERMT2PDZrmbk,
          14314 => Opcode::VPERMT2PDZrmbkz,
          14315 => Opcode::VPERMT2PDZrmk,
          14316 => Opcode::VPERMT2PDZrmkz,
          14317 => Opcode::VPERMT2PDZrr,
          14318 => Opcode::VPERMT2PDZrrk,
          14319 => Opcode::VPERMT2PDZrrkz,
          14320 => Opcode::VPERMT2PSZ128rm,
          14321 => Opcode::VPERMT2PSZ128rmb,
          14322 => Opcode::VPERMT2PSZ128rmbk,
          14323 => Opcode::VPERMT2PSZ128rmbkz,
          14324 => Opcode::VPERMT2PSZ128rmk,
          14325 => Opcode::VPERMT2PSZ128rmkz,
          14326 => Opcode::VPERMT2PSZ128rr,
          14327 => Opcode::VPERMT2PSZ128rrk,
          14328 => Opcode::VPERMT2PSZ128rrkz,
          14329 => Opcode::VPERMT2PSZ256rm,
          14330 => Opcode::VPERMT2PSZ256rmb,
          14331 => Opcode::VPERMT2PSZ256rmbk,
          14332 => Opcode::VPERMT2PSZ256rmbkz,
          14333 => Opcode::VPERMT2PSZ256rmk,
          14334 => Opcode::VPERMT2PSZ256rmkz,
          14335 => Opcode::VPERMT2PSZ256rr,
          14336 => Opcode::VPERMT2PSZ256rrk,
          14337 => Opcode::VPERMT2PSZ256rrkz,
          14338 => Opcode::VPERMT2PSZrm,
          14339 => Opcode::VPERMT2PSZrmb,
          14340 => Opcode::VPERMT2PSZrmbk,
          14341 => Opcode::VPERMT2PSZrmbkz,
          14342 => Opcode::VPERMT2PSZrmk,
          14343 => Opcode::VPERMT2PSZrmkz,
          14344 => Opcode::VPERMT2PSZrr,
          14345 => Opcode::VPERMT2PSZrrk,
          14346 => Opcode::VPERMT2PSZrrkz,
          14347 => Opcode::VPERMT2QZ128rm,
          14348 => Opcode::VPERMT2QZ128rmb,
          14349 => Opcode::VPERMT2QZ128rmbk,
          14350 => Opcode::VPERMT2QZ128rmbkz,
          14351 => Opcode::VPERMT2QZ128rmk,
          14352 => Opcode::VPERMT2QZ128rmkz,
          14353 => Opcode::VPERMT2QZ128rr,
          14354 => Opcode::VPERMT2QZ128rrk,
          14355 => Opcode::VPERMT2QZ128rrkz,
          14356 => Opcode::VPERMT2QZ256rm,
          14357 => Opcode::VPERMT2QZ256rmb,
          14358 => Opcode::VPERMT2QZ256rmbk,
          14359 => Opcode::VPERMT2QZ256rmbkz,
          14360 => Opcode::VPERMT2QZ256rmk,
          14361 => Opcode::VPERMT2QZ256rmkz,
          14362 => Opcode::VPERMT2QZ256rr,
          14363 => Opcode::VPERMT2QZ256rrk,
          14364 => Opcode::VPERMT2QZ256rrkz,
          14365 => Opcode::VPERMT2QZrm,
          14366 => Opcode::VPERMT2QZrmb,
          14367 => Opcode::VPERMT2QZrmbk,
          14368 => Opcode::VPERMT2QZrmbkz,
          14369 => Opcode::VPERMT2QZrmk,
          14370 => Opcode::VPERMT2QZrmkz,
          14371 => Opcode::VPERMT2QZrr,
          14372 => Opcode::VPERMT2QZrrk,
          14373 => Opcode::VPERMT2QZrrkz,
          14374 => Opcode::VPERMT2WZ128rm,
          14375 => Opcode::VPERMT2WZ128rmk,
          14376 => Opcode::VPERMT2WZ128rmkz,
          14377 => Opcode::VPERMT2WZ128rr,
          14378 => Opcode::VPERMT2WZ128rrk,
          14379 => Opcode::VPERMT2WZ128rrkz,
          14380 => Opcode::VPERMT2WZ256rm,
          14381 => Opcode::VPERMT2WZ256rmk,
          14382 => Opcode::VPERMT2WZ256rmkz,
          14383 => Opcode::VPERMT2WZ256rr,
          14384 => Opcode::VPERMT2WZ256rrk,
          14385 => Opcode::VPERMT2WZ256rrkz,
          14386 => Opcode::VPERMT2WZrm,
          14387 => Opcode::VPERMT2WZrmk,
          14388 => Opcode::VPERMT2WZrmkz,
          14389 => Opcode::VPERMT2WZrr,
          14390 => Opcode::VPERMT2WZrrk,
          14391 => Opcode::VPERMT2WZrrkz,
          14392 => Opcode::VPERMWZ128rm,
          14393 => Opcode::VPERMWZ128rmk,
          14394 => Opcode::VPERMWZ128rmkz,
          14395 => Opcode::VPERMWZ128rr,
          14396 => Opcode::VPERMWZ128rrk,
          14397 => Opcode::VPERMWZ128rrkz,
          14398 => Opcode::VPERMWZ256rm,
          14399 => Opcode::VPERMWZ256rmk,
          14400 => Opcode::VPERMWZ256rmkz,
          14401 => Opcode::VPERMWZ256rr,
          14402 => Opcode::VPERMWZ256rrk,
          14403 => Opcode::VPERMWZ256rrkz,
          14404 => Opcode::VPERMWZrm,
          14405 => Opcode::VPERMWZrmk,
          14406 => Opcode::VPERMWZrmkz,
          14407 => Opcode::VPERMWZrr,
          14408 => Opcode::VPERMWZrrk,
          14409 => Opcode::VPERMWZrrkz,
          14410 => Opcode::VPEXPANDBZ128rm,
          14411 => Opcode::VPEXPANDBZ128rmk,
          14412 => Opcode::VPEXPANDBZ128rmkz,
          14413 => Opcode::VPEXPANDBZ128rr,
          14414 => Opcode::VPEXPANDBZ128rrk,
          14415 => Opcode::VPEXPANDBZ128rrkz,
          14416 => Opcode::VPEXPANDBZ256rm,
          14417 => Opcode::VPEXPANDBZ256rmk,
          14418 => Opcode::VPEXPANDBZ256rmkz,
          14419 => Opcode::VPEXPANDBZ256rr,
          14420 => Opcode::VPEXPANDBZ256rrk,
          14421 => Opcode::VPEXPANDBZ256rrkz,
          14422 => Opcode::VPEXPANDBZrm,
          14423 => Opcode::VPEXPANDBZrmk,
          14424 => Opcode::VPEXPANDBZrmkz,
          14425 => Opcode::VPEXPANDBZrr,
          14426 => Opcode::VPEXPANDBZrrk,
          14427 => Opcode::VPEXPANDBZrrkz,
          14428 => Opcode::VPEXPANDDZ128rm,
          14429 => Opcode::VPEXPANDDZ128rmk,
          14430 => Opcode::VPEXPANDDZ128rmkz,
          14431 => Opcode::VPEXPANDDZ128rr,
          14432 => Opcode::VPEXPANDDZ128rrk,
          14433 => Opcode::VPEXPANDDZ128rrkz,
          14434 => Opcode::VPEXPANDDZ256rm,
          14435 => Opcode::VPEXPANDDZ256rmk,
          14436 => Opcode::VPEXPANDDZ256rmkz,
          14437 => Opcode::VPEXPANDDZ256rr,
          14438 => Opcode::VPEXPANDDZ256rrk,
          14439 => Opcode::VPEXPANDDZ256rrkz,
          14440 => Opcode::VPEXPANDDZrm,
          14441 => Opcode::VPEXPANDDZrmk,
          14442 => Opcode::VPEXPANDDZrmkz,
          14443 => Opcode::VPEXPANDDZrr,
          14444 => Opcode::VPEXPANDDZrrk,
          14445 => Opcode::VPEXPANDDZrrkz,
          14446 => Opcode::VPEXPANDQZ128rm,
          14447 => Opcode::VPEXPANDQZ128rmk,
          14448 => Opcode::VPEXPANDQZ128rmkz,
          14449 => Opcode::VPEXPANDQZ128rr,
          14450 => Opcode::VPEXPANDQZ128rrk,
          14451 => Opcode::VPEXPANDQZ128rrkz,
          14452 => Opcode::VPEXPANDQZ256rm,
          14453 => Opcode::VPEXPANDQZ256rmk,
          14454 => Opcode::VPEXPANDQZ256rmkz,
          14455 => Opcode::VPEXPANDQZ256rr,
          14456 => Opcode::VPEXPANDQZ256rrk,
          14457 => Opcode::VPEXPANDQZ256rrkz,
          14458 => Opcode::VPEXPANDQZrm,
          14459 => Opcode::VPEXPANDQZrmk,
          14460 => Opcode::VPEXPANDQZrmkz,
          14461 => Opcode::VPEXPANDQZrr,
          14462 => Opcode::VPEXPANDQZrrk,
          14463 => Opcode::VPEXPANDQZrrkz,
          14464 => Opcode::VPEXPANDWZ128rm,
          14465 => Opcode::VPEXPANDWZ128rmk,
          14466 => Opcode::VPEXPANDWZ128rmkz,
          14467 => Opcode::VPEXPANDWZ128rr,
          14468 => Opcode::VPEXPANDWZ128rrk,
          14469 => Opcode::VPEXPANDWZ128rrkz,
          14470 => Opcode::VPEXPANDWZ256rm,
          14471 => Opcode::VPEXPANDWZ256rmk,
          14472 => Opcode::VPEXPANDWZ256rmkz,
          14473 => Opcode::VPEXPANDWZ256rr,
          14474 => Opcode::VPEXPANDWZ256rrk,
          14475 => Opcode::VPEXPANDWZ256rrkz,
          14476 => Opcode::VPEXPANDWZrm,
          14477 => Opcode::VPEXPANDWZrmk,
          14478 => Opcode::VPEXPANDWZrmkz,
          14479 => Opcode::VPEXPANDWZrr,
          14480 => Opcode::VPEXPANDWZrrk,
          14481 => Opcode::VPEXPANDWZrrkz,
          14482 => Opcode::VPEXTRBZmr,
          14483 => Opcode::VPEXTRBZrr,
          14484 => Opcode::VPEXTRBmr,
          14485 => Opcode::VPEXTRBrr,
          14486 => Opcode::VPEXTRDZmr,
          14487 => Opcode::VPEXTRDZrr,
          14488 => Opcode::VPEXTRDmr,
          14489 => Opcode::VPEXTRDrr,
          14490 => Opcode::VPEXTRQZmr,
          14491 => Opcode::VPEXTRQZrr,
          14492 => Opcode::VPEXTRQmr,
          14493 => Opcode::VPEXTRQrr,
          14494 => Opcode::VPEXTRWZmr,
          14495 => Opcode::VPEXTRWZrr,
          14496 => Opcode::VPEXTRWZrr_REV,
          14497 => Opcode::VPEXTRWmr,
          14498 => Opcode::VPEXTRWrr,
          14499 => Opcode::VPEXTRWrr_REV,
          14500 => Opcode::VPGATHERDDYrm,
          14501 => Opcode::VPGATHERDDZ128rm,
          14502 => Opcode::VPGATHERDDZ256rm,
          14503 => Opcode::VPGATHERDDZrm,
          14504 => Opcode::VPGATHERDDrm,
          14505 => Opcode::VPGATHERDQYrm,
          14506 => Opcode::VPGATHERDQZ128rm,
          14507 => Opcode::VPGATHERDQZ256rm,
          14508 => Opcode::VPGATHERDQZrm,
          14509 => Opcode::VPGATHERDQrm,
          14510 => Opcode::VPGATHERQDYrm,
          14511 => Opcode::VPGATHERQDZ128rm,
          14512 => Opcode::VPGATHERQDZ256rm,
          14513 => Opcode::VPGATHERQDZrm,
          14514 => Opcode::VPGATHERQDrm,
          14515 => Opcode::VPGATHERQQYrm,
          14516 => Opcode::VPGATHERQQZ128rm,
          14517 => Opcode::VPGATHERQQZ256rm,
          14518 => Opcode::VPGATHERQQZrm,
          14519 => Opcode::VPGATHERQQrm,
          14520 => Opcode::VPHADDBDrm,
          14521 => Opcode::VPHADDBDrr,
          14522 => Opcode::VPHADDBQrm,
          14523 => Opcode::VPHADDBQrr,
          14524 => Opcode::VPHADDBWrm,
          14525 => Opcode::VPHADDBWrr,
          14526 => Opcode::VPHADDDQrm,
          14527 => Opcode::VPHADDDQrr,
          14528 => Opcode::VPHADDDYrm,
          14529 => Opcode::VPHADDDYrr,
          14530 => Opcode::VPHADDDrm,
          14531 => Opcode::VPHADDDrr,
          14532 => Opcode::VPHADDSWYrm,
          14533 => Opcode::VPHADDSWYrr,
          14534 => Opcode::VPHADDSWrm,
          14535 => Opcode::VPHADDSWrr,
          14536 => Opcode::VPHADDUBDrm,
          14537 => Opcode::VPHADDUBDrr,
          14538 => Opcode::VPHADDUBQrm,
          14539 => Opcode::VPHADDUBQrr,
          14540 => Opcode::VPHADDUBWrm,
          14541 => Opcode::VPHADDUBWrr,
          14542 => Opcode::VPHADDUDQrm,
          14543 => Opcode::VPHADDUDQrr,
          14544 => Opcode::VPHADDUWDrm,
          14545 => Opcode::VPHADDUWDrr,
          14546 => Opcode::VPHADDUWQrm,
          14547 => Opcode::VPHADDUWQrr,
          14548 => Opcode::VPHADDWDrm,
          14549 => Opcode::VPHADDWDrr,
          14550 => Opcode::VPHADDWQrm,
          14551 => Opcode::VPHADDWQrr,
          14552 => Opcode::VPHADDWYrm,
          14553 => Opcode::VPHADDWYrr,
          14554 => Opcode::VPHADDWrm,
          14555 => Opcode::VPHADDWrr,
          14556 => Opcode::VPHMINPOSUWrm,
          14557 => Opcode::VPHMINPOSUWrr,
          14558 => Opcode::VPHSUBBWrm,
          14559 => Opcode::VPHSUBBWrr,
          14560 => Opcode::VPHSUBDQrm,
          14561 => Opcode::VPHSUBDQrr,
          14562 => Opcode::VPHSUBDYrm,
          14563 => Opcode::VPHSUBDYrr,
          14564 => Opcode::VPHSUBDrm,
          14565 => Opcode::VPHSUBDrr,
          14566 => Opcode::VPHSUBSWYrm,
          14567 => Opcode::VPHSUBSWYrr,
          14568 => Opcode::VPHSUBSWrm,
          14569 => Opcode::VPHSUBSWrr,
          14570 => Opcode::VPHSUBWDrm,
          14571 => Opcode::VPHSUBWDrr,
          14572 => Opcode::VPHSUBWYrm,
          14573 => Opcode::VPHSUBWYrr,
          14574 => Opcode::VPHSUBWrm,
          14575 => Opcode::VPHSUBWrr,
          14576 => Opcode::VPINSRBZrm,
          14577 => Opcode::VPINSRBZrr,
          14578 => Opcode::VPINSRBrm,
          14579 => Opcode::VPINSRBrr,
          14580 => Opcode::VPINSRDZrm,
          14581 => Opcode::VPINSRDZrr,
          14582 => Opcode::VPINSRDrm,
          14583 => Opcode::VPINSRDrr,
          14584 => Opcode::VPINSRQZrm,
          14585 => Opcode::VPINSRQZrr,
          14586 => Opcode::VPINSRQrm,
          14587 => Opcode::VPINSRQrr,
          14588 => Opcode::VPINSRWZrm,
          14589 => Opcode::VPINSRWZrr,
          14590 => Opcode::VPINSRWrm,
          14591 => Opcode::VPINSRWrr,
          14592 => Opcode::VPLZCNTDZ128rm,
          14593 => Opcode::VPLZCNTDZ128rmb,
          14594 => Opcode::VPLZCNTDZ128rmbk,
          14595 => Opcode::VPLZCNTDZ128rmbkz,
          14596 => Opcode::VPLZCNTDZ128rmk,
          14597 => Opcode::VPLZCNTDZ128rmkz,
          14598 => Opcode::VPLZCNTDZ128rr,
          14599 => Opcode::VPLZCNTDZ128rrk,
          14600 => Opcode::VPLZCNTDZ128rrkz,
          14601 => Opcode::VPLZCNTDZ256rm,
          14602 => Opcode::VPLZCNTDZ256rmb,
          14603 => Opcode::VPLZCNTDZ256rmbk,
          14604 => Opcode::VPLZCNTDZ256rmbkz,
          14605 => Opcode::VPLZCNTDZ256rmk,
          14606 => Opcode::VPLZCNTDZ256rmkz,
          14607 => Opcode::VPLZCNTDZ256rr,
          14608 => Opcode::VPLZCNTDZ256rrk,
          14609 => Opcode::VPLZCNTDZ256rrkz,
          14610 => Opcode::VPLZCNTDZrm,
          14611 => Opcode::VPLZCNTDZrmb,
          14612 => Opcode::VPLZCNTDZrmbk,
          14613 => Opcode::VPLZCNTDZrmbkz,
          14614 => Opcode::VPLZCNTDZrmk,
          14615 => Opcode::VPLZCNTDZrmkz,
          14616 => Opcode::VPLZCNTDZrr,
          14617 => Opcode::VPLZCNTDZrrk,
          14618 => Opcode::VPLZCNTDZrrkz,
          14619 => Opcode::VPLZCNTQZ128rm,
          14620 => Opcode::VPLZCNTQZ128rmb,
          14621 => Opcode::VPLZCNTQZ128rmbk,
          14622 => Opcode::VPLZCNTQZ128rmbkz,
          14623 => Opcode::VPLZCNTQZ128rmk,
          14624 => Opcode::VPLZCNTQZ128rmkz,
          14625 => Opcode::VPLZCNTQZ128rr,
          14626 => Opcode::VPLZCNTQZ128rrk,
          14627 => Opcode::VPLZCNTQZ128rrkz,
          14628 => Opcode::VPLZCNTQZ256rm,
          14629 => Opcode::VPLZCNTQZ256rmb,
          14630 => Opcode::VPLZCNTQZ256rmbk,
          14631 => Opcode::VPLZCNTQZ256rmbkz,
          14632 => Opcode::VPLZCNTQZ256rmk,
          14633 => Opcode::VPLZCNTQZ256rmkz,
          14634 => Opcode::VPLZCNTQZ256rr,
          14635 => Opcode::VPLZCNTQZ256rrk,
          14636 => Opcode::VPLZCNTQZ256rrkz,
          14637 => Opcode::VPLZCNTQZrm,
          14638 => Opcode::VPLZCNTQZrmb,
          14639 => Opcode::VPLZCNTQZrmbk,
          14640 => Opcode::VPLZCNTQZrmbkz,
          14641 => Opcode::VPLZCNTQZrmk,
          14642 => Opcode::VPLZCNTQZrmkz,
          14643 => Opcode::VPLZCNTQZrr,
          14644 => Opcode::VPLZCNTQZrrk,
          14645 => Opcode::VPLZCNTQZrrkz,
          14646 => Opcode::VPMACSDDrm,
          14647 => Opcode::VPMACSDDrr,
          14648 => Opcode::VPMACSDQHrm,
          14649 => Opcode::VPMACSDQHrr,
          14650 => Opcode::VPMACSDQLrm,
          14651 => Opcode::VPMACSDQLrr,
          14652 => Opcode::VPMACSSDDrm,
          14653 => Opcode::VPMACSSDDrr,
          14654 => Opcode::VPMACSSDQHrm,
          14655 => Opcode::VPMACSSDQHrr,
          14656 => Opcode::VPMACSSDQLrm,
          14657 => Opcode::VPMACSSDQLrr,
          14658 => Opcode::VPMACSSWDrm,
          14659 => Opcode::VPMACSSWDrr,
          14660 => Opcode::VPMACSSWWrm,
          14661 => Opcode::VPMACSSWWrr,
          14662 => Opcode::VPMACSWDrm,
          14663 => Opcode::VPMACSWDrr,
          14664 => Opcode::VPMACSWWrm,
          14665 => Opcode::VPMACSWWrr,
          14666 => Opcode::VPMADCSSWDrm,
          14667 => Opcode::VPMADCSSWDrr,
          14668 => Opcode::VPMADCSWDrm,
          14669 => Opcode::VPMADCSWDrr,
          14670 => Opcode::VPMADD52HUQYrm,
          14671 => Opcode::VPMADD52HUQYrr,
          14672 => Opcode::VPMADD52HUQZ128m,
          14673 => Opcode::VPMADD52HUQZ128mb,
          14674 => Opcode::VPMADD52HUQZ128mbk,
          14675 => Opcode::VPMADD52HUQZ128mbkz,
          14676 => Opcode::VPMADD52HUQZ128mk,
          14677 => Opcode::VPMADD52HUQZ128mkz,
          14678 => Opcode::VPMADD52HUQZ128r,
          14679 => Opcode::VPMADD52HUQZ128rk,
          14680 => Opcode::VPMADD52HUQZ128rkz,
          14681 => Opcode::VPMADD52HUQZ256m,
          14682 => Opcode::VPMADD52HUQZ256mb,
          14683 => Opcode::VPMADD52HUQZ256mbk,
          14684 => Opcode::VPMADD52HUQZ256mbkz,
          14685 => Opcode::VPMADD52HUQZ256mk,
          14686 => Opcode::VPMADD52HUQZ256mkz,
          14687 => Opcode::VPMADD52HUQZ256r,
          14688 => Opcode::VPMADD52HUQZ256rk,
          14689 => Opcode::VPMADD52HUQZ256rkz,
          14690 => Opcode::VPMADD52HUQZm,
          14691 => Opcode::VPMADD52HUQZmb,
          14692 => Opcode::VPMADD52HUQZmbk,
          14693 => Opcode::VPMADD52HUQZmbkz,
          14694 => Opcode::VPMADD52HUQZmk,
          14695 => Opcode::VPMADD52HUQZmkz,
          14696 => Opcode::VPMADD52HUQZr,
          14697 => Opcode::VPMADD52HUQZrk,
          14698 => Opcode::VPMADD52HUQZrkz,
          14699 => Opcode::VPMADD52HUQrm,
          14700 => Opcode::VPMADD52HUQrr,
          14701 => Opcode::VPMADD52LUQYrm,
          14702 => Opcode::VPMADD52LUQYrr,
          14703 => Opcode::VPMADD52LUQZ128m,
          14704 => Opcode::VPMADD52LUQZ128mb,
          14705 => Opcode::VPMADD52LUQZ128mbk,
          14706 => Opcode::VPMADD52LUQZ128mbkz,
          14707 => Opcode::VPMADD52LUQZ128mk,
          14708 => Opcode::VPMADD52LUQZ128mkz,
          14709 => Opcode::VPMADD52LUQZ128r,
          14710 => Opcode::VPMADD52LUQZ128rk,
          14711 => Opcode::VPMADD52LUQZ128rkz,
          14712 => Opcode::VPMADD52LUQZ256m,
          14713 => Opcode::VPMADD52LUQZ256mb,
          14714 => Opcode::VPMADD52LUQZ256mbk,
          14715 => Opcode::VPMADD52LUQZ256mbkz,
          14716 => Opcode::VPMADD52LUQZ256mk,
          14717 => Opcode::VPMADD52LUQZ256mkz,
          14718 => Opcode::VPMADD52LUQZ256r,
          14719 => Opcode::VPMADD52LUQZ256rk,
          14720 => Opcode::VPMADD52LUQZ256rkz,
          14721 => Opcode::VPMADD52LUQZm,
          14722 => Opcode::VPMADD52LUQZmb,
          14723 => Opcode::VPMADD52LUQZmbk,
          14724 => Opcode::VPMADD52LUQZmbkz,
          14725 => Opcode::VPMADD52LUQZmk,
          14726 => Opcode::VPMADD52LUQZmkz,
          14727 => Opcode::VPMADD52LUQZr,
          14728 => Opcode::VPMADD52LUQZrk,
          14729 => Opcode::VPMADD52LUQZrkz,
          14730 => Opcode::VPMADD52LUQrm,
          14731 => Opcode::VPMADD52LUQrr,
          14732 => Opcode::VPMADDUBSWYrm,
          14733 => Opcode::VPMADDUBSWYrr,
          14734 => Opcode::VPMADDUBSWZ128rm,
          14735 => Opcode::VPMADDUBSWZ128rmk,
          14736 => Opcode::VPMADDUBSWZ128rmkz,
          14737 => Opcode::VPMADDUBSWZ128rr,
          14738 => Opcode::VPMADDUBSWZ128rrk,
          14739 => Opcode::VPMADDUBSWZ128rrkz,
          14740 => Opcode::VPMADDUBSWZ256rm,
          14741 => Opcode::VPMADDUBSWZ256rmk,
          14742 => Opcode::VPMADDUBSWZ256rmkz,
          14743 => Opcode::VPMADDUBSWZ256rr,
          14744 => Opcode::VPMADDUBSWZ256rrk,
          14745 => Opcode::VPMADDUBSWZ256rrkz,
          14746 => Opcode::VPMADDUBSWZrm,
          14747 => Opcode::VPMADDUBSWZrmk,
          14748 => Opcode::VPMADDUBSWZrmkz,
          14749 => Opcode::VPMADDUBSWZrr,
          14750 => Opcode::VPMADDUBSWZrrk,
          14751 => Opcode::VPMADDUBSWZrrkz,
          14752 => Opcode::VPMADDUBSWrm,
          14753 => Opcode::VPMADDUBSWrr,
          14754 => Opcode::VPMADDWDYrm,
          14755 => Opcode::VPMADDWDYrr,
          14756 => Opcode::VPMADDWDZ128rm,
          14757 => Opcode::VPMADDWDZ128rmk,
          14758 => Opcode::VPMADDWDZ128rmkz,
          14759 => Opcode::VPMADDWDZ128rr,
          14760 => Opcode::VPMADDWDZ128rrk,
          14761 => Opcode::VPMADDWDZ128rrkz,
          14762 => Opcode::VPMADDWDZ256rm,
          14763 => Opcode::VPMADDWDZ256rmk,
          14764 => Opcode::VPMADDWDZ256rmkz,
          14765 => Opcode::VPMADDWDZ256rr,
          14766 => Opcode::VPMADDWDZ256rrk,
          14767 => Opcode::VPMADDWDZ256rrkz,
          14768 => Opcode::VPMADDWDZrm,
          14769 => Opcode::VPMADDWDZrmk,
          14770 => Opcode::VPMADDWDZrmkz,
          14771 => Opcode::VPMADDWDZrr,
          14772 => Opcode::VPMADDWDZrrk,
          14773 => Opcode::VPMADDWDZrrkz,
          14774 => Opcode::VPMADDWDrm,
          14775 => Opcode::VPMADDWDrr,
          14776 => Opcode::VPMASKMOVDYmr,
          14777 => Opcode::VPMASKMOVDYrm,
          14778 => Opcode::VPMASKMOVDmr,
          14779 => Opcode::VPMASKMOVDrm,
          14780 => Opcode::VPMASKMOVQYmr,
          14781 => Opcode::VPMASKMOVQYrm,
          14782 => Opcode::VPMASKMOVQmr,
          14783 => Opcode::VPMASKMOVQrm,
          14784 => Opcode::VPMAXSBYrm,
          14785 => Opcode::VPMAXSBYrr,
          14786 => Opcode::VPMAXSBZ128rm,
          14787 => Opcode::VPMAXSBZ128rmk,
          14788 => Opcode::VPMAXSBZ128rmkz,
          14789 => Opcode::VPMAXSBZ128rr,
          14790 => Opcode::VPMAXSBZ128rrk,
          14791 => Opcode::VPMAXSBZ128rrkz,
          14792 => Opcode::VPMAXSBZ256rm,
          14793 => Opcode::VPMAXSBZ256rmk,
          14794 => Opcode::VPMAXSBZ256rmkz,
          14795 => Opcode::VPMAXSBZ256rr,
          14796 => Opcode::VPMAXSBZ256rrk,
          14797 => Opcode::VPMAXSBZ256rrkz,
          14798 => Opcode::VPMAXSBZrm,
          14799 => Opcode::VPMAXSBZrmk,
          14800 => Opcode::VPMAXSBZrmkz,
          14801 => Opcode::VPMAXSBZrr,
          14802 => Opcode::VPMAXSBZrrk,
          14803 => Opcode::VPMAXSBZrrkz,
          14804 => Opcode::VPMAXSBrm,
          14805 => Opcode::VPMAXSBrr,
          14806 => Opcode::VPMAXSDYrm,
          14807 => Opcode::VPMAXSDYrr,
          14808 => Opcode::VPMAXSDZ128rm,
          14809 => Opcode::VPMAXSDZ128rmb,
          14810 => Opcode::VPMAXSDZ128rmbk,
          14811 => Opcode::VPMAXSDZ128rmbkz,
          14812 => Opcode::VPMAXSDZ128rmk,
          14813 => Opcode::VPMAXSDZ128rmkz,
          14814 => Opcode::VPMAXSDZ128rr,
          14815 => Opcode::VPMAXSDZ128rrk,
          14816 => Opcode::VPMAXSDZ128rrkz,
          14817 => Opcode::VPMAXSDZ256rm,
          14818 => Opcode::VPMAXSDZ256rmb,
          14819 => Opcode::VPMAXSDZ256rmbk,
          14820 => Opcode::VPMAXSDZ256rmbkz,
          14821 => Opcode::VPMAXSDZ256rmk,
          14822 => Opcode::VPMAXSDZ256rmkz,
          14823 => Opcode::VPMAXSDZ256rr,
          14824 => Opcode::VPMAXSDZ256rrk,
          14825 => Opcode::VPMAXSDZ256rrkz,
          14826 => Opcode::VPMAXSDZrm,
          14827 => Opcode::VPMAXSDZrmb,
          14828 => Opcode::VPMAXSDZrmbk,
          14829 => Opcode::VPMAXSDZrmbkz,
          14830 => Opcode::VPMAXSDZrmk,
          14831 => Opcode::VPMAXSDZrmkz,
          14832 => Opcode::VPMAXSDZrr,
          14833 => Opcode::VPMAXSDZrrk,
          14834 => Opcode::VPMAXSDZrrkz,
          14835 => Opcode::VPMAXSDrm,
          14836 => Opcode::VPMAXSDrr,
          14837 => Opcode::VPMAXSQZ128rm,
          14838 => Opcode::VPMAXSQZ128rmb,
          14839 => Opcode::VPMAXSQZ128rmbk,
          14840 => Opcode::VPMAXSQZ128rmbkz,
          14841 => Opcode::VPMAXSQZ128rmk,
          14842 => Opcode::VPMAXSQZ128rmkz,
          14843 => Opcode::VPMAXSQZ128rr,
          14844 => Opcode::VPMAXSQZ128rrk,
          14845 => Opcode::VPMAXSQZ128rrkz,
          14846 => Opcode::VPMAXSQZ256rm,
          14847 => Opcode::VPMAXSQZ256rmb,
          14848 => Opcode::VPMAXSQZ256rmbk,
          14849 => Opcode::VPMAXSQZ256rmbkz,
          14850 => Opcode::VPMAXSQZ256rmk,
          14851 => Opcode::VPMAXSQZ256rmkz,
          14852 => Opcode::VPMAXSQZ256rr,
          14853 => Opcode::VPMAXSQZ256rrk,
          14854 => Opcode::VPMAXSQZ256rrkz,
          14855 => Opcode::VPMAXSQZrm,
          14856 => Opcode::VPMAXSQZrmb,
          14857 => Opcode::VPMAXSQZrmbk,
          14858 => Opcode::VPMAXSQZrmbkz,
          14859 => Opcode::VPMAXSQZrmk,
          14860 => Opcode::VPMAXSQZrmkz,
          14861 => Opcode::VPMAXSQZrr,
          14862 => Opcode::VPMAXSQZrrk,
          14863 => Opcode::VPMAXSQZrrkz,
          14864 => Opcode::VPMAXSWYrm,
          14865 => Opcode::VPMAXSWYrr,
          14866 => Opcode::VPMAXSWZ128rm,
          14867 => Opcode::VPMAXSWZ128rmk,
          14868 => Opcode::VPMAXSWZ128rmkz,
          14869 => Opcode::VPMAXSWZ128rr,
          14870 => Opcode::VPMAXSWZ128rrk,
          14871 => Opcode::VPMAXSWZ128rrkz,
          14872 => Opcode::VPMAXSWZ256rm,
          14873 => Opcode::VPMAXSWZ256rmk,
          14874 => Opcode::VPMAXSWZ256rmkz,
          14875 => Opcode::VPMAXSWZ256rr,
          14876 => Opcode::VPMAXSWZ256rrk,
          14877 => Opcode::VPMAXSWZ256rrkz,
          14878 => Opcode::VPMAXSWZrm,
          14879 => Opcode::VPMAXSWZrmk,
          14880 => Opcode::VPMAXSWZrmkz,
          14881 => Opcode::VPMAXSWZrr,
          14882 => Opcode::VPMAXSWZrrk,
          14883 => Opcode::VPMAXSWZrrkz,
          14884 => Opcode::VPMAXSWrm,
          14885 => Opcode::VPMAXSWrr,
          14886 => Opcode::VPMAXUBYrm,
          14887 => Opcode::VPMAXUBYrr,
          14888 => Opcode::VPMAXUBZ128rm,
          14889 => Opcode::VPMAXUBZ128rmk,
          14890 => Opcode::VPMAXUBZ128rmkz,
          14891 => Opcode::VPMAXUBZ128rr,
          14892 => Opcode::VPMAXUBZ128rrk,
          14893 => Opcode::VPMAXUBZ128rrkz,
          14894 => Opcode::VPMAXUBZ256rm,
          14895 => Opcode::VPMAXUBZ256rmk,
          14896 => Opcode::VPMAXUBZ256rmkz,
          14897 => Opcode::VPMAXUBZ256rr,
          14898 => Opcode::VPMAXUBZ256rrk,
          14899 => Opcode::VPMAXUBZ256rrkz,
          14900 => Opcode::VPMAXUBZrm,
          14901 => Opcode::VPMAXUBZrmk,
          14902 => Opcode::VPMAXUBZrmkz,
          14903 => Opcode::VPMAXUBZrr,
          14904 => Opcode::VPMAXUBZrrk,
          14905 => Opcode::VPMAXUBZrrkz,
          14906 => Opcode::VPMAXUBrm,
          14907 => Opcode::VPMAXUBrr,
          14908 => Opcode::VPMAXUDYrm,
          14909 => Opcode::VPMAXUDYrr,
          14910 => Opcode::VPMAXUDZ128rm,
          14911 => Opcode::VPMAXUDZ128rmb,
          14912 => Opcode::VPMAXUDZ128rmbk,
          14913 => Opcode::VPMAXUDZ128rmbkz,
          14914 => Opcode::VPMAXUDZ128rmk,
          14915 => Opcode::VPMAXUDZ128rmkz,
          14916 => Opcode::VPMAXUDZ128rr,
          14917 => Opcode::VPMAXUDZ128rrk,
          14918 => Opcode::VPMAXUDZ128rrkz,
          14919 => Opcode::VPMAXUDZ256rm,
          14920 => Opcode::VPMAXUDZ256rmb,
          14921 => Opcode::VPMAXUDZ256rmbk,
          14922 => Opcode::VPMAXUDZ256rmbkz,
          14923 => Opcode::VPMAXUDZ256rmk,
          14924 => Opcode::VPMAXUDZ256rmkz,
          14925 => Opcode::VPMAXUDZ256rr,
          14926 => Opcode::VPMAXUDZ256rrk,
          14927 => Opcode::VPMAXUDZ256rrkz,
          14928 => Opcode::VPMAXUDZrm,
          14929 => Opcode::VPMAXUDZrmb,
          14930 => Opcode::VPMAXUDZrmbk,
          14931 => Opcode::VPMAXUDZrmbkz,
          14932 => Opcode::VPMAXUDZrmk,
          14933 => Opcode::VPMAXUDZrmkz,
          14934 => Opcode::VPMAXUDZrr,
          14935 => Opcode::VPMAXUDZrrk,
          14936 => Opcode::VPMAXUDZrrkz,
          14937 => Opcode::VPMAXUDrm,
          14938 => Opcode::VPMAXUDrr,
          14939 => Opcode::VPMAXUQZ128rm,
          14940 => Opcode::VPMAXUQZ128rmb,
          14941 => Opcode::VPMAXUQZ128rmbk,
          14942 => Opcode::VPMAXUQZ128rmbkz,
          14943 => Opcode::VPMAXUQZ128rmk,
          14944 => Opcode::VPMAXUQZ128rmkz,
          14945 => Opcode::VPMAXUQZ128rr,
          14946 => Opcode::VPMAXUQZ128rrk,
          14947 => Opcode::VPMAXUQZ128rrkz,
          14948 => Opcode::VPMAXUQZ256rm,
          14949 => Opcode::VPMAXUQZ256rmb,
          14950 => Opcode::VPMAXUQZ256rmbk,
          14951 => Opcode::VPMAXUQZ256rmbkz,
          14952 => Opcode::VPMAXUQZ256rmk,
          14953 => Opcode::VPMAXUQZ256rmkz,
          14954 => Opcode::VPMAXUQZ256rr,
          14955 => Opcode::VPMAXUQZ256rrk,
          14956 => Opcode::VPMAXUQZ256rrkz,
          14957 => Opcode::VPMAXUQZrm,
          14958 => Opcode::VPMAXUQZrmb,
          14959 => Opcode::VPMAXUQZrmbk,
          14960 => Opcode::VPMAXUQZrmbkz,
          14961 => Opcode::VPMAXUQZrmk,
          14962 => Opcode::VPMAXUQZrmkz,
          14963 => Opcode::VPMAXUQZrr,
          14964 => Opcode::VPMAXUQZrrk,
          14965 => Opcode::VPMAXUQZrrkz,
          14966 => Opcode::VPMAXUWYrm,
          14967 => Opcode::VPMAXUWYrr,
          14968 => Opcode::VPMAXUWZ128rm,
          14969 => Opcode::VPMAXUWZ128rmk,
          14970 => Opcode::VPMAXUWZ128rmkz,
          14971 => Opcode::VPMAXUWZ128rr,
          14972 => Opcode::VPMAXUWZ128rrk,
          14973 => Opcode::VPMAXUWZ128rrkz,
          14974 => Opcode::VPMAXUWZ256rm,
          14975 => Opcode::VPMAXUWZ256rmk,
          14976 => Opcode::VPMAXUWZ256rmkz,
          14977 => Opcode::VPMAXUWZ256rr,
          14978 => Opcode::VPMAXUWZ256rrk,
          14979 => Opcode::VPMAXUWZ256rrkz,
          14980 => Opcode::VPMAXUWZrm,
          14981 => Opcode::VPMAXUWZrmk,
          14982 => Opcode::VPMAXUWZrmkz,
          14983 => Opcode::VPMAXUWZrr,
          14984 => Opcode::VPMAXUWZrrk,
          14985 => Opcode::VPMAXUWZrrkz,
          14986 => Opcode::VPMAXUWrm,
          14987 => Opcode::VPMAXUWrr,
          14988 => Opcode::VPMINSBYrm,
          14989 => Opcode::VPMINSBYrr,
          14990 => Opcode::VPMINSBZ128rm,
          14991 => Opcode::VPMINSBZ128rmk,
          14992 => Opcode::VPMINSBZ128rmkz,
          14993 => Opcode::VPMINSBZ128rr,
          14994 => Opcode::VPMINSBZ128rrk,
          14995 => Opcode::VPMINSBZ128rrkz,
          14996 => Opcode::VPMINSBZ256rm,
          14997 => Opcode::VPMINSBZ256rmk,
          14998 => Opcode::VPMINSBZ256rmkz,
          14999 => Opcode::VPMINSBZ256rr,
          15000 => Opcode::VPMINSBZ256rrk,
          15001 => Opcode::VPMINSBZ256rrkz,
          15002 => Opcode::VPMINSBZrm,
          15003 => Opcode::VPMINSBZrmk,
          15004 => Opcode::VPMINSBZrmkz,
          15005 => Opcode::VPMINSBZrr,
          15006 => Opcode::VPMINSBZrrk,
          15007 => Opcode::VPMINSBZrrkz,
          15008 => Opcode::VPMINSBrm,
          15009 => Opcode::VPMINSBrr,
          15010 => Opcode::VPMINSDYrm,
          15011 => Opcode::VPMINSDYrr,
          15012 => Opcode::VPMINSDZ128rm,
          15013 => Opcode::VPMINSDZ128rmb,
          15014 => Opcode::VPMINSDZ128rmbk,
          15015 => Opcode::VPMINSDZ128rmbkz,
          15016 => Opcode::VPMINSDZ128rmk,
          15017 => Opcode::VPMINSDZ128rmkz,
          15018 => Opcode::VPMINSDZ128rr,
          15019 => Opcode::VPMINSDZ128rrk,
          15020 => Opcode::VPMINSDZ128rrkz,
          15021 => Opcode::VPMINSDZ256rm,
          15022 => Opcode::VPMINSDZ256rmb,
          15023 => Opcode::VPMINSDZ256rmbk,
          15024 => Opcode::VPMINSDZ256rmbkz,
          15025 => Opcode::VPMINSDZ256rmk,
          15026 => Opcode::VPMINSDZ256rmkz,
          15027 => Opcode::VPMINSDZ256rr,
          15028 => Opcode::VPMINSDZ256rrk,
          15029 => Opcode::VPMINSDZ256rrkz,
          15030 => Opcode::VPMINSDZrm,
          15031 => Opcode::VPMINSDZrmb,
          15032 => Opcode::VPMINSDZrmbk,
          15033 => Opcode::VPMINSDZrmbkz,
          15034 => Opcode::VPMINSDZrmk,
          15035 => Opcode::VPMINSDZrmkz,
          15036 => Opcode::VPMINSDZrr,
          15037 => Opcode::VPMINSDZrrk,
          15038 => Opcode::VPMINSDZrrkz,
          15039 => Opcode::VPMINSDrm,
          15040 => Opcode::VPMINSDrr,
          15041 => Opcode::VPMINSQZ128rm,
          15042 => Opcode::VPMINSQZ128rmb,
          15043 => Opcode::VPMINSQZ128rmbk,
          15044 => Opcode::VPMINSQZ128rmbkz,
          15045 => Opcode::VPMINSQZ128rmk,
          15046 => Opcode::VPMINSQZ128rmkz,
          15047 => Opcode::VPMINSQZ128rr,
          15048 => Opcode::VPMINSQZ128rrk,
          15049 => Opcode::VPMINSQZ128rrkz,
          15050 => Opcode::VPMINSQZ256rm,
          15051 => Opcode::VPMINSQZ256rmb,
          15052 => Opcode::VPMINSQZ256rmbk,
          15053 => Opcode::VPMINSQZ256rmbkz,
          15054 => Opcode::VPMINSQZ256rmk,
          15055 => Opcode::VPMINSQZ256rmkz,
          15056 => Opcode::VPMINSQZ256rr,
          15057 => Opcode::VPMINSQZ256rrk,
          15058 => Opcode::VPMINSQZ256rrkz,
          15059 => Opcode::VPMINSQZrm,
          15060 => Opcode::VPMINSQZrmb,
          15061 => Opcode::VPMINSQZrmbk,
          15062 => Opcode::VPMINSQZrmbkz,
          15063 => Opcode::VPMINSQZrmk,
          15064 => Opcode::VPMINSQZrmkz,
          15065 => Opcode::VPMINSQZrr,
          15066 => Opcode::VPMINSQZrrk,
          15067 => Opcode::VPMINSQZrrkz,
          15068 => Opcode::VPMINSWYrm,
          15069 => Opcode::VPMINSWYrr,
          15070 => Opcode::VPMINSWZ128rm,
          15071 => Opcode::VPMINSWZ128rmk,
          15072 => Opcode::VPMINSWZ128rmkz,
          15073 => Opcode::VPMINSWZ128rr,
          15074 => Opcode::VPMINSWZ128rrk,
          15075 => Opcode::VPMINSWZ128rrkz,
          15076 => Opcode::VPMINSWZ256rm,
          15077 => Opcode::VPMINSWZ256rmk,
          15078 => Opcode::VPMINSWZ256rmkz,
          15079 => Opcode::VPMINSWZ256rr,
          15080 => Opcode::VPMINSWZ256rrk,
          15081 => Opcode::VPMINSWZ256rrkz,
          15082 => Opcode::VPMINSWZrm,
          15083 => Opcode::VPMINSWZrmk,
          15084 => Opcode::VPMINSWZrmkz,
          15085 => Opcode::VPMINSWZrr,
          15086 => Opcode::VPMINSWZrrk,
          15087 => Opcode::VPMINSWZrrkz,
          15088 => Opcode::VPMINSWrm,
          15089 => Opcode::VPMINSWrr,
          15090 => Opcode::VPMINUBYrm,
          15091 => Opcode::VPMINUBYrr,
          15092 => Opcode::VPMINUBZ128rm,
          15093 => Opcode::VPMINUBZ128rmk,
          15094 => Opcode::VPMINUBZ128rmkz,
          15095 => Opcode::VPMINUBZ128rr,
          15096 => Opcode::VPMINUBZ128rrk,
          15097 => Opcode::VPMINUBZ128rrkz,
          15098 => Opcode::VPMINUBZ256rm,
          15099 => Opcode::VPMINUBZ256rmk,
          15100 => Opcode::VPMINUBZ256rmkz,
          15101 => Opcode::VPMINUBZ256rr,
          15102 => Opcode::VPMINUBZ256rrk,
          15103 => Opcode::VPMINUBZ256rrkz,
          15104 => Opcode::VPMINUBZrm,
          15105 => Opcode::VPMINUBZrmk,
          15106 => Opcode::VPMINUBZrmkz,
          15107 => Opcode::VPMINUBZrr,
          15108 => Opcode::VPMINUBZrrk,
          15109 => Opcode::VPMINUBZrrkz,
          15110 => Opcode::VPMINUBrm,
          15111 => Opcode::VPMINUBrr,
          15112 => Opcode::VPMINUDYrm,
          15113 => Opcode::VPMINUDYrr,
          15114 => Opcode::VPMINUDZ128rm,
          15115 => Opcode::VPMINUDZ128rmb,
          15116 => Opcode::VPMINUDZ128rmbk,
          15117 => Opcode::VPMINUDZ128rmbkz,
          15118 => Opcode::VPMINUDZ128rmk,
          15119 => Opcode::VPMINUDZ128rmkz,
          15120 => Opcode::VPMINUDZ128rr,
          15121 => Opcode::VPMINUDZ128rrk,
          15122 => Opcode::VPMINUDZ128rrkz,
          15123 => Opcode::VPMINUDZ256rm,
          15124 => Opcode::VPMINUDZ256rmb,
          15125 => Opcode::VPMINUDZ256rmbk,
          15126 => Opcode::VPMINUDZ256rmbkz,
          15127 => Opcode::VPMINUDZ256rmk,
          15128 => Opcode::VPMINUDZ256rmkz,
          15129 => Opcode::VPMINUDZ256rr,
          15130 => Opcode::VPMINUDZ256rrk,
          15131 => Opcode::VPMINUDZ256rrkz,
          15132 => Opcode::VPMINUDZrm,
          15133 => Opcode::VPMINUDZrmb,
          15134 => Opcode::VPMINUDZrmbk,
          15135 => Opcode::VPMINUDZrmbkz,
          15136 => Opcode::VPMINUDZrmk,
          15137 => Opcode::VPMINUDZrmkz,
          15138 => Opcode::VPMINUDZrr,
          15139 => Opcode::VPMINUDZrrk,
          15140 => Opcode::VPMINUDZrrkz,
          15141 => Opcode::VPMINUDrm,
          15142 => Opcode::VPMINUDrr,
          15143 => Opcode::VPMINUQZ128rm,
          15144 => Opcode::VPMINUQZ128rmb,
          15145 => Opcode::VPMINUQZ128rmbk,
          15146 => Opcode::VPMINUQZ128rmbkz,
          15147 => Opcode::VPMINUQZ128rmk,
          15148 => Opcode::VPMINUQZ128rmkz,
          15149 => Opcode::VPMINUQZ128rr,
          15150 => Opcode::VPMINUQZ128rrk,
          15151 => Opcode::VPMINUQZ128rrkz,
          15152 => Opcode::VPMINUQZ256rm,
          15153 => Opcode::VPMINUQZ256rmb,
          15154 => Opcode::VPMINUQZ256rmbk,
          15155 => Opcode::VPMINUQZ256rmbkz,
          15156 => Opcode::VPMINUQZ256rmk,
          15157 => Opcode::VPMINUQZ256rmkz,
          15158 => Opcode::VPMINUQZ256rr,
          15159 => Opcode::VPMINUQZ256rrk,
          15160 => Opcode::VPMINUQZ256rrkz,
          15161 => Opcode::VPMINUQZrm,
          15162 => Opcode::VPMINUQZrmb,
          15163 => Opcode::VPMINUQZrmbk,
          15164 => Opcode::VPMINUQZrmbkz,
          15165 => Opcode::VPMINUQZrmk,
          15166 => Opcode::VPMINUQZrmkz,
          15167 => Opcode::VPMINUQZrr,
          15168 => Opcode::VPMINUQZrrk,
          15169 => Opcode::VPMINUQZrrkz,
          15170 => Opcode::VPMINUWYrm,
          15171 => Opcode::VPMINUWYrr,
          15172 => Opcode::VPMINUWZ128rm,
          15173 => Opcode::VPMINUWZ128rmk,
          15174 => Opcode::VPMINUWZ128rmkz,
          15175 => Opcode::VPMINUWZ128rr,
          15176 => Opcode::VPMINUWZ128rrk,
          15177 => Opcode::VPMINUWZ128rrkz,
          15178 => Opcode::VPMINUWZ256rm,
          15179 => Opcode::VPMINUWZ256rmk,
          15180 => Opcode::VPMINUWZ256rmkz,
          15181 => Opcode::VPMINUWZ256rr,
          15182 => Opcode::VPMINUWZ256rrk,
          15183 => Opcode::VPMINUWZ256rrkz,
          15184 => Opcode::VPMINUWZrm,
          15185 => Opcode::VPMINUWZrmk,
          15186 => Opcode::VPMINUWZrmkz,
          15187 => Opcode::VPMINUWZrr,
          15188 => Opcode::VPMINUWZrrk,
          15189 => Opcode::VPMINUWZrrkz,
          15190 => Opcode::VPMINUWrm,
          15191 => Opcode::VPMINUWrr,
          15192 => Opcode::VPMOVB2MZ128rr,
          15193 => Opcode::VPMOVB2MZ256rr,
          15194 => Opcode::VPMOVB2MZrr,
          15195 => Opcode::VPMOVD2MZ128rr,
          15196 => Opcode::VPMOVD2MZ256rr,
          15197 => Opcode::VPMOVD2MZrr,
          15198 => Opcode::VPMOVDBZ128mr,
          15199 => Opcode::VPMOVDBZ128mrk,
          15200 => Opcode::VPMOVDBZ128rr,
          15201 => Opcode::VPMOVDBZ128rrk,
          15202 => Opcode::VPMOVDBZ128rrkz,
          15203 => Opcode::VPMOVDBZ256mr,
          15204 => Opcode::VPMOVDBZ256mrk,
          15205 => Opcode::VPMOVDBZ256rr,
          15206 => Opcode::VPMOVDBZ256rrk,
          15207 => Opcode::VPMOVDBZ256rrkz,
          15208 => Opcode::VPMOVDBZmr,
          15209 => Opcode::VPMOVDBZmrk,
          15210 => Opcode::VPMOVDBZrr,
          15211 => Opcode::VPMOVDBZrrk,
          15212 => Opcode::VPMOVDBZrrkz,
          15213 => Opcode::VPMOVDWZ128mr,
          15214 => Opcode::VPMOVDWZ128mrk,
          15215 => Opcode::VPMOVDWZ128rr,
          15216 => Opcode::VPMOVDWZ128rrk,
          15217 => Opcode::VPMOVDWZ128rrkz,
          15218 => Opcode::VPMOVDWZ256mr,
          15219 => Opcode::VPMOVDWZ256mrk,
          15220 => Opcode::VPMOVDWZ256rr,
          15221 => Opcode::VPMOVDWZ256rrk,
          15222 => Opcode::VPMOVDWZ256rrkz,
          15223 => Opcode::VPMOVDWZmr,
          15224 => Opcode::VPMOVDWZmrk,
          15225 => Opcode::VPMOVDWZrr,
          15226 => Opcode::VPMOVDWZrrk,
          15227 => Opcode::VPMOVDWZrrkz,
          15228 => Opcode::VPMOVM2BZ128rr,
          15229 => Opcode::VPMOVM2BZ256rr,
          15230 => Opcode::VPMOVM2BZrr,
          15231 => Opcode::VPMOVM2DZ128rr,
          15232 => Opcode::VPMOVM2DZ256rr,
          15233 => Opcode::VPMOVM2DZrr,
          15234 => Opcode::VPMOVM2QZ128rr,
          15235 => Opcode::VPMOVM2QZ256rr,
          15236 => Opcode::VPMOVM2QZrr,
          15237 => Opcode::VPMOVM2WZ128rr,
          15238 => Opcode::VPMOVM2WZ256rr,
          15239 => Opcode::VPMOVM2WZrr,
          15240 => Opcode::VPMOVMSKBYrr,
          15241 => Opcode::VPMOVMSKBrr,
          15242 => Opcode::VPMOVQ2MZ128rr,
          15243 => Opcode::VPMOVQ2MZ256rr,
          15244 => Opcode::VPMOVQ2MZrr,
          15245 => Opcode::VPMOVQBZ128mr,
          15246 => Opcode::VPMOVQBZ128mrk,
          15247 => Opcode::VPMOVQBZ128rr,
          15248 => Opcode::VPMOVQBZ128rrk,
          15249 => Opcode::VPMOVQBZ128rrkz,
          15250 => Opcode::VPMOVQBZ256mr,
          15251 => Opcode::VPMOVQBZ256mrk,
          15252 => Opcode::VPMOVQBZ256rr,
          15253 => Opcode::VPMOVQBZ256rrk,
          15254 => Opcode::VPMOVQBZ256rrkz,
          15255 => Opcode::VPMOVQBZmr,
          15256 => Opcode::VPMOVQBZmrk,
          15257 => Opcode::VPMOVQBZrr,
          15258 => Opcode::VPMOVQBZrrk,
          15259 => Opcode::VPMOVQBZrrkz,
          15260 => Opcode::VPMOVQDZ128mr,
          15261 => Opcode::VPMOVQDZ128mrk,
          15262 => Opcode::VPMOVQDZ128rr,
          15263 => Opcode::VPMOVQDZ128rrk,
          15264 => Opcode::VPMOVQDZ128rrkz,
          15265 => Opcode::VPMOVQDZ256mr,
          15266 => Opcode::VPMOVQDZ256mrk,
          15267 => Opcode::VPMOVQDZ256rr,
          15268 => Opcode::VPMOVQDZ256rrk,
          15269 => Opcode::VPMOVQDZ256rrkz,
          15270 => Opcode::VPMOVQDZmr,
          15271 => Opcode::VPMOVQDZmrk,
          15272 => Opcode::VPMOVQDZrr,
          15273 => Opcode::VPMOVQDZrrk,
          15274 => Opcode::VPMOVQDZrrkz,
          15275 => Opcode::VPMOVQWZ128mr,
          15276 => Opcode::VPMOVQWZ128mrk,
          15277 => Opcode::VPMOVQWZ128rr,
          15278 => Opcode::VPMOVQWZ128rrk,
          15279 => Opcode::VPMOVQWZ128rrkz,
          15280 => Opcode::VPMOVQWZ256mr,
          15281 => Opcode::VPMOVQWZ256mrk,
          15282 => Opcode::VPMOVQWZ256rr,
          15283 => Opcode::VPMOVQWZ256rrk,
          15284 => Opcode::VPMOVQWZ256rrkz,
          15285 => Opcode::VPMOVQWZmr,
          15286 => Opcode::VPMOVQWZmrk,
          15287 => Opcode::VPMOVQWZrr,
          15288 => Opcode::VPMOVQWZrrk,
          15289 => Opcode::VPMOVQWZrrkz,
          15290 => Opcode::VPMOVSDBZ128mr,
          15291 => Opcode::VPMOVSDBZ128mrk,
          15292 => Opcode::VPMOVSDBZ128rr,
          15293 => Opcode::VPMOVSDBZ128rrk,
          15294 => Opcode::VPMOVSDBZ128rrkz,
          15295 => Opcode::VPMOVSDBZ256mr,
          15296 => Opcode::VPMOVSDBZ256mrk,
          15297 => Opcode::VPMOVSDBZ256rr,
          15298 => Opcode::VPMOVSDBZ256rrk,
          15299 => Opcode::VPMOVSDBZ256rrkz,
          15300 => Opcode::VPMOVSDBZmr,
          15301 => Opcode::VPMOVSDBZmrk,
          15302 => Opcode::VPMOVSDBZrr,
          15303 => Opcode::VPMOVSDBZrrk,
          15304 => Opcode::VPMOVSDBZrrkz,
          15305 => Opcode::VPMOVSDWZ128mr,
          15306 => Opcode::VPMOVSDWZ128mrk,
          15307 => Opcode::VPMOVSDWZ128rr,
          15308 => Opcode::VPMOVSDWZ128rrk,
          15309 => Opcode::VPMOVSDWZ128rrkz,
          15310 => Opcode::VPMOVSDWZ256mr,
          15311 => Opcode::VPMOVSDWZ256mrk,
          15312 => Opcode::VPMOVSDWZ256rr,
          15313 => Opcode::VPMOVSDWZ256rrk,
          15314 => Opcode::VPMOVSDWZ256rrkz,
          15315 => Opcode::VPMOVSDWZmr,
          15316 => Opcode::VPMOVSDWZmrk,
          15317 => Opcode::VPMOVSDWZrr,
          15318 => Opcode::VPMOVSDWZrrk,
          15319 => Opcode::VPMOVSDWZrrkz,
          15320 => Opcode::VPMOVSQBZ128mr,
          15321 => Opcode::VPMOVSQBZ128mrk,
          15322 => Opcode::VPMOVSQBZ128rr,
          15323 => Opcode::VPMOVSQBZ128rrk,
          15324 => Opcode::VPMOVSQBZ128rrkz,
          15325 => Opcode::VPMOVSQBZ256mr,
          15326 => Opcode::VPMOVSQBZ256mrk,
          15327 => Opcode::VPMOVSQBZ256rr,
          15328 => Opcode::VPMOVSQBZ256rrk,
          15329 => Opcode::VPMOVSQBZ256rrkz,
          15330 => Opcode::VPMOVSQBZmr,
          15331 => Opcode::VPMOVSQBZmrk,
          15332 => Opcode::VPMOVSQBZrr,
          15333 => Opcode::VPMOVSQBZrrk,
          15334 => Opcode::VPMOVSQBZrrkz,
          15335 => Opcode::VPMOVSQDZ128mr,
          15336 => Opcode::VPMOVSQDZ128mrk,
          15337 => Opcode::VPMOVSQDZ128rr,
          15338 => Opcode::VPMOVSQDZ128rrk,
          15339 => Opcode::VPMOVSQDZ128rrkz,
          15340 => Opcode::VPMOVSQDZ256mr,
          15341 => Opcode::VPMOVSQDZ256mrk,
          15342 => Opcode::VPMOVSQDZ256rr,
          15343 => Opcode::VPMOVSQDZ256rrk,
          15344 => Opcode::VPMOVSQDZ256rrkz,
          15345 => Opcode::VPMOVSQDZmr,
          15346 => Opcode::VPMOVSQDZmrk,
          15347 => Opcode::VPMOVSQDZrr,
          15348 => Opcode::VPMOVSQDZrrk,
          15349 => Opcode::VPMOVSQDZrrkz,
          15350 => Opcode::VPMOVSQWZ128mr,
          15351 => Opcode::VPMOVSQWZ128mrk,
          15352 => Opcode::VPMOVSQWZ128rr,
          15353 => Opcode::VPMOVSQWZ128rrk,
          15354 => Opcode::VPMOVSQWZ128rrkz,
          15355 => Opcode::VPMOVSQWZ256mr,
          15356 => Opcode::VPMOVSQWZ256mrk,
          15357 => Opcode::VPMOVSQWZ256rr,
          15358 => Opcode::VPMOVSQWZ256rrk,
          15359 => Opcode::VPMOVSQWZ256rrkz,
          15360 => Opcode::VPMOVSQWZmr,
          15361 => Opcode::VPMOVSQWZmrk,
          15362 => Opcode::VPMOVSQWZrr,
          15363 => Opcode::VPMOVSQWZrrk,
          15364 => Opcode::VPMOVSQWZrrkz,
          15365 => Opcode::VPMOVSWBZ128mr,
          15366 => Opcode::VPMOVSWBZ128mrk,
          15367 => Opcode::VPMOVSWBZ128rr,
          15368 => Opcode::VPMOVSWBZ128rrk,
          15369 => Opcode::VPMOVSWBZ128rrkz,
          15370 => Opcode::VPMOVSWBZ256mr,
          15371 => Opcode::VPMOVSWBZ256mrk,
          15372 => Opcode::VPMOVSWBZ256rr,
          15373 => Opcode::VPMOVSWBZ256rrk,
          15374 => Opcode::VPMOVSWBZ256rrkz,
          15375 => Opcode::VPMOVSWBZmr,
          15376 => Opcode::VPMOVSWBZmrk,
          15377 => Opcode::VPMOVSWBZrr,
          15378 => Opcode::VPMOVSWBZrrk,
          15379 => Opcode::VPMOVSWBZrrkz,
          15380 => Opcode::VPMOVSXBDYrm,
          15381 => Opcode::VPMOVSXBDYrr,
          15382 => Opcode::VPMOVSXBDZ128rm,
          15383 => Opcode::VPMOVSXBDZ128rmk,
          15384 => Opcode::VPMOVSXBDZ128rmkz,
          15385 => Opcode::VPMOVSXBDZ128rr,
          15386 => Opcode::VPMOVSXBDZ128rrk,
          15387 => Opcode::VPMOVSXBDZ128rrkz,
          15388 => Opcode::VPMOVSXBDZ256rm,
          15389 => Opcode::VPMOVSXBDZ256rmk,
          15390 => Opcode::VPMOVSXBDZ256rmkz,
          15391 => Opcode::VPMOVSXBDZ256rr,
          15392 => Opcode::VPMOVSXBDZ256rrk,
          15393 => Opcode::VPMOVSXBDZ256rrkz,
          15394 => Opcode::VPMOVSXBDZrm,
          15395 => Opcode::VPMOVSXBDZrmk,
          15396 => Opcode::VPMOVSXBDZrmkz,
          15397 => Opcode::VPMOVSXBDZrr,
          15398 => Opcode::VPMOVSXBDZrrk,
          15399 => Opcode::VPMOVSXBDZrrkz,
          15400 => Opcode::VPMOVSXBDrm,
          15401 => Opcode::VPMOVSXBDrr,
          15402 => Opcode::VPMOVSXBQYrm,
          15403 => Opcode::VPMOVSXBQYrr,
          15404 => Opcode::VPMOVSXBQZ128rm,
          15405 => Opcode::VPMOVSXBQZ128rmk,
          15406 => Opcode::VPMOVSXBQZ128rmkz,
          15407 => Opcode::VPMOVSXBQZ128rr,
          15408 => Opcode::VPMOVSXBQZ128rrk,
          15409 => Opcode::VPMOVSXBQZ128rrkz,
          15410 => Opcode::VPMOVSXBQZ256rm,
          15411 => Opcode::VPMOVSXBQZ256rmk,
          15412 => Opcode::VPMOVSXBQZ256rmkz,
          15413 => Opcode::VPMOVSXBQZ256rr,
          15414 => Opcode::VPMOVSXBQZ256rrk,
          15415 => Opcode::VPMOVSXBQZ256rrkz,
          15416 => Opcode::VPMOVSXBQZrm,
          15417 => Opcode::VPMOVSXBQZrmk,
          15418 => Opcode::VPMOVSXBQZrmkz,
          15419 => Opcode::VPMOVSXBQZrr,
          15420 => Opcode::VPMOVSXBQZrrk,
          15421 => Opcode::VPMOVSXBQZrrkz,
          15422 => Opcode::VPMOVSXBQrm,
          15423 => Opcode::VPMOVSXBQrr,
          15424 => Opcode::VPMOVSXBWYrm,
          15425 => Opcode::VPMOVSXBWYrr,
          15426 => Opcode::VPMOVSXBWZ128rm,
          15427 => Opcode::VPMOVSXBWZ128rmk,
          15428 => Opcode::VPMOVSXBWZ128rmkz,
          15429 => Opcode::VPMOVSXBWZ128rr,
          15430 => Opcode::VPMOVSXBWZ128rrk,
          15431 => Opcode::VPMOVSXBWZ128rrkz,
          15432 => Opcode::VPMOVSXBWZ256rm,
          15433 => Opcode::VPMOVSXBWZ256rmk,
          15434 => Opcode::VPMOVSXBWZ256rmkz,
          15435 => Opcode::VPMOVSXBWZ256rr,
          15436 => Opcode::VPMOVSXBWZ256rrk,
          15437 => Opcode::VPMOVSXBWZ256rrkz,
          15438 => Opcode::VPMOVSXBWZrm,
          15439 => Opcode::VPMOVSXBWZrmk,
          15440 => Opcode::VPMOVSXBWZrmkz,
          15441 => Opcode::VPMOVSXBWZrr,
          15442 => Opcode::VPMOVSXBWZrrk,
          15443 => Opcode::VPMOVSXBWZrrkz,
          15444 => Opcode::VPMOVSXBWrm,
          15445 => Opcode::VPMOVSXBWrr,
          15446 => Opcode::VPMOVSXDQYrm,
          15447 => Opcode::VPMOVSXDQYrr,
          15448 => Opcode::VPMOVSXDQZ128rm,
          15449 => Opcode::VPMOVSXDQZ128rmk,
          15450 => Opcode::VPMOVSXDQZ128rmkz,
          15451 => Opcode::VPMOVSXDQZ128rr,
          15452 => Opcode::VPMOVSXDQZ128rrk,
          15453 => Opcode::VPMOVSXDQZ128rrkz,
          15454 => Opcode::VPMOVSXDQZ256rm,
          15455 => Opcode::VPMOVSXDQZ256rmk,
          15456 => Opcode::VPMOVSXDQZ256rmkz,
          15457 => Opcode::VPMOVSXDQZ256rr,
          15458 => Opcode::VPMOVSXDQZ256rrk,
          15459 => Opcode::VPMOVSXDQZ256rrkz,
          15460 => Opcode::VPMOVSXDQZrm,
          15461 => Opcode::VPMOVSXDQZrmk,
          15462 => Opcode::VPMOVSXDQZrmkz,
          15463 => Opcode::VPMOVSXDQZrr,
          15464 => Opcode::VPMOVSXDQZrrk,
          15465 => Opcode::VPMOVSXDQZrrkz,
          15466 => Opcode::VPMOVSXDQrm,
          15467 => Opcode::VPMOVSXDQrr,
          15468 => Opcode::VPMOVSXWDYrm,
          15469 => Opcode::VPMOVSXWDYrr,
          15470 => Opcode::VPMOVSXWDZ128rm,
          15471 => Opcode::VPMOVSXWDZ128rmk,
          15472 => Opcode::VPMOVSXWDZ128rmkz,
          15473 => Opcode::VPMOVSXWDZ128rr,
          15474 => Opcode::VPMOVSXWDZ128rrk,
          15475 => Opcode::VPMOVSXWDZ128rrkz,
          15476 => Opcode::VPMOVSXWDZ256rm,
          15477 => Opcode::VPMOVSXWDZ256rmk,
          15478 => Opcode::VPMOVSXWDZ256rmkz,
          15479 => Opcode::VPMOVSXWDZ256rr,
          15480 => Opcode::VPMOVSXWDZ256rrk,
          15481 => Opcode::VPMOVSXWDZ256rrkz,
          15482 => Opcode::VPMOVSXWDZrm,
          15483 => Opcode::VPMOVSXWDZrmk,
          15484 => Opcode::VPMOVSXWDZrmkz,
          15485 => Opcode::VPMOVSXWDZrr,
          15486 => Opcode::VPMOVSXWDZrrk,
          15487 => Opcode::VPMOVSXWDZrrkz,
          15488 => Opcode::VPMOVSXWDrm,
          15489 => Opcode::VPMOVSXWDrr,
          15490 => Opcode::VPMOVSXWQYrm,
          15491 => Opcode::VPMOVSXWQYrr,
          15492 => Opcode::VPMOVSXWQZ128rm,
          15493 => Opcode::VPMOVSXWQZ128rmk,
          15494 => Opcode::VPMOVSXWQZ128rmkz,
          15495 => Opcode::VPMOVSXWQZ128rr,
          15496 => Opcode::VPMOVSXWQZ128rrk,
          15497 => Opcode::VPMOVSXWQZ128rrkz,
          15498 => Opcode::VPMOVSXWQZ256rm,
          15499 => Opcode::VPMOVSXWQZ256rmk,
          15500 => Opcode::VPMOVSXWQZ256rmkz,
          15501 => Opcode::VPMOVSXWQZ256rr,
          15502 => Opcode::VPMOVSXWQZ256rrk,
          15503 => Opcode::VPMOVSXWQZ256rrkz,
          15504 => Opcode::VPMOVSXWQZrm,
          15505 => Opcode::VPMOVSXWQZrmk,
          15506 => Opcode::VPMOVSXWQZrmkz,
          15507 => Opcode::VPMOVSXWQZrr,
          15508 => Opcode::VPMOVSXWQZrrk,
          15509 => Opcode::VPMOVSXWQZrrkz,
          15510 => Opcode::VPMOVSXWQrm,
          15511 => Opcode::VPMOVSXWQrr,
          15512 => Opcode::VPMOVUSDBZ128mr,
          15513 => Opcode::VPMOVUSDBZ128mrk,
          15514 => Opcode::VPMOVUSDBZ128rr,
          15515 => Opcode::VPMOVUSDBZ128rrk,
          15516 => Opcode::VPMOVUSDBZ128rrkz,
          15517 => Opcode::VPMOVUSDBZ256mr,
          15518 => Opcode::VPMOVUSDBZ256mrk,
          15519 => Opcode::VPMOVUSDBZ256rr,
          15520 => Opcode::VPMOVUSDBZ256rrk,
          15521 => Opcode::VPMOVUSDBZ256rrkz,
          15522 => Opcode::VPMOVUSDBZmr,
          15523 => Opcode::VPMOVUSDBZmrk,
          15524 => Opcode::VPMOVUSDBZrr,
          15525 => Opcode::VPMOVUSDBZrrk,
          15526 => Opcode::VPMOVUSDBZrrkz,
          15527 => Opcode::VPMOVUSDWZ128mr,
          15528 => Opcode::VPMOVUSDWZ128mrk,
          15529 => Opcode::VPMOVUSDWZ128rr,
          15530 => Opcode::VPMOVUSDWZ128rrk,
          15531 => Opcode::VPMOVUSDWZ128rrkz,
          15532 => Opcode::VPMOVUSDWZ256mr,
          15533 => Opcode::VPMOVUSDWZ256mrk,
          15534 => Opcode::VPMOVUSDWZ256rr,
          15535 => Opcode::VPMOVUSDWZ256rrk,
          15536 => Opcode::VPMOVUSDWZ256rrkz,
          15537 => Opcode::VPMOVUSDWZmr,
          15538 => Opcode::VPMOVUSDWZmrk,
          15539 => Opcode::VPMOVUSDWZrr,
          15540 => Opcode::VPMOVUSDWZrrk,
          15541 => Opcode::VPMOVUSDWZrrkz,
          15542 => Opcode::VPMOVUSQBZ128mr,
          15543 => Opcode::VPMOVUSQBZ128mrk,
          15544 => Opcode::VPMOVUSQBZ128rr,
          15545 => Opcode::VPMOVUSQBZ128rrk,
          15546 => Opcode::VPMOVUSQBZ128rrkz,
          15547 => Opcode::VPMOVUSQBZ256mr,
          15548 => Opcode::VPMOVUSQBZ256mrk,
          15549 => Opcode::VPMOVUSQBZ256rr,
          15550 => Opcode::VPMOVUSQBZ256rrk,
          15551 => Opcode::VPMOVUSQBZ256rrkz,
          15552 => Opcode::VPMOVUSQBZmr,
          15553 => Opcode::VPMOVUSQBZmrk,
          15554 => Opcode::VPMOVUSQBZrr,
          15555 => Opcode::VPMOVUSQBZrrk,
          15556 => Opcode::VPMOVUSQBZrrkz,
          15557 => Opcode::VPMOVUSQDZ128mr,
          15558 => Opcode::VPMOVUSQDZ128mrk,
          15559 => Opcode::VPMOVUSQDZ128rr,
          15560 => Opcode::VPMOVUSQDZ128rrk,
          15561 => Opcode::VPMOVUSQDZ128rrkz,
          15562 => Opcode::VPMOVUSQDZ256mr,
          15563 => Opcode::VPMOVUSQDZ256mrk,
          15564 => Opcode::VPMOVUSQDZ256rr,
          15565 => Opcode::VPMOVUSQDZ256rrk,
          15566 => Opcode::VPMOVUSQDZ256rrkz,
          15567 => Opcode::VPMOVUSQDZmr,
          15568 => Opcode::VPMOVUSQDZmrk,
          15569 => Opcode::VPMOVUSQDZrr,
          15570 => Opcode::VPMOVUSQDZrrk,
          15571 => Opcode::VPMOVUSQDZrrkz,
          15572 => Opcode::VPMOVUSQWZ128mr,
          15573 => Opcode::VPMOVUSQWZ128mrk,
          15574 => Opcode::VPMOVUSQWZ128rr,
          15575 => Opcode::VPMOVUSQWZ128rrk,
          15576 => Opcode::VPMOVUSQWZ128rrkz,
          15577 => Opcode::VPMOVUSQWZ256mr,
          15578 => Opcode::VPMOVUSQWZ256mrk,
          15579 => Opcode::VPMOVUSQWZ256rr,
          15580 => Opcode::VPMOVUSQWZ256rrk,
          15581 => Opcode::VPMOVUSQWZ256rrkz,
          15582 => Opcode::VPMOVUSQWZmr,
          15583 => Opcode::VPMOVUSQWZmrk,
          15584 => Opcode::VPMOVUSQWZrr,
          15585 => Opcode::VPMOVUSQWZrrk,
          15586 => Opcode::VPMOVUSQWZrrkz,
          15587 => Opcode::VPMOVUSWBZ128mr,
          15588 => Opcode::VPMOVUSWBZ128mrk,
          15589 => Opcode::VPMOVUSWBZ128rr,
          15590 => Opcode::VPMOVUSWBZ128rrk,
          15591 => Opcode::VPMOVUSWBZ128rrkz,
          15592 => Opcode::VPMOVUSWBZ256mr,
          15593 => Opcode::VPMOVUSWBZ256mrk,
          15594 => Opcode::VPMOVUSWBZ256rr,
          15595 => Opcode::VPMOVUSWBZ256rrk,
          15596 => Opcode::VPMOVUSWBZ256rrkz,
          15597 => Opcode::VPMOVUSWBZmr,
          15598 => Opcode::VPMOVUSWBZmrk,
          15599 => Opcode::VPMOVUSWBZrr,
          15600 => Opcode::VPMOVUSWBZrrk,
          15601 => Opcode::VPMOVUSWBZrrkz,
          15602 => Opcode::VPMOVW2MZ128rr,
          15603 => Opcode::VPMOVW2MZ256rr,
          15604 => Opcode::VPMOVW2MZrr,
          15605 => Opcode::VPMOVWBZ128mr,
          15606 => Opcode::VPMOVWBZ128mrk,
          15607 => Opcode::VPMOVWBZ128rr,
          15608 => Opcode::VPMOVWBZ128rrk,
          15609 => Opcode::VPMOVWBZ128rrkz,
          15610 => Opcode::VPMOVWBZ256mr,
          15611 => Opcode::VPMOVWBZ256mrk,
          15612 => Opcode::VPMOVWBZ256rr,
          15613 => Opcode::VPMOVWBZ256rrk,
          15614 => Opcode::VPMOVWBZ256rrkz,
          15615 => Opcode::VPMOVWBZmr,
          15616 => Opcode::VPMOVWBZmrk,
          15617 => Opcode::VPMOVWBZrr,
          15618 => Opcode::VPMOVWBZrrk,
          15619 => Opcode::VPMOVWBZrrkz,
          15620 => Opcode::VPMOVZXBDYrm,
          15621 => Opcode::VPMOVZXBDYrr,
          15622 => Opcode::VPMOVZXBDZ128rm,
          15623 => Opcode::VPMOVZXBDZ128rmk,
          15624 => Opcode::VPMOVZXBDZ128rmkz,
          15625 => Opcode::VPMOVZXBDZ128rr,
          15626 => Opcode::VPMOVZXBDZ128rrk,
          15627 => Opcode::VPMOVZXBDZ128rrkz,
          15628 => Opcode::VPMOVZXBDZ256rm,
          15629 => Opcode::VPMOVZXBDZ256rmk,
          15630 => Opcode::VPMOVZXBDZ256rmkz,
          15631 => Opcode::VPMOVZXBDZ256rr,
          15632 => Opcode::VPMOVZXBDZ256rrk,
          15633 => Opcode::VPMOVZXBDZ256rrkz,
          15634 => Opcode::VPMOVZXBDZrm,
          15635 => Opcode::VPMOVZXBDZrmk,
          15636 => Opcode::VPMOVZXBDZrmkz,
          15637 => Opcode::VPMOVZXBDZrr,
          15638 => Opcode::VPMOVZXBDZrrk,
          15639 => Opcode::VPMOVZXBDZrrkz,
          15640 => Opcode::VPMOVZXBDrm,
          15641 => Opcode::VPMOVZXBDrr,
          15642 => Opcode::VPMOVZXBQYrm,
          15643 => Opcode::VPMOVZXBQYrr,
          15644 => Opcode::VPMOVZXBQZ128rm,
          15645 => Opcode::VPMOVZXBQZ128rmk,
          15646 => Opcode::VPMOVZXBQZ128rmkz,
          15647 => Opcode::VPMOVZXBQZ128rr,
          15648 => Opcode::VPMOVZXBQZ128rrk,
          15649 => Opcode::VPMOVZXBQZ128rrkz,
          15650 => Opcode::VPMOVZXBQZ256rm,
          15651 => Opcode::VPMOVZXBQZ256rmk,
          15652 => Opcode::VPMOVZXBQZ256rmkz,
          15653 => Opcode::VPMOVZXBQZ256rr,
          15654 => Opcode::VPMOVZXBQZ256rrk,
          15655 => Opcode::VPMOVZXBQZ256rrkz,
          15656 => Opcode::VPMOVZXBQZrm,
          15657 => Opcode::VPMOVZXBQZrmk,
          15658 => Opcode::VPMOVZXBQZrmkz,
          15659 => Opcode::VPMOVZXBQZrr,
          15660 => Opcode::VPMOVZXBQZrrk,
          15661 => Opcode::VPMOVZXBQZrrkz,
          15662 => Opcode::VPMOVZXBQrm,
          15663 => Opcode::VPMOVZXBQrr,
          15664 => Opcode::VPMOVZXBWYrm,
          15665 => Opcode::VPMOVZXBWYrr,
          15666 => Opcode::VPMOVZXBWZ128rm,
          15667 => Opcode::VPMOVZXBWZ128rmk,
          15668 => Opcode::VPMOVZXBWZ128rmkz,
          15669 => Opcode::VPMOVZXBWZ128rr,
          15670 => Opcode::VPMOVZXBWZ128rrk,
          15671 => Opcode::VPMOVZXBWZ128rrkz,
          15672 => Opcode::VPMOVZXBWZ256rm,
          15673 => Opcode::VPMOVZXBWZ256rmk,
          15674 => Opcode::VPMOVZXBWZ256rmkz,
          15675 => Opcode::VPMOVZXBWZ256rr,
          15676 => Opcode::VPMOVZXBWZ256rrk,
          15677 => Opcode::VPMOVZXBWZ256rrkz,
          15678 => Opcode::VPMOVZXBWZrm,
          15679 => Opcode::VPMOVZXBWZrmk,
          15680 => Opcode::VPMOVZXBWZrmkz,
          15681 => Opcode::VPMOVZXBWZrr,
          15682 => Opcode::VPMOVZXBWZrrk,
          15683 => Opcode::VPMOVZXBWZrrkz,
          15684 => Opcode::VPMOVZXBWrm,
          15685 => Opcode::VPMOVZXBWrr,
          15686 => Opcode::VPMOVZXDQYrm,
          15687 => Opcode::VPMOVZXDQYrr,
          15688 => Opcode::VPMOVZXDQZ128rm,
          15689 => Opcode::VPMOVZXDQZ128rmk,
          15690 => Opcode::VPMOVZXDQZ128rmkz,
          15691 => Opcode::VPMOVZXDQZ128rr,
          15692 => Opcode::VPMOVZXDQZ128rrk,
          15693 => Opcode::VPMOVZXDQZ128rrkz,
          15694 => Opcode::VPMOVZXDQZ256rm,
          15695 => Opcode::VPMOVZXDQZ256rmk,
          15696 => Opcode::VPMOVZXDQZ256rmkz,
          15697 => Opcode::VPMOVZXDQZ256rr,
          15698 => Opcode::VPMOVZXDQZ256rrk,
          15699 => Opcode::VPMOVZXDQZ256rrkz,
          15700 => Opcode::VPMOVZXDQZrm,
          15701 => Opcode::VPMOVZXDQZrmk,
          15702 => Opcode::VPMOVZXDQZrmkz,
          15703 => Opcode::VPMOVZXDQZrr,
          15704 => Opcode::VPMOVZXDQZrrk,
          15705 => Opcode::VPMOVZXDQZrrkz,
          15706 => Opcode::VPMOVZXDQrm,
          15707 => Opcode::VPMOVZXDQrr,
          15708 => Opcode::VPMOVZXWDYrm,
          15709 => Opcode::VPMOVZXWDYrr,
          15710 => Opcode::VPMOVZXWDZ128rm,
          15711 => Opcode::VPMOVZXWDZ128rmk,
          15712 => Opcode::VPMOVZXWDZ128rmkz,
          15713 => Opcode::VPMOVZXWDZ128rr,
          15714 => Opcode::VPMOVZXWDZ128rrk,
          15715 => Opcode::VPMOVZXWDZ128rrkz,
          15716 => Opcode::VPMOVZXWDZ256rm,
          15717 => Opcode::VPMOVZXWDZ256rmk,
          15718 => Opcode::VPMOVZXWDZ256rmkz,
          15719 => Opcode::VPMOVZXWDZ256rr,
          15720 => Opcode::VPMOVZXWDZ256rrk,
          15721 => Opcode::VPMOVZXWDZ256rrkz,
          15722 => Opcode::VPMOVZXWDZrm,
          15723 => Opcode::VPMOVZXWDZrmk,
          15724 => Opcode::VPMOVZXWDZrmkz,
          15725 => Opcode::VPMOVZXWDZrr,
          15726 => Opcode::VPMOVZXWDZrrk,
          15727 => Opcode::VPMOVZXWDZrrkz,
          15728 => Opcode::VPMOVZXWDrm,
          15729 => Opcode::VPMOVZXWDrr,
          15730 => Opcode::VPMOVZXWQYrm,
          15731 => Opcode::VPMOVZXWQYrr,
          15732 => Opcode::VPMOVZXWQZ128rm,
          15733 => Opcode::VPMOVZXWQZ128rmk,
          15734 => Opcode::VPMOVZXWQZ128rmkz,
          15735 => Opcode::VPMOVZXWQZ128rr,
          15736 => Opcode::VPMOVZXWQZ128rrk,
          15737 => Opcode::VPMOVZXWQZ128rrkz,
          15738 => Opcode::VPMOVZXWQZ256rm,
          15739 => Opcode::VPMOVZXWQZ256rmk,
          15740 => Opcode::VPMOVZXWQZ256rmkz,
          15741 => Opcode::VPMOVZXWQZ256rr,
          15742 => Opcode::VPMOVZXWQZ256rrk,
          15743 => Opcode::VPMOVZXWQZ256rrkz,
          15744 => Opcode::VPMOVZXWQZrm,
          15745 => Opcode::VPMOVZXWQZrmk,
          15746 => Opcode::VPMOVZXWQZrmkz,
          15747 => Opcode::VPMOVZXWQZrr,
          15748 => Opcode::VPMOVZXWQZrrk,
          15749 => Opcode::VPMOVZXW