/* Copyright 2017 - 2024 R. Thomas
 * Copyright 2017 - 2024 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_NTDLL_DLL_LOOKUP_H
#define LIEF_PE_NTDLL_DLL_LOOKUP_H
#include <cstdint>

namespace LIEF {
namespace PE {

inline const char* ntdll_dll_lookup(uint32_t i) {
  switch(i) {
  case 0x0008: return "CsrAllocateCaptureBuffer";
  case 0x0009: return "CsrAllocateMessagePointer";
  case 0x000a: return "CsrCaptureMessageBuffer";
  case 0x000b: return "CsrCaptureMessageMultiUnicodeStringsInPlace";
  case 0x000c: return "CsrCaptureMessageString";
  case 0x000d: return "CsrCaptureTimeout";
  case 0x000e: return "CsrClientCallServer";
  case 0x000f: return "CsrClientConnectToServer";
  case 0x0010: return "CsrFreeCaptureBuffer";
  case 0x0011: return "CsrGetProcessId";
  case 0x0012: return "CsrIdentifyAlertableThread";
  case 0x0013: return "CsrNewThread";
  case 0x0014: return "CsrProbeForRead";
  case 0x0015: return "CsrProbeForWrite";
  case 0x0016: return "CsrSetPriorityClass";
  case 0x0017: return "DbgBreakPoint";
  case 0x0018: return "DbgPrint";
  case 0x0019: return "DbgPrintEx";
  case 0x001a: return "DbgPrintReturnControlC";
  case 0x001b: return "DbgPrompt";
  case 0x001c: return "DbgQueryDebugFilterState";
  case 0x001d: return "DbgSetDebugFilterState";
  case 0x001e: return "DbgUiConnectToDbg";
  case 0x001f: return "DbgUiContinue";
  case 0x0020: return "DbgUiConvertStateChangeStructure";
  case 0x0021: return "DbgUiDebugActiveProcess";
  case 0x0022: return "DbgUiGetThreadDebugObject";
  case 0x0023: return "DbgUiIssueRemoteBreakin";
  case 0x0024: return "DbgUiRemoteBreakin";
  case 0x0025: return "DbgUiSetThreadDebugObject";
  case 0x0026: return "DbgUiStopDebugging";
  case 0x0027: return "DbgUiWaitStateChange";
  case 0x0028: return "DbgUserBreakPoint";
  case 0x0029: return "KiFastSystemCall";
  case 0x002a: return "KiFastSystemCallRet";
  case 0x002b: return "KiIntSystemCall";
  case 0x002c: return "KiRaiseUserExceptionDispatcher";
  case 0x002d: return "KiUserApcDispatcher";
  case 0x002e: return "KiUserCallbackDispatcher";
  case 0x002f: return "KiUserExceptionDispatcher";
  case 0x0030: return "LdrAccessOutOfProcessResource";
  case 0x0031: return "LdrAccessResource";
  case 0x0032: return "LdrAddRefDll";
  case 0x0033: return "LdrAlternateResourcesEnabled";
  case 0x0034: return "LdrCreateOutOfProcessImage";
  case 0x0035: return "LdrDestroyOutOfProcessImage";
  case 0x0036: return "LdrDisableThreadCalloutsForDll";
  case 0x0037: return "LdrEnumResources";
  case 0x0038: return "LdrEnumerateLoadedModules";
  case 0x0039: return "LdrFindCreateProcessManifest";
  case 0x003a: return "LdrFindEntryForAddress";
  case 0x003b: return "LdrFindResourceDirectory_U";
  case 0x003c: return "LdrFindResourceEx_U";
  case 0x003d: return "LdrFindResource_U";
  case 0x003e: return "LdrFlushAlternateResourceModules";
  case 0x003f: return "LdrGetDllHandle";
  case 0x0040: return "LdrGetDllHandleEx";
  case 0x0041: return "LdrGetProcedureAddress";
  case 0x0042: return "LdrHotPatchRoutine";
  case 0x0043: return "LdrInitShimEngineDynamic";
  case 0x0044: return "LdrInitializeThunk";
  case 0x0045: return "LdrLoadAlternateResourceModule";
  case 0x0046: return "LdrLoadDll";
  case 0x0047: return "LdrLockLoaderLock";
  case 0x0048: return "LdrProcessRelocationBlock";
  case 0x0049: return "LdrQueryImageFileExecutionOptions";
  case 0x004a: return "LdrQueryProcessModuleInformation";
  case 0x004b: return "LdrSetAppCompatDllRedirectionCallback";
  case 0x004c: return "LdrSetDllManifestProber";
  case 0x004d: return "LdrShutdownProcess";
  case 0x004e: return "LdrShutdownThread";
  case 0x004f: return "LdrUnloadAlternateResourceModule";
  case 0x0050: return "LdrUnloadDll";
  case 0x0051: return "LdrUnlockLoaderLock";
  case 0x0052: return "LdrVerifyImageMatchesChecksum";
  case 0x0053: return "NlsAnsiCodePage";
  case 0x0054: return "NlsMbCodePageTag";
  case 0x0055: return "NlsMbOemCodePageTag";
  case 0x0056: return "NtAcceptConnectPort";
  case 0x0057: return "NtAccessCheck";
  case 0x0058: return "NtAccessCheckAndAuditAlarm";
  case 0x0059: return "NtAccessCheckByType";
  case 0x005a: return "NtAccessCheckByTypeAndAuditAlarm";
  case 0x005b: return "NtAccessCheckByTypeResultList";
  case 0x005c: return "NtAccessCheckByTypeResultListAndAuditAlarm";
  case 0x005d: return "NtAccessCheckByTypeResultListAndAuditAlarmByHandle";
  case 0x005e: return "NtAddAtom";
  case 0x005f: return "NtAddBootEntry";
  case 0x0060: return "NtAdjustGroupsToken";
  case 0x0061: return "NtAdjustPrivilegesToken";
  case 0x0062: return "NtAlertResumeThread";
  case 0x0063: return "NtAlertThread";
  case 0x0064: return "NtAllocateLocallyUniqueId";
  case 0x0065: return "NtAllocateUserPhysicalPages";
  case 0x0066: return "NtAllocateUuids";
  case 0x0067: return "NtAllocateVirtualMemory";
  case 0x0068: return "NtAreMappedFilesTheSame";
  case 0x0069: return "NtAssignProcessToJobObject";
  case 0x006a: return "NtCallbackReturn";
  case 0x006b: return "NtCancelDeviceWakeupRequest";
  case 0x006c: return "NtCancelIoFile";
  case 0x006d: return "NtCancelTimer";
  case 0x006e: return "NtClearEvent";
  case 0x006f: return "NtClose";
  case 0x0070: return "NtCloseObjectAuditAlarm";
  case 0x0071: return "NtCompactKeys";
  case 0x0072: return "NtCompareTokens";
  case 0x0073: return "NtCompleteConnectPort";
  case 0x0074: return "NtCompressKey";
  case 0x0075: return "NtConnectPort";
  case 0x0076: return "NtContinue";
  case 0x0077: return "NtCreateDebugObject";
  case 0x0078: return "NtCreateDirectoryObject";
  case 0x0079: return "NtCreateEvent";
  case 0x007a: return "NtCreateEventPair";
  case 0x007b: return "NtCreateFile";
  case 0x007c: return "NtCreateIoCompletion";
  case 0x007d: return "NtCreateJobObject";
  case 0x007e: return "NtCreateJobSet";
  case 0x007f: return "NtCreateKey";
  case 0x0080: return "NtCreateKeyedEvent";
  case 0x0081: return "NtCreateMailslotFile";
  case 0x0082: return "NtCreateMutant";
  case 0x0083: return "NtCreateNamedPipeFile";
  case 0x0084: return "NtCreatePagingFile";
  case 0x0085: return "NtCreatePort";
  case 0x0086: return "NtCreateProcess";
  case 0x0087: return "NtCreateProcessEx";
  case 0x0088: return "NtCreateProfile";
  case 0x0089: return "NtCreateSection";
  case 0x008a: return "NtCreateSemaphore";
  case 0x008b: return "NtCreateSymbolicLinkObject";
  case 0x008c: return "NtCreateThread";
  case 0x008d: return "NtCreateTimer";
  case 0x008e: return "NtCreateToken";
  case 0x008f: return "NtCreateWaitablePort";
  case 0x0090: return "NtCurrentTeb";
  case 0x0091: return "NtDebugActiveProcess";
  case 0x0092: return "NtDebugContinue";
  case 0x0093: return "NtDelayExecution";
  case 0x0094: return "NtDeleteAtom";
  case 0x0095: return "NtDeleteBootEntry";
  case 0x0096: return "NtDeleteFile";
  case 0x0097: return "NtDeleteKey";
  case 0x0098: return "NtDeleteObjectAuditAlarm";
  case 0x0099: return "NtDeleteValueKey";
  case 0x009a: return "NtDeviceIoControlFile";
  case 0x009b: return "NtDisplayString";
  case 0x009c: return "NtDuplicateObject";
  case 0x009d: return "NtDuplicateToken";
  case 0x009e: return "NtEnumerateBootEntries";
  case 0x009f: return "NtEnumerateKey";
  case 0x00a0: return "NtEnumerateSystemEnvironmentValuesEx";
  case 0x00a1: return "NtEnumerateValueKey";
  case 0x00a2: return "NtExtendSection";
  case 0x00a3: return "NtFilterToken";
  case 0x00a4: return "NtFindAtom";
  case 0x00a5: return "NtFlushBuffersFile";
  case 0x00a6: return "NtFlushInstructionCache";
  case 0x00a7: return "NtFlushKey";
  case 0x00a8: return "NtFlushVirtualMemory";
  case 0x00a9: return "NtFlushWriteBuffer";
  case 0x00aa: return "NtFreeUserPhysicalPages";
  case 0x00ab: return "NtFreeVirtualMemory";
  case 0x00ac: return "NtFsControlFile";
  case 0x00ad: return "NtGetContextThread";
  case 0x00ae: return "NtGetDevicePowerState";
  case 0x00af: return "NtGetPlugPlayEvent";
  case 0x00b0: return "NtGetWriteWatch";
  case 0x00b1: return "NtImpersonateAnonymousToken";
  case 0x00b2: return "NtImpersonateClientOfPort";
  case 0x00b3: return "NtImpersonateThread";
  case 0x00b4: return "NtInitializeRegistry";
  case 0x00b5: return "NtInitiatePowerAction";
  case 0x00b6: return "NtIsProcessInJob";
  case 0x00b7: return "NtIsSystemResumeAutomatic";
  case 0x00b8: return "NtListenPort";
  case 0x00b9: return "NtLoadDriver";
  case 0x00bb: return "NtLoadKey";
  case 0x00ba: return "NtLoadKey2";
  case 0x00bc: return "NtLockFile";
  case 0x00bd: return "NtLockProductActivationKeys";
  case 0x00be: return "NtLockRegistryKey";
  case 0x00bf: return "NtLockVirtualMemory";
  case 0x00c0: return "NtMakePermanentObject";
  case 0x00c1: return "NtMakeTemporaryObject";
  case 0x00c2: return "NtMapUserPhysicalPages";
  case 0x00c3: return "NtMapUserPhysicalPagesScatter";
  case 0x00c4: return "NtMapViewOfSection";
  case 0x00c5: return "NtModifyBootEntry";
  case 0x00c6: return "NtNotifyChangeDirectoryFile";
  case 0x00c7: return "NtNotifyChangeKey";
  case 0x00c8: return "NtNotifyChangeMultipleKeys";
  case 0x00c9: return "NtOpenDirectoryObject";
  case 0x00ca: return "NtOpenEvent";
  case 0x00cb: return "NtOpenEventPair";
  case 0x00cc: return "NtOpenFile";
  case 0x00cd: return "NtOpenIoCompletion";
  case 0x00ce: return "NtOpenJobObject";
  case 0x00cf: return "NtOpenKey";
  case 0x00d0: return "NtOpenKeyedEvent";
  case 0x00d1: return "NtOpenMutant";
  case 0x00d2: return "NtOpenObjectAuditAlarm";
  case 0x00d3: return "NtOpenProcess";
  case 0x00d4: return "NtOpenProcessToken";
  case 0x00d5: return "NtOpenProcessTokenEx";
  case 0x00d6: return "NtOpenSection";
  case 0x00d7: return "NtOpenSemaphore";
  case 0x00d8: return "NtOpenSymbolicLinkObject";
  case 0x00d9: return "NtOpenThread";
  case 0x00da: return "NtOpenThreadToken";
  case 0x00db: return "NtOpenThreadTokenEx";
  case 0x00dc: return "NtOpenTimer";
  case 0x00dd: return "NtPlugPlayControl";
  case 0x00de: return "NtPowerInformation";
  case 0x00df: return "NtPrivilegeCheck";
  case 0x00e0: return "NtPrivilegeObjectAuditAlarm";
  case 0x00e1: return "NtPrivilegedServiceAuditAlarm";
  case 0x00e2: return "NtProtectVirtualMemory";
  case 0x00e3: return "NtPulseEvent";
  case 0x00e4: return "NtQueryAttributesFile";
  case 0x00e5: return "NtQueryBootEntryOrder";
  case 0x00e6: return "NtQueryBootOptions";
  case 0x00e7: return "NtQueryDebugFilterState";
  case 0x00e8: return "NtQueryDefaultLocale";
  case 0x00e9: return "NtQueryDefaultUILanguage";
  case 0x00ea: return "NtQueryDirectoryFile";
  case 0x00eb: return "NtQueryDirectoryObject";
  case 0x00ec: return "NtQueryEaFile";
  case 0x00ed: return "NtQueryEvent";
  case 0x00ee: return "NtQueryFullAttributesFile";
  case 0x00ef: return "NtQueryInformationAtom";
  case 0x00f0: return "NtQueryInformationFile";
  case 0x00f1: return "NtQueryInformationJobObject";
  case 0x00f2: return "NtQueryInformationPort";
  case 0x00f3: return "NtQueryInformationProcess";
  case 0x00f4: return "NtQueryInformationThread";
  case 0x00f5: return "NtQueryInformationToken";
  case 0x00f6: return "NtQueryInstallUILanguage";
  case 0x00f7: return "NtQueryIntervalProfile";
  case 0x00f8: return "NtQueryIoCompletion";
  case 0x00f9: return "NtQueryKey";
  case 0x00fa: return "NtQueryMultipleValueKey";
  case 0x00fb: return "NtQueryMutant";
  case 0x00fc: return "NtQueryObject";
  case 0x00fd: return "NtQueryOpenSubKeys";
  case 0x00fe: return "NtQueryPerformanceCounter";
  case 0x00ff: return "NtQueryPortInformationProcess";
  case 0x0100: return "NtQueryQuotaInformationFile";
  case 0x0101: return "NtQuerySection";
  case 0x0102: return "NtQuerySecurityObject";
  case 0x0103: return "NtQuerySemaphore";
  case 0x0104: return "NtQuerySymbolicLinkObject";
  case 0x0105: return "NtQuerySystemEnvironmentValue";
  case 0x0106: return "NtQuerySystemEnvironmentValueEx";
  case 0x0107: return "NtQuerySystemInformation";
  case 0x0108: return "NtQuerySystemTime";
  case 0x0109: return "NtQueryTimer";
  case 0x010a: return "NtQueryTimerResolution";
  case 0x010b: return "NtQueryValueKey";
  case 0x010c: return "NtQueryVirtualMemory";
  case 0x010d: return "NtQueryVolumeInformationFile";
  case 0x010e: return "NtQueueApcThread";
  case 0x010f: return "NtRaiseException";
  case 0x0110: return "NtRaiseHardError";
  case 0x0111: return "NtReadFile";
  case 0x0112: return "NtReadFileScatter";
  case 0x0113: return "NtReadRequestData";
  case 0x0114: return "NtReadVirtualMemory";
  case 0x0115: return "NtRegisterThreadTerminatePort";
  case 0x0116: return "NtReleaseKeyedEvent";
  case 0x0117: return "NtReleaseMutant";
  case 0x0118: return "NtReleaseSemaphore";
  case 0x0119: return "NtRemoveIoCompletion";
  case 0x011a: return "NtRemoveProcessDebug";
  case 0x011b: return "NtRenameKey";
  case 0x011c: return "NtReplaceKey";
  case 0x011d: return "NtReplyPort";
  case 0x011e: return "NtReplyWaitReceivePort";
  case 0x011f: return "NtReplyWaitReceivePortEx";
  case 0x0120: return "NtReplyWaitReplyPort";
  case 0x0121: return "NtRequestDeviceWakeup";
  case 0x0122: return "NtRequestPort";
  case 0x0123: return "NtRequestWaitReplyPort";
  case 0x0124: return "NtRequestWakeupLatency";
  case 0x0125: return "NtResetEvent";
  case 0x0126: return "NtResetWriteWatch";
  case 0x0127: return "NtRestoreKey";
  case 0x0128: return "NtResumeProcess";
  case 0x0129: return "NtResumeThread";
  case 0x012a: return "NtSaveKey";
  case 0x012b: return "NtSaveKeyEx";
  case 0x012c: return "NtSaveMergedKeys";
  case 0x012d: return "NtSecureConnectPort";
  case 0x012e: return "NtSetBootEntryOrder";
  case 0x012f: return "NtSetBootOptions";
  case 0x0130: return "NtSetContextThread";
  case 0x0131: return "NtSetDebugFilterState";
  case 0x0132: return "NtSetDefaultHardErrorPort";
  case 0x0133: return "NtSetDefaultLocale";
  case 0x0134: return "NtSetDefaultUILanguage";
  case 0x0135: return "NtSetEaFile";
  case 0x0136: return "NtSetEvent";
  case 0x0137: return "NtSetEventBoostPriority";
  case 0x0138: return "NtSetHighEventPair";
  case 0x0139: return "NtSetHighWaitLowEventPair";
  case 0x013a: return "NtSetInformationDebugObject";
  case 0x013b: return "NtSetInformationFile";
  case 0x013c: return "NtSetInformationJobObject";
  case 0x013d: return "NtSetInformationKey";
  case 0x013e: return "NtSetInformationObject";
  case 0x013f: return "NtSetInformationProcess";
  case 0x0140: return "NtSetInformationThread";
  case 0x0141: return "NtSetInformationToken";
  case 0x0142: return "NtSetIntervalProfile";
  case 0x0143: return "NtSetIoCompletion";
  case 0x0144: return "NtSetLdtEntries";
  case 0x0145: return "NtSetLowEventPair";
  case 0x0146: return "NtSetLowWaitHighEventPair";
  case 0x0147: return "NtSetQuotaInformationFile";
  case 0x0148: return "NtSetSecurityObject";
  case 0x0149: return "NtSetSystemEnvironmentValue";
  case 0x014a: return "NtSetSystemEnvironmentValueEx";
  case 0x014b: return "NtSetSystemInformation";
  case 0x014c: return "NtSetSystemPowerState";
  case 0x014d: return "NtSetSystemTime";
  case 0x014e: return "NtSetThreadExecutionState";
  case 0x014f: return "NtSetTimer";
  case 0x0150: return "NtSetTimerResolution";
  case 0x0151: return "NtSetUuidSeed";
  case 0x0152: return "NtSetValueKey";
  case 0x0153: return "NtSetVolumeInformationFile";
  case 0x0154: return "NtShutdownSystem";
  case 0x0155: return "NtSignalAndWaitForSingleObject";
  case 0x0156: return "NtStartProfile";
  case 0x0157: return "NtStopProfile";
  case 0x0158: return "NtSuspendProcess";
  case 0x0159: return "NtSuspendThread";
  case 0x015a: return "NtSystemDebugControl";
  case 0x015b: return "NtTerminateJobObject";
  case 0x015c: return "NtTerminateProcess";
  case 0x015d: return "NtTerminateThread";
  case 0x015e: return "NtTestAlert";
  case 0x015f: return "NtTraceEvent";
  case 0x0160: return "NtTranslateFilePath";
  case 0x0161: return "NtUnloadDriver";
  case 0x0162: return "NtUnloadKey";
  case 0x0163: return "NtUnloadKeyEx";
  case 0x0164: return "NtUnlockFile";
  case 0x0165: return "NtUnlockVirtualMemory";
  case 0x0166: return "NtUnmapViewOfSection";
  case 0x0167: return "NtVdmControl";
  case 0x0168: return "NtWaitForDebugEvent";
  case 0x0169: return "NtWaitForKeyedEvent";
  case 0x016a: return "NtWaitForMultipleObjects";
  case 0x016b: return "NtWaitForSingleObject";
  case 0x016c: return "NtWaitHighEventPair";
  case 0x016d: return "NtWaitLowEventPair";
  case 0x016e: return "NtWriteFile";
  case 0x016f: return "NtWriteFileGather";
  case 0x0170: return "NtWriteRequestData";
  case 0x0171: return "NtWriteVirtualMemory";
  case 0x0172: return "NtYieldExecution";
  case 0x0173: return "PfxFindPrefix";
  case 0x0174: return "PfxInitialize";
  case 0x0175: return "PfxInsertPrefix";
  case 0x0176: return "PfxRemovePrefix";
  case 0x0001: return "PropertyLengthAsVariant";
  case 0x0177: return "RtlAbortRXact";
  case 0x0178: return "RtlAbsoluteToSelfRelativeSD";
  case 0x0179: return "RtlAcquirePebLock";
  case 0x017a: return "RtlAcquireResourceExclusive";
  case 0x017b: return "RtlAcquireResourceShared";
  case 0x017c: return "RtlActivateActivationContext";
  case 0x017d: return "RtlActivateActivationContextEx";
  case 0x017e: return "RtlActivateActivationContextUnsafeFast";
  case 0x017f: return "RtlAddAccessAllowedAce";
  case 0x0180: return "RtlAddAccessAllowedAceEx";
  case 0x0181: return "RtlAddAccessAllowedObjectAce";
  case 0x0182: return "RtlAddAccessDeniedAce";
  case 0x0183: return "RtlAddAccessDeniedAceEx";
  case 0x0184: return "RtlAddAccessDeniedObjectAce";
  case 0x0185: return "RtlAddAce";
  case 0x0186: return "RtlAddActionToRXact";
  case 0x0187: return "RtlAddAtomToAtomTable";
  case 0x0188: return "RtlAddAttributeActionToRXact";
  case 0x0189: return "RtlAddAuditAccessAce";
  case 0x018a: return "RtlAddAuditAccessAceEx";
  case 0x018b: return "RtlAddAuditAccessObjectAce";
  case 0x018c: return "RtlAddCompoundAce";
  case 0x018d: return "RtlAddRange";
  case 0x018e: return "RtlAddRefActivationContext";
  case 0x018f: return "RtlAddRefMemoryStream";
  case 0x0190: return "RtlAddVectoredExceptionHandler";
  case 0x0191: return "RtlAddressInSectionTable";
  case 0x0192: return "RtlAdjustPrivilege";
  case 0x0193: return "RtlAllocateAndInitializeSid";
  case 0x0194: return "RtlAllocateHandle";
  case 0x0195: return "RtlAllocateHeap";
  case 0x0196: return "RtlAnsiCharToUnicodeChar";
  case 0x0197: return "RtlAnsiStringToUnicodeSize";
  case 0x0198: return "RtlAnsiStringToUnicodeString";
  case 0x0199: return "RtlAppendAsciizToString";
  case 0x019a: return "RtlAppendPathElement";
  case 0x019b: return "RtlAppendStringToString";
  case 0x019c: return "RtlAppendUnicodeStringToString";
  case 0x019d: return "RtlAppendUnicodeToString";
  case 0x019e: return "RtlApplicationVerifierStop";
  case 0x019f: return "RtlApplyRXact";
  case 0x01a0: return "RtlApplyRXactNoFlush";
  case 0x01a1: return "RtlAreAllAccessesGranted";
  case 0x01a2: return "RtlAreAnyAccessesGranted";
  case 0x01a3: return "RtlAreBitsClear";
  case 0x01a4: return "RtlAreBitsSet";
  case 0x01a6: return "RtlAssert";
  case 0x01a5: return "RtlAssert2";
  case 0x01a7: return "RtlCancelTimer";
  case 0x01a8: return "RtlCaptureContext";
  case 0x01a9: return "RtlCaptureStackBackTrace";
  case 0x01aa: return "RtlCaptureStackContext";
  case 0x01ab: return "RtlCharToInteger";
  case 0x01ac: return "RtlCheckForOrphanedCriticalSections";
  case 0x01ad: return "RtlCheckProcessParameters";
  case 0x01ae: return "RtlCheckRegistryKey";
  case 0x01af: return "RtlClearAllBits";
  case 0x01b0: return "RtlClearBits";
  case 0x01b1: return "RtlCloneMemoryStream";
  case 0x01b2: return "RtlCommitMemoryStream";
  case 0x01b3: return "RtlCompactHeap";
  case 0x01b4: return "RtlCompareMemory";
  case 0x01b5: return "RtlCompareMemoryUlong";
  case 0x01b6: return "RtlCompareString";
  case 0x01b7: return "RtlCompareUnicodeString";
  case 0x01b8: return "RtlCompressBuffer";
  case 0x01b9: return "RtlComputeCrc32";
  case 0x01ba: return "RtlComputeImportTableHash";
  case 0x01bb: return "RtlComputePrivatizedDllName_U";
  case 0x01bc: return "RtlConsoleMultiByteToUnicodeN";
  case 0x01bd: return "RtlConvertExclusiveToShared";
  case 0x01be: return "RtlConvertLongToLargeInteger";
  case 0x0002: return "RtlConvertPropertyToVariant";
  case 0x01bf: return "RtlConvertSharedToExclusive";
  case 0x01c0: return "RtlConvertSidToUnicodeString";
  case 0x01c1: return "RtlConvertToAutoInheritSecurityObject";
  case 0x01c2: return "RtlConvertUiListToApiList";
  case 0x01c3: return "RtlConvertUlongToLargeInteger";
  case 0x0003: return "RtlConvertVariantToProperty";
  case 0x01c4: return "RtlCopyLuid";
  case 0x01c5: return "RtlCopyLuidAndAttributesArray";
  case 0x01c6: return "RtlCopyMemoryStreamTo";
  case 0x01c7: return "RtlCopyOutOfProcessMemoryStreamTo";
  case 0x01c8: return "RtlCopyRangeList";
  case 0x01c9: return "RtlCopySecurityDescriptor";
  case 0x01ca: return "RtlCopySid";
  case 0x01cb: return "RtlCopySidAndAttributesArray";
  case 0x01cc: return "RtlCopyString";
  case 0x01cd: return "RtlCopyUnicodeString";
  case 0x01ce: return "RtlCreateAcl";
  case 0x01cf: return "RtlCreateActivationContext";
  case 0x01d0: return "RtlCreateAndSetSD";
  case 0x01d1: return "RtlCreateAtomTable";
  case 0x01d2: return "RtlCreateBootStatusDataFile";
  case 0x01d3: return "RtlCreateEnvironment";
  case 0x01d4: return "RtlCreateHeap";
  case 0x01d5: return "RtlCreateProcessParameters";
  case 0x01d6: return "RtlCreateQueryDebugBuffer";
  case 0x01d7: return "RtlCreateRegistryKey";
  case 0x01d8: return "RtlCreateSecurityDescriptor";
  case 0x01d9: return "RtlCreateSystemVolumeInformationFolder";
  case 0x01da: return "RtlCreateTagHeap";
  case 0x01db: return "RtlCreateTimer";
  case 0x01dc: return "RtlCreateTimerQueue";
  case 0x01dd: return "RtlCreateUnicodeString";
  case 0x01de: return "RtlCreateUnicodeStringFromAsciiz";
  case 0x01df: return "RtlCreateUserProcess";
  case 0x01e0: return "RtlCreateUserSecurityObject";
  case 0x01e1: return "RtlCreateUserThread";
  case 0x01e2: return "RtlCustomCPToUnicodeN";
  case 0x01e3: return "RtlCutoverTimeToSystemTime";
  case 0x01e4: return "RtlDeNormalizeProcessParams";
  case 0x01e5: return "RtlDeactivateActivationContext";
  case 0x01e6: return "RtlDeactivateActivationContextUnsafeFast";
  case 0x01e7: return "RtlDebugPrintTimes";
  case 0x01e8: return "RtlDecodePointer";
  case 0x01e9: return "RtlDecodeSystemPointer";
  case 0x01ea: return "RtlDecompressBuffer";
  case 0x01eb: return "RtlDecompressFragment";
  case 0x01ec: return "RtlDefaultNpAcl";
  case 0x01ed: return "RtlDelete";
  case 0x01ee: return "RtlDeleteAce";
  case 0x01ef: return "RtlDeleteAtomFromAtomTable";
  case 0x01f0: return "RtlDeleteCriticalSection";
  case 0x01f1: return "RtlDeleteElementGenericTable";
  case 0x01f2: return "RtlDeleteElementGenericTableAvl";
  case 0x01f3: return "RtlDeleteNoSplay";
  case 0x01f4: return "RtlDeleteOwnersRanges";
  case 0x01f5: return "RtlDeleteRange";
  case 0x01f6: return "RtlDeleteRegistryValue";
  case 0x01f7: return "RtlDeleteResource";
  case 0x01f8: return "RtlDeleteSecurityObject";
  case 0x01f9: return "RtlDeleteTimer";
  case 0x01fa: return "RtlDeleteTimerQueue";
  case 0x01fb: return "RtlDeleteTimerQueueEx";
  case 0x01fc: return "RtlDeregisterWait";
  case 0x01fd: return "RtlDeregisterWaitEx";
  case 0x01fe: return "RtlDestroyAtomTable";
  case 0x01ff: return "RtlDestroyEnvironment";
  case 0x0200: return "RtlDestroyHandleTable";
  case 0x0201: return "RtlDestroyHeap";
  case 0x0202: return "RtlDestroyProcessParameters";
  case 0x0203: return "RtlDestroyQueryDebugBuffer";
  case 0x0204: return "RtlDetermineDosPathNameType_U";
  case 0x0205: return "RtlDllShutdownInProgress";
  case 0x0206: return "RtlDnsHostNameToComputerName";
  case 0x0207: return "RtlDoesFileExists_U";
  case 0x0208: return "RtlDosApplyFileIsolationRedirection_Ustr";
  case 0x0209: return "RtlDosPathNameToNtPathName_U";
  case 0x020a: return "RtlDosSearchPath_U";
  case 0x020b: return "RtlDosSearchPath_Ustr";
  case 0x020c: return "RtlDowncaseUnicodeChar";
  case 0x020d: return "RtlDowncaseUnicodeString";
  case 0x020e: return "RtlDumpResource";
  case 0x020f: return "RtlDuplicateUnicodeString";
  case 0x0210: return "RtlEmptyAtomTable";
  case 0x0211: return "RtlEnableEarlyCriticalSectionEventCreation";
  case 0x0212: return "RtlEncodePointer";
  case 0x0213: return "RtlEncodeSystemPointer";
  case 0x0214: return "RtlEnlargedIntegerMultiply";
  case 0x0215: return "RtlEnlargedUnsignedDivide";
  case 0x0216: return "RtlEnlargedUnsignedMultiply";
  case 0x0217: return "RtlEnterCriticalSection";
  case 0x0218: return "RtlEnumProcessHeaps";
  case 0x0219: return "RtlEnumerateGenericTable";
  case 0x021a: return "RtlEnumerateGenericTableAvl";
  case 0x021b: return "RtlEnumerateGenericTableLikeADirectory";
  case 0x021c: return "RtlEnumerateGenericTableWithoutSplaying";
  case 0x021d: return "RtlEnumerateGenericTableWithoutSplayingAvl";
  case 0x021e: return "RtlEqualComputerName";
  case 0x021f: return "RtlEqualDomainName";
  case 0x0220: return "RtlEqualLuid";
  case 0x0221: return "RtlEqualPrefixSid";
  case 0x0222: return "RtlEqualSid";
  case 0x0223: return "RtlEqualString";
  case 0x0224: return "RtlEqualUnicodeString";
  case 0x0225: return "RtlEraseUnicodeString";
  case 0x0226: return "RtlExitUserThread";
  case 0x0227: return "RtlExpandEnvironmentStrings_U";
  case 0x0228: return "RtlExtendHeap";
  case 0x0229: return "RtlExtendedIntegerMultiply";
  case 0x022a: return "RtlExtendedLargeIntegerDivide";
  case 0x022b: return "RtlExtendedMagicDivide";
  case 0x022c: return "RtlFillMemory";
  case 0x022d: return "RtlFillMemoryUlong";
  case 0x022e: return "RtlFinalReleaseOutOfProcessMemoryStream";
  case 0x022f: return "RtlFindActivationContextSectionGuid";
  case 0x0230: return "RtlFindActivationContextSectionString";
  case 0x0231: return "RtlFindCharInUnicodeString";
  case 0x0232: return "RtlFindClearBits";
  case 0x0233: return "RtlFindClearBitsAndSet";
  case 0x0234: return "RtlFindClearRuns";
  case 0x0235: return "RtlFindLastBackwardRunClear";
  case 0x0236: return "RtlFindLeastSignificantBit";
  case 0x0237: return "RtlFindLongestRunClear";
  case 0x0238: return "RtlFindMessage";
  case 0x0239: return "RtlFindMostSignificantBit";
  case 0x023a: return "RtlFindNextForwardRunClear";
  case 0x023b: return "RtlFindRange";
  case 0x023c: return "RtlFindSetBits";
  case 0x023d: return "RtlFindSetBitsAndClear";
  case 0x023e: return "RtlFirstEntrySList";
  case 0x023f: return "RtlFirstFreeAce";
  case 0x0240: return "RtlFlushSecureMemoryCache";
  case 0x0241: return "RtlFormatCurrentUserKeyPath";
  case 0x0242: return "RtlFormatMessage";
  case 0x0243: return "RtlFreeAnsiString";
  case 0x0244: return "RtlFreeHandle";
  case 0x0245: return "RtlFreeHeap";
  case 0x0246: return "RtlFreeOemString";
  case 0x0247: return "RtlFreeRangeList";
  case 0x0248: return "RtlFreeSid";
  case 0x0249: return "RtlFreeThreadActivationContextStack";
  case 0x024a: return "RtlFreeUnicodeString";
  case 0x024b: return "RtlFreeUserThreadStack";
  case 0x024c: return "RtlGUIDFromString";
  case 0x024d: return "RtlGenerate8dot3Name";
  case 0x024e: return "RtlGetAce";
  case 0x024f: return "RtlGetActiveActivationContext";
  case 0x0250: return "RtlGetCallersAddress";
  case 0x0251: return "RtlGetCompressionWorkSpaceSize";
  case 0x0252: return "RtlGetControlSecurityDescriptor";
  case 0x0253: return "RtlGetCurrentDirectory_U";
  case 0x0254: return "RtlGetCurrentPeb";
  case 0x0255: return "RtlGetDaclSecurityDescriptor";
  case 0x0256: return "RtlGetElementGenericTable";
  case 0x0257: return "RtlGetElementGenericTableAvl";
  case 0x0258: return "RtlGetFirstRange";
  case 0x0259: return "RtlGetFrame";
  case 0x025a: return "RtlGetFullPathName_U";
  case 0x025b: return "RtlGetGroupSecurityDescriptor";
  case 0x025c: return "RtlGetLastNtStatus";
  case 0x025d: return "RtlGetLastWin32Error";
  case 0x025e: return "RtlGetLengthWithoutLastFullDosOrNtPathElement";
  case 0x025f: return "RtlGetLengthWithoutTrailingPathSeperators";
  case 0x0260: return "RtlGetLongestNtPathLength";
  case 0x0261: return "RtlGetNativeSystemInformation";
  case 0x0262: return "RtlGetNextRange";
  case 0x0263: return "RtlGetNtGlobalFlags";
  case 0x0264: return "RtlGetNtProductType";
  case 0x0265: return "RtlGetNtVersionNumbers";
  case 0x0266: return "RtlGetOwnerSecurityDescriptor";
  case 0x0267: return "RtlGetProcessHeaps";
  case 0x0268: return "RtlGetSaclSecurityDescriptor";
  case 0x0269: return "RtlGetSecurityDescriptorRMControl";
  case 0x026a: return "RtlGetSetBootStatusData";
  case 0x026b: return "RtlGetUnloadEventTrace";
  case 0x026c: return "RtlGetUserInfoHeap";
  case 0x026d: return "RtlGetVersion";
  case 0x026e: return "RtlHashUnicodeString";
  case 0x026f: return "RtlIdentifierAuthoritySid";
  case 0x0270: return "RtlImageDirectoryEntryToData";
  case 0x0271: return "RtlImageNtHeader";
  case 0x0272: return "RtlImageRvaToSection";
  case 0x0273: return "RtlImageRvaToVa";
  case 0x0274: return "RtlImpersonateSelf";
  case 0x0275: return "RtlInitAnsiString";
  case 0x0276: return "RtlInitCodePageTable";
  case 0x0277: return "RtlInitMemoryStream";
  case 0x0278: return "RtlInitNlsTables";
  case 0x0279: return "RtlInitOutOfProcessMemoryStream";
  case 0x027a: return "RtlInitString";
  case 0x027b: return "RtlInitUnicodeString";
  case 0x027c: return "RtlInitUnicodeStringEx";
  case 0x027d: return "RtlInitializeAtomPackage";
  case 0x027e: return "RtlInitializeBitMap";
  case 0x027f: return "RtlInitializeContext";
  case 0x0280: return "RtlInitializeCriticalSection";
  case 0x0281: return "RtlInitializeCriticalSectionAndSpinCount";
  case 0x0282: return "RtlInitializeGenericTable";
  case 0x0283: return "RtlInitializeGenericTableAvl";
  case 0x0284: return "RtlInitializeHandleTable";
  case 0x0285: return "RtlInitializeRXact";
  case 0x0286: return "RtlInitializeRangeList";
  case 0x0287: return "RtlInitializeResource";
  case 0x0288: return "RtlInitializeSListHead";
  case 0x0289: return "RtlInitializeSid";
  case 0x028a: return "RtlInitializeStackTraceDataBase";
  case 0x028b: return "RtlInsertElementGenericTable";
  case 0x028c: return "RtlInsertElementGenericTableAvl";
  case 0x028d: return "RtlInt64ToUnicodeString";
  case 0x028e: return "RtlIntegerToChar";
  case 0x028f: return "RtlIntegerToUnicodeString";
  case 0x0290: return "RtlInterlockedFlushSList";
  case 0x0291: return "RtlInterlockedPopEntrySList";
  case 0x0292: return "RtlInterlockedPushEntrySList";
  case 0x0004: return "RtlInterlockedPushListSList";
  case 0x0293: return "RtlInvertRangeList";
  case 0x0294: return "RtlIpv4AddressToStringA";
  case 0x0295: return "RtlIpv4AddressToStringExA";
  case 0x0296: return "RtlIpv4AddressToStringExW";
  case 0x0297: return "RtlIpv4AddressToStringW";
  case 0x0298: return "RtlIpv4StringToAddressA";
  case 0x0299: return "RtlIpv4StringToAddressExA";
  case 0x029a: return "RtlIpv4StringToAddressExW";
  case 0x029b: return "RtlIpv4StringToAddressW";
  case 0x029c: return "RtlIpv6AddressToStringA";
  case 0x029d: return "RtlIpv6AddressToStringExA";
  case 0x029e: return "RtlIpv6AddressToStringExW";
  case 0x029f: return "RtlIpv6AddressToStringW";
  case 0x02a0: return "RtlIpv6StringToAddressA";
  case 0x02a1: return "RtlIpv6StringToAddressExA";
  case 0x02a2: return "RtlIpv6StringToAddressExW";
  case 0x02a3: return "RtlIpv6StringToAddressW";
  case 0x02a4: return "RtlIsActivationContextActive";
  case 0x02a5: return "RtlIsDosDeviceName_U";
  case 0x02a6: return "RtlIsGenericTableEmpty";
  case 0x02a7: return "RtlIsGenericTableEmptyAvl";
  case 0x02a8: return "RtlIsNameLegalDOS8Dot3";
  case 0x02a9: return "RtlIsRangeAvailable";
  case 0x02aa: return "RtlIsTextUnicode";
  case 0x02ab: return "RtlIsThreadWithinLoaderCallout";
  case 0x02ac: return "RtlIsValidHandle";
  case 0x02ad: return "RtlIsValidIndexHandle";
  case 0x02ae: return "RtlLargeIntegerAdd";
  case 0x02af: return "RtlLargeIntegerArithmeticShift";
  case 0x02b0: return "RtlLargeIntegerDivide";
  case 0x02b1: return "RtlLargeIntegerNegate";
  case 0x02b2: return "RtlLargeIntegerShiftLeft";
  case 0x02b3: return "RtlLargeIntegerShiftRight";
  case 0x02b4: return "RtlLargeIntegerSubtract";
  case 0x02b5: return "RtlLargeIntegerToChar";
  case 0x02b6: return "RtlLeaveCriticalSection";
  case 0x02b7: return "RtlLengthRequiredSid";
  case 0x02b8: return "RtlLengthSecurityDescriptor";
  case 0x02b9: return "RtlLengthSid";
  case 0x02ba: return "RtlLocalTimeToSystemTime";
  case 0x02bb: return "RtlLockBootStatusData";
  case 0x02bc: return "RtlLockHeap";
  case 0x02bd: return "RtlLockMemoryStreamRegion";
  case 0x02be: return "RtlLogStackBackTrace";
  case 0x02bf: return "RtlLookupAtomInAtomTable";
  case 0x02c0: return "RtlLookupElementGenericTable";
  case 0x02c1: return "RtlLookupElementGenericTableAvl";
  case 0x02c2: return "RtlMakeSelfRelativeSD";
  case 0x02c3: return "RtlMapGenericMask";
  case 0x02c4: return "RtlMapSecurityErrorToNtStatus";
  case 0x02c5: return "RtlMergeRangeLists";
  case 0x02c6: return "RtlMoveMemory";
  case 0x02c7: return "RtlMultiAppendUnicodeStringBuffer";
  case 0x02c8: return "RtlMultiByteToUnicodeN";
  case 0x02c9: return "RtlMultiByteToUnicodeSize";
  case 0x02ca: return "RtlNewInstanceSecurityObject";
  case 0x02cb: return "RtlNewSecurityGrantedAccess";
  case 0x02cc: return "RtlNewSecurityObject";
  case 0x02cd: return "RtlNewSecurityObjectEx";
  case 0x02ce: return "RtlNewSecurityObjectWithMultipleInheritance";
  case 0x02cf: return "RtlNormalizeProcessParams";
  case 0x02d0: return "RtlNtPathNameToDosPathName";
  case 0x02d1: return "RtlNtStatusToDosError";
  case 0x02d2: return "RtlNtStatusToDosErrorNoTeb";
  case 0x02d3: return "RtlNumberGenericTableElements";
  case 0x02d4: return "RtlNumberGenericTableElementsAvl";
  case 0x02d5: return "RtlNumberOfClearBits";
  case 0x02d6: return "RtlNumberOfSetBits";
  case 0x02d7: return "RtlOemStringToUnicodeSize";
  case 0x02d8: return "RtlOemStringToUnicodeString";
  case 0x02d9: return "RtlOemToUnicodeN";
  case 0x02da: return "RtlOpenCurrentUser";
  case 0x02db: return "RtlPcToFileHeader";
  case 0x02dc: return "RtlPinAtomInAtomTable";
  case 0x02dd: return "RtlPopFrame";
  case 0x02de: return "RtlPrefixString";
  case 0x02df: return "RtlPrefixUnicodeString";
  case 0x02e0: return "RtlProtectHeap";
  case 0x02e1: return "RtlPushFrame";
  case 0x02e2: return "RtlQueryAtomInAtomTable";
  case 0x02e3: return "RtlQueryDepthSList";
  case 0x02e4: return "RtlQueryEnvironmentVariable_U";
  case 0x02e5: return "RtlQueryHeapInformation";
  case 0x02e6: return "RtlQueryInformationAcl";
  case 0x02e7: return "RtlQueryInformationActivationContext";
  case 0x02e8: return "RtlQueryInformationActiveActivationContext";
  case 0x02e9: return "RtlQueryInterfaceMemoryStream";
  case 0x02ea: return "RtlQueryProcessBackTraceInformation";
  case 0x02eb: return "RtlQueryProcessDebugInformation";
  case 0x02ec: return "RtlQueryProcessHeapInformation";
  case 0x02ed: return "RtlQueryProcessLockInformation";
  case 0x02ee: return "RtlQueryRegistryValues";
  case 0x02ef: return "RtlQuerySecurityObject";
  case 0x02f0: return "RtlQueryTagHeap";
  case 0x02f1: return "RtlQueryTimeZoneInformation";
  case 0x02f2: return "RtlQueueApcWow64Thread";
  case 0x02f3: return "RtlQueueWorkItem";
  case 0x02f4: return "RtlRaiseException";
  case 0x02f5: return "RtlRaiseStatus";
  case 0x02f6: return "RtlRandom";
  case 0x02f7: return "RtlRandomEx";
  case 0x02f8: return "RtlReAllocateHeap";
  case 0x02f9: return "RtlReadMemoryStream";
  case 0x02fa: return "RtlReadOutOfProcessMemoryStream";
  case 0x02fb: return "RtlRealPredecessor";
  case 0x02fc: return "RtlRealSuccessor";
  case 0x02fd: return "RtlRegisterSecureMemoryCacheCallback";
  case 0x02fe: return "RtlRegisterWait";
  case 0x02ff: return "RtlReleaseActivationContext";
  case 0x0300: return "RtlReleaseMemoryStream";
  case 0x0301: return "RtlReleasePebLock";
  case 0x0302: return "RtlReleaseResource";
  case 0x0303: return "RtlRemoteCall";
  case 0x0304: return "RtlRemoveVectoredExceptionHandler";
  case 0x0305: return "RtlResetRtlTranslations";
  case 0x0306: return "RtlRestoreLastWin32Error";
  case 0x0307: return "RtlRevertMemoryStream";
  case 0x0308: return "RtlRunDecodeUnicodeString";
  case 0x0309: return "RtlRunEncodeUnicodeString";
  case 0x030a: return "RtlSecondsSince1970ToTime";
  case 0x030b: return "RtlSecondsSince1980ToTime";
  case 0x030c: return "RtlSeekMemoryStream";
  case 0x030e: return "RtlSelfRelativeToAbsoluteSD";
  case 0x030d: return "RtlSelfRelativeToAbsoluteSD2";
  case 0x030f: return "RtlSetAllBits";
  case 0x0310: return "RtlSetAttributesSecurityDescriptor";
  case 0x0311: return "RtlSetBits";
  case 0x0312: return "RtlSetControlSecurityDescriptor";
  case 0x0313: return "RtlSetCriticalSectionSpinCount";
  case 0x0314: return "RtlSetCurrentDirectory_U";
  case 0x0315: return "RtlSetCurrentEnvironment";
  case 0x0316: return "RtlSetDaclSecurityDescriptor";
  case 0x0317: return "RtlSetEnvironmentVariable";
  case 0x0318: return "RtlSetGroupSecurityDescriptor";
  case 0x0319: return "RtlSetHeapInformation";
  case 0x031a: return "RtlSetInformationAcl";
  case 0x031b: return "RtlSetIoCompletionCallback";
  case 0x031c: return "RtlSetLastWin32Error";
  case 0x031d: return "RtlSetLastWin32ErrorAndNtStatusFromNtStatus";
  case 0x031e: return "RtlSetMemoryStreamSize";
  case 0x031f: return "RtlSetOwnerSecurityDescriptor";
  case 0x0320: return "RtlSetProcessIsCritical";
  case 0x0321: return "RtlSetSaclSecurityDescriptor";
  case 0x0322: return "RtlSetSecurityDescriptorRMControl";
  case 0x0323: return "RtlSetSecurityObject";
  case 0x0324: return "RtlSetSecurityObjectEx";
  case 0x0325: return "RtlSetThreadIsCritical";
  case 0x0326: return "RtlSetThreadPoolStartFunc";
  case 0x0327: return "RtlSetTimeZoneInformation";
  case 0x0328: return "RtlSetTimer";
  case 0x0329: return "RtlSetUnicodeCallouts";
  case 0x032a: return "RtlSetUserFlagsHeap";
  case 0x032b: return "RtlSetUserValueHeap";
  case 0x032c: return "RtlSizeHeap";
  case 0x032d: return "RtlSplay";
  case 0x032e: return "RtlStartRXact";
  case 0x032f: return "RtlStatMemoryStream";
  case 0x0330: return "RtlStringFromGUID";
  case 0x0331: return "RtlSubAuthorityCountSid";
  case 0x0332: return "RtlSubAuthoritySid";
  case 0x0333: return "RtlSubtreePredecessor";
  case 0x0334: return "RtlSubtreeSuccessor";
  case 0x0335: return "RtlSystemTimeToLocalTime";
  case 0x0336: return "RtlTimeFieldsToTime";
  case 0x0337: return "RtlTimeToElapsedTimeFields";
  case 0x0338: return "RtlTimeToSecondsSince1970";
  case 0x0339: return "RtlTimeToSecondsSince1980";
  case 0x033a: return "RtlTimeToTimeFields";
  case 0x033b: return "RtlTraceDatabaseAdd";
  case 0x033c: return "RtlTraceDatabaseCreate";
  case 0x033d: return "RtlTraceDatabaseDestroy";
  case 0x033e: return "RtlTraceDatabaseEnumerate";
  case 0x033f: return "RtlTraceDatabaseFind";
  case 0x0340: return "RtlTraceDatabaseLock";
  case 0x0341: return "RtlTraceDatabaseUnlock";
  case 0x0342: return "RtlTraceDatabaseValidate";
  case 0x0343: return "RtlTryEnterCriticalSection";
  case 0x0005: return "RtlUlongByteSwap";
  case 0x0006: return "RtlUlonglongByteSwap";
  case 0x0345: return "RtlUnhandledExceptionFilter";
  case 0x0344: return "RtlUnhandledExceptionFilter2";
  case 0x0346: return "RtlUnicodeStringToAnsiSize";
  case 0x0347: return "RtlUnicodeStringToAnsiString";
  case 0x0348: return "RtlUnicodeStringToCountedOemString";
  case 0x0349: return "RtlUnicodeStringToInteger";
  case 0x034a: return "RtlUnicodeStringToOemSize";
  case 0x034b: return "RtlUnicodeStringToOemString";
  case 0x034c: return "RtlUnicodeToCustomCPN";
  case 0x034d: return "RtlUnicodeToMultiByteN";
  case 0x034e: return "RtlUnicodeToMultiByteSize";
  case 0x034f: return "RtlUnicodeToOemN";
  case 0x0350: return "RtlUniform";
  case 0x0351: return "RtlUnlockBootStatusData";
  case 0x0352: return "RtlUnlockHeap";
  case 0x0353: return "RtlUnlockMemoryStreamRegion";
  case 0x0354: return "RtlUnwind";
  case 0x0355: return "RtlUpcaseUnicodeChar";
  case 0x0356: return "RtlUpcaseUnicodeString";
  case 0x0357: return "RtlUpcaseUnicodeStringToAnsiString";
  case 0x0358: return "RtlUpcaseUnicodeStringToCountedOemString";
  case 0x0359: return "RtlUpcaseUnicodeStringToOemString";
  case 0x035a: return "RtlUpcaseUnicodeToCustomCPN";
  case 0x035b: return "RtlUpcaseUnicodeToMultiByteN";
  case 0x035c: return "RtlUpcaseUnicodeToOemN";
  case 0x035d: return "RtlUpdateTimer";
  case 0x035e: return "RtlUpperChar";
  case 0x035f: return "RtlUpperString";
  case 0x0360: return "RtlUsageHeap";
  case 0x0007: return "RtlUshortByteSwap";
  case 0x0361: return "RtlValidAcl";
  case 0x0362: return "RtlValidRelativeSecurityDescriptor";
  case 0x0363: return "RtlValidSecurityDescriptor";
  case 0x0364: return "RtlValidSid";
  case 0x0365: return "RtlValidateHeap";
  case 0x0366: return "RtlValidateProcessHeaps";
  case 0x0367: return "RtlValidateUnicodeString";
  case 0x0368: return "RtlVerifyVersionInfo";
  case 0x0369: return "RtlWalkFrameChain";
  case 0x036a: return "RtlWalkHeap";
  case 0x036b: return "RtlWriteMemoryStream";
  case 0x036c: return "RtlWriteRegistryValue";
  case 0x036d: return "RtlZeroHeap";
  case 0x036e: return "RtlZeroMemory";
  case 0x036f: return "RtlZombifyActivationContext";
  case 0x0370: return "RtlpApplyLengthFunction";
  case 0x0371: return "RtlpEnsureBufferSize";
  case 0x0372: return "RtlpNotOwnerCriticalSection";
  case 0x0373: return "RtlpNtCreateKey";
  case 0x0374: return "RtlpNtEnumerateSubKey";
  case 0x0375: return "RtlpNtMakeTemporaryKey";
  case 0x0376: return "RtlpNtOpenKey";
  case 0x0377: return "RtlpNtQueryValueKey";
  case 0x0378: return "RtlpNtSetValueKey";
  case 0x0379: return "RtlpUnWaitCriticalSection";
  case 0x037a: return "RtlpWaitForCriticalSection";
  case 0x037b: return "RtlxAnsiStringToUnicodeSize";
  case 0x037c: return "RtlxOemStringToUnicodeSize";
  case 0x037d: return "RtlxUnicodeStringToAnsiSize";
  case 0x037e: return "RtlxUnicodeStringToOemSize";
  case 0x037f: return "VerSetConditionMask";
  case 0x0380: return "ZwAcceptConnectPort";
  case 0x0381: return "ZwAccessCheck";
  case 0x0382: return "ZwAccessCheckAndAuditAlarm";
  case 0x0383: return "ZwAccessCheckByType";
  case 0x0384: return "ZwAccessCheckByTypeAndAuditAlarm";
  case 0x0385: return "ZwAccessCheckByTypeResultList";
  case 0x0386: return "ZwAccessCheckByTypeResultListAndAuditAlarm";
  case 0x0387: return "ZwAccessCheckByTypeResultListAndAuditAlarmByHandle";
  case 0x0388: return "ZwAddAtom";
  case 0x0389: return "ZwAddBootEntry";
  case 0x038a: return "ZwAdjustGroupsToken";
  case 0x038b: return "ZwAdjustPrivilegesToken";
  case 0x038c: return "ZwAlertResumeThread";
  case 0x038d: return "ZwAlertThread";
  case 0x038e: return "ZwAllocateLocallyUniqueId";
  case 0x038f: return "ZwAllocateUserPhysicalPages";
  case 0x0390: return "ZwAllocateUuids";
  case 0x0391: return "ZwAllocateVirtualMemory";
  case 0x0392: return "ZwAreMappedFilesTheSame";
  case 0x0393: return "ZwAssignProcessToJobObject";
  case 0x0394: return "ZwCallbackReturn";
  case 0x0395: return "ZwCancelDeviceWakeupRequest";
  case 0x0396: return "ZwCancelIoFile";
  case 0x0397: return "ZwCancelTimer";
  case 0x0398: return "ZwClearEvent";
  case 0x0399: return "ZwClose";
  case 0x039a: return "ZwCloseObjectAuditAlarm";
  case 0x039b: return "ZwCompactKeys";
  case 0x039c: return "ZwCompareTokens";
  case 0x039d: return "ZwCompleteConnectPort";
  case 0x039e: return "ZwCompressKey";
  case 0x039f: return "ZwConnectPort";
  case 0x03a0: return "ZwContinue";
  case 0x03a1: return "ZwCreateDebugObject";
  case 0x03a2: return "ZwCreateDirectoryObject";
  case 0x03a3: return "ZwCreateEvent";
  case 0x03a4: return "ZwCreateEventPair";
  case 0x03a5: return "ZwCreateFile";
  case 0x03a6: return "ZwCreateIoCompletion";
  case 0x03a7: return "ZwCreateJobObject";
  case 0x03a8: return "ZwCreateJobSet";
  case 0x03a9: return "ZwCreateKey";
  case 0x03aa: return "ZwCreateKeyedEvent";
  case 0x03ab: return "ZwCreateMailslotFile";
  case 0x03ac: return "ZwCreateMutant";
  case 0x03ad: return "ZwCreateNamedPipeFile";
  case 0x03ae: return "ZwCreatePagingFile";
  case 0x03af: return "ZwCreatePort";
  case 0x03b0: return "ZwCreateProcess";
  case 0x03b1: return "ZwCreateProcessEx";
  case 0x03b2: return "ZwCreateProfile";
  case 0x03b3: return "ZwCreateSection";
  case 0x03b4: return "ZwCreateSemaphore";
  case 0x03b5: return "ZwCreateSymbolicLinkObject";
  case 0x03b6: return "ZwCreateThread";
  case 0x03b7: return "ZwCreateTimer";
  case 0x03b8: return "ZwCreateToken";
  case 0x03b9: return "ZwCreateWaitablePort";
  case 0x03ba: return "ZwDebugActiveProcess";
  case 0x03bb: return "ZwDebugContinue";
  case 0x03bc: return "ZwDelayExecution";
  case 0x03bd: return "ZwDeleteAtom";
  case 0x03be: return "ZwDeleteBootEntry";
  case 0x03bf: return "ZwDeleteFile";
  case 0x03c0: return "ZwDeleteKey";
  case 0x03c1: return "ZwDeleteObjectAuditAlarm";
  case 0x03c2: return "ZwDeleteValueKey";
  case 0x03c3: return "ZwDeviceIoControlFile";
  case 0x03c4: return "ZwDisplayString";
  case 0x03c5: return "ZwDuplicateObject";
  case 0x03c6: return "ZwDuplicateToken";
  case 0x03c7: return "ZwEnumerateBootEntries";
  case 0x03c8: return "ZwEnumerateKey";
  case 0x03c9: return "ZwEnumerateSystemEnvironmentValuesEx";
  case 0x03ca: return "ZwEnumerateValueKey";
  case 0x03cb: return "ZwExtendSection";
  case 0x03cc: return "ZwFilterToken";
  case 0x03cd: return "ZwFindAtom";
  case 0x03ce: return "ZwFlushBuffersFile";
  case 0x03cf: return "ZwFlushInstructionCache";
  case 0x03d0: return "ZwFlushKey";
  case 0x03d1: return "ZwFlushVirtualMemory";
  case 0x03d2: return "ZwFlushWriteBuffer";
  case 0x03d3: return "ZwFreeUserPhysicalPages";
  case 0x03d4: return "ZwFreeVirtualMemory";
  case 0x03d5: return "ZwFsControlFile";
  case 0x03d6: return "ZwGetContextThread";
  case 0x03d7: return "ZwGetDevicePowerState";
  case 0x03d8: return "ZwGetPlugPlayEvent";
  case 0x03d9: return "ZwGetWriteWatch";
  case 0x03da: return "ZwImpersonateAnonymousToken";
  case 0x03db: return "ZwImpersonateClientOfPort";
  case 0x03dc: return "ZwImpersonateThread";
  case 0x03dd: return "ZwInitializeRegistry";
  case 0x03de: return "ZwInitiatePowerAction";
  case 0x03df: return "ZwIsProcessInJob";
  case 0x03e0: return "ZwIsSystemResumeAutomatic";
  case 0x03e1: return "ZwListenPort";
  case 0x03e2: return "ZwLoadDriver";
  case 0x03e4: return "ZwLoadKey";
  case 0x03e3: return "ZwLoadKey2";
  case 0x03e5: return "ZwLockFile";
  case 0x03e6: return "ZwLockProductActivationKeys";
  case 0x03e7: return "ZwLockRegistryKey";
  case 0x03e8: return "ZwLockVirtualMemory";
  case 0x03e9: return "ZwMakePermanentObject";
  case 0x03ea: return "ZwMakeTemporaryObject";
  case 0x03eb: return "ZwMapUserPhysicalPages";
  case 0x03ec: return "ZwMapUserPhysicalPagesScatter";
  case 0x03ed: return "ZwMapViewOfSection";
  case 0x03ee: return "ZwModifyBootEntry";
  case 0x03ef: return "ZwNotifyChangeDirectoryFile";
  case 0x03f0: return "ZwNotifyChangeKey";
  case 0x03f1: return "ZwNotifyChangeMultipleKeys";
  case 0x03f2: return "ZwOpenDirectoryObject";
  case 0x03f3: return "ZwOpenEvent";
  case 0x03f4: return "ZwOpenEventPair";
  case 0x03f5: return "ZwOpenFile";
  case 0x03f6: return "ZwOpenIoCompletion";
  case 0x03f7: return "ZwOpenJobObject";
  case 0x03f8: return "ZwOpenKey";
  case 0x03f9: return "ZwOpenKeyedEvent";
  case 0x03fa: return "ZwOpenMutant";
  case 0x03fb: return "ZwOpenObjectAuditAlarm";
  case 0x03fc: return "ZwOpenProcess";
  case 0x03fd: return "ZwOpenProcessToken";
  case 0x03fe: return "ZwOpenProcessTokenEx";
  case 0x03ff: return "ZwOpenSection";
  case 0x0400: return "ZwOpenSemaphore";
  case 0x0401: return "ZwOpenSymbolicLinkObject";
  case 0x0402: return "ZwOpenThread";
  case 0x0403: return "ZwOpenThreadToken";
  case 0x0404: return "ZwOpenThreadTokenEx";
  case 0x0405: return "ZwOpenTimer";
  case 0x0406: return "ZwPlugPlayControl";
  case 0x0407: return "ZwPowerInformation";
  case 0x0408: return "ZwPrivilegeCheck";
  case 0x0409: return "ZwPrivilegeObjectAuditAlarm";
  case 0x040a: return "ZwPrivilegedServiceAuditAlarm";
  case 0x040b: return "ZwProtectVirtualMemory";
  case 0x040c: return "ZwPulseEvent";
  case 0x040d: return "ZwQueryAttributesFile";
  case 0x040e: return "ZwQueryBootEntryOrder";
  case 0x040f: return "ZwQueryBootOptions";
  case 0x0410: return "ZwQueryDebugFilterState";
  case 0x0411: return "ZwQueryDefaultLocale";
  case 0x0412: return "ZwQueryDefaultUILanguage";
  case 0x0413: return "ZwQueryDirectoryFile";
  case 0x0414: return "ZwQueryDirectoryObject";
  case 0x0415: return "ZwQueryEaFile";
  case 0x0416: return "ZwQueryEvent";
  case 0x0417: return "ZwQueryFullAttributesFile";
  case 0x0418: return "ZwQueryInformationAtom";
  case 0x0419: return "ZwQueryInformationFile";
  case 0x041a: return "ZwQueryInformationJobObject";
  case 0x041b: return "ZwQueryInformationPort";
  case 0x041c: return "ZwQueryInformationProcess";
  case 0x041d: return "ZwQueryInformationThread";
  case 0x041e: return "ZwQueryInformationToken";
  case 0x041f: return "ZwQueryInstallUILanguage";
  case 0x0420: return "ZwQueryIntervalProfile";
  case 0x0421: return "ZwQueryIoCompletion";
  case 0x0422: return "ZwQueryKey";
  case 0x0423: return "ZwQueryMultipleValueKey";
  case 0x0424: return "ZwQueryMutant";
  case 0x0425: return "ZwQueryObject";
  case 0x0426: return "ZwQueryOpenSubKeys";
  case 0x0427: return "ZwQueryPerformanceCounter";
  case 0x0428: return "ZwQueryPortInformationProcess";
  case 0x0429: return "ZwQueryQuotaInformationFile";
  case 0x042a: return "ZwQuerySection";
  case 0x042b: return "ZwQuerySecurityObject";
  case 0x042c: return "ZwQuerySemaphore";
  case 0x042d: return "ZwQuerySymbolicLinkObject";
  case 0x042e: return "ZwQuerySystemEnvironmentValue";
  case 0x042f: return "ZwQuerySystemEnvironmentValueEx";
  case 0x0430: return "ZwQuerySystemInformation";
  case 0x0431: return "ZwQuerySystemTime";
  case 0x0432: return "ZwQueryTimer";
  case 0x0433: return "ZwQueryTimerResolution";
  case 0x0434: return "ZwQueryValueKey";
  case 0x0435: return "ZwQueryVirtualMemory";
  case 0x0436: return "ZwQueryVolumeInformationFile";
  case 0x0437: return "ZwQueueApcThread";
  case 0x0438: return "ZwRaiseException";
  case 0x0439: return "ZwRaiseHardError";
  case 0x043a: return "ZwReadFile";
  case 0x043b: return "ZwReadFileScatter";
  case 0x043c: return "ZwReadRequestData";
  case 0x043d: return "ZwReadVirtualMemory";
  case 0x043e: return "ZwRegisterThreadTerminatePort";
  case 0x043f: return "ZwReleaseKeyedEvent";
  case 0x0440: return "ZwReleaseMutant";
  case 0x0441: return "ZwReleaseSemaphore";
  case 0x0442: return "ZwRemoveIoCompletion";
  case 0x0443: return "ZwRemoveProcessDebug";
  case 0x0444: return "ZwRenameKey";
  case 0x0445: return "ZwReplaceKey";
  case 0x0446: return "ZwReplyPort";
  case 0x0447: return "ZwReplyWaitReceivePort";
  case 0x0448: return "ZwReplyWaitReceivePortEx";
  case 0x0449: return "ZwReplyWaitReplyPort";
  case 0x044a: return "ZwRequestDeviceWakeup";
  case 0x044b: return "ZwRequestPort";
  case 0x044c: return "ZwRequestWaitReplyPort";
  case 0x044d: return "ZwRequestWakeupLatency";
  case 0x044e: return "ZwResetEvent";
  case 0x044f: return "ZwResetWriteWatch";
  case 0x0450: return "ZwRestoreKey";
  case 0x0451: return "ZwResumeProcess";
  case 0x0452: return "ZwResumeThread";
  case 0x0453: return "ZwSaveKey";
  case 0x0454: return "ZwSaveKeyEx";
  case 0x0455: return "ZwSaveMergedKeys";
  case 0x0456: return "ZwSecureConnectPort";
  case 0x0457: return "ZwSetBootEntryOrder";
  case 0x0458: return "ZwSetBootOptions";
  case 0x0459: return "ZwSetContextThread";
  case 0x045a: return "ZwSetDebugFilterState";
  case 0x045b: return "ZwSetDefaultHardErrorPort";
  case 0x045c: return "ZwSetDefaultLocale";
  case 0x045d: return "ZwSetDefaultUILanguage";
  case 0x045e: return "ZwSetEaFile";
  case 0x045f: return "ZwSetEvent";
  case 0x0460: return "ZwSetEventBoostPriority";
  case 0x0461: return "ZwSetHighEventPair";
  case 0x0462: return "ZwSetHighWaitLowEventPair";
  case 0x0463: return "ZwSetInformationDebugObject";
  case 0x0464: return "ZwSetInformationFile";
  case 0x0465: return "ZwSetInformationJobObject";
  case 0x0466: return "ZwSetInformationKey";
  case 0x0467: return "ZwSetInformationObject";
  case 0x0468: return "ZwSetInformationProcess";
  case 0x0469: return "ZwSetInformationThread";
  case 0x046a: return "ZwSetInformationToken";
  case 0x046b: return "ZwSetIntervalProfile";
  case 0x046c: return "ZwSetIoCompletion";
  case 0x046d: return "ZwSetLdtEntries";
  case 0x046e: return "ZwSetLowEventPair";
  case 0x046f: return "ZwSetLowWaitHighEventPair";
  case 0x0470: return "ZwSetQuotaInformationFile";
  case 0x0471: return "ZwSetSecurityObject";
  case 0x0472: return "ZwSetSystemEnvironmentValue";
  case 0x0473: return "ZwSetSystemEnvironmentValueEx";
  case 0x0474: return "ZwSetSystemInformation";
  case 0x0475: return "ZwSetSystemPowerState";
  case 0x0476: return "ZwSetSystemTime";
  case 0x0477: return "ZwSetThreadExecutionState";
  case 0x0478: return "ZwSetTimer";
  case 0x0479: return "ZwSetTimerResolution";
  case 0x047a: return "ZwSetUuidSeed";
  case 0x047b: return "ZwSetValueKey";
  case 0x047c: return "ZwSetVolumeInformationFile";
  case 0x047d: return "ZwShutdownSystem";
  case 0x047e: return "ZwSignalAndWaitForSingleObject";
  case 0x047f: return "ZwStartProfile";
  case 0x0480: return "ZwStopProfile";
  case 0x0481: return "ZwSuspendProcess";
  case 0x0482: return "ZwSuspendThread";
  case 0x0483: return "ZwSystemDebugControl";
  case 0x0484: return "ZwTerminateJobObject";
  case 0x0485: return "ZwTerminateProcess";
  case 0x0486: return "ZwTerminateThread";
  case 0x0487: return "ZwTestAlert";
  case 0x0488: return "ZwTraceEvent";
  case 0x0489: return "ZwTranslateFilePath";
  case 0x048a: return "ZwUnloadDriver";
  case 0x048b: return "ZwUnloadKey";
  case 0x048c: return "ZwUnloadKeyEx";
  case 0x048d: return "ZwUnlockFile";
  case 0x048e: return "ZwUnlockVirtualMemory";
  case 0x048f: return "ZwUnmapViewOfSection";
  case 0x0490: return "ZwVdmControl";
  case 0x0491: return "ZwWaitForDebugEvent";
  case 0x0492: return "ZwWaitForKeyedEvent";
  case 0x0493: return "ZwWaitForMultipleObjects";
  case 0x0494: return "ZwWaitForSingleObject";
  case 0x0495: return "ZwWaitHighEventPair";
  case 0x0496: return "ZwWaitLowEventPair";
  case 0x0497: return "ZwWriteFile";
  case 0x0498: return "ZwWriteFileGather";
  case 0x0499: return "ZwWriteRequestData";
  case 0x049a: return "ZwWriteVirtualMemory";
  case 0x049b: return "ZwYieldExecution";
  case 0x049c: return "_CIcos";
  case 0x049d: return "_CIlog";
  case 0x049e: return "_CIpow";
  case 0x049f: return "_CIsin";
  case 0x04a0: return "_CIsqrt";
  case 0x04a1: return "__isascii";
  case 0x04a2: return "__iscsym";
  case 0x04a3: return "__iscsymf";
  case 0x04a4: return "__toascii";
  case 0x04a5: return "_alldiv";
  case 0x04a6: return "_alldvrm";
  case 0x04a7: return "_allmul";
  case 0x04a8: return "_alloca_probe";
  case 0x04a9: return "_allrem";
  case 0x04aa: return "_allshl";
  case 0x04ab: return "_allshr";
  case 0x04ac: return "_atoi64";
  case 0x04ad: return "_aulldiv";
  case 0x04ae: return "_aulldvrm";
  case 0x04af: return "_aullrem";
  case 0x04b0: return "_aullshr";
  case 0x04b1: return "_chkstk";
  case 0x04b2: return "_fltused";
  case 0x04b3: return "_ftol";
  case 0x04b4: return "_i64toa";
  case 0x04b5: return "_i64tow";
  case 0x04b6: return "_itoa";
  case 0x04b7: return "_itow";
  case 0x04b8: return "_lfind";
  case 0x04b9: return "_ltoa";
  case 0x04ba: return "_ltow";
  case 0x04bb: return "_memccpy";
  case 0x04bc: return "_memicmp";
  case 0x04bd: return "_snprintf";
  case 0x04be: return "_snwprintf";
  case 0x04bf: return "_splitpath";
  case 0x04c0: return "_strcmpi";
  case 0x04c1: return "_stricmp";
  case 0x04c2: return "_strlwr";
  case 0x04c3: return "_strnicmp";
  case 0x04c4: return "_strupr";
  case 0x04c5: return "_tolower";
  case 0x04c6: return "_toupper";
  case 0x04c7: return "_ui64toa";
  case 0x04c8: return "_ui64tow";
  case 0x04c9: return "_ultoa";
  case 0x04ca: return "_ultow";
  case 0x04cb: return "_vsnprintf";
  case 0x04cc: return "_vsnwprintf";
  case 0x04cd: return "_wcsicmp";
  case 0x04ce: return "_wcslwr";
  case 0x04cf: return "_wcsnicmp";
  case 0x04d0: return "_wcsupr";
  case 0x04d1: return "_wtoi";
  case 0x04d2: return "_wtoi64";
  case 0x04d3: return "_wtol";
  case 0x04d4: return "abs";
  case 0x04d5: return "atan";
  case 0x04d6: return "atoi";
  case 0x04d7: return "atol";
  case 0x04d8: return "bsearch";
  case 0x04d9: return "ceil";
  case 0x04da: return "cos";
  case 0x04db: return "fabs";
  case 0x04dc: return "floor";
  case 0x04dd: return "isalnum";
  case 0x04de: return "isalpha";
  case 0x04df: return "iscntrl";
  case 0x04e0: return "isdigit";
  case 0x04e1: return "isgraph";
  case 0x04e2: return "islower";
  case 0x04e3: return "isprint";
  case 0x04e4: return "ispunct";
  case 0x04e5: return "isspace";
  case 0x04e6: return "isupper";
  case 0x04e7: return "iswalpha";
  case 0x04e8: return "iswctype";
  case 0x04e9: return "iswdigit";
  case 0x04ea: return "iswlower";
  case 0x04eb: return "iswspace";
  case 0x04ec: return "iswxdigit";
  case 0x04ed: return "isxdigit";
  case 0x04ee: return "labs";
  case 0x04ef: return "log";
  case 0x04f0: return "mbstowcs";
  case 0x04f1: return "memchr";
  case 0x04f2: return "memcmp";
  case 0x04f3: return "memcpy";
  case 0x04f4: return "memmove";
  case 0x04f5: return "memset";
  case 0x04f6: return "pow";
  case 0x04f7: return "qsort";
  case 0x04f8: return "sin";
  case 0x04f9: return "sprintf";
  case 0x04fa: return "sqrt";
  case 0x04fb: return "sscanf";
  case 0x04fc: return "strcat";
  case 0x04fd: return "strchr";
  case 0x04fe: return "strcmp";
  case 0x04ff: return "strcpy";
  case 0x0500: return "strcspn";
  case 0x0501: return "strlen";
  case 0x0502: return "strncat";
  case 0x0503: return "strncmp";
  case 0x0504: return "strncpy";
  case 0x0505: return "strpbrk";
  case 0x0506: return "strrchr";
  case 0x0507: return "strspn";
  case 0x0508: return "strstr";
  case 0x0509: return "strtol";
  case 0x050a: return "strtoul";
  case 0x050b: return "swprintf";
  case 0x050c: return "tan";
  case 0x050d: return "tolower";
  case 0x050e: return "toupper";
  case 0x050f: return "towlower";
  case 0x0510: return "towupper";
  case 0x0511: return "vDbgPrintEx";
  case 0x0512: return "vDbgPrintExWithPrefix";
  case 0x0513: return "vsprintf";
  case 0x0514: return "wcscat";
  case 0x0515: return "wcschr";
  case 0x0516: return "wcscmp";
  case 0x0517: return "wcscpy";
  case 0x0518: return "wcscspn";
  case 0x0519: return "wcslen";
  case 0x051a: return "wcsncat";
  case 0x051b: return "wcsncmp";
  case 0x051c: return "wcsncpy";
  case 0x051d: return "wcspbrk";
  case 0x051e: return "wcsrchr";
  case 0x051f: return "wcsspn";
  case 0x0520: return "wcsstr";
  case 0x0521: return "wcstol";
  case 0x0522: return "wcstombs";
  case 0x0523: return "wcstoul";
  }
  return nullptr;
}


}
}

#endif

