#!/usr/bin/python3
from __future__ import annotations

import calendar
import configparser
import copy
import ctypes
import datetime
import inspect
import itertools
import json
import os
import platform
import pprint
import pydoc
import random
import socket
import subprocess
import sys
import textwrap
import threading
import time
import tkinter as tk
import tkinter.font
import traceback
import urllib.error
import urllib.parse
import warnings
from functools import wraps
from math import fabs
from tkinter import filedialog  # noqa
from tkinter import ttk
from tkinter.colorchooser import askcolor  # noqa
from typing import Any  # noqa
from typing import Dict  # noqa
from typing import List  # noqa
from typing import Tuple  # noqa


# get the tkinter detailed version
tclversion_detailed = tkinter.Tcl().eval('info patchlevel')
framework_version = tclversion_detailed

version = __version__ = '5.1.0'

_change_log = ''


# The shortened version of version
try:
    ver = version.split(' ')[0]
except:
    ver = ''

# __version__ = version
try:
    import webbrowser

    webbrowser_available = True
except:
    webbrowser_available = False


port = 'FreeSimpleGUI'
name = 'FreeSimpleGui'


warnings.simplefilter('always', UserWarning)

g_time_start = 0
g_time_end = 0
g_time_delta = 0

# ----====----====----==== Constants the user CAN safely change ====----====----====----#

# Base64 encoded GIF file
DEFAULT_BASE64_ICON = b'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'

DEFAULT_BASE64_ICON_16_BY_16 = b'iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAKCSURBVDhPVZNbSFRRFIb35YwXItBIGtDsiqENEUTRjJlZkJggPSUYBD0UhULElE6hBY6ID/ZSpD1IDxaCEPhUaFLRQyWRNxIJe8syMxCjMCbB07fOsaMt+GftvWf//7/2Whyt1sTei/fCpDqQBTrGOi9Myrk7URwhnQUfQLeOvErJuUQgADlK6gObvAOl5sHx0doHljwARFRiCpxG5J1sjPxALiYNgn9kiQ3gafdYUYzseCd+FICX7sShw7LR++q6cl3XHaXQHFdOJLxFsJtvKHnbUr1nqp01hhStpXAzo7TZZXOjJ+9orT9pY74aY3ZobZZYW8D/GpjM19Ob088fmJxW2tkC4AJt17Oeg2MLrHX6jXWes16w1sbBkrFWBTB2nTLpv5VJg7wGNhRDwCS0tR1cbECkidwMQohAdoScqiz8/FCZUKlPCgSWlQ71elOI1fcco9hCXp1kS7dX3u+qVOm2L4nW8qE4Neetvl8v83NOb++9703BcUI/cU3imuWV7JedKtv5LdFaMRzHLW+N+zJoVDZzRLj6SFNfPlMYwy5bDiRcCojmz15tKx+6hKPv7LvjrG/Q2RoOwjSyzNDlahyzA2dAJeNtFcMHA2cfLn24STNr6P4I728jJ7hvf/lEGuaXLnkRAp0PyFK+hlyLSJGyGWnKyeBi2oJU0IPIjNd15uuL2f2PJgueQBKhVRETCgNeYU+xaeEpnWaw8cQPRM7g/McT8eF0De9u7P+49TqXF7no98BDEEkdvvXem8LAtfJniFRB/A5XeiAiG2+/icgHVQUW5d5KyAhl3M2y+U+ysv1FDukyKGQW3Y+vHJWvU7mz8RJSPZgDd3H2RqiUUn8BSQuaBvGjGpsAAAAASUVORK5CYII='

DEFAULT_BASE64_LOADING_GIF = b'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'

# Old debugger logo
# PSG_DEBUGGER_LOGO = b'R0lGODlhMgAtAPcAAAAAADD/2akK/4yz0pSxyZWyy5u3zZ24zpW30pG52J250J+60aC60KS90aDC3a3E163F2K3F2bPI2bvO3rzP3qvJ4LHN4rnR5P/zuf/zuv/0vP/0vsDS38XZ6cnb6f/xw//zwv/yxf/1w//zyP/1yf/2zP/3z//30wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAP8ALAAAAAAyAC0AAAj/AP8JHEiwoMGDCBMqXMiwoUOFAiJGXBigYoAPDxlK3CigwUGLIAOEyIiQI8cCBUOqJFnQpEkGA1XKZPlPgkuXBATK3JmRws2bB3TuXNmQw8+jQoeCbHj0qIGkSgNobNoUqlKIVJs++BfV4oiEWalaHVpyosCwJidw7Sr1YMQFBDn+y4qSbUW3AiDElXiWqoK1bPEKGLixr1jAXQ9GuGn4sN22Bl02roo4Kla+c8OOJbsQM9rNPJlORlr5asbPpTk/RP2YJGu7rjWnDm2RIQLZrSt3zgp6ZmqwmkHAng3ccWDEMe8Kpnw8JEHlkXnPdh6SxHPILaU/dp60LFUP07dfRq5aYntohAO0m+c+nvT6pVMPZ3jv8AJu8xktyNbw+ATJDtKFBx9NlA20gWU0DVQBYwZhsJMICRrkwEYJJGRCSBtEqGGCAQEAOw=='

PSG_DEBUGGER_LOGO = b'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'

UDEMY_ICON = b'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'

BLANK_BASE64 = b'iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsMAAA7DAcdvqGQAAAANSURBVBhXY2BgYGAAAAAFAAGKM+MAAAAAAElFTkSuQmCC'
BLANK_BASE64 = b'iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII='


DEFAULT_WINDOW_ICON = DEFAULT_BASE64_ICON

DEFAULT_ELEMENT_SIZE = (45, 1)  # In CHARACTERS
DEFAULT_BUTTON_ELEMENT_SIZE = (10, 1)  # In CHARACTERS
DEFAULT_MARGINS = (10, 5)  # Margins for each LEFT/RIGHT margin is first term
DEFAULT_ELEMENT_PADDING = (5, 3)  # Padding between elements (row, col) in pixels
DEFAULT_AUTOSIZE_TEXT = True
DEFAULT_AUTOSIZE_BUTTONS = True
DEFAULT_FONT = ('Helvetica', 10)
DEFAULT_TEXT_JUSTIFICATION = 'left'
DEFAULT_BORDER_WIDTH = 1
DEFAULT_AUTOCLOSE_TIME = 3  # time in seconds to show an autoclose form
DEFAULT_DEBUG_WINDOW_SIZE = (80, 20)
DEFAULT_WINDOW_LOCATION = (None, None)
MAX_SCROLLED_TEXT_BOX_HEIGHT = 50
DEFAULT_TOOLTIP_TIME = 400
DEFAULT_TOOLTIP_OFFSET = (0, -20)
DEFAULT_KEEP_ON_TOP = None
DEFAULT_SCALING = None
DEFAULT_ALPHA_CHANNEL = 1.0
DEFAULT_HIDE_WINDOW_WHEN_CREATING = True
TOOLTIP_BACKGROUND_COLOR = '#ffffe0'
TOOLTIP_FONT = None
DEFAULT_USE_BUTTON_SHORTCUTS = False
#################### COLOR STUFF ####################
BLUES = ('#082567', '#0A37A3', '#00345B')
PURPLES = ('#480656', '#4F2398', '#380474')
GREENS = ('#01826B', '#40A860', '#96D2AB', '#00A949', '#003532')
YELLOWS = ('#F3FB62', '#F0F595')
TANS = ('#FFF9D5', '#F4EFCF', '#DDD8BA')
NICE_BUTTON_COLORS = (
    (GREENS[3], TANS[0]),
    ('#000000', '#FFFFFF'),
    ('#FFFFFF', '#000000'),
    (YELLOWS[0], PURPLES[1]),
    (YELLOWS[0], GREENS[3]),
    (YELLOWS[0], BLUES[2]),
)

COLOR_SYSTEM_DEFAULT = '1234567890'  # A Magic Number kind of signal to PySimpleGUI that the color should not be set at all
DEFAULT_BUTTON_COLOR = ('white', BLUES[0])  # Foreground, Background (None, None) == System Default
OFFICIAL_PYSIMPLEGUI_BUTTON_COLOR = ('white', BLUES[0])

# The "default PySimpleGUI theme"
OFFICIAL_PYSIMPLEGUI_THEME = CURRENT_LOOK_AND_FEEL = 'Dark Blue 3'

DEFAULT_ERROR_BUTTON_COLOR = ('#FFFFFF', '#FF0000')
DEFAULT_BACKGROUND_COLOR = None
DEFAULT_ELEMENT_BACKGROUND_COLOR = None
DEFAULT_ELEMENT_TEXT_COLOR = COLOR_SYSTEM_DEFAULT
DEFAULT_TEXT_ELEMENT_BACKGROUND_COLOR = None
DEFAULT_TEXT_COLOR = COLOR_SYSTEM_DEFAULT
DEFAULT_INPUT_ELEMENTS_COLOR = COLOR_SYSTEM_DEFAULT
DEFAULT_INPUT_TEXT_COLOR = COLOR_SYSTEM_DEFAULT
DEFAULT_SCROLLBAR_COLOR = None

SYSTEM_TRAY_WIN_MARGINS = 160, 60  # from right edge of screen, from bottom of screen
SYSTEM_TRAY_MESSAGE_MAX_LINE_LENGTH = 50
SYSTEM_TRAY_MESSAGE_WIN_COLOR = '#282828'
SYSTEM_TRAY_MESSAGE_TEXT_COLOR = '#ffffff'
SYSTEM_TRAY_MESSAGE_DISPLAY_DURATION_IN_MILLISECONDS = 3000  # how long to display the window
SYSTEM_TRAY_MESSAGE_FADE_IN_DURATION = 1000  # how long to fade in / fade out the window
EVENT_SYSTEM_TRAY_ICON_DOUBLE_CLICKED = '__DOUBLE_CLICKED__'
EVENT_SYSTEM_TRAY_ICON_ACTIVATED = '__ACTIVATED__'
EVENT_SYSTEM_TRAY_MESSAGE_CLICKED = '__MESSAGE_CLICKED__'
_tray_icon_error = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAADlAAAA5QGP5Zs8AAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAIpQTFRF////20lt30Bg30pg4FJc409g4FBe4E9f4U9f4U9g4U9f4E9g31Bf4E9f4E9f4E9f4E9f4E9f4FFh4Vdm4lhn42Bv5GNx5W575nJ/6HqH6HyI6YCM6YGM6YGN6oaR8Kev9MPI9cbM9snO9s3R+Nfb+dzg+d/i++vt/O7v/fb3/vj5//z8//7+////KofnuQAAABF0Uk5TAAcIGBktSYSXmMHI2uPy8/XVqDFbAAAA8UlEQVQ4y4VT15LCMBBTQkgPYem9d9D//x4P2I7vILN68kj2WtsAhyDO8rKuyzyLA3wjSnvi0Eujf3KY9OUP+kno651CvlB0Gr1byQ9UXff+py5SmRhhIS0oPj4SaUUCAJHxP9+tLb/ezU0uEYDUsCc+l5/T8smTIVMgsPXZkvepiMj0Tm5txQLENu7gSF7HIuMreRxYNkbmHI0u5Hk4PJOXkSMz5I3nyY08HMjbpOFylF5WswdJPmYeVaL28968yNfGZ2r9gvqFalJNUy2UWmq1Wa7di/3Kxl3tF1671YHRR04dWn3s9cXRV09f3vb1fwPD7z9j1WgeRgAAAABJRU5ErkJggg=='
_tray_icon_success = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAAA3NCSVQICAjb4U/gAAAACXBIWXMAAAEKAAABCgEWpLzLAAAAGXRFWHRTb2Z0d2FyZQB3d3cuaW5rc2NhcGUub3Jnm+48GgAAAHJQTFRF////ZsxmbbZJYL9gZrtVar9VZsJcbMRYaMZVasFYaL9XbMFbasRZaMFZacRXa8NYasFaasJaasFZasJaasNZasNYasJYasJZasJZasJZasJZasJZasJYasJZasJZasJZasJZasJaasJZasJZasJZasJZ2IAizQAAACV0Uk5TAAUHCA8YGRobHSwtPEJJUVtghJeYrbDByNjZ2tvj6vLz9fb3/CyrN0oAAADnSURBVDjLjZPbWoUgFIQnbNPBIgNKiwwo5v1fsQvMvUXI5oqPf4DFOgCrhLKjC8GNVgnsJY3nKm9kgTsduVHU3SU/TdxpOp15P7OiuV/PVzk5L3d0ExuachyaTWkAkLFtiBKAqZHPh/yuAYSv8R7XE0l6AVXnwBNJUsE2+GMOzWL8k3OEW7a/q5wOIS9e7t5qnGExvF5Bvlc4w/LEM4Abt+d0S5BpAHD7seMcf7+ZHfclp10TlYZc2y2nOqc6OwruxUWx0rDjNJtyp6HkUW4bJn0VWdf/a7nDpj1u++PBOR694+Ftj/8PKNdnDLn/V8YAAAAASUVORK5CYII='
_tray_icon_halt = b'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'
_tray_icon_notallowed = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAMAUExURQAAAPcICPcLC/cMDPcQEPcSEvcXF/cYGPcaGvcbG/ccHPgxMfgyMvg0NPg5Ofg6Ovg7O/hBQfhCQvlFRflGRvljY/pkZPplZfpnZ/p2dgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMgEwNYAAAEAdFJOU////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////wBT9wclAAAACXBIWXMAAA7DAAAOwwHHb6hkAAABE0lEQVQ4T4WT65bDIAiExWbbtN0m3Uua+P4P6g4jGtN4NvNL4DuCCC5WWobe++uwmEmtwNxJUTebcwWCt5jJBwsYcKf3NE4hTOOJxj1FEnBTz4NH6qH2jUcCGr/QLLpkQgHe/6VWJXVqFgBB4yI/KVCkBCoFgPrPHw0CWbwCL8RibBFwzQDQH62/QeAtHQBeADUIDbkF/UnmnkB1ixtERrN3xCgyuF5kMntHTCJXh2vyv+wIdMhvgTeCQJ0C2hBMgSKfZlM1wSLXZ5oqgs8sjSpaCQ2VVlfKhLU6fdZGSvyWz9JMb+NE4jt/Nwfm0yJZSkBpYDg7TcJGrjm0Z7jK0B6P/fHiHK8e9Pp/eSmuf1+vf4x/ralnCN9IrncAAAAASUVORK5CYII='
_tray_icon_stop = b'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'
_tray_icon_exclamation = b'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAMAUExURQAAAN0zM900NN01Nd02Nt03N944ON45Od46Ot47O98/P99BQd9CQt9DQ+FPT+JSUuJTU+JUVOJVVeJWVuNbW+ReXuVjY+Zra+dxceh4eOl7e+l8fOl+ful/f+qBgeqCguqDg+qFheuJieuLi+yPj+yQkO2Wlu+cnO+hofGqqvGtrfre3vrf3/ri4vvn5/75+f76+v/+/v///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMQ8SQkAAAEAdFJOU////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////wBT9wclAAAACXBIWXMAAA7DAAAOwwHHb6hkAAABJElEQVQ4T4WS63KCMBBGsyBai62X0otY0aq90ZZa3v/dtpvsJwTijOfXt7tnILOJYY9tNonjNCtQOlqhuKKG0RrNVjgkmIHBHgMId+h7zHSiwg2a9FNVVYScupETmjkd67o+CWpYwft+R6CpCgeUlq5AOyf45+8JsRUKFI6eQLkI3n5CIREBUekLxGaLpATCymRISiAszARJCYSxiZGUQKDLQoqgnPnFhUPOTWeRoZD3FvVZlmVHkE2OEM9iV71GVoZDBGUpAg9QWN5/jx+Ilsi9hz0q4VHOWD+hEF70yc1QEr1a4Q0F0S3eJDfLuv8T4QEFXduZE1rj+et7g6hzCDxF08N+X4DAu+6lUSTnc5wE5tx73ckSTV8QVoux3N88Rykw/wP3i+vwPKk17AAAAABJRU5ErkJggg=='
_tray_icon_none = None
SYSTEM_TRAY_MESSAGE_ICON_INFORMATION = _tray_icon_success
SYSTEM_TRAY_MESSAGE_ICON_WARNING = _tray_icon_exclamation
SYSTEM_TRAY_MESSAGE_ICON_CRITICAL = _tray_icon_stop
SYSTEM_TRAY_MESSAGE_ICON_NOICON = _tray_icon_none


RELIEF_RAISED = 'raised'
RELIEF_SUNKEN = 'sunken'
RELIEF_FLAT = 'flat'
RELIEF_RIDGE = 'ridge'
RELIEF_GROOVE = 'groove'
RELIEF_SOLID = 'solid'
RELIEF_LIST = (RELIEF_RAISED, RELIEF_FLAT, RELIEF_SUNKEN, RELIEF_RIDGE, RELIEF_SOLID, RELIEF_GROOVE)

# These are the spepific themes that tkinter offers
THEME_DEFAULT = 'default'  # this is a TTK theme, not a PSG theme!!!
THEME_WINNATIVE = 'winnative'
THEME_CLAM = 'clam'
THEME_ALT = 'alt'
THEME_CLASSIC = 'classic'
THEME_VISTA = 'vista'
THEME_XPNATIVE = 'xpnative'

# The theme to use by default for all windows
DEFAULT_TTK_THEME = THEME_DEFAULT
ttk_theme_in_use = None
# TTK_THEME_LIST = ('default', 'winnative', 'clam', 'alt', 'classic', 'vista', 'xpnative')


USE_TTK_BUTTONS = None

DEFAULT_PROGRESS_BAR_COLOR = ('#01826B', '#D0D0D0')  # a nice green progress bar
DEFAULT_PROGRESS_BAR_COMPUTE = (
    '#000000',
    '#000000',
)  # Means that the progress bar colors should be computed from other colors
DEFAULT_PROGRESS_BAR_COLOR_OFFICIAL = ('#01826B', '#D0D0D0')  # a nice green progress bar
DEFAULT_PROGRESS_BAR_SIZE = (20, 20)  # Size of Progress Bar (characters for length, pixels for width)
DEFAULT_PROGRESS_BAR_BORDER_WIDTH = 1
DEFAULT_PROGRESS_BAR_RELIEF = RELIEF_GROOVE
# PROGRESS_BAR_STYLES = ('default', 'winnative', 'clam', 'alt', 'classic', 'vista', 'xpnative')
DEFAULT_PROGRESS_BAR_STYLE = DEFAULT_TTK_THEME
DEFAULT_METER_ORIENTATION = 'Horizontal'
DEFAULT_SLIDER_ORIENTATION = 'vertical'
DEFAULT_SLIDER_BORDER_WIDTH = 1
DEFAULT_SLIDER_RELIEF = tk.FLAT
DEFAULT_FRAME_RELIEF = tk.GROOVE

DEFAULT_LISTBOX_SELECT_MODE = tk.SINGLE
SELECT_MODE_MULTIPLE = tk.MULTIPLE
LISTBOX_SELECT_MODE_MULTIPLE = 'multiple'
SELECT_MODE_BROWSE = tk.BROWSE
LISTBOX_SELECT_MODE_BROWSE = 'browse'
SELECT_MODE_EXTENDED = tk.EXTENDED
LISTBOX_SELECT_MODE_EXTENDED = 'extended'
SELECT_MODE_SINGLE = tk.SINGLE
LISTBOX_SELECT_MODE_SINGLE = 'single'

TABLE_SELECT_MODE_NONE = tk.NONE
TABLE_SELECT_MODE_BROWSE = tk.BROWSE
TABLE_SELECT_MODE_EXTENDED = tk.EXTENDED
DEFAULT_TABLE_SELECT_MODE = TABLE_SELECT_MODE_EXTENDED
TABLE_CLICKED_INDICATOR = '+CLICKED+'  # Part of the tuple returned as an event when a Table element has click events enabled
DEFAULT_MODAL_WINDOWS_ENABLED = True
DEFAULT_MODAL_WINDOWS_FORCED = False

TAB_LOCATION_TOP = 'top'
TAB_LOCATION_TOP_LEFT = 'topleft'
TAB_LOCATION_TOP_RIGHT = 'topright'
TAB_LOCATION_LEFT = 'left'
TAB_LOCATION_LEFT_TOP = 'lefttop'
TAB_LOCATION_LEFT_BOTTOM = 'leftbottom'
TAB_LOCATION_RIGHT = 'right'
TAB_LOCATION_RIGHT_TOP = 'righttop'
TAB_LOCATION_RIGHT_BOTTOM = 'rightbottom'
TAB_LOCATION_BOTTOM = 'bottom'
TAB_LOCATION_BOTTOM_LEFT = 'bottomleft'
TAB_LOCATION_BOTTOM_RIGHT = 'bottomright'


TITLE_LOCATION_TOP = tk.N
TITLE_LOCATION_BOTTOM = tk.S
TITLE_LOCATION_LEFT = tk.W
TITLE_LOCATION_RIGHT = tk.E
TITLE_LOCATION_TOP_LEFT = tk.NW
TITLE_LOCATION_TOP_RIGHT = tk.NE
TITLE_LOCATION_BOTTOM_LEFT = tk.SW
TITLE_LOCATION_BOTTOM_RIGHT = tk.SE

TEXT_LOCATION_TOP = tk.N
TEXT_LOCATION_BOTTOM = tk.S
TEXT_LOCATION_LEFT = tk.W
TEXT_LOCATION_RIGHT = tk.E
TEXT_LOCATION_TOP_LEFT = tk.NW
TEXT_LOCATION_TOP_RIGHT = tk.NE
TEXT_LOCATION_BOTTOM_LEFT = tk.SW
TEXT_LOCATION_BOTTOM_RIGHT = tk.SE
TEXT_LOCATION_CENTER = tk.CENTER

GRAB_ANYWHERE_IGNORE_THESE_WIDGETS = (
    ttk.Sizegrip,
    tk.Scale,
    ttk.Scrollbar,
    tk.Scrollbar,
    tk.Entry,
    tk.Text,
    tk.PanedWindow,
    tk.Listbox,
    tk.OptionMenu,
    ttk.Treeview,
)

# These timer routines are to help you quickly time portions of code.  Place the timer_start call at the point
# you want to start timing and the timer_stop at the end point. The delta between the start and stop calls
# is returned from calling timer_stop


EMOJI_BASE64_FACEPALM = b'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'
EMOJI_BASE64_FRUSTRATED = b'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'
EMOJI_BASE64_NOTUNDERSTANDING = b'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'
EMOJI_BASE64_PONDER = b'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'
EMOJI_BASE64_SAD = b'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'
EMOJI_BASE64_SKEPTICAL = b'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'
EMOJI_BASE64_THINK = b'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'
EMOJI_BASE64_DREAMING = b'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'
EMOJI_BASE64_WEARY = b'iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyJpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuMy1jMDExIDY2LjE0NTY2MSwgMjAxMi8wMi8wNi0xNDo1NjoyNyAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENTNiAoV2luZG93cykiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RTg0MzYzM0I2Q0U4MTFFQkFDNENFQjAwN0U2RjM1RTYiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RTg0MzYzM0M2Q0U4MTFFQkFDNENFQjAwN0U2RjM1RTYiPiA8eG1wTU06RGVyaXZlZEZyb20gc3RSZWY6aW5zdGFuY2VJRD0ieG1wLmlpZDpFODQzNjMzOTZDRTgxMUVCQUM0Q0VCMDA3RTZGMzVFNiIgc3RSZWY6ZG9jdW1lbnRJRD0ieG1wLmRpZDpFODQzNjMzQTZDRTgxMUVCQUM0Q0VCMDA3RTZGMzVFNiIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/PuojFwAAABVfSURBVHjatFoJkFxXdT3/9/+9r9OzL9Is2jdLsiVblsFbVbCxsGPAdnDZxgUJFRehwmZTRYrEEBJCkTikCCQVKhWDwTiKSTARjhXHRsLGYIxkoV2jkTT73j0903v3X3Le+z2antEIjSzRVW+6p/sv77x777nn3veV3bt34/7778fVfKkcUQVa2Ua7BbR26WgIaVhu2VjBn5o56hQFDR43gm43vHz3lsowikXkiiVM2TaGecwZVcGhnjyOFYFjtgvD0+blzeOOO+6AdjUA+RX+sbGswYXVPhXXejVsXtuKtmhMgqitr0N4WQuUeAwI+AFNB1xcBZ3vGmeguQDDhKtchscwEOPnzmwONw0O4cMnepCdnERvdy9OJfJ4adLCKxxnuVhLer1jgAFO0GthbaOOO9ti2LV6OTZ0daFu63X1iDc2orHJi2hwErAGCL68+EXsBe9KZVS/FASKaaw/eRLrf/EW3v/zN5E6OYj/zlj4h+4iDlwKqPYOgCmNKu7qCOFjW9bhtpvfrQfWX9uO9nVb6JcrCYhgst1A6iCQE+DsK/YQegGuuY5jO3DvHYi+9Coefv013Ffbh386ZeLJCQMzVwyQ8YAVOt7V7MFf7NiC2z/4B3XYeusOoOZ6XqUVSPcDo68AM7+mv2UWt8ZlvkpwowAvipYHxaJH/l9u9aDxLh3Xb9O9hf3Kp7wvH9z5m4T10ISN0+8YYK0Ob5uKL25biU8+8pFa9873/h6/3Elr1dBaJ4DJvyPAw/y/Akqdf34ZOtIIYUYJy/cMgnIklDgSqAx+nkIM04jI4/LwnR8lEKDiRpHvZYIs1emwGnSo2xUs2/bs9mu/+pE9ByaKd01Y6LlsgHEN0c1uPHv3e3DnH332ZnhX7wLMWqAwgfLkT5CcOoKU5UJK3Y6Eqw5DSjNHC0bRiDE0YFKplaCqAYqJXvFLeH4e6LntQZQUfdXmv/rws4dS+dvorpklA6zVENwYwH/e/OGNtz7wqQ9gKPQe5A0/DuQ8eG6shJH8u5F0NSKl1ciJ/65fbumk0lGhmSUoHK4ic8eOG+C6d9e2Vd/9jz9PmnjCtJcAMEDq3urDNwqP/dmt5qe/gBcUDxQDOJoDvsUsVTbfGQeHyQcBZBGws/I9pGQRVmZQqyRQiyTiShJROqr4LsJli/Czn8d5nWiEJhi5XIKRL6F3qAzFMqG7LGQ3mHimBX9yug/fGTdx7JIAO1TcW7j+xkfbH/ocOn0eCDpO8NpPT/P6aiXWLOdYnSsaExFkiyhKIa4m0aSMcYxyjKOR7w32uJzseYD0JI/F1WKG57xhcZRK9PySnL/8uswFZfJHvkDuojtO857NTZzbKmEB5/ZZHicWvi5MQ94EX/cIPp0o4KOzVrwAoIsXWRvA5noFT5k9JzD98PXYv/4atN22C4cKHvgsN26tH8SNDX1Y6e1HkzUiQQmAUQ7dTDM9MEw5mKyR4chxpLgwQxxHUsAUST3Fw6YZLTlOPC8AEQhVjBylWYAcpjWXH0XG8XDG12wAPv4xIBThNcYdhi8S5DWbga7X8P6hAXxx1ED/ogDXBLC9TceLvuVd8fZrd2K8twc9P3wOfXufh6pSptDvaVCMxqnBmPq8a4B+TvpN5vTRCWA8QULNOuDk4Od8sZLLeT5UF2yO2XfFxSHljOa8MzaUsOZIHf6mcvAg51yiNDMpvHm4H4NPGnji04xLKiOqH5gMmRoqpXXrET0xgnsI8BsXAOS1tQYFXw2v3hC/73NfRrlYwH99/cvY9dnPYc32m+imNorZDMYGBtF7/Dh2H3wTky+co18VZGqwvX7Y1GGqS5PZWfFxRNxQdTds8d0sqPPvPElRLypsbJrVnE45SojiVfF4oNa1Qg+GMXz8CJ7dbeLRR6uIlSeuWwfsoxVdBfwjw8qeBzCiYZ2mKzu33nkvOrtW4Jm//wpibZ2oXbUJp0/3oEDAwooerw9r3n0zuq6/Ab/42T6MnjoCdawXBlwota2B5fFDsS050Xk6xq6CYFf+ty+uoBWKVdXrgZlMOC6ay3DQJRqaoTc14tixIfT2Ae3tjjsLS7ZQc7Q2YIs5jeW8eu88gM0artPCYb1z7UYM9J7FRCIJT7wBr+17dVHJ5aL7BKioQ13rkYk3Qe87DgwcRXH5Jv6oXblM4/kqrWUzKC16jgg2m4tsppJw8X75sVG89RaVeadzuMV4DQWJowWRpm5s5Ve98zSHYWFjsKYe4VgNTp86BVckDpfbQ7VP32V8LBwK3cbmVWPhkOOGnZvo85xUOjnP9a64/BJsIuK2Esd2Ng3TRetGIjhJIZWakuE6lwE6yA3ATrtaVGl0AV1BZ7i+kaY2MDwyAt3jW7oVpLvZMr4cQrhKL3FN4ap+/9xcuKiWoOZ4PSbpvT1n5wOsb5AKbHNUqwIoiCviQp0vVotMJoOZmRnO89JqWVgxn8+Tznnz7DRMEoPtY1KyratbRPsCkmjO42YsWt4QLJLaieNzPwk2jUaZF6Noc9kIqVUM5uYCBXx0h2QyyUVa2gTFcel02mE5JiXTG4Dt9l6VMmmeFVn6izSilgtytjbVgEXmUQIhDLAqy6QdxxG3DQTkaGDI1Vf7UpC/BXUyZCKRWNJ9hfUKTBGFQhEuwZpT4zBCdb8THarQm1yKjVzzKlg+MgklmiVkTigMQbITCcdNhV0IAT4/wl4FNdVJKMC4DZRMxyLqEuJIABTH2oJssinWunTPYOzqu6dRhFrIY/z2R3D0ay8ivXIbVLKpyJO2P8T0RYExPuemIrKijJIWjwjFWVez4dd01V8yTJiUH4qiXBJcUXSJGOyqSNpTY3TPoOOelnll1uICKabBYcqVzzZ1YfDWhzF60/ugpWbgGzotBYVNMrRVr2zqjI3NvycJlvIc9ecB+lV4VU0PlgVApbQkgIKMTFpcIwXbM5Mwos2XDUSl1Re+TAqFfE0Lga1AYsPNSK69EUaE5RhdsHb/8/ANn5axDi6CrQip58ZUIj/vGj6fBBjW7IrAbvfgQZc/pBiqtiQXE+Qi2FMRmpHsaTHobbKaYpad1a9Y0WY+FDLNVl3zwVkGipEGnLvrE/KzAGq5fSgHIhxRFGONKEfClQTtsKBnaATNL/6zZM5ZyiT9yOtnMgtqR12eF9QMnrjSjxtjXvUzkfXbuRo0vWlc0noiV0qmFexZzMFSdZiMP4sJX04wUo902zok1+9E677vo+7tl/mbZ167TDVK0lrJzTtEzeUAMSv6zpJNGaeS4GnadBqrnvtLeBODMslXsY+kT1GBCKk263i6cz1Vq9OhNLnwGV/HalegpQOWUV4Ca9uShKQbczJqJonxbbtw5g//houjoRSKE6xPygnPwAj81Kn2AtISFtVJTBv+9ZNIrdiGkRvuwfSKa1Giijrf19FkQwfR479Gx55vInzuNyiK8kEUjLPXEQvMIdKwcJqFAkrzMvYYQsv9LZ2XFT9Ch+pcJkFKIhZKkTrk2tpln0TEigBe+8v96Prh1+AV+VG/sA8jQAoXjnW/KUe+thXZ5pXI1S2DSSB6bhrBoW6E+o5CZZlmuoWymr6wOWM7zFkNruw4oSFisMxRtM3LZz4Py5csy21F80AX+lN1Vt43PEi3/B4af/UC48taFFyVv3PiXvnROzUC3+TA/OkL6/D6wr1tlgy24Adl7lyF3iS+q5SUsqqQLceinEtOSFCDo2AW85ffBKK6kJPweOEf6UH96y+j5vDPaI1fwZ2ekFawtaU3biwRW9XxdcEBpqPFzic8VQIUwRcIzlNysougBjGlTRBxysBUPJ+5TPVky4pCJYsKICI+1j79eekyFmnb9ASuspShJQv5+eKe7KkIwUb3ramZfzjTJRQ/JrUCLV6ycdbIzly+wuAKuhhHksW5eiYZVJY1V0uHzppEKCVZE2bn/yz0qdgqKBlobKpOYbIHZOdjBKg4ebC7nGYuMys8u8QJzjKpyEXSVcSVF+S7JQFYPNFKpSIIzBKyTFTypjHvHIXlnJJNwMsQbmxwpi3IWrhnPocknWtSBshwCUea8mnbzGUULcAK2jaX7KZizN5UqZDCEssQB8T5d1PGksjBtkhVIomblZhbuCAVJKrYlRmeQh31vRjiUAGQlZ4Yo7UqRiXAvI0zZi4/UkpPN+uhqHOzJbxEsjd5VWd70HZiRKSNCrPNFsHyf3HNWTBiJuJ3q3KcZS3uNcoiVradPqIai8NF1WSlM+jc6pRIorgQnJaYBPpn0O02UZQuyttN0o0PFMYHmwMt7UsulYTQFmpGZAfhTqI5tGQLVoMQf37bebMLJULCH5QtDM2mHOzrhu4ysWWLs0azRu7vk7nvNXILdTi/yNC1p03sCY71v88sFWTbQam44MViT+hQUfULoCqZTIheR29eBYKZva9kSs6FeVJhoKkkFZddgjbZD3tyHD6PiXvuBzoqXTUBTljxzFlYo8DPVlT3RUcMvFg/NZUsTozUFH0Rnuxm8HrPx5giZIIkFBuZbI5ukIBwTkUI6WlWEi63/E25EgaVjKfJa4KMrLg9sv+rkikVCnp7JAlXIS2V0rKVCh68F2hudjrhs/rz9Gng3AAOEudhpRrgWAmDKd3+kf/c8Y+UOzYjRXcLsajy+f28gQmDcj2bnEKWDp7PzEhGE9YTk1GSI1DqG+BidSDuZjM2zseVjUX2qatckwgkIA6VFbsqSihB/YUc7NSoQ4mlPAJUacvaRKGnoq+kI95po7mpJC0265rilq+/BvSl8U1LbKEoVQDFZkVvCV+PDfc96Iq3eS1PEMn+XhRHRqSYjvuzaIiTrYihdi0kNYs5i9Ub5DwOHh8hlZNkhOziyotOmO1yVdKGcqELctFEWWVz8kJX2WKmFNGKqA/5fZCkEYvRQquAFfS1NoJrpbV4Gzz9KmtRMmNW3E6TXCXns38/8PZh7Bux8P1Fd5fGyzgyVbC+ETl39PGC5UcwP4Sbt9i45V0sqXiTxjqpDuR8x0acjRXKUQwPAad6TNR6EnKzJJ9yYkGwvbXAcLOGFHQuajbZP+Hk/LVADRewvt5xuzj/j0UddpSOUHEIn8uWpKYoc0PslRw4APzPHvSdyONjWRPlRQEKK3Jee6yp5OO3XJfEIx/i6q2tTM6ojLwjqIUUSmUcv88WHKAfvA9ooqIQTTZpkDLO12lWpY8vgAkqp5EdgF6n+hZAxLWqWp9yFKsKfmGtEpWzyESxgI1wwNlue3UfsPcnONufw/2Txvy9+guUMCe0fT3zypeerAArLM4HUXpeueLj9GbStbOPF62sunIJ5q9m/9lwLRYv/SBE74QqdwU2tZvoYzp4aS9w6AheOJnHn44b6Fv4WIm2yE0D4VDll1x11aXgjNKFfixDj7oKh9xR9Ll88mGCcrQGauQppCeOSDVhGFdVY8t2oC4SeEbB8SEVcea+Q/stHD6Ko2en8bfDJr6bMRfPT4vVMnnZB+JEx5QG/FK5AS8q78UB5VoJMIWoU/d5xKMivY7PKWFs6ngFCQJU3iEIMeT2YdXjJ+I74eKTVCaTE8Cvj/C9x5gpZaw3fpXCdwYM7MlZyFzWg0AeBZNDRi3+WPkKXtTegwG0XaQYNOcCknFR7liNkZf4nyavsSS9LlWUNbe7K1xcZAWRhZKsn0ngmJggZ6Vw5twEjlq2vXfMsN+YMdGdWWLr9cIYtHFuvBzFK8YjKDF5w7rIIxyiNBLFqdxi9GEgtgED4wq+930b9azNxF7JrGtJ3VpxXbHbK6oeURxkxE5wXmw/aygVTKY7+xSJa2A0h14qrJP86uRoGeeYKs+mLRTeSTv5AoA0e3/HyMB0aORUJLF84+IApQV9xKeis3AMm8tHsNP/v3iDoF7djy/RCFx7NEC2neCWtbgt6Wqa5HSdK1LzQDne6jSihCykavIlTyEzlXyMNP9TV8VFzz9deAWN8gsfQnChz04Wz8SGD29NdG3EbEbRmCNa7UG0YAibrMPYqbyBmHoAMeM0opYBTxg4yzx5bAiDx4r49gWPj7hkLgsHfTC9bvsBWydtGTkoRd4gJ/qiGXgV/PXaEGbqg96I0IjJbHGIln8jZ+KtkTJ66F0jJBO5aqK5QdxcYpQyVen2kgBnDBhJF15f9eYzW2/coWKNdQRr7RNot3slwFpMVjib+Y7poHvGIVuLq97Ryfx0DHf7DXw7L3KVhlijhjsjOu6rCXlWqronZmt6VLh2qDQFl/CCQJDvFNI8WdE9N2QYjPmy01iKke3UcuED1tQ4ludmhjKp7JmSB5nWCFUkdQjzqc7UUjo5iD2Hs/QcC+YlAYpGMCH8uOMXez/xLx/cq3jqK83YReJQ8zkPQIjlE2Qh1I5Xw5YWHbfEPLi9Nqx/yNfQ1hVYvhJaiKlESDjRx9F0R7wv8vIzz6TTM5iZnkap7HMeVIgvg37uQMt9t2ZbVlK6tTVSlzY5ubfAez/3LLZ+/d8xdtrGt0z70mkC4yZ+OZRA9/8dwOq77q4omEUAeqlG/BzpnEMgDY1SajW70sFXYyvXKL7WLrgj8fNb3bLwFSfKlrshc2t1gT8r4aLhMIJkqWmCFLtXZbEXSH3a1QVsZ+0XC809iOShrz70IFPI2/jC5An8aNJ5WnhOHCwGkPVhNm3iBy//lHPJX+woJ0/FQnMTFK27zuU0UrxViW2+Ce5wjWxBiG65qOhF9e6yTblxafKiWoU9hKQTMk1ItqJ84smSjeV4PE7p14RQKIicqwbnmHbdsy0fo0I+PD5A1n7g/Whc5sFnF0510akLNx228G/HTiB14KCzN3CxJ/6iAUdbis8iFVyziRNk+SSaWAuToU5Y41Q+P8IajrXoo2hQeZJw7SeeAD7/eeDhh50qokDfE90C0Vyuq6uDm2rpbJ/jLRdoFvLzLbcAN23ER6OKfC78twOUblpCf7KEZ57/sfMc2aJHih0fUlrEP6cp6xizXlcOZZHoqvb4hbVSzJcvoxMTCDHOA3jJWomT3gY8+pCF9nYbjXTx228HHn8c8tEQoWIESBddxRuNY3DCi7GJCsBqycT7apzDfXcj3OHDZ9SlABTByrrqqYOHMPX6zysZ7SIvv3eB7BJuKHee1MpNbGoeHXu5uDPwV1iLlMcF2FfswCd2L0MiOTfjBmbQxx5j3Vk721SzEYxFkMiH0dtPryxfWGIKV91xA624AR+Kqui4JMCKFXtTBr769A8onUYrmyoLF8JwyiYoc/vjTfUWpk4cku2/2b7pfixnOnHzEuX5LsD67odvN+PJ3fXzMrpoA+7Y4ZCXaJt4yWjlQCNOnuJc0ou1IXkphsvv70JkhR8fVyqG/n8BBgBOtpspKl5j3wAAAABJRU5ErkJggg=='
EMOJI_BASE64_YIKES = b'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'

EMOJI_BASE64_HAPPY_GASP = b'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'

EMOJI_BASE64_HAPPY_IDEA = b'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'

EMOJI_BASE64_HAPPY_JOY = b'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'

EMOJI_BASE64_HAPPY_LAUGH = b'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'

EMOJI_BASE64_HAPPY_STARE = b'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'

ICON_BUY_ME_A_COFFEE = b'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'

EMOJI_BASE64_HAPPY_RELIEF = b'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'

EMOJI_BASE64_HAPPY_BIG_SMILE = b'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'
EMOJI_BASE64_HAPPY_CONTENT = b'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'

EMOJI_BASE64_HAPPY_HEARTS = b'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'

EMOJI_BASE64_HAPPY_THUMBS_UP = b'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'

EMOJI_BASE64_HAPPY_WINK = b'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'


EMOJI_BASE64_CRY = b'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'

EMOJI_BASE64_DEAD = b'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'

EMOJI_BASE64_FINGERS_CROSSED = b'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'

EMOJI_BASE64_GUESS = b'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'

EMOJI_BASE64_CLAP = b'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'

EMOJI_BASE64_NO_HEAR = b'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'

EMOJI_BASE64_NO_SEE = b'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'

EMOJI_BASE64_NO_SPEAK = b'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'

EMOJI_BASE64_PRAY = b'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'

EMOJI_BASE64_ZIPPED_SHUT = b'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'

EMOJI_BASE64_NO_HEAR = b'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'

EMOJI_BASE64_MIKE = b'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'

EMOJI_BASE64_SUPERHERO = b'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'

EMOJI_BASE64_BLANK_STARE = b'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'

EMOJI_BASE64_COOL = b'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'

EMOJI_BASE64_EYE_ROLL = b'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'

EMOJI_BASE64_OK = b'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'

EMOJI_BASE64_QUESTION = b'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'

EMOJI_BASE64_SKEPTIC = b'iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAA3ZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQ1IDc5LjE2MzQ5OSwgMjAxOC8wOC8xMy0xNjo0MDoyMiAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wTU09Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9tbS8iIHhtbG5zOnN0UmVmPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvc1R5cGUvUmVzb3VyY2VSZWYjIiB4bWxuczp4bXA9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC8iIHhtcE1NOk9yaWdpbmFsRG9jdW1lbnRJRD0ieG1wLmRpZDpkNTJlMTYxMC0xNThlLTlhNDItYTY0Ni0yNjViYjMyYzFkMDgiIHhtcE1NOkRvY3VtZW50SUQ9InhtcC5kaWQ6RTIzRDJEN0QyOUM0MTFFREE3NTdFMjk3NzIzN0VDMjYiIHhtcE1NOkluc3RhbmNlSUQ9InhtcC5paWQ6RTIzRDJEN0MyOUM0MTFFREE3NTdFMjk3NzIzN0VDMjYiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTkgKFdpbmRvd3MpIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6ZDUyZTE2MTAtMTU4ZS05YTQyLWE2NDYtMjY1YmIzMmMxZDA4IiBzdFJlZjpkb2N1bWVudElEPSJ4bXAuZGlkOmQ1MmUxNjEwLTE1OGUtOWE0Mi1hNjQ2LTI2NWJiMzJjMWQwOCIvPiA8L3JkZjpEZXNjcmlwdGlvbj4gPC9yZGY6UkRGPiA8L3g6eG1wbWV0YT4gPD94cGFja2V0IGVuZD0iciI/Pqm5dLIAAAv+SURBVHjazFp5dFTVGf+92ZfsIcskMRsIRAIJYg/SBupRtoKt2loBsYuKUrUux1ZLVBZBAfGU0z9Aj+VgxYoLR6RiUcRii4mIiAiUfUlIIAnJZE8mM5NZXr9732QmL3mTzEyG2HvOnffeve/de3/3++7vft93R0CU04xkTKbLNMqTKBcIArJFEQlK71JdLdVdpNsTlL+i/PlnTaiKtG+RGuvXxxDBGOnyF8oPsucSgjZ3JjA6H4iJESCotNSrm7J3wHY8HqC5BfjuOPD3bUC9lYPvoPE+Q4A3DDtAAraELmtm3ww89gCgiRsLJM8FTKOlFzoOAVfeBLzOIWlDQyPw8J+ouQ44aeyTCezRqwqQgC2gy9sP3wvc/svxQMbvAJVGqnSTCKrW0rU12loPNu4nl5MenwJThXgC2hl1gDNHoGHieKSsfflGwHJvoIJJq3YTrnZiYz90BnhuOd168QKBXBY1gCQ5zxOr81TFc/+MLlU87LT0WtwitlYeRz3S0CbEwwUtTWsMWolP2LPoa5q92w2dYrvxaPPfm0UbvdXNyxKoFTNsiBfbkIoG/pwiWiE01iDWdhmfv1mFmiPWjwjkz4YMkCRnO7ftgmlJQb6/7H1aG5+14ntNszbfBu9HO5cRyFUDAVQNIrmXVKXLZeBO2L5/cCx9ev+HEHX6lTRGw0DvCYMAFNv3ingkzY5YdMAkduH9c5/Bgjoki01IQjMpZScSxFauRjyLEno1PPybUFKrb5vsEkykmGaeeWuC1GoLElErZMCKFJy3p6NenYFaXS7ctCxu+oWxfU8jaXYQCWoGALfuyYeA2Sl/BXq2sdYyzPS81e/dTpKqrYvTOarsdE/PXQ76zCvVBUsq0h+TkeVWqGiqzeZWxJiJwyiPjpHq+qaadtqBmgPPSzWIpbFqSFXdSn1oBpjYp2bf3EfA9W/hKG3GTz0//Cpp0AM7tgBxJjnAxQ9A2PgK2KzPDxkgzYguJZlukmYGCl1N2P05sP5VUgWtAc6cQn4djqTuJESXTuInBGH3e/K6rEx+mRcMYDCSKV38GwZwVqCkeh0H5zUnwDHqhqsLjmw3V021lOsuw2NOhL2ghFfdtaj/6zpd8KY0QYzgp6ZNYVNn9pf9Z59EHs7swqhiac+dgGOLN/qf4y4exYTXfg91fCI8bS18IbtqL0FryUJ3xmi0157tr3EzgO5duI1uPwxJgkRGZllB8x6s2yAhj2ZqGvdjnLpnNUqemYaS0qk8Z+17G+VrylA1r1T2rusKSTI+ld9/e1jeTlERv9wfjorKk3U73MRRrtTcqAJMPrEPk1+4VbLDfCnp9H4O1JmQhq+3VAYmtdcO8MlueTuxkjjmhKyiWRb60ab4GvZyV4bb00mZynYi8X1zwVTY0vMg0GCNDReRfLIMgtcbMfixW5dykL2Tt7ODj8HWXKPIRSEBJAa1jMxjKzfVvzV8sEt5EG5TPA4s/Se0nS1IPbKHA1N53OjIGY9zd5bCozdj/KbHEV9xOCKQ+tZ6uHpJ19PeCndaFjTKAEMmmTHZmb0k2PYl9n4R5OOuNq5OSilvl+SnNo+dMjQ9ZtZAjyYQWFGt5bcVpL35eZEBtCQnsRqyfrwOiQxapO0huMEnoHy1fBamrJgNtdNGa+qrQQfhNsbiwLKPA5hcDvxw2Qzp3mCEt6u/OXT6dGgAlUhGHxvDashOqtscUA9TXNBG9q/c26/sqxW7QxZSb3B8rdEe+82S7dLc6fTyl33SrKoOUQEUysxqVqqi3bPzWIBIdKagjXg12sgdWbXyt07fliBo5EomMoCCClZr5ABtnV3wq6e/4SGAGNCd8brDnBEvH4vdHjnApg4W8bDuCLnPmJoz/Tnb2RV6LEIhJZw7GJUJVAJ4vvYK69gln2mif9HpUGykeMMiJJ4JkImpvoJIZlbIg2BMrOlq9z8nnj2Iwtf/IOH3uPsRmuBxQRuiQimx6Nnqywqq1G2Hx+GCJiVdsaFxbzw9pJm+cdVcZQE75aFHwbdtBBnG4ADJcfRozyqImvY8IS6DGvfQg3rY/ECvvY+q+/rOzYlcReFy9Yl+xTKfrAUqcwwZvTUY1hRkjY4d209zL0dsbM+Z4WuEMSn1x92Y4cDWd82z9eeSVPbaUYHihgY+D/8Ixx+8yLSg5/nunwPvfCBRNAtTMaOXrQVVbLziwLrjUuAayPJRSLp2K7S2Vpnk3I0NcmYmH1Fr7X82c1TarreGDJDa3lR2AC9OvdFn2viMCV3deXgTs+BpbiTDt41nNhvMnBK0ZBjQpiyo1bhcMg+1U+eFBTB32xqkf7qZyNsVfD3RElFXNyAjQ15e/iXnjgPhBJ3Wb90eAMhSIen88dMNUJFX7ekzG5wIepHBNZue5jlslRzIIGAT6JV6/tXCPhrTHSbJ0Gw4Ki7Ky9Ys9X3g6OThg+FMTCs0qekwXJQOlxJ6aT/bRUiJjocVk+lZh3YHco0G4FvaNrLIezIzc7TyiOT4ZuZBdLu4ug6kVkOyQkxmqBOTuZYYzh8ignHgjtvl7+z6mFc/GHZkmxzfguJCnFy3XALYk955Fzj2X/+uy8MY7iQLb0rsdnJ1FR12Ah+ejSnodOTAmCEYaT2rNZwttY3VUJPT25MW3QeMHNkn/Pcs1zhBWi1hRLbpo1M9gjeTFG0+xl4wH7hljoBX31PDUeWGlswylgNehxEeczy8sQnwGmLo2TCg4awim1Vl74CKGFTdXOlfZ34pGgUYR2rx3IL+C+3ceX7ZGa6p1jtNX/QE/rXxZSKYykBhq02AdoQa2deqcO9N3Twgxaj6yBEyZC/YoSGzDi1XwlZJZl9OmAhMLCZJ+c57Vu8IHvR8/W9cELdFDJA+3juTFvD2nSgcM76X9+ATSqxBUgnmsk26XsqKvh0RQVeXdGVkyLYddu6gUkW+Ples4qQ7LRJjW5b2NGI83kNNSTUy5vjs4YxEyauubwstTsoA6fXRI59lKzivPUQCKI/IFlUAmVm2H+tLnwPafSdizOtv6xKu6vbAlgJLs4okwjp8RCIVAjeGwL0WEnmF0yExq4q2j0qviOyFC4CPzulRlOPB3OvdVwXg6h16rsZFeie+KONFGwjYo8Ht8ij+T4bA/pEuLzEtGEWG7w2TgLw8IC52aKCu0K5w5gxw4JAgtjaJAvMSaNx3E7CywR2PKP8RqBdYtpYZm/2UBlRC/YyMxPWj/A1lFn/cGcr6GjaAg6XpFqPoGDlJVmY8Ve7foKPnOg4TQJLoYuZlUc7hfQiq7L5ROZ9f1+P7XKC8hQC/+X8LkECtpMtSgcy3pKIpiMu/btDjNqvVCptNilrrvC44j+7rCewuIbAvfS8AZ6eigcadnJkOb3wcNO2dAI/C6czInLUw7InxeDy4dOmS3LE9sY8WtROWNOlorKUN7ror/PSo8pOG4Os7LFs0iJRWvPHu7SlpxcTUl9ar0LQLJ8itcnSz/ckWkeTV5Arl5uairq6OLB0pHGHSd6P0aXYFCnIC4/z6W+S71+LX4ahyuMbS8rT8H5DReQsYOB4uzI2OilssFp5Zam+TJFHQJ3I2WeKpLUMN/AaT3q1r1hG4imeVYyomZa8hPcmOhTdfgFYTOAw9bc7BVsssHI4b08ek02PEiBEDjuO+hXws40IddzgqunNS3jdBKw0Zo/qVLZ57BkX50p9afjSuAWvenYCVurvgEqRuD8WNRYUxA3fW/9v/jclkgpDAziaVT1fmk8P7xjs8/hIbNQkyE+2GYmVC6iYr7QK5gzHXyAE+ccdJPzi/czr/GNYKb8vKmrVxKE+YEBgQs80SLbA2EqEGCdIQ+ZijraKbnw8SQ6qhiT54kNQrKTUgBb0bo7MCf5Vcvz2gUY8T8NL2bbI2Tsb0OclMSsN33wF1Tcp9vrwCAk368mgC/G2ww47mjl4hDF8qyA6A83gFXKiVH55On1g7qA/wRbn8L1u904gkySWMCkCaKfXMmwbxxI1ygulNKGqViI2Pyo+xX9lfLHs2eeQRbIPBAK9n4C16wnXRU9GDj9ynXFFRJ1n/CYWh/9HgnlenY3taYMZUohf31H0qB0xEA0s+jwLUNCq389iDfPLfH6y//wkwAL7JVyiyAX5fAAAAAElFTkSuQmCC'

EMOJI_BASE64_SLEEPING = b'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'

EMOJI_BASE64_TEAR = b'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'

EMOJI_BASE64_UPSIDE_DOWN = b'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'

EMOJI_BASE64_WIZARD = b'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'

EMOJI_BASE64_CRAZY = b'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'

EMOJI_BASE64_GLASSES = b'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'

EMOJI_BASE64_HEAD_EXPLODE = b'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'


EMOJI_BASE64_LAPTOP = b'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'


EMOJI_BASE64_PARTY = b'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'

EMOJI_BASE64_RAINEDON = b'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'

EMOJI_BASE64_READING = b'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'

EMOJI_BASE64_SANTA = b'iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQ1IDc5LjE2MzQ5OSwgMjAxOC8wOC8xMy0xNjo0MDoyMiAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTkgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOjQ0ODdCM0Y5MzQwQjExRUQ5M0NERjlEMzk2Q0RBNDlFIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOjQ0ODdCM0ZBMzQwQjExRUQ5M0NERjlEMzk2Q0RBNDlFIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6NDQ4N0IzRjczNDBCMTFFRDkzQ0RGOUQzOTZDREE0OUUiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6NDQ4N0IzRjgzNDBCMTFFRDkzQ0RGOUQzOTZDREE0OUUiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6dQR9sAAATTklEQVR42sxaCXQUZbb+uquq13QnnU5nIyFhM0GWEBARFRFExu3I6AzqKMyMy4jOO755epz3jr43m7OcMx6d8TFvxqdPHVFH0FFBHWUYlR2CoKDsARLMvpBOJ71vVfW+v7oDQURRCE6d85+ku6r/+r//3vvd794q6LqOgXHppZfiDBwujutkWf6fqfn5H15RUtI9y+frrs3N3ZljsTzHc4s4xmEIjzVr1hzFJJ/BeX0WSbr1suLi+df5fBMqZdlamE7DlkohyRFRVd+RZHLC7nh84cZotHlrPF7Xo6p/5u9WDSXYMwVw4bcrKn794xEjyscRTDwQQLy/HylNg8aTFmFWkwllsoypLhe+73INb06lhr8eDt/4TCj0j650+kFe8uFQADSf5u8Vl6IsfvaCC557fvTo8or2dnQ0NyMQiSBO91AJSufQOFRenOB3EYKOcpQQ7L0eD94oKZl7fU7OWp6++58NoFJosy15a+bMexaazeg6cACRRAImSYKJgL7oSBFskEBLCXSxz5fzgMfzJy7moX8aFy2wWh99fcaM71TTHdfQclarFQ4uWgyLsNyp7C6vE1YVu/xvtKbFbP7JQ35/hL/97ddqQQn43k2Vlfc0MM6e7+uDlp9vLFbslnIK4IR9RXz2JROAAMjfhPj57txc3OZ2/5qnr/w6Ac6udLkeG8sdH0vXvM5iQVU4jGFcoOsUJxAbYKUri7jcFAqiK5nkQnR0xOP493yPNNFqXcxTnq8D4B0PTJjwtzVz5uQtIKCCjg7ECS7FE2kO7UtMpNFyPosVVXYHXu8PYE80hpCqopkE9WOPZ7RkMt1zVgHywoWLp0598je1tXbroUPoZNyl6Fom81fnqTRBltIDvpnrwYpgEC2pJHZFoxima7jYbr9ThPrZAjj69tGjF98zfryp/aOP0E9ikWT5uElE7AlysXI4xCDwgWHnZ+kkEycFSBLU1Q4HVtAbuGXYFYvhOodjGE9fcVZYtEBR7v6vSZPywo2NCPf2HgUnC0D86+eCOpkiBCOK/NdD92XyRph/PQRYrigYzwRfyL/CNQ2i4fcG2XDEhbvzw0jGZZOmwsJrrnQqKJLl6znPC0MN0DLJ55sznDdvZBK3EpywFGMETQT2LFm0taICzrIypLnoMIGNnDQJVWPHojIvD93d3Vi+di1+v3o1cvx+lNJSZqodE61VY7NhKj8rBNfL76ZyA5Zxo9z8PIL/j1KU8QQouCs0lABLz/d6S9WuLti4+MNkuo8IbDXJYD+Z9PuPPIIHb7wRw7zek8/wwx9iZ309AtwMK0GlyJq9dPP169bhwZdeQmVDA66xWVHKc0FNRwkR27iB1RZL2eZYbDhn2DOUAK3VkuTZ19SExwiyffx4nHP55bjhooswvroa48aMOaUbTayqOuG7eXPnouO++/C/Tz6JxX/4A2aRlSvoKRItKJtNKJdkOy/znlYQfkG5NJ1j8YySEv3a88/X//Tss3owFtOH4jjY1KTf+YMf6BN8Pv1CLmt3UZH+DAfv/63TKZdOBnCUzWZ7bdGiRfrKlSv1HXv2DBmwTx879+7T73/gQX1ezST9eptNALzrTAOcU1NT071hwwb96zr6+vr1pcvf0G+/+190WVbezKq70y94E4lEYWVl5TOrVq3yFRUVnXSCKEkmFAwZf1WqDzPZU+hJkQJi4lwojDjJSFU1CrBMWrCQFXOpNX2+AhR482GxWE46f26uG6PKhsF+5dXw5ORc89jvH30knU7fn1V5X51kUqnUtFtuuaX8ZOCO9PSgoeEwOjq7EKHigP4l79fSapRSbubE0tISY+QRjN1uP+HSfAr4+gMHMXPmLCTi8fueeOLx9mQy+UeeEqyWm1U5Qh02fB7LfppFzXI2iQvLBAJ9Bp33s2ro6wvCzySfSqUhSWbI0jFtIhYtxlG//4IjxBy4b3899tcfgNPpJMhcDCPYsrJSAyw3Gq2tmc0IR8KYM/cbePe9d36uyPLCuXPnVpeVlVnLy8uNNa5fvz62ZMmSv4ZCoXs5de8JlcvgBU2bNq1M07Qdy5evKNizd78BSLiZUb+K5C7UR7aYFS4mXFNneMSZnON0TYvVwu+t3ADJ+I3OnDY4eoSko6sZ46joFm0NDrGMXLcLBQVebmYf+vqDxvwD93rsd4+CVsRYCohPH3V1dZg/f/6GtrY2Ie2iIgYHCPM4C7Jobd20adOby1e8cWtRcXEmtgaJ6QwoiQtMoZHJubm5Cds3r0cq1AdJT0I3KywWOXiNwGZWLLA7nNDUtHAN1E67CKNGj6ZrDjvqJcJaA/cIUzwEQyFujtnwkqx7CG7gPHZaO+czPWL69Ol47rnnZ3zr+uv/r6+/73vZ4uZEgGLnuZvPb9v2/q3fuXkBglT4wsIKCULmqK/fj03r16GdlURvZxsklbLKIsMuS8RkJpAUNIJXCU70YVIx6sw+P0xZqlmxrAGKPQfewmLUTp5CsGMwnDJP4oborCAEWGHNwYeI17ffWQUTBXlrWweKigqN7sEJRersWfjRvffd/Ktf/mI11/z05ymZdS8tW/q4O6/g7gumz+DNNTQcbsXmde/io81r4CgogjPHhWEjRhk7L5jTlEqIAs9wQZOSsfKnOdKcTiCfi0/TmqFoBG+/9jJ0xrOX1hw7sQZV1WMxvHIkHA4XN0QzPFvixm3cuhX1LzzP+Ux4+tmnMWXy4s+0Ynf3EdTU1qKkpGRBMpH4XICaKZm8Z+NfHp0e6Vg7SbJXsFLfh/D7+1BeVA2zrwQ6FyksK1zMxP/9585AoHoarL2dKH7/TcjxEN31GAmZadlg+TgER06EpbcbBfs3we10INHViSg9oa69BetppeI8B/KKaOHi0XC68rBz5y5Yt+/Af9JizWkVh8msg8u0oyUXte2Oj3dCTYuUJWmD414+Sc/FevU4WB76WSF03zXorjuEO98lmeTkGvE0kB6kVBz+sRdjz+0PwygJ+MNwaRXGvvgTZO3JyiGB/lFTsGvRY9CcGdcqW/UiRv3tv2Gm+zno0k56gpTHxTfvwvWXpOEp2sXNAyLcx66RY03rWz6ByjjM4/WD2Xvg6KL1AoF+tLe1oKOjfZWiWD4fIJdf7POhSHKP5Pb7sX3LfvSm3ZCsNtpXHXShhu7JJC47wSUzeqN37EWIectg72mFJiukaRWd518LzW3NXMM7dk25CsM2vARLuh2qiD/hEazmdZsX0WAXZs3IkG/jPmB87QKjlbH15WVwbthgWOvTIkEIDpnuvHXrVj/j+JXBxGg+SZmfV1gAD8xuJq1dqN/PmzvyPqM9JiFaWAnPR1sx4Y8/wvA3n6FrmpFy5hngjT3gNZESutyhgxiz7GEUblqFtN2FpCufRS/zZ9bl9CQJxpqDpmYqKlbBcQ63E1j795Xp6dMuwF2/+S3GTz4PmzZvPm4J/STChoZGg3mbmj7xi/r7C8slWlCwO5MeF9m3Ha0d/M7mPOE6VbbAt3M1SupehSXoh3fveuS0H4CUpMoxdlGHpliRd2gbhq1fCkdPM0o2/xWupt1G7ELkSwLUE2IyWpGWoadR5oFkIxgUpu11m17ZUrf5punTpmEymfdITwAffLjdYPbe3gCFSJ8hC91ut1A8erZJ8IX1INMWF5hsQ6KnESHSvcmifIYFTVz4i9wHsqM9k6MKdq2BxlwoxsBR8c5TMCfjSNlzDcuWEqTOzTGukWRjHl1oWqsZsaSEWFRlzuPi6ImFJv2lZS++4KgeM+baPBbYMYKpP3DISGmGoOBGCnAipR050r1TeOypFbw0OaK7EAtHEUvRmDbps7WnkGeDfF6TTxTRgmgyrKpnwAhgeub/ga6c0S7mNYk0R1LNqCd+RWEU29dw6NaHHvr5K7fcsmDWmDHnwMrqv9ffKwAZHQIh8Je/9upuyrufnlJFz7nVVIruGdljKBJNMwEne95wCs8hdNOptxZ13XR0H0mwiKiGoO5tOHTwqod+8bPrKioqZ1O/Oru7uw739PQ0Uzs7KP1aec27HIFTbVlEIxHSpa4ZaUeRaCWqDF3TjsfDhZvSSWOrdUk5tT6lcT13ULFlFM5xyoXJxaxjQKUleGlH8qjLMTKxlESy9Lje6iBde8p9UUEtPX4qc8E2zAx2KwUx85AuniVkEZqEazJ+OqfNQ9xbDikeoSvGM+QxyJVFfApQUjIGKRFD1DccrZcuRMrl5TnVIJeMlYXfqLDJaQglJnBTlibNp9FR+zwX9XcLgCp8CrkjX1Rf/aRxSiyzyEG0nC7yeiwES8iP3Xf8Dp6DW+Db8R7zXwuUcICkkjRiM5MSvEaq6Km9DMHKCSj/xxLYAu3QRA5MJbMZRzYA5tg0g2AM+XUE3cR55IwDFJvX1YvuRBBV1nxWmCOYjw7RQxjcal8vpPwCA6RmsaFg91paJorGb96L9kvmQ2HtqIQCBrEI0hDsmsijIiJDuhv3omrpL+Gp3wLV6oAWDhmubwAk7Zu4gUXDGRIW0V1gQAXQYx4KgMLZ6zuw2+/HjFJiqRnPm74V5KJ8UHv9jBtSut1h7Lpo9ubt3Yyahh2GJAucMxWR4lFQbTl0zRRs7YdQ3LYfuTyf07zHcOMUyyo94jc8IlM4MvZEHenvAKspI4USO1oCOBgdVPqc0b5osA8bP2nB3aVjAFFjjiiI4ECS97LZubgIVNGyMGXYVYA06b1wtx2Ge90rx4rcgVgU8cov07JyYv9Iz+QCQddeWxgjRmbbI7RbZw/Wq0P18KUtjW0f7GCA8w4KVcUl01g9dHRAznHD5GJQisVmd59UZlTvKi2jkk2Nv8b/lsyQrdn8aDo+vdADTE4K6Nw8qJ0dGFelQjTIBcE0NiDdFsXmIXv4EmEZuPVjbIv0YnZXEJgwBbjoYC920WnSTi+SFpdoP2c1t2YoEWNlWraTdpRJM/0aw++EpRmXpoE8oGqwJMKQ/Z/gnIoY5szN/CzBGPl4Lz4O6tg5ZABFCbulEU9t3ITZtdOYaQnytluB5e8lULetDWVcc3/Iiv64sI7NkF4iF+qGfJKOd0EhvIUUY5oxqUmDgFzWBDzOOALEWnOxCTdekekJimpoP6uIfc1YkjjN+PvCZxOtKbzy55dxR3klZot8yMoHTp8E77kSbp+ZhBpLUPxydAcpegm4X5Quov0Io21h1IzcCBKkkU9z6dmUkygshOGKThYrz2ywwF6gMbmnjdTT0wO8+Xd8eDiKZ4b8LQvuYGplA26zL8abN9+MCZUVXKBTNwAIhcPiHkUlx4eV8FIDoDrQ5yFA2cgYJ0jZKF1RCJs8hy4yEJoouFj2HV59CN8N6IiclddI6JlNy/dgbu/jWDx3FuZXVmmwki+ae03w5eqIJbJeqB8PdHBnIZU+1ufKEi9snKON/ileFhru0bBmDbDyXby9sRn30Bkaz+p7MvS8znfacMO+Zbhy0nB9kbMgdfH7qtmbR0mQz9qW+d5IzmbTMaCmgQzxqazAuhZUbOjuBDZtN0PpSvUvW6LXbW/Gky1JrIh9hfb8GXkRKMbbHkxhZWsDVtoOayOKLFrNB5twni8fEwud8DErOBlnkt0Oj6RIJYpFMrJCKqlBTaY7WdEEWMql1RRi3VGGWgC7/OH0tu4kdsY1HIxhaI4v/aaTWEhMw+FAHIcpeVaIZrkbxsjhHpTYmTKLyrxPpXIzzzdkatVUR/vDHWm8JVo2/Tp6gjh7x1d6lcueTdlkSFe5Dee5bOZ5hV7vhWYblTVTty6LdJHOakwnNHfl/Z5UahEZJRGKxnYH+8PLW+LYzDTYLvwxiTOQD04XoABUk4vbp1TJC332tCUUo1YOoyCeM7bKOWo8ZJcHZlkZJNGOJXpN10uNBzgcuan4RE9/z821kb3tObbUJ24nKykViT3N+HB7Bx7wpwV5fw0AySUTH/zXy56Yv8AqoW8ton1RrK8D/rLFC8VbyqogbrTtBTZVE88Wst1pJk/xRoYn103mVNDT149oMIJZl6RK512JUuPdBa5ix0ZcsugXOOgP4vEzCdB8qta7eLTrrivmmiR0r2QCi8LhFARCRtRYVWiZIjetmgwm9eWJB6OZ1kOPJQ/9ktPobttsNpQWF8Ge40IgJDOnZntgDOza8xm8k3AXfcB61gF6TCi+fGryOpeyRrzome1jcvFMWLLdabTx0yrrPUcKi66px0+/uwM3XNSIHc4xeKXocqwomolmWzEkboR4BOfI9eKTDiviyWMFqLDivDmYUKFg1lkHONLFe89IFB+VJ6ZMv6T5iJMAc6BRl9ktaSy66gBqzzmCeEzBNy5swX9Mr4M7HUJUcmF1/hT0y7SkeJPJYUcwZoU/MKjA4HxTJsNUMwK3mc8mQFEUTa3GTVXVWaozZx5e+PuArgBLHfqqUCrDCqKoHtmLQL8NG3cXUbfK+Pb4nRSxexiUJkQVNwIcZsakYpHRn/agpT0zlzEnrejwAXOnYzY1Q9lZI5l8GefOrDVNZmxFhToUD3zDNMLBZllNKiUhJvVYmjRIx1XCYYtbMuv6zImd1JmSvqGhKvlBpMJqlWMmb9QfLUwGYmlGqUWRkFCKc+ubWhznjFLhVrSUhapNgLy4FnmjXtUv2xPGkjMB8P8FGACC2PTqexqHQAAAAABJRU5ErkJggg=='

EMOJI_BASE64_SEARCH = b'iVBORw0KGgoAAAANSUhEUgAAADgAAAA4CAYAAACohjseAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAyZpVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADw/eHBhY2tldCBiZWdpbj0i77u/IiBpZD0iVzVNME1wQ2VoaUh6cmVTek5UY3prYzlkIj8+IDx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IkFkb2JlIFhNUCBDb3JlIDUuNi1jMTQ1IDc5LjE2MzQ5OSwgMjAxOC8wOC8xMy0xNjo0MDoyMiAgICAgICAgIj4gPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4gPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIgeG1sbnM6eG1wPSJodHRwOi8vbnMuYWRvYmUuY29tL3hhcC8xLjAvIiB4bWxuczp4bXBNTT0iaHR0cDovL25zLmFkb2JlLmNvbS94YXAvMS4wL21tLyIgeG1sbnM6c3RSZWY9Imh0dHA6Ly9ucy5hZG9iZS5jb20veGFwLzEuMC9zVHlwZS9SZXNvdXJjZVJlZiMiIHhtcDpDcmVhdG9yVG9vbD0iQWRvYmUgUGhvdG9zaG9wIENDIDIwMTkgKFdpbmRvd3MpIiB4bXBNTTpJbnN0YW5jZUlEPSJ4bXAuaWlkOkJDNDI1OTlGMzQwQzExRUQ5QjBFQjEzMjUwNkNBQ0QwIiB4bXBNTTpEb2N1bWVudElEPSJ4bXAuZGlkOkJDNDI1OUEwMzQwQzExRUQ5QjBFQjEzMjUwNkNBQ0QwIj4gPHhtcE1NOkRlcml2ZWRGcm9tIHN0UmVmOmluc3RhbmNlSUQ9InhtcC5paWQ6QkM0MjU5OUQzNDBDMTFFRDlCMEVCMTMyNTA2Q0FDRDAiIHN0UmVmOmRvY3VtZW50SUQ9InhtcC5kaWQ6QkM0MjU5OUUzNDBDMTFFRDlCMEVCMTMyNTA2Q0FDRDAiLz4gPC9yZGY6RGVzY3JpcHRpb24+IDwvcmRmOlJERj4gPC94OnhtcG1ldGE+IDw/eHBhY2tldCBlbmQ9InIiPz6a40hqAAAatklEQVR42sR6CZhU5Znue04tXUtXVe/VK73QdNNNNyAgAaEFRFRERHEkQY3BucmIM1EnamImyXXmJo/x3quJmXG8M9cluMWYGMWJC+AGxqsBlK2haXqH3peq3mpfzjnz/qeqm25okdzM3FvPc56q7jp1/v/9v/d7v/f7z5Hwn/xKMwIGFXlRFRWlJpQ7jKhRNZTzqzwe6TwkHkEe/bKEUwEFB7viOKTIaBiN//njS//RgOwyL6qiJNuIKquMlekpWJSXiaKsTBRkZyEtzw1kZQDOVMBi4bmcQTQG+PzAgAdoaoXa3YvuAS+OjUbw2pCKfxuMYZSL8v8HIFcdDhnOLBkLrRKuyrbhitICVJYWI6O2GigrAXKyATcPWHloF56NEgIONwLNrUD9EeDkSbR0jOHhM3E871f+HwEUoJwy7JkSVjgNuKkkG6tnl6Bi0QJgYS1QVAikZkz5gZhY/EvATV48EdH2vuT7aWDPO0BjE15oiOBvPDH4/9MACmCM1Jx8A24tcmHLvHmGqpUrHZhfPYaiAs7ezJPUJBjlz6CFARgdA9p6GXQTLxkBdr0F7P0D3v0sjJs88YsHKV0ssEwZCwoNuKe2GH+xak2qc836RSidQ85FjlEiBghKu7gIXfRqMie7mZN+O/rsFWhMXYI/fKDC/MKzrx0K4auMpPJnAxTAsg0ozDPgB5eUYtv1m5zWNTesgauUXBw5zBl8yEgF/0OlagwuNEmV+Ey+FO8pa3BMrUanuQKqyQCJ0Vz+s60wvfbKDz6O4ZGLEZ4vnFoqaVIk41vV2fjJ5s1m98ZbVsNReR2jNQp0Pc/3Nn2V/9yXDw40SlXYLy3DXmkNGqR5aJHmzDw7ApSDIdR9d1nEU19/WUMUh7/s+saZ/plpgqPKhH9asRjb7rq3AsUrv8YzqxixPTx+zahF/q/BhWHRAX0mXYr3pStRL83XIzbja0qE8mMdKPE1YbG6H+5VwZR9TfifpxVczbqp/EkAM4xw11jwm1s3S6vuuH89jAU3Mc+IpvNfgeGPEqv6J4ITAI5Il2CPdDU+l5boABWhJBd4VWjNmIcGrFL3wd13ENm+FuTGvTBy/EgFXUEV1p45ik0tCl6/aICZRtYuK9746780L7v5O7ezaq8BQj6gh+DGj+JL5jT56qNJOSYtwAfyWnws1eGkVK1T8UKvOVoL5mv1uFL6EJfJB1EhNcMSH9e/G+GCdrBkhJPjm0nVulUsHS34Xm8cvw+oiH8pQJsBhuoUPHvHVtOym+//K9qMy7hUHKDnSYI7fkFwUdaHBqkG/0dagd3yNTiKheiV8i8IqEQ7jRqcwDoCutzwKaqlUzBrYyIpMUJHM8xyk5HFadDM2YWhY+prWoJAMYKtYBSrK/CVziNY1xLFrgsCNPBXs2RsX70MN3z9/lt41a9Q9plng698IbguqUin227pGvxRWq6Lg3oB7mbBg3laAyO0F+sM+1AjNcCuevSJ97Cof9QOHGpgYe8AhrxMc2ZWJs3ClSTRzZtpWkkAD8+V5ARQI2e+eCndTiPu7FWwK6BcAGCWAbnVWfjRt+5dCSmbV4zw7ACBjeybzLc4Tz3BKH0krcIueb2eU4PI+UJAKYjogFZIf8S1hvdwiXQMbpW2ZISL08Oi3UxAJ4DTnUBvP0WZ66mZLZCsNsipNKqyjFHvMJqeHkcbwf8NSTUyflZ3RBQrGcVZ+Vh7qgVzAkDLFwLkQt2y9kpbbtGy9SR6XHfLGNuDYS0Nhw1L8JZ8nQ7suFR7QXEQtFtE5d5o2I2V8n62DAyJT9ULdj0B7acnaDudiFg4mgRks8HgdkG22qHKJqgGHiSixBBJ7mKkDHRgz4eduv2rW82AjycMusopinWorkbq0Q5sGlDw2IwAWe9S8lOxecM1vIIxF/64Fb1KFh6LPYL3TdXokGefXzmNCTuVhQCF4ThWax9info+anEc9pgHfgI6xTL5C2GWCayLf/tEQ5RigWy3Q84jIJsDqplOyJSi67wa8EEZGSY3k3phMDCS5GVOCUzBAH73hhcFs4Dc/ET0xEuAnMvqlb0PN9pjeJxicx5RjZnAooxiV/WpeXehOb4BQ7ILp+IWPK1OKbRSssgSWPF4EzJb92PxwFuo8B5AaahLNwWKHdhJqn1GZncxQh5SUTWYIVmskDPTYChxMmJ2aElAOtlEMqmJv2RGUuLf8VFvgof8rI6N6oPL+WXwN47hjd/H8c1vJiIofiryNL+Ac8rHwhNjOk1PnQew1oRFzbXXpz+f9bdYqyXs2fiEWeZnq1nR5Tvv+Fsw7X0Tzt4+FKW6YHHOQlb1NkRK8xGIxeHp6cbpgSPwKH0YHjsOhc2eXMi+Ni0bCmcjaeo0QDMVdYkREwmgDHsSKJiH6vgo4tY8mAuK0HiyA0dZrZZSXCKRRARtJEFpKWzuVtQNKjMA5HC1WnE50qUJMeER86EOn2FryjvIObEL9b89iVicmnzDdixdfwPyykr1cyPRCCKBAJXNALvLNamhHaca8M4rL+HN556Ff3gQEiMAcwpBqBcuoJyxbE+FxuuqvnEdoP5vUjeemQvDUD8+2hdCDVsyWlOoSRLMZhaZP8A6moCn49r5IlPod+TBJUUwmyU6X+3BZmUHMpVnsfNpql1DPq6+6yVsuO1WRLlsn+99Fy88+hA6O84gFAkhyslIXG0L1c+eYkbN0stQeulKzNqwFZsX1uHYy0/h1MfvIppVRDXLT0bwwi7Z4EyDFg5Di8f0SArASiQMY14ROtubceL49Cjm5FLgsrCwpRuOcU1U0ikA+VfqtwOP4XbFg0yJldVsRIwU+/HDTObCbXh49/+C1WrEi48+jD2vvgKvbwTW3FlIcWbAmJ4Po8nEVdQINozxoB+nd7+L0I6nYGUkajZuwfJ7H0Jx3ZX49Ikfw9vDNq5gzhfTFInc0wXG6SRVvWeDOz6GeFY2ZFL/wIEwLrkkwWKRh+np+lFs7oagVv20jkgUhZpIMyPGYmO0ITwWwA8faqeh/W/4yY4daD36R3zr8oV4+fkdXKZKFK7aiMzKBUh1FyAl1QkjldFEIbGmZcBZUILs+Usxa91fwF42D0defR7vPPB1OHKLcO3PXkS+y0ZP28hRDecloET1lJT4pPiIsiEJT6bbFyKJRaFEo5Cz3ejgVM90Joq9+JrEQW4u09SMqplavoBPyK4WZf3R8D8efApldd/GnT96CG+/+Ax+eNtmBNMKUFR3FUFk6rTRDxGFCeHgoZErGic48Z0tfxbyr7gRUaMV73zvGxjvOo2rHn4auQ6qQh/tisGYXOGYfkRd2fox8bceRWvqlPJEqgb8UB0Z9CEGnabJFNWnUJCv6+LCGfpm9IsdLZiDeOXJ1xC3zMX2//r3eOulHXjivu3IWbQCrpI5ULmCmnrx+xBaPK6Dzqj9ClKrlmDvI/djrKsda370OJzRUWg+L2QuSDC7GI3feARH734aR+95Rv8s/idHw7oJmIy2AMikUySjXuGbWV+DwURwdbPC7EqRUWU8p4c0FBtRU1mOKwrTxvHLX0Xwk1+9gcZDB/HYXV9Ffmk5TFRAVTJ8gTAkqCUmKhE8pwBNmEXp7Cgak8SS6aYzMaPt7V+j6vpb4SDNuj54A+GS+Wj41uMYq74EiimVpcWOYHEpRkuXIuv4XhhjYaikJZJio8+BvDRSQiMDo6iuIbD0ZJ9JwWmuR6A/hGfC2tnJynRSTYNeKC+/0I3r73xQV8Nn//4uXLveDbNwG9rMiifHqJ6MUDijAL7iWozzCFIppeR3UxdEpQo6yqoBRyb2P/kTlK/bjOLS2fDklCFYUpzY9lWSBz8HZxVjcNF6LhzparFOX1JGUbM6KGq0fN1nbZudwbbZkaGoSJumot0KOo4cw9DshfNz779tK5579FHUFLVh6bL5+Pykct6ugXAbEgceL1uIgUXXIOguRUxQSVyM0m4bPIPsI+8ireUzPc/0iAqQjELmguXo+eA19B07gNot30T9zp1UAKISDNGmbzP688sT44n6OcEIQVNeR5Vp91JS0NUVmcxBsYnMf7n42cV/DU8GglWhxetB94ob/woROuCDbz+Dm79WypqnzGw3SMe+ZTei5cb7MDp7HnPWpkuxOBSa5/HiSrRtuhs9l99yVoT0n7KIU3FTS+fi5BsvInvRSsyJeGE7eTCx3XiOMqSMDuq/1U23wXj2OiK3RR7S8g0NJqKnt08UXFYsOz/ap5eJOHyubJu/bsMmHNy3F0U5QWTMdkGncdITTqWlZ8Fa9NTdqPs4QzTReExGVxXn8J1r07fsGgws2cgBImdP4GCpRXPg6WhBYHgIpTULkXF413SADJjBF0IOWaAJgRFSaZDP36phuAKkM42UXgoouuJI0RL752fnHFYwt3DOnFJ3QSE+efN1LF+9QC/ENpukr7oQD8FTISYRVw4nfgNpOh3YeVt1wtPyZ/2XbkAoa5aeSwkqqTDa2SGYzBg8eQRuRjFv/+uwdPYkQDIK1r5uVL78D7D3NkGlMCU86Tl1UzCD16C30N2MmJ9YA4NhsjKczUG7hEp3QVGB+GO4tw0lG/kx3o9UBtoo/F6yfRFAx8sWsVY5KeEXsR9JgDG7BaMVS2H99LVpuwIp9JWepnq4N29DzlgvFvz8GwgVVelssfW3IWXco9P9bAmUp6WocE6CtrEQx4if7S5m0kNjuQGls6rnG4PhGA2sD+lpmu642bbpx3jkLMX8+XP+pN1rEclAXvn5g9qd8PX3wEwnZHakwzg6gPTQuB4ZEbWp4CYif76My4kUV5OWTdVtmyJuVk07TeztONIzEAqEIMVHYDP06yqW5gScDiHL4bPiNtVZTMkHMbyiJdz9tENsSLGpVafURd2GURHivK5MATHQjjEeBGXVD20mOsanb5pJ+saMqgObuLQolYxmMHmvcVo3oYkVkmRJH0gN9ZJOVqRQj8R9vE4PHYWSUFRDODAJaoIORo5l4SAmOcFCkfAT38f4D5sWQwrlLSIAi3ZInuDSxIlfkMy6YeBvfGMsDdFp5kEMosUVoZr6Ib4Kkq6hIDwGCYNTWSbm1z8y0A+HMxXjITuGhoIociXGLyuRcPgEC7oo3KSEta8VSvVSCAI5eeF0Y+KGp5mHUZoOXLwpPCcj7kVaYZEOMMw6GaTlCFB0zOS/sH8x4VTM9mTHK01Wbi0chOqn9wwHz9/DF2WDv2PV0eufEFrPEIF4cUaRMTJ148LYqqCts/FEyGSQrPG4Faeah1E016lzrrxMYmQUDuKHYnMh88wJgg0hnYbZNqW70amoTt9tV0UAwnHYOk9SEKjfnJSFs0nje6DpCFLzSxAeH0HY74Ms9h2E0SNgWn/61JGEYzEk6t3UhlhiGybzehpbM1smGZKcyCk2Kd4w3j73Jqkc0tA41NfdIyxZFZvVfX/wT9omsZPlzk7sjThdaahkuBacOQATx40JCqqJdyUJUsHZ9zjpmXZqP8yeHma+TAFQmEoJA+7v70LO3Pnw9bJpJrc0gtS626B1tiISUzBcuwbt2x+Dd/n1Z21fEpwxPRPGvnadj/MXJFqlQUbv6FGMDCn47XmCxpzubGtsbuhqaSpfe9PN+P6LT6KrXUNRGcOfqmJ+rRnxVjfSc3MoDFHYGz5BmskOz9xLk/UxSUuRWoJdSdeVfuoI0mmYFaF2Sd5K/Owb7CMtw8ihwT7x8r9AIUC/MRX+5asxungdQgVU3bgKZ+sBWFm29F9ykjKF0MhEN3UxVMPDWHE5ULeSp3L8D99nfziIfx6Ko/M8gKM8YWAs/m8f7Xxl0+0P/gOyS6rx5jse/PU9jL+aihWrS9A5koK4fwyq2QaNnXXmoV0weboxzBoXzsiDwkwW4GSGM8UziLTmA3C1H9Fpp+qtU0zfdiCx0Pv5x8ieuxBmekyxd3PyB79DpLwGhrExpNV/iLy3n4K94zgMAY5HG4j0HJhsVhh9HkgdXexOYpi9SMaWm1VeA9i3D/hkPw50xPHfFe0LNn69wNvv/XrHwFf/9u/cW+99AE/efzu2bJmNrNJCuC1GFObF0NI5AuSl6t2F2BBKbTkEW3ej7m5idPcCoJF5YR7pI+/9iIt/EJQWIQWp34ozEyOyGZ7ONly9/UF0fvIu+gIxpDVxMd74Baw9LSxTXAgRcbZNam4RjLRjxvA4NLbwUjCAwhJglOqWyXJss6jY9zHw+htoO+bHbcPK9PIw5W447Q5TWxoac2XnOC+//o478el7H2GwdxiXri6mg4nCRod3soGD0w+prIUqDaAiJhOLwTDuhWmoB6aBTsjefqiciCIEgt13xO7SWynvsg0YWXolzvz+JVTMLkXpqg34+PGH4PcOw9FRz+hQVGi9NBoAKT0LJiqsORqA1MvOf7Afhe4YbqT9XbRCwpE+E2ryVbQcVQW4E4fHsJngmr/0Dm+OjKyVRa6D/7TvcKnYBvzOtSvxvQcqsfjKYk42Ii6GhhYJUkEx4uw6NLbTmjQhm1qyPGgJ18EvBtbehlBhGWQuhoO+0vvqv0DqPoUNj7+CeubeH3/9S8QyuYBULLE5bCBlDVxMecwLddgDAxW1mK3i8hXAgvlANjPm/eMG7DlggN0Ti3a2ay8dC+LbTLHQlzzPMHHnFUHNF2kbbDq89abt90ql8xbhFw89gcqSFOSUM8E1LlNTXG9eNdJNEVsYzHAhIFrSH07UbT0fSVNn4wFkfr4b3p3PINzTiqt++ksMnTqGT575OaJ5FTA4XTCzOzeGfZDEDYy+LthVH2qqFFy3EVi/PnGDRew9dZwBdr8roe+EEvX0aa8x3X/HAlImEoFzH9W+DKCW6BKbw+2d6khP85qv3v0ACqqW4uH7fs4mK4jaRVRRTUZXKy0d7YLmyNCjpaln9wcSBiXh/i3BMSjePrR/+iFLhoSrHn4GoZEh7P3pAwgZGTEumDzILqK/G5bQKIpzo6ijMm68Dli9hiWqKLFYba0E9h6wazdLIseqroB6RR0WrFqOrXWLsdUSwC2sYntJ076Legghi6tVKeNn1339a/fd+cRzeHnn29j384dQktqNK66rou0pQE+vEWoao2gRoiMl3L3otvUblBoigXEMtjTC23QcRV9ZjWUUld7jh/HBT79PkGOi0wGbErjdQEUlD4rGrFmJoi08ZR+n2tzE2lYPnPa4MEYfftumMaxeRZ0jVTNykgWX12k7Ctz9A3zy4RBW0y3FL+opC/0JCw3fX7Fs3o+rb7/HlDVvCU7u+j1Ov/8bWKIcXUqD3ZkGs80OmbkjPGyclA1TWMaGhhBmvcwor0Ltlr+k4tXg0Ms7cIbyP6sghiLmVSENRF5u4hEvAZYODr0MptjvPHmKn72pCJsLoKXlIMoxYgO92Fxbj6/dxN9knPOQEdvbZ/4VePRXuKNNwXPnlgrpQs/IzDHgmkKH9Gjl2g01VTdtgyN3FiPTgIH6g/A0H0d0bCRphHm+yQJbdh5yay9F3sKlsGfl4fSBT3Hit/8bBeZGXH8DF21W0tpx9b0eoJtp196WuGfoDaYjZnbDThGz57iR4nDozAhQlXtb2jFX+wR/9x0VhRPRm/JoiZdO5t7vovXd01hCNzP2Jz3plGWEq8yAb6a7TLfl1i5ZQMpJ2ZU1sGXlwpBimbyKTDsWo33yM696jxxE32d7kKa06G6jkr3s6GhiF6yXBOggII/fBn88HaaMAtjc+bBlZMJktSQ7JEW3dInbhEb09fZDbtmDB7cHcGltctJTI0Vq//ZXwCNP4b7jUTw+NYoX9YySg3ZgqRU7zA7LNwpYjILegUS+sS5KsonGXjTJAUTHBxEYHEEO86SYRZnuCl76g0EvLVrEgUDcAVO6G9ZMNyz80uJ0Jto0fWdcmbEll1n4/bRz3Z9+gDs3dmPztQlVnRZFppTI03sewJndrbhkUBE3yi/wINC5r1wDtlC5tp0ZsaP8+tuRUVJKD8nmq+0UDvzjgyhxR9Apng40uWCn/AXZlTf5mRxRB7t3F0xlqXCkpiLTbkuI0cStMoV1T1EntpARlwwz3Iuh/aMnk5xuNLV0Y8RHcco45ySujYv5fN3VKD7UjtsI8ImLBmhlbZ/twh3/5XbglZ1e7HrobmSWFDFXShDyhbGoJoZt24B/fpLNcerlyJw9O3Hb65xJCsqFwwlXLkkaLIY4hk0OHHVWIkIWzPe1ojA8wM7DoIOd+lujkWUnMxutnWb0D0WR5UxuMGnTnmXRn8j4zZvY3tqBpyN6ab+IZ5YYh8oVi7HKXZ14AGDRvEosL3PD2N4AW/8HuPUWVd9l1lNG5I7YmD3vYE/JxNiwtBv33HgSyysHMQo7Xs+4HE2Ocpy2FeKt7DocclZBnmHTR8BNzUhHfyAdrVRaX2iG5GKBSKcyX12H6nwDNp1X6Gd86JXlqdiAH9bMxqUjg8DHn4jbVMWsWUUY9QVpr/r0fRuxLyVuhoyby2FNT58UiMnFZXO4aXknNq9pR152AIvLh5GfEcDpASfa41mchaa7nx5LHpxxP3Kiw1Clc9ae1PYM+2GP9GMOa2eabfouxgQalx04+CmKe0N4gTxSZgRI4yHVWPDdusr85+YtX7pyxDQPR8/MQihuYpHvQQftxUBfLzp74zjMXvFYQwqGukKwFs5GirjFNuUuVDQuo7ZkFLeva2F0ZASDZn3xinPHcUP+SbozE47FSxNbcIKekoqKYNc0gCJv9X0XdiW+M72oqogjzZHYrpgWcK5rWjrw+WHkN/ZgJwPdPyPAbAOWXHFJ5avrv/uwPWDLRMyS6KStzLuU/BIojiz9ERD9Rgtna3LP4VJZEfH2wFZQpk9USpJLVSV8/cpW5Lr9CATMePz1ech2seFNDyPFSfrSRb46OB+akEb+rjTYjaLw4HkRNFJNw4oCz0AA2eYR5BUlojW5CTdx+4KRPXkCUnszOj0aPp4R4BwzNq25actVPtkSa6r/XDYirGpi60BVJBPdvyXVCQuLuohYlNzyn2lEenmVFvONSrIaVp3uTEUYAEXVIqwDY8urhiSXLS7F47LitEfV3PSQajJomn/MFP3HY8tiJ1DKiqOqruhY5LLREz6TGg9pkiQybfKQZDmkxOPxkCobxjsHpLmlQnMlzZEixSWFYY/zSL4XuCW15zTWsJVs/XcBBgBgfpzLi+mf8QAAAABJRU5ErkJggg=='

EMOJI_BASE64_WAVE = b'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'

EMOJI_BASE64_DEPRESSED = b'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'


EMOJI_BASE64_GOLD_STAR = b'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'

EMOJI_BASE64_HONEST = b'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'

EMOJI_BASE64_ILL = b'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'

EMOJI_BASE64_ILL2 = b'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'

EMOJI_BASE64_KEY = b'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'

EMOJI_BASE64_MASK = b'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'

EMOJI_BASE64_SALUTE = b'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'

EMOJI_BASE64_SCREAM = b'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'

EMOJI_BASE64_SMIRKING = b'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'

EMOJI_BASE64_WARNING2 = b'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'

EMOJI_BASE64_WARNING = b'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'

EMOJI_BASE64_JEDI = b'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'


EMOJI_BASE64_HAPPY_LIST = [
    EMOJI_BASE64_HAPPY_STARE,
    EMOJI_BASE64_BLANK_STARE,
    EMOJI_BASE64_HAPPY_LAUGH,
    EMOJI_BASE64_HAPPY_JOY,
    EMOJI_BASE64_HAPPY_IDEA,
    EMOJI_BASE64_HAPPY_GASP,
    EMOJI_BASE64_HAPPY_RELIEF,
    EMOJI_BASE64_HAPPY_WINK,
    EMOJI_BASE64_HAPPY_THUMBS_UP,
    EMOJI_BASE64_HAPPY_HEARTS,
    EMOJI_BASE64_HAPPY_CONTENT,
    EMOJI_BASE64_HAPPY_BIG_SMILE,
    EMOJI_BASE64_PRAY,
    EMOJI_BASE64_GUESS,
    EMOJI_BASE64_FINGERS_CROSSED,
    EMOJI_BASE64_CLAP,
    EMOJI_BASE64_COOL,
    EMOJI_BASE64_UPSIDE_DOWN,
    EMOJI_BASE64_OK,
    EMOJI_BASE64_COOL,
    EMOJI_BASE64_GLASSES,
    EMOJI_BASE64_HEAD_EXPLODE,
    EMOJI_BASE64_GLASSES,
    EMOJI_BASE64_LAPTOP,
    EMOJI_BASE64_PARTY,
    EMOJI_BASE64_READING,
    EMOJI_BASE64_SANTA,
    EMOJI_BASE64_SEARCH,
    EMOJI_BASE64_WAVE,
    EMOJI_BASE64_KEY,
    EMOJI_BASE64_SALUTE,
    EMOJI_BASE64_HONEST,
    EMOJI_BASE64_WIZARD,
    EMOJI_BASE64_JEDI,
    EMOJI_BASE64_GOLD_STAR,
    EMOJI_BASE64_SMIRKING,
]

EMOJI_BASE64_SAD_LIST = [
    EMOJI_BASE64_YIKES,
    EMOJI_BASE64_WEARY,
    EMOJI_BASE64_DREAMING,
    EMOJI_BASE64_SLEEPING,
    EMOJI_BASE64_THINK,
    EMOJI_BASE64_SKEPTIC,
    EMOJI_BASE64_SKEPTICAL,
    EMOJI_BASE64_FACEPALM,
    EMOJI_BASE64_FRUSTRATED,
    EMOJI_BASE64_PONDER,
    EMOJI_BASE64_NOTUNDERSTANDING,
    EMOJI_BASE64_QUESTION,
    EMOJI_BASE64_CRY,
    EMOJI_BASE64_TEAR,
    EMOJI_BASE64_DEAD,
    EMOJI_BASE64_ZIPPED_SHUT,
    EMOJI_BASE64_NO_HEAR,
    EMOJI_BASE64_NO_SEE,
    EMOJI_BASE64_NO_SPEAK,
    EMOJI_BASE64_EYE_ROLL,
    EMOJI_BASE64_CRAZY,
    EMOJI_BASE64_RAINEDON,
    EMOJI_BASE64_DEPRESSED,
    EMOJI_BASE64_ILL,
    EMOJI_BASE64_ILL2,
    EMOJI_BASE64_MASK,
    EMOJI_BASE64_WARNING,
    EMOJI_BASE64_WARNING2,
    EMOJI_BASE64_SCREAM,
]
EMOJI_BASE64_LIST = EMOJI_BASE64_HAPPY_LIST + EMOJI_BASE64_SAD_LIST

EMOJI_BASE64_JASON = EMOJI_BASE64_WIZARD
EMOJI_BASE64_TANAY = EMOJI_BASE64_JEDI


def _random_error_emoji():
    c = random.choice(EMOJI_BASE64_SAD_LIST)
    return c


def _random_happy_emoji():
    c = random.choice(EMOJI_BASE64_HAPPY_LIST)
    return c


def timer_start():
    """
    Time your code easily.... starts the timer.
    Uses the time.time value, a technique known to not be terribly accurage, but tis' gclose enough for our purposes
    """
    global g_time_start
    warnings.warn('The timer_start function is deprecated and will be removed in a future version', DeprecationWarning, stacklevel=2)

    g_time_start = time.time()


def timer_stop():
    """
    Time your code easily.... stop the timer and print the number of MILLISECONDS since the timer start

    :return: delta in MILLISECONDS from timer_start was called
    :rtype:  int
    """
    global g_time_delta, g_time_end
    warnings.warn('The timer_stop function is deprecated and will be removed in a future version', DeprecationWarning, stacklevel=2)

    g_time_end = time.time()
    g_time_delta = g_time_end - g_time_start
    return int(g_time_delta * 1000)


def timer_stop_usec():
    """
    Time your code easily.... stop the timer and print the number of MICROSECONDS since the timer start

    :return: delta in MICROSECONDS from timer_start was called
    :rtype:  int
    """
    global g_time_delta, g_time_end
    warnings.warn('The timer_stop_usec function is deprecated and will be removed in a future version', DeprecationWarning, stacklevel=2)

    g_time_end = time.time()
    g_time_delta = g_time_end - g_time_start
    return int(g_time_delta * 1000000)


def _timeit(func):
    """
    Put @_timeit as a decorator to a function to get the time spent in that function printed out

    :param func: Decorated function
    :type func:
    :return:     Execution time for the decorated function
    :rtype:
    """
    warnings.warn('The _timeit function is deprecated and will be removed in a future version', DeprecationWarning, stacklevel=2)

    @wraps(func)
    def wrapper(*args, **kwargs):
        start = time.time()
        result = func(*args, **kwargs)
        end = time.time()
        print(f'{func.__name__} executed in {end - start:.4f} seconds')
        return result

    return wrapper


_timeit_counter = 0
MAX_TIMEIT_COUNT = 1000
_timeit_total = 0


def _timeit_summary(func):
    """
    Same as the timeit decorator except that the value is shown as an averave
    Put @_timeit_summary as a decorator to a function to get the time spent in that function printed out

    :param func: Decorated function
    :type func:
    :return:     Execution time for the decorated function
    :rtype:
    """
    warnings.warn('The _timeit_summary function is deprecated and will be removed in a future version', DeprecationWarning, stacklevel=2)

    @wraps(func)
    def wrapper(*args, **kwargs):
        global _timeit_counter, _timeit_total

        start = time.time()
        result = func(*args, **kwargs)
        end = time.time()
        _timeit_counter += 1
        _timeit_total += end - start
        if _timeit_counter > MAX_TIMEIT_COUNT:
            print(f'{func.__name__} executed in {_timeit_total / MAX_TIMEIT_COUNT:.4f} seconds')
            _timeit_counter = 0
            _timeit_total = 0
        return result

    return wrapper


def formatted_datetime_now():
    """
    Returns a string with current date and time formatted YYYY-MM-DD HH:MM:SS for easy logging

    :return:    String with date and time formatted YYYY-MM-DD  HH:MM:SS
    :rtype:     (str)
    """
    now = datetime.datetime.now()
    current_time = now.strftime('%Y-%m-%d %H:%M:%S')
    return current_time


def running_linux():
    """
    Determines the OS is Linux by using sys.platform

    Returns True if Linux

    :return: True if sys.platform indicates running Linux
    :rtype:  (bool)
    """
    return sys.platform.startswith('linux')


def running_mac():
    """
    Determines the OS is Mac by using sys.platform

    Returns True if Mac

    :return: True if sys.platform indicates running Mac
    :rtype:  (bool)
    """
    return sys.platform.startswith('darwin')


def running_windows():
    """
    Determines the OS is Windows by using sys.platform

    Returns True if Windows

    :return: True if sys.platform indicates running Windows
    :rtype:  (bool)
    """
    return sys.platform.startswith('win')


def running_trinket():
    """
    A special case for Trinket.  Checks both the OS and the number of environment variables
    Currently, Trinket only has ONE environment variable.  This fact is used to figure out if Trinket is being used.

    Returns True if "Trinket" (in theory)

    :return: True if sys.platform indicates Linux and the number of environment variables is 1
    :rtype:  (bool)
    """
    if sys.platform.startswith('linux') and socket.gethostname().startswith('pygame-'):
        return True
    return False


def running_replit():
    """
    A special case for REPLIT.  Checks both the OS and for the existance of the number of environment variable REPL_OWNER
    Currently, Trinket only has ONE environment variable.  This fact is used to figure out if Trinket is being used.

    Returns True if running on "replit"

    :return: True if sys.platform indicates Linux and setting REPL_OWNER is found in the environment variables
    :rtype:  (bool)
    """
    if 'REPL_OWNER' in os.environ and sys.platform.startswith('linux'):
        return True
    return False


# ----====----====----==== Constants the user should NOT change ====----====----====----#
ThisRow = 555666777  # magic number

# DEFAULT_WINDOW_ICON = ''
MESSAGE_BOX_LINE_WIDTH = 60

# "Special" Key Values.. reserved
# Key representing a Read timeout
EVENT_TIMEOUT = TIMEOUT_EVENT = TIMEOUT_KEY = '__TIMEOUT__'
EVENT_TIMER = TIMER_KEY = '__TIMER EVENT__'
WIN_CLOSED = WINDOW_CLOSED = None
WINDOW_CLOSE_ATTEMPTED_EVENT = WIN_X_EVENT = WIN_CLOSE_ATTEMPTED_EVENT = '-WINDOW CLOSE ATTEMPTED-'
WINDOW_CONFIG_EVENT = '__WINDOW CONFIG__'
TITLEBAR_MINIMIZE_KEY = '__TITLEBAR MINIMIZE__'
TITLEBAR_MAXIMIZE_KEY = '__TITLEBAR MAXIMIZE__'
TITLEBAR_CLOSE_KEY = '__TITLEBAR CLOSE__'
TITLEBAR_IMAGE_KEY = '__TITLEBAR IMAGE__'
TITLEBAR_TEXT_KEY = '__TITLEBAR TEXT__'
TITLEBAR_DO_NOT_USE_AN_ICON = '__TITLEBAR_NO_ICON__'

# Key indicating should not create any return values for element
WRITE_ONLY_KEY = '__WRITE ONLY__'

MENU_DISABLED_CHARACTER = '!'
MENU_SHORTCUT_CHARACTER = '&'
MENU_KEY_SEPARATOR = '::'
MENU_SEPARATOR_LINE = '---'
MENU_RIGHT_CLICK_EDITME_EXIT = ['', ['Edit Me', 'Exit']]
MENU_RIGHT_CLICK_EDITME_VER_EXIT = ['', ['Edit Me', 'Version', 'Exit']]
MENU_RIGHT_CLICK_EDITME_VER_LOC_EXIT = ['', ['Edit Me', 'Version', 'File Location', 'Exit']]
MENU_RIGHT_CLICK_EDITME_VER_SETTINGS_EXIT = ['', ['Edit Me', 'Settings', 'Version', 'Exit']]
MENU_RIGHT_CLICK_EXIT = ['', ['Exit']]
MENU_RIGHT_CLICK_DISABLED = ['', []]
_MENU_RIGHT_CLICK_TABGROUP_DEFAULT = ['TABGROUP DEFAULT', []]
ENABLE_TK_WINDOWS = False

USE_CUSTOM_TITLEBAR = None
CUSTOM_TITLEBAR_BACKGROUND_COLOR = None
CUSTOM_TITLEBAR_TEXT_COLOR = None
CUSTOM_TITLEBAR_ICON = None
CUSTOM_TITLEBAR_FONT = None
TITLEBAR_METADATA_MARKER = 'This window has a titlebar'

CUSTOM_MENUBAR_METADATA_MARKER = 'This is a custom menubar'

SUPPRESS_ERROR_POPUPS = False
SUPPRESS_RAISE_KEY_ERRORS = True
SUPPRESS_KEY_GUESSING = False
SUPPRESS_WIDGET_NOT_FINALIZED_WARNINGS = False
ENABLE_TREEVIEW_869_PATCH = True

# These are now set based on the global settings file
ENABLE_MAC_NOTITLEBAR_PATCH = False
ENABLE_MAC_MODAL_DISABLE_PATCH = False
ENABLE_MAC_DISABLE_GRAB_ANYWHERE_WITH_TITLEBAR = True
ENABLE_MAC_ALPHA_99_PATCH = False

OLD_TABLE_TREE_SELECTED_ROW_COLORS = ('#FFFFFF', '#4A6984')
ALTERNATE_TABLE_AND_TREE_SELECTED_ROW_COLORS = ('SystemHighlightText', 'SystemHighlight')

# Some handy unicode symbols
SYMBOL_SQUARE = '█'
SYMBOL_CIRCLE = '⚫'
SYMBOL_CIRCLE_OUTLINE = '◯'
SYMBOL_BULLET = '•'
SYMBOL_UP = '▲'
SYMBOL_RIGHT = '►'
SYMBOL_LEFT = '◄'
SYMBOL_DOWN = '▼'
SYMBOL_X = '❎'
SYMBOL_CHECK = '✅'
SYMBOL_CHECK_SMALL = '✓'
SYMBOL_X_SMALL = '✗'
SYMBOL_BALLOT_X = '☒'
SYMBOL_BALLOT_CHECK = '☑'
SYMBOL_LEFT_DOUBLE = '«'
SYMBOL_RIGHT_DOUBLE = '»'
SYMBOL_LEFT_ARROWHEAD = '⮜'
SYMBOL_RIGHT_ARROWHEAD = '⮞'
SYMBOL_UP_ARROWHEAD = '⮝'
SYMBOL_DOWN_ARROWHEAD = '⮟'

if sum([int(i) for i in tclversion_detailed.split('.')]) > 19:
    SYMBOL_TITLEBAR_MINIMIZE = '_'
    SYMBOL_TITLEBAR_MAXIMIZE = '◻'
    SYMBOL_TITLEBAR_CLOSE = 'Ｘ'
else:
    SYMBOL_TITLEBAR_MINIMIZE = '_'
    SYMBOL_TITLEBAR_MAXIMIZE = 'O'
    SYMBOL_TITLEBAR_CLOSE = 'X'

#################### PATHS for user_settings APIs ####################
# These paths are passed to os.path.expanduser to get the default path for user_settings
# They can be changed using set_options

DEFAULT_USER_SETTINGS_WIN_PATH = r'~\AppData\Local\PySimpleGUI\settings'
DEFAULT_USER_SETTINGS_LINUX_PATH = r'~/.config/PySimpleGUI/settings'
DEFAULT_USER_SETTINGS_MAC_PATH = r'~/Library/Application Support/PySimpleGUI/settings'
DEFAULT_USER_SETTINGS_TRINKET_PATH = r'.'
DEFAULT_USER_SETTINGS_REPLIT_PATH = r'.'
DEFAULT_USER_SETTINGS_UNKNOWN_OS_PATH = r'~/Library/Application Support/PySimpleGUI/settings'
DEFAULT_USER_SETTINGS_PATH = None  # value set by user to override all paths above
DEFAULT_USER_SETTINGS_PYSIMPLEGUI_PATH = None  # location of the global PySimpleGUI settings
DEFAULT_USER_SETTINGS_PYSIMPLEGUI_FILENAME = '_PySimpleGUI_settings_global_.json'  # location of the global PySimpleGUI settings


# ====================================================================== #
# One-liner functions that are handy as f_ck                             #
# ====================================================================== #
def rgb(red, green, blue):
    """
    Given integer values of Red, Green, Blue, return a color string "#RRGGBB"
    :param red:   Red portion from 0 to 255
    :type red:    (int)
    :param green: Green portion from 0 to 255
    :type green:  (int)
    :param blue:  Blue portion from 0 to 255
    :type  blue:  (int)
    :return:      A single RGB String in the format "#RRGGBB" where each pair is a hex number.
    :rtype:       (str)
    """
    red = min(int(red), 255) if red > 0 else 0
    blue = min(int(blue), 255) if blue > 0 else 0
    green = min(int(green), 255) if green > 0 else 0
    return '#{:02x}{:02x}{:02x}'.format(red, green, blue)


# ====================================================================== #
# Enums for types                                                        #
# ====================================================================== #
# -------------------------  Button types  ------------------------- #
BUTTON_TYPE_BROWSE_FOLDER = 1
BUTTON_TYPE_BROWSE_FILE = 2
BUTTON_TYPE_BROWSE_FILES = 21
BUTTON_TYPE_SAVEAS_FILE = 3
BUTTON_TYPE_CLOSES_WIN = 5
BUTTON_TYPE_CLOSES_WIN_ONLY = 6
BUTTON_TYPE_READ_FORM = 7
BUTTON_TYPE_REALTIME = 9
BUTTON_TYPE_CALENDAR_CHOOSER = 30
BUTTON_TYPE_COLOR_CHOOSER = 40
BUTTON_TYPE_SHOW_DEBUGGER = 50

BROWSE_FILES_DELIMITER = ';'  # the delimiter to be used between each file in the returned string

FILE_TYPES_ALL_FILES = (('ALL Files', '*.* *'),)

BUTTON_DISABLED_MEANS_IGNORE = 'ignore'

# -------------------------  Element types  ------------------------- #

ELEM_TYPE_TEXT = 'text'
ELEM_TYPE_INPUT_TEXT = 'input'
ELEM_TYPE_INPUT_COMBO = 'combo'
ELEM_TYPE_INPUT_OPTION_MENU = 'option menu'
ELEM_TYPE_INPUT_RADIO = 'radio'
ELEM_TYPE_INPUT_MULTILINE = 'multiline'
ELEM_TYPE_INPUT_CHECKBOX = 'checkbox'
ELEM_TYPE_INPUT_SPIN = 'spind'
ELEM_TYPE_BUTTON = 'button'
ELEM_TYPE_IMAGE = 'image'
ELEM_TYPE_CANVAS = 'canvas'
ELEM_TYPE_FRAME = 'frame'
ELEM_TYPE_GRAPH = 'graph'
ELEM_TYPE_TAB = 'tab'
ELEM_TYPE_TAB_GROUP = 'tabgroup'
ELEM_TYPE_INPUT_SLIDER = 'slider'
ELEM_TYPE_INPUT_LISTBOX = 'listbox'
ELEM_TYPE_OUTPUT = 'output'
ELEM_TYPE_COLUMN = 'column'
ELEM_TYPE_MENUBAR = 'menubar'
ELEM_TYPE_PROGRESS_BAR = 'progressbar'
ELEM_TYPE_BLANK = 'blank'
ELEM_TYPE_TABLE = 'table'
ELEM_TYPE_TREE = 'tree'
ELEM_TYPE_ERROR = 'error'
ELEM_TYPE_SEPARATOR = 'separator'
ELEM_TYPE_STATUSBAR = 'statusbar'
ELEM_TYPE_PANE = 'pane'
ELEM_TYPE_BUTTONMENU = 'buttonmenu'
ELEM_TYPE_TITLEBAR = 'titlebar'
ELEM_TYPE_SIZEGRIP = 'sizegrip'

# STRETCH == ERROR ELEMENT as a filler

# -------------------------  Popup Buttons Types  ------------------------- #
POPUP_BUTTONS_YES_NO = 1
POPUP_BUTTONS_CANCELLED = 2
POPUP_BUTTONS_ERROR = 3
POPUP_BUTTONS_OK_CANCEL = 4
POPUP_BUTTONS_OK = 0
POPUP_BUTTONS_NO_BUTTONS = 5


PSG_THEME_PART_BUTTON_TEXT = 'Button Text Color'
PSG_THEME_PART_BUTTON_BACKGROUND = 'Button Background Color'
PSG_THEME_PART_BACKGROUND = 'Background Color'
PSG_THEME_PART_INPUT_BACKGROUND = 'Input Element Background Color'
PSG_THEME_PART_INPUT_TEXT = 'Input Element Text Color'
PSG_THEME_PART_TEXT = 'Text Color'
PSG_THEME_PART_SLIDER = 'Slider Color'
PSG_THEME_PART_LIST = [
    PSG_THEME_PART_BACKGROUND,
    PSG_THEME_PART_BUTTON_BACKGROUND,
    PSG_THEME_PART_BUTTON_TEXT,
    PSG_THEME_PART_INPUT_BACKGROUND,
    PSG_THEME_PART_INPUT_TEXT,
    PSG_THEME_PART_TEXT,
    PSG_THEME_PART_SLIDER,
]

# theme_button

TTK_SCROLLBAR_PART_TROUGH_COLOR = 'Trough Color'
TTK_SCROLLBAR_PART_BACKGROUND_COLOR = 'Background Color'
TTK_SCROLLBAR_PART_ARROW_BUTTON_ARROW_COLOR = 'Arrow Button Arrow Color'
TTK_SCROLLBAR_PART_FRAME_COLOR = 'Frame Color'
TTK_SCROLLBAR_PART_SCROLL_WIDTH = 'Frame Width'
TTK_SCROLLBAR_PART_ARROW_WIDTH = 'Arrow Width'
TTK_SCROLLBAR_PART_RELIEF = 'Relief'
TTK_SCROLLBAR_PART_LIST = [
    TTK_SCROLLBAR_PART_TROUGH_COLOR,
    TTK_SCROLLBAR_PART_BACKGROUND_COLOR,
    TTK_SCROLLBAR_PART_ARROW_BUTTON_ARROW_COLOR,
    TTK_SCROLLBAR_PART_FRAME_COLOR,
    TTK_SCROLLBAR_PART_SCROLL_WIDTH,
    TTK_SCROLLBAR_PART_ARROW_WIDTH,
    TTK_SCROLLBAR_PART_RELIEF,
]
TTK_SCROLLBAR_PART_THEME_BASED_LIST = [
    TTK_SCROLLBAR_PART_TROUGH_COLOR,
    TTK_SCROLLBAR_PART_BACKGROUND_COLOR,
    TTK_SCROLLBAR_PART_ARROW_BUTTON_ARROW_COLOR,
    TTK_SCROLLBAR_PART_FRAME_COLOR,
]
DEFAULT_TTK_PART_MAPPING_DICT = {
    TTK_SCROLLBAR_PART_TROUGH_COLOR: PSG_THEME_PART_SLIDER,
    TTK_SCROLLBAR_PART_BACKGROUND_COLOR: PSG_THEME_PART_BUTTON_BACKGROUND,
    TTK_SCROLLBAR_PART_ARROW_BUTTON_ARROW_COLOR: PSG_THEME_PART_BUTTON_TEXT,
    TTK_SCROLLBAR_PART_FRAME_COLOR: PSG_THEME_PART_BACKGROUND,
    TTK_SCROLLBAR_PART_SCROLL_WIDTH: 12,
    TTK_SCROLLBAR_PART_ARROW_WIDTH: 12,
    TTK_SCROLLBAR_PART_RELIEF: RELIEF_RAISED,
}

ttk_part_mapping_dict = copy.copy(DEFAULT_TTK_PART_MAPPING_DICT)


class TTKPartOverrides:
    """
    This class contains "overrides" to the defaults for ttk scrollbars that are defined in the global settings file.
    This class is used in every element, in the Window class and there's a global one that is used by set_options.
    """

    def __init__(
        self,
        sbar_trough_color=None,
        sbar_background_color=None,
        sbar_arrow_color=None,
        sbar_width=None,
        sbar_arrow_width=None,
        sbar_frame_color=None,
        sbar_relief=None,
    ):
        self.sbar_trough_color = sbar_trough_color
        self.sbar_background_color = sbar_background_color
        self.sbar_arrow_color = sbar_arrow_color
        self.sbar_width = sbar_width
        self.sbar_arrow_width = sbar_arrow_width
        self.sbar_frame_color = sbar_frame_color
        self.sbar_relief = sbar_relief


ttk_part_overrides_from_options = TTKPartOverrides()


# -------------------------  tkinter BASIC cursors... there are some OS dependent ones too  ------------------------- #
# TKINTER_CURSORS = ['X_cursor', 'arrow', 'based_arrow_down', 'based_arrow_up', 'boat', 'bogosity', 'bottom_left_corner', 'bottom_right_corner', 'bottom_side', 'bottom_tee', 'box_spiral', 'center_ptr', 'circle', 'clock', 'coffee_mug', 'cross', 'cross_reverse', 'crosshair', 'diamond_cross', 'dot', 'dotbox', 'double_arrow', 'draft_large', 'draft_small', 'draped_box', 'exchange', 'fleur', 'gobbler', 'gumby', 'hand1', 'hand2', 'heart', 'icon', 'iron_cross', 'left_ptr', 'left_side', 'left_tee', 'leftbutton', 'll_angle', 'lr_angle', 'man', 'middlebutton', 'mouse', 'pencil', 'pirate', 'plus', 'question_arrow', 'right_ptr', 'right_side', 'right_tee', 'rightbutton', 'rtl_logo', 'sailboat', 'sb_down_arrow', 'sb_h_double_arrow', 'sb_left_arrow', 'sb_right_arrow', 'sb_up_arrow', 'sb_v_double_arrow', 'shuttle', 'sizing', 'spider', 'spraycan', 'star', 'target', 'tcross', 'top_left_arrow', 'top_left_corner', 'top_right_corner', 'top_side', 'top_tee', 'trek', 'ul_angle', 'umbrella', 'ur_angle', 'watch', 'xterm',]

# fmt: off
TKINTER_CURSORS = ['X_cursor', 'arrow', 'based_arrow_down', 'based_arrow_up', 'boat', 'bogosity', 'bottom_left_corner', 'bottom_right_corner', 'bottom_side', 'bottom_tee', 'box_spiral', 'center_ptr', 'circle', 'clock', 'coffee_mug', 'cross', 'cross_reverse', 'crosshair', 'diamond_cross', 'dot', 'dotbox', 'double_arrow', 'draft_large', 'draft_small', 'draped_box', 'exchange', 'fleur', 'gobbler', 'gumby', 'hand1', 'hand2', 'heart', 'ibeam', 'icon', 'iron_cross', 'left_ptr', 'left_side', 'left_tee', 'leftbutton', 'll_angle', 'lr_angle', 'man', 'middlebutton', 'mouse', 'no', 'none', 'pencil', 'pirate', 'plus', 'question_arrow', 'right_ptr', 'right_side', 'right_tee', 'rightbutton', 'rtl_logo', 'sailboat', 'sb_down_arrow', 'sb_h_double_arrow', 'sb_left_arrow', 'sb_right_arrow', 'sb_up_arrow', 'sb_v_double_arrow', 'shuttle', 'size', 'size_ne_sw', 'size_ns', 'size_nw_se', 'size_we', 'sizing', 'spider', 'spraycan', 'star', 'starting', 'target', 'tcross', 'top_left_arrow', 'top_left_corner', 'top_right_corner', 'top_side', 'top_tee', 'trek', 'ul_angle', 'umbrella', 'uparrow', 'ur_angle', 'wait', 'watch', 'xterm',]
# -------------------------  tkinter key codes for bindings  ------------------------- #
# The keycode that when pressed will take a snapshot of the current window
DEFAULT_WINDOW_SNAPSHOT_KEY_CODE = None
DEFAULT_WINDOW_SNAPSHOT_KEY = '--SCREENSHOT THIS WINDOW--'
tkinter_keysyms = ('space', 'exclam', 'quotedbl', 'numbersign', 'dollar', 'percent', 'ampersand', 'quoteright', 'parenleft', 'parenright', 'asterisk', 'plus', 'comma', 'minus', 'period', 'slash', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'colon', 'semicolon', 'less', 'equal', 'greater', 'question', 'at', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'bracketleft', 'backslash', 'bracketright', 'asciicircum', 'underscore', 'quoteleft', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'braceleft', 'bar', 'braceright', 'asciitilde', 'nobreakspace', 'exclamdown', 'cent', 'sterling', 'currency', 'yen', 'brokenbar', 'section', 'diaeresis', 'copyright', 'ordfeminine', 'guillemotleft', 'notsign', 'hyphen', 'registered', 'macron', 'degree', 'plusminus', 'twosuperior', 'threesuperior', 'acute', 'mu', 'paragraph', 'periodcentered', 'cedilla', 'onesuperior', 'masculine', 'guillemotright', 'onequarter', 'onehalf', 'threequarters', 'questiondown', 'Agrave', 'Aacute', 'Acircumflex', 'Atilde', 'Adiaeresis', 'Aring', 'AE', 'Ccedilla', 'Egrave', 'Eacute', 'Ecircumflex', 'Ediaeresis', 'Igrave', 'Iacute', 'Icircumflex', 'Idiaeresis', 'Eth', 'Ntilde', 'Ograve', 'Oacute', 'Ocircumflex', 'Otilde', 'Odiaeresis', 'multiply', 'Ooblique', 'Ugrave', 'Uacute', 'Ucircumflex', 'Udiaeresis', 'Yacute', 'Thorn', 'ssharp', 'agrave', 'aacute', 'acircumflex', 'atilde', 'adiaeresis', 'aring', 'ae', 'ccedilla', 'egrave', 'eacute', 'ecircumflex', 'ediaeresis', 'igrave', 'iacute', 'icircumflex', 'idiaeresis', 'eth', 'ntilde', 'ograve', 'oacute', 'ocircumflex', 'otilde', 'odiaeresis', 'division', 'oslash', 'ugrave', 'uacute', 'ucircumflex', 'udiaeresis', 'yacute', 'thorn', 'ydiaeresis', 'Aogonek', 'breve', 'Lstroke', 'Lcaron', 'Sacute', 'Scaron', 'Scedilla', 'Tcaron', 'Zacute', 'Zcaron', 'Zabovedot', 'aogonek', 'ogonek', 'lstroke', 'lcaron', 'sacute', 'caron', 'scaron', 'scedilla', 'tcaron', 'zacute', 'doubleacute', 'zcaron', 'zabovedot', 'Racute', 'Abreve', 'Cacute', 'Ccaron', 'Eogonek', 'Ecaron', 'Dcaron', 'Nacute', 'Ncaron', 'Odoubleacute', 'Rcaron', 'Uring', 'Udoubleacute', 'Tcedilla', 'racute', 'abreve', 'cacute', 'ccaron', 'eogonek', 'ecaron', 'dcaron', 'nacute', 'ncaron', 'odoubleacute', 'rcaron', 'uring', 'udoubleacute', 'tcedilla', 'abovedot', 'Hstroke', 'Hcircumflex', 'Iabovedot', 'Gbreve', 'Jcircumflex', 'hstroke', 'hcircumflex', 'idotless', 'gbreve', 'jcircumflex', 'Cabovedot', 'Ccircumflex', 'Gabovedot', 'Gcircumflex', 'Ubreve', 'Scircumflex', 'cabovedot', 'ccircumflex', 'gabovedot', 'gcircumflex', 'ubreve', 'scircumflex', 'kappa', 'Rcedilla', 'Itilde', 'Lcedilla', 'Emacron', 'Gcedilla', 'Tslash', 'rcedilla', 'itilde', 'lcedilla', 'emacron', 'gacute', 'tslash', 'ENG', 'eng', 'Amacron', 'Iogonek', 'Eabovedot', 'Imacron', 'Ncedilla', 'Omacron', 'Kcedilla', 'Uogonek', 'Utilde', 'Umacron', 'amacron', 'iogonek', 'eabovedot', 'imacron', 'ncedilla', 'omacron', 'kcedilla', 'uogonek', 'utilde', 'umacron', 'overline', 'kana_fullstop', 'kana_openingbracket', 'kana_closingbracket', 'kana_comma', 'kana_middledot', 'kana_WO', 'kana_a', 'kana_i', 'kana_u', 'kana_e', 'kana_o', 'kana_ya', 'kana_yu', 'kana_yo', 'kana_tu', 'prolongedsound', 'kana_A', 'kana_I', 'kana_U', 'kana_E', 'kana_O', 'kana_KA', 'kana_KI', 'kana_KU', 'kana_KE', 'kana_KO', 'kana_SA', 'kana_SHI', 'kana_SU', 'kana_SE', 'kana_SO', 'kana_TA', 'kana_TI', 'kana_TU', 'kana_TE', 'kana_TO', 'kana_NA', 'kana_NI', 'kana_NU', 'kana_NE', 'kana_NO', 'kana_HA', 'kana_HI', 'kana_HU', 'kana_HE', 'kana_HO', 'kana_MA', 'kana_MI', 'kana_MU', 'kana_ME', 'kana_MO', 'kana_YA', 'kana_YU', 'kana_YO', 'kana_RA', 'kana_RI', 'kana_RU', 'kana_RE', 'kana_RO', 'kana_WA', 'kana_N', 'voicedsound', 'semivoicedsound', 'Arabic_comma', 'Arabic_semicolon', 'Arabic_question_mark', 'Arabic_hamza', 'Arabic_maddaonalef', 'Arabic_hamzaonalef', 'Arabic_hamzaonwaw', 'Arabic_hamzaunderalef', 'Arabic_hamzaonyeh', 'Arabic_alef', 'Arabic_beh', 'Arabic_tehmarbuta', 'Arabic_teh', 'Arabic_theh', 'Arabic_jeem', 'Arabic_hah', 'Arabic_khah', 'Arabic_dal', 'Arabic_thal', 'Arabic_ra', 'Arabic_zain', 'Arabic_seen', 'Arabic_sheen', 'Arabic_sad', 'Arabic_dad', 'Arabic_tah', 'Arabic_zah', 'Arabic_ain', 'Arabic_ghain', 'Arabic_tatweel', 'Arabic_feh', 'Arabic_qaf', 'Arabic_kaf', 'Arabic_lam', 'Arabic_meem', 'Arabic_noon', 'Arabic_heh', 'Arabic_waw', 'Arabic_alefmaksura', 'Arabic_yeh', 'Arabic_fathatan', 'Arabic_dammatan', 'Arabic_kasratan', 'Arabic_fatha', 'Arabic_damma', 'Arabic_kasra', 'Arabic_shadda', 'Arabic_sukun', 'Serbian_dje', 'Macedonia_gje', 'Cyrillic_io', 'Ukranian_je', 'Macedonia_dse', 'Ukranian_i', 'Ukranian_yi', 'Serbian_je', 'Serbian_lje', 'Serbian_nje', 'Serbian_tshe', 'Macedonia_kje', 'Byelorussian_shortu', 'Serbian_dze', 'numerosign', 'Serbian_DJE', 'Macedonia_GJE', 'Cyrillic_IO', 'Ukranian_JE', 'Macedonia_DSE', 'Ukranian_I', 'Ukranian_YI', 'Serbian_JE', 'Serbian_LJE', 'Serbian_NJE', 'Serbian_TSHE', 'Macedonia_KJE', 'Byelorussian_SHORTU', 'Serbian_DZE', 'Cyrillic_yu', 'Cyrillic_a', 'Cyrillic_be', 'Cyrillic_tse', 'Cyrillic_de', 'Cyrillic_ie', 'Cyrillic_ef', 'Cyrillic_ghe', 'Cyrillic_ha', 'Cyrillic_i', 'Cyrillic_shorti', 'Cyrillic_ka', 'Cyrillic_el', 'Cyrillic_em', 'Cyrillic_en', 'Cyrillic_o', 'Cyrillic_pe', 'Cyrillic_ya', 'Cyrillic_er', 'Cyrillic_es', 'Cyrillic_te', 'Cyrillic_u', 'Cyrillic_zhe', 'Cyrillic_ve', 'Cyrillic_softsign', 'Cyrillic_yeru', 'Cyrillic_ze', 'Cyrillic_sha', 'Cyrillic_e', 'Cyrillic_shcha', 'Cyrillic_che', 'Cyrillic_hardsign', 'Cyrillic_YU', 'Cyrillic_A', 'Cyrillic_BE', 'Cyrillic_TSE', 'Cyrillic_DE', 'Cyrillic_IE', 'Cyrillic_EF', 'Cyrillic_GHE', 'Cyrillic_HA', 'Cyrillic_I', 'Cyrillic_SHORTI', 'Cyrillic_KA', 'Cyrillic_EL', 'Cyrillic_EM', 'Cyrillic_EN', 'Cyrillic_O', 'Cyrillic_PE', 'Cyrillic_YA', 'Cyrillic_ER', 'Cyrillic_ES', 'Cyrillic_TE', 'Cyrillic_U', 'Cyrillic_ZHE', 'Cyrillic_VE', 'Cyrillic_SOFTSIGN', 'Cyrillic_YERU', 'Cyrillic_ZE', 'Cyrillic_SHA', 'Cyrillic_E', 'Cyrillic_SHCHA', 'Cyrillic_CHE', 'Cyrillic_HARDSIGN', 'Greek_ALPHAaccent', 'Greek_EPSILONaccent', 'Greek_ETAaccent', 'Greek_IOTAaccent', 'Greek_IOTAdiaeresis', 'Greek_IOTAaccentdiaeresis', 'Greek_OMICRONaccent', 'Greek_UPSILONaccent', 'Greek_UPSILONdieresis', 'Greek_UPSILONaccentdieresis', 'Greek_OMEGAaccent', 'Greek_alphaaccent', 'Greek_epsilonaccent', 'Greek_etaaccent', 'Greek_iotaaccent', 'Greek_iotadieresis', 'Greek_iotaaccentdieresis', 'Greek_omicronaccent', 'Greek_upsilonaccent', 'Greek_upsilondieresis', 'Greek_upsilonaccentdieresis', 'Greek_omegaaccent', 'Greek_ALPHA', 'Greek_BETA', 'Greek_GAMMA', 'Greek_DELTA', 'Greek_EPSILON', 'Greek_ZETA', 'Greek_ETA', 'Greek_THETA', 'Greek_IOTA', 'Greek_KAPPA', 'Greek_LAMBDA', 'Greek_MU', 'Greek_NU', 'Greek_XI', 'Greek_OMICRON', 'Greek_PI', 'Greek_RHO', 'Greek_SIGMA', 'Greek_TAU', 'Greek_UPSILON', 'Greek_PHI', 'Greek_CHI', 'Greek_PSI', 'Greek_OMEGA', 'Greek_alpha', 'Greek_beta', 'Greek_gamma', 'Greek_delta', 'Greek_epsilon', 'Greek_zeta', 'Greek_eta', 'Greek_theta', 'Greek_iota', 'Greek_kappa', 'Greek_lambda', 'Greek_mu', 'Greek_nu', 'Greek_xi', 'Greek_omicron', 'Greek_pi', 'Greek_rho', 'Greek_sigma', 'Greek_finalsmallsigma', 'Greek_tau', 'Greek_upsilon', 'Greek_phi', 'Greek_chi', 'Greek_psi', 'Greek_omega', 'leftradical', 'topleftradical', 'horizconnector', 'topintegral', 'botintegral', 'vertconnector', 'topleftsqbracket', 'botleftsqbracket', 'toprightsqbracket', 'botrightsqbracket', 'topleftparens', 'botleftparens', 'toprightparens', 'botrightparens', 'leftmiddlecurlybrace', 'rightmiddlecurlybrace', 'topleftsummation', 'botleftsummation', 'topvertsummationconnector', 'botvertsummationconnector', 'toprightsummation', 'botrightsummation', 'rightmiddlesummation', 'lessthanequal', 'notequal', 'greaterthanequal', 'integral', 'therefore', 'variation', 'infinity', 'nabla', 'approximate', 'similarequal', 'ifonlyif', 'implies', 'identical', 'radical', 'includedin', 'includes', 'intersection', 'union', 'logicaland', 'logicalor', 'partialderivative', 'function', 'leftarrow', 'uparrow', 'rightarrow', 'downarrow', 'blank', 'soliddiamond', 'checkerboard', 'ht', 'ff', 'cr', 'lf', 'nl', 'vt', 'lowrightcorner', 'uprightcorner', 'upleftcorner', 'lowleftcorner', 'crossinglines', 'horizlinescan1', 'horizlinescan3', 'horizlinescan5', 'horizlinescan7', 'horizlinescan9', 'leftt', 'rightt', 'bott', 'topt', 'vertbar', 'emspace', 'enspace', 'em3space', 'em4space', 'digitspace', 'punctspace', 'thinspace', 'hairspace', 'emdash', 'endash', 'signifblank', 'ellipsis', 'doubbaselinedot', 'onethird', 'twothirds', 'onefifth', 'twofifths', 'threefifths', 'fourfifths', 'onesixth', 'fivesixths', 'careof', 'figdash', 'leftanglebracket', 'decimalpoint', 'rightanglebracket', 'marker', 'oneeighth', 'threeeighths', 'fiveeighths', 'seveneighths', 'trademark', 'signaturemark', 'trademarkincircle', 'leftopentriangle', 'rightopentriangle', 'emopencircle', 'emopenrectangle', 'leftsinglequotemark', 'rightsinglequotemark', 'leftdoublequotemark', 'rightdoublequotemark', 'prescription', 'minutes', 'seconds', 'latincross', 'hexagram', 'filledrectbullet', 'filledlefttribullet', 'filledrighttribullet', 'emfilledcircle', 'emfilledrect', 'enopencircbullet', 'enopensquarebullet', 'openrectbullet', 'opentribulletup', 'opentribulletdown', 'openstar', 'enfilledcircbullet', 'enfilledsqbullet', 'filledtribulletup', 'filledtribulletdown', 'leftpointer', 'rightpointer', 'club', 'diamond', 'heart', 'maltesecross', 'dagger', 'doubledagger', 'checkmark', 'ballotcross', 'musicalsharp', 'musicalflat', 'malesymbol', 'femalesymbol', 'telephone', 'telephonerecorder', 'phonographcopyright', 'caret', 'singlelowquotemark', 'doublelowquotemark', 'cursor', 'leftcaret', 'rightcaret', 'downcaret', 'upcaret', 'overbar', 'downtack', 'upshoe', 'downstile', 'underbar', 'jot', 'quad', 'uptack', 'circle', 'upstile', 'downshoe', 'rightshoe', 'leftshoe', 'lefttack', 'righttack', 'hebrew_aleph', 'hebrew_beth', 'hebrew_gimmel', 'hebrew_daleth', 'hebrew_he', 'hebrew_waw', 'hebrew_zayin', 'hebrew_het', 'hebrew_teth', 'hebrew_yod', 'hebrew_finalkaph', 'hebrew_kaph', 'hebrew_lamed', 'hebrew_finalmem', 'hebrew_mem', 'hebrew_finalnun', 'hebrew_nun', 'hebrew_samekh', 'hebrew_ayin', 'hebrew_finalpe', 'hebrew_pe', 'hebrew_finalzadi', 'hebrew_zadi', 'hebrew_kuf', 'hebrew_resh', 'hebrew_shin', 'hebrew_taf', 'BackSpace', 'Tab', 'Linefeed', 'Clear', 'Return', 'Pause', 'Scroll_Lock', 'Sys_Req', 'Escape', 'Multi_key', 'Kanji', 'Home', 'Left', 'Up', 'Right', 'Down', 'Prior', 'Next', 'End', 'Begin', 'Win_L', 'Win_R', 'App', 'Select', 'Print', 'Execute', 'Insert', 'Undo', 'Redo', 'Menu', 'Find', 'Cancel', 'Help', 'Break', 'Hebrew_switch', 'Num_Lock', 'KP_Space', 'KP_Tab', 'KP_Enter', 'KP_F1', 'KP_F2', 'KP_F3', 'KP_F4', 'KP_Multiply', 'KP_Add', 'KP_Separator', 'KP_Subtract', 'KP_Decimal', 'KP_Divide', 'KP_0', 'KP_1', 'KP_2', 'KP_3', 'KP_4', 'KP_5', 'KP_6', 'KP_7', 'KP_8', 'KP_9', 'KP_Equal', 'F1', 'F2', 'F3', 'F4', 'F5', 'F6', 'F7', 'F8', 'F9', 'F10', 'F11', 'F12', 'L1', 'L2', 'L3', 'L4', 'L5', 'L6', 'L7', 'L8', 'L9', 'L10', 'R1', 'R2', 'R3', 'R4', 'R5', 'R6', 'R7', 'R8', 'R9', 'R10', 'R11', 'R12', 'F33', 'R14', 'R15', 'Shift_L', 'Shift_R', 'Control_L', 'Control_R', 'Caps_Lock', 'Shift_Lock', 'Meta_L', 'Meta_R', 'Alt_L', 'Alt_R', 'Super_L', 'Super_R', 'Hyper_L', 'Hyper_R', 'Delete',)
# fmt: on

# ------------------------------------------------------------------------- #
#                       ToolTip used by the Elements                        #
# ------------------------------------------------------------------------- #


class ToolTip:
    """
    Create a tooltip for a given widget
    (inspired by https://stackoverflow.com/a/36221216)
    This is an INTERNALLY USED only class.  Users should not refer to this class at all.
    """

    def __init__(self, widget, text, timeout=DEFAULT_TOOLTIP_TIME):
        """
        :param widget:  The tkinter widget
        :type widget:   widget type varies
        :param text:    text for the tooltip. It can inslude \n
        :type text:     (str)
        :param timeout: Time in milliseconds that mouse must remain still before tip is shown
        :type timeout:  (int)
        """
        self.widget = widget
        self.text = text
        self.timeout = timeout
        # self.wraplength = wraplength if wraplength else widget.winfo_screenwidth() // 2
        self.tipwindow = None
        self.id = None
        self.x = self.y = 0
        self.widget.bind('<Enter>', self.enter)
        self.widget.bind('<Leave>', self.leave)
        self.widget.bind('<ButtonPress>', self.leave)

    def enter(self, event=None):
        """
        Called by tkinter when mouse enters a widget
        :param event: from tkinter.  Has x,y coordinates of mouse
        :type event:

        """
        self.x = event.x
        self.y = event.y
        self.schedule()

    def leave(self, event=None):
        """
        Called by tktiner when mouse exits a widget
        :param event: from tkinter.  Event info that's not used by function.
        :type event:

        """
        self.unschedule()
        self.hidetip()

    def schedule(self):
        """
        Schedule a timer to time how long mouse is hovering
        """
        self.unschedule()
        self.id = self.widget.after(self.timeout, self.showtip)

    def unschedule(self):
        """
        Cancel timer used to time mouse hover
        """
        if self.id:
            self.widget.after_cancel(self.id)
        self.id = None

    def showtip(self):
        """
        Creates a topoltip window with the tooltip text inside of it
        """
        if self.tipwindow:
            return
        x = self.widget.winfo_rootx() + self.x + DEFAULT_TOOLTIP_OFFSET[0]
        y = self.widget.winfo_rooty() + self.y + DEFAULT_TOOLTIP_OFFSET[1]
        self.tipwindow = tk.Toplevel(self.widget)
        # if not sys.platform.startswith('darwin'):
        try:
            self.tipwindow.wm_overrideredirect(True)
            # if running_mac() and ENABLE_MAC_NOTITLEBAR_PATCH:
            if _mac_should_apply_notitlebar_patch():
                self.tipwindow.wm_overrideredirect(False)
        except Exception as e:
            print('* Error performing wm_overrideredirect in showtip *', e)
        self.tipwindow.wm_geometry('+%d+%d' % (x, y))
        self.tipwindow.wm_attributes('-topmost', 1)

        label = ttk.Label(
            self.tipwindow,
            text=self.text,
            justify=tk.LEFT,
            background=TOOLTIP_BACKGROUND_COLOR,
            relief=tk.SOLID,
            borderwidth=1,
        )
        if TOOLTIP_FONT is not None:
            label.config(font=TOOLTIP_FONT)
        label.pack()

    def hidetip(self):
        """
        Destroy the tooltip window
        """
        if self.tipwindow:
            self.tipwindow.destroy()
        self.tipwindow = None


class _TimerPeriodic:
    id_counter = 1
    # Dictionary containing the active timers.  Format is {id : _TimerPeriodic object}
    active_timers = {}  # type: dict[int:_TimerPeriodic]

    def __init__(self, window, frequency_ms, key=EVENT_TIMER, repeating=True):
        """
        :param window:          The window to send events to
        :type window:           FreeSimpleGUI.window.Window
        :param frequency_ms:    How often to send events in milliseconds
        :type frequency_ms:     int
        :param repeating:       If True then the timer will run, repeatedly sending events, until stopped
        :type repeating:        bool
        """
        self.window = window
        self.frequency_ms = frequency_ms
        self.repeating = repeating
        self.key = key
        self.id = _TimerPeriodic.id_counter
        _TimerPeriodic.id_counter += 1
        self.start()

    @classmethod
    def stop_timer_with_id(cls, timer_id):
        """
        Not user callable!
        :return: A simple counter that makes each container element unique
        :rtype:
        """
        timer = cls.active_timers.get(timer_id, None)
        if timer is not None:
            timer.stop()

    @classmethod
    def stop_all_timers_for_window(cls, window):
        """
        Stops all timers for a given window
        :param window:      The window to stop timers for
        :type window:       FreeSimpleGUI.window.Window
        """
        for timer in _TimerPeriodic.active_timers.values():
            if timer.window == window:
                timer.running = False

    @classmethod
    def get_all_timers_for_window(cls, window):
        """
        Returns a list of timer IDs for a given window
        :param window:      The window to find timers for
        :type window:       FreeSimpleGUI.window.Window
        :return:            List of timer IDs for the window
        :rtype:             List[int]
        """
        timers = []
        for timer in _TimerPeriodic.active_timers.values():
            if timer.window == window:
                timers.append(timer.id)

        return timers

    def timer_thread(self):
        """
        The thread that sends events to the window.  Runs either once or in a loop until timer is stopped
        """

        if not self.running:  # if timer has been cancelled, abort
            del _TimerPeriodic.active_timers[self.id]
            return
        while True:
            time.sleep(self.frequency_ms / 1000)
            if not self.running:  # if timer has been cancelled, abort
                del _TimerPeriodic.active_timers[self.id]
                return
            self.window.write_event_value(self.key, self.id)

            if not self.repeating:  # if timer does not repeat, then exit thread
                del _TimerPeriodic.active_timers[self.id]
                return

    def start(self):
        """
        Starts a timer by starting a timer thread
        Adds timer to the list of active timers
        """
        self.running = True
        self.thread = threading.Thread(target=self.timer_thread, daemon=True)
        self.thread.start()
        _TimerPeriodic.active_timers[self.id] = self

    def stop(self):
        """
        Stops a timer
        """
        self.running = False


def _long_func_thread(window, end_key, original_func):
    """
    Used to run long operations on the user's behalf. Called by the window object

    :param window:        The window that will get the event
    :type window:         (Window)
    :param end_key:       The event that will be sent when function returns. If None then no event will be sent when exiting thread
    :type end_key:        (Any|None)
    :param original_func: The user's function that is called. Can be a function with no arguments or a lambda experession
    :type original_func:  (Any)
    """

    return_value = original_func()
    if end_key is not None:
        window.write_event_value(end_key, return_value)


def _timeout_alarm_callback_hidden():
    """
    Read Timeout Alarm callback. Will kick a mainloop call out of the tkinter event loop and cause it to return
    """

    del Window._TKAfterID

    # first, get the results table built
    # modify the Results table in the parent FlexForm object
    # print('TIMEOUT CALLBACK')
    Window._root_running_mainloop.quit()  # kick the users out of the mainloop

    # Get window that caused return
    Window._window_that_exited = None


def read_all_windows(timeout=None, timeout_key=TIMEOUT_KEY):
    """
    Reads all windows that are "active" when the call is made. "Active" means that it's been finalized or read.
    If a window has not been finalized then it will not be considered an "active window"

    If any of the active windows returns a value then the window and its event and values
    are returned.

    If no windows are open, then the value (None, WIN_CLOSED, None) will be returned
        Since WIN_CLOSED is None, it means (None, None, None) is what's returned when no windows remain opened

    :param timeout:     Time in milliseconds to delay before a returning a timeout event
    :type timeout:      (int)
    :param timeout_key: Key to return when a timeout happens. Defaults to the standard TIMEOUT_KEY
    :type timeout_key:  (Any)
    :return:            A tuple with the  (Window, event, values dictionary/list)
    :rtype:             (Window, Any, Dict | List)
    """

    if len(Window._active_windows) == 0:
        return None, WIN_CLOSED, None

    # first see if any queued events are waiting for any of the windows
    for window in Window._active_windows.keys():
        if window._queued_thread_event_available():
            _BuildResults(window, False, window)
            event, values = window.ReturnValues
            return window, event, values

    Window._root_running_mainloop = Window.hidden_master_root
    Window._timeout_key = timeout_key

    if timeout == 0:
        window = list(Window._active_windows.keys())[Window._timeout_0_counter]
        event, values = window._ReadNonBlocking()
        if event is None:
            event = timeout_key
        if values is None:
            event = None
        Window._timeout_0_counter = (Window._timeout_0_counter + 1) % len(Window._active_windows)
        return window, event, values

    Window._timeout_0_counter = 0  # reset value if not reading with timeout 0 so ready next time needed

    # setup timeout timer
    if timeout is not None:
        try:
            Window.hidden_master_root.after_cancel(Window._TKAfterID)
            del Window._TKAfterID
        except:
            pass

        Window._TKAfterID = Window.hidden_master_root.after(timeout, _timeout_alarm_callback_hidden)

    # ------------ Call Mainloop ------------
    Window._root_running_mainloop.mainloop()

    try:
        Window.hidden_master_root.after_cancel(Window._TKAfterID)
        del Window._TKAfterID
    except:
        pass
        # print('** tkafter cancel failed **')

    # Get window that caused return

    window = Window._window_that_exited

    if window is None:
        return None, timeout_key, None

    if window.XFound:
        event, values = None, None
        window.close()
        try:
            del Window._active_windows[window]
        except:
            pass
            # print('Error deleting window, but OK')
    else:
        _BuildResults(window, False, window)
        event, values = window.ReturnValues

    return window, event, values


# =========================================================================== #
# Button Lazy Functions so the caller doesn't have to define a bunch of stuff #
# =========================================================================== #


# ------------------------- A fake Element... the Pad Element ------------------------- #
def Sizer(h_pixels=0, v_pixels=0):
    """
    "Pushes" out the size of whatever it is placed inside of.  This includes Columns, Frames, Tabs and Windows

    :param h_pixels: number of horizontal pixels
    :type h_pixels:  (int)
    :param v_pixels: number of vertical pixels
    :type v_pixels:  (int)
    :return:         (Canvas) A canvas element that has a pad setting set according to parameters
    :rtype:          (FreeSimpleGUI.elements.canvas.Canvas)
    """

    return Canvas(size=(0, 0), pad=((h_pixels, 0), (v_pixels, 0)))


def pin(elem, vertical_alignment=None, shrink=True, expand_x=None, expand_y=None):
    """
    Pin's an element provided into a layout so that when it's made invisible and visible again, it will
     be in the correct place.  Otherwise it will be placed at the end of its containing window/column.

     The element you want to pin is the element that you'll be making visibile/invisible.

    The pin helper function also causes containers to shrink to fit the contents correct after something inside
     has changed visiblity.  Note that setting a hardcoded size on your window can impact this ability to shrink.

    :param elem:               the element to put into the layout
    :type elem:                Element
    :param vertical_alignment: Aligns elements vertically. 'top', 'center', 'bottom'. Can be shortened to 't', 'c', 'b'
    :type vertical_alignment:  str | None
    :param shrink:             If True, then the space will shrink down to a single pixel when hidden. False leaves the area large and blank
    :type shrink:              bool
    :param expand_x:           If True/False the value will be passed to the Column Elements used to make this feature
    :type expand_x:            (bool)
    :param expand_y:           If True/False the value will be passed to the Column Elements used to make this feature
    :type expand_y:            (bool)
    :return:                   A column element containing the provided element
    :rtype:                    Column
    """
    if shrink:
        # return Column([[elem, Canvas(size=(0, 0),background_color=elem.BackgroundColor, pad=(0, 0))]], pad=(0, 0), vertical_alignment=vertical_alignment, expand_x=expand_x, expand_y=expand_y)
        return Column(
            [[elem, Column([[]], pad=(0, 0))]],
            pad=(0, 0),
            vertical_alignment=vertical_alignment,
            expand_x=expand_x,
            expand_y=expand_y,
        )
    else:
        return Column([[elem]], pad=(0, 0), vertical_alignment=vertical_alignment, expand_x=expand_x, expand_y=expand_y)


def vtop(elem_or_row, expand_x=None, expand_y=None, background_color=None):
    """
    Align an element or a row of elements to the top of the row that contains it

    :param elem_or_row:      the element or row of elements
    :type elem_or_row:       Element | List[Element] | Tuple[Element]
    :param expand_x:         If True/False the value will be passed to the Column Elements used to make this feature
    :type expand_x:          (bool)
    :param expand_y:         If True/False the value will be passed to the Column Elements used to make this feature
    :type expand_y:          (bool)
    :param background_color: Background color for container that is used by vtop to do the alignment
    :type background_color:  str | None
    :return:                 A column element containing the provided element aligned to the top or list of elements (a row)
    :rtype:                  Column | List[Column]
    """

    if isinstance(elem_or_row, list) or isinstance(elem_or_row, tuple):
        return [
            Column(
                [[e]],
                pad=(0, 0),
                vertical_alignment='top',
                expand_x=expand_x,
                expand_y=expand_y,
                background_color=background_color,
            )
            for e in elem_or_row
        ]

    return Column(
        [[elem_or_row]],
        pad=(0, 0),
        vertical_alignment='top',
        expand_x=expand_x,
        expand_y=expand_y,
        background_color=background_color,
    )


def vcenter(elem_or_row, expand_x=None, expand_y=None, background_color=None):
    """
    Align an element or a row of elements to the center of the row that contains it

    :param elem_or_row:      the element or row of elements
    :type elem_or_row:       Element | List[Element] | Tuple[Element]
    :param expand_x:         If True/False the value will be passed to the Column Elements used to make this feature
    :type expand_x:          (bool)
    :param expand_y:         If True/False the value will be passed to the Column Elements used to make this feature
    :type expand_y:          (bool)
    :param background_color: Background color for container that is used by vcenter to do the alignment
    :type background_color:  str | None
    :return:                 A column element containing the provided element aligned to the center or list of elements (a row)
    :rtype:                  Column | List[Column]
    """

    if isinstance(elem_or_row, list) or isinstance(elem_or_row, tuple):
        return [
            Column(
                [[e]],
                pad=(0, 0),
                vertical_alignment='center',
                expand_x=expand_x,
                expand_y=expand_y,
                background_color=background_color,
            )
            for e in elem_or_row
        ]

    return Column(
        [[elem_or_row]],
        pad=(0, 0),
        vertical_alignment='center',
        expand_x=expand_x,
        expand_y=expand_y,
        background_color=background_color,
    )


def vbottom(elem_or_row, expand_x=None, expand_y=None, background_color=None):
    """
    Align an element or a row of elements to the bottom of the row that contains it

    :param elem_or_row:      the element or row of elements
    :type elem_or_row:       Element | List[Element] | Tuple[Element]
    :param expand_x:         If True/False the value will be passed to the Column Elements used to make this feature
    :type expand_x:          (bool)
    :param expand_y:         If True/False the value will be passed to the Column Elements used to make this feature
    :type expand_y:          (bool)
    :param background_color: Background color for container that is used by vcenter to do the alignment
    :type background_color:  str | None
    :return:                 A column element containing the provided element aligned to the bottom or list of elements (a row)
    :rtype:                  Column | List[Column]
    """

    if isinstance(elem_or_row, list) or isinstance(elem_or_row, tuple):
        return [
            Column(
                [[e]],
                pad=(0, 0),
                vertical_alignment='bottom',
                expand_x=expand_x,
                expand_y=expand_y,
                background_color=background_color,
            )
            for e in elem_or_row
        ]

    return Column(
        [[elem_or_row]],
        pad=(0, 0),
        vertical_alignment='bottom',
        expand_x=expand_x,
        expand_y=expand_y,
        background_color=background_color,
    )


def Titlebar(title='', icon=None, text_color=None, background_color=None, font=None, key=None, k=None):
    """
    A custom titlebar that replaces the OS provided titlebar, thus giving you control
    the is not possible using the OS provided titlebar such as the color.

    NOTE LINUX USERS - at the moment the minimize function is not yet working.  Windows users
    should have no problem and it should function as a normal window would.

    This titlebar is created from a row of elements that is then encapsulated into a
    one Column element which is what this Titlebar function returns to you.

    A custom titlebar removes the margins from your window.  If you want the  remainder
    of your Window to have margins, place the layout after the Titlebar into a Column and
    set the pad of that Column to the dimensions you would like your margins to have.

    The Titlebar is a COLUMN element.  You can thus call the update method for the column and
    perform operations such as making the column visible/invisible

    :param icon:             Can be either a filename or Base64 byte string of a PNG or GIF. This is used in an Image element to create the titlebar
    :type icon:              str or bytes or None
    :param title:            The "title" to show in the titlebar
    :type title:             str
    :param text_color:       Text color for titlebar
    :type text_color:        str | None
    :param background_color: Background color for titlebar
    :type background_color:  str | None
    :param font:             Font to be used for the text and the symbols
    :type font:              (str or (str, int[, str]) or None)
    :param key:              Identifies an Element. Should be UNIQUE to this window.
    :type key:               str | int | tuple | object | None
    :param k:                Exactly the same as key.  Choose one of them to use
    :type k:                 str | int | tuple | object | None
    :return:                 A single Column element that has eveything in 1 element
    :rtype:                  Column
    """
    bc = background_color or CUSTOM_TITLEBAR_BACKGROUND_COLOR or theme_button_color()[1]
    tc = text_color or CUSTOM_TITLEBAR_TEXT_COLOR or theme_button_color()[0]
    font = font or CUSTOM_TITLEBAR_FONT or ('Helvetica', 12)
    key = k or key

    if isinstance(icon, bytes):
        icon_and_text_portion = [Image(data=icon, background_color=bc, key=TITLEBAR_IMAGE_KEY)]
    elif icon == TITLEBAR_DO_NOT_USE_AN_ICON:
        icon_and_text_portion = []
    elif icon is not None:
        icon_and_text_portion = [Image(filename=icon, background_color=bc, key=TITLEBAR_IMAGE_KEY)]
    elif CUSTOM_TITLEBAR_ICON is not None:
        if isinstance(CUSTOM_TITLEBAR_ICON, bytes):
            icon_and_text_portion = [Image(data=CUSTOM_TITLEBAR_ICON, background_color=bc, key=TITLEBAR_IMAGE_KEY)]
        else:
            icon_and_text_portion = [Image(filename=CUSTOM_TITLEBAR_ICON, background_color=bc, key=TITLEBAR_IMAGE_KEY)]
    else:
        icon_and_text_portion = [Image(data=DEFAULT_BASE64_ICON_16_BY_16, background_color=bc, key=TITLEBAR_IMAGE_KEY)]

    icon_and_text_portion += [T(title, text_color=tc, background_color=bc, font=font, grab=True, key=TITLEBAR_TEXT_KEY)]

    return Column(
        [
            [
                Column([icon_and_text_portion], pad=(0, 0), background_color=bc),
                Column(
                    [
                        [
                            T(
                                SYMBOL_TITLEBAR_MINIMIZE,
                                text_color=tc,
                                background_color=bc,
                                enable_events=True,
                                font=font,
                                key=TITLEBAR_MINIMIZE_KEY,
                            ),
                            Text(
                                SYMBOL_TITLEBAR_MAXIMIZE,
                                text_color=tc,
                                background_color=bc,
                                enable_events=True,
                                font=font,
                                key=TITLEBAR_MAXIMIZE_KEY,
                            ),
                            Text(
                                SYMBOL_TITLEBAR_CLOSE,
                                text_color=tc,
                                background_color=bc,
                                font=font,
                                enable_events=True,
                                key=TITLEBAR_CLOSE_KEY,
                            ),
                        ]
                    ],
                    element_justification='r',
                    expand_x=True,
                    grab=True,
                    pad=(0, 0),
                    background_color=bc,
                ),
            ]
        ],
        expand_x=True,
        grab=True,
        background_color=bc,
        pad=(0, 0),
        metadata=TITLEBAR_METADATA_MARKER,
        key=key,
    )


def MenubarCustom(
    menu_definition,
    disabled_text_color=None,
    bar_font=None,
    font=None,
    tearoff=False,
    pad=0,
    p=None,
    background_color=None,
    text_color=None,
    bar_background_color=None,
    bar_text_color=None,
    key=None,
    k=None,
):
    """
    A custom Menubar that replaces the OS provided Menubar

    Why?
    Two reasons - 1. they look great (see custom titlebar) 2. if you have a custom titlebar, then you have to use a custom menubar if you want a menubar

    :param menu_definition:      The Menu definition specified using lists (docs explain the format)
    :type menu_definition:       List[List[Tuple[str, List[str]]]
    :param disabled_text_color:  color to use for text when item is disabled. Can be in #RRGGBB format or a color name "black"
    :type disabled_text_color:   (str)
    :param bar_font:             specifies the font family, size to be used for the chars in the bar itself
    :type bar_font:              (str or (str, int[, str]) or None)
    :param font:                 specifies the font family, size to be used for the menu items
    :type font:                  (str or (str, int[, str]) or None)
    :param tearoff:              if True, then can tear the menu off from the window ans use as a floating window. Very cool effect
    :type tearoff:               (bool)
    :param pad:                  Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int).  TIP - 0 will make flush with titlebar
    :type pad:                   (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                    Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                     (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param background_color:     color to use for background of the menus that are displayed after making a section. Can be in #RRGGBB format or a color name "black". Defaults to the color of the bar text
    :type background_color:      (str)
    :param text_color:           color to use for the text of the many items in the displayed menus. Can be in #RRGGBB format or a color name "black". Defaults to the bar background
    :type text_color:            (str)
    :param bar_background_color: color to use for the menubar. Can be in #RRGGBB format or a color name "black". Defaults to theme's button text color
    :type bar_background_color:  (str)
    :param bar_text_color:       color to use for the menu items text when item is disabled. Can be in #RRGGBB format or a color name "black". Defaults to theme's button background color
    :type bar_text_color:        (str)
    :param key:                  Value that uniquely identifies this element from all other elements. Used when Finding an element or in return values. Must be unique to the window
    :type key:                   str | int | tuple | object
    :param k:                    Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                     str | int | tuple | object
    :returns:                    A Column element that has a series of ButtonMenu elements
    :rtype:                      Column
    """

    bar_bg = bar_background_color if bar_background_color is not None else theme_button_color()[0]
    bar_text = bar_text_color if bar_text_color is not None else theme_button_color()[1]
    menu_bg = background_color if background_color is not None else bar_text
    menu_text = text_color if text_color is not None else bar_bg
    pad = pad if pad is not None else p

    row = []
    for menu in menu_definition:
        text = menu[0]
        if MENU_SHORTCUT_CHARACTER in text:
            text = text.replace(MENU_SHORTCUT_CHARACTER, '')
        if text.startswith(MENU_DISABLED_CHARACTER):
            disabled = True
            text = text[len(MENU_DISABLED_CHARACTER) :]
        else:
            disabled = False

        button_menu = ButtonMenu(
            text,
            menu,
            border_width=0,
            button_color=(bar_text, bar_bg),
            key=text,
            pad=(0, 0),
            disabled=disabled,
            font=bar_font,
            item_font=font,
            disabled_text_color=disabled_text_color,
            text_color=menu_text,
            background_color=menu_bg,
            tearoff=tearoff,
        )
        button_menu.part_of_custom_menubar = True
        button_menu.custom_menubar_key = key if key is not None else k
        row += [button_menu]
    return Column([row], pad=pad, background_color=bar_bg, expand_x=True, key=key if key is not None else k)


# -------------------------  FOLDER BROWSE Element lazy function  ------------------------- #
def FolderBrowse(
    button_text='Browse',
    target=(ThisRow, -1),
    initial_folder=None,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    change_submits=False,
    enable_events=False,
    font=None,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """
    :param button_text:      text in the button (Default value = 'Browse')
    :type button_text:       (str)
    :param target:           target for the button (Default value = (ThisRow, -1))
    :type target:            str | (int, int)
    :param initial_folder:   starting path for folders and files
    :type initial_folder:    (str)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param change_submits:   If True, pressing Enter key submits window (Default = False)
    :type enable_events:     (bool)
    :param enable_events:    Turns on the element specific events.(Default = False)
    :type enable_events:     (bool)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              Used with window.find_element and with return values to uniquely identify this element
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 The Button created
    :rtype:                  (Button)
    """

    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_BROWSE_FOLDER,
        target=target,
        initial_folder=initial_folder,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        disabled=disabled,
        button_color=button_color,
        change_submits=change_submits,
        enable_events=enable_events,
        font=font,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  FILE BROWSE Element lazy function  ------------------------- #
def FileBrowse(
    button_text='Browse',
    target=(ThisRow, -1),
    file_types=FILE_TYPES_ALL_FILES,
    initial_folder=None,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    change_submits=False,
    enable_events=False,
    font=None,
    disabled=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Browse')
    :type button_text:       (str)
    :param target:           key or (row,col) target for the button (Default value = (ThisRow, -1))
    :type target:            str | (int, int)
    :param file_types:       filter file types Default value = (("ALL Files", "*.* *"),).
    :type file_types:        Tuple[(str, str), ...]
    :param initial_folder:   starting path for folders and files
    :type initial_folder:
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param change_submits:   If True, pressing Enter key submits window (Default = False)
    :type change_submits:    (bool)
    :param enable_events:    Turns on the element specific events.(Default = False)
    :type enable_events:     (bool)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_BROWSE_FILE,
        target=target,
        file_types=file_types,
        initial_folder=initial_folder,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        change_submits=change_submits,
        enable_events=enable_events,
        disabled=disabled,
        button_color=button_color,
        font=font,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  FILES BROWSE Element (Multiple file selection) lazy function  ------------------------- #
def FilesBrowse(
    button_text='Browse',
    target=(ThisRow, -1),
    file_types=FILE_TYPES_ALL_FILES,
    disabled=False,
    initial_folder=None,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    change_submits=False,
    enable_events=False,
    font=None,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    files_delimiter=BROWSE_FILES_DELIMITER,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """
    Allows browsing of multiple files. File list is returned as a single list with the delimiter defined using the files_delimiter parameter.

    :param button_text:      text in the button (Default value = 'Browse')
    :type button_text:       (str)
    :param target:           key or (row,col) target for the button (Default value = (ThisRow, -1))
    :type target:            str | (int, int)
    :param file_types:       Default value = (("ALL Files", "*.* *"),).
    :type file_types:        Tuple[(str, str), ...]
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param initial_folder:   starting path for folders and files
    :type initial_folder:    (str)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param change_submits:   If True, pressing Enter key submits window (Default = False)
    :type change_submits:    (bool)
    :param enable_events:    Turns on the element specific events.(Default = False)
    :type enable_events:     (bool)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param files_delimiter:  String to place between files when multiple files are selected. Normally a ;
    :type files_delimiter:   str
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    button = Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_BROWSE_FILES,
        target=target,
        file_types=file_types,
        initial_folder=initial_folder,
        change_submits=change_submits,
        enable_events=enable_events,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        disabled=disabled,
        button_color=button_color,
        font=font,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )
    button._files_delimiter = files_delimiter
    return button


# -------------------------  FILE BROWSE Element lazy function  ------------------------- #
def FileSaveAs(
    button_text='Save As...',
    target=(ThisRow, -1),
    file_types=FILE_TYPES_ALL_FILES,
    initial_folder=None,
    default_extension='',
    disabled=False,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    change_submits=False,
    enable_events=False,
    font=None,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:       text in the button (Default value = 'Save As...')
    :type button_text:        (str)
    :param target:            key or (row,col) target for the button (Default value = (ThisRow, -1))
    :type target:             str | (int, int)
    :param file_types:        Default value = (("ALL Files", "*.* *"),).
    :type file_types:         Tuple[(str, str), ...]
    :param default_extension: If no extension entered by user, add this to filename (only used in saveas dialogs)
    :type default_extension:  (str)
    :param initial_folder:    starting path for folders and files
    :type initial_folder:     (str)
    :param disabled:          set disable state for element (Default = False)
    :type disabled:           (bool)
    :param tooltip:           text, that will appear when mouse hovers over the element
    :type tooltip:            (str)
    :param size:              (w,h) w=characters-wide, h=rows-high
    :type size:               (int, int)
    :param s:                 Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                  (int, int)  | (None, None) | int
    :param auto_size_button:  True if button size is determined by button text
    :type auto_size_button:   (bool)
    :param button_color:      button color (foreground, background)
    :type button_color:       (str, str) | str
    :param change_submits:    If True, pressing Enter key submits window (Default = False)
    :type change_submits:     (bool)
    :param enable_events:     Turns on the element specific events.(Default = False)
    :type enable_events:      (bool)
    :param font:              specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:               (str or (str, int[, str]) or None)
    :param pad:               Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:                (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                 Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                  (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:               key for uniquely identify this element (for window.find_element)
    :type key:                str | int | tuple | object
    :param k:                 Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                  str | int | tuple | object
    :param visible:           set initial visibility state of the Button
    :type visible:            (bool)
    :param metadata:          Anything you want to store along with this button
    :type metadata:           (Any)
    :param expand_x:          If True Element will expand in the Horizontal directions
    :type expand_x:           (bool)
    :param expand_y:          If True Element will expand in the Vertical directions
    :type expand_y:           (bool)        :return:                  returns a button
    :rtype:                   (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_SAVEAS_FILE,
        target=target,
        file_types=file_types,
        initial_folder=initial_folder,
        default_extension=default_extension,
        tooltip=tooltip,
        size=size,
        s=s,
        disabled=disabled,
        auto_size_button=auto_size_button,
        button_color=button_color,
        change_submits=change_submits,
        enable_events=enable_events,
        font=font,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  SAVE AS Element lazy function  ------------------------- #
def SaveAs(
    button_text='Save As...',
    target=(ThisRow, -1),
    file_types=FILE_TYPES_ALL_FILES,
    initial_folder=None,
    default_extension='',
    disabled=False,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    change_submits=False,
    enable_events=False,
    font=None,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:       text in the button (Default value = 'Save As...')
    :type button_text:        (str)
    :param target:            key or (row,col) target for the button (Default value = (ThisRow, -1))
    :type target:             str | (int, int)
    :param file_types:        Default value = (("ALL Files", "*.* *"),).
    :type file_types:         Tuple[(str, str), ...]
    :param default_extension: If no extension entered by user, add this to filename (only used in saveas dialogs)
    :type default_extension:  (str)
    :param initial_folder:    starting path for folders and files
    :type initial_folder:     (str)
    :param disabled:          set disable state for element (Default = False)
    :type disabled:           (bool)
    :param tooltip:           text, that will appear when mouse hovers over the element
    :type tooltip:            (str)
    :param size:              (w,h) w=characters-wide, h=rows-high
    :type size:               (int, int)
    :param s:                 Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                  (int, int)  | (None, None) | int
    :param auto_size_button:  True if button size is determined by button text
    :type auto_size_button:   (bool)
    :param button_color:      button color (foreground, background)
    :type button_color:       (str, str) or str
    :param change_submits:    If True, pressing Enter key submits window (Default = False)
    :type change_submits:     (bool)
    :param enable_events:     Turns on the element specific events.(Default = False)
    :type enable_events:      (bool)
    :param font:              specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:               (str or (str, int[, str]) or None)
    :param pad:               Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:                (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                 Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                  (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int    :param key:               key for uniquely identify this element (for window.find_element)
    :type key:                str | int | tuple | object
    :param k:                 Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                  str | int | tuple | object
    :param visible:           set initial visibility state of the Button
    :type visible:            (bool)
    :param metadata:          Anything you want to store along with this button
    :type metadata:           (Any)
    :param expand_x:          If True Element will expand in the Horizontal directions
    :type expand_x:           (bool)
    :param expand_y:          If True Element will expand in the Vertical directions
    :type expand_y:           (bool)
    :return:                  returns a button
    :rtype:                   (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_SAVEAS_FILE,
        target=target,
        file_types=file_types,
        initial_folder=initial_folder,
        default_extension=default_extension,
        tooltip=tooltip,
        size=size,
        s=s,
        disabled=disabled,
        auto_size_button=auto_size_button,
        button_color=button_color,
        change_submits=change_submits,
        enable_events=enable_events,
        font=font,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  SAVE BUTTON Element lazy function  ------------------------- #
def Save(
    button_text='Save',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    bind_return_key=True,
    disabled=False,
    tooltip=None,
    font=None,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Save')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param bind_return_key:  (Default = True) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param focus:            if focus should be set to this
    :type focus:             idk_yetReally
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  SUBMIT BUTTON Element lazy function  ------------------------- #
def Submit(
    button_text='Submit',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    bind_return_key=True,
    tooltip=None,
    font=None,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Submit')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param bind_return_key:  (Default = True) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param focus:            if focus should be set to this
    :type focus:             idk_yetReally
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  OPEN BUTTON Element lazy function  ------------------------- #
# -------------------------  OPEN BUTTON Element lazy function  ------------------------- #
def Open(
    button_text='Open',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    bind_return_key=True,
    tooltip=None,
    font=None,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Open')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param bind_return_key:  (Default = True) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param focus:            if focus should be set to this
    :type focus:             idk_yetReally
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  OK BUTTON Element lazy function  ------------------------- #
def OK(
    button_text='OK',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    bind_return_key=True,
    tooltip=None,
    font=None,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'OK')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param bind_return_key:  (Default = True) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param focus:            if focus should be set to this
    :type focus:             idk_yetReally
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  YES BUTTON Element lazy function  ------------------------- #
def Ok(
    button_text='Ok',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    bind_return_key=True,
    tooltip=None,
    font=None,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Ok')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param bind_return_key:  (Default = True) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param focus:            if focus should be set to this
    :type focus:             idk_yetReally
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  CANCEL BUTTON Element lazy function  ------------------------- #
def Cancel(
    button_text='Cancel',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    tooltip=None,
    font=None,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Cancel')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  QUIT BUTTON Element lazy function  ------------------------- #
def Quit(
    button_text='Quit',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    tooltip=None,
    font=None,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Quit')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:             (bool)
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  Exit BUTTON Element lazy function  ------------------------- #
def Exit(
    button_text='Exit',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    tooltip=None,
    font=None,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Exit')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  YES BUTTON Element lazy function  ------------------------- #
def Yes(
    button_text='Yes',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    tooltip=None,
    font=None,
    bind_return_key=True,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Yes')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = True) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  NO BUTTON Element lazy function  ------------------------- #
def No(
    button_text='No',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    tooltip=None,
    font=None,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'No')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, then the return key will cause a the Listbox to generate an event
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  NO BUTTON Element lazy function  ------------------------- #
def Help(
    button_text='Help',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    font=None,
    tooltip=None,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button (Default value = 'Help')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  NO BUTTON Element lazy function  ------------------------- #
def Debug(
    button_text='',
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    font=None,
    tooltip=None,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """
    This Button has been changed in how it works!!
    Your button has been replaced with a normal button that has the PySimpleGUI Debugger buggon logo on it.
    In your event loop, you will need to check for the event of this button and then call:
            show_debugger_popout_window()
    :param button_text:      text in the button (Default value = '')
    :type button_text:       (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """

    user_key = key if key is not None else k if k is not None else button_text

    return Button(
        button_text='',
        button_type=BUTTON_TYPE_READ_FORM,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=theme_button_color(),
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=user_key,
        k=k,
        visible=visible,
        image_data=PSG_DEBUGGER_LOGO,
        image_subsample=2,
        border_width=0,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  GENERIC BUTTON Element lazy function  ------------------------- #
def SimpleButton(
    button_text,
    image_filename=None,
    image_data=None,
    image_size=(None, None),
    image_subsample=None,
    border_width=None,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    font=None,
    bind_return_key=False,
    disabled=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """
    DEPIRCATED

    This Button should not be used.

    :param button_text:      text in the button
    :type button_text:       (str)
    :param image_filename:   image filename if there is a button image
    :type image_filename:    image filename if there is a button image
    :param image_data:       in-RAM image to be displayed on button
    :type image_data:        in-RAM image to be displayed on button
    :param image_size:       image size (O.K.)
    :type image_size:        (Default = (None))
    :param image_subsample:  amount to reduce the size of the image
    :type image_subsample:   amount to reduce the size of the image
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param focus:            if focus should be set to this
    :type focus:             idk_yetReally
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_CLOSES_WIN,
        image_filename=image_filename,
        image_data=image_data,
        image_size=image_size,
        image_subsample=image_subsample,
        border_width=border_width,
        tooltip=tooltip,
        disabled=disabled,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  CLOSE BUTTON Element lazy function  ------------------------- #
def CloseButton(
    button_text,
    image_filename=None,
    image_data=None,
    image_size=(None, None),
    image_subsample=None,
    border_width=None,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    font=None,
    bind_return_key=False,
    disabled=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """
    DEPRICATED

    This button should not be used.  Instead explicitly close your windows by calling window.close() or by using
    the close parameter in window.read

    :param button_text:      text in the button
    :type button_text:       (str)
    :param image_filename:   image filename if there is a button image
    :type image_filename:    image filename if there is a button image
    :param image_data:       in-RAM image to be displayed on button
    :type image_data:        in-RAM image to be displayed on button
    :param image_size:       image size (O.K.)
    :type image_size:        (Default = (None))
    :param image_subsample:  amount to reduce the size of the image
    :type image_subsample:   amount to reduce the size of the image
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param focus:            if focus should be set to this
    :type focus:             idk_yetReally
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_CLOSES_WIN,
        image_filename=image_filename,
        image_data=image_data,
        image_size=image_size,
        image_subsample=image_subsample,
        border_width=border_width,
        tooltip=tooltip,
        disabled=disabled,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


CButton = CloseButton


# -------------------------  GENERIC BUTTON Element lazy function  ------------------------- #
def ReadButton(
    button_text,
    image_filename=None,
    image_data=None,
    image_size=(None, None),
    image_subsample=None,
    border_width=None,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    font=None,
    bind_return_key=False,
    disabled=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """
    :param button_text:      text in the button
    :type button_text:       (str)
    :param image_filename:   image filename if there is a button image
    :type image_filename:    image filename if there is a button image
    :param image_data:       in-RAM image to be displayed on button
    :type image_data:        in-RAM image to be displayed on button
    :param image_size:       image size (O.K.)
    :type image_size:        (Default = (None))
    :param image_subsample:  amount to reduce the size of the image
    :type image_subsample:   amount to reduce the size of the image
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param focus:            if focus should be set to this
    :type focus:             idk_yetReally
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param border_width:     width of border around element
    :type border_width:      (int)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 Button created
    :rtype:                  (Button)
    """

    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_READ_FORM,
        image_filename=image_filename,
        image_data=image_data,
        image_size=image_size,
        image_subsample=image_subsample,
        border_width=border_width,
        tooltip=tooltip,
        size=size,
        s=s,
        disabled=disabled,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


ReadFormButton = ReadButton
RButton = ReadFormButton


# -------------------------  Realtime BUTTON Element lazy function  ------------------------- #
def RealtimeButton(
    button_text,
    image_filename=None,
    image_data=None,
    image_size=(None, None),
    image_subsample=None,
    border_width=None,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    font=None,
    disabled=False,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button
    :type button_text:       (str)
    :param image_filename:   image filename if there is a button image
    :type image_filename:    image filename if there is a button image
    :param image_data:       in-RAM image to be displayed on button
    :type image_data:        in-RAM image to be displayed on button
    :param image_size:       image size (O.K.)
    :type image_size:        (Default = (None))
    :param image_subsample:  amount to reduce the size of the image
    :type image_subsample:   amount to reduce the size of the image
    :param border_width:     width of border around element
    :type border_width:      (int)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:             (bool)
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 Button created
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_REALTIME,
        image_filename=image_filename,
        image_data=image_data,
        image_size=image_size,
        image_subsample=image_subsample,
        border_width=border_width,
        tooltip=tooltip,
        disabled=disabled,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  Dummy BUTTON Element lazy function  ------------------------- #
def DummyButton(
    button_text,
    image_filename=None,
    image_data=None,
    image_size=(None, None),
    image_subsample=None,
    border_width=None,
    tooltip=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    font=None,
    disabled=False,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """
    This is a special type of Button.

    It will close the window but NOT send an event that the window has been closed.

    It's used in conjunction with non-blocking windows to silently close them.  They are used to
    implement the non-blocking popup windows. They're also found in some Demo Programs, so look there for proper use.

    :param button_text:      text in the button
    :type button_text:       (str)
    :param image_filename:   image filename if there is a button image
    :type image_filename:    image filename if there is a button image
    :param image_data:       in-RAM image to be displayed on button
    :type image_data:        in-RAM image to be displayed on button
    :param image_size:       image size (O.K.)
    :type image_size:        (Default = (None))
    :param image_subsample:  amount to reduce the size of the image
    :type image_subsample:   amount to reduce the size of the image
    :param border_width:     width of border around element
    :type border_width:      (int)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            if focus should be set to this
    :type focus:             (bool)
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         Anything you want to store along with this button
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    return Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_CLOSES_WIN_ONLY,
        image_filename=image_filename,
        image_data=image_data,
        image_size=image_size,
        image_subsample=image_subsample,
        border_width=border_width,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )


# -------------------------  Calendar Chooser Button lazy function  ------------------------- #
def CalendarButton(
    button_text,
    target=(ThisRow, -1),
    close_when_date_chosen=True,
    default_date_m_d_y=(None, None, None),
    image_filename=None,
    image_data=None,
    image_size=(None, None),
    image_subsample=None,
    tooltip=None,
    border_width=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    font=None,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    enable_events=None,
    key=None,
    k=None,
    visible=True,
    locale=None,
    format='%Y-%m-%d %H:%M:%S',
    begin_at_sunday_plus=0,
    month_names=None,
    day_abbreviations=None,
    title='Choose Date',
    no_titlebar=True,
    location=(None, None),
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """
    Button that will show a calendar chooser window.  Fills in the target element with result

    :param button_text:            text in the button
    :type button_text:             (str)
    :param target:                 Key or "coordinate" (see docs) of target element
    :type target:                  (int, int) | Any
    :param close_when_date_chosen: (Default = True)
    :type close_when_date_chosen:  bool
    :param default_date_m_d_y:     Beginning date to show
    :type default_date_m_d_y:      (int, int or None, int)
    :param image_filename:         image filename if there is a button image
    :type image_filename:          image filename if there is a button image
    :param image_data:             in-RAM image to be displayed on button
    :type image_data:              in-RAM image to be displayed on button
    :param image_size:             image size (O.K.)
    :type image_size:              (Default = (None))
    :param image_subsample:        amount to reduce the size of the image
    :type image_subsample:         amount to reduce the size of the image
    :param tooltip:                text, that will appear when mouse hovers over the element
    :type tooltip:                 (str)
    :param border_width:           width of border around element
    :type border_width:            width of border around element
    :param size:                   (w,h) w=characters-wide, h=rows-high
    :type size:                    (int, int)
    :param s:                      Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                       (int, int)  | (None, None) | int
    :param auto_size_button:       True if button size is determined by button text
    :type auto_size_button:        (bool)
    :param button_color:           button color (foreground, background)
    :type button_color:            (str, str) | str
    :param disabled:               set disable state for element (Default = False)
    :type disabled:                (bool)
    :param font:                   specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:                    (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:         bool
    :param focus:                  if focus should be set to this
    :type focus:                   bool
    :param pad:                    Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:                     (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                      Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                       (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:                    key for uniquely identify this element (for window.find_element)
    :type key:                     str | int | tuple | object
    :param k:                      Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                       str | int | tuple | object
    :param locale:                 defines the locale used to get day names
    :type locale:                  str
    :param format:                 formats result using this strftime format
    :type format:                  str
    :param begin_at_sunday_plus:   Determines the left-most day in the display. 0=sunday, 1=monday, etc
    :type begin_at_sunday_plus:    (int)
    :param month_names:            optional list of month names to use (should be 12 items)
    :type month_names:             List[str]
    :param day_abbreviations:      optional list of abbreviations to display as the day of week
    :type day_abbreviations:       List[str]
    :param title:                  Title shown on the date chooser window
    :type title:                   (str)
    :param no_titlebar:            if True no titlebar will be shown on the date chooser window
    :type no_titlebar:             bool
    :param location:               Location on the screen (x,y) to show the calendar popup window
    :type location:                (int, int)
    :param visible:                set initial visibility state of the Button
    :type visible:                 (bool)
    :param metadata:               Anything you want to store along with this button
    :type metadata:                (Any)
    :param expand_x:               If True Element will expand in the Horizontal directions
    :type expand_x:                (bool)
    :param expand_y:               If True Element will expand in the Vertical directions
    :type expand_y:                (bool)
    :return:                       returns a button
    :rtype:                        (Button)
    """
    button = Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_CALENDAR_CHOOSER,
        target=target,
        image_filename=image_filename,
        image_data=image_data,
        image_size=image_size,
        image_subsample=image_subsample,
        border_width=border_width,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        enable_events=enable_events,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )
    button.calendar_close_when_chosen = close_when_date_chosen
    button.calendar_default_date_M_D_Y = default_date_m_d_y
    button.calendar_locale = locale
    button.calendar_format = format
    button.calendar_no_titlebar = no_titlebar
    button.calendar_location = location
    button.calendar_begin_at_sunday_plus = begin_at_sunday_plus
    button.calendar_month_names = month_names
    button.calendar_day_abbreviations = day_abbreviations
    button.calendar_title = title

    return button


# -------------------------  Calendar Chooser Button lazy function  ------------------------- #
def ColorChooserButton(
    button_text,
    target=(ThisRow, -1),
    image_filename=None,
    image_data=None,
    image_size=(None, None),
    image_subsample=None,
    tooltip=None,
    border_width=None,
    size=(None, None),
    s=(None, None),
    auto_size_button=None,
    button_color=None,
    disabled=False,
    font=None,
    bind_return_key=False,
    focus=False,
    pad=None,
    p=None,
    key=None,
    k=None,
    default_color=None,
    visible=True,
    metadata=None,
    expand_x=False,
    expand_y=False,
):
    """

    :param button_text:      text in the button
    :type button_text:       (str)
    :param target:           key or (row,col) target for the button. Note that -1 for column means 1 element to the left of this one. The constant ThisRow is used to indicate the current row. The Button itself is a valid target for some types of button
    :type target:            str | (int, int)
    :type image_filename:    (str)
    :param image_filename:   image filename if there is a button image. GIFs and PNGs only.
    :type image_filename:    (str)
    :param image_data:       Raw or Base64 representation of the image to put on button. Choose either filename or data
    :type image_data:        bytes | str
    :param image_size:       Size of the image in pixels (width, height)
    :type image_size:        (int, int)
    :param image_subsample:  amount to reduce the size of the image. Divides the size by this number. 2=1/2, 3=1/3, 4=1/4, etc
    :type image_subsample:   (int)
    :param tooltip:          text, that will appear when mouse hovers over the element
    :type tooltip:           (str)
    :param border_width:     width of border around element
    :type border_width:      (int)
    :param size:             (w,h) w=characters-wide, h=rows-high
    :type size:              (int, int)
    :param s:                Same as size parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, size will be used
    :type s:                 (int, int)  | (None, None) | int
    :param auto_size_button: True if button size is determined by button text
    :type auto_size_button:  (bool)
    :param button_color:     button color (foreground, background)
    :type button_color:      (str, str) | str
    :param disabled:         set disable state for element (Default = False)
    :type disabled:          (bool)
    :param font:             specifies the  font family, size, etc. Tuple or Single string format 'name size styles'. Styles: italic * roman bold normal underline overstrike
    :type font:              (str or (str, int[, str]) or None)
    :param bind_return_key:  (Default = False) If True, this button will appear to be clicked when return key is pressed in other elements such as Input and elements with return key options
    :type bind_return_key:   (bool)
    :param focus:            Determines if initial focus should go to this element.
    :type focus:             (bool)
    :param pad:              Amount of padding to put around element in pixels (left/right, top/bottom) or ((left, right), (top, bottom)) or an int. If an int, then it's converted into a tuple (int, int)
    :type pad:               (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param p:                Same as pad parameter.  It's an alias. If EITHER of them are set, then the one that's set will be used. If BOTH are set, pad will be used
    :type p:                 (int, int) or ((int, int),(int,int)) or (int,(int,int)) or  ((int, int),int) | int
    :param key:              key for uniquely identify this element (for window.find_element)
    :type key:               str | int | tuple | object
    :param k:                Same as the Key. You can use either k or key. Which ever is set will be used.
    :type k:                 str | int | tuple | object
    :param default_color:    Color to be sent to tkinter to use as the default color
    :type default_color:     str
    :param visible:          set initial visibility state of the Button
    :type visible:           (bool)
    :param metadata:         User metadata that can be set to ANYTHING
    :type metadata:          (Any)
    :param expand_x:         If True Element will expand in the Horizontal directions
    :type expand_x:          (bool)
    :param expand_y:         If True Element will expand in the Vertical directions
    :type expand_y:          (bool)
    :return:                 returns a button
    :rtype:                  (Button)
    """
    button = Button(
        button_text=button_text,
        button_type=BUTTON_TYPE_COLOR_CHOOSER,
        target=target,
        image_filename=image_filename,
        image_data=image_data,
        image_size=image_size,
        image_subsample=image_subsample,
        border_width=border_width,
        tooltip=tooltip,
        size=size,
        s=s,
        auto_size_button=auto_size_button,
        button_color=button_color,
        font=font,
        disabled=disabled,
        bind_return_key=bind_return_key,
        focus=focus,
        pad=pad,
        p=p,
        key=key,
        k=k,
        visible=visible,
        metadata=metadata,
        expand_x=expand_x,
        expand_y=expand_y,
    )
    button.default_color = default_color
    return button


#####################################  -----  RESULTS   ------ ##################################################


def AddToReturnDictionary(form, element, value):
    form.ReturnValuesDictionary[element.Key] = value


def AddToReturnList(form, value):
    form.ReturnValuesList.append(value)


# ----------------------------------------------------------------------------#
# -------  FUNCTION InitializeResults.  Sets up form results matrix  --------#
def InitializeResults(form):
    _BuildResults(form, True, form)
    return


# =====  Radio Button RadVar encoding and decoding =====#
# =====  The value is simply the row * 1000 + col  =====#
def DecodeRadioRowCol(RadValue):
    container = RadValue // 100000
    row = RadValue // 1000
    col = RadValue % 1000
    return container, row, col


def EncodeRadioRowCol(container, row, col):
    RadValue = container * 100000 + row * 1000 + col
    return RadValue


# -------  FUNCTION BuildResults.  Form exiting so build the results to pass back  ------- #
# format of return values is
# (Button Pressed, input_values)
def _BuildResults(form, initialize_only, top_level_form):
    # Results for elements are:
    #   TEXT - Nothing
    #   INPUT - Read value from TK
    #   Button - Button Text and position as a Tuple

    # Get the initialized results so we don't have to rebuild
    form.ReturnValuesDictionary = {}
    form.ReturnValuesList = []
    _BuildResultsForSubform(form, initialize_only, top_level_form)
    if not top_level_form.LastButtonClickedWasRealtime:
        top_level_form.LastButtonClicked = None
    return form.ReturnValues


def _BuildResultsForSubform(form, initialize_only, top_level_form):
    event = top_level_form.LastButtonClicked
    for row_num, row in enumerate(form.Rows):
        for col_num, element in enumerate(row):
            if element.Key is not None and WRITE_ONLY_KEY in str(element.Key):
                continue
            value = None
            if element.Type == ELEM_TYPE_COLUMN:
                element.DictionaryKeyCounter = top_level_form.DictionaryKeyCounter
                element.ReturnValuesList = []
                element.ReturnValuesDictionary = {}
                _BuildResultsForSubform(element, initialize_only, top_level_form)
                for item in element.ReturnValuesList:
                    AddToReturnList(top_level_form, item)
                if element.UseDictionary:
                    top_level_form.UseDictionary = True
                if element.ReturnValues[0] is not None:  # if a button was clicked
                    event = element.ReturnValues[0]

            if element.Type == ELEM_TYPE_FRAME:
                element.DictionaryKeyCounter = top_level_form.DictionaryKeyCounter
                element.ReturnValuesList = []
                element.ReturnValuesDictionary = {}
                _BuildResultsForSubform(element, initialize_only, top_level_form)
                for item in element.ReturnValuesList:
                    AddToReturnList(top_level_form, item)
                if element.UseDictionary:
                    top_level_form.UseDictionary = True
                if element.ReturnValues[0] is not None:  # if a button was clicked
                    event = element.ReturnValues[0]

            if element.Type == ELEM_TYPE_PANE:
                element.DictionaryKeyCounter = top_level_form.DictionaryKeyCounter
                element.ReturnValuesList = []
                element.ReturnValuesDictionary = {}
                _BuildResultsForSubform(element, initialize_only, top_level_form)
                for item in element.ReturnValuesList:
                    AddToReturnList(top_level_form, item)
                if element.UseDictionary:
                    top_level_form.UseDictionary = True
                if element.ReturnValues[0] is not None:  # if a button was clicked
                    event = element.ReturnValues[0]

            if element.Type == ELEM_TYPE_TAB_GROUP:
                element.DictionaryKeyCounter = top_level_form.DictionaryKeyCounter
                element.ReturnValuesList = []
                element.ReturnValuesDictionary = {}
                _BuildResultsForSubform(element, initialize_only, top_level_form)
                for item in element.ReturnValuesList:
                    AddToReturnList(top_level_form, item)
                if element.UseDictionary:
                    top_level_form.UseDictionary = True
                if element.ReturnValues[0] is not None:  # if a button was clicked
                    event = element.ReturnValues[0]

            if element.Type == ELEM_TYPE_TAB:
                element.DictionaryKeyCounter = top_level_form.DictionaryKeyCounter
                element.ReturnValuesList = []
                element.ReturnValuesDictionary = {}
                _BuildResultsForSubform(element, initialize_only, top_level_form)
                for item in element.ReturnValuesList:
                    AddToReturnList(top_level_form, item)
                if element.UseDictionary:
                    top_level_form.UseDictionary = True
                if element.ReturnValues[0] is not None:  # if a button was clicked
                    event = element.ReturnValues[0]

            if not initialize_only:
                if element.Type == ELEM_TYPE_INPUT_TEXT:
                    try:
                        value = element.TKStringVar.get()
                    except:
                        value = ''
                    if not top_level_form.NonBlocking and not element.do_not_clear and not top_level_form.ReturnKeyboardEvents:
                        element.TKStringVar.set('')
                elif element.Type == ELEM_TYPE_INPUT_CHECKBOX:
                    value = element.TKIntVar.get()
                    value = value != 0
                elif element.Type == ELEM_TYPE_INPUT_RADIO:
                    RadVar = element.TKIntVar.get()
                    this_rowcol = EncodeRadioRowCol(form.ContainerElemementNumber, row_num, col_num)
                    # this_rowcol = element.EncodedRadioValue       # could use the saved one
                    value = RadVar == this_rowcol
                elif element.Type == ELEM_TYPE_BUTTON:
                    if top_level_form.LastButtonClicked == element.Key:
                        event = top_level_form.LastButtonClicked
                        if element.BType != BUTTON_TYPE_REALTIME:  # Do not clear realtime buttons
                            top_level_form.LastButtonClicked = None
                    if element.BType == BUTTON_TYPE_CALENDAR_CHOOSER:
                        # value = None
                        value = element.calendar_selection
                    else:
                        try:
                            value = element.TKStringVar.get()
                        except:
                            value = None
                elif element.Type == ELEM_TYPE_INPUT_COMBO:
                    element = element  # type: Combo
                    try:
                        if element.TKCombo.current() == -1:  # if the current value was not in the original list
                            value = element.TKCombo.get()
                        else:
                            value = element.Values[element.TKCombo.current()]  # get value from original list given index
                    except:
                        value = '*Exception occurred*'
                elif element.Type == ELEM_TYPE_INPUT_OPTION_MENU:
                    value = element.TKStringVar.get()
                elif element.Type == ELEM_TYPE_INPUT_LISTBOX:
                    try:
                        items = element.TKListbox.curselection()
                        value = [element.Values[int(item)] for item in items]
                    except Exception:
                        value = ''
                elif element.Type == ELEM_TYPE_INPUT_SPIN:
                    try:
                        value = element.TKStringVar.get()
                        for v in element.Values:
                            if str(v) == value:
                                value = v
                                break
                    except:
                        value = 0
                elif element.Type == ELEM_TYPE_INPUT_SLIDER:
                    try:
                        value = float(element.TKScale.get())
                    except:
                        value = 0
                elif element.Type == ELEM_TYPE_INPUT_MULTILINE:
                    if element.WriteOnly:  # if marked as "write only" when created, then don't include with the values being returned
                        continue
                    try:
                        value = element.TKText.get(1.0, tk.END)
                        if element.rstrip:
                            value = value.rstrip()
                        if not top_level_form.NonBlocking and not element.do_not_clear and not top_level_form.ReturnKeyboardEvents:
                            element.TKText.delete('1.0', tk.END)
                    except:
                        value = None
                elif element.Type == ELEM_TYPE_TAB_GROUP:
                    try:
                        value = element.TKNotebook.tab(element.TKNotebook.index('current'))['text']
                        tab_key = element.find_currently_active_tab_key()
                        # tab_key = element.FindKeyFromTabName(value)
                        if tab_key is not None:
                            value = tab_key
                    except:
                        value = None
                elif element.Type == ELEM_TYPE_TABLE:
                    value = element.SelectedRows
                elif element.Type == ELEM_TYPE_TREE:
                    value = element.SelectedRows
                elif element.Type == ELEM_TYPE_GRAPH:
                    value = element.ClickPosition
                elif element.Type == ELEM_TYPE_MENUBAR:
                    if element.MenuItemChosen is not None:
                        event = top_level_form.LastButtonClicked = element.MenuItemChosen
                    value = element.MenuItemChosen
                    element.MenuItemChosen = None
                elif element.Type == ELEM_TYPE_BUTTONMENU:
                    element = element  # type: ButtonMenu
                    value = element.MenuItemChosen
                    if element.part_of_custom_menubar:
                        if element.MenuItemChosen is not None:
                            value = event = element.MenuItemChosen
                            top_level_form.LastButtonClicked = element.MenuItemChosen
                            if element.custom_menubar_key is not None:
                                top_level_form.ReturnValuesDictionary[element.custom_menubar_key] = value
                            element.MenuItemChosen = None
                        else:
                            if element.custom_menubar_key not in top_level_form.ReturnValuesDictionary:
                                top_level_form.ReturnValuesDictionary[element.custom_menubar_key] = None
                            value = None

            else:
                value = None

            # if an input type element, update the results
            if element.Type not in (
                ELEM_TYPE_BUTTON,
                ELEM_TYPE_TEXT,
                ELEM_TYPE_IMAGE,
                ELEM_TYPE_OUTPUT,
                ELEM_TYPE_PROGRESS_BAR,
                ELEM_TYPE_COLUMN,
                ELEM_TYPE_FRAME,
                ELEM_TYPE_SEPARATOR,
                ELEM_TYPE_TAB,
            ):
                if not (element.Type == ELEM_TYPE_BUTTONMENU and element.part_of_custom_menubar):
                    AddToReturnList(form, value)
                    AddToReturnDictionary(top_level_form, element, value)
            elif (element.Type == ELEM_TYPE_BUTTON and element.BType == BUTTON_TYPE_COLOR_CHOOSER and element.Target == (None, None)) or (
                element.Type == ELEM_TYPE_BUTTON
                and element.Key is not None
                and (
                    element.BType
                    in (
                        BUTTON_TYPE_SAVEAS_FILE,
                        BUTTON_TYPE_BROWSE_FILE,
                        BUTTON_TYPE_BROWSE_FILES,
                        BUTTON_TYPE_BROWSE_FOLDER,
                        BUTTON_TYPE_CALENDAR_CHOOSER,
                    )
                )
            ):
                AddToReturnList(form, value)
                AddToReturnDictionary(top_level_form, element, value)

    # if this is a column, then will fail so need to wrap with try
    try:
        if form.ReturnKeyboardEvents and form.LastKeyboardEvent is not None:
            event = form.LastKeyboardEvent
            form.LastKeyboardEvent = None
    except:
        pass

    try:
        form.ReturnValuesDictionary.pop(None, None)  # clean up dictionary include None was included
    except:
        pass

    # if no event was found
    if not initialize_only and event is None and form == top_level_form:
        queued_event_value = form._queued_thread_event_read()
        if queued_event_value is not None:
            event, value = queued_event_value
            AddToReturnList(form, value)
            form.ReturnValuesDictionary[event] = value

    if not form.UseDictionary:
        form.ReturnValues = event, form.ReturnValuesList
    else:
        form.ReturnValues = event, form.ReturnValuesDictionary

    return form.ReturnValues


def fill_form_with_values(window, values_dict):
    """
    Fills a window with values provided in a values dictionary { element_key : new_value }

    :param window:      The window object to fill
    :type window:       (Window)
    :param values_dict: A dictionary with element keys as key and value is values parm for Update call
    :type values_dict:  (Dict[Any, Any])
    :return:            None
    :rtype:             None
    """

    for element_key in values_dict:
        try:
            window.AllKeysDict[element_key].Update(values_dict[element_key])
        except Exception:
            print(f'Problem filling form. Perhaps bad key?  This is a suspected bad key: {element_key}')


def _FindElementWithFocusInSubForm(form):
    """
    Searches through a "sub-form" (can be a window or container) for the current element with focus

    :param form: a Window, Column, Frame, or TabGroup (container elements)
    :type form:  container elements
    :return:     Element
    :rtype:      Element | None
    """
    for row_num, row in enumerate(form.Rows):
        for col_num, element in enumerate(row):
            if element.Type == ELEM_TYPE_COLUMN:
                matching_elem = _FindElementWithFocusInSubForm(element)
                if matching_elem is not None:
                    return matching_elem
            elif element.Type == ELEM_TYPE_FRAME:
                matching_elem = _FindElementWithFocusInSubForm(element)
                if matching_elem is not None:
                    return matching_elem
            elif element.Type == ELEM_TYPE_TAB_GROUP:
                matching_elem = _FindElementWithFocusInSubForm(element)
                if matching_elem is not None:
                    return matching_elem
            elif element.Type == ELEM_TYPE_TAB:
                matching_elem = _FindElementWithFocusInSubForm(element)
                if matching_elem is not None:
                    return matching_elem
            elif element.Type == ELEM_TYPE_PANE:
                matching_elem = _FindElementWithFocusInSubForm(element)
                if matching_elem is not None:
                    return matching_elem
            elif element.Type == ELEM_TYPE_INPUT_TEXT:
                if element.TKEntry is not None:
                    if element.TKEntry is element.TKEntry.focus_get():
                        return element
            elif element.Type == ELEM_TYPE_INPUT_MULTILINE:
                if element.TKText is not None:
                    if element.TKText is element.TKText.focus_get():
                        return element
            elif element.Type == ELEM_TYPE_BUTTON:
                if element.TKButton is not None:
                    if element.TKButton is element.TKButton.focus_get():
                        return element
            else:  # The "Catch All" - if type isn't one of the above, try generic element.Widget
                try:
                    if element.Widget is not None:
                        if element.Widget is element.Widget.focus_get():
                            return element
                except:
                    return None

    return None


# 888    888      d8b          888
# 888    888      Y8P          888
# 888    888                   888
# 888888 888  888 888 88888b.  888888  .d88b.  888d888
# 888    888 .88P 888 888 "88b 888    d8P  Y8b 888P"
# 888    888888K  888 888  888 888    88888888 888
# Y88b.  888 "88b 888 888  888 Y88b.  Y8b.     888
#  "Y888 888  888 888 888  888  "Y888  "Y8888  888

# My crappy tkinter code starts here.  (search for "crappy" to get here quickly... that's the purpose if you hadn't caught on

"""
         )
        (
          ,
       ___)\
      (_____)
      (_______)

"""


# Chr0nic || This is probably *very* bad practice. But it works. Simple, but it works...
class VarHolder:
    canvas_holder = None

    def __init__(self):
        self.canvas_holder = None


# Also, to get to the point in the code where each element's widget is created, look for element + "p lacement" (without the space)


# ========================   TK CODE STARTS HERE ========================================= #
def _fixed_map(style, style_name, option, highlight_colors=(None, None)):
    # Fix for setting text colour for Tkinter 8.6.9
    # From: https://core.tcl.tk/tk/info/509cafafae

    # default_map = [elm for elm in style.map("Treeview", query_opt=option) if '!' not in elm[0]]
    # custom_map = [elm for elm in style.map(style_name, query_opt=option) if '!' not in elm[0]]
    default_map = [elm for elm in style.map('Treeview', query_opt=option) if '!' not in elm[0] and 'selected' not in elm[0]]
    custom_map = [elm for elm in style.map(style_name, query_opt=option) if '!' not in elm[0] and 'selected' not in elm[0]]
    if option == 'background':
        custom_map.append(
            (
                'selected',
                (highlight_colors[1] if highlight_colors[1] is not None else ALTERNATE_TABLE_AND_TREE_SELECTED_ROW_COLORS[1]),
            )
        )
    elif option == 'foreground':
        custom_map.append(
            (
                'selected',
                (highlight_colors[0] if highlight_colors[0] is not None else ALTERNATE_TABLE_AND_TREE_SELECTED_ROW_COLORS[0]),
            )
        )

    new_map = custom_map + default_map
    return new_map


def _add_right_click_menu(element, toplevel_form):
    if element.RightClickMenu == MENU_RIGHT_CLICK_DISABLED:
        return
    if element.RightClickMenu or toplevel_form.RightClickMenu:
        menu = element.RightClickMenu or toplevel_form.RightClickMenu
        top_menu = tk.Menu(
            toplevel_form.TKroot,
            tearoff=toplevel_form.right_click_menu_tearoff,
            tearoffcommand=element._tearoff_menu_callback,
        )

        if toplevel_form.right_click_menu_background_color not in (COLOR_SYSTEM_DEFAULT, None):
            top_menu.config(bg=toplevel_form.right_click_menu_background_color)
        if toplevel_form.right_click_menu_text_color not in (COLOR_SYSTEM_DEFAULT, None):
            top_menu.config(fg=toplevel_form.right_click_menu_text_color)
        if toplevel_form.right_click_menu_disabled_text_color not in (COLOR_SYSTEM_DEFAULT, None):
            top_menu.config(disabledforeground=toplevel_form.right_click_menu_disabled_text_color)
        if toplevel_form.right_click_menu_font is not None:
            top_menu.config(font=toplevel_form.right_click_menu_font)

        if toplevel_form.right_click_menu_selected_colors[0] not in (COLOR_SYSTEM_DEFAULT, None):
            top_menu.config(activeforeground=toplevel_form.right_click_menu_selected_colors[0])
        if toplevel_form.right_click_menu_selected_colors[1] not in (COLOR_SYSTEM_DEFAULT, None):
            top_menu.config(activebackground=toplevel_form.right_click_menu_selected_colors[1])
        AddMenuItem(top_menu, menu[1], element, right_click_menu=True)
        element.TKRightClickMenu = top_menu
        if running_mac():
            element.Widget.bind('<ButtonRelease-2>', element._RightClickMenuCallback)
        else:
            element.Widget.bind('<ButtonRelease-3>', element._RightClickMenuCallback)


def _change_ttk_theme(style, theme_name):
    global ttk_theme_in_use
    if theme_name not in style.theme_names():
        _error_popup_with_traceback(
            f'You are trying to use TTK theme "{theme_name}"',
            'This is not legal for your system',
            'The valid themes to choose from are: {}'.format(', '.join(style.theme_names())),
        )
        return False

    style.theme_use(theme_name)
    ttk_theme_in_use = theme_name
    return True


def _make_ttk_style_name(base_style, element, primary_style=False):
    Window._counter_for_ttk_widgets += 1
    style_name = str(Window._counter_for_ttk_widgets) + '___' + str(element.Key) + base_style
    if primary_style:
        element.ttk_style_name = style_name
    return style_name


def _make_ttk_scrollbar(element, orientation, window):
    """
    Creates a ttk scrollbar for elements as they are being added to the layout

    :param element:     The element
    :type element:      (Element)
    :param orientation: The orientation vertical ('v') or horizontal ('h')
    :type orientation:  (str)
    :param window:      The window containing the scrollbar
    :type window:       (Window)
    """

    style = ttk.Style()
    _change_ttk_theme(style, window.TtkTheme)
    if orientation[0].lower() == 'v':
        orient = 'vertical'
        style_name = _make_ttk_style_name('.Vertical.TScrollbar', element)
        # style_name_thumb = _make_ttk_style_name('.Vertical.TScrollbar.thumb', element)
        element.vsb_style = style
        element.vsb = ttk.Scrollbar(element.element_frame, orient=orient, command=element.Widget.yview, style=style_name)
        element.vsb_style_name = style_name
    else:
        orient = 'horizontal'
        style_name = _make_ttk_style_name('.Horizontal.TScrollbar', element)
        element.hsb_style = style
        element.hsb = ttk.Scrollbar(element.element_frame, orient=orient, command=element.Widget.xview, style=style_name)
        element.hsb_style_name = style_name

    # ------------------ Get the colors using heirarchy of element, window, options, settings ------------------
    # Trough Color
    if element.ttk_part_overrides.sbar_trough_color is not None:
        trough_color = element.ttk_part_overrides.sbar_trough_color
    elif window.ttk_part_overrides.sbar_trough_color is not None:
        trough_color = window.ttk_part_overrides.sbar_trough_color
    elif ttk_part_overrides_from_options.sbar_trough_color is not None:
        trough_color = ttk_part_overrides_from_options.sbar_trough_color
    else:
        trough_color = element.scroll_trough_color
    # Relief
    if element.ttk_part_overrides.sbar_relief is not None:
        scroll_relief = element.ttk_part_overrides.sbar_relief
    elif window.ttk_part_overrides.sbar_relief is not None:
        scroll_relief = window.ttk_part_overrides.sbar_relief
    elif ttk_part_overrides_from_options.sbar_relief is not None:
        scroll_relief = ttk_part_overrides_from_options.sbar_relief
    else:
        scroll_relief = element.scroll_relief
    # Frame Color
    if element.ttk_part_overrides.sbar_frame_color is not None:
        frame_color = element.ttk_part_overrides.sbar_frame_color
    elif window.ttk_part_overrides.sbar_frame_color is not None:
        frame_color = window.ttk_part_overrides.sbar_frame_color
    elif ttk_part_overrides_from_options.sbar_frame_color is not None:
        frame_color = ttk_part_overrides_from_options.sbar_frame_color
    else:
        frame_color = element.scroll_frame_color
    # Background Color
    if element.ttk_part_overrides.sbar_background_color is not None:
        background_color = element.ttk_part_overrides.sbar_background_color
    elif window.ttk_part_overrides.sbar_background_color is not None:
        background_color = window.ttk_part_overrides.sbar_background_color
    elif ttk_part_overrides_from_options.sbar_background_color is not None:
        background_color = ttk_part_overrides_from_options.sbar_background_color
    else:
        background_color = element.scroll_background_color
    # Arrow Color
    if element.ttk_part_overrides.sbar_arrow_color is not None:
        arrow_color = element.ttk_part_overrides.sbar_arrow_color
    elif window.ttk_part_overrides.sbar_arrow_color is not None:
        arrow_color = window.ttk_part_overrides.sbar_arrow_color
    elif ttk_part_overrides_from_options.sbar_arrow_color is not None:
        arrow_color = ttk_part_overrides_from_options.sbar_arrow_color
    else:
        arrow_color = element.scroll_arrow_color
    # Arrow Width
    if element.ttk_part_overrides.sbar_arrow_width is not None:
        arrow_width = element.ttk_part_overrides.sbar_arrow_width
    elif window.ttk_part_overrides.sbar_arrow_width is not None:
        arrow_width = window.ttk_part_overrides.sbar_arrow_width
    elif ttk_part_overrides_from_options.sbar_arrow_width is not None:
        arrow_width = ttk_part_overrides_from_options.sbar_arrow_width
    else:
        arrow_width = element.scroll_arrow_width
    # Scroll Width
    if element.ttk_part_overrides.sbar_width is not None:
        scroll_width = element.ttk_part_overrides.sbar_width
    elif window.ttk_part_overrides.sbar_width is not None:
        scroll_width = window.ttk_part_overrides.sbar_width
    elif ttk_part_overrides_from_options.sbar_width is not None:
        scroll_width = ttk_part_overrides_from_options.sbar_width
    else:
        scroll_width = element.scroll_width

    if trough_color not in (None, COLOR_SYSTEM_DEFAULT):
        style.configure(style_name, troughcolor=trough_color)

    if frame_color not in (None, COLOR_SYSTEM_DEFAULT):
        style.configure(style_name, framecolor=frame_color)
    if frame_color not in (None, COLOR_SYSTEM_DEFAULT):
        style.configure(style_name, bordercolor=frame_color)

    if (background_color not in (None, COLOR_SYSTEM_DEFAULT)) and (arrow_color not in (None, COLOR_SYSTEM_DEFAULT)):
        style.map(
            style_name,
            background=[
                ('selected', background_color),
                ('active', arrow_color),
                ('background', background_color),
                ('!focus', background_color),
            ],
        )
    if (background_color not in (None, COLOR_SYSTEM_DEFAULT)) and (arrow_color not in (None, COLOR_SYSTEM_DEFAULT)):
        style.map(
            style_name,
            arrowcolor=[
                ('selected', arrow_color),
                ('active', background_color),
                ('background', background_color),
                ('!focus', arrow_color),
            ],
        )

    if scroll_width not in (None, COLOR_SYSTEM_DEFAULT):
        style.configure(style_name, width=scroll_width)
    if arrow_width not in (None, COLOR_SYSTEM_DEFAULT):
        style.configure(style_name, arrowsize=arrow_width)

    if scroll_relief not in (None, COLOR_SYSTEM_DEFAULT):
        style.configure(style_name, relief=scroll_relief)


# @_timeit
def PackFormIntoFrame(form, containing_frame, toplevel_form):
    """

    :param form:             a window class
    :type form:              (Window)
    :param containing_frame: ???
    :type containing_frame:  ???
    :param toplevel_form:    ???
    :type toplevel_form:     (Window)

    """

    # Old bindings
    def yscroll_old(event):
        try:
            if event.num == 5 or event.delta < 0:
                VarHolder.canvas_holder.yview_scroll(1, 'unit')
            elif event.num == 4 or event.delta > 0:
                VarHolder.canvas_holder.yview_scroll(-1, 'unit')
        except:
            pass

    def xscroll_old(event):
        try:
            if event.num == 5 or event.delta < 0:
                VarHolder.canvas_holder.xview_scroll(1, 'unit')
            elif event.num == 4 or event.delta > 0:
                VarHolder.canvas_holder.xview_scroll(-1, 'unit')
        except:
            pass

    # Chr0nic
    def testMouseHook2(em):
        combo = em.TKCombo
        combo.unbind_class('TCombobox', '<MouseWheel>')
        combo.unbind_class('TCombobox', '<ButtonPress-4>')
        combo.unbind_class('TCombobox', '<ButtonPress-5>')
        containing_frame.unbind_all('<4>')
        containing_frame.unbind_all('<5>')
        containing_frame.unbind_all('<MouseWheel>')
        containing_frame.unbind_all('<Shift-MouseWheel>')

    # Chr0nic
    def testMouseUnhook2(em):
        containing_frame.bind_all('<4>', yscroll_old, add='+')
        containing_frame.bind_all('<5>', yscroll_old, add='+')
        containing_frame.bind_all('<MouseWheel>', yscroll_old, add='+')
        containing_frame.bind_all('<Shift-MouseWheel>', xscroll_old, add='+')

    # Chr0nic
    def testMouseHook(em):
        containing_frame.unbind_all('<4>')
        containing_frame.unbind_all('<5>')
        containing_frame.unbind_all('<MouseWheel>')
        containing_frame.unbind_all('<Shift-MouseWheel>')

    # Chr0nic
    def testMouseUnhook(em):
        containing_frame.bind_all('<4>', yscroll_old, add='+')
        containing_frame.bind_all('<5>', yscroll_old, add='+')
        containing_frame.bind_all('<MouseWheel>', yscroll_old, add='+')
        containing_frame.bind_all('<Shift-MouseWheel>', xscroll_old, add='+')

    def _char_width_in_pixels(font):
        return tkinter.font.Font(font=font).measure('A')  # single character width

    def _char_height_in_pixels(font):
        return tkinter.font.Font(font=font).metrics('linespace')

    def _string_width_in_pixels(font, string):
        return tkinter.font.Font(font=font).measure(string)  # single character width

    def _add_grab(element):
        try:
            if form.Grab is True or element.Grab is True:
                # if something already about to the button, then don't do the grab stuff
                if '<Button-1>' not in element.Widget.bind():
                    element.Widget.bind('<ButtonPress-1>', toplevel_form._StartMoveGrabAnywhere)
                    element.Widget.bind('<ButtonRelease-1>', toplevel_form._StopMove)
                    element.Widget.bind('<B1-Motion>', toplevel_form._OnMotionGrabAnywhere)
                element.ParentRowFrame.bind('<ButtonPress-1>', toplevel_form._StartMoveGrabAnywhere)
                element.ParentRowFrame.bind('<ButtonRelease-1>', toplevel_form._StopMove)
                element.ParentRowFrame.bind('<B1-Motion>', toplevel_form._OnMotionGrabAnywhere)
                if element.Type == ELEM_TYPE_COLUMN:
                    element.TKColFrame.canvas.bind('<ButtonPress-1>', toplevel_form._StartMoveGrabAnywhere)
                    element.TKColFrame.canvas.bind('<ButtonRelease-1>', toplevel_form._StopMove)
                    element.TKColFrame.canvas.bind('<B1-Motion>', toplevel_form._OnMotionGrabAnywhere)
        except Exception:
            pass
            # print(e)

    def _add_right_click_menu_and_grab(element):
        if element.RightClickMenu == MENU_RIGHT_CLICK_DISABLED:
            return
        if element.Type == ELEM_TYPE_TAB_GROUP:  # unless everything disabled, then need to always set a right click menu for tabgroups
            if toplevel_form.RightClickMenu == MENU_RIGHT_CLICK_DISABLED:
                return
            menu = _MENU_RIGHT_CLICK_TABGROUP_DEFAULT
        else:
            menu = element.RightClickMenu or form.RightClickMenu or toplevel_form.RightClickMenu

        if menu:
            top_menu = tk.Menu(
                toplevel_form.TKroot,
                tearoff=toplevel_form.right_click_menu_tearoff,
                tearoffcommand=element._tearoff_menu_callback,
            )

            if toplevel_form.right_click_menu_background_color not in (COLOR_SYSTEM_DEFAULT, None):
                top_menu.config(bg=toplevel_form.right_click_menu_background_color)
            if toplevel_form.right_click_menu_text_color not in (COLOR_SYSTEM_DEFAULT, None):
                top_menu.config(fg=toplevel_form.right_click_menu_text_color)
            if toplevel_form.right_click_menu_disabled_text_color not in (COLOR_SYSTEM_DEFAULT, None):
                top_menu.config(disabledforeground=toplevel_form.right_click_menu_disabled_text_color)
            if toplevel_form.right_click_menu_font is not None:
                top_menu.config(font=toplevel_form.right_click_menu_font)

            if toplevel_form.right_click_menu_selected_colors[0] not in (COLOR_SYSTEM_DEFAULT, None):
                top_menu.config(activeforeground=toplevel_form.right_click_menu_selected_colors[0])
            if toplevel_form.right_click_menu_selected_colors[1] not in (COLOR_SYSTEM_DEFAULT, None):
                top_menu.config(activebackground=toplevel_form.right_click_menu_selected_colors[1])
            AddMenuItem(top_menu, menu[1], element, right_click_menu=True)
            element.TKRightClickMenu = top_menu
            if toplevel_form.RightClickMenu:  # if the top level has a right click menu, then setup a callback for the Window itself
                if toplevel_form.TKRightClickMenu is None:
                    toplevel_form.TKRightClickMenu = top_menu
                    if running_mac():
                        toplevel_form.TKroot.bind('<ButtonRelease-2>', toplevel_form._RightClickMenuCallback)
                    else:
                        toplevel_form.TKroot.bind('<ButtonRelease-3>', toplevel_form._RightClickMenuCallback)
            if running_mac():
                element.Widget.bind('<ButtonRelease-2>', element._RightClickMenuCallback)
            else:
                element.Widget.bind('<ButtonRelease-3>', element._RightClickMenuCallback)
                try:
                    if element.Type == ELEM_TYPE_COLUMN:
                        element.TKColFrame.canvas.bind('<ButtonRelease-3>', element._RightClickMenuCallback)
                except:
                    pass
        _add_grab(element)

    def _add_expansion(element, row_should_expand, row_fill_direction):
        expand = True
        if element.expand_x and element.expand_y:
            fill = tk.BOTH
            row_fill_direction = tk.BOTH
            row_should_expand = True
        elif element.expand_x:
            fill = tk.X
            row_fill_direction = tk.X if row_fill_direction == tk.NONE else tk.BOTH if row_fill_direction == tk.Y else tk.X
        elif element.expand_y:
            fill = tk.Y
            row_fill_direction = tk.Y if row_fill_direction == tk.NONE else tk.BOTH if row_fill_direction == tk.X else tk.Y
            row_should_expand = True
        else:
            fill = tk.NONE
            expand = False
        return expand, fill, row_should_expand, row_fill_direction

    tclversion_detailed = tkinter.Tcl().eval('info patchlevel')

    # --------------------------------------------------------------------------- #
    # ****************  Use FlexForm to build the tkinter window ********** ----- #
    # Building is done row by row.                                                #
    # WARNING - You can't use print in this function. If the user has rerouted   #
    # stdout then there will be an error saying the window isn't finalized        #
    # --------------------------------------------------------------------------- #
    ######################### LOOP THROUGH ROWS #########################
    # *********** -------  Loop through ROWS  ------- ***********#
    for row_num, flex_row in enumerate(form.Rows):
        ######################### LOOP THROUGH ELEMENTS ON ROW #########################
        # *********** -------  Loop through ELEMENTS  ------- ***********#
        # *********** Make TK Row                             ***********#
        tk_row_frame = tk.Frame(containing_frame)
        row_should_expand = False
        row_fill_direction = tk.NONE

        if form.ElementJustification is not None:
            row_justify = form.ElementJustification
        else:
            row_justify = 'l'

        for col_num, element in enumerate(flex_row):
            element.ParentRowFrame = tk_row_frame
            element.element_frame = None  # for elements that have a scrollbar too
            element.ParentForm = toplevel_form  # save the button's parent form object
            if toplevel_form.Font and (element.Font == DEFAULT_FONT or element.Font is None):
                font = toplevel_form.Font
            elif element.Font is not None:
                font = element.Font
            else:
                font = DEFAULT_FONT
            # -------  Determine Auto-Size setting on a cascading basis ------- #
            if element.AutoSizeText is not None:  # if element overide
                auto_size_text = element.AutoSizeText
            elif toplevel_form.AutoSizeText is not None:  # if form override
                auto_size_text = toplevel_form.AutoSizeText
            else:
                auto_size_text = DEFAULT_AUTOSIZE_TEXT
            element_type = element.Type
            # Set foreground color
            text_color = element.TextColor
            elementpad = element.Pad if element.Pad is not None else toplevel_form.ElementPadding
            # element.pad_used = elementpad  # store the value used back into the element
            # Determine Element size
            element_size = element.Size
            if element_size == (None, None) and element_type not in (
                ELEM_TYPE_BUTTON,
                ELEM_TYPE_BUTTONMENU,
            ):  # user did not specify a size
                element_size = toplevel_form.DefaultElementSize
            elif element_size == (None, None) and element_type in (ELEM_TYPE_BUTTON, ELEM_TYPE_BUTTONMENU):
                element_size = toplevel_form.DefaultButtonElementSize
            else:
                auto_size_text = False  # if user has specified a size then it shouldn't autosize

            border_depth = toplevel_form.BorderDepth if toplevel_form.BorderDepth is not None else DEFAULT_BORDER_WIDTH
            try:
                if element.BorderWidth is not None:
                    border_depth = element.BorderWidth
            except:
                pass

            # -------------------------  COLUMN placement element  ------------------------- #
            if element_type == ELEM_TYPE_COLUMN:
                element = element  # type: Column
                # ----------------------- SCROLLABLE Column ----------------------
                if element.Scrollable:
                    element.Widget = element.TKColFrame = TkScrollableFrame(tk_row_frame, element.VerticalScrollOnly, element, toplevel_form)  # do not use yet!  not working
                    PackFormIntoFrame(element, element.TKColFrame.TKFrame, toplevel_form)
                    element.TKColFrame.TKFrame.update()
                    if element.Size == (None, None):  # if no size specified, use column width x column height/2
                        element.TKColFrame.canvas.config(
                            width=element.TKColFrame.TKFrame.winfo_reqwidth() // element.size_subsample_width,
                            height=element.TKColFrame.TKFrame.winfo_reqheight() // element.size_subsample_height,
                        )
                    else:
                        element.TKColFrame.canvas.config(
                            width=element.TKColFrame.TKFrame.winfo_reqwidth() // element.size_subsample_width,
                            height=element.TKColFrame.TKFrame.winfo_reqheight() // element.size_subsample_height,
                        )
                        if None not in (element.Size[0], element.Size[1]):
                            element.TKColFrame.canvas.config(width=element.Size[0], height=element.Size[1])
                        elif element.Size[1] is not None:
                            element.TKColFrame.canvas.config(height=element.Size[1])
                        elif element.Size[0] is not None:
                            element.TKColFrame.canvas.config(width=element.Size[0])
                    if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                        element.TKColFrame.canvas.config(background=element.BackgroundColor)
                        element.TKColFrame.TKFrame.config(background=element.BackgroundColor, borderwidth=0, highlightthickness=0)
                        element.TKColFrame.config(background=element.BackgroundColor, borderwidth=0, highlightthickness=0)
                # ----------------------- PLAIN Column ----------------------
                else:
                    if element.Size != (None, None):
                        element.Widget = element.TKColFrame = TkFixedFrame(tk_row_frame)
                        PackFormIntoFrame(element, element.TKColFrame.TKFrame, toplevel_form)
                        element.TKColFrame.TKFrame.update()
                        if None not in (element.Size[0], element.Size[1]):
                            element.TKColFrame.canvas.config(width=element.Size[0], height=element.Size[1])
                        elif element.Size[1] is not None:
                            element.TKColFrame.canvas.config(height=element.Size[1])
                        elif element.Size[0] is not None:
                            element.TKColFrame.canvas.config(width=element.Size[0])
                        if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                            element.TKColFrame.canvas.config(background=element.BackgroundColor)
                            element.TKColFrame.TKFrame.config(background=element.BackgroundColor, borderwidth=0, highlightthickness=0)
                    else:
                        element.Widget = element.TKColFrame = tk.Frame(tk_row_frame)
                        PackFormIntoFrame(element, element.TKColFrame, toplevel_form)
                        if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                            element.TKColFrame.config(background=element.BackgroundColor, borderwidth=0, highlightthickness=0)

                if element.Justification is None:
                    pass
                elif element.Justification.lower().startswith('l'):
                    row_justify = 'l'
                elif element.Justification.lower().startswith('c'):
                    row_justify = 'c'
                elif element.Justification.lower().startswith('r'):
                    row_justify = 'r'

                # anchor=tk.NW
                # side = tk.LEFT
                # row_justify = element.Justification

                # element.Widget = element.TKColFrame

                expand = True
                if element.expand_x and element.expand_y:
                    fill = tk.BOTH
                    row_fill_direction = tk.BOTH
                    row_should_expand = True
                elif element.expand_x:
                    fill = tk.X
                    row_fill_direction = tk.X
                elif element.expand_y:
                    fill = tk.Y
                    row_fill_direction = tk.Y
                    row_should_expand = True
                else:
                    fill = tk.NONE
                    expand = False

                if element.VerticalAlignment is not None:
                    anchor = tk.CENTER  # Default to center if a bad choice is made

                    if element.VerticalAlignment.lower().startswith('t'):
                        anchor = tk.N
                    if element.VerticalAlignment.lower().startswith('c'):
                        anchor = tk.CENTER
                    if element.VerticalAlignment.lower().startswith('b'):
                        anchor = tk.S
                    element.TKColFrame.pack(side=tk.LEFT, anchor=anchor, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                else:
                    element.TKColFrame.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)

                # element.TKColFrame.pack(side=side, padx=elementpad[0], pady=elementpad[1], expand=True, fill='both')
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.TKColFrame.pack_forget()

                _add_right_click_menu_and_grab(element)
                # if element.Grab:
                #     element._grab_anywhere_on()
                # row_should_expand = True
            # -------------------------  Pane placement element  ------------------------- #
            if element_type == ELEM_TYPE_PANE:
                bd = element.BorderDepth if element.BorderDepth is not None else border_depth
                element.PanedWindow = element.Widget = tk.PanedWindow(
                    tk_row_frame,
                    orient=tk.VERTICAL if element.Orientation.startswith('v') else tk.HORIZONTAL,
                    borderwidth=bd,
                    bd=bd,
                )
                if element.Relief is not None:
                    element.PanedWindow.configure(relief=element.Relief)
                element.PanedWindow.configure(handlesize=element.HandleSize)
                if element.ShowHandle:
                    element.PanedWindow.config(showhandle=True)
                if element.Size != (None, None):
                    element.PanedWindow.config(width=element.Size[0], height=element.Size[1])
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.PanedWindow.configure(background=element.BackgroundColor)
                for pane in element.PaneList:
                    pane.Widget = pane.TKColFrame = tk.Frame(element.PanedWindow)
                    pane.ParentPanedWindow = element.PanedWindow
                    PackFormIntoFrame(pane, pane.TKColFrame, toplevel_form)
                    if pane.visible:
                        element.PanedWindow.add(pane.TKColFrame)
                    if pane.BackgroundColor != COLOR_SYSTEM_DEFAULT and pane.BackgroundColor is not None:
                        pane.TKColFrame.configure(
                            background=pane.BackgroundColor,
                            highlightbackground=pane.BackgroundColor,
                            highlightcolor=pane.BackgroundColor,
                        )
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.PanedWindow.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                # element.PanedWindow.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=True, fill='both')
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.PanedWindow.pack_forget()
            # -------------------------  TEXT placement element  ------------------------- #
            elif element_type == ELEM_TYPE_TEXT:
                # auto_size_text = element.AutoSizeText
                element = element  # type: Text
                display_text = element.DisplayText  # text to display
                if auto_size_text is False:
                    width, height = element_size
                else:
                    width, height = None, None
                # ---===--- LABEL widget create and place --- #
                element = element  # type: Text
                bd = element.BorderWidth if element.BorderWidth is not None else border_depth
                stringvar = tk.StringVar()
                element.TKStringVar = stringvar
                stringvar.set(str(display_text))
                if auto_size_text:
                    width = 0
                if element.Justification is not None:
                    justification = element.Justification
                elif toplevel_form.TextJustification is not None:
                    justification = toplevel_form.TextJustification
                else:
                    justification = DEFAULT_TEXT_JUSTIFICATION
                justify = tk.LEFT if justification.startswith('l') else tk.CENTER if justification.startswith('c') else tk.RIGHT
                anchor = tk.NW if justification.startswith('l') else tk.N if justification.startswith('c') else tk.NE
                tktext_label = element.Widget = tk.Label(tk_row_frame, textvariable=stringvar, width=width, height=height, justify=justify, bd=bd, font=font)
                # Set wrap-length for text (in PIXELS) == PAIN IN THE ASS
                wraplen = tktext_label.winfo_reqwidth()  # width of widget in Pixels
                if auto_size_text or (not auto_size_text and height == 1):  # if just 1 line high, ensure no wrap happens
                    wraplen = 0
                tktext_label.configure(anchor=anchor, wraplen=wraplen)  # set wrap to width of widget
                if element.Relief is not None:
                    tktext_label.configure(relief=element.Relief)
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    tktext_label.configure(background=element.BackgroundColor)
                if element.TextColor != COLOR_SYSTEM_DEFAULT and element.TextColor is not None:
                    tktext_label.configure(fg=element.TextColor)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                tktext_label.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # tktext_label.pack_forget()
                element.TKText = tktext_label
                if element.ClickSubmits:
                    tktext_label.bind('<Button-1>', element._TextClickedHandler)
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKText, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)
                if element.Grab:
                    element._grab_anywhere_on()
            # -------------------------  BUTTON placement element non-ttk version  ------------------------- #
            elif (element_type == ELEM_TYPE_BUTTON and element.UseTtkButtons is False) or (element_type == ELEM_TYPE_BUTTON and element.UseTtkButtons is not True and toplevel_form.UseTtkButtons is not True):
                element = element  # type: Button
                element.UseTtkButtons = False  # indicate that ttk button was not used
                stringvar = tk.StringVar()
                element.TKStringVar = stringvar
                element.Location = (row_num, col_num)
                btext = element.ButtonText
                btype = element.BType
                if element.AutoSizeButton is not None:
                    auto_size = element.AutoSizeButton
                else:
                    auto_size = toplevel_form.AutoSizeButtons
                if auto_size is False or element.Size[0] is not None:
                    width, height = element_size
                else:
                    width = 0
                    height = toplevel_form.DefaultButtonElementSize[1]
                if element.ButtonColor != (None, None) and element.ButtonColor != DEFAULT_BUTTON_COLOR:
                    bc = element.ButtonColor
                elif toplevel_form.ButtonColor != (None, None) and toplevel_form.ButtonColor != DEFAULT_BUTTON_COLOR:
                    bc = toplevel_form.ButtonColor
                else:
                    bc = DEFAULT_BUTTON_COLOR

                bd = element.BorderWidth
                pos = -1
                if DEFAULT_USE_BUTTON_SHORTCUTS is True:
                    pos = btext.find(MENU_SHORTCUT_CHARACTER)
                    if pos != -1:
                        if pos < len(MENU_SHORTCUT_CHARACTER) or btext[pos - len(MENU_SHORTCUT_CHARACTER)] != '\\':
                            btext = btext[:pos] + btext[pos + len(MENU_SHORTCUT_CHARACTER) :]
                        else:
                            btext = btext.replace('\\' + MENU_SHORTCUT_CHARACTER, MENU_SHORTCUT_CHARACTER)
                            pos = -1
                tkbutton = element.Widget = tk.Button(tk_row_frame, text=btext, width=width, height=height, justify=tk.CENTER, bd=bd, font=font)
                if pos != -1:
                    tkbutton.config(underline=pos)
                try:
                    if btype != BUTTON_TYPE_REALTIME:
                        tkbutton.config(command=element.ButtonCallBack)

                    else:
                        tkbutton.bind('<ButtonRelease-1>', element.ButtonReleaseCallBack)
                        tkbutton.bind('<ButtonPress-1>', element.ButtonPressCallBack)
                    if bc != (None, None) and COLOR_SYSTEM_DEFAULT not in bc:
                        tkbutton.config(foreground=bc[0], background=bc[1])
                    else:
                        if bc[0] != COLOR_SYSTEM_DEFAULT:
                            tkbutton.config(foreground=bc[0])
                        if bc[1] != COLOR_SYSTEM_DEFAULT:
                            tkbutton.config(background=bc[1])
                except Exception as e:
                    _error_popup_with_traceback(
                        'Button has a problem....',
                        'The traceback information will not show the line in your layout with the problem, but it does tell you which window.',
                        f'Error {e}',
                        # 'Button Text: {}'.format(btext),
                        # 'Button key: {}'.format(element.Key),
                        # 'Color string: {}'.format(bc),
                        f"Parent Window's Title: {toplevel_form.Title}",
                    )

                if bd == 0 and not running_mac():
                    tkbutton.config(relief=tk.FLAT)

                element.TKButton = tkbutton  # not used yet but save the TK button in case
                if elementpad[0] == 0 or elementpad[1] == 0:
                    tkbutton.config(highlightthickness=0)

                ## -------------- TK Button With Image -------------- ##
                if element.ImageFilename:  # if button has an image on it
                    tkbutton.config(highlightthickness=0)
                    try:
                        photo = tk.PhotoImage(file=element.ImageFilename)
                        if element.ImageSubsample:
                            photo = photo.subsample(element.ImageSubsample)
                        if element.zoom:
                            photo = photo.zoom(element.zoom)
                        if element.ImageSize != (None, None):
                            width, height = element.ImageSize
                        else:
                            width, height = photo.width(), photo.height()
                    except Exception as e:
                        _error_popup_with_traceback(
                            f'Button Element error {e}',
                            f'Image filename: {element.ImageFilename}',
                            'NOTE - file format must be PNG or GIF!',
                            f'Button element key: {element.Key}',
                            f"Parent Window's Title: {toplevel_form.Title}",
                        )
                    tkbutton.config(image=photo, compound=tk.CENTER, width=width, height=height)
                    tkbutton.image = photo
                if element.ImageData:  # if button has an image on it
                    tkbutton.config(highlightthickness=0)
                    try:
                        photo = tk.PhotoImage(data=element.ImageData)
                        if element.ImageSubsample:
                            photo = photo.subsample(element.ImageSubsample)
                        if element.zoom:
                            photo = photo.zoom(element.zoom)
                        if element.ImageSize != (None, None):
                            width, height = element.ImageSize
                        else:
                            width, height = photo.width(), photo.height()
                        tkbutton.config(image=photo, compound=tk.CENTER, width=width, height=height)
                        tkbutton.image = photo
                    except Exception as e:
                        _error_popup_with_traceback(
                            f'Button Element error {e}',
                            'Problem using BASE64 Image data Image Susample',
                            f'Buton element key: {element.Key}',
                            f"Parent Window's Title: {toplevel_form.Title}",
                        )

                if width != 0:
                    wraplen = width * _char_width_in_pixels(font)
                    tkbutton.configure(wraplength=wraplen)  # set wrap to width of widget
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)

                tkbutton.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # tkbutton.pack_forget()
                if element.BindReturnKey:
                    element.TKButton.bind('<Return>', element._ReturnKeyHandler)
                if element.Focus is True or (toplevel_form.UseDefaultFocus and not toplevel_form.FocusSet):
                    toplevel_form.FocusSet = True
                    element.TKButton.bind('<Return>', element._ReturnKeyHandler)
                    element.TKButton.focus_set()
                    toplevel_form.TKroot.focus_force()
                if element.Disabled is True:
                    element.TKButton['state'] = 'disabled'
                if element.DisabledButtonColor != (None, None) and element.DisabledButtonColor != (
                    COLOR_SYSTEM_DEFAULT,
                    COLOR_SYSTEM_DEFAULT,
                ):
                    if element.DisabledButtonColor[0] not in (None, COLOR_SYSTEM_DEFAULT):
                        element.TKButton['disabledforeground'] = element.DisabledButtonColor[0]
                if element.MouseOverColors[1] not in (COLOR_SYSTEM_DEFAULT, None):
                    tkbutton.config(activebackground=element.MouseOverColors[1])
                if element.MouseOverColors[0] not in (COLOR_SYSTEM_DEFAULT, None):
                    tkbutton.config(activeforeground=element.MouseOverColors[0])

                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKButton, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                try:
                    if element.HighlightColors[1] != COLOR_SYSTEM_DEFAULT:
                        tkbutton.config(highlightbackground=element.HighlightColors[1])
                    if element.HighlightColors[0] != COLOR_SYSTEM_DEFAULT:
                        tkbutton.config(highlightcolor=element.HighlightColors[0])
                except Exception as e:
                    _error_popup_with_traceback(
                        f'Button Element error {e}',
                        f'Button element key: {element.Key}',
                        f'Button text: {btext}',
                        f'Has a bad highlight color {element.HighlightColors}',
                        f"Parent Window's Title: {toplevel_form.Title}",
                    )
                    # print('Button with text: ', btext, 'has a bad highlight color', element.HighlightColors)
                _add_right_click_menu_and_grab(element)

            # -------------------------  BUTTON placement element ttk version ------------------------- #
            elif element_type == ELEM_TYPE_BUTTON:
                element = element  # type: Button
                element.UseTtkButtons = True  # indicate that ttk button was used
                stringvar = tk.StringVar()
                element.TKStringVar = stringvar
                element.Location = (row_num, col_num)
                btext = element.ButtonText
                pos = -1
                if DEFAULT_USE_BUTTON_SHORTCUTS is True:
                    pos = btext.find(MENU_SHORTCUT_CHARACTER)
                    if pos != -1:
                        if pos < len(MENU_SHORTCUT_CHARACTER) or btext[pos - len(MENU_SHORTCUT_CHARACTER)] != '\\':
                            btext = btext[:pos] + btext[pos + len(MENU_SHORTCUT_CHARACTER) :]
                        else:
                            btext = btext.replace('\\' + MENU_SHORTCUT_CHARACTER, MENU_SHORTCUT_CHARACTER)
                            pos = -1
                btype = element.BType
                if element.AutoSizeButton is not None:
                    auto_size = element.AutoSizeButton
                else:
                    auto_size = toplevel_form.AutoSizeButtons
                if auto_size is False or element.Size[0] is not None:
                    width, height = element_size
                else:
                    width = 0
                    height = toplevel_form.DefaultButtonElementSize[1]
                if element.ButtonColor != (None, None) and element.ButtonColor != COLOR_SYSTEM_DEFAULT:
                    bc = element.ButtonColor
                elif toplevel_form.ButtonColor != (None, None) and toplevel_form.ButtonColor != COLOR_SYSTEM_DEFAULT:
                    bc = toplevel_form.ButtonColor
                else:
                    bc = DEFAULT_BUTTON_COLOR
                bd = element.BorderWidth
                tkbutton = element.Widget = ttk.Button(tk_row_frame, text=btext, width=width)
                if pos != -1:
                    tkbutton.config(underline=pos)
                if btype != BUTTON_TYPE_REALTIME:
                    tkbutton.config(command=element.ButtonCallBack)
                else:
                    tkbutton.bind('<ButtonRelease-1>', element.ButtonReleaseCallBack)
                    tkbutton.bind('<ButtonPress-1>', element.ButtonPressCallBack)
                style_name = _make_ttk_style_name('.TButton', element, primary_style=True)
                button_style = ttk.Style()
                element.ttk_style = button_style
                _change_ttk_theme(button_style, toplevel_form.TtkTheme)
                button_style.configure(style_name, font=font)

                if bc != (None, None) and COLOR_SYSTEM_DEFAULT not in bc:
                    button_style.configure(style_name, foreground=bc[0], background=bc[1])
                elif bc[0] != COLOR_SYSTEM_DEFAULT:
                    button_style.configure(style_name, foreground=bc[0])
                elif bc[1] != COLOR_SYSTEM_DEFAULT:
                    button_style.configure(style_name, background=bc[1])

                if bd == 0 and not running_mac():
                    button_style.configure(style_name, relief=tk.FLAT)
                    button_style.configure(style_name, borderwidth=0)
                else:
                    button_style.configure(style_name, borderwidth=bd)
                button_style.configure(style_name, justify=tk.CENTER)

                if element.MouseOverColors[1] not in (COLOR_SYSTEM_DEFAULT, None):
                    button_style.map(style_name, background=[('active', element.MouseOverColors[1])])
                if element.MouseOverColors[0] not in (COLOR_SYSTEM_DEFAULT, None):
                    button_style.map(style_name, foreground=[('active', element.MouseOverColors[0])])

                if element.DisabledButtonColor[0] not in (COLOR_SYSTEM_DEFAULT, None):
                    button_style.map(style_name, foreground=[('disabled', element.DisabledButtonColor[0])])
                if element.DisabledButtonColor[1] not in (COLOR_SYSTEM_DEFAULT, None):
                    button_style.map(style_name, background=[('disabled', element.DisabledButtonColor[1])])

                if height > 1:
                    button_style.configure(style_name, padding=height * _char_height_in_pixels(font))  # should this be height instead?
                if width != 0:
                    wraplen = width * _char_width_in_pixels(font)  # width of widget in Pixels
                    button_style.configure(style_name, wraplength=wraplen)  # set wrap to width of widget

                ## -------------- TTK Button With Image -------------- ##
                if element.ImageFilename:  # if button has an image on it
                    button_style.configure(style_name, borderwidth=0)
                    # tkbutton.configure(highlightthickness=0)
                    photo = tk.PhotoImage(file=element.ImageFilename)
                    if element.ImageSubsample:
                        photo = photo.subsample(element.ImageSubsample)
                    if element.zoom:
                        photo = photo.zoom(element.zoom)
                    if element.ImageSize != (None, None):
                        width, height = element.ImageSize
                    else:
                        width, height = photo.width(), photo.height()
                    button_style.configure(style_name, image=photo, compound=tk.CENTER, width=width, height=height)
                    tkbutton.image = photo
                if element.ImageData:  # if button has an image on it
                    # tkbutton.configure(highlightthickness=0)
                    button_style.configure(style_name, borderwidth=0)

                    photo = tk.PhotoImage(data=element.ImageData)
                    if element.ImageSubsample:
                        photo = photo.subsample(element.ImageSubsample)
                    if element.zoom:
                        photo = photo.zoom(element.zoom)
                    if element.ImageSize != (None, None):
                        width, height = element.ImageSize
                    else:
                        width, height = photo.width(), photo.height()
                    button_style.configure(style_name, image=photo, compound=tk.CENTER, width=width, height=height)
                    # tkbutton.configure(image=photo, compound=tk.CENTER, width=width, height=height)
                    tkbutton.image = photo

                element.TKButton = tkbutton  # not used yet but save the TK button in case
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                tkbutton.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # tkbutton.pack_forget()
                if element.BindReturnKey:
                    element.TKButton.bind('<Return>', element._ReturnKeyHandler)
                if element.Focus is True or (toplevel_form.UseDefaultFocus and not toplevel_form.FocusSet):
                    toplevel_form.FocusSet = True
                    element.TKButton.bind('<Return>', element._ReturnKeyHandler)
                    element.TKButton.focus_set()
                    toplevel_form.TKroot.focus_force()
                if element.Disabled is True:
                    element.TKButton['state'] = 'disabled'

                tkbutton.configure(style=style_name)  # IMPORTANT!  Apply the style to the button!
                _add_right_click_menu_and_grab(element)

                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKButton, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
            # -------------------------  BUTTONMENU placement element  ------------------------- #
            elif element_type == ELEM_TYPE_BUTTONMENU:
                element = element  # type: ButtonMenu
                element.Location = (row_num, col_num)
                btext = element.ButtonText
                if element.AutoSizeButton is not None:
                    auto_size = element.AutoSizeButton
                else:
                    auto_size = toplevel_form.AutoSizeButtons
                if auto_size is False or element.Size[0] is not None:
                    width, height = element_size
                else:
                    width = 0
                    height = toplevel_form.DefaultButtonElementSize[1]
                if element.ButtonColor != (None, None) and element.ButtonColor != DEFAULT_BUTTON_COLOR:
                    bc = element.ButtonColor
                elif toplevel_form.ButtonColor != (None, None) and toplevel_form.ButtonColor != DEFAULT_BUTTON_COLOR:
                    bc = toplevel_form.ButtonColor
                else:
                    bc = DEFAULT_BUTTON_COLOR
                bd = element.BorderWidth
                if element.ItemFont is None:
                    element.ItemFont = font
                tkbutton = element.Widget = tk.Menubutton(tk_row_frame, text=btext, width=width, height=height, justify=tk.LEFT, bd=bd, font=font)
                element.TKButtonMenu = tkbutton
                if bc != (None, None) and bc != COLOR_SYSTEM_DEFAULT and bc[1] != COLOR_SYSTEM_DEFAULT:
                    tkbutton.config(foreground=bc[0], background=bc[1])
                    tkbutton.config(activebackground=bc[0])
                    tkbutton.config(activeforeground=bc[1])
                elif bc[0] != COLOR_SYSTEM_DEFAULT:
                    tkbutton.config(foreground=bc[0])
                    tkbutton.config(activebackground=bc[0])
                if bd == 0 and not running_mac():
                    tkbutton.config(relief=RELIEF_FLAT)
                elif bd != 0:
                    tkbutton.config(relief=RELIEF_RAISED)

                element.TKButton = tkbutton  # not used yet but save the TK button in case
                wraplen = tkbutton.winfo_reqwidth()  # width of widget in Pixels
                if element.ImageFilename:  # if button has an image on it
                    photo = tk.PhotoImage(file=element.ImageFilename)
                    if element.ImageSubsample:
                        photo = photo.subsample(element.ImageSubsample)
                    if element.zoom:
                        photo = photo.zoom(element.zoom)
                    if element.ImageSize != (None, None):
                        width, height = element.ImageSize
                    else:
                        width, height = photo.width(), photo.height()
                    tkbutton.config(image=photo, compound=tk.CENTER, width=width, height=height)
                    tkbutton.image = photo
                if element.ImageData:  # if button has an image on it
                    photo = tk.PhotoImage(data=element.ImageData)
                    if element.ImageSubsample:
                        photo = photo.subsample(element.ImageSubsample)
                    if element.zoom:
                        photo = photo.zoom(element.zoom)
                    if element.ImageSize != (None, None):
                        width, height = element.ImageSize
                    else:
                        width, height = photo.width(), photo.height()
                    tkbutton.config(image=photo, compound=tk.CENTER, width=width, height=height)
                    tkbutton.image = photo
                if width != 0:
                    tkbutton.configure(wraplength=wraplen + 10)  # set wrap to width of widget
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                tkbutton.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)

                menu_def = element.MenuDefinition

                element.TKMenu = top_menu = tk.Menu(
                    tkbutton,
                    tearoff=element.Tearoff,
                    font=element.ItemFont,
                    tearoffcommand=element._tearoff_menu_callback,
                )

                if element.BackgroundColor not in (COLOR_SYSTEM_DEFAULT, None):
                    top_menu.config(bg=element.BackgroundColor)
                    top_menu.config(activeforeground=element.BackgroundColor)
                if element.TextColor not in (COLOR_SYSTEM_DEFAULT, None):
                    top_menu.config(fg=element.TextColor)
                    top_menu.config(activebackground=element.TextColor)
                if element.DisabledTextColor not in (COLOR_SYSTEM_DEFAULT, None):
                    top_menu.config(disabledforeground=element.DisabledTextColor)
                if element.ItemFont is not None:
                    top_menu.config(font=element.ItemFont)

                AddMenuItem(top_menu, menu_def[1], element)
                if elementpad[0] == 0 or elementpad[1] == 0:
                    tkbutton.config(highlightthickness=0)
                tkbutton.configure(menu=top_menu)
                element.TKMenu = top_menu
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # tkbutton.pack_forget()
                if element.Disabled:
                    element.TKButton['state'] = 'disabled'
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKButton, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)

            # -------------------------  INPUT placement element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_TEXT:
                element = element  # type: InputText
                default_text = element.DefaultText
                element.TKStringVar = tk.StringVar()
                element.TKStringVar.set(default_text)
                show = element.PasswordCharacter if element.PasswordCharacter else ''
                bd = border_depth
                if element.Justification is not None:
                    justification = element.Justification
                else:
                    justification = DEFAULT_TEXT_JUSTIFICATION
                justify = tk.LEFT if justification.startswith('l') else tk.CENTER if justification.startswith('c') else tk.RIGHT
                # anchor = tk.NW if justification == 'left' else tk.N if justification == 'center' else tk.NE
                element.TKEntry = element.Widget = tk.Entry(
                    tk_row_frame,
                    width=element_size[0],
                    textvariable=element.TKStringVar,
                    bd=bd,
                    font=font,
                    show=show,
                    justify=justify,
                )
                if element.ChangeSubmits:
                    element.TKEntry.bind('<Key>', element._KeyboardHandler)
                element.TKEntry.bind('<Return>', element._ReturnKeyHandler)

                if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKEntry.configure(background=element.BackgroundColor, selectforeground=element.BackgroundColor)

                if text_color not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKEntry.configure(fg=text_color, selectbackground=text_color)
                    element.TKEntry.config(insertbackground=text_color)
                if element.selected_background_color not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKEntry.configure(selectbackground=element.selected_background_color)
                if element.selected_text_color not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKEntry.configure(selectforeground=element.selected_text_color)
                if element.disabled_readonly_background_color not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKEntry.config(readonlybackground=element.disabled_readonly_background_color)
                if element.disabled_readonly_text_color not in (None, COLOR_SYSTEM_DEFAULT) and element.Disabled:
                    element.TKEntry.config(fg=element.disabled_readonly_text_color)

                element.Widget.config(highlightthickness=0)
                # element.pack_keywords = {'side':tk.LEFT, 'padx':elementpad[0], 'pady':elementpad[1], 'expand':False, 'fill':tk.NONE }
                # element.TKEntry.pack(**element.pack_keywords)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKEntry.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.TKEntry.pack_forget()
                if element.Focus is True or (toplevel_form.UseDefaultFocus and not toplevel_form.FocusSet):
                    toplevel_form.FocusSet = True
                    element.TKEntry.focus_set()
                if element.Disabled:
                    element.TKEntry['state'] = 'readonly' if element.UseReadonlyForDisable else 'disabled'
                if element.ReadOnly:
                    element.TKEntry['state'] = 'readonly'

                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKEntry, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

                # row_should_expand = True

            # -------------------------  COMBO placement element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_COMBO:
                element = element  # type: Combo
                max_line_len = max([len(str(line)) for line in element.Values]) if len(element.Values) else 0
                if auto_size_text is False:
                    width = element_size[0]
                else:
                    width = max_line_len + 1
                element.TKStringVar = tk.StringVar()
                style_name = _make_ttk_style_name('.TCombobox', element, primary_style=True)
                combostyle = ttk.Style()
                element.ttk_style = combostyle
                _change_ttk_theme(combostyle, toplevel_form.TtkTheme)

                # Creates a unique name for each field element(Sure there is a better way to do this)
                # unique_field = _make_ttk_style_name('.TCombobox.field', element)

                # Set individual widget options
                try:
                    if element.TextColor not in (None, COLOR_SYSTEM_DEFAULT):
                        combostyle.configure(style_name, foreground=element.TextColor)
                        combostyle.configure(style_name, selectbackground=element.TextColor)
                        combostyle.configure(style_name, insertcolor=element.TextColor)
                        combostyle.map(style_name, fieldforeground=[('readonly', element.TextColor)])
                    if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                        combostyle.configure(style_name, selectforeground=element.BackgroundColor)
                        combostyle.map(style_name, fieldbackground=[('readonly', element.BackgroundColor)])
                        combostyle.configure(style_name, fieldbackground=element.BackgroundColor)

                    if element.button_arrow_color not in (None, COLOR_SYSTEM_DEFAULT):
                        combostyle.configure(style_name, arrowcolor=element.button_arrow_color)
                    if element.button_background_color not in (None, COLOR_SYSTEM_DEFAULT):
                        combostyle.configure(style_name, background=element.button_background_color)
                    if element.Readonly is True:
                        if element.TextColor not in (None, COLOR_SYSTEM_DEFAULT):
                            combostyle.configure(style_name, selectforeground=element.TextColor)
                        if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                            combostyle.configure(style_name, selectbackground=element.BackgroundColor)

                except Exception as e:
                    _error_popup_with_traceback(
                        f'Combo Element error {e}',
                        f'Combo element key: {element.Key}',
                        'One of your colors is bad. Check the text, background, button background and button arrow colors',
                        f"Parent Window's Title: {toplevel_form.Title}",
                    )

                # Strange code that is needed to set the font for the drop-down list
                element._dropdown_newfont = tkinter.font.Font(font=font)
                tk_row_frame.option_add('*TCombobox*Listbox*Font', element._dropdown_newfont)

                element.TKCombo = element.Widget = ttk.Combobox(tk_row_frame, width=width, textvariable=element.TKStringVar, font=font, style=style_name)

                # make tcl call to deal with colors for the drop-down formatting
                try:
                    if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT) and element.TextColor not in (
                        None,
                        COLOR_SYSTEM_DEFAULT,
                    ):
                        element.Widget.tk.eval(
                            '[ttk::combobox::PopdownWindow {}].f.l configure -foreground {} -background {} -selectforeground {} -selectbackground {}'.format(
                                element.Widget,
                                element.TextColor,
                                element.BackgroundColor,
                                element.BackgroundColor,
                                element.TextColor,
                            )
                        )
                except Exception:
                    pass  # going to let this one slide

                # Chr0nic
                element.TKCombo.bind('<Enter>', lambda event, em=element: testMouseHook2(em))
                element.TKCombo.bind('<Leave>', lambda event, em=element: testMouseUnhook2(em))

                if toplevel_form.UseDefaultFocus and not toplevel_form.FocusSet:
                    toplevel_form.FocusSet = True
                    element.TKCombo.focus_set()

                if element.Size[1] != 1 and element.Size[1] is not None:
                    element.TKCombo.configure(height=element.Size[1])
                element.TKCombo['values'] = element.Values
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKCombo.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.TKCombo.pack_forget()
                if element.DefaultValue is not None:
                    element.TKCombo.set(element.DefaultValue)
                if element.ChangeSubmits:
                    element.TKCombo.bind('<<ComboboxSelected>>', element._ComboboxSelectHandler)
                if element.BindReturnKey:
                    element.TKCombo.bind('<Return>', element._ComboboxSelectHandler)
                if element.enable_per_char_events:
                    element.TKCombo.bind('<Key>', element._KeyboardHandler)
                if element.Readonly:
                    element.TKCombo['state'] = 'readonly'
                if element.Disabled is True:  # note overrides readonly if disabled
                    element.TKCombo['state'] = 'disabled'
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKCombo, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

            # -------------------------  OPTIONMENU placement Element (Like ComboBox but different) element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_OPTION_MENU:
                max_line_len = max([len(str(line)) for line in element.Values])
                if auto_size_text is False:
                    width = element_size[0]
                else:
                    width = max_line_len
                element.TKStringVar = tk.StringVar()
                if element.DefaultValue:
                    element.TKStringVar.set(element.DefaultValue)
                element.TKOptionMenu = element.Widget = tk.OptionMenu(tk_row_frame, element.TKStringVar, *element.Values)
                element.TKOptionMenu.config(highlightthickness=0, font=font, width=width)
                element.TKOptionMenu['menu'].config(font=font)
                element.TKOptionMenu.config(borderwidth=border_depth)
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.TKOptionMenu.configure(background=element.BackgroundColor)
                    element.TKOptionMenu['menu'].config(background=element.BackgroundColor)
                if element.TextColor != COLOR_SYSTEM_DEFAULT and element.TextColor is not None:
                    element.TKOptionMenu.configure(fg=element.TextColor)
                    element.TKOptionMenu['menu'].config(fg=element.TextColor)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKOptionMenu.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.TKOptionMenu.pack_forget()
                if element.Disabled is True:
                    element.TKOptionMenu['state'] = 'disabled'
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKOptionMenu, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
            # -------------------------  LISTBOX placement element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_LISTBOX:
                element = element  # type: Listbox
                max_line_len = max([len(str(line)) for line in element.Values]) if len(element.Values) else 0
                if auto_size_text is False:
                    width = element_size[0]
                else:
                    width = max_line_len
                element_frame = tk.Frame(tk_row_frame)
                element.element_frame = element_frame

                justification = tk.LEFT
                if element.justification is not None:
                    if element.justification.startswith('l'):
                        justification = tk.LEFT
                    elif element.justification.startswith('r'):
                        justification = tk.RIGHT
                    elif element.justification.startswith('c'):
                        justification = tk.CENTER

                element.TKStringVar = tk.StringVar()
                element.TKListbox = element.Widget = tk.Listbox(
                    element_frame,
                    height=element_size[1],
                    width=width,
                    selectmode=element.SelectMode,
                    font=font,
                    exportselection=False,
                )
                # On OLD versions of tkinter the justify option isn't available
                try:
                    element.Widget.config(justify=justification)
                except:
                    pass

                element.Widget.config(highlightthickness=0)
                for index, item in enumerate(element.Values):
                    element.TKListbox.insert(tk.END, item)
                    if element.DefaultValues is not None and item in element.DefaultValues:
                        element.TKListbox.selection_set(index)
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.TKListbox.configure(background=element.BackgroundColor)
                if element.HighlightBackgroundColor is not None and element.HighlightBackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.TKListbox.config(selectbackground=element.HighlightBackgroundColor)
                if text_color is not None and text_color != COLOR_SYSTEM_DEFAULT:
                    element.TKListbox.configure(fg=text_color)
                if element.HighlightTextColor is not None and element.HighlightTextColor != COLOR_SYSTEM_DEFAULT:
                    element.TKListbox.config(selectforeground=element.HighlightTextColor)
                if element.ChangeSubmits:
                    element.TKListbox.bind('<<ListboxSelect>>', element._ListboxSelectHandler)

                if not element.NoScrollbar:
                    _make_ttk_scrollbar(element, 'v', toplevel_form)
                    element.Widget.configure(yscrollcommand=element.vsb.set)
                    element.vsb.pack(side=tk.RIGHT, fill='y')

                # Horizontal scrollbar
                if element.HorizontalScroll:
                    _make_ttk_scrollbar(element, 'h', toplevel_form)
                    element.hsb.pack(side=tk.BOTTOM, fill='x')
                    element.Widget.configure(xscrollcommand=element.hsb.set)

                if not element.NoScrollbar or element.HorizontalScroll:
                    # Chr0nic
                    element.Widget.bind('<Enter>', lambda event, em=element: testMouseHook(em))
                    element.Widget.bind('<Leave>', lambda event, em=element: testMouseUnhook(em))

                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element_frame.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], fill=fill, expand=expand)
                element.TKListbox.pack(side=tk.LEFT, fill=fill, expand=expand)
                if element.visible is False:
                    element._pack_forget_save_settings(alternate_widget=element_frame)
                    # element_frame.pack_forget()
                if element.BindReturnKey:
                    element.TKListbox.bind('<Return>', element._ListboxSelectHandler)
                    element.TKListbox.bind('<Double-Button-1>', element._ListboxSelectHandler)
                if element.Disabled is True:
                    element.TKListbox['state'] = 'disabled'
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKListbox, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)
            # -------------------------  MULTILINE placement element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_MULTILINE:
                element = element  # type: Multiline
                width, height = element_size
                bd = element.BorderWidth
                element.element_frame = element_frame = tk.Frame(tk_row_frame)

                # if element.no_scrollbar:
                element.TKText = element.Widget = tk.Text(element_frame, width=width, height=height, bd=bd, font=font, relief=RELIEF_SUNKEN)
                # else:
                #     element.TKText = element.Widget = tk.scrolledtext.ScrolledText(element_frame, width=width, height=height, bd=bd, font=font, relief=RELIEF_SUNKEN)

                if not element.no_scrollbar:
                    _make_ttk_scrollbar(element, 'v', toplevel_form)

                    element.Widget.configure(yscrollcommand=element.vsb.set)
                    element.vsb.pack(side=tk.RIGHT, fill='y')

                # Horizontal scrollbar
                if element.HorizontalScroll:
                    element.TKText.config(wrap='none')
                    _make_ttk_scrollbar(element, 'h', toplevel_form)
                    element.hsb.pack(side=tk.BOTTOM, fill='x')
                    element.Widget.configure(xscrollcommand=element.hsb.set)
                else:
                    element.TKText.config(wrap='word')

                if element.wrap_lines is True:
                    element.TKText.config(wrap='word')
                elif element.wrap_lines is False:
                    element.TKText.config(wrap='none')

                if not element.no_scrollbar or element.HorizontalScroll:
                    # Chr0nic
                    element.TKText.bind('<Enter>', lambda event, em=element: testMouseHook(em))
                    element.TKText.bind('<Leave>', lambda event, em=element: testMouseUnhook(em))

                if element.DefaultText:
                    element.TKText.insert(1.0, element.DefaultText)  # set the default text
                element.TKText.config(highlightthickness=0)
                if text_color is not None and text_color != COLOR_SYSTEM_DEFAULT:
                    element.TKText.configure(fg=text_color, selectbackground=text_color)
                    element.TKText.config(insertbackground=text_color)
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.TKText.configure(background=element.BackgroundColor, selectforeground=element.BackgroundColor)
                if element.selected_background_color not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKText.configure(selectbackground=element.selected_background_color)
                if element.selected_text_color not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKText.configure(selectforeground=element.selected_text_color)
                element.TKText.tag_configure('center', justify='center')
                element.TKText.tag_configure('left', justify='left')
                element.TKText.tag_configure('right', justify='right')

                if element.Justification.startswith('l'):
                    element.TKText.tag_add('left', 1.0, 'end')
                    element.justification_tag = 'left'
                elif element.Justification.startswith('r'):
                    element.TKText.tag_add('right', 1.0, 'end')
                    element.justification_tag = 'right'
                elif element.Justification.startswith('c'):
                    element.TKText.tag_add('center', 1.0, 'end')
                    element.justification_tag = 'center'
                # if DEFAULT_SCROLLBAR_COLOR not in (None, COLOR_SYSTEM_DEFAULT):               # only works on Linux so not including it
                #     element.TKText.vbar.config(troughcolor=DEFAULT_SCROLLBAR_COLOR)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)

                element.element_frame.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], fill=fill, expand=expand)
                element.Widget.pack(side=tk.LEFT, fill=fill, expand=expand)

                if element.visible is False:
                    element._pack_forget_save_settings(alternate_widget=element_frame)
                    # element.element_frame.pack_forget()
                else:
                    # Chr0nic
                    element.TKText.bind('<Enter>', lambda event, em=element: testMouseHook(em))
                    element.TKText.bind('<Leave>', lambda event, em=element: testMouseUnhook(em))
                if element.ChangeSubmits:
                    element.TKText.bind('<Key>', element._KeyboardHandler)
                if element.EnterSubmits:
                    element.TKText.bind('<Return>', element._ReturnKeyHandler)
                if element.Focus is True or (toplevel_form.UseDefaultFocus and not toplevel_form.FocusSet):
                    toplevel_form.FocusSet = True
                    element.TKText.focus_set()

                if element.Disabled is True:
                    element.TKText['state'] = 'disabled'
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKText, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)

                if element.reroute_cprint:
                    cprint_set_output_destination(toplevel_form, element.Key)

                _add_right_click_menu_and_grab(element)

                if element.reroute_stdout:
                    element.reroute_stdout_to_here()
                if element.reroute_stderr:
                    element.reroute_stderr_to_here()

                # row_should_expand = True
            # -------------------------  CHECKBOX pleacement element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_CHECKBOX:
                element = element  # type: Checkbox
                width = 0 if auto_size_text else element_size[0]
                default_value = element.InitialState
                element.TKIntVar = tk.IntVar()
                element.TKIntVar.set(default_value if default_value is not None else 0)

                element.TKCheckbutton = element.Widget = tk.Checkbutton(
                    tk_row_frame,
                    anchor=tk.NW,
                    text=element.Text,
                    width=width,
                    variable=element.TKIntVar,
                    bd=border_depth,
                    font=font,
                )
                if element.ChangeSubmits:
                    element.TKCheckbutton.configure(command=element._CheckboxHandler)
                if element.Disabled:
                    element.TKCheckbutton.configure(state='disable')
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.TKCheckbutton.configure(background=element.BackgroundColor)
                    element.TKCheckbutton.configure(selectcolor=element.CheckboxBackgroundColor)  # The background of the checkbox
                    element.TKCheckbutton.configure(activebackground=element.BackgroundColor)
                if text_color is not None and text_color != COLOR_SYSTEM_DEFAULT:
                    element.TKCheckbutton.configure(fg=text_color)
                    element.TKCheckbutton.configure(activeforeground=element.TextColor)

                element.Widget.configure(highlightthickness=element.highlight_thickness)
                if element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.TKCheckbutton.config(highlightbackground=element.BackgroundColor)
                if element.TextColor != COLOR_SYSTEM_DEFAULT:
                    element.TKCheckbutton.config(highlightcolor=element.TextColor)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKCheckbutton.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.TKCheckbutton.pack_forget()
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKCheckbutton, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

            # -------------------------  PROGRESS placement element  ------------------------- #
            elif element_type == ELEM_TYPE_PROGRESS_BAR:
                element = element  # type: ProgressBar
                if element.size_px != (None, None):
                    progress_length, progress_width = element.size_px
                else:
                    width = element_size[0]
                    fnt = tkinter.font.Font()
                    char_width = fnt.measure('A')  # single character width
                    progress_length = width * char_width
                    progress_width = element_size[1]
                direction = element.Orientation
                if element.BarColor != (None, None):  # if element has a bar color, use it
                    bar_color = element.BarColor
                else:
                    bar_color = DEFAULT_PROGRESS_BAR_COLOR
                if element.Orientation.lower().startswith('h'):
                    base_style_name = '.Horizontal.TProgressbar'
                else:
                    base_style_name = '.Vertical.TProgressbar'
                style_name = _make_ttk_style_name(base_style_name, element, primary_style=True)
                element.TKProgressBar = TKProgressBar(
                    tk_row_frame,
                    element.MaxValue,
                    progress_length,
                    progress_width,
                    orientation=direction,
                    BarColor=bar_color,
                    border_width=element.BorderWidth,
                    relief=element.Relief,
                    ttk_theme=toplevel_form.TtkTheme,
                    key=element.Key,
                    style_name=style_name,
                )
                element.Widget = element.TKProgressBar.TKProgressBarForReal
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKProgressBar.TKProgressBarForReal.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings(alternate_widget=element.TKProgressBar.TKProgressBarForReal)
                    # element.TKProgressBar.TKProgressBarForReal.pack_forget()
                _add_right_click_menu_and_grab(element)

                # -------------------------  RADIO placement element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_RADIO:
                element = element  # type: Radio
                width = 0 if auto_size_text else element_size[0]
                default_value = element.InitialState
                ID = element.GroupID
                # see if ID has already been placed
                value = EncodeRadioRowCol(form.ContainerElemementNumber, row_num, col_num)  # value to set intvar to if this radio is selected
                element.EncodedRadioValue = value
                if ID in toplevel_form.RadioDict:
                    RadVar = toplevel_form.RadioDict[ID]
                else:
                    RadVar = tk.IntVar()
                    toplevel_form.RadioDict[ID] = RadVar
                element.TKIntVar = RadVar  # store the RadVar in Radio object
                if default_value:  # if this radio is the one selected, set RadVar to match
                    element.TKIntVar.set(value)
                element.TKRadio = element.Widget = tk.Radiobutton(
                    tk_row_frame,
                    anchor=tk.NW,
                    text=element.Text,
                    width=width,
                    variable=element.TKIntVar,
                    value=value,
                    bd=border_depth,
                    font=font,
                )
                if element.ChangeSubmits:
                    element.TKRadio.configure(command=element._RadioHandler)
                if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKRadio.configure(background=element.BackgroundColor)
                    element.TKRadio.configure(selectcolor=element.CircleBackgroundColor)
                    element.TKRadio.configure(activebackground=element.BackgroundColor)
                if text_color is not None and text_color != COLOR_SYSTEM_DEFAULT:
                    element.TKRadio.configure(fg=text_color)
                    element.TKRadio.configure(activeforeground=text_color)

                element.Widget.configure(highlightthickness=1)
                if element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.TKRadio.config(highlightbackground=element.BackgroundColor)
                if element.TextColor != COLOR_SYSTEM_DEFAULT:
                    element.TKRadio.config(highlightcolor=element.TextColor)

                if element.Disabled:
                    element.TKRadio['state'] = 'disabled'
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKRadio.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.TKRadio.pack_forget()
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKRadio, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

                # -------------------------  SPIN placement element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_SPIN:
                element = element  # type: Spin
                width, height = element_size
                width = 0 if auto_size_text else element_size[0]
                element.TKStringVar = tk.StringVar()
                element.TKSpinBox = element.Widget = tk.Spinbox(tk_row_frame, values=element.Values, textvariable=element.TKStringVar, width=width, bd=border_depth)
                if element.DefaultValue is not None:
                    element.TKStringVar.set(element.DefaultValue)
                element.TKSpinBox.configure(font=font)  # set wrap to width of widget
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element.TKSpinBox.configure(background=element.BackgroundColor)
                    element.TKSpinBox.configure(buttonbackground=element.BackgroundColor)
                if text_color not in (None, COLOR_SYSTEM_DEFAULT):
                    element.TKSpinBox.configure(fg=text_color)
                    element.TKSpinBox.config(insertbackground=text_color)
                element.Widget.config(highlightthickness=0)
                if element.wrap is True:
                    element.Widget.configure(wrap=True)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKSpinBox.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.TKSpinBox.pack_forget()
                if element.ChangeSubmits:
                    element.TKSpinBox.configure(command=element._SpinboxSelectHandler)
                    # element.TKSpinBox.bind('<ButtonRelease-1>', element._SpinChangedHandler)
                    # element.TKSpinBox.bind('<Up>', element._SpinChangedHandler)
                    # element.TKSpinBox.bind('<Down>', element._SpinChangedHandler)
                if element.Readonly:
                    element.TKSpinBox['state'] = 'readonly'
                if element.Disabled is True:  # note overrides readonly if disabled
                    element.TKSpinBox['state'] = 'disabled'
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKSpinBox, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                if element.BindReturnKey:
                    element.TKSpinBox.bind('<Return>', element._SpinboxSelectHandler)
                _add_right_click_menu_and_grab(element)
                # -------------------------  IMAGE placement element  ------------------------- #
            elif element_type == ELEM_TYPE_IMAGE:
                element = element  # type: Image
                try:
                    if element.Filename is not None:
                        photo = tk.PhotoImage(file=element.Filename)
                    elif element.Data is not None:
                        photo = tk.PhotoImage(data=element.Data)
                    else:
                        photo = None

                    if photo is not None:
                        if element.ImageSubsample:
                            photo = photo.subsample(element.ImageSubsample)
                        if element.zoom:
                            photo = photo.zoom(element.zoom)
                        # print('*ERROR laying out form.... Image Element has no image specified*')
                except Exception as e:
                    photo = None
                    _error_popup_with_traceback(
                        'Your Window has an Image Element with a problem',
                        'The traceback will show you the Window with the problem layout',
                        f'Look in this Window\'s layout for an Image element that has a key of {element.Key}',
                        'The error occuring is:',
                        e,
                    )

                element.tktext_label = element.Widget = tk.Label(tk_row_frame, bd=0)

                if photo is not None:
                    if element_size == (None, None) or element_size is None or element_size == toplevel_form.DefaultElementSize:
                        width, height = photo.width(), photo.height()
                    else:
                        width, height = element_size
                    element.tktext_label.config(image=photo, width=width, height=height)

                if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                    element.tktext_label.config(background=element.BackgroundColor)

                element.tktext_label.image = photo
                # tktext_label.configure(anchor=tk.NW, image=photo)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.tktext_label.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)

                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element.tktext_label.pack_forget()
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.tktext_label, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                if element.EnableEvents and element.tktext_label is not None:
                    element.tktext_label.bind('<ButtonPress-1>', element._ClickHandler)

                _add_right_click_menu_and_grab(element)

                # -------------------------  Canvas placement element  ------------------------- #
            elif element_type == ELEM_TYPE_CANVAS:
                element = element  # type: Canvas
                width, height = element_size
                if element._TKCanvas is None:
                    element._TKCanvas = tk.Canvas(tk_row_frame, width=width, height=height, bd=border_depth)
                else:
                    element._TKCanvas.master = tk_row_frame
                element.Widget = element._TKCanvas

                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element._TKCanvas.configure(background=element.BackgroundColor, highlightthickness=0)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element._TKCanvas.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element._TKCanvas.pack_forget()
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element._TKCanvas, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

                # -------------------------  Graph placement element  ------------------------- #
            elif element_type == ELEM_TYPE_GRAPH:
                element = element  # type: Graph
                width, height = element_size
                # I don't know why TWO canvases were being defined, on inside the other.  Was it so entire canvas can move?
                # if element._TKCanvas is None:
                #     element._TKCanvas = tk.Canvas(tk_row_frame, width=width, height=height, bd=border_depth)
                # else:
                #     element._TKCanvas.master = tk_row_frame
                element._TKCanvas2 = element.Widget = tk.Canvas(tk_row_frame, width=width, height=height, bd=border_depth)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element._TKCanvas2.pack(side=tk.LEFT, expand=expand, fill=fill)
                element._TKCanvas2.addtag_all('mytag')
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    element._TKCanvas2.configure(background=element.BackgroundColor, highlightthickness=0)
                    # element._TKCanvas.configure(background=element.BackgroundColor, highlightthickness=0)
                element._TKCanvas2.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # element._TKCanvas2.pack_forget()
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element._TKCanvas2, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                if element.ChangeSubmits:
                    element._TKCanvas2.bind('<ButtonRelease-1>', element.ButtonReleaseCallBack)
                    element._TKCanvas2.bind('<ButtonPress-1>', element.ButtonPressCallBack)
                if element.DragSubmits:
                    element._TKCanvas2.bind('<Motion>', element.MotionCallBack)
                _add_right_click_menu_and_grab(element)
            # -------------------------  MENU placement element  ------------------------- #
            elif element_type == ELEM_TYPE_MENUBAR:
                element = element  # type: MenuBar
                menu_def = element.MenuDefinition
                element.TKMenu = element.Widget = tk.Menu(toplevel_form.TKroot, tearoff=element.Tearoff, tearoffcommand=element._tearoff_menu_callback)  # create the menubar
                menubar = element.TKMenu
                if font is not None:  # if a font is used, make sure it's saved in the element
                    element.Font = font
                for menu_entry in menu_def:
                    baritem = tk.Menu(menubar, tearoff=element.Tearoff, tearoffcommand=element._tearoff_menu_callback)
                    if element.BackgroundColor not in (COLOR_SYSTEM_DEFAULT, None):
                        baritem.config(bg=element.BackgroundColor)
                        baritem.config(activeforeground=element.BackgroundColor)
                    if element.TextColor not in (COLOR_SYSTEM_DEFAULT, None):
                        baritem.config(fg=element.TextColor)
                        baritem.config(activebackground=element.TextColor)
                    if element.DisabledTextColor not in (COLOR_SYSTEM_DEFAULT, None):
                        baritem.config(disabledforeground=element.DisabledTextColor)
                    if font is not None:
                        baritem.config(font=font)
                    pos = menu_entry[0].find(MENU_SHORTCUT_CHARACTER)
                    # print(pos)
                    if pos != -1:
                        if pos == 0 or menu_entry[0][pos - len(MENU_SHORTCUT_CHARACTER)] != '\\':
                            menu_entry[0] = menu_entry[0][:pos] + menu_entry[0][pos + 1 :]
                    if menu_entry[0][0] == MENU_DISABLED_CHARACTER:
                        menubar.add_cascade(label=menu_entry[0][len(MENU_DISABLED_CHARACTER) :], menu=baritem, underline=pos - 1)
                        menubar.entryconfig(menu_entry[0][len(MENU_DISABLED_CHARACTER) :], state='disabled')
                    else:
                        menubar.add_cascade(label=menu_entry[0], menu=baritem, underline=pos)

                    if len(menu_entry) > 1:
                        AddMenuItem(baritem, menu_entry[1], element)
                toplevel_form.TKroot.configure(menu=element.TKMenu)
            # -------------------------  Frame placement element  ------------------------- #
            elif element_type == ELEM_TYPE_FRAME:
                element = element  # type: Frame
                labeled_frame = element.Widget = tk.LabelFrame(tk_row_frame, text=element.Title, relief=element.Relief)
                element.TKFrame = labeled_frame
                PackFormIntoFrame(element, labeled_frame, toplevel_form)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                if element.VerticalAlignment is not None:
                    anchor = tk.CENTER  # Default to center if a bad choice is made
                    if element.VerticalAlignment.lower().startswith('t'):
                        anchor = tk.N
                    if element.VerticalAlignment.lower().startswith('c'):
                        anchor = tk.CENTER
                    if element.VerticalAlignment.lower().startswith('b'):
                        anchor = tk.S
                    labeled_frame.pack(side=tk.LEFT, anchor=anchor, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                else:
                    labeled_frame.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)

                if element.Size != (None, None):
                    labeled_frame.config(width=element.Size[0], height=element.Size[1])
                    labeled_frame.pack_propagate(0)
                if not element.visible:
                    element._pack_forget_save_settings()
                    # labeled_frame.pack_forget()
                if element.BackgroundColor != COLOR_SYSTEM_DEFAULT and element.BackgroundColor is not None:
                    labeled_frame.configure(
                        background=element.BackgroundColor,
                        highlightbackground=element.BackgroundColor,
                        highlightcolor=element.BackgroundColor,
                    )
                if element.TextColor != COLOR_SYSTEM_DEFAULT and element.TextColor is not None:
                    labeled_frame.configure(foreground=element.TextColor)
                if font is not None:
                    labeled_frame.configure(font=font)
                if element.TitleLocation is not None:
                    labeled_frame.configure(labelanchor=element.TitleLocation)
                if element.BorderWidth is not None:
                    labeled_frame.configure(borderwidth=element.BorderWidth)
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(labeled_frame, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)
                # row_should_expand=True
            # -------------------------  Tab placement element  ------------------------- #
            elif element_type == ELEM_TYPE_TAB:
                element = element  # type: Tab
                form = form  # type: TabGroup
                element.TKFrame = element.Widget = tk.Frame(form.TKNotebook)
                PackFormIntoFrame(element, element.TKFrame, toplevel_form)
                state = 'normal'
                if element.Disabled:
                    state = 'disabled'
                if element.visible is False:
                    state = 'hidden'
                # this code will add an image to the tab. Use it when adding the image on a tab enhancement
                try:
                    if element.Filename is not None:
                        photo = tk.PhotoImage(file=element.Filename)
                    elif element.Data is not None:
                        photo = tk.PhotoImage(data=element.Data)
                    else:
                        photo = None

                    if element.ImageSubsample and photo is not None:
                        photo = photo.subsample(element.ImageSubsample)
                    if element.zoom and photo is not None:
                        photo = photo.zoom(element.zoom)
                        # print('*ERROR laying out form.... Image Element has no image specified*')
                except Exception as e:
                    photo = None
                    _error_popup_with_traceback(
                        'Your Window has an Tab Element with an IMAGE problem',
                        'The traceback will show you the Window with the problem layout',
                        f'Look in this Window\'s layout for an Image element that has a key of {element.Key}',
                        'The error occuring is:',
                        e,
                    )

                element.photo = photo
                if photo is not None:
                    if element_size == (None, None) or element_size is None or element_size == toplevel_form.DefaultElementSize:
                        width, height = photo.width(), photo.height()
                    else:
                        width, height = element_size
                    element.tktext_label = tk.Label(tk_row_frame, image=photo, width=width, height=height, bd=0)
                else:
                    element.tktext_label = tk.Label(tk_row_frame, bd=0)
                if photo is not None:
                    form.TKNotebook.add(element.TKFrame, text=element.Title, compound=tk.LEFT, state=state, image=photo)

                # element.photo_image = tk.PhotoImage(data=DEFAULT_BASE64_ICON)
                # form.TKNotebook.add(element.TKFrame, text=element.Title, compound=tk.LEFT, state=state,image = element.photo_image)

                form.TKNotebook.add(element.TKFrame, text=element.Title, state=state)
                # July 28 2022 removing the expansion and pack as a test
                # expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                # form.TKNotebook.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], fill=fill, expand=expand)

                element.ParentNotebook = form.TKNotebook
                element.TabID = form.TabCount
                form.tab_index_to_key[element.TabID] = element.key  # has a list of the tabs in the notebook and their associated key
                form.TabCount += 1
                if element.BackgroundColor not in (COLOR_SYSTEM_DEFAULT, None):
                    element.TKFrame.configure(
                        background=element.BackgroundColor,
                        highlightbackground=element.BackgroundColor,
                        highlightcolor=element.BackgroundColor,
                    )

                # if element.BorderWidth is not None:
                #     element.TKFrame.configure(borderwidth=element.BorderWidth)
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKFrame, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)
                # row_should_expand = True
            # -------------------------  TabGroup placement element  ------------------------- #
            elif element_type == ELEM_TYPE_TAB_GROUP:
                element = element  # type: TabGroup
                # custom_style = str(element.Key) + 'customtab.TNotebook'
                custom_style = _make_ttk_style_name('.TNotebook', element, primary_style=True)
                style = ttk.Style()
                _change_ttk_theme(style, toplevel_form.TtkTheme)

                if element.TabLocation is not None:
                    position_dict = {
                        'left': 'w',
                        'right': 'e',
                        'top': 'n',
                        'bottom': 's',
                        'lefttop': 'wn',
                        'leftbottom': 'ws',
                        'righttop': 'en',
                        'rightbottom': 'es',
                        'bottomleft': 'sw',
                        'bottomright': 'se',
                        'topleft': 'nw',
                        'topright': 'ne',
                    }
                    try:
                        tab_position = position_dict[element.TabLocation]
                    except:
                        tab_position = position_dict['top']
                    style.configure(custom_style, tabposition=tab_position)

                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    style.configure(custom_style, background=element.BackgroundColor)

                # FINALLY the proper styling to get tab colors!
                if element.SelectedTitleColor is not None and element.SelectedTitleColor != COLOR_SYSTEM_DEFAULT:
                    style.map(custom_style + '.Tab', foreground=[('selected', element.SelectedTitleColor)])
                if element.SelectedBackgroundColor is not None and element.SelectedBackgroundColor != COLOR_SYSTEM_DEFAULT:
                    style.map(custom_style + '.Tab', background=[('selected', element.SelectedBackgroundColor)])
                if element.TabBackgroundColor is not None and element.TabBackgroundColor != COLOR_SYSTEM_DEFAULT:
                    style.configure(custom_style + '.Tab', background=element.TabBackgroundColor)
                if element.TextColor is not None and element.TextColor != COLOR_SYSTEM_DEFAULT:
                    style.configure(custom_style + '.Tab', foreground=element.TextColor)
                if element.BorderWidth is not None:
                    style.configure(custom_style, borderwidth=element.BorderWidth)
                if element.TabBorderWidth is not None:
                    style.configure(custom_style + '.Tab', borderwidth=element.TabBorderWidth)  # if ever want to get rid of border around the TABS themselves
                if element.FocusColor not in (None, COLOR_SYSTEM_DEFAULT):
                    style.configure(custom_style + '.Tab', focuscolor=element.FocusColor)

                style.configure(custom_style + '.Tab', font=font)
                element.Style = style
                element.StyleName = custom_style
                element.TKNotebook = element.Widget = ttk.Notebook(tk_row_frame, style=custom_style)

                PackFormIntoFrame(element, toplevel_form.TKroot, toplevel_form)

                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKNotebook.pack(anchor=tk.SW, side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], fill=fill, expand=expand)

                if element.ChangeSubmits:
                    element.TKNotebook.bind('<<NotebookTabChanged>>', element._TabGroupSelectHandler)
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKNotebook, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                if element.Size != (None, None):
                    element.TKNotebook.configure(width=element.Size[0], height=element.Size[1])
                _add_right_click_menu_and_grab(element)
                if element.visible is False:
                    element._pack_forget_save_settings()
                # row_should_expand = True
                # -------------------  SLIDER placement element  ------------------------- #
            elif element_type == ELEM_TYPE_INPUT_SLIDER:
                element = element  # type: Slider
                slider_length = element_size[0] * _char_width_in_pixels(font)
                slider_width = element_size[1]
                element.TKIntVar = tk.IntVar()
                element.TKIntVar.set(element.DefaultValue)
                if element.Orientation.startswith('v'):
                    range_from = element.Range[1]
                    range_to = element.Range[0]
                    slider_length += DEFAULT_MARGINS[1] * (element_size[0] * 2)  # add in the padding
                else:
                    range_from = element.Range[0]
                    range_to = element.Range[1]
                tkscale = element.Widget = tk.Scale(
                    tk_row_frame,
                    orient=element.Orientation,
                    variable=element.TKIntVar,
                    from_=range_from,
                    to_=range_to,
                    resolution=element.Resolution,
                    length=slider_length,
                    width=slider_width,
                    bd=element.BorderWidth,
                    relief=element.Relief,
                    font=font,
                    tickinterval=element.TickInterval,
                )
                tkscale.config(highlightthickness=0)
                if element.ChangeSubmits:
                    tkscale.config(command=element._SliderChangedHandler)
                if element.BackgroundColor not in (None, COLOR_SYSTEM_DEFAULT):
                    tkscale.configure(background=element.BackgroundColor)
                if element.TroughColor != COLOR_SYSTEM_DEFAULT:
                    tkscale.config(troughcolor=element.TroughColor)
                if element.DisableNumericDisplay:
                    tkscale.config(showvalue=0)
                if text_color not in (None, COLOR_SYSTEM_DEFAULT):
                    tkscale.configure(fg=text_color)
                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                tkscale.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # tkscale.pack_forget()
                element.TKScale = tkscale
                if element.Disabled is True:
                    element.TKScale['state'] = 'disabled'
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKScale, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

            # -------------------------  TABLE placement element  ------------------------- #
            elif element_type == ELEM_TYPE_TABLE:
                element = element  # type: Table
                element.element_frame = frame = tk.Frame(tk_row_frame)
                element.table_frame = frame
                height = element.NumRows
                if element.Justification.startswith('l'):
                    anchor = tk.W
                elif element.Justification.startswith('r'):
                    anchor = tk.E
                else:
                    anchor = tk.CENTER
                column_widths = {}
                # create column width list
                for row in element.Values:
                    for i, col in enumerate(row):
                        col_width = min(len(str(col)), element.MaxColumnWidth)
                        try:
                            if col_width > column_widths[i]:
                                column_widths[i] = col_width
                        except:
                            column_widths[i] = col_width

                if element.ColumnsToDisplay is None:
                    displaycolumns = element.ColumnHeadings if element.ColumnHeadings is not None else element.Values[0]
                else:
                    displaycolumns = []
                    for i, should_display in enumerate(element.ColumnsToDisplay):
                        if should_display:
                            if element.ColumnHeadings is not None:
                                displaycolumns.append(element.ColumnHeadings[i])
                            else:
                                displaycolumns.append(str(i))

                column_headings = element.ColumnHeadings if element.ColumnHeadings is not None else displaycolumns
                if element.DisplayRowNumbers:  # if display row number, tack on the numbers to front of columns
                    displaycolumns = [
                        element.RowHeaderText,
                    ] + displaycolumns
                    if column_headings is not None:
                        column_headings = [
                            element.RowHeaderText,
                        ] + element.ColumnHeadings
                    else:
                        column_headings = [
                            element.RowHeaderText,
                        ] + displaycolumns
                element.TKTreeview = element.Widget = ttk.Treeview(
                    frame,
                    columns=column_headings,
                    displaycolumns=displaycolumns,
                    show='headings',
                    height=height,
                    selectmode=element.SelectMode,
                )
                treeview = element.TKTreeview
                if element.DisplayRowNumbers:
                    treeview.heading(element.RowHeaderText, text=element.RowHeaderText)  # make a dummy heading
                    row_number_header_width = _string_width_in_pixels(element.HeaderFont, element.RowHeaderText) + 10
                    row_number_width = _string_width_in_pixels(font, str(len(element.Values))) + 10
                    row_number_width = max(row_number_header_width, row_number_width)
                    treeview.column(element.RowHeaderText, width=row_number_width, minwidth=10, anchor=anchor, stretch=0)

                headings = element.ColumnHeadings if element.ColumnHeadings is not None else element.Values[0]
                for i, heading in enumerate(headings):
                    # heading = str(heading)
                    treeview.heading(heading, text=heading)
                    if element.AutoSizeColumns:
                        col_width = column_widths.get(i, len(heading))  # in case more headings than there are columns of data
                        width = max(
                            col_width * _char_width_in_pixels(font),
                            len(heading) * _char_width_in_pixels(element.HeaderFont),
                        )
                    else:
                        try:
                            width = element.ColumnWidths[i] * _char_width_in_pixels(font)
                        except:
                            width = element.DefaultColumnWidth * _char_width_in_pixels(font)
                    if element.cols_justification is not None:
                        try:
                            if element.cols_justification[i].startswith('l'):
                                col_anchor = tk.W
                            elif element.cols_justification[i].startswith('r'):
                                col_anchor = tk.E
                            elif element.cols_justification[i].startswith('c'):
                                col_anchor = tk.CENTER
                            else:
                                col_anchor = anchor

                        except:  # likely didn't specify enough entries (must be one per col)
                            col_anchor = anchor
                    else:
                        col_anchor = anchor
                    treeview.column(heading, width=width, minwidth=10, anchor=col_anchor, stretch=element.expand_x)
                # Insert values into the tree
                for i, value in enumerate(element.Values):
                    if element.DisplayRowNumbers:
                        value = [i + element.StartingRowNumber] + value
                    id = treeview.insert('', 'end', text=value, iid=i + 1, values=value, tag=i)
                    element.tree_ids.append(id)
                if element.AlternatingRowColor not in (None, COLOR_SYSTEM_DEFAULT):  # alternating colors
                    for row in range(0, len(element.Values), 2):
                        treeview.tag_configure(row, background=element.AlternatingRowColor)
                if element.RowColors is not None:  # individual row colors
                    for row_def in element.RowColors:
                        if len(row_def) == 2:  # only background is specified
                            treeview.tag_configure(row_def[0], background=row_def[1])
                        else:
                            treeview.tag_configure(row_def[0], background=row_def[2], foreground=row_def[1])
                # ------ Do Styling of Colors -----
                # style_name = str(element.Key) + 'customtable.Treeview'
                style_name = _make_ttk_style_name('.Treeview', element, primary_style=True)
                element.table_ttk_style_name = style_name
                table_style = ttk.Style()
                element.ttk_style = table_style

                _change_ttk_theme(table_style, toplevel_form.TtkTheme)

                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    table_style.configure(
                        style_name,
                        background=element.BackgroundColor,
                        fieldbackground=element.BackgroundColor,
                    )
                    if element.SelectedRowColors[1] is not None:
                        table_style.map(
                            style_name,
                            background=_fixed_map(table_style, style_name, 'background', element.SelectedRowColors),
                        )
                if element.TextColor is not None and element.TextColor != COLOR_SYSTEM_DEFAULT:
                    table_style.configure(style_name, foreground=element.TextColor)
                    if element.SelectedRowColors[0] is not None:
                        table_style.map(
                            style_name,
                            foreground=_fixed_map(table_style, style_name, 'foreground', element.SelectedRowColors),
                        )
                if element.RowHeight is not None:
                    table_style.configure(style_name, rowheight=element.RowHeight)
                else:
                    table_style.configure(style_name, rowheight=_char_height_in_pixels(font))
                if element.HeaderTextColor is not None and element.HeaderTextColor != COLOR_SYSTEM_DEFAULT:
                    table_style.configure(style_name + '.Heading', foreground=element.HeaderTextColor)
                if element.HeaderBackgroundColor is not None and element.HeaderBackgroundColor != COLOR_SYSTEM_DEFAULT:
                    table_style.configure(style_name + '.Heading', background=element.HeaderBackgroundColor)
                if element.HeaderFont is not None:
                    table_style.configure(style_name + '.Heading', font=element.HeaderFont)
                else:
                    table_style.configure(style_name + '.Heading', font=font)
                if element.HeaderBorderWidth is not None:
                    table_style.configure(style_name + '.Heading', borderwidth=element.HeaderBorderWidth)
                if element.HeaderRelief is not None:
                    table_style.configure(style_name + '.Heading', relief=element.HeaderRelief)
                table_style.configure(style_name, font=font)
                if element.BorderWidth is not None:
                    table_style.configure(style_name, borderwidth=element.BorderWidth)

                if element.HeaderBackgroundColor not in (
                    None,
                    COLOR_SYSTEM_DEFAULT,
                ) and element.HeaderTextColor not in (None, COLOR_SYSTEM_DEFAULT):
                    table_style.map(
                        style_name + '.Heading',
                        background=[
                            ('pressed', '!focus', element.HeaderBackgroundColor),
                            ('active', element.HeaderTextColor),
                        ],
                    )
                    table_style.map(
                        style_name + '.Heading',
                        foreground=[
                            ('pressed', '!focus', element.HeaderTextColor),
                            ('active', element.HeaderBackgroundColor),
                        ],
                    )

                treeview.configure(style=style_name)
                # scrollable_frame.pack(side=tk.LEFT,  padx=elementpad[0], pady=elementpad[1], expand=True, fill='both')
                if element.enable_click_events is True:
                    treeview.bind('<ButtonRelease-1>', element._table_clicked)
                if element.right_click_selects:
                    if running_mac():
                        treeview.bind('<Button-2>', element._table_clicked)
                    else:
                        treeview.bind('<Button-3>', element._table_clicked)
                treeview.bind('<<TreeviewSelect>>', element._treeview_selected)
                if element.BindReturnKey:
                    treeview.bind('<Return>', element._treeview_double_click)
                    treeview.bind('<Double-Button-1>', element._treeview_double_click)

                if not element.HideVerticalScroll:
                    _make_ttk_scrollbar(element, 'v', toplevel_form)

                    element.Widget.configure(yscrollcommand=element.vsb.set)
                    element.vsb.pack(side=tk.RIGHT, fill='y')

                # Horizontal scrollbar
                if not element.VerticalScrollOnly:
                    # element.Widget.config(wrap='none')
                    _make_ttk_scrollbar(element, 'h', toplevel_form)
                    element.hsb.pack(side=tk.BOTTOM, fill='x')
                    element.Widget.configure(xscrollcommand=element.hsb.set)

                if not element.HideVerticalScroll or not element.VerticalScrollOnly:
                    # Chr0nic
                    element.Widget.bind('<Enter>', lambda event, em=element: testMouseHook(em))
                    element.Widget.bind('<Leave>', lambda event, em=element: testMouseUnhook(em))

                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKTreeview.pack(side=tk.LEFT, padx=0, pady=0, expand=expand, fill=fill)
                frame.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings(alternate_widget=element.element_frame)  # seems like it should be the frame if following other elements conventions
                    # element.TKTreeview.pack_forget()
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKTreeview, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

                if tclversion_detailed == '8.6.9' and ENABLE_TREEVIEW_869_PATCH:
                    # print('*** tk version 8.6.9 detected.... patching ttk treeview code ***')
                    table_style.map(
                        style_name,
                        foreground=_fixed_map(table_style, style_name, 'foreground', element.SelectedRowColors),
                        background=_fixed_map(table_style, style_name, 'background', element.SelectedRowColors),
                    )
            # -------------------------  Tree placement element  ------------------------- #
            elif element_type == ELEM_TYPE_TREE:
                element = element  # type: Tree
                element.element_frame = element_frame = tk.Frame(tk_row_frame)

                height = element.NumRows
                if element.Justification.startswith('l'):  # justification
                    anchor = tk.W
                elif element.Justification.startswith('r'):
                    anchor = tk.E
                else:
                    anchor = tk.CENTER

                if element.ColumnsToDisplay is None:  # Which cols to display
                    displaycolumns = element.ColumnHeadings
                else:
                    displaycolumns = []
                    for i, should_display in enumerate(element.ColumnsToDisplay):
                        if should_display:
                            displaycolumns.append(element.ColumnHeadings[i])
                column_headings = element.ColumnHeadings
                # ------------- GET THE TREEVIEW WIDGET -------------
                element.TKTreeview = element.Widget = ttk.Treeview(
                    element_frame,
                    columns=column_headings,
                    displaycolumns=displaycolumns,
                    show='tree headings' if column_headings is not None else 'tree',
                    height=height,
                    selectmode=element.SelectMode,
                )
                treeview = element.TKTreeview
                max_widths = {}
                for key, node in element.TreeData.tree_dict.items():
                    for i, value in enumerate(node.values):
                        max_width = max_widths.get(i, 0)
                        if len(str(value)) > max_width:
                            max_widths[i] = len(str(value))

                if element.ColumnHeadings is not None:
                    for i, heading in enumerate(element.ColumnHeadings):  # Configure cols + headings
                        treeview.heading(heading, text=heading)
                        if element.AutoSizeColumns:
                            max_width = max_widths.get(i, 0)
                            max_width = max(max_width, len(heading))
                            width = min(element.MaxColumnWidth, max_width + 1)
                        else:
                            try:
                                width = element.ColumnWidths[i]
                            except:
                                width = element.DefaultColumnWidth
                        treeview.column(heading, width=width * _char_width_in_pixels(font) + 10, anchor=anchor)

                def add_treeview_data(node):
                    """

                    :param node:
                    :type node:

                    """
                    if node.key != '':
                        if node.icon:
                            if node.icon not in element.image_dict:
                                if type(node.icon) is bytes:
                                    photo = tk.PhotoImage(data=node.icon)
                                else:
                                    photo = tk.PhotoImage(file=node.icon)
                                element.image_dict[node.icon] = photo
                            else:
                                photo = element.image_dict.get(node.icon)

                            node.photo = photo
                            try:
                                id = treeview.insert(
                                    element.KeyToID[node.parent],
                                    'end',
                                    iid=None,
                                    text=node.text,
                                    values=node.values,
                                    open=element.ShowExpanded,
                                    image=node.photo,
                                )
                                element.IdToKey[id] = node.key
                                element.KeyToID[node.key] = id
                            except Exception as e:
                                print('Error inserting image into tree', e)
                        else:
                            id = treeview.insert(
                                element.KeyToID[node.parent],
                                'end',
                                iid=None,
                                text=node.text,
                                values=node.values,
                                open=element.ShowExpanded,
                            )
                            element.IdToKey[id] = node.key
                            element.KeyToID[node.key] = id

                    for node in node.children:
                        add_treeview_data(node)

                add_treeview_data(element.TreeData.root_node)
                treeview.column('#0', width=element.Col0Width * _char_width_in_pixels(font), anchor=tk.W)
                treeview.heading('#0', text=element.col0_heading)

                # ----- configure colors -----
                # style_name = str(element.Key) + '.Treeview'
                style_name = _make_ttk_style_name('.Treeview', element, primary_style=True)
                tree_style = ttk.Style()
                _change_ttk_theme(tree_style, toplevel_form.TtkTheme)

                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    tree_style.configure(style_name, background=element.BackgroundColor, fieldbackground=element.BackgroundColor)
                    if element.SelectedRowColors[1] is not None:
                        tree_style.map(
                            style_name,
                            background=_fixed_map(tree_style, style_name, 'background', element.SelectedRowColors),
                        )
                if element.TextColor is not None and element.TextColor != COLOR_SYSTEM_DEFAULT:
                    tree_style.configure(style_name, foreground=element.TextColor)
                    if element.SelectedRowColors[0] is not None:
                        tree_style.map(
                            style_name,
                            foreground=_fixed_map(tree_style, style_name, 'foreground', element.SelectedRowColors),
                        )
                if element.HeaderTextColor is not None and element.HeaderTextColor != COLOR_SYSTEM_DEFAULT:
                    tree_style.configure(style_name + '.Heading', foreground=element.HeaderTextColor)
                if element.HeaderBackgroundColor is not None and element.HeaderBackgroundColor != COLOR_SYSTEM_DEFAULT:
                    tree_style.configure(style_name + '.Heading', background=element.HeaderBackgroundColor)
                if element.HeaderFont is not None:
                    tree_style.configure(style_name + '.Heading', font=element.HeaderFont)
                else:
                    tree_style.configure(style_name + '.Heading', font=font)
                if element.HeaderBorderWidth is not None:
                    tree_style.configure(style_name + '.Heading', borderwidth=element.HeaderBorderWidth)
                if element.HeaderRelief is not None:
                    tree_style.configure(style_name + '.Heading', relief=element.HeaderRelief)
                tree_style.configure(style_name, font=font)
                if element.RowHeight:
                    tree_style.configure(style_name, rowheight=element.RowHeight)
                else:
                    tree_style.configure(style_name, rowheight=_char_height_in_pixels(font))
                if element.BorderWidth is not None:
                    tree_style.configure(style_name, borderwidth=element.BorderWidth)

                treeview.configure(style=style_name)  # IMPORTANT! Be sure and set the style name for this widget

                if not element.HideVerticalScroll:
                    _make_ttk_scrollbar(element, 'v', toplevel_form)

                    element.Widget.configure(yscrollcommand=element.vsb.set)
                    element.vsb.pack(side=tk.RIGHT, fill='y')

                # Horizontal scrollbar
                if not element.VerticalScrollOnly:
                    # element.Widget.config(wrap='none')
                    _make_ttk_scrollbar(element, 'h', toplevel_form)
                    element.hsb.pack(side=tk.BOTTOM, fill='x')
                    element.Widget.configure(xscrollcommand=element.hsb.set)

                if not element.HideVerticalScroll or not element.VerticalScrollOnly:
                    element.Widget.bind('<Enter>', lambda event, em=element: testMouseHook(em))
                    element.Widget.bind('<Leave>', lambda event, em=element: testMouseUnhook(em))

                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)
                element.TKTreeview.pack(side=tk.LEFT, padx=0, pady=0, expand=expand, fill=fill)
                element_frame.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], expand=expand, fill=fill)
                if element.visible is False:
                    element._pack_forget_save_settings(alternate_widget=element.element_frame)  # seems like it should be the frame if following other elements conventions
                    # element.TKTreeview.pack_forget()
                treeview.bind('<<TreeviewSelect>>', element._treeview_selected)
                if element.Tooltip is not None:  # tooltip
                    element.TooltipObject = ToolTip(element.TKTreeview, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

                if tclversion_detailed == '8.6.9' and ENABLE_TREEVIEW_869_PATCH:
                    # print('*** tk version 8.6.9 detected.... patching ttk treeview code ***')
                    tree_style.map(
                        style_name,
                        foreground=_fixed_map(tree_style, style_name, 'foreground', element.SelectedRowColors),
                        background=_fixed_map(tree_style, style_name, 'background', element.SelectedRowColors),
                    )

            # -------------------------  Separator placement element  ------------------------- #
            elif element_type == ELEM_TYPE_SEPARATOR:
                element = element  # type: VerticalSeparator
                # style_name = str(element.Key) + "Line.TSeparator"
                style_name = _make_ttk_style_name('.Line.TSeparator', element, primary_style=True)
                style = ttk.Style()

                _change_ttk_theme(style, toplevel_form.TtkTheme)

                if element.color not in (None, COLOR_SYSTEM_DEFAULT):
                    style.configure(style_name, background=element.color)
                separator = element.Widget = ttk.Separator(
                    tk_row_frame,
                    orient=element.Orientation,
                )

                expand, fill, row_should_expand, row_fill_direction = _add_expansion(element, row_should_expand, row_fill_direction)

                if element.Orientation.startswith('h'):
                    separator.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], fill=tk.X, expand=True)
                else:
                    separator.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], fill=tk.Y, expand=False)
                element.Widget.configure(style=style_name)  # IMPORTANT!  Apply the style
            # -------------------------  SizeGrip placement element  ------------------------- #
            elif element_type == ELEM_TYPE_SIZEGRIP:
                element = element  # type: Sizegrip
                style_name = 'Sizegrip.TSizegrip'
                style = ttk.Style()

                _change_ttk_theme(style, toplevel_form.TtkTheme)

                size_grip = element.Widget = ttk.Sizegrip(tk_row_frame)
                toplevel_form.sizegrip_widget = size_grip
                # if no size is specified, then use the background color for the window
                if element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    style.configure(style_name, background=element.BackgroundColor)
                else:
                    style.configure(style_name, background=toplevel_form.TKroot['bg'])
                size_grip.configure(style=style_name)

                size_grip.pack(side=tk.BOTTOM, anchor='se', padx=elementpad[0], pady=elementpad[1], fill=tk.X, expand=True)
                # tricky part of sizegrip... it shouldn't cause the row to expand, but should expand and should add X axis if
                # not already filling in that direction.  Otherwise, leaves things alone!
                # row_should_expand = True
                row_fill_direction = tk.BOTH if row_fill_direction in (tk.Y, tk.BOTH) else tk.X
            # -------------------------  StatusBar placement element  ------------------------- #
            elif element_type == ELEM_TYPE_STATUSBAR:
                # auto_size_text = element.AutoSizeText
                display_text = element.DisplayText  # text to display
                if auto_size_text is False:
                    width, height = element_size
                else:
                    lines = display_text.split('\n')
                    max_line_len = max([len(line) for line in lines])
                    num_lines = len(lines)
                    if max_line_len > element_size[0]:  # if text exceeds element size, the will have to wrap
                        width = element_size[0]
                    else:
                        width = max_line_len
                    height = num_lines
                # ---===--- LABEL widget create and place --- #
                stringvar = tk.StringVar()
                element.TKStringVar = stringvar
                stringvar.set(display_text)
                if auto_size_text:
                    width = 0
                if element.Justification is not None:
                    justification = element.Justification
                elif toplevel_form.TextJustification is not None:
                    justification = toplevel_form.TextJustification
                else:
                    justification = DEFAULT_TEXT_JUSTIFICATION
                justify = tk.LEFT if justification.startswith('l') else tk.CENTER if justification.startswith('c') else tk.RIGHT
                anchor = tk.NW if justification.startswith('l') else tk.N if justification.startswith('c') else tk.NE
                tktext_label = element.Widget = tk.Label(
                    tk_row_frame,
                    textvariable=stringvar,
                    width=width,
                    height=height,
                    justify=justify,
                    bd=border_depth,
                    font=font,
                )
                # Set wrap-length for text (in PIXELS) == PAIN IN THE ASS
                wraplen = tktext_label.winfo_reqwidth() + 40  # width of widget in Pixels
                if not auto_size_text and height == 1:
                    wraplen = 0
                # print("wraplen, width, height", wraplen, width, height)
                tktext_label.configure(anchor=anchor, wraplen=wraplen)  # set wrap to width of widget
                if element.Relief is not None:
                    tktext_label.configure(relief=element.Relief)
                if element.BackgroundColor is not None and element.BackgroundColor != COLOR_SYSTEM_DEFAULT:
                    tktext_label.configure(background=element.BackgroundColor)
                if element.TextColor != COLOR_SYSTEM_DEFAULT and element.TextColor is not None:
                    tktext_label.configure(fg=element.TextColor)
                tktext_label.pack(side=tk.LEFT, padx=elementpad[0], pady=elementpad[1], fill=tk.X, expand=True)
                row_fill_direction = tk.X
                if element.visible is False:
                    element._pack_forget_save_settings()
                    # tktext_label.pack_forget()
                element.TKText = tktext_label
                if element.ClickSubmits:
                    tktext_label.bind('<Button-1>', element._TextClickedHandler)
                if element.Tooltip is not None:
                    element.TooltipObject = ToolTip(element.TKText, text=element.Tooltip, timeout=DEFAULT_TOOLTIP_TIME)
                _add_right_click_menu_and_grab(element)

        # ............................DONE WITH ROW pack the row of widgets ..........................#
        # done with row, pack the row of widgets

        anchor = 'nw'

        if row_justify.lower().startswith('c'):
            anchor = 'n'
        elif row_justify.lower().startswith('r'):
            anchor = 'ne'
        elif row_justify.lower().startswith('l'):
            anchor = 'nw'

        tk_row_frame.pack(side=tk.TOP, anchor=anchor, padx=0, pady=0, expand=row_should_expand, fill=row_fill_direction)
        if form.BackgroundColor is not None and form.BackgroundColor != COLOR_SYSTEM_DEFAULT:
            tk_row_frame.configure(background=form.BackgroundColor)

    return


def _get_hidden_master_root():
    """
    Creates the hidden master root window.  This window is never visible and represents the overall "application"
    """

    # if one is already made, then skip making another
    if Window.hidden_master_root is None:
        Window._IncrementOpenCount()
        Window.hidden_master_root = tk.Tk()
        Window.hidden_master_root.attributes('-alpha', 0)  # HIDE this window really really really
        # if not running_mac():
        try:
            Window.hidden_master_root.wm_overrideredirect(True)
        except Exception as e:
            if not running_mac():
                print('* Error performing wm_overrideredirect while hiding the hidden master root*', e)
        Window.hidden_master_root.withdraw()
    return Window.hidden_master_root


def _no_titlebar_setup(window):
    """
    Does the operations required to turn off the titlebar for the window.
    The Raspberry Pi required the settings to be make after the window's creation.
    Calling twice seems to have had better overall results so that's what's currently done.
    The MAC has been the problem with this feature.  It's been a chronic problem on the Mac.
    :param window:          window to turn off the titlebar if indicated in the settings
    :type window:           Window
    """
    try:
        if window.NoTitleBar:
            if running_linux():
                # window.TKroot.wm_attributes("-type", 'splash')
                window.TKroot.wm_attributes('-type', 'dock')
            else:
                window.TKroot.wm_overrideredirect(True)
                # Special case for Mac. Need to clear flag again if not tkinter version 8.6.10+
                # Previously restricted patch to only certain tkinter versions. Now use the patch setting exclusively regardless of tk ver
                # if running_mac() and ENABLE_MAC_NOTITLEBAR_PATCH and (sum([int(i) for i in tclversion_detailed.split('.')]) < 24):
                # if running_mac() and ENABLE_MAC_NOTITLEBAR_PATCH:
                if _mac_should_apply_notitlebar_patch():
                    print('* Applying Mac no_titlebar patch *')
                    window.TKroot.wm_overrideredirect(False)
    except Exception as e:
        warnings.warn(f'** Problem setting no titlebar {e} **', UserWarning)


def _convert_window_to_tk(window):
    """

    :type window: (Window)

    """
    master = window.TKroot
    master.title(window.Title)
    InitializeResults(window)

    PackFormIntoFrame(window, master, window)

    window.TKroot.configure(padx=window.Margins[0], pady=window.Margins[1])

    # ....................................... DONE creating and laying out window ..........................#
    if window._Size != (None, None):
        master.geometry('{}x{}'.format(window._Size[0], window._Size[1]))
    screen_width = master.winfo_screenwidth()  # get window info to move to middle of screen
    screen_height = master.winfo_screenheight()
    if window.Location is not None:
        if window.Location != (None, None):
            x, y = window.Location
        elif DEFAULT_WINDOW_LOCATION != (None, None):
            x, y = DEFAULT_WINDOW_LOCATION
        else:
            master.update_idletasks()  # don't forget to do updates or values are bad
            win_width = master.winfo_width()
            win_height = master.winfo_height()
            x = screen_width / 2 - win_width / 2
            y = screen_height / 2 - win_height / 2
            if y + win_height > screen_height:
                y = screen_height - win_height
            if x + win_width > screen_width:
                x = screen_width - win_width

        if window.RelativeLoction != (None, None):
            x += window.RelativeLoction[0]
            y += window.RelativeLoction[1]

        move_string = '+%i+%i' % (int(x), int(y))
        master.geometry(move_string)
        window.config_last_location = (int(x), (int(y)))
        window.TKroot.x = int(x)
        window.TKroot.y = int(y)
        window.starting_window_position = (int(x), (int(y)))
        master.update_idletasks()  # don't forget
        master.geometry(move_string)
        master.update_idletasks()  # don't forget
    else:
        master.update_idletasks()
        x, y = int(master.winfo_x()), int(master.winfo_y())
        window.config_last_location = x, y
        window.TKroot.x = x
        window.TKroot.y = y
        window.starting_window_position = x, y
    _no_titlebar_setup(window)

    return


# ----====----====----====----====----==== STARTUP TK ====----====----====----====----====----#
def StartupTK(window):
    """
    NOT user callable
    Creates the window (for real) lays out all the elements, etc.  It's a HUGE set of things it does.  It's the basic
    "porting layer" that will change depending on the GUI framework PySimpleGUI is running on top of.

    :param window: you window object
    :type window:  (Window)

    """
    window = window  # type: Window
    # global _my_windows
    # ow = _my_windows.NumOpenWindows
    ow = Window.NumOpenWindows
    # print('Starting TK open Windows = {}'.format(ow))
    if ENABLE_TK_WINDOWS:
        root = tk.Tk()
    elif not ow and not window.ForceTopLevel:
        # if first window being created, make a throwaway, hidden master root.  This stops one user
        # window from becoming the child of another user window. All windows are children of this hidden window
        _get_hidden_master_root()
        root = tk.Toplevel(class_=window.Title)
    else:
        root = tk.Toplevel(class_=window.Title)
    if window.DebuggerEnabled:
        root.bind('<Cancel>', window._callback_main_debugger_window_create_keystroke)
        root.bind('<Pause>', window._callback_popout_window_create_keystroke)

    # If location is None, then there's no need to hide the window.  Let it build where it is going to end up being.
    if DEFAULT_HIDE_WINDOW_WHEN_CREATING is True and window.Location is not None:
        try:
            if not running_mac() or (running_mac() and not window.NoTitleBar) or (running_mac() and window.NoTitleBar and not _mac_should_apply_notitlebar_patch()):

                root.attributes('-alpha', 0)  # hide window while building it. makes for smoother 'paint'
        except Exception as e:
            print('*** Exception setting alpha channel to zero while creating window ***', e)

    if window.BackgroundColor is not None and window.BackgroundColor != COLOR_SYSTEM_DEFAULT:
        root.configure(background=window.BackgroundColor)
    Window._IncrementOpenCount()

    window.TKroot = root

    window._create_thread_queue()

    # for the Raspberry Pi. Need to set the attributes here, prior to the building of the window
    # so going ahead and doing it for all platforms, in addition to doing it after the window is packed
    # 2023-April - this call seems to be causing problems on MacOS 13.2.1 Ventura.  Input elements become non-responsive
    # if this call is made here and at the end of building the window
    if not running_mac():
        _no_titlebar_setup(window)

    if not window.Resizable:
        root.resizable(False, False)

    if window.DisableMinimize:
        root.attributes('-toolwindow', 1)

    if window.KeepOnTop:
        root.wm_attributes('-topmost', 1)

    if window.TransparentColor is not None:
        window.SetTransparentColor(window.TransparentColor)

    if window.scaling is not None:
        root.tk.call('tk', 'scaling', window.scaling)

    # root.protocol("WM_DELETE_WINDOW", MyFlexForm.DestroyedCallback())
    # root.bind('<Destroy>', MyFlexForm.DestroyedCallback())
    _convert_window_to_tk(window)

    # Make moveable window
    if window.GrabAnywhere is not False and not (window.NonBlocking and window.GrabAnywhere is not True):
        if not (ENABLE_MAC_DISABLE_GRAB_ANYWHERE_WITH_TITLEBAR and running_mac() and not window.NoTitleBar):
            root.bind('<ButtonPress-1>', window._StartMoveGrabAnywhere)
            root.bind('<ButtonRelease-1>', window._StopMove)
            root.bind('<B1-Motion>', window._OnMotionGrabAnywhere)
    if window.GrabAnywhereUsingControlKey is not False and not (window.NonBlocking and window.GrabAnywhereUsingControlKey is not True):
        root.bind('<Control-Button-1>', window._StartMoveUsingControlKey)
        root.bind('<Control-ButtonRelease-1>', window._StopMove)
        root.bind('<Control-B1-Motion>', window._OnMotionUsingControlKey)
        # also enable movement using Control + Arrow key
        root.bind('<Control-Left>', window._move_callback)
        root.bind('<Control-Right>', window._move_callback)
        root.bind('<Control-Up>', window._move_callback)
        root.bind('<Control-Down>', window._move_callback)

    window.set_icon(window.WindowIcon)
    try:
        alpha_channel = 1 if window.AlphaChannel is None else window.AlphaChannel
        root.attributes('-alpha', alpha_channel)  # Make window visible again
    except Exception as e:
        print(f'**** Error setting Alpha Channel to {alpha_channel} after window was created ****', e)
        # pass

    if window.ReturnKeyboardEvents and not window.NonBlocking:
        root.bind('<KeyRelease>', window._KeyboardCallback)
        root.bind('<MouseWheel>', window._MouseWheelCallback)
        root.bind('<Button-4>', window._MouseWheelCallback)
        root.bind('<Button-5>', window._MouseWheelCallback)
    elif window.ReturnKeyboardEvents:
        root.bind('<Key>', window._KeyboardCallback)
        root.bind('<MouseWheel>', window._MouseWheelCallback)
        root.bind('<Button-4>', window._MouseWheelCallback)
        root.bind('<Button-5>', window._MouseWheelCallback)

    DEFAULT_WINDOW_SNAPSHOT_KEY_CODE = main_global_get_screen_snapshot_symcode()

    if DEFAULT_WINDOW_SNAPSHOT_KEY_CODE:
        # print('**** BINDING THE SNAPSHOT!', DEFAULT_WINDOW_SNAPSHOT_KEY_CODE, DEFAULT_WINDOW_SNAPSHOT_KEY)
        window.bind(DEFAULT_WINDOW_SNAPSHOT_KEY_CODE, DEFAULT_WINDOW_SNAPSHOT_KEY, propagate=False)
        # window.bind('<Win_L><F12>', DEFAULT_WINDOW_SNAPSHOT_KEY, )

    if window.NoTitleBar:
        window.TKroot.focus_force()

    if window.AutoClose:
        # if the window is being finalized, then don't start the autoclose timer
        if not window.finalize_in_progress:
            window._start_autoclose_timer()
            # duration = DEFAULT_AUTOCLOSE_TIME if window.AutoCloseDuration is None else window.AutoCloseDuration
            # window.TKAfterID = root.after(int(duration * 1000), window._AutoCloseAlarmCallback)

    if window.Timeout is not None:
        window.TKAfterID = root.after(int(window.Timeout), window._TimeoutAlarmCallback)
    if window.NonBlocking:
        window.TKroot.protocol('WM_DESTROY_WINDOW', window._OnClosingCallback)
        window.TKroot.protocol('WM_DELETE_WINDOW', window._OnClosingCallback)

    else:  # it's a blocking form
        # print('..... CALLING MainLoop')
        window.CurrentlyRunningMainloop = True
        window.TKroot.protocol('WM_DESTROY_WINDOW', window._OnClosingCallback)
        window.TKroot.protocol('WM_DELETE_WINDOW', window._OnClosingCallback)

        if window.modal or DEFAULT_MODAL_WINDOWS_FORCED:
            window.make_modal()

        if window.enable_window_config_events:
            window.TKroot.bind('<Configure>', window._config_callback)

        # ----------------------------------- tkinter mainloop call -----------------------------------
        Window._window_running_mainloop = window
        Window._root_running_mainloop = window.TKroot
        window.TKroot.mainloop()
        window.CurrentlyRunningMainloop = False
        window.TimerCancelled = True
        # print('..... BACK from MainLoop')
        if not window.FormRemainedOpen:
            Window._DecrementOpenCount()
            # _my_windows.Decrement()
        if window.RootNeedsDestroying:
            try:
                window.TKroot.destroy()
            except:
                pass
            window.RootNeedsDestroying = False
    return


def _set_icon_for_tkinter_window(root, icon=None, pngbase64=None):
    """
    At the moment, this function is only used by the get_filename or folder with the no_window option set.
    Changes the icon that is shown on the title bar and on the task bar.
    NOTE - The file type is IMPORTANT and depends on the OS!
    Can pass in:
    * filename which must be a .ICO icon file for windows, PNG file for Linux
    * bytes object
    * BASE64 encoded file held in a variable

    :param root:      The window being modified
    :type root:       (tk.Tk or tk.TopLevel)
    :param icon:      Filename or bytes object
    :type icon:       (str | bytes)
    :param pngbase64: Base64 encoded image
    :type pngbase64:  (bytes)
    """

    if type(icon) is bytes or pngbase64 is not None:
        wicon = tkinter.PhotoImage(data=icon if icon is not None else pngbase64)
        try:
            root.tk.call('wm', 'iconphoto', root._w, wicon)
        except:
            wicon = tkinter.PhotoImage(data=DEFAULT_BASE64_ICON)
            try:
                root.tk.call('wm', 'iconphoto', root._w, wicon)
            except Exception as e:
                print('Set icon exception', e)
                pass
        return

    wicon = icon
    try:
        root.iconbitmap(icon)
    except Exception:
        try:
            wicon = tkinter.PhotoImage(file=icon)
            root.tk.call('wm', 'iconphoto', root._w, wicon)
        except Exception as e:
            try:
                wicon = tkinter.PhotoImage(data=DEFAULT_BASE64_ICON)
                try:
                    root.tk.call('wm', 'iconphoto', root._w, wicon)
                except Exception as e:
                    print('Set icon exception', e)
                    pass
            except:
                print('Set icon exception', e)
                pass


# ==============================_GetNumLinesNeeded ==#
# Helper function for determining how to wrap text   #
# ===================================================#
def _GetNumLinesNeeded(text, max_line_width):
    if max_line_width == 0:
        return 1
    lines = text.split('\n')
    lines_used = []
    for L in lines:
        lines_used.append(len(L) // max_line_width + (len(L) % max_line_width > 0))  # fancy math to round up
    total_lines_needed = sum(lines_used)
    return total_lines_needed


# ==============================  PROGRESS METER ========================================== #


def convert_args_to_single_string(*args):
    """

    :param *args:
    :type *args:

    """
    (
        max_line_total,
        width_used,
        total_lines,
    ) = (
        0,
        0,
        0,
    )
    single_line_message = ''
    # loop through args and built a SINGLE string from them
    for message in args:
        # fancy code to check if string and convert if not is not need. Just always convert to string :-)
        # if not isinstance(message, str): message = str(message)
        message = str(message)
        longest_line_len = max([len(line) for line in message.split('\n')])
        width_used = max(longest_line_len, width_used)
        max_line_total = max(max_line_total, width_used)
        lines_needed = _GetNumLinesNeeded(message, width_used)
        total_lines += lines_needed
        single_line_message += message + '\n'
    return single_line_message, width_used, total_lines


METER_REASON_CANCELLED = 'cancelled'
METER_REASON_CLOSED = 'closed'
METER_REASON_REACHED_MAX = 'finished'
METER_OK = True
METER_STOPPED = False


class _QuickMeter:
    active_meters = {}
    exit_reasons = {}

    def __init__(
        self,
        title,
        current_value,
        max_value,
        key,
        *args,
        orientation='v',
        bar_color=(None, None),
        button_color=(None, None),
        size=DEFAULT_PROGRESS_BAR_SIZE,
        border_width=None,
        grab_anywhere=False,
        no_titlebar=False,
        keep_on_top=None,
        no_button=False,
    ):
        """

        :param title:         text to display in element
        :type title:          (str)
        :param current_value: current value
        :type current_value:  (int)
        :param max_value:     max value of progress meter
        :type max_value:      (int)
        :param key:           Used with window.find_element and with return values to uniquely identify this element
        :type key:            str | int | tuple | object
        :param *args:         stuff to output
        :type *args:          (Any)
        :param orientation:   'horizontal' or 'vertical' ('h' or 'v' work) (Default value = 'vertical' / 'v')
        :type orientation:    (str)
        :param bar_color:     The 2 colors that make up a progress bar. Either a tuple of 2 strings or a string. Tuple - (bar, background). A string with 1 color changes the background of the bar only. A string with 2 colors separated by "on" like "red on blue" specifies a red bar on a blue background.
        :type bar_color:      (str, str) or str
        :param button_color:  button color (foreground, background)
        :type button_color:   (str, str) | str
        :param size:          (w,h) w=characters-wide, h=rows-high (Default value = DEFAULT_PROGRESS_BAR_SIZE)
        :type size:           (int, int)
        :param border_width:  width of border around element
        :type border_width:   (int)
        :param grab_anywhere: If True: can grab anywhere to move the window (Default = False)
        :type grab_anywhere:  (bool)
        :param no_titlebar:   If True: window will be created without a titlebar
        :type no_titlebar:    (bool)
        :param keep_on_top:   If True the window will remain above all current windows
        :type keep_on_top:    (bool)
        :param no_button:     If True: window will be created without a cancel button
        :type no_button:      (bool)
        """
        self.start_time = datetime.datetime.utcnow()
        self.key = key
        self.orientation = orientation
        self.bar_color = bar_color
        self.size = size
        self.grab_anywhere = grab_anywhere
        self.button_color = button_color
        self.border_width = border_width
        self.no_titlebar = no_titlebar
        self.title = title
        self.current_value = current_value
        self.max_value = max_value
        self.close_reason = None
        self.keep_on_top = keep_on_top
        self.no_button = no_button
        self.window = self.BuildWindow(*args)

    def BuildWindow(self, *args):
        layout = []
        if self.orientation.lower().startswith('h'):
            col = []
            col += [[T(''.join(map(lambda x: str(x) + '\n', args)), key='-OPTMSG-')]]  # convert all *args into one string that can be updated

            col += [
                [T('', size=(30, 10), key='-STATS-')],
                [
                    ProgressBar(
                        max_value=self.max_value,
                        orientation='h',
                        key='-PROG-',
                        size=self.size,
                        bar_color=self.bar_color,
                    )
                ],
            ]
            if not self.no_button:
                col += [[Cancel(button_color=self.button_color), Stretch()]]
            layout = [Column(col)]
        else:
            col = [
                [
                    ProgressBar(
                        max_value=self.max_value,
                        orientation='v',
                        key='-PROG-',
                        size=self.size,
                        bar_color=self.bar_color,
                    )
                ]
            ]
            col2 = []

            col2 += [[T(''.join(map(lambda x: str(x) + '\n', args)), key='-OPTMSG-')]]  # convert all *args into one string that can be updated

            col2 += [[T('', size=(30, 10), key='-STATS-')]]

            if not self.no_button:
                col2 += [[Cancel(button_color=self.button_color), Stretch()]]

            layout = [Column(col), Column(col2)]
        self.window = Window(
            self.title,
            grab_anywhere=self.grab_anywhere,
            border_depth=self.border_width,
            no_titlebar=self.no_titlebar,
            disable_close=True,
            keep_on_top=self.keep_on_top,
        )
        self.window.Layout([layout]).Finalize()

        return self.window

    def UpdateMeter(self, current_value, max_value, *args):  # support for *args when updating

        self.current_value = current_value
        self.max_value = max_value
        self.window.Element('-PROG-').UpdateBar(self.current_value, self.max_value)
        self.window.Element('-STATS-').Update('\n'.join(self.ComputeProgressStats()))
        self.window.Element('-OPTMSG-').Update(value=''.join(map(lambda x: str(x) + '\n', args)))  # update the string with the args
        event, values = self.window.read(timeout=0)
        if event in ('Cancel', None) or current_value >= max_value:
            exit_reason = METER_REASON_CANCELLED if event in ('Cancel', None) else METER_REASON_REACHED_MAX if current_value >= max_value else METER_STOPPED
            self.window.close()
            del _QuickMeter.active_meters[self.key]
            _QuickMeter.exit_reasons[self.key] = exit_reason
            return _QuickMeter.exit_reasons[self.key]
        return METER_OK

    def ComputeProgressStats(self):
        utc = datetime.datetime.utcnow()
        time_delta = utc - self.start_time
        total_seconds = time_delta.total_seconds()
        if not total_seconds:
            total_seconds = 1
        try:
            time_per_item = total_seconds / self.current_value
        except:
            time_per_item = 1
        seconds_remaining = (self.max_value - self.current_value) * time_per_item
        time_remaining = str(datetime.timedelta(seconds=seconds_remaining))
        time_remaining_short = (time_remaining).split('.')[0]
        time_delta_short = str(time_delta).split('.')[0]
        total_time = time_delta + datetime.timedelta(seconds=seconds_remaining)
        total_time_short = str(total_time).split('.')[0]
        self.stat_messages = [
            f'{self.current_value} of {self.max_value}',
            f'{100 * self.current_value // self.max_value} %',
            '',
            f' {self.current_value / total_seconds:6.2f} Iterations per Second',
            f' {total_seconds / (self.current_value if self.current_value else 1):6.2f} Seconds per Iteration',
            '',
            f'{time_delta_short} Elapsed Time',
            f'{time_remaining_short} Time Remaining',
            f'{total_time_short} Estimated Total Time',
        ]
        return self.stat_messages


def one_line_progress_meter(
    title,
    current_value,
    max_value,
    *args,
    key='OK for 1 meter',
    orientation='v',
    bar_color=(None, None),
    button_color=None,
    size=DEFAULT_PROGRESS_BAR_SIZE,
    border_width=None,
    grab_anywhere=False,
    no_titlebar=False,
    keep_on_top=None,
    no_button=False,
):
    """
    :param title:         text to display in titlebar of window
    :type title:          (str)
    :param current_value: current value
    :type current_value:  (int)
    :param max_value:     max value of progress meter
    :type max_value:      (int)
    :param *args:         stuff to output as text in the window along with the meter
    :type *args:          (Any)
    :param key:           Used to differentiate between multiple meters. Used to cancel meter early. Now optional as there is a default value for single meters
    :type key:            str | int | tuple | object
    :param orientation:   'horizontal' or 'vertical' ('h' or 'v' work) (Default value = 'vertical' / 'v')
    :type orientation:    (str)
    :param bar_color:     The 2 colors that make up a progress bar. Either a tuple of 2 strings or a string. Tuple - (bar, background). A string with 1 color changes the background of the bar only. A string with 2 colors separated by "on" like "red on blue" specifies a red bar on a blue background.
    :type bar_color:      (str, str) or str
    :param button_color:  button color (foreground, background)
    :type button_color:   (str, str) | str
    :param size:          (w,h) w=characters-wide, h=rows-high (Default value = DEFAULT_PROGRESS_BAR_SIZE)
    :type size:           (int, int)
    :param border_width:  width of border around element
    :type border_width:   (int)
    :param grab_anywhere: If True: can grab anywhere to move the window (Default = False)
    :type grab_anywhere:  (bool)
    :param no_titlebar:   If True: no titlebar will be shown on the window
    :type no_titlebar:    (bool)
    :param keep_on_top:   If True the window will remain above all current windows
    :type keep_on_top:    (bool)
    :param no_button:     If True: window will be created without a cancel button
    :type no_button:      (bool)
    :return:              True if updated successfully. False if user closed the meter with the X or Cancel button
    :rtype:               (bool)
    """
    if key not in _QuickMeter.active_meters:
        meter = _QuickMeter(
            title,
            current_value,
            max_value,
            key,
            *args,
            orientation=orientation,
            bar_color=bar_color,
            button_color=button_color,
            size=size,
            border_width=border_width,
            grab_anywhere=grab_anywhere,
            no_titlebar=no_titlebar,
            keep_on_top=keep_on_top,
            no_button=no_button,
        )
        _QuickMeter.active_meters[key] = meter
        _QuickMeter.exit_reasons[key] = None

    else:
        meter = _QuickMeter.active_meters[key]

    meter.UpdateMeter(current_value, max_value, *args)  # pass the *args to UpdateMeter function

    # XXX: wtf?
    one_line_progress_meter.exit_reasons = getattr(one_line_progress_meter, 'exit_reasons', _QuickMeter.exit_reasons)
    exit_reason = one_line_progress_meter.exit_reasons.get(key)

    return METER_OK if exit_reason in (None, METER_REASON_REACHED_MAX) else METER_STOPPED


def one_line_progress_meter_cancel(key='OK for 1 meter'):
    """
    Cancels and closes a previously created One Line Progress Meter window

    :param key: Key used when meter was created
    :type key:  (Any)
    :return:    None
    :rtype:     None
    """
    try:
        meter = _QuickMeter.active_meters[key]
        meter.window.Close()
        del _QuickMeter.active_meters[key]
        _QuickMeter.exit_reasons[key] = METER_REASON_CANCELLED
    except:  # meter is already deleted
        return


def get_complimentary_hex(color):
    """
    :param color: color string, like "#RRGGBB"
    :type color:  (str)
    :return:      color string, like "#RRGGBB"
    :rtype:       (str)
    """

    # strip the # from the beginning
    color = color[1:]
    # convert the string into hex
    color = int(color, 16)
    # invert the three bytes
    # as good as substracting each of RGB component by 255(FF)
    comp_color = 0xFFFFFF ^ color
    # convert the color back to hex by prefixing a #
    comp_color = '#%06X' % comp_color
    return comp_color


# ========================  EasyPrint           =====#
# ===================================================#
class _DebugWin:
    debug_window = None

    def __init__(
        self,
        size=(None, None),
        location=(None, None),
        relative_location=(None, None),
        font=None,
        no_titlebar=False,
        no_button=False,
        grab_anywhere=False,
        keep_on_top=None,
        do_not_reroute_stdout=True,
        echo_stdout=False,
        resizable=True,
        blocking=False,
    ):
        """

        :param size:                  (w,h) w=characters-wide, h=rows-high
        :type size:                   (int, int)
        :param location:              Location of upper left corner of the window
        :type location:               (int, int)
        :param relative_location:     (x,y) location relative to the default location of the window, in pixels. Normally the window centers.  This location is relative to the location the window would be created. Note they can be negative.
        :type relative_location:      (int, int)
    