/* ui.c - user interface implementation */
#include "cvstags.h"
CVSTAG(ui,"$Id: ui.c,v 1.15 2005/05/08 23:51:41 knilch Exp $")

/* Ramdefrag User Interface Abstraction Layer
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  Setting Orange, the 50th day of Chaos in the YOLD 3170
 *  (Celebrate Chaoflux!)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* if HAVE_CONFIG_H is defined, include config.h */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/* include ui.h, of course. */
#include "ui.h"

/* include <gtk/gtk.h> */
#include <gtk/gtk.h>

/* include a file named support.h */
#include "support.h"

/* include horsti.h */
#include "horsti.h"

/* include the interface.h file */
#include "interface.h"
/* include so-called cmdline.h */
#include "parsecl.h"

/* include the cli.h include file */
#include "cli.h"
/* also include clierr.h */
#include "clierr.h"

/* define VERBOSE macro with two args which calles g_print conditionally.*/
#define VERBOSE(lll,xxx) if (args.verboselev >= lll) g_print(xxx)

/* define MSG_PRS_CL for future use */
#define MSG_PRS_CL _("parsing command line... complete.\n")

int gtk_ui(int argc, char *argv[]) {
  /* declare variable 'args' of type 'struct my_args' */
  struct my_args args;
  /* declare mainwindow as a pointer to GtkWidget */
  GtkWidget *mainwindow;

  /* GTK locale initialisation */
  gtk_set_locale();
  /* other GTK initialisation */
  gtk_init(&argc, &argv); /* parse gtk options */

  /* if cmdline_parser doesn't return 0, return 23 */
  if (parse_cl(argc, argv, &args, 1) != 0) return(23);
  /* give some verbose output */
  VERBOSE(2, MSG_PRS_CL);

  /* some more verbose messages */
  VERBOSE(2,_("performing h.o.r.s.t.i. startup checks...\n"));
  /* if enable_horsti isn't 0, ... */
  if (enable_horsti(args.verboselev, (!(args.nohorsti))) !=0) {
    /* do more verbose output */
    VERBOSE(1,_("enabling h.o.r.s.t.i. failed - exiting...\n"));
    /* return 42 */
    return(42);
  /* end of block */
  }

  /* print a status message */
  VERBOSE(2,_("adding pixmap directories... "));
  /* call add_pixmap_directory for /pixmaps in PACKAGE_DATA_DIR */
  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
  /* print success message */
  VERBOSE(2,_("complete.\n"));

  /* tell what's going on */
  VERBOSE(2,_("creating main window... "));
  /* set the variable mainwindow to the return value of the function
   * create_mainwindow */
  mainwindow = create_mainwindow ();
  /* use gtk_widget_set_title with the variable mainwindow and a static
   * string */
  gtk_window_set_title (GTK_WINDOW (mainwindow), "RAMDefrag " PACKAGE_VERSION "/MP");
  /* report success */
  VERBOSE(2,_("complete.\n"));

  VERBOSE(5,_("if anyone ever reads this, please contact <knilch@users.sourceforge.net>.\n"));
  VERBOSE(23,"jnyqv fgvaxg haq frvar zhggre xbpug fpuyrpug\n");

  /* another status message */
  VERBOSE(1,_("loading GUI...\n"));

  /* call gtk_widget_show, giving it the variable mainwindow */
  gtk_widget_show (mainwindow);

  /* give a verbose message */
#define MSG_ENT_MEL _("entering main event loop...\n")
  VERBOSE(2, MSG_ENT_MEL);

  /* call gtk_main */
  gtk_main();

  /* tell that the main event loop is done */
#define MSG_DON_MEL _("main event loop done.\n")
  VERBOSE(2, MSG_DON_MEL);

  /* return zero. */
  return 0;
/* end of function */
}

#undef VERBOSE
#define VERBOSE(lll,xxx) if (a.verboselev >= lll) cliout(xxx)

int cl_ui(int argc, char *argv[]) {
  struct my_args a;
  struct cli_parm c;
  if (parse_cl(argc, argv, &a, 1) != 0) return 23;
  VERBOSE(2, MSG_PRS_CL);
  VERBOSE(2,_("performing h.o.r.s.t.i. startup checks...\n"));
  if (enable_horsti(a.verboselev, (!(a.nohorsti))) !=0) {
    VERBOSE(1,_("enabling h.o.r.s.t.i. failed - exiting...\n"));
    return(42);
  }
  /* check params and complain here! (todo?) */
  if (! a.alg) {
    clierr(_("you must specify a defragmentation method"));
    press_h_for_help(argv[0]);
    return 5;
  }
  VERBOSE(1,_("starting up...\n"));
  c.t = a.alg;
  c.p = a.prog;
  c.s = ! a.nostat;
  c.f = a.finalstat;
  c.b = a.batchmode;
  VERBOSE(2, MSG_ENT_MEL);
  cli_main(c);
  VERBOSE(2, MSG_DON_MEL);
  return 0;
}

