# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /cvsroot/ramdefrag/ramdefrag/contrib/ramdefrag-0.3.2.ebuild,v 1.1 2005/10/09 15:16:58 knilch Exp $

inherit eutils

DESCRIPTION="Multi Platform RAM Defragmentation"
HOMEPAGE="http://ramdefrag.sourceforge.net/"
SRC_URI="mirror://sourceforge/ramdefrag/${PN}_${PV}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~x86 ~amd64"
IUSE="nls"

DEPEND="virtual/libc
	>=x11-libs/gtk+-1.2
	nls? ( sys-devel/gettext )"

S="${WORKDIR}/${PN}"

src_compile() {
	myconf=$(use_enable nls)

	econf $myconf || die "configure failed"
	emake || die "emake failed"
}

src_install() {
	make DESTDIR="${D}" install \
		|| die "make install failed"

	dodoc AUTHORS COPYING ChangeLog ChangeLog.OLD NEWS THANKS TODO \
		|| die "dodoc failed"
	prepall
}
