/* callbacks.c - gtk callbacks */
#include "cvstags.h"
CVSTAG(callbacks,
       "$Id: callbacks.c,v 1.15 2005/05/08 23:48:44 knilch Exp $")

/* GTK Callback Functions for Ramdefrag
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gtk/gtk.h>
#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "msgs.h"
#include "dstates.h"
#include "timings.h"

gint h = 0;
gchar *oldp = "";
gchar *newp = ""; /* so g_strcasecmp doesn't complain */

static gint
myfunction(gpointer data)
{
	GtkWidget *summarywindow;
	GtkLabel *label;
	GtkProgressBar *progress;
	GtkTextView *textbox;
	GtkTextBuffer *tb;
	gchar stxt[STAT_MAX];
	gchar *x;

	label = GTK_LABEL(lookup_widget(GTK_WIDGET(data), "lblstat"));
	progress = GTK_PROGRESS_BAR(lookup_widget(GTK_WIDGET(data),
				"progressbar"));

	oldp = newp;
	newp = getphase(h);
	if (!g_strcasecmp(oldp, newp)) {
		gtk_label_set_text(label, newp);
	}

	/* ich hab ein panzerwagen in mein lederhosen */
	x = g_strdup_printf("%d %%", h);
	gtk_progress_bar_set_text(progress, x);
	g_free(x);
	gtk_progress_bar_set_fraction(progress, ((gdouble) (h++) / 100.0));

	if (h > 100) {
		g_print(ST_DEFRAG_DONE);
		summarywindow = create_summarywindow();

		textbox = GTK_TEXT_VIEW(lookup_widget(summarywindow,
					"textbox"));
		tb = gtk_text_view_get_buffer(textbox);
		gtk_text_buffer_set_text(tb, getstatus(h, stxt, 0), -1);
		gtk_widget_show(summarywindow);
		gtk_widget_destroy(GTK_WIDGET(data));
		return FALSE;
	}
	return TRUE;
}


void
on_startbtn_clicked(GtkButton * button, gpointer data)
{
	GtkWidget *defragwindow;
	GtkRadioButton *rbutton;
	gint bla;
	defragwindow = create_defragwindow();
	gtk_widget_show(defragwindow);

	rbutton = GTK_RADIO_BUTTON(lookup_widget(data, "rbdeep"));

	bla = TM_STD_ALG;

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rbutton))) {
		bla = TM_DEEP_ALG;
	} else {
		rbutton = (GtkRadioButton *) lookup_widget(data, "rbopt");
		if (gtk_toggle_button_get_active
		    (GTK_TOGGLE_BUTTON(rbutton))) {
			bla = TM_OPT_ALG;
		}
	}
	bla = gtk_timeout_add(bla, myfunction, defragwindow);
	gtk_widget_destroy(GTK_WIDGET(data));
}


void
on_cancelbtn_clicked(GtkButton * b, gpointer data)
{
	g_print(ST_DEFRAG_ABORTED);
	gtk_main_quit();
}


void
on_okbutton_clicked(GtkButton * b, gpointer data)
{
	g_print(ST_PROGRAM_QUIT);
	gtk_main_quit();
}

