/* horsti.c - H.O.R.S.T.I. implementation */
#include "cvstags.h"
CVSTAG(horsti,"$Id: horsti.c,v 1.9 2005/05/24 21:37:07 knilch Exp $")

/* H.O.R.S.T.I. - Hybrid Operating Random System Transition Interface
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  Sweetmorn, the 11th day of Chaos in the YOLD 3170
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <unistd.h> /* get[e]uid() */
#include <stdio.h> /* [f]printf(), stderr */

#include "horsti.h"

#include "support.h"  /* for gettext-macros _() etc */

#define VERBOSE(lll,xxx) if (msglev >= lll) printf(xxx)

/* maybe calling usleep() or nanosleep() a few times in these lines would be
 * awesome... sometimes... */

int
enable_horsti(int msglev, int enable)
{
	if (geteuid()) {
		if (enable) {
			printf(_("No superuser privileges - enabling "
				"H.O.R.S.T. interface.\n"));
			VERBOSE(2,_("H.O.R.S.T.I. initialisation...\n"));
			VERBOSE(2,_("H.O.R.S.T.I. start-up...\n"));
			VERBOSE(1,_("H.O.R.S.T.I. up and running...\n"));
			VERBOSE(2,_("H.O.R.S.T.I. runtime checks... ok.\n"));
		} else {
			fprintf(stderr, _("No superuser privileges, and "
					"H.O.R.S.T.I. disabled!\n"
					"RAM defragmentation impossible, "
					"aborting!\n"));
			return(42);
		}
	} else {
		VERBOSE(1,_("running this program as root, eh? hope you know "
				"what you're doing...\n"));
		VERBOSE(1,_("NOT enabling H.O.R.S.T.I. - already sufficient "
				"privileges\n"));
	}
	return(0);
}

void disable_horsti(int msglev, int enabled) {
	if ((geteuid()) && (enabled)) {
		VERBOSE(1,_("H.O.R.S.T.I. shutdown in progress...\n"));
	} else {
		VERBOSE(1,_("H.O.R.S.T.I. not enabled\n"));
	}
}
#undef VERBOSE

