/*
 * ramdefrag (c) 2003, 2004, 2005 knilch/todeswaldi.
 *
 * get newest version at http://sourceforge.net/projects/ramdefrag
 */

/*  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program (try the file named 'COPYING' in the top
 *  directory); if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.
 */

#ifndef lint /* freebsd does it, so do we: */
static const char copyright[] =
    "@(#) Copyright (c) 2003, 2004, 2005 knilch/todeswaldi.\n"
    "This is FREE SOFTWARE under the terms of the GNU GPL.\n";
static const char cvsid[] =
    "@(#) $Id: main.c,v 1.24 2005/07/22 09:51:08 knilch Exp $ ";
#endif /* not lint */


/* if HAVE_CONFIG_H is defined, include config.h */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>

/* if HAVE_STDLIB_H is defined, include stdlib.h */
#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

/* include a file named support.h */
#include "support.h"
/* include horsti header */
#include "horsti.h"

/* include ui.h */
#include "ui.h"
/* and also parsecl.h */
#include "parsecl.h"

/* define VERBOSE macro with two args to something with if and printf.*/
#define VERBOSE(lll,xxx) if (opt.verboselev >= lll) printf(xxx)

/* main function, uses argc and argv, returns int */
int
main(int argc, char *argv[])
{
	/* declare variable 'opt' of type 'my_args' */
	struct my_args opt;
	/* declare 'i' as an integer with a value of 25 */
	int i = 25;

/* if lint is not defined */
#ifndef lint
	/* declare a char pointer named x and do something with it. */
	const char *x;
	x = copyright;
	x = cvsid; /* not in the spirit of freebsd, but who cares? */
/* end of block */
#endif

/* if ENABLE_NLS is defined */
#ifdef ENABLE_NLS
	/* call setlocale with LC_ALL and an empty string */
	setlocale(LC_ALL, "");
	/* call bindtextdomain with GETTEXT_PACKAGE and PACKAGE_LOCALE_DIR */
	bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	/* call bind_textdomain_codeset now */
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	/* call textdomain, giving it GETTEXT_PACKAGE */
	textdomain(GETTEXT_PACKAGE);
/* end of block */
#endif

	/* call 'parse_cl' with argc, argv, the address of opt, and zero */
	parse_cl(argc, argv, &opt, 0);

	/* switch depending on the value of opt.ui */
	switch (opt.ui) {
		/* case its USE_GTK_UI */
	case USE_GTK_UI:
		/* give i the return value of gtk_ui */
		i = gtk_ui(argc, argv);
		/* break */
		break;
		/* case its USE_CL_UI */
	case USE_CL_UI:
		/* give i the return value of cl_ui */
		i = cl_ui(argc, argv);
		/* break out! */
		break;
		/* default */
	default:
		/* print out an error message */
		fprintf(stderr, _("FATAL ERROR: could not determine "
					"user interface!"));
		/* break, will ya?! */
		break;
		/* end of block */
	}

	/* print another verbose message */
	VERBOSE(2, _("starting h.o.r.s.t.i. shutdown...\n"));
	/* call disable_horsti */
	disable_horsti(opt.verboselev, (!(opt.nohorsti)));
	/* yet another status message */
	VERBOSE(1, _("h.o.r.s.t.i. shutdown complete.\n"));

	/* return 12 */
	return i;
/* end of block */
}

