/* parsecl.h - header file for command line parser
 * $Id: parsecl.h,v 1.10 2005/05/08 23:51:41 knilch Exp $ */

/* Ramdefrag Command Line Parser
 *  (c) 2004, 2005 Tobias 'knilch' Jordan <knilch@users.sourceforge.net>
 *
 *  Setting Orange, the 50th day of Chaos in the YOLD 3170
 *  (Celebrate Chaoflux!)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* if somethin in this file looks familiar: yes, it was
 * at first generated via gengetopts.
 */

#ifndef PARSECL_H
#define PARSECL_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

/*
 *                         = ZARATHUD'S ENLIGHTENMENT =
 *
 * Before he became a hermit, Zarathud was a young Priest, and took great
 * delight in making fools of his opponents in front of his followers.
 *
 * One day Zarathud took his students to a pleasant pasture and there he
 * confronted The Sacred Chao while She was contentedly grazing.
 *
 * "Tell me, you dumb beast." demanded the Priest in his commanding voice,
 * "why don't you do something worthwhile. What is your Purpose in Life,
 * anyway?"
 *
 * Munching the tasty grass, The Sacred Chao replied "MU".*
 *
 * Upon hearing this, absolutely nobody was enlightened. Primarily because
 * nobody could understand Chinese.
 *
 * "MU" is the Chinese ideogram for NO-THING
 *
 */

#define USE_GTK_UI 23
#define USE_CL_UI 42

struct my_args {
  int nohorsti;
  int dry_run;
  int verboselev;
  int gtk;
  int cli;
  int prog;
  int nostat;
  int ui;
  int finalstat;
  int batchmode;
  char alg;
} ;

/*
 * "Grasshopper always wrong in argument with chicken"
 *                                    -Book of Chan compiled by O.P.U. sect
 */

int parse_cl(int argc, char * const *argv, struct my_args *args_info, int err);

void usage(char * argz);
void version(void);

#endif /* PARSECL_H */
