/*
 * windows.h
 * written by Brian Derr
 * 2002-09-19
 *
 * declarations for a ncurses based user interface to the braincurses game
 * written by Brian Derr
 */

#ifndef WINDOWS_H
  #define WINDOWS_H

#include <cstring>

#include <ncurses.h>
#include <term.h>

#include "../braincurses.h"

const int INPUT_LENGTH = 7;

struct Winders {
   WINDOW *top_left;
   WINDOW *top_right;
   WINDOW *left;
   WINDOW *middle;
   WINDOW *right;
   WINDOW *bottom;
};

WINDOW *create_newwin( int height, int width, int starty, int startx );
void destroy_win( WINDOW *local_win );

void cleanUpWindow( WINDOW *local_win );
bool getInput( Guess &g, int x, Winders winders );
void wrongInput( WINDOW *local_win, Guess &g, int inner );
void dispGuesses( WINDOW *local_win, const Guess &g, int guess_arr[],
                  int outer );
void dispMarkers( WINDOW *local_win, int marker_arr[], int outer );
bool isWinner( int marker_arr[] );
void youWin( WINDOW *local_win );
void youLose( WINDOW *local_win );
void dispAnswers( WINDOW *local_win, Answer ans );
bool playAgain( WINDOW *local_win );
void closeCurses( Winders winders );
void printTopScores( WINDOW *local_win );

extern void getScores( int scoreNum, char *name, int &score );
extern int writeScores( int turns );

#endif  /* WINDOWS_H */
