/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Bulgarian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-17 18:16:58.794613
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Windows_1251_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 25, 44, 36, 42, 29, 48, 46, 43, 28, 54, 47, 37, 38, 33, 30, /* 4X */
   41, 55, 32, 34, 35, 39, 49, 50, 51, 45, 53,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 25, 44, 36, 42, 29, 48, 46, 43, 28, 54, 47, 37, 38, 33, 30, /* 6X */
   41, 55, 32, 34, 35, 39, 49, 50, 51, 45, 53,SYM,SYM,SYM,SYM,CTR, /* 7X */
   59, 60,SYM, 61,SYM,SYM,SYM,SYM,SYM,SYM, 62,SYM, 63, 64, 65, 66, /* 8X */
   67,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 68,SYM, 69, 70, 71, 72, /* 9X */
  SYM, 73, 74, 75,SYM, 76,SYM,SYM, 77,SYM, 78,SYM,SYM,SYM,SYM, 79, /* AX */
  SYM,SYM, 57, 57, 80,SYM,SYM,SYM, 81,SYM, 82,SYM, 83, 84, 85, 86, /* BX */
    0, 20,  8, 17, 11,  3, 21, 13,  1, 24, 10,  9, 14,  5,  2, 12, /* CX */
    6,  7,  4, 19, 26, 23, 22, 18, 31, 27, 16, 56, 52, 58, 40, 15, /* DX */
    0, 20,  8, 17, 11,  3, 21, 13,  1, 24, 10,  9, 14,  5,  2, 12, /* EX */
    6,  7,  4, 19, 26, 23, 22, 18, 31, 27, 16, 56, 52, 58, 40, 15, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_5_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 25, 44, 36, 42, 29, 48, 46, 43, 28, 54, 47, 37, 38, 33, 30, /* 4X */
   41, 55, 32, 34, 35, 39, 49, 50, 51, 45, 53,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 25, 44, 36, 42, 29, 48, 46, 43, 28, 54, 47, 37, 38, 33, 30, /* 6X */
   41, 55, 32, 34, 35, 39, 49, 50, 51, 45, 53,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 87, 88, 89, 90, 91, 57, 92, 93, 94, 95, 96, 97,SYM, 98, 99, /* AX */
    0, 20,  8, 17, 11,  3, 21, 13,  1, 24, 10,  9, 14,  5,  2, 12, /* BX */
    6,  7,  4, 19, 26, 23, 22, 18, 31, 27, 16, 56, 52, 58, 40, 15, /* CX */
    0, 20,  8, 17, 11,  3, 21, 13,  1, 24, 10,  9, 14,  5,  2, 12, /* DX */
    6,  7,  4, 19, 26, 23, 22, 18, 31, 27, 16, 56, 52, 58, 40, 15, /* EX */
  SYM,100,101,102,103,104, 57,105,106,107,108,109,110,SYM,111,112, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 106;
static const unsigned int Unicode_CharOrder[] =
{
    65, 25,   66, 44,   67, 36,   68, 42,   69, 29,   70, 48,   71, 46,  72, 43,
    73, 28,   75, 47,   76, 37,   77, 38,   78, 33,   79, 30,   80, 41,  82, 32,
    83, 34,   84, 35,   85, 39,   86, 49,   87, 50,   88, 51,   89, 45,  97, 25,
    98, 44,   99, 36,  100, 42,  101, 29,  102, 48,  103, 46,  104, 43, 105, 28,
   107, 47,  108, 37,  109, 38,  110, 33,  111, 30,  112, 41,  114, 32, 115, 34,
   116, 35,  117, 39,  118, 49,  119, 50,  120, 51,  121, 45, 1040,  0,1041, 20,
  1042,  8, 1043, 17, 1044, 11, 1045,  3, 1046, 21, 1047, 13, 1048,  1,1049, 24,
  1050, 10, 1051,  9, 1052, 14, 1053,  5, 1054,  2, 1055, 12, 1056,  6,1057,  7,
  1058,  4, 1059, 19, 1060, 26, 1061, 23, 1062, 22, 1063, 18, 1064, 31,1065, 27,
  1066, 16, 1068, 52, 1070, 40, 1071, 15, 1072,  0, 1073, 20, 1074,  8,1075, 17,
  1076, 11, 1077,  3, 1078, 21, 1079, 13, 1080,  1, 1081, 24, 1082, 10,1083,  9,
  1084, 14, 1085,  5, 1086,  2, 1087, 12, 1088,  6, 1089,  7, 1090,  4,1091, 19,
  1092, 26, 1093, 23, 1094, 22, 1095, 18, 1096, 31, 1097, 27, 1098, 16,1100, 52,
  1102, 40, 1103, 15,
};


/* Model Table:
 * Total considered sequences: 1236 / 2809
 * - Positive sequences: first 720 (0.9950164618425456)
 * - Probable sequences: next 201 (921-720) (0.003986830525963603)
 * - Neutral sequences: last 1888 (0.0009967076314908452)
 * - Negative sequences: 1573 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 BulgarianLangModel[] =
{
  1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,0,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,1,
   3,3,0,0,0,3,0,0,0,0,1,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,0,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,0,
   3,3,1,0,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,0,1,2,0,1,
   2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,2,3,3,3,3,3,2,3,2,3,3,3,3,3,2,2,3,3,1,0,
   3,1,0,0,0,3,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,3,
  3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,
   3,0,0,1,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,1,3,1,3,3,3,2,3,3,3,0,2,3,0,0,
   3,0,0,0,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,0,1,3,1,0,0,
   1,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,1,3,3,1,3,3,2,3,3,3,3,3,3,3,3,3,3,2,0,0,
   3,0,0,0,0,2,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,3,
  3,3,3,3,3,3,3,3,3,3,2,1,1,3,3,1,3,2,2,3,0,0,3,1,0,0,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,3,2,3,0,0,
   1,0,0,0,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,1,1,0,1,3,3,0,3,3,1,0,2,2,0,0,
   0,0,0,0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,1,3,3,0,0,
   2,0,0,0,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,2,3,3,3,3,3,3,1,3,1,1,3,3,2,2,3,3,1,2,1,0,0,
   2,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2,
  1,1,1,2,3,3,3,3,3,3,3,3,3,3,3,2,0,3,3,1,3,1,2,3,3,1,
   0,3,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,0,3,3,3,3,3,0,
   2,3,0,0,0,2,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,3,1,3,3,1,2,0,0,3,1,3,0,1,3,1,0,0,0,1,0,
   0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,0,3,3,3,0,0,0,0,0,2,0,0,3,0,2,0,3,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,1,3,3,3,3,2,0,
   1,3,0,0,0,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,3,3,3,3,2,2,2,1,3,3,3,1,2,3,0,0,2,3,0,0,
   0,3,0,0,0,2,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,1,0,3,3,3,3,0,0,1,0,3,0,0,3,3,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,2,3,1,1,1,0,3,0,3,0,1,2,0,3,3,0,0,2,0,0,0,1,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,1,3,3,2,0,0,0,1,1,3,0,1,3,0,0,0,2,0,0,
   0,1,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,
  1,0,3,3,3,3,2,3,3,3,3,3,1,2,2,0,2,2,3,0,3,0,3,1,0,0,
   1,0,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
   0,0,3,3,2,0,3,3,3,3,3,3,3,3,0,3,3,1,2,3,3,1,2,2,2,2,0,
  3,3,3,3,3,2,3,3,0,3,1,0,0,0,0,3,2,1,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,2,0,1,0,0,0,0,0,0,3,1,0,0,3,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,3,3,3,3,3,3,3,3,0,3,3,1,2,1,3,2,3,3,1,2,0,
  0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,3,
   0,0,3,2,3,0,3,3,3,3,3,3,3,3,0,3,3,1,2,2,3,2,1,3,2,3,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,2,3,0,3,3,3,3,3,3,3,3,0,3,3,2,3,1,3,2,3,2,2,2,0,
  3,3,3,3,0,3,2,0,3,3,3,0,1,0,1,0,2,0,2,2,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,2,3,3,3,3,3,3,3,0,3,3,2,2,3,3,2,2,3,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,1,3,3,3,3,1,1,3,0,1,3,2,2,3,3,2,2,2,0,2,0,
  0,1,1,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,3,
   0,0,3,3,3,0,1,2,3,3,3,1,2,3,0,3,1,3,3,2,0,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,3,1,3,2,2,1,1,3,0,0,1,3,1,3,0,1,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,3,3,2,3,2,3,3,3,0,1,2,3,2,2,1,3,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,1,1,2,2,3,3,2,3,0,2,3,1,2,3,2,1,0,2,1,0,0,
  0,0,0,0,0,0,0,1,1,0,0,0,1,0,1,1,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,1,2,2,1,1,1,3,3,0,3,0,1,3,3,2,0,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,1,0,3,3,3,3,3,3,3,1,0,2,2,0,2,1,2,2,2,2,0,2,0,
  1,2,0,0,3,3,3,3,2,3,2,3,2,3,2,0,0,3,3,0,2,3,3,1,2,0,
   1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,3,1,2,3,0,3,2,3,0,2,2,3,1,2,1,1,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,2,1,2,2,1,2,1,3,0,0,2,1,1,2,1,1,2,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,2,2,1,2,2,2,1,2,0,1,1,0,1,3,1,1,1,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,3,3,1,0,3,3,1,2,0,1,1,1,3,2,0,0,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
   0,0,2,1,3,0,2,3,3,3,3,3,1,1,0,2,2,1,3,1,2,0,0,0,0,3,0,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,3,3,1,1,1,2,1,3,0,1,2,2,0,2,2,1,1,0,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,2,2,0,2,1,2,1,1,1,3,1,0,0,0,1,0,1,3,0,1,0,1,0,0,
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
   0,0,3,3,3,0,3,0,0,1,1,2,0,3,0,0,1,0,0,0,0,0,2,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,3,3,3,0,0,0,0,0,0,1,0,2,0,0,1,1,0,1,0,1,0,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   0,0,2,3,2,0,0,1,1,0,0,1,0,0,0,1,0,1,0,0,0,0,1,0,2,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
   0,0,2,1,2,0,0,0,0,2,1,1,1,2,0,1,0,0,0,1,0,0,1,2,0,2,0,
  0,1,3,0,0,1,0,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Windows_1251BulgarianModel =
{
  Windows_1251_CharToOrderMap,
  BulgarianLangModel,
  53,
  (float)0.9990032923685092,
  PR_FALSE,
  "WINDOWS-1251",
  "bg"
};

const SequenceModel Iso_8859_5BulgarianModel =
{
  Iso_8859_5_CharToOrderMap,
  BulgarianLangModel,
  53,
  (float)0.9990032923685092,
  PR_FALSE,
  "ISO-8859-5",
  "bg"
};

const LanguageModel BulgarianModel =
{
  "bg",
  Unicode_CharOrder,
  106,
  BulgarianLangModel,
  53,
  5,
  (float)0.4581931350621217,
  29,
  (float)0.03226223199877268,
};
