/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Czech *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-14 20:34:20.075982
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_2_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 22, 16, 13,  1, 32, 30, 17,  5, 20,  9, 10, 15,  3,  0, /* 4X */
   12, 40,  8,  6,  4, 11,  7, 35, 34, 21, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 22, 16, 13,  1, 32, 30, 17,  5, 20,  9, 10, 15,  3,  0, /* 6X */
   12, 40,  8,  6,  4, 11,  7, 35, 34, 21, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 70,SYM, 48,SYM, 54, 51,SYM,SYM, 29, 71, 37, 72,SYM, 28, 66, /* AX */
  SYM, 70,SYM, 48,SYM, 54, 51,SYM,SYM, 29, 71, 37, 73,SYM, 28, 66, /* BX */
   74, 19, 62, 61, 43, 75, 49, 45, 26, 24, 60, 63, 23, 14, 58, 39, /* CX */
   76, 50, 36, 38, 47, 64, 42,SYM, 25, 31, 33, 68, 41, 27, 77, 56, /* DX */
   78, 19, 62, 61, 43, 79, 49, 45, 26, 24, 60, 63, 23, 14, 58, 39, /* EX */
   80, 50, 36, 38, 47, 64, 42,SYM, 25, 31, 33, 68, 41, 27, 81,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1250_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 22, 16, 13,  1, 32, 30, 17,  5, 20,  9, 10, 15,  3,  0, /* 4X */
   12, 40,  8,  6,  4, 11,  7, 35, 34, 21, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 22, 16, 13,  1, 32, 30, 17,  5, 20,  9, 10, 15,  3,  0, /* 6X */
   12, 40,  8,  6,  4, 11,  7, 35, 34, 21, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,ILL,SYM,SYM,SYM,SYM,ILL,SYM, 29,SYM, 51, 37, 28, 82, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 29,SYM, 51, 37, 28, 83, /* 9X */
  SYM,SYM,SYM, 48,SYM, 70,SYM,SYM,SYM,SYM, 71,SYM,SYM,SYM,SYM, 66, /* AX */
  SYM,SYM,SYM, 48,SYM,SYM,SYM,SYM,SYM, 70, 71,SYM, 54,SYM, 54, 66, /* BX */
   84, 19, 62, 61, 43, 85, 49, 45, 26, 24, 60, 63, 23, 14, 58, 39, /* CX */
   86, 50, 36, 38, 47, 64, 42,SYM, 25, 31, 33, 68, 41, 27, 87, 56, /* DX */
   88, 19, 62, 61, 43, 89, 49, 45, 26, 24, 60, 63, 23, 14, 58, 39, /* EX */
   90, 50, 36, 38, 47, 64, 42,SYM, 25, 31, 33, 68, 41, 27, 91,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Ibm852_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 22, 16, 13,  1, 32, 30, 17,  5, 20,  9, 10, 15,  3,  0, /* 4X */
   12, 40,  8,  6,  4, 11,  7, 35, 34, 21, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 22, 16, 13,  1, 32, 30, 17,  5, 20,  9, 10, 15,  3,  0, /* 6X */
   12, 40,  8,  6,  4, 11,  7, 35, 34, 21, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
   45, 41, 24, 62, 43, 31, 49, 45, 48, 63, 64, 64, 58, 92, 43, 49, /* 8X */
   24, 93, 94, 47, 42, 54, 54, 51, 51, 42, 41, 37, 37, 48,SYM, 26, /* 9X */
   19, 14, 38, 33, 70, 70, 28, 28, 60, 60,SYM, 95, 26, 71,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 19, 62, 23, 71,SYM,SYM,SYM,SYM, 66, 66,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM, 61, 61,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
   96, 97, 39, 63, 39, 36, 14, 58, 23,SYM,SYM,SYM,SYM, 98, 31,SYM, /* DX */
   38, 56, 47, 50, 50, 36, 29, 29, 99, 33,100, 68, 27, 27,101,SYM, /* EX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 68, 25, 25,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Mac_Centraleurope_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 22, 16, 13,  1, 32, 30, 17,  5, 20,  9, 10, 15,  3,  0, /* 4X */
   12, 40,  8,  6,  4, 11,  7, 35, 34, 21, 18,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 22, 16, 13,  1, 32, 30, 17,  5, 20,  9, 10, 15,  3,  0, /* 6X */
   12, 40,  8,  6,  4, 11,  7, 35, 34, 21, 18,SYM,SYM,SYM,SYM,CTR, /* 7X */
   43, 44, 44, 24, 70, 42, 41, 19, 70, 26, 43, 26, 49, 49, 24,102, /* 8X */
  103, 39, 14, 39, 46, 46, 65, 38, 65, 47, 42, 59, 33, 23, 23, 41, /* 9X */
  SYM,SYM, 60,SYM,SYM,SYM,SYM, 56,SYM,SYM,SYM, 60,SYM,SYM,104,105, /* AX */
  106, 52,SYM,SYM, 52, 67,SYM,SYM, 48, 55, 55, 54, 54,107,108, 53, /* BX */
   53, 50,SYM,SYM, 50, 36,SYM,SYM,SYM,SYM,SYM, 36, 64, 59, 64, 57, /* CX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 57,109,110, 25,SYM,SYM, 25,111, /* DX */
  112, 29,SYM,SYM, 29, 51, 51, 19, 37, 37, 14, 28, 28, 69, 38, 47, /* EX */
   69, 31, 33, 31, 68, 68,113,114, 27, 27, 67, 66, 48, 66,115,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 82;
static const unsigned int Unicode_CharOrder[] =
{
   65,  2,  66, 22,  67, 16,  68, 13,  69,  1,  70, 32,  71, 30, 72, 17,
   73,  5,  74, 20,  75,  9,  76, 10,  77, 15,  78,  3,  79,  0, 80, 12,
   81, 40,  82,  8,  83,  6,  84,  4,  85, 11,  86,  7,  87, 35, 88, 34,
   89, 21,  90, 18,  97,  2,  98, 22,  99, 16, 100, 13, 101,  1,102, 32,
  103, 30, 104, 17, 105,  5, 106, 20, 107,  9, 108, 10, 109, 15,110,  3,
  111,  0, 112, 12, 113, 40, 114,  8, 115,  6, 116,  4, 117, 11,118,  7,
  119, 35, 120, 34, 121, 21, 122, 18, 193, 19, 201, 24, 205, 14,211, 38,
  218, 33, 221, 27, 225, 19, 233, 24, 237, 14, 243, 38, 250, 33,253, 27,
  268, 26, 269, 26, 270, 39, 271, 39, 282, 23, 283, 23, 327, 36,328, 36,
  344, 25, 345, 25, 352, 29, 353, 29, 356, 37, 357, 37, 366, 31,367, 31,
  381, 28, 382, 28,
};


/* Model Table:
 * Total considered sequences: 1372 / 1681
 * - Positive sequences: first 749 (0.995023909981167)
 * - Probable sequences: next 205 (954-749) (0.003983584242635896)
 * - Neutral sequences: last 727 (0.000992505776197139)
 * - Negative sequences: 309 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 CzechLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,1,
   3,3,3,0,1,3,3,0,3,3,3,0,3,1,3,3,2,2,0,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,
   3,3,3,0,0,3,3,0,3,3,3,0,3,2,3,3,3,1,1,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,1,
   3,3,3,0,0,3,3,0,3,3,3,0,3,2,3,3,3,2,1,3,1,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,3,3,
   2,3,3,3,3,0,3,3,3,3,3,3,3,1,2,2,0,0,2,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   3,3,3,3,3,3,2,3,0,3,2,3,2,1,1,2,2,0,3,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
   3,1,3,0,3,3,3,0,3,3,3,1,3,1,3,1,2,1,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,
   2,3,3,0,3,0,3,2,0,1,2,3,3,3,0,2,2,3,1,0,2,
  3,3,3,3,2,3,3,2,3,3,3,3,2,3,3,1,3,3,3,3,
   2,3,3,3,3,3,3,3,3,3,1,3,0,0,0,1,3,0,1,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,
   1,3,3,0,3,0,3,3,3,3,3,3,3,1,2,2,2,1,2,0,1,
  3,3,3,3,3,3,3,3,3,2,3,3,1,3,1,3,3,2,2,3,
   2,3,2,0,3,3,3,3,2,1,1,3,2,2,0,1,1,0,3,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,
   2,3,3,0,3,0,2,3,2,3,3,3,3,1,0,1,3,0,2,0,1,
  3,3,3,3,3,3,3,3,3,3,3,1,3,3,1,3,3,3,3,3,
   3,2,3,0,1,3,3,0,3,3,3,0,2,1,2,1,3,2,1,2,2,
  3,3,3,3,3,3,3,1,3,3,3,3,3,2,3,2,3,3,1,3,
   2,3,1,3,3,3,2,1,0,3,1,3,1,1,1,0,2,1,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,
   2,3,3,3,3,3,3,3,3,2,2,3,2,1,1,2,2,0,2,0,1,
  1,0,1,3,3,0,3,3,3,3,3,0,3,3,0,3,3,3,3,0,
   3,0,3,0,0,3,3,0,3,3,1,0,1,0,0,0,1,2,0,0,1,
  3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,3,3,1,1,3,
   2,3,3,3,3,2,2,3,3,2,2,3,2,1,1,0,0,0,1,0,0,
  3,3,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,3,3,2,
   1,3,1,0,3,0,1,0,0,0,1,3,1,1,1,1,1,0,1,0,2,
  3,3,3,3,3,3,2,3,3,2,3,3,2,3,1,3,2,1,1,3,
   1,3,2,0,3,3,2,3,3,1,1,3,1,1,0,2,1,1,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,
   3,3,3,0,2,3,2,3,0,3,1,3,1,2,0,2,2,0,2,0,0,
  1,0,0,3,3,1,3,3,3,3,3,0,3,3,0,3,3,3,3,0,
   3,0,3,0,0,3,3,0,3,3,2,0,1,0,0,0,3,1,0,1,0,
  3,3,3,3,2,3,3,3,2,3,3,3,3,3,3,3,2,2,3,3,
   1,0,2,0,1,1,3,0,2,3,1,3,1,2,0,1,2,0,2,0,0,
  3,3,2,3,3,2,3,3,3,3,3,3,3,3,0,3,3,3,3,2,
   3,0,3,0,0,3,3,0,3,3,2,1,2,1,0,2,1,2,1,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,2,3,2,2,3,
   3,3,2,3,2,3,3,3,1,2,0,3,1,1,0,1,1,0,2,0,0,
  1,0,0,3,3,1,3,3,3,3,3,0,3,3,0,3,3,3,3,0,
   3,0,1,0,0,3,3,0,3,3,0,0,0,0,0,0,2,2,0,2,0,
  1,1,1,3,3,1,3,3,3,3,3,1,2,3,0,3,2,3,3,0,
   0,0,2,0,0,2,3,0,3,1,1,0,1,0,1,0,0,0,0,0,1,
  3,3,3,3,2,3,3,0,0,3,1,3,1,0,3,2,1,1,0,3,
   0,0,2,0,0,1,1,0,0,1,0,3,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,1,3,3,3,3,1,0,3,2,2,0,0,3,
   1,0,3,0,0,0,1,0,0,0,0,2,0,0,0,0,1,0,1,0,0,
  0,0,0,2,3,0,3,3,3,3,2,2,2,3,0,3,3,3,3,0,
   3,0,3,0,0,2,2,0,2,3,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,3,1,2,3,3,3,0,3,3,1,2,1,0,3,
   0,0,3,0,1,0,0,0,0,3,0,2,0,1,0,0,3,0,1,2,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,0,3,2,2,0,1,2,
   1,0,0,0,1,0,1,0,0,3,0,1,0,1,0,0,0,3,2,0,0,
  3,3,3,3,3,3,2,2,3,1,3,3,1,2,1,3,1,3,1,3,
   1,3,1,0,1,1,0,0,0,0,3,2,1,1,0,1,0,0,1,0,0,
  0,1,0,2,2,0,3,3,3,2,3,0,1,3,0,3,2,3,3,0,
   3,0,3,0,0,1,3,0,3,1,0,0,1,0,0,0,1,0,0,0,0,
  3,3,3,1,2,3,2,1,3,2,3,3,1,1,2,2,1,1,0,3,
   1,3,1,1,3,0,0,2,0,1,2,1,3,2,0,0,0,0,2,0,0,
  1,0,0,3,3,0,3,2,3,3,2,0,3,3,0,3,2,2,3,0,
   1,0,2,0,0,3,3,0,2,1,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,2,3,3,1,1,0,1,1,3,3,0,1,2,2,1,0,1,
   0,3,0,0,0,0,0,0,0,0,0,1,1,0,1,0,0,0,0,0,0,
  3,3,3,2,1,3,2,0,2,0,2,2,1,1,1,1,1,2,0,0,
   0,2,1,1,0,0,0,0,0,0,1,1,1,0,0,3,0,0,0,0,0,
  3,0,2,0,0,0,2,0,0,3,0,3,0,0,0,0,1,1,0,1,
   0,0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,
  2,0,3,0,1,1,0,0,0,1,0,2,0,0,0,0,1,0,0,2,
   1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  1,0,1,3,2,1,1,1,2,2,2,0,0,3,0,2,1,1,3,0,
   1,0,1,0,0,1,1,0,1,1,2,1,0,0,0,1,0,0,0,0,0,
  2,0,3,0,1,0,0,0,0,1,0,1,0,0,0,1,1,0,0,1,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,0,1,0,1,0,0,3,1,0,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_2CzechModel =
{
  Iso_8859_2_CharToOrderMap,
  CzechLangModel,
  41,
  (float)0.9990074942238029,
  PR_TRUE,
  "ISO-8859-2",
  "cs"
};

const SequenceModel Windows_1250CzechModel =
{
  Windows_1250_CharToOrderMap,
  CzechLangModel,
  41,
  (float)0.9990074942238029,
  PR_TRUE,
  "WINDOWS-1250",
  "cs"
};

const SequenceModel Ibm852CzechModel =
{
  Ibm852_CharToOrderMap,
  CzechLangModel,
  41,
  (float)0.9990074942238029,
  PR_TRUE,
  "IBM852",
  "cs"
};

const SequenceModel Mac_CentraleuropeCzechModel =
{
  Mac_Centraleurope_CharToOrderMap,
  CzechLangModel,
  41,
  (float)0.9990074942238029,
  PR_TRUE,
  "MAC-CENTRALEUROPE",
  "cs"
};

const LanguageModel CzechModel =
{
  "cs",
  Unicode_CharOrder,
  82,
  CzechLangModel,
  41,
  7,
  (float)0.4430512060790744,
  27,
  (float)0.035703314740419725,
};
