/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: French *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-14 20:39:17.167378
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 18, 11, 10,  0, 17, 16, 19,  3, 25, 27,  7, 13,  4,  9, /* 4X */
   12, 20,  6,  1,  5,  8, 15, 30, 21, 24, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 18, 11, 10,  0, 17, 16, 19,  3, 25, 27,  7, 13,  4,  9, /* 6X */
   12, 20,  6,  1,  5,  8, 15, 30, 21, 24, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM, 47,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 53, 52,SYM,SYM, 53,SYM,SYM,SYM, 34, 34, 57,SYM, /* BX */
   23, 41, 33, 51, 43, 48, 45, 29, 22, 14, 26, 40, 56, 42, 32, 36, /* CX */
   59, 46, 49, 44, 31, 60, 39,SYM, 54, 35, 50, 37, 38, 58, 61, 55, /* DX */
   23, 41, 33, 51, 43, 48, 45, 29, 22, 14, 26, 40, 56, 42, 32, 36, /* EX */
   59, 46, 49, 44, 31, 62, 39,SYM, 54, 35, 50, 37, 38, 58, 63, 57, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 18, 11, 10,  0, 17, 16, 19,  3, 25, 27,  7, 13,  4,  9, /* 4X */
   12, 20,  6,  1,  5,  8, 15, 30, 21, 24, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 18, 11, 10,  0, 17, 16, 19,  3, 25, 27,  7, 13,  4,  9, /* 6X */
   12, 20,  6,  1,  5,  8, 15, 30, 21, 24, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 52,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   23, 41, 33, 51, 43, 48, 45, 29, 22, 14, 26, 40, 56, 42, 32, 36, /* CX */
   59, 46, 49, 44, 31, 64, 39,SYM, 54, 35, 50, 37, 38, 58, 65, 55, /* DX */
   23, 41, 33, 51, 43, 48, 45, 29, 22, 14, 26, 40, 56, 42, 32, 36, /* EX */
   59, 46, 49, 44, 31, 66, 39,SYM, 54, 35, 50, 37, 38, 58, 67, 57, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  2, 18, 11, 10,  0, 17, 16, 19,  3, 25, 27,  7, 13,  4,  9, /* 4X */
   12, 20,  6,  1,  5,  8, 15, 30, 21, 24, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  2, 18, 11, 10,  0, 17, 16, 19,  3, 25, 27,  7, 13,  4,  9, /* 6X */
   12, 20,  6,  1,  5,  8, 15, 30, 21, 24, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 68,SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM, 34,ILL, 53,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 47,SYM, 34,ILL, 53, 57, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 52,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   23, 41, 33, 51, 43, 48, 45, 29, 22, 14, 26, 40, 56, 42, 32, 36, /* CX */
   59, 46, 49, 44, 31, 69, 39,SYM, 54, 35, 50, 37, 38, 58, 70, 55, /* DX */
   23, 41, 33, 51, 43, 48, 45, 29, 22, 14, 26, 40, 56, 42, 32, 36, /* EX */
   59, 46, 49, 44, 31, 71, 39,SYM, 54, 35, 50, 37, 38, 58, 72, 57, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 76;
static const unsigned int Unicode_CharOrder[] =
{
   65,  2,  66, 18,  67, 11,  68, 10,  69,  0,  70, 17,  71, 16, 72, 19,
   73,  3,  74, 25,  75, 27,  76,  7,  77, 13,  78,  4,  79,  9, 80, 12,
   81, 20,  82,  6,  83,  1,  84,  5,  85,  8,  86, 15,  87, 30, 88, 21,
   89, 24,  90, 28,  97,  2,  98, 18,  99, 11, 100, 10, 101,  0,102, 17,
  103, 16, 104, 19, 105,  3, 106, 25, 107, 27, 108,  7, 109, 13,110,  4,
  111,  9, 112, 12, 113, 20, 114,  6, 115,  1, 116,  5, 117,  8,118, 15,
  119, 30, 120, 21, 121, 24, 122, 28, 192, 23, 194, 33, 199, 29,200, 22,
  201, 14, 202, 26, 206, 32, 207, 36, 212, 31, 217, 35, 219, 37,224, 23,
  226, 33, 231, 29, 232, 22, 233, 14, 234, 26, 238, 32, 239, 36,244, 31,
  249, 35, 251, 37, 338, 34, 339, 34,
};


/* Model Table:
 * Total considered sequences: 1187 / 1444
 * - Positive sequences: first 450 (0.9950352320661208)
 * - Probable sequences: next 168 (618-450) (0.003966397970469049)
 * - Neutral sequences: last 826 (0.000998369963410184)
 * - Negative sequences: 257 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 FrenchLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,0,1,3,2,0,2,3,3,2,1,0,1,1,0,2,1,
  3,3,3,3,2,3,2,3,3,3,2,3,3,3,3,2,2,3,3,3,3,1,3,0,3,1,0,3,1,0,2,0,1,1,2,0,0,2,
  3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,3,3,0,3,3,3,3,1,3,1,0,0,3,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,0,2,2,1,3,3,1,2,1,0,0,0,0,1,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,2,2,3,1,3,0,3,3,2,3,3,3,2,1,1,1,2,0,0,0,
  3,3,3,3,2,3,3,3,3,3,1,3,2,2,3,2,1,1,2,3,1,1,3,1,3,1,3,1,2,1,2,3,0,2,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,0,3,1,3,3,2,3,2,3,1,3,0,0,0,2,
  3,3,3,3,2,3,1,3,3,3,3,3,3,3,3,3,3,3,3,2,3,1,3,3,3,1,1,2,2,1,1,2,1,2,1,0,0,0,
  3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,2,2,3,2,0,2,3,3,3,3,0,1,0,1,0,0,0,1,0,
  2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,0,3,3,1,3,3,1,3,0,2,0,0,3,3,3,
  3,3,3,3,2,2,3,2,3,3,3,2,2,3,3,2,2,2,1,2,0,0,3,0,3,3,1,1,1,0,2,1,1,1,0,0,0,2,
  3,3,3,3,2,3,3,3,3,3,2,3,1,2,3,1,2,2,2,3,3,0,3,0,3,0,2,3,1,0,1,3,1,1,3,0,1,0,
  3,3,3,3,2,3,3,3,3,3,2,1,3,2,3,1,1,2,1,3,1,0,3,0,2,1,3,1,1,1,0,2,1,2,0,0,0,1,
  3,3,3,3,3,2,2,2,3,3,2,2,3,3,3,1,2,1,3,2,0,0,3,0,3,1,3,1,1,0,1,1,1,2,1,1,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,0,1,3,0,1,2,1,0,0,0,2,0,0,0,0,
  3,1,3,3,1,1,3,1,3,3,1,1,1,1,3,1,1,1,1,1,0,0,3,0,1,0,2,1,0,0,0,1,0,1,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,1,1,3,3,1,3,1,2,3,1,0,3,0,3,1,1,1,1,0,1,0,1,1,1,0,0,1,
  3,3,3,3,1,2,3,3,3,3,1,2,1,1,3,1,2,3,1,1,0,1,2,0,1,1,3,1,1,0,0,0,1,1,1,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,2,2,1,3,2,1,1,2,1,0,0,2,0,3,3,2,1,1,0,1,1,1,3,3,0,0,1,
  3,2,3,3,3,3,3,3,3,3,1,1,1,3,3,1,1,1,1,1,1,0,3,0,3,1,1,1,1,1,2,3,1,2,1,0,0,0,
  1,1,2,1,0,0,1,0,3,0,1,1,1,0,1,0,0,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,1,
  3,1,3,3,0,3,1,1,3,2,1,3,3,1,3,3,0,2,1,2,2,3,1,0,2,1,0,1,0,0,1,0,0,0,0,0,0,0,
  0,3,0,0,3,3,3,3,0,0,3,3,1,3,0,3,3,1,2,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,3,3,3,2,3,3,3,3,3,3,2,2,1,2,1,1,1,2,0,2,0,0,1,2,1,1,1,0,0,0,0,0,0,
  3,1,3,2,1,0,1,1,3,3,1,1,1,1,2,0,0,1,1,1,0,0,0,3,0,1,0,1,0,0,1,0,0,0,0,0,0,0,
  0,0,0,0,2,3,1,2,0,0,0,3,1,3,0,2,0,0,0,0,2,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,1,2,2,2,3,3,1,1,2,2,2,1,2,1,1,3,0,0,0,0,2,1,1,2,0,1,1,0,0,0,0,0,0,1,
  3,1,3,3,1,1,1,1,2,3,1,1,1,2,2,1,1,1,1,2,1,0,1,0,2,1,0,1,2,0,1,1,1,1,0,0,0,0,
  1,0,3,1,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,2,1,2,1,1,2,1,1,1,1,1,1,1,1,1,2,0,0,0,0,1,0,0,1,0,0,2,0,0,1,0,0,0,0,
  0,2,0,0,2,3,1,3,0,0,0,1,2,2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,
  0,1,1,0,3,3,1,3,0,0,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,2,3,1,2,0,0,1,3,1,2,0,0,3,1,1,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,
  0,1,0,1,1,1,1,1,3,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,2,1,0,2,2,1,1,1,1,3,2,1,1,1,1,1,1,1,0,2,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,
  0,1,0,0,1,3,2,2,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_15FrenchModel =
{
  Iso_8859_15_CharToOrderMap,
  FrenchLangModel,
  38,
  (float)0.9990016300365898,
  PR_TRUE,
  "ISO-8859-15",
  "fr"
};

const SequenceModel Iso_8859_1FrenchModel =
{
  Iso_8859_1_CharToOrderMap,
  FrenchLangModel,
  38,
  (float)0.9990016300365898,
  PR_TRUE,
  "ISO-8859-1",
  "fr"
};

const SequenceModel Windows_1252FrenchModel =
{
  Windows_1252_CharToOrderMap,
  FrenchLangModel,
  38,
  (float)0.9990016300365898,
  PR_TRUE,
  "WINDOWS-1252",
  "fr"
};

const LanguageModel FrenchModel =
{
  "fr",
  Unicode_CharOrder,
  76,
  FrenchLangModel,
  38,
  5,
  (float)0.448850221338782,
  19,
  (float)0.03475814849488167,
};
