/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"

#include "../nsLanguageDetector-generated.h"

/********* Language model for: Greek *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-18 20:30:49.245016
 **/

  /* Character Mapping Table:
   * ILL: illegal character.
   * CTR: control character specific to the charset.
   * RET: carriage/return.
   * SYM: symbol (punctuation) that does not belong to word.
   * NUM: 0 - 9.
   *
   * Other characters are ordered by probabilities
   * (0 is the most common character in the language).
   *
   * Orders are generic to a language. So the codepoint with order X in
   * CHARSET1 maps to the same character as the codepoint with the same
   * order X in CHARSET2 for the same language.
   * As such, it is possible to get missing order. For instance the
   * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
   * even though they are both used for French. Same for the euro sign.
   */
  static const unsigned char Iso_8859_7_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 31, 48, 40, 42, 32, 50, 47, 41, 33, 55, 52, 39, 44, 34, 35, /* 4X */
   45, 59, 37, 36, 38, 43, 53, 54, 57, 51, 56,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 31, 48, 40, 42, 32, 50, 47, 41, 33, 55, 52, 39, 44, 34, 35, /* 6X */
   45, 59, 37, 36, 38, 43, 53, 54, 57, 51, 56,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM, 17,SYM, 20, 22, 15,SYM, 16,SYM, 24, 26, /* BX */
   58,  0, 28, 18, 19,  5, 30,  9, 25,  3,  6, 14, 12,  4, 29,  1, /* CX */
   10,  7,ILL,  8,  2, 13, 27, 23, 46, 21, 49, 60, 17, 20, 22, 15, /* DX */
   61,  0, 28, 18, 19,  5, 30,  9, 25,  3,  6, 14, 12,  4, 29,  1, /* EX */
   10,  7, 11,  8,  2, 13, 27, 23, 46, 21, 49, 60, 16, 24, 26,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1253_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 31, 48, 40, 42, 32, 50, 47, 41, 33, 55, 52, 39, 44, 34, 35, /* 4X */
   45, 59, 37, 36, 38, 43, 53, 54, 57, 51, 56,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 31, 48, 40, 42, 32, 50, 47, 41, 33, 55, 52, 39, 44, 34, 35, /* 6X */
   45, 59, 37, 36, 38, 43, 53, 54, 57, 51, 56,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,ILL,SYM,ILL,ILL,ILL,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,ILL,SYM,ILL,ILL,ILL,ILL, /* 9X */
  SYM,SYM, 17,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 62,SYM,SYM, 20, 22, 15,SYM, 16,SYM, 24, 26, /* BX */
   58,  0, 28, 18, 19,  5, 30,  9, 25,  3,  6, 14, 12,  4, 29,  1, /* CX */
   10,  7,ILL,  8,  2, 13, 27, 23, 46, 21, 49, 60, 17, 20, 22, 15, /* DX */
   61,  0, 28, 18, 19,  5, 30,  9, 25,  3,  6, 14, 12,  4, 29,  1, /* EX */
   10,  7, 11,  8,  2, 13, 27, 23, 46, 21, 49, 60, 16, 24, 26,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Cp737_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 31, 48, 40, 42, 32, 50, 47, 41, 33, 55, 52, 39, 44, 34, 35, /* 4X */
   45, 59, 37, 36, 38, 43, 53, 54, 57, 51, 56,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 31, 48, 40, 42, 32, 50, 47, 41, 33, 55, 52, 39, 44, 34, 35, /* 6X */
   45, 59, 37, 36, 38, 43, 53, 54, 57, 51, 56,SYM,SYM,SYM,SYM,CTR, /* 7X */
    0, 28, 18, 19,  5, 30,  9, 25,  3,  6, 14, 12,  4, 29,  1, 10, /* 8X */
    7,  8,  2, 13, 27, 23, 46, 21,  0, 28, 18, 19,  5, 30,  9, 25, /* 9X */
    3,  6, 14, 12,  4, 29,  1, 10,  7,  8, 11,  2, 13, 27, 23, 46, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* CX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* DX */
   21, 17, 20, 22, 49, 15, 16, 24, 60, 26, 17, 20, 22, 15, 16, 24, /* EX */
   26,SYM,SYM,SYM, 49, 60,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 94;
static const unsigned int Unicode_CharOrder[] =
{
   65, 31,  67, 40,  68, 42,  69, 32,  72, 41,  73, 33,  76, 39, 77, 44,
   78, 34,  79, 35,  80, 45,  82, 37,  83, 36,  84, 38,  85, 43, 97, 31,
   99, 40, 100, 42, 101, 32, 104, 41, 105, 33, 108, 39, 109, 44,110, 34,
  111, 35, 112, 45, 114, 37, 115, 36, 116, 38, 117, 43, 902, 17,904, 20,
  905, 22, 906, 15, 908, 16, 910, 24, 911, 26, 913,  0, 914, 28,915, 18,
  916, 19, 917,  5, 918, 30, 919,  9, 920, 25, 921,  3, 922,  6,923, 14,
  924, 12, 925,  4, 926, 29, 927,  1, 928, 10, 929,  7, 931,  8,931, 11,
  932,  2, 933, 13, 934, 27, 935, 23, 936, 46, 937, 21, 940, 17,941, 20,
  942, 22, 943, 15, 945,  0, 946, 28, 947, 18, 948, 19, 949,  5,950, 30,
  951,  9, 952, 25, 953,  3, 954,  6, 955, 14, 956, 12, 957,  4,958, 29,
  959,  1, 960, 10, 961,  7, 962, 11, 963,  8, 964,  2, 965, 13,966, 27,
  967, 23, 968, 46, 969, 21, 972, 16, 973, 24, 974, 26,
};


  /* Model Table:
   * Total considered sequences: 1389 / 2209
   * - Positive sequences: first 849 (0.9950207709120384)
   * - Probable sequences: next 223 (1072-849) (0.003984435961508326)
   * - Neutral sequences: last 1137 (0.0009947931264532306)
   * - Negative sequences: 820 (off-ratio)
   * Negative sequences: TODO
 */
static const PRUint8 GreekLangModel[] =
{
  1,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,2,0,3,3,3,0,2,
   3,3,3,1,3,3,3,3,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,2,3,
   3,3,3,2,3,3,3,3,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,3,
  3,3,3,3,2,3,2,3,3,3,1,2,3,3,3,3,3,3,1,1,3,3,3,
   1,3,2,3,1,1,0,3,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,1,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,
   3,1,3,3,3,3,3,3,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,3,
  3,3,3,3,3,3,3,2,3,3,2,2,3,3,1,3,3,3,3,3,3,3,3,
   2,3,3,3,1,1,1,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,3,3,2,3,3,3,3,3,3,3,3,3,3,2,3,1,
   3,3,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
  3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,2,3,3,3,3,
   3,3,3,3,3,2,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,1,3,3,2,3,3,3,3,3,3,3,3,
   3,3,3,3,3,3,3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,1,3,3,2,3,3,3,0,3,3,3,3,3,3,1,3,3,3,3,
   3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,0,3,2,3,3,3,0,3,3,3,0,3,0,0,0,3,3,1,1,0,
   3,1,3,2,3,3,3,0,0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,3,
  3,3,3,3,3,3,0,3,1,3,3,1,0,3,3,3,3,3,0,0,3,3,3,
   0,3,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,1,0,0,0,0,0,
  3,3,2,3,3,3,1,1,1,3,3,1,3,3,1,3,3,3,1,0,3,3,3,
   0,3,0,3,3,3,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,3,3,3,3,3,3,3,
   3,0,3,2,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
  3,3,3,3,2,3,3,1,2,3,3,2,3,3,3,3,3,3,2,3,3,3,3,
   1,3,3,3,3,3,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,0,3,3,3,3,3,3,3,3,3,0,3,0,0,0,3,3,0,3,0,
   3,0,3,0,2,3,3,3,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,2,
  1,3,3,2,3,2,3,3,3,2,3,3,3,0,3,0,0,0,3,3,0,2,0,
   3,0,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
  2,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,0,0,3,3,0,1,0,
   3,0,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,0,3,3,3,3,3,0,3,0,0,3,3,3,3,3,3,3,2,3,3,3,
   3,3,0,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,2,3,1,3,2,3,0,3,0,0,1,3,1,3,3,3,0,0,3,3,3,
   0,3,0,3,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,0,3,3,3,1,3,0,0,0,3,3,0,3,0,
   3,0,3,0,3,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
  3,3,3,3,3,1,3,3,3,1,3,3,3,0,3,0,1,2,3,3,0,1,3,
   2,0,3,1,1,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,1,3,1,3,3,3,0,3,3,3,0,3,0,0,0,3,3,0,0,0,
   2,0,3,0,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,0,3,0,3,1,0,2,3,3,3,3,3,0,0,3,3,3,
   0,3,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,3,3,2,3,3,3,3,3,2,3,3,3,0,3,0,0,0,3,3,0,2,0,
   3,0,3,0,3,2,3,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
  3,3,0,3,3,3,0,3,0,3,0,0,3,3,2,2,3,3,0,0,3,3,3,
   0,3,0,3,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,1,3,3,3,2,3,3,3,0,3,0,0,0,2,3,0,3,0,
   2,0,3,0,0,2,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,1,3,0,3,1,3,0,0,1,3,3,3,3,3,1,0,3,3,3,
   0,3,3,3,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,0,3,0,3,0,3,0,3,0,1,0,2,3,3,3,3,2,2,3,2,3,
   0,2,0,2,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,2,3,0,3,0,0,0,3,0,0,0,3,1,3,2,3,0,0,3,3,3,
   0,3,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,1,3,1,3,0,0,0,3,0,0,1,3,0,3,3,2,0,0,3,3,3,
   0,2,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,2,3,3,3,2,3,3,3,3,3,2,3,3,3,3,0,
  0,1,1,0,0,0,1,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,
   0,0,1,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,0,
  0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,0,
  0,1,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,3,3,3,2,3,2,3,1,3,3,2,1,0,
  0,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,1,0,0,0,
   0,0,0,0,0,0,0,0,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
  0,1,1,0,0,1,1,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,2,3,3,1,3,2,3,3,1,3,2,3,0,
  0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
  0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,1,3,3,3,3,2,2,3,1,3,2,3,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,1,3,3,0,3,3,2,1,3,3,2,2,0,
  0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,3,3,2,2,3,3,2,3,1,3,2,2,0,
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,2,3,2,3,3,2,2,1,2,3,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,3,3,2,3,1,3,1,1,2,3,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,2,3,2,3,3,3,3,3,1,3,1,3,3,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,2,3,2,1,1,1,2,0,1,3,3,3,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,3,1,3,3,3,3,3,1,3,2,3,2,2,0,
  3,3,0,2,0,3,0,0,0,3,0,0,0,3,0,3,2,3,0,0,0,2,2,
   0,2,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_7GreekModel =
{
  Iso_8859_7_CharToOrderMap,
  GreekLangModel,
  47,
  (float)0.9990052068735468,
  PR_FALSE,
  "ISO-8859-7",
  "el"
};

const SequenceModel Windows_1253GreekModel =
{
  Windows_1253_CharToOrderMap,
  GreekLangModel,
  47,
  (float)0.9990052068735468,
  PR_FALSE,
  "WINDOWS-1253",
  "el"
};

const SequenceModel Cp737GreekModel =
{
  Cp737_CharToOrderMap,
  GreekLangModel,
  47,
  (float)0.9990052068735468,
  PR_FALSE,
  "CP737",
  "el"
};

const LanguageModel GreekModel =
{
  "el",
  Unicode_CharOrder,
  94,
  GreekLangModel,
  47,
  6,
  (float)0.4332502995419538,
  31,
  (float)0.03350734517136193,
};
