/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Hungarian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:16:34.282219
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_2_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 15, 26, 16,  0, 25, 13, 19,  8, 22,  7,  4, 14,  5,  9, /* 4X */
   20, 34,  6,  3,  2, 21, 17, 32, 33, 18, 10,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 15, 26, 16,  0, 25, 13, 19,  8, 22,  7,  4, 14,  5,  9, /* 6X */
   20, 34,  6,  3,  2, 21, 17, 32, 33, 18, 10,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 58,SYM, 38,SYM, 60, 52,SYM,SYM, 37, 51, 59, 61,SYM, 46, 54, /* AX */
  SYM, 58,SYM, 38,SYM, 62, 52,SYM,SYM, 37, 51, 59, 63,SYM, 46, 54, /* BX */
   64, 11, 44, 42, 36, 65, 40, 35, 45, 12, 55, 49, 57, 28, 47, 66, /* CX */
   50, 43, 67, 24, 41, 27, 23,SYM, 53, 68, 30, 31, 29, 48, 56, 39, /* DX */
   69, 11, 44, 42, 36, 70, 40, 35, 45, 12, 55, 49, 57, 28, 47, 71, /* EX */
   50, 43, 72, 24, 41, 27, 23,SYM, 53, 73, 30, 31, 29, 48, 56,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1250_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 15, 26, 16,  0, 25, 13, 19,  8, 22,  7,  4, 14,  5,  9, /* 4X */
   20, 34,  6,  3,  2, 21, 17, 32, 33, 18, 10,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 15, 26, 16,  0, 25, 13, 19,  8, 22,  7,  4, 14,  5,  9, /* 6X */
   20, 34,  6,  3,  2, 21, 17, 32, 33, 18, 10,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,ILL,SYM,SYM,SYM,SYM,ILL,SYM, 37,SYM, 52, 59, 46, 74, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 37,SYM, 52, 59, 46, 75, /* 9X */
  SYM,SYM,SYM, 38,SYM, 58,SYM,SYM,SYM,SYM, 51,SYM,SYM,SYM,SYM, 54, /* AX */
  SYM,SYM,SYM, 38,SYM,SYM,SYM,SYM,SYM, 58, 51,SYM, 76,SYM, 77, 54, /* BX */
   78, 11, 44, 42, 36, 79, 40, 35, 45, 12, 55, 49, 57, 28, 47, 80, /* CX */
   50, 43, 81, 24, 41, 27, 23,SYM, 53, 82, 30, 31, 29, 48, 56, 39, /* DX */
   83, 11, 44, 42, 36, 84, 40, 35, 45, 12, 55, 49, 57, 28, 47, 85, /* EX */
   50, 43, 86, 24, 41, 27, 23,SYM, 53, 87, 30, 31, 29, 48, 56,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 64;
static const unsigned int Unicode_CharOrder[] =
{
   65,  1,  66, 15,  67, 26,  68, 16,  69,  0,  70, 25,  71, 13, 72, 19,
   73,  8,  74, 22,  75,  7,  76,  4,  77, 14,  78,  5,  79,  9, 80, 20,
   82,  6,  83,  3,  84,  2,  85, 21,  86, 17,  89, 18,  90, 10, 97,  1,
   98, 15,  99, 26, 100, 16, 101,  0, 102, 25, 103, 13, 104, 19,105,  8,
  106, 22, 107,  7, 108,  4, 109, 14, 110,  5, 111,  9, 112, 20,114,  6,
  115,  3, 116,  2, 117, 21, 118, 17, 121, 18, 122, 10, 193, 11,201, 12,
  205, 28, 211, 24, 214, 23, 218, 30, 220, 29, 225, 11, 233, 12,237, 28,
  243, 24, 246, 23, 250, 30, 252, 29, 336, 27, 337, 27, 368, 31,369, 31,
};


/* Model Table:
 * Total considered sequences: 1221 / 1024
 * - Positive sequences: first 713 (0.9950428169725475)
 * - Probable sequences: next 143 (856-713) (0.003957871411948477)
 * - Neutral sequences: last 168 (0.0009993116155040394)
 * - Negative sequences: -197 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 HungarianLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,2,3,3,0,2,1,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,1,1,3,3,0,2,1,2,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,
  3,3,3,3,3,3,3,3,3,3,2,3,3,2,3,3,2,3,3,3,2,3,3,3,3,3,3,3,3,3,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,1,3,3,3,1,1,2,2,1,
  3,3,3,3,3,3,3,3,3,3,3,1,1,3,3,3,3,3,3,3,3,3,3,0,1,3,3,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,3,3,
  1,2,3,3,3,3,3,3,3,1,3,1,2,3,3,3,3,3,1,3,3,3,3,0,0,3,3,0,2,0,0,0,
  3,1,3,3,3,3,3,3,3,2,3,0,2,3,3,3,3,3,1,3,3,1,3,0,0,2,3,0,1,1,1,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,3,3,3,3,
  3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,3,2,2,2,3,3,3,2,2,3,3,3,2,3,3,3,3,
  3,3,2,3,3,3,3,2,3,3,1,3,3,1,1,3,3,1,2,2,3,3,3,3,3,2,2,3,3,3,2,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,
  3,3,3,3,2,2,3,2,3,3,0,3,3,2,1,3,1,3,2,1,1,2,3,3,2,2,2,3,3,3,2,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,2,3,3,3,3,3,2,3,3,3,3,3,
  3,3,3,3,3,3,3,1,3,3,1,3,3,1,2,1,1,1,3,2,1,3,1,3,3,1,1,3,3,2,3,2,
  3,3,3,3,3,2,3,3,3,3,3,3,3,2,2,3,2,3,1,3,3,3,3,2,3,2,3,2,3,3,2,1,
  3,3,3,3,3,3,3,3,3,2,3,3,1,3,3,3,3,3,2,3,3,1,2,0,1,2,3,1,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,2,3,3,1,2,2,3,3,3,3,2,2,1,2,3,3,2,
  1,0,3,3,3,3,3,3,0,0,3,0,0,3,3,3,3,3,0,1,3,0,1,0,0,1,2,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,1,3,2,1,3,3,3,3,3,0,3,3,1,3,1,1,3,3,0,1,1,1,1,
  3,3,3,1,3,1,3,1,3,3,1,3,3,1,1,2,1,1,2,1,1,3,2,3,2,3,2,3,0,3,2,2,
  3,3,3,3,3,2,3,3,3,3,3,3,3,1,2,3,2,2,2,3,1,3,1,1,1,1,3,0,3,0,1,1,
  3,3,3,3,3,3,3,3,3,2,3,1,2,3,3,3,3,3,0,3,3,1,3,1,1,3,2,1,1,1,1,0,
  1,1,3,3,3,3,3,2,0,1,3,1,1,3,3,1,3,3,0,0,3,0,3,0,0,1,3,0,1,0,1,0,
  1,2,3,3,3,3,3,3,0,0,3,0,0,3,2,1,2,2,0,2,1,0,1,0,0,0,1,0,0,0,0,0,
  1,2,3,3,3,3,3,2,2,1,3,0,1,3,1,2,3,2,0,1,1,0,3,0,0,1,2,0,0,0,0,0,
  3,1,2,3,3,3,3,3,1,0,3,0,1,1,1,2,1,3,0,2,0,1,3,0,0,2,1,0,1,0,1,0,
};


const SequenceModel Iso_8859_2HungarianModel =
{
  Iso_8859_2_CharToOrderMap,
  HungarianLangModel,
  32,
  (float)0.999000688384496,
  PR_FALSE,
  "ISO-8859-2",
  "hu"
};

const SequenceModel Windows_1250HungarianModel =
{
  Windows_1250_CharToOrderMap,
  HungarianLangModel,
  32,
  (float)0.999000688384496,
  PR_FALSE,
  "WINDOWS-1250",
  "hu"
};

const LanguageModel HungarianModel =
{
  "hu",
  Unicode_CharOrder,
  64,
  HungarianLangModel,
  32,
  6,
  (float)0.4436196326698296,
  25,
  (float)0.03548460884537605,
};
