/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Irish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-14 23:59:16.710336
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 15,  8, 11,  5, 19, 12,  3,  1, 27, 24, 10, 13,  2,  9, /* 4X */
   22, 30,  4,  6,  7, 14, 25, 26, 29, 23, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 15,  8, 11,  5, 19, 12,  3,  1, 27, 24, 10, 13,  2,  9, /* 6X */
   22, 30,  4,  6,  7, 14, 25, 26, 29, 23, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 37,SYM, 37,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 49, 55,SYM,SYM, 49,SYM,SYM,SYM, 56, 57, 58,SYM, /* BX */
   41, 16, 48, 59, 34, 43, 53, 39, 31, 18, 60, 38, 51, 17, 50, 54, /* CX */
   40, 35, 36, 20, 45, 61, 32,SYM, 42, 46, 21, 62, 33, 44, 63, 52, /* DX */
   41, 16, 48, 64, 34, 43, 53, 39, 31, 18, 65, 38, 51, 17, 50, 54, /* EX */
   40, 35, 36, 20, 45, 66, 32,SYM, 42, 46, 21, 67, 33, 44, 68, 69, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 15,  8, 11,  5, 19, 12,  3,  1, 27, 24, 10, 13,  2,  9, /* 4X */
   22, 30,  4,  6,  7, 14, 25, 26, 29, 23, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 15,  8, 11,  5, 19, 12,  3,  1, 27, 24, 10, 13,  2,  9, /* 6X */
   22, 30,  4,  6,  7, 14, 25, 26, 29, 23, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 70,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   41, 16, 48, 71, 34, 43, 53, 39, 31, 18, 72, 38, 51, 17, 50, 54, /* CX */
   40, 35, 36, 20, 45, 73, 32,SYM, 42, 46, 21, 74, 33, 44, 75, 52, /* DX */
   41, 16, 48, 76, 34, 43, 53, 39, 31, 18, 77, 38, 51, 17, 50, 54, /* EX */
   40, 35, 36, 20, 45, 78, 32,SYM, 42, 46, 21, 79, 33, 44, 80, 81, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 15,  8, 11,  5, 19, 12,  3,  1, 27, 24, 10, 13,  2,  9, /* 4X */
   22, 30,  4,  6,  7, 14, 25, 26, 29, 23, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 15,  8, 11,  5, 19, 12,  3,  1, 27, 24, 10, 13,  2,  9, /* 6X */
   22, 30,  4,  6,  7, 14, 25, 26, 29, 23, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 82,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   41, 16, 48, 83, 34, 43, 53, 39, 31, 18, 84, 38, 51, 17, 50, 54, /* CX */
   85, 35, 36, 20, 45, 86, 32,SYM, 42, 46, 21, 87, 33, 88, 47, 52, /* DX */
   41, 16, 48, 89, 34, 43, 53, 39, 31, 18, 90, 38, 51, 17, 50, 54, /* EX */
   91, 35, 36, 20, 45, 92, 32,SYM, 42, 46, 21, 93, 33, 94, 47, 95, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 15,  8, 11,  5, 19, 12,  3,  1, 27, 24, 10, 13,  2,  9, /* 4X */
   22, 30,  4,  6,  7, 14, 25, 26, 29, 23, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 15,  8, 11,  5, 19, 12,  3,  1, 27, 24, 10, 13,  2,  9, /* 6X */
   22, 30,  4,  6,  7, 14, 25, 26, 29, 23, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM, 96,SYM,SYM,SYM,SYM,SYM,SYM, 37,SYM, 97,ILL, 49,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 37,SYM, 98,ILL, 49, 99, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,100,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   41, 16, 48,101, 34, 43, 53, 39, 31, 18,102, 38, 51, 17, 50, 54, /* CX */
   40, 35, 36, 20, 45,103, 32,SYM, 42, 46, 21,104, 33, 44,105, 52, /* DX */
   41, 16, 48,106, 34, 43, 53, 39, 31, 18,107, 38, 51, 17, 50, 54, /* EX */
   40, 35, 36, 20, 45,108, 32,SYM, 42, 46, 21,109, 33, 44,110,111, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 62;
static const unsigned int Unicode_CharOrder[] =
{
   65,  0,  66, 15,  67,  8,  68, 11,  69,  5,  70, 19,  71, 12, 72,  3,
   73,  1,  74, 27,  75, 24,  76, 10,  77, 13,  78,  2,  79,  9, 80, 22,
   81, 30,  82,  4,  83,  6,  84,  7,  85, 14,  86, 25,  87, 26, 88, 29,
   89, 23,  90, 28,  97,  0,  98, 15,  99,  8, 100, 11, 101,  5,102, 19,
  103, 12, 104,  3, 105,  1, 106, 27, 107, 24, 108, 10, 109, 13,110,  2,
  111,  9, 112, 22, 113, 30, 114,  4, 115,  6, 116,  7, 117, 14,118, 25,
  119, 26, 120, 29, 121, 23, 122, 28, 193, 16, 201, 18, 205, 17,211, 20,
  218, 21, 225, 16, 233, 18, 237, 17, 243, 20, 250, 21,
};


/* Model Table:
 * Total considered sequences: 866 / 961
 * - Positive sequences: first 465 (0.9950412672131922)
 * - Probable sequences: next 161 (626-465) (0.003964208227885013)
 * - Neutral sequences: last 335 (0.0009945245589227936)
 * - Negative sequences: 95 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 IrishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,0,3,0,0,3,3,3,3,3,2,3,3,1,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,1,0,1,3,2,3,3,3,3,3,1,2,3,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,2,2,2,0,1,
  3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,1,2,1,1,0,0,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,1,1,1,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,1,0,3,1,0,3,3,3,3,3,2,3,3,1,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,2,3,2,2,1,2,0,1,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,2,3,3,2,3,2,2,2,0,3,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,2,3,3,3,3,3,3,1,3,3,0,1,0,2,0,3,
  2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,1,3,0,2,3,3,3,3,3,2,2,3,1,
  3,3,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,1,1,2,0,0,
  3,3,2,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,3,3,1,3,1,2,3,0,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,2,3,2,0,2,1,2,2,1,0,0,0,
  3,3,3,3,3,3,3,2,3,3,3,1,2,3,3,3,3,3,3,2,3,3,3,3,1,0,0,1,2,0,1,
  3,3,3,2,3,3,3,3,3,1,3,3,3,3,0,3,3,3,1,2,0,0,2,2,2,2,0,2,2,2,1,
  3,3,2,3,3,3,3,2,3,3,3,2,1,1,3,3,3,3,3,3,3,2,3,3,0,0,0,1,0,0,2,
  0,3,3,0,3,0,3,3,3,0,3,3,3,3,0,3,0,2,0,3,0,0,3,1,0,0,0,0,0,0,0,
  2,0,3,0,3,0,3,3,3,3,3,3,2,3,1,3,0,0,0,2,1,3,1,0,1,1,0,0,0,0,0,
  3,3,2,0,2,2,2,2,1,2,2,2,0,2,1,1,1,1,0,1,1,2,2,0,0,1,0,0,0,0,0,
  3,3,0,3,3,3,0,2,1,3,3,0,2,1,3,0,3,3,3,3,3,2,1,2,0,0,1,1,0,0,0,
  0,3,3,0,3,0,3,3,3,0,3,3,3,3,0,2,0,0,0,2,0,2,3,0,0,2,1,0,1,0,0,
  0,3,3,0,3,0,3,3,3,0,3,3,2,2,0,3,0,1,0,0,0,0,3,0,0,0,0,1,0,0,0,
  3,3,2,3,3,3,3,3,2,3,3,1,0,2,3,2,3,2,3,1,3,2,3,2,1,0,0,1,0,1,0,
  3,2,3,1,2,3,3,2,2,3,3,3,3,2,3,3,0,0,0,1,1,0,2,1,1,1,2,0,1,0,0,
  3,3,2,3,2,3,3,1,0,3,3,1,2,3,3,1,1,0,0,1,0,0,0,3,2,1,1,1,0,0,0,
  3,3,2,0,2,3,3,1,0,3,2,0,1,0,2,1,3,3,3,0,3,0,0,2,0,1,0,0,0,0,0,
  3,3,2,2,2,3,2,2,1,3,2,0,0,1,2,3,0,0,1,1,1,0,1,2,3,0,2,0,0,0,0,
  3,3,1,0,2,3,0,0,0,3,1,0,0,0,3,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,
  3,3,1,3,1,3,1,1,1,3,0,1,1,2,2,1,0,0,0,0,1,0,0,2,1,1,0,0,2,0,0,
  3,2,1,1,0,2,1,2,1,2,1,0,0,0,0,1,0,0,0,2,0,0,2,0,0,1,1,0,0,1,0,
  2,2,0,1,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_15IrishModel =
{
  Iso_8859_15_CharToOrderMap,
  IrishLangModel,
  31,
  (float)0.9990054754410772,
  PR_TRUE,
  "ISO-8859-15",
  "ga"
};

const SequenceModel Iso_8859_1IrishModel =
{
  Iso_8859_1_CharToOrderMap,
  IrishLangModel,
  31,
  (float)0.9990054754410772,
  PR_TRUE,
  "ISO-8859-1",
  "ga"
};

const SequenceModel Iso_8859_9IrishModel =
{
  Iso_8859_9_CharToOrderMap,
  IrishLangModel,
  31,
  (float)0.9990054754410772,
  PR_TRUE,
  "ISO-8859-9",
  "ga"
};

const SequenceModel Windows_1252IrishModel =
{
  Windows_1252_CharToOrderMap,
  IrishLangModel,
  31,
  (float)0.9990054754410772,
  PR_TRUE,
  "WINDOWS-1252",
  "ga"
};

const LanguageModel IrishModel =
{
  "ga",
  Unicode_CharOrder,
  62,
  IrishLangModel,
  31,
  4,
  (float)0.41512943556580745,
  19,
  (float)0.038838485225387374,
};
