/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Latvian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:06:43.950451
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_4_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 22, 12,  3, 24, 17, 27,  1, 16, 11, 10, 13,  7,  9, /* 4X */
   15, 39,  4,  2,  5,  6, 14, 34, 35, 33, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 22, 12,  3, 24, 17, 27,  1, 16, 11, 10, 13,  7,  9, /* 6X */
   15, 39,  4,  2,  5,  6, 14, 34, 35, 33, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 53, 72, 52,SYM, 73, 26,SYM,SYM, 23, 21, 31, 74,SYM, 29,SYM, /* AX */
  SYM, 53,SYM, 52,SYM, 75, 26,SYM,SYM, 23, 21, 31, 76, 59, 29, 59, /* BX */
    8, 44, 68, 62, 41, 60, 37, 58, 32, 36, 49, 56, 50, 48, 61, 19, /* CX */
   70, 25, 66, 30, 67, 57, 42,SYM, 63, 54, 51, 77, 38, 78, 28, 46, /* DX */
    8, 44, 68, 62, 41, 60, 37, 58, 32, 36, 49, 56, 50, 48, 61, 19, /* EX */
   70, 25, 66, 30, 67, 57, 42,SYM, 63, 54, 51, 79, 38, 80, 28,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_10_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 22, 12,  3, 24, 17, 27,  1, 16, 11, 10, 13,  7,  9, /* 4X */
   15, 39,  4,  2,  5,  6, 14, 34, 35, 33, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 22, 12,  3, 24, 17, 27,  1, 16, 11, 10, 13,  7,  9, /* 6X */
   15, 39,  4,  2,  5,  6, 14, 34, 35, 33, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 53, 21, 31, 19, 81, 30,SYM, 26, 70, 23, 82, 29,SYM, 28, 59, /* AX */
  SYM, 53, 21, 31, 19, 83, 30,SYM, 26, 70, 23, 84, 29, 71, 28, 59, /* BX */
    8, 44, 68, 62, 41, 60, 37, 58, 32, 36, 49, 56, 50, 48, 61, 85, /* CX */
   86, 25, 66, 43, 67, 57, 42, 87, 63, 54, 51, 88, 38, 64, 69, 46, /* DX */
    8, 44, 68, 62, 41, 60, 37, 58, 32, 36, 49, 56, 50, 48, 61, 89, /* EX */
   90, 25, 66, 43, 67, 57, 42, 91, 63, 54, 51, 92, 38, 64, 69, 93, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_13_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 18, 22, 12,  3, 24, 17, 27,  1, 16, 11, 10, 13,  7,  9, /* 4X */
   15, 39,  4,  2,  5,  6, 14, 34, 35, 33, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 18, 22, 12,  3, 24, 17, 27,  1, 16, 11, 10, 13,  7,  9, /* 6X */
   15, 39,  4,  2,  5,  6, 14, 34, 35, 33, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 63,SYM, 52,SYM,SYM,SYM,SYM, 37, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 63,SYM, 52,SYM,SYM,SYM,SYM, 37, /* BX */
   53, 58,  8, 55, 41, 60, 49, 21, 32, 36, 94, 50, 31, 30, 19, 26, /* CX */
   23, 45, 25, 43, 66, 57, 42,SYM, 54, 40, 47, 28, 38, 65, 29, 46, /* DX */
   53, 58,  8, 55, 41, 60, 49, 21, 32, 36, 95, 50, 31, 30, 19, 26, /* EX */
   23, 45, 25, 43, 66, 57, 42,SYM, 54, 40, 47, 28, 38, 65, 29,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 80;
static const unsigned int Unicode_CharOrder[] =
{
   65,  0,  66, 18,  67, 22,  68, 12,  69,  3,  70, 24,  71, 17, 72, 27,
   73,  1,  74, 16,  75, 11,  76, 10,  77, 13,  78,  7,  79,  9, 80, 15,
   81, 39,  82,  4,  83,  2,  84,  5,  85,  6,  86, 14,  87, 34, 88, 35,
   89, 33,  90, 20,  97,  0,  98, 18,  99, 22, 100, 12, 101,  3,102, 24,
  103, 17, 104, 27, 105,  1, 106, 16, 107, 11, 108, 10, 109, 13,110,  7,
  111,  9, 112, 15, 113, 39, 114,  4, 115,  2, 116,  5, 117,  6,118, 14,
  119, 34, 120, 35, 121, 33, 122, 20, 198, 37, 201, 36, 220, 38,230, 37,
  233, 36, 252, 38, 256,  8, 257,  8, 268, 32, 269, 32, 274, 21,275, 21,
  290, 31, 291, 31, 298, 19, 299, 19, 310, 30, 311, 30, 315, 26,316, 26,
  325, 25, 326, 25, 352, 23, 353, 23, 362, 28, 363, 28, 381, 29,382, 29,
};


/* Model Table:
 * Total considered sequences: 1225 / 1600
 * - Positive sequences: first 641 (0.9950084809045374)
 * - Probable sequences: next 222 (863-641) (0.003991829224555987)
 * - Neutral sequences: last 737 (0.0009996898709065949)
 * - Negative sequences: 375 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 LatvianLangModel[] =
{
  3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,2,3,2,3,3,3,3,3,3,0,3,2,3,3,3,3,2,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,3,3,3,3,3,3,1,3,3,3,3,2,1,2,1,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,0,2,1,0,3,3,1,0,0,1,2,2,0,2,0,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,0,3,3,3,3,3,3,0,3,3,3,3,3,3,2,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,0,2,0,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,1,0,1,3,2,1,2,0,0,0,
  3,3,3,3,3,3,2,3,3,2,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,0,2,2,3,2,1,1,2,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,2,3,0,1,3,2,1,0,2,0,0,0,
  2,2,3,2,3,3,1,3,0,0,3,3,3,3,3,3,3,3,3,0,3,0,3,3,3,3,3,1,0,2,0,0,2,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,1,3,0,3,3,3,3,3,3,0,3,2,3,2,2,3,1,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,3,2,1,1,1,2,0,1,2,0,1,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,2,2,2,1,2,3,3,2,3,3,3,2,0,0,0,0,1,1,0,0,0,0,0,
  3,3,3,3,3,2,3,3,3,3,3,2,2,3,3,1,2,2,2,3,3,3,2,0,1,2,0,2,3,3,0,0,0,2,2,1,1,0,2,0,
  3,3,3,3,2,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,2,3,1,1,0,1,3,1,1,0,0,2,0,2,1,0,2,0,
  3,3,3,3,3,1,3,3,3,3,3,2,3,2,2,3,3,2,2,3,2,3,0,0,1,0,1,0,1,0,0,0,1,2,0,0,1,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,1,0,2,1,0,0,0,1,3,0,0,
  3,3,3,3,2,1,3,3,3,3,1,2,2,2,2,1,1,0,2,3,1,3,2,1,1,0,0,0,3,0,0,0,0,1,0,0,0,0,1,0,
  3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,1,2,2,2,2,2,0,3,3,1,3,2,3,3,0,0,0,2,0,0,1,0,2,0,
  3,3,3,3,3,2,3,3,3,3,3,3,2,2,3,2,3,0,2,3,1,3,1,1,0,1,3,2,3,1,0,0,1,1,0,0,0,0,1,0,
  0,0,3,0,3,3,0,3,0,0,3,3,3,3,3,3,3,3,3,0,3,0,3,3,0,3,2,0,0,1,1,0,2,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,3,0,1,2,0,1,0,0,3,1,0,0,0,0,1,
  1,0,3,0,3,3,0,3,0,0,3,3,3,3,3,2,3,3,2,0,3,0,3,3,1,2,3,0,0,2,3,3,1,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,1,3,3,3,3,2,2,2,2,1,1,3,3,2,3,2,0,0,0,0,3,2,0,0,1,0,3,0,0,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,2,2,1,3,1,3,1,1,0,3,2,0,2,0,3,0,3,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,1,3,3,3,1,1,3,1,1,2,2,0,2,0,2,1,0,3,0,0,0,2,0,0,0,0,0,0,0,1,0,1,0,
  3,3,3,3,0,0,3,2,3,3,1,2,2,1,2,2,1,1,2,1,1,3,0,3,0,0,0,0,2,0,3,2,0,0,0,0,0,0,0,0,
  3,3,2,3,3,2,3,2,3,3,2,2,1,1,2,2,2,1,1,3,0,2,0,3,1,3,2,0,3,0,2,3,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,1,1,3,0,0,1,1,1,1,0,2,1,1,0,1,1,1,1,0,1,0,0,1,1,0,1,0,1,0,
  0,1,3,0,3,3,0,3,0,1,3,3,3,2,3,3,2,2,2,0,3,0,3,3,1,1,0,1,1,2,1,0,0,0,0,0,0,0,0,0,
  3,3,3,3,1,0,3,1,3,3,2,3,1,2,2,1,0,0,1,3,0,2,1,0,0,3,0,0,3,1,0,2,0,1,0,0,0,0,0,0,
  3,3,1,3,0,1,3,0,2,2,0,0,0,0,0,0,0,0,0,3,0,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  1,3,0,3,0,0,3,1,0,1,0,0,0,0,0,0,0,0,0,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,0,0,3,1,2,3,1,2,0,1,1,2,0,0,0,2,0,2,0,0,0,0,0,1,2,0,0,0,1,0,0,0,0,0,0,0,
  2,2,2,2,2,2,2,2,0,2,2,3,2,2,1,0,1,2,2,0,0,0,3,0,1,0,0,1,0,0,0,0,0,1,1,0,0,0,0,0,
  3,3,2,3,1,1,1,2,0,3,2,1,0,1,0,1,0,0,0,0,1,0,1,0,0,0,0,2,0,0,0,0,0,2,0,0,0,0,0,0,
  2,3,0,1,0,1,1,0,0,1,2,0,0,0,2,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,2,0,0,0,0,
  1,0,1,1,2,1,0,0,0,2,1,0,2,2,1,1,0,1,1,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,1,2,1,0,2,0,0,2,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,
  1,0,1,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
};


const SequenceModel Iso_8859_4LatvianModel =
{
  Iso_8859_4_CharToOrderMap,
  LatvianLangModel,
  40,
  (float)0.9990003101290934,
  PR_TRUE,
  "ISO-8859-4",
  "lv"
};

const SequenceModel Iso_8859_10LatvianModel =
{
  Iso_8859_10_CharToOrderMap,
  LatvianLangModel,
  40,
  (float)0.9990003101290934,
  PR_TRUE,
  "ISO-8859-10",
  "lv"
};

const SequenceModel Iso_8859_13LatvianModel =
{
  Iso_8859_13_CharToOrderMap,
  LatvianLangModel,
  40,
  (float)0.9990003101290934,
  PR_TRUE,
  "ISO-8859-13",
  "lv"
};

const LanguageModel LatvianModel =
{
  "lv",
  Unicode_CharOrder,
  80,
  LatvianLangModel,
  40,
  5,
  (float)0.42298978835240825,
  22,
  (float)0.034628570589573984,
};
