/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Maltese *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:03:07.917587
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_3_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 14, 28, 13,  4, 15, 18, 22,  1, 10, 12,  2,  9,  5,  8, /* 4X */
   16, 27,  6, 11,  3,  7, 24, 19, 26, 30, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 14, 28, 13,  4, 15, 18, 22,  1, 10, 12,  2,  9,  5,  8, /* 6X */
   16, 27,  6, 11,  3,  7, 24, 19, 26, 30, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 17,SYM,SYM,SYM,ILL, 50,SYM,SYM, 51, 52, 53, 54,SYM,ILL, 21, /* AX */
  SYM, 17,SYM,SYM,SYM,SYM, 55,SYM,SYM, 42, 56, 57, 58,SYM,ILL, 21, /* BX */
   29, 33, 49,ILL, 45, 25, 59, 39, 32, 31, 60, 41, 46, 35, 61, 62, /* CX */
  ILL, 37, 36, 34, 44, 23, 38,SYM, 63, 43, 40, 64, 48, 65, 66, 47, /* DX */
   29, 33, 49,ILL, 45, 25, 67, 39, 32, 31, 68, 41, 46, 35, 69, 70, /* EX */
  ILL, 37, 36, 34, 44, 23, 38,SYM, 71, 43, 40, 72, 48, 73, 74,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 62;
static const unsigned int Unicode_CharOrder[] =
{
   65,  0,  66, 14,  67, 28,  68, 13,  69,  4,  70, 15,  71, 18, 72, 22,
   73,  1,  74, 10,  75, 12,  76,  2,  77,  9,  78,  5,  79,  8, 80, 16,
   81, 27,  82,  6,  83, 11,  84,  3,  85,  7,  86, 24,  87, 19, 88, 26,
   89, 30,  90, 20,  97,  0,  98, 14,  99, 28, 100, 13, 101,  4,102, 15,
  103, 18, 104, 22, 105,  1, 106, 10, 107, 12, 108,  2, 109,  9,110,  5,
  111,  8, 112, 16, 113, 27, 114,  6, 115, 11, 116,  3, 117,  7,118, 24,
  119, 19, 120, 26, 121, 30, 122, 20, 192, 29, 224, 29, 266, 25,267, 25,
  288, 23, 289, 23, 294, 17, 295, 17, 379, 21, 380, 21,
};


/* Model Table:
 * Total considered sequences: 922 / 961
 * - Positive sequences: first 517 (0.9950257898046807)
 * - Probable sequences: next 170 (687-517) (0.003980403371696695)
 * - Neutral sequences: last 274 (0.0009938068236226005)
 * - Negative sequences: 39 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 MalteseLangModel[] =
{
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,0,2,
  3,3,3,3,3,2,1,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,3,3,3,1,3,3,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,2,3,3,3,2,1,3,0,3,1,3,3,2,3,3,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,
  3,3,3,3,3,3,2,3,3,2,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,2,3,3,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,3,3,2,2,3,3,3,3,2,3,0,3,
  3,3,3,3,3,3,3,2,2,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,
  3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,2,3,3,3,2,0,1,3,1,0,1,3,3,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,0,2,3,3,1,2,2,3,1,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,1,0,3,1,2,0,0,3,3,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,2,0,1,0,3,0,0,3,0,1,2,1,0,1,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,1,3,2,2,0,3,3,3,1,0,3,1,1,0,2,2,1,0,2,
  3,3,3,3,3,3,3,3,3,1,3,3,2,3,3,0,0,3,3,3,0,2,2,0,0,0,0,3,0,0,2,
  3,3,3,3,3,3,3,3,3,1,3,3,1,2,1,3,0,1,3,0,0,0,2,0,0,0,0,3,1,0,1,
  3,3,3,2,3,2,3,3,3,0,3,3,1,2,2,1,3,0,2,1,0,0,3,0,2,1,0,0,2,0,1,
  3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,2,0,3,0,2,0,2,3,2,0,0,2,3,0,0,0,
  3,3,3,2,3,3,3,3,3,2,1,2,1,2,2,1,0,3,3,3,1,3,3,1,3,0,1,1,0,0,2,
  3,3,3,3,3,3,3,2,3,2,1,3,3,3,1,1,1,2,2,3,1,3,2,3,0,0,2,1,0,0,1,
  3,3,2,1,3,2,1,3,3,2,3,1,1,0,0,0,1,0,2,1,3,0,2,0,1,0,0,1,0,0,0,
  3,3,3,0,3,2,2,3,3,3,3,0,0,3,3,1,0,0,3,2,0,3,1,0,3,0,0,0,0,0,0,
  3,3,2,3,3,2,3,3,3,2,1,1,1,2,2,0,1,0,1,2,1,0,2,0,1,0,0,1,2,0,2,
  3,3,2,2,3,3,3,3,3,1,3,1,0,3,3,0,0,1,3,2,0,1,1,3,1,0,0,0,0,2,0,
  3,3,2,0,3,0,3,3,3,1,3,1,0,3,0,0,1,0,0,0,0,1,0,0,3,0,0,0,0,0,2,
  3,3,2,1,3,1,1,2,1,0,3,0,2,0,0,0,1,1,0,0,0,0,0,0,0,3,0,0,0,0,0,
  3,3,3,3,3,1,3,3,3,3,3,0,2,1,2,2,1,1,1,1,0,0,3,0,2,0,3,0,0,0,0,
  3,3,3,3,3,1,3,3,3,1,3,3,2,3,3,3,0,0,3,3,0,0,2,1,0,1,1,3,1,0,0,
  3,3,2,3,3,1,3,3,3,2,1,2,3,3,2,2,1,0,0,0,2,0,3,0,0,0,0,1,2,0,2,
  0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,2,2,2,2,2,2,3,2,1,2,1,2,0,0,1,0,1,0,2,0,0,0,2,0,0,0,2,0,1,
};


const SequenceModel Iso_8859_3MalteseModel =
{
  Iso_8859_3_CharToOrderMap,
  MalteseLangModel,
  31,
  (float)0.9990061931763774,
  PR_TRUE,
  "ISO-8859-3",
  "mt"
};

const LanguageModel MalteseModel =
{
  "mt",
  Unicode_CharOrder,
  62,
  MalteseLangModel,
  31,
  4,
  (float)0.4023184608272577,
  23,
  (float)0.030268103128388086,
};
