/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Serbian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-17 22:36:36.029761
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Windows_1251_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 25, 46, 43, 45, 28, 51, 47, 49, 24, 38, 39, 40, 42, 32, 29, /* 4X */
   41, 55, 34, 35, 36, 37, 44, 53, 54, 52, 48,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 25, 46, 43, 45, 28, 51, 47, 49, 24, 38, 39, 40, 42, 32, 29, /* 6X */
   41, 55, 34, 35, 36, 37, 44, 53, 54, 52, 48,SYM,SYM,SYM,SYM,CTR, /* 7X */
   33, 64,SYM, 65,SYM,SYM,SYM,SYM,SYM,SYM, 27,SYM, 23, 66, 26, 50, /* 8X */
   33,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 27,SYM, 23, 67, 26, 50, /* 9X */
  SYM, 68, 69, 11,SYM, 70,SYM,SYM, 71,SYM, 72,SYM,SYM,SYM,SYM, 73, /* AX */
  SYM,SYM, 62, 62, 74,SYM,SYM,SYM, 75,SYM, 76,SYM, 11, 77, 78, 79, /* BX */
    0, 16, 10, 17, 12,  3, 30, 18,  1, 57,  7, 14, 15,  5,  2, 13, /* CX */
    4,  6,  9,  8, 31, 22, 19, 20, 21, 80, 60, 59, 56, 63, 61, 58, /* DX */
    0, 16, 10, 17, 12,  3, 30, 18,  1, 57,  7, 14, 15,  5,  2, 13, /* EX */
    4,  6,  9,  8, 31, 22, 19, 20, 21, 81, 60, 59, 56, 63, 61, 58, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_5_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 25, 46, 43, 45, 28, 51, 47, 49, 24, 38, 39, 40, 42, 32, 29, /* 4X */
   41, 55, 34, 35, 36, 37, 44, 53, 54, 52, 48,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 25, 46, 43, 45, 28, 51, 47, 49, 24, 38, 39, 40, 42, 32, 29, /* 6X */
   41, 55, 34, 35, 36, 37, 44, 53, 54, 52, 48,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 82, 33, 83, 84, 85, 62, 86, 11, 27, 23, 26, 87,SYM, 88, 50, /* AX */
    0, 16, 10, 17, 12,  3, 30, 18,  1, 57,  7, 14, 15,  5,  2, 13, /* BX */
    4,  6,  9,  8, 31, 22, 19, 20, 21, 89, 60, 59, 56, 63, 61, 58, /* CX */
    0, 16, 10, 17, 12,  3, 30, 18,  1, 57,  7, 14, 15,  5,  2, 13, /* DX */
    4,  6,  9,  8, 31, 22, 19, 20, 21, 90, 60, 59, 56, 63, 61, 58, /* EX */
  SYM, 91, 33, 92, 93, 94, 62, 95, 11, 27, 23, 26, 96,SYM, 97, 50, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 102;
static const unsigned int Unicode_CharOrder[] =
{
    65, 25,   66, 46,   67, 43,   68, 45,   69, 28,   71, 47,   72, 49,  73, 24,
    74, 38,   75, 39,   76, 40,   77, 42,   78, 32,   79, 29,   80, 41,  82, 34,
    83, 35,   84, 36,   85, 37,   86, 44,   90, 48,   97, 25,   98, 46,  99, 43,
   100, 45,  101, 28,  103, 47,  104, 49,  105, 24,  106, 38,  107, 39, 108, 40,
   109, 42,  110, 32,  111, 29,  112, 41,  114, 34,  115, 35,  116, 36, 117, 37,
   118, 44,  122, 48, 1026, 33, 1032, 11, 1033, 27, 1034, 23, 1035, 26,1039, 50,
  1040,  0, 1041, 16, 1042, 10, 1043, 17, 1044, 12, 1045,  3, 1046, 30,1047, 18,
  1048,  1, 1050,  7, 1051, 14, 1052, 15, 1053,  5, 1054,  2, 1055, 13,1056,  4,
  1057,  6, 1058,  9, 1059,  8, 1060, 31, 1061, 22, 1062, 19, 1063, 20,1064, 21,
  1072,  0, 1073, 16, 1074, 10, 1075, 17, 1076, 12, 1077,  3, 1078, 30,1079, 18,
  1080,  1, 1082,  7, 1083, 14, 1084, 15, 1085,  5, 1086,  2, 1087, 13,1088,  4,
  1089,  6, 1090,  9, 1091,  8, 1092, 31, 1093, 22, 1094, 19, 1095, 20,1096, 21,
  1106, 33, 1112, 11, 1113, 27, 1114, 23, 1115, 26, 1119, 50,
};


/* Model Table:
 * Total considered sequences: 1174 / 2601
 * - Positive sequences: first 658 (0.9950262953064305)
 * - Probable sequences: next 193 (851-658) (0.0039828494616473975)
 * - Neutral sequences: last 1750 (0.0009908552319221053)
 * - Negative sequences: 1427 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 SerbianLangModel[] =
{
  1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
   0,3,3,0,1,3,3,0,3,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,3,
  3,1,3,2,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
   0,3,3,0,0,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
   0,3,3,0,0,3,3,1,3,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,1,2,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,
   0,3,3,0,0,3,3,0,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
   1,1,1,0,0,3,2,0,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,1,3,3,3,3,3,2,3,3,2,1,3,3,3,3,3,1,2,0,0,
   1,0,1,0,0,3,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,0,3,0,0,2,0,0,
   1,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,3,3,3,2,2,2,3,3,1,1,0,3,1,2,1,3,0,
   1,2,3,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,
   0,3,3,0,0,3,3,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
  3,3,3,3,3,3,3,3,3,1,3,3,2,3,3,2,3,1,2,2,1,0,3,3,0,
   1,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,2,1,3,1,3,2,3,0,1,0,
   0,0,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,2,1,3,3,3,2,2,2,0,
   0,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,3,1,3,1,3,3,0,2,3,3,3,3,3,1,0,1,1,3,0,
   1,0,2,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,2,3,3,3,3,1,1,3,1,1,1,1,2,2,3,1,0,0,
   0,1,3,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
  3,3,3,3,1,3,3,3,3,3,2,0,3,2,1,3,3,2,1,2,2,3,2,1,0,
   0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,2,3,1,1,3,2,3,3,3,3,1,2,3,2,1,0,2,0,
   1,1,3,0,0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,1,3,2,2,3,2,1,3,1,0,1,3,1,1,1,2,1,0,
   0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,1,1,3,2,3,0,3,1,3,2,1,1,2,0,0,1,0,2,0,
   0,0,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,1,1,3,0,3,3,3,1,3,3,3,3,0,0,0,0,0,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,1,1,2,3,1,2,3,0,1,1,1,1,1,0,0,0,0,1,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,0,3,1,3,3,0,2,3,0,0,3,1,0,1,0,2,0,0,0,1,0,
   0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,0,3,3,3,3,2,1,3,3,1,1,0,0,2,2,1,0,3,0,
   0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,1,3,3,3,1,2,0,2,2,1,0,0,0,0,1,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,0,0,3,1,3,0,0,0,1,0,0,0,0,0,0,2,1,1,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,2,3,0,0,3,0,3,3,3,1,3,3,3,2,3,3,3,3,2,3,3,3,0,
  0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
   1,0,1,3,3,0,0,3,0,3,3,3,2,3,3,3,3,3,3,3,3,2,3,3,1,0,
  3,3,3,3,0,3,0,3,3,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,0,3,3,3,3,2,0,0,1,0,0,0,2,0,0,2,1,2,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,
   3,1,0,2,2,0,0,3,0,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
   1,0,0,0,2,0,0,3,0,3,3,3,2,3,3,3,3,3,3,3,3,3,3,2,1,0,
  3,3,3,3,2,3,0,0,3,0,1,3,3,0,0,1,3,0,0,0,0,0,0,3,0,
   0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,2,3,1,3,2,0,1,0,0,3,1,1,0,0,1,0,1,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,2,0,1,3,3,3,3,2,1,1,1,3,0,3,1,3,2,0,0,
  3,3,3,3,0,0,2,0,3,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,3,0,2,3,3,3,1,2,2,3,3,3,3,2,2,3,2,1,0,
  0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,3,0,3,2,3,3,1,3,3,3,2,2,3,1,3,1,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,3,
   3,0,0,3,3,0,0,2,0,3,3,2,3,1,2,2,1,1,1,3,1,1,0,1,3,0,
  0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
   2,0,0,2,1,0,0,3,0,3,3,3,0,3,3,3,3,3,2,1,3,3,3,2,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,3,0,0,3,1,3,0,2,1,0,1,2,1,1,1,0,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,2,0,3,2,3,3,0,1,3,0,3,2,1,0,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,3,0,0,2,2,3,3,2,3,0,0,1,1,1,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
   3,0,0,3,3,0,0,2,0,3,3,2,3,1,1,3,2,0,1,0,2,0,0,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,1,0,2,1,1,2,1,0,2,2,3,1,0,1,2,1,0,0,0,
  0,0,0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,0,0,2,1,3,3,1,3,2,0,1,2,1,0,0,1,2,3,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,3,0,3,2,0,3,1,1,3,1,1,1,0,1,0,1,1,0,0,
  0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,3,0,3,2,0,3,2,0,2,0,2,1,2,0,2,2,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,3,0,3,1,0,3,2,0,3,0,0,0,0,0,1,1,1,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,2,0,3,1,1,3,0,0,3,0,0,0,1,1,0,0,1,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,2,3,0,0,2,0,1,1,0,2,1,0,2,0,2,0,3,1,3,1,0,0,0,
  0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,
   3,0,0,3,3,0,0,2,0,3,0,1,2,0,0,1,0,0,0,2,0,1,0,0,0,0,
  3,3,3,3,0,0,0,0,2,0,1,0,0,0,0,0,3,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Windows_1251SerbianModel =
{
  Windows_1251_CharToOrderMap,
  SerbianLangModel,
  51,
  (float)0.9990091447680779,
  PR_FALSE,
  "WINDOWS-1251",
  "sr"
};

const SequenceModel Iso_8859_5SerbianModel =
{
  Iso_8859_5_CharToOrderMap,
  SerbianLangModel,
  51,
  (float)0.9990091447680779,
  PR_FALSE,
  "ISO-8859-5",
  "sr"
};

const LanguageModel SerbianModel =
{
  "sr",
  Unicode_CharOrder,
  102,
  SerbianLangModel,
  51,
  5,
  (float)0.43028847594635256,
  31,
  (float)0.03130000978968167,
};
