/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Turkish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:26:41.275230
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_3_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 15, 23,  8,  1, 27, 19, 21,  6, 28,  7,  5, 11,  3, 14, /* 4X */
   24, 34,  4, 10,  9, 12, 18, 29, 32, 13, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 15, 23,  8,  1, 27, 19, 21,  2, 28,  7,  5, 11,  3, 14, /* 6X */
   24, 34,  4, 10,  9, 12, 18, 29, 32, 13, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 53,SYM,SYM,SYM,ILL, 54,SYM,SYM,  2, 17, 25, 55,SYM,ILL, 50, /* AX */
  SYM, 56,SYM,SYM,SYM,SYM, 57,SYM,SYM,  6, 17, 25, 58,SYM,ILL, 50, /* BX */
   45, 38, 30,ILL, 43, 59, 60, 22, 36, 35, 61, 62, 44, 37, 31, 63, /* CX */
  ILL, 42, 48, 41, 47, 64, 26,SYM, 65, 49, 40, 33, 16, 66, 67, 52, /* DX */
   45, 38, 30,ILL, 43, 68, 69, 22, 36, 35, 70, 71, 44, 37, 31, 72, /* EX */
  ILL, 42, 48, 41, 47, 73, 26,SYM, 74, 49, 40, 33, 16, 75, 76,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 15, 23,  8,  1, 27, 19, 21,  6, 28,  7,  5, 11,  3, 14, /* 4X */
   24, 34,  4, 10,  9, 12, 18, 29, 32, 13, 20,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 15, 23,  8,  1, 27, 19, 21,  2, 28,  7,  5, 11,  3, 14, /* 6X */
   24, 34,  4, 10,  9, 12, 18, 29, 32, 13, 20,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 77,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   45, 38, 30, 51, 43, 78, 39, 22, 36, 35, 79, 80, 44, 37, 31, 81, /* CX */
   25, 42, 48, 41, 47, 82, 26,SYM, 46, 49, 40, 33, 16,  2, 17, 52, /* DX */
   45, 38, 30, 51, 43, 83, 39, 22, 36, 35, 84, 85, 44, 37, 31, 86, /* EX */
   25, 42, 48, 41, 47, 87, 26,SYM, 46, 49, 40, 33, 16,  6, 17, 88, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 68;
static const unsigned int Unicode_CharOrder[] =
{
   65,  0,  66, 15,  67, 23,  68,  8,  69,  1,  70, 27,  71, 19, 72, 21,
   73,  2,  73,  6,  74, 28,  75,  7,  76,  5,  77, 11,  78,  3, 79, 14,
   80, 24,  82,  4,  83, 10,  84,  9,  85, 12,  86, 18,  87, 29, 88, 32,
   89, 13,  90, 20,  97,  0,  98, 15,  99, 23, 100,  8, 101,  1,102, 27,
  103, 19, 104, 21, 105,  2, 106, 28, 107,  7, 108,  5, 109, 11,110,  3,
  111, 14, 112, 24, 114,  4, 115, 10, 116,  9, 117, 12, 118, 18,119, 29,
  120, 32, 121, 13, 122, 20, 194, 30, 199, 22, 206, 31, 214, 26,219, 33,
  220, 16, 226, 30, 231, 22, 238, 31, 246, 26, 251, 33, 252, 16,286, 25,
  287, 25, 305,  6, 350, 17, 351, 17,
};


/* Model Table:
 * Total considered sequences: 1018 / 1156
 * - Positive sequences: first 535 (0.995041989262771)
 * - Probable sequences: next 164 (699-535) (0.003962858701427208)
 * - Neutral sequences: last 457 (0.0009951520358018051)
 * - Negative sequences: 138 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 TurkishLangModel[] =
{
  3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,1,3,3,2,1,1,2,0,
  3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,3,3,3,0,0,3,0,
  3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,1,3,3,1,1,0,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,0,2,3,2,2,1,2,1,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,3,3,1,1,3,1,1,
  3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,3,3,2,0,2,3,2,1,3,3,0,1,
  2,1,0,3,3,3,3,3,3,3,3,3,2,3,2,3,0,3,3,1,3,2,3,3,3,3,0,3,0,0,0,0,1,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,1,2,3,2,1,0,3,2,1,1,3,1,0,3,
  3,3,3,2,3,3,3,1,3,2,3,2,3,3,3,2,3,0,2,2,1,2,0,2,1,0,3,1,1,2,2,1,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,0,3,2,2,3,3,3,1,0,3,3,1,2,1,1,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,0,2,2,1,3,3,3,3,0,3,3,0,2,1,1,0,0,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,3,3,1,3,3,0,3,2,1,2,2,3,1,1,
  3,3,3,3,3,3,0,3,3,3,3,3,2,3,2,3,0,3,3,3,3,3,3,3,3,3,0,3,1,0,0,0,2,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,1,3,3,2,2,1,3,2,0,3,2,0,1,1,0,2,1,
  2,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,2,3,3,3,0,3,3,3,0,0,2,0,
  3,3,3,2,3,3,3,1,3,1,2,3,3,2,3,2,3,1,1,1,2,1,0,2,1,0,3,0,1,2,2,1,0,1,
  1,2,1,3,3,3,0,3,3,3,3,3,0,3,1,3,1,3,3,1,3,2,3,3,3,3,1,3,1,0,0,0,1,0,
  3,3,3,2,3,3,3,3,1,3,2,3,3,2,2,2,3,0,3,3,1,2,3,1,1,0,2,2,0,0,1,0,0,1,
  3,3,3,2,3,3,3,2,3,0,3,2,3,3,3,2,2,2,3,2,2,2,0,3,0,0,0,1,1,0,1,1,0,0,
  3,3,3,3,3,3,3,1,2,2,3,2,3,2,3,1,3,0,1,2,2,3,0,0,1,0,3,1,1,1,2,0,1,0,
  3,3,3,2,1,3,3,2,3,2,2,3,3,3,3,2,3,0,1,3,2,3,0,3,1,0,2,0,0,0,1,1,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,2,3,0,2,2,3,1,2,0,2,1,0,1,3,2,0,0,
  3,3,3,0,2,3,3,2,1,3,2,3,3,2,3,2,3,0,0,1,0,1,0,0,0,0,3,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,2,2,3,2,3,2,3,0,1,1,1,3,0,3,1,0,0,2,0,0,0,0,0,0,
  3,3,3,1,3,3,3,3,1,3,3,3,3,2,3,1,3,0,0,1,1,3,3,1,2,0,1,1,1,1,1,0,0,0,
  3,3,3,1,3,3,3,1,3,0,1,3,3,0,2,1,3,0,0,0,2,1,0,1,0,0,0,0,0,0,0,0,0,0,
  0,1,1,3,3,3,0,3,3,3,3,3,0,3,0,1,0,2,2,2,3,1,3,1,3,3,0,1,0,0,0,0,0,0,
  3,3,3,2,3,3,3,2,1,3,2,1,3,3,3,1,2,2,0,1,1,1,1,2,1,0,1,3,0,1,0,1,0,0,
  3,3,3,2,1,2,2,1,2,0,1,1,3,0,3,0,2,0,0,1,1,0,0,1,1,0,1,1,0,1,0,0,0,0,
  3,3,3,2,2,1,1,1,1,1,2,1,1,1,3,1,0,1,0,0,0,2,0,1,0,0,0,0,0,1,0,0,0,0,
  0,0,1,3,3,3,0,3,2,2,1,2,0,2,0,2,0,2,1,1,2,2,0,0,0,2,0,1,0,0,0,0,0,0,
  0,0,0,0,1,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,1,2,0,0,1,2,0,0,1,1,0,1,0,1,0,0,0,1,0,0,0,0,1,2,0,0,1,0,0,0,0,1,0,
  1,0,0,1,1,1,0,1,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_3TurkishModel =
{
  Iso_8859_3_CharToOrderMap,
  TurkishLangModel,
  34,
  (float)0.9990048479641982,
  PR_FALSE,
  "ISO-8859-3",
  "tr"
};

const SequenceModel Iso_8859_9TurkishModel =
{
  Iso_8859_9_CharToOrderMap,
  TurkishLangModel,
  34,
  (float)0.9990048479641982,
  PR_FALSE,
  "ISO-8859-9",
  "tr"
};

const LanguageModel TurkishModel =
{
  "tr",
  Unicode_CharOrder,
  68,
  TurkishLangModel,
  34,
  5,
  (float)0.4444901594335149,
  23,
  (float)0.03317779168044757,
};
