/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Ukrainian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-17 18:48:43.498701
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Windows_1251_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 33, 45, 40, 44, 31, 52, 51, 41, 32, 58, 48, 42, 43, 35, 39, /* 4X */
   49, 60, 36, 37, 38, 46, 53, 47, 54, 50, 56,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 33, 45, 40, 44, 31, 52, 51, 41, 32, 58, 48, 42, 43, 35, 39, /* 6X */
   49, 60, 36, 37, 38, 46, 53, 47, 54, 50, 56,SYM,SYM,SYM,SYM,CTR, /* 7X */
   67, 70,SYM, 71,SYM,SYM,SYM,SYM,SYM,SYM, 68,SYM, 66, 72, 65, 69, /* 8X */
   67,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 68,SYM, 66, 73, 65, 69, /* 9X */
  SYM, 64, 64, 63,SYM, 57,SYM,SYM, 61,SYM, 30,SYM,SYM,SYM,SYM, 25, /* AX */
  SYM,SYM,  3,  3, 57,SYM,SYM,SYM, 61,SYM, 30,SYM, 63, 74, 75, 25, /* BX */
    1, 20,  6, 19, 13,  8, 27, 17,  5, 21, 10, 11, 15,  2,  0, 14, /* CX */
    4,  9,  7, 12, 29, 23, 24, 22, 28, 34, 62, 55, 18, 59, 26, 16, /* DX */
    1, 20,  6, 19, 13,  8, 27, 17,  5, 21, 10, 11, 15,  2,  0, 14, /* EX */
    4,  9,  7, 12, 29, 23, 24, 22, 28, 34, 62, 55, 18, 59, 26, 16, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 116;
static const unsigned int Unicode_CharOrder[] =
{
    65, 33,   66, 45,   67, 40,   68, 44,   69, 31,   70, 52,   71, 51,  72, 41,
    73, 32,   75, 48,   76, 42,   77, 43,   78, 35,   79, 39,   80, 49,  82, 36,
    83, 37,   84, 38,   85, 46,   86, 53,   87, 47,   88, 54,   89, 50,  90, 56,
    97, 33,   98, 45,   99, 40,  100, 44,  101, 31,  102, 52,  103, 51, 104, 41,
   105, 32,  107, 48,  108, 42,  109, 43,  110, 35,  111, 39,  112, 49, 114, 36,
   115, 37,  116, 38,  117, 46,  118, 53,  119, 47,  120, 54,  121, 50, 122, 56,
  1028, 30, 1030,  3, 1031, 25, 1040,  1, 1041, 20, 1042,  6, 1043, 19,1044, 13,
  1045,  8, 1046, 27, 1047, 17, 1048,  5, 1049, 21, 1050, 10, 1051, 11,1052, 15,
  1053,  2, 1054,  0, 1055, 14, 1056,  4, 1057,  9, 1058,  7, 1059, 12,1060, 29,
  1061, 23, 1062, 24, 1063, 22, 1064, 28, 1065, 34, 1067, 55, 1068, 18,1070, 26,
  1071, 16, 1072,  1, 1073, 20, 1074,  6, 1075, 19, 1076, 13, 1077,  8,1078, 27,
  1079, 17, 1080,  5, 1081, 21, 1082, 10, 1083, 11, 1084, 15, 1085,  2,1086,  0,
  1087, 14, 1088,  4, 1089,  9, 1090,  7, 1091, 12, 1092, 29, 1093, 23,1094, 24,
  1095, 22, 1096, 28, 1097, 34, 1099, 55, 1100, 18, 1102, 26, 1103, 16,1108, 30,
  1110,  3, 1111, 25, 1168, 57, 1169, 57,
};


/* Model Table:
 * Total considered sequences: 1538 / 3364
 * - Positive sequences: first 818 (0.9950006474582738)
 * - Probable sequences: next 269 (1087-818) (0.004005190805257075)
 * - Neutral sequences: last 2277 (0.0009941617364691568)
 * - Negative sequences: 1826 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 UkrainianLangModel[] =
{
  3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,1,3,1,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,1,3,3,3,1,3,3,3,
   3,3,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,2,
  3,3,3,2,3,0,3,3,2,3,3,3,2,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,
   3,2,0,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,2,
  2,2,3,1,3,3,3,3,3,3,3,3,2,3,3,3,3,3,0,3,3,3,3,3,3,3,2,3,3,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,1,3,3,3,1,1,3,3,
   0,2,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,3,3,1,3,2,3,0,3,2,2,0,3,2,2,
   3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,
  3,3,3,1,3,1,3,3,2,3,3,3,2,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,3,1,2,0,2,3,3,0,3,0,3,
   3,2,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,1,2,1,3,2,0,1,2,3,0,2,0,2,
   1,0,0,0,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,2,3,3,2,3,3,3,3,2,3,3,2,3,3,2,0,2,2,1,0,3,3,1,
   2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
  2,3,3,1,3,1,3,3,3,3,3,3,1,3,3,3,2,3,0,3,3,3,3,3,3,3,3,3,3,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,1,2,3,3,
   1,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,1,
  3,3,3,3,3,3,1,3,3,3,2,3,3,2,3,1,1,1,1,2,2,0,2,1,3,0,1,0,2,
   2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
  3,3,3,3,2,3,3,2,3,3,3,3,3,2,3,3,2,2,1,1,3,1,3,0,3,0,3,1,3,
   2,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,
  1,1,3,1,3,0,3,3,1,3,3,3,1,3,3,3,1,3,0,3,2,1,3,3,3,1,3,3,1,
   1,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,1,2,1,2,0,2,1,3,
   2,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,
  3,1,3,0,2,1,3,3,2,3,3,0,0,3,3,3,3,2,0,3,3,3,3,1,3,2,3,0,3,
   3,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,0,1,0,2,2,0,1,1,0,0,2,1,2,
   1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,3,3,3,3,2,1,3,1,2,0,3,3,0,3,3,2,1,3,0,2,
   1,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,
  3,1,3,1,3,0,3,3,1,3,3,3,1,3,3,3,1,3,0,2,3,0,2,3,3,1,1,3,3,
   2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,1,3,1,1,3,1,3,3,3,0,1,2,2,0,1,0,0,0,3,0,2,0,1,2,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,1,3,3,1,1,2,0,0,1,1,2,0,1,2,0,0,1,0,1,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,0,3,2,3,3,1,2,2,3,2,1,1,3,2,3,1,1,0,0,0,1,0,3,0,1,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
  0,0,3,1,2,0,3,2,0,2,2,3,0,2,0,3,0,3,0,0,0,3,1,3,1,3,0,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,3,0,3,0,3,3,2,3,3,2,1,3,1,2,0,3,0,3,3,1,3,2,3,1,3,2,1,
   2,3,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,
  3,3,3,3,1,3,2,1,3,1,3,3,3,3,1,2,3,0,1,1,3,0,3,1,2,0,1,3,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,3,3,3,1,3,3,3,0,3,1,1,1,0,0,1,0,0,1,1,0,1,0,1,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,1,3,3,3,1,3,3,3,1,3,3,0,0,1,1,0,1,2,0,0,0,0,0,0,2,0,1,
   3,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,0,3,0,3,3,1,3,3,3,0,3,3,3,0,3,0,3,1,1,2,1,1,3,3,1,1,
   2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,3,3,3,3,3,3,2,3,3,3,2,3,3,2,2,2,3,3,2,2,0,1,0,
  0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,3,3,3,3,3,3,2,3,3,3,2,2,0,3,3,1,3,2,3,2,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,3,2,0,3,3,3,3,1,3,2,3,3,3,3,3,2,2,3,3,3,2,3,2,0,2,0,
  3,3,2,3,0,3,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,3,2,3,3,3,3,1,1,1,3,2,3,2,3,1,2,3,3,2,0,0,2,0,
  0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,3,3,3,3,3,3,2,3,3,3,3,3,1,3,2,3,3,2,2,1,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,1,1,3,3,3,3,3,2,2,1,3,3,2,3,3,2,2,1,1,0,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
   0,0,3,3,3,0,2,3,3,3,3,1,3,3,2,2,2,3,2,1,2,3,1,1,2,1,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,2,2,0,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,2,2,3,3,2,0,2,0,
  0,1,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,0,3,2,3,3,2,3,3,1,1,1,2,0,3,0,2,1,1,1,0,0,2,0,
  0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,3,3,2,3,3,0,0,2,2,2,1,3,1,0,1,2,1,0,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,2,1,3,3,3,2,2,3,2,3,2,3,1,2,1,2,1,2,1,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,1,1,2,1,3,1,0,1,3,1,3,2,1,1,3,2,1,1,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,1,2,2,1,3,1,1,1,2,1,1,3,2,1,2,1,2,2,1,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,3,3,2,1,3,2,1,3,1,1,2,3,0,1,0,2,1,0,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,2,3,0,3,3,3,3,1,3,1,3,3,2,3,1,1,2,2,1,2,2,1,1,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,2,1,2,1,3,1,2,1,1,1,1,1,2,1,0,1,1,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,1,3,2,2,3,0,1,2,1,0,1,2,0,1,1,1,1,1,1,0,0,0,0,
  1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,2,3,0,0,3,2,2,3,1,3,3,1,1,1,3,0,1,2,1,1,1,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,2,1,2,0,1,1,2,1,2,2,1,1,1,2,3,1,0,1,1,1,0,0,1,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,2,3,2,1,2,0,2,2,1,1,1,2,1,0,1,1,1,1,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,1,3,1,2,3,0,1,2,1,0,1,2,1,0,1,1,1,3,0,0,0,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,3,0,2,1,1,1,3,1,0,1,0,1,0,2,0,0,1,1,0,0,1,1,0,0,0,
  0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,1,3,1,0,0,0,0,2,1,1,0,0,0,1,1,0,0,0,2,1,0,1,3,3,0,0,0,
  0,0,1,0,0,0,1,1,3,1,1,2,0,0,1,1,0,0,0,0,1,2,1,3,0,0,0,0,1,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,3,3,2,0,1,0,0,1,1,0,1,0,0,0,1,2,2,2,1,1,0,0,0,0,0,1,0,
  2,2,1,2,3,1,1,1,2,1,0,1,2,1,0,1,0,0,0,0,1,0,0,0,0,0,1,0,0,
   1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Windows_1251UkrainianModel =
{
  Windows_1251_CharToOrderMap,
  UkrainianLangModel,
  58,
  (float)0.9990058382635308,
  PR_FALSE,
  "WINDOWS-1251",
  "uk"
};

const LanguageModel UkrainianModel =
{
  "uk",
  Unicode_CharOrder,
  116,
  UkrainianLangModel,
  58,
  6,
  (float)0.4174821808378726,
  30,
  (float)0.032775587966704496,
};
