/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"
#include "../nsSBCharSetProber-generated.h"
#include "../nsLanguageDetector.h"
#include "../nsLanguageDetector-generated.h"

/********* Language model for: Vietnamese *********/

/**
 * Generated by BuildLangModel.py
 * On: 2022-12-15 00:50:53.989529
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Windows_1258_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  6, 19,  3, 22, 23, 68,  5,  1,  4, 75, 21, 14, 10,  0,  9, /* 4X */
   15, 34, 12, 18,  2,  7, 13, 73, 50, 20, 82,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  6, 19,  3, 22, 23, 68,  5,  1,  4, 75, 21, 14, 10,  0,  9, /* 6X */
   15, 34, 12, 18,  2,  7, 13, 73, 50, 20, 82,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,107,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 99,ILL,ILL,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, 99,ILL,ILL,104, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,108,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   11, 16, 26, 47,105,106, 98, 92, 85, 72, 31,100,SYM, 41,101, 96, /* CX */
    8,103,SYM, 33, 30, 48, 95,SYM, 94, 60, 62,102, 97, 17,SYM,109, /* DX */
   11, 16, 26, 47,105,106, 98, 92, 85, 72, 31,100,SYM, 41,101, 96, /* EX */
    8,103,SYM, 33, 30, 48, 95,SYM, 94, 60, 62,102, 97, 17,110,104, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Viscii_CharToOrderMap[] =
{
  CTR,CTR, 86,CTR,CTR, 91, 76,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR, 81,CTR,CTR,CTR,CTR, 84,CTR,CTR,CTR,CTR, 93,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  6, 19,  3, 22, 23, 68,  5,  1,  4, 75, 21, 14, 10,  0,  9, /* 4X */
   15, 34, 12, 18,  2,  7, 13, 73, 50, 20, 82,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  6, 19,  3, 22, 23, 68,  5,  1,  4, 75, 21, 14, 10,  0,  9, /* 6X */
   15, 34, 12, 18,  2,  7, 13, 73, 50, 20, 82,SYM,SYM,SYM,SYM,CTR, /* 7X */
   29, 61, 67, 63, 42, 49, 78, 45, 80, 88, 24, 40, 44, 77, 27, 28, /* 8X */
   57, 59, 83, 25, 39, 36, 38, 52, 43, 74, 55, 69, 32, 70, 56, 79, /* 9X */
   89, 61, 67, 63, 42, 49, 78, 45, 80, 88, 24, 40, 44, 77, 27, 28, /* AX */
   57, 59, 83, 90, 48, 25, 38, 52, 43, 46, 54, 58, 65, 48, 36, 17, /* BX */
   11, 16, 26, 51, 35, 47, 86, 91, 85, 72, 31, 87, 53, 41, 66, 79, /* CX */
    8, 54, 64, 33, 30, 29, 81, 58, 65, 60, 62, 84, 93, 71, 90, 17, /* DX */
   11, 16, 26, 51, 35, 47, 37, 76, 85, 72, 31, 87, 53, 41, 66, 69, /* EX */
    8, 46, 64, 33, 30, 89, 74, 55, 56, 60, 62, 70, 32, 71, 39, 37, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const int Unicode_Char_size = 188;
static const unsigned int Unicode_CharOrder[] =
{
    65,  6,   66, 19,   67,  3,   68, 22,   69, 23,   70, 68,   71,  5,  72,  1,
    73,  4,   74, 75,   75, 21,   76, 14,   77, 10,   78,  0,   79,  9,  80, 15,
    81, 34,   82, 12,   83, 18,   84,  2,   85,  7,   86, 13,   87, 73,  88, 50,
    89, 20,   90, 82,   97,  6,   98, 19,   99,  3,  100, 22,  101, 23, 102, 68,
   103,  5,  104,  1,  105,  4,  106, 75,  107, 21,  108, 14,  109, 10, 110,  0,
   111,  9,  112, 15,  113, 34,  114, 12,  115, 18,  116,  2,  117,  7, 118, 13,
   119, 73,  120, 50,  121, 20,  122, 82,  192, 11,  193, 16,  194, 26, 195, 51,
   199, 92,  200, 85,  201, 72,  202, 31,  204, 53,  205, 41,  210, 64, 211, 33,
   212, 30,  213, 89,  217, 60,  218, 62,  221, 71,  224, 11,  225, 16, 226, 26,
   227, 51,  231, 92,  232, 85,  233, 72,  234, 31,  236, 53,  237, 41, 242, 64,
   243, 33,  244, 30,  245, 89,  249, 60,  250, 62,  253, 71,  258, 47, 259, 47,
   272,  8,  273,  8,  296, 66,  297, 66,  360, 70,  361, 70,  416, 48, 417, 48,
   431, 17,  432, 17, 7840, 29, 7841, 29, 7842, 35, 7843, 35, 7844, 42,7845, 42,
  7846, 49, 7847, 49, 7848, 78, 7849, 78, 7850, 76, 7851, 76, 7852, 45,7853, 45,
  7854, 61, 7855, 61, 7856, 67, 7857, 67, 7858, 86, 7859, 86, 7860, 91,7861, 91,
  7862, 63, 7863, 63, 7864, 88, 7865, 88, 7866, 87, 7867, 87, 7868, 80,7869, 80,
  7870, 24, 7871, 24, 7872, 40, 7873, 40, 7874, 44, 7875, 44, 7876, 77,7877, 77,
  7878, 27, 7879, 27, 7880, 69, 7881, 69, 7882, 43, 7883, 43, 7884, 55,7885, 55,
  7886, 74, 7887, 74, 7888, 28, 7889, 28, 7890, 57, 7891, 57, 7892, 59,7893, 59,
  7894, 83, 7895, 83, 7896, 25, 7897, 25, 7898, 36, 7899, 36, 7900, 38,7901, 38,
  7902, 52, 7903, 52, 7904, 90, 7905, 90, 7906, 39, 7907, 39, 7908, 56,7909, 56,
  7910, 32, 7911, 32, 7912, 54, 7913, 54, 7914, 58, 7915, 58, 7916, 65,7917, 65,
  7918, 37, 7919, 37, 7920, 46, 7921, 46, 7922, 79, 7923, 79, 7924, 93,7925, 93,
  7926, 81, 7927, 81, 7928, 84, 7929, 84,
};


/* Model Table:
 * Total considered sequences: 1992 / 8836
 * - Positive sequences: first 1145 (0.9950096057827752)
 * - Probable sequences: next 346 (1491-1145) (0.003994365518613985)
 * - Neutral sequences: last 7345 (0.000996028698610818)
 * - Negative sequences: 6844 (off-ratio)
 * Negative sequences: TODO
 */
static const PRUint8 VietnameseLangModel[] =
{
  3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,2,2,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,0,3,2,2,2,3,0,2,3,2,3,1,1,1,1,
   3,3,2,1,2,2,0,1,2,1,2,0,3,1,3,3,3,1,3,0,3,3,0,0,0,3,3,1,2,0,0,1,0,0,0,2,3,0,3,0,1,0,0,0,2,3,0,
  3,0,3,2,3,1,3,3,1,3,3,3,3,1,2,2,3,3,3,1,3,2,3,3,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,
   3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,0,3,2,3,1,2,1,3,0,3,2,1,3,0,3,3,2,3,1,0,1,0,0,
  3,3,3,3,3,2,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,3,3,2,3,0,3,3,0,3,1,2,3,3,3,1,3,3,
   3,2,3,1,2,1,3,3,2,3,3,3,3,3,3,3,3,3,3,2,1,2,3,0,1,3,3,3,1,0,1,2,1,0,3,3,0,0,2,0,2,1,0,0,0,0,1,
  3,3,3,3,3,1,3,3,1,3,3,3,3,1,3,2,3,3,3,3,3,3,2,3,0,3,3,0,3,3,3,0,3,3,3,3,1,0,3,0,0,0,3,0,0,3,3,
   3,3,3,1,3,1,0,3,2,3,2,2,3,3,3,3,3,3,3,0,2,2,0,3,0,3,3,3,1,1,0,3,0,0,0,1,1,0,1,0,0,0,2,2,0,0,0,
  3,2,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,2,3,3,2,3,3,3,3,0,2,3,3,0,1,3,0,3,3,3,3,3,3,0,3,0,3,0,3,2,0,
   1,1,0,3,2,0,0,0,3,1,1,0,0,0,0,3,2,0,0,0,2,3,0,1,0,2,2,2,3,1,3,0,0,1,0,3,1,0,3,0,1,1,0,1,0,0,0,
  3,3,3,2,3,2,3,3,1,3,2,3,3,1,3,2,3,3,3,3,3,3,3,3,2,2,3,0,3,3,3,2,3,3,2,1,1,3,2,3,0,0,2,2,0,3,3,
   3,2,3,1,3,0,3,0,3,3,3,3,1,1,3,1,3,3,3,0,1,1,0,3,0,3,1,1,1,2,0,0,0,0,0,2,3,0,2,0,0,0,2,2,0,0,1,
  3,3,3,3,3,3,3,3,0,3,3,0,3,3,3,3,0,0,3,3,3,3,3,3,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,1,0,0,0,
   0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,1,3,0,3,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,3,3,3,3,1,0,2,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,1,1,3,1,0,1,0,1,1,3,0,0,3,0,
   2,2,3,3,2,2,0,0,1,0,3,0,3,0,0,0,2,1,0,0,0,3,0,0,3,2,1,0,2,2,0,3,3,0,2,3,2,3,0,0,0,1,0,0,0,1,3,
  0,0,1,0,3,0,3,3,0,3,0,3,1,0,0,0,3,3,0,1,0,0,0,3,3,3,3,3,3,3,3,3,3,3,0,3,3,0,3,3,3,3,3,3,3,3,2,
   3,3,3,0,3,0,3,3,3,2,3,2,3,1,3,3,3,3,0,3,2,0,3,1,0,2,0,3,0,1,1,3,0,0,0,0,3,0,2,3,2,3,0,3,0,0,0,
  3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,0,0,0,0,0,3,0,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,
   3,0,0,3,2,0,0,0,1,0,0,0,0,0,2,0,3,1,0,0,1,3,0,0,0,1,3,0,2,0,0,0,0,0,0,2,0,0,2,0,1,1,0,0,1,0,0,
  3,1,2,2,3,1,3,3,0,3,3,3,2,1,2,3,3,3,3,3,3,1,2,3,2,3,3,3,3,3,3,3,1,3,1,2,3,0,3,0,3,2,3,1,0,3,3,
   2,2,2,1,3,3,3,3,3,3,2,2,0,3,3,2,3,2,0,3,1,2,2,3,0,3,2,3,1,3,1,1,0,3,0,0,3,3,2,0,1,3,1,2,0,0,0,
  3,0,0,0,3,1,0,3,0,3,3,0,0,0,1,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,1,2,3,1,3,3,3,0,3,3,3,1,3,3,
   3,3,3,2,3,3,3,2,3,3,3,3,2,3,3,3,2,3,2,0,3,2,1,2,0,3,1,1,1,2,2,1,0,3,0,2,2,0,2,0,3,0,3,2,0,0,0,
  2,1,2,1,3,1,3,3,0,3,1,3,2,2,2,1,2,3,2,1,2,2,2,3,2,1,3,3,3,3,3,2,0,2,1,2,3,3,2,3,3,3,3,3,1,3,3,
   3,2,3,0,2,2,3,1,3,3,0,3,1,3,3,2,0,3,0,3,1,1,1,3,0,2,0,2,0,3,0,0,0,2,0,0,1,1,1,0,3,2,3,2,0,0,0,
  2,3,3,3,3,3,3,3,0,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,1,3,3,3,3,3,3,3,0,2,1,1,3,2,3,3,2,3,3,3,0,3,3,
   3,2,3,1,3,0,1,1,3,3,2,2,1,3,3,3,3,3,3,3,2,3,0,3,3,3,1,2,2,3,3,2,0,3,0,1,3,0,2,0,3,1,3,0,0,0,2,
  2,3,3,2,3,1,3,3,0,3,3,0,3,0,3,3,1,0,3,2,3,1,2,3,0,0,1,0,0,0,2,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
   1,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,3,1,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,3,0,3,3,0,1,0,0,3,0,0,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,2,2,0,3,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,3,3,0,0,0,0,0,0,0,
   0,3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,
  3,3,3,3,3,2,3,3,1,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,0,2,3,0,3,3,3,1,1,3,3,3,3,2,1,3,0,3,2,0,1,1,3,
   3,3,2,1,0,3,1,3,1,3,1,1,2,2,3,3,1,1,3,3,0,2,2,0,0,3,3,2,1,0,0,1,0,3,0,1,0,2,1,0,3,0,0,1,3,0,0,
  3,2,2,3,3,1,3,3,0,3,2,3,3,1,3,1,3,3,3,3,3,1,2,3,3,3,3,3,3,3,2,3,1,3,0,3,2,3,3,1,3,3,3,3,2,3,1,
   3,2,3,0,3,3,3,3,3,2,3,1,3,3,3,2,0,3,2,0,3,2,3,0,0,3,1,3,1,1,1,2,0,0,0,0,1,0,3,0,1,2,0,0,0,0,0,
  3,0,3,3,3,1,3,3,0,3,3,1,3,2,3,3,0,0,3,3,1,2,2,3,3,0,0,3,0,0,0,3,0,0,0,0,0,0,0,0,3,0,0,0,3,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,2,0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,
  2,3,2,1,3,1,3,3,0,3,3,1,3,2,3,1,2,0,3,2,3,2,0,3,3,0,0,0,0,1,3,3,0,0,0,0,0,0,0,0,2,3,0,3,3,0,0,
   0,0,0,1,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,3,0,3,3,2,0,1,0,0,0,3,1,3,1,0,3,3,0,3,2,0,0,0,0,2,
  2,3,3,3,3,3,3,3,0,3,2,3,3,2,2,3,3,3,3,2,3,2,3,3,0,2,3,2,2,3,1,2,0,1,0,2,0,3,2,0,2,1,3,3,0,3,3,
   1,1,3,0,3,1,2,3,3,3,2,2,0,3,1,0,2,3,1,2,1,2,0,2,0,3,3,0,1,3,3,0,0,0,0,1,1,0,2,2,2,2,2,1,0,0,0,
  3,3,3,3,3,3,3,3,0,3,3,0,3,3,3,3,0,0,3,3,3,3,3,3,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,3,0,1,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,0,0,0,3,0,0,3,0,0,0,0,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,1,0,0,2,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,1,0,0,0,3,0,0,3,0,1,0,1,1,0,1,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,1,0,0,3,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,0,0,0,2,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,0,0,3,3,0,0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,2,3,1,0,1,0,0,3,0,1,0,1,2,0,0,1,0,0,1,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,2,1,0,0,3,1,0,3,0,1,1,0,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,1,1,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,3,0,0,0,3,0,1,0,0,3,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,0,2,0,2,3,2,1,0,0,2,0,3,0,0,0,1,0,0,0,1,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,
   0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,1,0,3,3,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,1,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,0,3,0,0,2,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,0,0,3,2,0,0,3,0,0,0,1,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,2,2,0,0,3,0,0,3,0,0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,0,0,3,3,0,0,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,0,0,0,3,0,0,3,0,0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,3,0,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,2,0,0,0,0,0,0,3,0,1,0,0,1,0,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,1,3,0,0,2,0,0,3,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,3,2,3,0,3,3,0,3,1,1,1,3,1,2,3,3,1,0,2,0,0,3,3,1,3,0,2,2,3,2,0,3,0,3,1,0,0,0,0,3,3,0,0,0,0,
   2,1,0,3,3,0,1,3,0,0,0,0,1,1,1,3,0,1,3,0,0,2,2,0,0,3,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,0,0,
  3,1,0,1,3,0,0,0,0,3,2,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,2,2,0,0,3,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,1,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,3,0,0,0,0,0,1,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,2,0,2,0,0,0,3,0,0,0,0,3,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,3,3,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,1,3,0,0,0,2,0,0,0,0,0,0,0,1,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,0,0,0,0,0,0,3,0,0,0,0,3,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,3,0,3,0,0,0,0,0,0,0,0,3,0,0,0,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,0,0,0,0,0,0,2,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,1,3,0,3,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,3,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,1,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,3,2,3,1,3,3,0,3,2,0,3,0,3,1,1,1,2,2,1,1,1,3,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,3,0,0,0,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,2,0,0,0,1,0,0,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,0,0,0,0,0,0,0,0,0,1,0,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,3,3,1,2,2,1,0,3,3,0,3,1,3,3,0,0,2,1,0,0,3,3,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  2,3,2,1,3,1,3,1,0,3,1,0,2,0,2,0,1,0,3,1,2,1,1,3,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,3,0,3,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,1,0,0,3,1,3,3,0,3,0,0,1,1,0,1,0,0,2,0,1,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,0,2,0,0,0,0,0,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,3,0,0,3,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,2,1,0,3,1,3,2,0,3,0,1,0,1,0,0,1,0,2,1,1,1,1,3,0,0,2,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,
   0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,1,0,0,0,1,0,0,0,0,
  3,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,1,0,1,0,0,0,3,3,0,3,2,1,1,0,0,3,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,0,0,0,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,2,0,0,0,0,0,0,2,1,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,0,0,0,3,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,1,0,0,0,2,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Windows_1258VietnameseModel =
{
  Windows_1258_CharToOrderMap,
  VietnameseLangModel,
  94,
  (float)0.9990039713013892,
  PR_FALSE,
  "WINDOWS-1258",
  "vi"
};

const SequenceModel VisciiVietnameseModel =
{
  Viscii_CharToOrderMap,
  VietnameseLangModel,
  94,
  (float)0.9990039713013892,
  PR_FALSE,
  "VISCII",
  "vi"
};

const LanguageModel VietnameseModel =
{
  "vi",
  Unicode_CharOrder,
  188,
  VietnameseLangModel,
  94,
  6,
  (float)0.4477746522151054,
  57,
  (float)0.03172832235321948,
};
