package ThermalBlocks
  //Licensed by Terraneo Federico and Alberto Leva under the Modelica License 2
  //Copyright 2014-2020, Terraneo Federico and Alberto Leva
  //This Modelica package is free software and the use is completely at your own risk;
  //it can be redistributed and/or modified under the terms of the Modelica License 2.
  //For license conditions (including the disclaimer of warranty) see
  //Modelica.UsersGuide.ModelicaLicense2 or visit http://www.modelica.org/licenses/ModelicaLicense2.
  
  package Icons
    model Layer
    annotation(Icon(coordinateSystem(extent = {{-100, -100}, {100, 100}}, preserveAspectRatio = true, initialScale = 0.1, grid = {2, 2}), graphics = {Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-40, 40}, {-20, 20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-20, 40}, {0, 20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{0, 40}, {20, 20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{20, 40}, {40, 20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-40, 20}, {-20, 0}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-20, 20}, {0, 0}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{0, 20}, {20, 0}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{20, 20}, {40, 0}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-40, 0}, {-20, -20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-20, 0}, {0, -20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{0, 0}, {20, -20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{20, 0}, {40, -20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-40, -20}, {-20, -40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-20, -20}, {0, -40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{0, -20}, {20, -40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{20, -20}, {40, -40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-60, 60}, {-40, 40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-60, 40}, {-40, 20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-60, 20}, {-40, 0}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-60, 0}, {-40, -20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{40, 60}, {60, 40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{40, 40}, {60, 20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{40, 20}, {60, 0}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{40, 0}, {60, -20}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-40, 60}, {-20, 40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-20, 60}, {0, 40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{0, 60}, {20, 40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{20, 60}, {40, 40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-40, -40}, {-20, -60}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-20, -40}, {0, -60}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{0, -40}, {20, -60}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{20, -40}, {40, -60}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-60, -20}, {-40, -40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{-60, -40}, {-40, -60}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{40, -20}, {60, -40}}), Rectangle(fillColor = {215, 215, 215}, fillPattern = FillPattern.Solid, extent = {{40, -40}, {60, -60}}), Rectangle(lineThickness = 1, extent = {{-60, 60}, {60, -60}}), Line(points = {{-80, 50}, {-60, 50}}, thickness = 1), Line(points = {{-80, 10}, {-60, 10}}, thickness = 1), Line(points = {{-80, -10}, {-60, -10}}, thickness = 1), Line(points = {{-80, -50}, {-60, -50}}, thickness = 1), Line(points = {{-80, -30}, {-60, -30}}, thickness = 1), Line(points = {{-80, 30}, {-60, 30}}, thickness = 1), Line(points = {{-50, -80}, {-50, -60}}, thickness = 1), Line(points = {{-30, -80}, {-30, -60}}, thickness = 1), Line(points = {{-10, -80}, {-10, -60}}, thickness = 1), Line(points = {{10, -80}, {10, -60}}, thickness = 1), Line(points = {{30, -80}, {30, -60}}, thickness = 1), Line(points = {{50, -80}, {50, -60}}, thickness = 1), Line(points = {{60, 50}, {80, 50}}, thickness = 1), Line(points = {{60, 10}, {80, 10}}, thickness = 1), Line(points = {{60, -10}, {80, -10}}, thickness = 1), Line(points = {{60, -50}, {80, -50}}, thickness = 1), Line(points = {{60, -30}, {80, -30}}, thickness = 1), Line(points = {{60, 30}, {80, 30}}, thickness = 1), Line(points = {{-50, 60}, {-50, 80}}, thickness = 1), Line(points = {{-30, 60}, {-30, 80}}, thickness = 1), Line(points = {{-10, 60}, {-10, 80}}, thickness = 1), Line(points = {{10, 60}, {10, 80}}, thickness = 1), Line(points = {{30, 60}, {30, 80}}, thickness = 1), Line(points = {{50, 60}, {50, 80}}, thickness = 1), Ellipse(lineThickness = 1, extent = {{-40, 40}, {40, -40}}, endAngle = 360), Line(points = {{-80, 80}, {-28, 30}}, thickness = 1), Line(points = {{-80, -80}, {-60, -60}}, thickness = 1), Line(points = {{-50, 42}, {-50, 20}, {-52, 24}, {-48, 24}, {-50, 20}}, thickness = 0.5), Line(points = {{-42, 48}, {-18, 48}, {-22, 50}, {-22, 46}, {-18, 48}}, thickness = 0.5), Text(lineThickness = 0.5, extent = {{-54, 20}, {-40, 8}}, textString = "i"), Text(lineThickness = 0.5, extent = {{-22, 54}, {-8, 42}}, textString = "j"), Text(lineThickness = 0.5, extent = {{-62, -48}, {-34, -60}}, textString = "rows"), Text(lineThickness = 0.5, extent = {{38, 60}, {62, 48}}, textString = "cols"), Text(origin = {-7.84314, 0.280112}, lineThickness = 0.5, extent = {{52, 98}, {97.12609999999999, 81.3165}}, textString = "N"), Text(origin = {-5.04202, 2.80112}, lineThickness = 0.5, extent = {{50, -84}, {92.8852, -101.602}}, textString = "S"), Text(origin = {-2.24574, 1.95966}, lineThickness = 0.5, extent = {{72, 74}, {115.563, 56.3978}}, textString = "E"), Text(origin = {-6.72157, 2.51989}, lineThickness = 0.5, extent = {{-108, 72}, {-55.307, 56.3989}}, textString = "W"), Text(origin = {-5.32541, -0.842717}, lineThickness = 0.5, extent = {{-88, 98}, {-40.35, 85.2}}, textString = "top"), Text(origin = {-5.32213, 0.280112}, lineThickness = 0.5, extent = {{-86, -84}, {-43.395, -97.0812}}, textString = "bot"), Line(points = {{0, 0}, {82, -82}}, thickness = 1), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-4, 4}, {4, -4}}, endAngle = 360), Text(lineThickness = 0.5, extent = {{74, -64}, {110, -78}}, textString = "Pg"), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{6, 14}, {14, 6}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-14, -8}, {-6, -16}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-14, 14}, {-6, 6}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-14, -26}, {-6, -34}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{6, 32}, {14, 24}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-34, -6}, {-26, -14}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{26, 14}, {34, 6}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-14, 32}, {-6, 24}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-34, 14}, {-26, 6}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{26, -6}, {34, -14}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{6, -26}, {14, -34}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{6, 54}, {14, 46}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{26, 54}, {34, 46}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{46, 34}, {54, 26}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{46, 14}, {54, 6}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{46, -6}, {54, -14}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{46, -26}, {54, -34}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{6, -46}, {14, -54}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{26, -46}, {34, -54}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-14, -46}, {-6, -54}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-54, -26}, {-46, -34}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-54, -6}, {-46, -14}}, endAngle = 360), Ellipse(fillColor = {255, 0, 0}, fillPattern = FillPattern.Solid, extent = {{-34, -46}, {-26, -54}}, endAngle = 360)}));
    end Layer;
  end Icons;

  package Connectors
    connector HeatPortMatrix
      parameter Integer rows = 4;
      parameter Integer cols = 4;
      Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a port[rows, cols];
      annotation(
        defaultComponentName = "port",
        Icon(graphics = {Rectangle(lineColor = {191, 0, 0}, fillColor = {191, 0, 0}, fillPattern = FillPattern.Cross, extent = {{-100, 100}, {100, -100}})}, coordinateSystem(initialScale = 0.1)));
    end HeatPortMatrix;

    connector HeatPortVector
      parameter Integer n = 4;
      Modelica.Thermal.HeatTransfer.Interfaces.HeatPort_a port[n];
      annotation(
        defaultComponentName = "port",
        Icon(graphics = {Rectangle(lineColor = {191, 0, 0}, fillColor = {191, 0, 0}, fillPattern = FillPattern.Vertical, extent = {{-100, 100}, {100, -100}})}, coordinateSystem(initialScale = 0.1)));
    end HeatPortVector;
  end Connectors;
  
  package PartialModels
    partial model Layer
      parameter Modelica.SIunits.SpecificHeatCapacity cp = 751 "Average specific heat [J/KgK]";
      parameter Modelica.SIunits.Density rho = 2330 "Average density [Kg/m^3]";
      parameter Modelica.SIunits.ThermalConductivity k = 100 "Thermal conductivity [W/mK]";
      parameter Real alpha = 1 "Fitting factor for lumped/distributed compensation";
      parameter Modelica.SIunits.Length length = 0.001 "layer length (cols) [m]";
      parameter Modelica.SIunits.Length width = 0.001 "layer width (rows) [m]";
      parameter Modelica.SIunits.Length height = 0.001 "layer height [m]";
      
      parameter Integer rows = 4 "Number of rows for spatial discretization";
      parameter Integer cols = 4 "Number of columns for spatial discretization";
      parameter Modelica.SIunits.Temperature Tstart = 20 + 273.15 "Initial temperature [K]";
      
      Modelica.SIunits.Temperature T[rows, cols](each start = Tstart, each fixed = true, each displayUnit = "degC");
      
      // Dimensions of each volume element
      parameter Modelica.SIunits.Length l = length / cols;
      parameter Modelica.SIunits.Length w = width / rows;
      parameter Modelica.SIunits.Length h = height;
      // Heat capacity of each volume element
      parameter Modelica.SIunits.HeatCapacity c = alpha * cp * rho * l * w * h;
      // Thermal conductances between elements
      parameter Modelica.SIunits.ThermalConductance gx = k * w * h / l;
      parameter Modelica.SIunits.ThermalConductance gy = k * l * h / w;
      parameter Modelica.SIunits.ThermalConductance gz = k * l * w / h;
    end Layer;
  end PartialModels;

  model Layer
  extends ThermalBlocks.PartialModels.Layer;
  extends ThermalBlocks.Icons.Layer;
    
    ThermalBlocks.Connectors.HeatPortVector north(n = cols) annotation(
      Placement(transformation(extent = {{-60, 80}, {60, 100}}, rotation = 0)));
    ThermalBlocks.Connectors.HeatPortVector south(n = cols) annotation(
      Placement(transformation(extent = {{-60, -100}, {60, -80}}, rotation = 0)));
    ThermalBlocks.Connectors.HeatPortVector west(n = rows) annotation(
      Placement(transformation(extent = {{-100, -60}, {-80, 60}}, rotation = 0)));
    ThermalBlocks.Connectors.HeatPortVector east(n = rows) annotation(
      Placement(transformation(extent = {{80, -60}, {100, 60}}, rotation = 0)));
    ThermalBlocks.Connectors.HeatPortMatrix top(rows = rows, cols = cols) annotation(
      Placement(transformation(extent = {{-100, 80}, {-80, 100}}, rotation = 0)));
    ThermalBlocks.Connectors.HeatPortMatrix bottom(rows = rows, cols = cols) annotation(
      Placement(transformation(extent = {{-100, -100}, {-80, -80}}, rotation = 0)));
    ThermalBlocks.Connectors.HeatPortMatrix pGen(rows = rows, cols = cols) annotation(
      Placement(transformation(extent = {{80, -100}, {100, -80}}, rotation = 0)));
  
  equation
    for i in 1:rows loop
      west.port[i].Q_flow = 2 * gx * (west.port[i].T - T[i, 1]);
      east.port[i].Q_flow = 2 * gx * (east.port[i].T - T[i, cols]);
    end for;
    
    for j in 1:cols loop
      north.port[j].Q_flow = 2 * gy * (north.port[j].T - T[rows, j]);
      south.port[j].Q_flow = 2 * gy * (south.port[j].T - T[1, j]);
    end for;
    
    for i in 1:rows loop
      for j in 1:cols loop
          top.port[i, j].Q_flow    = 2 * gz * (top.port[i, j].T    - T[i, j]);
          bottom.port[i, j].Q_flow = 2 * gz * (bottom.port[i, j].T - T[i, j]);
          pGen.port[i, j].T        = T[i, j];
      end for;
    end for;
    
    c * der(T[1, 1])       = gx * (T[1, 2] - T[1, 1])
                           + gy * (T[2, 1] - T[1, 1])
                           + south.port[1].Q_flow
                           + west.port[1].Q_flow
                           + top.port[1, 1].Q_flow
                           + bottom.port[1, 1].Q_flow
                           + pGen.port[1, 1].Q_flow;
    c * der(T[1, cols])    = gx * (T[1, cols - 1] - T[1, cols])
                           + gy * (T[2, cols] - T[1, cols])
                           + south.port[cols].Q_flow
                           + east.port[1].Q_flow
                           + top.port[1, cols].Q_flow
                           + bottom.port[1, cols].Q_flow
                           + pGen.port[1, cols].Q_flow;
    c * der(T[rows, 1])    = gx * (T[rows, 2] - T[rows, 1])
                           + gy * (T[rows - 1, 1] - T[rows, 1])
                           + north.port[1].Q_flow
                           + west.port[rows].Q_flow
                           + top.port[rows, 1].Q_flow
                           + bottom.port[rows, 1].Q_flow
                           + pGen.port[rows, 1].Q_flow;
    c * der(T[rows, cols]) = gx * (T[rows, cols - 1] - T[rows, cols])
                           + gy * (T[rows - 1, cols] - T[rows, cols])
                           + north.port[cols].Q_flow + east.port[rows].Q_flow
                           + top.port[rows, cols].Q_flow
                           + bottom.port[rows, cols].Q_flow
                           + pGen.port[rows, cols].Q_flow;
  
    for i in 2:rows - 1 loop
      c * der(T[i, 1])    = gx * (T[i, 2] - T[i, 1])
                          + gy * (T[i - 1, 1] + T[i + 1, 1] - 2 * T[i, 1])
                          + west.port[i].Q_flow
                          + top.port[i, 1].Q_flow
                          + bottom.port[i, 1].Q_flow
                          + pGen.port[i, 1].Q_flow;
      c * der(T[i, cols]) = gx * (T[i, cols - 1] - T[i, cols])
                          + gy * (T[i - 1, cols] + T[i + 1, cols] - 2 * T[i, cols])
                          + east.port[i].Q_flow
                          + top.port[i, cols].Q_flow
                          + bottom.port[i, cols].Q_flow
                          + pGen.port[i, cols].Q_flow;
    end for;
    
    for j in 2:cols - 1 loop
      c * der(T[1, j])    = gx * (T[1, j - 1] + T[1, j + 1] - 2 * T[1, j])
                          + gy * (T[2, j] - T[1, j])
                          + south.port[j].Q_flow
                          + top.port[1, j].Q_flow
                          + bottom.port[1, j].Q_flow
                          + pGen.port[1, j].Q_flow;
      c * der(T[rows, j]) = gx * (T[rows, j - 1] + T[rows, j + 1] - 2 * T[rows, j])
                          + gy * (T[rows - 1, j] - T[rows, j])
                          + north.port[j].Q_flow
                          + top.port[rows, j].Q_flow
                          + bottom.port[rows, j].Q_flow
                          + pGen.port[rows, j].Q_flow;
    end for;
    
    for i in 2:rows - 1 loop
      for j in 2:cols - 1 loop
        c * der(T[i, j]) = gx * (T[i, j - 1] + T[i, j + 1] - 2 * T[i, j])
                         + gy * (T[i - 1, j] + T[i + 1, j] - 2 * T[i, j])
                         + top.port[i, j].Q_flow
                         + bottom.port[i, j].Q_flow
                         + pGen.port[i, j].Q_flow;
      end for;
    end for;
  end Layer;

end ThermalBlocks;