//USE: scilab-cli -nb -f compare-batch.sce -args data/line_2.csv out
a=sciargs();
i=find(a=="-args");

traceTTC   = a(i+1);
trace3Dice = a(i+2);
sampleRate = 10;

function ttrace=load3Dice(folder)
    ttrace=[]; //3D-ICE temperatures
    a=fscanfMat(folder+'/A1.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/A2.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/A3.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/A4.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/B1.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/B2.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/B3.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/B4.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/C1.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/C2.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/C3.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/C4.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/D1.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/D2.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/D3.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/D4.txt'); ttrace=[ttrace,a(:,2)];
    ttrace=ttrace-273.15;
endfunction

a=fscanfMat(traceTTC);
v=a(:,1:16);
i=a(:,17:17+15);
t=a(:,17+16:17+16+15);

t3=load3Dice(trace3Dice);

err=t-t3;

// Handle trace misalignment. During a power step temperature changes
// very quickly. If the power and temperature traces are off by just one
// sample, outliers appear in the error plot. This code smooths those outliers.
dex=find(abs(err)>2*nanmean(abs(err)));
for i=dex do
  e=err(i);
  avg=0;
  if i<=2 then
    avg=err(i+1);
  elseif i>=length(err)-2 then
    avg=err(i-1);
  else
    avg=(err(i-1)+err(i+1))/2;
  end
  if abs(e)>2*abs(avg) then
    err(i)=avg;
  end
end

maxerr=max(abs(err));
avgerr=(nanmean(abs(err)));
printf("Maximum error = %5.2f Average error = %5.2f\n",maxerr,avgerr);

exit
