clear;

file = "one";
traceTTC   = "traces-fan/"+file+".csv";
trace3Dice = "results-fan/"+file;
sampleRate = 10;

function ttrace=load3Dice(folder)
    ttrace=[]; //3D-ICE temperatures
    a=fscanfMat(folder+'/A1.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/A2.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/A3.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/A4.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/B1.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/B2.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/B3.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/B4.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/C1.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/C2.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/C3.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/C4.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/D1.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/D2.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/D3.txt'); ttrace=[ttrace,a(:,2)];
    a=fscanfMat(folder+'/D4.txt'); ttrace=[ttrace,a(:,2)];
    ttrace=ttrace-273.15;
endfunction

function index=rc2index(r,c)
    index=c+4*(r-1);
endfunction

a=fscanfMat(traceTTC);
v=a(:,1:16);
i=a(:,17:17+15);
t=a(:,17+16:17+16+15);

[r,c]=size(a);
time=0:r-1;
time=time/sampleRate;
time=time';

t3=load3Dice(trace3Dice);

figure(1);
clf
for r=1:4
    for c=1:4
        subplot(4,4,rc2index(r,c));
        plot(time,t(:,rc2index(r,c)),'k',time,t3(:,rc2index(r,c)),'r');
        ax=get("current_axes");
        //ax.data_bounds=[0,min(t);time($),max(t)];
    end
end
t

//figure(2);
//clf
//dex=6;
//plot(time,t(:,dex),'k',time,t3(:,dex),'r');
//ax=get("current_axes");
//ax.data_bounds=[0,min(t);time($),max(t)];

err=t-t3;

// Handle trace misalignment. During a power step temperature changes
// very quickly. If the power and temperature traces are off by just one
// sample, outliers appear in the error plot. This code smooths those outliers.
dex=find(abs(err)>2*nanmean(abs(err)));
for i=dex do
  e=err(i);
  avg=0;
  if i<=2 then
    avg=err(i+1);
  elseif i>=length(err)-2 then
    avg=err(i-1);
  else
    avg=(err(i-1)+err(i+1))/2;
  end
  if abs(e)>2*abs(avg) then
    err(i)=avg;
  end
end

maxerr=max(abs(err));
avgerr=(nanmean(abs(err)));
printf("Maximum error = %5.2f Average error = %5.2f\n",maxerr,avgerr);

