
#include <iostream>
#include <sstream>
#include <fstream>
#include <vector>
#include <array>

using namespace std;

const int numElem = 16;
using powertrace = vector<array<double, numElem>>;

powertrace load(const string& file)
{
    ifstream in(file);
    string line;
    powertrace result;
    while(getline(in, line))
    {
        if(line.empty() || line[0] == '#') continue;
        istringstream ss(line);
        ss.exceptions(ios::failbit);
        array<double, numElem> sample;
        for(int i = 0; i < numElem; i++) ss >> sample[i];
        result.push_back(sample);
    }
    return result;
}

int main(int argc, char *argv[])
{
    if(argc != 2) return 1;
    auto trace = load(argv[1]);
    
    const string rows = "1234";
    const string cols = "DCBA";
    
    const int mapping[4][4] =
    {
        {12,  8,  4,  0},
        {13,  9,  5,  1},
        {14, 10,  6,  2},
        {15, 11,  7,  3},
    };
    
    const double cellX         = 2560, cellY         = 2560;
    const double heaterX       = 2000, heaterY       =  925;
    const double heaterOffsetX =  280, heaterOffsetY =  280;
    
    for(int r = 0; r < 4; r++)
    {
        for(int c = 0; c < 4; c++)
        {
            int powerindex = mapping[r][c];
            
            cout << "// Mapped to power[" << powerindex + 1 << "]\n";
            cout << "HEATER_" << rows[r] << "_" << cols[c] << "_a:\n";
            cout << "\tposition " << c * cellX + heaterOffsetX << ", "
                 << (3 - r) * cellY + heaterOffsetY << " ;\n";
            cout << "\tdimension " << heaterX << ", " << heaterY << " ;\n";
            cout << "\tpower values\n\t";
            for(int i = 0; i < trace.size(); i++)
                cout << trace[i][powerindex]/2.0 << (i == trace.size() - 1 ? "" : ",");
            cout << ";\n\n";
            
            cout << "HEATER_" << rows[r] << "_" << cols[c] << "_b:\n";
            cout << "\tposition " << c * cellX + heaterOffsetX << ", "
                 << (4 - r) * cellY - heaterOffsetY - heaterY << " ;\n";
            cout << "\tdimension " << heaterX << ", " << heaterY << " ;\n";
            cout << "\tpower values\n\t";
            for(int i = 0; i < trace.size(); i++)
                cout << trace[i][powerindex]/2.0 << (i == trace.size() - 1 ? "" : ",");
            cout << ";\n\n";
        }
    }
}
