#!/bin/bash

# This script checkes the heatsink model against all the validation traces

results="results"

rm -rf "$results"
mkdir "$results"

g++ -std=c++11 -O2 -o gencell gencell.cpp

process() {
    # $1 is input trace file to process
    echo "$1"                            # File+path, e.g: traces/line_1.csv
    d=`dirname "$1"`                     # Directory, e.g: traces 
    f=`basename "$1" | cut -f 1 -d '.'`  # File only, e.g: line_1
    outdir="$results/$f"                 # Outdir,    e.g: results/line_1
    
    mkdir "$outdir"
    
    # Produce power file $outdir/p and get initial temperature (printed on stdout)
    initial=`scilab-cli -nb -f genpower-batch.sce -args "$1" "$outdir/p"`
    echo "$1 initial temperature $initial"
    initial=`perl -e "print $initial+273.15"`
    
    # Make flp from power file
    ./gencell "$outdir/p" > "$outdir/TTC.flp"
    rm "$outdir/p"
    
    # Get ambient temperature from metadata file tests.txt
    ambient=`cat "$d/tests.txt" | grep "^$f" | perl -ne 'next unless(/(\d+\.\d+)/); print "$1\n"'`
    echo "$1 ambient temperature $ambient"
    ambient=`perl -e "print $ambient+273.15"`
    
    # Produce TTC file
    cp TTC-fan-batch.stk "$outdir/TTC.stk"
    sed -i "s/<ambient>/$ambient/g" "$outdir/TTC.stk"
    sed -i "s/<initial>/$initial/g" "$outdir/TTC.stk"
    outdir_escaped=`echo "$outdir" | sed 's/\\//\\\\\\//'` # sed does not like the / in the path
    sed -i "s/<outdir>/$outdir_escaped/g" "$outdir/TTC.stk"
    
    ../../../bin/3D-ICE-Emulator "$outdir/TTC.stk" &> "$outdir/3D-ice.log"
    ./reformat.sh "$outdir"
    
    result=`scilab-cli -nb -f compare-batch.sce -args "$1" "$outdir"`
    
    echo "$1 $result";
    echo "$1 $result" >> "$results/results.txt"
}

for i in `ls traces-fan/*.csv`; do
    process $i
done

rm -f gencell
