// Copyright (c) 2014-2021 The Gridcoin developers
// Distributed under the MIT/X11 software license, see the accompanying
// file COPYING or https://opensource.org/licenses/mit-license.php.

#include "gridcoin/staking/exceptions.h"

extern bool fTestNet;

namespace
{
    static const std::set<uint256> bad_blocks =
    {
        uint256S("afbe8c0b0656908caae317eade1bb8a67b76e47204efcf94f680d6ef7ac672dc"), //P1144229 (beaconalt)
        uint256S("58b2d6d0ff7e3ebcaca1058be7574a87efadd4b7f5c661f9e14255f851a6185e"), //P1144550 S
        uint256S("624a9345d18ff1c97aebb38dfa4f349b9ac2a9a5c5f52ef8afebd1379f22208c"), //P1144608 (beaconalt)
        uint256S("eddb29693ea346bb17f8c4bfb0568eefaf33c48691b023fcab0b71d6b7778d72"), //P1145041 (beaconalt)
        uint256S("de0ef0290a7a9b2275b430940a4ab2346a060395f5049571ca9e3d642cc88a5d"), //P1145149 (beaconalt)
        uint256S("3bc307419af5ca7cafa5a12da10635bd16a3a282d2a2cd38c493b7c82e9adad1"), //P1146795 (beaconalt)
        uint256S("471292b59e5f3ad94c39b3784a9a3f7a8324b9b56ff0ad00bd48c31658537c30"), //P1146939 S
        uint256S("23b4704c9eba64f795955ff6bc7622fcd6f4b3bcb7fa71bae17c21d59da34241"), //P1147418 (beaconalt)
        uint256S("d8fed144ad3b543712bc680871838926d309f676665d52b9d9203d574b5a7803"), //P1149593 (beaconalt)
        uint256S("ab982bd9ccf0b28ca3cec0a7aeabefed292e424ef68ba84a127cb3939521cbb8"), //P1150537 (beaconalt)
        uint256S("3058460655cfd7ba2ee6372afa4fe8db3a2acaba75935b459cf767a07a283fd5"), //P1150576 (beaconalt)
        uint256S("7c3857611a83bba9b06021306fa40410c263a7494b551ea6bc5eaaa1451a5d43"), //P1152469 (beaconalt)
        uint256S("5b63d4edbdec06ddc2182703ce45a3ced70db0d813e329070e83bf37347a6c2c"), //P1152917 S
        uint256S("9498438c8f90d491fcffde4e24de9ae247acb6cd5abbe0980fe05ec254749ab8"), //P1153482 (beaconalt)
        uint256S("c02d1a40e2794a76119a73629aae0f4f8a372e12a3a57f4545e426cd98b8c1f2"), //P1153559 (beaconalt)
        uint256S("5c1e2f549cb8ce80e5de57b766011e3fbc73a4d3611ea5506bef79596a73cd0e"), //P1153658 (beaconalt)
        uint256S("19b7623a70f6ae9684de0489c4c6dd0662d3512207d3ef362ebe41e01fc8c405"), //P1153786 (beaconalt)
        uint256S("b34b5cbfcf5fa6e1b04c28fd2b5ceded71fe2f3cbf60a24e6a470155a9d70d05"), //P1153837 (beaconalt)
        uint256S("605f525bcb94515763066e8eb1e92841fe7d0753b3699e5a79f75477a0047225"), //P1154071 (beaconalt)
        uint256S("e9035d821668a0563b632e9c84bc5af73f53eafcca1e053ac6da53907c7f6940"), //P1154121 S
        uint256S("06aaf47a7ade1bf82180f078fd8c5007b92b0e38a5b9e83d7ed44c4b5622e52e"), //P1154356 (beaconalt)
        uint256S("63bcc2e5ed12eff30a321800ffd19f4de079f67892fc8e4a9b5b9b92e06c6f9f"), //P1154504 (beaconalt)
        uint256S("c04d48e2c95b7c63d857a355e51ee4b550f6b96635fed6af3d233716c89aac97"), //P1154672 (beaconalt)
        uint256S("d8a019549a05feaa494c5759becb359d3e2c3b38b75eb8788c0a204bfd9031b2"), //P1154712 (beaconalt)
        uint256S("db839c7b9fee316a2265867ddadf7dd26a87c7c6f71d5234aa8a53ae20e2c328"), //P1154800 (beaconalt)
        uint256S("150355bdaa5eed52b27208db421e6c5c1b36c38ec1b018c61c2bededf9e16a95"), //P1154992 (beaconalt)
        uint256S("9d1e37e32516e477b88d0f7502beb0c2b7852bb1d226e862a9513e0e865aae25"), //P1157054 (beaconalt)
        uint256S("bc575a4f4fc50841be590871c7843df7425c8601aec129f12a790a9f22f4973e"), //P1157306 (beaconalt)
        uint256S("475302e6ce58811110aaaf6b965f442d0492b9c84d74e13113237ad2b029093c"), //P1157321 (beaconalt)
        uint256S("624a24076c3ae63df8a4ae7fcb19f2b5d18d5da2f4a3fba365c32a01d3ed7bbe"), //P1157361 (beaconalt)
        uint256S("a520262edc71f1f5ef214116b3d277d4eb80600a7d98e0560f4442b68efb37bf"), //P1157847 (beaconalt)
        uint256S("1ee613e810d6b992c735c2df3c675d2de34782b7ae5a2a63368c47c331b885ca"), //P1158026 (beaconalt)
        uint256S("b0a4f120eb39665eb7a3e7c13b59fa5060d49fc7cdc0b8d057296fab28d80bcb"), //P1158342 (beaconalt)
        uint256S("06f12709b61a36dcb866a58c21ab2bbcc0dd181c1f70f23a856b25f45ae5beb9"), //P1159823 (beaconalt)
        uint256S("a444646cfd54d3853acb601a140fde6c63d4fcd7f9aab85cd93be9275b7ae02d"), //P1160088 (beaconalt)
        uint256S("145c15e3aff2e91d37b8ad814b371430c595b8c9b0b05263e9e60da3bae71ea1"), //P1160113 (beaconalt)
        uint256S("478d441f2cf28bca9c8e80d4cc1336abd031a6955173ed08361ab6b56b265c46"), //P1160206 (beaconalt)
        uint256S("5cc4746db01e067a3d94f181fa1624ca63d64856d5fda579ad403f2fea6859d3"), //P1160628 (beaconalt)
        uint256S("615c92721e5d978f5b03207d61a6af26f61b891b7e76cc50c5e344d410638a54"), //P1160725 (beaconalt)
        uint256S("b5e54424c6b4862b36960d04e070bbd586d31cf0bd1e4f069492ec65b91a240c"), //P1160860 (beaconalt)
        uint256S("d9d125a116a7e8699890bb30553548eafdaceb642036a2b504a915c3fd47b076"), //P1161529 (beaconalt)
        uint256S("e0cbe9a52a17746abb1ad8bfdf93153630345b8b68f1a8e4f52c38cba5ce2592"), //P1162011 (beaconalt)
        uint256S("d45391b525350c87efbe43be84b274b0490e2c34162c0ae1d819689495296c4a"), //P1163172 (beaconalt)
        uint256S("96d2b430afdd8d6812ccb7db2e261a77010a77ef09a8580aa62c3417c6865047"), //P1163201 (beaconalt)
        uint256S("a539282bdf3dbb6650f931aef5dd384363e7496f1955d021d9abaf1320516351"), //P1163306 (beaconalt)
        uint256S("96185e7a094dfdfe2d22fdbfbb3f3f224018163f4cf19e07add1a4496a5b80f8"), //P1163830 (beaconalt)
        uint256S("0c330a4213c99df032786e569a9673c97b0ffd3308fdb3a7dee017fcbe333932"), //P1163962 (beaconalt)
        uint256S("0a9d9c5037d5b71c718d62a5b3351496e1756f089e55d218c5ad1217a722ab63"), //P1164022 (beaconalt)
        uint256S("a9fdb90a53e76aed4d296475b71d3657e93baa5bcfb69b5b8bbb2b704ae38540"), //P1164120 (beaconalt)
        uint256S("a42c23123017ef6038404b6d00c4f3be40cdb32b4129eb167f6d822c2d12273c"), //P1165931 (beaconalt)
        uint256S("5be6283e7d972acb48343952e6df7d18ba0f81076659ceac2044f5209da1df5e"), //P1167788 (beaconalt)
        uint256S("c0954f79a08d0338e037a5dba21d445b5f7f7b205ba9b625d56bdc74dd63d291"), //P1167799 (beaconalt)
        uint256S("1d30c6d4dce377d69c037f1a725aabbc6bafa72a95456dbe2b2538bc1da115bd"), //P1168122 S
        uint256S("d8f24a5cbd95ac33323bfd7654c36dd8af5cc92420a61ba383f7e18a9a4ec2d5"), //P1168334 (beaconalt)
        uint256S("ffc8eb97c1ba16b5913ae4e072611847a082bb0813e3b26ae8e44d941868402d"), //P1168483 (beaconalt)
        uint256S("ab74fcb1fe22c0d8359512805da0bf805e60da4b95d924d5df5bd473d5b12cd0"), //P1168947 (beaconalt)
        uint256S("4926d431294c3968cbc68a011c8af6672fe01f9f5317f2522e5952e69b468c39"), //P1169155 (beaconalt)
        uint256S("c14fea0ba4eddaa06b8a4df4b17182e9c38b22added88bd9f341448fb6e4b95a"), //P1169447 (beaconalt)
        uint256S("9ab48d258e7932122bec75953f9b089f2a1a25a2883e8dc17ebaed9f438a783a"), //P1169739 (beaconalt)
        uint256S("934c6291209d90bb5d3987885b413c18e39f0e28430e8d302f20888d2a35e725"), //P1168193 S
        uint256S("58282559939ced7ebed7d390559c7ac821932958f8f2399ad40d1188eb0a57f9"), //P1170167 S
        uint256S("d2dba6df74164f7679821286cb85e597534009e6f6131d780f75e28ccbc3fd0d"), //P1170424 (beaconalt)
        uint256S("00222f4023567821a511fc2d18abf6ea12b869b4baa8c238fb8b0217916c07d1"), //P1170631 (beaconalt)
        uint256S("14438ca7a78cdff2ec58052023f35c4618e6bf21814e696eb3637550c747105b"), //P1170665 (beaconalt)
        uint256S("7ea79e70846360cce468715de2e03a52117da24769ff2306533a4249bc320c18"), //P1171492 (beaconalt)
        uint256S("5a63d6f8b8074fb41f3d6f7b843d4717da012fda2e9b561ff16f18610d85f950"), //P1171799 (beaconalt)
        uint256S("9df5eb83d5da8e08ac8d60ed1126abe720760b364dc9ade061a1ec174128d014"), //P1173124 (beaconalt)
        uint256S("3683775c15de6c2792e80461eab70b250fd2a12147ff0694bf7e008cf470719d"), //P1173330 (beaconalt)
        uint256S("0eb9b89daa31157e2cc40e50875e417f1efe141b471a60f6ffbfe7d62e5a7536"), //P1173431 (beaconalt)
        uint256S("2cbf8d81ac28406f6aa91d40097f7c7e388c7e7ee32be0be38b3f8eebfda1fb4"), //P1174113 (beaconalt)
        uint256S("6e89ccd86bed5d84eb8c128aeac7fc41293ac7f4cfe9e5d09be1c7fb9f837b31"), //P1174619 (beaconalt)
        uint256S("7a9b0a1fd0424d0013e16e1415587b7f14b1bbed9757f1b2b4ec4493d9eda0c0"), //P1174805 (beaconalt)
        uint256S("b319079030188c96e9b0ab8e5d6952bfb68597237cac48e319b13675da5e2d45"), //P1174913 (beaconalt)
        uint256S("53e9ed16415294492c06bad00e954889674cc92240e246cae70798b41af38d0a"), //P1175286 (beaconalt)
        uint256S("3c40f430c86a4c8429e625a027c04af9e922ec8d48238288c43fbb637af4eb26"), //P1175857 (beaconalt)
        uint256S("1d4b1ffce2151ccb35d602a83bd5e3d38338cd717d89207d0b29427badfc7cc9"), //P1176179 (beaconalt)
        uint256S("9a9e801256989dfb7c95abc5857da5a24aa8d9b6b2256fe7f1b8e910b621feee"), //P1176298 (beaconalt)
        uint256S("946996f693a33fa1334c1f068574238a463d438b1a3d2cd6d1dd51404a99c73d"), //P1176436 S
        uint256S("e8cf0b86e5a6d6a5a70aa82f894f68649554f4c48f4a74f7bf8df38e757bb35e"), //P1176864 (beaconalt)
        uint256S("9679b8982abcc6cfe5f5b472294947b794f1f741dec4c60ea67232f60faad3f9"), //P1177574 (beaconalt)
        uint256S("ef7bf61e72dbe177d2e2ea295fadd7ff3a17ce24f76b5589515538c23d8e369f"), //P1178808 (beaconalt)
        uint256S("b157393a383eb66ab03686a71d7b017dc36b4a3309fc975bd7503193abe75a7a"), //P1179423 (beaconalt)
        uint256S("887b9fe776bff7e0b9c5875418e744f1a8e12e7cb500edcd4c4ec29249c4d2b7"), //P1179700 (beaconalt)
        uint256S("75386277256b43610bc233d8ad656cd27c5f9656a6a505345bc7a752fd8f50ae"), //P1179750 (beaconalt)
        uint256S("0597a25ae451d4d2ecaf01713d405655627bfb63f11464ba8b4f6db348447134"), //P1179787 (beaconalt)
        uint256S("e44827be1b40e49eb816337ef241da689e783d3b04828c15f690e484b70ae35a"), //P1180173 (beaconalt)
        uint256S("fdd7dda9566fcfc31fea3b1505f35713a0bbf7a70b28b2a0ff5641d38345d10c"), //P1180318 (beaconalt)
        uint256S("96ce94edfb66eb4b7a0eef3aaca65801a88571200d951bde88b53580374dc66b"), //P1180753 (beaconalt)
        uint256S("d3274df1bd4b68f75b8266f5c14f74bcf1340822cf5a5afb5525b2add5bdac25"), //P1181046 (beaconalt)
        uint256S("5a13612695582199fb8b1602bd1edc8eeec703763715a5b7080037b901ed6c51"), //P1181171 (beaconalt)
        uint256S("14fecf06720e92a8f882f776e3f6dd7c72ebce0c215f9ccb0cc5c99d59b6ce34"), //P1181271 (beaconalt)
        uint256S("37d3cde390bd834e6395f902114a2fa3dfb51c053f991a276873b36f8269719e"), //P1181510 (beaconalt)
        uint256S("25b9280ee4bc9a5b03d72e8583e37ac53990471ba50c3312f0bfe5d8118788ad"), //P1182145 (beaconalt)
        uint256S("b1bcbd6e374edc95fc1e0cf957a5075093199e3e0b5671ba8cf5fc429a4c9f69"), //P1182483 (beaconalt)
        uint256S("ef24962a5ebc5df5b5f3808b6761ccdb68ae60dba62c67c602f96f28bb9b5fc6"), //P1182544 (beaconalt)
        uint256S("8733c21a46286dcb7402ffcfebc59a5b1b5b6598d1eccc7acecd311aa1950c0e"), //P1182678 (beaconalt)
        uint256S("53d7b78e75a022a50da9ec0691afba2e2a08e25c08dba592b32f30b88108b504"), //P1183010 (beaconalt)
        uint256S("32552f8d38be178e41ed29e577add412836d59e53adbfdadd5928d9fa6b60a25"), //P1183112 (beaconalt)
        uint256S("b050f0ef4e550912bda9243c24b6984fc62cdc8ff01d5f60fd4be55dd7728c17"), //P1183505 (beaconalt)
        uint256S("16b68db42e0aeeabcfc26cff275d2da52f349a649d9e6419db5ed6d54be57965"), //P1183782 (beaconalt)
        uint256S("e38983d28d41b77f98c7f8a2ddd6d45aa6cdd7a6437d9fdf88d200899a8a32c7"), //P1183977 (beaconalt)
        uint256S("945d2ae8ba5067574c965aaf390de291d48c71b16fda8dd1500af44ab0613227"), //P1184120 (beaconalt)
        uint256S("0bbb5fbacd6c30f0a7630595a592b63e764e96348dcc8e8bd5baf090f75fa25c"), //P1184583 (beaconalt)
        uint256S("0f2ce9cd75043c66222265a2d3bba60f83c8e14bcb062354e7c21e027566a447"), //P1184713 (beaconalt)
        uint256S("3e5c8726456350d9c25b8fcf00fe7271b9800f25153b9a4f010ca7e355b7f0c0"), //P1184783 (beaconalt)
        uint256S("aa3089f870f6e128e4c5177edc5d7f01aeb16cadb37e4234799b00a9d5447615"), //P1184886 (beaconalt)
        uint256S("c317b8c11c1bc9479807eca4f3aa08c290f2fb21aee6e0948f7fa2820caf8f3c"), //P1185329 (beaconalt)
        uint256S("a0855b6f6de659e1cfd329c99f1a783d6af9c7e0f396514c3a2247b97ec922ab"), //P1185545 (beaconalt)
        uint256S("0ff0838c20c24a21b337fdf3dfdbdfc1117c56004c85bc5fc32491f65769b1af"), //P1186574 (beaconalt)
        uint256S("615d541a52b8994d55734a095e6d6d61803b3a9341c2b9d71ca70181b4a5856e"), //P1186786 (beaconalt)
        uint256S("063289120f834ba58770aff7268b1b875b011dc00fe8e2fa410971a354bf87f8"), //P1186841 (beaconalt)
        uint256S("c65c5b5137ed4229ac9902800681eb6ca950df13de8c2176aaab14733d6c03cb"), //P1187663 (beaconalt)
        uint256S("a6564a5461c52025fdd07c837a065dc44e99a088e8012aa3ccbd63e4081c0b2f"), //P1187841 (beaconalt)
        uint256S("e3768b171093f8815cbf94dba23b173864f24cf08565c333742973524e586cf5"), //P1187926 (beaconalt)
        uint256S("66d35ac7f82627e0103b1177358c8de0773f609e04620462750dd98ea80659f1"), //P1187971 (beaconalt)
        uint256S("8278ec84fbba877a26e8f115d2bde3008ff717283f94a4b9a76743aeb4a131bd"), //P1188333 (beaconalt)
        uint256S("bb0e328821b77dc16ad13805afcbd918e9571486b3479a37e82c519a189c1b53"), //P1188528 (beaconalt)
        uint256S("9defc990b24a57f9b0f92ff836bf719f0668f33ed420303881a2f75334d449b7"), //P1188678 (beaconalt)
        uint256S("01d0e13f6d4c32d9af467a5cd37ff4540a9c89775e4dcb8e22a1c687ebe550f8"), //P1189134 (beaconalt)
        uint256S("27bdb9194e586f2f9f4e6b99db22045db6231f87e3e0c9cae5691b548724ce85"), //P1189483 (beaconalt)
        uint256S("4a43dbd23103a6dc04e8ddddc7b867ec8bdcdb3c0f4988b4ed4c47146b9434e3"), //P1189793 (beaconalt)
        uint256S("de7487da5b7cabc6414e21a11ac93fbb56319c856e4111b7f02f057c6e56523a"), //P1189934 (beaconalt)
        uint256S("8c4ea979dd329399b84bc858ab1e4907157528930780bdaee3a4c472171a7a56"), //P1190009 (beaconalt)
        uint256S("20ce337529216b4883601e0a461d66d005e8e5f2643686a7155ab4b31081e967"), //P1190278 (beaconalt)
        uint256S("13c250af4422a2aaf7a935a2946f0c4aca1fab5002793823ec5caa3e08cc6015"), //P1190438 (beaconalt)
        uint256S("da756f66f2120cc5db1c32c37828c405cad24808bdcd0d143074cdb55c545a39"), //P1190579 (beaconalt)
        uint256S("50fd55fb4823a9500a31d64af54461dc900f92bcbdf5b5cb0e2be021872e1958"), //P1190631 (beaconalt)
        uint256S("787da7e7145799dc9906dd0c5d4a9db0f569b3195a29d4786f46071e026d9f11"), //P1191067 (beaconalt)
        uint256S("542060fe5250b737be50b065d28ecd8396d3e9977caa8189d33f47b52b7edffd"), //P1191338 (beaconalt)
        uint256S("748762570d76df643d8157910c559175b9e3295a61ad688ca718f4fdb27b4dd6"), //P1191898 (beaconalt)
        uint256S("3b4a8227cf23394314a3619bca0bd602f41cb97450e055d3fba49b3cf8fb85f1"), //P1194554 (beaconalt)
        uint256S("d1c0cc335c9a4fdf2e6b8fea4910642bc51b99f0d8f220268f7a99bc41acb36c"), //P1196291 (beaconalt)
        uint256S("4f948d8696d3628354c413c9bb506532b142f1a78aae72a6b413c8e1db20c0d1"), //P1196502 (beaconalt)
        uint256S("2e01e39b0c46b45bfe55471340ed67b7cb6737b44c5b0c5cf21c1761f36af901"), //P1196583 (beaconalt)
        uint256S("98ce0717d68c03ce1ae5ffe8805e540f5207fcdfff37f212d9d0b25dd0165de4"), //P1197324 (beaconalt)
        uint256S("1e0be0fc83374e3e4bf0263aa4dfa2174dc87b079999dda70df02aa5235b0401"), //P1197610 (beaconalt)
        uint256S("ade8c34a741969b5ae0b5aa147ddd4cc74e8f795e8c8de2f48da60182c3e9f55"), //P1197704 (beaconalt)
        uint256S("fc3353f31fe24682d963d0ecba3a91239867c7953f4036d4a886663fe14e5a39"), //P1198173 (beaconalt)
        uint256S("172b15d6dbd4f0b6c713f525e1eecc9957b199fdaf5f14a727ffafde93932610"), //P1198725 (beaconalt)
        uint256S("4a3bff6776e5d622b3c5cd6cfc178f0925f060b88653e13398a3df6fdcd62f12"), //P1198798 (beaconalt)
        uint256S("609633d52abf3114baaad8c00c822ee864c744173d80828755bae04536146abe"), //P1199165 (beaconalt)
        uint256S("0af6d9d0ec7b801c4b7a6649eae9d98ffa377868123942268fed4acbf6599c48"), //P1200220 (beaconalt)
        uint256S("3461614a78b142d63aaae1fbce1569af3e7cbfd6a8984ab80bcaad2579a91764"), //P1201058 (beaconalt)
        uint256S("27b0070be29a12eb2c7fc56340bbb5637a9c0108f280e50ecb000fdee077307d"), //P1201490 (beaconalt)
        uint256S("71c294347e1e3bb26a459d8d1b7d8f0971d251c01fb3387c039ef019c5310800"), //P1201513 (beaconalt)
        uint256S("571bc1d88b8fcb19928462b1b17363dc7147beeb2951a5df0267ab9a6f42135e"), //P1201851 (beaconalt)
        uint256S("4684ead763d0b4dabe1c799792d5136715d9922b2ee0491ea125e9adcdfda69c"), //P1201987 (beaconalt)
        uint256S("06696d32a017d3bb5f534123b7b6013fd5ba86a7678d66761bfe87c76168dcf6"), //P1202314 (beaconalt)
        uint256S("d3eebcb545da3a96e5cb61ef6bebbf5c5c6795747fc706a3087581f43361a1a7"), //P1203690 (beaconalt)
        uint256S("6a020d3dafbf72bd90f6f1a9ceda7f4349b8879392dd9790eaba9d9327ab41c4"), //P1207043 (beaconalt)
        uint256S("fd566f3d8488a59327e7fe171604fdd7579566698d0822590aefd061cfa2692c"), //P1209097 (beaconalt)
        uint256S("fe5687ac4e702f5754b40135234dbd195a3c15231db75754749e3e64a3b20f8c"), //P1213823 (beaconalt)
        uint256S("c64dd92de722349c3949b98fa3337446a26b84d019bfc28df2a831d729c5d92d"), //P1219649 (beaconalt)
        uint256S("f6c9df769f8b53d14b181bced05258ec0214a40e2252ca035fb0c7f074704888"), //P1219734 (beaconalt)
        uint256S("7f7cfb85d941a7beac42373a53fa9988f3c20afd3939d724ae0f8dec157d6d02"), //P1227752 (beaconalt)
        uint256S("97759eba6ee36c91f8e3f974a65d8840ee7d4cbf7fbf6d0c6fbd591763fef8e7"), //P1230011 (beaconalt)
        uint256S("118b64f76cfb83b37b4be68698ce918fcc36b1142e060115bf52236e399ff7ba"), //P1230103 (beaconalt)
        uint256S("5957c756a4b76c2e64a9c6c702e5daeb0be836ededaf1e8b97e077e8c3cf0f16"), //P1230563 (beaconalt)
        uint256S("41c4e47beef891f35e0b467eb4b2a64bc8a563d9a653f08498dac9391234a3d6"), //P1231284 (beaconalt)
        uint256S("3a3290d2566c37e55d9e9bf575bcb7e20815f9aef3f7b04d8b1e59eec9f8bf02"), //P1236832 (beaconalt)
        uint256S("da5847c0f00ab0c3e20c301d2d864d1546f84879498e10575664d2f904b4c785"), //P1237616 (beaconalt)
        uint256S("ec3f6f0a2946c1e2f703e06e96fd4b5928960f5622ae23ad5fae76216f71caad"), //P1239913 (beaconalt)
        uint256S("b0d4a55d58a152bc397fe25f99c00b235351ab9a95bd72b7ce24ab22fa4dd85a"), //P1243813 (beaconalt)
        uint256S("5edf72be858a8124d9916e03eab2f38bc739c07c4109d1677e2974ba792b0171"), //P1245473 (beaconalt)
        uint256S("7f7fd9b45ed338cbda17fb2d0237c3b87d715d6d7f045d96a05a19ba88553b00"), //P1245575 (beaconalt)
        uint256S("21d9486673e9da1f547648a80a7370123ebdbe48aacabfad74a2e5c2f5d0af63"), //P1246480 (beaconalt)
        uint256S("dbfa82b5225c4c17866a362c9b5e2f77159f2b843d2a91e8989f93475ffaecd1"), //P1246488 (beaconalt)
        uint256S("baef552bb705cc3d258271e455a832fca19a459974136f72380b54acc2d2a8e8"), //P1247163 (beaconalt)
        uint256S("d0d3baabdb01e5c59bd2d6d7df2dc307ef3a796637142d0bf2f4f21af4441ddc"), //P1248753 (beaconalt)
        uint256S("64c6080458269d11f68585a0fa055ee70c4eb309ae6fef56893588bd6d79e49e"), //P1251722 (beaconalt)
        uint256S("4a442517ae1b4872d9f175250b1465836e589c37cab46f13fd668f97a58cb137"), //P1252427 (beaconalt)
        uint256S("cad5fb29784b9b666dec7505fb2b90399a96a2b527be2434be764171cd2c93f6"), //P1252561 (beaconalt)
        uint256S("2f9d89d65f6139e36ebb9f2b3137c3fc785bb3d593a3f17d49a558c177b3bbb2"), //P1253289 (beaconalt)
        uint256S("386013acce8f2665d3adf4105562b7f16a66106a0f18d060bb2c753cfd1d7dbd"), //P1253634 (beaconalt)
        uint256S("b28a643b04b0131f2d8bde9ee18c542e6114694b7b0f478567507115583177e3"), //P1253749 (beaconalt)
        uint256S("2471e0b93c0b455c1d362e6e7b386b6669b493d44d2fa8d32cb81da810234481"), //P1255111 (beaconalt)
        uint256S("980839dbb41328421577c44901647b081e140f75262d019b71df124a0403e87a"), //P1255837 (beaconalt)
        uint256S("17885f4f2fcaa59364aa6394575c1fea86197f28705b4aa1770e56fa81d19575"), //P1255965 (beaconalt)
        uint256S("02bc883c5652398eae7c74ca992529de21046929401139e89ec0f6521516eb0f"), //P1258907 (beaconalt)
        uint256S("62a2b9f29ef5c65b7e17b6c42e24d11b533d20dd9d41d60432051bed588f2073"), //P1260406 (beaconalt)
        uint256S("91af71cd636ff372a5a127cb55341832309513b2790dbc2958bcd62fda36338a"), //P1260850 (beaconalt)
        uint256S("476a9e6ee058313aa0e32f3deb6341a6025e8ab13525302b1f82b9c07ba6bcb3"), //P1261187 (beaconalt)
        uint256S("e0c2129fe044fbcc172a20e3aaedae767438a473b3aff19fa0b6b18f7a4ebf14"), //P1263066 (beaconalt)
        uint256S("187116bc09f33e4190533228ea3d0cc91b86ca390a4be2f1883d966aee1d3ac4"), //P1265204 (beaconalt)
        uint256S("638f82158112992f01c7ea2162b37dab532216a5aae62bea127322708fe849d0"), //P1269392 (beaconalt)
        uint256S("e6de76d30ca399a905dd341ce2c9a8ba672f9e4bf98b8e1424164c2bc5508358"), //P1284545 (beaconalt)
        uint256S("d3869b29acd7cfb651602e798119257a3835cf7290cd4f4ce940db1057d8ac6b"), //P1285031 (beaconalt)
        uint256S("3c5301bda6f4ea9217266cd4f997fb04cc39a5f4d35f5138e4c538e6e083d634"), //P1285515 (beaconalt)
        uint256S("fbbfd66c63b8d7a07472f29c612a14906c9ff3b2db4e10a6453ccea68d50f035"), //P1286867 (beaconalt)
        uint256S("a6417db646615f57c2fcca0df5369d442ea98d0c6f747b82d30ab58cd8bcb6c5"), //P1324021 (beaconalt)
        uint256S("bfb6d8f1dbe196b1796df84fa2472dbe785972406fee728ab5d4bd9f229460fd"), //P1337709 (beaconalt)
        uint256S("f94fd82db5dbb0a8dd6145573ad3ff0759e74cd26262a0ec5e8609c36bbdc742"), //P1350028 (beaconalt)
        uint256S("1fe190274629969ff626cd0cd446b3159b947a47b2cdf783e90f2fc40da2208a"), //P1351825 (beaconalt)
        uint256S("e4ce4a928e8d42db26e16eb657f8e53f4be401ba480de01af70d5ae1228677d1"), //P1368309 (beaconalt)
        uint256S("ab06a403875c6c97c6ce3e68fffc19d9dbf3be64324c64d9dbddc4958b350fab"), //P1441206 (beaconalt)
        uint256S("ede0a3eda3d53546e1e7b340b6fad7b428aecdd85bcf7534def8365e1b89828c"), //P1441467 (beaconalt)
        uint256S("bff64c0bf316c442f1f9e317589a6eb38ffce6623c03867e0e48853d15434665"), //P1564089 (beaconalt)
        uint256S("b67f1bf92dda31c833cb37f8fd0cd0eb4068f9bfb023af0c86600e922ef99082"), //P1565898 (beaconalt)
        uint256S("a9eb4e9d7b7309805e0dc30ad88fd81edbfd632b2a978f20c8f3a7454d42a288"), //P1774129 (beaconalt)
        uint256S("520e1efde69a4fb62341533aaef51f8008f17b16555bc738504941910238af43"), //P1862976 (beaconalt contract)
        uint256S("3cb0d638480886a43b0014e5e3ec1cd83d5d987d52913eff0c88139dabdfc605"), //P1875186 (beaconalt contract)
        uint256S("e64d0e3b1885586ce97bb607b650a952559811ae3473581f23c80c2386a68ccf"), //P1883817 (beaconalt contract)
        uint256S("6f3d843eb150afb98751b0bf1d25286f53d86bf9883822bdd0f6e91f3db9ddfd"), //P1884851 (beaconalt contract)
        uint256S("be248382c451f32a485d163098e780c2cbd78f70effafc86d632c2554a081912"), //P1885013 (beaconalt contract)
        uint256S("6058a61b27ae4d060712c454ba8b7436c72d3858164dada274c59b76ebc2d814"), //P1888603 (beaconalt contract)
        uint256S("dec93cbf000d0c9cb64ecf528db6f6c005c4e6133380de935d95c4c1d97a3bde"), //P1888869 (beaconalt contract)
        uint256S("25c164087ab2dc1eb96ed6589d43568bbb17a22fb987c9069053b53fb9548418"), //P1889534 (beaconalt contract)
        uint256S("52f706715f7c90b202b39705eb410f9e3bbf97c47e2cfc130b95954eb767d456"), //P1890348 (beaconalt contract)
        uint256S("b551bb5242c7ad5bdfe4336c26bba9974284abd81b9b39ac4e7044300a47eeb3"), //P1890742 (beaconalt contract)
        uint256S("c0f4a662f41cf3a9aeefc9818344e94b0c615e857293306be5b48e7d42dc2362"), //P1890827 (beaconalt contract)
        uint256S("44e60e6e6bb3414029b4ee4aa9410d3ef089a0dbca645a1d3210aecb3f227a4c"), //P1891639 (beaconalt contract)
        uint256S("89da5f60b6dd1b1560e595d79ecccdb4ec18e27370b2d396d69ebc979930cb43"), //P1895527 (beaconalt contract)
        uint256S("c34642b45b839c9aedb6173e8401c947e47347b90fbc210e3be164c0971033b2"), //P1896499 (beaconalt contract)
        uint256S("c4efca7e9d5cf292f26476e4e8bd597b6350ff58ef47f34084cc8321a1f6d1c1"), //P1896921 (beaconalt contract)
    };

    static const std::set<uint256> bad_blocks_testnet
    {
        // Invalid claims
        uint256S("129ae6779d620ec189f8e5148e205efca2dfe31d9f88004b918da3342157b7ff"), //T407024
        uint256S("c3f85818ba5290aaea1bcbd25b4e136f83acc93999942942bbb25aee2c655f7a"), //T407068
        uint256S("cf7f1316f92547f611852cf738fc7a4a643a2bb5b9290a33cd2f9425f44cc3f9"), //T407099
        uint256S("b47085beb075672c6f20d059633d0cad4dba9c5c20f1853d35455b75dc5d54a9"), //T407117
        uint256S("5a7d437d15bccc41ee8e39143e77960781f3dcf08697a888fa8c4af8a4965682"), //T407161
        uint256S("aeb3c24277ae1047bda548975a515e9d353d6e12a2952fb733da03f92438fb0f"), //T407181
        uint256S("fc584b18239f3e3ea78afbbd33af7c6a29bb518b8299f01c1ed4b52d19413d4f"), //T407214
        uint256S("d5441f7c35eb9ea1b786bbbed820b7f327504301ae70ef2ac3ca3cbc7106236b"), //T479114
        uint256S("18e2ed822c4c5686c0189f60ffbe828fa51e90873cc1ed3e534a257d2f09c360"), //T479282
        uint256S("7cb49bc17ecdb7b3a56e1290496d4866330fc9c7974c65b2034e1c6b951ea0fe"), //T511839
        uint256S("ef0276ace2209c836a84d16e0ce787358a8a1d3da1a8795b6e7697f5c7a26c45"), //T539246 (block span)
        uint256S("66a809c99fd224a9631d38c326c69e8c7e1507ad1a997117a7dd1e7780764d6c"), //T578074 (block span)
        uint256S("8f4f6c5cb17fda158229a627d18d5cff30621e3612f464526f6f356e7a699838"), //T578162 (block span)
        uint256S("c1aa0511add3bed3f2e366d38b954285a7602cae10a7244e7fe35e4002e90cd5"), //T629408
        uint256S("639756cf39bf12a4a0ab4ea5ec10938fd0f463cc7bc1bd2916529a445ceba2ab"), //T680406
        uint256S("ba1aae8ea37a9c330b298bd2b569448f0249a685bb0a8e85698fe44d1edca774"), //T1145954 (6-month cutoff)
        uint256S("b05e6c04c7b414a29746b2d642fd19f64e9fdb13dcc4873144233a23138bd419"), //T1154377 (zero-mag newbie)
        uint256S("99a47d7e8ba54a4444ca9cd762abb6dbac50065968ac1f2012f6f90ca3feb50b"), //T1219105 (returning newbie)
    };
}

const std::set<uint256>& GRC::GetBadBlocks()
{
    return fTestNet
            ? bad_blocks_testnet
            : bad_blocks;
}
