#ifndef BITCOIN_SCRYPT_H
#define BITCOIN_SCRYPT_H

#include <stdlib.h>

class uint256;

uint256 scrypt_salted_multiround_hash(const void* input, size_t inputlen, const void* salt, size_t saltlen, const unsigned int nRounds);
uint256 scrypt_salted_hash(const void* input, size_t inputlen, const void* salt, size_t saltlen);
uint256 scrypt_hash(const void* input, size_t inputlen);
uint256 scrypt_blockhash(const void* input);

#endif // BITCOIN_SCRYPT_H
