/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  /usr/bin/gengetopt -i RNAxplorer.ggo --file-name=RNAxplorer_cmdl --include-getopt --default-optional --func-name=RNAxplorer_cmdline_parser --arg-struct-name=RNAxplorer_args_info

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif


#include "RNAxplorer_cmdl.h"

const char *RNAxplorer_args_info_purpose = "The RNAxplorer is a multitool, that offers different sampling and clustering\nmethods to explore RNA energy landscapes.";

const char *RNAxplorer_args_info_usage = "Usage: RNAxplorer [OPTION]...";

const char *RNAxplorer_args_info_versiontext = "";

const char *RNAxplorer_args_info_description = "The RNAxplorer is a multitool, that offers different methods to explore RNA\nenergy landscapes. In default mode (or with -M RSH option) it takes an RNA\nsequence as input (either stdin or --sequence parameter) and outputs sampled\nsecondary RNA structures. The repellant sampling heuristic iteratively\npenalizes base pairs of local minima of structures that have been seen too\noften. This results in a diverse sample set with the most important low free\nenergy structures.\n Another important sampling method (-M RS option) is based on reference\nstructures (--struc1 and --struc2). This method produces structures in the\nvicinity of these two reference structures. Arbitrary many references can be\nadded if a fasta file is used as input (via stdin).\n Often the output of sampling methods has to be coarse grained by local minima\nthat are defined by a gradient walk. A parallelized gradient descent procedure\ncan be used to retrieve local minima (-M RL option) of sampled structures\n(input via stdin).";

const char *RNAxplorer_args_info_detailed_help[] = {
  "  -h, --help                    Print help and exit",
  "      --detailed-help           Print help, including all details and hidden\n                                  options, and exit",
  "      --full-help               Print help, including hidden options, and exit",
  "  -V, --version                 Print version and exit",
  "\nGeneral Options:",
  "  Below are command line options which alter the general behavior of this\n  program\n\n",
  "  -v, --verbose                 Be verbose\n                                    (default=off)",
  "\nRepulsive Sampling Options:",
  "      --sequence=STRING         Input sequence  (default=`')",
  "      --penalize-structures     Penalize structures instead of base pairs of\n                                  local minima, that occure too often.\n                                  (default=off)",
  "      --struc1=STRING           Input structure 1  (default=`')",
  "      --struc2=STRING           Input structure 2  (default=`')",
  "      --granularity=INT         Granularity, i.e. number of samples after which\n                                  distortion checks are performed\n                                  (default=`100')",
  "  -n, --num-samples=INT         Number of samples in total. The number of\n                                  samples per iteration is n/g.\n                                  (default=`100000')",
  "  -f, --exploration-factor=FLOAT\n                                Exploration factor  (default=`1')",
  "      --min-exploration-percent=FLOAT\n                                Minimum exploration percentage before adding\n                                  new repelled structures  (default=`1')",
  "      --cluster                 Cluster resulting local minima to reduce\n                                  effective size  (default=off)",
  "      --lmin-file=STRING        Output filename for local minima  (default=`')",
  "      --TwoD-file=STRING        Output filename for pseudo-2D file\n                                  (default=`')",
  "      --nonred                  Do sampling with non-redundant pbacktrack\n                                  (default=off)",
  "      --nonred-file=STRING      Input filename for nonredundant samples\n                                  (default=`')",
  "  -2, --explore-two-neighborhood\n                                Explore 2-Neighborhood of local minima, i.e.\n                                  eliminate shallow minima  (default=off)",
  "      --post-filter-two         Post processing Filter local minima according\n                                  to 2-Neighborhood, i.e. eliminate shallow\n                                  minima  (default=off)",
  "      --ediff-penalty           Use energy difference instead of kT for penalty\n                                  (default=off)",
  "      --mu=FLOAT                proportion factor used to decide whether\n                                  sampling round was sufficient\n                                  (default=`0.1')",
  "\nAlgorithms:",
  "  Select additional algorithms which should be included in the calculations.\n  Default is the repellant sampling heuristic. Display more options with\n  --detailed-help.\n\n",
  "  -M, --method=<method>         Set the method used to obtain meshpoint\n                                  structures for the bisection algorithm\n                                    (default=`RSH')",
  "  Available options are:\n   GW        Gradient Walk             (default)\n   MC        Monte Carlo walk\n   MC-SA     Monte Carlo Walk\n               with simulated Annealing\n   DB-MFE    Distance based MFE structure\n               meshpoints\n   TRATES    Transition rate computation\n\n   SM        Stochastic sampling method with 2D mapping (activate distortion\n  with -e\"N\").\n\n   RS        Repellant or Attraction sampling\n\n   RSH       Repellant sampling heuristic\n\n   RL        Retrieve local minima. Standard input should be a sequence and a\n  set of secondary structures (one per line).\n  \\n",
  "      --betaScale=DOUBLE        Set the scaling of the Boltzmann factors\n                                    (default=`1.')",
  "  The argument provided with this option enables to scale the thermodynamic\n  temperature used in the Boltzmann factors independently from the temperature\n  used to scale the individual energy contributions of the loop types. The\n  Boltzmann factors then become exp(-dG/(kT*betaScale)) where k is the\n  Boltzmann constant, dG the free energy contribution of the state and T the\n  absolute temperature.\n\n",
  "  -e, --extended_opt=STRING     Some extended options:\n                                  N    normal distortion (no shift)\n                                  B    alter both potentials at once\n                                  R    relax potential instead of increasing it\n                                  S    shift potential to other structure\n                                  F    shift to first structure\n                                  V    verbose\n\n                                    (default=`')",
  "  -i, --iterations=INT          Set the number of iterations/simulations\n\n                                    (default=`1')",
  "  -m, --maxKeep=INT             maxKeep for direct path search\n\n                                    (default=`10')",
  "  -s, --maxStore=INT            amount of best solutions to hold per iteration\n\n                                    (default=`10')",
  "  -r, --remember=INT            Set the number of structure states to remember\n                                  in a TABU list\n\n                                    (default=`10')",
  "  -c, --circ                    Assume a circular (instead of linear) RNA\n                                  molecule.\n                                    (default=off)",
  "      --cooling-rate=FLOAT      Cooling factor used for simulated annealing\n\n                                    (default=`0.9998')",
  "      --tstart=FLOAT            start temperature in deg. Celcius\n\n                                    (default=`37.0')",
  "      --tstop=FLOAT             stop temperature in deg. Celcius\n\n                                    (default=`0.0')",
  "      --penalizeBackWalks       Add a penalty for backward moves, i.e. moves\n                                  along states already visited\n\n                                    (default=off)",
  "      --basinStructure          just perform a gradient walk starting from a\n                                  given structure\n\n                                    (default=off)",
  "  -D, --maxD=INT                Maximum base pair distance between meshpoints\n                                  and references\n\n                                    (default=`5')",
  "      --maxD1=INT               Maximum base pair distance between meshpoints\n                                  and reference structure 1\n\n                                    (default=`5')",
  "      --maxD2=INT               Maximum base pair distance between meshpoints\n                                  and reference structure 2\n\n                                    (default=`5')",
  "\nModel Details`:",
  "  -T, --temp=DOUBLE             Rescale energy parameters to a temperature of\n                                  temp C. Default is 37C.\n\n",
  "      --p0=STRING               Set the percentage of the references distortion\n                                  value <int> to <double>\n                                  Can be given for all reference indices\n                                  (NOTE: the value <double> should be between 0\n                                  and 1)\n                                  (example: \"--p0 2=0.5\" - distortion value\n                                  of sequence 2 will be multiplied with 0.5\n                                  before sampling.)",
  "\nGradient walker options`:",
  "      --shift_moves             Use shift moves for gradient walks.\n\n                                    (default=off)",
  "  -P, --parameter_file=STRING   Use the given parameter file for gradient\n                                  walks.\n\n",
    0
};
static void
init_full_help_array(void)
{
  RNAxplorer_args_info_full_help[0] = RNAxplorer_args_info_detailed_help[0];
  RNAxplorer_args_info_full_help[1] = RNAxplorer_args_info_detailed_help[1];
  RNAxplorer_args_info_full_help[2] = RNAxplorer_args_info_detailed_help[2];
  RNAxplorer_args_info_full_help[3] = RNAxplorer_args_info_detailed_help[3];
  RNAxplorer_args_info_full_help[4] = RNAxplorer_args_info_detailed_help[4];
  RNAxplorer_args_info_full_help[5] = RNAxplorer_args_info_detailed_help[5];
  RNAxplorer_args_info_full_help[6] = RNAxplorer_args_info_detailed_help[6];
  RNAxplorer_args_info_full_help[7] = RNAxplorer_args_info_detailed_help[7];
  RNAxplorer_args_info_full_help[8] = RNAxplorer_args_info_detailed_help[8];
  RNAxplorer_args_info_full_help[9] = RNAxplorer_args_info_detailed_help[9];
  RNAxplorer_args_info_full_help[10] = RNAxplorer_args_info_detailed_help[10];
  RNAxplorer_args_info_full_help[11] = RNAxplorer_args_info_detailed_help[11];
  RNAxplorer_args_info_full_help[12] = RNAxplorer_args_info_detailed_help[12];
  RNAxplorer_args_info_full_help[13] = RNAxplorer_args_info_detailed_help[13];
  RNAxplorer_args_info_full_help[14] = RNAxplorer_args_info_detailed_help[14];
  RNAxplorer_args_info_full_help[15] = RNAxplorer_args_info_detailed_help[15];
  RNAxplorer_args_info_full_help[16] = RNAxplorer_args_info_detailed_help[16];
  RNAxplorer_args_info_full_help[17] = RNAxplorer_args_info_detailed_help[17];
  RNAxplorer_args_info_full_help[18] = RNAxplorer_args_info_detailed_help[18];
  RNAxplorer_args_info_full_help[19] = RNAxplorer_args_info_detailed_help[19];
  RNAxplorer_args_info_full_help[20] = RNAxplorer_args_info_detailed_help[20];
  RNAxplorer_args_info_full_help[21] = RNAxplorer_args_info_detailed_help[21];
  RNAxplorer_args_info_full_help[22] = RNAxplorer_args_info_detailed_help[22];
  RNAxplorer_args_info_full_help[23] = RNAxplorer_args_info_detailed_help[23];
  RNAxplorer_args_info_full_help[24] = RNAxplorer_args_info_detailed_help[24];
  RNAxplorer_args_info_full_help[25] = RNAxplorer_args_info_detailed_help[25];
  RNAxplorer_args_info_full_help[26] = RNAxplorer_args_info_detailed_help[26];
  RNAxplorer_args_info_full_help[27] = RNAxplorer_args_info_detailed_help[27];
  RNAxplorer_args_info_full_help[28] = RNAxplorer_args_info_detailed_help[29];
  RNAxplorer_args_info_full_help[29] = RNAxplorer_args_info_detailed_help[31];
  RNAxplorer_args_info_full_help[30] = RNAxplorer_args_info_detailed_help[32];
  RNAxplorer_args_info_full_help[31] = RNAxplorer_args_info_detailed_help[33];
  RNAxplorer_args_info_full_help[32] = RNAxplorer_args_info_detailed_help[34];
  RNAxplorer_args_info_full_help[33] = RNAxplorer_args_info_detailed_help[35];
  RNAxplorer_args_info_full_help[34] = RNAxplorer_args_info_detailed_help[36];
  RNAxplorer_args_info_full_help[35] = RNAxplorer_args_info_detailed_help[37];
  RNAxplorer_args_info_full_help[36] = RNAxplorer_args_info_detailed_help[38];
  RNAxplorer_args_info_full_help[37] = RNAxplorer_args_info_detailed_help[39];
  RNAxplorer_args_info_full_help[38] = RNAxplorer_args_info_detailed_help[40];
  RNAxplorer_args_info_full_help[39] = RNAxplorer_args_info_detailed_help[41];
  RNAxplorer_args_info_full_help[40] = RNAxplorer_args_info_detailed_help[42];
  RNAxplorer_args_info_full_help[41] = RNAxplorer_args_info_detailed_help[43];
  RNAxplorer_args_info_full_help[42] = RNAxplorer_args_info_detailed_help[44];
  RNAxplorer_args_info_full_help[43] = RNAxplorer_args_info_detailed_help[45];
  RNAxplorer_args_info_full_help[44] = RNAxplorer_args_info_detailed_help[46];
  RNAxplorer_args_info_full_help[45] = RNAxplorer_args_info_detailed_help[47];
  RNAxplorer_args_info_full_help[46] = RNAxplorer_args_info_detailed_help[48];
  RNAxplorer_args_info_full_help[47] = RNAxplorer_args_info_detailed_help[49];
  RNAxplorer_args_info_full_help[48] = RNAxplorer_args_info_detailed_help[50];
  RNAxplorer_args_info_full_help[49] = 0; 
  
}

const char *RNAxplorer_args_info_full_help[50];

static void
init_help_array(void)
{
  RNAxplorer_args_info_help[0] = RNAxplorer_args_info_detailed_help[0];
  RNAxplorer_args_info_help[1] = RNAxplorer_args_info_detailed_help[1];
  RNAxplorer_args_info_help[2] = RNAxplorer_args_info_detailed_help[2];
  RNAxplorer_args_info_help[3] = RNAxplorer_args_info_detailed_help[3];
  RNAxplorer_args_info_help[4] = RNAxplorer_args_info_detailed_help[4];
  RNAxplorer_args_info_help[5] = RNAxplorer_args_info_detailed_help[5];
  RNAxplorer_args_info_help[6] = RNAxplorer_args_info_detailed_help[6];
  RNAxplorer_args_info_help[7] = RNAxplorer_args_info_detailed_help[7];
  RNAxplorer_args_info_help[8] = RNAxplorer_args_info_detailed_help[8];
  RNAxplorer_args_info_help[9] = RNAxplorer_args_info_detailed_help[9];
  RNAxplorer_args_info_help[10] = RNAxplorer_args_info_detailed_help[10];
  RNAxplorer_args_info_help[11] = RNAxplorer_args_info_detailed_help[11];
  RNAxplorer_args_info_help[12] = RNAxplorer_args_info_detailed_help[12];
  RNAxplorer_args_info_help[13] = RNAxplorer_args_info_detailed_help[13];
  RNAxplorer_args_info_help[14] = RNAxplorer_args_info_detailed_help[14];
  RNAxplorer_args_info_help[15] = RNAxplorer_args_info_detailed_help[15];
  RNAxplorer_args_info_help[16] = RNAxplorer_args_info_detailed_help[16];
  RNAxplorer_args_info_help[17] = RNAxplorer_args_info_detailed_help[17];
  RNAxplorer_args_info_help[18] = RNAxplorer_args_info_detailed_help[18];
  RNAxplorer_args_info_help[19] = RNAxplorer_args_info_detailed_help[19];
  RNAxplorer_args_info_help[20] = RNAxplorer_args_info_detailed_help[20];
  RNAxplorer_args_info_help[21] = RNAxplorer_args_info_detailed_help[21];
  RNAxplorer_args_info_help[22] = RNAxplorer_args_info_detailed_help[22];
  RNAxplorer_args_info_help[23] = RNAxplorer_args_info_detailed_help[23];
  RNAxplorer_args_info_help[24] = RNAxplorer_args_info_detailed_help[24];
  RNAxplorer_args_info_help[25] = RNAxplorer_args_info_detailed_help[25];
  RNAxplorer_args_info_help[26] = RNAxplorer_args_info_detailed_help[26];
  RNAxplorer_args_info_help[27] = RNAxplorer_args_info_detailed_help[27];
  RNAxplorer_args_info_help[28] = RNAxplorer_args_info_detailed_help[31];
  RNAxplorer_args_info_help[29] = RNAxplorer_args_info_detailed_help[32];
  RNAxplorer_args_info_help[30] = RNAxplorer_args_info_detailed_help[33];
  RNAxplorer_args_info_help[31] = RNAxplorer_args_info_detailed_help[34];
  RNAxplorer_args_info_help[32] = RNAxplorer_args_info_detailed_help[35];
  RNAxplorer_args_info_help[33] = RNAxplorer_args_info_detailed_help[36];
  RNAxplorer_args_info_help[34] = RNAxplorer_args_info_detailed_help[37];
  RNAxplorer_args_info_help[35] = RNAxplorer_args_info_detailed_help[38];
  RNAxplorer_args_info_help[36] = RNAxplorer_args_info_detailed_help[39];
  RNAxplorer_args_info_help[37] = RNAxplorer_args_info_detailed_help[40];
  RNAxplorer_args_info_help[38] = RNAxplorer_args_info_detailed_help[41];
  RNAxplorer_args_info_help[39] = RNAxplorer_args_info_detailed_help[42];
  RNAxplorer_args_info_help[40] = RNAxplorer_args_info_detailed_help[43];
  RNAxplorer_args_info_help[41] = RNAxplorer_args_info_detailed_help[44];
  RNAxplorer_args_info_help[42] = RNAxplorer_args_info_detailed_help[45];
  RNAxplorer_args_info_help[43] = RNAxplorer_args_info_detailed_help[46];
  RNAxplorer_args_info_help[44] = RNAxplorer_args_info_detailed_help[47];
  RNAxplorer_args_info_help[45] = RNAxplorer_args_info_detailed_help[48];
  RNAxplorer_args_info_help[46] = RNAxplorer_args_info_detailed_help[49];
  RNAxplorer_args_info_help[47] = RNAxplorer_args_info_detailed_help[50];
  RNAxplorer_args_info_help[48] = 0; 
  
}

const char *RNAxplorer_args_info_help[49];

typedef enum {ARG_NO
  , ARG_FLAG
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
  , ARG_DOUBLE
} RNAxplorer_cmdline_parser_arg_type;

static
void clear_given (struct RNAxplorer_args_info *args_info);
static
void clear_args (struct RNAxplorer_args_info *args_info);

static int
RNAxplorer_cmdline_parser_internal (int argc, char **argv, struct RNAxplorer_args_info *args_info,
                        struct RNAxplorer_cmdline_parser_params *params, const char *additional_error);

static int
RNAxplorer_cmdline_parser_required2 (struct RNAxplorer_args_info *args_info, const char *prog_name, const char *additional_error);

static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct RNAxplorer_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->detailed_help_given = 0 ;
  args_info->full_help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->sequence_given = 0 ;
  args_info->penalize_structures_given = 0 ;
  args_info->struc1_given = 0 ;
  args_info->struc2_given = 0 ;
  args_info->granularity_given = 0 ;
  args_info->num_samples_given = 0 ;
  args_info->exploration_factor_given = 0 ;
  args_info->min_exploration_percent_given = 0 ;
  args_info->cluster_given = 0 ;
  args_info->lmin_file_given = 0 ;
  args_info->TwoD_file_given = 0 ;
  args_info->nonred_given = 0 ;
  args_info->nonred_file_given = 0 ;
  args_info->explore_two_neighborhood_given = 0 ;
  args_info->post_filter_two_given = 0 ;
  args_info->ediff_penalty_given = 0 ;
  args_info->mu_given = 0 ;
  args_info->method_given = 0 ;
  args_info->betaScale_given = 0 ;
  args_info->extended_opt_given = 0 ;
  args_info->iterations_given = 0 ;
  args_info->maxKeep_given = 0 ;
  args_info->maxStore_given = 0 ;
  args_info->remember_given = 0 ;
  args_info->circ_given = 0 ;
  args_info->cooling_rate_given = 0 ;
  args_info->tstart_given = 0 ;
  args_info->tstop_given = 0 ;
  args_info->penalizeBackWalks_given = 0 ;
  args_info->basinStructure_given = 0 ;
  args_info->maxD_given = 0 ;
  args_info->maxD1_given = 0 ;
  args_info->maxD2_given = 0 ;
  args_info->temp_given = 0 ;
  args_info->p0_given = 0 ;
  args_info->shift_moves_given = 0 ;
  args_info->parameter_file_given = 0 ;
}

static
void clear_args (struct RNAxplorer_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->verbose_flag = 0;
  args_info->sequence_arg = gengetopt_strdup ("");
  args_info->sequence_orig = NULL;
  args_info->penalize_structures_flag = 0;
  args_info->struc1_arg = gengetopt_strdup ("");
  args_info->struc1_orig = NULL;
  args_info->struc2_arg = gengetopt_strdup ("");
  args_info->struc2_orig = NULL;
  args_info->granularity_arg = 100;
  args_info->granularity_orig = NULL;
  args_info->num_samples_arg = 100000;
  args_info->num_samples_orig = NULL;
  args_info->exploration_factor_arg = 1;
  args_info->exploration_factor_orig = NULL;
  args_info->min_exploration_percent_arg = 1;
  args_info->min_exploration_percent_orig = NULL;
  args_info->cluster_flag = 0;
  args_info->lmin_file_arg = gengetopt_strdup ("");
  args_info->lmin_file_orig = NULL;
  args_info->TwoD_file_arg = gengetopt_strdup ("");
  args_info->TwoD_file_orig = NULL;
  args_info->nonred_flag = 0;
  args_info->nonred_file_arg = gengetopt_strdup ("");
  args_info->nonred_file_orig = NULL;
  args_info->explore_two_neighborhood_flag = 0;
  args_info->post_filter_two_flag = 0;
  args_info->ediff_penalty_flag = 0;
  args_info->mu_arg = 0.1;
  args_info->mu_orig = NULL;
  args_info->method_arg = gengetopt_strdup ("RSH");
  args_info->method_orig = NULL;
  args_info->betaScale_arg = 1.;
  args_info->betaScale_orig = NULL;
  args_info->extended_opt_arg = gengetopt_strdup ("");
  args_info->extended_opt_orig = NULL;
  args_info->iterations_arg = 1;
  args_info->iterations_orig = NULL;
  args_info->maxKeep_arg = 10;
  args_info->maxKeep_orig = NULL;
  args_info->maxStore_arg = 10;
  args_info->maxStore_orig = NULL;
  args_info->remember_arg = 10;
  args_info->remember_orig = NULL;
  args_info->circ_flag = 0;
  args_info->cooling_rate_arg = 0.9998;
  args_info->cooling_rate_orig = NULL;
  args_info->tstart_arg = 37.0;
  args_info->tstart_orig = NULL;
  args_info->tstop_arg = 0.0;
  args_info->tstop_orig = NULL;
  args_info->penalizeBackWalks_flag = 0;
  args_info->basinStructure_flag = 0;
  args_info->maxD_arg = 5;
  args_info->maxD_orig = NULL;
  args_info->maxD1_arg = 5;
  args_info->maxD1_orig = NULL;
  args_info->maxD2_arg = 5;
  args_info->maxD2_orig = NULL;
  args_info->temp_orig = NULL;
  args_info->p0_arg = NULL;
  args_info->p0_orig = NULL;
  args_info->shift_moves_flag = 0;
  args_info->parameter_file_arg = NULL;
  args_info->parameter_file_orig = NULL;
  
}

static
void init_args_info(struct RNAxplorer_args_info *args_info)
{
  init_full_help_array(); 
  init_help_array(); 
  args_info->help_help = RNAxplorer_args_info_detailed_help[0] ;
  args_info->detailed_help_help = RNAxplorer_args_info_detailed_help[1] ;
  args_info->full_help_help = RNAxplorer_args_info_detailed_help[2] ;
  args_info->version_help = RNAxplorer_args_info_detailed_help[3] ;
  args_info->verbose_help = RNAxplorer_args_info_detailed_help[6] ;
  args_info->sequence_help = RNAxplorer_args_info_detailed_help[8] ;
  args_info->penalize_structures_help = RNAxplorer_args_info_detailed_help[9] ;
  args_info->struc1_help = RNAxplorer_args_info_detailed_help[10] ;
  args_info->struc2_help = RNAxplorer_args_info_detailed_help[11] ;
  args_info->granularity_help = RNAxplorer_args_info_detailed_help[12] ;
  args_info->num_samples_help = RNAxplorer_args_info_detailed_help[13] ;
  args_info->exploration_factor_help = RNAxplorer_args_info_detailed_help[14] ;
  args_info->min_exploration_percent_help = RNAxplorer_args_info_detailed_help[15] ;
  args_info->cluster_help = RNAxplorer_args_info_detailed_help[16] ;
  args_info->lmin_file_help = RNAxplorer_args_info_detailed_help[17] ;
  args_info->TwoD_file_help = RNAxplorer_args_info_detailed_help[18] ;
  args_info->nonred_help = RNAxplorer_args_info_detailed_help[19] ;
  args_info->nonred_file_help = RNAxplorer_args_info_detailed_help[20] ;
  args_info->explore_two_neighborhood_help = RNAxplorer_args_info_detailed_help[21] ;
  args_info->post_filter_two_help = RNAxplorer_args_info_detailed_help[22] ;
  args_info->ediff_penalty_help = RNAxplorer_args_info_detailed_help[23] ;
  args_info->mu_help = RNAxplorer_args_info_detailed_help[24] ;
  args_info->method_help = RNAxplorer_args_info_detailed_help[27] ;
  args_info->betaScale_help = RNAxplorer_args_info_detailed_help[29] ;
  args_info->extended_opt_help = RNAxplorer_args_info_detailed_help[31] ;
  args_info->iterations_help = RNAxplorer_args_info_detailed_help[32] ;
  args_info->maxKeep_help = RNAxplorer_args_info_detailed_help[33] ;
  args_info->maxStore_help = RNAxplorer_args_info_detailed_help[34] ;
  args_info->remember_help = RNAxplorer_args_info_detailed_help[35] ;
  args_info->circ_help = RNAxplorer_args_info_detailed_help[36] ;
  args_info->cooling_rate_help = RNAxplorer_args_info_detailed_help[37] ;
  args_info->tstart_help = RNAxplorer_args_info_detailed_help[38] ;
  args_info->tstop_help = RNAxplorer_args_info_detailed_help[39] ;
  args_info->penalizeBackWalks_help = RNAxplorer_args_info_detailed_help[40] ;
  args_info->basinStructure_help = RNAxplorer_args_info_detailed_help[41] ;
  args_info->maxD_help = RNAxplorer_args_info_detailed_help[42] ;
  args_info->maxD1_help = RNAxplorer_args_info_detailed_help[43] ;
  args_info->maxD2_help = RNAxplorer_args_info_detailed_help[44] ;
  args_info->temp_help = RNAxplorer_args_info_detailed_help[46] ;
  args_info->p0_help = RNAxplorer_args_info_detailed_help[47] ;
  args_info->p0_min = 0;
  args_info->p0_max = 0;
  args_info->shift_moves_help = RNAxplorer_args_info_detailed_help[49] ;
  args_info->parameter_file_help = RNAxplorer_args_info_detailed_help[50] ;
  
}

void
RNAxplorer_cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(RNAXPLORER_CMDLINE_PARSER_PACKAGE_NAME) ? RNAXPLORER_CMDLINE_PARSER_PACKAGE_NAME : RNAXPLORER_CMDLINE_PARSER_PACKAGE),
     RNAXPLORER_CMDLINE_PARSER_VERSION);

  if (strlen(RNAxplorer_args_info_versiontext) > 0)
    printf("\n%s\n", RNAxplorer_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(RNAxplorer_args_info_purpose);
	size_t len_usage = strlen(RNAxplorer_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", RNAxplorer_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", RNAxplorer_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(RNAxplorer_args_info_description) > 0) {
		printf("%s\n\n", RNAxplorer_args_info_description);
	}
}

void
RNAxplorer_cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAxplorer_args_info_help[i])
    printf("%s\n", RNAxplorer_args_info_help[i++]);
}

void
RNAxplorer_cmdline_parser_print_full_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAxplorer_args_info_full_help[i])
    printf("%s\n", RNAxplorer_args_info_full_help[i++]);
}

void
RNAxplorer_cmdline_parser_print_detailed_help (void)
{
  int i = 0;
  print_help_common();
  while (RNAxplorer_args_info_detailed_help[i])
    printf("%s\n", RNAxplorer_args_info_detailed_help[i++]);
}

void
RNAxplorer_cmdline_parser_init (struct RNAxplorer_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);
}

void
RNAxplorer_cmdline_parser_params_init(struct RNAxplorer_cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct RNAxplorer_cmdline_parser_params *
RNAxplorer_cmdline_parser_params_create(void)
{
  struct RNAxplorer_cmdline_parser_params *params = 
    (struct RNAxplorer_cmdline_parser_params *)malloc(sizeof(struct RNAxplorer_cmdline_parser_params));
  RNAxplorer_cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}

/** @brief generic value variable */
union generic_value {
    int int_arg;
    float float_arg;
    double double_arg;
    char *string_arg;
    const char *default_string_arg;
};

/** @brief holds temporary values for multiple options */
struct generic_list
{
  union generic_value arg;
  char *orig;
  struct generic_list *next;
};

/**
 * @brief add a node at the head of the list 
 */
static void add_node(struct generic_list **list) {
  struct generic_list *new_node = (struct generic_list *) malloc (sizeof (struct generic_list));
  new_node->next = *list;
  *list = new_node;
  new_node->arg.string_arg = 0;
  new_node->orig = 0;
}


static void
free_multiple_string_field(unsigned int len, char ***arg, char ***orig)
{
  unsigned int i;
  if (*arg) {
    for (i = 0; i < len; ++i)
      {
        free_string_field(&((*arg)[i]));
        free_string_field(&((*orig)[i]));
      }
    free_string_field(&((*arg)[0])); /* free default string */

    free (*arg);
    *arg = 0;
    free (*orig);
    *orig = 0;
  }
}

static void
RNAxplorer_cmdline_parser_release (struct RNAxplorer_args_info *args_info)
{

  free_string_field (&(args_info->sequence_arg));
  free_string_field (&(args_info->sequence_orig));
  free_string_field (&(args_info->struc1_arg));
  free_string_field (&(args_info->struc1_orig));
  free_string_field (&(args_info->struc2_arg));
  free_string_field (&(args_info->struc2_orig));
  free_string_field (&(args_info->granularity_orig));
  free_string_field (&(args_info->num_samples_orig));
  free_string_field (&(args_info->exploration_factor_orig));
  free_string_field (&(args_info->min_exploration_percent_orig));
  free_string_field (&(args_info->lmin_file_arg));
  free_string_field (&(args_info->lmin_file_orig));
  free_string_field (&(args_info->TwoD_file_arg));
  free_string_field (&(args_info->TwoD_file_orig));
  free_string_field (&(args_info->nonred_file_arg));
  free_string_field (&(args_info->nonred_file_orig));
  free_string_field (&(args_info->mu_orig));
  free_string_field (&(args_info->method_arg));
  free_string_field (&(args_info->method_orig));
  free_string_field (&(args_info->betaScale_orig));
  free_string_field (&(args_info->extended_opt_arg));
  free_string_field (&(args_info->extended_opt_orig));
  free_string_field (&(args_info->iterations_orig));
  free_string_field (&(args_info->maxKeep_orig));
  free_string_field (&(args_info->maxStore_orig));
  free_string_field (&(args_info->remember_orig));
  free_string_field (&(args_info->cooling_rate_orig));
  free_string_field (&(args_info->tstart_orig));
  free_string_field (&(args_info->tstop_orig));
  free_string_field (&(args_info->maxD_orig));
  free_string_field (&(args_info->maxD1_orig));
  free_string_field (&(args_info->maxD2_orig));
  free_string_field (&(args_info->temp_orig));
  free_multiple_string_field (args_info->p0_given, &(args_info->p0_arg), &(args_info->p0_orig));
  free_string_field (&(args_info->parameter_file_arg));
  free_string_field (&(args_info->parameter_file_orig));
  
  

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}

static void
write_multiple_into_file(FILE *outfile, int len, const char *opt, char **arg, const char *values[])
{
  int i;
  
  for (i = 0; i < len; ++i)
    write_into_file(outfile, opt, (arg ? arg[i] : 0), values);
}

int
RNAxplorer_cmdline_parser_dump(FILE *outfile, struct RNAxplorer_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", RNAXPLORER_CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->detailed_help_given)
    write_into_file(outfile, "detailed-help", 0, 0 );
  if (args_info->full_help_given)
    write_into_file(outfile, "full-help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  if (args_info->verbose_given)
    write_into_file(outfile, "verbose", 0, 0 );
  if (args_info->sequence_given)
    write_into_file(outfile, "sequence", args_info->sequence_orig, 0);
  if (args_info->penalize_structures_given)
    write_into_file(outfile, "penalize-structures", 0, 0 );
  if (args_info->struc1_given)
    write_into_file(outfile, "struc1", args_info->struc1_orig, 0);
  if (args_info->struc2_given)
    write_into_file(outfile, "struc2", args_info->struc2_orig, 0);
  if (args_info->granularity_given)
    write_into_file(outfile, "granularity", args_info->granularity_orig, 0);
  if (args_info->num_samples_given)
    write_into_file(outfile, "num-samples", args_info->num_samples_orig, 0);
  if (args_info->exploration_factor_given)
    write_into_file(outfile, "exploration-factor", args_info->exploration_factor_orig, 0);
  if (args_info->min_exploration_percent_given)
    write_into_file(outfile, "min-exploration-percent", args_info->min_exploration_percent_orig, 0);
  if (args_info->cluster_given)
    write_into_file(outfile, "cluster", 0, 0 );
  if (args_info->lmin_file_given)
    write_into_file(outfile, "lmin-file", args_info->lmin_file_orig, 0);
  if (args_info->TwoD_file_given)
    write_into_file(outfile, "TwoD-file", args_info->TwoD_file_orig, 0);
  if (args_info->nonred_given)
    write_into_file(outfile, "nonred", 0, 0 );
  if (args_info->nonred_file_given)
    write_into_file(outfile, "nonred-file", args_info->nonred_file_orig, 0);
  if (args_info->explore_two_neighborhood_given)
    write_into_file(outfile, "explore-two-neighborhood", 0, 0 );
  if (args_info->post_filter_two_given)
    write_into_file(outfile, "post-filter-two", 0, 0 );
  if (args_info->ediff_penalty_given)
    write_into_file(outfile, "ediff-penalty", 0, 0 );
  if (args_info->mu_given)
    write_into_file(outfile, "mu", args_info->mu_orig, 0);
  if (args_info->method_given)
    write_into_file(outfile, "method", args_info->method_orig, 0);
  if (args_info->betaScale_given)
    write_into_file(outfile, "betaScale", args_info->betaScale_orig, 0);
  if (args_info->extended_opt_given)
    write_into_file(outfile, "extended_opt", args_info->extended_opt_orig, 0);
  if (args_info->iterations_given)
    write_into_file(outfile, "iterations", args_info->iterations_orig, 0);
  if (args_info->maxKeep_given)
    write_into_file(outfile, "maxKeep", args_info->maxKeep_orig, 0);
  if (args_info->maxStore_given)
    write_into_file(outfile, "maxStore", args_info->maxStore_orig, 0);
  if (args_info->remember_given)
    write_into_file(outfile, "remember", args_info->remember_orig, 0);
  if (args_info->circ_given)
    write_into_file(outfile, "circ", 0, 0 );
  if (args_info->cooling_rate_given)
    write_into_file(outfile, "cooling-rate", args_info->cooling_rate_orig, 0);
  if (args_info->tstart_given)
    write_into_file(outfile, "tstart", args_info->tstart_orig, 0);
  if (args_info->tstop_given)
    write_into_file(outfile, "tstop", args_info->tstop_orig, 0);
  if (args_info->penalizeBackWalks_given)
    write_into_file(outfile, "penalizeBackWalks", 0, 0 );
  if (args_info->basinStructure_given)
    write_into_file(outfile, "basinStructure", 0, 0 );
  if (args_info->maxD_given)
    write_into_file(outfile, "maxD", args_info->maxD_orig, 0);
  if (args_info->maxD1_given)
    write_into_file(outfile, "maxD1", args_info->maxD1_orig, 0);
  if (args_info->maxD2_given)
    write_into_file(outfile, "maxD2", args_info->maxD2_orig, 0);
  if (args_info->temp_given)
    write_into_file(outfile, "temp", args_info->temp_orig, 0);
  write_multiple_into_file(outfile, args_info->p0_given, "p0", args_info->p0_orig, 0);
  if (args_info->shift_moves_given)
    write_into_file(outfile, "shift_moves", 0, 0 );
  if (args_info->parameter_file_given)
    write_into_file(outfile, "parameter_file", args_info->parameter_file_orig, 0);
  

  i = EXIT_SUCCESS;
  return i;
}

int
RNAxplorer_cmdline_parser_file_save(const char *filename, struct RNAxplorer_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", RNAXPLORER_CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = RNAxplorer_cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
RNAxplorer_cmdline_parser_free (struct RNAxplorer_args_info *args_info)
{
  RNAxplorer_cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

static char *
get_multiple_arg_token(const char *arg)
{
  const char *tok;
  char *ret;
  size_t len, num_of_escape, i, j;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');
  num_of_escape = 0;

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
          ++num_of_escape;
        }
      else
        break;
    }

  if (tok)
    len = (size_t)(tok - arg + 1);
  else
    len = strlen (arg) + 1;

  len -= num_of_escape;

  ret = (char *) malloc (len);

  i = 0;
  j = 0;
  while (arg[i] && (j < len-1))
    {
      if (arg[i] == '\\' && 
	  arg[ i + 1 ] && 
	  arg[ i + 1 ] == ',')
        ++i;

      ret[j++] = arg[i++];
    }

  ret[len-1] = '\0';

  return ret;
}

static const char *
get_multiple_arg_token_next(const char *arg)
{
  const char *tok;

  if (!arg)
    return 0;

  tok = strchr (arg, ',');

  /* make sure it is not escaped */
  while (tok)
    {
      if (*(tok-1) == '\\')
        {
          /* find the next one */
          tok = strchr (tok+1, ',');
        }
      else
        break;
    }

  if (! tok || strlen(tok) == 1)
    return 0;

  return tok+1;
}

static int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc);

int
check_multiple_option_occurrences(const char *prog_name, unsigned int option_given, unsigned int min, unsigned int max, const char *option_desc)
{
  int error_occurred = 0;

  if (option_given && (min > 0 || max > 0))
    {
      if (min > 0 && max > 0)
        {
          if (min == max)
            {
              /* specific occurrences */
              if (option_given != (unsigned int) min)
                {
                  fprintf (stderr, "%s: %s option occurrences must be %d\n",
                    prog_name, option_desc, min);
                  error_occurred = 1;
                }
            }
          else if (option_given < (unsigned int) min
                || option_given > (unsigned int) max)
            {
              /* range occurrences */
              fprintf (stderr, "%s: %s option occurrences must be between %d and %d\n",
                prog_name, option_desc, min, max);
              error_occurred = 1;
            }
        }
      else if (min > 0)
        {
          /* at least check */
          if (option_given < min)
            {
              fprintf (stderr, "%s: %s option occurrences must be at least %d\n",
                prog_name, option_desc, min);
              error_occurred = 1;
            }
        }
      else if (max > 0)
        {
          /* at most check */
          if (option_given > max)
            {
              fprintf (stderr, "%s: %s option occurrences must be at most %d\n",
                prog_name, option_desc, max);
              error_occurred = 1;
            }
        }
    }
    
  return error_occurred;
}
int
RNAxplorer_cmdline_parser (int argc, char **argv, struct RNAxplorer_args_info *args_info)
{
  return RNAxplorer_cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
RNAxplorer_cmdline_parser_ext (int argc, char **argv, struct RNAxplorer_args_info *args_info,
                   struct RNAxplorer_cmdline_parser_params *params)
{
  int result;
  result = RNAxplorer_cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAxplorer_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAxplorer_cmdline_parser2 (int argc, char **argv, struct RNAxplorer_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct RNAxplorer_cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = RNAxplorer_cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      RNAxplorer_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAxplorer_cmdline_parser_required (struct RNAxplorer_args_info *args_info, const char *prog_name)
{
  int result = EXIT_SUCCESS;

  if (RNAxplorer_cmdline_parser_required2(args_info, prog_name, 0) > 0)
    result = EXIT_FAILURE;

  if (result == EXIT_FAILURE)
    {
      RNAxplorer_cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
RNAxplorer_cmdline_parser_required2 (struct RNAxplorer_args_info *args_info, const char *prog_name, const char *additional_error)
{
  int error_occurred = 0;
  FIX_UNUSED (additional_error);

  /* checks for required options */
  if (check_multiple_option_occurrences(prog_name, args_info->p0_given, args_info->p0_min, args_info->p0_max, "'--p0'"))
     error_occurred = 1;
  
  
  /* checks for dependences among options */

  return error_occurred;
}

/*
 * Extracted from the glibc source tree, version 2.3.6
 *
 * Licensed under the GPL as per the whole glibc source tree.
 *
 * This file was modified so that getopt_long can be called
 * many times without risking previous memory to be spoiled.
 *
 * Modified by Andre Noll and Lorenzo Bettini for use in
 * GNU gengetopt generated files.
 *
 */

/* 
 * we must include anything we need since this file is not thought to be
 * inserted in a file already using getopt.h
 *
 * Lorenzo
 */

struct option
{
  const char *name;
  /* has_arg can't be an enum because some compilers complain about
     type mismatches in all the code that assumes it is an int.  */
  int has_arg;
  int *flag;
  int val;
};

/* This version of `getopt' appears to the caller like standard Unix `getopt'
   but it behaves differently for the user, since it allows the user
   to intersperse the options with the other arguments.

   As `getopt' works, it permutes the elements of ARGV so that,
   when it is done, all the options precede everything else.  Thus
   all application programs are extended to handle flexible argument order.
*/
/*
   If the field `flag' is not NULL, it points to a variable that is set
   to the value given in the field `val' when the option is found, but
   left unchanged if the option is not found.

   To have a long-named option do something other than set an `int' to
   a compiled-in constant, such as set a value from `custom_optarg', set the
   option's `flag' field to zero and its `val' field to a nonzero
   value (the equivalent single-letter option character, if there is
   one).  For long options that have a zero `flag' field, `getopt'
   returns the contents of the `val' field.  */

/* Names for the values of the `has_arg' field of `struct option'.  */
#ifndef no_argument
#define no_argument		0
#endif

#ifndef required_argument
#define required_argument	1
#endif

#ifndef optional_argument
#define optional_argument	2
#endif

struct custom_getopt_data {
	/*
	 * These have exactly the same meaning as the corresponding global variables,
	 * except that they are used for the reentrant versions of getopt.
	 */
	int custom_optind;
	int custom_opterr;
	int custom_optopt;
	char *custom_optarg;

	/* True if the internal members have been initialized.  */
	int initialized;

	/*
	 * The next char to be scanned in the option-element in which the last option
	 * character we returned was found.  This allows us to pick up the scan where
	 * we left off.  If this is zero, or a null string, it means resume the scan by
	 * advancing to the next ARGV-element.
	 */
	char *nextchar;

	/*
	 * Describe the part of ARGV that contains non-options that have been skipped.
	 * `first_nonopt' is the index in ARGV of the first of them; `last_nonopt' is
	 * the index after the last of them.
	 */
	int first_nonopt;
	int last_nonopt;
};

/*
 * the variables optarg, optind, opterr and optopt are renamed with
 * the custom_ prefix so that they don't interfere with getopt ones.
 *
 * Moreover they're static so they are visible only from within the
 * file where this very file will be included.
 */

/*
 * For communication from `custom_getopt' to the caller.  When `custom_getopt' finds an
 * option that takes an argument, the argument value is returned here.
 */
static char *custom_optarg;

/*
 * Index in ARGV of the next element to be scanned.  This is used for
 * communication to and from the caller and for communication between
 * successive calls to `custom_getopt'.
 *
 * On entry to `custom_getopt', 1 means this is the first call; initialize.
 *
 * When `custom_getopt' returns -1, this is the index of the first of the non-option
 * elements that the caller should itself scan.
 *
 * Otherwise, `custom_optind' communicates from one call to the next how much of ARGV
 * has been scanned so far.
 *
 * 1003.2 says this must be 1 before any call.
 */
static int custom_optind = 1;

/*
 * Callers store zero here to inhibit the error message for unrecognized
 * options.
 */
static int custom_opterr = 1;

/*
 * Set to an option character which was unrecognized.  This must be initialized
 * on some systems to avoid linking in the system's own getopt implementation.
 */
static int custom_optopt = '?';

/*
 * Exchange two adjacent subsequences of ARGV.  One subsequence is elements
 * [first_nonopt,last_nonopt) which contains all the non-options that have been
 * skipped so far.  The other is elements [last_nonopt,custom_optind), which contains
 * all the options processed since those non-options were skipped.
 * `first_nonopt' and `last_nonopt' are relocated so that they describe the new
 * indices of the non-options in ARGV after they are moved.
 */
static void exchange(char **argv, struct custom_getopt_data *d)
{
	int bottom = d->first_nonopt;
	int middle = d->last_nonopt;
	int top = d->custom_optind;
	char *tem;

	/*
	 * Exchange the shorter segment with the far end of the longer segment.
	 * That puts the shorter segment into the right place.  It leaves the
	 * longer segment in the right place overall, but it consists of two
	 * parts that need to be swapped next.
	 */
	while (top > middle && middle > bottom) {
		if (top - middle > middle - bottom) {
			/* Bottom segment is the short one.  */
			int len = middle - bottom;
			int i;

			/* Swap it with the top part of the top segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] =
					argv[top - (middle - bottom) + i];
				argv[top - (middle - bottom) + i] = tem;
			}
			/* Exclude the moved bottom segment from further swapping.  */
			top -= len;
		} else {
			/* Top segment is the short one.  */
			int len = top - middle;
			int i;

			/* Swap it with the bottom part of the bottom segment.  */
			for (i = 0; i < len; i++) {
				tem = argv[bottom + i];
				argv[bottom + i] = argv[middle + i];
				argv[middle + i] = tem;
			}
			/* Exclude the moved top segment from further swapping.  */
			bottom += len;
		}
	}
	/* Update records for the slots the non-options now occupy.  */
	d->first_nonopt += (d->custom_optind - d->last_nonopt);
	d->last_nonopt = d->custom_optind;
}

/* Initialize the internal data when the first call is made.  */
static void custom_getopt_initialize(struct custom_getopt_data *d)
{
	/*
	 * Start processing options with ARGV-element 1 (since ARGV-element 0
	 * is the program name); the sequence of previously skipped non-option
	 * ARGV-elements is empty.
	 */
	d->first_nonopt = d->last_nonopt = d->custom_optind;
	d->nextchar = NULL;
	d->initialized = 1;
}

#define NONOPTION_P (argv[d->custom_optind][0] != '-' || argv[d->custom_optind][1] == '\0')

/* return: zero: continue, nonzero: return given value to user */
static int shuffle_argv(int argc, char *const *argv,const struct option *longopts,
	struct custom_getopt_data *d)
{
	/*
	 * Give FIRST_NONOPT & LAST_NONOPT rational values if CUSTOM_OPTIND has been
	 * moved back by the user (who may also have changed the arguments).
	 */
	if (d->last_nonopt > d->custom_optind)
		d->last_nonopt = d->custom_optind;
	if (d->first_nonopt > d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * If we have just processed some options following some
	 * non-options, exchange them so that the options come first.
	 */
	if (d->first_nonopt != d->last_nonopt &&
			d->last_nonopt != d->custom_optind)
		exchange((char **) argv, d);
	else if (d->last_nonopt != d->custom_optind)
		d->first_nonopt = d->custom_optind;
	/*
	 * Skip any additional non-options and extend the range of
	 * non-options previously skipped.
	 */
	while (d->custom_optind < argc && NONOPTION_P)
		d->custom_optind++;
	d->last_nonopt = d->custom_optind;
	/*
	 * The special ARGV-element `--' means premature end of options.  Skip
	 * it like a null option, then exchange with previous non-options as if
	 * it were an option, then skip everything else like a non-option.
	 */
	if (d->custom_optind != argc && !strcmp(argv[d->custom_optind], "--")) {
		d->custom_optind++;
		if (d->first_nonopt != d->last_nonopt
				&& d->last_nonopt != d->custom_optind)
			exchange((char **) argv, d);
		else if (d->first_nonopt == d->last_nonopt)
			d->first_nonopt = d->custom_optind;
		d->last_nonopt = argc;
		d->custom_optind = argc;
	}
	/*
	 * If we have done all the ARGV-elements, stop the scan and back over
	 * any non-options that we skipped and permuted.
	 */
	if (d->custom_optind == argc) {
		/*
		 * Set the next-arg-index to point at the non-options that we
		 * previously skipped, so the caller will digest them.
		 */
		if (d->first_nonopt != d->last_nonopt)
			d->custom_optind = d->first_nonopt;
		return -1;
	}
	/*
	 * If we have come to a non-option and did not permute it, either stop
	 * the scan or describe it to the caller and pass it by.
	 */
	if (NONOPTION_P) {
		d->custom_optarg = argv[d->custom_optind++];
		return 1;
	}
	/*
	 * We have found another option-ARGV-element. Skip the initial
	 * punctuation.
	 */
	d->nextchar = (argv[d->custom_optind] + 1 + (longopts != NULL && argv[d->custom_optind][1] == '-'));
	return 0;
}

/*
 * Check whether the ARGV-element is a long option.
 *
 * If there's a long option "fubar" and the ARGV-element is "-fu", consider
 * that an abbreviation of the long option, just like "--fu", and not "-f" with
 * arg "u".
 *
 * This distinction seems to be the most useful approach.
 *
 */
static int check_long_opt(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		int print_errors, struct custom_getopt_data *d)
{
	char *nameend;
	const struct option *p;
	const struct option *pfound = NULL;
	int exact = 0;
	int ambig = 0;
	int indfound = -1;
	int option_index;

	for (nameend = d->nextchar; *nameend && *nameend != '='; nameend++)
		/* Do nothing.  */ ;

	/* Test all long options for either exact match or abbreviated matches */
	for (p = longopts, option_index = 0; p->name; p++, option_index++)
		if (!strncmp(p->name, d->nextchar, nameend - d->nextchar)) {
			if ((unsigned int) (nameend - d->nextchar)
					== (unsigned int) strlen(p->name)) {
				/* Exact match found.  */
				pfound = p;
				indfound = option_index;
				exact = 1;
				break;
			} else if (pfound == NULL) {
				/* First nonexact match found.  */
				pfound = p;
				indfound = option_index;
			} else if (pfound->has_arg != p->has_arg
					|| pfound->flag != p->flag
					|| pfound->val != p->val)
				/* Second or later nonexact match found.  */
				ambig = 1;
		}
	if (ambig && !exact) {
		if (print_errors) {
			fprintf(stderr,
				"%s: option `%s' is ambiguous\n",
				argv[0], argv[d->custom_optind]);
		}
		d->nextchar += strlen(d->nextchar);
		d->custom_optind++;
		d->custom_optopt = 0;
		return '?';
	}
	if (pfound) {
		option_index = indfound;
		d->custom_optind++;
		if (*nameend) {
			if (pfound->has_arg != no_argument)
				d->custom_optarg = nameend + 1;
			else {
				if (print_errors) {
					if (argv[d->custom_optind - 1][1] == '-') {
						/* --option */
						fprintf(stderr, "%s: option `--%s' doesn't allow an argument\n",
							argv[0], pfound->name);
					} else {
						/* +option or -option */
						fprintf(stderr, "%s: option `%c%s' doesn't allow an argument\n",
							argv[0], argv[d->custom_optind - 1][0], pfound->name);
					}

				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return '?';
			}
		} else if (pfound->has_arg == required_argument) {
			if (d->custom_optind < argc)
				d->custom_optarg = argv[d->custom_optind++];
			else {
				if (print_errors) {
					fprintf(stderr,
						"%s: option `%s' requires an argument\n",
						argv[0],
						argv[d->custom_optind - 1]);
				}
				d->nextchar += strlen(d->nextchar);
				d->custom_optopt = pfound->val;
				return optstring[0] == ':' ? ':' : '?';
			}
		}
		d->nextchar += strlen(d->nextchar);
		if (longind != NULL)
			*longind = option_index;
		if (pfound->flag) {
			*(pfound->flag) = pfound->val;
			return 0;
		}
		return pfound->val;
	}
	/*
	 * Can't find it as a long option.  If this is not getopt_long_only, or
	 * the option starts with '--' or is not a valid short option, then
	 * it's an error.  Otherwise interpret it as a short option.
	 */
	if (print_errors) {
		if (argv[d->custom_optind][1] == '-') {
			/* --option */
			fprintf(stderr,
				"%s: unrecognized option `--%s'\n",
				argv[0], d->nextchar);
		} else {
			/* +option or -option */
			fprintf(stderr,
				"%s: unrecognized option `%c%s'\n",
				argv[0], argv[d->custom_optind][0],
				d->nextchar);
		}
	}
	d->nextchar = (char *) "";
	d->custom_optind++;
	d->custom_optopt = 0;
	return '?';
}

static int check_short_opt(int argc, char *const *argv, const char *optstring,
		int print_errors, struct custom_getopt_data *d)
{
	char c = *d->nextchar++;
	const char *temp = strchr(optstring, c);

	/* Increment `custom_optind' when we start to process its last character.  */
	if (*d->nextchar == '\0')
		++d->custom_optind;
	if (!temp || c == ':') {
		if (print_errors)
			fprintf(stderr, "%s: invalid option -- %c\n", argv[0], c);

		d->custom_optopt = c;
		return '?';
	}
	if (temp[1] == ':') {
		if (temp[2] == ':') {
			/* This is an option that accepts an argument optionally.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				d->custom_optind++;
			} else
				d->custom_optarg = NULL;
			d->nextchar = NULL;
		} else {
			/* This is an option that requires an argument.  */
			if (*d->nextchar != '\0') {
				d->custom_optarg = d->nextchar;
				/*
				 * If we end this ARGV-element by taking the
				 * rest as an arg, we must advance to the next
				 * element now.
				 */
				d->custom_optind++;
			} else if (d->custom_optind == argc) {
				if (print_errors) {
					fprintf(stderr,
						"%s: option requires an argument -- %c\n",
						argv[0], c);
				}
				d->custom_optopt = c;
				if (optstring[0] == ':')
					c = ':';
				else
					c = '?';
			} else
				/*
				 * We already incremented `custom_optind' once;
				 * increment it again when taking next ARGV-elt
				 * as argument.
				 */
				d->custom_optarg = argv[d->custom_optind++];
			d->nextchar = NULL;
		}
	}
	return c;
}

/*
 * Scan elements of ARGV for option characters given in OPTSTRING.
 *
 * If an element of ARGV starts with '-', and is not exactly "-" or "--",
 * then it is an option element.  The characters of this element
 * (aside from the initial '-') are option characters.  If `getopt'
 * is called repeatedly, it returns successively each of the option characters
 * from each of the option elements.
 *
 * If `getopt' finds another option character, it returns that character,
 * updating `custom_optind' and `nextchar' so that the next call to `getopt' can
 * resume the scan with the following option character or ARGV-element.
 *
 * If there are no more option characters, `getopt' returns -1.
 * Then `custom_optind' is the index in ARGV of the first ARGV-element
 * that is not an option.  (The ARGV-elements have been permuted
 * so that those that are not options now come last.)
 *
 * OPTSTRING is a string containing the legitimate option characters.
 * If an option character is seen that is not listed in OPTSTRING,
 * return '?' after printing an error message.  If you set `custom_opterr' to
 * zero, the error message is suppressed but we still return '?'.
 *
 * If a char in OPTSTRING is followed by a colon, that means it wants an arg,
 * so the following text in the same ARGV-element, or the text of the following
 * ARGV-element, is returned in `custom_optarg'.  Two colons mean an option that
 * wants an optional arg; if there is text in the current ARGV-element,
 * it is returned in `custom_optarg', otherwise `custom_optarg' is set to zero.
 *
 * If OPTSTRING starts with `-' or `+', it requests different methods of
 * handling the non-option ARGV-elements.
 * See the comments about RETURN_IN_ORDER and REQUIRE_ORDER, above.
 *
 * Long-named options begin with `--' instead of `-'.
 * Their names may be abbreviated as long as the abbreviation is unique
 * or is an exact match for some defined option.  If they have an
 * argument, it follows the option name in the same ARGV-element, separated
 * from the option name by a `=', or else the in next ARGV-element.
 * When `getopt' finds a long-named option, it returns 0 if that option's
 * `flag' field is nonzero, the value of the option's `val' field
 * if the `flag' field is zero.
 *
 * The elements of ARGV aren't really const, because we permute them.
 * But we pretend they're const in the prototype to be compatible
 * with other systems.
 *
 * LONGOPTS is a vector of `struct option' terminated by an
 * element containing a name which is zero.
 *
 * LONGIND returns the index in LONGOPT of the long-named option found.
 * It is only valid when a long-named option has been found by the most
 * recent call.
 *
 * Return the option character from OPTS just read.  Return -1 when there are
 * no more options.  For unrecognized options, or options missing arguments,
 * `custom_optopt' is set to the option letter, and '?' is returned.
 *
 * The OPTS string is a list of characters which are recognized option letters,
 * optionally followed by colons, specifying that that letter takes an
 * argument, to be placed in `custom_optarg'.
 *
 * If a letter in OPTS is followed by two colons, its argument is optional.
 * This behavior is specific to the GNU `getopt'.
 *
 * The argument `--' causes premature termination of argument scanning,
 * explicitly telling `getopt' that there are no more options.  If OPTS begins
 * with `--', then non-option arguments are treated as arguments to the option
 * '\0'.  This behavior is specific to the GNU `getopt'.
 */

static int getopt_internal_r(int argc, char *const *argv, const char *optstring,
		const struct option *longopts, int *longind,
		struct custom_getopt_data *d)
{
	int ret, print_errors = d->custom_opterr;

	if (optstring[0] == ':')
		print_errors = 0;
	if (argc < 1)
		return -1;
	d->custom_optarg = NULL;

	/* 
	 * This is a big difference with GNU getopt, since optind == 0
	 * means initialization while here 1 means first call.
	 */
	if (d->custom_optind == 0 || !d->initialized) {
		if (d->custom_optind == 0)
			d->custom_optind = 1;	/* Don't scan ARGV[0], the program name.  */
		custom_getopt_initialize(d);
	}
	if (d->nextchar == NULL || *d->nextchar == '\0') {
		ret = shuffle_argv(argc, argv, longopts, d);
		if (ret)
			return ret;
	}
	if (longopts && (argv[d->custom_optind][1] == '-' ))
		return check_long_opt(argc, argv, optstring, longopts,
			longind, print_errors, d);
	return check_short_opt(argc, argv, optstring, print_errors, d);
}

static int custom_getopt_internal(int argc, char *const *argv, const char *optstring,
	const struct option *longopts, int *longind)
{
	int result;
	/* Keep a global copy of all internal members of d */
	static struct custom_getopt_data d;

	d.custom_optind = custom_optind;
	d.custom_opterr = custom_opterr;
	result = getopt_internal_r(argc, argv, optstring, longopts,
		longind, &d);
	custom_optind = d.custom_optind;
	custom_optarg = d.custom_optarg;
	custom_optopt = d.custom_optopt;
	return result;
}

static int custom_getopt_long (int argc, char *const *argv, const char *options,
	const struct option *long_options, int *opt_index)
{
	return custom_getopt_internal(argc, argv, options, long_options,
		opt_index);
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see RNAxplorer_cmdline_parser_params.check_ambiguity
 * @param override @see RNAxplorer_cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               RNAxplorer_cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_FLAG:
    *((int *)field) = !*((int *)field);
    break;
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_DOUBLE:
    if (val) *((double *)field) = strtod (val, &stop_char);
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
  case ARG_DOUBLE:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
  case ARG_FLAG:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}

/**
 * @brief store information about a multiple option in a temporary list
 * @param list where to (temporarily) store multiple options
 */
static
int update_multiple_arg_temp(struct generic_list **list,
               unsigned int *prev_given, const char *val,
               const char *possible_values[], const char *default_value,
               RNAxplorer_cmdline_parser_arg_type arg_type,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  /* store single arguments */
  char *multi_token;
  const char *multi_next;

  if (arg_type == ARG_NO) {
    (*prev_given)++;
    return 0; /* OK */
  }

  multi_token = get_multiple_arg_token(val);
  multi_next = get_multiple_arg_token_next (val);

  while (1)
    {
      add_node (list);
      if (update_arg((void *)&((*list)->arg), &((*list)->orig), 0,
          prev_given, multi_token, possible_values, default_value, 
          arg_type, 0, 1, 1, 1, long_opt, short_opt, additional_error)) {
        if (multi_token) free(multi_token);
        return 1; /* failure */
      }

      if (multi_next)
        {
          multi_token = get_multiple_arg_token(multi_next);
          multi_next = get_multiple_arg_token_next (multi_next);
        }
      else
        break;
    }

  return 0; /* OK */
}

/**
 * @brief free the passed list (including possible string argument)
 */
static
void free_list(struct generic_list *list, short string_arg)
{
  if (list) {
    struct generic_list *tmp;
    while (list)
      {
        tmp = list;
        if (string_arg && list->arg.string_arg)
          free (list->arg.string_arg);
        if (list->orig)
          free (list->orig);
        list = list->next;
        free (tmp);
      }
  }
}

/**
 * @brief updates a multiple option starting from the passed list
 */
static
void update_multiple_arg(void *field, char ***orig_field,
               unsigned int field_given, unsigned int prev_given, union generic_value *default_value,
               RNAxplorer_cmdline_parser_arg_type arg_type,
               struct generic_list *list)
{
  int i;
  struct generic_list *tmp;

  if (prev_given && list) {
    *orig_field = (char **) realloc (*orig_field, (field_given + prev_given) * sizeof (char *));

    switch(arg_type) {
    case ARG_INT:
      *((int **)field) = (int *)realloc (*((int **)field), (field_given + prev_given) * sizeof (int)); break;
    case ARG_FLOAT:
      *((float **)field) = (float *)realloc (*((float **)field), (field_given + prev_given) * sizeof (float)); break;
    case ARG_DOUBLE:
      *((double **)field) = (double *)realloc (*((double **)field), (field_given + prev_given) * sizeof (double)); break;
    case ARG_STRING:
      *((char ***)field) = (char **)realloc (*((char ***)field), (field_given + prev_given) * sizeof (char *)); break;
    default:
      break;
    };
    
    for (i = (prev_given - 1); i >= 0; --i)
      {
        tmp = list;
        
        switch(arg_type) {
        case ARG_INT:
          (*((int **)field))[i + field_given] = tmp->arg.int_arg; break;
        case ARG_FLOAT:
          (*((float **)field))[i + field_given] = tmp->arg.float_arg; break;
        case ARG_DOUBLE:
          (*((double **)field))[i + field_given] = tmp->arg.double_arg; break;
        case ARG_STRING:
          (*((char ***)field))[i + field_given] = tmp->arg.string_arg; break;
        default:
          break;
        }        
        (*orig_field) [i + field_given] = list->orig;
        list = list->next;
        free (tmp);
      }
  } else { /* set the default value */
    if (default_value && ! field_given) {
      switch(arg_type) {
      case ARG_INT:
        if (! *((int **)field)) {
          *((int **)field) = (int *)malloc (sizeof (int));
          (*((int **)field))[0] = default_value->int_arg; 
        }
        break;
      case ARG_FLOAT:
        if (! *((float **)field)) {
          *((float **)field) = (float *)malloc (sizeof (float));
          (*((float **)field))[0] = default_value->float_arg;
        }
        break;
      case ARG_DOUBLE:
        if (! *((double **)field)) {
          *((double **)field) = (double *)malloc (sizeof (double));
          (*((double **)field))[0] = default_value->double_arg;
        }
        break;
      case ARG_STRING:
        if (! *((char ***)field)) {
          *((char ***)field) = (char **)malloc (sizeof (char *));
          (*((char ***)field))[0] = gengetopt_strdup(default_value->string_arg);
        }
        break;
      default: break;
      }
      if (!(*orig_field)) {
        *orig_field = (char **) malloc (sizeof (char *));
        (*orig_field)[0] = 0;
      }
    }
  }
}

int
RNAxplorer_cmdline_parser_internal (
  int argc, char **argv, struct RNAxplorer_args_info *args_info,
                        struct RNAxplorer_cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  struct generic_list * p0_list = NULL;
  int error_occurred = 0;
  struct RNAxplorer_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;

  char *optarg;
  int optind;
  int opterr;
  int optopt;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    RNAxplorer_cmdline_parser_init (args_info);

  RNAxplorer_cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "detailed-help",	0, NULL, 0 },
        { "full-help",	0, NULL, 0 },
        { "version",	0, NULL, 'V' },
        { "verbose",	0, NULL, 'v' },
        { "sequence",	1, NULL, 0 },
        { "penalize-structures",	0, NULL, 0 },
        { "struc1",	1, NULL, 0 },
        { "struc2",	1, NULL, 0 },
        { "granularity",	1, NULL, 0 },
        { "num-samples",	1, NULL, 'n' },
        { "exploration-factor",	1, NULL, 'f' },
        { "min-exploration-percent",	1, NULL, 0 },
        { "cluster",	0, NULL, 0 },
        { "lmin-file",	1, NULL, 0 },
        { "TwoD-file",	1, NULL, 0 },
        { "nonred",	0, NULL, 0 },
        { "nonred-file",	1, NULL, 0 },
        { "explore-two-neighborhood",	0, NULL, '2' },
        { "post-filter-two",	0, NULL, 0 },
        { "ediff-penalty",	0, NULL, 0 },
        { "mu",	1, NULL, 0 },
        { "method",	1, NULL, 'M' },
        { "betaScale",	1, NULL, 0 },
        { "extended_opt",	1, NULL, 'e' },
        { "iterations",	1, NULL, 'i' },
        { "maxKeep",	1, NULL, 'm' },
        { "maxStore",	1, NULL, 's' },
        { "remember",	1, NULL, 'r' },
        { "circ",	0, NULL, 'c' },
        { "cooling-rate",	1, NULL, 0 },
        { "tstart",	1, NULL, 0 },
        { "tstop",	1, NULL, 0 },
        { "penalizeBackWalks",	0, NULL, 0 },
        { "basinStructure",	0, NULL, 0 },
        { "maxD",	1, NULL, 'D' },
        { "maxD1",	1, NULL, 0 },
        { "maxD2",	1, NULL, 0 },
        { "temp",	1, NULL, 'T' },
        { "p0",	1, NULL, 0 },
        { "shift_moves",	0, NULL, 0 },
        { "parameter_file",	1, NULL, 'P' },
        { 0,  0, 0, 0 }
      };

      custom_optarg = optarg;
      custom_optind = optind;
      custom_opterr = opterr;
      custom_optopt = optopt;

      c = custom_getopt_long (argc, argv, "hVvn:f:2M:e:i:m:s:r:cD:T:P:", long_options, &option_index);

      optarg = custom_optarg;
      optind = custom_optind;
      opterr = custom_opterr;
      optopt = custom_optopt;

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          RNAxplorer_cmdline_parser_print_help ();
          RNAxplorer_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          RNAxplorer_cmdline_parser_print_version ();
          RNAxplorer_cmdline_parser_free (&local_args_info);
          exit (EXIT_SUCCESS);

        case 'v':	/* Be verbose
.  */
        
        
          if (update_arg((void *)&(args_info->verbose_flag), 0, &(args_info->verbose_given),
              &(local_args_info.verbose_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "verbose", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Number of samples in total. The number of samples per iteration is n/g..  */
        
        
          if (update_arg( (void *)&(args_info->num_samples_arg), 
               &(args_info->num_samples_orig), &(args_info->num_samples_given),
              &(local_args_info.num_samples_given), optarg, 0, "100000", ARG_INT,
              check_ambiguity, override, 0, 0,
              "num-samples", 'n',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Exploration factor.  */
        
        
          if (update_arg( (void *)&(args_info->exploration_factor_arg), 
               &(args_info->exploration_factor_orig), &(args_info->exploration_factor_given),
              &(local_args_info.exploration_factor_given), optarg, 0, "1", ARG_FLOAT,
              check_ambiguity, override, 0, 0,
              "exploration-factor", 'f',
              additional_error))
            goto failure;
        
          break;
        case '2':	/* Explore 2-Neighborhood of local minima, i.e. eliminate shallow minima.  */
        
        
          if (update_arg((void *)&(args_info->explore_two_neighborhood_flag), 0, &(args_info->explore_two_neighborhood_given),
              &(local_args_info.explore_two_neighborhood_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "explore-two-neighborhood", '2',
              additional_error))
            goto failure;
        
          break;
        case 'M':	/* Set the method used to obtain meshpoint structures for the bisection algorithm
.  */
        
        
          if (update_arg( (void *)&(args_info->method_arg), 
               &(args_info->method_orig), &(args_info->method_given),
              &(local_args_info.method_given), optarg, 0, "RSH", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "method", 'M',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Some extended options:
        N    normal distortion (no shift)
        B    alter both potentials at once
        R    relax potential instead of increasing it
        S    shift potential to other structure
        F    shift to first structure
        V    verbose
        
.  */
        
        
          if (update_arg( (void *)&(args_info->extended_opt_arg), 
               &(args_info->extended_opt_orig), &(args_info->extended_opt_given),
              &(local_args_info.extended_opt_given), optarg, 0, "", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "extended_opt", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Set the number of iterations/simulations
        
.  */
        
        
          if (update_arg( (void *)&(args_info->iterations_arg), 
               &(args_info->iterations_orig), &(args_info->iterations_given),
              &(local_args_info.iterations_given), optarg, 0, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "iterations", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* maxKeep for direct path search
        
.  */
        
        
          if (update_arg( (void *)&(args_info->maxKeep_arg), 
               &(args_info->maxKeep_orig), &(args_info->maxKeep_given),
              &(local_args_info.maxKeep_given), optarg, 0, "10", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maxKeep", 'm',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* amount of best solutions to hold per iteration
        
.  */
        
        
          if (update_arg( (void *)&(args_info->maxStore_arg), 
               &(args_info->maxStore_orig), &(args_info->maxStore_given),
              &(local_args_info.maxStore_given), optarg, 0, "10", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maxStore", 's',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Set the number of structure states to remember in a TABU list
        
.  */
        
        
          if (update_arg( (void *)&(args_info->remember_arg), 
               &(args_info->remember_orig), &(args_info->remember_given),
              &(local_args_info.remember_given), optarg, 0, "10", ARG_INT,
              check_ambiguity, override, 0, 0,
              "remember", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* Assume a circular (instead of linear) RNA molecule.
.  */
        
        
          if (update_arg((void *)&(args_info->circ_flag), 0, &(args_info->circ_given),
              &(local_args_info.circ_given), optarg, 0, 0, ARG_FLAG,
              check_ambiguity, override, 1, 0, "circ", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'D':	/* Maximum base pair distance between meshpoints and references
        
.  */
        
        
          if (update_arg( (void *)&(args_info->maxD_arg), 
               &(args_info->maxD_orig), &(args_info->maxD_given),
              &(local_args_info.maxD_given), optarg, 0, "5", ARG_INT,
              check_ambiguity, override, 0, 0,
              "maxD", 'D',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Rescale energy parameters to a temperature of temp C. Default is 37C.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->temp_arg), 
               &(args_info->temp_orig), &(args_info->temp_given),
              &(local_args_info.temp_given), optarg, 0, 0, ARG_DOUBLE,
              check_ambiguity, override, 0, 0,
              "temp", 'T',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Use the given parameter file for gradient walks.
        
.  */
        
        
          if (update_arg( (void *)&(args_info->parameter_file_arg), 
               &(args_info->parameter_file_orig), &(args_info->parameter_file_given),
              &(local_args_info.parameter_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "parameter_file", 'P',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          if (strcmp (long_options[option_index].name, "detailed-help") == 0) {
            RNAxplorer_cmdline_parser_print_detailed_help ();
            RNAxplorer_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          if (strcmp (long_options[option_index].name, "full-help") == 0) {
            RNAxplorer_cmdline_parser_print_full_help ();
            RNAxplorer_cmdline_parser_free (&local_args_info);
            exit (EXIT_SUCCESS);
          }

          /* Input sequence.  */
          if (strcmp (long_options[option_index].name, "sequence") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->sequence_arg), 
                 &(args_info->sequence_orig), &(args_info->sequence_given),
                &(local_args_info.sequence_given), optarg, 0, "", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "sequence", '-',
                additional_error))
              goto failure;
          
          }
          /* Penalize structures instead of base pairs of local minima, that occure too often..  */
          else if (strcmp (long_options[option_index].name, "penalize-structures") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->penalize_structures_flag), 0, &(args_info->penalize_structures_given),
                &(local_args_info.penalize_structures_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "penalize-structures", '-',
                additional_error))
              goto failure;
          
          }
          /* Input structure 1.  */
          else if (strcmp (long_options[option_index].name, "struc1") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->struc1_arg), 
                 &(args_info->struc1_orig), &(args_info->struc1_given),
                &(local_args_info.struc1_given), optarg, 0, "", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "struc1", '-',
                additional_error))
              goto failure;
          
          }
          /* Input structure 2.  */
          else if (strcmp (long_options[option_index].name, "struc2") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->struc2_arg), 
                 &(args_info->struc2_orig), &(args_info->struc2_given),
                &(local_args_info.struc2_given), optarg, 0, "", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "struc2", '-',
                additional_error))
              goto failure;
          
          }
          /* Granularity, i.e. number of samples after which distortion checks are performed.  */
          else if (strcmp (long_options[option_index].name, "granularity") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->granularity_arg), 
                 &(args_info->granularity_orig), &(args_info->granularity_given),
                &(local_args_info.granularity_given), optarg, 0, "100", ARG_INT,
                check_ambiguity, override, 0, 0,
                "granularity", '-',
                additional_error))
              goto failure;
          
          }
          /* Minimum exploration percentage before adding new repelled structures.  */
          else if (strcmp (long_options[option_index].name, "min-exploration-percent") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->min_exploration_percent_arg), 
                 &(args_info->min_exploration_percent_orig), &(args_info->min_exploration_percent_given),
                &(local_args_info.min_exploration_percent_given), optarg, 0, "1", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "min-exploration-percent", '-',
                additional_error))
              goto failure;
          
          }
          /* Cluster resulting local minima to reduce effective size.  */
          else if (strcmp (long_options[option_index].name, "cluster") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->cluster_flag), 0, &(args_info->cluster_given),
                &(local_args_info.cluster_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "cluster", '-',
                additional_error))
              goto failure;
          
          }
          /* Output filename for local minima.  */
          else if (strcmp (long_options[option_index].name, "lmin-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->lmin_file_arg), 
                 &(args_info->lmin_file_orig), &(args_info->lmin_file_given),
                &(local_args_info.lmin_file_given), optarg, 0, "", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "lmin-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Output filename for pseudo-2D file.  */
          else if (strcmp (long_options[option_index].name, "TwoD-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->TwoD_file_arg), 
                 &(args_info->TwoD_file_orig), &(args_info->TwoD_file_given),
                &(local_args_info.TwoD_file_given), optarg, 0, "", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "TwoD-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Do sampling with non-redundant pbacktrack.  */
          else if (strcmp (long_options[option_index].name, "nonred") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->nonred_flag), 0, &(args_info->nonred_given),
                &(local_args_info.nonred_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "nonred", '-',
                additional_error))
              goto failure;
          
          }
          /* Input filename for nonredundant samples.  */
          else if (strcmp (long_options[option_index].name, "nonred-file") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->nonred_file_arg), 
                 &(args_info->nonred_file_orig), &(args_info->nonred_file_given),
                &(local_args_info.nonred_file_given), optarg, 0, "", ARG_STRING,
                check_ambiguity, override, 0, 0,
                "nonred-file", '-',
                additional_error))
              goto failure;
          
          }
          /* Post processing Filter local minima according to 2-Neighborhood, i.e. eliminate shallow minima.  */
          else if (strcmp (long_options[option_index].name, "post-filter-two") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->post_filter_two_flag), 0, &(args_info->post_filter_two_given),
                &(local_args_info.post_filter_two_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "post-filter-two", '-',
                additional_error))
              goto failure;
          
          }
          /* Use energy difference instead of kT for penalty.  */
          else if (strcmp (long_options[option_index].name, "ediff-penalty") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->ediff_penalty_flag), 0, &(args_info->ediff_penalty_given),
                &(local_args_info.ediff_penalty_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "ediff-penalty", '-',
                additional_error))
              goto failure;
          
          }
          /* proportion factor used to decide whether sampling round was sufficient.  */
          else if (strcmp (long_options[option_index].name, "mu") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->mu_arg), 
                 &(args_info->mu_orig), &(args_info->mu_given),
                &(local_args_info.mu_given), optarg, 0, "0.1", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "mu", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the scaling of the Boltzmann factors
.  */
          else if (strcmp (long_options[option_index].name, "betaScale") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->betaScale_arg), 
                 &(args_info->betaScale_orig), &(args_info->betaScale_given),
                &(local_args_info.betaScale_given), optarg, 0, "1.", ARG_DOUBLE,
                check_ambiguity, override, 0, 0,
                "betaScale", '-',
                additional_error))
              goto failure;
          
          }
          /* Cooling factor used for simulated annealing
          
.  */
          else if (strcmp (long_options[option_index].name, "cooling-rate") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cooling_rate_arg), 
                 &(args_info->cooling_rate_orig), &(args_info->cooling_rate_given),
                &(local_args_info.cooling_rate_given), optarg, 0, "0.9998", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "cooling-rate", '-',
                additional_error))
              goto failure;
          
          }
          /* start temperature in deg. Celcius
          
.  */
          else if (strcmp (long_options[option_index].name, "tstart") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->tstart_arg), 
                 &(args_info->tstart_orig), &(args_info->tstart_given),
                &(local_args_info.tstart_given), optarg, 0, "37.0", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "tstart", '-',
                additional_error))
              goto failure;
          
          }
          /* stop temperature in deg. Celcius
          
.  */
          else if (strcmp (long_options[option_index].name, "tstop") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->tstop_arg), 
                 &(args_info->tstop_orig), &(args_info->tstop_given),
                &(local_args_info.tstop_given), optarg, 0, "0.0", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "tstop", '-',
                additional_error))
              goto failure;
          
          }
          /* Add a penalty for backward moves, i.e. moves along states already visited
          
.  */
          else if (strcmp (long_options[option_index].name, "penalizeBackWalks") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->penalizeBackWalks_flag), 0, &(args_info->penalizeBackWalks_given),
                &(local_args_info.penalizeBackWalks_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "penalizeBackWalks", '-',
                additional_error))
              goto failure;
          
          }
          /* just perform a gradient walk starting from a given structure
          
.  */
          else if (strcmp (long_options[option_index].name, "basinStructure") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->basinStructure_flag), 0, &(args_info->basinStructure_given),
                &(local_args_info.basinStructure_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "basinStructure", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum base pair distance between meshpoints and reference structure 1
          
.  */
          else if (strcmp (long_options[option_index].name, "maxD1") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->maxD1_arg), 
                 &(args_info->maxD1_orig), &(args_info->maxD1_given),
                &(local_args_info.maxD1_given), optarg, 0, "5", ARG_INT,
                check_ambiguity, override, 0, 0,
                "maxD1", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum base pair distance between meshpoints and reference structure 2
          
.  */
          else if (strcmp (long_options[option_index].name, "maxD2") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->maxD2_arg), 
                 &(args_info->maxD2_orig), &(args_info->maxD2_given),
                &(local_args_info.maxD2_given), optarg, 0, "5", ARG_INT,
                check_ambiguity, override, 0, 0,
                "maxD2", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the percentage of the references distortion value <int> to <double>
          Can be given for all reference indices
          (NOTE: the value <double> should be between 0 and 1)
          (example: \"--p0 2=0.5\" - distortion value of sequence 2 will be multiplied with 0.5 before sampling.).  */
          else if (strcmp (long_options[option_index].name, "p0") == 0)
          {
          
            if (update_multiple_arg_temp(&p0_list, 
                &(local_args_info.p0_given), optarg, 0, 0, ARG_STRING,
                "p0", '-',
                additional_error))
              goto failure;
          
          }
          /* Use shift moves for gradient walks.
          
.  */
          else if (strcmp (long_options[option_index].name, "shift_moves") == 0)
          {
          
          
            if (update_arg((void *)&(args_info->shift_moves_flag), 0, &(args_info->shift_moves_given),
                &(local_args_info.shift_moves_given), optarg, 0, 0, ARG_FLAG,
                check_ambiguity, override, 1, 0, "shift_moves", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", RNAXPLORER_CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */


  update_multiple_arg((void *)&(args_info->p0_arg),
    &(args_info->p0_orig), args_info->p0_given,
    local_args_info.p0_given, 0,
    ARG_STRING, p0_list);

  args_info->p0_given += local_args_info.p0_given;
  local_args_info.p0_given = 0;
  
  if (check_required)
    {
      error_occurred += RNAxplorer_cmdline_parser_required2 (args_info, argv[0], additional_error);
    }

  RNAxplorer_cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  return 0;

failure:
  free_list (p0_list, 1 );
  
  RNAxplorer_cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
