/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "ensemble_defect.ts" instead.
 */

#include <check.h>

#line 1 "ensemble_defect.ts"
#include <stdio.h>      /* printf, scanf, NULL */
#include <stdlib.h>     /* malloc, free, rand */

#include <ViennaRNA/fold_vars.h>
#include <ViennaRNA/data_structures.h>
#include <ViennaRNA/utils/basic.h>
#include <ViennaRNA/utils/structures.h>
#include <ViennaRNA/equilibrium_probs.h>
#include <ViennaRNA/fold.h>
#include <ViennaRNA/part_func.h>



START_TEST(test_ensemble_defect)
{
#line 17
{
  vrna_md_t             md;
  vrna_fold_compound_t  *vc;
  const char            *sequence = "AGGAAACCUUAAUUGGUUA";
  const char  		*str1     = ".((...))(([[..))]].";
  double ed;
  short int *ptpk;

  vrna_md_set_default(&md);

  vc = vrna_fold_compound(sequence, &md, VRNA_OPTION_PF);

  vrna_pf(vc, NULL);

  ptpk = vrna_ptable_from_string(str1, VRNA_BRACKETS_ANY);

  ck_assert(vrna_ensemble_defect(vc, str1) == 0.614080983833787);
  ck_assert(vrna_ensemble_defect_pt(vc, ptpk) == 0.7279184335061499);

  vrna_fold_compound_free(vc);
  free(ptpk);
}


}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("Ensemble_Defect");
    TCase *tc1_1 = tcase_create("Ensemble_Defect");
    SRunner *sr = srunner_create(s1);
    int nf;

    /* User-specified pre-run code */
#line 42
    srunner_set_tap(sr, "-");

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, test_ensemble_defect);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
