(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



(* :Title: FigArgument *)
(* :Context: SciDraw` *)
(* :Summary: Miscellaneous argument processing definitions *)
(* :Author: Mark A. Caprio, Department of Physics, University of Notre Dame *)
(* :Copyright: Copyright FIGYEAR, Mark A. Caprio *)
(* :Package Version: FIGVERSION *)
(* :Mathematica Version: MATHVERSION *)
(* :Discussion: FIGDISCUSSION *)
(* :History: See main package file. *)


BeginPackage["SciDraw`",SciDraw`Private`$ExternalContexts];


Unprotect[Evaluate[$Context<>"*"]];


Begin["`Private`"];





ReplaceSequential[x_,Rules:{((_Rule)|(_RuleDelayed))...}]:=Module[
{Value},

Value=x;
Scan[
(Value=Replace[Value,#])&,
Rules
];
Value
];


ResolveOption[Option_Symbol,DefaultRules:{((_Rule)|(_RuleDelayed))...},FullOptions_List]:=ReplaceSequential[(Option/.FullOptions),DefaultRules];


NonNegativePattern=((_?NumericQ)?NonNegative);
PositivePattern=((_?NumericQ)?Positive);
UnitIntervalPattern=(((_?NumericQ)?NonNegative)?((#<=1)&));


LogicalPattern=(True|False);


NonListPattern=Except[_List];
FlatListPattern={NonListPattern...};


SizePattern=(Tiny|Small|Medium|Large);


ColorDirectivePattern=(_GrayLevel|_RGBColor|_CMYKColor|_Hue); 


ThicknessArgumentPattern=(SizePattern|NonNegativePattern);
ThicknessDirectivePattern=(Thin|Thick)|Thickness[ThicknessArgumentPattern]|AbsoluteThickness[ThicknessArgumentPattern];
FigThicknessPattern=(ThicknessArgumentPattern|ThicknessDirectivePattern);


FigResolveThickness[t:FigThicknessPattern]:=Switch[
t,
ThicknessArgumentPattern,AbsoluteThickness[t],
ThicknessDirectivePattern,t
];


DashingArgumentPattern=((SizePattern|NonNegativePattern)|({(SizePattern|NonNegativePattern)..}?(EvenQ[Length[#]]&)));
DashingDirectivePattern=(Dotted|DotDashed|Dashed)|Dashing[DashingArgumentPattern]|AbsoluteDashing[DashingArgumentPattern];
FigDashingPattern=(None|DashingArgumentPattern|DashingDirectivePattern);


FigResolveDashing[d:FigDashingPattern]:=Switch[
d,
None,AbsoluteDashing[{}],
DashingArgumentPattern,AbsoluteDashing[d],
DashingDirectivePattern,d
];


PointSizeArgumentPattern=(SizePattern|NonNegativePattern);
PointSizeDirectivePattern=PointSize[PointSizeArgumentPattern]|AbsolutePointSize[PointSizeArgumentPattern];
FigPointSizePattern=(PointSizeArgumentPattern|PointSizeDirectivePattern);


FigResolvePointSize[t:FigPointSizePattern]:=Switch[
t,
PointSizeArgumentPattern,AbsolutePointSize[t],
PointSizeDirectivePattern,t
];


FontFamilyPattern=(Times|(_String));
(*FontSizePattern=(NonNegativePattern|Scaled[NonNegativePattern]);*)
FontSizePattern=NonNegativePattern;  (* only accept absolute font sizes, not Scaled[] font sizes *)
FontWeightPattern=(Plain|Bold|(_String));
FontSlantPattern=(Plain|Italic|(_String));
FontTrackingPattern=(Plain|(_String));


FigTextOffsetPattern=Automatic|FigOffsetPattern;
FigTextOrientationPattern=Automatic|Inverse|Horizontal|Vertical|(_?NumericQ);


End[];


Protect[Evaluate[$Context<>"*"]];
Unprotect[Evaluate[$Context<>"$*"]];
EndPackage[];
