/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterGraphics;

public class DotPlot3D
extends FCSDisplay {
    public static final int PRECISION = 1024;
    public static final int ROTATEDEF = 6;
    public static final float DEG_TO_RAD = 0.0174533f;
    private int width;
    private int height;
    private int top;
    private float scale;
    private float res;
    private float oldVx;
    private float oldVy;
    private float newVx;
    private float newVy = 0.0f;
    private float anchorX;
    private float anchorY;
    private boolean buttonPress = false;
    private boolean regionDone = false;
    private boolean display3DDragging = true;

    public DotPlot3D(GDisplay gd) {
        super(gd);
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        float[] res = new float[3];
        int[] ivry = new int[3];
        float[] evry = new float[3];
        double[] minLog = new double[3];
        double[] splitEvry = new double[3];
        boolean[] split = new boolean[3];
        int rot = this.gd.cSymph.fs.scale[3] % 360;
        int tilt = this.gd.cSymph.fs.scale[4];
        while (rot < 0) {
            rot += 360;
        }
        if (tilt < 0) {
            tilt = 0;
        }
        float theta = (float)rot * 0.0174533f;
        float phi = (float)tilt * 0.0174533f;
        int oldWidth = this.p.xAbs();
        int oldHeight = this.p.yAbs();
        boolean rhs = rot > 45 && rot < 225;
        Dimension d = this.getSize();
        if (this.fullPaint || d.width != oldWidth || d.height != oldHeight || this.offImage == null) {
            int justify;
            int p_num;
            if (this.offGraphics == null || d.width != this.offDimension.width || d.height != this.offDimension.height) {
                this.offDimension = d;
                this.offImage = this.createImage(d.width, d.height);
                this.offGraphics = this.offImage.getGraphics();
            }
            this.p.set(this.offGraphics);
            this.offGraphics.setColor(this.getBackground());
            this.offGraphics.fillRect(0, 0, d.width, d.height);
            this.frame();
            this.p.vwindo(0.0f, 256.0f, 0.0f, 256.0f);
            int i = 0;
            while (i < 3) {
                p_num = this.gd.parameter[i];
                res[i] = this.gd.cSymph.fs.linRange[p_num];
                if (this.gd.cSymph.fs.logflg[p_num]) {
                    evry[i] = this.gd.cSymph.fs.logrng[p_num];
                    ivry[i] = -1;
                    split[i] = this.gd.cSymph.fs.splitflg[p_num];
                    splitEvry[i] = this.getSplitEvry(this.gd.cSymph.fs.minSplitVal[p_num]);
                } else {
                    evry[i] = this.getEvry(res[i]);
                    ivry[i] = 5;
                    split[i] = false;
                    splitEvry[i] = 1.0;
                }
                minLog[i] = split[i] ? this.gd.cSymph.fs.minSplitLog[p_num] : this.gd.cSymph.fs.minLog[p_num];
                ++i;
            }
            this.p.set_colour(1);
            this.p.base3(res, evry, minLog, ivry, theta, phi, (this.gd.show & 0x20000) != 0, split, splitEvry);
            if (this.p.hideZ3()) {
                this.p.axisZ3(res, evry, minLog, ivry, theta, phi, (this.gd.show & 0x20000) != 0, rhs, split, splitEvry);
            }
            this.p.vwindo3(0.0f, 256.0f, 0.0f, 256.0f, 0.0f, 256.0f, theta, phi);
            if ((this.gd.show & 0x20000) != 0) {
                this.p.movabs(35, 0);
                this.p.drwtxt(new String("Rotation: " + rot + " Tilt: " + tilt), 1, 9);
                this.p.set_colour(1);
                justify = 516;
                this.p.movea3(0.0f, 256.0f, 0.0f);
                p_num = this.gd.parameter[1];
                this.drawParLabel(0, p_num, justify, 0, this.parArea[1], this.gd.instrName[1]);
                this.p.movea3(256.0f, 0.0f, 0.0f);
                p_num = this.gd.parameter[0];
                this.drawParLabel(0, p_num, justify, 0, this.parArea[0], this.gd.instrName[0]);
            }
            this.p.linestyle(this.dotSize, 0);
            int maxDots = this.gd.cSymph.fs.scale[0] < this.gd.cSymph.fs.gated ? this.gd.cSymph.fs.scale[0] : this.gd.cSymph.fs.gated;
            int k = 0;
            while (k < 64) {
                this.p.set_colour(1);
                int j = 0;
                while (j < maxDots) {
                    if (this.gd.d3DArray[j] != null && this.gd.d3DArray[j].z * 64 / 256 == k) {
                        if ((this.gd.style & 0x40) != 0) {
                            this.p.set_colour(this.gd.d3DArray[j].rCol);
                        } else if ((this.gd.style & 0x20) != 0) {
                            this.p.set_colour(this.gd.d3DArray[j].gCol);
                        } else if ((this.gd.style & 0x200) != 0) {
                            this.p.set_colour(this.gd.d3DArray[j].hCol);
                        } else if ((this.gd.style & 0x400) != 0) {
                            this.p.set_colour(this.gd.d3DArray[j].clCol);
                        } else if ((this.gd.style & 0x800) != 0) {
                            ColDot3D cD = (ColDot3D)this.gd.d3DArray[j];
                            this.p.setRGBColour(new Color(cD.r & 0xFF, cD.g & 0xFF, cD.b & 0xFF));
                        }
                        if ((this.gd.style & 0x80) != 0) {
                            int size = this.dotSize * (this.gd.d3DArray[j].size & 0xFF) / 100;
                            if (size <= 0) {
                                size = 1;
                            }
                            this.p.pointa3(this.gd.d3DArray[j].x, this.gd.d3DArray[j].y, this.gd.d3DArray[j].z, size);
                        } else {
                            this.p.pointa3(this.gd.d3DArray[j].x, this.gd.d3DArray[j].y, this.gd.d3DArray[j].z, 0);
                        }
                    }
                    ++j;
                }
                ++k;
            }
            this.p.linestyle(1, 0);
            this.p.set_colour(1);
            this.p.movea3(0.0f, 256.0f, 256.0f);
            this.p.drawa3(0.0f, 0.0f, 256.0f);
            this.p.drawa3(256.0f, 0.0f, 256.0f);
            this.p.drawa3(256.0f, 256.0f, 256.0f);
            this.p.drawa3(0.0f, 256.0f, 256.0f);
            if (!this.p.hideZ3()) {
                this.p.axisZ3(res, evry, minLog, ivry, theta, phi, (this.gd.show & 0x20000) != 0, rhs, split, splitEvry);
                this.p.vwindo3(0.0f, 256.0f, 0.0f, 256.0f, 0.0f, 256.0f, theta, phi);
            }
            if ((this.gd.show & 0x20000) != 0) {
                this.p.set_colour(1);
                justify = rhs ? 10 : 9;
                this.p.movea3(0.0f, 0.0f, 256.0f);
                p_num = this.gd.parameter[2];
                this.drawParLabel(0, p_num, justify, 0, this.parArea[2], this.gd.instrName[2]);
            }
            this.fullPaint = false;
            this.reportPaint();
        }
        if (!(g instanceof PrinterGraphics)) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
            g.drawImage(this.offImage, 0, 0, this);
        }
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.display3DDragging) {
            this.newX = me.getX();
            this.newY = me.getY();
            if (this.oldX >= 0 && this.oldY >= 0) {
                int deltaX = this.newX - this.oldX;
                int deltaY = this.newY - this.oldY;
                this.dragDisplay(deltaX, deltaY);
            } else {
                this.oldX = this.newX;
                this.oldY = this.newY;
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isPopupTrigger()) {
            this.maybeShowPopup(me);
        } else if (this.display3DDragging) {
            this.oldX = me.getX();
            this.oldY = me.getY();
        }
    }

    void frame() {
        this.width = this.p.xAbs() - 35 - 10;
        this.height = this.p.yAbs() - 30 - 10;
        int left = 35;
        int base = 30;
        this.p.swindo(left, this.width, base, this.height);
    }

    float sum_real_array(int size) {
        float count = 0.0f;
        int i = 0;
        while (i < size) {
            count += this.gd.rArray[i];
            ++i;
        }
        return count;
    }
}

