Summary: Tool for finding and fixing problems in MP3 files; includes a tagger
%define version 1.4.01
%define branch %{nil}

%define pkgName MP3Diags
# pkgName should be mp3diags, MP3Diags, or whatever else
# !!! note that you can't simply comment a "define", as macros get expanded inside comments

%define srcBaseName MP3Diags%{branch}
# ttt1 perhaps have a binName and a dskName and use some file renaming and sed to control the name of the binary, desktop file, and icons (probably the same as the desktop file)

%define translName mp3diags%{branch}

Name: %{pkgName}%{branch}
Version: %{version}
Release: 1
#Conflicts: MP3Diags >= 0.8.0.0
#Provides: MP3Diags
Group: Applications/Multimedia
Source: %{srcBaseName}-%{version}.tar.gz
URL: http://mp3diags.sourceforge.net/
License: http://www.gnu.org/licenses/gpl-2.0.html


BuildRoot: %{_tmppath}/%{name}-%{version}-build
Packager: Ciobi


%if 0%{?suse_version} > 0000
Requires: libqt4-x11
BuildRequires: zlib-devel boost-devel libqt4-devel
BuildRequires: update-desktop-files
%endif

%if 0%{?fedora} || 0%{?fedora_version}
Requires: qt-x11
BuildRequires: qt-devel zlib-devel boost-devel boost-devel-static gcc-c++
%endif

# this breaks the build for mandriva 2009.1: parseExpressionBoolean returns -1
%if 0%{?mandriva_version} >= 2009
#%if 0%{?mdkversion} >= 200900
BuildRequires:  kdelibs4-devel
BuildRequires:  boost-devel boost-static-devel
BuildRequires:  zlib-devel
Requires:       qt4-common
%endif
# related but probably something else: https://bugzilla.novell.com/show_bug.cgi?id=459337  or  https://bugzilla.redhat.com/show_bug.cgi?id=456103





%description
Finds problems in MP3 files and helps the user to fix many of them. Looks at both the audio part (VBR info, quality, normalization) and the tags containing track information (ID3.)

Has a tag editor, which can download album information (including cover art) from MusicBrainz and Discogs, as well as paste data from the clipboard. Track information can also be extracted from a file's name.

Another component is the file renamer, which can rename files based on the fields in their ID3V2 tag (artist, track number, album, genre, ...)



%prep
%setup -q -n %{srcBaseName}-%{version}



%build

./AdjustMt.sh STATIC_SER

%if 0%{?suse_version}
qmake
lrelease src/src.pro
%endif

%if 0%{?mandriva_version} >= 2009
qmake
lrelease src/src.pro
%endif

%if 0%{?fedora} || 0%{?fedora_version}
qmake-qt4
lrelease-qt4 src/src.pro
%endif

make
strip $RPM_BUILD_DIR/%{srcBaseName}-%{version}/bin/%{srcBaseName}


%install
# ttt1 perhaps look at http://doc.trolltech.com/4.3/qmake-variable-reference.html#installs and use INSTALLS += ...
echo BUILD ROOT - %{buildroot}%{_bindir}

mkdir -p %{buildroot}%{_bindir} ; install -p -m755 bin/%{srcBaseName} %{buildroot}%{_bindir}

#mkdir -p %{buildroot}%{_datadir}/applications ; desktop-file-install --dir %{buildroot}%{_datadir}/applications desktop/%{srcBaseName}.desktop
mkdir -p %{buildroot}%{_datadir}/applications ; install -p -m644 desktop/%{srcBaseName}.desktop %{buildroot}%{_datadir}/applications/%{srcBaseName}.desktop

mkdir -p %{buildroot}%{_datadir}/icons/hicolor/16x16/apps ; install -p -m644 desktop/%{srcBaseName}16.png %{buildroot}%{_datadir}/icons/hicolor/16x16/apps/%{srcBaseName}.png
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/22x22/apps ; install -p -m644 desktop/%{srcBaseName}22.png %{buildroot}%{_datadir}/icons/hicolor/22x22/apps/%{srcBaseName}.png
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/24x24/apps ; install -p -m644 desktop/%{srcBaseName}24.png %{buildroot}%{_datadir}/icons/hicolor/24x24/apps/%{srcBaseName}.png
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/32x32/apps ; install -p -m644 desktop/%{srcBaseName}32.png %{buildroot}%{_datadir}/icons/hicolor/32x32/apps/%{srcBaseName}.png
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/36x36/apps ; install -p -m644 desktop/%{srcBaseName}36.png %{buildroot}%{_datadir}/icons/hicolor/36x36/apps/%{srcBaseName}.png
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/40x40/apps ; install -p -m644 desktop/%{srcBaseName}40.png %{buildroot}%{_datadir}/icons/hicolor/40x40/apps/%{srcBaseName}.png
mkdir -p %{buildroot}%{_datadir}/icons/hicolor/48x48/apps ; install -p -m644 desktop/%{srcBaseName}48.png %{buildroot}%{_datadir}/icons/hicolor/48x48/apps/%{srcBaseName}.png

mkdir -p %{buildroot}/usr/share/%{translName}/translations ; install -p -m644 src/translations/*.qm %{buildroot}/usr/share/%{translName}/translations


%if 0%{?suse_version} > 0000
%suse_update_desktop_file -n %{srcBaseName}
#echo ================ SUSE ================ SUSE ================
%endif
#error with suse_update_desktop_file -in MP3Diags , perhaps try suse_update_desktop_file -n -i MP3Diags


%clean
rm -rf %{buildroot}


%files
%defattr(-,root,root)
%dir %{_datadir}/icons/hicolor
%dir %{_datadir}/icons/hicolor/*
%dir %{_datadir}/icons/hicolor/*/*
%dir /usr/share/%{translName}
%dir /usr/share/%{translName}/translations
%{_bindir}/%{srcBaseName}
%{_datadir}/applications/%{srcBaseName}.desktop
%{_datadir}/icons/hicolor/*/apps/%{srcBaseName}.png
/usr/share/%{translName}/translations/*.qm

#?datadir (=/usr/share)
#/usr/share/applications



%changelog
* Sun Nov 26 2023 Marian Ciobanu <mp3diags@gmail.com> 1.4.01
- updated links to use https pages
- integrated changes from 1.5.02:
- made "close" button visible in KDE
- added some compile-time checks to make project build on Arch
- Qt5 port
- retries on file read failure
- fix for UTF8 output in calls to mp3gain (Linux only)
- new transformation: "Remove Xing or LAME streams from CBR files"
- always show sessions button if there are more than 1 sessions

* Fri Jul 29 2016 Marian Ciobanu <ciobi@inbox.com> 1.2.03
- fixed build for GCC 6
- integrated changes from 1.3.03:
- improved error reporting
- speed improvements for external drives (USB, network, ...)
- different treatment for the Xing frame being included in the frame count

* Sun Mar 08 2015 Marian Ciobanu <ciobi@inbox.com> 1.2.02
- integrated changes from 1.3.01:
- fixed incorrect message occurring some times when start after a crash
- better logging and retries for write errors
- added offset to the output created via the command line
- fixed crash caused by saving very small images
- build fix
- disabled Discogs integration

* Fri Jan 17 2014 Marian Ciobanu <ciobi@inbox.com> 1.2.01

- 1.2 as the new stable branch
- build fix for clang and for Solaris
- fixed broken links in documentation and moved alternate downloads from Dropbox to my ISP

* Sun Mar 31 2013 Marian Ciobanu <ciobi@inbox.com> 1.2.00

- new version number to support the new "stable" branch

* Sat Dec 01 2012 Marian Ciobanu <ciobi@inbox.com> 1.1.21.080

- fixed bug that caused a "%s" to be shown instead of the list of files about to be changed

* Sat Oct 20 2012 Marian Ciobanu <ciobi@inbox.com> 1.1.20.077

- Discogs fix

* Sun Apr 29 2012 Marian Ciobanu <ciobi@inbox.com> 1.1.19.075

- French translation

* Sat Apr 06 2012 Marian Ciobanu <ciobi@inbox.com> 1.1.18.074

- German translation
- made code compilable on GCC 4.7
- several translation fixes

* Sat Mar 17 2012 Marian Ciobanu <ciobi@inbox.com> 1.1.17.073

- fixed crash introduced in 1.1.16 with translation changes

* Sun Mar 11 2012 Marian Ciobanu <ciobi@inbox.com> 1.1.16.072

- made program translatable
- added Czech translation

* Wed Feb 02 2012 Marian Ciobanu <ciobi@inbox.com> 1.1.12.068

- external tools
- possibility of applying transformation lists in CLI mode
- "Open containing folder" in the main window
- delete files from the main window
- close buttons for Gnome 3
- APE remover
- non-audio remover
- CLI analyzer uses session settings to determine quality thresholds
- fixed menu tooltips that disappeared too quickly

* Sat Dec 03 2011 Marian Ciobanu <ciobi@inbox.com> 1.1.09.064

- moved to Discogs API V2
- added codepage support when copying ID3V1 to ID3V2
- fixed crash caused by ID3V2.4 tag with invalid flags
- fixed splitting of unsupported ID3V2 tags
- fixed Xing generation for small bitrates

* Sun Aug 28 2011 Marian Ciobanu <ciobi@inbox.com> 1.1.08.062

- made Discogs queries after a Discogs API change
- fixed track numbering when querying multi-volume albums from Discogs
- made Linux shell integration accept file names containing spaces
- added close button for dialogs on Gnome 3

* Sat Jul 30 2011 Marian Ciobanu <ciobi@inbox.com> 1.1.07.061

- shell integration for Linux
- replaced MP3Diags with MP3Diags-unstable in places where this wasn't done
- restructured the .spec file
- added close button on Gnome 3

* Fri Jul 22 2011 Marian Ciobanu <ciobi@inbox.com> 1.1.06.059

- shell integration fixes

* Thu Jul 21 2011 Marian Ciobanu <ciobi@inbox.com> 1.1.05.058

- shell integration (Windows only)

* Sun Jul 17 2011 Marian Ciobanu <ciobi@inbox.com> 1.1.04.057

- folder-based sessions based on command-line parameters

* Wed Jun 15 2011 Marian Ciobanu <ciobi@inbox.com> 1.1.03.056

- integrated command-line mode by Michael Elsdörfer

* Mon May 30 2011 Marian Ciobanu <ciobi@inbox.com> 1.1.01.054

- created unstable branch

* Sat May 28 2011 Marian Ciobanu <ciobi@inbox.com> 1.0.08.053

- fixed crash when trying to save after error at startup
- added branch support to build process

* Wed Dec 29 2010 Marian Ciobanu <ciobi@inbox.com> 1.0.07.052

- fixed crash in folder filter dialog
- made project compilable on Fedora 13 and 14

* Sun Jul 04 2010 Marian Ciobanu <ciobi@inbox.com> 1.0.06.051

- fixed crash caused by invalid Lyrics tag
- fixed assertion failure when opening the folder filter in Windows

* Wed Mar 17 2010 Marian Ciobanu <ciobi@inbox.com> 1.0.05.050

- fixed issue #23 (assertion failure)

* Sun Mar 07 2010 Marian Ciobanu <ciobi@inbox.com> 1.0.04.049

- fixed crash triggered by invalid frame lengths in ID3V2
- fixed crash that occured when the backup directory couldn't be created

* Fri Jan 29 2010 Marian Ciobanu <ciobi@inbox.com> 1.0.03.048

- fixed crash triggered by GEOB frames containing UTF-16 text

* Tue Jan 12 2010 Marian Ciobanu <ciobi@inbox.com> 1.0.02.047

- fixed crash triggered by trying to repair broken ID3V2 tags that contain images
- fixed crash that occurred when changing file names manually in the file renamer, without defining a pattern
- fixed crash caused by unsynchronized ID3V2.4.0 frames that end with 0xff

* Fri Dec 11 2009 Marian Ciobanu <ciobi@inbox.com> 1.0.01.046

- fixed crash that occurred when running on Qt 4.6
- fixed crash that occurred when changing song info in the tag editor if songs had images stored as BMP or anything else besides JPG or PNG

* Sun Nov 29 2009 Marian Ciobanu <ciobi@inbox.com> 1.0.00.045

- wording changes to reflect non-beta status
- pressing CTRL+C when viewing full-size images in the tag editor or in "Tag details" in the main window copies the image to the clipboard
- added "Rating" and changed field order in "Tag details" to match the Tag editor

* Wed Nov 04 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.06.044

- fixed a crash in folder filter
- fixed bug causing non-normalized files having any TXXX frame to appear normalized
- case is ignored for file extension, so .Mp3 or .mP3 files are recognized
- better support and more consistent handling for TXXX and text frames in ID3V2
- reduced number of locales by eliminating redundant ones
- disabled CTRL+A selection in the main window
- static link for serialization
- added trace details for web downloads

* Tue Oct 27 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.06.043

- "Simple view" in file configuration
- fixed crash on empty text frames in ID3V2
- generic binaries for Linux
- BuildMp3Diags.hta detects VS version
- documentation updates

* Tue Oct 20 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.06.042

- better support for binary frames in ID2V2.4.0
- fixed bug resulting in crash when files were modified in external tools
- fixed bug resulting in crash when renaming files if a filter is applied
- fixed bug resulting in crash when going to "Tag details" for files using Unicode in USLT (issue 40)
- added option to include styles in Discogs info
- added case-change option to the tag editor
- better detection and notification for changed files before applying transformations or saving from the tag editor
- file renamer allows file names to be changed manually
- file renamer can use "duplicate" label for unrated songs
- images shown for Lyrics tags
- improved case-change transformation
- removing images from the tag editor now works even for non-cover images

* Fri Oct 09 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.06.041

- brought documentation up to date
- added test for ReplayGain info stored inside Id3V2
- failing to read text frames from files no longer causes crashes
- fixed bug resulting in crash when 2 ID3V2 tags are present and "Discard invalid ID3V2 data" gets called
- XML export now works when names contain double quotes
- locale in export dialog
- locale lists are now sorted
- long text frames are now truncated when shown in the "File info" area
- changed names and order for tabs under Config/Files
- made transformation options work correctly in MSVC

* Wed Sep 30 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.06.040
- "Various Artists" support
- all pictures are shown and can be viewed in full size in "Tag details"
- all pictures from a file are shown in the tag editor
- patterns in the tag editor may now be disabled
- export as M3U or XML
- better handling of text frames containing null characters
- auto-size for the tag editor's "current file" area
- better column widths in the tag editor
- improved HTA for Windows build

* Wed Sep 23 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.05.038
- fixed bug introduced in 0.99.05.037 causing crashes when finding empty ID3V2 frames
- new build process for Windows
- 4th custom transf list now defaults to a "fix-all" approach

* Thu Sep 17 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.05.037
- fixes on right-click
- UTF-8 strings recognized in ID3V2.3.0
- fixed bug 35 (assertion failure)
- faster tracer
- code compilable with VS 2008 (port by Sebastian Schuberth)

* Mon Sep 07 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.05.034
- drive labels shown in Windows
- mp3gain can be started now if it's in a directory containing spaces
- configurable invalid characters and replacement for file renamer
- automatic check for new versions
- text inside square, curly, and angle brackets removed from web queries
- improved tracing code
- no longer rescan the files if exiting tag editor without changes
- replace non-alphanumeric chars with spaces in web queries (issue 2)
- better sorting in the tag editor for albums with unusual track numbers
- a default .ini name is generated in most cases
- (probably) fixed an assert (not sure because couldn't reproduce it)
- tracks without a track number are put at the end in the tag editor
- let the user know about reporting support notes and about patterns
- better detection of exceptions in threads
- exceptions that propagate from slots are now caught
- default "actions to be taken" no longer shown when applying transforms
- file info for StreamWriter

* Wed Sep 02 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.05.033
- fixed crash in Windows when checking a whole drive
- fixed crash when saving data from the tag editor
- improved trace speed on Windows
- fixed potential crash at startup
- fixed crash when changing a file that is being used by other program
- more details and better formatting in assert messages and trace files
- MPEG2 Layer3 streams no longer show Support note
- improved temporary file generation, which can result in faster transforms
- F1 help now works for the first session dialog
- smaller TABs in the "Tag details" area make "Other info" more readable
- better HTML paragraph formatting

* Sun Aug 23 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.05.032
- restructured crash detector
- fixed Windows issue with rectangles being shown instead of letters
- Lyrics partial support
- warning that may corrupt data
- note about how to change selected files
- HTML clean up

* Wed Aug 19 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.05.031
- crash detection
- fixed small memory leak in config dialog
- fixed small memory leak in the tag editor
- content is shown for GEOB frames
- .ID3 files are now loaded in addition to .MP3
- made the counter shown when applying transforms increment on new file(until now it was incremented for each transform)
- "Various artists" no longer set as "artist" when downloading track info from MusicBrainz
- fixed "current cell" in the tag editor (until now, when dragging the mouse to select several cells, the current cell was wrong, leading to setting values incorrectly
- fixed a bug that didn't allow removal of the track number
- slightly improved the normalizer, so a "busy" cursor is shown when the connection to the underlying process is lost (the program seems frozen, but it resumes after about 30 seconds)

* Tue Jul 28 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.05.030
- fixed a bug that caused the tag editor to reserve more space than needed even if the "fast save" option was turned off
- fixed a bug that prevented removal of elements from lists
- fixed a bug in the ID3V2 tag writer that prevented "Discard invalid ID3V2 data" and other transformations to properly work with ID3V2.4.0 tags that contain UTF8-encoded strings, resulting in a broken ID3V2.3.0 tag
- file renamer now accepts patterns with no directory separators, in which case the renamed files are placed in the source directory
- pattern dialogs now show the current line and column
- fixed an assertion in the code that determines the file list
- added tooltips for all the notes in the main file table
- improved speed for "Discard invalid ID3V2 data" when no changes are done
- transformation name included in the dialog that shows which file is currently processed
- broken ID3V2 streams get removed when saving from the tag editor
- the tag editor no longer triggers an assertion failure if non-default settings in the file section of the configuration dialog; (e.g. until now saving from the tag editor while original files weren't deleted resulted in this assertion failure)
- fixed a bug in the "Change case for ID3V2 text frames" that resulted in a program crash if some fields were missing from the ID3V2 tag

* Sun Jul 26 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.05.029
- fast save in the tag editor
- file renamer can work with the list of visible files instead of the current album if the user holds CTRL down when pressing the button
- configurable visible transformations
- new transform for keeping a single image, as front cover
- new transform for removing ID3V1
- button to remove image files
- improved paste in tag editor (it is possible to paste to multiple cells or to paste file names copied from file browsers)
- configurable max image size
- tooltips for the transformations menu
- more checks + fixed error reporting in file renamer
- "sessions" button visible by default for second and later sessions
- directory filter no longer shows some directories that don't make sense
- fixed loading images from current dir
- fixed a bug in tag editor patterns that prevented patterns ending with a static text from working
- fixed some bugs in the directory filter

* Sat Jul 18 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.04.026
- non-ASCII file names can now be seen on Windows
- tag editor now looks at filter
- USLT Lyrics inside ID3V2 are now shown
- better alignment for text in note column header on Ubuntu
- size grip on most dialogs
- F1 help
- files changed in the tag editor no longer show up in the main window if a filter is applied and they don't match the filter

* Fri Jul 10 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.03.022
- 2-letter labels
- gradient grouping of notes
- configurable colors
- app no longer crashes when files are changed by external tools
- tooltips are shown for the column headers in the file table
- more consistent font handling

* Sun Jul 05 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.020
- file renamer now replaces invalid characters in file names
- duration is now shown for audio streams
- fixed assertion caused by files with too many streams
- multiple ID3 stream remover no longer included by default in second list
- some changes to the .spec file in the hope it will work on Mandriva

* Sun Jul 05 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.020
- file renamer now replaces invalid characters in file names
- duration is now shown for audio streams
- fixed assertion caused by files with too many streams
- multiple ID3 stream remover no longer included by default in second list
- some changes to the .spec file in the hope it will work on Mandriva

* Wed Jun 24 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.018
- made -mt suffix default for Boost Serialization

* Wed Jun 24 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.017
- always use multithreaded libraries (single-threaded ones may lead to crashes)
- improved assert dialog; now it has more data, which can be copied and even emailed directly
- the tag editor shows a warning in some cases when a user action would result in discarded images

* Sun Jun 21 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.016
- fixed an assertion failure that was triggered by an unsupported text encoding in APIC
- added support for UTF8 text encoding in APIC
- made the documentation look slightly better on IE6

* Sat Jun 20 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.015
- made compilable on Fedora 11 and added Fedora 11 build
- copying missing ID3V1 fields to ID3V2 no longer part of the default custom transformation list 2

* Thu Jun 18 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.014
- the tag editor loads albums much faster than before; this is most visible when navigating to the next / previous album

* Sun Jun 14 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.012
- added support for UTF8 in ID3V240
- added maximize button to most windows in Windows (but could not get this to work with Gnome)
- removed "What's this" button from most windows
- now the main window shows the session name if more than 1 session was defined
- now the main window shows up maximized in Gnome and Windows if it was maximized when it was closed
- changed documentation links to point to new site, at SourceForge
- minor documentation improvements

* Sat Jun 06 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.011
- added missing dependency for SVG icons
- fixed a bug in "Save as ..."

* Thu Jun 04 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.010
- fixed a bug that could cause removal of audio data
- fixed a bug that prevented single-image-saving from working

* Wed Jun 03 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.009
- Ubuntu binaries
- minor UI tweaks

* Mon May 25 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.008
- improved font handling
- minor UI tweaks

* Tue May 19 2009 Marian Ciobanu <ciobi@inbox.com> 0.99.02.007
- initial version
